/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.ExceptionInfo;
import proguard.classfile.attribute.LineNumberInfo;
import proguard.classfile.attribute.LineNumberTableAttribute;
import proguard.classfile.attribute.LocalVariableInfo;
import proguard.classfile.attribute.LocalVariableTableAttribute;
import proguard.classfile.attribute.LocalVariableTypeInfo;
import proguard.classfile.attribute.LocalVariableTypeTableAttribute;
import proguard.classfile.attribute.annotation.TypeAnnotation;
import proguard.classfile.attribute.annotation.TypeAnnotationsAttribute;
import proguard.classfile.attribute.annotation.target.LocalVariableTargetElement;
import proguard.classfile.attribute.annotation.target.LocalVariableTargetInfo;
import proguard.classfile.attribute.annotation.target.OffsetTargetInfo;
import proguard.classfile.attribute.annotation.target.TargetInfo;
import proguard.classfile.attribute.annotation.target.visitor.LocalVariableTargetElementVisitor;
import proguard.classfile.attribute.annotation.target.visitor.TargetInfoVisitor;
import proguard.classfile.attribute.annotation.visitor.TypeAnnotationVisitor;
import proguard.classfile.attribute.preverification.FullFrame;
import proguard.classfile.attribute.preverification.MoreZeroFrame;
import proguard.classfile.attribute.preverification.SameOneFrame;
import proguard.classfile.attribute.preverification.StackMapAttribute;
import proguard.classfile.attribute.preverification.StackMapFrame;
import proguard.classfile.attribute.preverification.StackMapTableAttribute;
import proguard.classfile.attribute.preverification.UninitializedType;
import proguard.classfile.attribute.preverification.VerificationType;
import proguard.classfile.attribute.preverification.visitor.StackMapFrameVisitor;
import proguard.classfile.attribute.preverification.visitor.VerificationTypeVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.ExceptionInfoVisitor;
import proguard.classfile.attribute.visitor.LineNumberInfoVisitor;
import proguard.classfile.attribute.visitor.LocalVariableInfoVisitor;
import proguard.classfile.attribute.visitor.LocalVariableTypeInfoVisitor;
import proguard.classfile.editor.ExceptionInfoEditor;
import proguard.classfile.editor.InstructionWriter;
import proguard.classfile.editor.StackSizeUpdater;
import proguard.classfile.editor.VariableSizeUpdater;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionFactory;
import proguard.classfile.instruction.LookUpSwitchInstruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.TableSwitchInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.util.ArrayUtil;

public class CodeAttributeEditor
extends SimplifiedVisitor
implements AttributeVisitor,
InstructionVisitor,
ExceptionInfoVisitor,
StackMapFrameVisitor,
VerificationTypeVisitor,
LineNumberInfoVisitor,
LocalVariableInfoVisitor,
LocalVariableTypeInfoVisitor,
TypeAnnotationVisitor,
TargetInfoVisitor,
LocalVariableTargetElementVisitor {
    private static final boolean DEBUG = false;
    private static final int LABEL_FLAG = 0x20000000;
    private final boolean updateFrameSizes;
    private final boolean shrinkInstructions;
    private int codeLength;
    private boolean modified;
    private boolean simple;
    private Map labels = new HashMap();
    public Instruction[] preOffsetInsertions = new Instruction[8096];
    public Instruction[] preInsertions = new Instruction[8096];
    public Instruction[] replacements = new Instruction[8096];
    public Instruction[] postInsertions = new Instruction[8096];
    public boolean[] deleted = new boolean[8096];
    private int[] newInstructionOffsets = new int[8096];
    private int newOffset;
    private boolean lengthIncreased;
    private int expectedStackMapFrameOffset;
    private final StackSizeUpdater stackSizeUpdater = new StackSizeUpdater();
    private final VariableSizeUpdater variableSizeUpdater = new VariableSizeUpdater();
    private final InstructionWriter instructionWriter = new InstructionWriter();

    public CodeAttributeEditor() {
        this(true, true);
    }

    public CodeAttributeEditor(boolean bl, boolean bl2) {
        this.updateFrameSizes = bl;
        this.shrinkInstructions = bl2;
    }

    public void reset(int n) {
        this.labels.clear();
        if (this.preInsertions.length < n) {
            this.preOffsetInsertions = new Instruction[n];
            this.preInsertions = new Instruction[n];
            this.replacements = new Instruction[n];
            this.postInsertions = new Instruction[n];
            this.deleted = new boolean[n];
        } else {
            Arrays.fill(this.preOffsetInsertions, 0, n, null);
            Arrays.fill(this.preInsertions, 0, n, null);
            Arrays.fill(this.replacements, 0, n, null);
            Arrays.fill(this.postInsertions, 0, n, null);
            Arrays.fill(this.deleted, 0, n, false);
        }
        this.codeLength = n;
        this.modified = false;
        this.simple = true;
    }

    public void extend(int n) {
        if (this.preInsertions.length < n) {
            this.preOffsetInsertions = ArrayUtil.extendArray(this.preOffsetInsertions, n);
            this.preInsertions = ArrayUtil.extendArray(this.preInsertions, n);
            this.replacements = ArrayUtil.extendArray(this.replacements, n);
            this.postInsertions = ArrayUtil.extendArray(this.postInsertions, n);
            this.deleted = ArrayUtil.extendArray(this.deleted, n);
        } else {
            Arrays.fill(this.preOffsetInsertions, this.codeLength, n, null);
            Arrays.fill(this.preInsertions, this.codeLength, n, null);
            Arrays.fill(this.replacements, this.codeLength, n, null);
            Arrays.fill(this.postInsertions, this.codeLength, n, null);
            Arrays.fill(this.deleted, this.codeLength, n, false);
        }
        this.codeLength = n;
    }

    public void insertBeforeOffset(int n, Instruction instruction) {
        if (n < 0 || n >= this.codeLength) {
            throw new IllegalArgumentException("Invalid instruction offset [" + n + "] in code with length [" + this.codeLength + "]");
        }
        this.preOffsetInsertions[n] = this.shrinkInstructions ? instruction.shrink() : instruction;
        this.modified = true;
        this.simple = false;
    }

    public void insertBeforeInstruction(int n, Instruction instruction) {
        if (n < 0 || n >= this.codeLength) {
            throw new IllegalArgumentException("Invalid instruction offset [" + n + "] in code with length [" + this.codeLength + "]");
        }
        this.preInsertions[n] = this.shrinkInstructions ? instruction.shrink() : instruction;
        this.modified = true;
        this.simple = false;
    }

    public void insertBeforeOffset(int n, Instruction[] instructionArray) {
        if (n < 0 || n >= this.codeLength) {
            throw new IllegalArgumentException("Invalid instruction offset [" + n + "] in code with length [" + this.codeLength + "]");
        }
        CompositeInstruction compositeInstruction = new CompositeInstruction(instructionArray);
        this.preOffsetInsertions[n] = this.shrinkInstructions ? compositeInstruction.shrink() : compositeInstruction;
        this.modified = true;
        this.simple = false;
    }

    public void insertBeforeInstruction(int n, Instruction[] instructionArray) {
        if (n < 0 || n >= this.codeLength) {
            throw new IllegalArgumentException("Invalid instruction offset [" + n + "] in code with length [" + this.codeLength + "]");
        }
        CompositeInstruction compositeInstruction = new CompositeInstruction(instructionArray);
        this.preInsertions[n] = this.shrinkInstructions ? compositeInstruction.shrink() : compositeInstruction;
        this.modified = true;
        this.simple = false;
    }

    public void replaceInstruction(int n, Instruction instruction) {
        if (n < 0 || n >= this.codeLength) {
            throw new IllegalArgumentException("Invalid instruction offset [" + n + "] in code with length [" + this.codeLength + "]");
        }
        this.replacements[n] = this.shrinkInstructions ? instruction.shrink() : instruction;
        this.modified = true;
    }

    public void replaceInstruction(int n, Instruction[] instructionArray) {
        if (n < 0 || n >= this.codeLength) {
            throw new IllegalArgumentException("Invalid instruction offset [" + n + "] in code with length [" + this.codeLength + "]");
        }
        CompositeInstruction compositeInstruction = new CompositeInstruction(instructionArray);
        this.replacements[n] = this.shrinkInstructions ? compositeInstruction.shrink() : compositeInstruction;
        this.modified = true;
    }

    public void insertAfterInstruction(int n, Instruction instruction) {
        if (n < 0 || n >= this.codeLength) {
            throw new IllegalArgumentException("Invalid instruction offset [" + n + "] in code with length [" + this.codeLength + "]");
        }
        this.postInsertions[n] = this.shrinkInstructions ? instruction.shrink() : instruction;
        this.modified = true;
        this.simple = false;
    }

    public void insertAfterInstruction(int n, Instruction[] instructionArray) {
        if (n < 0 || n >= this.codeLength) {
            throw new IllegalArgumentException("Invalid instruction offset [" + n + "] in code with length [" + this.codeLength + "]");
        }
        CompositeInstruction compositeInstruction = new CompositeInstruction(instructionArray);
        this.postInsertions[n] = this.shrinkInstructions ? compositeInstruction.shrink() : compositeInstruction;
        this.modified = true;
        this.simple = false;
    }

    public void deleteInstruction(int n) {
        if (n < 0 || n >= this.codeLength) {
            throw new IllegalArgumentException("Invalid instruction offset [" + n + "] in code with length [" + this.codeLength + "]");
        }
        this.deleted[n] = true;
        this.modified = true;
        this.simple = false;
    }

    public void undeleteInstruction(int n) {
        if (n < 0 || n >= this.codeLength) {
            throw new IllegalArgumentException("Invalid instruction offset [" + n + "] in code with length [" + this.codeLength + "]");
        }
        this.deleted[n] = false;
    }

    public void clearModifications(int n) {
        if (n < 0 || n >= this.codeLength) {
            throw new IllegalArgumentException("Invalid instruction offset [" + n + "] in code with length [" + this.codeLength + "]");
        }
        this.preOffsetInsertions[n] = null;
        this.preInsertions[n] = null;
        this.replacements[n] = null;
        this.postInsertions[n] = null;
        this.deleted[n] = false;
    }

    public boolean isModified() {
        return this.modified;
    }

    public boolean isModified(int n) {
        return this.preOffsetInsertions[n] != null || this.preInsertions[n] != null || this.replacements[n] != null || this.postInsertions[n] != null || this.deleted[n];
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        try {
            this.visitCodeAttribute0(clazz, method, codeAttribute);
        }
        catch (RuntimeException runtimeException) {
            System.err.println("Unexpected error while editing code:");
            System.err.println("  Class       = [" + clazz.getName() + "]");
            System.err.println("  Method      = [" + method.getName(clazz) + method.getDescriptor(clazz) + "]");
            System.err.println("  Exception   = [" + runtimeException.getClass().getName() + "] (" + runtimeException.getMessage() + ")");
            throw runtimeException;
        }
    }

    public void visitCodeAttribute0(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        if (this.modified) {
            if (this.canPerformSimpleReplacements(codeAttribute)) {
                this.performSimpleReplacements(codeAttribute);
            } else {
                codeAttribute.u4codeLength = this.updateInstructions(clazz, method, codeAttribute);
                codeAttribute.exceptionsAccept(clazz, method, this);
                codeAttribute.u2exceptionTableLength = this.removeEmptyExceptions(codeAttribute.exceptionTable, codeAttribute.u2exceptionTableLength);
                codeAttribute.attributesAccept(clazz, method, this);
            }
            this.instructionWriter.visitCodeAttribute(clazz, method, codeAttribute);
        }
        if (this.updateFrameSizes) {
            this.stackSizeUpdater.visitCodeAttribute(clazz, method, codeAttribute);
            this.variableSizeUpdater.visitCodeAttribute(clazz, method, codeAttribute);
        }
    }

    @Override
    public void visitStackMapAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, StackMapAttribute stackMapAttribute) {
        this.expectedStackMapFrameOffset = -1;
        stackMapAttribute.stackMapFramesAccept(clazz, method, codeAttribute, this);
    }

    @Override
    public void visitStackMapTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, StackMapTableAttribute stackMapTableAttribute) {
        this.expectedStackMapFrameOffset = 0;
        stackMapTableAttribute.stackMapFramesAccept(clazz, method, codeAttribute, this);
    }

    @Override
    public void visitLineNumberTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LineNumberTableAttribute lineNumberTableAttribute) {
        lineNumberTableAttribute.lineNumbersAccept(clazz, method, codeAttribute, this);
    }

    @Override
    public void visitLocalVariableTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTableAttribute localVariableTableAttribute) {
        localVariableTableAttribute.localVariablesAccept(clazz, method, codeAttribute, this);
    }

    @Override
    public void visitLocalVariableTypeTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeTableAttribute localVariableTypeTableAttribute) {
        localVariableTypeTableAttribute.localVariablesAccept(clazz, method, codeAttribute, this);
    }

    @Override
    public void visitAnyTypeAnnotationsAttribute(Clazz clazz, TypeAnnotationsAttribute typeAnnotationsAttribute) {
        typeAnnotationsAttribute.typeAnnotationsAccept(clazz, this);
    }

    private boolean canPerformSimpleReplacements(CodeAttribute codeAttribute) {
        if (!this.simple) {
            return false;
        }
        byte[] byArray = codeAttribute.code;
        int n = codeAttribute.u4codeLength;
        for (int i = 0; i < n; ++i) {
            Instruction instruction = this.replacements[i];
            if (instruction == null || instruction.length(i) == InstructionFactory.create(byArray, i).length(i)) continue;
            return false;
        }
        return true;
    }

    private void performSimpleReplacements(CodeAttribute codeAttribute) {
        int n = codeAttribute.u4codeLength;
        for (int i = 0; i < n; ++i) {
            Instruction instruction = this.replacements[i];
            if (instruction == null) continue;
            instruction.write(codeAttribute, i);
        }
    }

    private int updateInstructions(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        byte[] byArray = codeAttribute.code;
        int n = codeAttribute.u4codeLength;
        if (this.newInstructionOffsets.length < n + 1) {
            this.newInstructionOffsets = new int[n + 1];
        }
        int n2 = this.mapInstructions(byArray, n);
        if (this.lengthIncreased) {
            codeAttribute.code = new byte[n2];
        }
        this.instructionWriter.reset(n2);
        this.moveInstructions(clazz, method, codeAttribute, byArray, n);
        return n2;
    }

    private int mapInstructions(byte[] byArray, int n) {
        this.newOffset = 0;
        this.lengthIncreased = false;
        int n2 = 0;
        do {
            Instruction instruction = InstructionFactory.create(byArray, n2);
            this.mapInstruction(n2, instruction);
            n2 += instruction.length(n2);
            if (this.newOffset <= n2) continue;
            this.lengthIncreased = true;
        } while (n2 < n);
        this.newInstructionOffsets[n2] = this.newOffset;
        return this.newOffset;
    }

    private void mapInstruction(int n, Instruction instruction) {
        Instruction instruction2;
        Instruction instruction3 = this.preOffsetInsertions[n];
        if (instruction3 != null) {
            this.newOffset += instruction3.length(this.newOffset);
        }
        this.newInstructionOffsets[n] = this.newOffset;
        Instruction instruction4 = this.preInsertions[n];
        if (instruction4 != null) {
            this.newOffset += instruction4.length(this.newOffset);
        }
        if ((instruction2 = this.replacements[n]) != null) {
            this.newOffset += instruction2.length(this.newOffset);
        } else if (!this.deleted[n]) {
            this.newOffset += instruction.length(this.newOffset);
        }
        Instruction instruction5 = this.postInsertions[n];
        if (instruction5 != null) {
            this.newOffset += instruction5.length(this.newOffset);
        }
    }

    private void moveInstructions(Clazz clazz, Method method, CodeAttribute codeAttribute, byte[] byArray, int n) {
        Instruction instruction;
        this.newOffset = 0;
        int n2 = 0;
        do {
            instruction = InstructionFactory.create(byArray, n2);
            this.moveInstruction(clazz, method, codeAttribute, n2, instruction);
        } while ((n2 += instruction.length(n2)) < n);
    }

    private void moveInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, Instruction instruction) {
        Instruction instruction2;
        Instruction instruction3;
        Instruction instruction4 = this.preOffsetInsertions[n];
        if (instruction4 != null) {
            instruction4.accept(clazz, method, codeAttribute, n, this);
        }
        if ((instruction3 = this.preInsertions[n]) != null) {
            instruction3.accept(clazz, method, codeAttribute, n, this);
        }
        if ((instruction2 = this.replacements[n]) != null) {
            instruction2.accept(clazz, method, codeAttribute, n, this);
        } else if (!this.deleted[n]) {
            instruction.accept(clazz, method, codeAttribute, n, this);
        }
        Instruction instruction5 = this.postInsertions[n];
        if (instruction5 != null) {
            instruction5.accept(clazz, method, codeAttribute, n, this);
        }
    }

    @Override
    public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, SimpleInstruction simpleInstruction) {
        this.instructionWriter.visitSimpleInstruction(clazz, method, codeAttribute, this.newOffset, simpleInstruction);
        this.newOffset += simpleInstruction.length(this.newOffset);
    }

    @Override
    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, ConstantInstruction constantInstruction) {
        this.instructionWriter.visitConstantInstruction(clazz, method, codeAttribute, this.newOffset, constantInstruction);
        this.newOffset += constantInstruction.length(this.newOffset);
    }

    @Override
    public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, VariableInstruction variableInstruction) {
        this.instructionWriter.visitVariableInstruction(clazz, method, codeAttribute, this.newOffset, variableInstruction);
        this.newOffset += variableInstruction.length(this.newOffset);
    }

    @Override
    public void visitBranchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, BranchInstruction branchInstruction) {
        branchInstruction.branchOffset = this.newBranchOffset(n, branchInstruction.branchOffset, this.newOffset);
        this.instructionWriter.visitBranchInstruction(clazz, method, codeAttribute, this.newOffset, branchInstruction);
        this.newOffset += branchInstruction.length(this.newOffset);
    }

    @Override
    public void visitTableSwitchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, TableSwitchInstruction tableSwitchInstruction) {
        tableSwitchInstruction.defaultOffset = this.newBranchOffset(n, tableSwitchInstruction.defaultOffset, this.newOffset);
        this.newJumpOffsets(n, tableSwitchInstruction.jumpOffsets, this.newOffset);
        this.instructionWriter.visitTableSwitchInstruction(clazz, method, codeAttribute, this.newOffset, tableSwitchInstruction);
        this.newOffset += tableSwitchInstruction.length(this.newOffset);
    }

    @Override
    public void visitLookUpSwitchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, LookUpSwitchInstruction lookUpSwitchInstruction) {
        lookUpSwitchInstruction.defaultOffset = this.newBranchOffset(n, lookUpSwitchInstruction.defaultOffset, this.newOffset);
        this.newJumpOffsets(n, lookUpSwitchInstruction.jumpOffsets, this.newOffset);
        this.instructionWriter.visitLookUpSwitchInstruction(clazz, method, codeAttribute, this.newOffset, lookUpSwitchInstruction);
        this.newOffset += lookUpSwitchInstruction.length(this.newOffset);
    }

    @Override
    public void visitExceptionInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, ExceptionInfo exceptionInfo) {
        exceptionInfo.u2startPC = this.newInstructionOffset(exceptionInfo.u2startPC);
        exceptionInfo.u2endPC = this.newInstructionOffset(exceptionInfo.u2endPC);
        exceptionInfo.u2handlerPC = this.newInstructionOffset(exceptionInfo.u2handlerPC);
    }

    @Override
    public void visitAnyStackMapFrame(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, StackMapFrame stackMapFrame) {
        int n2;
        int n3 = n2 = this.newInstructionOffset(n);
        if (this.expectedStackMapFrameOffset >= 0) {
            n3 -= this.expectedStackMapFrameOffset;
            this.expectedStackMapFrameOffset = n2 + 1;
        }
        stackMapFrame.u2offsetDelta = n3;
    }

    @Override
    public void visitSameOneFrame(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, SameOneFrame sameOneFrame) {
        this.visitAnyStackMapFrame(clazz, method, codeAttribute, n, sameOneFrame);
        sameOneFrame.stackItemAccept(clazz, method, codeAttribute, n, this);
    }

    @Override
    public void visitMoreZeroFrame(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, MoreZeroFrame moreZeroFrame) {
        this.visitAnyStackMapFrame(clazz, method, codeAttribute, n, moreZeroFrame);
        moreZeroFrame.additionalVariablesAccept(clazz, method, codeAttribute, n, this);
    }

    @Override
    public void visitFullFrame(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, FullFrame fullFrame) {
        this.visitAnyStackMapFrame(clazz, method, codeAttribute, n, fullFrame);
        fullFrame.variablesAccept(clazz, method, codeAttribute, n, this);
        fullFrame.stackAccept(clazz, method, codeAttribute, n, this);
    }

    @Override
    public void visitAnyVerificationType(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, VerificationType verificationType) {
    }

    @Override
    public void visitUninitializedType(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, UninitializedType uninitializedType) {
        uninitializedType.u2newInstructionOffset = this.newInstructionOffset(uninitializedType.u2newInstructionOffset);
    }

    @Override
    public void visitLineNumberInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LineNumberInfo lineNumberInfo) {
        lineNumberInfo.u2startPC = this.newInstructionOffset(lineNumberInfo.u2startPC);
    }

    @Override
    public void visitLocalVariableInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableInfo localVariableInfo) {
        localVariableInfo.u2length = this.newBranchOffset(localVariableInfo.u2startPC, localVariableInfo.u2length);
        localVariableInfo.u2startPC = this.newInstructionOffset(localVariableInfo.u2startPC);
    }

    @Override
    public void visitLocalVariableTypeInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeInfo localVariableTypeInfo) {
        localVariableTypeInfo.u2length = this.newBranchOffset(localVariableTypeInfo.u2startPC, localVariableTypeInfo.u2length);
        localVariableTypeInfo.u2startPC = this.newInstructionOffset(localVariableTypeInfo.u2startPC);
    }

    @Override
    public void visitTypeAnnotation(Clazz clazz, TypeAnnotation typeAnnotation) {
        typeAnnotation.targetInfoAccept(clazz, this);
    }

    @Override
    public void visitAnyTargetInfo(Clazz clazz, TypeAnnotation typeAnnotation, TargetInfo targetInfo) {
    }

    @Override
    public void visitLocalVariableTargetInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, TypeAnnotation typeAnnotation, LocalVariableTargetInfo localVariableTargetInfo) {
        localVariableTargetInfo.targetElementsAccept(clazz, method, codeAttribute, typeAnnotation, this);
    }

    @Override
    public void visitOffsetTargetInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, TypeAnnotation typeAnnotation, OffsetTargetInfo offsetTargetInfo) {
        offsetTargetInfo.u2offset = this.newInstructionOffset(offsetTargetInfo.u2offset);
    }

    @Override
    public void visitLocalVariableTargetElement(Clazz clazz, Method method, CodeAttribute codeAttribute, TypeAnnotation typeAnnotation, LocalVariableTargetInfo localVariableTargetInfo, LocalVariableTargetElement localVariableTargetElement) {
        localVariableTargetElement.u2length = this.newBranchOffset(localVariableTargetElement.u2startPC, localVariableTargetElement.u2length);
        localVariableTargetElement.u2startPC = this.newInstructionOffset(localVariableTargetElement.u2startPC);
    }

    private void newJumpOffsets(int n, int[] nArray, int n2) {
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.newBranchOffset(n, nArray[i], n2);
        }
    }

    private int newBranchOffset(int n, int n2) {
        return this.newInstructionOffset(n + n2) - this.newInstructionOffset(n);
    }

    private int newBranchOffset(int n, int n2, int n3) {
        int n4 = CodeAttributeEditor.isLabel(n2) ? n2 : n + n2;
        return this.newInstructionOffset(n4) - n3;
    }

    private int newInstructionOffset(int n) {
        if (CodeAttributeEditor.isLabel(n)) {
            int n2 = CodeAttributeEditor.labelIdentifier(n);
            Label label = (Label)this.labels.get(n2);
            if (label == null) {
                throw new IllegalArgumentException("Reference to unknown label identifier [" + n2 + "]");
            }
            return label.newOffset;
        }
        if (n < 0 || n > this.codeLength) {
            throw new IllegalArgumentException("Invalid instruction offset [" + n + "] in code with length [" + this.codeLength + "]");
        }
        return this.newInstructionOffsets[n];
    }

    private int removeEmptyExceptions(ExceptionInfo[] exceptionInfoArray, int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            ExceptionInfo exceptionInfo = exceptionInfoArray[i];
            if (exceptionInfo.u2startPC >= exceptionInfo.u2endPC) continue;
            exceptionInfoArray[n2++] = exceptionInfo;
        }
        return n2;
    }

    private int removeEmptyLineNumbers(LineNumberInfo[] lineNumberInfoArray, int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            LineNumberInfo lineNumberInfo = lineNumberInfoArray[i];
            int n4 = lineNumberInfo.u2startPC;
            if (n4 >= n2 || i != 0 && n4 <= lineNumberInfoArray[i - 1].u2startPC) continue;
            lineNumberInfoArray[n3++] = lineNumberInfo;
        }
        return n3;
    }

    public Label label() {
        return this.label(this.labels.size());
    }

    public Label label(int n) {
        Label label = new Label(n);
        this.labels.put(new Integer(n), label);
        return label;
    }

    public Label catch_(int n, int n2, int n3) {
        return this.catch_(this.labels.size(), n, n2, n3);
    }

    public Label catch_(int n, int n2, int n3, int n4) {
        Catch catch_ = new Catch(n, n2, n3, n4);
        this.labels.put(new Integer(n), catch_);
        return catch_;
    }

    private static boolean isLabel(int n) {
        return (n & 0xFF000000) == 0x20000000;
    }

    private static int labelIdentifier(int n) {
        return n & 0xDFFFFFFF;
    }

    private static class Catch
    extends Label {
        private final int startOfffset;
        private final int endOffset;
        private final int catchType;

        public Catch(int n, int n2, int n3, int n4) {
            super(n);
            this.startOfffset = n2;
            this.endOffset = n3;
            this.catchType = n4;
        }

        @Override
        public Instruction shrink() {
            return this;
        }

        @Override
        public void write(byte[] byArray, int n) {
        }

        @Override
        protected void readInfo(byte[] byArray, int n) {
            throw new UnsupportedOperationException("Can't read catch instruction");
        }

        @Override
        protected void writeInfo(byte[] byArray, int n) {
            throw new UnsupportedOperationException("Can't write catch instruction");
        }

        @Override
        public int length(int n) {
            return super.length(n);
        }

        @Override
        public void accept(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, InstructionVisitor instructionVisitor) {
            if (instructionVisitor.getClass() != CodeAttributeEditor.class) {
                throw new UnsupportedOperationException("Unexpected visitor [" + instructionVisitor + "]");
            }
            new ExceptionInfoEditor(codeAttribute).prependException(new ExceptionInfo(this.startOfffset, this.endOffset, this.offset(), this.catchType));
        }

        @Override
        public String toString() {
            return "catch " + (CodeAttributeEditor.isLabel(this.startOfffset) ? "label_" : "") + this.startOfffset + ", " + (CodeAttributeEditor.isLabel(this.endOffset) ? "label_" : "") + this.endOffset + ", #" + this.catchType;
        }
    }

    private static class Label
    extends Instruction {
        protected final int identifier;
        private int newOffset;

        public Label(int n) {
            this.identifier = n;
        }

        public int offset() {
            return 0x20000000 | this.identifier;
        }

        @Override
        public Instruction shrink() {
            return this;
        }

        @Override
        public void write(byte[] byArray, int n) {
        }

        @Override
        protected void readInfo(byte[] byArray, int n) {
            throw new UnsupportedOperationException("Can't read label instruction");
        }

        @Override
        protected void writeInfo(byte[] byArray, int n) {
            throw new UnsupportedOperationException("Can't write label instruction");
        }

        @Override
        public int length(int n) {
            this.newOffset = n;
            return 0;
        }

        @Override
        public void accept(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, InstructionVisitor instructionVisitor) {
            if (instructionVisitor.getClass() != CodeAttributeEditor.class) {
                throw new UnsupportedOperationException("Unexpected visitor [" + instructionVisitor + "]");
            }
        }

        public String toString() {
            return "label_" + this.offset();
        }
    }

    private class CompositeInstruction
    extends Instruction {
        private Instruction[] instructions;

        private CompositeInstruction(Instruction[] instructionArray) {
            this.instructions = instructionArray;
        }

        @Override
        public Instruction shrink() {
            for (int i = 0; i < this.instructions.length; ++i) {
                this.instructions[i] = this.instructions[i].shrink();
            }
            return this;
        }

        @Override
        public void write(byte[] byArray, int n) {
            for (int i = 0; i < this.instructions.length; ++i) {
                Instruction instruction = this.instructions[i];
                instruction.write(byArray, n);
                n += instruction.length(n);
            }
        }

        @Override
        protected void readInfo(byte[] byArray, int n) {
            throw new UnsupportedOperationException("Can't read composite instruction");
        }

        @Override
        protected void writeInfo(byte[] byArray, int n) {
            throw new UnsupportedOperationException("Can't write composite instruction");
        }

        @Override
        public int length(int n) {
            int n2 = n;
            for (int i = 0; i < this.instructions.length; ++i) {
                n2 += this.instructions[i].length(n2);
            }
            return n2 - n;
        }

        @Override
        public void accept(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, InstructionVisitor instructionVisitor) {
            if (instructionVisitor != CodeAttributeEditor.this) {
                throw new UnsupportedOperationException("Unexpected visitor [" + instructionVisitor + "]");
            }
            for (int i = 0; i < this.instructions.length; ++i) {
                Instruction instruction = this.instructions[i];
                instruction.accept(clazz, method, codeAttribute, n, CodeAttributeEditor.this);
            }
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.instructions.length; ++i) {
                stringBuffer.append(this.instructions[i].toString()).append("; ");
            }
            return stringBuffer.toString();
        }
    }
}

