/*
 * Decompiled with CFR 0.152.
 */
package proguard.io;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import proguard.io.DataEntry;
import proguard.io.DataEntryWriter;

public class DirectoryWriter
implements DataEntryWriter {
    private final File baseFile;
    private final boolean isFile;

    public DirectoryWriter(File file, boolean bl) {
        this.baseFile = file;
        this.isFile = bl;
    }

    @Override
    public boolean createDirectory(DataEntry dataEntry) throws IOException {
        File file = this.getFile(dataEntry);
        if (!file.exists() && !file.mkdirs()) {
            throw new IOException("Can't create directory [" + file.getPath() + "]");
        }
        return true;
    }

    @Override
    public boolean sameOutputStream(DataEntry dataEntry, DataEntry dataEntry2) throws IOException {
        return this.getFile(dataEntry).equals(this.getFile(dataEntry2));
    }

    @Override
    public OutputStream createOutputStream(DataEntry dataEntry) throws IOException {
        File file = this.getFile(dataEntry);
        File file2 = file.getParentFile();
        if (file2 != null && !file2.exists() && !file2.mkdirs()) {
            throw new IOException("Can't create directory [" + file2.getPath() + "]");
        }
        return new BufferedOutputStream(new FileOutputStream(file));
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void println(PrintWriter printWriter, String string) {
        printWriter.println(string + "DirectoryWriter (base " + (this.isFile ? "file " : "directory") + " [" + this.baseFile + "])");
    }

    private File getFile(DataEntry dataEntry) {
        return this.isFile ? this.baseFile : new File(this.baseFile, dataEntry.getName().replace('/', File.separatorChar));
    }
}

