/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize;

import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.ProgramClass;
import proguard.classfile.visitor.ClassVisitor;
import proguard.optimize.KeepMarker;

public class KeptClassFilter
implements ClassVisitor {
    private final ClassVisitor acceptedVisitor;
    private final ClassVisitor rejectedVisitor;

    public KeptClassFilter(ClassVisitor classVisitor) {
        this(classVisitor, null);
    }

    public KeptClassFilter(ClassVisitor classVisitor, ClassVisitor classVisitor2) {
        this.acceptedVisitor = classVisitor;
        this.rejectedVisitor = classVisitor2;
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        ClassVisitor classVisitor = this.selectVisitor(programClass);
        if (classVisitor != null) {
            classVisitor.visitProgramClass(programClass);
        }
    }

    @Override
    public void visitLibraryClass(LibraryClass libraryClass) {
        ClassVisitor classVisitor = this.selectVisitor(libraryClass);
        if (classVisitor != null) {
            classVisitor.visitLibraryClass(libraryClass);
        }
    }

    private ClassVisitor selectVisitor(Clazz clazz) {
        return KeepMarker.isKept(clazz) ? this.acceptedVisitor : this.rejectedVisitor;
    }
}

