/*
 * Decompiled with CFR 0.152.
 */
package proguard.util;

import java.lang.reflect.Array;
import java.util.Arrays;
import proguard.util.ObjectUtil;

public class ArrayUtil {
    public static boolean equal(boolean[] blArray, boolean[] blArray2, int n) {
        for (int i = 0; i < n; ++i) {
            if (blArray[i] == blArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equal(byte[] byArray, byte[] byArray2, int n) {
        for (int i = 0; i < n; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equal(char[] cArray, char[] cArray2, int n) {
        for (int i = 0; i < n; ++i) {
            if (cArray[i] == cArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equal(short[] sArray, short[] sArray2, int n) {
        for (int i = 0; i < n; ++i) {
            if (sArray[i] == sArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equal(int[] nArray, int[] nArray2, int n) {
        for (int i = 0; i < n; ++i) {
            if (nArray[i] == nArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equal(long[] lArray, long[] lArray2, int n) {
        for (int i = 0; i < n; ++i) {
            if (lArray[i] == lArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equal(float[] fArray, float[] fArray2, int n) {
        for (int i = 0; i < n; ++i) {
            if (fArray[i] == fArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equal(double[] dArray, double[] dArray2, int n) {
        for (int i = 0; i < n; ++i) {
            if (dArray[i] == dArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equal(Object[] objectArray, Object[] objectArray2, int n) {
        for (int i = 0; i < n; ++i) {
            if (objectArray[i].equals(objectArray2[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean equalOrNull(Object[] objectArray, Object[] objectArray2) {
        return objectArray == null ? objectArray2 == null : ArrayUtil.equalOrNull(objectArray, objectArray2, objectArray.length);
    }

    public static boolean equalOrNull(Object[] objectArray, Object[] objectArray2, int n) {
        return objectArray == null ? objectArray2 == null : objectArray2 != null && ArrayUtil.equal(objectArray, objectArray2, n);
    }

    public static int hashCode(boolean[] blArray, int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 = n2 << 1 | n2 >>> 31;
            if (!blArray[i]) continue;
            n2 ^= 1;
        }
        return n2;
    }

    public static int hashCode(byte[] byArray, int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 = n2 << 1 | n2 >>> 31;
            n2 ^= byArray[i] & 0xFF;
        }
        return n2;
    }

    public static int hashCode(char[] cArray, int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 = n2 << 1 | n2 >>> 31;
            n2 ^= cArray[i];
        }
        return n2;
    }

    public static int hashCode(short[] sArray, int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 = n2 << 1 | n2 >>> 31;
            n2 ^= sArray[i] & 0xFFFF;
        }
        return n2;
    }

    public static int hashCode(int[] nArray, int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 = n2 << 1 | n2 >>> 31;
            n2 ^= nArray[i];
        }
        return n2;
    }

    public static int hashCode(long[] lArray, int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 = n2 << 1 | n2 >>> 31;
            long l = lArray[i];
            n2 = (int)((long)n2 ^ (l | l >>> 32));
        }
        return n2;
    }

    public static int hashCode(float[] fArray, int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 = n2 << 1 | n2 >>> 31;
            n2 ^= Float.floatToRawIntBits(fArray[i]);
        }
        return n2;
    }

    public static int hashCode(double[] dArray, int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 = n2 << 1 | n2 >>> 31;
            long l = Double.doubleToRawLongBits(dArray[i]);
            n2 = (int)((long)n2 ^ (l | l >>> 32));
        }
        return n2;
    }

    public static int hashCode(Object[] objectArray, int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 = n2 << 1 | n2 >>> 31;
            n2 ^= objectArray[i].hashCode();
        }
        return n2;
    }

    public static int hashCodeOrNull(Object[] objectArray) {
        return objectArray == null ? 0 : ArrayUtil.hashCode(objectArray, objectArray.length);
    }

    public static int hashCodeOrNull(Object[] objectArray, int n) {
        return objectArray == null ? 0 : ArrayUtil.hashCode(objectArray, n);
    }

    public static int compare(boolean[] blArray, int n, boolean[] blArray2, int n2) {
        int n3 = Math.min(n, n2);
        for (int i = 0; i < n3; ++i) {
            if (!blArray[i] && blArray2[i]) {
                return -1;
            }
            if (!blArray[i] || blArray2[i]) continue;
            return 1;
        }
        return n < n2 ? -1 : (n == n2 ? 0 : 1);
    }

    public static int compare(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = Math.min(n, n2);
        for (int i = 0; i < n3; ++i) {
            if (byArray[i] < byArray2[i]) {
                return -1;
            }
            if (byArray[i] <= byArray2[i]) continue;
            return 1;
        }
        return n < n2 ? -1 : (n == n2 ? 0 : 1);
    }

    public static int compare(char[] cArray, int n, char[] cArray2, int n2) {
        int n3 = Math.min(n, n2);
        for (int i = 0; i < n3; ++i) {
            if (cArray[i] < cArray2[i]) {
                return -1;
            }
            if (cArray[i] <= cArray2[i]) continue;
            return 1;
        }
        return n < n2 ? -1 : (n == n2 ? 0 : 1);
    }

    public static int compare(short[] sArray, int n, short[] sArray2, int n2) {
        int n3 = Math.min(n, n2);
        for (int i = 0; i < n3; ++i) {
            if (sArray[i] < sArray2[i]) {
                return -1;
            }
            if (sArray[i] <= sArray2[i]) continue;
            return 1;
        }
        return n < n2 ? -1 : (n == n2 ? 0 : 1);
    }

    public static int compare(int[] nArray, int n, int[] nArray2, int n2) {
        int n3 = Math.min(n, n2);
        for (int i = 0; i < n3; ++i) {
            if (nArray[i] < nArray2[i]) {
                return -1;
            }
            if (nArray[i] <= nArray2[i]) continue;
            return 1;
        }
        return n < n2 ? -1 : (n == n2 ? 0 : 1);
    }

    public static int compare(long[] lArray, int n, long[] lArray2, int n2) {
        int n3 = Math.min(n, n2);
        for (int i = 0; i < n3; ++i) {
            if (lArray[i] < lArray2[i]) {
                return -1;
            }
            if (lArray[i] <= lArray2[i]) continue;
            return 1;
        }
        return n < n2 ? -1 : (n == n2 ? 0 : 1);
    }

    public static int compare(float[] fArray, int n, float[] fArray2, int n2) {
        int n3 = Math.min(n, n2);
        for (int i = 0; i < n3; ++i) {
            if (fArray[i] < fArray2[i]) {
                return -1;
            }
            if (!(fArray[i] > fArray2[i])) continue;
            return 1;
        }
        return n < n2 ? -1 : (n == n2 ? 0 : 1);
    }

    public static int compare(double[] dArray, int n, double[] dArray2, int n2) {
        int n3 = Math.min(n, n2);
        for (int i = 0; i < n3; ++i) {
            if (dArray[i] < dArray2[i]) {
                return -1;
            }
            if (!(dArray[i] > dArray2[i])) continue;
            return 1;
        }
        return n < n2 ? -1 : (n == n2 ? 0 : 1);
    }

    public static int compare(Comparable[] comparableArray, int n, Comparable[] comparableArray2, int n2) {
        int n3 = Math.min(n, n2);
        for (int i = 0; i < n3; ++i) {
            int n4 = ObjectUtil.compare(comparableArray[i], comparableArray2[i]);
            if (n4 == 0) continue;
            return n4;
        }
        return n < n2 ? -1 : (n == n2 ? 0 : 1);
    }

    public static <T> T[] cloneOrNull(T[] TArray) {
        return TArray != null ? (Object[])TArray.clone() : null;
    }

    public static boolean[] extendArray(boolean[] blArray, int n) {
        if (blArray.length >= n) {
            return blArray;
        }
        boolean[] blArray2 = new boolean[n];
        System.arraycopy(blArray, 0, blArray2, 0, blArray.length);
        return blArray2;
    }

    public static boolean[] ensureArraySize(boolean[] blArray, int n, boolean bl) {
        if (blArray.length >= n) {
            Arrays.fill(blArray, 0, n, bl);
        } else {
            blArray = new boolean[n];
            if (bl) {
                Arrays.fill(blArray, 0, n, bl);
            }
        }
        return blArray;
    }

    public static byte[] add(byte[] byArray, int n, byte by) {
        byArray = ArrayUtil.extendArray(byArray, n + 1);
        byArray[n] = by;
        return byArray;
    }

    public static byte[] insert(byte[] byArray, int n, int n2, byte by) {
        byArray = ArrayUtil.extendArray(byArray, n + 1);
        System.arraycopy(byArray, n2, byArray, n2 + 1, n - n2);
        byArray[n2] = by;
        return byArray;
    }

    public static void remove(byte[] byArray, int n, int n2) {
        System.arraycopy(byArray, n2 + 1, byArray, n2, byArray.length - n2 - 1);
        byArray[n - 1] = 0;
    }

    public static byte[] extendArray(byte[] byArray, int n) {
        if (byArray.length >= n) {
            return byArray;
        }
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        return byArray2;
    }

    public static byte[] ensureArraySize(byte[] byArray, int n, byte by) {
        if (byArray.length >= n) {
            Arrays.fill(byArray, 0, n, by);
        } else {
            byArray = new byte[n];
            if (by != 0) {
                Arrays.fill(byArray, 0, n, by);
            }
        }
        return byArray;
    }

    public static char[] add(char[] cArray, int n, char c) {
        cArray = ArrayUtil.extendArray(cArray, n + 1);
        cArray[n] = c;
        return cArray;
    }

    public static char[] insert(char[] cArray, int n, int n2, char c) {
        cArray = ArrayUtil.extendArray(cArray, n + 1);
        System.arraycopy(cArray, n2, cArray, n2 + 1, n - n2);
        cArray[n2] = c;
        return cArray;
    }

    public static void remove(char[] cArray, int n, int n2) {
        System.arraycopy(cArray, n2 + 1, cArray, n2, cArray.length - n2 - 1);
        cArray[n - 1] = '\u0000';
    }

    public static char[] extendArray(char[] cArray, int n) {
        if (cArray.length >= n) {
            return cArray;
        }
        char[] cArray2 = new char[n];
        System.arraycopy(cArray, 0, cArray2, 0, cArray.length);
        return cArray2;
    }

    public static char[] ensureArraySize(char[] cArray, int n, char c) {
        if (cArray.length >= n) {
            Arrays.fill(cArray, 0, n, c);
        } else {
            cArray = new char[n];
            if (c != '\u0000') {
                Arrays.fill(cArray, 0, n, c);
            }
        }
        return cArray;
    }

    public static short[] add(short[] sArray, int n, short s) {
        sArray = ArrayUtil.extendArray(sArray, n + 1);
        sArray[n] = s;
        return sArray;
    }

    public static short[] insert(short[] sArray, int n, int n2, short s) {
        sArray = ArrayUtil.extendArray(sArray, n + 1);
        System.arraycopy(sArray, n2, sArray, n2 + 1, n - n2);
        sArray[n2] = s;
        return sArray;
    }

    public static void remove(short[] sArray, int n, int n2) {
        System.arraycopy(sArray, n2 + 1, sArray, n2, sArray.length - n2 - 1);
        sArray[n - 1] = 0;
    }

    public static short[] extendArray(short[] sArray, int n) {
        if (sArray.length >= n) {
            return sArray;
        }
        short[] sArray2 = new short[n];
        System.arraycopy(sArray, 0, sArray2, 0, sArray.length);
        return sArray2;
    }

    public static short[] ensureArraySize(short[] sArray, int n, short s) {
        if (sArray.length >= n) {
            Arrays.fill(sArray, 0, n, s);
        } else {
            sArray = new short[n];
            if (s != 0) {
                Arrays.fill(sArray, 0, n, s);
            }
        }
        return sArray;
    }

    public static int[] add(int[] nArray, int n, int n2) {
        nArray = ArrayUtil.extendArray(nArray, n + 1);
        nArray[n] = n2;
        return nArray;
    }

    public static int[] insert(int[] nArray, int n, int n2, int n3) {
        nArray = ArrayUtil.extendArray(nArray, n + 1);
        System.arraycopy(nArray, n2, nArray, n2 + 1, n - n2);
        nArray[n2] = n3;
        return nArray;
    }

    public static void remove(int[] nArray, int n, int n2) {
        System.arraycopy(nArray, n2 + 1, nArray, n2, nArray.length - n2 - 1);
        nArray[n - 1] = 0;
    }

    public static int[] extendArray(int[] nArray, int n) {
        if (nArray.length >= n) {
            return nArray;
        }
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        return nArray2;
    }

    public static int[] ensureArraySize(int[] nArray, int n, int n2) {
        if (nArray.length >= n) {
            Arrays.fill(nArray, 0, n, n2);
        } else {
            nArray = new int[n];
            if (n2 != 0) {
                Arrays.fill(nArray, 0, n, n2);
            }
        }
        return nArray;
    }

    public static long[] add(long[] lArray, int n, long l) {
        lArray = ArrayUtil.extendArray(lArray, n + 1);
        lArray[n] = l;
        return lArray;
    }

    public static long[] insert(long[] lArray, int n, int n2, long l) {
        lArray = ArrayUtil.extendArray(lArray, n + 1);
        System.arraycopy(lArray, n2, lArray, n2 + 1, n - n2);
        lArray[n2] = l;
        return lArray;
    }

    public static void remove(long[] lArray, int n, int n2) {
        System.arraycopy(lArray, n2 + 1, lArray, n2, lArray.length - n2 - 1);
        lArray[n - 1] = 0L;
    }

    public static long[] extendArray(long[] lArray, int n) {
        if (lArray.length >= n) {
            return lArray;
        }
        long[] lArray2 = new long[n];
        System.arraycopy(lArray, 0, lArray2, 0, lArray.length);
        return lArray2;
    }

    public static long[] ensureArraySize(long[] lArray, int n, long l) {
        if (lArray.length >= n) {
            Arrays.fill(lArray, 0, n, l);
        } else {
            lArray = new long[n];
            if (l != 0L) {
                Arrays.fill(lArray, 0, n, l);
            }
        }
        return lArray;
    }

    public static float[] add(float[] fArray, int n, float f) {
        fArray = ArrayUtil.extendArray(fArray, n + 1);
        fArray[n] = f;
        return fArray;
    }

    public static float[] insert(float[] fArray, int n, int n2, float f) {
        fArray = ArrayUtil.extendArray(fArray, n + 1);
        System.arraycopy(fArray, n2, fArray, n2 + 1, n - n2);
        fArray[n2] = f;
        return fArray;
    }

    public static void remove(float[] fArray, int n, int n2) {
        System.arraycopy(fArray, n2 + 1, fArray, n2, fArray.length - n2 - 1);
        fArray[n - 1] = 0.0f;
    }

    public static float[] extendArray(float[] fArray, int n) {
        if (fArray.length >= n) {
            return fArray;
        }
        float[] fArray2 = new float[n];
        System.arraycopy(fArray, 0, fArray2, 0, fArray.length);
        return fArray2;
    }

    public static float[] ensureArraySize(float[] fArray, int n, float f) {
        if (fArray.length >= n) {
            Arrays.fill(fArray, 0, n, f);
        } else {
            fArray = new float[n];
            if (f != 0.0f) {
                Arrays.fill(fArray, 0, n, f);
            }
        }
        return fArray;
    }

    public static double[] add(double[] dArray, int n, double d) {
        dArray = ArrayUtil.extendArray(dArray, n + 1);
        dArray[n] = d;
        return dArray;
    }

    public static double[] insert(double[] dArray, int n, int n2, double d) {
        dArray = ArrayUtil.extendArray(dArray, n + 1);
        System.arraycopy(dArray, n2, dArray, n2 + 1, n - n2);
        dArray[n2] = d;
        return dArray;
    }

    public static void remove(double[] dArray, int n, int n2) {
        System.arraycopy(dArray, n2 + 1, dArray, n2, dArray.length - n2 - 1);
        dArray[n - 1] = 0.0;
    }

    public static double[] extendArray(double[] dArray, int n) {
        if (dArray.length >= n) {
            return dArray;
        }
        double[] dArray2 = new double[n];
        System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
        return dArray2;
    }

    public static double[] ensureArraySize(double[] dArray, int n, double d) {
        if (dArray.length >= n) {
            Arrays.fill(dArray, 0, n, d);
        } else {
            dArray = new double[n];
            if (d != 0.0) {
                Arrays.fill(dArray, 0, n, d);
            }
        }
        return dArray;
    }

    public static <T> T[] add(T[] TArray, int n, T t) {
        TArray = ArrayUtil.extendArray(TArray, n + 1);
        TArray[n] = t;
        return TArray;
    }

    public static <T> T[] insert(T[] TArray, int n, int n2, T t) {
        TArray = ArrayUtil.extendArray(TArray, n + 1);
        System.arraycopy(TArray, n2, TArray, n2 + 1, n - n2);
        TArray[n2] = t;
        return TArray;
    }

    public static void remove(Object[] objectArray, int n, int n2) {
        System.arraycopy(objectArray, n2 + 1, objectArray, n2, objectArray.length - n2 - 1);
        objectArray[n - 1] = null;
    }

    public static <T> T[] extendArray(T[] TArray, int n) {
        if (TArray.length >= n) {
            return TArray;
        }
        Object[] objectArray = (Object[])Array.newInstance(TArray.getClass().getComponentType(), n);
        System.arraycopy(TArray, 0, objectArray, 0, TArray.length);
        return objectArray;
    }

    public static <T> T[] ensureArraySize(T[] objectArray, int n, T t) {
        if (objectArray.length >= n) {
            Arrays.fill(objectArray, 0, n, t);
        } else {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n);
            if (t != null) {
                Arrays.fill(objectArray, 0, n, t);
            }
        }
        return objectArray;
    }
}

