/* File: defines.h */

/* Purpose: global constants and macro definitions */


/*
 * Do not edit this file unless you know *exactly* what you are doing.
 *
 * Some of the values in this file were chosen to preserve game balance,
 * while others are hard-coded based on the format of old save-files, the
 * definition of arrays in various places, mathematical properties, fast
 * computation, storage limits, or the format of external text files.
 *
 * Changing some of these values will induce crashes or memory errors or
 * savefile mis-reads.  Most of the comments in this file are meant as
 * reminders, not complete descriptions, and even a complete knowledge
 * of the source may not be sufficient to fully understand the effects
 * of changing certain definitions.
 *
 * Lastly, note that the code does not always use the symbolic constants
 * below, and sometimes uses various hard-coded values that may not even
 * be defined in this file, but which may be related to definitions here.
 * This is of course bad programming practice, but nobody is perfect...
 *
 * You have been warned.
 */


/*
 * Name of the version/variant
 */
#define VERSION_NAME "ZAngband"

/* Savefile version */
#define SAVEFILE_VERSION 52

/* User-visible version */
#define VER_MAJOR 2
#define VER_MINOR 7
#define VER_PATCH 5
#define VER_EXTRA 0

/* Versions after release */
#define VER_AFTER "pre1"

/* Stringify argument */
#define Z_STR(a) Z_STR1(a)

#define Z_STR1(a)\
	# a

/* Pre-release version string */
#if VER_EXTRA != 0
	#define PRE_VERSION \
		"pre" Z_STR(VER_EXTRA)
#else
	#define PRE_VERSION
#endif /* VER_EXTRA != 0 */


/*
 * Current version string
 */
#define VERSION_STRING \
	Z_STR(VER_MAJOR) "." Z_STR(VER_MINOR) "." Z_STR(VER_PATCH) PRE_VERSION VER_AFTER

#define ANGBAND_2_8_1
#define ZANGBAND
#define ZANGBAND_BIGSCREEN
#define ZANGBAND_WILDERNESS
/* hack - define if the source contains the cleanup_angband() function. */
#define HAS_CLEANUP


/* Debug modes depend on version */

/* Dev version? */
#if ((VER_MINOR == 1) || (VER_MINOR == 3) || (VER_MINOR == 5) || \
    (VER_MINOR == 7) || (VER_MINOR == 9))

#define DEBUG
#endif /* Dev version */

/* Alpha testing */
#if (VER_EXTRA != 0)
#define DEBUG_ALPHA

#ifndef DEBUG
#define DEBUG
#endif /*  !DEBUG */

#endif /* Pre version */

/* Turn off assert if not debugging */
#ifndef DEBUG
#undef assert
#define assert(ignore)	((void) 0)
#endif /* !DEBUG */


/*
 * The maximum number of players we support
 */
#define MAX_PLAYERS		1

/*
 * Maximum amount of Angband windows.
 */
#define ANGBAND_TERM_MAX 8

/*
 * Maximum of different windows
 */
#define WINDOW_CHOICE_MAX	15

/*
 * Number of grids in each block (vertically)
 */
#define BLOCK_HGT	11

/*
 * Number of grids in each block (horizontally)
 */
#define BLOCK_WID	11

/*
 * Maximum dungeon height in grids.
 */
#define MAX_HGT         66

/*
 * Maximum dungeon width in grids.
 */
#define MAX_WID         198


/*
 * Script triggers
 */
#define MAX_TRIGGER     10

#define TRIGGER_USE     0
#define TRIGGER_MAKE    1
#define TRIGGER_BONUS   2
#define TRIGGER_SMASH   3
#define TRIGGER_DESC	4
#define TRIGGER_TIMED   5
#define TRIGGER_HIT     6
#define TRIGGER_ATTACK  7
#define TRIGGER_ALTER   8
#define TRIGGER_SPOIL   9


/*
 * Defines used by the wilderness data structures
 */

/* Size of wilderness in blocks */
#define WILD_SIZE		129

/* Size of blocks - hard coded. (Affects size of towns) */
#define WILD_BLOCK_SIZE	16

/* Number of blocks the player can see at one time */
#define WILD_VIEW		9

/* Number of blocks of wilderness cache */
#define WILD_CACHE		(MAX_PLAYERS * WILD_VIEW * WILD_VIEW * 2)


/* Hack XXX  Start of the sea types = 2^16 - 65*/
#define WILD_SEA	65471

/* Town types */
#define TOWN_OLD		1
#define TOWN_FRACT		2
#define TOWN_QUEST		3
#define TOWN_DUNGEON    4

/*
 * Quest type
 */
#define QUEST_TYPE_NONE				0
#define QUEST_TYPE_BOUNTY			1
#define QUEST_TYPE_DUNGEON			2
#define QUEST_TYPE_WILD				3
#define QUEST_TYPE_MESSAGE			4
#define QUEST_TYPE_FIND_ITEM		5
#define QUEST_TYPE_FIND_PLACE		6



/*
 * Quest creation types
 */
#define QC_NONE					0
#define QC_DUN_MONST			1
#define QC_DUN_ARTIFACT			2


/*
 * Quest action triggers
 */
#define QX_NONE					0
#define QX_KILL_MONST			1
#define QX_KILL_UNIQUE			2
#define QX_KILL_WINNER			3
#define QX_WILD_ENTER			4
#define QX_KNOW_ARTIFACT		5
#define QX_FIND_SHOP			6

/*
 * Mega Hack XXX XXX Info for winner quest
 */
#define QW_OBERON				860
#define QW_SERPENT				862


/* Number of gates in the city */
#define MAX_GATES				4

/* Maximum length of town name + '/0' */
#define T_NAME_LEN	18


/*
 * Total number of stores in vanilla town (see "store.c", etc)
 */
#define MAX_STORES      9


/*
 * Total number of stores with stock (see "store.c", etc)
 */
#define STORE_CACHE_AMNT 100


/*
 * Total number of owners per store (see "store.c", etc)
 */
#define MAX_OWNERS			32


/*
 * Total number of buildings (see "bldg.c", etc)
 */
#define MAX_BLDG			10

/* List of building types */
#define	BUILD_STORE_GENERAL		0
#define BUILD_STORE_ARMOURY		1
#define BUILD_STORE_WEAPON		2
#define BUILD_STORE_TEMPLE		3
#define BUILD_STORE_ALCHEMIST	4
#define BUILD_STORE_MAGIC		5
#define BUILD_STORE_BLACK		6
#define BUILD_STORE_HOME		7
#define BUILD_STORE_BOOK		8
#define BUILD_STAIRS			9
#define BUILD_WEAPONMASTER		10
#define BUILD_RECHARGE			11
#define BUILD_PLUS_WEAPON		12
#define BUILD_PLUS_ARMOUR		13
#define BUILD_MUTATE			14
#define BUILD_NONE				15
#define BUILD_BLANK				16
#define BUILD_MAP				17
#define BUILD_WEAPON1			18
#define BUILD_WEAPON2			19
#define BUILD_WEAPON3			20
#define BUILD_WEAPON4			21
#define BUILD_WEAPON5			22
#define BUILD_ARMOUR1			23
#define BUILD_ARMOUR2			24
#define BUILD_ARMOUR3			25
#define BUILD_ARMOUR4			26
#define BUILD_ARMOUR5			27
#define BUILD_SWORD0			28
#define BUILD_SWORD1			29
#define BUILD_SWORD2			30
#define BUILD_SWORD3			31
#define BUILD_SWORD4			32
#define BUILD_SWORD5			33
#define BUILD_SHIELD0			34
#define BUILD_SHIELD1			35
#define BUILD_SHIELD2			36
#define BUILD_SHIELD3			37
#define BUILD_SHIELD4			38
#define BUILD_SHIELD5			39
#define BUILD_AXE0				40
#define BUILD_AXE1				41
#define BUILD_AXE2				42
#define BUILD_AXE3				43
#define BUILD_AXE4				44
#define BUILD_AXE5				45
#define BUILD_AMMO0				46
#define BUILD_AMMO1				47
#define BUILD_AMMO2				48
#define BUILD_FLET0				49
#define BUILD_FLET1				50
#define BUILD_FLET2				51
#define BUILD_FLET3				52
#define BUILD_WARHALL0			53
#define BUILD_WARHALL1			54
#define BUILD_WARHALL2			55
#define BUILD_WARHALL3			56
#define BUILD_WARHALL4			57
#define BUILD_WARHALL5			58
#define BUILD_CLOTH0			59
#define BUILD_CLOTH1			60
#define BUILD_HARMOUR0			61
#define BUILD_HARMOUR1			62
#define BUILD_HARMOUR2			63
#define BUILD_HARMOUR3			64
#define BUILD_HARMOUR4			65
#define BUILD_HARMOUR5			66
#define BUILD_HAT0				67
#define BUILD_HAT1				68
#define BUILD_HAT2				69
#define BUILD_HAT3				70
#define BUILD_JEWEL0			71
#define BUILD_JEWEL1			72
#define BUILD_JEWEL2			73
#define BUILD_JEWEL3			74
#define BUILD_JEWEL4			75
#define BUILD_STATUE0			76
#define BUILD_STATUE1			77
#define BUILD_FIGUR0			78
#define BUILD_FIGUR1			79
#define BUILD_POTION0			80
#define BUILD_POTION1			81
#define BUILD_POTION2			82
#define BUILD_POTION3			83
#define BUILD_POTION4			84
#define BUILD_SCROLL0			85
#define BUILD_SCROLL1			86
#define BUILD_SCROLL2			87
#define BUILD_SCROLL3			88
#define BUILD_SCROLL4			89
#define BUILD_MAGIC0			90
#define BUILD_MAGIC1			91
#define BUILD_MAGIC2			92
#define BUILD_MAGIC3			93
#define BUILD_MAGIC4			94
#define BUILD_BOOK1				95
#define BUILD_TEMPLE1			96
#define BUILD_TEMPLE2			97
#define BUILD_TEMPLE3			98
#define BUILD_SUPPLIES0			99
#define BUILD_SUPPLIES1			100
#define BUILD_BLACK1			101
#define BUILD_BLACK2			102
#define BUILD_ALCHEMY1			103
#define BUILD_ALCHEMY2			104
#define BUILD_JUNK				105
#define BUILD_FOOD				106
#define BUILD_LIBRARY			107
#define BUILD_CASINO			108
#define BUILD_INN				109
#define BUILD_HEALER			110
#define BUILD_BLACK0            111
#define BUILD_MAGETOWER0        112
#define BUILD_MAGETOWER1        113
#define BUILD_CASTLE0			114
#define BUILD_CASTLE1			115

/* Maximum number of "building" types in a city */
#define MAX_CITY_BUILD			116


/*
 * Total number of owners per building (see "bldg.c", etc)
 */
#define MAX_B_OWN			5


/*
 * Store constants
 */
#define STORE_INVEN_MAX 24		/* Max number of discrete objs in inven */

#define STORE_TURNOVER  9		/* Normal shop turnover, per day */
#define STORE_MIN_KEEP1 6		/* Min slots to "always" keep full */
#define STORE_MAX_KEEP1 18		/* Max slots to "always" keep full */
#define STORE_MIN_KEEP2 3		/* Min slots to "always" keep full */
#define STORE_MAX_KEEP2 9		/* Max slots to "always" keep full */
#define STORE_SHUFFLE   21		/* 1/Chance (per day) of an owner changing */
#define STORE_TURNS     1000	/* Number of turns between turnovers */

/* Store extra flags */
#define ST_REST_BLESSED		0x01	/* Blessed items */
#define ST_REST_GOOD		0x02	/* Good items only */
#define ST_REST_GREAT		0x04	/* Great items only */
#define ST_HALF_INVEN		0x08	/* One page of inventory */
#define ST_GREED			0x10	/* Double prices */
#define ST_ULTRA_GREED		0x20	/* Quadruple prices */



/*
 * Maximum number of player "sex" types (see "table.c", etc)
 */
#define MAX_SEXES           2

/*
 * Maximum number of player "class" types (see "table.c", etc)
 */
#define MAX_CLASS           11

/* The number of "patrons" available (for Chaos Warriors) */
#define MAX_PATRON          16

/* Number of entries in the sanity-blast descriptions */
#define MAX_SAN_HORROR		20
#define MAX_SAN_FUNNY		22
#define MAX_SAN_COMMENT		5

/* Chaos Warrior: Reward types: */
#define REW_POLY_SLF    1
#define REW_GAIN_EXP    2
#define REW_LOSE_EXP    3
#define REW_GOOD_OBJ    4
#define REW_GREA_OBJ    5
#define REW_CHAOS_WP    6
#define REW_GOOD_OBS    7
#define REW_GREA_OBS    8
#define REW_TY_CURSE    9
#define REW_SUMMON_M    10
#define REW_H_SUMMON    11
#define REW_DO_HAVOC    12
#define REW_GAIN_ABL    13
#define REW_LOSE_ABL    14
#define REW_RUIN_ABL    15
#define REW_AUGM_ABL    16
#define REW_POLY_WND    17
#define REW_HEAL_FUL    18
#define REW_HURT_LOT    19
#define REW_CURSE_WP    20
#define REW_CURSE_AR    21
#define REW_PISS_OFF    22
#define REW_WRATH       23
#define REW_DESTRUCT    24
#define REW_GENOCIDE    25
#define REW_MASS_GEN    26
#define REW_DISPEL_C    27
#define REW_UNUSED_1    28
#define REW_UNUSED_2    29
#define REW_UNUSED_3    30
#define REW_UNUSED_4    31
#define REW_UNUSED_5    32
#define REW_IGNORE      33
#define REW_SER_UNDE    34
#define REW_SER_DEMO    35
#define REW_SER_MONS    36

/* Chaos mutations */
#define MUT_SETS_MAX	 3
#define MUT_PER_SET		32


/* "Activatable" mutations must be in MUT1_* */
#define MUT1_SPIT_ACID                  0x00000001L
#define MUT1_BR_FIRE                    0x00000002L
#define MUT1_HYPN_GAZE                  0x00000004L
#define MUT1_TELEKINES                  0x00000008L
#define MUT1_VTELEPORT                  0x00000010L	/* Voluntary teleport */
#define MUT1_MIND_BLST                  0x00000020L
#define MUT1_RADIATION                  0x00000040L
#define MUT1_VAMPIRISM                  0x00000080L
#define MUT1_SMELL_MET                  0x00000100L
#define MUT1_SMELL_MON                  0x00000200L
#define MUT1_BLINK                      0x00000400L
#define MUT1_EAT_ROCK                   0x00000800L
#define MUT1_SWAP_POS                   0x00001000L
#define MUT1_SHRIEK                     0x00002000L
#define MUT1_ILLUMINE                   0x00004000L
#define MUT1_DET_CURSE                  0x00008000L
#define MUT1_BERSERK                    0x00010000L
#define MUT1_POLYMORPH                  0x00020000L
#define MUT1_MIDAS_TCH                  0x00040000L
#define MUT1_GROW_MOLD                  0x00080000L
#define MUT1_RESIST                     0x00100000L
#define MUT1_EARTHQUAKE                 0x00200000L
#define MUT1_EAT_MAGIC                  0x00400000L
#define MUT1_WEIGH_MAG                  0x00800000L
#define MUT1_STERILITY                  0x01000000L
#define MUT1_PANIC_HIT                  0x02000000L
#define MUT1_DAZZLE                     0x04000000L
#define MUT1_LASER_EYE                  0x08000000L
#define MUT1_RECALL                     0x10000000L
#define MUT1_BANISH                     0x20000000L
#define MUT1_COLD_TOUCH                 0x40000000L
#define MUT1_LAUNCHER                   0x80000000L

/* Randomly activating mutations must be MUT2_* */
#define MUT2_BERS_RAGE                  0x00000001L
#define MUT2_COWARDICE                  0x00000002L
#define MUT2_RTELEPORT                  0x00000004L	/* Random teleport */
#define MUT2_ALCOHOL                    0x00000008L
#define MUT2_HALLU                      0x00000010L
#define MUT2_FLATULENT                  0x00000020L
#define MUT2_SCOR_TAIL                  0x00000040L
#define MUT2_HORNS                      0x00000080L
#define MUT2_BEAK                       0x00000100L
#define MUT2_ATT_DEMON                  0x00000200L
#define MUT2_PROD_MANA                  0x00000400L
#define MUT2_SPEED_FLUX                 0x00000800L
#define MUT2_BANISH_ALL                 0x00001000L
#define MUT2_EAT_LIGHT                  0x00002000L
#define MUT2_TRUNK                      0x00004000L
#define MUT2_ATT_ANIMAL                 0x00008000L
#define MUT2_TENTACLES                  0x00010000L
#define MUT2_RAW_CHAOS                  0x00020000L
#define MUT2_NORMALITY                  0x00040000L
#define MUT2_WRAITH                     0x00080000L
#define MUT2_POLY_WOUND                 0x00100000L
#define MUT2_WASTING                    0x00200000L
#define MUT2_ATT_DRAGON                 0x00400000L
#define MUT2_WEIRD_MIND                 0x00800000L
#define MUT2_NAUSEA                     0x01000000L
#define MUT2_CHAOS_GIFT                 0x02000000L
#define MUT2_WALK_SHAD                  0x04000000L
#define MUT2_WARNING                    0x08000000L
#define MUT2_INVULN                     0x10000000L
#define MUT2_SP_TO_HP                   0x20000000L
#define MUT2_HP_TO_SP                   0x40000000L
#define MUT2_DISARM                     0x80000000L



/* Other mutations will be mainly in MUT3_* */

#define MUT3_HYPER_STR                  0x00000001L
#define MUT3_PUNY                       0x00000002L
#define MUT3_HYPER_INT                  0x00000004L
#define MUT3_MORONIC                    0x00000008L
#define MUT3_RESILIENT                  0x00000010L
#define MUT3_XTRA_FAT                   0x00000020L
#define MUT3_ALBINO                     0x00000040L
#define MUT3_FLESH_ROT                  0x00000080L
#define MUT3_SILLY_VOI                  0x00000100L
#define MUT3_BLANK_FAC                  0x00000200L
#define MUT3_ILL_NORM                   0x00000400L
#define MUT3_XTRA_EYES                  0x00000800L
#define MUT3_MAGIC_RES                  0x00001000L
#define MUT3_XTRA_NOIS                  0x00002000L
#define MUT3_INFRAVIS                   0x00004000L
#define MUT3_XTRA_LEGS                  0x00008000L
#define MUT3_SHORT_LEG                  0x00010000L
#define MUT3_ELEC_TOUC                  0x00020000L
#define MUT3_FIRE_BODY                  0x00040000L
#define MUT3_WART_SKIN                  0x00080000L
#define MUT3_SCALES                     0x00100000L
#define MUT3_IRON_SKIN                  0x00200000L
#define MUT3_WINGS                      0x00400000L
#define MUT3_FEARLESS                   0x00800000L
#define MUT3_REGEN                      0x01000000L
#define MUT3_ESP                        0x02000000L
#define MUT3_LIMBER                     0x04000000L
#define MUT3_ARTHRITIS                  0x08000000L
#define MUT3_BAD_LUCK                   0x10000000L
#define MUT3_VULN_ELEM                  0x20000000L
#define MUT3_MOTION                     0x40000000L
#define MUT3_GOOD_LUCK                  0x80000000L

/*
 * The racial powers
 */
#define MAX_RACE_POWERS		28


/* Monk martial arts... */
# define MAX_MA			17
# define MA_KNEE		1
# define MA_SLOW		2

/* Mindcrafter */
#define MINDCRAFT_NEURAL_BLAST           0
#define MINDCRAFT_PRECOGNITION           1
#define MINDCRAFT_MINOR_DISPLACEMENT     2
#define MINDCRAFT_MAJOR_DISPLACEMENT     3
#define MINDCRAFT_DOMINATION             4
#define MINDCRAFT_PULVERISE              5
#define MINDCRAFT_CHARACTER_ARMOUR       6
#define MINDCRAFT_PSYCHOMETRY            7
#define MINDCRAFT_MIND_WAVE              8
#define MINDCRAFT_ADRENALINE_CHANNELING  9
#define MINDCRAFT_PSYCHIC_DRAIN         10
#define MINDCRAFT_TELEKINETIC_WAVE      11
#define MINDCRAFT_MAX                   12

/* Hallucination stuff */
#define MAX_SILLY_ATTACK		28


/*
 * Maximum number of high scores in the high score file
 */
#define MAX_HISCORES    100


/*
 * Maximum dungeon level.  The player can never reach this level
 * in the dungeon, and this value is used for various calculations
 * involving object and monster creation.  It must be at least 100.
 * Setting it below 128 may prevent the creation of some objects.
 */
#define MAX_DEPTH       128

/*
 * Maximum size of the "view" array (see "cave.c")
 * Note that the "view radius" will NEVER exceed 20, and even if the "view"
 * was octagonal, we would never require more than 1520 entries in the array.
 */
#define VIEW_MAX		1536

/*
 * Maximum size of the "temp" array (see "cave.c")
 * We must be as large as "VIEW_MAX" for proper functioning
 * of "update_view()".  We must also be as large as the
 * largest illuminatable room, but no room is larger than 800 grids.  We
 * must also be large enough to allow "good enough" use as a circular queue,
 * to calculate monster flow.  The larger size is due to use as a circular
 * queue for the fractal caves patch fill routine.
 */
#define TEMP_MAX		2000

/*
 * Maximum number of squares lit by monsters.
 * (Note that squares far away from the player do not need to be stored.)
 */
#define LITE_MAX		2500


/*
 * Maximum number of monsters that can be exploding at once.
 */
#define DEATH_MAX		100

/*
 * Number of keymap modes
 */
#define KEYMAP_MODES		2

/*
 * Mode for original keyset commands
 */
#define KEYMAP_MODE_ORIG	0

/*
 * Mode for roguelike keyset commands
 */
#define KEYMAP_MODE_ROGUE	1


/*
 * OPTION: Maximum number of macros (see "utils.c")
 * Default: assume at most 256 macros are used
 */
#define MACRO_MAX       256

/*
 * OPTION: Maximum number of "quarks" (see "utils.c")
 * Default: assume at most 2048 scripts + names + inscriptions
 */
#define QUARK_MAX       2048

/*
 * Threshold for quark list before compacting
 */
#define QUARK_COMPACT	(MAX_SHORT - 1)


/*
 * OPTION: Maximum number of messages to remember (see "utils.c")
 * Default: assume maximal memorization of 2048 total messages
 */
#define MESSAGE_MAX     2048

/*
 * OPTION: Maximum space for the message text buffer (see "utils.c")
 * Default: assume that each of the 2048 messages is repeated an
 * average of three times, and has an average length of 48
 */
#define MESSAGE_BUF     32768


/*
 * Maximum value storable in a "byte" (hard-coded)
 */
#define MAX_UCHAR       255

/*
 * Maximum value storable in a "s16b" (hard-coded)
 */
#define MAX_SHORT       32767


/*
 * Misc constants
 */
#define TOWN_DAWN               10000	/* Number of turns from dawn to dawn XXX */
#define BREAK_GLYPH             550	/* Rune of protection resistance */
#define BREAK_MINOR_GLYPH       99	/* For explosive runes */
#define BTH_PLUS_ADJ    		1	/* Adjust BTH per plus-to-hit */
#define MON_MULT_ADJ    		8	/* High value slows multiplication */
#define MON_SUMMON_ADJ  		2	/* Adjust level of summoned creatures */
#define MON_DRAIN_LIFE  		2	/* Percent of player exp drained per hit */
#define USE_DEVICE      		3	/* x> Harder devices x< Easier devices */


/* "Biases" for random artifact gen */

#define BIAS_ELEC            1
#define BIAS_POIS            2
#define BIAS_FIRE            3
#define BIAS_COLD            4
#define BIAS_ACID            5
#define BIAS_STR             6
#define BIAS_INT             7
#define BIAS_WIS             8
#define BIAS_DEX             9
#define BIAS_CON            10
#define BIAS_CHR            11
#define BIAS_CHAOS          12
#define BIAS_PRIESTLY       13
#define BIAS_NECROMANTIC    14
#define BIAS_LAW            15
#define BIAS_ROGUE          16
#define BIAS_MAGE           17
#define BIAS_WARRIOR        18
#define BIAS_RANGER         19


/*** Pet constants ***/


/*
 * Commands
 */

#define PET_STAY_CLOSE				0
#define PET_FOLLOW_ME				1
#define PET_SEEK_AND_DESTROY		2
#define PET_ALLOW_SPACE				3
#define PET_STAY_AWAY				4
#define PET_OPEN_DOORS				5
#define PET_TAKE_ITEMS				6
#define PET_INFO					7
#define PET_DISMISS					8
#define PET_CHOICE_MAX				9

/*
 * Follow distances
 */
#define PET_CLOSE_DIST				1
#define PET_FOLLOW_DIST				6
#define PET_SEEK_DIST				10
#define PET_DESTROY_DIST			255
#define PET_SPACE_DIST				(-10)
#define PET_AWAY_DIST				(-25)


/*
 * There is a 1/50 (2%) chance of inflating the requested object_level
 * during the creation of an object (see "get_obj_num()" in "object.c").
 * Lower values yield better objects more often.
 */
#define GREAT_OBJ       50


/*
 * There is a 1/10 (10%) chance of inflating the level requested in
 * making an ego item
 */
#define EGO_INFLATE		10

/*
 * There is a 1/50 (2%) chance of inflating the requested monster level
 * during the creation of a monsters (see "get_mon_num()" in "monster.c").
 * Lower values yield harder monsters more often.
 */
#define NASTY_MON       50

/* 1/x chance of hurting even if invulnerable! */
#define PENETRATE_INVULNERABILITY 13

/* Mana drained by getting in a psi hit */
#define PSI_COST 1


/*
 * Refueling constants
 */
#define FUEL_TORCH      5000	/* Maximum amount of fuel in a torch */
#define FUEL_LAMP       15000	/* Maximum amount of fuel in a lantern */


/*
 * More maximum values
 */
#define MAX_DETECT		30		/* Maximum detection range */
#define MAX_SIGHT       20		/* Maximum view distance */
#define MAX_RANGE       18		/* Maximum range (spells, etc) < MAX_SIGHT */


/*
 * Max distance the player can be before we redo the flow data
 */
#define FLOW_DIST_MAX	10

/*
 * Maximum flow depth when using "MONSTER_FLOW"
 */
#define MONSTER_FLOW_DEPTH 40


/*
 * There is a 1/160 chance per round of creating a new monster
 */
#define MAX_M_ALLOC_CHANCE      160

/*
 * Normal levels get at least 14 monsters
 */
#define MIN_M_ALLOC_LEVEL       14


/*
 * A monster can only "multiply" (reproduce) if there are fewer than 100
 * monsters on the level capable of such spontaneous reproduction.  This
 * is a hack which prevents the "m_list[]" array from exploding due to
 * reproducing monsters.  Messy, but necessary.
 */
#define MAX_REPRO       100


/*
 * Player constants
 */
#define PY_MAX_EXP      99999999L	/* Maximum exp */
#define PY_MAX_GOLD     999999999L	/* Maximum gold */
#define PY_MAX_LEVEL    50		/* Maximum level */

/*
 * Player "food" crucial values
 */
#define PY_FOOD_MAX  	15000	/* Food value (Bloated) */
#define PY_FOOD_FULL    10000	/* Food value (Normal) */
#define PY_FOOD_ALERT   2000	/* Food value (Hungry) */
#define PY_FOOD_WEAK    1000	/* Food value (Weak) */
#define PY_FOOD_FAINT   500		/* Food value (Fainting) */
#define PY_FOOD_STARVE  100		/* Food value (Starving) */

/*
 * Player regeneration constants
 */
#define PY_REGEN_NORMAL         197	/* Regen factor*2^16 when full */
#define PY_REGEN_WEAK           98	/* Regen factor*2^16 when weak */
#define PY_REGEN_FAINT          33	/* Regen factor*2^16 when fainting */
#define PY_REGEN_HPBASE         1442	/* Min amount hp regen*2^16 */
#define PY_REGEN_MNBASE         524	/* Min amount mana regen*2^16 */


/*
 * Maximum number of players spells
 */
#define PY_MAX_SPELLS 64

/*
 * Possible realms that can be chosen;
 * currently used only by birth.c and tables.c
 */
#define CH_NONE         0x00
#define CH_LIFE         0x01
#define CH_SORCERY      0x02
#define CH_NATURE       0x04
#define CH_CHAOS        0x08
#define CH_DEATH        0x10
#define CH_TRUMP        0x20
#define CH_ARCANE       0x40


/*
 * Magic realms
 */
#define REALM_NONE         0
#define REALM_LIFE         1
#define REALM_SORCERY      2
#define REALM_NATURE       3
#define REALM_CHAOS        4
#define REALM_DEATH        5
#define REALM_TRUMP        6
#define REALM_ARCANE       7
#define MAX_REALM          8

/*
 * Magic-books for the realms
 */
#define REALM1_BOOK     (p_ptr->spell.r[0].realm + TV_LIFE_BOOK - 1)
#define REALM2_BOOK     (p_ptr->spell.r[1].realm + TV_LIFE_BOOK - 1)


/*
 * Ego item slot-types
 */

/* XXX XXX Hack - gap */

#define ES_CROWN     21
#define ES_DIG		 22
#define ES_AMMO      23
#define ES_WIELD     24
#define ES_BOW       25

/* Hack - gap */

#define ES_NECK      28
#define ES_LITE      29
#define ES_BODY      30
#define ES_OUTER     31
#define ES_ARM       32
#define ES_HEAD      33
#define ES_HANDS     34
#define ES_FEET      35


/*
 * Maximum number of "normal" pack slots.
 * Note that "INVEN_PACK" is probably hard-coded by its use in savefiles, and
 * by the fact that the screen can only show 23 items plus a one-line prompt.
 */
#define INVEN_PACK              23

/*
 * Equipment slots
 */
#define EQUIP_WIELD     0
#define EQUIP_BOW       1
#define EQUIP_LEFT      2
#define EQUIP_RIGHT     3
#define EQUIP_NECK      4
#define EQUIP_LITE      5
#define EQUIP_BODY      6
#define EQUIP_OUTER     7
#define EQUIP_ARM       8
#define EQUIP_HEAD      9
#define EQUIP_HANDS     10
#define EQUIP_FEET      11

/*
 * Total number of things that you can wield (hard coded)
 */
#define EQUIP_MAX		12


/*
 * A "stack" of items is limited to less than 100 items (hard-coded).
 */
#define MAX_STACK_SIZE		100

/*
 * A "stack" of items is limited to less than or equal to 20.0 lbs.
 */
#define MAX_STACK_WEIGHT        200


/*
 * Indexes of the various "stats" (hard-coded by savefiles, etc).
 */
#define A_STR   0
#define A_INT   1
#define A_WIS   2
#define A_DEX   3
#define A_CON   4
#define A_CHR   5

/*
 * Total number of stats.
 */
#define A_MAX	6

/* 1/x chance of reducing stats (for elemental attacks) */
#define HURT_CHANCE 50


/*
 * Player sex constants (hard-coded by save-files, arrays, etc)
 */
#define SEX_FEMALE              0
#define SEX_MALE                1


/*
 * Player race constants (hard-coded by save-files, arrays, etc)
 */
#define RACE_HUMAN               0
#define RACE_HALF_ELF            1
#define RACE_ELF                 2
#define RACE_HOBBIT              3
#define RACE_GNOME               4
#define RACE_DWARF               5
#define RACE_HALF_ORC            6
#define RACE_HALF_TROLL          7
#define RACE_AMBERITE            8
#define RACE_HIGH_ELF            9
#define RACE_BARBARIAN          10
#define RACE_HALF_OGRE          11
#define RACE_HALF_GIANT         12
#define RACE_HALF_TITAN         13
#define RACE_CYCLOPS            14
#define RACE_YEEK               15
#define RACE_KLACKON            16
#define RACE_KOBOLD             17
#define RACE_NIBELUNG           18
#define RACE_DARK_ELF           19
#define RACE_DRACONIAN          20
#define RACE_MIND_FLAYER        21
#define RACE_IMP                22
#define RACE_GOLEM              23
#define RACE_SKELETON           24
#define RACE_ZOMBIE             25
#define RACE_VAMPIRE            26
#define RACE_SPECTRE            27
#define RACE_SPRITE             28
#define RACE_BEASTMAN           29
#define RACE_GHOUL              30

/*
 * Maximum number of player "race" types (see "table.c", etc)
 */
#define MAX_RACES               31


/*
 * Player class constants (hard-coded by save-files, arrays, etc)
 */
#define CLASS_WARRIOR            0
#define CLASS_MAGE               1
#define CLASS_PRIEST             2
#define CLASS_ROGUE              3
#define CLASS_RANGER             4
#define CLASS_PALADIN            5
#define CLASS_WARRIOR_MAGE       6
#define CLASS_CHAOS_WARRIOR      7
#define CLASS_MONK               8
#define CLASS_MINDCRAFTER        9
#define CLASS_HIGH_MAGE         10

/*** Screen Locations ***/

/*
 * Some screen locations for various display routines
 */

#define ROW_RACE                1
#define COL_RACE                0	/* <race name> */

#define ROW_CLASS               2
#define COL_CLASS               0	/* <class name> */

#define ROW_TITLE               3
#define COL_TITLE               0	/* <title> or <mode> */

#define ROW_LEVEL               4
#define COL_LEVEL               0	/* "LEVEL xxxxxx" */

#define ROW_EXP                 5
#define COL_EXP                 0	/* "EXP xxxxxxxx" */

#define ROW_GOLD                6
#define COL_GOLD                0	/* "AU xxxxxxxxx" */

#define ROW_EQUIPPY             7
#define COL_EQUIPPY             0	/* equippy chars */

#define ROW_STAT                8
#define COL_STAT                0	/* "xxx   xxxxxx" */

#define ROW_STATBAR             14
#define COL_STATBAR             0	/* "Status bar" */

#define ROW_AC                  15
#define COL_AC                  0	/* "Cur AC xxxxx" */

#define ROW_MAXHP               16
#define COL_MAXHP               0	/* "Max HP xxxxx" */

#define ROW_CURHP               17
#define COL_CURHP               0	/* "Cur HP xxxxx" */

#define ROW_MAXSP               18
#define COL_MAXSP               0	/* "Max SP xxxxx" */

#define ROW_CURSP               19
#define COL_CURSP               0	/* "Cur SP xxxxx" */

#define ROW_INFO                20
#define COL_INFO                0	/* "xxxxxxxxxxxx" */

#define ROW_CUT                 21
#define COL_CUT                 0	/* <cut> */

#define ROW_STUN                22
#define COL_STUN                0	/* <stun> */

#define ROW_MAP					1
#define COL_MAP                 13	/* The map of the dungeon */


#define COL_HUNGRY              0	/* "Weak" / "Hungry" / "Full" / "Gorged" */

#define COL_BLIND               7	/* "Blind" */

#define COL_CONFUSED    		13	/* "Confused" */

#define COL_AFRAID              22	/* "Afraid" */

#define COL_POISONED		    29	/* "Poisoned" */

#define COL_STATE               38	/* <state> */

#define COL_SPEED               45	/* "Slow (-NN)" or "Fast (+NN)" */

#define COL_STUDY               56	/* "Study" */

#define COL_DEPTH               62	/* "Lev NNN" / "NNNN ft" / town name */



#define MAX_EFFECTS				30	/* Max #of player timed effects */


/*** Terrain Feature Indexes (see "lib/edit/f_info.txt") ***/

/* Nothing */
#define FEAT_NONE               0x00

/* Various */
#define FEAT_FLOOR              0x01
/* #define FEAT_INVIS              0x02 Now is a field */
/* #define FEAT_GLYPH              0x03 Now is a field */
#define FEAT_OPEN               0x04
#define FEAT_BROKEN             0x05
#define FEAT_LESS               0x06
#define FEAT_MORE               0x07

/* Passable floors */

#define FEAT_SAND				0x08
#define FEAT_SALT				0x09
#define FEAT_WET_MUD			0x0A
#define FEAT_DRY_MUD			0x0B
#define FEAT_FLOOR_TILE			0x0C
#define FEAT_FLOOR_WOOD			0x0D
#define FEAT_PEBBLES			0x0E
#define FEAT_SOLID_LAVA			0x0F

/* Gap where the traps were */

/* Closed Door */
#define FEAT_CLOSED				0x20
#define FEAT_PILLAR         	0x21

/* A big gap for expansion */

/* Extra */
#define FEAT_SECRET             0x30
#define FEAT_RUBBLE             0x31

/* Seams */
#define FEAT_MAGMA              0x32
#define FEAT_QUARTZ             0x33
/* #define FEAT_MAGMA_H            0x34 */
/* #define FEAT_QUARTZ_H           0x35 */
#define FEAT_MAGMA_K            0x36
#define FEAT_QUARTZ_K           0x37

/* Walls */
#define FEAT_WALL_EXTRA         0x38
#define FEAT_WALL_INNER         0x39
#define FEAT_WALL_OUTER         0x3A
#define FEAT_WALL_SOLID         0x3B
#define FEAT_PERM_EXTRA         0x3C
#define FEAT_PERM_INNER         0x3D
#define FEAT_PERM_OUTER         0x3E
#define FEAT_PERM_SOLID         0x3F

/* Gap where Glyph was */

/* Pattern */
#define FEAT_PATTERN_START      0x41
#define FEAT_PATTERN_1          0x42
#define FEAT_PATTERN_2          0x43
#define FEAT_PATTERN_3          0x44
#define FEAT_PATTERN_4          0x45
#define FEAT_PATTERN_END        0x46
#define FEAT_PATTERN_OLD        0x47
#define FEAT_PATTERN_XTRA1      0x48
#define FEAT_PATTERN_XTRA2      0x49

/* Terrains */
#define FEAT_DEEP_WATER         0x53
#define FEAT_SHAL_WATER         0x54
#define FEAT_DEEP_LAVA          0x55
#define FEAT_SHAL_LAVA          0x56

/* Gap */

#define FEAT_DIRT               0x58
#define FEAT_GRASS              0x59

/* Gap */

#define FEAT_OCEAN_WATER		0x5C
#define FEAT_DEEP_ACID			0x5D
#define FEAT_SHAL_ACID			0x5E
#define FEAT_TREE_WATER			0x5F

/* Terrain semi-transparent*/
#define FEAT_TREES          	0x60
#define FEAT_MOUNTAIN       	0x61
#define FEAT_SNOW_MOUNTAIN		0x62
#define FEAT_BOULDER			0x63
#define FEAT_PINE_TREE			0x64
#define FEAT_SNOW_TREE			0x65
#define FEAT_OBELISK			0x66

/* Gap */

/* Impassible terrains */
#define FEAT_FENCE				0x70
#define FEAT_WELL				0x71
#define FEAT_FOUNTAIN			0x72
#define FEAT_JUNGLE				0x73

/* Gap */

/* Slow "floor" terrains */
#define FEAT_BUSH				0x80
#define FEAT_DEAD_BUSH			0x81
#define FEAT_GRASS_LONG			0x82
#define FEAT_ROCK_GEN			0x83
#define FEAT_ROCK_SNOW			0x84
#define FEAT_TREE_GEN			0x85
#define FEAT_TREE_SNOW			0x86
#define FEAT_SNOW				0x87
#define FEAT_DEEP_SWAMP			0x88
#define FEAT_SHAL_SWAMP			0x89


/*** Wilderness Info flags - (see "wild.c") ***/

#define WILD_INFO_TRACK		0x01
#define WILD_INFO_ROAD		0x02
#define WILD_INFO_WATER		0x04
#define WILD_INFO_LAVA		0x08
#define WILD_INFO_DUMMY		0x10
#define WILD_INFO_SEEN		0x20
#define WILD_INFO_ACID		0x40
#define WILD_INFO_QUEST		0x80


/* Types of "liquid" for dungeon */
#define LQ_NONE		0x00
#define LQ_WATER	0x01
#define LQ_LAVA		0x02
#define LQ_ACID		0x04
#define LQ_SWAMP	0x08

#define LQ_MAX		4

/* Room types */
#define RT_TAG_CROWDED	0x0001 /* Affects "crowded" counter */
#define RT_NATURAL		0x0002
#define RT_ANIMAL		0x0004
#define RT_COMPLEX		0x0008
#define RT_DENSE		0x0010
#define RT_RUIN			0x0020
#define RT_SIMPLE		0x0040
#define RT_BUILDING		0x0080
#define RT_CRYPT		0x0100
#define RT_RVAULT		0x0200
#define RT_STRANGE		0x0400
#define RT_FANCY		0x0800


/*** Field Thaumatergical types - (see "fields.c" and t_info.txt) ***/
#define FT_NONE					0x0000
#define FT_WALL_INVIS			0x0001
#define FT_GLYPH_WARDING		0x0002
#define FT_GLYPH_EXPLODE		0x0003
#define FT_CORPSE				0x0004
#define FT_SKELETON				0x0005
#define FT_TRAP_DOOR			0x0006
#define FT_TRAP_PIT				0x0007
#define FT_TRAP_SPIKE_PIT		0x0008
#define FT_TRAP_POISON_PIT		0x0009
#define FT_TRAP_CURSE			0x000A
#define FT_TRAP_TELEPORT		0x000B
#define FT_TRAP_ELEMENT			0x000C
#define FT_TRAP_BA_ELEMENT		0x000D
#define FT_TRAP_GAS				0x000E
#define FT_TRAP_TRAPS			0x000F
#define FT_TRAP_TEMP_STAT		0x0010
#define FT_TRAP_PERM_STAT		0x0011
#define FT_TRAP_LOSE_XP			0x0012
#define FT_TRAP_DISENCHANT		0x0013
#define FT_TRAP_DROP_ITEM		0x0014
#define FT_TRAP_MUTATE			0x0015
#define FT_TRAP_NEW_LIFE		0x0016
#define FT_TRAP_NO_LITE			0x0017
#define FT_TRAP_HUNGER			0x0018
#define FT_TRAP_NO_GOLD			0x0019
#define FT_TRAP_HASTE_MON		0x001A
#define FT_TRAP_RAISE_MON		0x001B
#define FT_TRAP_DRAIN_MAGIC		0x001C
#define FT_TRAP_AGGRAVATE		0x001D
#define FT_TRAP_SUMMON			0x001E
#define FT_TRAP_LOSE_MEMORY		0x001F
#define FT_LOCK_DOOR			0x0020
#define FT_JAM_DOOR				0x0021
#define FT_STORE_GENERAL		0x0022
#define FT_STORE_ARMOURY		0x0023
#define FT_STORE_WEAPON			0x0024
#define FT_STORE_TEMPLE			0x0025
#define FT_STORE_ALCHEMIST		0x0026
#define FT_STORE_MAGIC			0x0027
#define FT_STORE_BLACK			0x0028
#define FT_STORE_HOME			0x0029
#define FT_STORE_BOOK			0x002A
#define FT_BUILD_WEAPON			0x002B
#define FT_BUILD_RECHARGE		0x002C
#define FT_BUILD_PLUS_WEAPON	0x002D
#define FT_BUILD_PLUS_ARMOUR	0x002E
#define FT_BUILD_MUTATE			0x002F
#define FT_BUILD_MAP			0x0030
#define FT_STORE_WEAPON1		0x0031
#define FT_STORE_WEAPON2		0x0032
#define FT_STORE_WEAPON3		0x0033
#define FT_STORE_WEAPON4		0x0034
#define FT_STORE_WEAPON5		0x0035
#define FT_STORE_ARMOUR1		0x0036
#define FT_STORE_ARMOUR2		0x0037
#define FT_STORE_ARMOUR3		0x0038
#define FT_STORE_ARMOUR4		0x0039
#define FT_STORE_ARMOUR5		0x003A
#define FT_STORE_SWORD0			0x003B
#define FT_STORE_SWORD1			0x003C
#define FT_STORE_SWORD2			0x003D
#define FT_STORE_SWORD3			0x003E
#define FT_STORE_SWORD4			0x003F
#define FT_STORE_SWORD5			0x0040
#define FT_STORE_SHIELD0		0x0041
#define FT_STORE_SHIELD1		0x0042
#define FT_STORE_SHIELD2		0x0043
#define FT_STORE_SHIELD3		0x0044
#define FT_STORE_SHIELD4		0x0045
#define FT_STORE_SHIELD5		0x0046
#define FT_STORE_AXE0			0x0047
#define FT_STORE_AXE1			0x0048
#define FT_STORE_AXE2			0x0049
#define FT_STORE_AXE3			0x004A
#define FT_STORE_AXE4			0x004B
#define FT_STORE_AXE5			0x004C
#define FT_STORE_AMMO0			0x004D
#define FT_STORE_AMMO1			0x004E
#define FT_STORE_AMMO2			0x004F
#define FT_STORE_FLET0			0x0050
#define FT_STORE_FLET1			0x0051
#define FT_STORE_FLET2			0x0052
#define FT_STORE_FLET3			0x0053
#define FT_STORE_WARHALL0		0x0054
#define FT_STORE_WARHALL1		0x0055
#define FT_STORE_WARHALL2		0x0056
#define FT_STORE_WARHALL3		0x0057
#define FT_STORE_WARHALL4		0x0058
#define FT_STORE_WARHALL5		0x0059
#define FT_STORE_CLOTH0			0x005A
#define FT_STORE_CLOTH1			0x005B
#define FT_STORE_HARMOUR0		0x005C
#define FT_STORE_HARMOUR1		0x005D
#define FT_STORE_HARMOUR2		0x005E
#define FT_STORE_HARMOUR3		0x005F
#define FT_STORE_HARMOUR4		0x0060
#define FT_STORE_HARMOUR5		0x0061
#define FT_STORE_HAT0			0x0062
#define FT_STORE_HAT1			0x0063
#define FT_STORE_HAT2			0x0064
#define FT_STORE_HAT3			0x0065
#define FT_STORE_JEWEL0			0x0066
#define FT_STORE_JEWEL1			0x0067
#define FT_STORE_JEWEL2			0x0068
#define FT_STORE_JEWEL3			0x0069
#define FT_STORE_JEWEL4			0x006A
#define FT_STORE_STATUE0		0x006B
#define FT_STORE_STATUE1		0x006C
#define FT_STORE_FIGUR0			0x006D
#define FT_STORE_FIGUR1			0x006E
#define FT_STORE_POTION0		0x006F
#define FT_STORE_POTION1		0x0070
#define FT_STORE_POTION2		0x0071
#define FT_STORE_POTION3		0x0072
#define FT_STORE_POTION4		0x0073
#define FT_STORE_SCROLL0		0x0074
#define FT_STORE_SCROLL1		0x0075
#define FT_STORE_SCROLL2		0x0076
#define FT_STORE_SCROLL3		0x0077
#define FT_STORE_SCROLL4		0x0078
#define FT_STORE_MAGIC0			0x0079
#define FT_STORE_MAGIC1			0x007A
#define FT_STORE_MAGIC2			0x007B
#define FT_STORE_MAGIC3			0x007C
#define FT_STORE_MAGIC4			0x007D
#define FT_STORE_BOOK1			0x007E
#define FT_STORE_TEMPLE1		0x007F
#define FT_STORE_TEMPLE2		0x0080
#define FT_STORE_TEMPLE3		0x0081
#define FT_STORE_SUPPLIES0		0x0082
#define FT_STORE_SUPPLIES1		0x0083
#define FT_STORE_BLACK1			0x0084
#define FT_STORE_BLACK2			0x0085
#define FT_STORE_ALCHEMY1		0x0086
#define FT_STORE_ALCHEMY2		0x0087
#define FT_STORE_JUNK			0x0088
#define FT_STORE_FOOD			0x0089
#define FT_BUILD_LIBRARY		0x008A
#define FT_BUILD_CASINO			0x008B
#define FT_BUILD_INN			0x008C
#define FT_BUILD_HEALER			0x008D
#define FT_STORE_BLACK0         0x008E
#define FT_BUILD_MAGETOWER0     0x008F
#define FT_BUILD_MAGETOWER1     0x0090
#define FT_BUILD_CASTLE0		0x0091
#define FT_BUILD_CASTLE1		0x0092


/*** Artifact indexes (see "lib/edit/a_info.txt") ***/

/* The maximum "special" artifact index */
#define MAX_ART_SPECIAL          15

/* Lites */
#define ART_GALADRIEL            1
#define ART_ELENDIL              2
#define ART_THRAIN               3

/* Amulets */
#define ART_CARLAMMAS            4
#define ART_INGWE                5
#define ART_DWARVES              6

/* Rings */
#define ART_BARAHIR              8
#define ART_TULKAS               9
#define ART_NARYA               10
#define ART_NENYA               11
#define ART_VILYA               12
#define ART_POWER               13
#define ART_ELEMENTS			14

/* Dragon Scale */
#define ART_RAZORBACK           16
#define ART_BLADETURNER         17

/* Robe */
#define ART_THAUMATURGIST		18

/* Hard Armour */
#define ART_SOULKEEPER          19
#define ART_ISILDUR             20
#define ART_ROHIRRIM            21
#define ART_BELEGENNON          22
#define ART_CELEBORN            23
#define ART_ARVEDUI             24
#define ART_CASPANION           25
#define ART_NEMOVEBLA			26

/* Soft Armour */
#define ART_HITHLOMIR           27
#define ART_THALKETTOTH         28

/* Gap */

/* Shields */
#define ART_THORIN              30
#define ART_CELEGORM            31
#define ART_ANARION             32

/* Helms and Crowns */
#define ART_MORGOTH             34
#define ART_BERUTHIEL           35
#define ART_THRANDUIL           36
#define ART_THENGEL             37
#define ART_HAMMERHAND          38
#define ART_DOR                 39
#define ART_HOLHENNETH          40
#define ART_TERROR              41
#define ART_GONDOR              42

/* Cloaks */
#define ART_KERI                43
#define ART_COLLUIN             44
#define ART_HOLCOLLETH          45
#define ART_THINGOL             46
#define ART_THORONGIL           47
#define ART_COLANNON            48
#define ART_LUTHIEN             49
#define ART_TUOR                50

/* Gloves */
#define ART_CAMBELEG            52
#define ART_CAMMITHRIM          53
#define ART_PAURHACH            54
#define ART_CORWIN              55
#define ART_PAURAEGEN           56
#define ART_PAURNEN             57
#define ART_CAMLOST             58
#define ART_FINGOLFIN           59

/* Boots */
#define ART_FEANOR              60
#define ART_DAL                 61
#define ART_THROR               62

/* Swords */
#define ART_MAEDHROS            64
#define ART_ANGRIST             65
#define ART_NARTHANC            66
#define ART_NIMTHANC            67
#define ART_DETHANC             68
#define ART_RILIA               69
#define ART_BELANGIL            70
#define ART_CALRIS              71
#define ART_GRAYSWANDIR         72
#define ART_GLAMDRING           73
#define ART_AEGLIN              74
#define ART_ORCRIST             75
#define ART_GURTHANG            76
#define ART_ZARCUTHRA           77
#define ART_MORMEGIL            78
#define ART_GONDRICAM           79
#define ART_CRISDURIAN          80
#define ART_GROO                81
#define ART_RINGIL              82
#define ART_ANDURIL             83
#define ART_ANGUIREL            84
#define ART_CHAINSWORD          85
#define ART_FORASGIL            86
#define ART_CARETH              87
#define ART_STING               88
#define ART_HARADEKKET          89
#define ART_GILETTAR            90
#define ART_DOOMCALLER          91
#define ART_VORPAL_BLADE        92

/* Polearms */
#define ART_THEODEN             93
#define ART_PAIN                94
#define ART_OSONDIR             95
#define ART_TIL                 96
#define ART_AEGLOS              97
#define ART_OROME               98
#define ART_NIMLOTH             99
#define ART_SOULSUCKER          100
#define ART_DURIN               101
#define ART_EONWE               102
#define ART_BALLI               103
#define ART_LOTHARANG           104
#define ART_MUNDWINE            105
#define ART_BARUKKHELED         106
#define ART_WRATH               107
#define ART_ULMO                108
#define ART_AVAVIR              109

/* The sword of the Dawn */
#define ART_DAWN                110

/* Hafted */
#define ART_GROND               111
#define ART_TOTILA              112
#define ART_THUNDERFIST         113
#define ART_WHIRLWIND           114
#define ART_FIRESTAR            115
#define ART_ENERGY              116
#define ART_AULE                117
#define ART_NAR                 118
#define ART_ERIRIL              119
#define ART_OLORIN              120
#define ART_DEATHWREAKER        121
#define ART_TURMIL              122

/* Sling */
#define ART_CATAPULT			123

/* Bows */
#define ART_BELTHRONDING        124
#define ART_BARD                125
#define ART_BRAND               126
#define ART_MARKSMAN			127


/* New artifacts */
#define ART_STORMBRINGER		130


/*** Ego-Item indexes (see "lib/edit/e_info.txt") ***/


/* Nothing */
/* xxx */
/* xxx */
/* xxx */

/* Body Armor */
#define EGO_RESIST_ACID         4
#define EGO_RESIST_ELEC         5
#define EGO_RESIST_FIRE         6
#define EGO_RESIST_COLD         7
#define EGO_RESISTANCE          8
#define EGO_ELVENKIND           9
/* xxx */
#define EGO_PERMANENCE          11

/* Lites */
#define EGO_EVERBURN			12
#define EGO_VISION              13
#define EGO_WARMTH				14
#define EGO_SEARCH              15


/* Shields */
#define EGO_ENDURE_ACID         16
#define EGO_ENDURE_ELEC         17
#define EGO_ENDURE_FIRE         18
#define EGO_ENDURE_COLD         19
#define EGO_ENDURANCE           20
#define EGO_REFLECTION          21
/* xxx */
/* xxx */

/* Crowns and Helms */
#define EGO_INTELLIGENCE        24
#define EGO_WISDOM              25
#define EGO_BEAUTY              26
#define EGO_MAGI                27
#define EGO_MIGHT               28
#define EGO_LORDLINESS          29
#define EGO_SEEING              30
#define EGO_INFRAVISION         31
#define EGO_LITE                32
#define EGO_TELEPATHY           33
#define EGO_REGENERATION        34
#define EGO_TELEPORTATION       35
#define EGO_STUPIDITY           36
#define EGO_NAIVETY             37
#define EGO_UGLINESS            38
#define EGO_SICKLINESS          39

/* Cloaks */
#define EGO_PROTECTION          40
#define EGO_STEALTH             41
#define EGO_AMAN                42
#define EGO_AURA_FIRE           43
#define EGO_ENVELOPING          44
#define EGO_VULNERABILITY       45
#define EGO_IRRITATION          46
#define EGO_AURA_ELEC           47

/* Gloves */
#define EGO_FREE_ACTION         48
#define EGO_SLAYING             49
#define EGO_AGILITY             50
#define EGO_POWER               51
#define EGO_GHOUL_TOUCH         52
/* xxx */
#define EGO_WEAKNESS            54
#define EGO_CLUMSINESS          55

/* Boots */
#define EGO_SLOW_DESCENT        56
#define EGO_QUIET               57
#define EGO_MOTION              58
#define EGO_SPEED               59
/* xxx */
#define EGO_NOISE               61
#define EGO_SLOWNESS            62
#define EGO_ANNOYANCE           63

/* Weapons */
#define EGO_HA                  64
#define EGO_DF                  65
#define EGO_BLESS_BLADE         66
/* xxx */
#define EGO_WEST                68
#define EGO_ATTACKS             69
#define EGO_SLAYING_WEAPON      70
/* xxx */
#define EGO_BRAND_ACID          72
#define EGO_BRAND_ELEC          73
#define EGO_BRAND_FIRE          74
#define EGO_BRAND_COLD          75
#define EGO_BRAND_POIS          76
#define EGO_CHAOTIC             77
#define EGO_SHARPNESS           78
#define EGO_EARTHQUAKES         79
#define EGO_SLAY_ANIMAL         80
#define EGO_SLAY_EVIL           81
#define EGO_SLAY_UNDEAD         82
#define EGO_SLAY_DEMON          83
#define EGO_SLAY_ORC            84
#define EGO_SLAY_TROLL          85
#define EGO_SLAY_GIANT          86
#define EGO_SLAY_DRAGON         87
#define EGO_KILL_ANIMAL         88
#define EGO_KILL_EVIL           89
#define EGO_KILL_UNDEAD         90
#define EGO_KILL_DEMON          91
#define EGO_KILL_ORC            92
#define EGO_KILL_TROLL          93
#define EGO_KILL_GIANT          94
#define EGO_KILL_DRAGON         95
#define EGO_VAMPIRIC            96
/* xxx */
/* xxx */
#define EGO_TRUMP               98
#define EGO_PATTERN             99
#define EGO_DIGGING             100
/* xxx */
#define EGO_MORGUL              102
/* xxx */

/* Bows */
#define EGO_ACCURACY            104
#define EGO_VELOCITY            105
/* xxx */
/* xxx */
#define EGO_EXTRA_MIGHT         108
#define EGO_EXTRA_SHOTS         109
/* xxx */
/* xxx */

/* Ammo */
#define EGO_HURT_ANIMAL         112
#define EGO_HURT_EVIL           113
/* xxx */
/* xxx */
/* xxx */
#define EGO_RETURNING           117
#define EGO_EXPLOSION           118
#define EGO_HURT_DRAGON         119
#define EGO_SLAYING_BOLT        120
#define EGO_LIGHTNING_BOLT      121
#define EGO_FLAME               122
#define EGO_FROST               123
#define EGO_WOUNDING            124
#define EGO_BACKBITING          125
#define EGO_SHATTERED           126
#define EGO_BLASTED             127


/*** Object "tval" and "sval" codes ***/


/*
 * The values for the "tval" field of various objects.
 *
 * This value is the primary means by which items are sorted in the
 * player inventory, followed by "sval" and "cost".
 *
 * Note that as of 2.7.8, the "item flags" apply to all items, though
 * only armor and weapons and a few other items use any of these flags.
 */

#define TV_ANY			 0		/* Used for matching all objects */
#define TV_SKELETON      1		/* Skeletons ('~') */
#define TV_BOTTLE        2		/* Empty bottles ('!') */
#define TV_JUNK          3		/* Sticks, Pottery, etc ('~') */
#define TV_SPIKE         5		/* Spikes ('~') */
#define TV_CHEST         7		/* Chests ('&') */
#define TV_FIGURINE      8		/* Magical figurines */
#define TV_STATUE        9		/* Statue */
/*#define TV_CORPSE       10  */ /* Corpses are now fields */
#define TV_SHOT         16		/* Ammo for slings */
#define TV_ARROW        17		/* Ammo for bows */
#define TV_BOLT         18		/* Ammo for x-bows */
#define TV_BOW          19		/* Slings/Bows/Xbows */
#define TV_DIGGING      20		/* Shovels/Picks */
#define TV_HAFTED       21		/* Priest Weapons */
#define TV_POLEARM      22		/* Axes and Pikes */
#define TV_SWORD        23		/* Edged Weapons */
#define TV_BOOTS        30		/* Boots */
#define TV_GLOVES       31		/* Gloves */
#define TV_HELM         32		/* Helms */
#define TV_CROWN        33		/* Crowns */
#define TV_SHIELD       34		/* Shields */
#define TV_CLOAK        35		/* Cloaks */
#define TV_SOFT_ARMOR   36		/* Soft Armor */
#define TV_HARD_ARMOR   37		/* Hard Armor */
#define TV_DRAG_ARMOR   38		/* Dragon Scale Mail */
#define TV_LITE         39		/* Lites (including Specials) */
#define TV_AMULET       40		/* Amulets (including Specials) */
#define TV_RING         45		/* Rings (including Specials) */
#define TV_STAFF        55
#define TV_WAND         65
#define TV_ROD          66
#define TV_SCROLL       70
#define TV_POTION       75
#define TV_FLASK        77
#define TV_FOOD         80
#define TV_LIFE_BOOK    90
#define TV_SORCERY_BOOK 91
#define TV_NATURE_BOOK  92
#define TV_CHAOS_BOOK   93
#define TV_DEATH_BOOK   94
#define TV_TRUMP_BOOK   95
#define TV_ARCANE_BOOK  96
#define TV_GOLD         100		/* Gold can only be picked up by players */

#define TV_BOOKS_MIN    TV_LIFE_BOOK	/* First tval of spellbooks */
#define TV_BOOKS_MAX    TV_ARCANE_BOOK	/* Last tval of spellbooks */

/* Any subvalue */
#define SV_ANY 					255

/* The "sval" codes for TV_FIGURINE */
#define SV_FIGURINE_NORMAL		0

/* The "sval" codes for TV_STATUE */
#define SV_WOODEN_STATUE		0
#define SV_CLAY_STATUE			1
#define SV_STONE_STATUE			2
#define SV_IRON_STATUE			3
#define SV_COPPER_STATUE		4
#define SV_SILVER_STATUE		5
#define SV_GOLDEN_STATUE		6
#define SV_IVORY_STATUE			7
#define SV_MITHRIL_STATUE		8
#define SV_ORNATE_STATUE		9

/* The "sval" codes for TV_SHOT/TV_ARROW/TV_BOLT */
#define SV_AMMO_LIGHT                    0	/* pebbles, flight arrows */
#define SV_AMMO_NORMAL                   1	/* shots, arrows, bolts */
#define SV_AMMO_HEAVY                    2	/* sheaf + seeker arrows and bolts, mithril shots */

/* The "sval" codes for TV_BOW (note information in "sval") */
#define SV_SLING                         2	/* (x2) */
#define SV_SHORT_BOW                    12	/* (x2) */
#define SV_LONG_BOW                     13	/* (x3 or x2) */
#define SV_LIGHT_XBOW                   23	/* (x4) */
#define SV_HEAVY_XBOW                   24	/* (x5) */

/* The "sval" codes for TV_DIGGING */
#define SV_SHOVEL                        1
#define SV_GNOMISH_SHOVEL                2
#define SV_DWARVEN_SHOVEL                3
#define SV_PICK                          4
#define SV_ORCISH_PICK                   5
#define SV_DWARVEN_PICK                  6
#define SV_MATTOCK                       7

/* 
 * Do not put the damage dice of the weapons or the AC of armour here.
 * The values rapidly diverge from what is in k_info.txt
 * as they are tweaked.
 */

/* The "sval" values for TV_HAFTED */
#define SV_CLUB                          1
#define SV_WHIP                          2
#define SV_QUARTERSTAFF                  3
#define SV_NUNCHAKU                      4
#define SV_MACE                          5
#define SV_BALL_AND_CHAIN                6
#define SV_JO_STAFF                      7
#define SV_WAR_HAMMER                    8
#define SV_THREE_PIECE_ROD              11
#define SV_MORNING_STAR                 12
#define SV_FLAIL                        13
#define SV_BO_STAFF                     14
#define SV_LEAD_FILLED_MACE             15
#define SV_TETSUBO                      16
#define SV_TWO_HANDED_FLAIL             18
#define SV_GREAT_HAMMER                 19
#define SV_MACE_OF_DISRUPTION           20
#define SV_WHIP_OF_ENTANGLEMENT         21
#define SV_HAMMER_OF_RETURNING          22
#define SV_GROND                        50

/* The "sval" values for TV_POLEARM */
#define SV_HATCHET                       1
#define SV_SPEAR                         2
#define SV_SICKLE                        3
#define SV_AWL_PIKE                      4
#define SV_TRIDENT                       5
#define SV_FAUCHARD                      6
#define SV_BROAD_SPEAR                   7
#define SV_PIKE                          8
#define SV_NAGINATA                      9
#define SV_BEAKED_AXE                   10
#define SV_BROAD_AXE                    11
#define SV_LUCERNE_HAMMER               12
#define SV_GLAIVE                       13
#define SV_LAJATANG                     14
#define SV_HALBERD                      15
#define SV_GUISARME                     16
#define SV_SCYTHE                       17
#define SV_LANCE                        20
#define SV_BATTLE_AXE                   22
#define SV_GREAT_AXE                    25
#define SV_TRIFURCATE_SPEAR             26
#define SV_LOCHABER_AXE                 28
#define SV_HEAVY_LANCE                  29
#define SV_SCYTHE_OF_SLICING            30

/* The "sval" codes for TV_SWORD */
#define SV_BROKEN_DAGGER                 1
#define SV_BROKEN_SWORD                  2
#define SV_DAGGER                        4
#define SV_MAIN_GAUCHE                   5
#define SV_TANTO                         6
#define SV_RAPIER                        7
#define SV_SMALL_SWORD                   8
#define SV_BASILLARD                     9
#define SV_SHORT_SWORD                  10
#define SV_SABRE                        11
#define SV_CUTLASS                      12
#define SV_WAKIZASHI                    13
#define SV_KHOPESH                      14
#define SV_TULWAR                       15
#define SV_BROAD_SWORD                  16
#define SV_LONG_SWORD                   17
#define SV_SCIMITAR                     18
#define SV_NINJATO                      19
#define SV_KATANA                       20
#define SV_BASTARD_SWORD                21
#define SV_GREAT_SCIMITAR               22
#define SV_CLAYMORE                     23
#define SV_ESPADON                      24
#define SV_TWO_HANDED_SWORD             25
#define SV_FLAMBERGE                    26
#define SV_NO_DACHI                     27
#define SV_EXECUTIONERS_SWORD           28
#define SV_ZWEIHANDER                   29
#define SV_BLADE_OF_CHAOS               30
#define SV_DIAMOND_EDGE                 31
#define SV_ELFBLADE                     32
#define SV_PSIBLADE                     33

/* The "sval" codes for TV_SHIELD */
#define SV_SMALL_LEATHER_SHIELD          2
#define SV_SMALL_METAL_SHIELD            3
#define SV_LARGE_LEATHER_SHIELD          4
#define SV_LARGE_METAL_SHIELD            5
#define SV_DRAGON_SHIELD                 6
#define SV_SHIELD_OF_DEFLECTION         10

/* The "sval" codes for TV_HELM */
#define SV_HARD_LEATHER_CAP              2
#define SV_METAL_CAP                     3
#define SV_JINGASA                       4
#define SV_IRON_HELM                     5
#define SV_STEEL_HELM                    6
#define SV_DRAGON_HELM                   7
#define SV_KABUTO                        8
#define SV_IRON_CROWN                   10
#define SV_GOLDEN_CROWN                 11
#define SV_JEWELED_CROWN                12
#define SV_MORGOTH                      50

/* The "sval" codes for TV_BOOTS */
#define SV_PAIR_OF_SOFT_LEATHER_BOOTS    2
#define SV_PAIR_OF_HARD_LEATHER_BOOTS    3
#define SV_PAIR_OF_METAL_SHOD_BOOTS      6

/* The "sval" codes for TV_CLOAK */
#define SV_CLOAK                         1
#define SV_ELVEN_CLOAK                   2
#define SV_FUR_CLOAK                     3
#define SV_SHADOW_CLOAK                  6

/* The "sval" codes for TV_GLOVES */
#define SV_SET_OF_LEATHER_GLOVES         1
#define SV_SET_OF_GAUNTLETS              2
#define SV_SET_OF_CESTI                  5

/* The "sval" codes for TV_SOFT_ARMOR */
#define SV_T_SHIRT                       0
#define SV_FILTHY_RAG                    1
#define SV_ROBE                          2
#define SV_PAPER_ARMOR                   3
#define SV_SOFT_LEATHER_ARMOR            4
#define SV_SOFT_STUDDED_LEATHER          5
#define SV_HARD_LEATHER_ARMOR            6
#define SV_HARD_STUDDED_LEATHER          7
#define SV_RHINO_HIDE_ARMOR              8
#define SV_CORD_ARMOR                    9
#define SV_PADDED_ARMOR                 10
#define SV_LEATHER_SCALE_MAIL           11
#define SV_LEATHER_JACK                 12
#define SV_STONE_AND_HIDE_ARMOR         15
#define SV_HAGAROMO			16

/* The "sval" codes for TV_HARD_ARMOR */
#define SV_RUSTY_CHAIN_MAIL              1
#define SV_RING_MAIL                     2
#define SV_METAL_SCALE_MAIL              3
#define SV_CHAIN_MAIL                    4
#define SV_DOUBLE_RING_MAIL              5
#define SV_AUGMENTED_CHAIN_MAIL          6
#define SV_DOUBLE_CHAIN_MAIL             7
#define SV_BAR_CHAIN_MAIL                8
#define SV_METAL_BRIGANDINE_ARMOUR       9
#define SV_SPLINT_MAIL                  10
#define SV_DO_MARU                      11
#define SV_PARTIAL_PLATE_ARMOUR         12
#define SV_METAL_LAMELLAR_ARMOUR        13
#define SV_HARAMAKIDO                   14
#define SV_FULL_PLATE_ARMOUR            15
#define SV_O_YOROI                      16
#define SV_RIBBED_PLATE_ARMOUR          18
#define SV_MITHRIL_CHAIN_MAIL           20
#define SV_MITHRIL_PLATE_MAIL           25
#define SV_ADAMANTITE_PLATE_MAIL        30

/* The "sval" codes for TV_DRAG_ARMOR */
#define SV_DRAGON_BLACK                  1
#define SV_DRAGON_BLUE                   2
#define SV_DRAGON_WHITE                  3
#define SV_DRAGON_RED                    4
#define SV_DRAGON_GREEN                  5
#define SV_DRAGON_MULTIHUED              6
#define SV_DRAGON_SHINING               10
#define SV_DRAGON_LAW                   12
#define SV_DRAGON_BRONZE                14
#define SV_DRAGON_GOLD                  16
#define SV_DRAGON_CHAOS                 18
#define SV_DRAGON_BALANCE               20
#define SV_DRAGON_POWER                 30

/* The sval codes for TV_LITE */
#define SV_LITE_TORCH                    0
#define SV_LITE_LANTERN                  1
#define SV_LITE_GALADRIEL                4
#define SV_LITE_ELENDIL                  5
#define SV_LITE_THRAIN                   6

/* The "sval" codes for TV_AMULET */
#define SV_AMULET_DOOM                   0
#define SV_AMULET_TELEPORT               1
#define SV_AMULET_BERSERK                2
#define SV_AMULET_SLOW_DIGEST            3
#define SV_AMULET_RESIST_ACID            4
#define SV_AMULET_SEARCHING              5
#define SV_AMULET_WISDOM                 6
#define SV_AMULET_CHARISMA               7
#define SV_AMULET_THE_MAGI               8
#define SV_AMULET_REFLECTION             9
#define SV_AMULET_CARLAMMAS             10
#define SV_AMULET_INGWE                 11
#define SV_AMULET_DWARVES               12
#define SV_AMULET_NO_MAGIC              13
#define SV_AMULET_NO_TELE               14
#define SV_AMULET_RESISTANCE            15
#define SV_AMULET_PROT_EVIL             16
#define SV_AMULET_PROT_UNDEAD           17
#define SV_AMULET_LUCK                  18
#define SV_AMULET_SUSTENANCE            19

/* The sval codes for TV_RING */
#define SV_RING_WOE                      0
#define SV_RING_AGGRAVATION              1
#define SV_RING_WEAKNESS                 2
#define SV_RING_STUPIDITY                3
#define SV_RING_TELEPORTATION            4
#define SV_RING_SLOW_DIGESTION           6
#define SV_RING_FEATHER_FALL             7
#define SV_RING_RESIST_FIRE              8
#define SV_RING_RESIST_COLD              9
#define SV_RING_SUSTAIN_STR             10
#define SV_RING_SUSTAIN_INT             11
#define SV_RING_SUSTAIN_WIS             12
#define SV_RING_SUSTAIN_DEX             13
#define SV_RING_SUSTAIN_CON             14
#define SV_RING_SUSTAIN_CHR             15
#define SV_RING_PROTECTION              16
#define SV_RING_ACID                    17
#define SV_RING_FLAMES                  18
#define SV_RING_ICE                     19
#define SV_RING_RESIST_POIS             20
#define SV_RING_FREE_ACTION             21
#define SV_RING_SEE_INVIS               22
#define SV_RING_SEARCHING               23
#define SV_RING_STR                     24
#define SV_RING_INT                     25
#define SV_RING_DEX                     26
#define SV_RING_CON                     27
#define SV_RING_ACCURACY                28
#define SV_RING_DAMAGE                  29
#define SV_RING_SLAYING                 30
#define SV_RING_SPEED                   31
#define SV_RING_BARAHIR                 32
#define SV_RING_TULKAS                  33
#define SV_RING_NARYA                   34
#define SV_RING_NENYA                   35
#define SV_RING_VILYA                   36
#define SV_RING_POWER                   37
#define SV_RING_RES_FEAR                38
#define SV_RING_RES_LD                  39
#define SV_RING_RES_NETHER              40
#define SV_RING_RES_NEXUS               41
#define SV_RING_RES_SOUND               42
#define SV_RING_RES_CONFUSION           43
#define SV_RING_RES_SHARDS              44
#define SV_RING_RES_DISENCHANT          45
#define SV_RING_RES_CHAOS               46
#define SV_RING_RES_BLINDNESS           47
#define SV_RING_LORDLY                  48
#define SV_RING_ATTACKS                 49
#define SV_RING_ELEMENTS				50
#define SV_RING_RES_FIRE_COLD           51
#define SV_RING_CAT                     52
#define SV_RING_FATE                    53
#define SV_RING_WIZARDRY                54

/* The "sval" codes for TV_STAFF */
#define SV_STAFF_DARKNESS                0
#define SV_STAFF_SLOWNESS                1
#define SV_STAFF_HASTE_MONSTERS          2
#define SV_STAFF_SUMMONING               3
#define SV_STAFF_TELEPORTATION           4
#define SV_STAFF_IDENTIFY                5
#define SV_STAFF_REMOVE_CURSE            6
#define SV_STAFF_STARLITE                7
#define SV_STAFF_LITE                    8
#define SV_STAFF_MAPPING                 9
#define SV_STAFF_DETECT_GOLD            10
#define SV_STAFF_DETECT_ITEM            11
#define SV_STAFF_DETECT_TRAP            12
#define SV_STAFF_DETECT_DOOR            13
#define SV_STAFF_DETECT_INVIS           14
#define SV_STAFF_DETECT_EVIL            15
#define SV_STAFF_CURE_LIGHT             16
#define SV_STAFF_CURING                 17
#define SV_STAFF_HEALING                18
#define SV_STAFF_THE_MAGI               19
#define SV_STAFF_SLEEP_MONSTERS         20
#define SV_STAFF_SLOW_MONSTERS          21
#define SV_STAFF_SPEED                  22
#define SV_STAFF_PROBING                23
#define SV_STAFF_DISPEL_EVIL            24
#define SV_STAFF_POWER                  25
#define SV_STAFF_HOLINESS               26
#define SV_STAFF_GENOCIDE               27
#define SV_STAFF_EARTHQUAKES            28
#define SV_STAFF_DESTRUCTION            29


/* The "sval" codes for TV_WAND */
#define SV_WAND_HEAL_MONSTER             0
#define SV_WAND_HASTE_MONSTER            1
#define SV_WAND_CLONE_MONSTER            2
#define SV_WAND_TELEPORT_AWAY            3
#define SV_WAND_DISARMING                4
#define SV_WAND_TRAP_DOOR_DEST           5
#define SV_WAND_STONE_TO_MUD             6
#define SV_WAND_LITE                     7
#define SV_WAND_SLEEP_MONSTER            8
#define SV_WAND_SLOW_MONSTER             9
#define SV_WAND_CONFUSE_MONSTER         10
#define SV_WAND_FEAR_MONSTER            11
#define SV_WAND_DRAIN_LIFE              12
#define SV_WAND_POLYMORPH               13
#define SV_WAND_STINKING_CLOUD          14
#define SV_WAND_MAGIC_MISSILE           15
#define SV_WAND_ACID_BOLT               16
#define SV_WAND_CHARM_MONSTER           17
#define SV_WAND_FIRE_BOLT               18
#define SV_WAND_COLD_BOLT               19
#define SV_WAND_ACID_BALL               20
#define SV_WAND_ELEC_BALL               21
#define SV_WAND_FIRE_BALL               22
#define SV_WAND_COLD_BALL               23
#define SV_WAND_WONDER                  24
#define SV_WAND_ANNIHILATION            25
#define SV_WAND_DRAGON_FIRE             26
#define SV_WAND_DRAGON_COLD             27
#define SV_WAND_DRAGON_BREATH           28
#define SV_WAND_ROCKETS                 29

/* The "sval" codes for TV_ROD */
#define SV_ROD_DETECT_TRAP               0
#define SV_ROD_DETECT_DOOR               1
#define SV_ROD_IDENTIFY                  2
#define SV_ROD_RECALL                    3
#define SV_ROD_ILLUMINATION              4
#define SV_ROD_MAPPING                   5
#define SV_ROD_DETECTION                 6
#define SV_ROD_PROBING                   7
#define SV_ROD_CURING                    8
#define SV_ROD_HEALING                   9
#define SV_ROD_RESTORATION              10
#define SV_ROD_SPEED                    11
#define SV_ROD_PESTICIDE                12
#define SV_ROD_TELEPORT_AWAY            13
#define SV_ROD_DISARMING                14
#define SV_ROD_LITE                     15
#define SV_ROD_SLEEP_MONSTER            16
#define SV_ROD_SLOW_MONSTER             17
#define SV_ROD_DRAIN_LIFE               18
#define SV_ROD_POLYMORPH                19
#define SV_ROD_ACID_BOLT                20
#define SV_ROD_ELEC_BOLT                21
#define SV_ROD_FIRE_BOLT                22
#define SV_ROD_COLD_BOLT                23
#define SV_ROD_ACID_BALL                24
#define SV_ROD_ELEC_BALL                25
#define SV_ROD_FIRE_BALL                26
#define SV_ROD_COLD_BALL                27
#define SV_ROD_HAVOC                    28


/* The "sval" codes for TV_SCROLL */

#define SV_SCROLL_DARKNESS               0
#define SV_SCROLL_AGGRAVATE_MONSTER      1
#define SV_SCROLL_CURSE_ARMOR            2
#define SV_SCROLL_CURSE_WEAPON           3
#define SV_SCROLL_SUMMON_MONSTER         4
#define SV_SCROLL_SUMMON_UNDEAD          5
/* xxx (summon?) */
#define SV_SCROLL_TRAP_CREATION          7
#define SV_SCROLL_PHASE_DOOR             8
#define SV_SCROLL_TELEPORT               9
#define SV_SCROLL_TELEPORT_LEVEL        10
#define SV_SCROLL_WORD_OF_RECALL        11
#define SV_SCROLL_IDENTIFY              12
#define SV_SCROLL_STAR_IDENTIFY         13
#define SV_SCROLL_REMOVE_CURSE          14
#define SV_SCROLL_STAR_REMOVE_CURSE     15
#define SV_SCROLL_ENCHANT_ARMOR         16
#define SV_SCROLL_ENCHANT_WEAPON_TO_HIT 17
#define SV_SCROLL_ENCHANT_WEAPON_TO_DAM 18
/* xxx enchant missile? */
#define SV_SCROLL_STAR_ENCHANT_ARMOR    20
#define SV_SCROLL_STAR_ENCHANT_WEAPON   21
#define SV_SCROLL_RECHARGING            22
#define SV_SCROLL_MUNDANITY             23
#define SV_SCROLL_LIGHT                 24
#define SV_SCROLL_MAPPING               25
#define SV_SCROLL_DETECT_GOLD           26
#define SV_SCROLL_DETECT_ITEM           27
#define SV_SCROLL_DETECT_TRAP           28
#define SV_SCROLL_DETECT_DOOR           29
#define SV_SCROLL_DETECT_INVIS          30
/* xxx (detect evil?) */
#define SV_SCROLL_SATISFY_HUNGER        32
#define SV_SCROLL_BLESSING              33
#define SV_SCROLL_HOLY_CHANT            34
#define SV_SCROLL_HOLY_PRAYER           35
#define SV_SCROLL_MONSTER_CONFUSION     36
#define SV_SCROLL_PROTECTION_FROM_EVIL  37
#define SV_SCROLL_RUNE_OF_PROTECTION    38
#define SV_SCROLL_TRAP_DOOR_DESTRUCTION 39
/* xxx */
#define SV_SCROLL_STAR_DESTRUCTION      41
#define SV_SCROLL_DISPEL_UNDEAD         42
/* xxx */
#define SV_SCROLL_GENOCIDE              44
#define SV_SCROLL_MASS_GENOCIDE         45
#define SV_SCROLL_ACQUIREMENT           46
#define SV_SCROLL_STAR_ACQUIREMENT      47
#define SV_SCROLL_FIRE                  48
#define SV_SCROLL_ICE                   49
#define SV_SCROLL_CHAOS                 50
#define SV_SCROLL_RUMOR                 51
#define SV_SCROLL_ARTIFACT              52

/* The "sval" codes for TV_POTION */
#define SV_POTION_WATER                  0
#define SV_POTION_APPLE_JUICE            1
#define SV_POTION_SLIME_MOLD             2
/* xxx (fixed color) */
#define SV_POTION_SLOWNESS               4
#define SV_POTION_SALT_WATER             5
#define SV_POTION_POISON                 6
#define SV_POTION_BLINDNESS              7
/* xxx */
#define SV_POTION_CONFUSION              9
/* xxx */
#define SV_POTION_SLEEP                 11
/* xxx */
#define SV_POTION_LOSE_MEMORIES         13
/* xxx */
#define SV_POTION_RUINATION             15
#define SV_POTION_DEC_STR               16
#define SV_POTION_DEC_INT               17
#define SV_POTION_DEC_WIS               18
#define SV_POTION_DEC_DEX               19
#define SV_POTION_DEC_CON               20
#define SV_POTION_DEC_CHR               21
#define SV_POTION_DETONATIONS           22
#define SV_POTION_DEATH                 23
#define SV_POTION_INFRAVISION           24
#define SV_POTION_DETECT_INVIS          25
#define SV_POTION_SLOW_POISON           26
#define SV_POTION_CURE_POISON           27
#define SV_POTION_BOLDNESS              28
#define SV_POTION_SPEED                 29
#define SV_POTION_RESIST_HEAT           30
#define SV_POTION_RESIST_COLD           31
#define SV_POTION_HEROISM               32
#define SV_POTION_BERSERK_STRENGTH      33
#define SV_POTION_CURE_LIGHT            34
#define SV_POTION_CURE_SERIOUS          35
#define SV_POTION_CURE_CRITICAL         36
#define SV_POTION_HEALING               37
#define SV_POTION_STAR_HEALING          38
#define SV_POTION_LIFE                  39
#define SV_POTION_RESTORE_MANA          40
#define SV_POTION_RESTORE_EXP           41
#define SV_POTION_RES_STR               42
#define SV_POTION_RES_INT               43
#define SV_POTION_RES_WIS               44
#define SV_POTION_RES_DEX               45
#define SV_POTION_RES_CON               46
#define SV_POTION_RES_CHR               47
#define SV_POTION_INC_STR               48
#define SV_POTION_INC_INT               49
#define SV_POTION_INC_WIS               50
#define SV_POTION_INC_DEX               51
#define SV_POTION_INC_CON               52
#define SV_POTION_INC_CHR               53
/* xxx */
#define SV_POTION_AUGMENTATION          55
#define SV_POTION_ENLIGHTENMENT         56
#define SV_POTION_STAR_ENLIGHTENMENT    57
#define SV_POTION_SELF_KNOWLEDGE        58
#define SV_POTION_EXPERIENCE            59
#define SV_POTION_RESISTANCE            60
#define SV_POTION_CURING                61
#define SV_POTION_INVULNERABILITY       62
#define SV_POTION_NEW_LIFE              63

/* The "sval" codes for TV_FOOD */
#define SV_FOOD_POISON                   0
#define SV_FOOD_BLINDNESS                1
#define SV_FOOD_PARANOIA                 2
#define SV_FOOD_CONFUSION                3
#define SV_FOOD_HALLUCINATION            4
#define SV_FOOD_PARALYSIS                5
#define SV_FOOD_WEAKNESS                 6
#define SV_FOOD_SICKNESS                 7
#define SV_FOOD_STUPIDITY                8
#define SV_FOOD_NAIVETY                  9
#define SV_FOOD_UNHEALTH                10
#define SV_FOOD_DISEASE                 11
#define SV_FOOD_CURE_POISON             12
#define SV_FOOD_CURE_BLINDNESS          13
#define SV_FOOD_CURE_PARANOIA           14
#define SV_FOOD_CURE_CONFUSION          15
#define SV_FOOD_CURE_SERIOUS            16
#define SV_FOOD_RESTORE_STR             17
#define SV_FOOD_RESTORE_CON             18
#define SV_FOOD_RESTORING               19
/* many missing mushrooms */
#define SV_FOOD_BISCUIT                 32
#define SV_FOOD_JERKY                   33
#define SV_FOOD_RATION                  35
#define SV_FOOD_SLIME_MOLD              36
#define SV_FOOD_WAYBREAD                37
#define SV_FOOD_PINT_OF_ALE             38
#define SV_FOOD_PINT_OF_WINE            39


/*
 * Special "sval" limit -- first "normal" food
 */
#define SV_FOOD_MIN_FOOD                32

/*
 * Special "sval" limit -- first "aimed" rod
 */
#define SV_ROD_MIN_DIRECTION    12

/*
 * Special "sval" limit -- first "large" chest
 */
#define SV_CHEST_MIN_LARGE      4

/*
 * Special "sval" limit -- first "good" magic/prayer book
 */
#define SV_BOOK_MIN_GOOD    2


#define OBJ_GOLD_LIST   480		/* First "gold" entry */
#define MAX_GOLD        18		/* Number of "gold" entries */

/*
 * Object creation flags
 * These are the values passable to apply_magic
 */
#define OC_NONE			0x00
#define OC_NORMAL		0x01
#define OC_FORCE_BAD	0x02
#define OC_FORCE_GOOD	0x04


/*** General flag values ***/


/*
 * Special cave grid flags
 */
#define CAVE_DUM1       0x01
#define CAVE_GLOW       0x02	/* self-illuminating */
#define CAVE_ICKY       0x04	/* part of a vault */
#define CAVE_ROOM       0x08	/* part of a room */
#define CAVE_DUM2       0x10
#define CAVE_MNLT       0x20	/* Illuminated by monster */
#define CAVE_TEMP       0x40	/* temp flag */
#define CAVE_XTRA       0x80	/* misc flag */


/*
 * Cave grid flags that are player-specific
 *
 * This data structure will eventually be moved into the players struct.
 */
#define GRID_DUM1		0x01
#define GRID_VIEW		0x02	/* In LOS */
#define GRID_SEEN		0x04	/* In LOS + Lit in some way */
#define GRID_DTCT		0x08	/* Detected for traps */
#define GRID_LITE		0x10	/* Lit by torchlight */
#define GRID_DUM3		0x20
#define GRID_DUM4		0x40
#define GRID_DUM5		0x80


/*
 * Region flags
 */
#define REGION_NULL		0x00
#define REGION_CAVE		0x01	/* Cave region */
#define REGION_OVER		0x02	/* Overlay region */
#define REGION_DUM2		0x04


/*
 * Feature flags
 */
#define FF_BLOCK		0x01	/* Blocks movement + los */
#define FF_HALF_LOS		0x02	/* Half-blocks los */
#define FF_USE_TRANS	0x04	/* Use transparency light effects */
#define FF_ICKY			0x08	/* Terrain can not have objects */
#define FF_PERM			0x10	/* Permanent terrain */
#define FF_OBJECT		0x20	/* Terrain is described like an object */
#define FF_PATTERN		0x40	/* The pattern */
#define FF_MARK			0x80	/* Remember tile if seen */

/*
 * Bit flags for the "project()" function
 *
 *   JUMP: Jump directly to the target location (this is a hack)
 *   BEAM: Work as a beam weapon (affect every grid passed through)
 *   THRU: Continue "through" the target (used for "bolts"/"beams")
 *   STOP: Stop as soon as we hit a monster (used for "bolts")
 *   GRID: Affect each grid in the "blast area" in some way
 *   ITEM: Affect each object in the "blast area" in some way
 *   KILL: Affect each monster in the "blast area" in some way
 *   HIDE: Hack -- disable "visual" feedback from projection
 *   FRND: Stop if hit a friendly monster / player.
 *	 MFLD: Make fields using GF_XXX value as type. (unused as of yet)
 */
#define PROJECT_JUMP    0x0001
#define PROJECT_BEAM    0x0002
#define PROJECT_THRU    0x0004
#define PROJECT_STOP    0x0008
#define PROJECT_GRID    0x0010
#define PROJECT_ITEM    0x0020
#define PROJECT_KILL    0x0040
#define PROJECT_HIDE    0x0080
#define PROJECT_FRND	0x0100
#define PROJECT_MFLD	0x0200

/*
 * Bit flags for the "enchant()" function
 */
#define ENCH_TOHIT      0x01	/* Enchant to hit */
#define ENCH_TODAM      0x02	/* Enchant to damage */
#define ENCH_TOAC       0x04	/* Enchant to AC */
#define ENCH_FORCE      0x08	/* Force enchantment */

/*
 * Bit flags for the "target_set" function
 *
 *      KILL: Target monsters
 *      LOOK: Describe grid fully
 *      XTRA: Currently unused flag
 *      GRID: Select from all grids
 *		HOST: Select hostile creatures only.
 */
#define TARGET_KILL             0x01
#define TARGET_LOOK             0x02
#define TARGET_XTRA             0x04
#define TARGET_GRID             0x08
#define TARGET_HOST				0x10


/*
 * Some bit-flags for the "smart" field
 */
#define SM_RES_ACID             0x00000001
#define SM_RES_ELEC             0x00000002
#define SM_RES_FIRE             0x00000004
#define SM_RES_COLD             0x00000008
#define SM_RES_POIS             0x00000010
#define SM_RES_NETH             0x00000020
#define SM_RES_LITE             0x00000040
#define SM_RES_DARK             0x00000080
#define SM_RES_FEAR             0x00000100
#define SM_RES_CONF             0x00000200
#define SM_RES_CHAOS            0x00000400
#define SM_RES_DISEN            0x00000800
#define SM_RES_BLIND            0x00001000
#define SM_RES_NEXUS            0x00002000
#define SM_RES_SOUND            0x00004000
#define SM_RES_SHARD            0x00008000
#define SM_OPP_ACID             0x00010000
#define SM_OPP_ELEC             0x00020000
#define SM_OPP_FIRE             0x00040000
#define SM_OPP_COLD             0x00080000
#define SM_OPP_POIS             0x00100000
#define SM_MIMIC                0x00200000	/* XXX Unknown Mimic */
#define SM_CLONED               0x00400000	/* XXX Cloned */
#define SM_PET                  0x00800000	/* XXX Pet */
#define SM_IMM_ACID             0x01000000
#define SM_IMM_ELEC             0x02000000
#define SM_IMM_FIRE             0x04000000
#define SM_IMM_COLD             0x08000000
#define SM_FRIENDLY             0x10000000	/* XXX Friendly */
#define SM_IMM_REFLECT          0x20000000
#define SM_IMM_FREE             0x40000000
#define SM_IMM_MANA             0x80000000


/*
 * Bit flags for the "get_item" function
 */
#define USE_EQUIP	0x01		/* Allow equip items */
#define USE_INVEN	0x02		/* Allow inven items */
#define USE_FLOOR	0x04		/* Allow floor items */
#define USE_STORE	0x10		/* Selling to store */

/*
 * Bit flags for the "p_ptr->notice" variable
 */
#define PN_COMBINE      0x00000001L	/* Combine the pack */
#define PN_REORDER      0x00000002L	/* Reorder the pack */
/* xxx (many) */


/*
 * Bit flags for the "p_ptr->update" variable
 */
#define PU_BONUS        0x00000001L	/* Calculate bonuses */
#define PU_TORCH        0x00000002L	/* Calculate torch radius */
/* xxx (many) */
#define PU_HP           0x00000010L	/* Calculate chp and mhp */
#define PU_MANA         0x00000020L	/* Calculate csp and msp */
#define PU_SPELLS       0x00000040L	/* Calculate spells */
/* xxx (many) */
#define PU_WEIGHT		0x00000100L	/* Calculate weight of inventory */
/* xxx (many) */
#define PU_MAP			0x00001000L	/* Notice change in screen size */
/* xxx (many) */
#define PU_VIEW         0x00100000L	/* Update view */
#define PU_MON_LITE		0x00200000L	/* Monster illumination */
#define PU_WIZ_FIX		0x00400000L	/* Fix up after a wiz_lite() */
/* xxx */
#define PU_MONSTERS     0x01000000L	/* Update monsters */
#define PU_DISTANCE     0x02000000L	/* Update distances */
/* xxx */
#define PU_FLOW         0x10000000L	/* Update flow */
/* xxx (many) */


/*
 * Bit flags for the "p_ptr->change" variable
 */
#define PC_WIZ_LITE		0x00000001L	/* Redraw map after a wiz_lite() */
#define PC_SHIMMER		0x00000002L /* Shimmer monsters */
#define PC_REPAIR		0x00000004L	/* Repair monsters */
#define PC_MUTATE		0x00000008L	/* Mutate player (on birth) */


/*
 * Bit flags for the "p_ptr->redraw" variable
 */
#define PR_MISC         0x00000001L	/* Display Race/Class */
#define PR_TITLE        0x00000002L	/* Display Title */
#define PR_LEV          0x00000004L	/* Display Level */
#define PR_EXP          0x00000008L	/* Display Experience */
#define PR_STATS        0x00000010L	/* Display Stats */
#define PR_ARMOR        0x00000020L	/* Display Armor */
#define PR_HP           0x00000040L	/* Display Hitpoints */
#define PR_MANA         0x00000080L	/* Display Mana */
#define PR_GOLD         0x00000100L	/* Display Gold */
#define PR_DEPTH        0x00000200L	/* Display Depth */
#define PR_EQUIPPY      0x00000400L	/* Display equippy chars */
#define PR_HEALTH       0x00000800L	/* Display Health Bar */
#define PR_CUT          0x00001000L	/* Display Extra (Cut) */
#define PR_STUN         0x00002000L	/* Display Extra (Stun) */
#define PR_HUNGER       0x00004000L	/* Display Extra (Hunger) */
#define PR_STATUS       0x00008000L	/* Display Status Bar */
#define PR_BLIND        0x00010000L	/* Display Extra (Blind) */
#define PR_CONFUSED     0x00020000L	/* Display Extra (Confused) */
#define PR_AFRAID       0x00040000L	/* Display Extra (Afraid) */
#define PR_POISONED     0x00080000L	/* Display Extra (Poisoned) */
#define PR_STATE        0x00100000L	/* Display Extra (State) */
#define PR_SPEED        0x00200000L	/* Display Extra (Speed) */
#define PR_STUDY        0x00400000L	/* Display Extra (Study) */
/* xxx */
#define PR_EXTRA        0x01000000L	/* Display Extra Info */
#define PR_BASIC        0x02000000L	/* Display Basic Info */
#define PR_MAP          0x04000000L	/* Display Map */
#define PR_WIPE         0x08000000L	/* Hack -- Total Redraw */
/* xxx */
/* xxx */
/* xxx */
/* xxx */


/*
 * Bit flags for the "p_ptr->window" variable (etc)
 */
#define PW_INVEN            0x00000001L	/* Display inven/equip */
#define PW_EQUIP            0x00000002L	/* Display equip/inven */
#define PW_SPELL            0x00000004L	/* Display spell list */
#define PW_PLAYER           0x00000008L	/* Display character */
#define PW_SCRIPT_VARS      0x00000010L	/* Display script messages */
#define PW_SCRIPT_SOURCE    0x00000020L	/* Display script messages */
#define PW_MESSAGE          0x00000040L	/* Display messages */
#define PW_OVERHEAD         0x00000080L	/* Display overhead view */
#define PW_MONSTER          0x00000100L	/* Display monster recall */
#define PW_OBJECT           0x00000200L	/* Display object recall */
#define PW_DUNGEON          0x00000400L	/* Display dungeon view */
#define PW_SNAPSHOT         0x00000800L	/* Display snap-shot */
#define PW_VISIBLE          0x00001000L	/* Display monster visible list */
#define PW_BORG_1           0x00002000L	/* Display borg messages */
#define PW_BORG_2           0x00004000L	/* Display borg status */


/*** General index values ***/


/*
 * Legal restrictions for "summon_specific()"
 */
#define SUMMON_ANT                  11
#define SUMMON_SPIDER               12
#define SUMMON_HOUND                13
#define SUMMON_HYDRA                14
#define SUMMON_ANGEL                15
#define SUMMON_DEMON                16
#define SUMMON_UNDEAD               17
#define SUMMON_DRAGON               18
#define SUMMON_HI_UNDEAD            21
#define SUMMON_HI_DRAGON            22
#define SUMMON_AMBERITES            31
#define SUMMON_UNIQUE               32
#define SUMMON_BIZARRE1             33
#define SUMMON_BIZARRE2             34
#define SUMMON_BIZARRE3             35
#define SUMMON_BIZARRE4             36
#define SUMMON_BIZARRE5             37
#define SUMMON_BIZARRE6             38
#define SUMMON_CYBER                39
#define SUMMON_KIN                  40
#define SUMMON_DAWN                 41
#define SUMMON_ANIMAL               42
#define SUMMON_ANIMAL_RANGER        43
#define SUMMON_HI_UNDEAD_NO_UNIQUES 44
#define SUMMON_HI_DRAGON_NO_UNIQUES 45
#define SUMMON_NO_UNIQUES           46
#define SUMMON_PHANTOM              47
#define SUMMON_ELEMENTAL            48
#define SUMMON_BLUE_HORROR          49



/*
 * Spell types used by project(), and related functions.
 */
#define GF_NONE			0
#define GF_ELEC         1
#define GF_POIS         2
#define GF_ACID         3
#define GF_COLD         4
#define GF_FIRE         5
#define GF_MISSILE      10
#define GF_ARROW        11
#define GF_PLASMA       12
/* Replaced with GF_HOLY_FIRE and GF_HELL_FIRE */
/* #define GF_HOLY_ORB     13 */
#define GF_WATER        14
#define GF_LITE         15
#define GF_DARK         16
#define GF_LITE_WEAK    17
#define GF_DARK_WEAK    18
#define GF_SHARDS       20
#define GF_SOUND        21
#define GF_CONFUSION    22
#define GF_FORCE        23
#define GF_INERTIA      24
#define GF_MANA         26
#define GF_METEOR       27
#define GF_ICE          28
#define GF_CHAOS        30
#define GF_NETHER       31
#define GF_DISENCHANT   32
#define GF_NEXUS        33
#define GF_TIME         34
#define GF_GRAVITY      35
#define GF_KILL_WALL    40
#define GF_KILL_DOOR    41
#define GF_KILL_TRAP    42
#define GF_MAKE_WALL    45
#define GF_MAKE_DOOR    46
#define GF_MAKE_TRAP    47
#define GF_OLD_CLONE    51
#define GF_OLD_POLY     52
#define GF_OLD_HEAL     53
#define GF_OLD_SPEED    54
#define GF_OLD_SLOW     55
#define GF_OLD_CONF		56
#define GF_OLD_SLEEP    57
#define GF_OLD_DRAIN	58
#define GF_NEW_DRAIN	59
#define GF_AWAY_UNDEAD  61
#define GF_AWAY_EVIL    62
#define GF_AWAY_ALL     63
#define GF_TURN_UNDEAD  64
#define GF_TURN_EVIL    65
#define GF_TURN_ALL     66
#define GF_DISP_UNDEAD  67
#define GF_DISP_EVIL    68
#define GF_DISP_ALL 	69
#define GF_DISP_DEMON   70		/* New types for Zangband begin here... */
#define GF_DISP_LIVING  71
#define GF_ROCKET       72
#define GF_NUKE         73
#define GF_MAKE_GLYPH   74
#define GF_STASIS       75
#define GF_STONE_WALL   76
#define GF_DEATH_RAY    77
#define GF_STUN         78
#define GF_HOLY_FIRE    79
#define GF_HELL_FIRE    80
#define GF_DISINTEGRATE 81
#define GF_CHARM        82
#define GF_CONTROL_UNDEAD   83
#define GF_CONTROL_ANIMAL   84
#define GF_PSI			85
#define GF_PSI_DRAIN	86
#define GF_TELEKINESIS  87
#define GF_JAM_DOOR     88
#define GF_DOMINATION   89
#define GF_DISP_GOOD    90
#define MAX_GF			91

/*
 * Some things which induce learning
 */
#define DRS_ACID         1
#define DRS_ELEC         2
#define DRS_FIRE         3
#define DRS_COLD         4
#define DRS_POIS         5
#define DRS_NETH         6
#define DRS_LITE         7
#define DRS_DARK         8
#define DRS_FEAR         9
#define DRS_CONF        10
#define DRS_CHAOS       11
#define DRS_DISEN       12
#define DRS_BLIND       13
#define DRS_NEXUS       14
#define DRS_SOUND       15
#define DRS_SHARD       16
#define DRS_FREE        30
#define DRS_MANA        31
#define DRS_REFLECT		32

/*
 * Game generated inscription indices. These are stored in the object,
 * and are used to index the string array from tables.c.
 */

#define FEEL_NONE              0
#define FEEL_BROKEN            1
#define FEEL_TERRIBLE          2
#define FEEL_WORTHLESS         3
#define FEEL_CURSED            4
#define FEEL_UNCURSED          5
#define FEEL_AVERAGE           6
#define FEEL_GOOD              7
#define FEEL_EXCELLENT         8
#define FEEL_SPECIAL           9
#define FEEL_BAD			   10
#define FEEL_DUBIOUS		   11
#define FEEL_TAINTED		   12

#define FEEL_MAX               13

/*
 * Special "xtra" object powers for ego items and some artifacts
 */

/* Sustain one stat */
#define EGO_XTRA_SUSTAIN        1

/* Resistances */
#define EGO_XTRA_LO_RESIST      2
#define EGO_XTRA_HI_RESIST      3
#define EGO_XTRA_ANY_RESIST     4

/* Special ability */
#define EGO_XTRA_ABILITY        5

/* Special ability OR high resist */
#define EGO_XTRA_POWER          6


/*** Object flag values ***/


/*
 * Chest trap flags (see "tables.c")
 */
#define CHEST_LOSE_STR          0x01
#define CHEST_LOSE_CON          0x02
#define CHEST_POISON            0x04
#define CHEST_PARALYZE          0x08
#define CHEST_EXPLODE           0x10
#define CHEST_SUMMON            0x20



/*
 * Special Object Flags
 */
#define OB_SENSE     0x01		/* Item has been "sensed" */
#define OB_SEEN      0x02		/* Item is seen */
#define OB_EMPTY     0x04		/* Item charges are known */
#define OB_KNOWN     0x08		/* Item abilities are known */
#define OB_STOREB    0x10		/* Item is storebought */
#define OB_MENTAL    0x20		/* Item is *id*'ed */
#define OB_NO_EXP    0x40		/* Item gives no score */
#define OB_DUMMY4    0x80



/*
 * Special Monster Flags (all temporary)
 */
#define MFLAG_VIEW      0x01	/* Monster is in line of sight */
#define MFLAG_TEMP      0x02	/* Monster is marked for project_hack() */
#define MFLAG_XXX2      0x04	/* (unused) */
#define MFLAG_XXX3      0x08	/* (unused) */
#define MFLAG_MOVE      0x10	/* Monster has moved this turn */
#define MFLAG_NICE      0x20	/* Monster is still being nice */
#define MFLAG_SHOW      0x40	/* Monster is recently memorized */
#define MFLAG_MARK      0x80	/* Monster is currently memorized */



/*
 * As of 2.7.8, the "object flags" are valid for all objects, and as
 * of 2.7.9, these flags are not actually stored with the object.
 *
 * Note that "flags1" contains all flags dependant on "pval" (including
 * stat bonuses, but NOT stat sustainers), plus all "extra attack damage"
 * flags (SLAY_XXX and BRAND_XXX).
 *
 * Note that "flags2" contains all "resistances" (including "Stat Sustainers",
 * actual immunities, and resistances).  Note that "Hold Life" is really an
 * "immunity" to ExpLoss, and "Free Action" is "immunity to paralysis".
 *
 * Note that "flags3" contains everything else -- including the three "CURSED"
 * flags, and the "BLESSED" flag, several "item display" parameters, some new
 * flags for powerful Bows, and flags which affect the player in a "general"
 * way (LITE, TELEPATHY, SEE_INVIS, SLOW_DIGEST, REGEN, FEATHER), including
 * all the "general" curses (TELEPORT, AGGRAVATE, EXP_DRAIN).  It also has
 * four new flags called "ITEM_IGNORE_XXX" which lets an item specify that
 * it can not be affected by various forms of destruction.  This is NOT as
 * powerful as actually granting resistance/immunity to the wearer.
 */

#define NUM_TR_SETS 4

#define TR0_STR                 0x00000001L	/* STR += "pval" */
#define TR0_INT                 0x00000002L	/* INT += "pval" */
#define TR0_WIS                 0x00000004L	/* WIS += "pval" */
#define TR0_DEX                 0x00000008L	/* DEX += "pval" */
#define TR0_CON                 0x00000010L	/* CON += "pval" */
#define TR0_CHR                 0x00000020L	/* CHR += "pval" */
#define TR0_XXX1                0x00000040L	/* Later */
#define TR0_SP                  0x00000080L	/* Extra mana */
#define TR0_STEALTH             0x00000100L	/* Stealth += "pval" */
#define TR0_SEARCH              0x00000200L	/* Search += "pval" */
#define TR0_INFRA               0x00000400L	/* Infra += "pval" */
#define TR0_TUNNEL              0x00000800L	/* Tunnel += "pval" */
#define TR0_SPEED               0x00001000L	/* Speed += "pval" */
#define TR0_BLOWS               0x00002000L	/* Blows += "pval" */
#define TR0_CHAOTIC             0x00004000L
#define TR0_VAMPIRIC            0x00008000L
#define TR0_SLAY_ANIMAL         0x00010000L
#define TR0_SLAY_EVIL           0x00020000L
#define TR0_SLAY_UNDEAD         0x00040000L
#define TR0_SLAY_DEMON          0x00080000L
#define TR0_SLAY_ORC            0x00100000L
#define TR0_SLAY_TROLL          0x00200000L
#define TR0_SLAY_GIANT          0x00400000L
#define TR0_SLAY_DRAGON         0x00800000L
#define TR0_KILL_DRAGON         0x01000000L	/* Execute Dragon */
#define TR0_VORPAL              0x02000000L	/* Later */
#define TR0_IMPACT              0x04000000L	/* Cause Earthquakes */
#define TR0_BRAND_POIS          0x08000000L
#define TR0_BRAND_ACID          0x10000000L
#define TR0_BRAND_ELEC          0x20000000L
#define TR0_BRAND_FIRE          0x40000000L
#define TR0_BRAND_COLD          0x80000000L

#define TR1_SUST_STR            0x00000001L
#define TR1_SUST_INT            0x00000002L
#define TR1_SUST_WIS            0x00000004L
#define TR1_SUST_DEX            0x00000008L
#define TR1_SUST_CON            0x00000010L
#define TR1_SUST_CHR            0x00000020L
#define TR1_XXX1                0x00000040L	/* Later */
#define TR1_IM_POIS             0x00000080L
#define TR1_IM_ACID             0x00000100L
#define TR1_IM_ELEC             0x00000200L
#define TR1_IM_FIRE             0x00000400L
#define TR1_IM_COLD             0x00000800L
#define TR1_THROW               0x00001000L	/* Throwing items */
#define TR1_REFLECT             0x00002000L	/* Reflect 'bolts' */
#define TR1_FREE_ACT            0x00004000L	/* Free Action */
#define TR1_HOLD_LIFE           0x00008000L	/* Hold Life */
#define TR1_RES_ACID            0x00010000L
#define TR1_RES_ELEC            0x00020000L
#define TR1_RES_FIRE            0x00040000L
#define TR1_RES_COLD            0x00080000L
#define TR1_RES_POIS            0x00100000L
#define TR1_RES_FEAR            0x00200000L	/* Added for Zangband */
#define TR1_RES_LITE            0x00400000L
#define TR1_RES_DARK            0x00800000L
#define TR1_RES_BLIND           0x01000000L
#define TR1_RES_CONF            0x02000000L
#define TR1_RES_SOUND           0x04000000L
#define TR1_RES_SHARDS          0x08000000L
#define TR1_RES_NETHER          0x10000000L
#define TR1_RES_NEXUS           0x20000000L
#define TR1_RES_CHAOS           0x40000000L
#define TR1_RES_DISEN           0x80000000L

#define TR2_SH_FIRE             0x00000001L	/* Immolation (Fire) */
#define TR2_SH_ELEC             0x00000002L	/* Electric Sheath */
#define TR2_QUESTITEM           0x00000004L	/* quest level item -KMW- */
#define TR2_XXX4                0x00000008L	/* Later */
#define TR2_NO_TELE             0x00000010L	/* Anti-teleportation */
#define TR2_NO_MAGIC            0x00000020L	/* Anti-magic */
#define TR2_XXX7                0x00000040L	/* Later */
#define TR2_TY_CURSE            0x00000080L	/* The Ancient Curse */
#define TR2_EASY_KNOW           0x00000100L	/* Aware -> Known */
#define TR2_HIDE_TYPE           0x00000200L	/* Hide "pval" description */
#define TR2_SHOW_MODS           0x00000400L	/* Always show Tohit/Todam */
#define TR2_INSTA_ART           0x00000800L	/* Item must be an artifact */
#define TR2_FEATHER             0x00001000L	/* Feather Falling */
#define TR2_LITE                0x00002000L	/* Permanent Light */
#define TR2_SEE_INVIS           0x00004000L	/* See Invisible */
#define TR2_TELEPATHY           0x00008000L	/* Telepathy */
#define TR2_SLOW_DIGEST         0x00010000L	/* Item slows down digestion */
#define TR2_REGEN               0x00020000L	/* Item induces regeneration */
#define TR2_XTRA_MIGHT          0x00040000L	/* Bows get extra multiplier */
#define TR2_XTRA_SHOTS          0x00080000L	/* Bows get extra shots */
#define TR2_IGNORE_ACID         0x00100000L	/* Item ignores Acid Damage */
#define TR2_IGNORE_ELEC         0x00200000L	/* Item ignores Elec Damage */
#define TR2_IGNORE_FIRE         0x00400000L	/* Item ignores Fire Damage */
#define TR2_IGNORE_COLD         0x00800000L	/* Item ignores Cold Damage */
#define TR2_ACTIVATE            0x01000000L	/* Item can be activated */
#define TR2_DRAIN_EXP           0x02000000L	/* Item drains Experience */
#define TR2_TELEPORT            0x04000000L	/* Item teleports player */
#define TR2_AGGRAVATE           0x08000000L	/* Item aggravates monsters */
#define TR2_BLESSED             0x10000000L	/* Item is Blessed */
#define TR2_CURSED              0x20000000L	/* Item is Cursed */
#define TR2_HEAVY_CURSE         0x40000000L	/* Item is Heavily Cursed */
#define TR2_PERMA_CURSE         0x80000000L	/* Item is Perma Cursed */


#define TR3_LUCK_10             0x00000001L
#define TR3_WILD_SHOT           0x00000002L
#define TR3_WILD_WALK           0x00000004L
#define TR3_EASY_ENCHANT        0x00000008L
#define TR3_XXX5                0x00000010L
#define TR3_XXX6                0x00000020L
#define TR3_XXX7                0x00000040L
#define TR3_XXX8                0x00000080L
#define TR3_IM_LITE             0x00000100L
#define TR3_IM_DARK             0x00000200L
#define TR3_SH_ACID             0x00000400L
#define TR3_SH_COLD             0x00000800L
#define TR3_MUTATE              0x00001000L
#define TR3_PATRON              0x00002000L
#define TR3_STRANGE_LUCK        0x00004000L
#define TR3_PASS_WALL           0x00008000L
#define TR3_GHOUL_TOUCH         0x00010000L
#define TR3_PSI_CRIT            0x00020000L
#define TR3_RETURN              0x00040000L
#define TR3_EXPLODE             0x00080000L
#define TR3_HURT_ACID           0x00100000L
#define TR3_HURT_ELEC           0x00200000L
#define TR3_HURT_FIRE           0x00400000L
#define TR3_HURT_COLD           0x00800000L
#define TR3_HURT_LITE           0x01000000L
#define TR3_HURT_DARK           0x02000000L
#define TR3_XXX27               0x04000000L
#define TR3_XXX28               0x08000000L
#define TR3_AUTO_CURSE          0x10000000L
#define TR3_DRAIN_STATS         0x20000000L
#define TR3_CANT_EAT            0x40000000L
#define TR3_SLOW_HEAL           0x80000000L


/*
 * Hack -- flag set 1 -- mask for "pval-dependant" flags.
 * Note that all "pval" dependant flags must be in "flags1".
 */
#define TR0_PVAL_MASK \
	(TR0_STR | TR0_INT | TR0_WIS | TR0_DEX | \
     TR0_CON | TR0_CHR | TR0_SP | \
	 TR0_STEALTH | TR0_SEARCH | TR0_INFRA | TR0_TUNNEL | \
     TR0_SPEED | TR0_BLOWS)

/*
 * Flag set 1 -- mask for "easy" flags.
 * These flags are automatically learned if the item is worn.
 */
#define TR0_EASY_MASK \
    (TR0_STR | TR0_INT | TR0_WIS | TR0_DEX | \
     TR0_CON | TR0_CHR | TR0_SP | \
     TR0_INFRA | TR0_SPEED | TR0_BLOWS)

/*
 * Flag set 3 -- mask for "ignore element" flags.
 */
#define TR2_IGNORE_MASK \
	(TR2_IGNORE_ACID | TR2_IGNORE_ELEC | TR2_IGNORE_FIRE | \
	 TR2_IGNORE_COLD )



/* Helpers for the FLAG() macro */
#define TR_STR				0,	TR0_STR
#define TR_INT				0,	TR0_INT
#define TR_WIS  		 	0,  TR0_WIS		  
#define TR_DEX  		 	0,  TR0_DEX		  
#define TR_CON  		 	0,  TR0_CON		  
#define TR_CHR  		 	0,  TR0_CHR 		 
#define TR_XXX1 		 	0,  TR0_XXX1		 
#define TR_SP			 	0,  TR0_SP  		 
#define TR_STEALTH  	 	0,  TR0_STEALTH 	 
#define TR_SEARCH		 	0,  TR0_SEARCH  	 
#define TR_INFRA		 	0,  TR0_INFRA		 
#define TR_TUNNEL		 	0,  TR0_TUNNEL  	 
#define TR_SPEED		 	0,  TR0_SPEED		 
#define TR_BLOWS		 	0,  TR0_BLOWS		 
#define TR_CHAOTIC  	 	0,  TR0_CHAOTIC 	 
#define TR_VAMPIRIC 	 	0,  TR0_VAMPIRIC	 
#define TR_SLAY_ANIMAL   	0,  TR0_SLAY_ANIMAL  
#define TR_SLAY_EVIL	 	0,  TR0_SLAY_EVIL	 
#define TR_SLAY_UNDEAD   	0,  TR0_SLAY_UNDEAD  
#define TR_SLAY_DEMON	 	0,  TR0_SLAY_DEMON   
#define TR_SLAY_ORC 	 	0,  TR0_SLAY_ORC	 
#define TR_SLAY_TROLL	 	0,  TR0_SLAY_TROLL   
#define TR_SLAY_GIANT	 	0,  TR0_SLAY_GIANT   
#define TR_SLAY_DRAGON   	0,  TR0_SLAY_DRAGON  
#define TR_KILL_DRAGON   	0,  TR0_KILL_DRAGON  
#define TR_VORPAL		 	0,  TR0_VORPAL  	 
#define TR_IMPACT		 	0,  TR0_IMPACT  	 
#define TR_BRAND_POIS	 	0,  TR0_BRAND_POIS   
#define TR_BRAND_ACID	 	0,  TR0_BRAND_ACID   
#define TR_BRAND_ELEC	 	0,  TR0_BRAND_ELEC   
#define TR_BRAND_FIRE	 	0,  TR0_BRAND_FIRE   
#define TR_BRAND_COLD	 	0,  TR0_BRAND_COLD   

#define TR_SUST_STR 	 	1,  TR1_SUST_STR	 
#define TR_SUST_INT 	 	1,  TR1_SUST_INT	 
#define TR_SUST_WIS 	 	1,  TR1_SUST_WIS	 
#define TR_SUST_DEX 	 	1,  TR1_SUST_DEX	 
#define TR_SUST_CON 	 	1,  TR1_SUST_CON	 
#define TR_SUST_CHR 	 	1,  TR1_SUST_CHR	 
#define TR_XXX2 		 	1,  TR1_XXX2	   
#define TR_IM_POIS 		 	1,  TR1_IM_POIS	   
#define TR_IM_ACID  	 	1,  TR1_IM_ACID    
#define TR_IM_ELEC  	 	1,  TR1_IM_ELEC    
#define TR_IM_FIRE  	 	1,  TR1_IM_FIRE    
#define TR_IM_COLD  	 	1,  TR1_IM_COLD    
#define TR_THROW		 	1,  TR1_THROW	   
#define TR_REFLECT  	 	1,  TR1_REFLECT    
#define TR_FREE_ACT 	 	1,  TR1_FREE_ACT	 
#define TR_HOLD_LIFE	 	1,  TR1_HOLD_LIFE	 
#define TR_RES_ACID 	 	1,  TR1_RES_ACID	 
#define TR_RES_ELEC 	 	1,  TR1_RES_ELEC	 
#define TR_RES_FIRE 	 	1,  TR1_RES_FIRE	 
#define TR_RES_COLD 	 	1,  TR1_RES_COLD	 
#define TR_RES_POIS 	 	1,  TR1_RES_POIS	 
#define TR_RES_FEAR 	 	1,  TR1_RES_FEAR	 
#define TR_RES_LITE 	 	1,  TR1_RES_LITE	 
#define TR_RES_DARK 	 	1,  TR1_RES_DARK	 
#define TR_RES_BLIND	 	1,  TR1_RES_BLIND	 
#define TR_RES_CONF 	 	1,  TR1_RES_CONF	 
#define TR_RES_SOUND	 	1,  TR1_RES_SOUND	 
#define TR_RES_SHARDS	 	1,  TR1_RES_SHARDS   
#define TR_RES_NETHER	 	1,  TR1_RES_NETHER   
#define TR_RES_NEXUS	 	1,  TR1_RES_NEXUS	 
#define TR_RES_CHAOS	 	1,  TR1_RES_CHAOS	 
#define TR_RES_DISEN	 	1,  TR1_RES_DISEN	 

#define TR_SH_FIRE  	 	2,  TR2_SH_FIRE 	 
#define TR_SH_ELEC  	 	2,  TR2_SH_ELEC 	 
#define TR_QUESTITEM	 	2,  TR2_QUESTITEM	 
#define TR_XXX4 		 	2,  TR2_XXX4		 
#define TR_NO_TELE  	 	2,  TR2_NO_TELE 	 
#define TR_NO_MAGIC 	 	2,  TR2_NO_MAGIC	 
#define TR_XXX5 		 	2,  TR2_XXX5		 
#define TR_TY_CURSE 	 	2,  TR2_TY_CURSE	 
#define TR_EASY_KNOW	 	2,  TR2_EASY_KNOW	 
#define TR_HIDE_TYPE	 	2,  TR2_HIDE_TYPE	 
#define TR_SHOW_MODS	 	2,  TR2_SHOW_MODS	 
#define TR_INSTA_ART	 	2,  TR2_INSTA_ART	 
#define TR_FEATHER  	 	2,  TR2_FEATHER 	 
#define TR_LITE 		 	2,  TR2_LITE		 
#define TR_SEE_INVIS	 	2,  TR2_SEE_INVIS	 
#define TR_TELEPATHY	 	2,  TR2_TELEPATHY	 
#define TR_SLOW_DIGEST   	2,  TR2_SLOW_DIGEST  
#define TR_REGEN		 	2,  TR2_REGEN		 
#define TR_XTRA_MIGHT	 	2,  TR2_XTRA_MIGHT   
#define TR_XTRA_SHOTS	 	2,  TR2_XTRA_SHOTS   
#define TR_IGNORE_ACID   	2,  TR2_IGNORE_ACID  
#define TR_IGNORE_ELEC   	2,  TR2_IGNORE_ELEC  
#define TR_IGNORE_FIRE   	2,  TR2_IGNORE_FIRE  
#define TR_IGNORE_COLD   	2,  TR2_IGNORE_COLD  
#define TR_ACTIVATE 	 	2,  TR2_ACTIVATE	 
#define TR_DRAIN_EXP	 	2,  TR2_DRAIN_EXP	 
#define TR_TELEPORT 	 	2,  TR2_TELEPORT	 
#define TR_AGGRAVATE	 	2,  TR2_AGGRAVATE	 
#define TR_BLESSED  	 	2,  TR2_BLESSED 	 
#define TR_CURSED		 	2,  TR2_CURSED  	 
#define TR_HEAVY_CURSE   	2,  TR2_HEAVY_CURSE  
#define TR_PERMA_CURSE   	2,  TR2_PERMA_CURSE  


#define TR_LUCK_10  	 	3,  TR3_LUCK_10 	 
#define TR_WILD_SHOT            3,  TR3_WILD_SHOT
#define TR_WILD_WALK            3,  TR3_WILD_WALK
#define TR_EASY_ENCHANT		3,  TR3_EASY_ENCHANT
#define TR_XXX7 		 	3,  TR3_XXX7		 
#define TR_XXX8 		 	3,  TR3_XXX8		 
#define TR_XXX9 		 	3,  TR3_XXX9		 
#define TR_XXX10 		 	3,  TR3_XXX10		 
#define TR_XXX11		 	3,  TR3_XXX11	 
#define TR_XXX12 		 	3,  TR3_XXX12	 
#define TR_IM_LITE  	 	3,  TR3_IM_LITE 	 
#define TR_IM_DARK  	 	3,  TR3_IM_DARK 	 
#define TR_SH_ACID  	 	3,  TR3_SH_ACID 	 
#define TR_SH_COLD  	 	3,  TR3_SH_COLD 	 
#define TR_MUTATE		 	3,  TR3_MUTATE  	 
#define TR_PATRON		 	3,  TR3_PATRON  	 
#define TR_STRANGE_LUCK  	3,  TR3_STRANGE_LUCK 
#define TR_PASS_WALL	 	3,  TR3_PASS_WALL	 
#define TR_GHOUL_TOUCH   	3,  TR3_GHOUL_TOUCH  
#define TR_PSI_CRIT 	 	3,  TR3_PSI_CRIT	 
#define TR_RETURN		 	3,  TR3_RETURN  	 
#define TR_EXPLODE  	 	3,  TR3_EXPLODE 	 
#define TR_HURT_ACID	 	3,  TR3_HURT_ACID	 
#define TR_HURT_ELEC	 	3,  TR3_HURT_ELEC	 
#define TR_HURT_FIRE	 	3,  TR3_HURT_FIRE	 
#define TR_HURT_COLD	 	3,  TR3_HURT_COLD	 
#define TR_HURT_LITE	 	3,  TR3_HURT_LITE	 
#define TR_HURT_DARK	 	3,  TR3_HURT_DARK	 
#define TR_XXX27		 	3,  TR3_XXX27		 
#define TR_XXX28		 	3,  TR3_XXX28		 
#define TR_AUTO_CURSE	 	3,  TR3_AUTO_CURSE   
#define TR_DRAIN_STATS   	3,  TR3_DRAIN_STATS  
#define TR_CANT_EAT 	 	3,  TR3_CANT_EAT	 
#define TR_SLOW_HEAL	 	3,  TR3_SLOW_HEAL	 


/* Extra helpers */
#define TR_PVAL_MASK     	0,	TR0_PVAL_MASK
#define TR_EASY_MASK    	0,	TR0_EASY_MASK
#define TR_IGNORE_MASK      2,	TR2_IGNORE_MASK 


/*** Monster blow constants ***/


/*
 * New monster blow methods
 */
#define RBM_HIT          1
#define RBM_TOUCH        2
#define RBM_PUNCH        3
#define RBM_KICK         4
#define RBM_CLAW         5
#define RBM_BITE         6
#define RBM_STING        7
#define RBM_XXX1         8
#define RBM_BUTT         9
#define RBM_CRUSH       10
#define RBM_ENGULF      11
#define RBM_CHARGE      12
#define RBM_CRAWL       13
#define RBM_DROOL       14
#define RBM_SPIT        15
#define RBM_EXPLODE     16
#define RBM_GAZE        17
#define RBM_WAIL        18
#define RBM_SPORE       19
#define RBM_XXX4        20
#define RBM_BEG         21
#define RBM_INSULT      22
#define RBM_MOAN        23
#define RBM_SHOW        24

#define MAX_RBM			25

/*
 * New monster blow effects
 */
#define RBE_HURT         1
#define RBE_POISON       2
#define RBE_UN_BONUS     3
#define RBE_UN_POWER     4
#define RBE_EAT_GOLD     5
#define RBE_EAT_ITEM     6
#define RBE_EAT_FOOD     7
#define RBE_EAT_LITE     8
#define RBE_ACID         9
#define RBE_ELEC        10
#define RBE_FIRE        11
#define RBE_COLD        12
#define RBE_BLIND       13
#define RBE_CONFUSE     14
#define RBE_TERRIFY     15
#define RBE_PARALYZE    16
#define RBE_LOSE_STR    17
#define RBE_LOSE_INT    18
#define RBE_LOSE_WIS    19
#define RBE_LOSE_DEX    20
#define RBE_LOSE_CON    21
#define RBE_LOSE_CHR    22
#define RBE_LOSE_ALL    23
#define RBE_SHATTER     24
#define RBE_EXP_10      25
#define RBE_EXP_20      26
#define RBE_EXP_40      27
#define RBE_EXP_80      28
#define RBE_DISEASE     29
#define RBE_TIME        30
#define RBE_EXP_VAMP    31


/*** Monster flag values (hard-coded) ***/


/*
 * New monster race bit flags
 */
#define RF0_UNIQUE              0x00000001	/* Unique Monster */
#define RF0_QUESTOR             0x00000002	/* Quest Monster */
#define RF0_MALE                0x00000004	/* Male gender */
#define RF0_FEMALE              0x00000008	/* Female gender */
#define RF0_CHAR_CLEAR          0x00000010	/* Absorbs symbol */
#define RF0_CHAR_MIMIC          0x00000020	/* Changes symbol */
#define RF0_ATTR_CLEAR          0x00000040	/* Absorbs color */
#define RF0_ATTR_MULTI          0x00000080	/* Changes color */
#define RF0_FORCE_DEPTH         0x00000100	/* Start at "correct" depth */
#define RF0_FORCE_MAXHP         0x00000200	/* Start with max hitpoints */
#define RF0_FORCE_SLEEP         0x00000400	/* Start out sleeping */
#define RF0_FORCE_EXTRA         0x00000800	/* Start out something */
#define RF0_XXX_1               0x00001000	/* Unused */
#define RF0_FRIENDS             0x00002000	/* Arrive with some friends */
#define RF0_ESCORT              0x00004000	/* Arrive with an escort */
#define RF0_ESCORTS             0x00008000	/* Arrive with some escorts */
#define RF0_NEVER_BLOW          0x00010000	/* Never make physical blow */
#define RF0_NEVER_MOVE          0x00020000	/* Never make physical move */
#define RF0_RAND_25             0x00040000	/* Moves randomly (25%) */
#define RF0_RAND_50             0x00080000	/* Moves randomly (50%) */
#define RF0_ONLY_GOLD           0x00100000	/* Drop only gold */
#define RF0_ONLY_ITEM           0x00200000	/* Drop only items */
#define RF0_DROP_60             0x00400000	/* Drop an item/gold (60%) */
#define RF0_DROP_90             0x00800000	/* Drop an item/gold (90%) */
#define RF0_DROP_1D2            0x01000000	/* Drop 1d2 items/gold */
#define RF0_DROP_2D2            0x02000000	/* Drop 2d2 items/gold */
#define RF0_DROP_3D2            0x04000000	/* Drop 3d2 items/gold */
#define RF0_DROP_4D2            0x08000000	/* Drop 4d2 items/gold */
#define RF0_DROP_GOOD           0x10000000	/* Drop good items */
#define RF0_DROP_GREAT          0x20000000	/* Drop great items */
#define RF0_DROP_USEFUL         0x40000000	/* Drop "useful" items */
#define RF0_DROP_CHOSEN         0x80000000	/* Drop "chosen" items */

/*
 * New monster race bit flags
 */
#define RF1_STUPID          0x00000001	/* Monster is stupid */
#define RF1_SMART           0x00000002	/* Monster is smart */
#define RF1_CAN_SPEAK       0x00000004	/* TY: can speak */
#define RF1_REFLECTING      0x00000008	/* Reflects bolts */
#define RF1_INVISIBLE       0x00000010	/* Monster avoids vision */
#define RF1_COLD_BLOOD      0x00000020	/* Monster avoids infra */
#define RF1_EMPTY_MIND      0x00000040	/* Monster avoids telepathy */
#define RF1_WEIRD_MIND      0x00000080	/* Monster avoids telepathy? */
#define RF1_MULTIPLY        0x00000100	/* Monster reproduces */
#define RF1_REGENERATE      0x00000200	/* Monster regenerates */
#define RF1_SHAPECHANGER    0x00000400	/* TY: shapechanger */
#define RF1_ATTR_ANY        0x00000800	/* TY: Attr_any */
#define RF1_POWERFUL        0x00001000	/* Monster has strong breath */
#define RF1_XXX_1			0x00002000
#define RF1_AURA_FIRE       0x00004000	/* Burns in melee */
#define RF1_AURA_ELEC       0x00008000	/* Shocks in melee */
#define RF1_OPEN_DOOR       0x00010000	/* Monster can open doors */
#define RF1_BASH_DOOR       0x00020000	/* Monster can bash doors */
#define RF1_PASS_WALL       0x00040000	/* Monster can pass walls */
#define RF1_KILL_WALL       0x00080000	/* Monster can destroy walls */
#define RF1_MOVE_BODY       0x00100000	/* Monster can move monsters */
#define RF1_KILL_BODY       0x00200000	/* Monster can kill monsters */
#define RF1_TAKE_ITEM       0x00400000	/* Monster can pick up items */
#define RF1_KILL_ITEM       0x00800000	/* Monster can crush items */
#define RF1_BRAIN_1         0x01000000
#define RF1_BRAIN_2         0x02000000
#define RF1_BRAIN_3         0x04000000
#define RF1_BRAIN_4         0x08000000
#define RF1_BRAIN_5         0x10000000
#define RF1_BRAIN_6         0x20000000
#define RF1_BRAIN_7         0x40000000
#define RF1_QUANTUM         0x80000000	/* Monster has quantum behavior */

/*
 * New monster race bit flags
 */
#define RF2_ORC             0x00000001	/* Orc */
#define RF2_TROLL           0x00000002	/* Troll */
#define RF2_GIANT           0x00000004	/* Giant */
#define RF2_DRAGON          0x00000008	/* Dragon */
#define RF2_DEMON           0x00000010	/* Demon */
#define RF2_UNDEAD          0x00000020	/* Undead */
#define RF2_EVIL            0x00000040	/* Evil */
#define RF2_ANIMAL          0x00000080	/* Animal */
#define RF2_AMBERITE        0x00000100	/* TY: Amberite */
#define RF2_GOOD            0x00000200	/* Good */
#define RF2_AURA_COLD       0x00000400	/* Freezes in melee */
#define RF2_NONLIVING       0x00000800	/* TY: Non-Living (?) */
#define RF2_HURT_LITE       0x00001000	/* Hurt by lite */
#define RF2_HURT_ROCK       0x00002000	/* Hurt by rock remover */
#define RF2_HURT_FIRE       0x00004000	/* Hurt badly by fire */
#define RF2_HURT_COLD       0x00008000	/* Hurt badly by cold */
#define RF2_IM_ACID         0x00010000	/* Resist acid a lot */
#define RF2_IM_ELEC         0x00020000	/* Resist elec a lot */
#define RF2_IM_FIRE         0x00040000	/* Resist fire a lot */
#define RF2_IM_COLD         0x00080000	/* Resist cold a lot */
#define RF2_IM_POIS         0x00100000	/* Resist poison a lot */
#define RF2_RES_TELE        0x00200000	/* Resist teleportation */
#define RF2_RES_NETH        0x00400000	/* Resist nether a lot */
#define RF2_RES_WATE        0x00800000	/* Resist water */
#define RF2_RES_PLAS        0x01000000	/* Resist plasma */
#define RF2_RES_NEXU        0x02000000	/* Resist nexus */
#define RF2_RES_DISE        0x04000000	/* Resist disenchantment */
#define RF2_UNIQUE_7        0x08000000	/* Is a "Nazgul" unique */
#define RF2_NO_FEAR         0x10000000	/* Cannot be scared */
#define RF2_NO_STUN         0x20000000	/* Cannot be stunned */
#define RF2_NO_CONF         0x40000000	/* Cannot be confused */
#define RF2_NO_SLEEP        0x80000000	/* Cannot be slept */

/*
 * New monster race bit flags
 */
#define RF3_SHRIEK          0x00000001	/* Shriek for help */
#define RF3_ELDRITCH_HORROR 0x00000002	/* Sanity-blasting horror */
#define RF3_XXX3            0x00000004	/* (?) */
#define RF3_ROCKET          0x00000008	/* TY: Rocket */
#define RF3_ARROW           0x00000010  /* Fire an arrow */
#define RF3_XXX6            0x00000020  /* (?) */
#define RF3_XXX7            0x00000040  /* (?) */
#define RF3_XXX8            0x00000080  /* (?) */
#define RF3_BR_ACID         0x00000100	/* Breathe Acid */
#define RF3_BR_ELEC         0x00000200	/* Breathe Elec */
#define RF3_BR_FIRE         0x00000400	/* Breathe Fire */
#define RF3_BR_COLD         0x00000800	/* Breathe Cold */
#define RF3_BR_POIS         0x00001000	/* Breathe Poison */
#define RF3_BR_NETH         0x00002000	/* Breathe Nether */
#define RF3_BR_LITE         0x00004000	/* Breathe Lite */
#define RF3_BR_DARK         0x00008000	/* Breathe Dark */
#define RF3_BR_CONF         0x00010000	/* Breathe Confusion */
#define RF3_BR_SOUN         0x00020000	/* Breathe Sound */
#define RF3_BR_CHAO         0x00040000	/* Breathe Chaos */
#define RF3_BR_DISE         0x00080000	/* Breathe Disenchant */
#define RF3_BR_NEXU         0x00100000	/* Breathe Nexus */
#define RF3_BR_TIME         0x00200000	/* Breathe Time */
#define RF3_BR_INER         0x00400000	/* Breathe Inertia */
#define RF3_BR_GRAV         0x00800000	/* Breathe Gravity */
#define RF3_BR_SHAR         0x01000000	/* Breathe Shards */
#define RF3_BR_PLAS         0x02000000	/* Breathe Plasma */
#define RF3_BR_WALL         0x04000000	/* Breathe Force */
#define RF3_BR_MANA         0x08000000	/* Breathe Mana */
#define RF3_BA_NUKE         0x10000000	/* TY: Nuke Ball */
#define RF3_BR_NUKE         0x20000000	/* TY: Toxic Breath */
#define RF3_BA_CHAO         0x40000000	/* TY: Logrus Ball */
#define RF3_BR_DISI         0x80000000	/* Breathe Disintegration */

/*
 * New monster race bit flags
 */
#define RF4_BA_ACID         0x00000001	/* Acid Ball */
#define RF4_BA_ELEC         0x00000002	/* Elec Ball */
#define RF4_BA_FIRE         0x00000004	/* Fire Ball */
#define RF4_BA_COLD         0x00000008	/* Cold Ball */
#define RF4_BA_POIS         0x00000010	/* Poison Ball */
#define RF4_BA_NETH         0x00000020	/* Nether Ball */
#define RF4_BA_WATE         0x00000040	/* Water Ball */
#define RF4_BA_MANA         0x00000080	/* Mana Storm */
#define RF4_BA_DARK         0x00000100	/* Darkness Storm */
#define RF4_DRAIN_MANA      0x00000200	/* Drain Mana */
#define RF4_MIND_BLAST      0x00000400	/* Blast Mind */
#define RF4_BRAIN_SMASH     0x00000800	/* Smash Brain */
#define RF4_CAUSE_1         0x00001000	/* Cause Light Wound */
#define RF4_CAUSE_2         0x00002000	/* Cause Serious Wound */
#define RF4_CAUSE_3         0x00004000	/* Cause Critical Wound */
#define RF4_CAUSE_4         0x00008000	/* Cause Mortal Wound */
#define RF4_BO_ACID         0x00010000	/* Acid Bolt */
#define RF4_BO_ELEC         0x00020000	/* Elec Bolt (unused) */
#define RF4_BO_FIRE         0x00040000	/* Fire Bolt */
#define RF4_BO_COLD         0x00080000	/* Cold Bolt */
#define RF4_BO_POIS         0x00100000	/* Poison Bolt (unused) */
#define RF4_BO_NETH         0x00200000	/* Nether Bolt */
#define RF4_BO_WATE         0x00400000	/* Water Bolt */
#define RF4_BO_MANA         0x00800000	/* Mana Bolt */
#define RF4_BO_PLAS         0x01000000	/* Plasma Bolt */
#define RF4_BO_ICEE         0x02000000	/* Ice Bolt */
#define RF4_MISSILE         0x04000000	/* Magic Missile */
#define RF4_SCARE           0x08000000	/* Frighten Player */
#define RF4_BLIND           0x10000000	/* Blind Player */
#define RF4_CONF            0x20000000	/* Confuse Player */
#define RF4_SLOW            0x40000000	/* Slow Player */
#define RF4_HOLD            0x80000000	/* Paralyze Player */

/*
 * New monster race bit flags
 */
#define RF5_HASTE           0x00000001	/* Speed self */
#define RF5_HAND_DOOM       0x00000002	/* Hand of Doom */
#define RF5_HEAL            0x00000004	/* Heal self */
#define RF5_INVULNER        0x00000008	/* INVULNERABILITY! */
#define RF5_BLINK           0x00000010	/* Teleport Short */
#define RF5_TPORT           0x00000020	/* Teleport Long */
#define RF5_XXX3            0x00000040	/* Move to Player (?) */
#define RF5_XXX4            0x00000080	/* Move to Monster (?) */
#define RF5_TELE_TO         0x00000100	/* Move player to monster */
#define RF5_TELE_AWAY       0x00000200	/* Move player far away */
#define RF5_TELE_LEVEL      0x00000400	/* Move player vertically */
#define RF5_XXX5            0x00000800	/* Move player (?) */
#define RF5_DARKNESS        0x00001000	/* Create Darkness */
#define RF5_TRAPS           0x00002000	/* Create Traps */
#define RF5_FORGET          0x00004000	/* Cause amnesia */
#define RF5_RAISE_DEAD      0x00008000	/* Raise Dead */
#define RF5_S_KIN           0x00010000	/* Summon "kin" */
#define RF5_S_CYBER         0x00020000	/* Summon Cyberdemons! */
#define RF5_S_MONSTER       0x00040000	/* Summon Monster */
#define RF5_S_MONSTERS      0x00080000	/* Summon Monsters */
#define RF5_S_ANT           0x00100000	/* Summon Ants */
#define RF5_S_SPIDER        0x00200000	/* Summon Spiders */
#define RF5_S_HOUND         0x00400000	/* Summon Hounds */
#define RF5_S_HYDRA         0x00800000	/* Summon Hydras */
#define RF5_S_ANGEL         0x01000000	/* Summon Angel */
#define RF5_S_DEMON         0x02000000	/* Summon Demon */
#define RF5_S_UNDEAD        0x04000000	/* Summon Undead */
#define RF5_S_DRAGON        0x08000000	/* Summon Dragon */
#define RF5_S_HI_UNDEAD     0x10000000	/* Summon Greater Undead */
#define RF5_S_HI_DRAGON     0x20000000	/* Summon Ancient Dragon */
#define RF5_S_AMBERITES     0x40000000	/* Summon Amberites */
#define RF5_S_UNIQUE        0x80000000	/* Summon Unique Monster */

/*
 * New monster race bit flags
 */
#define RF6_AQUATIC			0x00000001	/* Aquatic monster */
#define RF6_CAN_SWIM		0x00000002	/* Monster can swim */
#define RF6_CAN_FLY			0x00000004	/* Monster can fly */
#define RF6_FRIENDLY		0x00000008	/* Monster is friendly */
#define RF6_SILLY			0x00000010	/* Monster is "silly" */
#define RF6_LITE_1			0x00000020	/* Monster carries a small lite */
#define RF6_LITE_2			0x00000040	/* Monster carries a large lite */
#define RF6_LIBRARY			0x00000080  /* Monster has been researched at a library */

/*
 * Monster race wilderness flags
 */
#define RF7_WILD_FOREST1        0x00000001
#define RF7_WILD_FOREST2        0x00000002
#define RF7_WILD_MOUNT1         0x00000004
#define RF7_WILD_MOUNT2         0x00000008
#define RF7_WILD_WASTE1         0x00000010
#define RF7_WILD_WASTE2         0x00000020
#define RF7_WILD_SWAMP1         0x00000040
#define RF7_WILD_SWAMP2         0x00000080
#define RF7_WILD_SHORE          0x00000100
#define RF7_WILD_OCEAN          0x00000200
#define RF7_WILD_GRASS          0x00000400
#define RF7_WILD_TOWN           0x00000800
#define RF7_DUN_DARKWATER       0x00001000
#define RF7_DUN_LAIR            0x00002000
#define RF7_DUN_TEMPLE          0x00004000
#define RF7_DUN_TOWER           0x00008000
#define RF7_DUN_RUIN            0x00010000
#define RF7_DUN_GRAVE           0x00020000
#define RF7_DUN_CAVERN          0x00040000
#define RF7_DUN_PLANAR          0x00080000
#define RF7_DUN_HELL            0x00100000
#define RF7_DUN_HORROR          0x00200000
#define RF7_DUN_MINE            0x00400000
#define RF7_DUN_CITY            0x00800000
#define RF7_DUN_XTRA1			0x01000000
#define RF7_DUN_XTRA2			0x02000000
#define RF7_DUN_XTRA3			0x04000000
#define RF7_DUN_XTRA4			0x08000000
#define RF7_DUN_XTRA5			0x10000000
#define RF7_DUN_XTRA6			0x20000000
#define RF7_DUN_XTRA7			0x40000000
#define RF7_DUN_XTRA8			0x80000000


/*
 * Useful flag combinations
 */

#define RF7_DUNGEON             0xFFFFF000
#define RF7_WILD                0x000007FF


/*
 * Monster drop info
 */

#define RF8_DROP_CORPSE         0x00000001
#define RF8_DROP_SKELETON       0x00000002

/*
 * Hack -- choose "intelligent" spells when desperate
 */

#define RF3_INT_MASK \
   0L

#define RF4_INT_MASK \
  (RF4_HOLD | RF4_SLOW | RF4_CONF | RF4_BLIND | RF4_SCARE)

#define RF5_INT_MASK \
   (RF5_BLINK | RF5_TPORT | RF5_TELE_LEVEL | RF5_TELE_AWAY | \
    RF5_HEAL | RF5_INVULNER | RF5_HASTE | RF5_TRAPS | RF5_RAISE_DEAD | \
    RF5_S_KIN | RF5_S_CYBER | RF5_S_MONSTER | RF5_S_MONSTERS | \
    RF5_S_ANT | RF5_S_SPIDER | RF5_S_HOUND | RF5_S_HYDRA | \
    RF5_S_ANGEL | RF5_S_DRAGON | RF5_S_UNDEAD | RF5_S_DEMON | \
    RF5_S_HI_DRAGON | RF5_S_HI_UNDEAD | RF5_S_AMBERITES | RF5_S_UNIQUE)


/*
 * Hack -- "bolt" spells that may hurt fellow monsters
 */
#define RF3_BOLT_MASK \
  (RF3_ROCKET | RF3_ARROW)

#define RF4_BOLT_MASK \
   (RF4_BO_ACID | RF4_BO_ELEC | RF4_BO_FIRE | RF4_BO_COLD | \
    RF4_BO_POIS | RF4_BO_NETH | RF4_BO_WATE | RF4_BO_MANA | \
    RF4_BO_PLAS | RF4_BO_ICEE | RF4_MISSILE)

#define RF5_BOLT_MASK \
   0L

/*
 * Spells that hurt the player directly
 */
#define RF3_ATTACK_MASK \
	(RF3_ROCKET | RF3_ARROW |  \
	 RF3_BR_ACID | RF3_BR_ELEC | RF3_BR_FIRE | RF3_BR_COLD | RF3_BR_POIS | \
	 RF3_BR_NETH | RF3_BR_LITE | RF3_BR_DARK | RF3_BR_CONF | RF3_BR_SOUN | \
	 RF3_BR_CHAO | RF3_BR_DISE | RF3_BR_NEXU | RF3_BR_TIME | RF3_BR_INER | \
	 RF3_BR_GRAV | RF3_BR_SHAR | RF3_BR_PLAS | RF3_BR_WALL | RF3_BR_MANA | \
	 RF3_BA_NUKE | RF3_BR_NUKE | RF3_BA_CHAO | RF3_BR_DISI)

#define RF4_ATTACK_MASK \
	(RF4_BA_ACID | RF4_BA_ELEC | RF4_BA_FIRE | RF4_BA_COLD | RF4_BA_POIS | \
	 RF4_BA_NETH | RF4_BA_WATE | RF4_BA_MANA | RF4_BA_DARK | \
	 RF4_MIND_BLAST | RF4_BRAIN_SMASH | RF4_CAUSE_1 | RF4_CAUSE_2 | \
	 RF4_CAUSE_3 | RF4_CAUSE_4 | RF4_BO_ACID | RF4_BO_ELEC | RF4_BO_FIRE | \
	 RF4_BO_COLD | RF4_BO_POIS | RF4_BO_NETH | RF4_BO_WATE | RF4_BO_MANA | \
	 RF4_BO_PLAS | RF4_BO_ICEE | RF4_MISSILE)

#define RF5_ATTACK_MASK \
	(RF5_HAND_DOOM)



/*
 * Spells that allow the caster to escape
 */
#define RF3_ESCAPE_MASK \
	(0L)

#define RF4_ESCAPE_MASK \
	(0L)

#define RF5_ESCAPE_MASK \
	(RF5_BLINK | RF5_TPORT | RF5_TELE_AWAY | RF5_TELE_LEVEL)



/*
 * Hack -- 'ball' spells that may hurt friends
 */
#define RF3_BALL_MASK \
	(RF3_ROCKET | RF3_BR_ACID | RF3_BR_ELEC | RF3_BR_FIRE | \
	RF3_BR_COLD | RF3_BR_POIS | RF3_BR_NETH | RF3_BR_LITE | \
	RF3_BR_DARK | RF3_BR_CONF | RF3_BR_SOUN | RF3_BR_CHAO | \
	RF3_BR_DISE | RF3_BR_NEXU | RF3_BR_SHAR | \
	RF3_BR_SOUN | RF3_BR_TIME | RF3_BR_INER | RF3_BR_GRAV | \
	RF3_BR_PLAS | RF3_BR_WALL | RF3_BR_MANA | RF3_BA_NUKE | \
	RF3_BR_NUKE | RF3_BA_CHAO | RF3_BR_DISI)

#define RF4_BALL_MASK \
	(RF4_BA_ACID | RF4_BA_ELEC | RF4_BA_FIRE | RF4_BA_COLD | \
	RF4_BA_NETH | RF4_BA_DARK | RF4_BA_WATE | RF4_BA_MANA)

#define RF5_BALL_MASK \
	0L


/* Hack -- summon spells */

#define RF3_SUMMON_MASK \
    0L

#define RF4_SUMMON_MASK \
    0L

#define RF5_SUMMON_MASK \
    (RF5_S_KIN | RF5_S_CYBER | RF5_S_MONSTER | RF5_S_MONSTERS | RF5_S_ANT | \
     RF5_S_SPIDER | RF5_S_HOUND | RF5_S_HYDRA | RF5_S_ANGEL | RF5_S_DEMON | \
     RF5_S_UNDEAD | RF5_S_DRAGON | RF5_S_HI_UNDEAD | RF5_S_HI_DRAGON | \
     RF5_S_AMBERITES | RF5_S_UNIQUE)


/*
 * Spells that improve the caster's tactical position
 */
#define RF3_TACTIC_MASK \
	(0L)

#define RF4_TACTIC_MASK \
	(0L)

#define RF5_TACTIC_MASK \
	(RF5_BLINK)


/*
 * Annoying spells
 */
#define RF3_ANNOY_MASK \
	(RF3_SHRIEK | RF3_ELDRITCH_HORROR)

#define RF4_ANNOY_MASK \
	(RF4_DRAIN_MANA | RF4_MIND_BLAST | RF4_BRAIN_SMASH | \
	RF4_CAUSE_1 | RF4_CAUSE_2 | RF4_CAUSE_3 | RF4_CAUSE_4 | \
	RF4_SCARE | RF4_BLIND | RF4_CONF | RF4_SLOW | RF4_HOLD)

#define RF5_ANNOY_MASK \
	(RF5_TELE_TO | RF5_DARKNESS | RF5_TRAPS | RF5_FORGET | RF5_RAISE_DEAD)


/*
 * Spells that increase the caster's relative speed
 */
#define RF3_HASTE_MASK \
	(0L)

#define RF4_HASTE_MASK \
	(RF4_SLOW | RF4_HOLD)

#define RF5_HASTE_MASK \
	(RF5_HASTE)

/*
 * Spells that give invulnerability
 */
#define RF3_INVULN_MASK \
	(0L)

#define RF4_INVULN_MASK \
	(0L)

#define RF5_INVULN_MASK \
	(RF5_INVULNER)

/*
 * Healing spells
 */
#define RF3_HEAL_MASK \
	(0L)

#define RF4_HEAL_MASK \
	(0L)

#define RF5_HEAL_MASK \
	(RF5_HEAL)


/*
 * Innate spell-like effects
 */
#define RF3_INNATE_MASK \
	(RF3_SHRIEK | RF3_ELDRITCH_HORROR | RF3_ARROW | \
	 RF3_BR_ACID | RF3_BR_ELEC | RF3_BR_FIRE | \
	 RF3_BR_COLD | RF3_BR_POIS | RF3_BR_NETH | RF3_BR_LITE | RF3_BR_DARK | \
	 RF3_BR_CONF | RF3_BR_SOUN | RF3_BR_CHAO | RF3_BR_DISE | RF3_BR_NEXU | \
	 RF3_BR_TIME | RF3_BR_INER | RF3_BR_GRAV | RF3_BR_SHAR | RF3_BR_PLAS | \
	 RF3_BR_WALL | RF3_BR_MANA | RF3_BR_NUKE | RF3_BR_DISI)

#define RF4_INNATE_MASK \
	(0L)

#define RF5_INNATE_MASK \
	(0L)


/*
 * Breath mask
 */
#define RF3_BREATHS \
	(RF3_BR_ACID | RF3_BR_ELEC | RF3_BR_FIRE | RF3_BR_COLD | RF3_BR_POIS | \
	 RF3_BR_NETH | RF3_BR_LITE | RF3_BR_DARK | RF3_BR_CONF | RF3_BR_SOUN | \
	 RF3_BR_CHAO | RF3_BR_DISE | RF3_BR_NEXU | RF3_BR_TIME | RF3_BR_INER | \
	 RF3_BR_GRAV | RF3_BR_SHAR | RF3_BR_PLAS | RF3_BR_WALL | RF3_BR_MANA | \
	 RF3_BR_NUKE | RF3_BR_DISI)


#define RF_UNIQUE			   0,  RF0_UNIQUE	  
#define RF_QUESTOR  		   0,  RF0_QUESTOR    
#define RF_MALE 			   0,  RF0_MALE 	
#define RF_FEMALE			   0,  RF0_FEMALE	  
#define RF_CHAR_CLEAR		   0,  RF0_CHAR_CLEAR 
#define RF_CHAR_MIMIC		   0,  RF0_CHAR_MIMIC 
#define RF_ATTR_CLEAR		   0,  RF0_ATTR_CLEAR 
#define RF_ATTR_MULTI		   0,  RF0_ATTR_MULTI 
#define RF_FORCE_DEPTH  	   0,  RF0_FORCE_DEPTH
#define RF_FORCE_MAXHP  	   0,  RF0_FORCE_MAXHP
#define RF_FORCE_SLEEP  	   0,  RF0_FORCE_SLEEP
#define RF_FORCE_EXTRA  	   0,  RF0_FORCE_EXTRA
#define RF_XXX_1			   0,  RF0_XXX_1	
#define RF_FRIENDS  		   0,  RF0_FRIENDS    
#define RF_ESCORT			   0,  RF0_ESCORT	  
#define RF_ESCORTS  		   0,  RF0_ESCORTS    
#define RF_NEVER_BLOW		   0,  RF0_NEVER_BLOW 
#define RF_NEVER_MOVE		   0,  RF0_NEVER_MOVE 
#define RF_RAND_25  		   0,  RF0_RAND_25    
#define RF_RAND_50  		   0,  RF0_RAND_50    
#define RF_ONLY_GOLD		   0,  RF0_ONLY_GOLD  
#define RF_ONLY_ITEM		   0,  RF0_ONLY_ITEM  
#define RF_DROP_60  		   0,  RF0_DROP_60    
#define RF_DROP_90  		   0,  RF0_DROP_90    
#define RF_DROP_1D2 		   0,  RF0_DROP_1D2   
#define RF_DROP_2D2 		   0,  RF0_DROP_2D2   
#define RF_DROP_3D2 		   0,  RF0_DROP_3D2   
#define RF_DROP_4D2 		   0,  RF0_DROP_4D2   
#define RF_DROP_GOOD		   0,  RF0_DROP_GOOD  
#define RF_DROP_GREAT		   0,  RF0_DROP_GREAT 
#define RF_DROP_USEFUL  	   0,  RF0_DROP_USEFUL
#define RF_DROP_CHOSEN  	   0,  RF0_DROP_CHOSEN

/*
 * New monster race bit flags
 */
#define RF_STUPID			   1,  RF1_STUPID		
#define RF_SMART			   1,  RF1_SMART		
#define RF_CAN_SPEAK		   1,  RF1_CAN_SPEAK	
#define RF_REFLECTING		   1,  RF1_REFLECTING	
#define RF_INVISIBLE		   1,  RF1_INVISIBLE	
#define RF_COLD_BLOOD		   1,  RF1_COLD_BLOOD	
#define RF_EMPTY_MIND		   1,  RF1_EMPTY_MIND	
#define RF_WEIRD_MIND		   1,  RF1_WEIRD_MIND	
#define RF_MULTIPLY 		   1,  RF1_MULTIPLY 	
#define RF_REGENERATE		   1,  RF1_REGENERATE	
#define RF_SHAPECHANGER 	   1,  RF1_SHAPECHANGER    
#define RF_ATTR_ANY 		   1,  RF1_ATTR_ANY 	
#define RF_POWERFUL 		   1,  RF1_POWERFUL 	
#define RF_XXX_2			   1,  RF1_XXX_2		
#define RF_AURA_FIRE		   1,  RF1_AURA_FIRE	
#define RF_AURA_ELEC		   1,  RF1_AURA_ELEC	
#define RF_OPEN_DOOR		   1,  RF1_OPEN_DOOR	
#define RF_BASH_DOOR		   1,  RF1_BASH_DOOR	
#define RF_PASS_WALL		   1,  RF1_PASS_WALL	
#define RF_KILL_WALL		   1,  RF1_KILL_WALL	
#define RF_MOVE_BODY		   1,  RF1_MOVE_BODY	
#define RF_KILL_BODY		   1,  RF1_KILL_BODY	
#define RF_TAKE_ITEM		   1,  RF1_TAKE_ITEM	
#define RF_KILL_ITEM		   1,  RF1_KILL_ITEM	
#define RF_BRAIN_1  		   1,  RF1_BRAIN_1  		
#define RF_BRAIN_2  		   1,  RF1_BRAIN_2  		
#define RF_BRAIN_3  		   1,  RF1_BRAIN_3  		
#define RF_BRAIN_4  		   1,  RF1_BRAIN_4  		
#define RF_BRAIN_5  		   1,  RF1_BRAIN_5  		
#define RF_BRAIN_6  		   1,  RF1_BRAIN_6  		
#define RF_BRAIN_7  		   1,  RF1_BRAIN_7  		
#define RF_QUANTUM  		   1,  RF1_QUANTUM  		

/*
 * New monster race bit flag
 */
#define RF_ORC  			   2,  RF2_ORC  	  
#define RF_TROLL			   2,  RF2_TROLL	  
#define RF_GIANT			   2,  RF2_GIANT	  
#define RF_DRAGON			   2,  RF2_DRAGON	  
#define RF_DEMON			   2,  RF2_DEMON	  
#define RF_UNDEAD			   2,  RF2_UNDEAD	  
#define RF_EVIL 			   2,  RF2_EVIL 	  
#define RF_ANIMAL			   2,  RF2_ANIMAL	  
#define RF_AMBERITE 		   2,  RF2_AMBERITE   
#define RF_GOOD 			   2,  RF2_GOOD 	  
#define RF_AURA_COLD		   2,  RF2_AURA_COLD  
#define RF_NONLIVING		   2,  RF2_NONLIVING  
#define RF_HURT_LITE		   2,  RF2_HURT_LITE  
#define RF_HURT_ROCK		   2,  RF2_HURT_ROCK  
#define RF_HURT_FIRE		   2,  RF2_HURT_FIRE  
#define RF_HURT_COLD		   2,  RF2_HURT_COLD  
#define RF_IM_ACID  		   2,  RF2_IM_ACID    
#define RF_IM_ELEC  		   2,  RF2_IM_ELEC    
#define RF_IM_FIRE  		   2,  RF2_IM_FIRE    
#define RF_IM_COLD  		   2,  RF2_IM_COLD    
#define RF_IM_POIS  		   2,  RF2_IM_POIS    
#define RF_RES_TELE 		   2,  RF2_RES_TELE   
#define RF_RES_NETH 		   2,  RF2_RES_NETH   
#define RF_RES_WATE 		   2,  RF2_RES_WATE   
#define RF_RES_PLAS 		   2,  RF2_RES_PLAS   
#define RF_RES_NEXU 		   2,  RF2_RES_NEXU   
#define RF_RES_DISE 		   2,  RF2_RES_DISE   
#define RF_UNIQUE_7 		   2,  RF2_UNIQUE_7   
#define RF_NO_FEAR  		   2,  RF2_NO_FEAR    
#define RF_NO_STUN  		   2,  RF2_NO_STUN    
#define RF_NO_CONF  		   2,  RF2_NO_CONF    
#define RF_NO_SLEEP 		   2,  RF2_NO_SLEEP   

/*
 * New monster race bit flag
 */
#define RF_SHRIEK			   3,  RF3_SHRIEK		
#define RF_ELDRITCH_HORROR     3,  RF3_ELDRITCH_HORROR 
#define RF_XXX3 			   3,  RF3_XXX3 		
#define RF_ROCKET			   3,  RF3_ROCKET		
#define RF_ARROW  		   3,  RF3_ARROW  	
#define RF_XXX6X4  		   3,  RF3_XXX6  	
#define RF_XXX7X4  		   3,  RF3_XXX7  	
#define RF_XXX8X4  		   3,  RF3_XXX8
#define RF_BR_ACID  		   3,  RF3_BR_ACID  	
#define RF_BR_ELEC  		   3,  RF3_BR_ELEC  	
#define RF_BR_FIRE  		   3,  RF3_BR_FIRE  	
#define RF_BR_COLD  		   3,  RF3_BR_COLD  	
#define RF_BR_POIS  		   3,  RF3_BR_POIS  	
#define RF_BR_NETH  		   3,  RF3_BR_NETH  	
#define RF_BR_LITE  		   3,  RF3_BR_LITE  	
#define RF_BR_DARK  		   3,  RF3_BR_DARK  	
#define RF_BR_CONF  		   3,  RF3_BR_CONF  	
#define RF_BR_SOUN  		   3,  RF3_BR_SOUN  	
#define RF_BR_CHAO  		   3,  RF3_BR_CHAO  	
#define RF_BR_DISE  		   3,  RF3_BR_DISE  	
#define RF_BR_NEXU  		   3,  RF3_BR_NEXU  	
#define RF_BR_TIME  		   3,  RF3_BR_TIME  	
#define RF_BR_INER  		   3,  RF3_BR_INER  	
#define RF_BR_GRAV  		   3,  RF3_BR_GRAV  	
#define RF_BR_SHAR  		   3,  RF3_BR_SHAR  	
#define RF_BR_PLAS  		   3,  RF3_BR_PLAS  	
#define RF_BR_WALL  		   3,  RF3_BR_WALL  	
#define RF_BR_MANA  		   3,  RF3_BR_MANA  	
#define RF_BA_NUKE  		   3,  RF3_BA_NUKE  	
#define RF_BR_NUKE  		   3,  RF3_BR_NUKE  	
#define RF_BA_CHAO  		   3,  RF3_BA_CHAO  	
#define RF_BR_DISI  		   3,  RF3_BR_DISI  	

/*
 * New monster race bit flag
 */
#define RF_BA_ACID  		   4,  RF4_BA_ACID    
#define RF_BA_ELEC  		   4,  RF4_BA_ELEC    
#define RF_BA_FIRE  		   4,  RF4_BA_FIRE    
#define RF_BA_COLD  		   4,  RF4_BA_COLD    
#define RF_BA_POIS  		   4,  RF4_BA_POIS    
#define RF_BA_NETH  		   4,  RF4_BA_NETH    
#define RF_BA_WATE  		   4,  RF4_BA_WATE    
#define RF_BA_MANA  		   4,  RF4_BA_MANA    
#define RF_BA_DARK  		   4,  RF4_BA_DARK    
#define RF_DRAIN_MANA		   4,  RF4_DRAIN_MANA 
#define RF_MIND_BLAST		   4,  RF4_MIND_BLAST 
#define RF_BRAIN_SMASH  	   4,  RF4_BRAIN_SMASH
#define RF_CAUSE_1  		   4,  RF4_CAUSE_1    
#define RF_CAUSE_2  		   4,  RF4_CAUSE_2    
#define RF_CAUSE_3  		   4,  RF4_CAUSE_3    
#define RF_CAUSE_4  		   4,  RF4_CAUSE_4    
#define RF_BO_ACID  		   4,  RF4_BO_ACID    
#define RF_BO_ELEC  		   4,  RF4_BO_ELEC    
#define RF_BO_FIRE  		   4,  RF4_BO_FIRE    
#define RF_BO_COLD  		   4,  RF4_BO_COLD    
#define RF_BO_POIS  		   4,  RF4_BO_POIS    
#define RF_BO_NETH  		   4,  RF4_BO_NETH    
#define RF_BO_WATE  		   4,  RF4_BO_WATE    
#define RF_BO_MANA  		   4,  RF4_BO_MANA    
#define RF_BO_PLAS  		   4,  RF4_BO_PLAS    
#define RF_BO_ICEE  		   4,  RF4_BO_ICEE    
#define RF_MISSILE  		   4,  RF4_MISSILE    
#define RF_SCARE			   4,  RF4_SCARE	  
#define RF_BLIND			   4,  RF4_BLIND	  
#define RF_CONF 			   4,  RF4_CONF 	  
#define RF_SLOW 			   4,  RF4_SLOW 	  
#define RF_HOLD 			   4,  RF4_HOLD 	  

/*
 * New monster race bit flag
 */
#define RF_HASTE			   5,  RF5_HASTE	  
#define RF_HAND_DOOM		   5,  RF5_HAND_DOOM  
#define RF_HEAL 			   5,  RF5_HEAL 	  
#define RF_INVULNER 		   5,  RF5_INVULNER   
#define RF_BLINK			   5,  RF5_BLINK	  
#define RF_TPORT			   5,  RF5_TPORT	  
#define RF_XXX4 			   5,  RF5_XXX4
#define RF_XXX5 			   5,  RF5_XXX5 	  
#define RF_TELE_TO  		   5,  RF5_TELE_TO    
#define RF_TELE_AWAY		   5,  RF5_TELE_AWAY  
#define RF_TELE_LEVEL		   5,  RF5_TELE_LEVEL 
#define RF_XXX6 			   5,  RF5_XXX6 	  
#define RF_DARKNESS 		   5,  RF5_DARKNESS   
#define RF_TRAPS			   5,  RF5_TRAPS	  
#define RF_FORGET			   5,  RF5_FORGET	  
#define RF_RAISE_DEAD		   5,  RF5_RAISE_DEAD 
#define RF_S_KIN			   5,  RF5_S_KIN	  
#define RF_S_CYBER  		   5,  RF5_S_CYBER    
#define RF_S_MONSTER		   5,  RF5_S_MONSTER  
#define RF_S_MONSTERS		   5,  RF5_S_MONSTERS 
#define RF_S_ANT			   5,  RF5_S_ANT	  
#define RF_S_SPIDER 		   5,  RF5_S_SPIDER   
#define RF_S_HOUND  		   5,  RF5_S_HOUND    
#define RF_S_HYDRA  		   5,  RF5_S_HYDRA    
#define RF_S_ANGEL  		   5,  RF5_S_ANGEL    
#define RF_S_DEMON  		   5,  RF5_S_DEMON    
#define RF_S_UNDEAD 		   5,  RF5_S_UNDEAD   
#define RF_S_DRAGON 		   5,  RF5_S_DRAGON   
#define RF_S_HI_UNDEAD  	   5,  RF5_S_HI_UNDEAD
#define RF_S_HI_DRAGON  	   5,  RF5_S_HI_DRAGON
#define RF_S_AMBERITES  	   5,  RF5_S_AMBERITES
#define RF_S_UNIQUE 		   5,  RF5_S_UNIQUE   

/*
 * New monster race bit flag
 */
#define RF_AQUATIC  		   6,  RF6_AQUATIC   
#define RF_CAN_SWIM 		   6,  RF6_CAN_SWIM  
#define RF_CAN_FLY  		   6,  RF6_CAN_FLY   
#define RF_FRIENDLY 		   6,  RF6_FRIENDLY  
#define RF_SILLY			   6,  RF6_SILLY     
#define RF_LITE_1			   6,  RF6_LITE_1    
#define RF_LITE_2			   6,  RF6_LITE_2    
#define RF_LIBRARY			   6,  RF6_LIBRARY

/*
 * Monster race wilderness flags
 */
#define RF_WILD_FOREST1 	   7,  RF7_WILD_FOREST1   
#define RF_WILD_FOREST2 	   7,  RF7_WILD_FOREST2   
#define RF_WILD_MOUNT1  	   7,  RF7_WILD_MOUNT1    
#define RF_WILD_MOUNT2  	   7,  RF7_WILD_MOUNT2    
#define RF_WILD_WASTE1  	   7,  RF7_WILD_WASTE1    
#define RF_WILD_WASTE2  	   7,  RF7_WILD_WASTE2    
#define RF_WILD_SWAMP1  	   7,  RF7_WILD_SWAMP1    
#define RF_WILD_SWAMP2  	   7,  RF7_WILD_SWAMP2    
#define RF_WILD_SHORE		   7,  RF7_WILD_SHORE     
#define RF_WILD_OCEAN		   7,  RF7_WILD_OCEAN     
#define RF_WILD_GRASS		   7,  RF7_WILD_GRASS     
#define RF_WILD_TOWN		   7,  RF7_WILD_TOWN      
#define RF_DUN_DARKWATER	   7,  RF7_DUN_DARKWATER  
#define RF_DUN_LAIR 		   7,  RF7_DUN_LAIR   	  
#define RF_DUN_TEMPLE		   7,  RF7_DUN_TEMPLE     
#define RF_DUN_TOWER		   7,  RF7_DUN_TOWER      
#define RF_DUN_RUIN 		   7,  RF7_DUN_RUIN   	  
#define RF_DUN_GRAVE		   7,  RF7_DUN_GRAVE      
#define RF_DUN_CAVERN		   7,  RF7_DUN_CAVERN     
#define RF_DUN_PLANAR		   7,  RF7_DUN_PLANAR     
#define RF_DUN_HELL 		   7,  RF7_DUN_HELL   	  
#define RF_DUN_HORROR		   7,  RF7_DUN_HORROR     
#define RF_DUN_MINE 		   7,  RF7_DUN_MINE   	  
#define RF_DUN_CITY 		   7,  RF7_DUN_CITY   	  
#define RF_DUN_XTRA1		   7,  RF7_DUN_XTRA1      
#define RF_DUN_XTRA2		   7,  RF7_DUN_XTRA2      
#define RF_DUN_XTRA3		   7,  RF7_DUN_XTRA3      
#define RF_DUN_XTRA4		   7,  RF7_DUN_XTRA4      
#define RF_DUN_XTRA5		   7,  RF7_DUN_XTRA5      
#define RF_DUN_XTRA6		   7,  RF7_DUN_XTRA6      
#define RF_DUN_XTRA7		   7,  RF7_DUN_XTRA7      
#define RF_DUN_XTRA8		   7,  RF7_DUN_XTRA8      


#define RF_DUNGEON             7,  RF7_DUNGEON
#define RF_WILD                7,  RF7_WILD

#define RF_DROP_CORPSE         8,  RF8_DROP_CORPSE    
#define RF_DROP_SKELETON       8,  RF8_DROP_SKELETON  

/*
 * Flag manipulation macros
 */
#ifdef _MSC_VER

/* Hack - VC++ doesn't expand preprocessor macros properly */
static __inline bool FLAG_AUX(const u32b *flags, int num, u32b mask)
{
	return((flags[num] & mask) != 0);
}

static __inline void SET_FLAG_AUX(u32b *flags, int num, u32b mask)
{
	flags[num] |= mask;
}

static __inline void COPY_FLAG_AUX(const u32b *flags1, u32b *flags2, int num, u32b mask)
{
	flags2[num] |= flags1[num] & mask;
}

#else /* _MSC_VER */
#define FLAG_AUX(A, NUM, MASK) (((A)[NUM] & (MASK)) != 0)
#define SET_FLAG_AUX(A, NUM, MASK) ((A)[NUM] |= (MASK))
#define COPY_FLAG_AUX(A1, A2, NUM, MASK) ((A2)[NUM] |= ((A1)[NUM] & (MASK)))
#endif /* _MSC_VER */

#define FLAG(P, F) FLAG_AUX((P)->flags, F)
#define SET_FLAG(P, F) SET_FLAG_AUX((P)->flags, F)
#define COPY_FLAG(P1, P2, F) COPY_FLAG_AUX((P1)->flags, (P2)->flags, F)
#define KN_FLAG(P, F) FLAG_AUX((P)->kn_flags, F)


/* Skills */
#define MAX_SKILL	10

#define SKILL_DIS	0 /* Skill: Disarming */
#define SKILL_DEV	1 /* Skill: Magic Devices */
#define SKILL_SAV	2 /* Skill: Saving throw */
#define SKILL_STL	3 /* Skill: Stealth factor */
#define SKILL_SNS	4 /* Skill: Sensing ability */
#define SKILL_FOS	5 /* Skill: Searching frequency */
#define SKILL_THN	6 /* Skill: To hit (normal) */
#define SKILL_THB	7 /* Skill: To hit (shooting) */
#define SKILL_THT	8 /* Skill: To hit (throwing) */
#define SKILL_DIG	9 /* Skill: Digging */

/*** Menu Stuff ***/


/* Menu seperator */
#define MENU_SEPERATOR {"", NULL, NULL, 0x00}

/* Menu terminator */
#define MENU_END {NULL, NULL, NULL, 0x00}

#define MN_ACTIVE		0x01	/* Available to choose */
#define MN_SELECT		0x02	/* Can 'select' action */
#define MN_CLEAR		0x04	/* Clear screen before calling */

/*** Option Definitions ***/

/*
 * Option indexes (offsets)
 *
 * These values are hard-coded by savefiles (and various pieces of code).
 */

#define OPT_MAX					256
#define OPT_PLAYER				192
#define OPT_BIRTH				32
#define OPT_SERVER				32

#define OPT_FLAG_BIRTH			0x01
#define OPT_FLAG_SERVER			0x02
#define OPT_FLAG_PLAYER			0x04


#define OPT_BIRTH_PAGE			6

/* Option set 0 */

#define rogue_like_commands		p_ptr->options[0]
#define quick_messages			p_ptr->options[1]
/* {TRUE,  0, NULL,					"Number 2" }, p_ptr->options[2] */
#define carry_query_flag		p_ptr->options[3]
#define use_old_target			p_ptr->options[4]
#define always_pickup			p_ptr->options[5]
/* {TRUE,  0, NULL,					"Number 6" }, p_ptr->options[6] */
#define depth_in_feet			p_ptr->options[7]
/* {TRUE,  0, NULL,					"Number 8" }, p_ptr->options[8] */
/* {FALSE, 0, NULL,					"Number 9" }, p_ptr->options[9] */
#define show_labels				p_ptr->options[10]
#define show_weights			p_ptr->options[11]
#define view_monster_grids		p_ptr->options[12]
#define toggle_xp				p_ptr->options[13]
#define ring_bell				p_ptr->options[14]
#define use_color				p_ptr->options[15]
#define find_ignore_stairs		p_ptr->options[16]
#define find_ignore_doors		p_ptr->options[17]
#define find_cut				p_ptr->options[18]
#define find_examine			p_ptr->options[19]
#define disturb_view			p_ptr->options[20]
#define disturb_near			p_ptr->options[21]
#define disturb_panel			p_ptr->options[22]
#define disturb_state			p_ptr->options[23]
#define disturb_minor			p_ptr->options[24]
#define disturb_other			p_ptr->options[25]
#define disturb_traps			p_ptr->options[26]
#define auto_more				p_ptr->options[27]
#define last_words				p_ptr->options[28]
#define speak_unique			p_ptr->options[29]
#define small_levels			svr_ptr->options[0]
/* {TRUE,  0, NULL,					"Number 31" }, p_ptr->options[30] */

/* Option set 1 */

/* {TRUE,  0, NULL,					"Number 32" }, svr_ptr->options[1] */
/* {TRUE,  0, NULL,					"Number 33" }, svr_ptr->options[2] */
/* {TRUE,  0, NULL,					"Number 34" }, svr_ptr->options[3] */
/* {TRUE,  0, NULL,					"Number 35" }, svr_ptr->options[4] */
/* {TRUE, 0, NULL, 					"Number 36" }, svr_ptr->options[5] */
#define expand_list				svr_ptr->options[6]
/* {TRUE, 0, NULL, 					"Number 38" }, p_ptr->options[31] */
#define view_torch_grids		p_ptr->options[32]
/* {TRUE,  0, NULL,					"Number 40" }, svr_ptr->options[7] */
#define dungeon_stair			svr_ptr->options[8]
/* {TRUE,  0, NULL,					"Number 42" }, svr_ptr->options[9] */
/* {TRUE,  0, NULL,					"Number 43" }, svr_ptr->options[10] */
/* {TRUE,  0, NULL,					"Number 44" }, svr_ptr->options[11] */
/* {TRUE,  0, NULL,					"Number 45" }, svr_ptr->options[12] */
#define smart_packs				svr_ptr->options[13]
/* {TRUE,  0, NULL,					"Number 47" }, svr_ptr->options[14] */
/* {TRUE,  0, NULL,					"Number 48" }, p_ptr->options[33] */
/* {TRUE,  0, NULL,					"Number 49" }, p_ptr->options[34] */
/* {TRUE,  0, NULL,					"Number 50" }, p_ptr->options[35] */
/* {TRUE,  0, NULL,					"Number 51" }, p_ptr->options[36] */
#define flush_failure			p_ptr->options[37]
#define flush_disturb			p_ptr->options[38]
/* {FALSE, 0, NULL, 					"Number 54" }, p_ptr->options[39] */
#define fresh_before			p_ptr->options[40]
#define fresh_after				p_ptr->options[41]
#define emergency_stop			p_ptr->options[42]
/* {FALSE, 0, NULL,					"Number 57" }, p_ptr->options[42] */
#define compress_savefile		p_ptr->options[43]
#define hilite_player			p_ptr->options[44]
#define view_yellow_lite		p_ptr->options[45]
#define	view_bright_lite		p_ptr->options[46]
#define view_granite_lite		p_ptr->options[47]
#define	view_special_lite		p_ptr->options[48]

/* Option Set 2 */

#define	view_player_colour		p_ptr->options[49]
/* {TRUE,  0, NULL,					"Number 65" }, p_ptr->options[50] */
/* {TRUE,  0, NULL,					"Number 66" }, p_ptr->options[51] */
/* {TRUE,  0, NULL,					"Number 67" }, p_ptr->options[52] */
/* {TRUE,  0, NULL,					"Number 68" }, p_ptr->options[53] */
/* {TRUE,  0, NULL,					"Number 69" }, p_ptr->options[54] */
/* {TRUE,  0, NULL,					"Number 70" }, p_ptr->options[55] */
/* {TRUE,  0, NULL,					"Number 71" }, p_ptr->options[56] */
/* {TRUE,  0, NULL,					"Number 72" }, p_ptr->options[57] */
/* {TRUE,  0, NULL,					"Number 73" }, p_ptr->options[58] */
/* {TRUE,  0, NULL,					"Number 74" }, p_ptr->options[59] */
/* {TRUE,  0, NULL,					"Number 75" }, p_ptr->options[60] */
/* {TRUE,  0, NULL,					"Number 76" }, p_ptr->options[61] */
/* {TRUE,  0, NULL,					"Number 77" }, p_ptr->options[62] */
/* {TRUE,  0, NULL,					"Number 78" }, p_ptr->options[63] */
/* {TRUE,  0, NULL,					"Number 79" }, p_ptr->options[64] */
/* {TRUE,  0, NULL,					"Number 80" }, p_ptr->options[65] */
/* {TRUE,  0, NULL,					"Number 81" }, p_ptr->options[66] */
/* {TRUE,  0, NULL,					"Number 82" }, p_ptr->options[67] */
/* {TRUE,  0, NULL,					"Number 83" }, p_ptr->options[68] */
/* {TRUE,  0, NULL,					"Number 84" }, p_ptr->options[69] */
/* {TRUE,  0, NULL,					"Number 85" }, p_ptr->options[70] */
/* {TRUE,  0, NULL,					"Number 86" }, p_ptr->options[71] */
/* {TRUE,  0, NULL,					"Number 87" }, p_ptr->options[72] */
/* {TRUE,  0, NULL,					"Number 88" }, p_ptr->options[73] */
/* {TRUE,  0, NULL,					"Number 89" }, p_ptr->options[74] */
/* {TRUE,  0, NULL,					"Number 90" }, p_ptr->options[75] */
/* {TRUE,  0, NULL,					"Number 91" }, p_ptr->options[76] */
/* {TRUE,  0, NULL,					"Number 92" }, p_ptr->options[77] */
/* {TRUE,  0, NULL,					"Number 93" }, p_ptr->options[78] */
/* {TRUE,  0, NULL,					"Number 94" }, p_ptr->options[79] */
/* {TRUE,  0, NULL,					"Number 95" }, p_ptr->options[80] */

/* Option Set 3 */

/* {TRUE,  0, NULL,					"Number 96" }, p_ptr->options[81] */
/* {TRUE,  0, NULL,					"Number 97" }, p_ptr->options[82] */
/* {TRUE,  0, NULL,					"Number 98" }, p_ptr->options[83] */
/* {TRUE,  0, NULL,					"Number 99" }, p_ptr->options[84] */
/* {TRUE,  0, NULL,					"Number 100" }, p_ptr->options[85] */
/* {TRUE,  0, NULL,					"Number 101" }, p_ptr->options[86] */
/* {TRUE,  0, NULL,					"Number 102" }, p_ptr->options[87] */
/* {TRUE,  0, NULL,					"Number 103" }, p_ptr->options[88] */
/* {TRUE,  0, NULL,					"Number 104" }, p_ptr->options[89] */
/* {TRUE,  0, NULL,					"Number 105" }, p_ptr->options[90] */
/* {TRUE,  0, NULL,					"Number 106" }, p_ptr->options[91] */
/* {TRUE,  0, NULL,					"Number 107" }, p_ptr->options[92] */
/* {TRUE,  0, NULL,					"Number 108" }, p_ptr->options[93] */
/* {TRUE,  0, NULL,					"Number 109" }, p_ptr->options[94] */
/* {TRUE,  0, NULL,					"Number 110" }, p_ptr->options[95] */
/* {TRUE,  0, NULL,					"Number 111" }, p_ptr->options[96] */
/* {TRUE,  0, NULL,					"Number 112" }, p_ptr->options[97] */
/* {TRUE,  0, NULL,					"Number 113" }, p_ptr->options[98] */
/* {TRUE,  0, NULL,					"Number 114" }, p_ptr->options[99] */
/* {TRUE,  0, NULL,					"Number 115" }, p_ptr->options[100] */
/* {TRUE,  0, NULL,					"Number 116" }, p_ptr->options[101] */
/* {TRUE,  0, NULL,					"Number 117" }, p_ptr->options[102] */
/* {TRUE,  0, NULL,					"Number 118" }, p_ptr->options[103] */
/* {TRUE,  0, NULL,					"Number 119" }, p_ptr->options[104] */
/* {TRUE,  0, NULL,					"Number 120" }, p_ptr->options[105] */
/* {TRUE,  0, NULL,					"Number 121" }, p_ptr->options[106] */
/* {TRUE,  0, NULL,					"Number 122" }, p_ptr->options[107 */
/* {TRUE,  0, NULL,					"Number 123" }, p_ptr->options[108] */
/* {TRUE,  0, NULL,					"Number 124" }, p_ptr->options[109] */
/* {TRUE,  0, NULL,					"Number 125" }, p_ptr->options[110] */
/* {TRUE,  0, NULL,					"Number 126" }, p_ptr->options[111] */
/* {TRUE,  0, NULL,					"Number 127" }, p_ptr->options[112] */

/* Option Set 4 */

/* {TRUE,  0, NULL,					"Number 128" },p_ptr->options[113] */
/* {TRUE,  0, NULL,					"Number 129" },p_ptr->options[114] */
/* {TRUE,  0, NULL,					"Number 130" },p_ptr->options[115] */
/* {TRUE,  0, NULL,					"Number 131" },p_ptr->options[116] */
/* {TRUE,  0, NULL,					"Number 132" },p_ptr->options[117] */
/* {TRUE,  0, NULL,					"Number 133" },p_ptr->options[118] */
/* {TRUE,  0, NULL,					"Number 134" },p_ptr->options[119] */
/* {TRUE,  0, NULL,					"Number 135" },p_ptr->options[120] */
/* {TRUE,  0, NULL,					"Number 136" },p_ptr->options[121] */
/* {TRUE,  0, NULL,					"Number 137" },p_ptr->options[122] */
/* {TRUE,  0, NULL,					"Number 138" },p_ptr->options[123] */
/* {TRUE,  0, NULL,					"Number 139" },p_ptr->options[124] */
/* {TRUE,  0, NULL,					"Number 140" },p_ptr->options[125] */
/* {TRUE,  0, NULL,					"Number 141" },p_ptr->options[126] */
/* {TRUE,  0, NULL,					"Number 142" },p_ptr->options[127] */
/* {TRUE,  0, NULL,					"Number 143" },p_ptr->options[128] */
/* {TRUE,  0, NULL,					"Number 144" },p_ptr->options[129] */
/* {TRUE,  0, NULL,					"Number 145" },p_ptr->options[130] */
/* {TRUE,  0, NULL,					"Number 146" },p_ptr->options[131] */
/* {TRUE,  0, NULL,					"Number 147" },p_ptr->options[132] */
/* {TRUE,  0, NULL,					"Number 148" },p_ptr->options[133] */
/* {TRUE,  0, NULL,					"Number 149" },p_ptr->options[134] */
/* {TRUE,  0, NULL,					"Number 150" },p_ptr->options[135] */
/* {TRUE,  0, NULL,					"Number 151" },p_ptr->options[136] */
/* {TRUE,  0, NULL,					"Number 152" },p_ptr->options[137] */
/* {TRUE,  0, NULL,					"Number 153" },p_ptr->options[138] */
/* {TRUE,  0, NULL,					"Number 154" },p_ptr->options[139] */
/* {TRUE,  0, NULL,					"Number 155" },p_ptr->options[140] */
/* {TRUE,  0, NULL,					"Number 156" },p_ptr->options[141] */
/* {TRUE,  0, NULL,					"Number 157" },p_ptr->options[142] */
/* {TRUE,  0, NULL,					"Number 158" },p_ptr->options[143] */
/* {TRUE,  0, NULL,					"Number 159" },p_ptr->options[144] */

/* Option Set 5 */

/* {TRUE,  0, NULL,					"Number 160" }, p_ptr->options[145] */
#define	plain_descriptions		p_ptr->options[146]
#define stupid_monsters			p_ptr->birth[0]
#define auto_destroy			p_ptr->options[147]
#define confirm_wear			p_ptr->options[148]
/* {FALSE, 0, NULL,					"Number 165" }, p_ptr->options[149] */
#define easy_open				p_ptr->options[150]
#define easy_disarm				p_ptr->options[151]
#define easy_floor				p_ptr->options[152]
/* {TRUE,  0, NULL,					"Number 169" }, p_ptr->options[153] */
#define center_player			p_ptr->options[154]
#define avoid_center			p_ptr->options[155]
/* {TRUE,  0, NULL,					"Number 172" }, p_ptr->options[156] */
#define limit_messages			p_ptr->options[157]
#define check_transaction		p_ptr->options[158]
/* {TRUE,  0, NULL,					"Number 175" }, p_ptr->options[159] */
/* {TRUE,  0, NULL,					"Number 176" }, p_ptr->options[160] */
/* {TRUE,  0, NULL,					"Number 177" }, p_ptr->options[161] */
/* {TRUE,  0, NULL,					"Number 178" }, p_ptr->options[162] */
/* {TRUE,  0, NULL,					"Number 179" }, p_ptr->options[163] */
/* {TRUE,  0, NULL,					"Number 180" }, p_ptr->options[164] */
/* {TRUE,  0, NULL,					"Number 181" }, p_ptr->options[165] */
/* {TRUE,  0, NULL,					"Number 182" }, p_ptr->options[166] */
/* {TRUE,  0, NULL,					"Number 183" }, p_ptr->options[167] */
/* {TRUE,  0, NULL,					"Number 184" }, p_ptr->options[168] */
/* {TRUE,  0, NULL,					"Number 185" }, p_ptr->options[169] */
/* {TRUE,  0, NULL,					"Number 186" }, p_ptr->options[170] */
/* {TRUE,  0, NULL,					"Number 187" }, p_ptr->options[171] */
/* {TRUE,  0, NULL,					"Number 188" }, p_ptr->options[172] */
/* {TRUE,  0, NULL,					"Number 189" }, p_ptr->options[173] */
/* {TRUE,  0, NULL,					"Number 190" }, p_ptr->options[174] */
/* {TRUE,  0, NULL,					"Number 191" }, p_ptr->options[175] */

/* Option Set 6 */

#define vanilla_town			p_ptr->birth[1]
/* {TRUE,  0, NULL,					"Number 193" }, p_ptr->options[176] */
#define ironman_shops			p_ptr->birth[2]
#define ironman_small_levels	p_ptr->birth[3]
#define ironman_downward		p_ptr->birth[4]
/* {TRUE,  0, NULL,					"Number 197" }, p_ptr->birth[5] */
/* {TRUE,  0, NULL,					"Number 198" }, p_ptr->birth[6] */
/* {TRUE,  0, NULL,					"Number 199" }, p_ptr->birth[7] */
/* {TRUE,  0, NULL,					"Number 200" }, p_ptr->birth[8] */
/* {TRUE,  0, NULL,					"Number 201" }, p_ptr->birth[9] */
/* {TRUE,  0, NULL,					"Number 202" }, p_ptr->birth[10] */
#define munchkin_death			p_ptr->birth[11]
/* {TRUE,  0, NULL,					"Number 204" }, p_ptr->birth[12] */
/* {TRUE,  0, NULL,					"Number 205" }, p_ptr->birth[13] */
#define preserve_mode			p_ptr->birth[14]
#define autoroller				p_ptr->birth[15]
#define point_based				p_ptr->birth[16]
#define silly_monsters			p_ptr->birth[17]
#define ironman_nightmare		p_ptr->birth[18]
/* {TRUE,  0, NULL,					"Number 211" }, p_ptr->birth[19] */
/* {TRUE,  0, NULL,					"Number 212" }, p_ptr->birth[20] */
/* {TRUE,  0, NULL,					"Number 213" }, p_ptr->birth[21] */
/* {TRUE,  0, NULL,					"Number 214" }, p_ptr->birth[22] */
/* {TRUE,  0, NULL,					"Number 215" }, p_ptr->birth[23] */
/* {TRUE,  0, NULL,					"Number 216" }, p_ptr->birth[24] */
/* {TRUE,  0, NULL,					"Number 217" }, p_ptr->birth[25] */
/* {TRUE,  0, NULL,					"Number 218" }, p_ptr->birth[26] */
/* {TRUE,  0, NULL,					"Number 219" }, p_ptr->birth[27] */
/* {TRUE,  0, NULL,					"Number 220" }, p_ptr->birth[28] */
/* {TRUE,  0, NULL,					"Number 221" }, p_ptr->birth[29] */
/* {TRUE,  0, NULL,					"Number 222" }, p_ptr->birth[30] */
/* {TRUE,  0, NULL,					"Number 223" }, p_ptr->birth[31] */

/* Option Set 7 */

/* {TRUE,  0, NULL,					"Number 224" },svr_ptr->options[15] */
#define monster_light			svr_ptr->options[16]
/* "Turn on muliplayer client - server code" , svr_ptr->options[17] */
/* {TRUE,  0, NULL,					"Number 227" },svr_ptr->options[18] */
/* {TRUE,  0, NULL,					"Number 228" },svr_ptr->options[19] */
/* {TRUE,  0, NULL,					"Number 229" },svr_ptr->options[20] */
/* {TRUE,  0, NULL,					"Number 230" },svr_ptr->options[21] */
/* {TRUE,  0, NULL,					"Number 231" },svr_ptr->options[22] */
/* {TRUE,  0, NULL,					"Number 232" },svr_ptr->options[23] */
/* {TRUE,  0, NULL,					"Number 233" },svr_ptr->options[24] */
/* {TRUE,  0, NULL,					"Number 234" },svr_ptr->options[25] */
/* {TRUE,  0, NULL,					"Number 235" },svr_ptr->options[26] */
/* {TRUE,  0, NULL,					"Number 236" },svr_ptr->options[27] */
/* {TRUE,  0, NULL,					"Number 237" },svr_ptr->options[28] */
/* {TRUE,  0, NULL,					"Number 238" },svr_ptr->options[29] */
/* {TRUE,  0, NULL,					"Number 239" },p_ptr->options[177] */
/* {TRUE,  0, NULL,					"Number 240" },p_ptr->options[178] */
/* {TRUE,  0, NULL,					"Number 241" },p_ptr->options[179] */
/* {TRUE,  0, NULL,					"Number 242" },p_ptr->options[180] */
/* {TRUE,  0, NULL,					"Number 243" },p_ptr->options[181] */
/* {TRUE,  0, NULL,					"Number 244" },p_ptr->options[182] */
/* {TRUE,  0, NULL,					"Number 245" },p_ptr->options[183] */
/* {TRUE,  0, NULL,					"Number 246" },p_ptr->options[184] */
/* {TRUE,  0, NULL,					"Number 247" },p_ptr->options[185] */
/* {TRUE,  0, NULL,					"Number 248" },p_ptr->options[186] */
/* {TRUE,  0, NULL,					"Number 249" },p_ptr->options[187] */
/* {TRUE,  0, NULL,					"Number 250" },p_ptr->options[188] */
#define auto_notes				p_ptr->options[189]
#define take_notes				p_ptr->options[190]
/* {TRUE,  0, NULL,					"Number 253" }, p_ptr->options[191] */
#define testing_stack			svr_ptr->options[30]
/* {TRUE,  0, NULL,					"Number 255" }, svr_ptr->options[31] */



/*** Macro Definitions ***/

/*
 * Hack -- The main "screen"
 */
#define term_screen     (angband_term[0])


/*
 * Determine if a given inventory item is "aware"
 */
#define object_aware_p(T) \
    (k_info[(T)->k_idx].aware)

/*
 * Determine if a given inventory item is "tried"
 */
#define object_tried_p(T) \
    (k_info[(T)->k_idx].tried)


/*
 * Determine if a given inventory item is "known"
 * Test One -- Check for special "known" tag
 * Test Two -- Check for "Easy Know" + "Aware"
 */
#define object_known_p(T) \
    (((T)->info & (OB_KNOWN)) || \
     (k_info[(T)->k_idx].easy_know && k_info[(T)->k_idx].aware))

/*
 * Is the object fully known?
 */
#define object_known_full(T) \
	((T)->info & (OB_MENTAL))


/*
 * Return the "attr" for a given item.
 * Use "flavor" if available.
 * Default to user definitions.
 */
#define object_attr(T) \
	((k_info[(T)->k_idx].flavor) ? \
	 (misc_to_attr[k_info[(T)->k_idx].flavor]) : \
	 (k_info[(T)->k_idx].x_attr))

/*
 * Return the "char" for a given item.
 * Use "flavor" if available.
 * Default to user definitions.
 */
#define object_char(T) \
	((k_info[(T)->k_idx].flavor) ? \
	 (misc_to_char[k_info[(T)->k_idx].flavor]) : \
	 (k_info[(T)->k_idx].x_char))


/*
 * Ego-Items are named, but are not INSTA_ART.
 */
#define ego_item_p(T) \
	((((T)->xtra_name) && (!((T)->flags[2] & TR2_INSTA_ART))) ? TRUE : FALSE)

/*
 * Cursed items.
 */
#define cursed_p(T) \
	((T)->flags[2] & (TR2_CURSED))


/*
 * Iterate over the objects in a list
 */
#define OBJ_ITT_START(OSTART, O) \
	do { \
		s16b _this_o_idx, _next_o_idx = 0; \
		\
		for (_this_o_idx = (OSTART); _this_o_idx; _this_o_idx = _next_o_idx) \
		{ \
			(O) = &o_list[_this_o_idx];\
			assert((O)->k_idx); \
			\
			_next_o_idx = (O)->next_o_idx;

#define OBJ_ITT_END \
		} \
	} while (0)

/*
 * Iterate over the fieldss in a list
 */
#define FLD_ITT_START(FSTART, F) \
	do { \
		s16b _this_f_idx, _next_f_idx = 0; \
		\
		for (_this_f_idx = (FSTART); _this_f_idx; _this_f_idx = _next_f_idx) \
		{ \
			(F) = &fld_list[_this_f_idx];\
			assert((F)->t_idx); \
			\
			_next_f_idx = (F)->next_f_idx;

#define FLD_ITT_END \
		} \
	} while (0)

/*
 * Useful macros for object formatting
 * (So we use the correct number of arguments)
 */
#define OBJECT_FMT(O, P, M) \
	object_fmt, (O), (P), (M)

#define OBJECT_STORE_FMT(O, P, M) \
	object_store_fmt, (O), (P), (M)

/* Monster name format */
#define MONSTER_FMT(M, P) \
	monster_fmt, (M), (P)


/*
 * Test bounds checking
 */
#ifdef DEBUG_ALPHA
#define area(X, Y) \
	(assert_exp(in_bounds2((X), (Y))) ? area_aux((X), (Y)): NULL)

#define parea(X, Y) \
	(assert_exp(in_boundsp((X), (Y))) ? parea_aux((X), (Y)): NULL)

#else /* DEBUG_ALPHA */
#define area(X, Y) \
	area_aux((X), (Y))
#define parea(X, Y) \
	parea_aux((X), (Y))


#endif /* DEBUG_ALPHA */


/*
 * Determines if a map location is currently "on screen" -RAK-
 */
#define panel_contains(X,Y) \
  (((Y) >= p_ptr->panel_y1) && ((Y) < p_ptr->panel_y2) && \
   ((X) >= p_ptr->panel_x1) && ((X) < p_ptr->panel_x2))

/*
 * Determine if a "legal" grid is a "floor" grid
 */
#define cave_floor_grid(C) \
    (!(f_info[(C)->feat].flags & FF_BLOCK))
/*
 * Determine if a "legal" grid is a "wall" grid
 */
#define cave_wall_grid(C) \
    (f_info[(C)->feat].flags & FF_BLOCK)

/*
 * A half-blocking grid
 */
#define cave_semi_grid(C) \
	(f_info[(C)->feat].flags & FF_HALF_LOS)


/*
 * True half the time for trees. (Block line of sight half the time.)
 */
#define cave_half_grid(C) \
    (cave_semi_grid(C) && (quick_rand()))

/*
 * Grid will block LOS.
 */
#define cave_los_grid(C) \
   ((cave_floor_grid(C)) || (cave_half_grid(C)))

/*
 * A nice grid for dropping objects
 */
#define cave_nice_grid(C) \
    (!(f_info[(C)->feat].flags & FF_ICKY))

/*
 * Grid that does not have any objects or "interesting" terrains
 */
#define cave_clean_grid(C) \
    (cave_nice_grid(C) && \
	((C)->o_idx == 0))

/*
 * Not occupied by a monster
 */
#define cave_empty_grid(C) \
    (cave_floor_grid(C) && !((C)->m_idx))

/*
 * Grid that is empty of everything interesting
 */
#define cave_naked_grid(C) \
    (cave_nice_grid(C) && \
	((C)->o_idx == 0) && \
	((C)->m_idx == 0) && \
	((C)->fld_idx == 0))


/*
 * Grid that cannot be destroyed or passed.
 */
#define cave_perma_grid(C) \
	(f_info[(C)->feat].flags & FF_PERM)


/*
 * Pattern grid.
 */
#define cave_pattern_grid(C) \
	(f_info[(C)->feat].flags & FF_PATTERN)

/*
 * Is the grid worth remembering?
 */
#define cave_mem_grid(C) \
	(f_info[(C)->feat].flags & FF_MARK)

/*
 * Determine if a "legal" grid is within "los" of the player
 *
 * Note the use of comparison to zero to force a "boolean" result
 */
#define player_has_los_grid(C) \
    (((C)->player & (GRID_VIEW)) != 0)

/*
 * Determine if the player can see a grid
 *
 * (The grid is lit + in view)
 */
#define player_can_see_grid(C) \
	(((C)->player & (GRID_SEEN)) != 0)

/*
 * Forget square
 */
#define forget_grid(C) \
	((C)->feat = FEAT_NONE)

/*
 * Memorise square
 *
 * Hack XXX XXX - we test C1->info and C2->player
 *  so we have the correct types.
 * (Without this check - it would be quite easy
 * to get the two pointers the wrong way around.)
 *
 * We need to lite_spot() as well...
 */
#define remember_grid(C1, C2) \
	(((C2)->feat = (C1)->feat), \
	(void) ((C1)->info), \
	(void) ((C2)->player))


/*
 * Create a dungeon region
 */
#define create_region(R, WID, HGT, FLAGS) \
	create_region_aux(&(R)->region, (WID), (HGT), (FLAGS))

/*
 * Is the monster a pet of the player?
 */
#define is_pet(T) \
	 ((bool)(((T)->smart & SM_PET) != 0))

/*
 * Is the monster friendly toward the player?
 */
#define is_friendly(T) \
	 ((bool)(((T)->smart & SM_FRIENDLY) != 0))


/*
 * Is the monster hostile toward the player?
 */
#define is_hostile(T) \
	 ((bool)(!(is_pet(T) || is_friendly(T))))


/*
 * Helper macro so call path_build() with correct buffer size.
 */
#define path_make(B, P, F) \
	do \
	{ \
		assert(sizeof(B) > sizeof(void*)); \
		path_build((B), sizeof(B), (P), (F)); \
	} \
	while (FALSE)



/*
 * Hack -- Prepare to use the "Secure" routines
 */
#if defined(SET_UID) && defined(SECURE)
extern int PlayerUID;
# define getuid() PlayerUID
# define geteuid() PlayerUID
#endif



/*** Color constants ***/


/*
 * Angband "attributes" (with symbols, and base (R,G,B) codes)
 *
 * The "(R,G,B)" codes are given in "fourths" of the "maximal" value,
 * and should "gamma corrected" on most (non-Macintosh) machines.
 */
#define TERM_DARK                0  /* 'd' */	/* 0,0,0 */
#define TERM_WHITE               1  /* 'w' */	/* 4,4,4 */
#define TERM_SLATE               2  /* 's' */	/* 2,2,2 */
#define TERM_ORANGE              3  /* 'o' */	/* 4,2,0 */
#define TERM_RED                 4  /* 'r' */	/* 3,0,0 */
#define TERM_GREEN               5  /* 'g' */	/* 0,2,1 */
#define TERM_BLUE                6  /* 'b' */	/* 0,0,4 */
#define TERM_UMBER               7  /* 'u' */	/* 2,1,0 */
#define TERM_L_DARK              8  /* 'D' */	/* 1,1,1 */
#define TERM_L_WHITE             9  /* 'W' */	/* 3,3,3 */
#define TERM_VIOLET             10  /* 'v' */	/* 4,0,4 */
#define TERM_YELLOW             11  /* 'y' */	/* 4,4,0 */
#define TERM_L_RED              12  /* 'R' */	/* 4,0,0 */
#define TERM_L_GREEN            13  /* 'G' */	/* 0,4,0 */
#define TERM_L_BLUE             14  /* 'B' */	/* 0,4,4 */
#define TERM_L_UMBER            15  /* 'U' */	/* 3,2,1 */


/*
 * Colour format specifiers in strings
 *
 * Start with $, and then have a character that depends on the
 * colour.  We could also use this techinque for other formatting
 * specifiers...
 *
 * Note we must use 'nice' characters for the specifier because
 * the formatting routines eat some of the control characters.
 */
#define CLR_DARK		"$A"  
#define CLR_WHITE		"$B"
#define CLR_SLATE		"$C"
#define CLR_ORANGE		"$D"
#define CLR_RED			"$E"
#define CLR_GREEN		"$F"
#define CLR_BLUE		"$G"
#define CLR_UMBER		"$H"
#define CLR_L_DARK		"$I"
#define CLR_L_WHITE		"$J"
#define CLR_VIOLET		"$K"
#define CLR_YELLOW		"$L"
#define CLR_L_RED		"$M"
#define CLR_L_GREEN		"$N"
#define CLR_L_BLUE		"$O"
#define CLR_L_UMBER		"$P"
#define CLR_SET_DEFAULT "$Q"
#define CLR_DEFAULT		"$R"


/*
 * Raw message types
 */
#define MSG_GENERIC          0
#define MSG_HIT              1
#define MSG_MISS             2
#define MSG_FLEE             3
#define MSG_DROP             4
#define MSG_KILL             5
#define MSG_LEVEL            6
#define MSG_DEATH            7
#define MSG_STUDY            8
#define MSG_TELEPORT         9
#define MSG_SHOOT           10
#define MSG_QUAFF           11
#define MSG_ZAP             12
#define MSG_WALK            13
#define MSG_TPOTHER         14
#define MSG_HITWALL         15
#define MSG_EAT             16
#define MSG_STORE1          17
#define MSG_STORE2          18
#define MSG_STORE3          19
#define MSG_STORE4          20
#define MSG_DIG             21
#define MSG_OPENDOOR        22
#define MSG_SHUTDOOR        23
#define MSG_TPLEVEL         24
#define MSG_BELL            25
#define MSG_NOTHING_TO_OPEN 26
#define MSG_LOCKPICK_FAIL   27
#define MSG_STAIRS          28
#define MSG_HITPOINT_WARN   29

#define MSG_MAX             30

/*
 * 'Magic' macro that changes the default message type.
 * set_message_type sets a static variable to be T, and
 * then parses the following string as a format string.
 */
#define MESSAGE_TYPE(T)		"%v", set_message_type, (T)

/*
 * Message types used for msgf()  (See util.c)
 */
#define MSGT_GENERIC		 MESSAGE_TYPE(0)
#define MSGT_HIT             MESSAGE_TYPE(1)
#define MSGT_MISS            MESSAGE_TYPE(2)
#define MSGT_FLEE            MESSAGE_TYPE(3)
#define MSGT_DROP            MESSAGE_TYPE(4)
#define MSGT_KILL            MESSAGE_TYPE(5)
#define MSGT_LEVEL           MESSAGE_TYPE(6)
#define MSGT_DEATH           MESSAGE_TYPE(7)
#define MSGT_STUDY           MESSAGE_TYPE(8)
#define MSGT_TELEPORT        MESSAGE_TYPE(9)
#define MSGT_SHOOT           MESSAGE_TYPE(10)
#define MSGT_QUAFF           MESSAGE_TYPE(11)
#define MSGT_ZAP             MESSAGE_TYPE(12)
#define MSGT_WALK            MESSAGE_TYPE(13)
#define MSGT_TPOTHER         MESSAGE_TYPE(14)
#define MSGT_HITWALL         MESSAGE_TYPE(15)
#define MSGT_EAT             MESSAGE_TYPE(16)
#define MSGT_STORE1          MESSAGE_TYPE(17)
#define MSGT_STORE2          MESSAGE_TYPE(18)
#define MSGT_STORE3          MESSAGE_TYPE(19)
#define MSGT_STORE4          MESSAGE_TYPE(20)
#define MSGT_DIG             MESSAGE_TYPE(21)
#define MSGT_OPENDOOR        MESSAGE_TYPE(22)
#define MSGT_SHUTDOOR        MESSAGE_TYPE(23)
#define MSGT_TPLEVEL         MESSAGE_TYPE(24)
#define MSGT_BELL            MESSAGE_TYPE(25)
#define MSGT_NOTHING_TO_OPEN MESSAGE_TYPE(26)
#define MSGT_LOCKPICK_FAIL   MESSAGE_TYPE(27)
#define MSGT_STAIRS          MESSAGE_TYPE(28)
#define MSGT_HITPOINT_WARN   MESSAGE_TYPE(29)




/*** Sound constants ***/


/*
 * Mega-Hack -- some primitive sound support (see "main-win.c")
 *
 * Some "sound" constants for "Term_xtra(TERM_XTRA_SOUND, val)"
 */
#define SOUND_NONE		 0
#define SOUND_HIT        1
#define SOUND_MISS       2
#define SOUND_FLEE       3
#define SOUND_DROP       4
#define SOUND_KILL       5
#define SOUND_LEVEL      6
#define SOUND_DEATH      7
#define SOUND_STUDY      8
#define SOUND_TELEPORT   9
#define SOUND_SHOOT     10
#define SOUND_QUAFF     11
#define SOUND_ZAP       12
#define SOUND_WALK      13
#define SOUND_TPOTHER   14
#define SOUND_HITWALL   15
#define SOUND_EAT       16
#define SOUND_STORE1    17
#define SOUND_STORE2    18
#define SOUND_STORE3    19
#define SOUND_STORE4    20
#define SOUND_DIG       21
#define SOUND_OPENDOOR  22
#define SOUND_SHUTDOOR  23
#define SOUND_TPLEVEL   24
#define SOUND_SCROLL	25
#define SOUND_BUY	    26
#define SOUND_SELL	    27
#define SOUND_WARN	    28
#define SOUND_ROCKET    29		/* Somebody's shooting rockets */
#define SOUND_N_KILL    30		/* The player kills a non-living/undead monster */
#define SOUND_U_KILL    31		/* The player kills a unique */
#define SOUND_QUEST     32		/* The player has just completed a quest */
#define SOUND_HEAL      33		/* The player was healed a little bit */
#define SOUND_X_HEAL    34		/* The player was healed full health */
#define SOUND_BITE      35		/* A monster bites you */
#define SOUND_CLAW      36		/* A monster claws you */
#define SOUND_M_SPELL   37		/* A monster casts a miscellaneous spell */
#define SOUND_SUMMON    38		/* A monster casts a summoning spell */
#define SOUND_BREATH    39		/* A monster breathes */
#define SOUND_BALL      40		/* A monster casts a ball / bolt spell */
#define SOUND_M_HEAL    41		/* A monster heals itself somehow */
#define SOUND_ATK_SPELL 42		/* A monster casts a misc. offensive spell */
#define SOUND_EVIL      43		/* Something nasty has just happened! */
#define SOUND_TOUCH     44		/* A monster touches you */
#define SOUND_STING     45		/* A monster stings you */
#define SOUND_CRUSH     46		/* A monster crushes / envelopes you */
#define SOUND_SLIME     47		/* A monster drools/spits/etc on you */
#define SOUND_WAIL      48		/* A monster wails */
#define SOUND_WINNER    49		/* Just won the game! */
#define SOUND_FIRE      50		/* An item was burned */
#define SOUND_ACID      51		/* An item was destroyed by acid */
#define SOUND_ELEC      52		/* An item was destroyed by electricity */
#define SOUND_COLD      53		/* An item was shattered */
#define SOUND_ILLEGAL   54		/* Illegal command attempted */
#define SOUND_FAIL      55		/* Fail to get a spell off / activate an item */
#define SOUND_WAKEUP    56		/* A monster wakes up */
#define SOUND_INVULN    57		/* Invulnerability! */
#define SOUND_FALL      58		/* Falling through a trapdoor... */
#define SOUND_PAIN      59		/* A monster is in pain! */
#define SOUND_DESTITEM  60		/* An item was destroyed by misc. means */
#define SOUND_MOAN      61		/* A monster makes a moan/beg/insult attack */
#define SOUND_SHOW      62		/* A monster makes a "show" attack */
#define SOUND_UNUSED    63		/* (no sound for gaze attacks) */
#define SOUND_EXPLODE   64		/* Something (or somebody) explodes */

/*
 * Mega-Hack -- maximum known sounds
 */
#define SOUND_MAX 65


#define V_COMPASSION	1
#define V_HONOUR		2
#define V_JUSTICE	    3
#define V_SACRIFICE	    4
#define V_KNOWLEDGE	    5
#define V_FAITH 	    6
#define V_ENLIGHTEN	    7
#define V_ENCHANT	    8
#define V_CHANCE	    9
#define V_NATURE	   10
#define V_HARMONY	   11
#define V_VITALITY	   12
#define V_UNLIFE	   13
#define V_PATIENCE	   14
#define V_TEMPERANCE   15
#define V_DILIGENCE	   16
#define V_VALOUR	   17
#define V_INDIVIDUALISM    18

#define MAX_VIRTUE		18

/*
 * Number of virtues the player can have
 * ToDo: Check if changing this value breaks anything
 * (apart from savefile compatibility).
 */
#define MAX_PLAYER_VIRTUES 8


/*
 * Available graphic modes
 */
#define GRAPHICS_NONE			0
#define GRAPHICS_ORIGINAL		1
#define GRAPHICS_ADAM_BOLT		2
#define GRAPHICS_DAVID_GERVAIS	3
#define GRAPHICS_ANY			4
#define GRAPHICS_HALF_3D		5

/*
 * Modes for the random name generator
 */
#define NAME_DWARF  1
#define NAME_ELF    2
#define NAME_GNOME  3
#define NAME_HOBBIT 4
#define NAME_HUMAN  5
#define NAME_ORC    6

/*
 * Modes for the tokenizer
 */
#define TOKENIZE_CHECKQUOTE 0x01	/* Special handling of single quotes */

/*
 * Automatic note taking types
 */
#define NOTE_BIRTH		1
#define NOTE_WINNER		2
#define NOTE_SAVE_GAME		3
#define NOTE_ENTER_DUNGEON	4

/*
 * Field information flags
 */
#define FIELD_INFO_TEMP		0x0001	/* Temporary field - use counter */
#define FIELD_INFO_FEAT		0x0002	/* Terrain feature based field */
#define FIELD_INFO_VIS		0x0004	/* Has attr / char */
#define FIELD_INFO_MARK		0x0008	/* Known */
#define FIELD_INFO_TRANS	0x0010	/* Tile uses 16x16 transparency effects */
#define FIELD_INFO_NO_LOOK	0x0020	/* Do not describe when looked at */
#define FIELD_INFO_NFT_LOOK	0x0040	/* Do not describe feat when looked at */
#define FIELD_INFO_MERGE	0x0080	/* Merge counter with similar fields */
#define FIELD_INFO_NO_ENTER	0x0100	/* Grid blocks player entry */
#define FIELD_INFO_NO_MAGIC	0x0200	/* Grid blocks magic */
#define FIELD_INFO_NO_OBJCT	0x0400	/* Grid cannot hold objects */
#define FIELD_INFO_PERM		0x0800	/* Grid is not affected by disintegrate */
#define FIELD_INFO_IGNORE	0x1000	/* Grid is below the object layer */
#define FIELD_INFO_NO_MPLACE 0x2000	/* Grid blocks monster placement */
#define FIELD_INFO_DUMMY13	0x4000
#define FIELD_INFO_DUMMY14  0x8000

#define FTYPE_NOTHING	0
#define FTYPE_TRAP		1
#define FTYPE_DOOR		2
#define FTYPE_BUILD		3
#define FTYPE_FEAT		4
#define FTYPE_QUEST		5
#define FTYPE_FIELD		6
#define FTYPE_CORPSE	7
#define FTYPE_MISC		8

/*
 * Field Actions
 */
#define FIELD_ACT_INIT			0	/* Initialise the field data */
#define FIELD_ACT_LOAD			1	/* Loading Initialisation */
#define FIELD_ACT_PLAYER_ENTER	2	/* Player walks onto square */
#define FIELD_ACT_PLAYER_ON		3	/* Player is on square */
#define FIELD_ACT_MONSTER_ENTER	4	/* Monster walks onto square */
#define FIELD_ACT_MONSTER_ON	5	/* Monster is on square */
#define FIELD_ACT_OBJECT_DROP	6	/* Object lands on square */
#define FIELD_ACT_OBJECT_ON		7	/* Object is on square */
#define FIELD_ACT_INTERACT		8	/* Type-specific interation */
#define FIELD_ACT_MAGIC_TARGET	9	/* Targeting this square */
#define FIELD_ACT_LOOK			10	/* Hook for name of field when looking */
#define FIELD_ACT_EXIT			11	/* Field is destroyed */
#define FIELD_ACT_MONSTER_AI	12	/* Monster AI hook */
#define FIELD_ACT_SPECIAL		13	/* Special, type specific action */
#define FIELD_ACT_INTERACT_TEST	14	/* Test for type of player interaction */
#define FIELD_ACT_MON_ENTER_TEST 15	/* Monster attempts to enter grid */
#define FIELD_ACT_BUILD_ACT1	16	/* Building prelimiary action */
#define FIELD_ACT_BUILD_ACT2	17	/* Building final action */
#define FIELD_ACT_STORE_ACT1	18	/* Store object antiselection action */
#define FIELD_ACT_STORE_ACT2	19	/* Store object selection action */
#define FIELD_ACT_SB_INIT		20	/* Initialize a store / building */
#define FIELD_ACTION_MAX		21

#define ACT_TUNNEL		0
#define ACT_DISARM		1
#define ACT_OPEN		2

/* To make the declarations in externs.h simpler */
#define DECL_FIELD_ACTION(N) \
	extern bool field_action_##N (field_type *f_ptr, va_list vp)

/*
 * Player displays
 */
#define DISPLAY_PLAYER_STANDARD		0	/* standard display */
#define DISPLAY_PLAYER_SUMMARY		1	/* summary of various things */
#define DISPLAY_PLAYER_FLAG             2

#define DISPLAY_PLAYER_MAX		3

/* Types of object list */
#define LIST_INVEN			1
#define LIST_EQUIP			2
#define LIST_FLOOR			3
#define LIST_STORE			4
#define LIST_HOME			5

/* Locations of the tables on the screen (see ui.c / birth.c) */
#define HEADER_ROW		1
#define QUESTION_ROW	7
#define TABLE_ROW		10

#define INVALID_CHOICE 255

/*
 * Useful macros for lua interface.
 */
#define LUA_VAR(A) \
	#A, (A)
#define LUA_VAR_NAMED(A, N) \
	N, (A)
#define LUA_RETURN(A) \
	#A, &(A)
#define LUA_RETURN_NAMED(A, N) \
	N, &(A)
#define LUA_OBJECT(A) \
	"object", "object_type", (void *)(A)
#define LUA_OBJECT_NAMED(A, N) \
	N, "object_type", (void *)(A)
