# Copyright 2014-2015 Canonical Ltd.  This software is licensed under the
# GNU Affero General Public License version 3 (see the file LICENSE).

"""Model for a nodes physical block device."""

from __future__ import (
    absolute_import,
    print_function,
    unicode_literals,
    )

str = None

__metaclass__ = type
__all__ = [
    'PhysicalBlockDevice',
    ]

from django.db.models import CharField
from maasserver import DefaultMeta
from maasserver.models.blockdevice import BlockDevice


class PhysicalBlockDevice(BlockDevice):
    """A physical block device attached to a node."""

    class Meta(DefaultMeta):
        """Needed for South to recognize this model."""

    model = CharField(
        max_length=255, blank=True, null=False,
        help_text="Model name of block device.")

    serial = CharField(
        max_length=255, blank=True, null=False,
        help_text="Serial number of block device.")
