/* getLength.java -- Some checks for the getLength() method in the 
                     PlainDocument class.
   Copyright (C) 2006  David Gilbert <david.gilbert@object-refinery.com>
This file is part of Mauve.

Mauve is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Mauve is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with Mauve; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
02110-1301 USA.

*/

// Tags: 1.2

package gnu.testlet.javax.swing.text.PlainDocument;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;

import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class getLength implements Testlet
{
    
  /**
   * Runs the test using the specified harness.
   * 
   * @param harness  the test harness (<code>null</code> not permitted).
   */
  public void test(TestHarness harness)      
  {
    PlainDocument d = new PlainDocument();
    
    harness.check(d.getLength(), 0);
    try
    {
      d.insertString(0, "ABC", null);
    }
    catch (BadLocationException e)
    {
      // ignore - checks will fail if this happens
    }
    harness.check(d.getLength(), 3);
    
    // try adding a string with a '\n'
    try
    {
      d.insertString(0, "ABC\n", null);
    }
    catch (BadLocationException e)
    {
      // ignore - checks will fail if this happens
    }
    harness.check(d.getLength(), 7);
  }

}