/*
 * Decompiled with CFR 0.152.
 */
package com.wombatinvasion.pmwikidraw;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import org.jhotdraw.figures.GroupCommand;
import org.jhotdraw.figures.UngroupCommand;
import org.jhotdraw.framework.DrawingEditor;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.framework.Painter;
import org.jhotdraw.framework.PointConstrainer;
import org.jhotdraw.standard.CopyCommand;
import org.jhotdraw.standard.CutCommand;
import org.jhotdraw.standard.DuplicateCommand;
import org.jhotdraw.standard.PasteCommand;
import org.jhotdraw.standard.StandardDrawingView;
import org.jhotdraw.util.Command;
import org.jhotdraw.util.RedoCommand;
import org.jhotdraw.util.UndoCommand;
import org.jhotdraw.util.UndoableCommand;

public class PmWikiDrawingView
extends StandardDrawingView {
    private static final long serialVersionUID = -1L;
    private boolean fQualityMode = true;
    private KeyListener keyListener = null;

    public PmWikiDrawingView(DrawingEditor drawingEditor, int n, int n2) {
        super(drawingEditor, n, n2);
        this.addBackground(new Painter(){

            public void draw(Graphics graphics, DrawingView drawingView) {
                Rectangle rectangle = graphics.getClipBounds();
                PointConstrainer pointConstrainer = drawingView.getConstrainer();
                if (rectangle != null && pointConstrainer != null) {
                    int n;
                    int n2 = pointConstrainer.getStepX();
                    int n3 = pointConstrainer.getStepY();
                    int n4 = rectangle.x + (n2 - rectangle.x % n2 - n2);
                    graphics.setColor(Color.lightGray);
                    int n5 = n4;
                    int n6 = n;
                    int n7 = rectangle.x + rectangle.width + n2;
                    int n8 = rectangle.y + rectangle.height + n3;
                    Stroke stroke = ((Graphics2D)graphics).getStroke();
                    ((Graphics2D)graphics).setStroke(new BasicStroke(0.5f));
                    for (n = rectangle.y + (n3 - rectangle.y % n3 - n3); n <= n8; n += n3) {
                        graphics.drawLine(n4, n, n4 + rectangle.width + 10, n);
                    }
                    n = n6;
                    for (n4 = n5; n4 <= n7; n4 += n2) {
                        graphics.drawLine(n4, n, n4, n + rectangle.height + 10);
                    }
                    ((Graphics2D)graphics).setStroke(stroke);
                }
            }
        });
    }

    public void drawDrawing(Graphics graphics) {
        if (this.fQualityMode) {
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        }
        super.drawDrawing(graphics);
    }

    public void setQualityMode(boolean bl) {
        this.fQualityMode = bl;
    }

    public boolean getQualityMode() {
        return this.fQualityMode;
    }

    protected KeyListener createKeyListener() {
        return new PmWikiDrawingViewKeyListener();
    }

    public class PmWikiDrawingViewKeyListener
    extends StandardDrawingView.DrawingViewKeyListener {
        Command cutCmd;
        Command copyCmd;
        Command pasteCmd;
        Command duplicateCmd;
        Command groupCmd;
        Command unGroupCmd;
        Command undo;
        Command redo;

        public PmWikiDrawingViewKeyListener() {
            super(PmWikiDrawingView.this);
            this.cutCmd = new UndoableCommand(new CutCommand("Cut", PmWikiDrawingView.this.editor()));
            this.copyCmd = new UndoableCommand(new CopyCommand("Copy", PmWikiDrawingView.this.editor()));
            this.pasteCmd = new UndoableCommand(new PasteCommand("Paste", PmWikiDrawingView.this.editor()));
            this.duplicateCmd = new UndoableCommand(new DuplicateCommand("Copy", PmWikiDrawingView.this.editor()));
            this.groupCmd = new UndoableCommand(new GroupCommand("Group", PmWikiDrawingView.this.editor()));
            this.unGroupCmd = new UndoableCommand(new UngroupCommand("UnGroup", PmWikiDrawingView.this.editor()));
            this.undo = new UndoCommand("Undo", PmWikiDrawingView.this.editor());
            this.redo = new RedoCommand("Undo", PmWikiDrawingView.this.editor());
        }

        public void keyPressed(KeyEvent keyEvent) {
            block17: {
                block16: {
                    int n = keyEvent.getKeyCode();
                    if ((keyEvent.getModifiers() & 2) != 2) break block16;
                    switch (n) {
                        case 88: {
                            if (this.cutCmd.isExecutable()) {
                                this.cutCmd.execute();
                                break;
                            }
                            break block17;
                        }
                        case 67: {
                            if (this.copyCmd.isExecutable()) {
                                this.copyCmd.execute();
                                break;
                            }
                            break block17;
                        }
                        case 86: {
                            if (this.pasteCmd.isExecutable()) {
                                this.pasteCmd.execute();
                                break;
                            }
                            break block17;
                        }
                        case 71: {
                            if (this.groupCmd.isExecutable()) {
                                this.groupCmd.execute();
                                break;
                            }
                            break block17;
                        }
                        case 85: {
                            if (this.unGroupCmd.isExecutable()) {
                                this.unGroupCmd.execute();
                                break;
                            }
                            break block17;
                        }
                        case 90: {
                            if (this.undo.isExecutable()) {
                                this.undo.execute();
                                break;
                            }
                            break block17;
                        }
                        case 89: {
                            if (this.redo.isExecutable()) {
                                this.redo.execute();
                                break;
                            }
                            break block17;
                        }
                        default: {
                            super.keyPressed(keyEvent);
                            break;
                        }
                    }
                    break block17;
                }
                super.keyPressed(keyEvent);
            }
        }
    }
}

