############## mysql-test\t\query_alloc_block_size_basic.test ###############
#                                                                             #
# Variable Name: query_alloc_block_size                                       #
# Scope: GLOBAL | SESSION                                                     #
# Access Type: Dynamic                                                        #
# Data Type: numeric                                                          #
# Default Value:  8192                                                        #
# Range: 1024-4294967295                                                      #
#                                                                             #
#                                                                             #
# Creation Date: 2008-02-07                                                   #
# Author:  Salman                                                             #
#                                                                             #
# Description: Test Cases of Dynamic System Variable query_alloc_block_size   #
#              that checks the behavior of this variable in the following ways#
#              * Default Value                                                #
#              * Valid & Invalid values                                       #
#              * Scope & Access method                                        #
#              * Data Integrity                                               #
#                                                                             #
# Reference: http://dev.mysql.com/doc/refman/5.1/en/                          #
#  server-system-variables.html                                               #
#                                                                             #
###############################################################################

--source include/load_sysvars.inc

###################################################################
#           START OF query_alloc_block_size TESTS                    #
###################################################################


#############################################################
#                 Save initial value                        #
#############################################################

SET @start_global_value = @@global.query_alloc_block_size;
SELECT @start_global_value;
SET @start_session_value = @@session.query_alloc_block_size;
SELECT @start_session_value;


--echo '#--------------------FN_DYNVARS_130_01-------------------------#'
###################################################################
#     Display the DEFAULT value of query_alloc_block_size            #
###################################################################

SET @@global.query_alloc_block_size = 10000;
SET @@global.query_alloc_block_size = DEFAULT;
SELECT @@global.query_alloc_block_size;

SET @@session.query_alloc_block_size = 20000;
SET @@session.query_alloc_block_size = DEFAULT;
SELECT @@session.query_alloc_block_size;


--echo '#--------------------FN_DYNVARS_130_02-------------------------#'
###################################################################
#     Check the DEFAULT value of query_alloc_block_size              #
###################################################################

SET @@global.query_alloc_block_size = DEFAULT;
SELECT @@global.query_alloc_block_size = 8192;

SET @@session.query_alloc_block_size = DEFAULT;
SELECT @@session.query_alloc_block_size = 8192;


--echo '#--------------------FN_DYNVARS_130_03-------------------------#'
#############################################################################
# Change the value of query_alloc_block_size to a valid value for GLOBAL Scope #
#############################################################################

SET @@global.query_alloc_block_size = 1024;
SELECT @@global.query_alloc_block_size;
SET @@global.query_alloc_block_size = 1025;
SELECT @@global.query_alloc_block_size;
SET @@global.query_alloc_block_size = 4294967295;
SELECT @@global.query_alloc_block_size;
SET @@global.query_alloc_block_size = 4294967294;
SELECT @@global.query_alloc_block_size;
SET @@global.query_alloc_block_size = 65536;
SELECT @@global.query_alloc_block_size;

--echo '#--------------------FN_DYNVARS_130_04-------------------------#'
#################################################################################
# Change the value of query_alloc_block_size to a valid value for SESSION Scope #
#################################################################################
 
SET @@session.query_alloc_block_size = 1024;
SELECT @@session.query_alloc_block_size;
SET @@session.query_alloc_block_size = 1025;
SELECT @@session.query_alloc_block_size;
SET @@session.query_alloc_block_size = 4294967295;
SELECT @@session.query_alloc_block_size;
SET @@session.query_alloc_block_size = 4294967294;
SELECT @@session.query_alloc_block_size;
SET @@session.query_alloc_block_size = 655536;
SELECT @@session.query_alloc_block_size;

--echo '#------------------FN_DYNVARS_130_05-----------------------#'
##################################################################
# Change the value of query_alloc_block_size to an invalid value #
##################################################################

SET @@global.query_alloc_block_size = 64;
SELECT @@global.query_alloc_block_size;
SET @@global.query_alloc_block_size = -1;
SELECT @@global.query_alloc_block_size;
SET @@global.query_alloc_block_size = 1023;
SELECT @@global.query_alloc_block_size;
SET @@global.query_alloc_block_size = 4294967296;
SELECT @@global.query_alloc_block_size;
--Error ER_WRONG_TYPE_FOR_VAR
SET @@global.query_alloc_block_size = 65530.34;
SELECT @@global.query_alloc_block_size;
--Error ER_WRONG_TYPE_FOR_VAR
SET @@global.query_alloc_block_size = test;
SELECT @@global.query_alloc_block_size;

SET @@session.query_alloc_block_size = 64;
SELECT @@session.query_alloc_block_size;
SET @@session.query_alloc_block_size = -2;
SELECT @@session.query_alloc_block_size;
--Error ER_WRONG_TYPE_FOR_VAR
SET @@session.query_alloc_block_size = 65530.34;
SET @@session.query_alloc_block_size = 1023;
SELECT @@session.query_alloc_block_size;
#SET @@session.query_alloc_block_size = 4294967296;
#SELECT @@session.query_alloc_block_size;

--Error ER_WRONG_TYPE_FOR_VAR
SET @@session.query_alloc_block_size = test;
SELECT @@session.query_alloc_block_size;

--echo '#------------------FN_DYNVARS_130_06-----------------------#'
####################################################################
#   Check if the value in GLOBAL Table matches value in variable   #
####################################################################

#SET @@global.query_alloc_block_size = 1;
#SET @@session.query_alloc_block_size = 12;

SET @@global.query_alloc_block_size = 1;
SET @@session.query_alloc_block_size = 12;

SELECT @@global.query_alloc_block_size = 
VARIABLE_VALUE FROM INFORMATION_SCHEMA.GLOBAL_VARIABLES 
WHERE VARIABLE_NAME='query_alloc_block_size';


--echo '#------------------FN_DYNVARS_130_07-----------------------#'
####################################################################
#  Check if the value in SESSION Table matches value in variable   #
####################################################################

SELECT @@session.query_alloc_block_size = VARIABLE_VALUE 
FROM INFORMATION_SCHEMA.SESSION_VARIABLES 
WHERE VARIABLE_NAME='query_alloc_block_size';


--echo '#------------------FN_DYNVARS_130_08-----------------------#'
####################################################################
#     Check if TRUE and FALSE values can be used on variable       #
####################################################################

SET @@global.query_alloc_block_size = TRUE;
SELECT @@global.query_alloc_block_size;
SET @@global.query_alloc_block_size = FALSE;
SELECT @@global.query_alloc_block_size;


--echo '#---------------------FN_DYNVARS_130_09----------------------#'
#################################################################################
#  Check if accessing variable with and without GLOBAL point to same variable   #
################################################################################# 

SET @@global.query_alloc_block_size = 2048;
SELECT @@query_alloc_block_size = @@global.query_alloc_block_size;


--echo '#---------------------FN_DYNVARS_130_10----------------------#'
########################################################################################################
#    Check if accessing variable with SESSION,LOCAL and without SCOPE points to same session variable  #
########################################################################################################

SET @@query_alloc_block_size = 5000;
SELECT @@query_alloc_block_size = @@local.query_alloc_block_size;
SELECT @@local.query_alloc_block_size = @@session.query_alloc_block_size;


--echo '#---------------------FN_DYNVARS_130_11----------------------#'
##############################################################################
#   Check if query_alloc_block_size can be accessed with and without @@ sign    #
##############################################################################

SET query_alloc_block_size = 1024;
SELECT @@query_alloc_block_size;
--Error ER_UNKNOWN_TABLE
SELECT local.query_alloc_block_size;
--Error ER_UNKNOWN_TABLE
SELECT session.query_alloc_block_size;
--Error ER_BAD_FIELD_ERROR
SELECT query_alloc_block_size = @@session.query_alloc_block_size;


####################################
#     Restore initial value        #
####################################

SET @@global.query_alloc_block_size = @start_global_value;
SELECT @@global.query_alloc_block_size;
SET @@session.query_alloc_block_size = @start_session_value;
SELECT @@session.query_alloc_block_size;


########################################################
#              END OF query_alloc_block_size TESTS     #
########################################################

