+++
title = "SphericalSegment"
+++

### SphericalSegment

A spherical segment, obtained from a spherical ball by two parallel cuts.

<img src="/img/draw/ff/3d/SphericalSegment.png" width="30%" >
<img src="/img/draw/ff/2d/SphericalSegment_xy.svg" width="30%">
<img src="/img/draw/ff/2d/SphericalSegment_xz.svg" width="30%">

#### Constructor

```python
SphericalSegment(R, t, b)
```

Parameters:
- $ R $, radius
- $ t $, cut from top
- $ b $, cut from bottom

Constraint:

$ t+b \le 2R $

#### Usage

As for any other [Form factor](/ref/sample/particle/ff).

#### Implementation

Class {{% ref-class "Sample/HardParticle" "SphericalSegment" %}} inherits from the interface class
{{% ref-class "Sample/Particle" "IFormfactor" %}}.

Computation involves numerical integration in vertical direction,

$$ F(\mathbf{q})=2\pi \exp\[iq_z(R-b)\]  \int_{-R+b}^{R-t} \text{d}z \space r_z^2 \frac{J_1(q_{||}r_z)}{q_{||}r_z} \exp(iq_z z), $$

with the notation

$$ q_{||} := \sqrt{q_x^2 + q_y^2}, \quad r_z:=\sqrt{R^2-z^2} $$

Volume [has been validated]({{% url-src %}}/Tests/Unit/Sample/FormfactorBasicTest.cpp)
against
$$ V=\dfrac{\pi}{3} \[ 4R^3 - 3R(t^2+b^2) + (t^3 + b^3) \]. $$

#### Related shapes

- [HemiEllipsoid](/ref/sample/particle/ff/hard/hemiellipsoid), top half of ellipsoid.

More general:
- [SpheroidalSegment](/ref/sample/particle/ff/hard/spheroidalsegment), spheroid truncated from the top and/or the bottom.

More special:
- [Sphere](/ref/sample/particle/ff/hard/sphere), if $t=b=0.$

#### Example

Scattering by uncorrelated, oriented truncated spheres for horizontal incidence. Rotation around $y$ axis:

<img src="/img/auto/ff/SphericalSegment.png">

Generated by {{% ref-ex "ff/SphericalSegment.py" %}}.

#### History

Agrees with the IsGISAXS form factor "Sphere" [[manual](/lit/lazzari2006), Eq. 2.32] and "Truncated sphere" [[Renaud 2009](/lit/renaud2009), Eq. 228]. It is *not* "Truncated sphere" of FitGISAXS, which is without top removal [[Babonneau 2013](/lit/babonneau2013)].
