#!/bin/bash

currentlogdir=src/contrib/nightlysummary/currentlogs

## Grab logs:
rm $currentlogdir/*
mkdir $currentlogdir
wget -P $currentlogdir ftp://ftp.mcs.anl.gov/pub/petsc/nightlylogs/*.log


OUTFILE=src/contrib/nightlysummary/html/index.html

echo "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">" > $OUTFILE
echo "<html>" >> $OUTFILE
echo "<head><title>PETSc Test Summary</title>" >> $OUTFILE
echo "<link href=\"style.css\" rel=\"stylesheet\" type=\"text/css\"></head>" >> $OUTFILE
echo "<body><div class=\"main\">" >> $OUTFILE
echo "<center>Last update: " >> $OUTFILE
date >> $OUTFILE
echo "</center>" >> $OUTFILE
echo "<h1>PETSc Test Summary</h1>" >> $OUTFILE
echo "<p>This page is an automated summary of the output generated by the <a href=\"http://ftp.mcs.anl.gov/pub/petsc/nightlylogs/\">Nightly logs</a>. It serves as a basis for discussion rather than trying to be a full-fledged testing solution.</p>" >> $OUTFILE

# Writes a full result table
# inputs:
#  $1 ... Table Title
#  $2 ... File prefix for log files
#
generate_section()
{
  echo "<h3>$1</h3>" >> $OUTFILE
  echo "<center><table>" >> $OUTFILE
  echo "<tr><th>Test</th><th>Warnings</th><th>Errors</th></tr>" >> $OUTFILE

  for f in `ls $currentlogdir/$2*.log`
  do
    echo "Processing file $f..."
    echo "<tr><td class=\"desc\">" >> $OUTFILE
    echo "<a href=\"http://ftp.mcs.anl.gov/pub/petsc/nightlylogs/${f#$currentlogdir/}\">${f#$currentlogdir/}</a>" >> $OUTFILE

    # Write number of warnings:
    numwarnings=`grep "[Ww]arning[: ]" $f | wc -l`
    if [ "$numwarnings" -gt "0" ]
    then
	  echo "</td><td class=\"yellow\">$numwarnings</td>" >> $OUTFILE
    else
	  echo "</td><td class=\"green\">$numwarnings</td>" >> $OUTFILE
    fi

    # Write number of errors:
    numerrors=`grep " [Kk]illed\| [Ff]atal[: ]\| [Ee][Rr][Rr][Oo][Rr][: ]" $f | wc -l`
    if [ "$numerrors" -gt "0" ]
    then
	  echo "</td><td class=\"red\">$numerrors</td></tr>" >> $OUTFILE
    else
	  echo "</td><td class=\"green\">$numerrors</td></tr>" >> $OUTFILE
    fi
  done
  echo "</table></center>" >> $OUTFILE
}



############ Part 1: Build ####################
#generate_section Configure configure  #Note: Current grep-driven extraction is not suitable for configure*.log files
generate_section Build     build
generate_section Examples  examples
generate_section Make      make


echo "</div></body></html>" >> $OUTFILE

