/* $Cambridge: hermes/src/prayer/session/portlist.h,v 1.3 2008/09/16 09:59:58 dpc22 Exp $ */
/************************************************
 *    Prayer - a Webmail Interface              *
 ************************************************/

/* Copyright (c) University of Cambridge 2000 - 2008 */
/* See the file NOTICE for conditions of use and distribution. */

/* Data structures which describe lists of internet domain sockets and
 * ports used for HTTP connects direct to Prayer in direct mode operation */

struct port {
    struct port *next;          /* Linked list */
    char *name;                 /* NIL */
    int sockfd;                 /* Socket descriptor associated with this socket */
    unsigned long inet_port;    /* Internet domain port associated with socket */
    pid_t pid;                  /* Process id associated with port if active */
};

struct portlist {
    struct list *idle;          /* List of idle ports */
    struct list *active;        /* List of active ports */
    unsigned long next;         /* Range to draw fresh ports from */
    unsigned long last;
};

struct portlist *portlist_create(unsigned long first_port,
                                 unsigned long count);
void portlist_free(struct portlist *pl);

struct port *portlist_reserve_port(struct portlist *pl);
BOOL portlist_free_port_bypid(struct portlist *pl, pid_t pid);
BOOL portlist_free_port(struct portlist *pl, unsigned long inet_port);

void portlist_close_all(struct portlist *pl);
void portlist_close_all_except(struct portlist *pl, int except_fd);
