# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Dict, List, Optional, Union

import msrest.serialization

from ._device_update_client_enums import *


class AccessCondition(msrest.serialization.Model):
    """Parameter group.

    :param if_none_match: Defines the If-None-Match condition. The operation will be performed only
     if the ETag on the server does not match this value.
    :type if_none_match: str
    """

    _attribute_map = {
        'if_none_match': {'key': 'If-None-Match', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        if_none_match: Optional[str] = None,
        **kwargs
    ):
        super(AccessCondition, self).__init__(**kwargs)
        self.if_none_match = if_none_match


class Compatibility(msrest.serialization.Model):
    """Update compatibility information.

    All required parameters must be populated in order to send to Azure.

    :param device_manufacturer: Required. The manufacturer of device the update is compatible with.
    :type device_manufacturer: str
    :param device_model: Required. The model of device the update is compatible with.
    :type device_model: str
    """

    _validation = {
        'device_manufacturer': {'required': True},
        'device_model': {'required': True},
    }

    _attribute_map = {
        'device_manufacturer': {'key': 'deviceManufacturer', 'type': 'str'},
        'device_model': {'key': 'deviceModel', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        device_manufacturer: str,
        device_model: str,
        **kwargs
    ):
        super(Compatibility, self).__init__(**kwargs)
        self.device_manufacturer = device_manufacturer
        self.device_model = device_model


class Deployment(msrest.serialization.Model):
    """Deployment metadata.

    All required parameters must be populated in order to send to Azure.

    :param deployment_id: Required. Gets or sets the deployment identifier.
    :type deployment_id: str
    :param deployment_type: Required. Gets or sets the deployment type. Possible values include:
     "Complete", "Download", "Install".
    :type deployment_type: str or ~azure.iot.deviceupdate.models.DeploymentType
    :param device_class_id: Gets or sets the device class identifier.
    :type device_class_id: str
    :param start_date_time: Required. Gets or sets the Deployment start datetime.
    :type start_date_time: ~datetime.datetime
    :param device_group_type: Required. Gets or sets the device group type. Possible values
     include: "All", "Devices", "DeviceGroupDefinitions".
    :type device_group_type: str or ~azure.iot.deviceupdate.models.DeviceGroupType
    :param device_group_definition: Required. Gets or sets the device group definition.
    :type device_group_definition: list[str]
    :param update_id: Required. Update identity.
    :type update_id: ~azure.iot.deviceupdate.models.UpdateId
    :param is_canceled: Boolean flag indicating whether the deployment was canceled.
    :type is_canceled: bool
    :param is_retried: Boolean flag indicating whether the deployment has been retried.
    :type is_retried: bool
    :param is_completed: Boolean flag indicating whether the deployment was completed.
    :type is_completed: bool
    """

    _validation = {
        'deployment_id': {'required': True},
        'deployment_type': {'required': True},
        'start_date_time': {'required': True},
        'device_group_type': {'required': True},
        'device_group_definition': {'required': True},
        'update_id': {'required': True},
    }

    _attribute_map = {
        'deployment_id': {'key': 'deploymentId', 'type': 'str'},
        'deployment_type': {'key': 'deploymentType', 'type': 'str'},
        'device_class_id': {'key': 'deviceClassId', 'type': 'str'},
        'start_date_time': {'key': 'startDateTime', 'type': 'iso-8601'},
        'device_group_type': {'key': 'deviceGroupType', 'type': 'str'},
        'device_group_definition': {'key': 'deviceGroupDefinition', 'type': '[str]'},
        'update_id': {'key': 'updateId', 'type': 'UpdateId'},
        'is_canceled': {'key': 'isCanceled', 'type': 'bool'},
        'is_retried': {'key': 'isRetried', 'type': 'bool'},
        'is_completed': {'key': 'isCompleted', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        deployment_id: str,
        deployment_type: Union[str, "DeploymentType"],
        start_date_time: datetime.datetime,
        device_group_type: Union[str, "DeviceGroupType"],
        device_group_definition: List[str],
        update_id: "UpdateId",
        device_class_id: Optional[str] = None,
        is_canceled: Optional[bool] = None,
        is_retried: Optional[bool] = None,
        is_completed: Optional[bool] = None,
        **kwargs
    ):
        super(Deployment, self).__init__(**kwargs)
        self.deployment_id = deployment_id
        self.deployment_type = deployment_type
        self.device_class_id = device_class_id
        self.start_date_time = start_date_time
        self.device_group_type = device_group_type
        self.device_group_definition = device_group_definition
        self.update_id = update_id
        self.is_canceled = is_canceled
        self.is_retried = is_retried
        self.is_completed = is_completed


class DeploymentDeviceState(msrest.serialization.Model):
    """Deployment device status.

    All required parameters must be populated in order to send to Azure.

    :param device_id: Required. Device identity.
    :type device_id: str
    :param retry_count: Required. The number of times this deployment has been retried on this
     device.
    :type retry_count: int
    :param moved_on_to_new_deployment: Required. Boolean flag indicating whether this device is in
     a newer deployment and can no longer retry this deployment.
    :type moved_on_to_new_deployment: bool
    :param device_state: Required. Deployment device state. Possible values include: "Succeeded",
     "InProgress", "Failed", "Canceled", "Incompatible".
    :type device_state: str or ~azure.iot.deviceupdate.models.DeviceDeploymentState
    """

    _validation = {
        'device_id': {'required': True},
        'retry_count': {'required': True},
        'moved_on_to_new_deployment': {'required': True},
        'device_state': {'required': True},
    }

    _attribute_map = {
        'device_id': {'key': 'deviceId', 'type': 'str'},
        'retry_count': {'key': 'retryCount', 'type': 'int'},
        'moved_on_to_new_deployment': {'key': 'movedOnToNewDeployment', 'type': 'bool'},
        'device_state': {'key': 'deviceState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        device_id: str,
        retry_count: int,
        moved_on_to_new_deployment: bool,
        device_state: Union[str, "DeviceDeploymentState"],
        **kwargs
    ):
        super(DeploymentDeviceState, self).__init__(**kwargs)
        self.device_id = device_id
        self.retry_count = retry_count
        self.moved_on_to_new_deployment = moved_on_to_new_deployment
        self.device_state = device_state


class DeploymentDeviceStatesFilter(msrest.serialization.Model):
    """Deployment device state filter.

    :param device_id: Device Identifier.
    :type device_id: str
    :param device_state: The deployment device state. Possible values include: "NotStarted",
     "Incompatible", "AlreadyInDeployment", "Canceled", "InProgress", "Failed", "Succeeded".
    :type device_state: str or ~azure.iot.deviceupdate.models.DeviceState
    """

    _attribute_map = {
        'device_id': {'key': 'deviceId', 'type': 'str'},
        'device_state': {'key': 'deviceState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        device_id: Optional[str] = None,
        device_state: Optional[Union[str, "DeviceState"]] = None,
        **kwargs
    ):
        super(DeploymentDeviceStatesFilter, self).__init__(**kwargs)
        self.device_id = device_id
        self.device_state = device_state


class DeploymentFilter(msrest.serialization.Model):
    """Deployment filter.

    :param provider: Update provider.
    :type provider: str
    :param name: Update name.
    :type name: str
    :param version: Update version.
    :type version: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        name: Optional[str] = None,
        version: Optional[str] = None,
        **kwargs
    ):
        super(DeploymentFilter, self).__init__(**kwargs)
        self.provider = provider
        self.name = name
        self.version = version


class DeploymentStatus(msrest.serialization.Model):
    """Deployment status metadata.

    All required parameters must be populated in order to send to Azure.

    :param deployment_state: Required. Gets or sets the state of the deployment. Possible values
     include: "Active", "Superseded", "Canceled".
    :type deployment_state: str or ~azure.iot.deviceupdate.models.DeploymentState
    :param total_devices: Gets or sets the total number of devices in the deployment.
    :type total_devices: int
    :param devices_incompatible_count: Gets or sets the number of incompatible devices in the
     deployment.
    :type devices_incompatible_count: int
    :param devices_in_progress_count: Gets or sets the number of devices that are currently in
     deployment.
    :type devices_in_progress_count: int
    :param devices_completed_failed_count: Gets or sets the number of devices that have completed
     deployment with a failure.
    :type devices_completed_failed_count: int
    :param devices_completed_succeeded_count: Gets or sets the number of devices which have
     successfully completed deployment.
    :type devices_completed_succeeded_count: int
    :param devices_canceled_count: Gets or sets the number of devices which have had their
     deployment canceled.
    :type devices_canceled_count: int
    """

    _validation = {
        'deployment_state': {'required': True},
    }

    _attribute_map = {
        'deployment_state': {'key': 'deploymentState', 'type': 'str'},
        'total_devices': {'key': 'totalDevices', 'type': 'int'},
        'devices_incompatible_count': {'key': 'devicesIncompatibleCount', 'type': 'int'},
        'devices_in_progress_count': {'key': 'devicesInProgressCount', 'type': 'int'},
        'devices_completed_failed_count': {'key': 'devicesCompletedFailedCount', 'type': 'int'},
        'devices_completed_succeeded_count': {'key': 'devicesCompletedSucceededCount', 'type': 'int'},
        'devices_canceled_count': {'key': 'devicesCanceledCount', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        deployment_state: Union[str, "DeploymentState"],
        total_devices: Optional[int] = None,
        devices_incompatible_count: Optional[int] = None,
        devices_in_progress_count: Optional[int] = None,
        devices_completed_failed_count: Optional[int] = None,
        devices_completed_succeeded_count: Optional[int] = None,
        devices_canceled_count: Optional[int] = None,
        **kwargs
    ):
        super(DeploymentStatus, self).__init__(**kwargs)
        self.deployment_state = deployment_state
        self.total_devices = total_devices
        self.devices_incompatible_count = devices_incompatible_count
        self.devices_in_progress_count = devices_in_progress_count
        self.devices_completed_failed_count = devices_completed_failed_count
        self.devices_completed_succeeded_count = devices_completed_succeeded_count
        self.devices_canceled_count = devices_canceled_count


class Device(msrest.serialization.Model):
    """Device metadata.

    All required parameters must be populated in order to send to Azure.

    :param device_id: Required. Device identity.
    :type device_id: str
    :param device_class_id: Required. Device class identity.
    :type device_class_id: str
    :param manufacturer: Required. Device manufacturer.
    :type manufacturer: str
    :param model: Required. Device model.
    :type model: str
    :param group_id: Device group identity.
    :type group_id: str
    :param last_attempted_update_id: Update identity.
    :type last_attempted_update_id: ~azure.iot.deviceupdate.models.UpdateId
    :param deployment_status: State of the device in its last deployment. Possible values include:
     "Succeeded", "InProgress", "Failed", "Canceled", "Incompatible".
    :type deployment_status: str or ~azure.iot.deviceupdate.models.DeviceDeploymentState
    :param installed_update_id: Update identity.
    :type installed_update_id: ~azure.iot.deviceupdate.models.UpdateId
    :param on_latest_update: Required. Boolean flag indicating whether the latest update is
     installed on the device.
    :type on_latest_update: bool
    :param last_deployment_id: The deployment identifier for the last deployment to the device.
    :type last_deployment_id: str
    """

    _validation = {
        'device_id': {'required': True},
        'device_class_id': {'required': True},
        'manufacturer': {'required': True},
        'model': {'required': True},
        'on_latest_update': {'required': True},
    }

    _attribute_map = {
        'device_id': {'key': 'deviceId', 'type': 'str'},
        'device_class_id': {'key': 'deviceClassId', 'type': 'str'},
        'manufacturer': {'key': 'manufacturer', 'type': 'str'},
        'model': {'key': 'model', 'type': 'str'},
        'group_id': {'key': 'groupId', 'type': 'str'},
        'last_attempted_update_id': {'key': 'lastAttemptedUpdateId', 'type': 'UpdateId'},
        'deployment_status': {'key': 'deploymentStatus', 'type': 'str'},
        'installed_update_id': {'key': 'installedUpdateId', 'type': 'UpdateId'},
        'on_latest_update': {'key': 'onLatestUpdate', 'type': 'bool'},
        'last_deployment_id': {'key': 'lastDeploymentId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        device_id: str,
        device_class_id: str,
        manufacturer: str,
        model: str,
        on_latest_update: bool,
        group_id: Optional[str] = None,
        last_attempted_update_id: Optional["UpdateId"] = None,
        deployment_status: Optional[Union[str, "DeviceDeploymentState"]] = None,
        installed_update_id: Optional["UpdateId"] = None,
        last_deployment_id: Optional[str] = None,
        **kwargs
    ):
        super(Device, self).__init__(**kwargs)
        self.device_id = device_id
        self.device_class_id = device_class_id
        self.manufacturer = manufacturer
        self.model = model
        self.group_id = group_id
        self.last_attempted_update_id = last_attempted_update_id
        self.deployment_status = deployment_status
        self.installed_update_id = installed_update_id
        self.on_latest_update = on_latest_update
        self.last_deployment_id = last_deployment_id


class DeviceClass(msrest.serialization.Model):
    """Device class metadata.

    All required parameters must be populated in order to send to Azure.

    :param device_class_id: Required. The device class identifier.
    :type device_class_id: str
    :param manufacturer: Required. Device manufacturer.
    :type manufacturer: str
    :param model: Required. Device model.
    :type model: str
    :param best_compatible_update_id: Required. Update identity.
    :type best_compatible_update_id: ~azure.iot.deviceupdate.models.UpdateId
    """

    _validation = {
        'device_class_id': {'required': True},
        'manufacturer': {'required': True},
        'model': {'required': True},
        'best_compatible_update_id': {'required': True},
    }

    _attribute_map = {
        'device_class_id': {'key': 'deviceClassId', 'type': 'str'},
        'manufacturer': {'key': 'manufacturer', 'type': 'str'},
        'model': {'key': 'model', 'type': 'str'},
        'best_compatible_update_id': {'key': 'bestCompatibleUpdateId', 'type': 'UpdateId'},
    }

    def __init__(
        self,
        *,
        device_class_id: str,
        manufacturer: str,
        model: str,
        best_compatible_update_id: "UpdateId",
        **kwargs
    ):
        super(DeviceClass, self).__init__(**kwargs)
        self.device_class_id = device_class_id
        self.manufacturer = manufacturer
        self.model = model
        self.best_compatible_update_id = best_compatible_update_id


class DeviceFilter(msrest.serialization.Model):
    """Operation status filter.

    :param group_id: Device group identifier.
    :type group_id: str
    """

    _attribute_map = {
        'group_id': {'key': 'groupId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        group_id: Optional[str] = None,
        **kwargs
    ):
        super(DeviceFilter, self).__init__(**kwargs)
        self.group_id = group_id


class DeviceTag(msrest.serialization.Model):
    """Device tag properties.

    All required parameters must be populated in order to send to Azure.

    :param tag_name: Required. Tag name.
    :type tag_name: str
    :param device_count: Required. Number of devices with this tag.
    :type device_count: int
    """

    _validation = {
        'tag_name': {'required': True},
        'device_count': {'required': True},
    }

    _attribute_map = {
        'tag_name': {'key': 'tagName', 'type': 'str'},
        'device_count': {'key': 'deviceCount', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        tag_name: str,
        device_count: int,
        **kwargs
    ):
        super(DeviceTag, self).__init__(**kwargs)
        self.tag_name = tag_name
        self.device_count = device_count


class Error(msrest.serialization.Model):
    """Error details.

    All required parameters must be populated in order to send to Azure.

    :param code: Required. Server defined error code.
    :type code: str
    :param message: Required. A human-readable representation of the error.
    :type message: str
    :param target: The target of the error.
    :type target: str
    :param details: An array of errors that led to the reported error.
    :type details: list[~azure.iot.deviceupdate.models.Error]
    :param innererror: An object containing more specific information than the current object about
     the error.
    :type innererror: ~azure.iot.deviceupdate.models.InnerError
    :param occurred_date_time: Date and time in UTC when the error occurred.
    :type occurred_date_time: ~datetime.datetime
    """

    _validation = {
        'code': {'required': True},
        'message': {'required': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[Error]'},
        'innererror': {'key': 'innererror', 'type': 'InnerError'},
        'occurred_date_time': {'key': 'occurredDateTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        code: str,
        message: str,
        target: Optional[str] = None,
        details: Optional[List["Error"]] = None,
        innererror: Optional["InnerError"] = None,
        occurred_date_time: Optional[datetime.datetime] = None,
        **kwargs
    ):
        super(Error, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target
        self.details = details
        self.innererror = innererror
        self.occurred_date_time = occurred_date_time


class File(msrest.serialization.Model):
    """Update file metadata.

    All required parameters must be populated in order to send to Azure.

    :param file_id: Required. File identity, generated by server at import time.
    :type file_id: str
    :param file_name: Required. File name.
    :type file_name: str
    :param size_in_bytes: Required. File size in number of bytes.
    :type size_in_bytes: long
    :param hashes: Required. Mapping of hashing algorithm to base64 encoded hash values.
    :type hashes: dict[str, str]
    :param mime_type: File MIME type.
    :type mime_type: str
    :param etag: File ETag.
    :type etag: str
    """

    _validation = {
        'file_id': {'required': True},
        'file_name': {'required': True},
        'size_in_bytes': {'required': True},
        'hashes': {'required': True},
    }

    _attribute_map = {
        'file_id': {'key': 'fileId', 'type': 'str'},
        'file_name': {'key': 'fileName', 'type': 'str'},
        'size_in_bytes': {'key': 'sizeInBytes', 'type': 'long'},
        'hashes': {'key': 'hashes', 'type': '{str}'},
        'mime_type': {'key': 'mimeType', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        file_id: str,
        file_name: str,
        size_in_bytes: int,
        hashes: Dict[str, str],
        mime_type: Optional[str] = None,
        etag: Optional[str] = None,
        **kwargs
    ):
        super(File, self).__init__(**kwargs)
        self.file_id = file_id
        self.file_name = file_name
        self.size_in_bytes = size_in_bytes
        self.hashes = hashes
        self.mime_type = mime_type
        self.etag = etag


class FileImportMetadata(msrest.serialization.Model):
    """Metadata describing an update file.

    All required parameters must be populated in order to send to Azure.

    :param filename: Required. Update file name as specified inside import manifest.
    :type filename: str
    :param url: Required. Azure Blob location from which the update file can be downloaded by
     Device Update for IoT Hub. This is typically a read-only SAS-protected blob URL with an
     expiration set to at least 4 hours.
    :type url: str
    """

    _validation = {
        'filename': {'required': True},
        'url': {'required': True},
    }

    _attribute_map = {
        'filename': {'key': 'filename', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        filename: str,
        url: str,
        **kwargs
    ):
        super(FileImportMetadata, self).__init__(**kwargs)
        self.filename = filename
        self.url = url


class Group(msrest.serialization.Model):
    """Group details.

    All required parameters must be populated in order to send to Azure.

    :param group_id: Required. Group identity.
    :type group_id: str
    :param group_type: Required. Group type. Possible values include: "IoTHubTag".
    :type group_type: str or ~azure.iot.deviceupdate.models.GroupType
    :param tags: Required. A set of tags. IoT Hub tags.
    :type tags: list[str]
    :param created_date_time: Required. Date and time when the update was created.
    :type created_date_time: str
    :param device_count: The number of devices in the group.
    :type device_count: int
    """

    _validation = {
        'group_id': {'required': True},
        'group_type': {'required': True},
        'tags': {'required': True},
        'created_date_time': {'required': True},
    }

    _attribute_map = {
        'group_id': {'key': 'groupId', 'type': 'str'},
        'group_type': {'key': 'groupType', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '[str]'},
        'created_date_time': {'key': 'createdDateTime', 'type': 'str'},
        'device_count': {'key': 'deviceCount', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        group_id: str,
        group_type: Union[str, "GroupType"],
        tags: List[str],
        created_date_time: str,
        device_count: Optional[int] = None,
        **kwargs
    ):
        super(Group, self).__init__(**kwargs)
        self.group_id = group_id
        self.group_type = group_type
        self.tags = tags
        self.created_date_time = created_date_time
        self.device_count = device_count


class GroupBestUpdatesFilter(msrest.serialization.Model):
    """Group best updates filter.

    :param provider: Update provider.
    :type provider: str
    :param name: Update name.
    :type name: str
    :param version: Update version.
    :type version: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        name: Optional[str] = None,
        version: Optional[str] = None,
        **kwargs
    ):
        super(GroupBestUpdatesFilter, self).__init__(**kwargs)
        self.provider = provider
        self.name = name
        self.version = version


class ImportManifestMetadata(msrest.serialization.Model):
    """Metadata describing the import manifest, a document which describes the files and other metadata about an update version.

    All required parameters must be populated in order to send to Azure.

    :param url: Required. Azure Blob location from which the import manifest can be downloaded by
     Device Update for IoT Hub. This is typically a read-only SAS-protected blob URL with an
     expiration set to at least 4 hours.
    :type url: str
    :param size_in_bytes: Required. File size in number of bytes.
    :type size_in_bytes: long
    :param hashes: Required. A JSON object containing the hash(es) of the file. At least SHA256
     hash is required. This object can be thought of as a set of key-value pairs where the key is
     the hash algorithm, and the value is the hash of the file calculated using that algorithm.
    :type hashes: dict[str, str]
    """

    _validation = {
        'url': {'required': True},
        'size_in_bytes': {'required': True},
        'hashes': {'required': True},
    }

    _attribute_map = {
        'url': {'key': 'url', 'type': 'str'},
        'size_in_bytes': {'key': 'sizeInBytes', 'type': 'long'},
        'hashes': {'key': 'hashes', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        url: str,
        size_in_bytes: int,
        hashes: Dict[str, str],
        **kwargs
    ):
        super(ImportManifestMetadata, self).__init__(**kwargs)
        self.url = url
        self.size_in_bytes = size_in_bytes
        self.hashes = hashes


class ImportUpdateInput(msrest.serialization.Model):
    """Import update input metadata.

    All required parameters must be populated in order to send to Azure.

    :param import_manifest: Required. Import manifest metadata like source URL, file size/hashes,
     etc.
    :type import_manifest: ~azure.iot.deviceupdate.models.ImportManifestMetadata
    :param files: Required. One or more update file properties like filename and source URL.
    :type files: list[~azure.iot.deviceupdate.models.FileImportMetadata]
    """

    _validation = {
        'import_manifest': {'required': True},
        'files': {'required': True, 'min_items': 1},
    }

    _attribute_map = {
        'import_manifest': {'key': 'importManifest', 'type': 'ImportManifestMetadata'},
        'files': {'key': 'files', 'type': '[FileImportMetadata]'},
    }

    def __init__(
        self,
        *,
        import_manifest: "ImportManifestMetadata",
        files: List["FileImportMetadata"],
        **kwargs
    ):
        super(ImportUpdateInput, self).__init__(**kwargs)
        self.import_manifest = import_manifest
        self.files = files


class InnerError(msrest.serialization.Model):
    """An object containing more specific information than the current object about the error.

    All required parameters must be populated in order to send to Azure.

    :param code: Required. A more specific error code than what was provided by the containing
     error.
    :type code: str
    :param message: A human-readable representation of the error.
    :type message: str
    :param error_detail: The internal error or exception message.
    :type error_detail: str
    :param inner_error: An object containing more specific information than the current object
     about the error.
    :type inner_error: ~azure.iot.deviceupdate.models.InnerError
    """

    _validation = {
        'code': {'required': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'error_detail': {'key': 'errorDetail', 'type': 'str'},
        'inner_error': {'key': 'innerError', 'type': 'InnerError'},
    }

    def __init__(
        self,
        *,
        code: str,
        message: Optional[str] = None,
        error_detail: Optional[str] = None,
        inner_error: Optional["InnerError"] = None,
        **kwargs
    ):
        super(InnerError, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.error_detail = error_detail
        self.inner_error = inner_error


class Operation(msrest.serialization.Model):
    """Operation metadata.

    All required parameters must be populated in order to send to Azure.

    :param operation_id: Required. Operation Id.
    :type operation_id: str
    :param status: Required. Operation status. Possible values include: "Undefined", "NotStarted",
     "Running", "Succeeded", "Failed".
    :type status: str or ~azure.iot.deviceupdate.models.OperationStatus
    :param update_id: The identity of update being imported or deleted. For import, this property
     will only be populated after import manifest is processed successfully.
    :type update_id: ~azure.iot.deviceupdate.models.UpdateId
    :param resource_location: Location of the imported update when operation is successful.
    :type resource_location: str
    :param error: Operation error encountered, if any.
    :type error: ~azure.iot.deviceupdate.models.Error
    :param trace_id: Operation correlation identity that can used by Microsoft Support for
     troubleshooting.
    :type trace_id: str
    :param last_action_date_time: Required. Date and time in UTC when the operation status was last
     updated.
    :type last_action_date_time: ~datetime.datetime
    :param created_date_time: Required. Date and time in UTC when the operation was created.
    :type created_date_time: ~datetime.datetime
    :param etag: Operation ETag.
    :type etag: str
    """

    _validation = {
        'operation_id': {'required': True},
        'status': {'required': True},
        'last_action_date_time': {'required': True},
        'created_date_time': {'required': True},
    }

    _attribute_map = {
        'operation_id': {'key': 'operationId', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'update_id': {'key': 'updateId', 'type': 'UpdateId'},
        'resource_location': {'key': 'resourceLocation', 'type': 'str'},
        'error': {'key': 'error', 'type': 'Error'},
        'trace_id': {'key': 'traceId', 'type': 'str'},
        'last_action_date_time': {'key': 'lastActionDateTime', 'type': 'iso-8601'},
        'created_date_time': {'key': 'createdDateTime', 'type': 'iso-8601'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        operation_id: str,
        status: Union[str, "OperationStatus"],
        last_action_date_time: datetime.datetime,
        created_date_time: datetime.datetime,
        update_id: Optional["UpdateId"] = None,
        resource_location: Optional[str] = None,
        error: Optional["Error"] = None,
        trace_id: Optional[str] = None,
        etag: Optional[str] = None,
        **kwargs
    ):
        super(Operation, self).__init__(**kwargs)
        self.operation_id = operation_id
        self.status = status
        self.update_id = update_id
        self.resource_location = resource_location
        self.error = error
        self.trace_id = trace_id
        self.last_action_date_time = last_action_date_time
        self.created_date_time = created_date_time
        self.etag = etag


class OperationFilter(msrest.serialization.Model):
    """Operation status filter.

    :param status: Operation status filter. Possible values include: "Running", "NotStarted".
    :type status: str or ~azure.iot.deviceupdate.models.OperationFilterStatus
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "OperationFilterStatus"]] = None,
        **kwargs
    ):
        super(OperationFilter, self).__init__(**kwargs)
        self.status = status


class PageableListOfDeploymentDeviceStates(msrest.serialization.Model):
    """The list of deployment device states.

    :param value: The collection of pageable items.
    :type value: list[~azure.iot.deviceupdate.models.DeploymentDeviceState]
    :param next_link: The link to the next page of items.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DeploymentDeviceState]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["DeploymentDeviceState"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(PageableListOfDeploymentDeviceStates, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PageableListOfDeployments(msrest.serialization.Model):
    """The list of deployments.

    :param value: The collection of pageable items.
    :type value: list[~azure.iot.deviceupdate.models.Deployment]
    :param next_link: The link to the next page of items.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Deployment]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Deployment"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(PageableListOfDeployments, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PageableListOfDeviceClasses(msrest.serialization.Model):
    """The list of device classes.

    :param value: The collection of pageable items.
    :type value: list[~azure.iot.deviceupdate.models.DeviceClass]
    :param next_link: The link to the next page of items.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DeviceClass]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["DeviceClass"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(PageableListOfDeviceClasses, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PageableListOfDevices(msrest.serialization.Model):
    """The list of devices.

    :param value: The collection of pageable items.
    :type value: list[~azure.iot.deviceupdate.models.Device]
    :param next_link: The link to the next page of items.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Device]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Device"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(PageableListOfDevices, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PageableListOfDeviceTags(msrest.serialization.Model):
    """The list of device tags.

    :param value: The collection of pageable items.
    :type value: list[~azure.iot.deviceupdate.models.DeviceTag]
    :param next_link: The link to the next page of items.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DeviceTag]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["DeviceTag"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(PageableListOfDeviceTags, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PageableListOfGroups(msrest.serialization.Model):
    """The list of groups.

    :param value: The collection of pageable items.
    :type value: list[~azure.iot.deviceupdate.models.Group]
    :param next_link: The link to the next page of items.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Group]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Group"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(PageableListOfGroups, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PageableListOfOperations(msrest.serialization.Model):
    """The list of operations with server paging support.

    :param value: The collection of pageable items.
    :type value: list[~azure.iot.deviceupdate.models.Operation]
    :param next_link: The link to the next page of items.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Operation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Operation"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(PageableListOfOperations, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PageableListOfStrings(msrest.serialization.Model):
    """The list of strings with server paging support.

    :param value: The collection of pageable items.
    :type value: list[str]
    :param next_link: The link to the next page of items.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[str]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List[str]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(PageableListOfStrings, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PageableListOfUpdatableDevices(msrest.serialization.Model):
    """The list of updatable devices.

    :param value: The collection of pageable items.
    :type value: list[~azure.iot.deviceupdate.models.UpdatableDevices]
    :param next_link: The link to the next page of items.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[UpdatableDevices]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["UpdatableDevices"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(PageableListOfUpdatableDevices, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PageableListOfUpdateIds(msrest.serialization.Model):
    """The list of update identities.

    :param value: The collection of pageable items.
    :type value: list[~azure.iot.deviceupdate.models.UpdateId]
    :param next_link: The link to the next page of items.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[UpdateId]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["UpdateId"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(PageableListOfUpdateIds, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class UpdatableDevices(msrest.serialization.Model):
    """Update identifier and the number of devices for which the update is applicable.

    All required parameters must be populated in order to send to Azure.

    :param update_id: Required. Update identity.
    :type update_id: ~azure.iot.deviceupdate.models.UpdateId
    :param device_count: Required. Total number of devices for which the update is applicable.
    :type device_count: int
    """

    _validation = {
        'update_id': {'required': True},
        'device_count': {'required': True},
    }

    _attribute_map = {
        'update_id': {'key': 'updateId', 'type': 'UpdateId'},
        'device_count': {'key': 'deviceCount', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        update_id: "UpdateId",
        device_count: int,
        **kwargs
    ):
        super(UpdatableDevices, self).__init__(**kwargs)
        self.update_id = update_id
        self.device_count = device_count


class Update(msrest.serialization.Model):
    """Update metadata.

    All required parameters must be populated in order to send to Azure.

    :param update_id: Required. Update identity.
    :type update_id: ~azure.iot.deviceupdate.models.UpdateId
    :param update_type: Required. Update type.
    :type update_type: str
    :param installed_criteria: Required. String interpreted by Device Update client to determine if
     the update is installed on the device.
    :type installed_criteria: str
    :param compatibility: Required. List of update compatibility information.
    :type compatibility: list[~azure.iot.deviceupdate.models.Compatibility]
    :param manifest_version: Required. Schema version of manifest used to import the update.
    :type manifest_version: str
    :param imported_date_time: Required. Date and time in UTC when the update was imported.
    :type imported_date_time: ~datetime.datetime
    :param created_date_time: Required. Date and time in UTC when the update was created.
    :type created_date_time: ~datetime.datetime
    :param etag: Update ETag.
    :type etag: str
    """

    _validation = {
        'update_id': {'required': True},
        'update_type': {'required': True},
        'installed_criteria': {'required': True},
        'compatibility': {'required': True, 'min_items': 1},
        'manifest_version': {'required': True},
        'imported_date_time': {'required': True},
        'created_date_time': {'required': True},
    }

    _attribute_map = {
        'update_id': {'key': 'updateId', 'type': 'UpdateId'},
        'update_type': {'key': 'updateType', 'type': 'str'},
        'installed_criteria': {'key': 'installedCriteria', 'type': 'str'},
        'compatibility': {'key': 'compatibility', 'type': '[Compatibility]'},
        'manifest_version': {'key': 'manifestVersion', 'type': 'str'},
        'imported_date_time': {'key': 'importedDateTime', 'type': 'iso-8601'},
        'created_date_time': {'key': 'createdDateTime', 'type': 'iso-8601'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        update_id: "UpdateId",
        update_type: str,
        installed_criteria: str,
        compatibility: List["Compatibility"],
        manifest_version: str,
        imported_date_time: datetime.datetime,
        created_date_time: datetime.datetime,
        etag: Optional[str] = None,
        **kwargs
    ):
        super(Update, self).__init__(**kwargs)
        self.update_id = update_id
        self.update_type = update_type
        self.installed_criteria = installed_criteria
        self.compatibility = compatibility
        self.manifest_version = manifest_version
        self.imported_date_time = imported_date_time
        self.created_date_time = created_date_time
        self.etag = etag


class UpdateCompliance(msrest.serialization.Model):
    """Update compliance information.

    All required parameters must be populated in order to send to Azure.

    :param total_device_count: Required. Total number of devices.
    :type total_device_count: int
    :param on_latest_update_device_count: Required. Number of devices on the latest update.
    :type on_latest_update_device_count: int
    :param new_updates_available_device_count: Required. Number of devices with a newer update
     available.
    :type new_updates_available_device_count: int
    :param updates_in_progress_device_count: Required. Number of devices with update in-progress.
    :type updates_in_progress_device_count: int
    """

    _validation = {
        'total_device_count': {'required': True},
        'on_latest_update_device_count': {'required': True},
        'new_updates_available_device_count': {'required': True},
        'updates_in_progress_device_count': {'required': True},
    }

    _attribute_map = {
        'total_device_count': {'key': 'totalDeviceCount', 'type': 'int'},
        'on_latest_update_device_count': {'key': 'onLatestUpdateDeviceCount', 'type': 'int'},
        'new_updates_available_device_count': {'key': 'newUpdatesAvailableDeviceCount', 'type': 'int'},
        'updates_in_progress_device_count': {'key': 'updatesInProgressDeviceCount', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        total_device_count: int,
        on_latest_update_device_count: int,
        new_updates_available_device_count: int,
        updates_in_progress_device_count: int,
        **kwargs
    ):
        super(UpdateCompliance, self).__init__(**kwargs)
        self.total_device_count = total_device_count
        self.on_latest_update_device_count = on_latest_update_device_count
        self.new_updates_available_device_count = new_updates_available_device_count
        self.updates_in_progress_device_count = updates_in_progress_device_count


class UpdateId(msrest.serialization.Model):
    """Update identifier.

    All required parameters must be populated in order to send to Azure.

    :param provider: Required. Update provider.
    :type provider: str
    :param name: Required. Update name.
    :type name: str
    :param version: Required. Update version.
    :type version: str
    """

    _validation = {
        'provider': {'required': True},
        'name': {'required': True},
        'version': {'required': True},
    }

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        provider: str,
        name: str,
        version: str,
        **kwargs
    ):
        super(UpdateId, self).__init__(**kwargs)
        self.provider = provider
        self.name = name
        self.version = version
