# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.recoveryservicessiterecovery.aio import SiteRecoveryManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestSiteRecoveryManagementReplicationvCentersOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(SiteRecoveryManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_replicationv_centers_list_by_replication_fabrics(self, resource_group):
        response = self.client.replicationv_centers.list_by_replication_fabrics(
            fabric_name="str",
            api_version="2025-01-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_replicationv_centers_get(self, resource_group):
        response = await self.client.replicationv_centers.get(
            fabric_name="str",
            vcenter_name="str",
            api_version="2025-01-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_replicationv_centers_begin_create(self, resource_group):
        response = await (
            await self.client.replicationv_centers.begin_create(
                fabric_name="str",
                vcenter_name="str",
                add_v_center_request={
                    "properties": {
                        "friendlyName": "str",
                        "ipAddress": "str",
                        "port": "str",
                        "processServerId": "str",
                        "runAsAccountId": "str",
                    }
                },
                api_version="2025-01-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_replicationv_centers_begin_delete(self, resource_group):
        response = await (
            await self.client.replicationv_centers.begin_delete(
                fabric_name="str",
                vcenter_name="str",
                api_version="2025-01-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_replicationv_centers_begin_update(self, resource_group):
        response = await (
            await self.client.replicationv_centers.begin_update(
                fabric_name="str",
                vcenter_name="str",
                update_v_center_request={
                    "properties": {
                        "friendlyName": "str",
                        "ipAddress": "str",
                        "port": "str",
                        "processServerId": "str",
                        "runAsAccountId": "str",
                    }
                },
                api_version="2025-01-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_replicationv_centers_list(self, resource_group):
        response = self.client.replicationv_centers.list(
            api_version="2025-01-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...
