#!/usr/bin/python

from arsenal.arsenal_lib import *
from lpltk import LaunchpadService

if len(sys.argv) < 2:
    sys.stderr.write("Usage: %s <source-package>\n" %(sys.argv[0]) )
    sys.exit(1)

total_count = 0
source_pkgs = sys.argv[1:]
lp          = LaunchpadService(config={'read_only':True})
d           = lp.launchpad.distributions["ubuntu"]
tags        = {}

for source_pkg in source_pkgs:
    print "== Tags in '"+source_pkg+"' =="
    s = d.getSourcePackage(name = source_pkg)
    for bugtask in s.searchTasks():
        for tag in bugtask.bug.tags:
            if not tags.has_key(tag):
                #print bugtask.bug.id," ",tag
                tags[tag] = 1
            else:
                tags[tag] += 1


for tag in tags.keys():
    print "%-20s %d" % (tag, tags[tag])

