# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base.version import Version
from twilio.rest.voice.v1.byoc_trunk import ByocTrunkList
from twilio.rest.voice.v1.connection_policy import ConnectionPolicyList
from twilio.rest.voice.v1.dialing_permissions import DialingPermissionsList
from twilio.rest.voice.v1.ip_record import IpRecordList
from twilio.rest.voice.v1.source_ip_mapping import SourceIpMappingList


class V1(Version):

    def __init__(self, domain):
        """
        Initialize the V1 version of Voice

        :returns: V1 version of Voice
        :rtype: twilio.rest.voice.v1.V1.V1
        """
        super(V1, self).__init__(domain)
        self.version = 'v1'
        self._byoc_trunks = None
        self._connection_policies = None
        self._dialing_permissions = None
        self._ip_records = None
        self._source_ip_mappings = None

    @property
    def byoc_trunks(self):
        """
        :rtype: twilio.rest.voice.v1.byoc_trunk.ByocTrunkList
        """
        if self._byoc_trunks is None:
            self._byoc_trunks = ByocTrunkList(self)
        return self._byoc_trunks

    @property
    def connection_policies(self):
        """
        :rtype: twilio.rest.voice.v1.connection_policy.ConnectionPolicyList
        """
        if self._connection_policies is None:
            self._connection_policies = ConnectionPolicyList(self)
        return self._connection_policies

    @property
    def dialing_permissions(self):
        """
        :rtype: twilio.rest.voice.v1.dialing_permissions.DialingPermissionsList
        """
        if self._dialing_permissions is None:
            self._dialing_permissions = DialingPermissionsList(self)
        return self._dialing_permissions

    @property
    def ip_records(self):
        """
        :rtype: twilio.rest.voice.v1.ip_record.IpRecordList
        """
        if self._ip_records is None:
            self._ip_records = IpRecordList(self)
        return self._ip_records

    @property
    def source_ip_mappings(self):
        """
        :rtype: twilio.rest.voice.v1.source_ip_mapping.SourceIpMappingList
        """
        if self._source_ip_mappings is None:
            self._source_ip_mappings = SourceIpMappingList(self)
        return self._source_ip_mappings

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Voice.V1>'
