.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\" Copyright \(co 2000  The XFree86 Project, Inc.
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided ``as is'' without express or implied warranty.
.\"
.\" $XFree86: xc/doc/man/X11/XSLTTProp.man,v 1.4 2001/02/09 03:47:46 tsi Exp $
.\" 
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.na
.de Ds
.nf
.\\$1D \\$2 \\$1
.ft 1
.\".ps \\n(PS
.\".if \\n(VS>=40 .vs \\n(VSu
.\".if \\n(VS<=39 .vs \\n(VSp
..
.de De
.ce 0
.if \\n(BD .DF
.nr BD 0
.in \\n(OIu
.if \\n(TM .ls 2
.sp \\n(DDu
.fi
..
.de FD
.LP
.KS
.TA .5i 3i
.ta .5i 3i
.nf
..
.de FN
.fi
.KE
.LP
..
.de IN		\" send an index entry to the stderr
..
.de C{
.KS
.nf
.D
.\"
.\"	choose appropriate monospace font
.\"	the imagen conditional, 480,
.\"	may be changed to L if LB is too
.\"	heavy for your eyes...
.\"
.ie "\\*(.T"480" .ft L
.el .ie "\\*(.T"300" .ft L
.el .ie "\\*(.T"202" .ft PO
.el .ie "\\*(.T"aps" .ft CW
.el .ft R
.ps \\n(PS
.ie \\n(VS>40 .vs \\n(VSu
.el .vs \\n(VSp
..
.de C}
.DE
.R
..
.de Pn
.ie t \\$1\fB\^\\$2\^\fR\\$3
.el \\$1\fI\^\\$2\^\fP\\$3
..
.de ZN
.ie t \fB\^\\$1\^\fR\\$2
.el \fI\^\\$1\^\fP\\$2
..
.de hN
.ie t <\fB\\$1\fR>\\$2
.el <\fI\\$1\fP>\\$2
..
.de NT
.ne 7
.ds NO Note
.if \\n(.$>$1 .if !'\\$2'C' .ds NO \\$2
.if \\n(.$ .if !'\\$1'C' .ds NO \\$1
.ie n .sp
.el .sp 10p
.TB
.ce
\\*(NO
.ie n .sp
.el .sp 5p
.if '\\$1'C' .ce 99
.if '\\$2'C' .ce 99
.in +5n
.ll -5n
.R
..
.		\" Note End -- doug kraft 3/85
.de NE
.ce 0
.in -5n
.ll +5n
.ie n .sp
.el .sp 10p
..
.ny0
.TH XStringListToTextProperty 3X11 __xorgversion__ "XLIB FUNCTIONS"
.SH NAME
XStringListToTextProperty, XTextPropertyToStringList, XFreeStringList, XTextProperty \- convert string lists and text property structure
.SH SYNTAX
Status XStringListToTextProperty\^(\^\fIlist\fP, \fIcount\fP,
\fItext_prop_return\fP\^)
.br
      char **\fIlist\fP\^;
.br
      int \fIcount\fP\^;
.br
      XTextProperty *\fItext_prop_return\fP\^;
.LP
Status XTextPropertyToStringList\^(\^\fItext_prop\fP, \fIlist_return\fP,
\fIcount_return\fP\^)
.br
       XTextProperty *\fItext_prop\fP\^;
.br
       char ***\fIlist_return\fP\^;
.br
       int *\fIcount_return\fP\^;
.LP
void XFreeStringList\^(\^\fIlist\fP\^)
.br
      char **\fIlist\fP\^;
.SH ARGUMENTS
.ds Cn strings
.IP \fIcount\fP 1i
Specifies the number of \*(Cn.
.ds Cn strings
.IP \fIcount_return\fP 1i
Returns the number of \*(Cn.
.IP \fIlist\fP 1i
Specifies the list of strings to be freed.
.IP \fIlist\fP 1i
Specifies a list of null-terminated character strings.
.IP \fIlist_return\fP 1i
Returns a list of null-terminated character strings.
.IP \fItext_prop\fP 1i
Specifies the
.ZN XTextProperty
structure to be used.
.IP \fItext_prop_return\fP 1i
Returns the
.ZN XTextProperty
structure.
.SH DESCRIPTION
The 
.ZN XStringListToTextProperty 
function sets the specified 
.ZN XTextProperty
to be of type STRING (format 8) with a value representing the
concatenation of the specified list of null-separated character strings.
An extra null byte (which is not included in the nitems member) 
is stored at the end of the value field of text_prop_return.
The strings are assumed (without verification) to be in the STRING encoding.
If insufficient memory is available for the new value string, 
.ZN XStringListToTextProperty
does not set any fields in the
.ZN XTextProperty
structure and returns a zero status.
Otherwise, it returns a nonzero status.
To free the storage for the value field, use 
.ZN XFree .
.LP
The 
.ZN XTextPropertyToStringList 
function returns a list of strings representing the null-separated elements 
of the specified
.ZN XTextProperty
structure.
The data in text_prop must be of type STRING and format 8. 
Multiple elements of the property 
(for example, the strings in a disjoint text selection) 
are separated by NULL (encoding 0).
The contents of the property are not null-terminated.
If insufficient memory is available for the list and its elements, 
.ZN XTextPropertyToStringList
sets no return values and returns a zero status.
Otherwise, it returns a nonzero status.
To free the storage for the list and its contents, use 
.ZN XFreeStringList .
.LP
The 
.ZN XFreeStringList 
function releases memory allocated by 
.ZN XmbTextPropertyToTextList ,
.ZN Xutf8TextPropertyToTextList
and
.ZN XTextPropertyToStringList
and the missing charset list allocated by 
.ZN XCreateFontSet .
.SH STRUCTURES
The
.ZN XTextProperty
structure contains:
.LP
.Ds 0
.TA .5i 2.5i
.ta .5i 2.5i
typedef struct {
	unsigned char *value;	/* property data */
	Atom encoding;	/* type of property */
	int format;	/* 8, 16, or 32 */
	unsigned long nitems;	/* number of items in value */
} XTextProperty;
.De
.SH "SEE ALSO"
XAllocClassHint(3X11),
XAllocIconSize(3X11),
XAllocSizeHints(3X11),
XAllocWMHints(3X11),
XFree(3X11),
XSetCommand(3X11),
XSetTransientForHint(3X11),
XSetTextProperty(3X11),
XSetWMClientMachine(3X11),
XSetWMColormapWindows(3X11),
XSetWMIconName(3X11),
XSetWMName(3X11),
XSetWMProperties(3X11),
XSetWMProtocols(3X11)
.br
\fI\*(xL\fP
