<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head><!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>mod_unique_id - Serveur Apache HTTP Version 2.4</title>
<link href="../style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="../style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="../style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" /><link rel="stylesheet" type="text/css" href="../style/css/prettify.css" />
<script src="../style/scripts/prettify.min.js" type="text/javascript">
</script>

<link href="../images/favicon.ico" rel="shortcut icon" /></head>
<body>
<div id="page-header">
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p>
<p class="apache">Serveur Apache HTTP Version 2.4</p>
<img alt="" src="../images/feather.gif" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="../images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="../">Version 2.4</a> &gt; <a href="./">Modules</a></div>
<div id="page-content">
<div id="preamble"><h1>Module Apache mod_unique_id</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_unique_id.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_unique_id.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="../ja/mod/mod_unique_id.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="../ko/mod/mod_unique_id.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a></p>
</div>
<table class="module"><tr><th><a href="module-dict.html#Description">Description:</a></th><td>Fournit une variable d'environnement contenant un
identifiant unique pour chaque requte</td></tr>
<tr><th><a href="module-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="module-dict.html#ModuleIdentifier">IdentificateurdeModule:</a></th><td>unique_id_module</td></tr>
<tr><th><a href="module-dict.html#SourceFile">FichierSource:</a></th><td>mod_unique_id.c</td></tr></table>
<h3>Sommaire</h3>


    <p>Ce module fournit un identifiant dont l'unicit est garantie
    parmi "toutes" les requtes sous des conditions trs prcises.
    L'identifiant unique le sera aussi parmi plusieurs machines
    appartenant  un cluster correctement configur. L'identifiant est
    affect  la variable d'environnement <code>UNIQUE_ID</code> pour
    chaque requte. Les identifiants uniques sont utiles pour diverses
    raisons dont la nature se situe au del de la porte de ce
    document.</p>
</div>
<div id="quickview"><h3 class="directives">Directives</h3>
<p>Ce module ne fournit aucune directive.</p>
<h3>Sujets</h3>
<ul id="topics">
<li><img alt="" src="../images/down.gif" /> <a href="#theory">Thorie</a></li>
</ul><ul class="seealso"><li><a href="#comments_section">Commentaires</a></li></ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="theory" id="theory">Thorie</a></h2>
    

    <p>Tout d'abord un bref rappel de la manire dont le serveur Apache
    fonctionne sous Unix (cette fonctionnalit n'tant actuellement pas
    supporte sous Windows NT). Sous Unix, Apache cre plusieurs
    processus enfants, ces derniers traitant les requtes une par une.
    Chaque processus enfant peut traiter plusieurs requtes pendant sa
    dure de vie. Dans le cadre de cette discussion, nous supposerons
    que les diffrents processus enfants ne s'changent pas de donnes
    entre eux. Nous nous rfrerons aux processus enfants sous le nom de
    <dfn>processus httpd</dfn>.</p>

    <p>Votre site web est rparti entre une ou plusieurs machines dont
    vous tes l'administrateur, et que nous nommerons cluster de
    serveurs. Chaque serveur peut excuter plusieurs instances d'Apache.
    L'ensemble de ces dernires sera considr comme "l'Univers", et
    sous certaines hypothses, nous montrerons qu'il est possible dans
    cet univers, de gnrer des identifiants uniques pour chaque
    requte, sans pour autant ncessiter une communication importante
    entre les diffrents serveurs du cluster.</p>

    <p>Les machines de votre cluster doivent satisfaire ces conditions
    (mme si le cluster ne comporte qu'une machine, vous devez
    synchroniser son horloge avec NTP) :</p>

    <ul>
      <li>Les temps des machines sont synchroniss via NTP ou tout autre
      protocole de synchronisation du temps en rseau.</li>

      <li>Les nom d'htes des machines sont tous diffrents, de faon 
      ce que le module puisse recevoir une adresse IP diffrente pour
      chaque machine du cluster en effectuant une recherche sur le nom
      d'hte.</li>
    </ul>

    <p>Au vu des caractristiques actuelles du systme d'exploitation,
    nous supposerons que les pids (identifiants processus) sont cods
    sur 32 bits. Si le systme d'exploitation utilise plus de 32 bits
    pour un pid, la correction est triviale mais doit tre effectue
    dans le code.</p>

    <p>Ces hypothses poses,  un instant donn, nous pouvons
    distinguer tout processus httpd sur toute machine du cluster de tous
    les autres processus httpd. Pour ce faire, il suffit d'utiliser
    l'adresse IP de la machine et le pid du processus httpd. Un
    processus httpd peut traiter plusieurs requtes simultanment si
    vous utilisez un module MPM multi-thread. Pour identifier les
    threads, Apache httpd utilise en interne un index de threads. Ainsi,
    afin de gnrer des identifiants uniques pour chaque requte, il
    suffit d'effectuer une distinction en fonction du temps.</p>

    <p>Pour dterminer le temps, nous utiliserons un repre de temps
    Unix (les secondes coules depuis le 1er janvier 1970 UTC), et un
    compteur 16 bits. La prcision du repre de temps n'tant que d'une
    seconde, le compteur va reprsenter 65536 valeurs par seconde. Le
    quadruplet <em>(adresse IP, pid, repre de temps, compteur)</em> est
    en mesure de distinguer 65536 requtes par seconde par processus
    httpd. Il peut cependant arriver que le mme pid soit rutilis au
    cours du temps, et le compteur est l pour pallier cet
    inconvnient.</p>

    <p>Lorsqu'un processus enfant httpd est cr, le compteur est
    initialis avec (nombre de microsecondes actuel divis par 10)
    modulo 65536 (cette formule a t choisie pour liminer certains
    problme de variance avec les bits de poids faibles du compteur de
    microsecondes sur certains systmes). Lorsqu'un identifiant unique
    est gnr, le repre de temps utilis est le moment o la requte
    arrive sur le serveur web. Le compteur est incrment  chaque
    cration d'identifiant (et peut repasser  0 lorsqu'il a atteint sa
    valeur maximale).</p>

    <p>Le noyau gnre un pid pour chaque processus lors de sa cration,
    et le compteur de pid est rinitialis  une certaine valeur
    lorsqu'il a atteint sa valeur maximale (les pid sont cods sur 16
    bits sous de nombreux Unixes, mais les systmes les plus rcents les
    ont tendus  32 bits). La mme valeur de pid pourra donc tre
    rutilise au cours du temps. Cependant, tant qu'elle n'est pas
    rutilise dans la mme seconde, elle ne remet pas en cause
    l'unicit de notre quadruplet. Nous supposerons donc que le systme
    ne crera pas plus de 65536 processus en une seconde (ce nombre peut
    tre de 32768 sous certains Unixes, mais mme dans ce cas, on est en
    gnral loin de cette situation).</p>

    <p>Il est possible que le temps se rpte pour une raison
    quelconque.
    Supposons par exemple que l'horloge systme soit retarde et repasse
    par un temps pass (ou bien, comme elle avanait, elle a t remise
     l'heure, et elle repasse par un temps futur). Dans ce cas, il peut
    tre facilement dmontr que le couple pid/repre de temps peut tre
    rutilis. Le choix de la formule d'initialisation du compteur a
    t effectu dans l'intention de pallier ce problme. Notez qu'un
    nombre vraiment alatoire serait souhaitable pour initialiser le
    compteur, mais il n'existe pas de tel nombre directement lisible sur
    la plupart des systmes (c'est  dire que vous ne pouvez pas
    utiliser rand() car vous devez dclencher le gnrateur avec une
    valeur unique, et vous ne pouvez pas utiliser le temps  cet effet
    car celui-ci , au moins  la seconde prs, s'est rpt). Il ne
    s'agit donc pas d'une dfense parfaite.</p>

    <p>Mme si elle n'est pas parfaite, quel est le degr d'efficacit
    de cette dfense ? Supposons
    qu'une de vos machines serve au plus 500 requtes par seconde (ce
    qui constitue une limite suprieure trs raisonnable au moment o ce
    document est crit, car les systmes ne se contentent en gnral pas
    de dbiter des fichiers statiques). Pour y parvenir, un certain nombre
    de processus enfants sera ncessaire, qui dpendra du nombre de
    clients simultans prsents. Mais soyons pessimiste et supposons
    qu'un seul processus enfant soit capable de servir 500 requtes par
    secondes.
    Il existe 1000 valeurs de dmarrage possibles du compteur pour
    lesquelles deux squences de 500 requtes puissent se recouvrir. Il
    y a donc 1,5% de chance que le processus enfant rpte une valeur de
    compteur si le temps se rpte (avec une rsolution d'une seconde),
    et l'unicit sera alors remise en cause. C'est cependant un exemple
    trs pessimiste, et avec les valeurs du monde rel, il y a bien
    moins de chances que cela ne se produise. Si vous estimez que ceci a
    tout de mme quelque chances de se produire sur votre systme, vous
    pouvez migrer vers un compteur  32 bits (en modifiant le code).</p>

    <p>On pourrait supposer que ceci a plus de chance de se produire
    lors du passage  l'heure d'hiver o l'horloge est "retarde". Cela
    ne constitue cependant pas un problme car les temps pris en compte
    ici sont des temps UTC, qui vont "toujours" de l'avant. Notez que
    les Unixes  base de processeur x86 peuvent ncessiter une
    configuration particulire pour que ceci soit vrai -- il doivent
    tre configurs pour assumer que l'horloge systme est en UTC et
    compenser de manire approprie. Mais mme dans ce cas, si vous
    utilisez NTP, votre temps UTC sera correct peu aprs le
    redmarrage.</p>

    
    <p>La variable d'environnement <code>UNIQUE_ID</code> est construite
    par codage du quadruplet de 144 bits (adresse IP sur 32 bits, pid
    sur 32 bits, repre de temps sur 32 bits, compteur 16 bits et index
    de threads sur 32 bits) en
    utilisant l'alphabet <code>[A-Za-z0-9@-]</code> d'une manire
    similaire  celle du codage MIME base64, et sa valeur se prsente
    sous la forme d'une chane de 24 caractres. L'alphabet MIME base64
    est en fait <code>[A-Za-z0-9+/]</code> ; cependant, les caractres
    <code>+</code> et <code>/</code> ncessitent un codage particulier
    dans les URLs, ce qui rend leur utilisation peu commode. Toutes les
    valeurs sont codes dans l'ordre des octets d'une adresse rseau de
    faon  ce
    que le codage soit comparable entre des architectures o l'ordre des
    octets est diffrent. L'ordre rel de codage est : repre de temps,
    adresse IP, pid, compteur. Cet ordre de codage possde un but
    prcis, mais il faut souligner que les applications n'ont aucun
    intrt  entrer dans les dtails de ce codage. Les applications
    doivent se contenter de traiter la variable <code>UNIQUE_ID</code>
    comme un symbole opaque, qui peut tre compar avec d'autres
    <code>UNIQUE_ID</code>s en ne testant que leur galit.</p>

    <p>L'ordre a t choisi de faon  ce qu'il soit possible de
    modifier le codage dans le futur sans avoir  se proccuper de
    conflits ventuels avec une base de donnes de
    <code>UNIQUE_ID</code>s existante. Les nouveaux codages doivent
    conserver le repre de temps comme premier lment, et pour le
    reste, utiliser les mme alphabet et longueur en bits. Comme les
    repres de temps constituent essentiellement un squence croissante,
    il suffit que toutes les machines du cluster arrtent de servir et
    de requrir dans la mme <em>seconde repre</em>, et n'utilisent
    alors plus l'ancien format de codage. Ensuite, elles peuvent
    reprendre le traitement des requtes en utilisant les nouveaux
    codages.</p>

    <p>Nous pensons que ceci apporte une solution relativement portable
    au problme. Les
    identifiants gnrs possdent une dure de vie pratiquement infinie
    car les identifiants futurs pourront tre allongs selon les
    besoins. Pratiquement aucune communication n'est requise entre les
    machines du cluster (seule la synchronisation NTP est requise, ce
    qui reprsente une charge trs faible), et aucune communication
    entre les processus httpd n'est ncessaire (la communication est
    implicite et incluse dans le pid assign par le noyau). Dans des
    situations trs spcifiques, l'identifiant peut tre raccourci, mais
    dans ce cas, d'avantage d'informations doivent tre admises (par
    exemple, les 32 bits de l'adresse IP sont excessifs pour la plupart
    des sites, mais il n'existe pas de valeur de remplacement portable
    plus courte).</p>
</div>
</div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_unique_id.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_unique_id.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="../ja/mod/mod_unique_id.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="../ko/mod/mod_unique_id.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a></p>
</div><div class="top"><a href="#page-header"><img src="../images/up.gif" alt="top" /></a></div><div class="section"><h2><a id="comments_section" name="comments_section">Commentaires</a></h2><div class="warning"><strong>Notice:</strong><br />This is not a Q&amp;A section. Comments placed here should be pointed towards suggestions on improving the documentation or server, and may be removed again by our moderators if they are either implemented or considered invalid/off-topic. Questions on how to manage the Apache HTTP Server should be directed at either our IRC channel, #httpd, on Freenode, or sent to our <a href="http://httpd.apache.org/lists.html">mailing lists</a>.</div>
<script type="text/javascript"><!--//--><![CDATA[//><!--
var comments_shortname = 'httpd';
var comments_identifier = 'http://httpd.apache.org/docs/2.4/mod/mod_unique_id.html';
(function(w, d) {
    if (w.location.hostname.toLowerCase() == "httpd.apache.org") {
        d.write('<div id="comments_thread"><\/div>');
        var s = d.createElement('script');
        s.type = 'text/javascript';
        s.async = true;
        s.src = 'https://comments.apache.org/show_comments.lua?site=' + comments_shortname + '&page=' + comments_identifier;
        (d.getElementsByTagName('head')[0] || d.getElementsByTagName('body')[0]).appendChild(s);
    }
    else { 
        d.write('<div id="comments_thread">Comments are disabled for this page at the moment.<\/div>');
    }
})(window, document);
//--><!]]></script></div><div id="footer">
<p class="apache">Copyright 2014 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p></div><script type="text/javascript"><!--//--><![CDATA[//><!--
if (typeof(prettyPrint) !== 'undefined') {
    prettyPrint();
}
//--><!]]></script>
</body></html>