//  Copyright (c) 2014 Anton Bikineev
//  Use, modification and distribution are subject to the
//  Boost Software License, Version 1.0. (See accompanying file
//  LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

   static const boost::array<boost::array<typename table_type<T>::type, 3>, 1980> bessel_i_prime_int_data = {{
      {{ SC_(0.0), SC_(0.177219114266335964202880859375e-2), SC_(0.00088609591919750015203076551463481289812081759457593) }}, 
      {{ SC_(0.0), SC_(0.22177286446094512939453125e-2), SC_(0.0011088650040236093434924259738776777082777117728366) }}, 
      {{ SC_(0.0), SC_(0.7444499991834163665771484375e-2), SC_(0.003722275782133396649790935284938128705516556817227) }}, 
      {{ SC_(0.0), SC_(0.1433600485324859619140625e-1), SC_(0.0071681865751110609746510378519051273111721075420681) }}, 
      {{ SC_(0.0), SC_(0.1760916970670223236083984375e-1), SC_(0.008804926126614467969087386987026758424777681208949) }}, 
      {{ SC_(0.0), SC_(0.6152711808681488037109375e-1), SC_(0.030778118603049061956303124312187349139104670901298) }}, 
      {{ SC_(0.0), SC_(0.11958599090576171875e0), SC_(0.059899945189311456643393232325528632776126403440763) }}, 
      {{ SC_(0.0), SC_(0.15262925624847412109375e0), SC_(0.076537069171312995155266637603161226785362168868793) }}, 
      {{ SC_(0.0), SC_(0.408089816570281982421875e0), SC_(0.20832212130892514352270120184527358300711621253093) }}, 
      {{ SC_(0.0), SC_(0.6540834903717041015625e0), SC_(0.34484589720660571203268712177657285280507611555709) }}, 
      {{ SC_(0.0), SC_(0.1097540378570556640625e1), SC_(0.63565392939687165931975701385906830196228023376933) }}, 
      {{ SC_(0.0), SC_(0.30944411754608154296875e1), SC_(4.304586767845429639244166020309162877221031947039) }}, 
      {{ SC_(0.0), SC_(0.51139926910400390625e1), SC_(27.026310609828701503222843893102992533224960967973) }}, 
      {{ SC_(0.0), SC_(0.95070552825927734375e1), SC_(1669.6303950934903244727446466214615294086023903195) }}, 
      {{ SC_(0.0), SC_(0.24750102996826171875e2), SC_(4428295881.3677779786815636628866430364992082651157) }}, 
      {{ SC_(0.0), SC_(0.637722015380859375e2), SC_(246567311915704274501887357.24020001512007921147054) }}, 
      {{ SC_(0.1e1), SC_(0.177219114266335964202880859375e-2), SC_(0.50000058887414958452485804994744934952377336181573) }}, 
      {{ SC_(0.1e1), SC_(0.22177286446094512939453125e-2), SC_(0.50000092218537893261448430232179397590419077630156) }}, 
      {{ SC_(0.1e1), SC_(0.7444499991834163665771484375e-2), SC_(0.50001039139876686065339052546517335546246153291185) }}, 
      {{ SC_(0.1e1), SC_(0.1433600485324859619140625e-1), SC_(0.50003853574407998926317310663333528092870153852384) }}, 
      {{ SC_(0.1e1), SC_(0.1760916970670223236083984375e-1), SC_(0.50005814178781229442302267906313903386120382311391) }}, 
      {{ SC_(0.1e1), SC_(0.6152711808681488037109375e-1), SC_(0.50070998404154571459128156447054892961460345184902) }}, 
      {{ SC_(0.1e1), SC_(0.11958599090576171875e0), SC_(0.5026840657714710757890236690799629757305465005453) }}, 
      {{ SC_(0.1e1), SC_(0.15262925624847412109375e0), SC_(0.50437501291751594265663420039241884122843561276152) }}, 
      {{ SC_(0.1e1), SC_(0.408089816570281982421875e0), SC_(0.53158863081248487334362919459520848093354880736601) }}, 
      {{ SC_(0.1e1), SC_(0.6540834903717041015625e0), SC_(0.58263043215568911299814886678184475770592474363462) }}, 
      {{ SC_(0.1e1), SC_(0.1097540378570556640625e1), SC_(0.7454322330858457449159781361157891562659959168394) }}, 
      {{ SC_(0.1e1), SC_(0.30944411754608154296875e1), SC_(3.8794322064706267194422881162259380140744641171029) }}, 
      {{ SC_(0.1e1), SC_(0.51139926910400390625e1), SC_(24.879824200109264550070346070548572538675416510962) }}, 
      {{ SC_(0.1e1), SC_(0.95070552825927734375e1), SC_(1589.6010892466270146562540500585578585568257598452) }}, 
      {{ SC_(0.1e1), SC_(0.24750102996826171875e2), SC_(4341662415.1619366320979220433134729416481099471501) }}, 
      {{ SC_(0.1e1), SC_(0.637722015380859375e2), SC_(244657223419722976962060156.64526989576384593438155) }}, 
      {{ SC_(0.4e1), SC_(0.177219114266335964202880859375e-2), SC_(5.7977642791440240594069365123737373446875473336019e-11) }}, 
      {{ SC_(0.4e1), SC_(0.22177286446094512939453125e-2), SC_(1.1361983257670755452088629287120813120498174641957e-10) }}, 
      {{ SC_(0.4e1), SC_(0.7444499991834163665771484375e-2), SC_(4.2977106585064563071965155077470765547580422080236e-09) }}, 
      {{ SC_(0.4e1), SC_(0.1433600485324859619140625e-1), SC_(3.0691624717963766687820586762992955366705538139243e-08) }}, 
      {{ SC_(0.4e1), SC_(0.1760916970670223236083984375e-1), SC_(5.6879465129841838118217352628667866284796929079985e-08) }}, 
      {{ SC_(0.4e1), SC_(0.6152711808681488037109375e-1), SC_(2.4268994701713292881629948960548331673657583324918e-06) }}, 
      {{ SC_(0.4e1), SC_(0.11958599090576171875e0), SC_(1.7833452482002047243884933100474315698557783900753e-05) }}, 
      {{ SC_(0.4e1), SC_(0.15262925624847412109375e0), SC_(3.7102292783677070216850017034917460055257223905384e-05) }}, 
      {{ SC_(0.4e1), SC_(0.408089816570281982421875e0), SC_(0.00071682270806809984142485696566273749789215179247911) }}, 
      {{ SC_(0.4e1), SC_(0.6540834903717041015625e0), SC_(0.0030095810505154039505649035929324233185650471379949) }}, 
      {{ SC_(0.4e1), SC_(0.1097540378570556640625e1), SC_(0.015058380627056309463722070322914223292754890572289) }}, 
      {{ SC_(0.4e1), SC_(0.30944411754608154296875e1), SC_(0.59848912997745095317460689682974327447677370660399) }}, 
      {{ SC_(0.4e1), SC_(0.51139926910400390625e1), SC_(7.1096561414745714565763810157506729038368017958419) }}, 
      {{ SC_(0.4e1), SC_(0.95070552825927734375e1), SC_(765.16515717873090426778318670348842991572055594829) }}, 
      {{ SC_(0.4e1), SC_(0.24750102996826171875e2), SC_(3229907987.7660192457647761075637335091559830439104) }}, 
      {{ SC_(0.4e1), SC_(0.637722015380859375e2), SC_(217726882458479319415712565.5405744792891643352915) }}, 
      {{ SC_(0.7e1), SC_(0.177219114266335964202880859375e-2), SC_(3.3614059042626999826433170034673583525940024533365e-22) }}, 
      {{ SC_(0.7e1), SC_(0.22177286446094512939453125e-2), SC_(1.2909459381881364762226234760871640013723793229134e-21) }}, 
      {{ SC_(0.7e1), SC_(0.7444499991834163665771484375e-2), SC_(1.8470204487525243740480774284818604942655055760685e-18) }}, 
      {{ SC_(0.7e1), SC_(0.1433600485324859619140625e-1), SC_(9.4195456714879631145465581060971390240605913016647e-17) }}, 
      {{ SC_(0.7e1), SC_(0.1760916970670223236083984375e-1), SC_(3.2351633825752615485614839434982271986658229352008e-16) }}, 
      {{ SC_(0.7e1), SC_(0.6152711808681488037109375e-1), SC_(5.8873930260915374674989454237737730208377956367626e-13) }}, 
      {{ SC_(0.7e1), SC_(0.11958599090576171875e0), SC_(3.175330254744452869252588114264639853167205817015e-11) }}, 
      {{ SC_(0.7e1), SC_(0.15262925624847412109375e0), SC_(1.37306382819489632474481829981320999530458749603e-10) }}, 
      {{ SC_(0.7e1), SC_(0.408089816570281982421875e0), SC_(5.0454108730606873004055781144584974598940725268679e-08) }}, 
      {{ SC_(0.7e1), SC_(0.6540834903717041015625e0), SC_(8.6439452609012235664132667907912941487867684225691e-07) }}, 
      {{ SC_(0.7e1), SC_(0.1097540378570556640625e1), SC_(1.9903149576891282438547022015958250025057830031167e-05) }}, 
      {{ SC_(0.7e1), SC_(0.30944411754608154296875e1), SC_(0.01384785426742151623543148483577563767691802604294) }}, 
      {{ SC_(0.7e1), SC_(0.51139926910400390625e1), SC_(0.51646140440419256730344781907930371686614842827865) }}, 
      {{ SC_(0.7e1), SC_(0.95070552825927734375e1), SC_(159.36813435931220806214715239890071317771114319414) }}, 
      {{ SC_(0.7e1), SC_(0.24750102996826171875e2), SC_(1690985569.3106283509427018529720200073122553490215) }}, 
      {{ SC_(0.7e1), SC_(0.637722015380859375e2), SC_(168498224714212654572390223.05556865829883060936147) }}, 
      {{ SC_(0.1e2), SC_(0.177219114266335964202880859375e-2), SC_(4.6401508807064011421143230437500824609602971352179e-34) }}, 
      {{ SC_(0.1e2), SC_(0.22177286446094512939453125e-2), SC_(3.4923094749247058078410546677911647554526610700822e-33) }}, 
      {{ SC_(0.1e2), SC_(0.7444499991834163665771484375e-2), SC_(1.8899811421673150137144505161791836254612211618897e-28) }}, 
      {{ SC_(0.1e2), SC_(0.1433600485324859619140625e-1), SC_(6.8832366136666889223518611944268692193585979859144e-26) }}, 
      {{ SC_(0.1e2), SC_(0.1760916970670223236083984375e-1), SC_(4.3811749288152295951419128719224259962904962831792e-25) }}, 
      {{ SC_(0.1e2), SC_(0.6152711808681488037109375e-1), SC_(3.4007993440358828048688277506578232572337801931071e-20) }}, 
      {{ SC_(0.1e2), SC_(0.11958599090576171875e0), SC_(1.3465706671882772570222972249225215948417542289846e-17) }}, 
      {{ SC_(0.1e2), SC_(0.15262925624847412109375e0), SC_(1.2104671718281105291439858586423655467136695739629e-16) }}, 
      {{ SC_(0.1e2), SC_(0.408089816570281982421875e0), SC_(8.4861533427406158688302946175483668209061388974216e-13) }}, 
      {{ SC_(0.1e2), SC_(0.6540834903717041015625e0), SC_(5.9662275860826758024768567630605908594392319370419e-11) }}, 
      {{ SC_(0.1e2), SC_(0.1097540378570556640625e1), SC_(6.4263427651003603907119851552021198456497504370918e-09) }}, 
      {{ SC_(0.1e2), SC_(0.30944411754608154296875e1), SC_(9.0581095107475697200688757844596473845335178799724e-05) }}, 
      {{ SC_(0.1e2), SC_(0.51139926910400390625e1), SC_(0.012810443388044946681969202159228942193660937870026) }}, 
      {{ SC_(0.1e2), SC_(0.95070552825927734375e1), SC_(15.60592527978584992145630257468419287679106228448) }}, 
      {{ SC_(0.1e2), SC_(0.24750102996826171875e2), SC_(627917302.57961419731735233323958352991397820713106) }}, 
      {{ SC_(0.1e2), SC_(0.637722015380859375e2), SC_(113459532318575669036439276.87008888326253509718636) }}, 
      {{ SC_(0.13e2), SC_(0.177219114266335964202880859375e-2), SC_(2.4456812841552206198331648276735838307208194344922e-46) }}, 
      {{ SC_(0.13e2), SC_(0.22177286446094512939453125e-2), SC_(3.6072314405975860034046247177476173774735736367531e-45) }}, 
      {{ SC_(0.13e2), SC_(0.7444499991834163665771484375e-2), SC_(7.3841412140501872128796578303854512307073208188581e-39) }}, 
      {{ SC_(0.13e2), SC_(0.1433600485324859619140625e-1), SC_(1.9204924469115190774990181944476141427755118423913e-35) }}, 
      {{ SC_(0.13e2), SC_(0.1760916970670223236083984375e-1), SC_(2.265387054446753441806331709049474788648043685053e-34) }}, 
      {{ SC_(0.13e2), SC_(0.6152711808681488037109375e-1), SC_(7.5007699710758693280183732287855910132602175813639e-28) }}, 
      {{ SC_(0.13e2), SC_(0.11958599090576171875e0), SC_(2.1805434139201279779292196568881545047834755581445e-24) }}, 
      {{ SC_(0.13e2), SC_(0.15262925624847412109375e0), SC_(4.0750693309347507669124384883757014786263684741617e-23) }}, 
      {{ SC_(0.13e2), SC_(0.408089816570281982421875e0), SC_(5.4554704607395994835687731495288041560338136372535e-18) }}, 
      {{ SC_(0.13e2), SC_(0.6540834903717041015625e0), SC_(1.5765156159987458616185208468121472963104447350042e-15) }}, 
      {{ SC_(0.13e2), SC_(0.1097540378570556640625e1), SC_(7.9815499244594723489982895111836413560647173692536e-13) }}, 
      {{ SC_(0.13e2), SC_(0.30944411754608154296875e1), SC_(2.3892209736758076242780232919452695681175929051865e-07) }}, 
      {{ SC_(0.13e2), SC_(0.51139926910400390625e1), SC_(0.00013818222370676455792480764228728714310023991375189) }}, 
      {{ SC_(0.13e2), SC_(0.95070552825927734375e1), SC_(0.79222983175956140130590251649409265616457558165901) }}, 
      {{ SC_(0.13e2), SC_(0.24750102996826171875e2), SC_(167246140.89233842710493520460530057726331634864968) }}, 
      {{ SC_(0.13e2), SC_(0.637722015380859375e2), SC_(66527964895331490665084274.729414759711662772569263) }}, 
      {{ SC_(0.16e2), SC_(0.177219114266335964202880859375e-2), SC_(6.2327384908390204003995267448223005543055023147294e-59) }}, 
      {{ SC_(0.16e2), SC_(0.22177286446094512939453125e-2), SC_(1.8015510900104265741703505220228255217501640996067e-57) }}, 
      {{ SC_(0.16e2), SC_(0.7444499991834163665771484375e-2), SC_(1.3949346528058263997335600963443464048028784827881e-49) }}, 
      {{ SC_(0.16e2), SC_(0.1433600485324859619140625e-1), SC_(2.5908604714318098779930030083499935197035305885449e-45) }}, 
      {{ SC_(0.16e2), SC_(0.1760916970670223236083984375e-1), SC_(5.6637734123262466962398777103859439677795421081841e-44) }}, 
      {{ SC_(0.16e2), SC_(0.6152711808681488037109375e-1), SC_(7.9991945166921338198712046906168540061184875351317e-36) }}, 
      {{ SC_(0.16e2), SC_(0.11958599090576171875e0), SC_(1.7073706303992054301380968751501078313087885491857e-31) }}, 
      {{ SC_(0.16e2), SC_(0.15262925624847412109375e0), SC_(6.6336820967524499048416265672676448776377767154055e-30) }}, 
      {{ SC_(0.16e2), SC_(0.408089816570281982421875e0), SC_(1.6964977370960940867904018220611621037203607694874e-23) }}, 
      {{ SC_(0.16e2), SC_(0.6540834903717041015625e0), SC_(2.0164686264336515855800514562160697497317741039595e-20) }}, 
      {{ SC_(0.16e2), SC_(0.1097540378570556640625e1), SC_(4.8081423013451428446781996718199320667965846227978e-17) }}, 
      {{ SC_(0.16e2), SC_(0.30944411754608154296875e1), SC_(3.1202777146405241319083739284324439475238974819571e-10) }}, 
      {{ SC_(0.16e2), SC_(0.51139926910400390625e1), SC_(7.6506354774553372201041534782782851883589570488462e-07) }}, 
      {{ SC_(0.16e2), SC_(0.95070552825927734375e1), SC_(0.022810518697728430978376653257588972923887424084797) }}, 
      {{ SC_(0.16e2), SC_(0.24750102996826171875e2), SC_(32393686.878233176767714218218026712152488781179032) }}, 
      {{ SC_(0.16e2), SC_(0.637722015380859375e2), SC_(34006044202102043664136930.416215586280411703681407) }}, 
      {{ SC_(0.19e2), SC_(0.177219114266335964202880859375e-2), SC_(8.856847980878727795567709967496260001994211357813e-72) }}, 
      {{ SC_(0.19e2), SC_(0.22177286446094512939453125e-2), SC_(5.0169572297336366765552303079999295510142794228582e-70) }}, 
      {{ SC_(0.19e2), SC_(0.7444499991834163665771484375e-2), SC_(1.4693626716390377205874191389607611038360000766807e-60) }}, 
      {{ SC_(0.19e2), SC_(0.1433600485324859619140625e-1), SC_(1.948932524957243795767695206040602854623886866201e-55) }}, 
      {{ SC_(0.19e2), SC_(0.1760916970670223236083984375e-1), SC_(7.8957019077757739467283477371739720761027952996169e-54) }}, 
      {{ SC_(0.19e2), SC_(0.6152711808681488037109375e-1), SC_(4.7567474718083147260120079391550475135946586430245e-44) }}, 
      {{ SC_(0.19e2), SC_(0.11958599090576171875e0), SC_(7.4545320327999783266332919577297460937028986369503e-39) }}, 
      {{ SC_(0.19e2), SC_(0.15262925624847412109375e0), SC_(6.0215600365965337916484418240419281309301921804305e-37) }}, 
      {{ SC_(0.19e2), SC_(0.408089816570281982421875e0), SC_(2.9423333728004908601963916644442366115689862806536e-29) }}, 
      {{ SC_(0.19e2), SC_(0.6540834903717041015625e0), SC_(1.438974209129641647167542567221369367211385506464e-25) }}, 
      {{ SC_(0.19e2), SC_(0.1097540378570556640625e1), SC_(1.6176424036200185444597270593787016246601449964642e-21) }}, 
      {{ SC_(0.19e2), SC_(0.30944411754608154296875e1), SC_(2.3004460236761897065652511082313592519092019184042e-13) }}, 
      {{ SC_(0.19e2), SC_(0.51139926910400390625e1), SC_(2.4385852987632722455536745570114716849056311307068e-09) }}, 
      {{ SC_(0.19e2), SC_(0.95070552825927734375e1), SC_(0.00040156165740344595105598595665264806808695248156959) }}, 
      {{ SC_(0.19e2), SC_(0.24750102996826171875e2), SC_(4632725.6880069349564692619191717692091439317967541) }}, 
      {{ SC_(0.19e2), SC_(0.637722015380859375e2), SC_(15173140165934437399551589.526356192163119956440712) }}, 
      {{ SC_(0.22e2), SC_(0.177219114266335964202880859375e-2), SC_(7.7217901410693911227150913672524759201196903075688e-85) }}, 
      {{ SC_(0.22e2), SC_(0.22177286446094512939453125e-2), SC_(8.5718139057074217885771301419152193014974567068691e-83) }}, 
      {{ SC_(0.22e2), SC_(0.7444499991834163665771484375e-2), SC_(9.4960431304778410076342752912829121300498851551588e-72) }}, 
      {{ SC_(0.22e2), SC_(0.1433600485324859619140625e-1), SC_(8.9947307650224396323985283241561562881690883036141e-66) }}, 
      {{ SC_(0.22e2), SC_(0.1760916970670223236083984375e-1), SC_(6.7532719454852858707274844730590110322055354201261e-64) }}, 
      {{ SC_(0.22e2), SC_(0.6152711808681488037109375e-1), SC_(1.7354564445702626586581450469447089808517451686261e-52) }}, 
      {{ SC_(0.22e2), SC_(0.11958599090576171875e0), SC_(1.9968997630414801171372011643368703808933684536787e-46) }}, 
      {{ SC_(0.22e2), SC_(0.15262925624847412109375e0), SC_(3.3535879185247440495559628765042054556736832009973e-44) }}, 
      {{ SC_(0.22e2), SC_(0.408089816570281982421875e0), SC_(3.1312999792630543963468112049134819584201438113638e-35) }}, 
      {{ SC_(0.22e2), SC_(0.6540834903717041015625e0), SC_(6.3022559148540593979809071511297179643355284388908e-31) }}, 
      {{ SC_(0.22e2), SC_(0.1097540378570556640625e1), SC_(3.3421661563818918027248621563705615930961800683724e-26) }}, 
      {{ SC_(0.22e2), SC_(0.30944411754608154296875e1), SC_(1.0480943588467369123564849816161014309504231224117e-16) }}, 
      {{ SC_(0.22e2), SC_(0.51139926910400390625e1), SC_(4.8601470687452747654791579038432653167991722888448e-12) }}, 
      {{ SC_(0.22e2), SC_(0.95070552825927734375e1), SC_(4.5932604866635780945986211206328686104317827785376e-06) }}, 
      {{ SC_(0.22e2), SC_(0.24750102996826171875e2), SC_(497042.99880985683333764499216941722667112029683176) }}, 
      {{ SC_(0.22e2), SC_(0.637722015380859375e2), SC_(5918880046023104655771352.6782237242901860852317783) }}, 
      {{ SC_(0.25e2), SC_(0.177219114266335964202880859375e-2), SC_(4.4238249306786722714380053705078343362120752233109e-98) }}, 
      {{ SC_(0.25e2), SC_(0.22177286446094512939453125e-2), SC_(9.6237914479471191558965141844862721081442175321339e-96) }}, 
      {{ SC_(0.25e2), SC_(0.7444499991834163665771484375e-2), SC_(4.0327147045865958831583298860742024446331120501667e-83) }}, 
      {{ SC_(0.25e2), SC_(0.1433600485324859619140625e-1), SC_(2.7278514060116473582575283637948648247484666198626e-76) }}, 
      {{ SC_(0.25e2), SC_(0.1760916970670223236083984375e-1), SC_(3.7955868337522424942465659748636599881281084954936e-74) }}, 
      {{ SC_(0.25e2), SC_(0.6152711808681488037109375e-1), SC_(4.1606316754451939513934325687032936781084709557174e-61) }}, 
      {{ SC_(0.25e2), SC_(0.11958599090576171875e0), SC_(3.5150887159712265449519995061242180635458855716543e-54) }}, 
      {{ SC_(0.25e2), SC_(0.15262925624847412109375e0), SC_(1.2273160435814530154216756907909730168133408979354e-51) }}, 
      {{ SC_(0.25e2), SC_(0.408089816570281982421875e0), SC_(2.1899473435503006448341914230207856810704869083032e-41) }}, 
      {{ SC_(0.25e2), SC_(0.6540834903717041015625e0), SC_(1.8141376468185006270177034679423087959304460589198e-36) }}, 
      {{ SC_(0.25e2), SC_(0.1097540378570556640625e1), SC_(4.5401256012481338865917719171873814815455419943788e-31) }}, 
      {{ SC_(0.25e2), SC_(0.30944411754608154296875e1), SC_(3.1521962466413116247808110835949674611594155007853e-20) }}, 
      {{ SC_(0.25e2), SC_(0.51139926910400390625e1), SC_(6.4427073157520072840733338491592423980722282978731e-15) }}, 
      {{ SC_(0.25e2), SC_(0.95070552825927734375e1), SC_(3.5857709467233735521574525635843083962184714996389e-08) }}, 
      {{ SC_(0.25e2), SC_(0.24750102996826171875e2), SC_(40647.830055777630614853496513882487464182612659778) }}, 
      {{ SC_(0.25e2), SC_(0.637722015380859375e2), SC_(2022150557561339396583620.7453516199727862155230984) }}, 
      {{ SC_(0.28e2), SC_(0.177219114266335964202880859375e-2), SC_(1.7537290958183525886359463869845381510727973831423e-111) }}, 
      {{ SC_(0.28e2), SC_(0.22177286446094512939453125e-2), SC_(7.4766028276759785646169118728086334339479138785121e-109) }}, 
      {{ SC_(0.28e2), SC_(0.7444499991834163665771484375e-2), SC_(1.185050791595980297563816416170548017342823596371e-94) }}, 
      {{ SC_(0.28e2), SC_(0.1433600485324859619140625e-1), SC_(5.724504710844555403747096938161237570505164025639e-87) }}, 
      {{ SC_(0.28e2), SC_(0.1760916970670223236083984375e-1), SC_(1.4761425734303275112655245061072381804432607379419e-84) }}, 
      {{ SC_(0.28e2), SC_(0.6152711808681488037109375e-1), SC_(6.9022390374891292355576926730504869388918678954679e-70) }}, 
      {{ SC_(0.28e2), SC_(0.11958599090576171875e0), SC_(4.2815692363419751017394375328880217150827975972142e-62) }}, 
      {{ SC_(0.28e2), SC_(0.15262925624847412109375e0), SC_(3.1080718605471868275638552768574431110418784071503e-59) }}, 
      {{ SC_(0.28e2), SC_(0.408089816570281982421875e0), SC_(1.0598656166823514975648552246910002876529662767461e-47) }}, 
      {{ SC_(0.28e2), SC_(0.6540834903717041015625e0), SC_(3.6140105230831318695326639669307447887819511019234e-42) }}, 
      {{ SC_(0.28e2), SC_(0.1097540378570556640625e1), SC_(4.2693528244885788297255064309997960048365291014026e-36) }}, 
      {{ SC_(0.28e2), SC_(0.30944411754608154296875e1), SC_(6.5802864120266680645515881946834747879356034935864e-24) }}, 
      {{ SC_(0.28e2), SC_(0.51139926910400390625e1), SC_(5.9585045673303143108135339499940553485447088632098e-18) }}, 
      {{ SC_(0.28e2), SC_(0.95070552825927734375e1), SC_(1.988438534646550878842883479897113184558083848306e-10) }}, 
      {{ SC_(0.28e2), SC_(0.24750102996826171875e2), SC_(2573.1411287700232846977353121103361460322486488431) }}, 
      {{ SC_(0.28e2), SC_(0.637722015380859375e2), SC_(606232660335704409810090.03657524411661636232787034) }}, 
      {{ SC_(0.31e2), SC_(0.177219114266335964202880859375e-2), SC_(5.0087219126383253324349380172860487566432855139685e-125) }}, 
      {{ SC_(0.31e2), SC_(0.22177286446094512939453125e-2), SC_(4.1846800213041264338919690624948669793769364574766e-122) }}, 
      {{ SC_(0.31e2), SC_(0.7444499991834163665771484375e-2), SC_(2.5088591078901587717390863274703893752606853061857e-106) }}, 
      {{ SC_(0.31e2), SC_(0.1433600485324859619140625e-1), SC_(8.6547590603242990949702115694256363867835406572861e-98) }}, 
      {{ SC_(0.31e2), SC_(0.1760916970670223236083984375e-1), SC_(4.1359715994078682698876915805253118998897861437516e-95) }}, 
      {{ SC_(0.31e2), SC_(0.6152711808681488037109375e-1), SC_(8.2493728361189737866670383445494981400106230153243e-79) }}, 
      {{ SC_(0.31e2), SC_(0.11958599090576171875e0), SC_(3.7572570366945474616179276146698625977888359329743e-70) }}, 
      {{ SC_(0.31e2), SC_(0.15262925624847412109375e0), SC_(5.670584642447869741263362302156653059738229151679e-67) }}, 
      {{ SC_(0.31e2), SC_(0.408089816570281982421875e0), SC_(3.6955941921570070467273719291388407719278944905994e-54) }}, 
      {{ SC_(0.31e2), SC_(0.6540834903717041015625e0), SC_(5.1874128673494756833392144870922666768391511767402e-48) }}, 
      {{ SC_(0.31e2), SC_(0.1097540378570556640625e1), SC_(2.8931790681890152449929455935946929857333580509535e-41) }}, 
      {{ SC_(0.31e2), SC_(0.30944411754608154296875e1), SC_(9.9178101387254123888824302991706578879838598783839e-28) }}, 
      {{ SC_(0.31e2), SC_(0.51139926910400390625e1), SC_(3.9932674715594104964128503446033838147659504667162e-21) }}, 
      {{ SC_(0.31e2), SC_(0.95070552825927734375e1), SC_(8.0950989569301632461640932495000811369058776548288e-13) }}, 
      {{ SC_(0.31e2), SC_(0.24750102996826171875e2), SC_(127.94850241485772130585495761695068677510628272) }}, 
      {{ SC_(0.31e2), SC_(0.637722015380859375e2), SC_(159817594923140342623291.20398499833703669395963482) }}, 
      {{ SC_(0.34e2), SC_(0.177219114266335964202880859375e-2), SC_(1.0644934780176950962560394681532225849773680058709e-138) }}, 
      {{ SC_(0.34e2), SC_(0.22177286446094512939453125e-2), SC_(1.7428976035917544129989302428497194913138579202666e-135) }}, 
      {{ SC_(0.34e2), SC_(0.7444499991834163665771484375e-2), SC_(3.9524579403269171803369385637558217271264775288375e-118) }}, 
      {{ SC_(0.34e2), SC_(0.1433600485324859619140625e-1), SC_(9.7369678001635573545503110129537132135591038708835e-109) }}, 
      {{ SC_(0.34e2), SC_(0.1760916970670223236083984375e-1), SC_(8.6233990620942755154548731208557667522524325271062e-106) }}, 
      {{ SC_(0.34e2), SC_(0.6152711808681488037109375e-1), SC_(7.3367515832609213979608708078032887331893716760878e-88) }}, 
      {{ SC_(0.34e2), SC_(0.11958599090576171875e0), SC_(2.4535309861100621118404676470270001610755173253095e-78) }}, 
      {{ SC_(0.34e2), SC_(0.15262925624847412109375e0), SC_(7.6987103226204474228299710459354001986872971425418e-75) }}, 
      {{ SC_(0.34e2), SC_(0.408089816570281982421875e0), SC_(9.5891796438704037962550024950686831416871263944065e-61) }}, 
      {{ SC_(0.34e2), SC_(0.6540834903717041015625e0), SC_(5.5410848148483629243991325407653364478861508321096e-54) }}, 
      {{ SC_(0.34e2), SC_(0.1097540378570556640625e1), SC_(1.4592416702058255678868869069288933084584122765773e-46) }}, 
      {{ SC_(0.34e2), SC_(0.30944411754608154296875e1), SC_(1.1141017553235972731179105495808947512528737037098e-31) }}, 
      {{ SC_(0.34e2), SC_(0.51139926910400390625e1), SC_(1.9999533014515442664410514640311352029537737796512e-24) }}, 
      {{ SC_(0.34e2), SC_(0.95070552825927734375e1), SC_(2.4868440390774050554114069080662971673947902623961e-15) }}, 
      {{ SC_(0.34e2), SC_(0.24750102996826171875e2), SC_(5.06656357626145066912681718080220258943729401784) }}, 
      {{ SC_(0.34e2), SC_(0.637722015380859375e2), SC_(37130522340900238142758.905822881447034320072942124) }}, 
      {{ SC_(0.37e2), SC_(0.177219114266335964202880859375e-2), SC_(1.7287621278190839370590687031994130921705203027731e-152) }}, 
      {{ SC_(0.37e2), SC_(0.22177286446094512939453125e-2), SC_(5.546993284567881066610530840898852183064493438262e-149) }}, 
      {{ SC_(0.37e2), SC_(0.7444499991834163665771484375e-2), SC_(4.7581090814519782725042999839536478983860958645142e-130) }}, 
      {{ SC_(0.37e2), SC_(0.1433600485324859619140625e-1), SC_(8.3708323995790324303958763893727680473342532914197e-120) }}, 
      {{ SC_(0.37e2), SC_(0.1760916970670223236083984375e-1), SC_(1.3739014672168454406680073367182205099607148197632e-116) }}, 
      {{ SC_(0.37e2), SC_(0.6152711808681488037109375e-1), SC_(4.9861237392471978055003726862508643829847162252575e-97) }}, 
      {{ SC_(0.37e2), SC_(0.11958599090576171875e0), SC_(1.2243035655778619905636683889063047401519062606425e-86) }}, 
      {{ SC_(0.37e2), SC_(0.15262925624847412109375e0), SC_(7.9870340394199891721115345149816582762740029243384e-83) }}, 
      {{ SC_(0.37e2), SC_(0.408089816570281982421875e0), SC_(1.9013576951182169806853947255296139623785576186916e-67) }}, 
      {{ SC_(0.37e2), SC_(0.6540834903717041015625e0), SC_(4.5231204964283367350579123529524644256173276796902e-60) }}, 
      {{ SC_(0.37e2), SC_(0.1097540378570556640625e1), SC_(5.6249756162264798875230713047050389930739501783392e-52) }}, 
      {{ SC_(0.37e2), SC_(0.30944411754608154296875e1), SC_(9.5747313181559510960653928485860835096410763339761e-36) }}, 
      {{ SC_(0.37e2), SC_(0.51139926910400390625e1), SC_(7.67859806352689356386823578607221058376012844798e-28) }}, 
      {{ SC_(0.37e2), SC_(0.95070552825927734375e1), SC_(5.9001858858606893937118814413721912920024394022728e-18) }}, 
      {{ SC_(0.37e2), SC_(0.24750102996826171875e2), SC_(0.16182031803861277979226848786561421115178084390837) }}, 
      {{ SC_(0.37e2), SC_(0.637722015380859375e2), SC_(7620156925871909004013.4511789819332608090859149484) }}, 
      {{ SC_(0.4e2), SC_(0.177219114266335964202880859375e-2), SC_(2.1934463145098982856482722894618772007386408955866e-166) }}, 
      {{ SC_(0.4e2), SC_(0.22177286446094512939453125e-2), SC_(1.3792498395120423934684486452597604404348707842772e-162) }}, 
      {{ SC_(0.4e2), SC_(0.7444499991834163665771484375e-2), SC_(4.4750827254189778755330436710326506163523889802085e-142) }}, 
      {{ SC_(0.4e2), SC_(0.1433600485324859619140625e-1), SC_(5.6222881809274427763875173260632408250704436858785e-131) }}, 
      {{ SC_(0.4e2), SC_(0.1760916970670223236083984375e-1), SC_(1.7101422547443159905114096833775090592290767321829e-127) }}, 
      {{ SC_(0.4e2), SC_(0.6152711808681488037109375e-1), SC_(2.6474147397607258550183244427472642118161245275487e-106) }}, 
      {{ SC_(0.4e2), SC_(0.11958599090576171875e0), SC_(4.7729492236342102509017782812387711881706287458449e-95) }}, 
      {{ SC_(0.4e2), SC_(0.15262925624847412109375e0), SC_(6.4737153699907991293058554021804873987255762728477e-91) }}, 
      {{ SC_(0.4e2), SC_(0.408089816570281982421875e0), SC_(2.9454570864564136977420322683387112229627476337539e-74) }}, 
      {{ SC_(0.4e2), SC_(0.6540834903717041015625e0), SC_(2.8846886509171748574863377735521386214202206755858e-66) }}, 
      {{ SC_(0.4e2), SC_(0.1097540378570556640625e1), SC_(1.6941972001909998208906812347963350453047191654302e-57) }}, 
      {{ SC_(0.4e2), SC_(0.30944411754608154296875e1), SC_(6.4346689071340193649227713397841966987433720786189e-40) }}, 
      {{ SC_(0.4e2), SC_(0.51139926910400390625e1), SC_(2.3089841179919606378679849343539819497749439614471e-31) }}, 
      {{ SC_(0.4e2), SC_(0.95070552825927734375e1), SC_(1.102736347295864305334545583894581762444979228683e-20) }}, 
      {{ SC_(0.4e2), SC_(0.24750102996826171875e2), SC_(0.0042179636760203964867503418195156015892913194089181) }}, 
      {{ SC_(0.4e2), SC_(0.637722015380859375e2), SC_(1384718401734132335251.2307161144249865361826025353) }}, 
      {{ SC_(0.43e2), SC_(0.177219114266335964202880859375e-2), SC_(2.2155194558806744336118853845894526377597755033613e-180) }}, 
      {{ SC_(0.43e2), SC_(0.22177286446094512939453125e-2), SC_(2.7301407262855693718808358405067536530151961222709e-176) }}, 
      {{ SC_(0.43e2), SC_(0.7444499991834163665771484375e-2), SC_(3.3506150347288365485455030173519989511162460227522e-154) }}, 
      {{ SC_(0.43e2), SC_(0.1433600485324859619140625e-1), SC_(3.0061756609377494048964736743144427129003213203223e-142) }}, 
      {{ SC_(0.43e2), SC_(0.1760916970670223236083984375e-1), SC_(1.6945940912316967428473837149944892562616754985489e-138) }}, 
      {{ SC_(0.43e2), SC_(0.6152711808681488037109375e-1), SC_(1.1190199437049647148982314787349308670836083412719e-115) }}, 
      {{ SC_(0.43e2), SC_(0.11958599090576171875e0), SC_(1.4812957404734739372437378368931490462014921889916e-103) }}, 
      {{ SC_(0.43e2), SC_(0.15262925624847412109375e0), SC_(4.1771418376583419694971373044913302025322339896609e-99) }}, 
      {{ SC_(0.43e2), SC_(0.408089816570281982421875e0), SC_(3.6324851051777819272129739809658943871874407487028e-81) }}, 
      {{ SC_(0.43e2), SC_(0.6540834903717041015625e0), SC_(1.4646390194930429146922835980901944721928096243995e-72) }}, 
      {{ SC_(0.43e2), SC_(0.1097540378570556640625e1), SC_(4.0625964334686726052275084650431825087265178224124e-63) }}, 
      {{ SC_(0.43e2), SC_(0.30944411754608154296875e1), SC_(3.445055402147930375877257131921015119606512508245e-44) }}, 
      {{ SC_(0.43e2), SC_(0.51139926910400390625e1), SC_(5.5381687600583444906926687040881418784943267264745e-35) }}, 
      {{ SC_(0.43e2), SC_(0.95070552825927734375e1), SC_(1.6515029191453376830894919269624334980950396009178e-23) }}, 
      {{ SC_(0.43e2), SC_(0.24750102996826171875e2), SC_(9.07033473684436819050490950252432930934152092096e-05) }}, 
      {{ SC_(0.43e2), SC_(0.637722015380859375e2), SC_(223349833220390199450.27662394978391334765490925711) }}, 
      {{ SC_(0.46e2), SC_(0.177219114266335964202880859375e-2), SC_(1.8104378462921870510073243689353670043465780417572e-194) }}, 
      {{ SC_(0.46e2), SC_(0.22177286446094512939453125e-2), SC_(4.3720650768675253652563392243562531036087038645837e-190) }}, 
      {{ SC_(0.46e2), SC_(0.7444499991834163665771484375e-2), SC_(2.0295861561067542761383038303516665614408092929621e-166) }}, 
      {{ SC_(0.46e2), SC_(0.1433600485324859619140625e-1), SC_(1.3003944406199447796291213829678693617876885669235e-153) }}, 
      {{ SC_(0.46e2), SC_(0.1760916970670223236083984375e-1), SC_(1.358496858602096893203295098466102421151497813062e-149) }}, 
      {{ SC_(0.46e2), SC_(0.6152711808681488037109375e-1), SC_(3.8266017294469036713813054977133414550613357620995e-125) }}, 
      {{ SC_(0.46e2), SC_(0.11958599090576171875e0), SC_(3.7192605471161617718716878121485601007325143417766e-112) }}, 
      {{ SC_(0.46e2), SC_(0.15262925624847412109375e0), SC_(2.1805444805077346331288545875784651786026586254492e-107) }}, 
      {{ SC_(0.46e2), SC_(0.408089816570281982421875e0), SC_(3.6242559912380282003067476102750491997093042839905e-88) }}, 
      {{ SC_(0.46e2), SC_(0.6540834903717041015625e0), SC_(6.0163489655614054743164061525225632154707225487227e-79) }}, 
      {{ SC_(0.46e2), SC_(0.1097540378570556640625e1), SC_(7.8819672414759206147861166344933846001601735395384e-69) }}, 
      {{ SC_(0.46e2), SC_(0.30944411754608154296875e1), SC_(1.4930590833870162213775836764629326071792693829531e-48) }}, 
      {{ SC_(0.46e2), SC_(0.51139926910400390625e1), SC_(1.0763470713262935904456505724516010574972799879661e-38) }}, 
      {{ SC_(0.46e2), SC_(0.95070552825927734375e1), SC_(2.0115846220319402838816743576250278175262193057597e-26) }}, 
      {{ SC_(0.46e2), SC_(0.24750102996826171875e2), SC_(1.6252200145822910970533586273353022511176623102534e-06) }}, 
      {{ SC_(0.46e2), SC_(0.637722015380859375e2), SC_(32056296975334433492.887437331135099409690999530645) }}, 
      {{ SC_(0.49e2), SC_(0.177219114266335964202880859375e-2), SC_(1.2137476169035449224165111313052760780577498154495e-208) }}, 
      {{ SC_(0.49e2), SC_(0.22177286446094512939453125e-2), SC_(5.744138736848391561405561566827001406807628730672e-204) }}, 
      {{ SC_(0.49e2), SC_(0.7444499991834163665771484375e-2), SC_(1.0086190601725809485592749250036950039156412980801e-178) }}, 
      {{ SC_(0.49e2), SC_(0.1433600485324859619140625e-1), SC_(4.6150092654244014484753439347715293478138962384071e-165) }}, 
      {{ SC_(0.49e2), SC_(0.1760916970670223236083984375e-1), SC_(8.9348715778263801065552292828264974327479981243026e-161) }}, 
      {{ SC_(0.49e2), SC_(0.6152711808681488037109375e-1), SC_(1.073557969060502670244818681362437101258532544188e-134) }}, 
      {{ SC_(0.49e2), SC_(0.11958599090576171875e0), SC_(7.6614056528546695457433049939650076449807425863572e-121) }}, 
      {{ SC_(0.49e2), SC_(0.15262925624847412109375e0), SC_(9.3387316510569269729588388217209165125692830551503e-116) }}, 
      {{ SC_(0.49e2), SC_(0.408089816570281982421875e0), SC_(2.9667037180399959712795194068438806052231435377161e-95) }}, 
      {{ SC_(0.49e2), SC_(0.6540834903717041015625e0), SC_(2.027595514156380296893790154872960085404285710906e-85) }}, 
      {{ SC_(0.49e2), SC_(0.1097540378570556640625e1), SC_(1.254665875782490153416445484836172524618855505355e-74) }}, 
      {{ SC_(0.49e2), SC_(0.30944411754608154296875e1), SC_(5.3112767401349998228922034188767491632135108874701e-53) }}, 
      {{ SC_(0.49e2), SC_(0.51139926910400390625e1), SC_(1.7184230106399633928374634149552055310832862291052e-42) }}, 
      {{ SC_(0.49e2), SC_(0.95070552825927734375e1), SC_(2.0188620523288691423046930654162370151184157582571e-29) }}, 
      {{ SC_(0.49e2), SC_(0.24750102996826171875e2), SC_(2.4486900820026561561243390823793236131043274568681e-08) }}, 
      {{ SC_(0.49e2), SC_(0.637722015380859375e2), SC_(4104203373731508351.8091124505391567563692298373867) }}, 
      {{ SC_(0.52e2), SC_(0.177219114266335964202880859375e-2), SC_(6.7582433736913603419058059256135791361735470637909e-223) }}, 
      {{ SC_(0.52e2), SC_(0.22177286446094512939453125e-2), SC_(6.2679264331526494370328882789831359414684776971336e-218) }}, 
      {{ SC_(0.52e2), SC_(0.7444499991834163665771484375e-2), SC_(4.1630106067711993660903358738294501375369753249879e-191) }}, 
      {{ SC_(0.52e2), SC_(0.1433600485324859619140625e-1), SC_(1.3602875417470081410985454428401245372759992414993e-176) }}, 
      {{ SC_(0.52e2), SC_(0.1760916970670223236083984375e-1), SC_(4.8806612177325115813521165986700318378662496250041e-172) }}, 
      {{ SC_(0.52e2), SC_(0.6152711808681488037109375e-1), SC_(2.5014882661113533293597761965233330461237158797651e-144) }}, 
      {{ SC_(0.52e2), SC_(0.11958599090576171875e0), SC_(1.3107541196311674615336229789222782210248645345988e-129) }}, 
      {{ SC_(0.52e2), SC_(0.15262925624847412109375e0), SC_(3.321788061274790179806750754248969443658942707425e-124) }}, 
      {{ SC_(0.52e2), SC_(0.408089816570281982421875e0), SC_(2.0169405302622672394567009913765725797440815303228e-102) }}, 
      {{ SC_(0.52e2), SC_(0.6540834903717041015625e0), SC_(5.6754178832405837953514458701036195191657065470066e-92) }}, 
      {{ SC_(0.52e2), SC_(0.1097540378570556640625e1), SC_(1.6588360861872987132698768619041215273305353601283e-80) }}, 
      {{ SC_(0.52e2), SC_(0.30944411754608154296875e1), SC_(1.5698207694417899021446502648229999500768660780745e-57) }}, 
      {{ SC_(0.52e2), SC_(0.51139926910400390625e1), SC_(2.2810052462334100092981477624289897510531514533963e-46) }}, 
      {{ SC_(0.52e2), SC_(0.95070552825927734375e1), SC_(1.6888264677784034501755356452466192541124575722402e-32) }}, 
      {{ SC_(0.52e2), SC_(0.24750102996826171875e2), SC_(3.1284554770212266533654823889614535495011507388997e-10) }}, 
      {{ SC_(0.52e2), SC_(0.637722015380859375e2), SC_(469912526052398293.17302112716282663456985359455793) }}, 
      {{ SC_(0.55e2), SC_(0.177219114266335964202880859375e-2), SC_(3.1593849990997961977974943812146816685612063609753e-237) }}, 
      {{ SC_(0.55e2), SC_(0.22177286446094512939453125e-2), SC_(5.7423035662670156701155774883438821586276792733737e-232) }}, 
      {{ SC_(0.55e2), SC_(0.7444499991834163665771484375e-2), SC_(1.4426173536899176398539280108006290466380469104659e-203) }}, 
      {{ SC_(0.55e2), SC_(0.1433600485324859619140625e-1), SC_(3.3662948625298628408893789499302767949884611521748e-188) }}, 
      {{ SC_(0.55e2), SC_(0.1760916970670223236083984375e-1), SC_(2.2383721988438966126895088423110749261179727739443e-183) }}, 
      {{ SC_(0.55e2), SC_(0.6152711808681488037109375e-1), SC_(4.8936711651864414231989567585154845915532624571577e-154) }}, 
      {{ SC_(0.55e2), SC_(0.11958599090576171875e0), SC_(1.8827710109688701937429883606767323358888834986806e-138) }}, 
      {{ SC_(0.55e2), SC_(0.15262925624847412109375e0), SC_(9.9201804930062867946547900039207204930607095294563e-133) }}, 
      {{ SC_(0.55e2), SC_(0.408089816570281982421875e0), SC_(1.1512714886725383721018856342861659745765144062983e-109) }}, 
      {{ SC_(0.55e2), SC_(0.6540834903717041015625e0), SC_(1.3337792351351849232556965484782506374204938471942e-98) }}, 
      {{ SC_(0.55e2), SC_(0.1097540378570556640625e1), SC_(1.8414497718532141402443858594087036395047321320979e-86) }}, 
      {{ SC_(0.55e2), SC_(0.30944411754608154296875e1), SC_(3.8967726654446097204350019896316737688338122273432e-62) }}, 
      {{ SC_(0.55e2), SC_(0.51139926910400390625e1), SC_(2.5442972422456580268434830211595319738276544262809e-50) }}, 
      {{ SC_(0.55e2), SC_(0.95070552825927734375e1), SC_(1.1896599721367974831559089457000349605850672303126e-35) }}, 
      {{ SC_(0.55e2), SC_(0.24750102996826171875e2), SC_(3.4154599781777805873676342450915281728506074263741e-12) }}, 
      {{ SC_(0.55e2), SC_(0.637722015380859375e2), SC_(48234457604444740.335143147971511893573254691716282) }}, 
      {{ SC_(0.58e2), SC_(0.177219114266335964202880859375e-2), SC_(1.2520413645388569928887958112848204212138063461708e-251) }}, 
      {{ SC_(0.58e2), SC_(0.22177286446094512939453125e-2), SC_(4.4595989634686150568429251044625228423529401458671e-246) }}, 
      {{ SC_(0.58e2), SC_(0.7444499991834163665771484375e-2), SC_(4.2378168989917621180007953130186366290981620423231e-216) }}, 
      {{ SC_(0.58e2), SC_(0.1433600485324859619140625e-1), SC_(7.0618906988802236107307134052564237747614610667347e-200) }}, 
      {{ SC_(0.58e2), SC_(0.1760916970670223236083984375e-1), SC_(8.702285916071814227807807229418309354595552484574e-195) }}, 
      {{ SC_(0.58e2), SC_(0.6152711808681488037109375e-1), SC_(8.1155609568253125349091276265266629388793969141888e-164) }}, 
      {{ SC_(0.58e2), SC_(0.11958599090576171875e0), SC_(2.2925633886147348167887929308708443895271449574002e-147) }}, 
      {{ SC_(0.58e2), SC_(0.15262925624847412109375e0), SC_(2.5113943794105648062440017015132938005891936086402e-141) }}, 
      {{ SC_(0.58e2), SC_(0.408089816570281982421875e0), SC_(5.5707269509534084668880316016301521365616605779226e-117) }}, 
      {{ SC_(0.58e2), SC_(0.6540834903717041015625e0), SC_(2.657190957474252490339745093174279959587302920337e-105) }}, 
      {{ SC_(0.58e2), SC_(0.1097540378570556640625e1), SC_(1.7329204095864388145245624373544625363852920610294e-92) }}, 
      {{ SC_(0.58e2), SC_(0.30944411754608154296875e1), SC_(8.2021165289716639245472391886116444446565644799576e-67) }}, 
      {{ SC_(0.58e2), SC_(0.51139926910400390625e1), SC_(2.4075702286581099190297646954055364849049383370423e-54) }}, 
      {{ SC_(0.58e2), SC_(0.95070552825927734375e1), SC_(7.1220189825823412856021938995136401566994991595578e-39) }}, 
      {{ SC_(0.58e2), SC_(0.24750102996826171875e2), SC_(3.2090378383167806078759489925206593790671983259232e-14) }}, 
      {{ SC_(0.58e2), SC_(0.637722015380859375e2), SC_(4449584424751920.8125944951606147809737782831249622) }}, 
      {{ SC_(0.61e2), SC_(0.177219114266335964202880859375e-2), SC_(4.2425710020331914252821718283968275084437170049519e-266) }}, 
      {{ SC_(0.61e2), SC_(0.22177286446094512939453125e-2), SC_(2.9614184695203394581083532929114208408300940116942e-260) }}, 
      {{ SC_(0.61e2), SC_(0.7444499991834163665771484375e-2), SC_(1.0644555775598225924016923665182010252785388717882e-228) }}, 
      {{ SC_(0.61e2), SC_(0.1433600485324859619140625e-1), SC_(1.2667302662084979337826570205994629760575270558421e-211) }}, 
      {{ SC_(0.61e2), SC_(0.1760916970670223236083984375e-1), SC_(2.8928686352184495808714058731442370301152120952584e-206) }}, 
      {{ SC_(0.61e2), SC_(0.6152711808681488037109375e-1), SC_(1.1507915428192169017964403554298572567426260297269e-173) }}, 
      {{ SC_(0.61e2), SC_(0.11958599090576171875e0), SC_(2.3869299277328255154517154042855638918319843712064e-156) }}, 
      {{ SC_(0.61e2), SC_(0.15262925624847412109375e0), SC_(5.4363176381398824179797926296956081316400445904413e-150) }}, 
      {{ SC_(0.61e2), SC_(0.408089816570281982421875e0), SC_(2.304846819977282184080434493418762646459057636491e-124) }}, 
      {{ SC_(0.61e2), SC_(0.6540834903717041015625e0), SC_(4.5264779375838098725800226481107380276899609082274e-112) }}, 
      {{ SC_(0.61e2), SC_(0.1097540378570556640625e1), SC_(1.394454579586264814875228803591527867526457487378e-98) }}, 
      {{ SC_(0.61e2), SC_(0.30944411754608154296875e1), SC_(1.4765286399092230040791741547510647367576508020078e-71) }}, 
      {{ SC_(0.61e2), SC_(0.51139926910400390625e1), SC_(1.9492095186618141817805891509498817574437792414524e-58) }}, 
      {{ SC_(0.61e2), SC_(0.95070552825927734375e1), SC_(3.6535166424498974327222404091018181991713133997357e-42) }}, 
      {{ SC_(0.61e2), SC_(0.24750102996826171875e2), SC_(2.6118649550402288054398306933496441568963183554462e-16) }}, 
      {{ SC_(0.61e2), SC_(0.637722015380859375e2), SC_(369792726054441.26944059981155583095952179135366203) }}, 
      {{ SC_(0.64e2), SC_(0.177219114266335964202880859375e-2), SC_(1.2388215254263042046658811407264068831944639577887e-280) }}, 
      {{ SC_(0.64e2), SC_(0.22177286446094512939453125e-2), SC_(1.6946223779377366322214570359963237180694346302933e-274) }}, 
      {{ SC_(0.64e2), SC_(0.7444499991834163665771484375e-2), SC_(2.3039978927625714612754208135610671784320013072718e-241) }}, 
      {{ SC_(0.64e2), SC_(0.1433600485324859619140625e-1), SC_(1.9580171289330104594320265640969941604408912539339e-223) }}, 
      {{ SC_(0.64e2), SC_(0.1760916970670223236083984375e-1), SC_(8.2869222089767530366964301609205640263233926997991e-218) }}, 
      {{ SC_(0.64e2), SC_(0.6152711808681488037109375e-1), SC_(1.4061899668280737770929553194231885629327969496772e-183) }}, 
      {{ SC_(0.64e2), SC_(0.11958599090576171875e0), SC_(2.1415454598728861932080547695071679847395256848646e-165) }}, 
      {{ SC_(0.64e2), SC_(0.15262925624847412109375e0), SC_(1.0140610986099354939720650920341316744599074527865e-158) }}, 
      {{ SC_(0.64e2), SC_(0.408089816570281982421875e0), SC_(8.2175612618247530833632942052734480423446402337471e-132) }}, 
      {{ SC_(0.64e2), SC_(0.6540834903717041015625e0), SC_(6.644634547471484880791466057684730813837330292183e-119) }}, 
      {{ SC_(0.64e2), SC_(0.1097540378570556640625e1), SC_(9.6696376607232609042276705446491638405663890260955e-105) }}, 
      {{ SC_(0.64e2), SC_(0.30944411754608154296875e1), SC_(2.2909383826664629344212826375049004437270655767509e-76) }}, 
      {{ SC_(0.64e2), SC_(0.51139926910400390625e1), SC_(1.3606375299804661100856453043111750946073025084922e-62) }}, 
      {{ SC_(0.64e2), SC_(0.95070552825927734375e1), SC_(1.6180433668923993064382449435665897851233631058371e-45) }}, 
      {{ SC_(0.64e2), SC_(0.24750102996826171875e2), SC_(1.8526974585711814390179423187480033162454423293619e-18) }}, 
      {{ SC_(0.64e2), SC_(0.637722015380859375e2), SC_(27753113149542.319960176525351078723832287820547493) }}, 
      {{ SC_(0.67e2), SC_(0.177219114266335964202880859375e-2), SC_(3.1391579949641315570429785335251785779472340952396e-295) }}, 
      {{ SC_(0.67e2), SC_(0.22177286446094512939453125e-2), SC_(8.4153251602910179456365817555428171807809518688995e-289) }}, 
      {{ SC_(0.67e2), SC_(0.7444499991834163665771484375e-2), SC_(4.3277425893419072609128204122623810704245409423407e-254) }}, 
      {{ SC_(0.67e2), SC_(0.1433600485324859619140625e-1), SC_(2.6264772024499850109130857465955655576422239032293e-235) }}, 
      {{ SC_(0.67e2), SC_(0.1760916970670223236083984375e-1), SC_(2.0600730537734909016515261785532438510975012855129e-229) }}, 
      {{ SC_(0.67e2), SC_(0.6152711808681488037109375e-1), SC_(1.4911322583614259693979664878250519196585835218334e-193) }}, 
      {{ SC_(0.67e2), SC_(0.11958599090576171875e0), SC_(1.6674001854529428038637462621355919009987100139771e-174) }}, 
      {{ SC_(0.67e2), SC_(0.15262925624847412109375e0), SC_(1.6415284380093694762051254707233017592566535189797e-167) }}, 
      {{ SC_(0.67e2), SC_(0.408089816570281982421875e0), SC_(2.5425525749591888960496273354363910266310540776057e-139) }}, 
      {{ SC_(0.67e2), SC_(0.6540834903717041015625e0), SC_(8.4646682425793074323920353901914134714572584083322e-126) }}, 
      {{ SC_(0.67e2), SC_(0.1097540378570556640625e1), SC_(5.8190252763780625217344009150147801436271833123923e-111) }}, 
      {{ SC_(0.67e2), SC_(0.30944411754608154296875e1), SC_(3.0852077415388690855886325107096863249917033942949e-81) }}, 
      {{ SC_(0.67e2), SC_(0.51139926910400390625e1), SC_(8.2462111027747296965681108576161141617822209913075e-67) }}, 
      {{ SC_(0.67e2), SC_(0.95070552825927734375e1), SC_(6.2285651920123373313610961040377593081523421620429e-49) }}, 
      {{ SC_(0.67e2), SC_(0.24750102996826171875e2), SC_(1.1517779224277461415676244801629515542988750835375e-20) }}, 
      {{ SC_(0.67e2), SC_(0.637722015380859375e2), SC_(1885370641257.1827204796598740013286146728943092018) }}, 
      {{ SC_(0.7e2), SC_(0.177219114266335964202880859375e-2), SC_(6.9473961878707575158600210597440403366919272660158e-310) }}, 
      {{ SC_(0.7e2), SC_(0.7444499991834163665771484375e-2), SC_(7.0997854620701933448207860785327496840617296058248e-267) }}, 
      {{ SC_(0.7e2), SC_(0.1433600485324859619140625e-1), SC_(3.0770549060187263202686051152703950291929132300009e-247) }}, 
      {{ SC_(0.7e2), SC_(0.1760916970670223236083984375e-1), SC_(4.4727687301545682185419970522402590443925802186037e-241) }}, 
      {{ SC_(0.7e2), SC_(0.6152711808681488037109375e-1), SC_(1.38099727631585453821424328210265554521889576794e-203) }}, 
      {{ SC_(0.7e2), SC_(0.11958599090576171875e0), SC_(1.1338535137583496021114388849056277318334203998478e-183) }}, 
      {{ SC_(0.7e2), SC_(0.15262925624847412109375e0), SC_(2.3207978713078011352593728014212904279302244216489e-176) }}, 
      {{ SC_(0.7e2), SC_(0.408089816570281982421875e0), SC_(6.8707243490708476481738782345605125804860468763652e-147) }}, 
      {{ SC_(0.7e2), SC_(0.6540834903717041015625e0), SC_(9.4179449916360381129438016958300605326351814425029e-133) }}, 
      {{ SC_(0.7e2), SC_(0.1097540378570556640625e1), SC_(3.058460877037596390669567494169930309974687355767e-117) }}, 
      {{ SC_(0.7e2), SC_(0.30944411754608154296875e1), SC_(3.6293163655119455138709489938300238971715047471255e-86) }}, 
      {{ SC_(0.7e2), SC_(0.51139926910400390625e1), SC_(4.3666440561259071006305673721113793993049308903697e-71) }}, 
      {{ SC_(0.7e2), SC_(0.95070552825927734375e1), SC_(2.0969827693288095828633768469004433740064673456557e-52) }}, 
      {{ SC_(0.7e2), SC_(0.24750102996826171875e2), SC_(6.3081171041477797378349146657536728814518874279765e-23) }}, 
      {{ SC_(0.7e2), SC_(0.637722015380859375e2), SC_(116200587705.9972033212971866848583486865390099783) }}, 
      {{ SC_(0.73e2), SC_(0.177219114266335964202880859375e-2), SC_(1.3507496963190848811812605035755276822306783013008e-324) }}, 
      {{ SC_(0.73e2), SC_(0.22177286446094512939453125e-2), SC_(1.3906558628240210167410406322926273217138498155297e-317) }}, 
      {{ SC_(0.73e2), SC_(0.7444499991834163665771484375e-2), SC_(1.0232292612643929164393555734712076107963466015419e-279) }}, 
      {{ SC_(0.73e2), SC_(0.1433600485324859619140625e-1), SC_(3.1669468744744228128871438059384274750920481170588e-259) }}, 
      {{ SC_(0.73e2), SC_(0.1760916970670223236083984375e-1), SC_(8.5312798332901951159689132307158391752594168130046e-253) }}, 
      {{ SC_(0.73e2), SC_(0.6152711808681488037109375e-1), SC_(1.1236043760547774550840777773292804117368603963381e-213) }}, 
      {{ SC_(0.73e2), SC_(0.11958599090576171875e0), SC_(6.773576827937433880701869360263370808791766081818e-193) }}, 
      {{ SC_(0.73e2), SC_(0.15262925624847412109375e0), SC_(2.8825064217746425597303617323233603741034850031809e-185) }}, 
      {{ SC_(0.73e2), SC_(0.408089816570281982421875e0), SC_(1.6310978659437693190299774851696549575048944847774e-154) }}, 
      {{ SC_(0.73e2), SC_(0.6540834903717041015625e0), SC_(9.2055305236266895105402372198275994943403004085982e-140) }}, 
      {{ SC_(0.73e2), SC_(0.1097540378570556640625e1), SC_(1.4122341130484579348120664306328290171004071749639e-123) }}, 
      {{ SC_(0.73e2), SC_(0.30944411754608154296875e1), SC_(3.7511636793232867462931323998211418887996843788832e-91) }}, 
      {{ SC_(0.73e2), SC_(0.51139926910400390625e1), SC_(2.0320758792487700817910271861967809334924888836874e-75) }}, 
      {{ SC_(0.73e2), SC_(0.95070552825927734375e1), SC_(6.2097685364004522844908379887813700451507749938078e-56) }}, 
      {{ SC_(0.73e2), SC_(0.24750102996826171875e2), SC_(3.0584007614905224150486889015635217620856903402764e-25) }}, 
      {{ SC_(0.73e2), SC_(0.637722015380859375e2), SC_(6512044119.7702057066658291352087070348263357228093) }}, 
      {{ SC_(0.76e2), SC_(0.177219114266335964202880859375e-2), SC_(2.3195339478133814054007492392224202349931276855473e-339) }}, 
      {{ SC_(0.76e2), SC_(0.22177286446094512939453125e-2), SC_(4.6799267801180082535015118083610105786567490647111e-332) }}, 
      {{ SC_(0.76e2), SC_(0.7444499991834163665771484375e-2), SC_(1.302487964423846871761170667875260709588948583303e-292) }}, 
      {{ SC_(0.76e2), SC_(0.1433600485324859619140625e-1), SC_(2.8788520988405523410234474831788210360652724346618e-271) }}, 
      {{ SC_(0.76e2), SC_(0.1760916970670223236083984375e-1), SC_(1.4372257027590942365638884742058014425484218169965e-264) }}, 
      {{ SC_(0.76e2), SC_(0.6152711808681488037109375e-1), SC_(8.0743409403950639843494092057130732296951054158363e-224) }}, 
      {{ SC_(0.76e2), SC_(0.11958599090576171875e0), SC_(3.5739814054216253005793493470952029267539287015973e-202) }}, 
      {{ SC_(0.76e2), SC_(0.15262925624847412109375e0), SC_(3.1621059211308472966030568819860933756230005522119e-194) }}, 
      {{ SC_(0.76e2), SC_(0.408089816570281982421875e0), SC_(3.4200419048105661428016795544405914835338349409359e-162) }}, 
      {{ SC_(0.76e2), SC_(0.6540834903717041015625e0), SC_(7.9472481910706086097506541561280938718583919474349e-147) }}, 
      {{ SC_(0.76e2), SC_(0.1097540378570556640625e1), SC_(5.7595666922124447046430787468026384041534535625797e-130) }}, 
      {{ SC_(0.76e2), SC_(0.30944411754608154296875e1), SC_(3.4247611609219922313466541280690329008558200182914e-96) }}, 
      {{ SC_(0.76e2), SC_(0.51139926910400390625e1), SC_(8.3549036111460052656699367013939841144814107156374e-80) }}, 
      {{ SC_(0.76e2), SC_(0.95070552825927734375e1), SC_(1.6259075460259942049178264036277075443223749204689e-59) }}, 
      {{ SC_(0.76e2), SC_(0.24750102996826171875e2), SC_(1.318576118552021545104435738323048727864154201574e-27) }}, 
      {{ SC_(0.76e2), SC_(0.637722015380859375e2), SC_(332559623.8985721331192076011185438876913669207339) }}, 
      {{ SC_(0.79e2), SC_(0.177219114266335964202880859375e-2), SC_(3.5354403212019364046063104755631828771883937058006e-354) }}, 
      {{ SC_(0.79e2), SC_(0.22177286446094512939453125e-2), SC_(1.3978976306615431583515397352566586129978164981083e-346) }}, 
      {{ SC_(0.79e2), SC_(0.7444499991834163665771484375e-2), SC_(1.4716055261727348172790592652718757218968491250897e-305) }}, 
      {{ SC_(0.79e2), SC_(0.1433600485324859619140625e-1), SC_(2.3228162360620189257436933252556231587350476505745e-283) }}, 
      {{ SC_(0.79e2), SC_(0.1760916970670223236083984375e-1), SC_(2.1490805210942587181886096768253317000272047900881e-276) }}, 
      {{ SC_(0.79e2), SC_(0.6152711808681488037109375e-1), SC_(5.1501240022553382313931109927252352647508033725137e-234) }}, 
      {{ SC_(0.79e2), SC_(0.11958599090576171875e0), SC_(1.6737997765406598434264054525564444084850592554407e-211) }}, 
      {{ SC_(0.79e2), SC_(0.15262925624847412109375e0), SC_(3.0789282916516690174719881434864575044336286368998e-203) }}, 
      {{ SC_(0.79e2), SC_(0.408089816570281982421875e0), SC_(6.36503109275278961131724617973150670884809100085e-170) }}, 
      {{ SC_(0.79e2), SC_(0.6540834903717041015625e0), SC_(6.0898084719470202787549713824635043238285438147712e-154) }}, 
      {{ SC_(0.79e2), SC_(0.1097540378570556640625e1), SC_(2.0849489482470412059259293955112926383959218775221e-136) }}, 
      {{ SC_(0.79e2), SC_(0.30944411754608154296875e1), SC_(2.7755929193923341619599366432165290745895361503068e-101) }}, 
      {{ SC_(0.79e2), SC_(0.51139926910400390625e1), SC_(3.0498646489259068012138998537230278724083029378205e-84) }}, 
      {{ SC_(0.79e2), SC_(0.95070552825927734375e1), SC_(3.7822190240734211344697436228310459325646325013602e-63) }}, 
      {{ SC_(0.79e2), SC_(0.24750102996826171875e2), SC_(5.0763751887669428908160377413843070315272619394593e-30) }}, 
      {{ SC_(0.79e2), SC_(0.637722015380859375e2), SC_(15509034.088708430442808142776840096102763256428376) }}, 
      {{ SC_(0.82e2), SC_(0.177219114266335964202880859375e-2), SC_(4.8048862563202889181890537443326779885545248610242e-369) }}, 
      {{ SC_(0.82e2), SC_(0.22177286446094512939453125e-2), SC_(3.7231325849660746143336380063851346168130573371484e-361) }}, 
      {{ SC_(0.82e2), SC_(0.7444499991834163665771484375e-2), SC_(1.4825383087772703677121933113230100416009283671034e-318) }}, 
      {{ SC_(0.82e2), SC_(0.1433600485324859619140625e-1), SC_(1.6711182277052575836893718534668728582756108648312e-295) }}, 
      {{ SC_(0.82e2), SC_(0.1760916970670223236083984375e-1), SC_(2.8653470065901442471349796594633948569490121927789e-288) }}, 
      {{ SC_(0.82e2), SC_(0.6152711808681488037109375e-1), SC_(2.9290388140539613063288304116939069775353632716894e-244) }}, 
      {{ SC_(0.82e2), SC_(0.11958599090576171875e0), SC_(6.989588437838497498633490694257384354295169533204e-221) }}, 
      {{ SC_(0.82e2), SC_(0.15262925624847412109375e0), SC_(2.6731273786128594995441372203649359993461979500185e-212) }}, 
      {{ SC_(0.82e2), SC_(0.408089816570281982421875e0), SC_(1.0562510171246344218084352488817570605950194519393e-177) }}, 
      {{ SC_(0.82e2), SC_(0.6540834903717041015625e0), SC_(4.1609172226269596757660908595807745867150206089336e-161) }}, 
      {{ SC_(0.82e2), SC_(0.1097540378570556640625e1), SC_(6.7298102679330724106181833447827647907096714047206e-143) }}, 
      {{ SC_(0.82e2), SC_(0.30944411754608154296875e1), SC_(2.0059377323087951081667274371186273644145227822575e-106) }}, 
      {{ SC_(0.82e2), SC_(0.51139926910400390625e1), SC_(9.9294186782645320133623704220686212337084869523935e-89) }}, 
      {{ SC_(0.82e2), SC_(0.95070552825927734375e1), SC_(7.8516737724524765361257804357393329459841050420731e-67) }}, 
      {{ SC_(0.82e2), SC_(0.24750102996826171875e2), SC_(1.7520334090734988621562311121564391919297578081493e-32) }}, 
      {{ SC_(0.82e2), SC_(0.637722015380859375e2), SC_(661845.41868057886844507495847825147949109845357718) }}, 
      {{ SC_(0.85e2), SC_(0.177219114266335964202880859375e-2), SC_(5.8472757925281335709441070120916109604930024452409e-384) }}, 
      {{ SC_(0.85e2), SC_(0.22177286446094512939453125e-2), SC_(8.8791726773414850912512854292238871639394376398273e-376) }}, 
      {{ SC_(0.85e2), SC_(0.7444499991834163665771484375e-2), SC_(1.3373691635430932409867433733092264367846631443699e-331) }}, 
      {{ SC_(0.85e2), SC_(0.1433600485324859619140625e-1), SC_(1.0765404847203446320910822788131070879964149338772e-307) }}, 
      {{ SC_(0.85e2), SC_(0.1760916970670223236083984375e-1), SC_(3.420838952015165818158018000931089841366043146575e-300) }}, 
      {{ SC_(0.85e2), SC_(0.6152711808681488037109375e-1), SC_(1.4916380317089088216843268489867077713269951388358e-254) }}, 
      {{ SC_(0.85e2), SC_(0.11958599090576171875e0), SC_(2.6135488501491766407431161565237945419126408844675e-230) }}, 
      {{ SC_(0.85e2), SC_(0.15262925624847412109375e0), SC_(2.0781203049030925463263429601388263138063177457416e-221) }}, 
      {{ SC_(0.85e2), SC_(0.408089816570281982421875e0), SC_(1.5695141280427997758020218417755528490733613885247e-185) }}, 
      {{ SC_(0.85e2), SC_(0.6540834903717041015625e0), SC_(2.5456984433230137894914413111361227522822484252069e-168) }}, 
      {{ SC_(0.85e2), SC_(0.1097540378570556640625e1), SC_(1.9451160142029278734236728286821772378084338638687e-149) }}, 
      {{ SC_(0.85e2), SC_(0.30944411754608154296875e1), SC_(1.2982106047581298813134523396297908278237157397917e-111) }}, 
      {{ SC_(0.85e2), SC_(0.51139926910400390625e1), SC_(2.8953015092379672002808952081487566053733334541789e-93) }}, 
      {{ SC_(0.85e2), SC_(0.95070552825927734375e1), SC_(1.4606208585387583821716999258644880230045971888375e-70) }}, 
      {{ SC_(0.85e2), SC_(0.24750102996826171875e2), SC_(5.4408313801020912656180501212839264038981557151731e-35) }}, 
      {{ SC_(0.85e2), SC_(0.637722015380859375e2), SC_(25897.152181004517269750138033637774774294027201157) }}, 
      {{ SC_(0.88e2), SC_(0.177219114266335964202880859375e-2), SC_(6.3967392280596030279323854433032980999361288193673e-399) }}, 
      {{ SC_(0.88e2), SC_(0.22177286446094512939453125e-2), SC_(1.9035798676765477375707106012504409197237459683134e-390) }}, 
      {{ SC_(0.88e2), SC_(0.7444499991834163665771484375e-2), SC_(1.0845043229696536816589939558806337747262693806117e-344) }}, 
      {{ SC_(0.88e2), SC_(0.1433600485324859619140625e-1), SC_(6.2343066307351531677125296908505917958463867368011e-320) }}, 
      {{ SC_(0.88e2), SC_(0.1760916970670223236083984375e-1), SC_(3.6713233393263255015318969376892728032966858934394e-312) }}, 
      {{ SC_(0.88e2), SC_(0.6152711808681488037109375e-1), SC_(6.8286740416097889483960253094161116355961137599911e-265) }}, 
      {{ SC_(0.88e2), SC_(0.11958599090576171875e0), SC_(8.7850510192292171781935576131152961424001837737372e-240) }}, 
      {{ SC_(0.88e2), SC_(0.15262925624847412109375e0), SC_(1.4523001945931213963724402582050155086750135868739e-230) }}, 
      {{ SC_(0.88e2), SC_(0.408089816570281982421875e0), SC_(2.0965173883428983962808243031008372953025094614022e-193) }}, 
      {{ SC_(0.88e2), SC_(0.6540834903717041015625e0), SC_(1.4001057827881787318362535742853637138047693417883e-175) }}, 
      {{ SC_(0.88e2), SC_(0.1097540378570556640625e1), SC_(5.0539014586103948417980337852169920633032949579937e-156) }}, 
      {{ SC_(0.88e2), SC_(0.30944411754608154296875e1), SC_(7.5533392148555117094876622598604796141439853510179e-117) }}, 
      {{ SC_(0.88e2), SC_(0.51139926910400390625e1), SC_(7.5907438126908222770882865866850381553729181510969e-98) }}, 
      {{ SC_(0.88e2), SC_(0.95070552825927734375e1), SC_(2.4442318532108741067843417039652114734958529194241e-74) }}, 
      {{ SC_(0.88e2), SC_(0.24750102996826171875e2), SC_(1.5255185376367196961330937653065804471587161182596e-37) }}, 
      {{ SC_(0.88e2), SC_(0.637722015380859375e2), SC_(930.9184838624792218675752167087125839937752968732) }},
      {{ SC_(0.0), SC_(-0.177219114266335964202880859375e-2), SC_(-0.00088609591919750015203076551463481289812081759457593) }}, 
      {{ SC_(0.0), SC_(-0.22177286446094512939453125e-2), SC_(-0.0011088650040236093434924259738776777082777117728366) }}, 
      {{ SC_(0.0), SC_(-0.7444499991834163665771484375e-2), SC_(-0.003722275782133396649790935284938128705516556817227) }}, 
      {{ SC_(0.0), SC_(-0.1433600485324859619140625e-1), SC_(-0.0071681865751110609746510378519051273111721075420681) }}, 
      {{ SC_(0.0), SC_(-0.1760916970670223236083984375e-1), SC_(-0.008804926126614467969087386987026758424777681208949) }}, 
      {{ SC_(0.0), SC_(-0.6152711808681488037109375e-1), SC_(-0.030778118603049061956303124312187349139104670901298) }}, 
      {{ SC_(0.0), SC_(-0.11958599090576171875e0), SC_(-0.059899945189311456643393232325528632776126403440763) }}, 
      {{ SC_(0.0), SC_(-0.15262925624847412109375e0), SC_(-0.076537069171312995155266637603161226785362168868793) }}, 
      {{ SC_(0.0), SC_(-0.408089816570281982421875e0), SC_(-0.20832212130892514352270120184527358300711621253093) }}, 
      {{ SC_(0.0), SC_(-0.6540834903717041015625e0), SC_(-0.34484589720660571203268712177657285280507611555709) }}, 
      {{ SC_(0.0), SC_(-0.1097540378570556640625e1), SC_(-0.63565392939687165931975701385906830196228023376933) }}, 
      {{ SC_(0.0), SC_(-0.30944411754608154296875e1), SC_(-4.304586767845429639244166020309162877221031947039) }}, 
      {{ SC_(0.0), SC_(-0.51139926910400390625e1), SC_(-27.026310609828701503222843893102992533224960967973) }}, 
      {{ SC_(0.0), SC_(-0.95070552825927734375e1), SC_(-1669.6303950934903244727446466214615294086023903195) }}, 
      {{ SC_(0.0), SC_(-0.24750102996826171875e2), SC_(-4428295881.3677779786815636628866430364992082651157) }}, 
      {{ SC_(0.0), SC_(-0.637722015380859375e2), SC_(-246567311915704274501887357.24020001512007921147054) }}, 
      {{ SC_(0.1e1), SC_(-0.177219114266335964202880859375e-2), SC_(0.50000058887414958452485804994744934952377336181573) }}, 
      {{ SC_(0.1e1), SC_(-0.22177286446094512939453125e-2), SC_(0.50000092218537893261448430232179397590419077630156) }}, 
      {{ SC_(0.1e1), SC_(-0.7444499991834163665771484375e-2), SC_(0.50001039139876686065339052546517335546246153291185) }}, 
      {{ SC_(0.1e1), SC_(-0.1433600485324859619140625e-1), SC_(0.50003853574407998926317310663333528092870153852384) }}, 
      {{ SC_(0.1e1), SC_(-0.1760916970670223236083984375e-1), SC_(0.50005814178781229442302267906313903386120382311391) }}, 
      {{ SC_(0.1e1), SC_(-0.6152711808681488037109375e-1), SC_(0.50070998404154571459128156447054892961460345184902) }}, 
      {{ SC_(0.1e1), SC_(-0.11958599090576171875e0), SC_(0.5026840657714710757890236690799629757305465005453) }}, 
      {{ SC_(0.1e1), SC_(-0.15262925624847412109375e0), SC_(0.50437501291751594265663420039241884122843561276152) }}, 
      {{ SC_(0.1e1), SC_(-0.408089816570281982421875e0), SC_(0.53158863081248487334362919459520848093354880736601) }}, 
      {{ SC_(0.1e1), SC_(-0.6540834903717041015625e0), SC_(0.58263043215568911299814886678184475770592474363462) }}, 
      {{ SC_(0.1e1), SC_(-0.1097540378570556640625e1), SC_(0.7454322330858457449159781361157891562659959168394) }}, 
      {{ SC_(0.1e1), SC_(-0.30944411754608154296875e1), SC_(3.8794322064706267194422881162259380140744641171029) }}, 
      {{ SC_(0.1e1), SC_(-0.51139926910400390625e1), SC_(24.879824200109264550070346070548572538675416510962) }}, 
      {{ SC_(0.1e1), SC_(-0.95070552825927734375e1), SC_(1589.6010892466270146562540500585578585568257598452) }}, 
      {{ SC_(0.1e1), SC_(-0.24750102996826171875e2), SC_(4341662415.1619366320979220433134729416481099471501) }}, 
      {{ SC_(0.1e1), SC_(-0.637722015380859375e2), SC_(244657223419722976962060156.64526989576384593438155) }}, 
      {{ SC_(0.4e1), SC_(-0.177219114266335964202880859375e-2), SC_(-5.7977642791440240594069365123737373446875473336019e-11) }}, 
      {{ SC_(0.4e1), SC_(-0.22177286446094512939453125e-2), SC_(-1.1361983257670755452088629287120813120498174641957e-10) }}, 
      {{ SC_(0.4e1), SC_(-0.7444499991834163665771484375e-2), SC_(-4.2977106585064563071965155077470765547580422080236e-09) }}, 
      {{ SC_(0.4e1), SC_(-0.1433600485324859619140625e-1), SC_(-3.0691624717963766687820586762992955366705538139243e-08) }}, 
      {{ SC_(0.4e1), SC_(-0.1760916970670223236083984375e-1), SC_(-5.6879465129841838118217352628667866284796929079985e-08) }}, 
      {{ SC_(0.4e1), SC_(-0.6152711808681488037109375e-1), SC_(-2.4268994701713292881629948960548331673657583324918e-06) }}, 
      {{ SC_(0.4e1), SC_(-0.11958599090576171875e0), SC_(-1.7833452482002047243884933100474315698557783900753e-05) }}, 
      {{ SC_(0.4e1), SC_(-0.15262925624847412109375e0), SC_(-3.7102292783677070216850017034917460055257223905384e-05) }}, 
      {{ SC_(0.4e1), SC_(-0.408089816570281982421875e0), SC_(-0.00071682270806809984142485696566273749789215179247911) }}, 
      {{ SC_(0.4e1), SC_(-0.6540834903717041015625e0), SC_(-0.0030095810505154039505649035929324233185650471379949) }}, 
      {{ SC_(0.4e1), SC_(-0.1097540378570556640625e1), SC_(-0.015058380627056309463722070322914223292754890572289) }}, 
      {{ SC_(0.4e1), SC_(-0.30944411754608154296875e1), SC_(-0.59848912997745095317460689682974327447677370660399) }}, 
      {{ SC_(0.4e1), SC_(-0.51139926910400390625e1), SC_(-7.1096561414745714565763810157506729038368017958419) }}, 
      {{ SC_(0.4e1), SC_(-0.95070552825927734375e1), SC_(-765.16515717873090426778318670348842991572055594829) }}, 
      {{ SC_(0.4e1), SC_(-0.24750102996826171875e2), SC_(-3229907987.7660192457647761075637335091559830439104) }}, 
      {{ SC_(0.4e1), SC_(-0.637722015380859375e2), SC_(-217726882458479319415712565.5405744792891643352915) }}, 
      {{ SC_(0.7e1), SC_(-0.177219114266335964202880859375e-2), SC_(3.3614059042626999826433170034673583525940024533365e-22) }}, 
      {{ SC_(0.7e1), SC_(-0.22177286446094512939453125e-2), SC_(1.2909459381881364762226234760871640013723793229134e-21) }}, 
      {{ SC_(0.7e1), SC_(-0.7444499991834163665771484375e-2), SC_(1.8470204487525243740480774284818604942655055760685e-18) }}, 
      {{ SC_(0.7e1), SC_(-0.1433600485324859619140625e-1), SC_(9.4195456714879631145465581060971390240605913016647e-17) }}, 
      {{ SC_(0.7e1), SC_(-0.1760916970670223236083984375e-1), SC_(3.2351633825752615485614839434982271986658229352008e-16) }}, 
      {{ SC_(0.7e1), SC_(-0.6152711808681488037109375e-1), SC_(5.8873930260915374674989454237737730208377956367626e-13) }}, 
      {{ SC_(0.7e1), SC_(-0.11958599090576171875e0), SC_(3.175330254744452869252588114264639853167205817015e-11) }}, 
      {{ SC_(0.7e1), SC_(-0.15262925624847412109375e0), SC_(1.37306382819489632474481829981320999530458749603e-10) }}, 
      {{ SC_(0.7e1), SC_(-0.408089816570281982421875e0), SC_(5.0454108730606873004055781144584974598940725268679e-08) }}, 
      {{ SC_(0.7e1), SC_(-0.6540834903717041015625e0), SC_(8.6439452609012235664132667907912941487867684225691e-07) }}, 
      {{ SC_(0.7e1), SC_(-0.1097540378570556640625e1), SC_(1.9903149576891282438547022015958250025057830031167e-05) }}, 
      {{ SC_(0.7e1), SC_(-0.30944411754608154296875e1), SC_(0.01384785426742151623543148483577563767691802604294) }}, 
      {{ SC_(0.7e1), SC_(-0.51139926910400390625e1), SC_(0.51646140440419256730344781907930371686614842827865) }}, 
      {{ SC_(0.7e1), SC_(-0.95070552825927734375e1), SC_(159.36813435931220806214715239890071317771114319414) }}, 
      {{ SC_(0.7e1), SC_(-0.24750102996826171875e2), SC_(1690985569.3106283509427018529720200073122553490215) }}, 
      {{ SC_(0.7e1), SC_(-0.637722015380859375e2), SC_(168498224714212654572390223.05556865829883060936147) }}, 
      {{ SC_(0.1e2), SC_(-0.177219114266335964202880859375e-2), SC_(-4.6401508807064011421143230437500824609602971352179e-34) }}, 
      {{ SC_(0.1e2), SC_(-0.22177286446094512939453125e-2), SC_(-3.4923094749247058078410546677911647554526610700822e-33) }}, 
      {{ SC_(0.1e2), SC_(-0.7444499991834163665771484375e-2), SC_(-1.8899811421673150137144505161791836254612211618897e-28) }}, 
      {{ SC_(0.1e2), SC_(-0.1433600485324859619140625e-1), SC_(-6.8832366136666889223518611944268692193585979859144e-26) }}, 
      {{ SC_(0.1e2), SC_(-0.1760916970670223236083984375e-1), SC_(-4.3811749288152295951419128719224259962904962831792e-25) }}, 
      {{ SC_(0.1e2), SC_(-0.6152711808681488037109375e-1), SC_(-3.4007993440358828048688277506578232572337801931071e-20) }}, 
      {{ SC_(0.1e2), SC_(-0.11958599090576171875e0), SC_(-1.3465706671882772570222972249225215948417542289846e-17) }}, 
      {{ SC_(0.1e2), SC_(-0.15262925624847412109375e0), SC_(-1.2104671718281105291439858586423655467136695739629e-16) }}, 
      {{ SC_(0.1e2), SC_(-0.408089816570281982421875e0), SC_(-8.4861533427406158688302946175483668209061388974216e-13) }}, 
      {{ SC_(0.1e2), SC_(-0.6540834903717041015625e0), SC_(-5.9662275860826758024768567630605908594392319370419e-11) }}, 
      {{ SC_(0.1e2), SC_(-0.1097540378570556640625e1), SC_(-6.4263427651003603907119851552021198456497504370918e-09) }}, 
      {{ SC_(0.1e2), SC_(-0.30944411754608154296875e1), SC_(-9.0581095107475697200688757844596473845335178799724e-05) }}, 
      {{ SC_(0.1e2), SC_(-0.51139926910400390625e1), SC_(-0.012810443388044946681969202159228942193660937870026) }}, 
      {{ SC_(0.1e2), SC_(-0.95070552825927734375e1), SC_(-15.60592527978584992145630257468419287679106228448) }}, 
      {{ SC_(0.1e2), SC_(-0.24750102996826171875e2), SC_(-627917302.57961419731735233323958352991397820713106) }}, 
      {{ SC_(0.1e2), SC_(-0.637722015380859375e2), SC_(-113459532318575669036439276.87008888326253509718636) }}, 
      {{ SC_(0.13e2), SC_(-0.177219114266335964202880859375e-2), SC_(2.4456812841552206198331648276735838307208194344922e-46) }}, 
      {{ SC_(0.13e2), SC_(-0.22177286446094512939453125e-2), SC_(3.6072314405975860034046247177476173774735736367531e-45) }}, 
      {{ SC_(0.13e2), SC_(-0.7444499991834163665771484375e-2), SC_(7.3841412140501872128796578303854512307073208188581e-39) }}, 
      {{ SC_(0.13e2), SC_(-0.1433600485324859619140625e-1), SC_(1.9204924469115190774990181944476141427755118423913e-35) }}, 
      {{ SC_(0.13e2), SC_(-0.1760916970670223236083984375e-1), SC_(2.265387054446753441806331709049474788648043685053e-34) }}, 
      {{ SC_(0.13e2), SC_(-0.6152711808681488037109375e-1), SC_(7.5007699710758693280183732287855910132602175813639e-28) }}, 
      {{ SC_(0.13e2), SC_(-0.11958599090576171875e0), SC_(2.1805434139201279779292196568881545047834755581445e-24) }}, 
      {{ SC_(0.13e2), SC_(-0.15262925624847412109375e0), SC_(4.0750693309347507669124384883757014786263684741617e-23) }}, 
      {{ SC_(0.13e2), SC_(-0.408089816570281982421875e0), SC_(5.4554704607395994835687731495288041560338136372535e-18) }}, 
      {{ SC_(0.13e2), SC_(-0.6540834903717041015625e0), SC_(1.5765156159987458616185208468121472963104447350042e-15) }}, 
      {{ SC_(0.13e2), SC_(-0.1097540378570556640625e1), SC_(7.9815499244594723489982895111836413560647173692536e-13) }}, 
      {{ SC_(0.13e2), SC_(-0.30944411754608154296875e1), SC_(2.3892209736758076242780232919452695681175929051865e-07) }}, 
      {{ SC_(0.13e2), SC_(-0.51139926910400390625e1), SC_(0.00013818222370676455792480764228728714310023991375189) }}, 
      {{ SC_(0.13e2), SC_(-0.95070552825927734375e1), SC_(0.79222983175956140130590251649409265616457558165901) }}, 
      {{ SC_(0.13e2), SC_(-0.24750102996826171875e2), SC_(167246140.89233842710493520460530057726331634864968) }}, 
      {{ SC_(0.13e2), SC_(-0.637722015380859375e2), SC_(66527964895331490665084274.729414759711662772569263) }}, 
      {{ SC_(0.16e2), SC_(-0.177219114266335964202880859375e-2), SC_(-6.2327384908390204003995267448223005543055023147294e-59) }}, 
      {{ SC_(0.16e2), SC_(-0.22177286446094512939453125e-2), SC_(-1.8015510900104265741703505220228255217501640996067e-57) }}, 
      {{ SC_(0.16e2), SC_(-0.7444499991834163665771484375e-2), SC_(-1.3949346528058263997335600963443464048028784827881e-49) }}, 
      {{ SC_(0.16e2), SC_(-0.1433600485324859619140625e-1), SC_(-2.5908604714318098779930030083499935197035305885449e-45) }}, 
      {{ SC_(0.16e2), SC_(-0.1760916970670223236083984375e-1), SC_(-5.6637734123262466962398777103859439677795421081841e-44) }}, 
      {{ SC_(0.16e2), SC_(-0.6152711808681488037109375e-1), SC_(-7.9991945166921338198712046906168540061184875351317e-36) }}, 
      {{ SC_(0.16e2), SC_(-0.11958599090576171875e0), SC_(-1.7073706303992054301380968751501078313087885491857e-31) }}, 
      {{ SC_(0.16e2), SC_(-0.15262925624847412109375e0), SC_(-6.6336820967524499048416265672676448776377767154055e-30) }}, 
      {{ SC_(0.16e2), SC_(-0.408089816570281982421875e0), SC_(-1.6964977370960940867904018220611621037203607694874e-23) }}, 
      {{ SC_(0.16e2), SC_(-0.6540834903717041015625e0), SC_(-2.0164686264336515855800514562160697497317741039595e-20) }}, 
      {{ SC_(0.16e2), SC_(-0.1097540378570556640625e1), SC_(-4.8081423013451428446781996718199320667965846227978e-17) }}, 
      {{ SC_(0.16e2), SC_(-0.30944411754608154296875e1), SC_(-3.1202777146405241319083739284324439475238974819571e-10) }}, 
      {{ SC_(0.16e2), SC_(-0.51139926910400390625e1), SC_(-7.6506354774553372201041534782782851883589570488462e-07) }}, 
      {{ SC_(0.16e2), SC_(-0.95070552825927734375e1), SC_(-0.022810518697728430978376653257588972923887424084797) }}, 
      {{ SC_(0.16e2), SC_(-0.24750102996826171875e2), SC_(-32393686.878233176767714218218026712152488781179032) }}, 
      {{ SC_(0.16e2), SC_(-0.637722015380859375e2), SC_(-34006044202102043664136930.416215586280411703681407) }}, 
      {{ SC_(0.19e2), SC_(-0.177219114266335964202880859375e-2), SC_(8.856847980878727795567709967496260001994211357813e-72) }}, 
      {{ SC_(0.19e2), SC_(-0.22177286446094512939453125e-2), SC_(5.0169572297336366765552303079999295510142794228582e-70) }}, 
      {{ SC_(0.19e2), SC_(-0.7444499991834163665771484375e-2), SC_(1.4693626716390377205874191389607611038360000766807e-60) }}, 
      {{ SC_(0.19e2), SC_(-0.1433600485324859619140625e-1), SC_(1.948932524957243795767695206040602854623886866201e-55) }}, 
      {{ SC_(0.19e2), SC_(-0.1760916970670223236083984375e-1), SC_(7.8957019077757739467283477371739720761027952996169e-54) }}, 
      {{ SC_(0.19e2), SC_(-0.6152711808681488037109375e-1), SC_(4.7567474718083147260120079391550475135946586430245e-44) }}, 
      {{ SC_(0.19e2), SC_(-0.11958599090576171875e0), SC_(7.4545320327999783266332919577297460937028986369503e-39) }}, 
      {{ SC_(0.19e2), SC_(-0.15262925624847412109375e0), SC_(6.0215600365965337916484418240419281309301921804305e-37) }}, 
      {{ SC_(0.19e2), SC_(-0.408089816570281982421875e0), SC_(2.9423333728004908601963916644442366115689862806536e-29) }}, 
      {{ SC_(0.19e2), SC_(-0.6540834903717041015625e0), SC_(1.438974209129641647167542567221369367211385506464e-25) }}, 
      {{ SC_(0.19e2), SC_(-0.1097540378570556640625e1), SC_(1.6176424036200185444597270593787016246601449964642e-21) }}, 
      {{ SC_(0.19e2), SC_(-0.30944411754608154296875e1), SC_(2.3004460236761897065652511082313592519092019184042e-13) }}, 
      {{ SC_(0.19e2), SC_(-0.51139926910400390625e1), SC_(2.4385852987632722455536745570114716849056311307068e-09) }}, 
      {{ SC_(0.19e2), SC_(-0.95070552825927734375e1), SC_(0.00040156165740344595105598595665264806808695248156959) }}, 
      {{ SC_(0.19e2), SC_(-0.24750102996826171875e2), SC_(4632725.6880069349564692619191717692091439317967541) }}, 
      {{ SC_(0.19e2), SC_(-0.637722015380859375e2), SC_(15173140165934437399551589.526356192163119956440712) }}, 
      {{ SC_(0.22e2), SC_(-0.177219114266335964202880859375e-2), SC_(-7.7217901410693911227150913672524759201196903075688e-85) }}, 
      {{ SC_(0.22e2), SC_(-0.22177286446094512939453125e-2), SC_(-8.5718139057074217885771301419152193014974567068691e-83) }}, 
      {{ SC_(0.22e2), SC_(-0.7444499991834163665771484375e-2), SC_(-9.4960431304778410076342752912829121300498851551588e-72) }}, 
      {{ SC_(0.22e2), SC_(-0.1433600485324859619140625e-1), SC_(-8.9947307650224396323985283241561562881690883036141e-66) }}, 
      {{ SC_(0.22e2), SC_(-0.1760916970670223236083984375e-1), SC_(-6.7532719454852858707274844730590110322055354201261e-64) }}, 
      {{ SC_(0.22e2), SC_(-0.6152711808681488037109375e-1), SC_(-1.7354564445702626586581450469447089808517451686261e-52) }}, 
      {{ SC_(0.22e2), SC_(-0.11958599090576171875e0), SC_(-1.9968997630414801171372011643368703808933684536787e-46) }}, 
      {{ SC_(0.22e2), SC_(-0.15262925624847412109375e0), SC_(-3.3535879185247440495559628765042054556736832009973e-44) }}, 
      {{ SC_(0.22e2), SC_(-0.408089816570281982421875e0), SC_(-3.1312999792630543963468112049134819584201438113638e-35) }}, 
      {{ SC_(0.22e2), SC_(-0.6540834903717041015625e0), SC_(-6.3022559148540593979809071511297179643355284388908e-31) }}, 
      {{ SC_(0.22e2), SC_(-0.1097540378570556640625e1), SC_(-3.3421661563818918027248621563705615930961800683724e-26) }}, 
      {{ SC_(0.22e2), SC_(-0.30944411754608154296875e1), SC_(-1.0480943588467369123564849816161014309504231224117e-16) }}, 
      {{ SC_(0.22e2), SC_(-0.51139926910400390625e1), SC_(-4.8601470687452747654791579038432653167991722888448e-12) }}, 
      {{ SC_(0.22e2), SC_(-0.95070552825927734375e1), SC_(-4.5932604866635780945986211206328686104317827785376e-06) }}, 
      {{ SC_(0.22e2), SC_(-0.24750102996826171875e2), SC_(-497042.99880985683333764499216941722667112029683176) }}, 
      {{ SC_(0.22e2), SC_(-0.637722015380859375e2), SC_(-5918880046023104655771352.6782237242901860852317783) }}, 
      {{ SC_(0.25e2), SC_(-0.177219114266335964202880859375e-2), SC_(4.4238249306786722714380053705078343362120752233109e-98) }}, 
      {{ SC_(0.25e2), SC_(-0.22177286446094512939453125e-2), SC_(9.6237914479471191558965141844862721081442175321339e-96) }}, 
      {{ SC_(0.25e2), SC_(-0.7444499991834163665771484375e-2), SC_(4.0327147045865958831583298860742024446331120501667e-83) }}, 
      {{ SC_(0.25e2), SC_(-0.1433600485324859619140625e-1), SC_(2.7278514060116473582575283637948648247484666198626e-76) }}, 
      {{ SC_(0.25e2), SC_(-0.1760916970670223236083984375e-1), SC_(3.7955868337522424942465659748636599881281084954936e-74) }}, 
      {{ SC_(0.25e2), SC_(-0.6152711808681488037109375e-1), SC_(4.1606316754451939513934325687032936781084709557174e-61) }}, 
      {{ SC_(0.25e2), SC_(-0.11958599090576171875e0), SC_(3.5150887159712265449519995061242180635458855716543e-54) }}, 
      {{ SC_(0.25e2), SC_(-0.15262925624847412109375e0), SC_(1.2273160435814530154216756907909730168133408979354e-51) }}, 
      {{ SC_(0.25e2), SC_(-0.408089816570281982421875e0), SC_(2.1899473435503006448341914230207856810704869083032e-41) }}, 
      {{ SC_(0.25e2), SC_(-0.6540834903717041015625e0), SC_(1.8141376468185006270177034679423087959304460589198e-36) }}, 
      {{ SC_(0.25e2), SC_(-0.1097540378570556640625e1), SC_(4.5401256012481338865917719171873814815455419943788e-31) }}, 
      {{ SC_(0.25e2), SC_(-0.30944411754608154296875e1), SC_(3.1521962466413116247808110835949674611594155007853e-20) }}, 
      {{ SC_(0.25e2), SC_(-0.51139926910400390625e1), SC_(6.4427073157520072840733338491592423980722282978731e-15) }}, 
      {{ SC_(0.25e2), SC_(-0.95070552825927734375e1), SC_(3.5857709467233735521574525635843083962184714996389e-08) }}, 
      {{ SC_(0.25e2), SC_(-0.24750102996826171875e2), SC_(40647.830055777630614853496513882487464182612659778) }}, 
      {{ SC_(0.25e2), SC_(-0.637722015380859375e2), SC_(2022150557561339396583620.7453516199727862155230984) }}, 
      {{ SC_(0.28e2), SC_(-0.177219114266335964202880859375e-2), SC_(-1.7537290958183525886359463869845381510727973831423e-111) }}, 
      {{ SC_(0.28e2), SC_(-0.22177286446094512939453125e-2), SC_(-7.4766028276759785646169118728086334339479138785121e-109) }}, 
      {{ SC_(0.28e2), SC_(-0.7444499991834163665771484375e-2), SC_(-1.185050791595980297563816416170548017342823596371e-94) }}, 
      {{ SC_(0.28e2), SC_(-0.1433600485324859619140625e-1), SC_(-5.724504710844555403747096938161237570505164025639e-87) }}, 
      {{ SC_(0.28e2), SC_(-0.1760916970670223236083984375e-1), SC_(-1.4761425734303275112655245061072381804432607379419e-84) }}, 
      {{ SC_(0.28e2), SC_(-0.6152711808681488037109375e-1), SC_(-6.9022390374891292355576926730504869388918678954679e-70) }}, 
      {{ SC_(0.28e2), SC_(-0.11958599090576171875e0), SC_(-4.2815692363419751017394375328880217150827975972142e-62) }}, 
      {{ SC_(0.28e2), SC_(-0.15262925624847412109375e0), SC_(-3.1080718605471868275638552768574431110418784071503e-59) }}, 
      {{ SC_(0.28e2), SC_(-0.408089816570281982421875e0), SC_(-1.0598656166823514975648552246910002876529662767461e-47) }}, 
      {{ SC_(0.28e2), SC_(-0.6540834903717041015625e0), SC_(-3.6140105230831318695326639669307447887819511019234e-42) }}, 
      {{ SC_(0.28e2), SC_(-0.1097540378570556640625e1), SC_(-4.2693528244885788297255064309997960048365291014026e-36) }}, 
      {{ SC_(0.28e2), SC_(-0.30944411754608154296875e1), SC_(-6.5802864120266680645515881946834747879356034935864e-24) }}, 
      {{ SC_(0.28e2), SC_(-0.51139926910400390625e1), SC_(-5.9585045673303143108135339499940553485447088632098e-18) }}, 
      {{ SC_(0.28e2), SC_(-0.95070552825927734375e1), SC_(-1.988438534646550878842883479897113184558083848306e-10) }}, 
      {{ SC_(0.28e2), SC_(-0.24750102996826171875e2), SC_(-2573.1411287700232846977353121103361460322486488431) }}, 
      {{ SC_(0.28e2), SC_(-0.637722015380859375e2), SC_(-606232660335704409810090.03657524411661636232787034) }}, 
      {{ SC_(0.31e2), SC_(-0.177219114266335964202880859375e-2), SC_(5.0087219126383253324349380172860487566432855139685e-125) }}, 
      {{ SC_(0.31e2), SC_(-0.22177286446094512939453125e-2), SC_(4.1846800213041264338919690624948669793769364574766e-122) }}, 
      {{ SC_(0.31e2), SC_(-0.7444499991834163665771484375e-2), SC_(2.5088591078901587717390863274703893752606853061857e-106) }}, 
      {{ SC_(0.31e2), SC_(-0.1433600485324859619140625e-1), SC_(8.6547590603242990949702115694256363867835406572861e-98) }}, 
      {{ SC_(0.31e2), SC_(-0.1760916970670223236083984375e-1), SC_(4.1359715994078682698876915805253118998897861437516e-95) }}, 
      {{ SC_(0.31e2), SC_(-0.6152711808681488037109375e-1), SC_(8.2493728361189737866670383445494981400106230153243e-79) }}, 
      {{ SC_(0.31e2), SC_(-0.11958599090576171875e0), SC_(3.7572570366945474616179276146698625977888359329743e-70) }}, 
      {{ SC_(0.31e2), SC_(-0.15262925624847412109375e0), SC_(5.670584642447869741263362302156653059738229151679e-67) }}, 
      {{ SC_(0.31e2), SC_(-0.408089816570281982421875e0), SC_(3.6955941921570070467273719291388407719278944905994e-54) }}, 
      {{ SC_(0.31e2), SC_(-0.6540834903717041015625e0), SC_(5.1874128673494756833392144870922666768391511767402e-48) }}, 
      {{ SC_(0.31e2), SC_(-0.1097540378570556640625e1), SC_(2.8931790681890152449929455935946929857333580509535e-41) }}, 
      {{ SC_(0.31e2), SC_(-0.30944411754608154296875e1), SC_(9.9178101387254123888824302991706578879838598783839e-28) }}, 
      {{ SC_(0.31e2), SC_(-0.51139926910400390625e1), SC_(3.9932674715594104964128503446033838147659504667162e-21) }}, 
      {{ SC_(0.31e2), SC_(-0.95070552825927734375e1), SC_(8.0950989569301632461640932495000811369058776548288e-13) }}, 
      {{ SC_(0.31e2), SC_(-0.24750102996826171875e2), SC_(127.94850241485772130585495761695068677510628272) }}, 
      {{ SC_(0.31e2), SC_(-0.637722015380859375e2), SC_(159817594923140342623291.20398499833703669395963482) }}, 
      {{ SC_(0.34e2), SC_(-0.177219114266335964202880859375e-2), SC_(-1.0644934780176950962560394681532225849773680058709e-138) }}, 
      {{ SC_(0.34e2), SC_(-0.22177286446094512939453125e-2), SC_(-1.7428976035917544129989302428497194913138579202666e-135) }}, 
      {{ SC_(0.34e2), SC_(-0.7444499991834163665771484375e-2), SC_(-3.9524579403269171803369385637558217271264775288375e-118) }}, 
      {{ SC_(0.34e2), SC_(-0.1433600485324859619140625e-1), SC_(-9.7369678001635573545503110129537132135591038708835e-109) }}, 
      {{ SC_(0.34e2), SC_(-0.1760916970670223236083984375e-1), SC_(-8.6233990620942755154548731208557667522524325271062e-106) }}, 
      {{ SC_(0.34e2), SC_(-0.6152711808681488037109375e-1), SC_(-7.3367515832609213979608708078032887331893716760878e-88) }}, 
      {{ SC_(0.34e2), SC_(-0.11958599090576171875e0), SC_(-2.4535309861100621118404676470270001610755173253095e-78) }}, 
      {{ SC_(0.34e2), SC_(-0.15262925624847412109375e0), SC_(-7.6987103226204474228299710459354001986872971425418e-75) }}, 
      {{ SC_(0.34e2), SC_(-0.408089816570281982421875e0), SC_(-9.5891796438704037962550024950686831416871263944065e-61) }}, 
      {{ SC_(0.34e2), SC_(-0.6540834903717041015625e0), SC_(-5.5410848148483629243991325407653364478861508321096e-54) }}, 
      {{ SC_(0.34e2), SC_(-0.1097540378570556640625e1), SC_(-1.4592416702058255678868869069288933084584122765773e-46) }}, 
      {{ SC_(0.34e2), SC_(-0.30944411754608154296875e1), SC_(-1.1141017553235972731179105495808947512528737037098e-31) }}, 
      {{ SC_(0.34e2), SC_(-0.51139926910400390625e1), SC_(-1.9999533014515442664410514640311352029537737796512e-24) }}, 
      {{ SC_(0.34e2), SC_(-0.95070552825927734375e1), SC_(-2.4868440390774050554114069080662971673947902623961e-15) }}, 
      {{ SC_(0.34e2), SC_(-0.24750102996826171875e2), SC_(-5.06656357626145066912681718080220258943729401784) }}, 
      {{ SC_(0.34e2), SC_(-0.637722015380859375e2), SC_(-37130522340900238142758.905822881447034320072942124) }}, 
      {{ SC_(0.37e2), SC_(-0.177219114266335964202880859375e-2), SC_(1.7287621278190839370590687031994130921705203027731e-152) }}, 
      {{ SC_(0.37e2), SC_(-0.22177286446094512939453125e-2), SC_(5.546993284567881066610530840898852183064493438262e-149) }}, 
      {{ SC_(0.37e2), SC_(-0.7444499991834163665771484375e-2), SC_(4.7581090814519782725042999839536478983860958645142e-130) }}, 
      {{ SC_(0.37e2), SC_(-0.1433600485324859619140625e-1), SC_(8.3708323995790324303958763893727680473342532914197e-120) }}, 
      {{ SC_(0.37e2), SC_(-0.1760916970670223236083984375e-1), SC_(1.3739014672168454406680073367182205099607148197632e-116) }}, 
      {{ SC_(0.37e2), SC_(-0.6152711808681488037109375e-1), SC_(4.9861237392471978055003726862508643829847162252575e-97) }}, 
      {{ SC_(0.37e2), SC_(-0.11958599090576171875e0), SC_(1.2243035655778619905636683889063047401519062606425e-86) }}, 
      {{ SC_(0.37e2), SC_(-0.15262925624847412109375e0), SC_(7.9870340394199891721115345149816582762740029243384e-83) }}, 
      {{ SC_(0.37e2), SC_(-0.408089816570281982421875e0), SC_(1.9013576951182169806853947255296139623785576186916e-67) }}, 
      {{ SC_(0.37e2), SC_(-0.6540834903717041015625e0), SC_(4.5231204964283367350579123529524644256173276796902e-60) }}, 
      {{ SC_(0.37e2), SC_(-0.1097540378570556640625e1), SC_(5.6249756162264798875230713047050389930739501783392e-52) }}, 
      {{ SC_(0.37e2), SC_(-0.30944411754608154296875e1), SC_(9.5747313181559510960653928485860835096410763339761e-36) }}, 
      {{ SC_(0.37e2), SC_(-0.51139926910400390625e1), SC_(7.67859806352689356386823578607221058376012844798e-28) }}, 
      {{ SC_(0.37e2), SC_(-0.95070552825927734375e1), SC_(5.9001858858606893937118814413721912920024394022728e-18) }}, 
      {{ SC_(0.37e2), SC_(-0.24750102996826171875e2), SC_(0.16182031803861277979226848786561421115178084390837) }}, 
      {{ SC_(0.37e2), SC_(-0.637722015380859375e2), SC_(7620156925871909004013.4511789819332608090859149484) }}, 
      {{ SC_(0.4e2), SC_(-0.177219114266335964202880859375e-2), SC_(-2.1934463145098982856482722894618772007386408955866e-166) }}, 
      {{ SC_(0.4e2), SC_(-0.22177286446094512939453125e-2), SC_(-1.3792498395120423934684486452597604404348707842772e-162) }}, 
      {{ SC_(0.4e2), SC_(-0.7444499991834163665771484375e-2), SC_(-4.4750827254189778755330436710326506163523889802085e-142) }}, 
      {{ SC_(0.4e2), SC_(-0.1433600485324859619140625e-1), SC_(-5.6222881809274427763875173260632408250704436858785e-131) }}, 
      {{ SC_(0.4e2), SC_(-0.1760916970670223236083984375e-1), SC_(-1.7101422547443159905114096833775090592290767321829e-127) }}, 
      {{ SC_(0.4e2), SC_(-0.6152711808681488037109375e-1), SC_(-2.6474147397607258550183244427472642118161245275487e-106) }}, 
      {{ SC_(0.4e2), SC_(-0.11958599090576171875e0), SC_(-4.7729492236342102509017782812387711881706287458449e-95) }}, 
      {{ SC_(0.4e2), SC_(-0.15262925624847412109375e0), SC_(-6.4737153699907991293058554021804873987255762728477e-91) }}, 
      {{ SC_(0.4e2), SC_(-0.408089816570281982421875e0), SC_(-2.9454570864564136977420322683387112229627476337539e-74) }}, 
      {{ SC_(0.4e2), SC_(-0.6540834903717041015625e0), SC_(-2.8846886509171748574863377735521386214202206755858e-66) }}, 
      {{ SC_(0.4e2), SC_(-0.1097540378570556640625e1), SC_(-1.6941972001909998208906812347963350453047191654302e-57) }}, 
      {{ SC_(0.4e2), SC_(-0.30944411754608154296875e1), SC_(-6.4346689071340193649227713397841966987433720786189e-40) }}, 
      {{ SC_(0.4e2), SC_(-0.51139926910400390625e1), SC_(-2.3089841179919606378679849343539819497749439614471e-31) }}, 
      {{ SC_(0.4e2), SC_(-0.95070552825927734375e1), SC_(-1.102736347295864305334545583894581762444979228683e-20) }}, 
      {{ SC_(0.4e2), SC_(-0.24750102996826171875e2), SC_(-0.0042179636760203964867503418195156015892913194089181) }}, 
      {{ SC_(0.4e2), SC_(-0.637722015380859375e2), SC_(-1384718401734132335251.2307161144249865361826025353) }}, 
      {{ SC_(0.43e2), SC_(-0.177219114266335964202880859375e-2), SC_(2.2155194558806744336118853845894526377597755033613e-180) }}, 
      {{ SC_(0.43e2), SC_(-0.22177286446094512939453125e-2), SC_(2.7301407262855693718808358405067536530151961222709e-176) }}, 
      {{ SC_(0.43e2), SC_(-0.7444499991834163665771484375e-2), SC_(3.3506150347288365485455030173519989511162460227522e-154) }}, 
      {{ SC_(0.43e2), SC_(-0.1433600485324859619140625e-1), SC_(3.0061756609377494048964736743144427129003213203223e-142) }}, 
      {{ SC_(0.43e2), SC_(-0.1760916970670223236083984375e-1), SC_(1.6945940912316967428473837149944892562616754985489e-138) }}, 
      {{ SC_(0.43e2), SC_(-0.6152711808681488037109375e-1), SC_(1.1190199437049647148982314787349308670836083412719e-115) }}, 
      {{ SC_(0.43e2), SC_(-0.11958599090576171875e0), SC_(1.4812957404734739372437378368931490462014921889916e-103) }}, 
      {{ SC_(0.43e2), SC_(-0.15262925624847412109375e0), SC_(4.1771418376583419694971373044913302025322339896609e-99) }}, 
      {{ SC_(0.43e2), SC_(-0.408089816570281982421875e0), SC_(3.6324851051777819272129739809658943871874407487028e-81) }}, 
      {{ SC_(0.43e2), SC_(-0.6540834903717041015625e0), SC_(1.4646390194930429146922835980901944721928096243995e-72) }}, 
      {{ SC_(0.43e2), SC_(-0.1097540378570556640625e1), SC_(4.0625964334686726052275084650431825087265178224124e-63) }}, 
      {{ SC_(0.43e2), SC_(-0.30944411754608154296875e1), SC_(3.445055402147930375877257131921015119606512508245e-44) }}, 
      {{ SC_(0.43e2), SC_(-0.51139926910400390625e1), SC_(5.5381687600583444906926687040881418784943267264745e-35) }}, 
      {{ SC_(0.43e2), SC_(-0.95070552825927734375e1), SC_(1.6515029191453376830894919269624334980950396009178e-23) }}, 
      {{ SC_(0.43e2), SC_(-0.24750102996826171875e2), SC_(9.07033473684436819050490950252432930934152092096e-05) }}, 
      {{ SC_(0.43e2), SC_(-0.637722015380859375e2), SC_(223349833220390199450.27662394978391334765490925711) }}, 
      {{ SC_(0.46e2), SC_(-0.177219114266335964202880859375e-2), SC_(-1.8104378462921870510073243689353670043465780417572e-194) }}, 
      {{ SC_(0.46e2), SC_(-0.22177286446094512939453125e-2), SC_(-4.3720650768675253652563392243562531036087038645837e-190) }}, 
      {{ SC_(0.46e2), SC_(-0.7444499991834163665771484375e-2), SC_(-2.0295861561067542761383038303516665614408092929621e-166) }}, 
      {{ SC_(0.46e2), SC_(-0.1433600485324859619140625e-1), SC_(-1.3003944406199447796291213829678693617876885669235e-153) }}, 
      {{ SC_(0.46e2), SC_(-0.1760916970670223236083984375e-1), SC_(-1.358496858602096893203295098466102421151497813062e-149) }}, 
      {{ SC_(0.46e2), SC_(-0.6152711808681488037109375e-1), SC_(-3.8266017294469036713813054977133414550613357620995e-125) }}, 
      {{ SC_(0.46e2), SC_(-0.11958599090576171875e0), SC_(-3.7192605471161617718716878121485601007325143417766e-112) }}, 
      {{ SC_(0.46e2), SC_(-0.15262925624847412109375e0), SC_(-2.1805444805077346331288545875784651786026586254492e-107) }}, 
      {{ SC_(0.46e2), SC_(-0.408089816570281982421875e0), SC_(-3.6242559912380282003067476102750491997093042839905e-88) }}, 
      {{ SC_(0.46e2), SC_(-0.6540834903717041015625e0), SC_(-6.0163489655614054743164061525225632154707225487227e-79) }}, 
      {{ SC_(0.46e2), SC_(-0.1097540378570556640625e1), SC_(-7.8819672414759206147861166344933846001601735395384e-69) }}, 
      {{ SC_(0.46e2), SC_(-0.30944411754608154296875e1), SC_(-1.4930590833870162213775836764629326071792693829531e-48) }}, 
      {{ SC_(0.46e2), SC_(-0.51139926910400390625e1), SC_(-1.0763470713262935904456505724516010574972799879661e-38) }}, 
      {{ SC_(0.46e2), SC_(-0.95070552825927734375e1), SC_(-2.0115846220319402838816743576250278175262193057597e-26) }}, 
      {{ SC_(0.46e2), SC_(-0.24750102996826171875e2), SC_(-1.6252200145822910970533586273353022511176623102534e-06) }}, 
      {{ SC_(0.46e2), SC_(-0.637722015380859375e2), SC_(-32056296975334433492.887437331135099409690999530645) }}, 
      {{ SC_(0.49e2), SC_(-0.177219114266335964202880859375e-2), SC_(1.2137476169035449224165111313052760780577498154495e-208) }}, 
      {{ SC_(0.49e2), SC_(-0.22177286446094512939453125e-2), SC_(5.744138736848391561405561566827001406807628730672e-204) }}, 
      {{ SC_(0.49e2), SC_(-0.7444499991834163665771484375e-2), SC_(1.0086190601725809485592749250036950039156412980801e-178) }}, 
      {{ SC_(0.49e2), SC_(-0.1433600485324859619140625e-1), SC_(4.6150092654244014484753439347715293478138962384071e-165) }}, 
      {{ SC_(0.49e2), SC_(-0.1760916970670223236083984375e-1), SC_(8.9348715778263801065552292828264974327479981243026e-161) }}, 
      {{ SC_(0.49e2), SC_(-0.6152711808681488037109375e-1), SC_(1.073557969060502670244818681362437101258532544188e-134) }}, 
      {{ SC_(0.49e2), SC_(-0.11958599090576171875e0), SC_(7.6614056528546695457433049939650076449807425863572e-121) }}, 
      {{ SC_(0.49e2), SC_(-0.15262925624847412109375e0), SC_(9.3387316510569269729588388217209165125692830551503e-116) }}, 
      {{ SC_(0.49e2), SC_(-0.408089816570281982421875e0), SC_(2.9667037180399959712795194068438806052231435377161e-95) }}, 
      {{ SC_(0.49e2), SC_(-0.6540834903717041015625e0), SC_(2.027595514156380296893790154872960085404285710906e-85) }}, 
      {{ SC_(0.49e2), SC_(-0.1097540378570556640625e1), SC_(1.254665875782490153416445484836172524618855505355e-74) }}, 
      {{ SC_(0.49e2), SC_(-0.30944411754608154296875e1), SC_(5.3112767401349998228922034188767491632135108874701e-53) }}, 
      {{ SC_(0.49e2), SC_(-0.51139926910400390625e1), SC_(1.7184230106399633928374634149552055310832862291052e-42) }}, 
      {{ SC_(0.49e2), SC_(-0.95070552825927734375e1), SC_(2.0188620523288691423046930654162370151184157582571e-29) }}, 
      {{ SC_(0.49e2), SC_(-0.24750102996826171875e2), SC_(2.4486900820026561561243390823793236131043274568681e-08) }}, 
      {{ SC_(0.49e2), SC_(-0.637722015380859375e2), SC_(4104203373731508351.8091124505391567563692298373867) }}, 
      {{ SC_(0.52e2), SC_(-0.177219114266335964202880859375e-2), SC_(-6.7582433736913603419058059256135791361735470637909e-223) }}, 
      {{ SC_(0.52e2), SC_(-0.22177286446094512939453125e-2), SC_(-6.2679264331526494370328882789831359414684776971336e-218) }}, 
      {{ SC_(0.52e2), SC_(-0.7444499991834163665771484375e-2), SC_(-4.1630106067711993660903358738294501375369753249879e-191) }}, 
      {{ SC_(0.52e2), SC_(-0.1433600485324859619140625e-1), SC_(-1.3602875417470081410985454428401245372759992414993e-176) }}, 
      {{ SC_(0.52e2), SC_(-0.1760916970670223236083984375e-1), SC_(-4.8806612177325115813521165986700318378662496250041e-172) }}, 
      {{ SC_(0.52e2), SC_(-0.6152711808681488037109375e-1), SC_(-2.5014882661113533293597761965233330461237158797651e-144) }}, 
      {{ SC_(0.52e2), SC_(-0.11958599090576171875e0), SC_(-1.3107541196311674615336229789222782210248645345988e-129) }}, 
      {{ SC_(0.52e2), SC_(-0.15262925624847412109375e0), SC_(-3.321788061274790179806750754248969443658942707425e-124) }}, 
      {{ SC_(0.52e2), SC_(-0.408089816570281982421875e0), SC_(-2.0169405302622672394567009913765725797440815303228e-102) }}, 
      {{ SC_(0.52e2), SC_(-0.6540834903717041015625e0), SC_(-5.6754178832405837953514458701036195191657065470066e-92) }}, 
      {{ SC_(0.52e2), SC_(-0.1097540378570556640625e1), SC_(-1.6588360861872987132698768619041215273305353601283e-80) }}, 
      {{ SC_(0.52e2), SC_(-0.30944411754608154296875e1), SC_(-1.5698207694417899021446502648229999500768660780745e-57) }}, 
      {{ SC_(0.52e2), SC_(-0.51139926910400390625e1), SC_(-2.2810052462334100092981477624289897510531514533963e-46) }}, 
      {{ SC_(0.52e2), SC_(-0.95070552825927734375e1), SC_(-1.6888264677784034501755356452466192541124575722402e-32) }}, 
      {{ SC_(0.52e2), SC_(-0.24750102996826171875e2), SC_(-3.1284554770212266533654823889614535495011507388997e-10) }}, 
      {{ SC_(0.52e2), SC_(-0.637722015380859375e2), SC_(-469912526052398293.17302112716282663456985359455793) }}, 
      {{ SC_(0.55e2), SC_(-0.177219114266335964202880859375e-2), SC_(3.1593849990997961977974943812146816685612063609753e-237) }}, 
      {{ SC_(0.55e2), SC_(-0.22177286446094512939453125e-2), SC_(5.7423035662670156701155774883438821586276792733737e-232) }}, 
      {{ SC_(0.55e2), SC_(-0.7444499991834163665771484375e-2), SC_(1.4426173536899176398539280108006290466380469104659e-203) }}, 
      {{ SC_(0.55e2), SC_(-0.1433600485324859619140625e-1), SC_(3.3662948625298628408893789499302767949884611521748e-188) }}, 
      {{ SC_(0.55e2), SC_(-0.1760916970670223236083984375e-1), SC_(2.2383721988438966126895088423110749261179727739443e-183) }}, 
      {{ SC_(0.55e2), SC_(-0.6152711808681488037109375e-1), SC_(4.8936711651864414231989567585154845915532624571577e-154) }}, 
      {{ SC_(0.55e2), SC_(-0.11958599090576171875e0), SC_(1.8827710109688701937429883606767323358888834986806e-138) }}, 
      {{ SC_(0.55e2), SC_(-0.15262925624847412109375e0), SC_(9.9201804930062867946547900039207204930607095294563e-133) }}, 
      {{ SC_(0.55e2), SC_(-0.408089816570281982421875e0), SC_(1.1512714886725383721018856342861659745765144062983e-109) }}, 
      {{ SC_(0.55e2), SC_(-0.6540834903717041015625e0), SC_(1.3337792351351849232556965484782506374204938471942e-98) }}, 
      {{ SC_(0.55e2), SC_(-0.1097540378570556640625e1), SC_(1.8414497718532141402443858594087036395047321320979e-86) }}, 
      {{ SC_(0.55e2), SC_(-0.30944411754608154296875e1), SC_(3.8967726654446097204350019896316737688338122273432e-62) }}, 
      {{ SC_(0.55e2), SC_(-0.51139926910400390625e1), SC_(2.5442972422456580268434830211595319738276544262809e-50) }}, 
      {{ SC_(0.55e2), SC_(-0.95070552825927734375e1), SC_(1.1896599721367974831559089457000349605850672303126e-35) }}, 
      {{ SC_(0.55e2), SC_(-0.24750102996826171875e2), SC_(3.4154599781777805873676342450915281728506074263741e-12) }}, 
      {{ SC_(0.55e2), SC_(-0.637722015380859375e2), SC_(48234457604444740.335143147971511893573254691716282) }}, 
      {{ SC_(0.58e2), SC_(-0.177219114266335964202880859375e-2), SC_(-1.2520413645388569928887958112848204212138063461708e-251) }}, 
      {{ SC_(0.58e2), SC_(-0.22177286446094512939453125e-2), SC_(-4.4595989634686150568429251044625228423529401458671e-246) }}, 
      {{ SC_(0.58e2), SC_(-0.7444499991834163665771484375e-2), SC_(-4.2378168989917621180007953130186366290981620423231e-216) }}, 
      {{ SC_(0.58e2), SC_(-0.1433600485324859619140625e-1), SC_(-7.0618906988802236107307134052564237747614610667347e-200) }}, 
      {{ SC_(0.58e2), SC_(-0.1760916970670223236083984375e-1), SC_(-8.702285916071814227807807229418309354595552484574e-195) }}, 
      {{ SC_(0.58e2), SC_(-0.6152711808681488037109375e-1), SC_(-8.1155609568253125349091276265266629388793969141888e-164) }}, 
      {{ SC_(0.58e2), SC_(-0.11958599090576171875e0), SC_(-2.2925633886147348167887929308708443895271449574002e-147) }}, 
      {{ SC_(0.58e2), SC_(-0.15262925624847412109375e0), SC_(-2.5113943794105648062440017015132938005891936086402e-141) }}, 
      {{ SC_(0.58e2), SC_(-0.408089816570281982421875e0), SC_(-5.5707269509534084668880316016301521365616605779226e-117) }}, 
      {{ SC_(0.58e2), SC_(-0.6540834903717041015625e0), SC_(-2.657190957474252490339745093174279959587302920337e-105) }}, 
      {{ SC_(0.58e2), SC_(-0.1097540378570556640625e1), SC_(-1.7329204095864388145245624373544625363852920610294e-92) }}, 
      {{ SC_(0.58e2), SC_(-0.30944411754608154296875e1), SC_(-8.2021165289716639245472391886116444446565644799576e-67) }}, 
      {{ SC_(0.58e2), SC_(-0.51139926910400390625e1), SC_(-2.4075702286581099190297646954055364849049383370423e-54) }}, 
      {{ SC_(0.58e2), SC_(-0.95070552825927734375e1), SC_(-7.1220189825823412856021938995136401566994991595578e-39) }}, 
      {{ SC_(0.58e2), SC_(-0.24750102996826171875e2), SC_(-3.2090378383167806078759489925206593790671983259232e-14) }}, 
      {{ SC_(0.58e2), SC_(-0.637722015380859375e2), SC_(-4449584424751920.8125944951606147809737782831249622) }}, 
      {{ SC_(0.61e2), SC_(-0.177219114266335964202880859375e-2), SC_(4.2425710020331914252821718283968275084437170049519e-266) }}, 
      {{ SC_(0.61e2), SC_(-0.22177286446094512939453125e-2), SC_(2.9614184695203394581083532929114208408300940116942e-260) }}, 
      {{ SC_(0.61e2), SC_(-0.7444499991834163665771484375e-2), SC_(1.0644555775598225924016923665182010252785388717882e-228) }}, 
      {{ SC_(0.61e2), SC_(-0.1433600485324859619140625e-1), SC_(1.2667302662084979337826570205994629760575270558421e-211) }}, 
      {{ SC_(0.61e2), SC_(-0.1760916970670223236083984375e-1), SC_(2.8928686352184495808714058731442370301152120952584e-206) }}, 
      {{ SC_(0.61e2), SC_(-0.6152711808681488037109375e-1), SC_(1.1507915428192169017964403554298572567426260297269e-173) }}, 
      {{ SC_(0.61e2), SC_(-0.11958599090576171875e0), SC_(2.3869299277328255154517154042855638918319843712064e-156) }}, 
      {{ SC_(0.61e2), SC_(-0.15262925624847412109375e0), SC_(5.4363176381398824179797926296956081316400445904413e-150) }}, 
      {{ SC_(0.61e2), SC_(-0.408089816570281982421875e0), SC_(2.304846819977282184080434493418762646459057636491e-124) }}, 
      {{ SC_(0.61e2), SC_(-0.6540834903717041015625e0), SC_(4.5264779375838098725800226481107380276899609082274e-112) }}, 
      {{ SC_(0.61e2), SC_(-0.1097540378570556640625e1), SC_(1.394454579586264814875228803591527867526457487378e-98) }}, 
      {{ SC_(0.61e2), SC_(-0.30944411754608154296875e1), SC_(1.4765286399092230040791741547510647367576508020078e-71) }}, 
      {{ SC_(0.61e2), SC_(-0.51139926910400390625e1), SC_(1.9492095186618141817805891509498817574437792414524e-58) }}, 
      {{ SC_(0.61e2), SC_(-0.95070552825927734375e1), SC_(3.6535166424498974327222404091018181991713133997357e-42) }}, 
      {{ SC_(0.61e2), SC_(-0.24750102996826171875e2), SC_(2.6118649550402288054398306933496441568963183554462e-16) }}, 
      {{ SC_(0.61e2), SC_(-0.637722015380859375e2), SC_(369792726054441.26944059981155583095952179135366203) }}, 
      {{ SC_(0.64e2), SC_(-0.177219114266335964202880859375e-2), SC_(-1.2388215254263042046658811407264068831944639577887e-280) }}, 
      {{ SC_(0.64e2), SC_(-0.22177286446094512939453125e-2), SC_(-1.6946223779377366322214570359963237180694346302933e-274) }}, 
      {{ SC_(0.64e2), SC_(-0.7444499991834163665771484375e-2), SC_(-2.3039978927625714612754208135610671784320013072718e-241) }}, 
      {{ SC_(0.64e2), SC_(-0.1433600485324859619140625e-1), SC_(-1.9580171289330104594320265640969941604408912539339e-223) }}, 
      {{ SC_(0.64e2), SC_(-0.1760916970670223236083984375e-1), SC_(-8.2869222089767530366964301609205640263233926997991e-218) }}, 
      {{ SC_(0.64e2), SC_(-0.6152711808681488037109375e-1), SC_(-1.4061899668280737770929553194231885629327969496772e-183) }}, 
      {{ SC_(0.64e2), SC_(-0.11958599090576171875e0), SC_(-2.1415454598728861932080547695071679847395256848646e-165) }}, 
      {{ SC_(0.64e2), SC_(-0.15262925624847412109375e0), SC_(-1.0140610986099354939720650920341316744599074527865e-158) }}, 
      {{ SC_(0.64e2), SC_(-0.408089816570281982421875e0), SC_(-8.2175612618247530833632942052734480423446402337471e-132) }}, 
      {{ SC_(0.64e2), SC_(-0.6540834903717041015625e0), SC_(-6.644634547471484880791466057684730813837330292183e-119) }}, 
      {{ SC_(0.64e2), SC_(-0.1097540378570556640625e1), SC_(-9.6696376607232609042276705446491638405663890260955e-105) }}, 
      {{ SC_(0.64e2), SC_(-0.30944411754608154296875e1), SC_(-2.2909383826664629344212826375049004437270655767509e-76) }}, 
      {{ SC_(0.64e2), SC_(-0.51139926910400390625e1), SC_(-1.3606375299804661100856453043111750946073025084922e-62) }}, 
      {{ SC_(0.64e2), SC_(-0.95070552825927734375e1), SC_(-1.6180433668923993064382449435665897851233631058371e-45) }}, 
      {{ SC_(0.64e2), SC_(-0.24750102996826171875e2), SC_(-1.8526974585711814390179423187480033162454423293619e-18) }}, 
      {{ SC_(0.64e2), SC_(-0.637722015380859375e2), SC_(-27753113149542.319960176525351078723832287820547493) }}, 
      {{ SC_(0.67e2), SC_(-0.177219114266335964202880859375e-2), SC_(3.1391579949641315570429785335251785779472340952396e-295) }}, 
      {{ SC_(0.67e2), SC_(-0.22177286446094512939453125e-2), SC_(8.4153251602910179456365817555428171807809518688995e-289) }}, 
      {{ SC_(0.67e2), SC_(-0.7444499991834163665771484375e-2), SC_(4.3277425893419072609128204122623810704245409423407e-254) }}, 
      {{ SC_(0.67e2), SC_(-0.1433600485324859619140625e-1), SC_(2.6264772024499850109130857465955655576422239032293e-235) }}, 
      {{ SC_(0.67e2), SC_(-0.1760916970670223236083984375e-1), SC_(2.0600730537734909016515261785532438510975012855129e-229) }}, 
      {{ SC_(0.67e2), SC_(-0.6152711808681488037109375e-1), SC_(1.4911322583614259693979664878250519196585835218334e-193) }}, 
      {{ SC_(0.67e2), SC_(-0.11958599090576171875e0), SC_(1.6674001854529428038637462621355919009987100139771e-174) }}, 
      {{ SC_(0.67e2), SC_(-0.15262925624847412109375e0), SC_(1.6415284380093694762051254707233017592566535189797e-167) }}, 
      {{ SC_(0.67e2), SC_(-0.408089816570281982421875e0), SC_(2.5425525749591888960496273354363910266310540776057e-139) }}, 
      {{ SC_(0.67e2), SC_(-0.6540834903717041015625e0), SC_(8.4646682425793074323920353901914134714572584083322e-126) }}, 
      {{ SC_(0.67e2), SC_(-0.1097540378570556640625e1), SC_(5.8190252763780625217344009150147801436271833123923e-111) }}, 
      {{ SC_(0.67e2), SC_(-0.30944411754608154296875e1), SC_(3.0852077415388690855886325107096863249917033942949e-81) }}, 
      {{ SC_(0.67e2), SC_(-0.51139926910400390625e1), SC_(8.2462111027747296965681108576161141617822209913075e-67) }}, 
      {{ SC_(0.67e2), SC_(-0.95070552825927734375e1), SC_(6.2285651920123373313610961040377593081523421620429e-49) }}, 
      {{ SC_(0.67e2), SC_(-0.24750102996826171875e2), SC_(1.1517779224277461415676244801629515542988750835375e-20) }}, 
      {{ SC_(0.67e2), SC_(-0.637722015380859375e2), SC_(1885370641257.1827204796598740013286146728943092018) }}, 
      {{ SC_(0.7e2), SC_(-0.177219114266335964202880859375e-2), SC_(-6.9473961878707575158600210597440403366919272660158e-310) }}, 
      {{ SC_(0.7e2), SC_(-0.7444499991834163665771484375e-2), SC_(-7.0997854620701933448207860785327496840617296058248e-267) }}, 
      {{ SC_(0.7e2), SC_(-0.1433600485324859619140625e-1), SC_(-3.0770549060187263202686051152703950291929132300009e-247) }}, 
      {{ SC_(0.7e2), SC_(-0.1760916970670223236083984375e-1), SC_(-4.4727687301545682185419970522402590443925802186037e-241) }}, 
      {{ SC_(0.7e2), SC_(-0.6152711808681488037109375e-1), SC_(-1.38099727631585453821424328210265554521889576794e-203) }}, 
      {{ SC_(0.7e2), SC_(-0.11958599090576171875e0), SC_(-1.1338535137583496021114388849056277318334203998478e-183) }}, 
      {{ SC_(0.7e2), SC_(-0.15262925624847412109375e0), SC_(-2.3207978713078011352593728014212904279302244216489e-176) }}, 
      {{ SC_(0.7e2), SC_(-0.408089816570281982421875e0), SC_(-6.8707243490708476481738782345605125804860468763652e-147) }}, 
      {{ SC_(0.7e2), SC_(-0.6540834903717041015625e0), SC_(-9.4179449916360381129438016958300605326351814425029e-133) }}, 
      {{ SC_(0.7e2), SC_(-0.1097540378570556640625e1), SC_(-3.058460877037596390669567494169930309974687355767e-117) }}, 
      {{ SC_(0.7e2), SC_(-0.30944411754608154296875e1), SC_(-3.6293163655119455138709489938300238971715047471255e-86) }}, 
      {{ SC_(0.7e2), SC_(-0.51139926910400390625e1), SC_(-4.3666440561259071006305673721113793993049308903697e-71) }}, 
      {{ SC_(0.7e2), SC_(-0.95070552825927734375e1), SC_(-2.0969827693288095828633768469004433740064673456557e-52) }}, 
      {{ SC_(0.7e2), SC_(-0.24750102996826171875e2), SC_(-6.3081171041477797378349146657536728814518874279765e-23) }}, 
      {{ SC_(0.7e2), SC_(-0.637722015380859375e2), SC_(-116200587705.9972033212971866848583486865390099783) }}, 
      {{ SC_(0.73e2), SC_(-0.177219114266335964202880859375e-2), SC_(1.3507496963190848811812605035755276822306783013008e-324) }}, 
      {{ SC_(0.73e2), SC_(-0.22177286446094512939453125e-2), SC_(1.3906558628240210167410406322926273217138498155297e-317) }}, 
      {{ SC_(0.73e2), SC_(-0.7444499991834163665771484375e-2), SC_(1.0232292612643929164393555734712076107963466015419e-279) }}, 
      {{ SC_(0.73e2), SC_(-0.1433600485324859619140625e-1), SC_(3.1669468744744228128871438059384274750920481170588e-259) }}, 
      {{ SC_(0.73e2), SC_(-0.1760916970670223236083984375e-1), SC_(8.5312798332901951159689132307158391752594168130046e-253) }}, 
      {{ SC_(0.73e2), SC_(-0.6152711808681488037109375e-1), SC_(1.1236043760547774550840777773292804117368603963381e-213) }}, 
      {{ SC_(0.73e2), SC_(-0.11958599090576171875e0), SC_(6.773576827937433880701869360263370808791766081818e-193) }}, 
      {{ SC_(0.73e2), SC_(-0.15262925624847412109375e0), SC_(2.8825064217746425597303617323233603741034850031809e-185) }}, 
      {{ SC_(0.73e2), SC_(-0.408089816570281982421875e0), SC_(1.6310978659437693190299774851696549575048944847774e-154) }}, 
      {{ SC_(0.73e2), SC_(-0.6540834903717041015625e0), SC_(9.2055305236266895105402372198275994943403004085982e-140) }}, 
      {{ SC_(0.73e2), SC_(-0.1097540378570556640625e1), SC_(1.4122341130484579348120664306328290171004071749639e-123) }}, 
      {{ SC_(0.73e2), SC_(-0.30944411754608154296875e1), SC_(3.7511636793232867462931323998211418887996843788832e-91) }}, 
      {{ SC_(0.73e2), SC_(-0.51139926910400390625e1), SC_(2.0320758792487700817910271861967809334924888836874e-75) }}, 
      {{ SC_(0.73e2), SC_(-0.95070552825927734375e1), SC_(6.2097685364004522844908379887813700451507749938078e-56) }}, 
      {{ SC_(0.73e2), SC_(-0.24750102996826171875e2), SC_(3.0584007614905224150486889015635217620856903402764e-25) }}, 
      {{ SC_(0.73e2), SC_(-0.637722015380859375e2), SC_(6512044119.7702057066658291352087070348263357228093) }}, 
      {{ SC_(0.76e2), SC_(-0.177219114266335964202880859375e-2), SC_(-2.3195339478133814054007492392224202349931276855473e-339) }}, 
      {{ SC_(0.76e2), SC_(-0.22177286446094512939453125e-2), SC_(-4.6799267801180082535015118083610105786567490647111e-332) }}, 
      {{ SC_(0.76e2), SC_(-0.7444499991834163665771484375e-2), SC_(-1.302487964423846871761170667875260709588948583303e-292) }}, 
      {{ SC_(0.76e2), SC_(-0.1433600485324859619140625e-1), SC_(-2.8788520988405523410234474831788210360652724346618e-271) }}, 
      {{ SC_(0.76e2), SC_(-0.1760916970670223236083984375e-1), SC_(-1.4372257027590942365638884742058014425484218169965e-264) }}, 
      {{ SC_(0.76e2), SC_(-0.6152711808681488037109375e-1), SC_(-8.0743409403950639843494092057130732296951054158363e-224) }}, 
      {{ SC_(0.76e2), SC_(-0.11958599090576171875e0), SC_(-3.5739814054216253005793493470952029267539287015973e-202) }}, 
      {{ SC_(0.76e2), SC_(-0.15262925624847412109375e0), SC_(-3.1621059211308472966030568819860933756230005522119e-194) }}, 
      {{ SC_(0.76e2), SC_(-0.408089816570281982421875e0), SC_(-3.4200419048105661428016795544405914835338349409359e-162) }}, 
      {{ SC_(0.76e2), SC_(-0.6540834903717041015625e0), SC_(-7.9472481910706086097506541561280938718583919474349e-147) }}, 
      {{ SC_(0.76e2), SC_(-0.1097540378570556640625e1), SC_(-5.7595666922124447046430787468026384041534535625797e-130) }}, 
      {{ SC_(0.76e2), SC_(-0.30944411754608154296875e1), SC_(-3.4247611609219922313466541280690329008558200182914e-96) }}, 
      {{ SC_(0.76e2), SC_(-0.51139926910400390625e1), SC_(-8.3549036111460052656699367013939841144814107156374e-80) }}, 
      {{ SC_(0.76e2), SC_(-0.95070552825927734375e1), SC_(-1.6259075460259942049178264036277075443223749204689e-59) }}, 
      {{ SC_(0.76e2), SC_(-0.24750102996826171875e2), SC_(-1.318576118552021545104435738323048727864154201574e-27) }}, 
      {{ SC_(0.76e2), SC_(-0.637722015380859375e2), SC_(-332559623.8985721331192076011185438876913669207339) }}, 
      {{ SC_(0.79e2), SC_(-0.177219114266335964202880859375e-2), SC_(3.5354403212019364046063104755631828771883937058006e-354) }}, 
      {{ SC_(0.79e2), SC_(-0.22177286446094512939453125e-2), SC_(1.3978976306615431583515397352566586129978164981083e-346) }}, 
      {{ SC_(0.79e2), SC_(-0.7444499991834163665771484375e-2), SC_(1.4716055261727348172790592652718757218968491250897e-305) }}, 
      {{ SC_(0.79e2), SC_(-0.1433600485324859619140625e-1), SC_(2.3228162360620189257436933252556231587350476505745e-283) }}, 
      {{ SC_(0.79e2), SC_(-0.1760916970670223236083984375e-1), SC_(2.1490805210942587181886096768253317000272047900881e-276) }}, 
      {{ SC_(0.79e2), SC_(-0.6152711808681488037109375e-1), SC_(5.1501240022553382313931109927252352647508033725137e-234) }}, 
      {{ SC_(0.79e2), SC_(-0.11958599090576171875e0), SC_(1.6737997765406598434264054525564444084850592554407e-211) }}, 
      {{ SC_(0.79e2), SC_(-0.15262925624847412109375e0), SC_(3.0789282916516690174719881434864575044336286368998e-203) }}, 
      {{ SC_(0.79e2), SC_(-0.408089816570281982421875e0), SC_(6.36503109275278961131724617973150670884809100085e-170) }}, 
      {{ SC_(0.79e2), SC_(-0.6540834903717041015625e0), SC_(6.0898084719470202787549713824635043238285438147712e-154) }}, 
      {{ SC_(0.79e2), SC_(-0.1097540378570556640625e1), SC_(2.0849489482470412059259293955112926383959218775221e-136) }}, 
      {{ SC_(0.79e2), SC_(-0.30944411754608154296875e1), SC_(2.7755929193923341619599366432165290745895361503068e-101) }}, 
      {{ SC_(0.79e2), SC_(-0.51139926910400390625e1), SC_(3.0498646489259068012138998537230278724083029378205e-84) }}, 
      {{ SC_(0.79e2), SC_(-0.95070552825927734375e1), SC_(3.7822190240734211344697436228310459325646325013602e-63) }}, 
      {{ SC_(0.79e2), SC_(-0.24750102996826171875e2), SC_(5.0763751887669428908160377413843070315272619394593e-30) }}, 
      {{ SC_(0.79e2), SC_(-0.637722015380859375e2), SC_(15509034.088708430442808142776840096102763256428376) }}, 
      {{ SC_(0.82e2), SC_(-0.177219114266335964202880859375e-2), SC_(-4.8048862563202889181890537443326779885545248610242e-369) }}, 
      {{ SC_(0.82e2), SC_(-0.22177286446094512939453125e-2), SC_(-3.7231325849660746143336380063851346168130573371484e-361) }}, 
      {{ SC_(0.82e2), SC_(-0.7444499991834163665771484375e-2), SC_(-1.4825383087772703677121933113230100416009283671034e-318) }}, 
      {{ SC_(0.82e2), SC_(-0.1433600485324859619140625e-1), SC_(-1.6711182277052575836893718534668728582756108648312e-295) }}, 
      {{ SC_(0.82e2), SC_(-0.1760916970670223236083984375e-1), SC_(-2.8653470065901442471349796594633948569490121927789e-288) }}, 
      {{ SC_(0.82e2), SC_(-0.6152711808681488037109375e-1), SC_(-2.9290388140539613063288304116939069775353632716894e-244) }}, 
      {{ SC_(0.82e2), SC_(-0.11958599090576171875e0), SC_(-6.989588437838497498633490694257384354295169533204e-221) }}, 
      {{ SC_(0.82e2), SC_(-0.15262925624847412109375e0), SC_(-2.6731273786128594995441372203649359993461979500185e-212) }}, 
      {{ SC_(0.82e2), SC_(-0.408089816570281982421875e0), SC_(-1.0562510171246344218084352488817570605950194519393e-177) }}, 
      {{ SC_(0.82e2), SC_(-0.6540834903717041015625e0), SC_(-4.1609172226269596757660908595807745867150206089336e-161) }}, 
      {{ SC_(0.82e2), SC_(-0.1097540378570556640625e1), SC_(-6.7298102679330724106181833447827647907096714047206e-143) }}, 
      {{ SC_(0.82e2), SC_(-0.30944411754608154296875e1), SC_(-2.0059377323087951081667274371186273644145227822575e-106) }}, 
      {{ SC_(0.82e2), SC_(-0.51139926910400390625e1), SC_(-9.9294186782645320133623704220686212337084869523935e-89) }}, 
      {{ SC_(0.82e2), SC_(-0.95070552825927734375e1), SC_(-7.8516737724524765361257804357393329459841050420731e-67) }}, 
      {{ SC_(0.82e2), SC_(-0.24750102996826171875e2), SC_(-1.7520334090734988621562311121564391919297578081493e-32) }}, 
      {{ SC_(0.82e2), SC_(-0.637722015380859375e2), SC_(-661845.41868057886844507495847825147949109845357718) }}, 
      {{ SC_(0.85e2), SC_(-0.177219114266335964202880859375e-2), SC_(5.8472757925281335709441070120916109604930024452409e-384) }}, 
      {{ SC_(0.85e2), SC_(-0.22177286446094512939453125e-2), SC_(8.8791726773414850912512854292238871639394376398273e-376) }}, 
      {{ SC_(0.85e2), SC_(-0.7444499991834163665771484375e-2), SC_(1.3373691635430932409867433733092264367846631443699e-331) }}, 
      {{ SC_(0.85e2), SC_(-0.1433600485324859619140625e-1), SC_(1.0765404847203446320910822788131070879964149338772e-307) }}, 
      {{ SC_(0.85e2), SC_(-0.1760916970670223236083984375e-1), SC_(3.420838952015165818158018000931089841366043146575e-300) }}, 
      {{ SC_(0.85e2), SC_(-0.6152711808681488037109375e-1), SC_(1.4916380317089088216843268489867077713269951388358e-254) }}, 
      {{ SC_(0.85e2), SC_(-0.11958599090576171875e0), SC_(2.6135488501491766407431161565237945419126408844675e-230) }}, 
      {{ SC_(0.85e2), SC_(-0.15262925624847412109375e0), SC_(2.0781203049030925463263429601388263138063177457416e-221) }}, 
      {{ SC_(0.85e2), SC_(-0.408089816570281982421875e0), SC_(1.5695141280427997758020218417755528490733613885247e-185) }}, 
      {{ SC_(0.85e2), SC_(-0.6540834903717041015625e0), SC_(2.5456984433230137894914413111361227522822484252069e-168) }}, 
      {{ SC_(0.85e2), SC_(-0.1097540378570556640625e1), SC_(1.9451160142029278734236728286821772378084338638687e-149) }}, 
      {{ SC_(0.85e2), SC_(-0.30944411754608154296875e1), SC_(1.2982106047581298813134523396297908278237157397917e-111) }}, 
      {{ SC_(0.85e2), SC_(-0.51139926910400390625e1), SC_(2.8953015092379672002808952081487566053733334541789e-93) }}, 
      {{ SC_(0.85e2), SC_(-0.95070552825927734375e1), SC_(1.4606208585387583821716999258644880230045971888375e-70) }}, 
      {{ SC_(0.85e2), SC_(-0.24750102996826171875e2), SC_(5.4408313801020912656180501212839264038981557151731e-35) }}, 
      {{ SC_(0.85e2), SC_(-0.637722015380859375e2), SC_(25897.152181004517269750138033637774774294027201157) }}, 
      {{ SC_(0.88e2), SC_(-0.177219114266335964202880859375e-2), SC_(-6.3967392280596030279323854433032980999361288193673e-399) }}, 
      {{ SC_(0.88e2), SC_(-0.22177286446094512939453125e-2), SC_(-1.9035798676765477375707106012504409197237459683134e-390) }}, 
      {{ SC_(0.88e2), SC_(-0.7444499991834163665771484375e-2), SC_(-1.0845043229696536816589939558806337747262693806117e-344) }}, 
      {{ SC_(0.88e2), SC_(-0.1433600485324859619140625e-1), SC_(-6.2343066307351531677125296908505917958463867368011e-320) }}, 
      {{ SC_(0.88e2), SC_(-0.1760916970670223236083984375e-1), SC_(-3.6713233393263255015318969376892728032966858934394e-312) }}, 
      {{ SC_(0.88e2), SC_(-0.6152711808681488037109375e-1), SC_(-6.8286740416097889483960253094161116355961137599911e-265) }}, 
      {{ SC_(0.88e2), SC_(-0.11958599090576171875e0), SC_(-8.7850510192292171781935576131152961424001837737372e-240) }}, 
      {{ SC_(0.88e2), SC_(-0.15262925624847412109375e0), SC_(-1.4523001945931213963724402582050155086750135868739e-230) }}, 
      {{ SC_(0.88e2), SC_(-0.408089816570281982421875e0), SC_(-2.0965173883428983962808243031008372953025094614022e-193) }}, 
      {{ SC_(0.88e2), SC_(-0.6540834903717041015625e0), SC_(-1.4001057827881787318362535742853637138047693417883e-175) }}, 
      {{ SC_(0.88e2), SC_(-0.1097540378570556640625e1), SC_(-5.0539014586103948417980337852169920633032949579937e-156) }}, 
      {{ SC_(0.88e2), SC_(-0.30944411754608154296875e1), SC_(-7.5533392148555117094876622598604796141439853510179e-117) }}, 
      {{ SC_(0.88e2), SC_(-0.51139926910400390625e1), SC_(-7.5907438126908222770882865866850381553729181510969e-98) }}, 
      {{ SC_(0.88e2), SC_(-0.95070552825927734375e1), SC_(-2.4442318532108741067843417039652114734958529194241e-74) }}, 
      {{ SC_(0.88e2), SC_(-0.24750102996826171875e2), SC_(-1.5255185376367196961330937653065804471587161182596e-37) }}, 
      {{ SC_(0.88e2), SC_(-0.637722015380859375e2), SC_(-930.9184838624792218675752167087125839937752968732) }},
      {{ SC_(-0.0), SC_(0.177219114266335964202880859375e-2), SC_(0.00088609591919750015203076551463481289812081759457593) }}, 
      {{ SC_(-0.0), SC_(0.22177286446094512939453125e-2), SC_(0.0011088650040236093434924259738776777082777117728366) }}, 
      {{ SC_(-0.0), SC_(0.7444499991834163665771484375e-2), SC_(0.003722275782133396649790935284938128705516556817227) }}, 
      {{ SC_(-0.0), SC_(0.1433600485324859619140625e-1), SC_(0.0071681865751110609746510378519051273111721075420681) }}, 
      {{ SC_(-0.0), SC_(0.1760916970670223236083984375e-1), SC_(0.008804926126614467969087386987026758424777681208949) }}, 
      {{ SC_(-0.0), SC_(0.6152711808681488037109375e-1), SC_(0.030778118603049061956303124312187349139104670901298) }}, 
      {{ SC_(-0.0), SC_(0.11958599090576171875e0), SC_(0.059899945189311456643393232325528632776126403440763) }}, 
      {{ SC_(-0.0), SC_(0.15262925624847412109375e0), SC_(0.076537069171312995155266637603161226785362168868793) }}, 
      {{ SC_(-0.0), SC_(0.408089816570281982421875e0), SC_(0.20832212130892514352270120184527358300711621253093) }}, 
      {{ SC_(-0.0), SC_(0.6540834903717041015625e0), SC_(0.34484589720660571203268712177657285280507611555709) }}, 
      {{ SC_(-0.0), SC_(0.1097540378570556640625e1), SC_(0.63565392939687165931975701385906830196228023376933) }}, 
      {{ SC_(-0.0), SC_(0.30944411754608154296875e1), SC_(4.304586767845429639244166020309162877221031947039) }}, 
      {{ SC_(-0.0), SC_(0.51139926910400390625e1), SC_(27.026310609828701503222843893102992533224960967973) }}, 
      {{ SC_(-0.0), SC_(0.95070552825927734375e1), SC_(1669.6303950934903244727446466214615294086023903195) }}, 
      {{ SC_(-0.0), SC_(0.24750102996826171875e2), SC_(4428295881.3677779786815636628866430364992082651157) }}, 
      {{ SC_(-0.0), SC_(0.637722015380859375e2), SC_(246567311915704274501887357.24020001512007921147054) }}, 
      {{ SC_(-0.1e1), SC_(0.177219114266335964202880859375e-2), SC_(0.50000058887414958452485804994744934952377336181573) }}, 
      {{ SC_(-0.1e1), SC_(0.22177286446094512939453125e-2), SC_(0.50000092218537893261448430232179397590419077630156) }}, 
      {{ SC_(-0.1e1), SC_(0.7444499991834163665771484375e-2), SC_(0.50001039139876686065339052546517335546246153291185) }}, 
      {{ SC_(-0.1e1), SC_(0.1433600485324859619140625e-1), SC_(0.50003853574407998926317310663333528092870153852384) }}, 
      {{ SC_(-0.1e1), SC_(0.1760916970670223236083984375e-1), SC_(0.50005814178781229442302267906313903386120382311391) }}, 
      {{ SC_(-0.1e1), SC_(0.6152711808681488037109375e-1), SC_(0.50070998404154571459128156447054892961460345184902) }}, 
      {{ SC_(-0.1e1), SC_(0.11958599090576171875e0), SC_(0.5026840657714710757890236690799629757305465005453) }}, 
      {{ SC_(-0.1e1), SC_(0.15262925624847412109375e0), SC_(0.50437501291751594265663420039241884122843561276152) }}, 
      {{ SC_(-0.1e1), SC_(0.408089816570281982421875e0), SC_(0.53158863081248487334362919459520848093354880736601) }}, 
      {{ SC_(-0.1e1), SC_(0.6540834903717041015625e0), SC_(0.58263043215568911299814886678184475770592474363462) }}, 
      {{ SC_(-0.1e1), SC_(0.1097540378570556640625e1), SC_(0.7454322330858457449159781361157891562659959168394) }}, 
      {{ SC_(-0.1e1), SC_(0.30944411754608154296875e1), SC_(3.8794322064706267194422881162259380140744641171029) }}, 
      {{ SC_(-0.1e1), SC_(0.51139926910400390625e1), SC_(24.879824200109264550070346070548572538675416510962) }}, 
      {{ SC_(-0.1e1), SC_(0.95070552825927734375e1), SC_(1589.6010892466270146562540500585578585568257598452) }}, 
      {{ SC_(-0.1e1), SC_(0.24750102996826171875e2), SC_(4341662415.1619366320979220433134729416481099471501) }}, 
      {{ SC_(-0.1e1), SC_(0.637722015380859375e2), SC_(244657223419722976962060156.64526989576384593438155) }}, 
      {{ SC_(-0.4e1), SC_(0.177219114266335964202880859375e-2), SC_(5.7977642791440240594069365123737373446875473336019e-11) }}, 
      {{ SC_(-0.4e1), SC_(0.22177286446094512939453125e-2), SC_(1.1361983257670755452088629287120813120498174641957e-10) }}, 
      {{ SC_(-0.4e1), SC_(0.7444499991834163665771484375e-2), SC_(4.2977106585064563071965155077470765547580422080236e-09) }}, 
      {{ SC_(-0.4e1), SC_(0.1433600485324859619140625e-1), SC_(3.0691624717963766687820586762992955366705538139243e-08) }}, 
      {{ SC_(-0.4e1), SC_(0.1760916970670223236083984375e-1), SC_(5.6879465129841838118217352628667866284796929079985e-08) }}, 
      {{ SC_(-0.4e1), SC_(0.6152711808681488037109375e-1), SC_(2.4268994701713292881629948960548331673657583324918e-06) }}, 
      {{ SC_(-0.4e1), SC_(0.11958599090576171875e0), SC_(1.7833452482002047243884933100474315698557783900753e-05) }}, 
      {{ SC_(-0.4e1), SC_(0.15262925624847412109375e0), SC_(3.7102292783677070216850017034917460055257223905384e-05) }}, 
      {{ SC_(-0.4e1), SC_(0.408089816570281982421875e0), SC_(0.00071682270806809984142485696566273749789215179247911) }}, 
      {{ SC_(-0.4e1), SC_(0.6540834903717041015625e0), SC_(0.0030095810505154039505649035929324233185650471379949) }}, 
      {{ SC_(-0.4e1), SC_(0.1097540378570556640625e1), SC_(0.015058380627056309463722070322914223292754890572289) }}, 
      {{ SC_(-0.4e1), SC_(0.30944411754608154296875e1), SC_(0.59848912997745095317460689682974327447677370660399) }}, 
      {{ SC_(-0.4e1), SC_(0.51139926910400390625e1), SC_(7.1096561414745714565763810157506729038368017958419) }}, 
      {{ SC_(-0.4e1), SC_(0.95070552825927734375e1), SC_(765.16515717873090426778318670348842991572055594829) }}, 
      {{ SC_(-0.4e1), SC_(0.24750102996826171875e2), SC_(3229907987.7660192457647761075637335091559830439104) }}, 
      {{ SC_(-0.4e1), SC_(0.637722015380859375e2), SC_(217726882458479319415712565.5405744792891643352915) }}, 
      {{ SC_(-0.7e1), SC_(0.177219114266335964202880859375e-2), SC_(3.3614059042626999826433170034673583525940024533365e-22) }}, 
      {{ SC_(-0.7e1), SC_(0.22177286446094512939453125e-2), SC_(1.2909459381881364762226234760871640013723793229134e-21) }}, 
      {{ SC_(-0.7e1), SC_(0.7444499991834163665771484375e-2), SC_(1.8470204487525243740480774284818604942655055760685e-18) }}, 
      {{ SC_(-0.7e1), SC_(0.1433600485324859619140625e-1), SC_(9.4195456714879631145465581060971390240605913016647e-17) }}, 
      {{ SC_(-0.7e1), SC_(0.1760916970670223236083984375e-1), SC_(3.2351633825752615485614839434982271986658229352008e-16) }}, 
      {{ SC_(-0.7e1), SC_(0.6152711808681488037109375e-1), SC_(5.8873930260915374674989454237737730208377956367626e-13) }}, 
      {{ SC_(-0.7e1), SC_(0.11958599090576171875e0), SC_(3.175330254744452869252588114264639853167205817015e-11) }}, 
      {{ SC_(-0.7e1), SC_(0.15262925624847412109375e0), SC_(1.37306382819489632474481829981320999530458749603e-10) }}, 
      {{ SC_(-0.7e1), SC_(0.408089816570281982421875e0), SC_(5.0454108730606873004055781144584974598940725268679e-08) }}, 
      {{ SC_(-0.7e1), SC_(0.6540834903717041015625e0), SC_(8.6439452609012235664132667907912941487867684225691e-07) }}, 
      {{ SC_(-0.7e1), SC_(0.1097540378570556640625e1), SC_(1.9903149576891282438547022015958250025057830031167e-05) }}, 
      {{ SC_(-0.7e1), SC_(0.30944411754608154296875e1), SC_(0.01384785426742151623543148483577563767691802604294) }}, 
      {{ SC_(-0.7e1), SC_(0.51139926910400390625e1), SC_(0.51646140440419256730344781907930371686614842827865) }}, 
      {{ SC_(-0.7e1), SC_(0.95070552825927734375e1), SC_(159.36813435931220806214715239890071317771114319414) }}, 
      {{ SC_(-0.7e1), SC_(0.24750102996826171875e2), SC_(1690985569.3106283509427018529720200073122553490215) }}, 
      {{ SC_(-0.7e1), SC_(0.637722015380859375e2), SC_(168498224714212654572390223.05556865829883060936147) }}, 
      {{ SC_(-0.1e2), SC_(0.177219114266335964202880859375e-2), SC_(4.6401508807064011421143230437500824609602971352179e-34) }}, 
      {{ SC_(-0.1e2), SC_(0.22177286446094512939453125e-2), SC_(3.4923094749247058078410546677911647554526610700822e-33) }}, 
      {{ SC_(-0.1e2), SC_(0.7444499991834163665771484375e-2), SC_(1.8899811421673150137144505161791836254612211618897e-28) }}, 
      {{ SC_(-0.1e2), SC_(0.1433600485324859619140625e-1), SC_(6.8832366136666889223518611944268692193585979859144e-26) }}, 
      {{ SC_(-0.1e2), SC_(0.1760916970670223236083984375e-1), SC_(4.3811749288152295951419128719224259962904962831792e-25) }}, 
      {{ SC_(-0.1e2), SC_(0.6152711808681488037109375e-1), SC_(3.4007993440358828048688277506578232572337801931071e-20) }}, 
      {{ SC_(-0.1e2), SC_(0.11958599090576171875e0), SC_(1.3465706671882772570222972249225215948417542289846e-17) }}, 
      {{ SC_(-0.1e2), SC_(0.15262925624847412109375e0), SC_(1.2104671718281105291439858586423655467136695739629e-16) }}, 
      {{ SC_(-0.1e2), SC_(0.408089816570281982421875e0), SC_(8.4861533427406158688302946175483668209061388974216e-13) }}, 
      {{ SC_(-0.1e2), SC_(0.6540834903717041015625e0), SC_(5.9662275860826758024768567630605908594392319370419e-11) }}, 
      {{ SC_(-0.1e2), SC_(0.1097540378570556640625e1), SC_(6.4263427651003603907119851552021198456497504370918e-09) }}, 
      {{ SC_(-0.1e2), SC_(0.30944411754608154296875e1), SC_(9.0581095107475697200688757844596473845335178799724e-05) }}, 
      {{ SC_(-0.1e2), SC_(0.51139926910400390625e1), SC_(0.012810443388044946681969202159228942193660937870026) }}, 
      {{ SC_(-0.1e2), SC_(0.95070552825927734375e1), SC_(15.60592527978584992145630257468419287679106228448) }}, 
      {{ SC_(-0.1e2), SC_(0.24750102996826171875e2), SC_(627917302.57961419731735233323958352991397820713106) }}, 
      {{ SC_(-0.1e2), SC_(0.637722015380859375e2), SC_(113459532318575669036439276.87008888326253509718636) }}, 
      {{ SC_(-0.13e2), SC_(0.177219114266335964202880859375e-2), SC_(2.4456812841552206198331648276735838307208194344922e-46) }}, 
      {{ SC_(-0.13e2), SC_(0.22177286446094512939453125e-2), SC_(3.6072314405975860034046247177476173774735736367531e-45) }}, 
      {{ SC_(-0.13e2), SC_(0.7444499991834163665771484375e-2), SC_(7.3841412140501872128796578303854512307073208188581e-39) }}, 
      {{ SC_(-0.13e2), SC_(0.1433600485324859619140625e-1), SC_(1.9204924469115190774990181944476141427755118423913e-35) }}, 
      {{ SC_(-0.13e2), SC_(0.1760916970670223236083984375e-1), SC_(2.265387054446753441806331709049474788648043685053e-34) }}, 
      {{ SC_(-0.13e2), SC_(0.6152711808681488037109375e-1), SC_(7.5007699710758693280183732287855910132602175813639e-28) }}, 
      {{ SC_(-0.13e2), SC_(0.11958599090576171875e0), SC_(2.1805434139201279779292196568881545047834755581445e-24) }}, 
      {{ SC_(-0.13e2), SC_(0.15262925624847412109375e0), SC_(4.0750693309347507669124384883757014786263684741617e-23) }}, 
      {{ SC_(-0.13e2), SC_(0.408089816570281982421875e0), SC_(5.4554704607395994835687731495288041560338136372535e-18) }}, 
      {{ SC_(-0.13e2), SC_(0.6540834903717041015625e0), SC_(1.5765156159987458616185208468121472963104447350042e-15) }}, 
      {{ SC_(-0.13e2), SC_(0.1097540378570556640625e1), SC_(7.9815499244594723489982895111836413560647173692536e-13) }}, 
      {{ SC_(-0.13e2), SC_(0.30944411754608154296875e1), SC_(2.3892209736758076242780232919452695681175929051865e-07) }}, 
      {{ SC_(-0.13e2), SC_(0.51139926910400390625e1), SC_(0.00013818222370676455792480764228728714310023991375189) }}, 
      {{ SC_(-0.13e2), SC_(0.95070552825927734375e1), SC_(0.79222983175956140130590251649409265616457558165901) }}, 
      {{ SC_(-0.13e2), SC_(0.24750102996826171875e2), SC_(167246140.89233842710493520460530057726331634864968) }}, 
      {{ SC_(-0.13e2), SC_(0.637722015380859375e2), SC_(66527964895331490665084274.729414759711662772569263) }}, 
      {{ SC_(-0.16e2), SC_(0.177219114266335964202880859375e-2), SC_(6.2327384908390204003995267448223005543055023147294e-59) }}, 
      {{ SC_(-0.16e2), SC_(0.22177286446094512939453125e-2), SC_(1.8015510900104265741703505220228255217501640996067e-57) }}, 
      {{ SC_(-0.16e2), SC_(0.7444499991834163665771484375e-2), SC_(1.3949346528058263997335600963443464048028784827881e-49) }}, 
      {{ SC_(-0.16e2), SC_(0.1433600485324859619140625e-1), SC_(2.5908604714318098779930030083499935197035305885449e-45) }}, 
      {{ SC_(-0.16e2), SC_(0.1760916970670223236083984375e-1), SC_(5.6637734123262466962398777103859439677795421081841e-44) }}, 
      {{ SC_(-0.16e2), SC_(0.6152711808681488037109375e-1), SC_(7.9991945166921338198712046906168540061184875351317e-36) }}, 
      {{ SC_(-0.16e2), SC_(0.11958599090576171875e0), SC_(1.7073706303992054301380968751501078313087885491857e-31) }}, 
      {{ SC_(-0.16e2), SC_(0.15262925624847412109375e0), SC_(6.6336820967524499048416265672676448776377767154055e-30) }}, 
      {{ SC_(-0.16e2), SC_(0.408089816570281982421875e0), SC_(1.6964977370960940867904018220611621037203607694874e-23) }}, 
      {{ SC_(-0.16e2), SC_(0.6540834903717041015625e0), SC_(2.0164686264336515855800514562160697497317741039595e-20) }}, 
      {{ SC_(-0.16e2), SC_(0.1097540378570556640625e1), SC_(4.8081423013451428446781996718199320667965846227978e-17) }}, 
      {{ SC_(-0.16e2), SC_(0.30944411754608154296875e1), SC_(3.1202777146405241319083739284324439475238974819571e-10) }}, 
      {{ SC_(-0.16e2), SC_(0.51139926910400390625e1), SC_(7.6506354774553372201041534782782851883589570488462e-07) }}, 
      {{ SC_(-0.16e2), SC_(0.95070552825927734375e1), SC_(0.022810518697728430978376653257588972923887424084797) }}, 
      {{ SC_(-0.16e2), SC_(0.24750102996826171875e2), SC_(32393686.878233176767714218218026712152488781179032) }}, 
      {{ SC_(-0.16e2), SC_(0.637722015380859375e2), SC_(34006044202102043664136930.416215586280411703681407) }}, 
      {{ SC_(-0.19e2), SC_(0.177219114266335964202880859375e-2), SC_(8.856847980878727795567709967496260001994211357813e-72) }}, 
      {{ SC_(-0.19e2), SC_(0.22177286446094512939453125e-2), SC_(5.0169572297336366765552303079999295510142794228582e-70) }}, 
      {{ SC_(-0.19e2), SC_(0.7444499991834163665771484375e-2), SC_(1.4693626716390377205874191389607611038360000766807e-60) }}, 
      {{ SC_(-0.19e2), SC_(0.1433600485324859619140625e-1), SC_(1.948932524957243795767695206040602854623886866201e-55) }}, 
      {{ SC_(-0.19e2), SC_(0.1760916970670223236083984375e-1), SC_(7.8957019077757739467283477371739720761027952996169e-54) }}, 
      {{ SC_(-0.19e2), SC_(0.6152711808681488037109375e-1), SC_(4.7567474718083147260120079391550475135946586430245e-44) }}, 
      {{ SC_(-0.19e2), SC_(0.11958599090576171875e0), SC_(7.4545320327999783266332919577297460937028986369503e-39) }}, 
      {{ SC_(-0.19e2), SC_(0.15262925624847412109375e0), SC_(6.0215600365965337916484418240419281309301921804305e-37) }}, 
      {{ SC_(-0.19e2), SC_(0.408089816570281982421875e0), SC_(2.9423333728004908601963916644442366115689862806536e-29) }}, 
      {{ SC_(-0.19e2), SC_(0.6540834903717041015625e0), SC_(1.438974209129641647167542567221369367211385506464e-25) }}, 
      {{ SC_(-0.19e2), SC_(0.1097540378570556640625e1), SC_(1.6176424036200185444597270593787016246601449964642e-21) }}, 
      {{ SC_(-0.19e2), SC_(0.30944411754608154296875e1), SC_(2.3004460236761897065652511082313592519092019184042e-13) }}, 
      {{ SC_(-0.19e2), SC_(0.51139926910400390625e1), SC_(2.4385852987632722455536745570114716849056311307068e-09) }}, 
      {{ SC_(-0.19e2), SC_(0.95070552825927734375e1), SC_(0.00040156165740344595105598595665264806808695248156959) }}, 
      {{ SC_(-0.19e2), SC_(0.24750102996826171875e2), SC_(4632725.6880069349564692619191717692091439317967541) }}, 
      {{ SC_(-0.19e2), SC_(0.637722015380859375e2), SC_(15173140165934437399551589.526356192163119956440712) }}, 
      {{ SC_(-0.22e2), SC_(0.177219114266335964202880859375e-2), SC_(7.7217901410693911227150913672524759201196903075688e-85) }}, 
      {{ SC_(-0.22e2), SC_(0.22177286446094512939453125e-2), SC_(8.5718139057074217885771301419152193014974567068691e-83) }}, 
      {{ SC_(-0.22e2), SC_(0.7444499991834163665771484375e-2), SC_(9.4960431304778410076342752912829121300498851551588e-72) }}, 
      {{ SC_(-0.22e2), SC_(0.1433600485324859619140625e-1), SC_(8.9947307650224396323985283241561562881690883036141e-66) }}, 
      {{ SC_(-0.22e2), SC_(0.1760916970670223236083984375e-1), SC_(6.7532719454852858707274844730590110322055354201261e-64) }}, 
      {{ SC_(-0.22e2), SC_(0.6152711808681488037109375e-1), SC_(1.7354564445702626586581450469447089808517451686261e-52) }}, 
      {{ SC_(-0.22e2), SC_(0.11958599090576171875e0), SC_(1.9968997630414801171372011643368703808933684536787e-46) }}, 
      {{ SC_(-0.22e2), SC_(0.15262925624847412109375e0), SC_(3.3535879185247440495559628765042054556736832009973e-44) }}, 
      {{ SC_(-0.22e2), SC_(0.408089816570281982421875e0), SC_(3.1312999792630543963468112049134819584201438113638e-35) }}, 
      {{ SC_(-0.22e2), SC_(0.6540834903717041015625e0), SC_(6.3022559148540593979809071511297179643355284388908e-31) }}, 
      {{ SC_(-0.22e2), SC_(0.1097540378570556640625e1), SC_(3.3421661563818918027248621563705615930961800683724e-26) }}, 
      {{ SC_(-0.22e2), SC_(0.30944411754608154296875e1), SC_(1.0480943588467369123564849816161014309504231224117e-16) }}, 
      {{ SC_(-0.22e2), SC_(0.51139926910400390625e1), SC_(4.8601470687452747654791579038432653167991722888448e-12) }}, 
      {{ SC_(-0.22e2), SC_(0.95070552825927734375e1), SC_(4.5932604866635780945986211206328686104317827785376e-06) }}, 
      {{ SC_(-0.22e2), SC_(0.24750102996826171875e2), SC_(497042.99880985683333764499216941722667112029683176) }}, 
      {{ SC_(-0.22e2), SC_(0.637722015380859375e2), SC_(5918880046023104655771352.6782237242901860852317783) }}, 
      {{ SC_(-0.25e2), SC_(0.177219114266335964202880859375e-2), SC_(4.4238249306786722714380053705078343362120752233109e-98) }}, 
      {{ SC_(-0.25e2), SC_(0.22177286446094512939453125e-2), SC_(9.6237914479471191558965141844862721081442175321339e-96) }}, 
      {{ SC_(-0.25e2), SC_(0.7444499991834163665771484375e-2), SC_(4.0327147045865958831583298860742024446331120501667e-83) }}, 
      {{ SC_(-0.25e2), SC_(0.1433600485324859619140625e-1), SC_(2.7278514060116473582575283637948648247484666198626e-76) }}, 
      {{ SC_(-0.25e2), SC_(0.1760916970670223236083984375e-1), SC_(3.7955868337522424942465659748636599881281084954936e-74) }}, 
      {{ SC_(-0.25e2), SC_(0.6152711808681488037109375e-1), SC_(4.1606316754451939513934325687032936781084709557174e-61) }}, 
      {{ SC_(-0.25e2), SC_(0.11958599090576171875e0), SC_(3.5150887159712265449519995061242180635458855716543e-54) }}, 
      {{ SC_(-0.25e2), SC_(0.15262925624847412109375e0), SC_(1.2273160435814530154216756907909730168133408979354e-51) }}, 
      {{ SC_(-0.25e2), SC_(0.408089816570281982421875e0), SC_(2.1899473435503006448341914230207856810704869083032e-41) }}, 
      {{ SC_(-0.25e2), SC_(0.6540834903717041015625e0), SC_(1.8141376468185006270177034679423087959304460589198e-36) }}, 
      {{ SC_(-0.25e2), SC_(0.1097540378570556640625e1), SC_(4.5401256012481338865917719171873814815455419943788e-31) }}, 
      {{ SC_(-0.25e2), SC_(0.30944411754608154296875e1), SC_(3.1521962466413116247808110835949674611594155007853e-20) }}, 
      {{ SC_(-0.25e2), SC_(0.51139926910400390625e1), SC_(6.4427073157520072840733338491592423980722282978731e-15) }}, 
      {{ SC_(-0.25e2), SC_(0.95070552825927734375e1), SC_(3.5857709467233735521574525635843083962184714996389e-08) }}, 
      {{ SC_(-0.25e2), SC_(0.24750102996826171875e2), SC_(40647.830055777630614853496513882487464182612659778) }}, 
      {{ SC_(-0.25e2), SC_(0.637722015380859375e2), SC_(2022150557561339396583620.7453516199727862155230984) }}, 
      {{ SC_(-0.28e2), SC_(0.177219114266335964202880859375e-2), SC_(1.7537290958183525886359463869845381510727973831423e-111) }}, 
      {{ SC_(-0.28e2), SC_(0.22177286446094512939453125e-2), SC_(7.4766028276759785646169118728086334339479138785121e-109) }}, 
      {{ SC_(-0.28e2), SC_(0.7444499991834163665771484375e-2), SC_(1.185050791595980297563816416170548017342823596371e-94) }}, 
      {{ SC_(-0.28e2), SC_(0.1433600485324859619140625e-1), SC_(5.724504710844555403747096938161237570505164025639e-87) }}, 
      {{ SC_(-0.28e2), SC_(0.1760916970670223236083984375e-1), SC_(1.4761425734303275112655245061072381804432607379419e-84) }}, 
      {{ SC_(-0.28e2), SC_(0.6152711808681488037109375e-1), SC_(6.9022390374891292355576926730504869388918678954679e-70) }}, 
      {{ SC_(-0.28e2), SC_(0.11958599090576171875e0), SC_(4.2815692363419751017394375328880217150827975972142e-62) }}, 
      {{ SC_(-0.28e2), SC_(0.15262925624847412109375e0), SC_(3.1080718605471868275638552768574431110418784071503e-59) }}, 
      {{ SC_(-0.28e2), SC_(0.408089816570281982421875e0), SC_(1.0598656166823514975648552246910002876529662767461e-47) }}, 
      {{ SC_(-0.28e2), SC_(0.6540834903717041015625e0), SC_(3.6140105230831318695326639669307447887819511019234e-42) }}, 
      {{ SC_(-0.28e2), SC_(0.1097540378570556640625e1), SC_(4.2693528244885788297255064309997960048365291014026e-36) }}, 
      {{ SC_(-0.28e2), SC_(0.30944411754608154296875e1), SC_(6.5802864120266680645515881946834747879356034935864e-24) }}, 
      {{ SC_(-0.28e2), SC_(0.51139926910400390625e1), SC_(5.9585045673303143108135339499940553485447088632098e-18) }}, 
      {{ SC_(-0.28e2), SC_(0.95070552825927734375e1), SC_(1.988438534646550878842883479897113184558083848306e-10) }}, 
      {{ SC_(-0.28e2), SC_(0.24750102996826171875e2), SC_(2573.1411287700232846977353121103361460322486488431) }}, 
      {{ SC_(-0.28e2), SC_(0.637722015380859375e2), SC_(606232660335704409810090.03657524411661636232787034) }}, 
      {{ SC_(-0.31e2), SC_(0.177219114266335964202880859375e-2), SC_(5.0087219126383253324349380172860487566432855139685e-125) }}, 
      {{ SC_(-0.31e2), SC_(0.22177286446094512939453125e-2), SC_(4.1846800213041264338919690624948669793769364574766e-122) }}, 
      {{ SC_(-0.31e2), SC_(0.7444499991834163665771484375e-2), SC_(2.5088591078901587717390863274703893752606853061857e-106) }}, 
      {{ SC_(-0.31e2), SC_(0.1433600485324859619140625e-1), SC_(8.6547590603242990949702115694256363867835406572861e-98) }}, 
      {{ SC_(-0.31e2), SC_(0.1760916970670223236083984375e-1), SC_(4.1359715994078682698876915805253118998897861437516e-95) }}, 
      {{ SC_(-0.31e2), SC_(0.6152711808681488037109375e-1), SC_(8.2493728361189737866670383445494981400106230153243e-79) }}, 
      {{ SC_(-0.31e2), SC_(0.11958599090576171875e0), SC_(3.7572570366945474616179276146698625977888359329743e-70) }}, 
      {{ SC_(-0.31e2), SC_(0.15262925624847412109375e0), SC_(5.670584642447869741263362302156653059738229151679e-67) }}, 
      {{ SC_(-0.31e2), SC_(0.408089816570281982421875e0), SC_(3.6955941921570070467273719291388407719278944905994e-54) }}, 
      {{ SC_(-0.31e2), SC_(0.6540834903717041015625e0), SC_(5.1874128673494756833392144870922666768391511767402e-48) }}, 
      {{ SC_(-0.31e2), SC_(0.1097540378570556640625e1), SC_(2.8931790681890152449929455935946929857333580509535e-41) }}, 
      {{ SC_(-0.31e2), SC_(0.30944411754608154296875e1), SC_(9.9178101387254123888824302991706578879838598783839e-28) }}, 
      {{ SC_(-0.31e2), SC_(0.51139926910400390625e1), SC_(3.9932674715594104964128503446033838147659504667162e-21) }}, 
      {{ SC_(-0.31e2), SC_(0.95070552825927734375e1), SC_(8.0950989569301632461640932495000811369058776548288e-13) }}, 
      {{ SC_(-0.31e2), SC_(0.24750102996826171875e2), SC_(127.94850241485772130585495761695068677510628272) }}, 
      {{ SC_(-0.31e2), SC_(0.637722015380859375e2), SC_(159817594923140342623291.20398499833703669395963482) }}, 
      {{ SC_(-0.34e2), SC_(0.177219114266335964202880859375e-2), SC_(1.0644934780176950962560394681532225849773680058709e-138) }}, 
      {{ SC_(-0.34e2), SC_(0.22177286446094512939453125e-2), SC_(1.7428976035917544129989302428497194913138579202666e-135) }}, 
      {{ SC_(-0.34e2), SC_(0.7444499991834163665771484375e-2), SC_(3.9524579403269171803369385637558217271264775288375e-118) }}, 
      {{ SC_(-0.34e2), SC_(0.1433600485324859619140625e-1), SC_(9.7369678001635573545503110129537132135591038708835e-109) }}, 
      {{ SC_(-0.34e2), SC_(0.1760916970670223236083984375e-1), SC_(8.6233990620942755154548731208557667522524325271062e-106) }}, 
      {{ SC_(-0.34e2), SC_(0.6152711808681488037109375e-1), SC_(7.3367515832609213979608708078032887331893716760878e-88) }}, 
      {{ SC_(-0.34e2), SC_(0.11958599090576171875e0), SC_(2.4535309861100621118404676470270001610755173253095e-78) }}, 
      {{ SC_(-0.34e2), SC_(0.15262925624847412109375e0), SC_(7.6987103226204474228299710459354001986872971425418e-75) }}, 
      {{ SC_(-0.34e2), SC_(0.408089816570281982421875e0), SC_(9.5891796438704037962550024950686831416871263944065e-61) }}, 
      {{ SC_(-0.34e2), SC_(0.6540834903717041015625e0), SC_(5.5410848148483629243991325407653364478861508321096e-54) }}, 
      {{ SC_(-0.34e2), SC_(0.1097540378570556640625e1), SC_(1.4592416702058255678868869069288933084584122765773e-46) }}, 
      {{ SC_(-0.34e2), SC_(0.30944411754608154296875e1), SC_(1.1141017553235972731179105495808947512528737037098e-31) }}, 
      {{ SC_(-0.34e2), SC_(0.51139926910400390625e1), SC_(1.9999533014515442664410514640311352029537737796512e-24) }}, 
      {{ SC_(-0.34e2), SC_(0.95070552825927734375e1), SC_(2.4868440390774050554114069080662971673947902623961e-15) }}, 
      {{ SC_(-0.34e2), SC_(0.24750102996826171875e2), SC_(5.06656357626145066912681718080220258943729401784) }}, 
      {{ SC_(-0.34e2), SC_(0.637722015380859375e2), SC_(37130522340900238142758.905822881447034320072942124) }}, 
      {{ SC_(-0.37e2), SC_(0.177219114266335964202880859375e-2), SC_(1.7287621278190839370590687031994130921705203027731e-152) }}, 
      {{ SC_(-0.37e2), SC_(0.22177286446094512939453125e-2), SC_(5.546993284567881066610530840898852183064493438262e-149) }}, 
      {{ SC_(-0.37e2), SC_(0.7444499991834163665771484375e-2), SC_(4.7581090814519782725042999839536478983860958645142e-130) }}, 
      {{ SC_(-0.37e2), SC_(0.1433600485324859619140625e-1), SC_(8.3708323995790324303958763893727680473342532914197e-120) }}, 
      {{ SC_(-0.37e2), SC_(0.1760916970670223236083984375e-1), SC_(1.3739014672168454406680073367182205099607148197632e-116) }}, 
      {{ SC_(-0.37e2), SC_(0.6152711808681488037109375e-1), SC_(4.9861237392471978055003726862508643829847162252575e-97) }}, 
      {{ SC_(-0.37e2), SC_(0.11958599090576171875e0), SC_(1.2243035655778619905636683889063047401519062606425e-86) }}, 
      {{ SC_(-0.37e2), SC_(0.15262925624847412109375e0), SC_(7.9870340394199891721115345149816582762740029243384e-83) }}, 
      {{ SC_(-0.37e2), SC_(0.408089816570281982421875e0), SC_(1.9013576951182169806853947255296139623785576186916e-67) }}, 
      {{ SC_(-0.37e2), SC_(0.6540834903717041015625e0), SC_(4.5231204964283367350579123529524644256173276796902e-60) }}, 
      {{ SC_(-0.37e2), SC_(0.1097540378570556640625e1), SC_(5.6249756162264798875230713047050389930739501783392e-52) }}, 
      {{ SC_(-0.37e2), SC_(0.30944411754608154296875e1), SC_(9.5747313181559510960653928485860835096410763339761e-36) }}, 
      {{ SC_(-0.37e2), SC_(0.51139926910400390625e1), SC_(7.67859806352689356386823578607221058376012844798e-28) }}, 
      {{ SC_(-0.37e2), SC_(0.95070552825927734375e1), SC_(5.9001858858606893937118814413721912920024394022728e-18) }}, 
      {{ SC_(-0.37e2), SC_(0.24750102996826171875e2), SC_(0.16182031803861277979226848786561421115178084390837) }}, 
      {{ SC_(-0.37e2), SC_(0.637722015380859375e2), SC_(7620156925871909004013.4511789819332608090859149484) }}, 
      {{ SC_(-0.4e2), SC_(0.177219114266335964202880859375e-2), SC_(2.1934463145098982856482722894618772007386408955866e-166) }}, 
      {{ SC_(-0.4e2), SC_(0.22177286446094512939453125e-2), SC_(1.3792498395120423934684486452597604404348707842772e-162) }}, 
      {{ SC_(-0.4e2), SC_(0.7444499991834163665771484375e-2), SC_(4.4750827254189778755330436710326506163523889802085e-142) }}, 
      {{ SC_(-0.4e2), SC_(0.1433600485324859619140625e-1), SC_(5.6222881809274427763875173260632408250704436858785e-131) }}, 
      {{ SC_(-0.4e2), SC_(0.1760916970670223236083984375e-1), SC_(1.7101422547443159905114096833775090592290767321829e-127) }}, 
      {{ SC_(-0.4e2), SC_(0.6152711808681488037109375e-1), SC_(2.6474147397607258550183244427472642118161245275487e-106) }}, 
      {{ SC_(-0.4e2), SC_(0.11958599090576171875e0), SC_(4.7729492236342102509017782812387711881706287458449e-95) }}, 
      {{ SC_(-0.4e2), SC_(0.15262925624847412109375e0), SC_(6.4737153699907991293058554021804873987255762728477e-91) }}, 
      {{ SC_(-0.4e2), SC_(0.408089816570281982421875e0), SC_(2.9454570864564136977420322683387112229627476337539e-74) }}, 
      {{ SC_(-0.4e2), SC_(0.6540834903717041015625e0), SC_(2.8846886509171748574863377735521386214202206755858e-66) }}, 
      {{ SC_(-0.4e2), SC_(0.1097540378570556640625e1), SC_(1.6941972001909998208906812347963350453047191654302e-57) }}, 
      {{ SC_(-0.4e2), SC_(0.30944411754608154296875e1), SC_(6.4346689071340193649227713397841966987433720786189e-40) }}, 
      {{ SC_(-0.4e2), SC_(0.51139926910400390625e1), SC_(2.3089841179919606378679849343539819497749439614471e-31) }}, 
      {{ SC_(-0.4e2), SC_(0.95070552825927734375e1), SC_(1.102736347295864305334545583894581762444979228683e-20) }}, 
      {{ SC_(-0.4e2), SC_(0.24750102996826171875e2), SC_(0.0042179636760203964867503418195156015892913194089181) }}, 
      {{ SC_(-0.4e2), SC_(0.637722015380859375e2), SC_(1384718401734132335251.2307161144249865361826025353) }}, 
      {{ SC_(-0.43e2), SC_(0.177219114266335964202880859375e-2), SC_(2.2155194558806744336118853845894526377597755033613e-180) }}, 
      {{ SC_(-0.43e2), SC_(0.22177286446094512939453125e-2), SC_(2.7301407262855693718808358405067536530151961222709e-176) }}, 
      {{ SC_(-0.43e2), SC_(0.7444499991834163665771484375e-2), SC_(3.3506150347288365485455030173519989511162460227522e-154) }}, 
      {{ SC_(-0.43e2), SC_(0.1433600485324859619140625e-1), SC_(3.0061756609377494048964736743144427129003213203223e-142) }}, 
      {{ SC_(-0.43e2), SC_(0.1760916970670223236083984375e-1), SC_(1.6945940912316967428473837149944892562616754985489e-138) }}, 
      {{ SC_(-0.43e2), SC_(0.6152711808681488037109375e-1), SC_(1.1190199437049647148982314787349308670836083412719e-115) }}, 
      {{ SC_(-0.43e2), SC_(0.11958599090576171875e0), SC_(1.4812957404734739372437378368931490462014921889916e-103) }}, 
      {{ SC_(-0.43e2), SC_(0.15262925624847412109375e0), SC_(4.1771418376583419694971373044913302025322339896609e-99) }}, 
      {{ SC_(-0.43e2), SC_(0.408089816570281982421875e0), SC_(3.6324851051777819272129739809658943871874407487028e-81) }}, 
      {{ SC_(-0.43e2), SC_(0.6540834903717041015625e0), SC_(1.4646390194930429146922835980901944721928096243995e-72) }}, 
      {{ SC_(-0.43e2), SC_(0.1097540378570556640625e1), SC_(4.0625964334686726052275084650431825087265178224124e-63) }}, 
      {{ SC_(-0.43e2), SC_(0.30944411754608154296875e1), SC_(3.445055402147930375877257131921015119606512508245e-44) }}, 
      {{ SC_(-0.43e2), SC_(0.51139926910400390625e1), SC_(5.5381687600583444906926687040881418784943267264745e-35) }}, 
      {{ SC_(-0.43e2), SC_(0.95070552825927734375e1), SC_(1.6515029191453376830894919269624334980950396009178e-23) }}, 
      {{ SC_(-0.43e2), SC_(0.24750102996826171875e2), SC_(9.07033473684436819050490950252432930934152092096e-05) }}, 
      {{ SC_(-0.43e2), SC_(0.637722015380859375e2), SC_(223349833220390199450.27662394978391334765490925711) }}, 
      {{ SC_(-0.46e2), SC_(0.177219114266335964202880859375e-2), SC_(1.8104378462921870510073243689353670043465780417572e-194) }}, 
      {{ SC_(-0.46e2), SC_(0.22177286446094512939453125e-2), SC_(4.3720650768675253652563392243562531036087038645837e-190) }}, 
      {{ SC_(-0.46e2), SC_(0.7444499991834163665771484375e-2), SC_(2.0295861561067542761383038303516665614408092929621e-166) }}, 
      {{ SC_(-0.46e2), SC_(0.1433600485324859619140625e-1), SC_(1.3003944406199447796291213829678693617876885669235e-153) }}, 
      {{ SC_(-0.46e2), SC_(0.1760916970670223236083984375e-1), SC_(1.358496858602096893203295098466102421151497813062e-149) }}, 
      {{ SC_(-0.46e2), SC_(0.6152711808681488037109375e-1), SC_(3.8266017294469036713813054977133414550613357620995e-125) }}, 
      {{ SC_(-0.46e2), SC_(0.11958599090576171875e0), SC_(3.7192605471161617718716878121485601007325143417766e-112) }}, 
      {{ SC_(-0.46e2), SC_(0.15262925624847412109375e0), SC_(2.1805444805077346331288545875784651786026586254492e-107) }}, 
      {{ SC_(-0.46e2), SC_(0.408089816570281982421875e0), SC_(3.6242559912380282003067476102750491997093042839905e-88) }}, 
      {{ SC_(-0.46e2), SC_(0.6540834903717041015625e0), SC_(6.0163489655614054743164061525225632154707225487227e-79) }}, 
      {{ SC_(-0.46e2), SC_(0.1097540378570556640625e1), SC_(7.8819672414759206147861166344933846001601735395384e-69) }}, 
      {{ SC_(-0.46e2), SC_(0.30944411754608154296875e1), SC_(1.4930590833870162213775836764629326071792693829531e-48) }}, 
      {{ SC_(-0.46e2), SC_(0.51139926910400390625e1), SC_(1.0763470713262935904456505724516010574972799879661e-38) }}, 
      {{ SC_(-0.46e2), SC_(0.95070552825927734375e1), SC_(2.0115846220319402838816743576250278175262193057597e-26) }}, 
      {{ SC_(-0.46e2), SC_(0.24750102996826171875e2), SC_(1.6252200145822910970533586273353022511176623102534e-06) }}, 
      {{ SC_(-0.46e2), SC_(0.637722015380859375e2), SC_(32056296975334433492.887437331135099409690999530645) }}, 
      {{ SC_(-0.49e2), SC_(0.177219114266335964202880859375e-2), SC_(1.2137476169035449224165111313052760780577498154495e-208) }}, 
      {{ SC_(-0.49e2), SC_(0.22177286446094512939453125e-2), SC_(5.744138736848391561405561566827001406807628730672e-204) }}, 
      {{ SC_(-0.49e2), SC_(0.7444499991834163665771484375e-2), SC_(1.0086190601725809485592749250036950039156412980801e-178) }}, 
      {{ SC_(-0.49e2), SC_(0.1433600485324859619140625e-1), SC_(4.6150092654244014484753439347715293478138962384071e-165) }}, 
      {{ SC_(-0.49e2), SC_(0.1760916970670223236083984375e-1), SC_(8.9348715778263801065552292828264974327479981243026e-161) }}, 
      {{ SC_(-0.49e2), SC_(0.6152711808681488037109375e-1), SC_(1.073557969060502670244818681362437101258532544188e-134) }}, 
      {{ SC_(-0.49e2), SC_(0.11958599090576171875e0), SC_(7.6614056528546695457433049939650076449807425863572e-121) }}, 
      {{ SC_(-0.49e2), SC_(0.15262925624847412109375e0), SC_(9.3387316510569269729588388217209165125692830551503e-116) }}, 
      {{ SC_(-0.49e2), SC_(0.408089816570281982421875e0), SC_(2.9667037180399959712795194068438806052231435377161e-95) }}, 
      {{ SC_(-0.49e2), SC_(0.6540834903717041015625e0), SC_(2.027595514156380296893790154872960085404285710906e-85) }}, 
      {{ SC_(-0.49e2), SC_(0.1097540378570556640625e1), SC_(1.254665875782490153416445484836172524618855505355e-74) }}, 
      {{ SC_(-0.49e2), SC_(0.30944411754608154296875e1), SC_(5.3112767401349998228922034188767491632135108874701e-53) }}, 
      {{ SC_(-0.49e2), SC_(0.51139926910400390625e1), SC_(1.7184230106399633928374634149552055310832862291052e-42) }}, 
      {{ SC_(-0.49e2), SC_(0.95070552825927734375e1), SC_(2.0188620523288691423046930654162370151184157582571e-29) }}, 
      {{ SC_(-0.49e2), SC_(0.24750102996826171875e2), SC_(2.4486900820026561561243390823793236131043274568681e-08) }}, 
      {{ SC_(-0.49e2), SC_(0.637722015380859375e2), SC_(4104203373731508351.8091124505391567563692298373867) }}, 
      {{ SC_(-0.52e2), SC_(0.177219114266335964202880859375e-2), SC_(6.7582433736913603419058059256135791361735470637909e-223) }}, 
      {{ SC_(-0.52e2), SC_(0.22177286446094512939453125e-2), SC_(6.2679264331526494370328882789831359414684776971336e-218) }}, 
      {{ SC_(-0.52e2), SC_(0.7444499991834163665771484375e-2), SC_(4.1630106067711993660903358738294501375369753249879e-191) }}, 
      {{ SC_(-0.52e2), SC_(0.1433600485324859619140625e-1), SC_(1.3602875417470081410985454428401245372759992414993e-176) }}, 
      {{ SC_(-0.52e2), SC_(0.1760916970670223236083984375e-1), SC_(4.8806612177325115813521165986700318378662496250041e-172) }}, 
      {{ SC_(-0.52e2), SC_(0.6152711808681488037109375e-1), SC_(2.5014882661113533293597761965233330461237158797651e-144) }}, 
      {{ SC_(-0.52e2), SC_(0.11958599090576171875e0), SC_(1.3107541196311674615336229789222782210248645345988e-129) }}, 
      {{ SC_(-0.52e2), SC_(0.15262925624847412109375e0), SC_(3.321788061274790179806750754248969443658942707425e-124) }}, 
      {{ SC_(-0.52e2), SC_(0.408089816570281982421875e0), SC_(2.0169405302622672394567009913765725797440815303228e-102) }}, 
      {{ SC_(-0.52e2), SC_(0.6540834903717041015625e0), SC_(5.6754178832405837953514458701036195191657065470066e-92) }}, 
      {{ SC_(-0.52e2), SC_(0.1097540378570556640625e1), SC_(1.6588360861872987132698768619041215273305353601283e-80) }}, 
      {{ SC_(-0.52e2), SC_(0.30944411754608154296875e1), SC_(1.5698207694417899021446502648229999500768660780745e-57) }}, 
      {{ SC_(-0.52e2), SC_(0.51139926910400390625e1), SC_(2.2810052462334100092981477624289897510531514533963e-46) }}, 
      {{ SC_(-0.52e2), SC_(0.95070552825927734375e1), SC_(1.6888264677784034501755356452466192541124575722402e-32) }}, 
      {{ SC_(-0.52e2), SC_(0.24750102996826171875e2), SC_(3.1284554770212266533654823889614535495011507388997e-10) }}, 
      {{ SC_(-0.52e2), SC_(0.637722015380859375e2), SC_(469912526052398293.17302112716282663456985359455793) }}, 
      {{ SC_(-0.55e2), SC_(0.177219114266335964202880859375e-2), SC_(3.1593849990997961977974943812146816685612063609753e-237) }}, 
      {{ SC_(-0.55e2), SC_(0.22177286446094512939453125e-2), SC_(5.7423035662670156701155774883438821586276792733737e-232) }}, 
      {{ SC_(-0.55e2), SC_(0.7444499991834163665771484375e-2), SC_(1.4426173536899176398539280108006290466380469104659e-203) }}, 
      {{ SC_(-0.55e2), SC_(0.1433600485324859619140625e-1), SC_(3.3662948625298628408893789499302767949884611521748e-188) }}, 
      {{ SC_(-0.55e2), SC_(0.1760916970670223236083984375e-1), SC_(2.2383721988438966126895088423110749261179727739443e-183) }}, 
      {{ SC_(-0.55e2), SC_(0.6152711808681488037109375e-1), SC_(4.8936711651864414231989567585154845915532624571577e-154) }}, 
      {{ SC_(-0.55e2), SC_(0.11958599090576171875e0), SC_(1.8827710109688701937429883606767323358888834986806e-138) }}, 
      {{ SC_(-0.55e2), SC_(0.15262925624847412109375e0), SC_(9.9201804930062867946547900039207204930607095294563e-133) }}, 
      {{ SC_(-0.55e2), SC_(0.408089816570281982421875e0), SC_(1.1512714886725383721018856342861659745765144062983e-109) }}, 
      {{ SC_(-0.55e2), SC_(0.6540834903717041015625e0), SC_(1.3337792351351849232556965484782506374204938471942e-98) }}, 
      {{ SC_(-0.55e2), SC_(0.1097540378570556640625e1), SC_(1.8414497718532141402443858594087036395047321320979e-86) }}, 
      {{ SC_(-0.55e2), SC_(0.30944411754608154296875e1), SC_(3.8967726654446097204350019896316737688338122273432e-62) }}, 
      {{ SC_(-0.55e2), SC_(0.51139926910400390625e1), SC_(2.5442972422456580268434830211595319738276544262809e-50) }}, 
      {{ SC_(-0.55e2), SC_(0.95070552825927734375e1), SC_(1.1896599721367974831559089457000349605850672303126e-35) }}, 
      {{ SC_(-0.55e2), SC_(0.24750102996826171875e2), SC_(3.4154599781777805873676342450915281728506074263741e-12) }}, 
      {{ SC_(-0.55e2), SC_(0.637722015380859375e2), SC_(48234457604444740.335143147971511893573254691716282) }}, 
      {{ SC_(-0.58e2), SC_(0.177219114266335964202880859375e-2), SC_(1.2520413645388569928887958112848204212138063461708e-251) }}, 
      {{ SC_(-0.58e2), SC_(0.22177286446094512939453125e-2), SC_(4.4595989634686150568429251044625228423529401458671e-246) }}, 
      {{ SC_(-0.58e2), SC_(0.7444499991834163665771484375e-2), SC_(4.2378168989917621180007953130186366290981620423231e-216) }}, 
      {{ SC_(-0.58e2), SC_(0.1433600485324859619140625e-1), SC_(7.0618906988802236107307134052564237747614610667347e-200) }}, 
      {{ SC_(-0.58e2), SC_(0.1760916970670223236083984375e-1), SC_(8.702285916071814227807807229418309354595552484574e-195) }}, 
      {{ SC_(-0.58e2), SC_(0.6152711808681488037109375e-1), SC_(8.1155609568253125349091276265266629388793969141888e-164) }}, 
      {{ SC_(-0.58e2), SC_(0.11958599090576171875e0), SC_(2.2925633886147348167887929308708443895271449574002e-147) }}, 
      {{ SC_(-0.58e2), SC_(0.15262925624847412109375e0), SC_(2.5113943794105648062440017015132938005891936086402e-141) }}, 
      {{ SC_(-0.58e2), SC_(0.408089816570281982421875e0), SC_(5.5707269509534084668880316016301521365616605779226e-117) }}, 
      {{ SC_(-0.58e2), SC_(0.6540834903717041015625e0), SC_(2.657190957474252490339745093174279959587302920337e-105) }}, 
      {{ SC_(-0.58e2), SC_(0.1097540378570556640625e1), SC_(1.7329204095864388145245624373544625363852920610294e-92) }}, 
      {{ SC_(-0.58e2), SC_(0.30944411754608154296875e1), SC_(8.2021165289716639245472391886116444446565644799576e-67) }}, 
      {{ SC_(-0.58e2), SC_(0.51139926910400390625e1), SC_(2.4075702286581099190297646954055364849049383370423e-54) }}, 
      {{ SC_(-0.58e2), SC_(0.95070552825927734375e1), SC_(7.1220189825823412856021938995136401566994991595578e-39) }}, 
      {{ SC_(-0.58e2), SC_(0.24750102996826171875e2), SC_(3.2090378383167806078759489925206593790671983259232e-14) }}, 
      {{ SC_(-0.58e2), SC_(0.637722015380859375e2), SC_(4449584424751920.8125944951606147809737782831249622) }}, 
      {{ SC_(-0.61e2), SC_(0.177219114266335964202880859375e-2), SC_(4.2425710020331914252821718283968275084437170049519e-266) }}, 
      {{ SC_(-0.61e2), SC_(0.22177286446094512939453125e-2), SC_(2.9614184695203394581083532929114208408300940116942e-260) }}, 
      {{ SC_(-0.61e2), SC_(0.7444499991834163665771484375e-2), SC_(1.0644555775598225924016923665182010252785388717882e-228) }}, 
      {{ SC_(-0.61e2), SC_(0.1433600485324859619140625e-1), SC_(1.2667302662084979337826570205994629760575270558421e-211) }}, 
      {{ SC_(-0.61e2), SC_(0.1760916970670223236083984375e-1), SC_(2.8928686352184495808714058731442370301152120952584e-206) }}, 
      {{ SC_(-0.61e2), SC_(0.6152711808681488037109375e-1), SC_(1.1507915428192169017964403554298572567426260297269e-173) }}, 
      {{ SC_(-0.61e2), SC_(0.11958599090576171875e0), SC_(2.3869299277328255154517154042855638918319843712064e-156) }}, 
      {{ SC_(-0.61e2), SC_(0.15262925624847412109375e0), SC_(5.4363176381398824179797926296956081316400445904413e-150) }}, 
      {{ SC_(-0.61e2), SC_(0.408089816570281982421875e0), SC_(2.304846819977282184080434493418762646459057636491e-124) }}, 
      {{ SC_(-0.61e2), SC_(0.6540834903717041015625e0), SC_(4.5264779375838098725800226481107380276899609082274e-112) }}, 
      {{ SC_(-0.61e2), SC_(0.1097540378570556640625e1), SC_(1.394454579586264814875228803591527867526457487378e-98) }}, 
      {{ SC_(-0.61e2), SC_(0.30944411754608154296875e1), SC_(1.4765286399092230040791741547510647367576508020078e-71) }}, 
      {{ SC_(-0.61e2), SC_(0.51139926910400390625e1), SC_(1.9492095186618141817805891509498817574437792414524e-58) }}, 
      {{ SC_(-0.61e2), SC_(0.95070552825927734375e1), SC_(3.6535166424498974327222404091018181991713133997357e-42) }}, 
      {{ SC_(-0.61e2), SC_(0.24750102996826171875e2), SC_(2.6118649550402288054398306933496441568963183554462e-16) }}, 
      {{ SC_(-0.61e2), SC_(0.637722015380859375e2), SC_(369792726054441.26944059981155583095952179135366203) }}, 
      {{ SC_(-0.64e2), SC_(0.177219114266335964202880859375e-2), SC_(1.2388215254263042046658811407264068831944639577887e-280) }}, 
      {{ SC_(-0.64e2), SC_(0.22177286446094512939453125e-2), SC_(1.6946223779377366322214570359963237180694346302933e-274) }}, 
      {{ SC_(-0.64e2), SC_(0.7444499991834163665771484375e-2), SC_(2.3039978927625714612754208135610671784320013072718e-241) }}, 
      {{ SC_(-0.64e2), SC_(0.1433600485324859619140625e-1), SC_(1.9580171289330104594320265640969941604408912539339e-223) }}, 
      {{ SC_(-0.64e2), SC_(0.1760916970670223236083984375e-1), SC_(8.2869222089767530366964301609205640263233926997991e-218) }}, 
      {{ SC_(-0.64e2), SC_(0.6152711808681488037109375e-1), SC_(1.4061899668280737770929553194231885629327969496772e-183) }}, 
      {{ SC_(-0.64e2), SC_(0.11958599090576171875e0), SC_(2.1415454598728861932080547695071679847395256848646e-165) }}, 
      {{ SC_(-0.64e2), SC_(0.15262925624847412109375e0), SC_(1.0140610986099354939720650920341316744599074527865e-158) }}, 
      {{ SC_(-0.64e2), SC_(0.408089816570281982421875e0), SC_(8.2175612618247530833632942052734480423446402337471e-132) }}, 
      {{ SC_(-0.64e2), SC_(0.6540834903717041015625e0), SC_(6.644634547471484880791466057684730813837330292183e-119) }}, 
      {{ SC_(-0.64e2), SC_(0.1097540378570556640625e1), SC_(9.6696376607232609042276705446491638405663890260955e-105) }}, 
      {{ SC_(-0.64e2), SC_(0.30944411754608154296875e1), SC_(2.2909383826664629344212826375049004437270655767509e-76) }}, 
      {{ SC_(-0.64e2), SC_(0.51139926910400390625e1), SC_(1.3606375299804661100856453043111750946073025084922e-62) }}, 
      {{ SC_(-0.64e2), SC_(0.95070552825927734375e1), SC_(1.6180433668923993064382449435665897851233631058371e-45) }}, 
      {{ SC_(-0.64e2), SC_(0.24750102996826171875e2), SC_(1.8526974585711814390179423187480033162454423293619e-18) }}, 
      {{ SC_(-0.64e2), SC_(0.637722015380859375e2), SC_(27753113149542.319960176525351078723832287820547493) }}, 
      {{ SC_(-0.67e2), SC_(0.177219114266335964202880859375e-2), SC_(3.1391579949641315570429785335251785779472340952396e-295) }}, 
      {{ SC_(-0.67e2), SC_(0.22177286446094512939453125e-2), SC_(8.4153251602910179456365817555428171807809518688995e-289) }}, 
      {{ SC_(-0.67e2), SC_(0.7444499991834163665771484375e-2), SC_(4.3277425893419072609128204122623810704245409423407e-254) }}, 
      {{ SC_(-0.67e2), SC_(0.1433600485324859619140625e-1), SC_(2.6264772024499850109130857465955655576422239032293e-235) }}, 
      {{ SC_(-0.67e2), SC_(0.1760916970670223236083984375e-1), SC_(2.0600730537734909016515261785532438510975012855129e-229) }}, 
      {{ SC_(-0.67e2), SC_(0.6152711808681488037109375e-1), SC_(1.4911322583614259693979664878250519196585835218334e-193) }}, 
      {{ SC_(-0.67e2), SC_(0.11958599090576171875e0), SC_(1.6674001854529428038637462621355919009987100139771e-174) }}, 
      {{ SC_(-0.67e2), SC_(0.15262925624847412109375e0), SC_(1.6415284380093694762051254707233017592566535189797e-167) }}, 
      {{ SC_(-0.67e2), SC_(0.408089816570281982421875e0), SC_(2.5425525749591888960496273354363910266310540776057e-139) }}, 
      {{ SC_(-0.67e2), SC_(0.6540834903717041015625e0), SC_(8.4646682425793074323920353901914134714572584083322e-126) }}, 
      {{ SC_(-0.67e2), SC_(0.1097540378570556640625e1), SC_(5.8190252763780625217344009150147801436271833123923e-111) }}, 
      {{ SC_(-0.67e2), SC_(0.30944411754608154296875e1), SC_(3.0852077415388690855886325107096863249917033942949e-81) }}, 
      {{ SC_(-0.67e2), SC_(0.51139926910400390625e1), SC_(8.2462111027747296965681108576161141617822209913075e-67) }}, 
      {{ SC_(-0.67e2), SC_(0.95070552825927734375e1), SC_(6.2285651920123373313610961040377593081523421620429e-49) }}, 
      {{ SC_(-0.67e2), SC_(0.24750102996826171875e2), SC_(1.1517779224277461415676244801629515542988750835375e-20) }}, 
      {{ SC_(-0.67e2), SC_(0.637722015380859375e2), SC_(1885370641257.1827204796598740013286146728943092018) }}, 
      {{ SC_(-0.7e2), SC_(0.177219114266335964202880859375e-2), SC_(6.9473961878707575158600210597440403366919272660158e-310) }}, 
      {{ SC_(-0.7e2), SC_(0.7444499991834163665771484375e-2), SC_(7.0997854620701933448207860785327496840617296058248e-267) }}, 
      {{ SC_(-0.7e2), SC_(0.1433600485324859619140625e-1), SC_(3.0770549060187263202686051152703950291929132300009e-247) }}, 
      {{ SC_(-0.7e2), SC_(0.1760916970670223236083984375e-1), SC_(4.4727687301545682185419970522402590443925802186037e-241) }}, 
      {{ SC_(-0.7e2), SC_(0.6152711808681488037109375e-1), SC_(1.38099727631585453821424328210265554521889576794e-203) }}, 
      {{ SC_(-0.7e2), SC_(0.11958599090576171875e0), SC_(1.1338535137583496021114388849056277318334203998478e-183) }}, 
      {{ SC_(-0.7e2), SC_(0.15262925624847412109375e0), SC_(2.3207978713078011352593728014212904279302244216489e-176) }}, 
      {{ SC_(-0.7e2), SC_(0.408089816570281982421875e0), SC_(6.8707243490708476481738782345605125804860468763652e-147) }}, 
      {{ SC_(-0.7e2), SC_(0.6540834903717041015625e0), SC_(9.4179449916360381129438016958300605326351814425029e-133) }}, 
      {{ SC_(-0.7e2), SC_(0.1097540378570556640625e1), SC_(3.058460877037596390669567494169930309974687355767e-117) }}, 
      {{ SC_(-0.7e2), SC_(0.30944411754608154296875e1), SC_(3.6293163655119455138709489938300238971715047471255e-86) }}, 
      {{ SC_(-0.7e2), SC_(0.51139926910400390625e1), SC_(4.3666440561259071006305673721113793993049308903697e-71) }}, 
      {{ SC_(-0.7e2), SC_(0.95070552825927734375e1), SC_(2.0969827693288095828633768469004433740064673456557e-52) }}, 
      {{ SC_(-0.7e2), SC_(0.24750102996826171875e2), SC_(6.3081171041477797378349146657536728814518874279765e-23) }}, 
      {{ SC_(-0.7e2), SC_(0.637722015380859375e2), SC_(116200587705.9972033212971866848583486865390099783) }}, 
      {{ SC_(-0.73e2), SC_(0.177219114266335964202880859375e-2), SC_(1.3507496963190848811812605035755276822306783013008e-324) }}, 
      {{ SC_(-0.73e2), SC_(0.22177286446094512939453125e-2), SC_(1.3906558628240210167410406322926273217138498155297e-317) }}, 
      {{ SC_(-0.73e2), SC_(0.7444499991834163665771484375e-2), SC_(1.0232292612643929164393555734712076107963466015419e-279) }}, 
      {{ SC_(-0.73e2), SC_(0.1433600485324859619140625e-1), SC_(3.1669468744744228128871438059384274750920481170588e-259) }}, 
      {{ SC_(-0.73e2), SC_(0.1760916970670223236083984375e-1), SC_(8.5312798332901951159689132307158391752594168130046e-253) }}, 
      {{ SC_(-0.73e2), SC_(0.6152711808681488037109375e-1), SC_(1.1236043760547774550840777773292804117368603963381e-213) }}, 
      {{ SC_(-0.73e2), SC_(0.11958599090576171875e0), SC_(6.773576827937433880701869360263370808791766081818e-193) }}, 
      {{ SC_(-0.73e2), SC_(0.15262925624847412109375e0), SC_(2.8825064217746425597303617323233603741034850031809e-185) }}, 
      {{ SC_(-0.73e2), SC_(0.408089816570281982421875e0), SC_(1.6310978659437693190299774851696549575048944847774e-154) }}, 
      {{ SC_(-0.73e2), SC_(0.6540834903717041015625e0), SC_(9.2055305236266895105402372198275994943403004085982e-140) }}, 
      {{ SC_(-0.73e2), SC_(0.1097540378570556640625e1), SC_(1.4122341130484579348120664306328290171004071749639e-123) }}, 
      {{ SC_(-0.73e2), SC_(0.30944411754608154296875e1), SC_(3.7511636793232867462931323998211418887996843788832e-91) }}, 
      {{ SC_(-0.73e2), SC_(0.51139926910400390625e1), SC_(2.0320758792487700817910271861967809334924888836874e-75) }}, 
      {{ SC_(-0.73e2), SC_(0.95070552825927734375e1), SC_(6.2097685364004522844908379887813700451507749938078e-56) }}, 
      {{ SC_(-0.73e2), SC_(0.24750102996826171875e2), SC_(3.0584007614905224150486889015635217620856903402764e-25) }}, 
      {{ SC_(-0.73e2), SC_(0.637722015380859375e2), SC_(6512044119.7702057066658291352087070348263357228093) }}, 
      {{ SC_(-0.76e2), SC_(0.177219114266335964202880859375e-2), SC_(2.3195339478133814054007492392224202349931276855473e-339) }}, 
      {{ SC_(-0.76e2), SC_(0.22177286446094512939453125e-2), SC_(4.6799267801180082535015118083610105786567490647111e-332) }}, 
      {{ SC_(-0.76e2), SC_(0.7444499991834163665771484375e-2), SC_(1.302487964423846871761170667875260709588948583303e-292) }}, 
      {{ SC_(-0.76e2), SC_(0.1433600485324859619140625e-1), SC_(2.8788520988405523410234474831788210360652724346618e-271) }}, 
      {{ SC_(-0.76e2), SC_(0.1760916970670223236083984375e-1), SC_(1.4372257027590942365638884742058014425484218169965e-264) }}, 
      {{ SC_(-0.76e2), SC_(0.6152711808681488037109375e-1), SC_(8.0743409403950639843494092057130732296951054158363e-224) }}, 
      {{ SC_(-0.76e2), SC_(0.11958599090576171875e0), SC_(3.5739814054216253005793493470952029267539287015973e-202) }}, 
      {{ SC_(-0.76e2), SC_(0.15262925624847412109375e0), SC_(3.1621059211308472966030568819860933756230005522119e-194) }}, 
      {{ SC_(-0.76e2), SC_(0.408089816570281982421875e0), SC_(3.4200419048105661428016795544405914835338349409359e-162) }}, 
      {{ SC_(-0.76e2), SC_(0.6540834903717041015625e0), SC_(7.9472481910706086097506541561280938718583919474349e-147) }}, 
      {{ SC_(-0.76e2), SC_(0.1097540378570556640625e1), SC_(5.7595666922124447046430787468026384041534535625797e-130) }}, 
      {{ SC_(-0.76e2), SC_(0.30944411754608154296875e1), SC_(3.4247611609219922313466541280690329008558200182914e-96) }}, 
      {{ SC_(-0.76e2), SC_(0.51139926910400390625e1), SC_(8.3549036111460052656699367013939841144814107156374e-80) }}, 
      {{ SC_(-0.76e2), SC_(0.95070552825927734375e1), SC_(1.6259075460259942049178264036277075443223749204689e-59) }}, 
      {{ SC_(-0.76e2), SC_(0.24750102996826171875e2), SC_(1.318576118552021545104435738323048727864154201574e-27) }}, 
      {{ SC_(-0.76e2), SC_(0.637722015380859375e2), SC_(332559623.8985721331192076011185438876913669207339) }}, 
      {{ SC_(-0.79e2), SC_(0.177219114266335964202880859375e-2), SC_(3.5354403212019364046063104755631828771883937058006e-354) }}, 
      {{ SC_(-0.79e2), SC_(0.22177286446094512939453125e-2), SC_(1.3978976306615431583515397352566586129978164981083e-346) }}, 
      {{ SC_(-0.79e2), SC_(0.7444499991834163665771484375e-2), SC_(1.4716055261727348172790592652718757218968491250897e-305) }}, 
      {{ SC_(-0.79e2), SC_(0.1433600485324859619140625e-1), SC_(2.3228162360620189257436933252556231587350476505745e-283) }}, 
      {{ SC_(-0.79e2), SC_(0.1760916970670223236083984375e-1), SC_(2.1490805210942587181886096768253317000272047900881e-276) }}, 
      {{ SC_(-0.79e2), SC_(0.6152711808681488037109375e-1), SC_(5.1501240022553382313931109927252352647508033725137e-234) }}, 
      {{ SC_(-0.79e2), SC_(0.11958599090576171875e0), SC_(1.6737997765406598434264054525564444084850592554407e-211) }}, 
      {{ SC_(-0.79e2), SC_(0.15262925624847412109375e0), SC_(3.0789282916516690174719881434864575044336286368998e-203) }}, 
      {{ SC_(-0.79e2), SC_(0.408089816570281982421875e0), SC_(6.36503109275278961131724617973150670884809100085e-170) }}, 
      {{ SC_(-0.79e2), SC_(0.6540834903717041015625e0), SC_(6.0898084719470202787549713824635043238285438147712e-154) }}, 
      {{ SC_(-0.79e2), SC_(0.1097540378570556640625e1), SC_(2.0849489482470412059259293955112926383959218775221e-136) }}, 
      {{ SC_(-0.79e2), SC_(0.30944411754608154296875e1), SC_(2.7755929193923341619599366432165290745895361503068e-101) }}, 
      {{ SC_(-0.79e2), SC_(0.51139926910400390625e1), SC_(3.0498646489259068012138998537230278724083029378205e-84) }}, 
      {{ SC_(-0.79e2), SC_(0.95070552825927734375e1), SC_(3.7822190240734211344697436228310459325646325013602e-63) }}, 
      {{ SC_(-0.79e2), SC_(0.24750102996826171875e2), SC_(5.0763751887669428908160377413843070315272619394593e-30) }}, 
      {{ SC_(-0.79e2), SC_(0.637722015380859375e2), SC_(15509034.088708430442808142776840096102763256428376) }}, 
      {{ SC_(-0.82e2), SC_(0.177219114266335964202880859375e-2), SC_(4.8048862563202889181890537443326779885545248610242e-369) }}, 
      {{ SC_(-0.82e2), SC_(0.22177286446094512939453125e-2), SC_(3.7231325849660746143336380063851346168130573371484e-361) }}, 
      {{ SC_(-0.82e2), SC_(0.7444499991834163665771484375e-2), SC_(1.4825383087772703677121933113230100416009283671034e-318) }}, 
      {{ SC_(-0.82e2), SC_(0.1433600485324859619140625e-1), SC_(1.6711182277052575836893718534668728582756108648312e-295) }}, 
      {{ SC_(-0.82e2), SC_(0.1760916970670223236083984375e-1), SC_(2.8653470065901442471349796594633948569490121927789e-288) }}, 
      {{ SC_(-0.82e2), SC_(0.6152711808681488037109375e-1), SC_(2.9290388140539613063288304116939069775353632716894e-244) }}, 
      {{ SC_(-0.82e2), SC_(0.11958599090576171875e0), SC_(6.989588437838497498633490694257384354295169533204e-221) }}, 
      {{ SC_(-0.82e2), SC_(0.15262925624847412109375e0), SC_(2.6731273786128594995441372203649359993461979500185e-212) }}, 
      {{ SC_(-0.82e2), SC_(0.408089816570281982421875e0), SC_(1.0562510171246344218084352488817570605950194519393e-177) }}, 
      {{ SC_(-0.82e2), SC_(0.6540834903717041015625e0), SC_(4.1609172226269596757660908595807745867150206089336e-161) }}, 
      {{ SC_(-0.82e2), SC_(0.1097540378570556640625e1), SC_(6.7298102679330724106181833447827647907096714047206e-143) }}, 
      {{ SC_(-0.82e2), SC_(0.30944411754608154296875e1), SC_(2.0059377323087951081667274371186273644145227822575e-106) }}, 
      {{ SC_(-0.82e2), SC_(0.51139926910400390625e1), SC_(9.9294186782645320133623704220686212337084869523935e-89) }}, 
      {{ SC_(-0.82e2), SC_(0.95070552825927734375e1), SC_(7.8516737724524765361257804357393329459841050420731e-67) }}, 
      {{ SC_(-0.82e2), SC_(0.24750102996826171875e2), SC_(1.7520334090734988621562311121564391919297578081493e-32) }}, 
      {{ SC_(-0.82e2), SC_(0.637722015380859375e2), SC_(661845.41868057886844507495847825147949109845357718) }}, 
      {{ SC_(-0.85e2), SC_(0.177219114266335964202880859375e-2), SC_(5.8472757925281335709441070120916109604930024452409e-384) }}, 
      {{ SC_(-0.85e2), SC_(0.22177286446094512939453125e-2), SC_(8.8791726773414850912512854292238871639394376398273e-376) }}, 
      {{ SC_(-0.85e2), SC_(0.7444499991834163665771484375e-2), SC_(1.3373691635430932409867433733092264367846631443699e-331) }}, 
      {{ SC_(-0.85e2), SC_(0.1433600485324859619140625e-1), SC_(1.0765404847203446320910822788131070879964149338772e-307) }}, 
      {{ SC_(-0.85e2), SC_(0.1760916970670223236083984375e-1), SC_(3.420838952015165818158018000931089841366043146575e-300) }}, 
      {{ SC_(-0.85e2), SC_(0.6152711808681488037109375e-1), SC_(1.4916380317089088216843268489867077713269951388358e-254) }}, 
      {{ SC_(-0.85e2), SC_(0.11958599090576171875e0), SC_(2.6135488501491766407431161565237945419126408844675e-230) }}, 
      {{ SC_(-0.85e2), SC_(0.15262925624847412109375e0), SC_(2.0781203049030925463263429601388263138063177457416e-221) }}, 
      {{ SC_(-0.85e2), SC_(0.408089816570281982421875e0), SC_(1.5695141280427997758020218417755528490733613885247e-185) }}, 
      {{ SC_(-0.85e2), SC_(0.6540834903717041015625e0), SC_(2.5456984433230137894914413111361227522822484252069e-168) }}, 
      {{ SC_(-0.85e2), SC_(0.1097540378570556640625e1), SC_(1.9451160142029278734236728286821772378084338638687e-149) }}, 
      {{ SC_(-0.85e2), SC_(0.30944411754608154296875e1), SC_(1.2982106047581298813134523396297908278237157397917e-111) }}, 
      {{ SC_(-0.85e2), SC_(0.51139926910400390625e1), SC_(2.8953015092379672002808952081487566053733334541789e-93) }}, 
      {{ SC_(-0.85e2), SC_(0.95070552825927734375e1), SC_(1.4606208585387583821716999258644880230045971888375e-70) }}, 
      {{ SC_(-0.85e2), SC_(0.24750102996826171875e2), SC_(5.4408313801020912656180501212839264038981557151731e-35) }}, 
      {{ SC_(-0.85e2), SC_(0.637722015380859375e2), SC_(25897.152181004517269750138033637774774294027201157) }}, 
      {{ SC_(-0.88e2), SC_(0.177219114266335964202880859375e-2), SC_(6.3967392280596030279323854433032980999361288193673e-399) }}, 
      {{ SC_(-0.88e2), SC_(0.22177286446094512939453125e-2), SC_(1.9035798676765477375707106012504409197237459683134e-390) }}, 
      {{ SC_(-0.88e2), SC_(0.7444499991834163665771484375e-2), SC_(1.0845043229696536816589939558806337747262693806117e-344) }}, 
      {{ SC_(-0.88e2), SC_(0.1433600485324859619140625e-1), SC_(6.2343066307351531677125296908505917958463867368011e-320) }}, 
      {{ SC_(-0.88e2), SC_(0.1760916970670223236083984375e-1), SC_(3.6713233393263255015318969376892728032966858934394e-312) }}, 
      {{ SC_(-0.88e2), SC_(0.6152711808681488037109375e-1), SC_(6.8286740416097889483960253094161116355961137599911e-265) }}, 
      {{ SC_(-0.88e2), SC_(0.11958599090576171875e0), SC_(8.7850510192292171781935576131152961424001837737372e-240) }}, 
      {{ SC_(-0.88e2), SC_(0.15262925624847412109375e0), SC_(1.4523001945931213963724402582050155086750135868739e-230) }}, 
      {{ SC_(-0.88e2), SC_(0.408089816570281982421875e0), SC_(2.0965173883428983962808243031008372953025094614022e-193) }}, 
      {{ SC_(-0.88e2), SC_(0.6540834903717041015625e0), SC_(1.4001057827881787318362535742853637138047693417883e-175) }}, 
      {{ SC_(-0.88e2), SC_(0.1097540378570556640625e1), SC_(5.0539014586103948417980337852169920633032949579937e-156) }}, 
      {{ SC_(-0.88e2), SC_(0.30944411754608154296875e1), SC_(7.5533392148555117094876622598604796141439853510179e-117) }}, 
      {{ SC_(-0.88e2), SC_(0.51139926910400390625e1), SC_(7.5907438126908222770882865866850381553729181510969e-98) }}, 
      {{ SC_(-0.88e2), SC_(0.95070552825927734375e1), SC_(2.4442318532108741067843417039652114734958529194241e-74) }}, 
      {{ SC_(-0.88e2), SC_(0.24750102996826171875e2), SC_(1.5255185376367196961330937653065804471587161182596e-37) }}, 
      {{ SC_(-0.88e2), SC_(0.637722015380859375e2), SC_(930.9184838624792218675752167087125839937752968732) }},
      {{ SC_(-0.0), SC_(-0.177219114266335964202880859375e-2), SC_(-0.00088609591919750015203076551463481289812081759457593) }}, 
      {{ SC_(-0.0), SC_(-0.22177286446094512939453125e-2), SC_(-0.0011088650040236093434924259738776777082777117728366) }}, 
      {{ SC_(-0.0), SC_(-0.7444499991834163665771484375e-2), SC_(-0.003722275782133396649790935284938128705516556817227) }}, 
      {{ SC_(-0.0), SC_(-0.1433600485324859619140625e-1), SC_(-0.0071681865751110609746510378519051273111721075420681) }}, 
      {{ SC_(-0.0), SC_(-0.1760916970670223236083984375e-1), SC_(-0.008804926126614467969087386987026758424777681208949) }}, 
      {{ SC_(-0.0), SC_(-0.6152711808681488037109375e-1), SC_(-0.030778118603049061956303124312187349139104670901298) }}, 
      {{ SC_(-0.0), SC_(-0.11958599090576171875e0), SC_(-0.059899945189311456643393232325528632776126403440763) }}, 
      {{ SC_(-0.0), SC_(-0.15262925624847412109375e0), SC_(-0.076537069171312995155266637603161226785362168868793) }}, 
      {{ SC_(-0.0), SC_(-0.408089816570281982421875e0), SC_(-0.20832212130892514352270120184527358300711621253093) }}, 
      {{ SC_(-0.0), SC_(-0.6540834903717041015625e0), SC_(-0.34484589720660571203268712177657285280507611555709) }}, 
      {{ SC_(-0.0), SC_(-0.1097540378570556640625e1), SC_(-0.63565392939687165931975701385906830196228023376933) }}, 
      {{ SC_(-0.0), SC_(-0.30944411754608154296875e1), SC_(-4.304586767845429639244166020309162877221031947039) }}, 
      {{ SC_(-0.0), SC_(-0.51139926910400390625e1), SC_(-27.026310609828701503222843893102992533224960967973) }}, 
      {{ SC_(-0.0), SC_(-0.95070552825927734375e1), SC_(-1669.6303950934903244727446466214615294086023903195) }}, 
      {{ SC_(-0.0), SC_(-0.24750102996826171875e2), SC_(-4428295881.3677779786815636628866430364992082651157) }}, 
      {{ SC_(-0.0), SC_(-0.637722015380859375e2), SC_(-246567311915704274501887357.24020001512007921147054) }}, 
      {{ SC_(-0.1e1), SC_(-0.177219114266335964202880859375e-2), SC_(0.50000058887414958452485804994744934952377336181573) }}, 
      {{ SC_(-0.1e1), SC_(-0.22177286446094512939453125e-2), SC_(0.50000092218537893261448430232179397590419077630156) }}, 
      {{ SC_(-0.1e1), SC_(-0.7444499991834163665771484375e-2), SC_(0.50001039139876686065339052546517335546246153291185) }}, 
      {{ SC_(-0.1e1), SC_(-0.1433600485324859619140625e-1), SC_(0.50003853574407998926317310663333528092870153852384) }}, 
      {{ SC_(-0.1e1), SC_(-0.1760916970670223236083984375e-1), SC_(0.50005814178781229442302267906313903386120382311391) }}, 
      {{ SC_(-0.1e1), SC_(-0.6152711808681488037109375e-1), SC_(0.50070998404154571459128156447054892961460345184902) }}, 
      {{ SC_(-0.1e1), SC_(-0.11958599090576171875e0), SC_(0.5026840657714710757890236690799629757305465005453) }}, 
      {{ SC_(-0.1e1), SC_(-0.15262925624847412109375e0), SC_(0.50437501291751594265663420039241884122843561276152) }}, 
      {{ SC_(-0.1e1), SC_(-0.408089816570281982421875e0), SC_(0.53158863081248487334362919459520848093354880736601) }}, 
      {{ SC_(-0.1e1), SC_(-0.6540834903717041015625e0), SC_(0.58263043215568911299814886678184475770592474363462) }}, 
      {{ SC_(-0.1e1), SC_(-0.1097540378570556640625e1), SC_(0.7454322330858457449159781361157891562659959168394) }}, 
      {{ SC_(-0.1e1), SC_(-0.30944411754608154296875e1), SC_(3.8794322064706267194422881162259380140744641171029) }}, 
      {{ SC_(-0.1e1), SC_(-0.51139926910400390625e1), SC_(24.879824200109264550070346070548572538675416510962) }}, 
      {{ SC_(-0.1e1), SC_(-0.95070552825927734375e1), SC_(1589.6010892466270146562540500585578585568257598452) }}, 
      {{ SC_(-0.1e1), SC_(-0.24750102996826171875e2), SC_(4341662415.1619366320979220433134729416481099471501) }}, 
      {{ SC_(-0.1e1), SC_(-0.637722015380859375e2), SC_(244657223419722976962060156.64526989576384593438155) }}, 
      {{ SC_(-0.4e1), SC_(-0.177219114266335964202880859375e-2), SC_(-5.7977642791440240594069365123737373446875473336019e-11) }}, 
      {{ SC_(-0.4e1), SC_(-0.22177286446094512939453125e-2), SC_(-1.1361983257670755452088629287120813120498174641957e-10) }}, 
      {{ SC_(-0.4e1), SC_(-0.7444499991834163665771484375e-2), SC_(-4.2977106585064563071965155077470765547580422080236e-09) }}, 
      {{ SC_(-0.4e1), SC_(-0.1433600485324859619140625e-1), SC_(-3.0691624717963766687820586762992955366705538139243e-08) }}, 
      {{ SC_(-0.4e1), SC_(-0.1760916970670223236083984375e-1), SC_(-5.6879465129841838118217352628667866284796929079985e-08) }}, 
      {{ SC_(-0.4e1), SC_(-0.6152711808681488037109375e-1), SC_(-2.4268994701713292881629948960548331673657583324918e-06) }}, 
      {{ SC_(-0.4e1), SC_(-0.11958599090576171875e0), SC_(-1.7833452482002047243884933100474315698557783900753e-05) }}, 
      {{ SC_(-0.4e1), SC_(-0.15262925624847412109375e0), SC_(-3.7102292783677070216850017034917460055257223905384e-05) }}, 
      {{ SC_(-0.4e1), SC_(-0.408089816570281982421875e0), SC_(-0.00071682270806809984142485696566273749789215179247911) }}, 
      {{ SC_(-0.4e1), SC_(-0.6540834903717041015625e0), SC_(-0.0030095810505154039505649035929324233185650471379949) }}, 
      {{ SC_(-0.4e1), SC_(-0.1097540378570556640625e1), SC_(-0.015058380627056309463722070322914223292754890572289) }}, 
      {{ SC_(-0.4e1), SC_(-0.30944411754608154296875e1), SC_(-0.59848912997745095317460689682974327447677370660399) }}, 
      {{ SC_(-0.4e1), SC_(-0.51139926910400390625e1), SC_(-7.1096561414745714565763810157506729038368017958419) }}, 
      {{ SC_(-0.4e1), SC_(-0.95070552825927734375e1), SC_(-765.16515717873090426778318670348842991572055594829) }}, 
      {{ SC_(-0.4e1), SC_(-0.24750102996826171875e2), SC_(-3229907987.7660192457647761075637335091559830439104) }}, 
      {{ SC_(-0.4e1), SC_(-0.637722015380859375e2), SC_(-217726882458479319415712565.5405744792891643352915) }}, 
      {{ SC_(-0.7e1), SC_(-0.177219114266335964202880859375e-2), SC_(3.3614059042626999826433170034673583525940024533365e-22) }}, 
      {{ SC_(-0.7e1), SC_(-0.22177286446094512939453125e-2), SC_(1.2909459381881364762226234760871640013723793229134e-21) }}, 
      {{ SC_(-0.7e1), SC_(-0.7444499991834163665771484375e-2), SC_(1.8470204487525243740480774284818604942655055760685e-18) }}, 
      {{ SC_(-0.7e1), SC_(-0.1433600485324859619140625e-1), SC_(9.4195456714879631145465581060971390240605913016647e-17) }}, 
      {{ SC_(-0.7e1), SC_(-0.1760916970670223236083984375e-1), SC_(3.2351633825752615485614839434982271986658229352008e-16) }}, 
      {{ SC_(-0.7e1), SC_(-0.6152711808681488037109375e-1), SC_(5.8873930260915374674989454237737730208377956367626e-13) }}, 
      {{ SC_(-0.7e1), SC_(-0.11958599090576171875e0), SC_(3.175330254744452869252588114264639853167205817015e-11) }}, 
      {{ SC_(-0.7e1), SC_(-0.15262925624847412109375e0), SC_(1.37306382819489632474481829981320999530458749603e-10) }}, 
      {{ SC_(-0.7e1), SC_(-0.408089816570281982421875e0), SC_(5.0454108730606873004055781144584974598940725268679e-08) }}, 
      {{ SC_(-0.7e1), SC_(-0.6540834903717041015625e0), SC_(8.6439452609012235664132667907912941487867684225691e-07) }}, 
      {{ SC_(-0.7e1), SC_(-0.1097540378570556640625e1), SC_(1.9903149576891282438547022015958250025057830031167e-05) }}, 
      {{ SC_(-0.7e1), SC_(-0.30944411754608154296875e1), SC_(0.01384785426742151623543148483577563767691802604294) }}, 
      {{ SC_(-0.7e1), SC_(-0.51139926910400390625e1), SC_(0.51646140440419256730344781907930371686614842827865) }}, 
      {{ SC_(-0.7e1), SC_(-0.95070552825927734375e1), SC_(159.36813435931220806214715239890071317771114319414) }}, 
      {{ SC_(-0.7e1), SC_(-0.24750102996826171875e2), SC_(1690985569.3106283509427018529720200073122553490215) }}, 
      {{ SC_(-0.7e1), SC_(-0.637722015380859375e2), SC_(168498224714212654572390223.05556865829883060936147) }}, 
      {{ SC_(-0.1e2), SC_(-0.177219114266335964202880859375e-2), SC_(-4.6401508807064011421143230437500824609602971352179e-34) }}, 
      {{ SC_(-0.1e2), SC_(-0.22177286446094512939453125e-2), SC_(-3.4923094749247058078410546677911647554526610700822e-33) }}, 
      {{ SC_(-0.1e2), SC_(-0.7444499991834163665771484375e-2), SC_(-1.8899811421673150137144505161791836254612211618897e-28) }}, 
      {{ SC_(-0.1e2), SC_(-0.1433600485324859619140625e-1), SC_(-6.8832366136666889223518611944268692193585979859144e-26) }}, 
      {{ SC_(-0.1e2), SC_(-0.1760916970670223236083984375e-1), SC_(-4.3811749288152295951419128719224259962904962831792e-25) }}, 
      {{ SC_(-0.1e2), SC_(-0.6152711808681488037109375e-1), SC_(-3.4007993440358828048688277506578232572337801931071e-20) }}, 
      {{ SC_(-0.1e2), SC_(-0.11958599090576171875e0), SC_(-1.3465706671882772570222972249225215948417542289846e-17) }}, 
      {{ SC_(-0.1e2), SC_(-0.15262925624847412109375e0), SC_(-1.2104671718281105291439858586423655467136695739629e-16) }}, 
      {{ SC_(-0.1e2), SC_(-0.408089816570281982421875e0), SC_(-8.4861533427406158688302946175483668209061388974216e-13) }}, 
      {{ SC_(-0.1e2), SC_(-0.6540834903717041015625e0), SC_(-5.9662275860826758024768567630605908594392319370419e-11) }}, 
      {{ SC_(-0.1e2), SC_(-0.1097540378570556640625e1), SC_(-6.4263427651003603907119851552021198456497504370918e-09) }}, 
      {{ SC_(-0.1e2), SC_(-0.30944411754608154296875e1), SC_(-9.0581095107475697200688757844596473845335178799724e-05) }}, 
      {{ SC_(-0.1e2), SC_(-0.51139926910400390625e1), SC_(-0.012810443388044946681969202159228942193660937870026) }}, 
      {{ SC_(-0.1e2), SC_(-0.95070552825927734375e1), SC_(-15.60592527978584992145630257468419287679106228448) }}, 
      {{ SC_(-0.1e2), SC_(-0.24750102996826171875e2), SC_(-627917302.57961419731735233323958352991397820713106) }}, 
      {{ SC_(-0.1e2), SC_(-0.637722015380859375e2), SC_(-113459532318575669036439276.87008888326253509718636) }}, 
      {{ SC_(-0.13e2), SC_(-0.177219114266335964202880859375e-2), SC_(2.4456812841552206198331648276735838307208194344922e-46) }}, 
      {{ SC_(-0.13e2), SC_(-0.22177286446094512939453125e-2), SC_(3.6072314405975860034046247177476173774735736367531e-45) }}, 
      {{ SC_(-0.13e2), SC_(-0.7444499991834163665771484375e-2), SC_(7.3841412140501872128796578303854512307073208188581e-39) }}, 
      {{ SC_(-0.13e2), SC_(-0.1433600485324859619140625e-1), SC_(1.9204924469115190774990181944476141427755118423913e-35) }}, 
      {{ SC_(-0.13e2), SC_(-0.1760916970670223236083984375e-1), SC_(2.265387054446753441806331709049474788648043685053e-34) }}, 
      {{ SC_(-0.13e2), SC_(-0.6152711808681488037109375e-1), SC_(7.5007699710758693280183732287855910132602175813639e-28) }}, 
      {{ SC_(-0.13e2), SC_(-0.11958599090576171875e0), SC_(2.1805434139201279779292196568881545047834755581445e-24) }}, 
      {{ SC_(-0.13e2), SC_(-0.15262925624847412109375e0), SC_(4.0750693309347507669124384883757014786263684741617e-23) }}, 
      {{ SC_(-0.13e2), SC_(-0.408089816570281982421875e0), SC_(5.4554704607395994835687731495288041560338136372535e-18) }}, 
      {{ SC_(-0.13e2), SC_(-0.6540834903717041015625e0), SC_(1.5765156159987458616185208468121472963104447350042e-15) }}, 
      {{ SC_(-0.13e2), SC_(-0.1097540378570556640625e1), SC_(7.9815499244594723489982895111836413560647173692536e-13) }}, 
      {{ SC_(-0.13e2), SC_(-0.30944411754608154296875e1), SC_(2.3892209736758076242780232919452695681175929051865e-07) }}, 
      {{ SC_(-0.13e2), SC_(-0.51139926910400390625e1), SC_(0.00013818222370676455792480764228728714310023991375189) }}, 
      {{ SC_(-0.13e2), SC_(-0.95070552825927734375e1), SC_(0.79222983175956140130590251649409265616457558165901) }}, 
      {{ SC_(-0.13e2), SC_(-0.24750102996826171875e2), SC_(167246140.89233842710493520460530057726331634864968) }}, 
      {{ SC_(-0.13e2), SC_(-0.637722015380859375e2), SC_(66527964895331490665084274.729414759711662772569263) }}, 
      {{ SC_(-0.16e2), SC_(-0.177219114266335964202880859375e-2), SC_(-6.2327384908390204003995267448223005543055023147294e-59) }}, 
      {{ SC_(-0.16e2), SC_(-0.22177286446094512939453125e-2), SC_(-1.8015510900104265741703505220228255217501640996067e-57) }}, 
      {{ SC_(-0.16e2), SC_(-0.7444499991834163665771484375e-2), SC_(-1.3949346528058263997335600963443464048028784827881e-49) }}, 
      {{ SC_(-0.16e2), SC_(-0.1433600485324859619140625e-1), SC_(-2.5908604714318098779930030083499935197035305885449e-45) }}, 
      {{ SC_(-0.16e2), SC_(-0.1760916970670223236083984375e-1), SC_(-5.6637734123262466962398777103859439677795421081841e-44) }}, 
      {{ SC_(-0.16e2), SC_(-0.6152711808681488037109375e-1), SC_(-7.9991945166921338198712046906168540061184875351317e-36) }}, 
      {{ SC_(-0.16e2), SC_(-0.11958599090576171875e0), SC_(-1.7073706303992054301380968751501078313087885491857e-31) }}, 
      {{ SC_(-0.16e2), SC_(-0.15262925624847412109375e0), SC_(-6.6336820967524499048416265672676448776377767154055e-30) }}, 
      {{ SC_(-0.16e2), SC_(-0.408089816570281982421875e0), SC_(-1.6964977370960940867904018220611621037203607694874e-23) }}, 
      {{ SC_(-0.16e2), SC_(-0.6540834903717041015625e0), SC_(-2.0164686264336515855800514562160697497317741039595e-20) }}, 
      {{ SC_(-0.16e2), SC_(-0.1097540378570556640625e1), SC_(-4.8081423013451428446781996718199320667965846227978e-17) }}, 
      {{ SC_(-0.16e2), SC_(-0.30944411754608154296875e1), SC_(-3.1202777146405241319083739284324439475238974819571e-10) }}, 
      {{ SC_(-0.16e2), SC_(-0.51139926910400390625e1), SC_(-7.6506354774553372201041534782782851883589570488462e-07) }}, 
      {{ SC_(-0.16e2), SC_(-0.95070552825927734375e1), SC_(-0.022810518697728430978376653257588972923887424084797) }}, 
      {{ SC_(-0.16e2), SC_(-0.24750102996826171875e2), SC_(-32393686.878233176767714218218026712152488781179032) }}, 
      {{ SC_(-0.16e2), SC_(-0.637722015380859375e2), SC_(-34006044202102043664136930.416215586280411703681407) }}, 
      {{ SC_(-0.19e2), SC_(-0.177219114266335964202880859375e-2), SC_(8.856847980878727795567709967496260001994211357813e-72) }}, 
      {{ SC_(-0.19e2), SC_(-0.22177286446094512939453125e-2), SC_(5.0169572297336366765552303079999295510142794228582e-70) }}, 
      {{ SC_(-0.19e2), SC_(-0.7444499991834163665771484375e-2), SC_(1.4693626716390377205874191389607611038360000766807e-60) }}, 
      {{ SC_(-0.19e2), SC_(-0.1433600485324859619140625e-1), SC_(1.948932524957243795767695206040602854623886866201e-55) }}, 
      {{ SC_(-0.19e2), SC_(-0.1760916970670223236083984375e-1), SC_(7.8957019077757739467283477371739720761027952996169e-54) }}, 
      {{ SC_(-0.19e2), SC_(-0.6152711808681488037109375e-1), SC_(4.7567474718083147260120079391550475135946586430245e-44) }}, 
      {{ SC_(-0.19e2), SC_(-0.11958599090576171875e0), SC_(7.4545320327999783266332919577297460937028986369503e-39) }}, 
      {{ SC_(-0.19e2), SC_(-0.15262925624847412109375e0), SC_(6.0215600365965337916484418240419281309301921804305e-37) }}, 
      {{ SC_(-0.19e2), SC_(-0.408089816570281982421875e0), SC_(2.9423333728004908601963916644442366115689862806536e-29) }}, 
      {{ SC_(-0.19e2), SC_(-0.6540834903717041015625e0), SC_(1.438974209129641647167542567221369367211385506464e-25) }}, 
      {{ SC_(-0.19e2), SC_(-0.1097540378570556640625e1), SC_(1.6176424036200185444597270593787016246601449964642e-21) }}, 
      {{ SC_(-0.19e2), SC_(-0.30944411754608154296875e1), SC_(2.3004460236761897065652511082313592519092019184042e-13) }}, 
      {{ SC_(-0.19e2), SC_(-0.51139926910400390625e1), SC_(2.4385852987632722455536745570114716849056311307068e-09) }}, 
      {{ SC_(-0.19e2), SC_(-0.95070552825927734375e1), SC_(0.00040156165740344595105598595665264806808695248156959) }}, 
      {{ SC_(-0.19e2), SC_(-0.24750102996826171875e2), SC_(4632725.6880069349564692619191717692091439317967541) }}, 
      {{ SC_(-0.19e2), SC_(-0.637722015380859375e2), SC_(15173140165934437399551589.526356192163119956440712) }}, 
      {{ SC_(-0.22e2), SC_(-0.177219114266335964202880859375e-2), SC_(-7.7217901410693911227150913672524759201196903075688e-85) }}, 
      {{ SC_(-0.22e2), SC_(-0.22177286446094512939453125e-2), SC_(-8.5718139057074217885771301419152193014974567068691e-83) }}, 
      {{ SC_(-0.22e2), SC_(-0.7444499991834163665771484375e-2), SC_(-9.4960431304778410076342752912829121300498851551588e-72) }}, 
      {{ SC_(-0.22e2), SC_(-0.1433600485324859619140625e-1), SC_(-8.9947307650224396323985283241561562881690883036141e-66) }}, 
      {{ SC_(-0.22e2), SC_(-0.1760916970670223236083984375e-1), SC_(-6.7532719454852858707274844730590110322055354201261e-64) }}, 
      {{ SC_(-0.22e2), SC_(-0.6152711808681488037109375e-1), SC_(-1.7354564445702626586581450469447089808517451686261e-52) }}, 
      {{ SC_(-0.22e2), SC_(-0.11958599090576171875e0), SC_(-1.9968997630414801171372011643368703808933684536787e-46) }}, 
      {{ SC_(-0.22e2), SC_(-0.15262925624847412109375e0), SC_(-3.3535879185247440495559628765042054556736832009973e-44) }}, 
      {{ SC_(-0.22e2), SC_(-0.408089816570281982421875e0), SC_(-3.1312999792630543963468112049134819584201438113638e-35) }}, 
      {{ SC_(-0.22e2), SC_(-0.6540834903717041015625e0), SC_(-6.3022559148540593979809071511297179643355284388908e-31) }}, 
      {{ SC_(-0.22e2), SC_(-0.1097540378570556640625e1), SC_(-3.3421661563818918027248621563705615930961800683724e-26) }}, 
      {{ SC_(-0.22e2), SC_(-0.30944411754608154296875e1), SC_(-1.0480943588467369123564849816161014309504231224117e-16) }}, 
      {{ SC_(-0.22e2), SC_(-0.51139926910400390625e1), SC_(-4.8601470687452747654791579038432653167991722888448e-12) }}, 
      {{ SC_(-0.22e2), SC_(-0.95070552825927734375e1), SC_(-4.5932604866635780945986211206328686104317827785376e-06) }}, 
      {{ SC_(-0.22e2), SC_(-0.24750102996826171875e2), SC_(-497042.99880985683333764499216941722667112029683176) }}, 
      {{ SC_(-0.22e2), SC_(-0.637722015380859375e2), SC_(-5918880046023104655771352.6782237242901860852317783) }}, 
      {{ SC_(-0.25e2), SC_(-0.177219114266335964202880859375e-2), SC_(4.4238249306786722714380053705078343362120752233109e-98) }}, 
      {{ SC_(-0.25e2), SC_(-0.22177286446094512939453125e-2), SC_(9.6237914479471191558965141844862721081442175321339e-96) }}, 
      {{ SC_(-0.25e2), SC_(-0.7444499991834163665771484375e-2), SC_(4.0327147045865958831583298860742024446331120501667e-83) }}, 
      {{ SC_(-0.25e2), SC_(-0.1433600485324859619140625e-1), SC_(2.7278514060116473582575283637948648247484666198626e-76) }}, 
      {{ SC_(-0.25e2), SC_(-0.1760916970670223236083984375e-1), SC_(3.7955868337522424942465659748636599881281084954936e-74) }}, 
      {{ SC_(-0.25e2), SC_(-0.6152711808681488037109375e-1), SC_(4.1606316754451939513934325687032936781084709557174e-61) }}, 
      {{ SC_(-0.25e2), SC_(-0.11958599090576171875e0), SC_(3.5150887159712265449519995061242180635458855716543e-54) }}, 
      {{ SC_(-0.25e2), SC_(-0.15262925624847412109375e0), SC_(1.2273160435814530154216756907909730168133408979354e-51) }}, 
      {{ SC_(-0.25e2), SC_(-0.408089816570281982421875e0), SC_(2.1899473435503006448341914230207856810704869083032e-41) }}, 
      {{ SC_(-0.25e2), SC_(-0.6540834903717041015625e0), SC_(1.8141376468185006270177034679423087959304460589198e-36) }}, 
      {{ SC_(-0.25e2), SC_(-0.1097540378570556640625e1), SC_(4.5401256012481338865917719171873814815455419943788e-31) }}, 
      {{ SC_(-0.25e2), SC_(-0.30944411754608154296875e1), SC_(3.1521962466413116247808110835949674611594155007853e-20) }}, 
      {{ SC_(-0.25e2), SC_(-0.51139926910400390625e1), SC_(6.4427073157520072840733338491592423980722282978731e-15) }}, 
      {{ SC_(-0.25e2), SC_(-0.95070552825927734375e1), SC_(3.5857709467233735521574525635843083962184714996389e-08) }}, 
      {{ SC_(-0.25e2), SC_(-0.24750102996826171875e2), SC_(40647.830055777630614853496513882487464182612659778) }}, 
      {{ SC_(-0.25e2), SC_(-0.637722015380859375e2), SC_(2022150557561339396583620.7453516199727862155230984) }}, 
      {{ SC_(-0.28e2), SC_(-0.177219114266335964202880859375e-2), SC_(-1.7537290958183525886359463869845381510727973831423e-111) }}, 
      {{ SC_(-0.28e2), SC_(-0.22177286446094512939453125e-2), SC_(-7.4766028276759785646169118728086334339479138785121e-109) }}, 
      {{ SC_(-0.28e2), SC_(-0.7444499991834163665771484375e-2), SC_(-1.185050791595980297563816416170548017342823596371e-94) }}, 
      {{ SC_(-0.28e2), SC_(-0.1433600485324859619140625e-1), SC_(-5.724504710844555403747096938161237570505164025639e-87) }}, 
      {{ SC_(-0.28e2), SC_(-0.1760916970670223236083984375e-1), SC_(-1.4761425734303275112655245061072381804432607379419e-84) }}, 
      {{ SC_(-0.28e2), SC_(-0.6152711808681488037109375e-1), SC_(-6.9022390374891292355576926730504869388918678954679e-70) }}, 
      {{ SC_(-0.28e2), SC_(-0.11958599090576171875e0), SC_(-4.2815692363419751017394375328880217150827975972142e-62) }}, 
      {{ SC_(-0.28e2), SC_(-0.15262925624847412109375e0), SC_(-3.1080718605471868275638552768574431110418784071503e-59) }}, 
      {{ SC_(-0.28e2), SC_(-0.408089816570281982421875e0), SC_(-1.0598656166823514975648552246910002876529662767461e-47) }}, 
      {{ SC_(-0.28e2), SC_(-0.6540834903717041015625e0), SC_(-3.6140105230831318695326639669307447887819511019234e-42) }}, 
      {{ SC_(-0.28e2), SC_(-0.1097540378570556640625e1), SC_(-4.2693528244885788297255064309997960048365291014026e-36) }}, 
      {{ SC_(-0.28e2), SC_(-0.30944411754608154296875e1), SC_(-6.5802864120266680645515881946834747879356034935864e-24) }}, 
      {{ SC_(-0.28e2), SC_(-0.51139926910400390625e1), SC_(-5.9585045673303143108135339499940553485447088632098e-18) }}, 
      {{ SC_(-0.28e2), SC_(-0.95070552825927734375e1), SC_(-1.988438534646550878842883479897113184558083848306e-10) }}, 
      {{ SC_(-0.28e2), SC_(-0.24750102996826171875e2), SC_(-2573.1411287700232846977353121103361460322486488431) }}, 
      {{ SC_(-0.28e2), SC_(-0.637722015380859375e2), SC_(-606232660335704409810090.03657524411661636232787034) }}, 
      {{ SC_(-0.31e2), SC_(-0.177219114266335964202880859375e-2), SC_(5.0087219126383253324349380172860487566432855139685e-125) }}, 
      {{ SC_(-0.31e2), SC_(-0.22177286446094512939453125e-2), SC_(4.1846800213041264338919690624948669793769364574766e-122) }}, 
      {{ SC_(-0.31e2), SC_(-0.7444499991834163665771484375e-2), SC_(2.5088591078901587717390863274703893752606853061857e-106) }}, 
      {{ SC_(-0.31e2), SC_(-0.1433600485324859619140625e-1), SC_(8.6547590603242990949702115694256363867835406572861e-98) }}, 
      {{ SC_(-0.31e2), SC_(-0.1760916970670223236083984375e-1), SC_(4.1359715994078682698876915805253118998897861437516e-95) }}, 
      {{ SC_(-0.31e2), SC_(-0.6152711808681488037109375e-1), SC_(8.2493728361189737866670383445494981400106230153243e-79) }}, 
      {{ SC_(-0.31e2), SC_(-0.11958599090576171875e0), SC_(3.7572570366945474616179276146698625977888359329743e-70) }}, 
      {{ SC_(-0.31e2), SC_(-0.15262925624847412109375e0), SC_(5.670584642447869741263362302156653059738229151679e-67) }}, 
      {{ SC_(-0.31e2), SC_(-0.408089816570281982421875e0), SC_(3.6955941921570070467273719291388407719278944905994e-54) }}, 
      {{ SC_(-0.31e2), SC_(-0.6540834903717041015625e0), SC_(5.1874128673494756833392144870922666768391511767402e-48) }}, 
      {{ SC_(-0.31e2), SC_(-0.1097540378570556640625e1), SC_(2.8931790681890152449929455935946929857333580509535e-41) }}, 
      {{ SC_(-0.31e2), SC_(-0.30944411754608154296875e1), SC_(9.9178101387254123888824302991706578879838598783839e-28) }}, 
      {{ SC_(-0.31e2), SC_(-0.51139926910400390625e1), SC_(3.9932674715594104964128503446033838147659504667162e-21) }}, 
      {{ SC_(-0.31e2), SC_(-0.95070552825927734375e1), SC_(8.0950989569301632461640932495000811369058776548288e-13) }}, 
      {{ SC_(-0.31e2), SC_(-0.24750102996826171875e2), SC_(127.94850241485772130585495761695068677510628272) }}, 
      {{ SC_(-0.31e2), SC_(-0.637722015380859375e2), SC_(159817594923140342623291.20398499833703669395963482) }}, 
      {{ SC_(-0.34e2), SC_(-0.177219114266335964202880859375e-2), SC_(-1.0644934780176950962560394681532225849773680058709e-138) }}, 
      {{ SC_(-0.34e2), SC_(-0.22177286446094512939453125e-2), SC_(-1.7428976035917544129989302428497194913138579202666e-135) }}, 
      {{ SC_(-0.34e2), SC_(-0.7444499991834163665771484375e-2), SC_(-3.9524579403269171803369385637558217271264775288375e-118) }}, 
      {{ SC_(-0.34e2), SC_(-0.1433600485324859619140625e-1), SC_(-9.7369678001635573545503110129537132135591038708835e-109) }}, 
      {{ SC_(-0.34e2), SC_(-0.1760916970670223236083984375e-1), SC_(-8.6233990620942755154548731208557667522524325271062e-106) }}, 
      {{ SC_(-0.34e2), SC_(-0.6152711808681488037109375e-1), SC_(-7.3367515832609213979608708078032887331893716760878e-88) }}, 
      {{ SC_(-0.34e2), SC_(-0.11958599090576171875e0), SC_(-2.4535309861100621118404676470270001610755173253095e-78) }}, 
      {{ SC_(-0.34e2), SC_(-0.15262925624847412109375e0), SC_(-7.6987103226204474228299710459354001986872971425418e-75) }}, 
      {{ SC_(-0.34e2), SC_(-0.408089816570281982421875e0), SC_(-9.5891796438704037962550024950686831416871263944065e-61) }}, 
      {{ SC_(-0.34e2), SC_(-0.6540834903717041015625e0), SC_(-5.5410848148483629243991325407653364478861508321096e-54) }}, 
      {{ SC_(-0.34e2), SC_(-0.1097540378570556640625e1), SC_(-1.4592416702058255678868869069288933084584122765773e-46) }}, 
      {{ SC_(-0.34e2), SC_(-0.30944411754608154296875e1), SC_(-1.1141017553235972731179105495808947512528737037098e-31) }}, 
      {{ SC_(-0.34e2), SC_(-0.51139926910400390625e1), SC_(-1.9999533014515442664410514640311352029537737796512e-24) }}, 
      {{ SC_(-0.34e2), SC_(-0.95070552825927734375e1), SC_(-2.4868440390774050554114069080662971673947902623961e-15) }}, 
      {{ SC_(-0.34e2), SC_(-0.24750102996826171875e2), SC_(-5.06656357626145066912681718080220258943729401784) }}, 
      {{ SC_(-0.34e2), SC_(-0.637722015380859375e2), SC_(-37130522340900238142758.905822881447034320072942124) }}, 
      {{ SC_(-0.37e2), SC_(-0.177219114266335964202880859375e-2), SC_(1.7287621278190839370590687031994130921705203027731e-152) }}, 
      {{ SC_(-0.37e2), SC_(-0.22177286446094512939453125e-2), SC_(5.546993284567881066610530840898852183064493438262e-149) }}, 
      {{ SC_(-0.37e2), SC_(-0.7444499991834163665771484375e-2), SC_(4.7581090814519782725042999839536478983860958645142e-130) }}, 
      {{ SC_(-0.37e2), SC_(-0.1433600485324859619140625e-1), SC_(8.3708323995790324303958763893727680473342532914197e-120) }}, 
      {{ SC_(-0.37e2), SC_(-0.1760916970670223236083984375e-1), SC_(1.3739014672168454406680073367182205099607148197632e-116) }}, 
      {{ SC_(-0.37e2), SC_(-0.6152711808681488037109375e-1), SC_(4.9861237392471978055003726862508643829847162252575e-97) }}, 
      {{ SC_(-0.37e2), SC_(-0.11958599090576171875e0), SC_(1.2243035655778619905636683889063047401519062606425e-86) }}, 
      {{ SC_(-0.37e2), SC_(-0.15262925624847412109375e0), SC_(7.9870340394199891721115345149816582762740029243384e-83) }}, 
      {{ SC_(-0.37e2), SC_(-0.408089816570281982421875e0), SC_(1.9013576951182169806853947255296139623785576186916e-67) }}, 
      {{ SC_(-0.37e2), SC_(-0.6540834903717041015625e0), SC_(4.5231204964283367350579123529524644256173276796902e-60) }}, 
      {{ SC_(-0.37e2), SC_(-0.1097540378570556640625e1), SC_(5.6249756162264798875230713047050389930739501783392e-52) }}, 
      {{ SC_(-0.37e2), SC_(-0.30944411754608154296875e1), SC_(9.5747313181559510960653928485860835096410763339761e-36) }}, 
      {{ SC_(-0.37e2), SC_(-0.51139926910400390625e1), SC_(7.67859806352689356386823578607221058376012844798e-28) }}, 
      {{ SC_(-0.37e2), SC_(-0.95070552825927734375e1), SC_(5.9001858858606893937118814413721912920024394022728e-18) }}, 
      {{ SC_(-0.37e2), SC_(-0.24750102996826171875e2), SC_(0.16182031803861277979226848786561421115178084390837) }}, 
      {{ SC_(-0.37e2), SC_(-0.637722015380859375e2), SC_(7620156925871909004013.4511789819332608090859149484) }}, 
      {{ SC_(-0.4e2), SC_(-0.177219114266335964202880859375e-2), SC_(-2.1934463145098982856482722894618772007386408955866e-166) }}, 
      {{ SC_(-0.4e2), SC_(-0.22177286446094512939453125e-2), SC_(-1.3792498395120423934684486452597604404348707842772e-162) }}, 
      {{ SC_(-0.4e2), SC_(-0.7444499991834163665771484375e-2), SC_(-4.4750827254189778755330436710326506163523889802085e-142) }}, 
      {{ SC_(-0.4e2), SC_(-0.1433600485324859619140625e-1), SC_(-5.6222881809274427763875173260632408250704436858785e-131) }}, 
      {{ SC_(-0.4e2), SC_(-0.1760916970670223236083984375e-1), SC_(-1.7101422547443159905114096833775090592290767321829e-127) }}, 
      {{ SC_(-0.4e2), SC_(-0.6152711808681488037109375e-1), SC_(-2.6474147397607258550183244427472642118161245275487e-106) }}, 
      {{ SC_(-0.4e2), SC_(-0.11958599090576171875e0), SC_(-4.7729492236342102509017782812387711881706287458449e-95) }}, 
      {{ SC_(-0.4e2), SC_(-0.15262925624847412109375e0), SC_(-6.4737153699907991293058554021804873987255762728477e-91) }}, 
      {{ SC_(-0.4e2), SC_(-0.408089816570281982421875e0), SC_(-2.9454570864564136977420322683387112229627476337539e-74) }}, 
      {{ SC_(-0.4e2), SC_(-0.6540834903717041015625e0), SC_(-2.8846886509171748574863377735521386214202206755858e-66) }}, 
      {{ SC_(-0.4e2), SC_(-0.1097540378570556640625e1), SC_(-1.6941972001909998208906812347963350453047191654302e-57) }}, 
      {{ SC_(-0.4e2), SC_(-0.30944411754608154296875e1), SC_(-6.4346689071340193649227713397841966987433720786189e-40) }}, 
      {{ SC_(-0.4e2), SC_(-0.51139926910400390625e1), SC_(-2.3089841179919606378679849343539819497749439614471e-31) }}, 
      {{ SC_(-0.4e2), SC_(-0.95070552825927734375e1), SC_(-1.102736347295864305334545583894581762444979228683e-20) }}, 
      {{ SC_(-0.4e2), SC_(-0.24750102996826171875e2), SC_(-0.0042179636760203964867503418195156015892913194089181) }}, 
      {{ SC_(-0.4e2), SC_(-0.637722015380859375e2), SC_(-1384718401734132335251.2307161144249865361826025353) }}, 
      {{ SC_(-0.43e2), SC_(-0.177219114266335964202880859375e-2), SC_(2.2155194558806744336118853845894526377597755033613e-180) }}, 
      {{ SC_(-0.43e2), SC_(-0.22177286446094512939453125e-2), SC_(2.7301407262855693718808358405067536530151961222709e-176) }}, 
      {{ SC_(-0.43e2), SC_(-0.7444499991834163665771484375e-2), SC_(3.3506150347288365485455030173519989511162460227522e-154) }}, 
      {{ SC_(-0.43e2), SC_(-0.1433600485324859619140625e-1), SC_(3.0061756609377494048964736743144427129003213203223e-142) }}, 
      {{ SC_(-0.43e2), SC_(-0.1760916970670223236083984375e-1), SC_(1.6945940912316967428473837149944892562616754985489e-138) }}, 
      {{ SC_(-0.43e2), SC_(-0.6152711808681488037109375e-1), SC_(1.1190199437049647148982314787349308670836083412719e-115) }}, 
      {{ SC_(-0.43e2), SC_(-0.11958599090576171875e0), SC_(1.4812957404734739372437378368931490462014921889916e-103) }}, 
      {{ SC_(-0.43e2), SC_(-0.15262925624847412109375e0), SC_(4.1771418376583419694971373044913302025322339896609e-99) }}, 
      {{ SC_(-0.43e2), SC_(-0.408089816570281982421875e0), SC_(3.6324851051777819272129739809658943871874407487028e-81) }}, 
      {{ SC_(-0.43e2), SC_(-0.6540834903717041015625e0), SC_(1.4646390194930429146922835980901944721928096243995e-72) }}, 
      {{ SC_(-0.43e2), SC_(-0.1097540378570556640625e1), SC_(4.0625964334686726052275084650431825087265178224124e-63) }}, 
      {{ SC_(-0.43e2), SC_(-0.30944411754608154296875e1), SC_(3.445055402147930375877257131921015119606512508245e-44) }}, 
      {{ SC_(-0.43e2), SC_(-0.51139926910400390625e1), SC_(5.5381687600583444906926687040881418784943267264745e-35) }}, 
      {{ SC_(-0.43e2), SC_(-0.95070552825927734375e1), SC_(1.6515029191453376830894919269624334980950396009178e-23) }}, 
      {{ SC_(-0.43e2), SC_(-0.24750102996826171875e2), SC_(9.07033473684436819050490950252432930934152092096e-05) }}, 
      {{ SC_(-0.43e2), SC_(-0.637722015380859375e2), SC_(223349833220390199450.27662394978391334765490925711) }}, 
      {{ SC_(-0.46e2), SC_(-0.177219114266335964202880859375e-2), SC_(-1.8104378462921870510073243689353670043465780417572e-194) }}, 
      {{ SC_(-0.46e2), SC_(-0.22177286446094512939453125e-2), SC_(-4.3720650768675253652563392243562531036087038645837e-190) }}, 
      {{ SC_(-0.46e2), SC_(-0.7444499991834163665771484375e-2), SC_(-2.0295861561067542761383038303516665614408092929621e-166) }}, 
      {{ SC_(-0.46e2), SC_(-0.1433600485324859619140625e-1), SC_(-1.3003944406199447796291213829678693617876885669235e-153) }}, 
      {{ SC_(-0.46e2), SC_(-0.1760916970670223236083984375e-1), SC_(-1.358496858602096893203295098466102421151497813062e-149) }}, 
      {{ SC_(-0.46e2), SC_(-0.6152711808681488037109375e-1), SC_(-3.8266017294469036713813054977133414550613357620995e-125) }}, 
      {{ SC_(-0.46e2), SC_(-0.11958599090576171875e0), SC_(-3.7192605471161617718716878121485601007325143417766e-112) }}, 
      {{ SC_(-0.46e2), SC_(-0.15262925624847412109375e0), SC_(-2.1805444805077346331288545875784651786026586254492e-107) }}, 
      {{ SC_(-0.46e2), SC_(-0.408089816570281982421875e0), SC_(-3.6242559912380282003067476102750491997093042839905e-88) }}, 
      {{ SC_(-0.46e2), SC_(-0.6540834903717041015625e0), SC_(-6.0163489655614054743164061525225632154707225487227e-79) }}, 
      {{ SC_(-0.46e2), SC_(-0.1097540378570556640625e1), SC_(-7.8819672414759206147861166344933846001601735395384e-69) }}, 
      {{ SC_(-0.46e2), SC_(-0.30944411754608154296875e1), SC_(-1.4930590833870162213775836764629326071792693829531e-48) }}, 
      {{ SC_(-0.46e2), SC_(-0.51139926910400390625e1), SC_(-1.0763470713262935904456505724516010574972799879661e-38) }}, 
      {{ SC_(-0.46e2), SC_(-0.95070552825927734375e1), SC_(-2.0115846220319402838816743576250278175262193057597e-26) }}, 
      {{ SC_(-0.46e2), SC_(-0.24750102996826171875e2), SC_(-1.6252200145822910970533586273353022511176623102534e-06) }}, 
      {{ SC_(-0.46e2), SC_(-0.637722015380859375e2), SC_(-32056296975334433492.887437331135099409690999530645) }}, 
      {{ SC_(-0.49e2), SC_(-0.177219114266335964202880859375e-2), SC_(1.2137476169035449224165111313052760780577498154495e-208) }}, 
      {{ SC_(-0.49e2), SC_(-0.22177286446094512939453125e-2), SC_(5.744138736848391561405561566827001406807628730672e-204) }}, 
      {{ SC_(-0.49e2), SC_(-0.7444499991834163665771484375e-2), SC_(1.0086190601725809485592749250036950039156412980801e-178) }}, 
      {{ SC_(-0.49e2), SC_(-0.1433600485324859619140625e-1), SC_(4.6150092654244014484753439347715293478138962384071e-165) }}, 
      {{ SC_(-0.49e2), SC_(-0.1760916970670223236083984375e-1), SC_(8.9348715778263801065552292828264974327479981243026e-161) }}, 
      {{ SC_(-0.49e2), SC_(-0.6152711808681488037109375e-1), SC_(1.073557969060502670244818681362437101258532544188e-134) }}, 
      {{ SC_(-0.49e2), SC_(-0.11958599090576171875e0), SC_(7.6614056528546695457433049939650076449807425863572e-121) }}, 
      {{ SC_(-0.49e2), SC_(-0.15262925624847412109375e0), SC_(9.3387316510569269729588388217209165125692830551503e-116) }}, 
      {{ SC_(-0.49e2), SC_(-0.408089816570281982421875e0), SC_(2.9667037180399959712795194068438806052231435377161e-95) }}, 
      {{ SC_(-0.49e2), SC_(-0.6540834903717041015625e0), SC_(2.027595514156380296893790154872960085404285710906e-85) }}, 
      {{ SC_(-0.49e2), SC_(-0.1097540378570556640625e1), SC_(1.254665875782490153416445484836172524618855505355e-74) }}, 
      {{ SC_(-0.49e2), SC_(-0.30944411754608154296875e1), SC_(5.3112767401349998228922034188767491632135108874701e-53) }}, 
      {{ SC_(-0.49e2), SC_(-0.51139926910400390625e1), SC_(1.7184230106399633928374634149552055310832862291052e-42) }}, 
      {{ SC_(-0.49e2), SC_(-0.95070552825927734375e1), SC_(2.0188620523288691423046930654162370151184157582571e-29) }}, 
      {{ SC_(-0.49e2), SC_(-0.24750102996826171875e2), SC_(2.4486900820026561561243390823793236131043274568681e-08) }}, 
      {{ SC_(-0.49e2), SC_(-0.637722015380859375e2), SC_(4104203373731508351.8091124505391567563692298373867) }}, 
      {{ SC_(-0.52e2), SC_(-0.177219114266335964202880859375e-2), SC_(-6.7582433736913603419058059256135791361735470637909e-223) }}, 
      {{ SC_(-0.52e2), SC_(-0.22177286446094512939453125e-2), SC_(-6.2679264331526494370328882789831359414684776971336e-218) }}, 
      {{ SC_(-0.52e2), SC_(-0.7444499991834163665771484375e-2), SC_(-4.1630106067711993660903358738294501375369753249879e-191) }}, 
      {{ SC_(-0.52e2), SC_(-0.1433600485324859619140625e-1), SC_(-1.3602875417470081410985454428401245372759992414993e-176) }}, 
      {{ SC_(-0.52e2), SC_(-0.1760916970670223236083984375e-1), SC_(-4.8806612177325115813521165986700318378662496250041e-172) }}, 
      {{ SC_(-0.52e2), SC_(-0.6152711808681488037109375e-1), SC_(-2.5014882661113533293597761965233330461237158797651e-144) }}, 
      {{ SC_(-0.52e2), SC_(-0.11958599090576171875e0), SC_(-1.3107541196311674615336229789222782210248645345988e-129) }}, 
      {{ SC_(-0.52e2), SC_(-0.15262925624847412109375e0), SC_(-3.321788061274790179806750754248969443658942707425e-124) }}, 
      {{ SC_(-0.52e2), SC_(-0.408089816570281982421875e0), SC_(-2.0169405302622672394567009913765725797440815303228e-102) }}, 
      {{ SC_(-0.52e2), SC_(-0.6540834903717041015625e0), SC_(-5.6754178832405837953514458701036195191657065470066e-92) }}, 
      {{ SC_(-0.52e2), SC_(-0.1097540378570556640625e1), SC_(-1.6588360861872987132698768619041215273305353601283e-80) }}, 
      {{ SC_(-0.52e2), SC_(-0.30944411754608154296875e1), SC_(-1.5698207694417899021446502648229999500768660780745e-57) }}, 
      {{ SC_(-0.52e2), SC_(-0.51139926910400390625e1), SC_(-2.2810052462334100092981477624289897510531514533963e-46) }}, 
      {{ SC_(-0.52e2), SC_(-0.95070552825927734375e1), SC_(-1.6888264677784034501755356452466192541124575722402e-32) }}, 
      {{ SC_(-0.52e2), SC_(-0.24750102996826171875e2), SC_(-3.1284554770212266533654823889614535495011507388997e-10) }}, 
      {{ SC_(-0.52e2), SC_(-0.637722015380859375e2), SC_(-469912526052398293.17302112716282663456985359455793) }}, 
      {{ SC_(-0.55e2), SC_(-0.177219114266335964202880859375e-2), SC_(3.1593849990997961977974943812146816685612063609753e-237) }}, 
      {{ SC_(-0.55e2), SC_(-0.22177286446094512939453125e-2), SC_(5.7423035662670156701155774883438821586276792733737e-232) }}, 
      {{ SC_(-0.55e2), SC_(-0.7444499991834163665771484375e-2), SC_(1.4426173536899176398539280108006290466380469104659e-203) }}, 
      {{ SC_(-0.55e2), SC_(-0.1433600485324859619140625e-1), SC_(3.3662948625298628408893789499302767949884611521748e-188) }}, 
      {{ SC_(-0.55e2), SC_(-0.1760916970670223236083984375e-1), SC_(2.2383721988438966126895088423110749261179727739443e-183) }}, 
      {{ SC_(-0.55e2), SC_(-0.6152711808681488037109375e-1), SC_(4.8936711651864414231989567585154845915532624571577e-154) }}, 
      {{ SC_(-0.55e2), SC_(-0.11958599090576171875e0), SC_(1.8827710109688701937429883606767323358888834986806e-138) }}, 
      {{ SC_(-0.55e2), SC_(-0.15262925624847412109375e0), SC_(9.9201804930062867946547900039207204930607095294563e-133) }}, 
      {{ SC_(-0.55e2), SC_(-0.408089816570281982421875e0), SC_(1.1512714886725383721018856342861659745765144062983e-109) }}, 
      {{ SC_(-0.55e2), SC_(-0.6540834903717041015625e0), SC_(1.3337792351351849232556965484782506374204938471942e-98) }}, 
      {{ SC_(-0.55e2), SC_(-0.1097540378570556640625e1), SC_(1.8414497718532141402443858594087036395047321320979e-86) }}, 
      {{ SC_(-0.55e2), SC_(-0.30944411754608154296875e1), SC_(3.8967726654446097204350019896316737688338122273432e-62) }}, 
      {{ SC_(-0.55e2), SC_(-0.51139926910400390625e1), SC_(2.5442972422456580268434830211595319738276544262809e-50) }}, 
      {{ SC_(-0.55e2), SC_(-0.95070552825927734375e1), SC_(1.1896599721367974831559089457000349605850672303126e-35) }}, 
      {{ SC_(-0.55e2), SC_(-0.24750102996826171875e2), SC_(3.4154599781777805873676342450915281728506074263741e-12) }}, 
      {{ SC_(-0.55e2), SC_(-0.637722015380859375e2), SC_(48234457604444740.335143147971511893573254691716282) }}, 
      {{ SC_(-0.58e2), SC_(-0.177219114266335964202880859375e-2), SC_(-1.2520413645388569928887958112848204212138063461708e-251) }}, 
      {{ SC_(-0.58e2), SC_(-0.22177286446094512939453125e-2), SC_(-4.4595989634686150568429251044625228423529401458671e-246) }}, 
      {{ SC_(-0.58e2), SC_(-0.7444499991834163665771484375e-2), SC_(-4.2378168989917621180007953130186366290981620423231e-216) }}, 
      {{ SC_(-0.58e2), SC_(-0.1433600485324859619140625e-1), SC_(-7.0618906988802236107307134052564237747614610667347e-200) }}, 
      {{ SC_(-0.58e2), SC_(-0.1760916970670223236083984375e-1), SC_(-8.702285916071814227807807229418309354595552484574e-195) }}, 
      {{ SC_(-0.58e2), SC_(-0.6152711808681488037109375e-1), SC_(-8.1155609568253125349091276265266629388793969141888e-164) }}, 
      {{ SC_(-0.58e2), SC_(-0.11958599090576171875e0), SC_(-2.2925633886147348167887929308708443895271449574002e-147) }}, 
      {{ SC_(-0.58e2), SC_(-0.15262925624847412109375e0), SC_(-2.5113943794105648062440017015132938005891936086402e-141) }}, 
      {{ SC_(-0.58e2), SC_(-0.408089816570281982421875e0), SC_(-5.5707269509534084668880316016301521365616605779226e-117) }}, 
      {{ SC_(-0.58e2), SC_(-0.6540834903717041015625e0), SC_(-2.657190957474252490339745093174279959587302920337e-105) }}, 
      {{ SC_(-0.58e2), SC_(-0.1097540378570556640625e1), SC_(-1.7329204095864388145245624373544625363852920610294e-92) }}, 
      {{ SC_(-0.58e2), SC_(-0.30944411754608154296875e1), SC_(-8.2021165289716639245472391886116444446565644799576e-67) }}, 
      {{ SC_(-0.58e2), SC_(-0.51139926910400390625e1), SC_(-2.4075702286581099190297646954055364849049383370423e-54) }}, 
      {{ SC_(-0.58e2), SC_(-0.95070552825927734375e1), SC_(-7.1220189825823412856021938995136401566994991595578e-39) }}, 
      {{ SC_(-0.58e2), SC_(-0.24750102996826171875e2), SC_(-3.2090378383167806078759489925206593790671983259232e-14) }}, 
      {{ SC_(-0.58e2), SC_(-0.637722015380859375e2), SC_(-4449584424751920.8125944951606147809737782831249622) }}, 
      {{ SC_(-0.61e2), SC_(-0.177219114266335964202880859375e-2), SC_(4.2425710020331914252821718283968275084437170049519e-266) }}, 
      {{ SC_(-0.61e2), SC_(-0.22177286446094512939453125e-2), SC_(2.9614184695203394581083532929114208408300940116942e-260) }}, 
      {{ SC_(-0.61e2), SC_(-0.7444499991834163665771484375e-2), SC_(1.0644555775598225924016923665182010252785388717882e-228) }}, 
      {{ SC_(-0.61e2), SC_(-0.1433600485324859619140625e-1), SC_(1.2667302662084979337826570205994629760575270558421e-211) }}, 
      {{ SC_(-0.61e2), SC_(-0.1760916970670223236083984375e-1), SC_(2.8928686352184495808714058731442370301152120952584e-206) }}, 
      {{ SC_(-0.61e2), SC_(-0.6152711808681488037109375e-1), SC_(1.1507915428192169017964403554298572567426260297269e-173) }}, 
      {{ SC_(-0.61e2), SC_(-0.11958599090576171875e0), SC_(2.3869299277328255154517154042855638918319843712064e-156) }}, 
      {{ SC_(-0.61e2), SC_(-0.15262925624847412109375e0), SC_(5.4363176381398824179797926296956081316400445904413e-150) }}, 
      {{ SC_(-0.61e2), SC_(-0.408089816570281982421875e0), SC_(2.304846819977282184080434493418762646459057636491e-124) }}, 
      {{ SC_(-0.61e2), SC_(-0.6540834903717041015625e0), SC_(4.5264779375838098725800226481107380276899609082274e-112) }}, 
      {{ SC_(-0.61e2), SC_(-0.1097540378570556640625e1), SC_(1.394454579586264814875228803591527867526457487378e-98) }}, 
      {{ SC_(-0.61e2), SC_(-0.30944411754608154296875e1), SC_(1.4765286399092230040791741547510647367576508020078e-71) }}, 
      {{ SC_(-0.61e2), SC_(-0.51139926910400390625e1), SC_(1.9492095186618141817805891509498817574437792414524e-58) }}, 
      {{ SC_(-0.61e2), SC_(-0.95070552825927734375e1), SC_(3.6535166424498974327222404091018181991713133997357e-42) }}, 
      {{ SC_(-0.61e2), SC_(-0.24750102996826171875e2), SC_(2.6118649550402288054398306933496441568963183554462e-16) }}, 
      {{ SC_(-0.61e2), SC_(-0.637722015380859375e2), SC_(369792726054441.26944059981155583095952179135366203) }}, 
      {{ SC_(-0.64e2), SC_(-0.177219114266335964202880859375e-2), SC_(-1.2388215254263042046658811407264068831944639577887e-280) }}, 
      {{ SC_(-0.64e2), SC_(-0.22177286446094512939453125e-2), SC_(-1.6946223779377366322214570359963237180694346302933e-274) }}, 
      {{ SC_(-0.64e2), SC_(-0.7444499991834163665771484375e-2), SC_(-2.3039978927625714612754208135610671784320013072718e-241) }}, 
      {{ SC_(-0.64e2), SC_(-0.1433600485324859619140625e-1), SC_(-1.9580171289330104594320265640969941604408912539339e-223) }}, 
      {{ SC_(-0.64e2), SC_(-0.1760916970670223236083984375e-1), SC_(-8.2869222089767530366964301609205640263233926997991e-218) }}, 
      {{ SC_(-0.64e2), SC_(-0.6152711808681488037109375e-1), SC_(-1.4061899668280737770929553194231885629327969496772e-183) }}, 
      {{ SC_(-0.64e2), SC_(-0.11958599090576171875e0), SC_(-2.1415454598728861932080547695071679847395256848646e-165) }}, 
      {{ SC_(-0.64e2), SC_(-0.15262925624847412109375e0), SC_(-1.0140610986099354939720650920341316744599074527865e-158) }}, 
      {{ SC_(-0.64e2), SC_(-0.408089816570281982421875e0), SC_(-8.2175612618247530833632942052734480423446402337471e-132) }}, 
      {{ SC_(-0.64e2), SC_(-0.6540834903717041015625e0), SC_(-6.644634547471484880791466057684730813837330292183e-119) }}, 
      {{ SC_(-0.64e2), SC_(-0.1097540378570556640625e1), SC_(-9.6696376607232609042276705446491638405663890260955e-105) }}, 
      {{ SC_(-0.64e2), SC_(-0.30944411754608154296875e1), SC_(-2.2909383826664629344212826375049004437270655767509e-76) }}, 
      {{ SC_(-0.64e2), SC_(-0.51139926910400390625e1), SC_(-1.3606375299804661100856453043111750946073025084922e-62) }}, 
      {{ SC_(-0.64e2), SC_(-0.95070552825927734375e1), SC_(-1.6180433668923993064382449435665897851233631058371e-45) }}, 
      {{ SC_(-0.64e2), SC_(-0.24750102996826171875e2), SC_(-1.8526974585711814390179423187480033162454423293619e-18) }}, 
      {{ SC_(-0.64e2), SC_(-0.637722015380859375e2), SC_(-27753113149542.319960176525351078723832287820547493) }}, 
      {{ SC_(-0.67e2), SC_(-0.177219114266335964202880859375e-2), SC_(3.1391579949641315570429785335251785779472340952396e-295) }}, 
      {{ SC_(-0.67e2), SC_(-0.22177286446094512939453125e-2), SC_(8.4153251602910179456365817555428171807809518688995e-289) }}, 
      {{ SC_(-0.67e2), SC_(-0.7444499991834163665771484375e-2), SC_(4.3277425893419072609128204122623810704245409423407e-254) }}, 
      {{ SC_(-0.67e2), SC_(-0.1433600485324859619140625e-1), SC_(2.6264772024499850109130857465955655576422239032293e-235) }}, 
      {{ SC_(-0.67e2), SC_(-0.1760916970670223236083984375e-1), SC_(2.0600730537734909016515261785532438510975012855129e-229) }}, 
      {{ SC_(-0.67e2), SC_(-0.6152711808681488037109375e-1), SC_(1.4911322583614259693979664878250519196585835218334e-193) }}, 
      {{ SC_(-0.67e2), SC_(-0.11958599090576171875e0), SC_(1.6674001854529428038637462621355919009987100139771e-174) }}, 
      {{ SC_(-0.67e2), SC_(-0.15262925624847412109375e0), SC_(1.6415284380093694762051254707233017592566535189797e-167) }}, 
      {{ SC_(-0.67e2), SC_(-0.408089816570281982421875e0), SC_(2.5425525749591888960496273354363910266310540776057e-139) }}, 
      {{ SC_(-0.67e2), SC_(-0.6540834903717041015625e0), SC_(8.4646682425793074323920353901914134714572584083322e-126) }}, 
      {{ SC_(-0.67e2), SC_(-0.1097540378570556640625e1), SC_(5.8190252763780625217344009150147801436271833123923e-111) }}, 
      {{ SC_(-0.67e2), SC_(-0.30944411754608154296875e1), SC_(3.0852077415388690855886325107096863249917033942949e-81) }}, 
      {{ SC_(-0.67e2), SC_(-0.51139926910400390625e1), SC_(8.2462111027747296965681108576161141617822209913075e-67) }}, 
      {{ SC_(-0.67e2), SC_(-0.95070552825927734375e1), SC_(6.2285651920123373313610961040377593081523421620429e-49) }}, 
      {{ SC_(-0.67e2), SC_(-0.24750102996826171875e2), SC_(1.1517779224277461415676244801629515542988750835375e-20) }}, 
      {{ SC_(-0.67e2), SC_(-0.637722015380859375e2), SC_(1885370641257.1827204796598740013286146728943092018) }}, 
      {{ SC_(-0.7e2), SC_(-0.177219114266335964202880859375e-2), SC_(-6.9473961878707575158600210597440403366919272660158e-310) }}, 
      {{ SC_(-0.7e2), SC_(-0.7444499991834163665771484375e-2), SC_(-7.0997854620701933448207860785327496840617296058248e-267) }}, 
      {{ SC_(-0.7e2), SC_(-0.1433600485324859619140625e-1), SC_(-3.0770549060187263202686051152703950291929132300009e-247) }}, 
      {{ SC_(-0.7e2), SC_(-0.1760916970670223236083984375e-1), SC_(-4.4727687301545682185419970522402590443925802186037e-241) }}, 
      {{ SC_(-0.7e2), SC_(-0.6152711808681488037109375e-1), SC_(-1.38099727631585453821424328210265554521889576794e-203) }}, 
      {{ SC_(-0.7e2), SC_(-0.11958599090576171875e0), SC_(-1.1338535137583496021114388849056277318334203998478e-183) }}, 
      {{ SC_(-0.7e2), SC_(-0.15262925624847412109375e0), SC_(-2.3207978713078011352593728014212904279302244216489e-176) }}, 
      {{ SC_(-0.7e2), SC_(-0.408089816570281982421875e0), SC_(-6.8707243490708476481738782345605125804860468763652e-147) }}, 
      {{ SC_(-0.7e2), SC_(-0.6540834903717041015625e0), SC_(-9.4179449916360381129438016958300605326351814425029e-133) }}, 
      {{ SC_(-0.7e2), SC_(-0.1097540378570556640625e1), SC_(-3.058460877037596390669567494169930309974687355767e-117) }}, 
      {{ SC_(-0.7e2), SC_(-0.30944411754608154296875e1), SC_(-3.6293163655119455138709489938300238971715047471255e-86) }}, 
      {{ SC_(-0.7e2), SC_(-0.51139926910400390625e1), SC_(-4.3666440561259071006305673721113793993049308903697e-71) }}, 
      {{ SC_(-0.7e2), SC_(-0.95070552825927734375e1), SC_(-2.0969827693288095828633768469004433740064673456557e-52) }}, 
      {{ SC_(-0.7e2), SC_(-0.24750102996826171875e2), SC_(-6.3081171041477797378349146657536728814518874279765e-23) }}, 
      {{ SC_(-0.7e2), SC_(-0.637722015380859375e2), SC_(-116200587705.9972033212971866848583486865390099783) }}, 
      {{ SC_(-0.73e2), SC_(-0.177219114266335964202880859375e-2), SC_(1.3507496963190848811812605035755276822306783013008e-324) }}, 
      {{ SC_(-0.73e2), SC_(-0.22177286446094512939453125e-2), SC_(1.3906558628240210167410406322926273217138498155297e-317) }}, 
      {{ SC_(-0.73e2), SC_(-0.7444499991834163665771484375e-2), SC_(1.0232292612643929164393555734712076107963466015419e-279) }}, 
      {{ SC_(-0.73e2), SC_(-0.1433600485324859619140625e-1), SC_(3.1669468744744228128871438059384274750920481170588e-259) }}, 
      {{ SC_(-0.73e2), SC_(-0.1760916970670223236083984375e-1), SC_(8.5312798332901951159689132307158391752594168130046e-253) }}, 
      {{ SC_(-0.73e2), SC_(-0.6152711808681488037109375e-1), SC_(1.1236043760547774550840777773292804117368603963381e-213) }}, 
      {{ SC_(-0.73e2), SC_(-0.11958599090576171875e0), SC_(6.773576827937433880701869360263370808791766081818e-193) }}, 
      {{ SC_(-0.73e2), SC_(-0.15262925624847412109375e0), SC_(2.8825064217746425597303617323233603741034850031809e-185) }}, 
      {{ SC_(-0.73e2), SC_(-0.408089816570281982421875e0), SC_(1.6310978659437693190299774851696549575048944847774e-154) }}, 
      {{ SC_(-0.73e2), SC_(-0.6540834903717041015625e0), SC_(9.2055305236266895105402372198275994943403004085982e-140) }}, 
      {{ SC_(-0.73e2), SC_(-0.1097540378570556640625e1), SC_(1.4122341130484579348120664306328290171004071749639e-123) }}, 
      {{ SC_(-0.73e2), SC_(-0.30944411754608154296875e1), SC_(3.7511636793232867462931323998211418887996843788832e-91) }}, 
      {{ SC_(-0.73e2), SC_(-0.51139926910400390625e1), SC_(2.0320758792487700817910271861967809334924888836874e-75) }}, 
      {{ SC_(-0.73e2), SC_(-0.95070552825927734375e1), SC_(6.2097685364004522844908379887813700451507749938078e-56) }}, 
      {{ SC_(-0.73e2), SC_(-0.24750102996826171875e2), SC_(3.0584007614905224150486889015635217620856903402764e-25) }}, 
      {{ SC_(-0.73e2), SC_(-0.637722015380859375e2), SC_(6512044119.7702057066658291352087070348263357228093) }}, 
      {{ SC_(-0.76e2), SC_(-0.177219114266335964202880859375e-2), SC_(-2.3195339478133814054007492392224202349931276855473e-339) }}, 
      {{ SC_(-0.76e2), SC_(-0.22177286446094512939453125e-2), SC_(-4.6799267801180082535015118083610105786567490647111e-332) }}, 
      {{ SC_(-0.76e2), SC_(-0.7444499991834163665771484375e-2), SC_(-1.302487964423846871761170667875260709588948583303e-292) }}, 
      {{ SC_(-0.76e2), SC_(-0.1433600485324859619140625e-1), SC_(-2.8788520988405523410234474831788210360652724346618e-271) }}, 
      {{ SC_(-0.76e2), SC_(-0.1760916970670223236083984375e-1), SC_(-1.4372257027590942365638884742058014425484218169965e-264) }}, 
      {{ SC_(-0.76e2), SC_(-0.6152711808681488037109375e-1), SC_(-8.0743409403950639843494092057130732296951054158363e-224) }}, 
      {{ SC_(-0.76e2), SC_(-0.11958599090576171875e0), SC_(-3.5739814054216253005793493470952029267539287015973e-202) }}, 
      {{ SC_(-0.76e2), SC_(-0.15262925624847412109375e0), SC_(-3.1621059211308472966030568819860933756230005522119e-194) }}, 
      {{ SC_(-0.76e2), SC_(-0.408089816570281982421875e0), SC_(-3.4200419048105661428016795544405914835338349409359e-162) }}, 
      {{ SC_(-0.76e2), SC_(-0.6540834903717041015625e0), SC_(-7.9472481910706086097506541561280938718583919474349e-147) }}, 
      {{ SC_(-0.76e2), SC_(-0.1097540378570556640625e1), SC_(-5.7595666922124447046430787468026384041534535625797e-130) }}, 
      {{ SC_(-0.76e2), SC_(-0.30944411754608154296875e1), SC_(-3.4247611609219922313466541280690329008558200182914e-96) }}, 
      {{ SC_(-0.76e2), SC_(-0.51139926910400390625e1), SC_(-8.3549036111460052656699367013939841144814107156374e-80) }}, 
      {{ SC_(-0.76e2), SC_(-0.95070552825927734375e1), SC_(-1.6259075460259942049178264036277075443223749204689e-59) }}, 
      {{ SC_(-0.76e2), SC_(-0.24750102996826171875e2), SC_(-1.318576118552021545104435738323048727864154201574e-27) }}, 
      {{ SC_(-0.76e2), SC_(-0.637722015380859375e2), SC_(-332559623.8985721331192076011185438876913669207339) }}, 
      {{ SC_(-0.79e2), SC_(-0.177219114266335964202880859375e-2), SC_(3.5354403212019364046063104755631828771883937058006e-354) }}, 
      {{ SC_(-0.79e2), SC_(-0.22177286446094512939453125e-2), SC_(1.3978976306615431583515397352566586129978164981083e-346) }}, 
      {{ SC_(-0.79e2), SC_(-0.7444499991834163665771484375e-2), SC_(1.4716055261727348172790592652718757218968491250897e-305) }}, 
      {{ SC_(-0.79e2), SC_(-0.1433600485324859619140625e-1), SC_(2.3228162360620189257436933252556231587350476505745e-283) }}, 
      {{ SC_(-0.79e2), SC_(-0.1760916970670223236083984375e-1), SC_(2.1490805210942587181886096768253317000272047900881e-276) }}, 
      {{ SC_(-0.79e2), SC_(-0.6152711808681488037109375e-1), SC_(5.1501240022553382313931109927252352647508033725137e-234) }}, 
      {{ SC_(-0.79e2), SC_(-0.11958599090576171875e0), SC_(1.6737997765406598434264054525564444084850592554407e-211) }}, 
      {{ SC_(-0.79e2), SC_(-0.15262925624847412109375e0), SC_(3.0789282916516690174719881434864575044336286368998e-203) }}, 
      {{ SC_(-0.79e2), SC_(-0.408089816570281982421875e0), SC_(6.36503109275278961131724617973150670884809100085e-170) }}, 
      {{ SC_(-0.79e2), SC_(-0.6540834903717041015625e0), SC_(6.0898084719470202787549713824635043238285438147712e-154) }}, 
      {{ SC_(-0.79e2), SC_(-0.1097540378570556640625e1), SC_(2.0849489482470412059259293955112926383959218775221e-136) }}, 
      {{ SC_(-0.79e2), SC_(-0.30944411754608154296875e1), SC_(2.7755929193923341619599366432165290745895361503068e-101) }}, 
      {{ SC_(-0.79e2), SC_(-0.51139926910400390625e1), SC_(3.0498646489259068012138998537230278724083029378205e-84) }}, 
      {{ SC_(-0.79e2), SC_(-0.95070552825927734375e1), SC_(3.7822190240734211344697436228310459325646325013602e-63) }}, 
      {{ SC_(-0.79e2), SC_(-0.24750102996826171875e2), SC_(5.0763751887669428908160377413843070315272619394593e-30) }}, 
      {{ SC_(-0.79e2), SC_(-0.637722015380859375e2), SC_(15509034.088708430442808142776840096102763256428376) }}, 
      {{ SC_(-0.82e2), SC_(-0.177219114266335964202880859375e-2), SC_(-4.8048862563202889181890537443326779885545248610242e-369) }}, 
      {{ SC_(-0.82e2), SC_(-0.22177286446094512939453125e-2), SC_(-3.7231325849660746143336380063851346168130573371484e-361) }}, 
      {{ SC_(-0.82e2), SC_(-0.7444499991834163665771484375e-2), SC_(-1.4825383087772703677121933113230100416009283671034e-318) }}, 
      {{ SC_(-0.82e2), SC_(-0.1433600485324859619140625e-1), SC_(-1.6711182277052575836893718534668728582756108648312e-295) }}, 
      {{ SC_(-0.82e2), SC_(-0.1760916970670223236083984375e-1), SC_(-2.8653470065901442471349796594633948569490121927789e-288) }}, 
      {{ SC_(-0.82e2), SC_(-0.6152711808681488037109375e-1), SC_(-2.9290388140539613063288304116939069775353632716894e-244) }}, 
      {{ SC_(-0.82e2), SC_(-0.11958599090576171875e0), SC_(-6.989588437838497498633490694257384354295169533204e-221) }}, 
      {{ SC_(-0.82e2), SC_(-0.15262925624847412109375e0), SC_(-2.6731273786128594995441372203649359993461979500185e-212) }}, 
      {{ SC_(-0.82e2), SC_(-0.408089816570281982421875e0), SC_(-1.0562510171246344218084352488817570605950194519393e-177) }}, 
      {{ SC_(-0.82e2), SC_(-0.6540834903717041015625e0), SC_(-4.1609172226269596757660908595807745867150206089336e-161) }}, 
      {{ SC_(-0.82e2), SC_(-0.1097540378570556640625e1), SC_(-6.7298102679330724106181833447827647907096714047206e-143) }}, 
      {{ SC_(-0.82e2), SC_(-0.30944411754608154296875e1), SC_(-2.0059377323087951081667274371186273644145227822575e-106) }}, 
      {{ SC_(-0.82e2), SC_(-0.51139926910400390625e1), SC_(-9.9294186782645320133623704220686212337084869523935e-89) }}, 
      {{ SC_(-0.82e2), SC_(-0.95070552825927734375e1), SC_(-7.8516737724524765361257804357393329459841050420731e-67) }}, 
      {{ SC_(-0.82e2), SC_(-0.24750102996826171875e2), SC_(-1.7520334090734988621562311121564391919297578081493e-32) }}, 
      {{ SC_(-0.82e2), SC_(-0.637722015380859375e2), SC_(-661845.41868057886844507495847825147949109845357718) }}, 
      {{ SC_(-0.85e2), SC_(-0.177219114266335964202880859375e-2), SC_(5.8472757925281335709441070120916109604930024452409e-384) }}, 
      {{ SC_(-0.85e2), SC_(-0.22177286446094512939453125e-2), SC_(8.8791726773414850912512854292238871639394376398273e-376) }}, 
      {{ SC_(-0.85e2), SC_(-0.7444499991834163665771484375e-2), SC_(1.3373691635430932409867433733092264367846631443699e-331) }}, 
      {{ SC_(-0.85e2), SC_(-0.1433600485324859619140625e-1), SC_(1.0765404847203446320910822788131070879964149338772e-307) }}, 
      {{ SC_(-0.85e2), SC_(-0.1760916970670223236083984375e-1), SC_(3.420838952015165818158018000931089841366043146575e-300) }}, 
      {{ SC_(-0.85e2), SC_(-0.6152711808681488037109375e-1), SC_(1.4916380317089088216843268489867077713269951388358e-254) }}, 
      {{ SC_(-0.85e2), SC_(-0.11958599090576171875e0), SC_(2.6135488501491766407431161565237945419126408844675e-230) }}, 
      {{ SC_(-0.85e2), SC_(-0.15262925624847412109375e0), SC_(2.0781203049030925463263429601388263138063177457416e-221) }}, 
      {{ SC_(-0.85e2), SC_(-0.408089816570281982421875e0), SC_(1.5695141280427997758020218417755528490733613885247e-185) }}, 
      {{ SC_(-0.85e2), SC_(-0.6540834903717041015625e0), SC_(2.5456984433230137894914413111361227522822484252069e-168) }}, 
      {{ SC_(-0.85e2), SC_(-0.1097540378570556640625e1), SC_(1.9451160142029278734236728286821772378084338638687e-149) }}, 
      {{ SC_(-0.85e2), SC_(-0.30944411754608154296875e1), SC_(1.2982106047581298813134523396297908278237157397917e-111) }}, 
      {{ SC_(-0.85e2), SC_(-0.51139926910400390625e1), SC_(2.8953015092379672002808952081487566053733334541789e-93) }}, 
      {{ SC_(-0.85e2), SC_(-0.95070552825927734375e1), SC_(1.4606208585387583821716999258644880230045971888375e-70) }}, 
      {{ SC_(-0.85e2), SC_(-0.24750102996826171875e2), SC_(5.4408313801020912656180501212839264038981557151731e-35) }}, 
      {{ SC_(-0.85e2), SC_(-0.637722015380859375e2), SC_(25897.152181004517269750138033637774774294027201157) }}, 
      {{ SC_(-0.88e2), SC_(-0.177219114266335964202880859375e-2), SC_(-6.3967392280596030279323854433032980999361288193673e-399) }}, 
      {{ SC_(-0.88e2), SC_(-0.22177286446094512939453125e-2), SC_(-1.9035798676765477375707106012504409197237459683134e-390) }}, 
      {{ SC_(-0.88e2), SC_(-0.7444499991834163665771484375e-2), SC_(-1.0845043229696536816589939558806337747262693806117e-344) }}, 
      {{ SC_(-0.88e2), SC_(-0.1433600485324859619140625e-1), SC_(-6.2343066307351531677125296908505917958463867368011e-320) }}, 
      {{ SC_(-0.88e2), SC_(-0.1760916970670223236083984375e-1), SC_(-3.6713233393263255015318969376892728032966858934394e-312) }}, 
      {{ SC_(-0.88e2), SC_(-0.6152711808681488037109375e-1), SC_(-6.8286740416097889483960253094161116355961137599911e-265) }}, 
      {{ SC_(-0.88e2), SC_(-0.11958599090576171875e0), SC_(-8.7850510192292171781935576131152961424001837737372e-240) }}, 
      {{ SC_(-0.88e2), SC_(-0.15262925624847412109375e0), SC_(-1.4523001945931213963724402582050155086750135868739e-230) }}, 
      {{ SC_(-0.88e2), SC_(-0.408089816570281982421875e0), SC_(-2.0965173883428983962808243031008372953025094614022e-193) }}, 
      {{ SC_(-0.88e2), SC_(-0.6540834903717041015625e0), SC_(-1.4001057827881787318362535742853637138047693417883e-175) }}, 
      {{ SC_(-0.88e2), SC_(-0.1097540378570556640625e1), SC_(-5.0539014586103948417980337852169920633032949579937e-156) }}, 
      {{ SC_(-0.88e2), SC_(-0.30944411754608154296875e1), SC_(-7.5533392148555117094876622598604796141439853510179e-117) }}, 
      {{ SC_(-0.88e2), SC_(-0.51139926910400390625e1), SC_(-7.5907438126908222770882865866850381553729181510969e-98) }}, 
      {{ SC_(-0.88e2), SC_(-0.95070552825927734375e1), SC_(-2.4442318532108741067843417039652114734958529194241e-74) }}, 
      {{ SC_(-0.88e2), SC_(-0.24750102996826171875e2), SC_(-1.5255185376367196961330937653065804471587161182596e-37) }}, 
      {{ SC_(-0.88e2), SC_(-0.637722015380859375e2), SC_(-930.9184838624792218675752167087125839937752968732) }},
   }};
