//  (C) Copyright John Maddock 2006.
//  Use, modification and distribution are subject to the
//  Boost Software License, Version 1.0. (See accompanying file
//  LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

   static const boost::array<boost::array<typename table_type<T>::type, 3>, 198> factorials = { {
      {{ SC_(1.0), SC_(1.0), SC_(0.0) }},
      {{ SC_(2.0), SC_(1.0), SC_(0.0) }},
      {{ SC_(3.0), SC_(2.0), SC_(0.6931471805599453094172321214581765680755) }},
      {{ SC_(4.0), SC_(6.0), SC_(1.791759469228055000812477358380702272723) }},
      {{ SC_(5.0), SC_(24.0), SC_(3.178053830347945619646941601297055408874) }},
      {{ SC_(6.0), SC_(120.0), SC_(4.7874917427820459942477009345232430484) }},
      {{ SC_(7.0), SC_(720.0), SC_(6.579251212010100995060178292903945321123) }},
      {{ SC_(8.0), SC_(5040.0), SC_(8.52516136106541430016553103634712505076) }},
      {{ SC_(9.0), SC_(40320.0), SC_(10.60460290274525022841722740072165475499) }},
      {{ SC_(10.0), SC_(362880.0), SC_(12.80182748008146961120771787456670616428) }},
      {{ SC_(11.0), SC_(3628800.0), SC_(15.10441257307551529522570932925107037188) }},
      {{ SC_(12.0), SC_(39916800.0), SC_(17.5023078458738858392876529072161996717) }},
      {{ SC_(13.0), SC_(479001600.0), SC_(19.9872144956618861495173623870550785125) }},
      {{ SC_(14.0), SC_(6227020800.0), SC_(22.55216385312342288557084982862039711731) }},
      {{ SC_(15.0), SC_(87178291200.0), SC_(25.19122118273868150009343469352175341502) }},
      {{ SC_(16.0), SC_(1307674368000.0), SC_(27.89927138384089156608943926367046675919) }},
      {{ SC_(17.0), SC_(20922789888000.0), SC_(30.6718601060806728037583677495031730315) }},
      {{ SC_(18.0), SC_(355687428096000.0), SC_(33.50507345013688888400790236737629956708) }},
      {{ SC_(19.0), SC_(6402373705728000.0), SC_(36.39544520803305357621562496267952754445) }},
      {{ SC_(20.0), SC_(121645100408832000.0), SC_(39.33988418719949403622465239456738108169) }},
      {{ SC_(21.0), SC_(0.243290200817664e19), SC_(42.33561646075348502965987597070992185737) }},
      {{ SC_(22.0), SC_(0.5109094217170944e20), SC_(45.38013889847690802616047395107562729165) }},
      {{ SC_(23.0), SC_(0.112400072777760768e22), SC_(48.47118135183522387963964965049893315955) }},
      {{ SC_(24.0), SC_(0.2585201673888497664e23), SC_(51.60667556776437357044640248230912927799) }},
      {{ SC_(25.0), SC_(0.62044840173323943936e24), SC_(54.78472939811231919009334408360618468687) }},
      {{ SC_(26.0), SC_(0.15511210043330985984e26), SC_(58.00360522298051993929486275005855996592) }},
      {{ SC_(27.0), SC_(0.403291461126605635584e27), SC_(61.2617017610020019847655823130820551388) }},
      {{ SC_(28.0), SC_(0.10888869450418352160768e29), SC_(64.55753862700633105895131802384963225274) }},
      {{ SC_(29.0), SC_(0.304888344611713860501504e30), SC_(67.88974313718153498289113501020916511853) }},
      {{ SC_(30.0), SC_(0.8841761993739701954543616e31), SC_(71.25703896716800901007440704257107672402) }},
      {{ SC_(31.0), SC_(0.26525285981219105863630848e33), SC_(74.65823634883016438548764373417796663627) }},
      {{ SC_(32.0), SC_(0.822283865417792281772556288e34), SC_(78.09222355331531063141680805872032384672) }},
      {{ SC_(33.0), SC_(0.26313083693369353016721801216e36), SC_(81.5579594561150371785029686660112066871) }},
      {{ SC_(34.0), SC_(0.868331761881188649551819440128e37), SC_(85.05446701758151741396015748089886169157) }},
      {{ SC_(35.0), SC_(0.29523279903960414084761860964352e39), SC_(88.58082754219767880362692422023016479523) }},
      {{ SC_(36.0), SC_(0.103331479663861449296666513375232e41), SC_(92.13617560368709248333303629689953216439) }},
      {{ SC_(37.0), SC_(0.3719933267899012174679994481508352e42), SC_(95.71969454214320248495799101366093670984) }},
      {{ SC_(38.0), SC_(0.137637530912263450463159795815809024e44), SC_(99.33061245478742692932608668469238387374) }},
      {{ SC_(39.0), SC_(0.5230226174666011117600072241000742912e45), SC_(102.9681986145138126987523462380384139791) }},
      {{ SC_(40.0), SC_(0.203978820811974433586402817399028973568e47), SC_(106.6317602606434591262010789165262582885) }},
      {{ SC_(41.0), SC_(0.815915283247897734345611269596115894272e48), SC_(110.3206397147573954290535346141269756323) }},
      {{ SC_(42.0), SC_(0.3345252661316380710817006205344075166515e50), SC_(114.0342117814617032329202979871643832206) }},
      {{ SC_(43.0), SC_(0.1405006117752879898543142606244511569936e52), SC_(117.771881399745071538838128088988265223) }},
      {{ SC_(44.0), SC_(0.6041526306337383563735513206851399750726e53), SC_(121.5330815154386339623109706023341122586) }},
      {{ SC_(45.0), SC_(0.265827157478844876804362581101461589032e55), SC_(125.3172711493568951252073784232155946945) }},
      {{ SC_(46.0), SC_(0.1196222208654801945619631614956577150644e57), SC_(129.1239336391272148825986282302868337433) }},
      {{ SC_(47.0), SC_(0.5502622159812088949850305428800254892962e58), SC_(132.9525750356163098828226131835552064299) }},
      {{ SC_(48.0), SC_(0.2586232415111681806429643551536119799692e60), SC_(136.8027226373263684696435638533273801388) }},
      {{ SC_(49.0), SC_(0.1241391559253607267086228904737337503852e62), SC_(140.6739236482342593987077375760826121157) }},
      {{ SC_(50.0), SC_(0.6082818640342675608722521633212953768876e63), SC_(144.565743946344886008918443062968971575) }},
      {{ SC_(51.0), SC_(0.3041409320171337804361260816606476884438e65), SC_(148.4777669517730320675371938508795234221) }},
      {{ SC_(52.0), SC_(0.1551118753287382280224243016469303211063e67), SC_(152.4095925844973578391819737056751756623) }},
      {{ SC_(53.0), SC_(0.8065817517094387857166063685640376697529e68), SC_(156.3608363030787851940699253901568474033) }},
      {{ SC_(54.0), SC_(0.427488328406002556429801375338939964969e70), SC_(160.3311282166309070282143945291859051737) }},
      {{ SC_(55.0), SC_(0.2308436973392413804720927426830275810833e72), SC_(164.3201122631951814118173623614116588557) }},
      {{ SC_(56.0), SC_(0.1269640335365827592596510084756651695958e74), SC_(168.327445448427652330480065272602975795) }},
      {{ SC_(57.0), SC_(0.7109985878048634518540456474637249497365e75), SC_(172.3527971391628015638371143804206852289) }},
      {{ SC_(58.0), SC_(0.4052691950487721675568060190543232213498e77), SC_(176.3958484069973517152413870492310644708) }},
      {{ SC_(59.0), SC_(0.2350561331282878571829474910515074683829e79), SC_(180.4562914175437710518418912030511526443) }},
      {{ SC_(60.0), SC_(0.1386831185456898357379390197203894063459e81), SC_(184.5338288614494905024579415767708502684) }},
      {{ SC_(61.0), SC_(0.8320987112741390144276341183223364380754e82), SC_(188.6281734236715911872884103898359167487) }},
      {{ SC_(62.0), SC_(0.507580213877224798800856812176625227226e84), SC_(192.7390472878449024360397994932615314951) }},
      {{ SC_(63.0), SC_(0.3146997326038793752565312235495076408801e86), SC_(196.8661816728899939913861959392620652736) }},
      {{ SC_(64.0), SC_(0.1982608315404440064116146708361898137545e88), SC_(201.0093163992815266792820391565502964125) }},
      {{ SC_(65.0), SC_(0.1268869321858841641034333893351614808029e90), SC_(205.168199482641198535785431885299355821) }},
      {{ SC_(66.0), SC_(0.8247650592082470666723170306785496252186e91), SC_(209.3425867525368356464396786600908620653) }},
      {{ SC_(67.0), SC_(0.5443449390774430640037292402478427526443e93), SC_(213.5322414945632611913140995964366936378) }},
      {{ SC_(68.0), SC_(0.3647111091818868528824985909660546442717e95), SC_(217.7369341139542272509841715928004163884) }},
      {{ SC_(69.0), SC_(0.2480035542436830599600990418569171581047e97), SC_(221.9564418191303339500681704535898960601) }},
      {{ SC_(70.0), SC_(0.1711224524281413113724683388812728390923e99), SC_(226.1905483237275933322701685223226178832) }},
      {{ SC_(71.0), SC_(0.1197857166996989179607278372168909873646e101), SC_(230.4390435657769523213935127204501618205) }},
      {{ SC_(72.0), SC_(0.8504785885678623175211676442399260102886e102), SC_(234.7017234428182677427229672529631959172) }},
      {{ SC_(73.0), SC_(0.6123445837688608686152407038527467274078e104), SC_(238.9783895618343230537651540911827770308) }},
      {{ SC_(74.0), SC_(0.4470115461512684340891257138125051110077e106), SC_(243.2688490029827141828572629486213196017) }},
      {{ SC_(75.0), SC_(0.3307885441519386412259530282212537821457e108), SC_(247.5729140961868839366425907411109433336) }},
      {{ SC_(76.0), SC_(0.2480914081139539809194647711659403366093e110), SC_(251.8904022097231943772393546444858443173) }},
      {{ SC_(77.0), SC_(0.188549470166605025498793226086114655823e112), SC_(256.2211355500095254560828463192900509907) }},
      {{ SC_(78.0), SC_(0.1451830920282858696340707840863082849837e114), SC_(260.5649409718632093052501426406983600202) }},
      {{ SC_(79.0), SC_(0.1132428117820629783145752115873204622873e116), SC_(264.9216497985528010421161074406443808977) }},
      {{ SC_(80.0), SC_(0.8946182130782975286851441715398316520698e117), SC_(269.2910976510198225362890529821257918199) }},
      {{ SC_(81.0), SC_(0.7156945704626380229481153372318653216558e119), SC_(273.6731242856937041485587408011846857317) }},
      {{ SC_(82.0), SC_(0.5797126020747367985879734231578109105412e121), SC_(278.0675734403661429141397217488747885503) }},
      {{ SC_(83.0), SC_(0.4753643337012841748421382069894049466438e123), SC_(282.4742926876303960274237172433703727067) }},
      {{ SC_(84.0), SC_(0.3945523969720658651189747118012061057144e125), SC_(286.8931332954269939508991894666617431598) }},
      {{ SC_(85.0), SC_(0.3314240134565353266999387579130131288001e127), SC_(291.3239500942703075662342516899438017302) }},
      {{ SC_(86.0), SC_(0.2817104114380550276949479442260611594801e129), SC_(295.7666013507606240210845456410431159053) }},
      {{ SC_(87.0), SC_(0.2422709538367273238176552320344125971528e131), SC_(300.220948647014131753974620275847139509) }},
      {{ SC_(88.0), SC_(0.210775729837952771721360051869938959523e133), SC_(304.6868567656687154725531375451315768191) }},
      {{ SC_(89.0), SC_(0.1854826422573984391147968456455462843802e135), SC_(309.1641935801469219448667774874712358232) }},
      {{ SC_(90.0), SC_(0.1650795516090846108121691926245361930984e137), SC_(313.6528299498790617831845930281410850426) }},
      {{ SC_(91.0), SC_(0.1485715964481761497309522733620825737886e139), SC_(318.1526396202093268499930749566705006595) }},
      {{ SC_(92.0), SC_(0.1352001527678402962551665687594951421476e141), SC_(322.6634991267261768911519151416789989939) }},
      {{ SC_(93.0), SC_(0.1243841405464130725547532432587355307758e143), SC_(327.1852877037752172007931322164055482485) }},
      {{ SC_(94.0), SC_(0.1156772507081641574759205162306240436215e145), SC_(331.7178871969284731381175417778704311636) }},
      {{ SC_(95.0), SC_(0.1087366156656743080273652852567866010042e147), SC_(336.2611819791984770343557245691007814406) }},
      {{ SC_(96.0), SC_(0.103299784882390592625997020993947270954e149), SC_(340.8150588707990178689655113342148226173) }},
      {{ SC_(97.0), SC_(0.9916779348709496892095714015418938011582e150), SC_(345.3794070622668541074469171784282311623) }},
      {{ SC_(98.0), SC_(0.9619275968248211985332842594956369871234e152), SC_(349.9541180407702369295636388001321928762) }},
      {{ SC_(99.0), SC_(0.942689044888324774562618574305724247381e154), SC_(354.5390855194408088491915764084767289035) }},
      {{ SC_(1.5), SC_(0.8862269254527580136490837416705725913988), SC_(-0.1207822376352452223455184457816472122519) }},
      {{ SC_(2.5), SC_(1.329340388179137020473625612505858887098), SC_(0.2846828704729191596324946696827019243201) }},
      {{ SC_(3.5), SC_(3.323350970447842551184064031264647217745), SC_(1.20097360234707422481602188145071299577) }},
      {{ SC_(4.5), SC_(11.63172839656744892914422410942626526211), SC_(2.453736570842442220504142503435716157332) }},
      {{ SC_(5.5), SC_(52.34277778455352018114900849241819367949), SC_(3.957813967618716293877400855822590998551) }},
      {{ SC_(6.5), SC_(287.8852778150443609963195467083000652372), SC_(5.662562059857141528522112312329543730298) }},
      {{ SC_(7.5), SC_(1871.254305797788346476077053603950424042), SC_(7.534364236758732955158367632436685767027) }},
      {{ SC_(8.5), SC_(14034.40729348341259857057790202962818031), SC_(9.549267257300997711737140081127222543125) }},
      {{ SC_(9.5), SC_(119292.4619946090070878499121672518395327), SC_(11.68933342079726848256944257754217251064) }},
      {{ SC_(10.5), SC_(1133278.38894878556733457416558889247556), SC_(13.9406252194037636331612378879718494798) }},
      {{ SC_(11.5), SC_(11899423.08396224845701302873868337099338), SC_(16.29200047656724132024460374687937834601) }},
      {{ SC_(12.5), SC_(136843365.4655658572556498304948587664239), SC_(18.73434751193644570163412445723139789638) }},
      {{ SC_(13.5), SC_(1710542068.319573215695622881185734580299), SC_(21.26007615624470114141841100222559660735) }},
      {{ SC_(14.5), SC_(23092317922.31423841189090889600741683403), SC_(23.86276584168908490618691459153499715322) }},
      {{ SC_(15.5), SC_(334838609873.5564569724181789921075440935), SC_(26.53691449111561362395295450243873219064) }},
      {{ SC_(16.5), SC_(5189998453040.125083072481774377666933449), SC_(29.27775451504081456046488670552291283301) }},
      {{ SC_(17.5), SC_(85634974475162.06387069594927723150440191), SC_(32.08111489594734948650484339895239126941) }},
      {{ SC_(18.5), SC_(1498612053315336.117737179112351551327033), SC_(34.94331577687681785679372335416358207049) }},
      {{ SC_(19.5), SC_(27724322986333718.17813781357850369955012), SC_(37.86108650896109699174458690373685266632) }},
      {{ SC_(20.5), SC_(540624298233507504.4736873647808221412273), SC_(40.83150097453079810977608746076652040769) }},
      {{ SC_(21.5), SC_(11082798113786903841.71059097800685389516), SC_(43.851925860675160604225618712345751428) }},
      {{ SC_(22.5), SC_(238280159446418432596.7777060271473587459), SC_(46.91997879580877771828122910423342189548) }},
      {{ SC_(23.5), SC_(5361303587544414733427.498385610815571784), SC_(50.03349410501915216625524678984648437622) }},
      {{ SC_(24.5), SC_(125990634307293746235546.2120618541659369), SC_(53.19049452616926544365896533816048151704) }},
      {{ SC_(25.5), SC_(3086770540528696782770882.195515427065454), SC_(56.38916764371994674445243870358866440824) }},
      {{ SC_(26.5), SC_(78712648783481767960657495.98564339016909), SC_(59.6278460958843272066799864369261400804) }},
      {{ SC_(27.5), SC_(2085885192762266850957423643.619549839481), SC_(62.90499082887650373140722345449702128269) }},
      {{ SC_(28.5), SC_(57361842800962338401329150199.53762058572), SC_(66.21917683354902934065269424423016165396) }},
      {{ SC_(29.5), SC_(1634812519827426644437880780686.822186693), SC_(69.56908092082363418263973479158236432777) }},
      {{ SC_(30.5), SC_(48226969334909086010917483030261.25450745), SC_(72.95347118416940832383855304384388538376) }},
      {{ SC_(31.5), SC_(1470922564714727123332983232422968.262477), SC_(76.371197867782774263172710025811323562) }},
      {{ SC_(32.5), SC_(46334060788513904384988971821323500.26803), SC_(79.82118541361436164165132112164137813285) }},
      {{ SC_(33.5), SC_(1505856975626701892512141584193013758.711), SC_(83.30242550295005344288833577497470780911) }},
      {{ SC_(34.5), SC_(50446208683494513399156743070465960916.82), SC_(86.8139709417810741931411756498802539916) }},
      {{ SC_(35.5), SC_(1740394199580560712270907635931075651630.0), SC_(90.35493026581838826592594159715479924661) }},
      {{ SC_(36.5), SC_(61783994085109905285617221075553185632870.0), SC_(93.9244629622997583778381640082096567753) }},
      {{ SC_(37.5), SC_(0.22551157841065115429250285692576912756e43), SC_(97.52177522288820419751304074419002277813) }},
      {{ SC_(38.5), SC_(0.8456684190399418285968857134716342283499e44), SC_(101.1461161558645693286925725261067471938) }},
      {{ SC_(39.5), SC_(0.3255823413303776040098009996865791779147e46), SC_(104.7967743971583078684426367260568796551) }},
      {{ SC_(40.5), SC_(0.1286050248254991535838713948761987752763e48), SC_(108.4730750690653840531983501460801140092) }},
      {{ SC_(41.5), SC_(0.5208503505432715720146791492486050398691e49), SC_(112.1743770431778775093620989723120402597) }},
      {{ SC_(42.5), SC_(0.2161528954754577023860918469381710915457e51), SC_(115.9000704704145301234203390741452341447) }},
      {{ SC_(43.5), SC_(0.9186498057706952351408903494872271390691e52), SC_(119.6495745463449012688534009037863717517) }},
      {{ SC_(44.5), SC_(0.3996126655102524272862873020269438054951e54), SC_(123.4223354844395396780146860516126324938) }},
      {{ SC_(45.5), SC_(0.1778276361520623301423978494019899934453e56), SC_(127.2178246736117342069152694708243051451) }},
      {{ SC_(46.5), SC_(0.8091157444918836021479102147790544701761e57), SC_(131.0355369995686389386568775343746269115) }},
      {{ SC_(47.5), SC_(0.3762388211887258749987782498722603286319e59), SC_(134.8749893121619495665640549743813332585) }},
      {{ SC_(48.5), SC_(0.1787134400646447906244196686893236561001e61), SC_(138.7357190232025450917566096180371978672) }},
      {{ SC_(49.5), SC_(0.8667601843135272345284353931432197320857e62), SC_(142.6172828211459826044560991182829830129) }},
      {{ SC_(50.5), SC_(0.4290462912351959810915755196058937673824e64), SC_(146.519255490720627221891301048634987154) }},
      {{ SC_(51.5), SC_(0.2166683770737739704512456374009763525281e66), SC_(150.4412288270019413633582671940897997428) }},
      {{ SC_(52.5), SC_(0.111584214192993594782391503261502821552e68), SC_(154.3828106346716318247096373876850639954) }},
      {{ SC_(53.5), SC_(0.5858171245132163726075553921228898131479e69), SC_(158.3436238042692098863937625798187805011) }},
      {{ SC_(54.5), SC_(0.3134121616145707593450421347857460500341e71), SC_(162.3233054581711707502809292753838809346) }},
      {{ SC_(55.5), SC_(0.1708096280799410638430479634582315972686e73), SC_(166.3215061598403691412410136061349060176) }},
      {{ SC_(56.5), SC_(0.9479934358436729043289161971931853648408e74), SC_(170.337889180592757967587122392630702318) }},
      {{ SC_(57.5), SC_(0.535616291251675190945837651414149731135e76), SC_(174.372129818745153226752021764788547422) }},
      {{ SC_(58.5), SC_(0.3079793674697132347938566495631360954026e78), SC_(178.4239147665484579827423018083667546119) }},
      {{ SC_(59.5), SC_(0.1801679299697822423544061399944346158105e80), SC_(182.4929415207862687921690476023189480579) }},
      {{ SC_(60.5), SC_(0.1071999183320204342008716532966885964073e82), SC_(186.5789178333378528681067028421770777551) }},
      {{ SC_(61.5), SC_(0.648559505908723626915273502444966008264e83), SC_(190.6815611983746486468133578766491597866) }},
      {{ SC_(62.5), SC_(0.3988640961338650305528932040036540950824e85), SC_(194.8005983731871208326581343651509165116) }},
      {{ SC_(63.5), SC_(0.2492900600836656440955582525022838094265e87), SC_(198.9357649299294766470431802433713028621) }},
      {{ SC_(64.5), SC_(0.1582991881531276840006794903389502189858e89), SC_(203.0868048358281226106733889296294186889) }},
      {{ SC_(65.5), SC_(0.1021029763587673561804382712686228912459e91), SC_(207.253470059629849416124244558439614861) }},
      {{ SC_(66.5), SC_(0.6687744951499261829818706768094799376603e92), SC_(211.435520202271055650856436448150964186) }},
      {{ SC_(67.5), SC_(0.4447350392747009116829440000783041585441e94), SC_(215.6327221499328641065535845020238208848) }},
      {{ SC_(68.5), SC_(0.3001961515104231153859872000528553070173e96), SC_(219.8448497478113482459228474245594090702) }},
      {{ SC_(69.5), SC_(0.2056343637846398340394012320362058853068e98), SC_(224.0716834930795278518208054310810978927) }},
      {{ SC_(70.5), SC_(0.1429158828303246846573838562651630902882e100), SC_(228.3130102456502742995923582284984651071) }},
      {{ SC_(71.5), SC_(0.1007556973953789026834556186669399786532e102), SC_(232.5686229554684972683913220137349879525) }},
      {{ SC_(72.5), SC_(0.7204032363769591541867076734686208473705e103), SC_(236.8383204051684592390895209118072592891) }},
      {{ SC_(73.5), SC_(0.5222923463732953867853630632647501143436e105), SC_(241.121906967029088331456320155937181966) }},
      {{ SC_(74.5), SC_(0.3838848745843721092872418514995913340426e107), SC_(245.4191923732478793236450387582878905619) }},
      {{ SC_(75.5), SC_(0.2859942315653572214189951793671955438617e109), SC_(249.7299914986333931552202349119338344817) }},
      {{ SC_(76.5), SC_(0.2159256448318447021713413604222326356156e111), SC_(254.0541241548883721745992390899601342039) }},
      {{ SC_(77.5), SC_(0.1651831182963611971610761407230079662459e113), SC_(258.3914148957208623282220320602201355807) }},
      {{ SC_(78.5), SC_(0.1280169166796799277998340090603311738406e115), SC_(262.7416928320801636393347235965305038626) }},
      {{ SC_(79.5), SC_(0.1004932795935487433228696971123599714649e117), SC_(267.1047914568685263873419367114758025432) }},
      {{ SC_(80.5), SC_(0.7989215727687125094168140920432617731457e118), SC_(271.4805484785288126034644189659692094502) }},
      {{ SC_(81.5), SC_(0.6431318660788135700805353440948257273823e120), SC_(275.8688056629533302899592924197644087302) }},
      {{ SC_(82.5), SC_(0.5241524708542330596156363054372829678165e122), SC_(280.2694086832001473146069926644269820387) }},
      {{ SC_(83.5), SC_(0.4324257884547422741828999519857584484486e124), SC_(284.6822069765407826152477086910826481146) }},
      {{ SC_(84.5), SC_(0.3610755333597097989427214599081083044546e126), SC_(289.1070536083975924130902273463692509124) }},
      {{ SC_(85.5), SC_(0.3051088256889547801065996336223515172642e128), SC_(293.5438051427607205757799701080417115539) }},
      {{ SC_(86.5), SC_(0.2608680459640563369911426867471105472609e130), SC_(297.9923215187034351091622558923164399324) }},
      {{ SC_(87.5), SC_(0.2256508597589087314973384240362506233806e132), SC_(302.4524659326412687466785241592992548335) }},
      {{ SC_(88.5), SC_(0.1974445022890451400601711210317192954581e134), SC_(306.9241047260048374915681634477366332741) }},
      {{ SC_(89.5), SC_(0.1747383845258049489532514421130715764804e136), SC_(311.4071072780187213241622269369206800347) }},
      {{ SC_(90.5), SC_(0.1563908541505954293131600406911990609499e138), SC_(315.9013459032995310109227992454839056422) }},
      {{ SC_(91.5), SC_(0.1415337230062888635284098368255351501597e140), SC_(320.4066957540054114483446541626587380014) }},
      {{ SC_(92.5), SC_(0.1295033565507543101284950006953646623961e142), SC_(324.9230347262868870790740563815487018843) }},
      {{ SC_(93.5), SC_(0.1197906048094477368688578756432123127164e144), SC_(329.4502433708052665886256792643481601196) }},
      {{ SC_(94.5), SC_(0.1120042154968336339723821137264035123898e146), SC_(333.988204807099907903519925338728239387) }},
      {{ SC_(95.5), SC_(0.1058439836445077841039010974714513192084e148), SC_(338.5368046415996049733937816714808196625) }},
      {{ SC_(96.5), SC_(0.101081004380504933819225548085236009844e150), SC_(343.095930889086289536826499502225010241) }},
      {{ SC_(97.5), SC_(0.9754316922718726113555265390225274949948e151), SC_(347.6654738974312297792641984341498924371) }},
      {{ SC_(98.5), SC_(0.95104589996507579607163837554696430762e153), SC_(352.245326275435031271896458324405747818) }},
      {{ SC_(99.5), SC_(0.9367802114655996591305637999137598430057e155), SC_(356.835382823613074469259023532110402225) }}
   } };


   static const boost::array<boost::array<typename table_type<T>::type, 3>, 41> near_1 = { {
      {{ SC_(0.5), SC_(1.772453850905516027298167483341145182798), SC_(0.5723649429247000870717136756765293558236) }},
      {{ SC_(0.625), SC_(1.434518848090556775636019739456423136632), SC_(0.3608294954889401811849576858227794878574) }},
      {{ SC_(0.75), SC_(1.225416702465177645129098303362890526851), SC_(0.2032809514312953714814329718624296997597) }},
      {{ SC_(0.875), SC_(1.089652357422896951252376755102892971148), SC_(0.08585870722533432350236558376948770226972) }},
      {{ SC_(0.875), SC_(1.089652357422896951252376755102892971148), SC_(0.08585870722533432350236558376948770226972) }},
      {{ SC_(0.9375), SC_(1.040177011186767171459762817361921128614), SC_(0.03939090173458230065822754634095384450336) }},
      {{ SC_(0.96875), SC_(1.019032525056673950564730047928136024882), SC_(0.01885367233441289053559206570480080890174) }},
      {{ SC_(0.984375), SC_(1.009263984715686303151364227987264939567), SC_(0.009221337197578781045045446027854805411837) }},
      {{ SC_(0.9921875), SC_(1.004570300975031369541819081985749775618), SC_(0.004559888861804558865096599455042458443847) }},
      {{ SC_(0.99609375), SC_(1.002269894807266338070518646683408822875), SC_(0.002267322487909119869224853055660925945503) }},
      {{ SC_(0.998046875), SC_(1.001131154070271719475148653701632936175), SC_(0.001130514797538261731446855551493110644591) }},
      {{ SC_(0.9990234375), SC_(1.000564631256105134179583334797007222469), SC_(0.0005644719118551233842574575277837954032273) }},
      {{ SC_(0.99951171875), SC_(1.000282079501403060312266009234616105409), SC_(0.0002820397244605020216499093258679218227703) }},
      {{ SC_(0.999755859375), SC_(1.000140980758729162527664293184201592009), SC_(0.0001409708218759223705137152436852900410971) }},
      {{ SC_(0.9998779296875), SC_(1.000070475636328154358952919083132410835), SC_(0.7047315303717008615499045661742960649129e-4) }},
      {{ SC_(0.99993896484375), SC_(1.000035234133024267207862236519063784064), SC_(0.3523351231678223923789189421658142521323e-4) }},
      {{ SC_(0.999969482421875), SC_(1.00001761614530457531538182039987833925), SC_(0.1761599014210985977615986870219441253152e-4) }},
      {{ SC_(0.9999847412109375), SC_(1.000008807842360071243230645907272632701), SC_(0.8807803571255486980463673710461571970668e-5) }},
      {{ SC_(0.99999237060546875), SC_(1.000004403863608190592851185888812529877), SC_(0.4403853911211722516241836921789602523957e-5) }},
      {{ SC_(0.999996185302734375), SC_(1.000002201917411285169225005738085227502), SC_(0.2201914987068584780432891571768087250967e-5) }},
      {{ SC_(1.0), SC_(1.0), SC_(0.0) }},
      {{ SC_(1.000003814697265625), SC_(0.9999977981113740328314320876032760067576), SC_(-0.2201891050127487637714181831108975522931e-5) }},
      {{ SC_(1.00000762939453125), SC_(0.9999955962515330814147665236857616584616), SC_(-0.4403758163447332570221840098229107074209e-5) }},
      {{ SC_(1.0000152587890625), SC_(0.9999911926182050168670695717547199129391), SC_(-0.8807420580197905194061157631901679899078e-5) }},
      {{ SC_(1.000030517578125), SC_(0.99998238569695577840308912119540189507), SC_(-0.1761445817787918059338915122874759423839e-4) }},
      {{ SC_(1.00006103515625), SC_(0.9999647732360171681023427372223702590454), SC_(-0.352273844598538899122262467277208094941e-4) }},
      {{ SC_(1.0001220703125), SC_(0.9999295538398379138630109146622273453912), SC_(-0.7044864160936656733821449407577769386531e-4) }},
      {{ SC_(1.000244140625), SC_(0.9998591371459403420587898072239427065107), SC_(-0.0001408727761632663509703058417841195184664) }},
      {{ SC_(1.00048828125), SC_(0.9997183921173586652300583206642029951561), SC_(-0.0002816475415868068318239205463917072406589) }},
      {{ SC_(1.0009765625), SC_(0.999437255220281084345213592031181905165), SC_(-0.0005629031799912046317021499216851450277288) }},
      {{ SC_(1.001953125), SC_(0.998876391856702293840181665944397250951), SC_(-0.001124239864176365593088235002674045499535) }},
      {{ SC_(1.00390625), SC_(0.9977602892435009045255150050890440579513), SC_(-0.002242222659961150144765481909230529929808) }},
      {{ SC_(1.0078125), SC_(0.995550440714294209465143243929765941358), SC_(-0.004459488037952299086670078922352109198758) }},
      {{ SC_(1.015625), SC_(0.9912190698420517341764818662191450397148), SC_(-0.008819709705733069204889229698627066380001) }},
      {{ SC_(1.03125), SC_(0.98290109928362691478263486825456935047), SC_(-0.01724677500176806740289126202224623179737) }},
      {{ SC_(1.0625), SC_(0.9675800675995248847599762987154317516646), SC_(-0.03295710029357781908319883575047418315706) }},
      {{ SC_(1.125), SC_(0.9417426998497014880874037301518917030763), SC_(-0.06002318412603958293140584320743011427822) }},
      {{ SC_(1.125), SC_(0.9417426998497014880874037301518917030763), SC_(-0.06002318412603958293140584320743011427822) }},
      {{ SC_(1.25), SC_(0.9064024770554770779826712889669180007488), SC_(-0.09827183642181316146385380269663584022562) }},
      {{ SC_(1.375), SC_(0.8889135691562253407424275640662446912078), SC_(-0.1177552707410787744513620333179885042465) }},
      {{ SC_(1.5), SC_(0.8862269254527580136490837416705725913988), SC_(-0.1207822376352452223455184457816472122519) }}
   } };

   static const boost::array<boost::array<typename table_type<T>::type, 3>, 41> near_2 = { {
      {{ SC_(1.5), SC_(0.8862269254527580136490837416705725913988), SC_(-0.1207822376352452223455184457816472122519) }},
      {{ SC_(1.625), SC_(0.8965742800565979847725123371602644603951), SC_(-0.1091741337567953724659793453255625768435) }},
      {{ SC_(1.75), SC_(0.9190625268488832338468237275221678951384), SC_(-0.08440112102048555595778603413139773174384) }},
      {{ SC_(1.875), SC_(0.9534458127450348323458296607150313497544), SC_(-0.0476726853991882996439780371618622723197) }},
      {{ SC_(1.875), SC_(0.9534458127450348323458296607150313497544), SC_(-0.0476726853991882996439780371618622723197) }},
      {{ SC_(1.9375), SC_(0.9751659479875942232435276412768010580753), SC_(-0.02514761940298887101469636934303908362555) }},
      {{ SC_(1.96875), SC_(0.9871877586486528896095822339303817741048), SC_(-0.01289502598016741062140421704372482102582) }},
      {{ SC_(1.984375), SC_(0.9934942349545037046646241619249639248858), SC_(-0.006527019770560387562504065432973464109098) }},
      {{ SC_(1.9921875), SC_(0.9967220954986639369672736204077361054958), SC_(-0.003283288599221334008087443035901123210745) }},
      {{ SC_(1.99609375), SC_(0.9983547780306754539374306832198017571606), SC_(-0.001646576833227209223092930587911738897203) }},
      {{ SC_(1.998046875), SC_(0.9991758197849782200230487539873719343464), SC_(-0.0008245200382650888261806366903737014930725) }},
      {{ SC_(1.9990234375), SC_(0.9995875173583940940094860854466195201034), SC_(-0.0004125677359714894017106176239696704326377) }},
      {{ SC_(1.99951171875), SC_(0.9997936605172715158492229105972945155141), SC_(-0.0002063607736483724433350542340289891606905) }},
      {{ SC_(1.999755859375), SC_(0.9998968057145986134157190626438734177924), SC_(-0.0001031996102979920861817501746961436019694) }},
      {{ SC_(1.9998779296875), SC_(0.9999483967208452041447977734631271456482), SC_(-0.5160461064981215542788033369454594603258e-4) }},
      {{ SC_(1.99993896484375), SC_(0.9999741968262534527384281628962293685498), SC_(-0.2580350665416168648325053559023655125278e-4) }},
      {{ SC_(1.999969482421875), SC_(0.9999870980295774847216527132886600812439), SC_(-0.1290205365365156795229453393309637521044e-4) }},
      {{ SC_(1.9999847412109375), SC_(0.9999935489189005625751513729787156979985), SC_(-0.6451101907750591399976874019296260011728e-5) }},
      {{ SC_(1.99999237060546875), SC_(0.9999967744354781276641509840822795646932), SC_(-0.3225569724016764801116581064181763189594e-5) }},
      {{ SC_(1.999996185302734375), SC_(0.9999983872117460118412633921783404380531), SC_(-0.1612789554532533173009818453505550062943e-5) }},
      {{ SC_(2.0), SC_(1.0), SC_(0.0) }},
      {{ SC_(2.000003814697265625), SC_(1.00000161280024011931074434129623713986), SC_(0.161279893955840184299760314572495677042e-5) }},
      {{ SC_(2.00000762939453125), SC_(1.000003225612466396944257297966490462185), SC_(0.322560726412023958566345675090317173141e-5) }},
      {{ SC_(2.0000152587890625), SC_(1.000006451272877535864519325623917830418), SC_(0.6451252068164492211696167502987139983584e-5) }},
      {{ SC_(2.000030517578125), SC_(1.000012902737534909133631207655399313341), SC_(0.1290265429530719797568036294024708700466e-4) }},
      {{ SC_(2.00006103515625), SC_(1.000025806242196124228325546227327679105), SC_(0.2580590922078463500093254292124318294867e-4) }},
      {{ SC_(2.0001220703125), SC_(1.000051615552953128452105520486771074315), SC_(0.5161422091631080428484087308642550680092e-4) }},
      {{ SC_(2.000244140625), SC_(1.000103243380595112650112753954221989398), SC_(0.0001032380513640963581901732440393341809948) }},
      {{ SC_(2.00048828125), SC_(1.000206535863509719265815185078589813025), SC_(0.0002065145379145443567131291462537026096587) }},
      {{ SC_(2.0009765625), SC_(1.000413268164832140091644464679649856244), SC_(0.000413182793064254264258674986332041644883) }},
      {{ SC_(2.001953125), SC_(1.000827322309547415507838270760694901832), SC_(0.000826980267085383846585814529167493000815) }},
      {{ SC_(2.00390625), SC_(1.001657790373358329933817798077673136303), SC_(0.001656417755696172869171861186612377080916) }},
      {{ SC_(2.0078125), SC_(1.003328178532374632976589675522967237775), SC_(0.003322652404102649860792821138784654479368) }},
      {{ SC_(2.015625), SC_(1.00670686780833379252298939537881918096), SC_(0.006684476830232184945964816343819769497868) }},
      {{ SC_(2.03125), SC_(1.013616758636240255869592207887524642672), SC_(0.01352488366498562096813694557452593229433) }},
      {{ SC_(2.0625), SC_(1.028053821824495190057474817385146236144), SC_(0.02766752152285702349740729628994608012915) }},
      {{ SC_(2.125), SC_(1.059460537330914174098329196420878165961), SC_(0.05775985153034387160738826626309159079026) }},
      {{ SC_(2.125), SC_(1.059460537330914174098329196420878165961), SC_(0.05775985153034387160738826626309159079026) }},
      {{ SC_(2.25), SC_(1.133003096319346347478339111208647500936), SC_(0.124871714892396594302441287613198663149) }},
      {{ SC_(2.375), SC_(1.222256157589809843520837900591086450411), SC_(0.2006984603774558413588851802726110913487) }},
      {{ SC_(2.5), SC_(1.329340388179137020473625612505858887098), SC_(0.2846828704729191596324946696827019243201) }}
   } };

   static const boost::array<boost::array<typename table_type<T>::type, 3>, 40> near_0 = { {
      {{ SC_(-0.5), SC_(-3.544907701811032054596334966682290365595), SC_(1.265512123484645396488945797134705923899) }},
      {{ SC_(-0.375), SC_(-3.825383594908151401696052638550461697686), SC_(1.341658748500666418041408813274783487436) }},
      {{ SC_(-0.25), SC_(-4.901666809860710580516393213451562107405), SC_(1.589575312551185990315897214778782835911) }},
      {{ SC_(-0.125), SC_(-8.717218859383175610019014040823143769183), SC_(2.165300248905170251754061948144017406496) }},
      {{ SC_(-0.125), SC_(-8.717218859383175610019014040823143769183), SC_(2.165300248905170251754061948144017406496) }},
      {{ SC_(-0.0625), SC_(-16.64283217898827474335620507779073805782), SC_(2.811979623974363538327156032173660116805) }},
      {{ SC_(-0.03125), SC_(-32.60904080181356641807136153370035279623), SC_(3.484589575134139437621752672995683649279) }},
      {{ SC_(-0.015625), SC_(-64.59289502180392340168731059118495613226), SC_(4.168104420557250637548438174776914213865) }},
      {{ SC_(-0.0078125), SC_(-128.5849985248040153013528424941759712791), SC_(4.856590152781421724785721449662278434972) }},
      {{ SC_(-0.00390625), SC_(-256.581093070660182546052773550952658656), SC_(5.54744476696747159520708182472107347055) }},
      {{ SC_(-0.001953125), SC_(-512.5791508839791203712761106952360633215), SC_(6.239455139837046046486535948675082223324) }},
      {{ SC_(-0.0009765625), SC_(-1024.578182406251657399893334832135395808), SC_(6.932036277511308217556578672109549476158) }},
      {{ SC_(-0.00048828125), SC_(-2048.577698818873467519520786912493783878), SC_(7.624901025883858905611203245365810170653) }},
      {{ SC_(-0.000244140625), SC_(-4096.57745718775464971331294488248972087), SC_(8.317907137541219635377299172741804106947) }},
      {{ SC_(-0.0001220703125), SC_(-8192.577336412800240508542313129020709561), SC_(9.010983820432326192510172569412912814588) }},
      {{ SC_(-0.6103515625e-4), SC_(-16384.5772760354695939336148831283410381), SC_(9.704095761351551114080487592308688534482) }},
      {{ SC_(-0.30517578125e-4), SC_(-32768.57724584934032393443149086321342054), SC_(10.39722532438932175111825798174135071555) }},
      {{ SC_(-0.152587890625e-4), SC_(-65536.57723075690962899636361017901925666), SC_(11.09036369676269620616269440700453555078) }},
      {{ SC_(-0.762939453125e-5), SC_(-131072.577223210852757386190636818435916), SC_(11.78350647337298147181546230662592344689) }},
      {{ SC_(-0.3814697265625e-5), SC_(-262144.5772194378639394013199042046138782), SC_(12.47665145199400263809495861913874999345) }},
      {{ SC_(0.3814697265625e-5), SC_(262143.4227881080344625629331726731855155), SC_(12.47664704818796544202254047206534711638) }},
      {{ SC_(0.762939453125e-5), SC_(131071.4227918809440471962777925401520979), SC_(11.78349766576090681276037584294890342818) }},
      {{ SC_(0.152587890625e-4), SC_(65535.42279942668398540027145451732421438), SC_(11.09034608153854475277051988217319318753) }},
      {{ SC_(0.30517578125e-4), SC_(32767.42281451784694671242432333092929765), SC_(10.39719009394100176207788843272141977354) }},
      {{ SC_(0.6103515625e-4), SC_(16383.4228446989052821887834066513143242), SC_(9.704025300454774477951337474167744232248) }},
      {{ SC_(0.0001220703125), SC_(8191.422905055952190365785412912966413445), SC_(9.010842898637679655856679364462219607288) }},
      {{ SC_(0.000244140625), SC_(4095.423025749771641072803050389269325868), SC_(8.317625293943180446655815151656334697388) }},
      {{ SC_(0.00048828125), SC_(2047.42326705635054639115944072028773408), SC_(7.62433733861781159675772941549355054159) }},
      {{ SC_(0.0009765625), SC_(1023.423749345567830369498718239930270889), SC_(6.930908902419461889540619064660080535727) }},
      {{ SC_(0.001953125), SC_(511.4247126306315744461730129635313924869), SC_(6.23720038517533141916200085812091506718) }},
      {{ SC_(0.00390625), SC_(255.4266340463362315585318413027952788355), SC_(5.542935221819601325193091489756182014674) }},
      {{ SC_(0.0078125), SC_(127.4304564114296588115383352230100404938), SC_(4.84757077588166486683395477128488386733) }},
      {{ SC_(0.015625), SC_(63.43802046989131098729483943802528254174), SC_(4.150063373653938787298503499050432342073) }},
      {{ SC_(0.03125), SC_(31.45283517707606127304431578414621921504), SC_(3.44848912779795847968326934526863660858) }},
      {{ SC_(0.0625), SC_(15.48128108159239815615962077944690802663), SC_(2.739631621946203418585729650082232089145) }},
      {{ SC_(0.125), SC_(7.53394159879761190469922984121513362461), SC_(2.019418357553796345320290521167099589948) }},
      {{ SC_(0.125), SC_(7.53394159879761190469922984121513362461), SC_(2.019418357553796345320290521167099589948) }},
      {{ SC_(0.25), SC_(3.625609908221908311930685155867672002995), SC_(1.288022524698077457370610440219717295925) }},
      {{ SC_(0.375), SC_(2.370436184416600908646473504176652509887), SC_(0.8630739822706474624050890941340154953325) }},
      {{ SC_(0.5), SC_(1.772453850905516027298167483341145182798), SC_(0.5723649429247000870717136756765293558236) }}
   } }; 

   static const boost::array<boost::array<typename table_type<T>::type, 3>, 40> near_m10 = { {
      {{ SC_(-10.5), SC_(-0.2640121820547716316246385325311240439682e-6), SC_(-15.14727059071784114610117639552631963436) }},
      {{ SC_(-10.375), SC_(-0.3853824777091100016167565620752110328498e-6), SC_(-14.76902954720701012688042720516103787762) }},
      {{ SC_(-10.25), SC_(-0.67808180432946731304891004492754985848e-6), SC_(-14.20399790093109065161116876070387206737) }},
      {{ SC_(-10.125), SC_(-0.1684831262052517456216882327889895477394e-5), SC_(-13.293845140389538484236785089823191703) }},
      {{ SC_(-10.125), SC_(-0.1684831262052517456216882327889895477394e-5), SC_(-13.293845140389538484236785089823191703) }},
      {{ SC_(-10.0625), SC_(-0.3830328107020316635889325503807551568979e-5), SC_(-12.47256009081165579039929355805785844157) }},
      {{ SC_(-10.03125), SC_(-0.820629952953019778657392524711140975814e-5), SC_(-11.71060846332720387792243958913415617938) }},
      {{ SC_(-10.015625), SC_(-0.1700699874643038383461557487368349913225e-4), SC_(-10.98188560766303889037266091827081352261) }},
      {{ SC_(-10.0078125), SC_(-0.3463458256516313677243695342138690766685e-4), SC_(-10.27065787896126424410583159193311350064) }},
      {{ SC_(-10.00390625), SC_(-0.6990332874758209033426446699035926999779e-4), SC_(-9.568397288290682386853008683681967849367) }},
      {{ SC_(-10.001953125), SC_(-0.0001404477363900451708521851118608466504012), SC_(-8.870675121382310094805966387146254501189) }},
      {{ SC_(-10.0009765625), SC_(-0.000281540041401883411812666338203440274148), SC_(-8.175235877509399161097817609681419866606) }},
      {{ SC_(-10.00048828125), SC_(-0.000563726404385624063397951573975953521758), SC_(-7.480941522771659111292091779019988346536) }},
      {{ SC_(-10.000244140625), SC_(-0.001128100008866690679009902807702968873353), SC_(-6.787220469493554911614571257238006425123) }},
      {{ SC_(-10.0001220703125), SC_(-0.002256847657595184957233851276605048793085), SC_(-6.093786281167310238545736320487058532071) }},
      {{ SC_(-10.00006103515625), SC_(-0.004514343175062893955072428860155326550553), SC_(-5.400495578872419834979145899538225218653) }},
      {{ SC_(-10.000030517578125), SC_(-0.009029334320035575647839997474459714791226), SC_(-4.707276632982054173483611347195057396393) }},
      {{ SC_(-10.0000152587890625), SC_(-0.01805931666500754906434806474181437991942), SC_(-4.01409356864116185854622778461065066607) }},
      {{ SC_(-10.00000762939453125), SC_(-0.03611928138246679574769960801636554264536), SC_(-3.320928445911808853642423587159533484381) }},
      {{ SC_(-10.000003814697265625), SC_(-0.07223921083114343778444263107651750106133), SC_(-2.627772294197426150094657771000510514181) }},
      {{ SC_(-9.999996185302734375), SC_(0.07224050699108014022628046448675851453374), SC_(-2.627754351749084271591553302449947161499) }},
      {{ SC_(-9.99999237060546875), SC_(0.03612057754240364069840471083444586728855), SC_(-3.320892561015125097640948165422843317137) }},
      {{ SC_(-9.9999847412109375), SC_(0.01806061282494496405052242015364798732676), SC_(-4.014021798847794354581145064057511795502) }},
      {{ SC_(-9.999969482421875), SC_(0.009030630479975270775894162659645956519741), SC_(-4.707133093395319229856390889602684453056) }},
      {{ SC_(-9.99993896484375), SC_(0.004515639335011709650690623512369371764253), SC_(-5.400208499698950462148264857327856480671) }},
      {{ SC_(-9.9998779296875), SC_(0.002258143817580482923824809786660261248415), SC_(-6.093212122820375608272453375481778776963) }},
      {{ SC_(-9.999755859375), SC_(0.00112939616899791774095825334343857186485), SC_(-6.786072152799718574175843462405206935614) }},
      {{ SC_(-9.99951171875), SC_(0.0005650225651005676902373042742306456894427), SC_(-7.478644889384249821277500306107773873963) }},
      {{ SC_(-9.9990234375), SC_(0.000282836204451696233602080064105049188933), SC_(-8.170642610736687659976646968506313698216) }},
      {{ SC_(-9.998046875), SC_(0.0001417439087793817388175538505551912206884), SC_(-8.861488587853743723990903404527520549863) }},
      {{ SC_(-9.99609375), SC_(0.7119953849576511774290270246050426493188e-4), SC_(-9.550024221368402701862865053477154735263) }},
      {{ SC_(-9.9921875), SC_(0.3593094176075641243360143967272818899195e-4), SC_(-10.23391174619552949434163600960412224542) }},
      {{ SC_(-9.984375), SC_(0.1830395592410737084371847753712605958898e-4), SC_(-10.90839335076217169965796414369624068766) }},
      {{ SC_(-9.96875), SC_(0.9505651717966543211040666528035462899479e-5), SC_(-11.56362401857045907442600014919001566007) }},
      {{ SC_(-9.9375), SC_(0.5139309871979484321498376816774659227047e-5), SC_(-12.17859175366355833461560769108992933228) }},
      {{ SC_(-9.875), SC_(0.3033137834984411836791652786842133042328e-5), SC_(-12.70591288519170921633064985576606088605) }},
      {{ SC_(-9.875), SC_(0.3033137834984411836791652786842133042328e-5), SC_(-12.70591288519170921633064985576606088605) }},
      {{ SC_(-9.75), SC_(0.2197547155462853887868709703817446704567e-5), SC_(-13.02816874893114553892881831326149507953) }},
      {{ SC_(-9.625), SC_(0.2248214426276410648574460028763198846825e-5), SC_(-13.00537424512744790544056216033820032846) }},
      {{ SC_(-9.5), SC_(0.2772127911575102132058704591576802461667e-5), SC_(-12.79589533355436345901781053661879076815) }}
   } };

   static const boost::array<boost::array<typename table_type<T>::type, 3>, 40> near_m55 = { {
      {{ SC_(-55.5), SC_(0.3313939247684676728377268347296671102738e-73), SC_(-169.1931592947433577934436950412776436064) }},
      {{ SC_(-55.375), SC_(0.5931885913251829148011431845907438457576e-73), SC_(-168.6109546898941580979033836431457031234) }},
      {{ SC_(-55.25), SC_(0.128134265213561204650151776242601279892e-72), SC_(-167.8408033134133338381597995376176917559) }},
      {{ SC_(-55.125), SC_(0.3913191103476296924523858848738104144085e-72), SC_(-166.7243586084319013982262850893209212539) }},
      {{ SC_(-55.125), SC_(0.3913191103476296924523858848738104144085e-72), SC_(-166.7243586084319013982262850893209212539) }},
      {{ SC_(-55.0625), SC_(0.986732607487198018754292852511389106856e-72), SC_(-165.7994828862238820223463651561184383051) }},
      {{ SC_(-55.03125), SC_(0.2226660343675615375290464186909601183619e-71), SC_(-164.9856238363615162450940197678605306484) }},
      {{ SC_(-55.015625), SC_(0.4736069454740001055763353712089973133951e-71), SC_(-164.2309191328226253115354307486462442346) }},
      {{ SC_(-55.0078125), SC_(0.977114118293834733521912343859491871413e-71), SC_(-163.5066934315334134525852432438180103697) }},
      {{ SC_(-55.00390625), SC_(0.1984981336813056540008261636773673389822e-70), SC_(-162.7979320905915813518737104001603528406) }},
      {{ SC_(-55.001953125), SC_(0.4001152702583918680236220298606474660766e-70), SC_(-162.0969591073259992663458061954608696748) }},
      {{ SC_(-55.0009765625), SC_(0.8033716579133006533597549451686567408424e-70), SC_(-161.399894344940666691934457343256688548) }},
      {{ SC_(-55.00048828125), SC_(0.1609895558223411179719291838965309144853e-69), SC_(-160.7047872033597077904481004857770657217) }},
      {{ SC_(-55.000244140625), SC_(0.3222948938373906907742658942729222148632e-69), SC_(-160.0106597497627978468127607946271352327) }},
      {{ SC_(-55.0001220703125), SC_(0.6449058492709206027088103024110200975353e-69), SC_(-159.3170223595527956784727838139907674684) }},
      {{ SC_(-55.00006103515625), SC_(0.1290127899946570906748117205135768082314e-68), SC_(-158.6236300558849309281660984198839415596) }},
      {{ SC_(-55.000030517578125), SC_(0.2580572071228903781598785159467838581806e-68), SC_(-157.9303603092003033255947568117785799832) }},
      {{ SC_(-55.0000152587890625), SC_(0.5161460448765772204325064962419091742529e-68), SC_(-157.2371518444353362397006108889220356827) }},
      {{ SC_(-55.00000762939453125), SC_(0.1032323722132728230665906965174285853426e-67), SC_(-156.5439740214872098856520824742320518588) }},
      {{ SC_(-55.000003814697265625), SC_(0.2064679077519460715554797358664728667652e-67), SC_(-155.8508115196617565149201605014267824236) }},
      {{ SC_(-54.999996185302734375), SC_(-0.2064742345776389872444192676691131506575e-67), SC_(-155.8507808769879053144034254273344043224) }},
      {{ SC_(-54.99999237060546875), SC_(-0.1032386990389669331883069223703195417382e-67), SC_(-156.543912736139507484654652677755511734) }},
      {{ SC_(-54.9999847412109375), SC_(-0.5162093131335660989607568848213731056733e-68), SC_(-157.2370292737399314379940741096346901828) }},
      {{ SC_(-54.999969482421875), SC_(-0.258120475380070365932807313377307528986e-68), SC_(-157.9301151678094937244882657625299630878) }},
      {{ SC_(-54.99993896484375), SC_(-0.129076058252601515431668371755594450098e-68), SC_(-158.6231397731033117444057763960015760334) }},
      {{ SC_(-54.9998779296875), SC_(-0.6455385318809423304687659289501264852653e-69), SC_(-159.3160417939895574585734203633457962732) }},
      {{ SC_(-54.999755859375), SC_(-0.3229275765697223526481784197301709161285e-69), SC_(-160.0086986186363225879842786767213113941) }},
      {{ SC_(-54.99951171875), SC_(-0.1616222390439127298761439614470246404862e-69), SC_(-160.70086494110676672055309472267163668) }},
      {{ SC_(-54.9990234375), SC_(-0.8096985096986489455731873769112931053315e-70), SC_(-161.3920498204348601342401201789602276343) }},
      {{ SC_(-54.998046875), SC_(-0.4064422003228156070372890110113661523823e-70), SC_(-162.0812700583149908077227373306519861132) }},
      {{ SC_(-54.99609375), SC_(-0.2048253768707794232109022149495560465895e-70), SC_(-162.7665539925744016887591545718340828031) }},
      {{ SC_(-54.9921875), SC_(-0.1040399076590405899054222579682253865197e-70), SC_(-163.4439372355377521596244089121137210432) }},
      {{ SC_(-54.984375), SC_(-0.5369420317824801296090020359957584504561e-71), SC_(-164.1054067411408869986598886088213583004) }},
      {{ SC_(-54.96875), SC_(-0.2862019916619447982849309567142574291595e-71), SC_(-164.7345990554747140245090340482576614581) }},
      {{ SC_(-54.9375), SC_(-0.1630184748946170270451320476784206632433e-71), SC_(-165.2974333442636798880161449262335724888) }},
      {{ SC_(-54.875), SC_(-0.1068084665867092473960298264876009169786e-71), SC_(-165.7202596830189416811721153572453840111) }},
      {{ SC_(-54.875), SC_(-0.1068084665867092473960298264876009169786e-71), SC_(-165.7202596830189416811721153572453840111) }},
      {{ SC_(-54.75), SC_(-0.9545836185625177195542164628822374598687e-72), SC_(-165.8326067306542059861208673933569437798) }},
      {{ SC_(-54.625), SC_(-0.1206186475649396145903288691554707530168e-71), SC_(-165.5986629859610336595561650158366255984) }},
      {{ SC_(-54.5), SC_(-0.183923628246499558424938393274965246202e-71), SC_(-165.1767762739909689670975862547818473059) }}
   } };

   static const boost::array<boost::array<typename table_type<T>::type, 2>, 141> gammap1m1_data = { {
      {{ SC_(-0.4952165186405181884765625), SC_(0.7559827693907095754807809442951050489732) }}, 
      {{ SC_(-0.4642883241176605224609375), SC_(0.6574328869566978138139138799311066062094) }}, 
      {{ SC_(-0.4024595916271209716796875), SC_(0.4948624198600628575485791492257182331098) }}, 
      {{ SC_(-0.3901382386684417724609375), SC_(0.466994695902624837582482771934607569504) }}, 
      {{ SC_(-0.3875354826450347900390625), SC_(0.4612760821854033810460931227828015343156) }}, 
      {{ SC_(-0.373013198375701904296875), SC_(0.4303940312894863907637421435297095229576) }}, 
      {{ SC_(-0.364522993564605712890625), SC_(0.4131121158463471061555369932726425070959) }}, 
      {{ SC_(-0.35811364650726318359375), SC_(0.4004260060282522370607617707987066040664) }}, 
      {{ SC_(-0.342386901378631591796875), SC_(0.3705491389143732767395411311340356537958) }}, 
      {{ SC_(-0.311618030071258544921875), SC_(0.3168394199636867612664810682360364987851) }}, 
      {{ SC_(-0.2880756855010986328125), SC_(0.2795634828731819295069040561405863199118) }}, 
      {{ SC_(-0.27896595001220703125), SC_(0.2659494215075372040950689557832739194382) }}, 
      {{ SC_(-0.221501767635345458984375), SC_(0.1892800230490205183297725744929501015544) }}, 
      {{ SC_(-0.202970564365386962890625), SC_(0.1675837744862475402389911769714649852773) }}, 
      {{ SC_(-0.191832959651947021484375), SC_(0.1551782986717939911912971517092154248689) }}, 
      {{ SC_(-0.1387059986591339111328125), SC_(0.1019358076187795495751950704491293377337) }}, 
      {{ SC_(-0.1012614667415618896484375), SC_(0.06964849559574637322009665674759450635903) }}, 
      {{ SC_(-0.0782387256622314453125), SC_(0.05168944861403749320872745190411594799105) }}, 
      {{ SC_(-0.0146243572235107421875), SC_(0.008655823217365420051945171708362679166147) }}, 
      {{ SC_(0.1431564604442703013402649929484277542953e-29), SC_(-0.8263215150028947028222714725368343067077e-30) }}, 
      {{ SC_(0.1791466932348087634896446282571611213266e-29), SC_(-0.1034062776504410791508686126702507453693e-29) }}, 
      {{ SC_(0.6013619202535540063110633226832922483532e-29), SC_(-0.3471155206456177563387123499681270341265e-29) }}, 
      {{ SC_(0.115805324961653822428570241697281798758e-28), SC_(-0.6684464764687909153739175517973613571261e-29) }}, 
      {{ SC_(0.1422457400834001098175711728787848259007e-28), SC_(-0.8210646944165041873250036406993552111264e-29) }}, 
      {{ SC_(0.4970121018327539153628705477876439795096e-28), SC_(-0.2868831708235014101261168518349749234889e-28) }}, 
      {{ SC_(0.9660079415057497591758174164417478444323e-28), SC_(-0.5575949162564024099347963251548294827165e-28) }}, 
      {{ SC_(0.1232929313253182131376331095427391968754e-27), SC_(-0.7116661133260258147780879126862696392479e-28) }}, 
      {{ SC_(0.3296523285617759312781860549364832953326e-27), SC_(-0.1902804880171240659658521971091414147824e-27) }}, 
      {{ SC_(0.528364435768055252017009628713605422886e-27), SC_(-0.3049802291021812635024061181080113889506e-27) }}, 
      {{ SC_(0.886586057273120049620324386849842094685e-27), SC_(-0.5117513605413324831805933701656815521236e-27) }}, 
      {{ SC_(0.2499669674831043259218157022821422146034e-26), SC_(-0.1442848493391799075204112945868205575921e-26) }}, 
      {{ SC_(0.4131050397232622964314362671638736040881e-26), SC_(-0.2384507001780369908735157814349257650306e-26) }}, 
      {{ SC_(0.7679738097881433551381658732998641759182e-26), SC_(-0.4432865132438264916724504940164877771849e-26) }}, 
      {{ SC_(0.199929739820949207249437007767740538737e-25), SC_(-0.1154025777043396680338534232061371984153e-25) }}, 
      {{ SC_(0.5151477415246978459754129800826163591626e-25), SC_(-0.2973513461467014566158126478567428007026e-25) }}, 
      {{ SC_(0.101200734533556026342258477595279955025e-24), SC_(-0.5841464927231005972586520769367701801272e-25) }}, 
      {{ SC_(0.2064292695896540981798546456623054911033e-24), SC_(-0.1191542081013299677372796818685763621433e-24) }}, 
      {{ SC_(0.4063294332896333395257434433879773416284e-24), SC_(-0.2345397140053387487331153502526122099635e-24) }}, 
      {{ SC_(0.8138195767936862452966745688936976428456e-24), SC_(-0.4697494081288516881709792363579127898501e-24) }}, 
      {{ SC_(0.9575550627132253801929510132578249716542e-24), SC_(-0.5527157822038433842858279196451987644551e-24) }}, 
      {{ SC_(0.2855160956298500804375620841706273850616e-23), SC_(-0.1648043629790735548426012109835882111878e-23) }}, 
      {{ SC_(0.65201444297915461398563707001320281266e-23), SC_(-0.3763529502296153146061378052316774680657e-23) }}, 
      {{ SC_(0.1310988374636350038320977491775043421995e-22), SC_(-0.7567230263439006455136418784154172627278e-23) }}, 
      {{ SC_(0.2590288837798696209228010176465529547374e-22), SC_(-0.1495155293796993236481538654450094828034e-22) }}, 
      {{ SC_(0.2937779542193655202274099291941187976629e-22), SC_(-0.1695732371781431498672748630538267989951e-22) }}, 
      {{ SC_(0.7863513178004503049754083414326234074965e-22), SC_(-0.4538942987503834952636621253829968594981e-22) }}, 
      {{ SC_(0.1903818607087388763706780167350761726053e-21), SC_(-0.109891392314185724619218859435147914583e-21) }}, 
      {{ SC_(0.3812242142377350870566942975497647799754e-21), SC_(-0.2200485882977986685255989911406099731464e-21) }}, 
      {{ SC_(0.5493133580141330277178034419485741501887e-21), SC_(-0.3170722751854215599980143372792630827825e-21) }}, 
      {{ SC_(0.9672153634284186955666772243312215295852e-21), SC_(-0.5582918591043124472447977064584587087382e-21) }}, 
      {{ SC_(0.1702169477623814384559878647986894129041e-20), SC_(-0.9825188868017248805929057833465618943933e-21) }}, 
      {{ SC_(0.4817114569977399785676754474621208412799e-20), SC_(-0.2780513989416366360400948471972900830387e-20) }}, 
      {{ SC_(0.7538352992756463183303278501219690799218e-20), SC_(-0.4351255434976382024407146526549699565796e-20) }}, 
      {{ SC_(0.2596305715949999708394617609422128090557e-19), SC_(-0.1498628330119729391523576917959646915902e-19) }}, 
      {{ SC_(0.4444587480324321591032923385589104015025e-19), SC_(-0.2565485517668431887674899070788880246089e-19) }}, 
      {{ SC_(0.9715574921498573937069095571295029856174e-19), SC_(-0.5607982038213457280620337061143959968827e-19) }}, 
      {{ SC_(0.2036598542733453787268262970278076551267e-18), SC_(-0.1175556581981383412558675525031327289634e-18) }}, 
      {{ SC_(0.4248971931658660264162106698360155121463e-18), SC_(-0.2452573158680304024128136998709195441154e-18) }}, 
      {{ SC_(0.6521097487613458963613731825259556273977e-18), SC_(-0.3764079622200518159115220576707372289309e-18) }}, 
      {{ SC_(0.1436126164096190058281493628911107407475e-17), SC_(-0.8289545186912702312307596583951073368993e-18) }}, 
      {{ SC_(0.3118908901459261162419055180006211003274e-17), SC_(-0.1800283075323116855097674712567357424907e-17) }}, 
      {{ SC_(0.3593346613595175715618300349429858897565e-17), SC_(-0.2074135954788010816821644850649799519675e-17) }}, 
      {{ SC_(0.9445874854124767215374919304693435151421e-17), SC_(-0.5452306934500297136990208691880314661067e-17) }}, 
      {{ SC_(0.2566182432094081539023303073498993853718e-16), SC_(-0.1481240698799817909729203530750507585117e-16) }}, 
      {{ SC_(0.3363765695149349330660137891158001366421e-16), SC_(-0.1941618252298598450712101459398214835952e-16) }}, 
      {{ SC_(0.1073581901339262605326457800103412409953e-15), SC_(-0.6196882910077942026172170471644452240087e-16) }}, 
      {{ SC_(0.186668406231853462907965823802669547149e-15), SC_(-0.1077479282192287023344331697438668504475e-15) }}, 
      {{ SC_(0.3727540802657755688795382376099496468669e-15), SC_(-0.2151594942853688563255514533064804448857e-15) }}, 
      {{ SC_(0.6211646767866855090717281839829411183018e-15), SC_(-0.3585459819247720488263755672803206966864e-15) }}, 
      {{ SC_(0.1561186859754253464932505224282976996619e-14), SC_(-0.9011415112885851355703262394946230181441e-15) }}, 
      {{ SC_(0.3092010764722992466335682593125966377556e-14), SC_(-0.1784757049442269726369719145429686196432e-14) }}, 
      {{ SC_(0.6192850577371690132255643845837767003104e-14), SC_(-0.3574610363653403859138387348420733335946e-14) }}, 
      {{ SC_(0.1047879028014987723427253740737796761096e-13), SC_(-0.6048521898920322580919537460083385958307e-14) }}, 
      {{ SC_(0.1978473638988408750405412206418986897916e-13), SC_(-0.1142005977018810929368580238123776497134e-13) }}, 
      {{ SC_(0.4041816252346730475863978426787070930004e-13), SC_(-0.2332999655507978182935820166341591465938e-13) }}, 
      {{ SC_(0.9410302262901834580155480125540634617209e-13), SC_(-0.5431773877604405885692410233977439758357e-13) }}, 
      {{ SC_(0.1334530223958893535574077304772799834609e-12), SC_(-0.7703117505534481432167486795079037095016e-13) }}, 
      {{ SC_(0.266297021326439287136622624529991298914e-12), SC_(-0.1537108122261681912683838906901126667239e-12) }}, 
      {{ SC_(0.5920415525016708979677559909760020673275e-12), SC_(-0.3417356583762410657228951913532598329392e-12) }}, 
      {{ SC_(0.155163989296047688526414276566356420517e-11), SC_(-0.8956308525005437046951559037146364454014e-12) }}, 
      {{ SC_(0.326923297461201300961874949280172586441e-11), SC_(-0.1887052485148118271327652592003779278951e-11) }}, 
      {{ SC_(0.3753785910581841633870681107509881258011e-11), SC_(-0.2166744030260566997416579153839836535144e-11) }}, 
      {{ SC_(0.9579165585749116473834874341264367103577e-11), SC_(-0.5529244432689301568675461523208969657637e-11) }}, 
      {{ SC_(0.1858167439361402273334533674642443656921e-10), SC_(-0.1072563353975220567027440177997243696045e-10) }}, 
      {{ SC_(0.5449485307451595872407779097557067871094e-10), SC_(-0.3145528284818088265306644806429650505592e-10) }}, 
      {{ SC_(0.6089519166696533147842274047434329986572e-10), SC_(-0.3514965854368603547185748339618264962e-10) }}, 
      {{ SC_(0.1337744776064297980155970435589551925659e-9), SC_(-0.7721672402075083279577276691763777798079e-10) }}, 
      {{ SC_(0.2554458866654840676346793770790100097656e-9), SC_(-0.1474473672534405166880467009401481006846e-9) }}, 
      {{ SC_(0.9285605062636648199259070679545402526855e-9), SC_(-0.5359796691714968347006887450221011388011e-9) }}, 
      {{ SC_(0.1698227447555211711005540564656257629395e-8), SC_(-0.980243482442200345890191122898173278899e-9) }}, 
      {{ SC_(0.339355921141759608872234821319580078125e-8), SC_(-0.1958815525210918994679361737180445367869e-8) }}, 
      {{ SC_(0.6313728651008432279922999441623687744141e-8), SC_(-0.3644383041872783822741274272616254061398e-8) }}, 
      {{ SC_(0.8383264749056706932606175541877746582031e-8), SC_(-0.4838951666662356901644608730186546413827e-8) }}, 
      {{ SC_(0.1962631124285962869180366396903991699219e-7), SC_(-0.1132861391263510827635198807950784606364e-7) }}, 
      {{ SC_(0.5256384838503436185419559478759765625e-7), SC_(-0.3034067396263077516870264512967026960836e-7) }}, 
      {{ SC_(0.116242290459922514855861663818359375e-6), SC_(-0.6709685761311096545819618213723265238395e-7) }}, 
      {{ SC_(0.1776920584006802528165280818939208984375e-6), SC_(-0.1025666084085592538025029643343934584008e-6) }}, 
      {{ SC_(0.246631174150024889968335628509521484375e-6), SC_(-0.142359317011220184093241753035251343271e-6) }}, 
      {{ SC_(0.7932688959044753573834896087646484375e-6), SC_(-0.4578866108069128537168607745624614794722e-6) }}, 
      {{ SC_(0.1372093493046122603118419647216796875e-5), SC_(-0.791991995861101927407880386227298092424e-6) }}, 
      {{ SC_(0.214747751670074649155139923095703125e-5), SC_(-0.1239553101482841564081262476002391564028e-5) }}, 
      {{ SC_(0.527022712049074470996856689453125e-5), SC_(-0.3042030180348038757030022358659056016131e-5) }}, 
      {{ SC_(0.9233162927557714283466339111328125e-5), SC_(-0.5329441960781667799420300524501852822265e-5) }}, 
      {{ SC_(0.269396477960981428623199462890625e-4), SC_(-0.1554926893050895772896453957379474045684e-4) }}, 
      {{ SC_(0.3208058114978484809398651123046875e-4), SC_(-0.1851639610824637542072201121307897455015e-4) }}, 
      {{ SC_(0.00010957030463032424449920654296875), SC_(-0.6323382317252073303439803607481865268353e-4) }}, 
      {{ SC_(0.000126518702018074691295623779296875), SC_(-0.7301274674392621832822527575061291232133e-4) }}, 
      {{ SC_(0.00028976381872780621051788330078125), SC_(-0.0001671731931845284705043154051351730706298) }}, 
      {{ SC_(0.000687857042066752910614013671875), SC_(-0.0003965741858362509385654340724912705823236) }}, 
      {{ SC_(0.00145484809763729572296142578125), SC_(-0.0008376704829300962209037156359622989708524) }}, 
      {{ SC_(0.00366270542144775390625), SC_(-0.002100946766981816464155333982357752904999) }}, 
      {{ SC_(0.046881496906280517578125), SC_(-0.02497588947336944943591732868959193811385) }}, 
      {{ SC_(0.04722058773040771484375), SC_(-0.02514197077286474061941968460870171431946) }}, 
      {{ SC_(0.1323592662811279296875), SC_(-0.06091072639354085529687250076608036167983) }}, 
      {{ SC_(0.139763355255126953125), SC_(-0.06350237679012056526225278765134891026831) }}, 
      {{ SC_(0.155740678310394287109375), SC_(-0.06883441875617310404657299803607175885806) }}, 
      {{ SC_(0.17873513698577880859375), SC_(-0.07590347542832235360535014668688262042636) }}, 
      {{ SC_(0.1813595294952392578125), SC_(-0.07666619009216679212771233211297326572625) }}, 
      {{ SC_(0.225838959217071533203125), SC_(-0.08828121583826801836069461556215827733624) }}, 
      {{ SC_(0.292207300662994384765625), SC_(-0.1013142147509511845410398110728244632327) }}, 
      {{ SC_(0.297928631305694580078125), SC_(-0.1022125377703106514269725748156778633457) }}, 
      {{ SC_(0.29810583591461181640625), SC_(-0.1022398124529602122123098193784073635017) }}, 
      {{ SC_(0.30028045177459716796875), SC_(-0.1025718475377491669113360177547935208456) }}, 
      {{ SC_(0.314723670482635498046875), SC_(-0.1046527148786850527567817015912636515928) }}, 
      {{ SC_(0.335008561611175537109375), SC_(-0.1072166100764849221291653907100739024018) }}, 
      {{ SC_(0.34912931919097900390625), SC_(-0.1087597918806720999316678995289547437333) }}, 
      {{ SC_(0.378430664539337158203125), SC_(-0.1113472284261879798379642546535625292991) }}, 
      {{ SC_(0.405791938304901123046875), SC_(-0.1130363541503776146472634379575969350382) }}, 
      {{ SC_(0.4133758544921875), SC_(-0.1133834162443148976453781329005327033269) }}, 
      {{ SC_(0.415735542774200439453125), SC_(-0.1134808289122708542397946052703635909288) }}, 
      {{ SC_(0.43399322032928466796875), SC_(-0.1140666251072475325460987089801937766512) }}, 
      {{ SC_(0.457166969776153564453125), SC_(-0.1143882508090213200510081514983929178479) }}, 
      {{ SC_(0.457506835460662841796875), SC_(-0.1143895043011533114503086722896019260013) }}, 
      {{ SC_(0.4594924449920654296875), SC_(-0.1143948425572877686750521180317509748309) }}, 
      {{ SC_(0.464888513088226318359375), SC_(-0.1143922664386800836288584840918904877633) }}, 
      {{ SC_(0.467694938182830810546875), SC_(-0.1143810844126184461958335384166685988825) }}, 
      {{ SC_(0.468867778778076171875), SC_(-0.114374421494214380845931849419009841586) }}, 
      {{ SC_(0.470592796802520751953125), SC_(-0.1143624939837521390307936225841266176506) }}, 
      {{ SC_(0.481109678745269775390625), SC_(-0.1142351916017016455044428590981136786372) }}, 
      {{ SC_(0.492881298065185546875), SC_(-0.1139822218283491394475161618135268104636) }}, 
      {{ SC_(0.496461331844329833984375), SC_(-0.1138823102618022293565213085801050842487) }}
   } };

