// Copyright John Maddock 2012.

// Use, modification and distribution are subject to the
// Boost Software License, Version 1.0.
// (See accompanying file LICENSE_1_0.txt
// or copy at http://www.boost.org/LICENSE_1_0.txt)

#ifndef SC_
#  define SC_(x) static_cast<T>(BOOST_JOIN(x, L))
#endif
   static const boost::array<boost::array<T, 5>, 400> jacobi_elliptic = {{
      {{ SC_(9.7540378570556640625000000000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(9.7540378570556640625000000000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(9.7384321813508780300050309993112921610348339609531096226291156957843807163438391463300771570266454611e-02), SC_(9.9524685071841496279438927849850673342525676921414792528840427410727111940782381944976305408868157855e-01), SC_(9.9995488439733316729114394585903874689886199946693440341361736436672692239264636048488084336908171547e-01) }},
      {{ SC_(9.7540378570556640625000000000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(1.2698680162429809570312500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.7383306026428126815811673852101862643417212675894886262329096942831342806175591481538515201116435095e-02), SC_(9.9524695011206291426731901545274769005867525867705503210833924341584688692109569818882782443312019870e-01), SC_(9.9992353321916073154296514614318371763529995049379965142148455053362169878708374701587696243287582131e-01) }},
      {{ SC_(9.7540378570556640625000000000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(1.3547700643539428710937500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.7382963663268679354766311462039914384149178492941126840831062817834448292082576674044335924290112792e-02), SC_(9.9524698361168545268757042933526662768772514619668023376490370653166168736869277815425438301697322693e-01), SC_(9.9991296657753407444565165371686075323189094367991128619066744668429579140503359966446931860569605749e-01) }},
      {{ SC_(9.7540378570556640625000000000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(1.8838196992874145507812500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.7380331287488173017819681812505333548000401340832607031998520409371778408842832201970632399407455377e-02), SC_(9.9524724118097360944629737689090579536626111956092105184429209919209960381948277540779135011872980164e-01), SC_(9.9983172185713251267253025953154802657840786163407200767760200375372426265381549093953869220602182213e-01) }},
      {{ SC_(9.7540378570556640625000000000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(2.2103404998779296875000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.7378277454797060918439287025630752988524259325176347053163180340804501139998370882347991305783292950e-02), SC_(9.9524744213684697238369251137951559191374873239697065458847170083807556278595809556474002748294261664e-01), SC_(9.9976833370589598055738289274893465677056797771478451409770833086130339040015264801585644093126658918e-01) }},
      {{ SC_(9.7540378570556640625000000000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(2.7849817276000976562500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.7373867428466078827183319249605829662038878958674322241785141561706308176062148140500575389736858636e-02), SC_(9.9524787361843859046684503694959443606213073331077397309037690642929126741546581484860725317608308903e-01), SC_(9.9963222736499384529570421859460465646281312249068720158613197297025393833765853405888603462853042983e-01) }},
      {{ SC_(9.7540378570556640625000000000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(3.0816698074340820312500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.7371193424879810007588652514672604171038551577576512840133215162813719206019907024377008226545048940e-02), SC_(9.9524813523614031580155154272347701177066765446592058958809789667054121097494545539509044453284397477e-01), SC_(9.9954970099303609847458849068667534444745484953685258900209171332658289031259888119908884757012452532e-01) }},
      {{ SC_(9.7540378570556640625000000000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(5.4688143730163574218750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.7339839179579928018704143000418077269746964304983646252493319558842047662986337736134976401214155303e-02), SC_(9.9525120231451793830985245843366966203733236112111860397852232906222180662225991758767056042339001978e-01), SC_(9.9858209994199781278941437194680143132324188699653873991712233555081338659514668305299268048007246328e-01) }},
      {{ SC_(9.7540378570556640625000000000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(5.4722046852111816406250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.7339782204735098983141505623993711911459001259399602837752570540694687172295574882766475269842999767e-02), SC_(9.9525120788690065078512180252804658575870883738949865086421010712034580246577640951605540994760241665e-01), SC_(9.9858034179693371185530389839478102909306909444244139828444148460849700760700112751223062617432481898e-01) }},
      {{ SC_(9.7540378570556640625000000000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(6.3235926628112792968750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.7324357382337915060878514538001614103127959113855749132567239992517451675127438717163091023277436887e-02), SC_(9.9525271637916917939363212827434662588809382803755724970123962674618546815060076204600270615937503766e-01), SC_(9.9810437384215507531192865121492102169160078954931664380383811419406897938852089977538372535612829971e-01) }},
      {{ SC_(9.7540378570556640625000000000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(8.1472349166870117187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.7283832207787332968350504435429144214762136106042661009244142576287985290132328716551768340406726525e-02), SC_(9.9525667844580027212519964525662529454780451004601160492220566958669619783126116364988358493401101876e-01), SC_(9.9685402331179302384119860067365790061187418556554456085008029417476701630546266620873973439295183575e-01) }},
      {{ SC_(9.7540378570556640625000000000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(8.3500838279724121093750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.7278693925629101473730435341228310212032309563196883073408404976412708107672325578164629264874000079e-02), SC_(9.9525718068654182996379555937806239819599280949500315783758413223431440712177599882842080674201603958e-01), SC_(9.9669550352317052980773857626559666269204531893591114427801701253901312521428606453243059354958930545e-01) }},
      {{ SC_(9.7540378570556640625000000000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(9.0579175949096679687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.7259775696151969231560088118671897900432100312079923769575924893086166745621797945635252162042457459e-02), SC_(9.9525902961567457799459980362930626346578307070578660454715450064990786754293178291486280639555469960e-01), SC_(9.9611189149631570780194584866472514410147478802889450853381129958809506344781648993683324004393139400e-01) }},
      {{ SC_(9.7540378570556640625000000000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(9.1337585449218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.7257657583072734398564817378715512213597927085867646425816327114748354915967246517590740628001648382e-02), SC_(9.9525923660192864077140433651715283184822491030430309366345862602952814976707227038950564349076111474e-01), SC_(9.9604655229407085613020817827545499990274574505860169796764685614255261186781008745763895029260399934e-01) }},
      {{ SC_(9.7540378570556640625000000000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(9.5750665664672851562500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.7244982770042818904024531685011575954627230233210286803989361976045451794730571449048456332621323951e-02), SC_(9.9526047511495907655064681291117857597207801050777388462844588407020878200858505148516677103386126487e-01), SC_(9.9565557382340077224630623621638890196227919522504229996558938083078176693734660018540050675794907254e-01) }},
      {{ SC_(9.7540378570556640625000000000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(9.6488833427429199218750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.7242804401238330394641034407571773598415791334970660265829118621816630813903078372035638501402854060e-02), SC_(9.9526068795676969770830147652098548970870591187020705631353682973051952503866517509360167878496802699e-01), SC_(9.9558838001891729294499891780505516968777413390971340214047171239353816575095609120301571391073133445e-01) }},
      {{ SC_(9.7540378570556640625000000000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(9.6769475936889648437500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.7241971830040626580775446834986136249520903646682302901559733248423563672355475550286992004247011330e-02), SC_(9.9526076930350549471991585281853568963609976679114746406156151825336912211360294679020458186631077546e-01), SC_(9.9556269875012748079193459899059614648026964684907523159920139031085488131527377860967239854162520648e-01) }},
      {{ SC_(9.7540378570556640625000000000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(9.6886777877807617187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.7241623119621507768675533305231494633519052635102622629454283243024320020666848207623354683904466225e-02), SC_(9.9526080337420175720684817572609318291152213025067248310909549916814881246189911074085103017210067969e-01), SC_(9.9555194254819173899689090341202623861942977239356687223773368135903981199872362824922639858352857970e-01) }},
      {{ SC_(9.7540378570556640625000000000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(9.9288129806518554687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.7234391800827738968992450665433357666742411135127401009733638701177282347102378993477236969678654384e-02), SC_(9.9526150988125885796360273996610273175186092020643789825948701988318876024022145047763437281682892141e-01), SC_(9.9532889129818059354033929751614120883992975273268479379992266644335702830351636902588795874617070406e-01) }},
      {{ SC_(9.7540378570556640625000000000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(9.9646115303039550781250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.7233298644478973403186335285900151115960047949746687839215967221911192031090096952634390287961810058e-02), SC_(9.9526161667910893238555566309439694986630762455664353906763841267218133910312675011879044026031301748e-01), SC_(9.9529517329166101513341571318056995313554164948688445541889776316051021077409476762097381272562596493e-01) }},
      {{ SC_(1.2698680162429809570312500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.7540378570556640625000000000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(1.2664257541417004306368951282691748727550124386720100600608750546318698226257203720501683038955900435e-01), SC_(9.9194841503601700817490236765031671061294384597914801836296273830499788073745688271122867056931693804e-01), SC_(9.9992370169081134090096139778728212576933539830520415345599126533770335253944052333509204238907245252e-01) }},
      {{ SC_(1.2698680162429809570312500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.2698680162429809570312500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.2664034438368367615558599657163363971530646734795711968270194977547712684218447066591858350732790914e-01), SC_(9.9194869987030175974065452521412422683585122017884833703172127477318391160839598306916141357487061604e-01), SC_(9.9987068186822403724749028083081518011247091434035237209533262760757214065053721683798188881413986251e-01) }},
      {{ SC_(1.2698680162429809570312500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.3547700643539428710937500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.2663959243421258905813608345822828017922530244400625498512136982817465216522876223180316746892978949e-01), SC_(9.9194879587007742159475715284033058520863291944391982961636532662432995118718631907184665515795900253e-01), SC_(9.9985281208317985060971531909892334434677570476838685775408615707510438112357380797799157313711172762e-01) }},
      {{ SC_(1.2698680162429809570312500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.8838196992874145507812500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.2663381084916491805090059492100784238269531877861315216778816447532202573932684348672955289435329564e-01), SC_(9.9194953397328531710160500722460026622655952036103040094265110799584619676852721018077456040008038541e-01), SC_(9.9971541642789849558372993501158595197975574212963933886048158773290926889665199945423225402810274253e-01) }},
      {{ SC_(1.2698680162429809570312500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.2103404998779296875000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.2662929998242081571139218814069795892923025976302653342009659020548480739650785177125529517333216777e-01), SC_(9.9195010982708302717556304478333609322185594815599681184080622604103482677714560248637311499973443224e-01), SC_(9.9960822036141720568423059443779597670253897270187040517610329946323987386528311228454125508327135443e-01) }},
      {{ SC_(1.2698680162429809570312500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.7849817276000976562500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.2661961429460418896967396810246571405727207422895958972385864065275488877136482238636675755124590557e-01), SC_(9.9195134622414100866733580145832318164333662539872220791472939170731476462823729405537088602256531729e-01), SC_(9.9937805532816590734549896953199729957319400587793257255984019593010016180390682729079027380693079026e-01) }},
      {{ SC_(1.2698680162429809570312500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(3.0816698074340820312500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.2661374149642430498275814078314106907940053959163726876931088942592173877800165066908556638658111681e-01), SC_(9.9195209585154697731347941628428426390274881177960013587295374143129739974658168687491437531765414110e-01), SC_(9.9923850109148547626583577239570508951580732513750278611967550553394336805805481340265773352381893379e-01) }},
      {{ SC_(1.2698680162429809570312500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.4688143730163574218750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.2654488424423158028146538144364661933525780622463738133669996961977781584193025131615978691374736521e-01), SC_(9.9196088243015612875932298709053672424734467141780120825856707350305433097042525294321552164863047109e-01), SC_(9.9760245654598811811584699102546894291904546191886429980627001499665291127151607954102898970245409851e-01) }},
      {{ SC_(1.2698680162429809570312500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.4722046852111816406250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.2654475912933657371715784577955371713950703838798566033558563166548518653854245032696681907807858998e-01), SC_(9.9196089839111006557460998819888205150549888102742495979786588774847517740582706614262145998016077843e-01), SC_(9.9759948415480573100107351286434486993251335277288542659411034077442010567990044154536613504939145113e-01) }},
      {{ SC_(1.2698680162429809570312500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(6.3235926628112792968750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.2651088778028249529681324961472643930079008980008330443355801794393510519029990510797116683182423634e-01), SC_(9.9196521878191110759219578926460974418887553288384632411906981490130493843683671418532806952146307632e-01), SC_(9.9679483689080146267036555206087036941264673152290486533337176224825544066841611926466991550562261874e-01) }},
      {{ SC_(1.2698680162429809570312500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.1472349166870117187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.2642190862830527580721215526505229730209030323519852184974507764030465101007745564782832625354258426e-01), SC_(9.9197656273662858755859536262180938253203297732542725317281233590840843833734141008855041566100980432e-01), SC_(9.9468147004035723310154343069206567712485541810261085505258701220192600870722139834124181369745440365e-01) }},
      {{ SC_(1.2698680162429809570312500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.3500838279724121093750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.2641062779058421570460511065537410136170983657735378675244278309981837665101907468118588301864017788e-01), SC_(9.9197800035161585107950888704067358591074934045565763068610700126705898581352101079650398461144515141e-01), SC_(9.9441357947410335444584081726543013089369655154563276876730738364115365115945214421916656677513127714e-01) }},
      {{ SC_(1.2698680162429809570312500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.0579175949096679687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.2636909579190592105840772186634053855349665235538976974328031718322404357760490206890129340398145436e-01), SC_(9.9198329201087661526570442454915583057671389462271501447012368719319859755566546725291094557801848466e-01), SC_(9.9342738693000332599023435146912056910259930440443406932062169067850277571529149341681342988839858382e-01) }},
      {{ SC_(1.2698680162429809570312500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.1337585449218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.2636444600483454929809127650268940119326928490721071275191947418049108665734760052441701951562321976e-01), SC_(9.9198388433779066797744876757243919372651978497089148515009099094125826299863226947736370553030004936e-01), SC_(9.9331698429837425360137946605738697988644994627479783349201698499483352546906337696828993453198700348e-01) }},
      {{ SC_(1.2698680162429809570312500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.5750665664672851562500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.2633662245544303531719706451224656938088018551336847850918095777656808440418945955176998974002039419e-01), SC_(9.9198742826033377437823497104917645079765256177257169457781597834796787192740582416312249294742280701e-01), SC_(9.9265638818123717829044416267324424208436635214457530159464907190816190360604911936503335242971313706e-01) }},
      {{ SC_(1.2698680162429809570312500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.6488833427429199218750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.2633184067787117083347366979634799834393108210376717864379715524888076823028318808344928893828596585e-01), SC_(9.9198803724185150828250582980593063042679670221557857339102660580508587204564758906924039446639017382e-01), SC_(9.9254286360607095310872869643825082215490324697349858219115342380174729398452659970029364958049644953e-01) }},
      {{ SC_(1.2698680162429809570312500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.6769475936889648437500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.2633001309656437482138428320121532543634522262273343831850781936735439680488083844595421989351804066e-01), SC_(9.9198826998660718716837813804502039249483935740565168392192363791315425400298946293811987436525091633e-01), SC_(9.9249947531299439702698295127464023422759266902968622218955461594085751552138129781542248325997359130e-01) }},
      {{ SC_(1.2698680162429809570312500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.6886777877807617187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.2632924764235816731122490282788085050476197822831510526557353497849620409416563257619528664279583130e-01), SC_(9.9198836746713705777141680982103677818496328716939109700349370063712332759617804108545679620324882243e-01), SC_(9.9248130287295519744310865030952607670744265802403537347802822028594500474500607852951661534106741075e-01) }},
      {{ SC_(1.2698680162429809570312500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.9288129806518554687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.2631337441785326687816634005477747453164660541828162776424733100301553637815563590107827363665848737e-01), SC_(9.9199038878568536858418121802450500485198240142002220024192700917283352293061580769708240953851525272e-01), SC_(9.9210447114215378460735781102561770935245345554665212827381606721877666899124939323242771637869862343e-01) }},
      {{ SC_(1.2698680162429809570312500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.9646115303039550781250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.2631097490742989492657063944430274528211968079074595010518144227487275486133207409344783969804883908e-01), SC_(9.9199069432023132030724337389389222909214633265360595954651526035596677698452115639274936117462678109e-01), SC_(9.9204750824490307674819232713512953979951089427971007026054590889954850519860270336808200548690138901e-01) }},
      {{ SC_(1.3547700643539428710937500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.7540378570556640625000000000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(1.3505906957854976487019467229150809299318994437628105664808750542677436676111732863997438626947793430e-01), SC_(9.9083754860450078395332681477647907903642750464099497421905382162419258175583803075318058079728369191e-01), SC_(9.9991322288071247194195204891653593075842464302209725187751044432311136062342207945950982768236536585e-01) }},
      {{ SC_(1.3547700643539428710937500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.2698680162429809570312500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.3505636471649210372603198422461956650248783568616264379949905080830384864418695971926895389672075266e-01), SC_(9.9083791729503663901050275565174316583124095890337567827942102794837398209846047692450885437410150910e-01), SC_(9.9985292148901205467810449327038587744280341027642623486742152766298960207302364016802381421894872186e-01) }},
      {{ SC_(1.3547700643539428710937500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.3547700643539428710937500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.3505545306702043324555247360993267218152563908287211742085132195375578775329170689622874882692407421e-01), SC_(9.9083804155717691189280521944749172668102641028654697238445838592256772810050311373624809701571899797e-01), SC_(9.9983259755816988650741468172676291742309735190889277059133765868842785460233762823103667649992172288e-01) }},
      {{ SC_(1.3547700643539428710937500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.8838196992874145507812500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.3504844359527710271421527734139016831004439520985972915688817561116621544183023138860891351026536269e-01), SC_(9.9083899695283151430767142615710266889023172523613911873972859255494532949124882527713027148994917091e-01), SC_(9.9967633321925125060065709538611712355608318330552064140177150622272431910857883885592327269685959150e-01) }},
      {{ SC_(1.3547700643539428710937500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.2103404998779296875000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.3504297473257173875471819102320292659475059993694916993825457206771827329180416622176168121018029783e-01), SC_(9.9083974232737454873736188425996276677442026397246869439168189866777079392887025814578836333803069333e-01), SC_(9.9955441647276913066801367472567078396542980367428451621363490179554166790416332918254803717100398131e-01) }},
      {{ SC_(1.3547700643539428710937500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.7849817276000976562500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.3503123209571208309363420689950731116982605531298413808499070898093452268543670766437579056569141833e-01), SC_(9.9084134267738038050957477136668274555739381574666904146465394636521539120180597541097029906956114518e-01), SC_(9.9929264603467677351450162743852392690540061085831323090957515452329013442250362757056746876653781443e-01) }},
      {{ SC_(1.3547700643539428710937500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(3.0816698074340820312500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.3502411212508212376952373835067574915279745260836873262492709373071630554211876591297721702778959691e-01), SC_(9.9084231295642257235957756239166010258356457850169518192411961653264629445989143219869838177725648101e-01), SC_(9.9913393003649550818161042129707375183438189378349987392384398541248301402040108040099627017157786572e-01) }},
      {{ SC_(1.3547700643539428710937500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.4688143730163574218750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.3494063393531688685189672787730371372304351081922879121972752483013846971164990658159252018785670550e-01), SC_(9.9085368511861265852603894538994285296494825125674598030544377888683597727115843604773942558265971424e-01), SC_(9.9727331884454411201298964238842324037440988940893185806909188329933516194285753882038200949518729618e-01) }},
      {{ SC_(1.3547700643539428710937500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.4722046852111816406250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.3494048225706637862451725568680331469399277471972125123717115147463127823521362287219487127858824550e-01), SC_(9.9085370577509087391361033622885993099888051152615830483178373490291403040576652084310648551294729353e-01), SC_(9.9726993858062915563755561920401451474696518575466389795134153908170245585822598399918740623751537952e-01) }},
      {{ SC_(1.3547700643539428710937500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(6.3235926628112792968750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.3489942004583462344121895006728197036775770230702790778385499483882626759432853510849681117183885112e-01), SC_(9.9085929701007371219201469868355260494070513245456121257345888724705987699314688550077102623601479180e-01), SC_(9.9635489376482160735399354751961369470671029163998517793229466128340958374134582010970709972492125902e-01) }},
      {{ SC_(1.3547700643539428710937500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.1472349166870117187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.3479155468769529785824989553678949935421476984186554822956711375215160274791840110515300162114622010e-01), SC_(9.9087397623758090489855479898674509914766999176876305224298739636032678469300289451325464647024533775e-01), SC_(9.9395172955318900862818177587138758473751411180028969893594909441640672928704131263937731193468478648e-01) }},
      {{ SC_(1.3547700643539428710937500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.3500838279724121093750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.3477787985804195551290062061667312473352758786187465898353053105051583790362022233154294630345474410e-01), SC_(9.9087583636950760418641691826412344110863951784909240931531476244987070334260239220655853598818344608e-01), SC_(9.9364712044063046563119875727296706821176953323619589918533456022336596547248767494448174026190982665e-01) }},
      {{ SC_(1.3547700643539428710937500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.0579175949096679687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.3472753484327469036613657994931135857946828796319703180123987490003848234874864543550820058070908682e-01), SC_(9.9088268294236235696243337297551772665412284539794608780701996422590496148845012930186144486571377190e-01), SC_(9.9252578636742026017634289940072300165156668087356160987645005444477962543868246708950979315854791149e-01) }},
      {{ SC_(1.3547700643539428710937500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.1337585449218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.3472189845836226732720523076066697064609012193688383728787822345544093108047285712580988910864658388e-01), SC_(9.9088344928945842522308034863080449654517680499896121562430259522989416864005471012960172138527884036e-01), SC_(9.9240025794020559003071175074148167658660780947701859364792845954964336615526416541307074915126550053e-01) }},
      {{ SC_(1.3547700643539428710937500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.5750665664672851562500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.3468817160339658757349641819431933783491972524438144267894252921514719208124518247409902880367942710e-01), SC_(9.9088803425519979033017291630590407430230016012424692571907886895450418899602865278685400092707306690e-01), SC_(9.9164916930077531091711182978835510066320287574729076345931503999726269262053389065942152141429692688e-01) }},
      {{ SC_(1.3547700643539428710937500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.6488833427429199218750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.3468237533613298415352213465915304823291622515298740593955406528805793153167536525902264345087161272e-01), SC_(9.9088882210559676776361722252831893991697501702057892993330154712321749747908070008813558991280374984e-01), SC_(9.9152009566466638608392331206960239508771721884430969107326748378801662480547031160656546873551148852e-01) }},
      {{ SC_(1.3547700643539428710937500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.6769475936889648437500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.3468016002428164699967739485847081687823030012320420890630695361527675182305857169322393687599550706e-01), SC_(9.9088912320997543977953251452359060677263676369690512687287188891324115734702627203643807654479928534e-01), SC_(9.9147076480311719511668184351271563431466605498306695230282244404834961660297989846830110634051814057e-01) }},
      {{ SC_(1.3547700643539428710937500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.6886777877807617187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.3467923217585241503623642749011601064091539038703793302110440701409985939738806187684222428028886689e-01), SC_(9.9088924932129667321730787466432018038804398920741477796407189327926889215485273700503113812578316072e-01), SC_(9.9145010344896372480622602880633201494581305713083012084212155340350559996580723267428859746613079498e-01) }},
      {{ SC_(1.3547700643539428710937500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.9288129806518554687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.3465999147904104119794265128548403163939229780524067585367029993352622268163125198974916154455235918e-01), SC_(9.9089186427927875795932051517957132163415217697929336041660856309143973798722299817009058127526898844e-01), SC_(9.9102166428267351151509659876674422449121926806306151995784209205135895844193229239869745233066098955e-01) }},
      {{ SC_(1.3547700643539428710937500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.9646115303039550781250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.3465708293343586023671393978738332485491911918948132092224094652995111367889963413571035123783860016e-01), SC_(9.9089225953978355657436806662705311885012153088102010444688278441589048117371455568499119273499007407e-01), SC_(9.9095690089519852209032599301184815230620852882540945965336134071959287839309645801096957884843263609e-01) }},
      {{ SC_(1.8838196992874145507812500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.7540378570556640625000000000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(1.8725939670285395654283521058419496476595039493627735199080671783479304207612768980819534778138264783e-01), SC_(9.8231049996754242612091578087931860169213834957828523625436997934213583714487816395825605400401602506e-01), SC_(9.9983317453465671811946936687637939890931825361493561113972206150537023144143836517012685023130710687e-01) }},
      {{ SC_(1.8838196992874145507812500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.2698680162429809570312500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.8725221189437532667500822302526268645353988375857869269183312674137176234050722091489438706492774308e-01), SC_(9.8231186959166077432509632373722070416853983028706541997404138882451891972724254552789845329663904090e-01), SC_(9.9971725008063781891781090308742893104145289524484154366231074848902393888902956581920694429778189309e-01) }},
      {{ SC_(1.8838196992874145507812500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.3547700643539428710937500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.8724979033503657288250196057598152862315191959594624980720773249102394738614027654979407677361635647e-01), SC_(9.8231233119588030755375146886907706272118339043053505475194671823076376902872880290333890998824377929e-01), SC_(9.9967817946240730917424186503435105625063607349988779332440619084322548703551053593971030086171547697e-01) }},
      {{ SC_(1.8838196992874145507812500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.8838196992874145507812500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.8723117176626887525383795148524825642175550603138355258660945015478698608704820001936764207093714312e-01), SC_(9.8231588011139773123242421393607027414274980281390989419878610783090739645757458420107508709342532929e-01), SC_(9.9937778551638034523519633585670274448899798789366432792630069005327247453536176959259656828871746874e-01) }},
      {{ SC_(1.8838196992874145507812500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.2103404998779296875000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.8721664569354612146905773036046800972639298499363398133484079781522103704275367268205751208127688989e-01), SC_(9.8231864869565477393169639477436881521657952880135366028375384104734563626135608215003642381652200578e-01), SC_(9.9914342907570589630704523369807937770975436431130366321187243117113123639246625965996534544649137174e-01) }},
      {{ SC_(1.8838196992874145507812500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.7849817276000976562500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.8718545656135944226959801333210225028129829981121053881223462394573219518560489043320207854639926422e-01), SC_(9.8232459240920738404721936111901293950190813660163536491294517743464830558980482308379034647844714204e-01), SC_(9.9864026500884172607899444026398583108046757667183560795192906697408008113619643737337785291238299345e-01) }},
      {{ SC_(1.8838196992874145507812500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(3.0816698074340820312500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.8716654614766344804802061493023273836948714501847858099919345485896208784970747392293709077114241543e-01), SC_(9.8232819566739229827847204622003806468377223566963599017484156730486657550582770216466889910840012188e-01), SC_(9.9833520669989223068076235837456355248104609326752175568879491058563892410524305315935068542844145886e-01) }},
      {{ SC_(1.8838196992874145507812500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.4688143730163574218750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.8694486713509494035365269144227604033298645631306923285488575663742531744318688485575660344377845795e-01), SC_(9.8237040705216772102208429780319529747639623238910938924646958399502264121575416532488428711866235974e-01), SC_(9.9476010261075321392139625532175251228384097009697651864321495382127972823441949496528416995062001692e-01) }},
      {{ SC_(1.8838196992874145507812500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.4722046852111816406250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.8694446440967110586462598055886548073521170255817154802346102575911987646196344196457674762767488841e-01), SC_(9.8237048369063960452427752793652539547769702355014451302972743601319029603955384727614147884521690680e-01), SC_(9.9475360932624308050628737256081621064327364193112796560509159929674908406044871310504392267953683617e-01) }},
      {{ SC_(1.8838196992874145507812500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(6.3235926628112792968750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.8683544706075416742321225137714511925983371665505077908475891151998745396294338833622108300140017625e-01), SC_(9.8239122335330751210112620006061185618564002654009839298415533521458689344694357028847792242903299640e-01), SC_(9.9299610098241350611420496770383358496398613213514218561368623149006103016894590617729161908560733511e-01) }},
      {{ SC_(1.8838196992874145507812500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.1472349166870117187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.8654914931306994378504279649566762889686737336963341254699971126165479971156119114857310238429653814e-01), SC_(9.8244562948316378355396236555018353738387238196138567595683118487727622384165919706190942298354748146e-01), SC_(9.8838265040279004371764890595027116820997827588227476523586021222488743069737190163108681617223401568e-01) }},
      {{ SC_(1.8838196992874145507812500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.3500838279724121093750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.8651286139669281005787884912568327244505557361530531986760556656282637109802312281653433215159816949e-01), SC_(9.8245251922605300883120120136976688519969549319184767145713182573182498036731202822612265669837969624e-01), SC_(9.8779811390510808274156083148481232712822915934450726328793873928318636399725156028379579312268789024e-01) }},
      {{ SC_(1.8838196992874145507812500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.0579175949096679687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.8637927997394447023141924600276459401756048728030920925944319589359015535516202328663383057293740321e-01), SC_(9.8247786946902474326162668743053767826831957024653523109283721984253754019484909362851461366305096653e-01), SC_(9.8564675827867729198348810884526004472733303412431585892214353405649550833617540033541663010865654485e-01) }},
      {{ SC_(1.8838196992874145507812500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.1337585449218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.8636432636395460192771868763678157000156697100298083166120763600471581247188316918149233350950846054e-01), SC_(9.8248070610007879976210244972268502287963752592419605090628509527401987897835705735064212939009944954e-01), SC_(9.8540596787148135487460350776704325425281295012997253758312871907055656074575078765478532841842878710e-01) }},
      {{ SC_(1.8838196992874145507812500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.5750665664672851562500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.8627485374083246378117499015615510035744299504326523039953734781281132383816846494775376640671152381e-01), SC_(9.8249767371929765494561418329202787105332920420981619004320863000407238753784191053469702858228577621e-01), SC_(9.8396540589606803824196794363532268536501217522121502488459233696582805148462051491411300783848771349e-01) }},
      {{ SC_(1.8838196992874145507812500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.6488833427429199218750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.8625947816060392097020499246073871408543480877371955073377104950610642111164754855253247050399125898e-01), SC_(9.8250058869974195604005089136332271497197794822673981437527626553181231129659062253783845664143363928e-01), SC_(9.8371787938892417129870526288729841154406312984380693797330372759873989001575678862347717327159191326e-01) }},
      {{ SC_(1.8838196992874145507812500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.6769475936889648437500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.8625360175649251327916269665589320666222871473281219884996302992104157331670163805740811014149734398e-01), SC_(9.8250170271238405064089105298618133465508473318748138678141923526290587501906250606461494692687879082e-01), SC_(9.8362327933217915362026856174322601645328328325957221486334591196469515895895943209292316338837211499e-01) }},
      {{ SC_(1.8838196992874145507812500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.6886777877807617187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.8625114053138335488335293030010915500485025449167233134571752637262510510613418090821404438147030674e-01), SC_(9.8250216928552320040120447388248691100795616031193668798990599848007968435636519983561662236253866915e-01), SC_(9.8358365819124163971602602476587631917375618536367119903346852164784897048661117169944477362330499527e-01) }},
      {{ SC_(1.8838196992874145507812500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.9288129806518554687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.8620010423352520906908429652618316507404307677402723640754135946261763246922226503283940092363930928e-01), SC_(9.8251184277006266908785969829086175674371911315320534836686051767584719385857839264135115062745944656e-01), SC_(9.8276211864030162266455388775815084219495162642345584998297088964496086250121102443410484070442762829e-01) }},
      {{ SC_(1.8838196992874145507812500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.9646115303039550781250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.8619238957432851261244105396587449670000145299907263614645667571406851505599816881591895521244267742e-01), SC_(9.8251330477739663176995879874311403180516885270351555864704954387677272354733452537945819793243098790e-01), SC_(9.8263794279042988548099467472484461653532688098250347193272229493751104226191893610392435431681607015e-01) }},
      {{ SC_(2.2103404998779296875000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.7540378570556640625000000000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(2.1922208879382651179570819436871386534420145571496482093616163189757893771660384482170564857771827306e-01), SC_(9.7567498470795675336153393932031774393882277301660033562605129036456187436339073954296166128938394712e-01), SC_(9.9977135739849008607432874270302599707446525838932570086913653906042345962324788791781948668348276876e-01) }},
      {{ SC_(2.2103404998779296875000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.2698680162429809570312500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.1921059236751131250248708040690077457060682574482837895882586883218904045345733363574829455636286011e-01), SC_(9.7567756774145668122881164711003293677752135239438466811705897217414659318305614660296630809091631894e-01), SC_(9.9961247974920008171567381374991973541126426732920495862349732720614546858048438494680701073547167899e-01) }},
      {{ SC_(2.2103404998779296875000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.3547700643539428710937500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.1920671764363137138842884884237509995727937173178383085033084474660096184532962664770526360085910567e-01), SC_(9.7567843828789476371636534172527032490392029363556782970096939004109049484917446963704386967353975479e-01), SC_(9.9955893287075546831495064285629946279700516615349114187399395276925846153075831320671528644712833104e-01) }},
      {{ SC_(2.2103404998779296875000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.8838196992874145507812500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.1917692647697500516997754442991710291044681133251669295374728321454364291726436558202985169589919690e-01), SC_(9.7568513102337820394024674988578503816465038936640510930603221738805372984390652003160226553300283289e-01), SC_(9.9914724642252994141125290980159260239069923239854655344276444794709855179825506870817374675189619261e-01) }},
      {{ SC_(2.2103404998779296875000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.2103404998779296875000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.1915368399734496412874197007973348315314019778804667034930356288915745319329188975329340595666095214e-01), SC_(9.7569035189981860647456383432550396720324582863818424412832007988403888216382296002280197568278880959e-01), SC_(9.9882607349610307104496082349603780669563534607699284759503234345993172582878271939651578591654906699e-01) }},
      {{ SC_(2.2103404998779296875000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.7849817276000976562500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.1910378085236393447773810509775995149331603756790493149078355703520674155958255503464917370173882341e-01), SC_(9.7570155950280169638489666898246055818287808050556178219545566636373285567490060630137068873172353033e-01), SC_(9.9813654340536393519263096447563612563565188469579121122902384054457351771927563207315697843435685802e-01) }},
      {{ SC_(2.2103404998779296875000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(3.0816698074340820312500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.1907352460160089289426481351512365692594429919440516407969142799383653012941090483228023749696622854e-01), SC_(9.7570835336110132553712794451818664114931754857869665381207018478662485436572562200998892232564559180e-01), SC_(9.9771851455103717587784729630947852899903728789568813158063655826239830132746973597457373136173441239e-01) }},
      {{ SC_(2.2103404998779296875000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.4688143730163574218750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.1871888438935117272855111957760079620677149719061726259575991861120472115088289378879193401846734820e-01), SC_(9.7578791220811791519637759462595624965658298052993908867248092728787101696441099661464038761784610415e-01), SC_(9.9282055728872210402099650727176938115073951837690000517897373426716172474312376497054016181960576094e-01) }},
      {{ SC_(2.2103404998779296875000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.4722046852111816406250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.1871824018207506427816846252640770158483251481080230967061653002606170369128831612170264523849841686e-01), SC_(9.7578805660433051067598717960718596672083313808016143004200082826720656255695191108675093207536971194e-01), SC_(9.9281166320923274367690385959706080181302497736137546788474030388965750143851145212666666310323473473e-01) }},
      {{ SC_(2.2103404998779296875000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(6.3235926628112792968750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.1854386322236234731619233747087798412764097077612938233034937987877000909202785639132571199750934941e-01), SC_(9.7582712600534187969174661939743070132170784406887061676856852657107629734074625719746523486158458925e-01), SC_(9.9040458767655797225150046776410775158016259752071614155233149379234020052624683425546227971900786587e-01) }},
      {{ SC_(2.2103404998779296875000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.1472349166870117187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.1808600831464667424005283793574535737180763097038736475553811887401644266303105221763969250268965752e-01), SC_(9.7592955328619076595793651593678521605389757082552369754347194791744193766578740094274809501369414283e-01), SC_(9.8408835514947186948627033840660069845548504897563797032124650426535431151074097159222590575322201206e-01) }},
      {{ SC_(2.2103404998779296875000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.3500838279724121093750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.1802798484403742608314344016860620330712223395196533461630932494954235125706102160007324457036647132e-01), SC_(9.7594251768474980527967149024967752810718876069608508342071418453252109740702291275925919684907222250e-01), SC_(9.8328831273583950420942834838428361022137747123504854885690487299323404773056264670575678213558651215e-01) }},
      {{ SC_(2.2103404998779296875000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.0579175949096679687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.1781440919728143510412242650463421866079303050331604894313620503371249046490800027024586842031869991e-01), SC_(9.7599020648059744789198917886347058350302022429882215721786379607923244248220237656000875774450014651e-01), SC_(9.8034426681320792807788387563938997889808307953061455250945389355637801639419278357655660307290929938e-01) }},
      {{ SC_(2.2103404998779296875000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.1337585449218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.1779050246531263878471867715407667060241795317460181821761352435292831109754998422877422004750810993e-01), SC_(9.7599554150411294253731492616585999356153531455537911123349646616723441482093081421995103984237203889e-01), SC_(9.8001480038290045715262801821115742531517666077545906700021460976515082607850230811750332324306176462e-01) }},
      {{ SC_(2.2103404998779296875000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.5750665664672851562500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.1764746751535163697174630996390684094717848734177870069171260695069321501467565921434994307072897486e-01), SC_(9.7602744832517592160290611028992275346652514145833726443632588063083948025424335716357045310431315860e-01), SC_(9.7804391461588080143629910383683885238924402119959425927395017052762922302662046337548307965801447139e-01) }},
      {{ SC_(2.2103404998779296875000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.6488833427429199218750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.1762288868291358017336123811356521974219801510689982461550453688890802179214976275005573567709351524e-01), SC_(9.7603292891239289600979292919644501389715260959033645488787930587935100624339238577342919278200464939e-01), SC_(9.7770529778280319127652920142999410749459421187977203271188081289496285496754697111977592546302863995e-01) }},
      {{ SC_(2.2103404998779296875000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.6769475936889648437500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.1761349497883627715979166251263218145457058233806078159543485480592345986429663755085874008323125566e-01), SC_(9.7603502334859685012910159608747092221931318609017812958336760522525116200572730112501119894468739813e-01), SC_(9.7757588726531303254130987946372449082235391635437956152021492253389752294500077873434782705950339550e-01) }},
      {{ SC_(2.2103404998779296875000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.6886777877807617187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.1760956061257841256743157710499553578894982638251511782768431267654206766917576117404902954629354896e-01), SC_(9.7603590053337718504599162555441418169099542355482907351116673148633810131687368971722971135863489382e-01), SC_(9.7752168695671355067558592463194367766184981243256275974472256858471732625736375446902058652871806778e-01) }},
      {{ SC_(2.2103404998779296875000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.9288129806518554687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.1752797919519639313836358883521980023548520166585894256859585188685528485314055683902025989979657288e-01), SC_(9.7605408572847755133172944387527267142924376487240265995120351752235652884843648688258683810587358460e-01), SC_(9.7639790651327864842691222147632388194911812763360354458532901386126751576574865044880140977375931840e-01) }},
      {{ SC_(2.2103404998779296875000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.9646115303039550781250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.1751564768282765845652488459275107066069386353786024468475841126890836748940730877179974025636868466e-01), SC_(9.7605683390523934730599649910355562656697754485952500911230621446246764713919130711444579652977907693e-01), SC_(9.7622805625922863210269010578076169669331953145339731740625339734237548809227492692068246373114671868e-01) }},
      {{ SC_(2.7849817276000976562500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.7540378570556640625000000000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(2.7487957411491551024152693656839846467138834730623212308197778621390409374986742456493786788454776007e-01), SC_(9.6147866317168092993601510683515906895133608615166340566082994564433313745241080635581726444910489220e-01), SC_(9.9964049752177238253273497719037510596858200395236560045334207081698254835894098315566804661296008672e-01) }},
      {{ SC_(2.7849817276000976562500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.2698680162429809570312500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.7485704320937634228325647605687306973688675495902742056452605537022159248436146274082334999991626582e-01), SC_(9.6148510430385713091378735725360819230975938343211055192266756327401716220551221162592759390713344814e-01), SC_(9.9939069710276038870411938109854758262310091152220956714259855031542683655007490595783718158322641893e-01) }},
      {{ SC_(2.7849817276000976562500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.3547700643539428710937500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.7484944952058735858335354671016134757133701600037702878514124938102531153809495522390561446429573002e-01), SC_(9.6148727505788140898673789458417410249624360048823808038905384989285138603206990868243893382626401687e-01), SC_(9.9930650785433229166953676312000192386347316267231906853875089737417108055791574560522388250030663245e-01) }},
      {{ SC_(2.7849817276000976562500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.8838196992874145507812500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.7479106585905040118547719590606998127749558810827199981365301029376750812322413336306804483878628472e-01), SC_(9.6150396261484384222596181850543535792819032699678759916045206241662372828301656424961459966153334235e-01), SC_(9.9865925827354243876030312961823420785559631390820108003780338792938500084314672383298260062462015344e-01) }},
      {{ SC_(2.7849817276000976562500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.2103404998779296875000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.7474551743789657901527768093247976592204889865424032833695766814988466988868280308612405085347685074e-01), SC_(9.6151697886609494173173014075510024540750213195777945685521816250072693441396519576262070778221333979e-01), SC_(9.9815434483707694420673771997875992457392171739244325658760767180470428953853933673374726469326440730e-01) }},
      {{ SC_(2.7849817276000976562500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.7849817276000976562500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.7464772598054607406618635656960408670114823349942746666756257269917087184508431985144753927349577097e-01), SC_(9.6154491658669532848655757629198371677113378126290602379668627498892955454254754854530596993011660097e-01), SC_(9.9707043368626089911574638533941270692881983418709511305667940959209176005230859085546194563807252026e-01) }},
      {{ SC_(2.7849817276000976562500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(3.0816698074340820312500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.7458843774516887328352826568054909719537940449386292664852182248744360264067138923774465461199026485e-01), SC_(9.6156184921026661851710026132164889386083633500611487695136123276982830818233331342612654593577093088e-01), SC_(9.9641337287304539277894921096171636158862733092965934948214964053332110304739859800625938332780641180e-01) }},
      {{ SC_(2.7849817276000976562500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.4688143730163574218750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.7389365796538072060361816180266581593549878648066363307552864393514635092532475160124197829123466530e-01), SC_(9.6175998259770771050024054003522672430914983906093115363172085734462240400705759295056245237359082577e-01), SC_(9.8871823467675784656237601959243648100815092378109853106861004506567803393816161019248054311083047299e-01) }},
      {{ SC_(2.7849817276000976562500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.4722046852111816406250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.7389239614451992388612010005902672986185504982389315580264749379066976749859152493415996377836159326e-01), SC_(9.6176034194294649525590688085291868478991281977133906030018268034686345559145224854400935471700802941e-01), SC_(9.8870426715124687543022733684615365007761941380466856565548742291052498867157359693558582860370454415e-01) }},
      {{ SC_(2.7849817276000976562500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(6.3235926628112792968750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.7355087454733386204643501528550965719539021775432277870693281479589085098018990274124935043631252430e-01), SC_(9.6185753572677737327650338525420557940584199852204136250594934146294674022803888103334313269239431302e-01), SC_(9.8492491023469604000354518786382014981115762456506536325573083423681973580198320007429040850684635825e-01) }},
      {{ SC_(2.7849817276000976562500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.1472349166870117187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.7265447589668581227307261351838223342069693085097995682188814521823002123607027305402515453362435380e-01), SC_(9.6211201882811108318348656560767945421737336860558279596552733763534296020100159109162343755789576156e-01), SC_(9.7501523373440727611321474480888390897362273015883864137149087219886328391939537934754224237911297001e-01) }},
      {{ SC_(2.7849817276000976562500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.3500838279724121093750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.7254090957251439086283478080662446342886217789807434074717242181090111284685936297842884900801507788e-01), SC_(9.6214419533112942523126900175563617347451743535981890491127648339934818335834999950847411009598053753e-01), SC_(9.7376080222240219871082810271138129292246881297819972562332676397313938497347890419427486892086197712e-01) }},
      {{ SC_(2.7849817276000976562500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.0579175949096679687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.7212295382678863469955725345026346801389285301613532004526632624431548395323182294605285458846915870e-01), SC_(9.6226248913723300178181635507496322740164087029332799547492909384933541484940269264934212473175487377e-01), SC_(9.6914616666196122516566565305204051959522108986861105565476802342648062460631961033926913624796382170e-01) }},
      {{ SC_(2.7849817276000976562500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.1337585449218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.7207617601890246904117170828835275168110321830918986860047358485985317213577108434283531174851387059e-01), SC_(9.6227571643626713781788550882612764217282958967297413663553663825358672005181321089945869449505885890e-01), SC_(9.6862989241978612606509269616702486895570369616150382161832353261643256277525110869532808112334891345e-01) }},
      {{ SC_(2.7849817276000976562500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.5750665664672851562500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.7179632922027836485246865751609083882011972876089002760732046010260650660128682437598420425733409447e-01), SC_(9.6235479705895478905060965754455387184265936212295109023372141480881662274746408308625911398214094942e-01), SC_(9.6554213059948450301645957446261566146006897210749535902786563130451334162653036706689887239159337830e-01) }},
      {{ SC_(2.7849817276000976562500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.6488833427429199218750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.7174824553515702732970982193749899004728200361891227731611245432062794105702945691654618396508156363e-01), SC_(9.6236837596035127029127543432004722081476690413652086797996062740631880444000322297407105395878758072e-01), SC_(9.6501173059944522165121317539895380239587960401467044680830544464129177858095008986223961001111665460e-01) }},
      {{ SC_(2.7849817276000976562500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.6769475936889648437500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.7172986894554127714287677023048653401431484462516141485231787624546135343904684335685432596052132160e-01), SC_(9.6237356485038540477283191079964633282554737626659260886778191023482538016177042388732101931868161151e-01), SC_(9.6480903382977437230477309140380658749824173203479262538622427658670898475412135035470976110206478637e-01) }},
      {{ SC_(2.7849817276000976562500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.6886777877807617187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.7172217233499058639605311722521526710418390329202814803913360161579242203489064698247297556361310013e-01), SC_(9.6237573798467803872325391792506418873925440213582770142947809606347651973140371493212688032313493926e-01), SC_(9.6472414079466207454029792318418136842927122007456676424316207761942006563766181858833229507329241274e-01) }},
      {{ SC_(2.7849817276000976562500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.9288129806518554687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.7156258637493118105872461990230521793432167161450341045346763170737674151010837579939769460688396523e-01), SC_(9.6242078202902395641426478888051410029751970803669395881096992508483934666875385611981448412723460032e-01), SC_(9.6296416314518002651639774955917433860552093569900476362764049267935005563568797783974165734091879518e-01) }},
      {{ SC_(2.7849817276000976562500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.9646115303039550781250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.7153846531508720758362201430913229535925612435473509536902653562436646519451422375552821522355351244e-01), SC_(9.6242758784977022370090502025325344900517121978003342778839763369516045408475963094436810921021163007e-01), SC_(9.6269818689292483046691497077716004999207447172223160663372241318276640423148932939120796437687617165e-01) }},
      {{ SC_(3.0816698074340820312500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.7540378570556640625000000000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(3.0326909292843329367512426390611598082537502640578570669292090410604548609198002350844995883114335227e-01), SC_(9.5290495710451905027514660642131044454857875345856679771756076337909630776184202462675934631122578685e-01), SC_(9.9956238699545302717965380350386792059814675680180520163805128992077836683226243714974796398029228008e-01) }},
      {{ SC_(3.0816698074340820312500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.2698680162429809570312500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(3.0323894487950665430372708978493772640795418585027675192478293687014841192822526679062085792695363694e-01), SC_(9.5291455142020133023754633124544732434470525334403134889767782353994514678513938933637662647705438774e-01), SC_(9.9925831719242147403507153763213820592821539981956128532154658069020685774857929190395191309465022231e-01) }},
      {{ SC_(3.0816698074340820312500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.3547700643539428710937500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(3.0322878399591431326341780243422956777602479601861671006243338498580122181826490964955035930830637649e-01), SC_(9.5291778478332491432873860706727952847107215158032436203257764412329420742755840281600493299329815331e-01), SC_(9.9915583880881537180898140362621276923509127133787746356289114728836081901058573687103243910062150305e-01) }},
      {{ SC_(3.0816698074340820312500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.8838196992874145507812500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(3.0315066333952684858138401857890938712454353222808488283228931058095796716067297087536971649866544891e-01), SC_(9.5294264009792575362544261661419707498425292441354931880160829423603951907127368299524392406196291954e-01), SC_(9.9836799965128515624869292723595021229745748604318718955688710300997012758560310689330619750132013061e-01) }},
      {{ SC_(3.0816698074340820312500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.2103404998779296875000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(3.0308971787656891769726616510138091543032213324606251887965477291810679541075676177726442587056917581e-01), SC_(9.5296202595775129860112631206180223421437118347939397849212072580213728581082217923132096123082652133e-01), SC_(9.9775343554451937347698757108551994495660562509451666953830350563586835625403242033521573586539896956e-01) }},
      {{ SC_(3.0816698074340820312500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.7849817276000976562500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(3.0295887201363512494372265182218370374688113168415984635529054014229440894742356301099254101703427999e-01), SC_(9.5300363161334587427115603808676636773914284503302409734527841053650053045315209630068937506712593488e-01), SC_(9.9643419943363246327660973424550747976322592254928651974927264359583889506001581299992789405084099074e-01) }},
      {{ SC_(3.0816698074340820312500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(3.0816698074340820312500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(3.0287954561134081940656122427776397472999803727499943943596862789410876067943494486444593960218209975e-01), SC_(9.5302884575980580136867981130520155599371165405359554415785810909474265219444212518956677250213893487e-01), SC_(9.9563452920334185518845076403788764658464529924332811408508558359661665843404459202762412025120004333e-01) }},
      {{ SC_(3.0816698074340820312500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.4688143730163574218750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(3.0195004648134235263302748002128501118182843287594445359533169520146418646520857972003352176610881830e-01), SC_(9.5332374848732012101950013616353328519534217432420873571770948924158657997358381115499126285177602699e-01), SC_(9.8627166337948300315199659521613296040680917452232026159961392341800047087193170072500812361721211063e-01) }},
      {{ SC_(3.0816698074340820312500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.4722046852111816406250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(3.0194835854673341366095835461644129765780110449741911972821827085187698458981900136961819677027457490e-01), SC_(9.5332428311196045115910739053169181977721064088222047654488243767708662173884088204998594375661969245e-01), SC_(9.8625467283529176925947584217566039699226262685244745452814003627112337818941868205690325093095614292e-01) }},
      {{ SC_(3.0816698074340820312500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(6.3235926628112792968750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(3.0149152879755141118887532562152736656678025670130220267558162535382872306603989593856058319344578022e-01), SC_(9.5346885531899531895374448069935575947401516198590091239325448644864102502982855383492596763491726679e-01), SC_(9.8165788883459903426152171616613697574120698117036651873693696145960859386881203800848610645336577350e-01) }},
      {{ SC_(3.0816698074340820312500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.1472349166870117187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(3.0029269601875154167950400025425101667111836762277843786685061225344556072220327637589855206447914293e-01), SC_(9.5384710342789723334011273346932390565153915780592108250260561744156361329453441181523529584443701543e-01), SC_(9.6961006572539321137968419479303814363662917099180678878478560979727441160126670677106499983334113124e-01) }},
      {{ SC_(3.0816698074340820312500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.3500838279724121093750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(3.0014083638247239931267737525203908009618599288303462675043998314279749630828478267161492294182173187e-01), SC_(9.5389489899864226734922889796960087157259464188919436157889455441984850061831151699699065464755630491e-01), SC_(9.6808551185242006599884047603850479350557529494757140067171898820621687251819445355354577579667499701e-01) }},
      {{ SC_(3.0816698074340820312500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.0579175949096679687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.9958199458299881480949360427587683882191311589110544081281765658734806755787666367750677893122041288e-01), SC_(9.5407055741264339090662671276280587530620830580327127585643746004858364219864605184849991406551687597e-01), SC_(9.6247823160496204548693858781704846332893269778648210634547495473629405677070119027983223412811496453e-01) }},
      {{ SC_(3.0816698074340820312500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.1337585449218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.9951945305697106273497970886804836564674573002628956126281701834720852799934683990311863244183026191e-01), SC_(9.5409019345156928821844616907000254058166760176620458682641193234464786014801358060774254746466256176e-01), SC_(9.6185100512095421371656717056839628514777030404559337021378528238503996571658673484437874754011758818e-01) }},
      {{ SC_(3.0816698074340820312500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.5750665664672851562500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.9914531850055829478869241609766439240168795389048472864784054443203077516830276500858613115605128070e-01), SC_(9.5420756568956187207012110979749891412040734228311076186006789602235990553761711894412308178471321245e-01), SC_(9.5810008529688166978918126141760918486468813833121879324746094101198698705296572284143998044748060959e-01) }},
      {{ SC_(3.0816698074340820312500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.6488833427429199218750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.9908103729980897055493387258238115119446972319054900386028305603125011433323968119724664623636896326e-01), SC_(9.5422771555204278465880608431301589405541917425011412905466106959973517313994385384254452463187512687e-01), SC_(9.5745584586702435754622598366371418078050748468804324838863303128456527071049455109295382153474695347e-01) }},
      {{ SC_(3.0816698074340820312500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.6769475936889648437500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.9905647059871549163502826974271905295195000241907039745969203280801355066937857992486784908962551975e-01), SC_(9.5423541508007321322786781876077197982584335052398087214592463816905810312776043747210497127134726528e-01), SC_(9.5720965018574042127354562843764555533186416893338043685776549926928907867783002899736284899077823511e-01) }},
      {{ SC_(3.0816698074340820312500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.6886777877807617187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.9904618144288149787006969538175575820354046910869708934267432667459568487662357245170181112465081889e-01), SC_(9.5423863963079549866076271121221510678495182556728929910600089661166206322085840963418465994867024041e-01), SC_(9.5710653997659099791498565490646591001367816965591409788537499915441493682315721726273368513111674084e-01) }},
      {{ SC_(3.0816698074340820312500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.9288129806518554687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.9883284549033727324403996822471202088644478854459719630673925750969829657836734342097352009707525690e-01), SC_(9.5430547020131253673570839692663249538775688782938826288409886995833457284488005730612759244071910958e-01), SC_(9.5496901543224138773298751726639661464928863665776121309811549784840017553117193160844395978264622040e-01) }},
      {{ SC_(3.0816698074340820312500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.9646115303039550781250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.9880060112606319274741197123532492884564938820235463818063008263372047306217158470051732244375910149e-01), SC_(9.5431556665848392911820947397600875803240949850861799320544367388327945223160402861578624863197770316e-01), SC_(9.5464600344889752173121739856048336387404777814543931914585841333480158905827127999155983730153830156e-01) }},
      {{ SC_(5.4688143730163574218750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.7540378570556640625000000000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(5.1981739759869433997135535281539209946317405934028560990914440005263835216073855286372459078708171161e-01), SC_(8.5427739824586306553321129313539882509915056149066737165596613488590801806717451540833864440053163694e-01), SC_(9.9871376627884133067688644513738540962277959988655102666310227083261454315679192459173488309694366416e-01) }},
      {{ SC_(5.4688143730163574218750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.2698680162429809570312500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.1967241648319471532250711842933533396296520500521276385002394582719372534715961050641237376212276426e-01), SC_(8.5436560063389549693043609154732772225123446934264934909723747951009729739501480246801503910821665095e-01), SC_(9.9782018265029507127021756398408275779186813249942093285393696657513071517625281843565388968248242731e-01) }},
      {{ SC_(5.4688143730163574218750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.3547700643539428710937500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.1962355303803171819906343667991640789312495777079670013849596404313596970659203888428435465885810793e-01), SC_(8.5439532016984493658926062320062783685589220108577632558690534025559338434551343606573849240495765015e-01), SC_(9.9751905058252365808781995990078848752731845090641163948345425614645051742197250042377154377959438418e-01) }},
      {{ SC_(5.4688143730163574218750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.8838196992874145507812500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.1924787201389542945740360016144333441590356117233796449985974677916534405901975285997737778769892224e-01), SC_(8.5462368760118115020478146051006523102825329991575435437552335727681925883478394082104171629411935571e-01), SC_(9.9520442464537423953090440305952807543658677360795738772778843557971545570470621404600674705822697684e-01) }},
      {{ SC_(5.4688143730163574218750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.2103404998779296875000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.1895478550722218860798046012827182027306193042199162594784435547994954539793913355454727961225939759e-01), SC_(8.5480169080269899233928285819199390366806213666197791947272092103004609789072681360950952580231447516e-01), SC_(9.9339940508434332725248550988446790815749974541175241711581853986419831829055059276109779857570520976e-01) }},
      {{ SC_(5.4688143730163574218750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.7849817276000976562500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.1832554660559546270012115243561331872022630361661137868239517502686870938706048914579537754750267437e-01), SC_(8.5518338836533224952064937784580255777228507380715375782956280356206267018261014933211695339546933244e-01), SC_(9.8952629723237966448905398720830369913593246100505551381992003449047197272062718231582847876848438084e-01) }},
      {{ SC_(5.4688143730163574218750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(3.0816698074340820312500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.1794406449694716102590532189955830577618417433366485240126105751525564043817157956064127288473315508e-01), SC_(8.5541448786677808956238757223379810357585801810428494719638118731562607928699860976734644520339470494e-01), SC_(9.8717962281190397007867993529460974391485610757565333243188783455458588439244170031160963419116878282e-01) }},
      {{ SC_(5.4688143730163574218750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.4688143730163574218750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.1347412407053512856683763793952333783079634255848972391548143578716385138720426672939753564416017465e-01), SC_(8.5810507742933015306383728115722936974706478446192617391678763590461124255111094978326796521504781534e-01), SC_(9.5976353506966182673890191736237125886936459146014679641663940041884063831084209089492026212241568538e-01) }},
      {{ SC_(5.4688143730163574218750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.4722046852111816406250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.1346600701238357381178620270439536885111992537798543362606724008006806917702661387301246040177297742e-01), SC_(8.5810993447387547571511590176672145330296145151017498895459644492043927830902367452552687551207246390e-01), SC_(9.5971388462739138422444055288347837584572728818776045723071378305146749236790213550093429189734869875e-01) }},
      {{ SC_(5.4688143730163574218750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(6.3235926628112792968750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.1126921787617001441521952326050534518316487949214773710332334638821163360796366388881735900858714111e-01), SC_(8.5942061114002228459169678243633150248268351986739874589029265620107962803145230672244455138275572258e-01), SC_(9.4629453232706831996838874035629795103121125620370031660969576862147623329369368496815383289674747675e-01) }},
      {{ SC_(5.4688143730163574218750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.1472349166870117187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.0550498343863245380192449829315969791300329716737458269565239054796814464915584965816033572963774550e-01), SC_(8.6282368518643942508837228633245350990553175318424769698255251939363076024624756818585887650903736644e-01), SC_(9.1125310729284167812970640003998321948112383885922521293551608846831502089318965129243715040126470480e-01) }},
      {{ SC_(5.4688143730163574218750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.3500838279724121093750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.0477490829557254312697291409488960146205520200215217666862785165873511043366623567933115766954415176e-01), SC_(8.6325100171108769434169679731641789410833357069364376850552759443400184213660905059418080811791123280e-01), SC_(9.0683245476123736322934869781314829191560205277312596116371921454711695852029262010558337189356968473e-01) }},
      {{ SC_(5.4688143730163574218750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.0579175949096679687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.0208848357104535847868400905147144487282861998769267877527012857438631839387309287519842872745705492e-01), SC_(8.6481625485725470095842711367599124892057401934046199340482503939366819060007233186610950525004696056e-01), SC_(8.9059992641072104695146168071566311483204686235341395330510448065847344188515610445583895494881070714e-01) }},
      {{ SC_(5.4688143730163574218750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.1337585449218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.0178786442703313350511930438039416922031846137918360289406418400179196481568044687002899839696042985e-01), SC_(8.6499071620090664183484596297969758048804707533461155652221493955249418090895481327347026113625601978e-01), SC_(8.8878677690390179655030106793458948535950274230211075430882384011438637611824756748024021671727264943e-01) }},
      {{ SC_(5.4688143730163574218750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.5750665664672851562500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(4.9998962849403194251006037964224994070630846538423096923680701643072644277362845158884717701315647848e-01), SC_(8.6603139169339578937023182807101899373816070806480120013392813031367753740377301770296883996646321388e-01), SC_(8.7795487316512168912465501486415675776096541167377880862980888361557342616329621679499784237871425570e-01) }},
      {{ SC_(5.4688143730163574218750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.6488833427429199218750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(4.9968069004939244970228548384020710953003412658703270878264283784926307682671572982018025979245808346e-01), SC_(8.6620967899912258675044371431797382700000801329994449664842741294567525699750207875111092741079073384e-01), SC_(8.7609634816462547083037409544565219331362859851503161707717680363918738612886642798849864772523508579e-01) }},
      {{ SC_(5.4688143730163574218750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.6769475936889648437500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(4.9956262311421870423140342005977123174752582802643478150656078824902044669733690155762083590188336157e-01), SC_(8.6627777622841109107004280234901901317783187236741252589342328565231004018077499864770537902361152969e-01), SC_(8.7538626231390684828041516378824944960398381347127745331515612836262740067707623821663721914979327241e-01) }},
      {{ SC_(5.4688143730163574218750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.6886777877807617187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(4.9951317398939792415152248844392120829970779028046991445156544735177676799034006680990142892350753750e-01), SC_(8.6630629052953175304522330562470749272532832252651845946150921438426494279446353444280598439009141805e-01), SC_(8.7508889276372370045098570577865485508802232112643555401483726729225102075164956159897021874162557799e-01) }},
      {{ SC_(5.4688143730163574218750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.9288129806518554687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(4.9848793296001919240569957795761329543523365892712339196722279750852256308539363414729911036472305518e-01), SC_(8.6689663783708805619255860669219861540920915542845148572879972393756471761461163862597108501812306812e-01), SC_(8.6892752507524042640070447345759508804605344072162331449577443560736037795219977265748971893998130351e-01) }},
      {{ SC_(5.4688143730163574218750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.9646115303039550781250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(4.9833298112203598994500477858078160864327315306195089198069576271527693936398663318473058676023836998e-01), SC_(8.6698572071633597445803921321598145112506570775347362305423384648864914845374828010868228628712282392e-01), SC_(8.6799698986374699647046520719585138541968933812128800227347414638170296064804798217446106765916430594e-01) }},
      {{ SC_(5.4722046852111816406250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.7540378570556640625000000000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(5.2010662176855584292740154593669842964312107862160224544032245256496191193491740059715525807246314716e-01), SC_(8.5410134175781529056601889175108240541303457820629884133883663214092851919741175746593413054437535324e-01), SC_(9.9871233364783675589036415181300765886254532609456302993996709454726102642197631888984370802976608469e-01) }},
      {{ SC_(5.4722046852111816406250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.2698680162429809570312500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.1996141160305239511635736858078448736167857237729423632306157775985759637785190652917354834791477305e-01), SC_(8.5418975084214229296468541916452592148254767035001699869447634642247642772498230210274823314584323393e-01), SC_(9.9781775488706319424642556401056922363416961108630002217453579069965382691436844718028122282581311484e-01) }},
      {{ SC_(5.4722046852111816406250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.3547700643539428710937500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.1991247095602684076481417093288149140985663066132329259539030150472468640114404554076822989684577014e-01), SC_(8.5421954001556212747668359970097081709953328562248934126657834188402910111028202063250196539278537375e-01), SC_(9.9751628749519532786246976336171068981955042432306992964051166537107303601683226164846132707556450825e-01) }},
      {{ SC_(5.4722046852111816406250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.8838196992874145507812500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.1953619630008697502970999170229317302974082374263928020629973648811971621211920183609571884062036418e-01), SC_(8.5444844240833951733687028822167839007993570503562830490168226955690789603493523457195420568530618164e-01), SC_(9.9519908461109148272918254073569029730893464448273156070624442523315334065143832102673116758990812170e-01) }},
      {{ SC_(5.4722046852111816406250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.2103404998779296875000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.1924264658250777692518797797388305653402533483835725522596841144362921306995071415301902319072989265e-01), SC_(8.5462686242008150726240074444133694720439213183775690324071562991398482199005937043050057594547046936e-01), SC_(9.9339205607209050327554913263753700271759143862941028390674090827994171866299198097097304173798799060e-01) }},
      {{ SC_(5.4722046852111816406250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.7849817276000976562500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.1861241292852973623062870152332877824969341201416204813933129664264167300563773810540647832711818753e-01), SC_(8.5500945325560474933832015931190551727975972037333981183775991327901515286024818720296917227372742431e-01), SC_(9.8951463928039508594250904412907680911363578483674714492725969525916836201496769849987959281872883067e-01) }},
      {{ SC_(5.4722046852111816406250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(3.0816698074340820312500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.1823032756578805170243038716192728331532071230591414738060851220398667430672973077193435032077196984e-01), SC_(8.5524109325444367154739575059972275751352169396472779581913361346609384373015421339125774842951543172e-01), SC_(9.8716535532951692540630201410144586882773590083014434029685973692795545664661734247093990684981538413e-01) }},
      {{ SC_(5.4722046852111816406250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.4688143730163574218750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.1375330902533645581477838025998559988671145262119330695279356578108375108654425076173713671687814163e-01), SC_(8.5793795665276235811328878886707545342035963237633838971656849814716310651105325648391436746306610344e-01), SC_(9.5971885016315869449298309980041549879083087910372246793660960042850796495999381455716233820218971229e-01) }},
      {{ SC_(5.4722046852111816406250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.4722046852111816406250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.1374517909822255584948314691269334443899341961660445405016123119231711937668877039557560141245473163e-01), SC_(8.5794282499088202929886893068684303071968354810043650392530712811413532726815742588165862013213831199e-01), SC_(9.5966914475426916645413135091122552934920862991577763317397146973909376017071940887965913734873603311e-01) }},
      {{ SC_(5.4722046852111816406250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(6.3235926628112792968750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.1154490511513414130948915341104060861818789686652322554190148299754578743199905381114914274797932990e-01), SC_(8.5925654495659700399955748971498946599987477968120630962923233438264848580781058103354991890876416358e-01), SC_(9.4623495260137066845771122836563644166269839612005881612303544559804464937606052847559420422077652558e-01) }},
      {{ SC_(5.4722046852111816406250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.1472349166870117187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.0577150851033620222065426480052062556339068529136250538565090145686601607778439495142027369642677211e-01), SC_(8.6266748007513237578263966453370563241131265732002042565927193179381457055716930836745465724048534549e-01), SC_(9.1115493637874774574895524688904860648069286781379853310115201529697825253198607660654686438137243104e-01) }},
      {{ SC_(5.4722046852111816406250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.3500838279724121093750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.0504027114687172704612077647147689664448391776592059050169156795148087456750013680648771618109751241e-01), SC_(8.6309577945897423170490885782075421326397572460436343594082239787264168388215364794028500967555411466e-01), SC_(9.0672943244489723556629063297565034569910068078705325446695609199455771940580147138661920170374453607e-01) }},
      {{ SC_(5.4722046852111816406250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.0579175949096679687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.0234956661398836325220934555682062181828963658372433318456298273995853280335715150534302653688650003e-01), SC_(8.6466462453528077015378008591411006047542258613786938098273250946749182955588309790818138170098555462e-01), SC_(8.9047912406779004078780181222660018000107719911556966741257174279595257471119862130846465207659650823e-01) }},
      {{ SC_(5.4722046852111816406250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.1337585449218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.0204846823743274745033767085517480944326304555773635167678377755812020121756485042751049770949115576e-01), SC_(8.6483948541937392379049699321469409112385341842886711759532063452027719824581566325039441607458669976e-01), SC_(8.8866399195198759526084927175418007931651279559239907007042563559465458604995497052448898466601777959e-01) }},
      {{ SC_(5.4722046852111816406250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.5750665664672851562500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.0024736438774677362455305479905427323703753284716142209132865625628793728901000552731161379181973699e-01), SC_(8.6588254077739256668400915794274422159503762994573992687214086236795464679840524010908002660125081512e-01), SC_(8.7782025845268452494297767852249296096808972557740536145642567215293410891081013287916117684417721735e-01) }},
      {{ SC_(5.4722046852111816406250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.6488833427429199218750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(4.9993793301972062801745347614832842739593297996856667578148753234931573431755386092356995520342244207e-01), SC_(8.6606123520682377380614424212201454846217828801398363529267715055480042972690694453906243012457588310e-01), SC_(8.7595970624049649040909168785749198216246924208497062720231525657789426337888930574782097654871634906e-01) }},
      {{ SC_(5.4722046852111816406250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.6769475936889648437500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(4.9981967768790490332259083365356840203455006149209131538085592667369875698655778683923526084487144403e-01), SC_(8.6612948789194266605103930026038160177103374624406205226219981408737850325299066393602784641827398450e-01), SC_(8.7524884605096796307412575538564600419915477777597601494681538070322418254575375580375756898536384738e-01) }},
      {{ SC_(5.4722046852111816406250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.6886777877807617187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(4.9977014965561798661262506577783954451486402867962578762279513934471620133946881165517052633037930278e-01), SC_(8.6615806727940899601362969223884853955800691465148897718116465217013208093723042953116622539279986681e-01), SC_(8.7495115225583780242845592087996731668201501037373415873510393147361214809191107950651098904630593299e-01) }},
      {{ SC_(5.4722046852111816406250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.9288129806518554687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(4.9874327226783456387994872592996361579424155245953997152030951802805967728075675370658383043099545381e-01), SC_(8.6674976110038394543602904112300725304873810621906304564672743613429089373792464213933342009041658658e-01), SC_(8.6878307068406900675440211034430388281438451325350045661102580499286278978019367863722655313606312732e-01) }},
      {{ SC_(5.4722046852111816406250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.9646115303039550781250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(4.9858807305797170049422148274088831458056652119831549712521134613839276073404902535807338706125792371e-01), SC_(8.6683904700027136820980396772039876875412482570256964962341437173596289146170296223443315089450346074e-01), SC_(8.6785152221435618708627964143918764239851311519509432541931659691259869953046106905396447429435703220e-01) }},
      {{ SC_(6.3235926628112792968750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.7540378570556640625000000000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(5.9075093541184279655225872441294375833238088640218249650012396478913243548365143438006820362160275711e-01), SC_(8.0685397211021570365753542697908504475272688109643201530321058905784135114098827239254172846427649268e-01), SC_(9.9833846818733338489558425744380181799404971073489583696156750115899710669786036603658062627262554213e-01) }},
      {{ SC_(6.3235926628112792968750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.2698680162429809570312500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.9054347757117304578562570508175281882352343966235805630594469652668418422053499423283590087582803355e-01), SC_(8.0700582469902002425405368354610781855401390925964140614073806846017162909771184952856148490260936831e-01), SC_(9.9718419352069258686387316493691220018640568331299613500269151412628189800890180587325649621296910489e-01) }},
      {{ SC_(6.3235926628112792968750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.3547700643539428710937500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.9047355482691422779476380463798818379081034910961041214496386949747573148700992534494880986204341336e-01), SC_(8.0705698748605548358983688106805904765521407324215099082516936165274683774444409313419808123353429292e-01), SC_(9.9679521750788596920754748111284961487315784193379110675611712085013757953748695526810391674614928430e-01) }},
      {{ SC_(6.3235926628112792968750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.8838196992874145507812500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.8993591862003370998667839085055187872448489192349434551596016012585474449552318264873491493916085053e-01), SC_(8.0745006775771402113064280178443600302374501723890636477541187791167425438455725514201654387363472571e-01), SC_(9.9380551002033835880023337633785411638148363940604552251471099727737573219849766079359560431096247329e-01) }},
      {{ SC_(6.3235926628112792968750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.2103404998779296875000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.8951643036107616605878063632084772425332747876759814378145769638987683677453780454141662172614691785e-01), SC_(8.0775638551133375433611876198715077171670284030485258170117054622681162495424711993884169835887604418e-01), SC_(9.9147419280161643207775051398711393218055901243332794304959598993508906231224926523887936578717621259e-01) }},
      {{ SC_(6.3235926628112792968750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.7849817276000976562500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.8861565900919746589905951685461140940994086186030763664457206106966341382095037869049312055319490556e-01), SC_(8.0841301694688722651684154532036990539299619589371407043604938014221547838199699292781632033435341388e-01), SC_(9.8647224209806804219857073265891393683297988664146374986822363766360004328193339344537972624263526425e-01) }},
      {{ SC_(6.3235926628112792968750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(3.0816698074340820312500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.8806945503160632981526164389848981639545967167984866725752202429237670734029789758756186376953328061e-01), SC_(8.0881043270894419188103204478338216915662915995921351359463902204273821303853601172082991264787117322e-01), SC_(9.8344192050092273407344810515227512115973972706031188426266136289704949790850014083930220392529226795e-01) }},
      {{ SC_(6.3235926628112792968750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.4688143730163574218750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.8166379209443088435398049569033716319796468354862700402659247525166386822432274150617781032144224228e-01), SC_(8.1342930422153263081330210518854138063929009394612551944142247923992841067193112873989438084623221110e-01), SC_(9.4805678663313714996722987990525090932800795152433079076845664018829788266438665249800352873289868909e-01) }},
      {{ SC_(6.3235926628112792968750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.4722046852111816406250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.8165215070849046489515830883870284246840801523622548327280466289817274042203787190611632410872471485e-01), SC_(8.1343762857159951718497250489484225766676447606321427391177001401719916516541595975408454860742732430e-01), SC_(9.4799273554936006026711867730735487073503652492224189584820690733996724182957462295521434667803783569e-01) }},
      {{ SC_(6.3235926628112792968750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(6.3235926628112792968750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.7850035593793181681321888055019802993321340051310198339765882092978052675512016599311196194946168145e-01), SC_(8.1568213059971235104546474545849825679664276357648550125488526306756377463610003159283532440037804170e-01), SC_(9.3068559849438236923167371677761772051872684486372199790389626105504515661423774721407734687450055594e-01) }},
      {{ SC_(6.3235926628112792968750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.1472349166870117187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.7021946210944329110843811022718962647554537221212322839500617426273380464756435734217363621024779142e-01), SC_(8.2149240107965525041475781184044474439703813152591512238198620900148259855774531737462566072762034655e-01), SC_(8.8553577472559267960093143116597579718161395246002867239169281867860974519842172981516209787043774603e-01) }},
      {{ SC_(6.3235926628112792968750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.3500838279724121093750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.6916957353853814614281558485118922409029008449940494175423936059778467930970494653730470547694225781e-01), SC_(8.2222016306945344658041242720787420187263722989138196806649193936625240904566525199254068413095498236e-01), SC_(8.7984466515819998746384611518644409339960535656357297517945753320222341480511315542465460405817120793e-01) }},
      {{ SC_(6.3235926628112792968750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.0579175949096679687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.6530439112120330937306949138664381005212508962998073091929814190492717168415767084312185234523288104e-01), SC_(8.2488238275470860791827979281114975955638092294793187266422776551196231144893593387139910632983555472e-01), SC_(8.5895680053814161044482688728638347108586484648577002088097911968759539912049448132182961441144254538e-01) }},
      {{ SC_(6.3235926628112792968750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.1337585449218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.6487167824122444704825168220752976116514232407185420425483783746258338916378389901457962710785538517e-01), SC_(8.2517876070639542339000589555294623140753408472034767415133353020462480320444447857378248360948276474e-01), SC_(8.5662463177802280868263580262516003679514928061716503420741135884959392650091663894063692853636137762e-01) }},
      {{ SC_(6.3235926628112792968750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.5750665664672851562500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.6228252280876447905972563759471929092123105171800226051410495377232056607325064244129197944129406362e-01), SC_(8.2694520044789621680242630111142249369862991026068317495357259059452374906224056430707108167164483283e-01), SC_(8.4269627169336007494507356365574812420932619386107191714340658221868449375011005484999812349771207312e-01) }},
      {{ SC_(6.3235926628112792968750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.6488833427429199218750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.6183757376353266438204684113907278490739405315390369113887128526878503024413373619649024117492383414e-01), SC_(8.2724756917594323765295728753604907491917806403805966950120369680248222418561555415309374207419005950e-01), SC_(8.4030719583170076409825633901095708769330325230946024043886715808886549371213734794734902475887550719e-01) }},
      {{ SC_(6.3235926628112792968750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.6769475936889648437500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.6166751775916384562585023087517271723170232590091015803436463683864628302450485139900799038279570931e-01), SC_(8.2736303971972265404037727166137986916155445924338112475950218854012017983387364917000763619153131428e-01), SC_(8.3939446029340384960579903779768644254488948985199281901027907079425323376181131884420898862250606066e-01) }},
      {{ SC_(6.3235926628112792968750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.6886777877807617187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.6159629280002962516526857321246108256070495743425822648043352562234127429093661242990083998336567606e-01), SC_(8.2741138734807330024868762212926221106005518881722056032791141587481318134094980365464638231824415442e-01), SC_(8.3901223466198115351534394225506602213879080561255374145185042454850394297840250253309653680341938695e-01) }},
      {{ SC_(6.3235926628112792968750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.9288129806518554687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.6011935320531803063511659588686921648095001912823149235902547846236639818140511475944488568362333933e-01), SC_(8.2841192058350789161762162547144659866075415869308928045072967877008674808693397378742045944604749680e-01), SC_(8.3109395658496251490770313207672683050829501570973006664880530573907333185684556567068999049250156399e-01) }},
      {{ SC_(6.3235926628112792968750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.9646115303039550781250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.5989609763483160839657065867235297388082970989570737448569271714092916193329022534511282743729648633e-01), SC_(8.2856282794564656417768348946749588827294081279292398240080448353575229928083389690735739145528926299e-01), SC_(8.2989829209385814407005617116991620316439471229683027889361394657030405723553518835979738537924001601e-01) }},
      {{ SC_(8.1472349166870117187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.7540378570556640625000000000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(7.2702081580737277669378090242838702320600782680936939750297509297540855756782380187372237495418275919e-01), SC_(6.8661541883559689407416994227584603188546446069897119786849522609965693644733858682279491754200123501e-01), SC_(9.9748244136363214768984878995507356164930188655482644497348867217230906737375486707939873184798685159e-01) }},
      {{ SC_(8.1472349166870117187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.2698680162429809570312500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.2666271167367658786097195902539272140958148846575857549497193226638907749766700488340661025421346299e-01), SC_(6.8699439842189336966296389648411822851351190168746759092643803347473397004631800700883441563971654693e-01), SC_(9.9573341510760839699322347957607722746534464979271772104861969911658546169235433423999982923168538002e-01) }},
      {{ SC_(8.1472349166870117187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.3547700643539428710937500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.2654198766577543071853586037025875497574700590477970784324964905796887175209926497781445698794762262e-01), SC_(6.8712207078412509823897749545065351011153724250219081461407354870609754852508046479838418592773629856e-01), SC_(9.9514400342640062448989208264011999183252431777488657319249033217899216103582578031325592789976310670e-01) }},
      {{ SC_(8.1472349166870117187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.8838196992874145507812500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.2561329354661306077412799320218019331997631337134094743140418421356446600010982941028020080741003769e-01), SC_(6.8810271633560402960125491817177211952017585090779880561442907216475128728962560028175742624311589481e-01), SC_(9.9061353257942462105507251198806879548705125033581207355905917809525183880551724834928775281926702135e-01) }},
      {{ SC_(8.1472349166870117187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.2103404998779296875000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.2488813662829167529468196627232788778279105771477637990814196479116706848512693964828987194999919256e-01), SC_(6.8886659766282988274183048739981792674581121064868007301816480399889604139731528085713463499251245624e-01), SC_(9.8708052457337966655020077031322261987039698185658337710299138482459928976581681959028464141552140008e-01) }},
      {{ SC_(8.1472349166870117187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.7849817276000976562500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.2332938777509523341318802889454235792664090752106332588811995994082657827858353597304055671683263819e-01), SC_(6.9050314755322144751239416135520643538884168615134231860060657855997527775330381257634698178754887528e-01), SC_(9.7949963972253992704919444112437859800032723176297725085845458493721888641415460797147212904369476711e-01) }},
      {{ SC_(8.1472349166870117187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(3.0816698074340820312500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.2238313854924186854832868422917407223388468021141734936932541221515633393163385541625633176750476800e-01), SC_(6.9149302320395599682781250712181807055365989266007447464118392044979739877609947389932958853307541322e-01), SC_(9.7490652176376638702625325842677247179455133817124639416657237262381703657668497186821802403514482197e-01) }},
      {{ SC_(8.1472349166870117187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.4688143730163574218750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.1122738571055200181414206393802136029322597286490412920654573122391740875102057373774728683111370943e-01), SC_(7.0296202302495238720806273113864281410031160991303419337245133989782130340046557623032453011902769982e-01), SC_(9.2125588704115744531654321456654858899882026512734857432389133675190546080904350663586248749658574596e-01) }},
      {{ SC_(8.1472349166870117187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.4722046852111816406250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.1120701574778153407745289227333962263176488904889689025662611294919247006718182993422351310001143305e-01), SC_(7.0298263189863718637636004688192176796942829333963965371900865941459473706020518994246929274803063378e-01), SC_(9.2115875435192793485286914432159385031522273028077542022800388197585088493664147919703487698209794513e-01) }},
      {{ SC_(8.1472349166870117187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(6.3235926628112792968750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.0567963800957047774225949571886325342392707660455771266094480582646702193647688908599299876021336827e-01), SC_(7.0853104977741206501329302411816566349956951089019877736376418185640410244299526923938672260238358524e-01), SC_(8.9491180184338962021306146944737091398904398680208952625262644593539899254459861974464823761669115196e-01) }},
      {{ SC_(8.1472349166870117187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.1472349166870117187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(6.9104400457305508568554814521131075738027087409434408361300335549951967489706341850667651691765001005e-01), SC_(7.2281268925194957580408548252455708668668389850394811062360018429393665024851082872860099351488455680e-01), SC_(8.2645023006813509903471829977016547430994322432540296870677280656799198222984234763646538663352866583e-01) }},
      {{ SC_(8.1472349166870117187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.3500838279724121093750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(6.8917722684450533754149276369687205537543196647355696515349949736675083007663106707892925681936180315e-01), SC_(7.2459281669011681663738039923573440253297398865269522964407164316632518516537291231625560118057773867e-01), SC_(8.1782376119013668659483735367708666592673987857028800191315347034215867078440437671897371276078083222e-01) }},
      {{ SC_(8.1472349166870117187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.0579175949096679687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(6.8228395637998369891991461146685393005640463381807225352900556984267865836199329959268004961688164914e-01), SC_(7.3108727445256253839648630021677304016032658500820247936450027349518525608087685624359988276537679255e-01), SC_(7.8617244856998338689639725575832511577010639535226580706150115112985101228329745708861066090419412763e-01) }},
      {{ SC_(8.1472349166870117187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.1337585449218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(6.8151025930746686430410002731230483653135523089835925136654803051335584135955298909492480981618621263e-01), SC_(7.3180855861261234244718966274055207000274963408547202000985315618423058552037383202853740781275849327e-01), SC_(7.8263967133846801638133004519128440234950333637574810006353888244640324157028896380350656667548220893e-01) }},
      {{ SC_(8.1472349166870117187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.5750665664672851562500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(6.7687267907261822298382270351454875070936857655549482249094730445968414772098012632797144739372658525e-01), SC_(7.3610011297720663827941034589565095308760402201826494850828051875201150893707409758588866156224913323e-01), SC_(7.6154665226360837750282328813264148468570235244281662572904305571553463430491979060842814525048729869e-01) }},
      {{ SC_(8.1472349166870117187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.6488833427429199218750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(6.7607432205458880329732204172724304676992789223981548905046396442451731611969638955719824281158956877e-01), SC_(7.3683343508450275782736611220779679595565954961648027439856606955897896305574127586750630515027413023e-01), SC_(7.5792971155459095665296301335177918781827399113361023627707542012456119957223076675684211588976940534e-01) }},
      {{ SC_(8.1472349166870117187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.6769475936889648437500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(6.7576909046060388467612258992582275598902496045014859489257292630463764783526536554972911927629226788e-01), SC_(7.3711338095170146205052727024635012121183233418003469505333772926725279770941237826979478819077523075e-01), SC_(7.5654796340069473352057233988252516434605943121264289426764314425986333972133188926148622304911158627e-01) }},
      {{ SC_(8.1472349166870117187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.6886777877807617187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(6.7564123224244632670866169971581404281890731188821744413353087377632756971329475459005775675445047190e-01), SC_(7.3723057810559425153648485872591759077701408865385569177050186278088833193549749747290263644538979574e-01), SC_(7.5596934425519105227768649866603443484608923734098720674059389033238484943523624562987059109627045189e-01) }},
      {{ SC_(8.1472349166870117187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.9288129806518554687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(6.7298763831316128935227655474813190601249087503312441199008390102906684210293457674057765057865365461e-01), SC_(7.3965372890135124568793469377509995823242190860888540849744965346216345224911349495547939232114852760e-01), SC_(7.4398453151529232289010766550971004610959361614016128459141464895758290420930558801023105719942120088e-01) }},
      {{ SC_(8.1472349166870117187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.9646115303039550781250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(6.7258614079680893268625822897316756945131889764605650241460395389032587876624505383475138799139754556e-01), SC_(7.4001883976562050136738496338519714611675185742196923224808214070126294129117999719619088482452447773e-01), SC_(7.4217516082340016418297092172241872190857578944247877583676597277003241989866300218114707079769599336e-01) }},
      {{ SC_(8.3500838279724121093750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.7540378570556640625000000000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(7.4076324788430907334158306356012619457725393392386225038107321265399554466344483117016772170440293464e-01), SC_(6.7176618743718388284011926222819445178580654931332986752937529825594206045228082963990418947090409534e-01), SC_(9.9738624019923539300981800609332742346600825579040162904951881708792436182996218338885876058748149600e-01) }},
      {{ SC_(8.3500838279724121093750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.2698680162429809570312500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.4038858064360453745530418991801971816271141370597740993834775724862885862348703337433612804378762116e-01), SC_(6.7217910533766868975760120514414304948483805301723570006425111783958102897059004973371108373504600255e-01), SC_(9.9557034858792031449618112179527461268193322442491420392539335988787185124425758588672419089593513466e-01) }},
      {{ SC_(8.3500838279724121093750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.3547700643539428710937500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.4026226758906612824943350153719522163069887400220616291531074391323743059000913046940867818471550639e-01), SC_(6.7231820976669511567810513184926597260109136692591513097705237598066943434863143418373792182028169259e-01), SC_(9.9495839790441227940124197003143440642518334870655214323867498177360456404329779862056865723085513024e-01) }},
      {{ SC_(8.3500838279724121093750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.8838196992874145507812500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.3929048964919188510673175669715677554266492856980613576662794961847201017886543999000672451855320636e-01), SC_(6.7338664370052522314215195448439128833291684853785074770399337527779090025993284365787455602963596273e-01), SC_(9.9025458644538219914033592405393576633363688438439385942427311676412725919726410290419925761910539566e-01) }},
      {{ SC_(8.3500838279724121093750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.2103404998779296875000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.3853158244033975132622991525473214539992737869332302118819812576288755830328615094075847966834871837e-01), SC_(6.7421888266212749959648395227119700761724614529473742317506271025786241567596522613546413931582605371e-01), SC_(9.8658628502078002829913118549085384306447259009666727774536724393584300503812859164547365838645341455e-01) }},
      {{ SC_(8.3500838279724121093750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.7849817276000976562500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.3689996557957474402368278774873781851667501950663615382056532856075139621589301250976710572249904242e-01), SC_(6.7600180527038650615667560418124471116115579136192703480671479434573037987560329242906608624239870736e-01), SC_(9.7871475861719318393178079621671134748028385862374676104791201858173718735586428327082725040831069340e-01) }},
      {{ SC_(8.3500838279724121093750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(3.0816698074340820312500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.3590926964818514212443010918240581052807402033004632762617606269977042462838512816072047238849403979e-01), SC_(6.7708016279158166630670944817623879564115008470584229152642490027329416558360818691053696613069538555e-01), SC_(9.7394532657393069384529658935021214142854824179973125906968923071408313026446657764606827004402222527e-01) }},
      {{ SC_(8.3500838279724121093750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.4688143730163574218750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.2421788311730029548822325065271354264197985168172358555685955095151187235114503077561420904438300482e-01), SC_(6.8957121298173139997246079274283464503283210224892016168927457999731975195617309385106600052603194062e-01), SC_(9.1822406486868193275755539372820892443129474286650254546816034533993183110935707364078647648283778549e-01) }},
      {{ SC_(8.3500838279724121093750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.4722046852111816406250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.2419651611525990381877779247103601708842960460229533883040836737012719658671940771722736314571710647e-01), SC_(6.8959365284674720708538829218615691276303202963314933828095587721810637171490645843783238209027546628e-01), SC_(9.1812316638742448033593382532116906645259770592790362255668830436448810091841014774822140960903101002e-01) }},
      {{ SC_(8.3500838279724121093750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(6.3235926628112792968750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.1839614581308613202149782572999516459682943186344466059063181028194454999586068972012047714772996940e-01), SC_(6.9563422693316570932615563296874897279527930445778844727148916473375348633255566917395665916878192772e-01), SC_(8.9085668303401992261130519634870503422003089933485526527325040573651519565983316449677827125517616163e-01) }},
      {{ SC_(8.3500838279724121093750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.1472349166870117187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.0301536114401092504194666075030448870547128016719823718768467640329414383248455882463171410076837718e-01), SC_(7.1117466349382547028589875020985812926935720102897837417466547077919982306114853694447965183862235452e-01), SC_(8.1972092642813956651017353548402389854784798810771553580668064499013623405451975193161217704753531464e-01) }},
      {{ SC_(8.3500838279724121093750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.3500838279724121093750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.0105134605983746938769822607345191989431122860907235029031960313396628199501685598169664154832620578e-01), SC_(7.1311079797440313832185514281631637157665502387149623500870705858757856129448864033254683553043527114e-01), SC_(8.1075635327748687343413787397609442974290674492088798659168342532492771063364309090310853185641908089e-01) }},
      {{ SC_(8.3500838279724121093750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.0579175949096679687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(6.9379498775503908234446901999857763332893317723875545926726495167488465688139124620792109603884180156e-01), SC_(7.2017255915925120021492613748623531050205192581180808096827576448324347831207018250987352806377730883e-01), SC_(7.7786308614091035660682923795060297689540542907301425690792987706948470756650277873732440059396959805e-01) }},
      {{ SC_(8.3500838279724121093750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.1337585449218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(6.9298015254857488709196146591482846263825611572573842494773812331787312566511366542408977999417436168e-01), SC_(7.2095666178609784617856189016462009271617855290831673465355752399547539271862384961209581744474470977e-01), SC_(7.7419157996144336950502764523805527883786888383661897331323910206982059616246234902199143973903020739e-01) }},
      {{ SC_(8.3500838279724121093750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.5750665664672851562500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(6.8809441372277983881207637424054525627628626279800432297782450862992909655258800452177795255479616314e-01), SC_(7.2562116686567508967684614345396635292307901764433965481867477139332881014109791820691049851327676569e-01), SC_(7.5226997367874660119889765875645287842124221752818923617931366949283420367225377312913440485233372918e-01) }},
      {{ SC_(8.3500838279724121093750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.6488833427429199218750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(6.8725306882118333591069706568031544801834209945472409215137778470988371770815767125988006952074196598e-01), SC_(7.2641807479981239886919153846858987098278165644752907613391228802325304610698397646109212752323412764e-01), SC_(7.4851091600116434967073519315874230780234397462471257432970519841781936760767531143265556274097243667e-01) }},
      {{ SC_(8.3500838279724121093750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.6769475936889648437500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(6.8693138147358459150147327312335392913476302859621178559092425137115550426721887841832251103330155669e-01), SC_(7.2672228337019679133591130870452959185365049144371840920581776644748890209928457039707410358324305474e-01), SC_(7.4707487452230952690152989249692744917617757234408596638624419858922028153750783062941590861443292123e-01) }},
      {{ SC_(8.3500838279724121093750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.6886777877807617187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(6.8679662677225768720267326934273486392768566645177624626521341401816503089513692091255358323523417388e-01), SC_(7.2684963606941991469338796014089336672653989735611095931782702323544050699988359469814784801463134921e-01), SC_(7.4647351934068971998349688935403495867766083828972779972880096383364335659512367186248310226490171285e-01) }},
      {{ SC_(8.3500838279724121093750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.9288129806518554687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(6.8399945990082017197244171838863273836670338927990084952169792324564029028558239641840767993508826379e-01), SC_(7.2948251442744417410047768411717594712672691702250179708532973086774800313604591708311706845225230731e-01), SC_(7.3401776147879441458791806264666042015929100347514421043466211359715413276880253266839501325059059013e-01) }},
      {{ SC_(8.3500838279724121093750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.9646115303039550781250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(6.8357616653950641272331382771665683610694805502872408520142233875309891500280330159901904240170697493e-01), SC_(7.2987918489237175493209607091573035092798417369168804318131334596447070913625916559246502247505200885e-01), SC_(7.3213729026940675967095424179659294123081453912643359905807273277032367666477546142843097127298108218e-01) }},
      {{ SC_(9.0579175949096679687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.7540378570556640625000000000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(7.8629691169433263475800603930812353384243062463068377995635169827854063791601469895063203091945293667e-01), SC_(6.1784882184880377635616753819043888831373673096130208455027911643898037827398293629295042904875253644e-01), SC_(9.9705454707427469130784264794553746645812018084679010135200513465160541135974212386366154791789825519e-01) }},
      {{ SC_(9.0579175949096679687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.2698680162429809570312500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.8586775469486550907269874802317658509813553150605506347815002692787422734387567924611635557680941633e-01), SC_(6.1839459257892180377278808234017449057546331058878012728794294136332375005052045308373789451403192506e-01), SC_(9.9500803583322488794423001831632183464951810729528182561866138193775722268771712512172588018712258040e-01) }},
      {{ SC_(9.0579175949096679687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.3547700643539428710937500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.8572304455498794692416610328186131910261183319000153607237699002788614633398256590048571299705202266e-01), SC_(6.1857844874780468349880505248516681224836844925844552246519735219268406899670899779998228321369189550e-01), SC_(9.9431833421878408996010706649661096697712399154524240043261150043851286694637970738873523090336682621e-01) }},
      {{ SC_(9.0579175949096679687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.8838196992874145507812500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.8460928117705408647866186817081845242123373737698405493274540434192664995174875216431232460007710812e-01), SC_(6.1999054500115280386121138431975506858629150925943682090767424140915108027379171539841164397037658362e-01), SC_(9.8901633698445049305483056714137455775514797559259785585868621571407237631664144859011379366873815514e-01) }},
      {{ SC_(9.0579175949096679687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.2103404998779296875000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.8373894067706275579665503432095691027393318761088545116193247668672839372414502234437817995941039317e-01), SC_(6.2109039025442625701691726397880657204176746606617423560017412889407021111325739439760524766684183776e-01), SC_(9.8488087118014180773926596948713818903366198016463206031958732691828181878217331995710923365624057557e-01) }},
      {{ SC_(9.0579175949096679687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.7849817276000976562500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.8186612756217651830841332116146037120880163315636881192653458265335999592420606939047616637671346105e-01), SC_(6.2344635580852208279408592743597575320389000493687758705299996298601526530930110088952131490640784912e-01), SC_(9.7600496060732927711577618060458769058233690277452637572187537037024859013215677906296002545926249346e-01) }},
      {{ SC_(9.0579175949096679687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(3.0816698074340820312500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.8072791115920204711416268351606945427518688114008704320135430129723314648008046950037571800078832455e-01), SC_(6.2487112970354864653936219008446256113804436452303988550977004301396796903410955895674955959422907989e-01), SC_(9.7062570343871750701253917403608109537390745123852984619784641884185326891204208246531445365443997583e-01) }},
      {{ SC_(9.0579175949096679687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.4688143730163574218750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.6723679780242606553198843774954072899365927867722785683383344925043665696499964603671415027355004608e-01), SC_(6.4136393420419204427721079056556643784187389601707326883820624820194356323069801365174233384526577758e-01), SC_(9.0771486558272730172879154432178102679317450162008358779740185984639432178148273865403857926289608787e-01) }},
      {{ SC_(9.0579175949096679687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.4722046852111816406250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.6721204562555277801403283705234839196623556791457528112193325639809411609081905105622741353881458035e-01), SC_(6.4139354303505014506850193378500784304187379310964496816385368458431112320730674032366091203224842204e-01), SC_(9.0760084786018331942709212261602554038283761087253930660996507087784979915325935814224033229261719497e-01) }},
      {{ SC_(9.0579175949096679687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(6.3235926628112792968750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.6048035150043737165538800849453773436177643088117811475608982040704598824612431775715542885122423307e-01), SC_(6.4936094352969152270756102460889639806351204706356560056739606923397009524676079410050445839599923509e-01), SC_(8.7677720690194663757229165211291877589624297065936113526755570695984316860018888882536261710439852680e-01) }},
      {{ SC_(9.0579175949096679687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.1472349166870117187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.4251711293219378985602788397505834460276096200613618273297812663657644023159134115458811199450563033e-01), SC_(6.6982709485570959082636809098704703895756779662940302817291336379070346786937569566310266129076309112e-01), SC_(7.9626639631694422592435789151300650372141601935365005341405791958592846550265840499728967511652485723e-01) }},
      {{ SC_(9.0579175949096679687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.3500838279724121093750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.4021224778983898058073499588402961606809466264561903877922077608437595958978264520578976121050178004e-01), SC_(6.7237328041937688022980849614829396458042787504525960323002450751016622856583247886586194058479934580e-01), SC_(7.8611250539876966795694314893111599813405052384345503509006162648615953474704989049626489088395657641e-01) }},
      {{ SC_(9.0579175949096679687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.0579175949096679687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.3167620680000075520923419608491810238745055269088554241321942930185672203660552621176187193155525532e-01), SC_(6.8165235157135820492189145828922914599728539530991439139834583010271398802186398444454079856231239987e-01), SC_(7.4884402249256454476519725002075826962230127264985080889599191100849205925391534673113600351392193175e-01) }},
      {{ SC_(9.0579175949096679687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.1337585449218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.3071572630609677010469128667249519696439359488791099005373016417084933869332276820697812777395786168e-01), SC_(6.8268186392268652145834521119908639534523527683604357706307080932545932399291972745550845211718388177e-01), SC_(7.4468320686276709619482028663682491547720583815721844004996713031639626610979387572981360294230999304e-01) }},
      {{ SC_(9.0579175949096679687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.5750665664672851562500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.2494875129128055361843383062476392479861437587790355512333464129357724320659642967602880085423675742e-01), SC_(6.8880280777680708568830071458539469299881996102841543359254950890921687730833950551766430056098629640e-01), SC_(7.1983688528322886817454451853819227834367263204520890104698288663704751305969802566816245514643778669e-01) }},
      {{ SC_(9.0579175949096679687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.6488833427429199218750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.2395430363724595731046879056752369962362327480342926091102626998457381280806827913952612832383433259e-01), SC_(6.8984792979693016171270083749639226004860969743712494282686832427137287305737399642922074490753116621e-01), SC_(7.1557582895098043568946350488758899825112101278791181548325529257195441896364025696614771547242280436e-01) }},
      {{ SC_(9.0579175949096679687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.6769475936889648437500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.2357397456481587011104935077485803009288871693050220813003548660618025700569977845197801242959693320e-01), SC_(6.9024684231981474255673737889661943118939686190598012034761539988039411726173973857634531340467474713e-01), SC_(7.1394798131110777350237305395221789751621690136626589519579974184227032556219529444048054861712686103e-01) }},
      {{ SC_(9.0579175949096679687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.6886777877807617187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.2341463798991304672858320269856048490777557838665150030915701909441151411168689710800914427356512077e-01), SC_(6.9041383353893123981496266490585215592888995184083236351952543124993147912290058784839147303719536133e-01), SC_(7.1326630054270987927239381586051120230189040569756738647994296610306204148778683267585979075606646302e-01) }},
      {{ SC_(9.0579175949096679687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.9288129806518554687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.2010498386900745867443479007439325538292969898724483120533363817647611197507708168162395964211018912e-01), SC_(6.9386512537165067389389809675198250843000241121203206374130475731942173769874403991978511769535081733e-01), SC_(6.9914616271393880171572563782813906881868824403653481548013024973604593948789994174600367553022040859e-01) }},
      {{ SC_(9.0579175949096679687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.9646115303039550781250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.1960376907541222827559892525820018886712603922128442660620943320512419319038997589180484252573046475e-01), SC_(6.9438491885442096747315808742294801641540759478424923714581750129020852709729816396990967405377775477e-01), SC_(6.9701432541760521394863987768562498320227622401655656122429566564369131264511469209597366893831875724e-01) }},
      {{ SC_(9.1337585449218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.7540378570556640625000000000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(7.9094632803718866216457540000839809041495982765507582341207041853099201108648289994843518347144162800e-01), SC_(6.1188553354731957123625228913250573326175912548469167432330947450060259335676817177888424178226730367e-01), SC_(9.9701955862518728726704898788317593573763719746710677961454510409770374126863309473473493960015484631e-01) }},
      {{ SC_(9.1337585449218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.2698680162429809570312500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.9051174797693570476320719875609096320398575092909776600809904944814446450500729435178442692188572199e-01), SC_(6.1244687631699917805363241157983286552744098835460603108388714718151896932949902212950637664677430621e-01), SC_(9.9494871245222398415600394441163970300462414902117038063235708272474453990289103631436607676254321671e-01) }},
      {{ SC_(9.1337585449218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.3547700643539428710937500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.9036520570720260883226397250933752345934344095758960991490162280501040807088817237382938824654365757e-01), SC_(6.1263597805500396899996035081225461422407985448744160099593776162063675653135179254453554990889249075e-01), SC_(9.9425080507669167263849987676670070877142802692828652948538238264225563258955018755280506577257981469e-01) }},
      {{ SC_(9.1337585449218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.8838196992874145507812500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.8923728262805153342282405606062581420370479483579705789721544122968733545593774054429114805968916929e-01), SC_(6.1408835822696484759357268240465303898461306592932186936120482828660406786245942555753286677014982242e-01), SC_(9.8888565077007745714990491436415663869754626485369815489495587368118027620281205946136766383330065879e-01) }},
      {{ SC_(9.1337585449218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.2103404998779296875000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.8835580528077788100088702676352259521202373702448163519056485534504734878620104336769912383606097897e-01), SC_(6.1521957403848605938079727724784864333523299380800734355992677931217704168088900623014107614822024784e-01), SC_(9.8470083067762954550823838334662864357586683612054676297110637677267259914616162477285538974467956823e-01) }},
      {{ SC_(9.1337585449218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.7849817276000976562500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.8645881620076702777981950221351674525938599641690431446879971679949916602142635287817508258258563416e-01), SC_(6.1764272068898225301342833505743732302882248960430569503104358272554900669993559949054300113369137507e-01), SC_(9.7571872120155081543518010646536883243938054653302232274750795304872284253586602868599256092811959672e-01) }},
      {{ SC_(9.1337585449218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(3.0816698074340820312500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.8530576710577628874300717610181366952035733766428770043028393890726075085245789988322966129604491272e-01), SC_(6.1910811022826074093362060647042146144197393508352752594235962586598774456213309498630627487163798294e-01), SC_(9.7027492561773279859007459449068629008385106760690962758755499162451656640875515936610193917251587201e-01) }},
      {{ SC_(9.1337585449218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.4688143730163574218750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.7163116748586988534281975726095510144271248886935386188797177688194341552906126914979825850982741647e-01), SC_(6.3607023304379950954845237094157116095819379323424114094158951146615124396812300262985833865727782419e-01), SC_(9.0660013061774195012851970652803601780465195581295197670245346496244616460303984754978960543005295162e-01) }},
      {{ SC_(9.1337585449218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.4722046852111816406250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.7160606617644142316390572673709149280033571543207058659626415929753474576118422613304861693961202632e-01), SC_(6.3610068278513669518321916534567713342672286788392010547944230417264297563764096719688323214534212339e-01), SC_(9.0648471402597960208408171746963203001772719652931446797549497567792809874663469162649693548835774697e-01) }},
      {{ SC_(9.1337585449218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(6.3235926628112792968750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.6477781603027443934265673695904976346142618034494172548008038127615436309692422879725391568052943668e-01), SC_(6.4429410373521478067628666061153626730899032053508042787795445954627735105804407776104006024554359979e-01), SC_(8.7528119566681106354037230231541975543900996666065628768119798971614052605300176891443985740326672973e-01) }},
      {{ SC_(9.1337585449218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.1472349166870117187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.4654229372762525985568572402815866286703352653991180272692877466124254865061924339107033896401056118e-01), SC_(6.6533796199818336428832031836471653611890078755621196067041221423197885945056260399954115325343191283e-01), SC_(7.9376425174812357223702000403164420265657509245578469252131740773234144685252889358367775788336921194e-01) }},
      {{ SC_(9.1337585449218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.3500838279724121093750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.4420106241637256205263375423527715119826223578638285805480797055537695628398351362642715217522541673e-01), SC_(6.6795567120756026266980428655742859571142254556715931596104772654691904011984056543471534950591309827e-01), SC_(7.8348228090969812572605311513504583629409739989739971736363780339264003298710480252792881402632130864e-01) }},
      {{ SC_(9.1337585449218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.0579175949096679687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.3552772643497240474242029201343405004144096179411758273288706273385790409372433781111809106530220561e-01), SC_(6.7749462259519108034385146658029178929536163498746430627977240982118759791916229260639053190658428947e-01), SC_(7.4574190358255876270416800662502960539430272915359229279590619949401467891901375786740463462569907132e-01) }},
      {{ SC_(9.1337585449218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.1337585449218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.3455154814564588182296201574650962343605613170440166963458759421893446955116106704945218014609649403e-01), SC_(6.7855288896064312613329297339698885079356801144224459042566688431524061621581974159437598956264533356e-01), SC_(7.4152824781250675520123680770386352603648230395929872347089212346768429157439004588520950810626017819e-01) }},
      {{ SC_(9.1337585449218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.5750665664672851562500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.2868930336224944509954435699051242081626637411631223395128481038247868701945966933331023238324849676e-01), SC_(6.8484443428083694950965934337226569360278372185780494353761474067946121047771042094069261880780382803e-01), SC_(7.1636584347407644067442440414513640906435817672499764627210124493880450035126861233202245358355972029e-01) }},
      {{ SC_(9.1337585449218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.6488833427429199218750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.2767825520295792761981950284218195432649301193777422580468789124034484718597293260179870321648976406e-01), SC_(6.8591862265488814598207283937984289915009495339977322047486165007075591804231677119337570929029830233e-01), SC_(7.1205049479704653459059907488714433284873086905560693331624992990057709254540332542301503693783211233e-01) }},
      {{ SC_(9.1337585449218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.6769475936889648437500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.2729156408884616188252236800567647324977059680184254110660622031114286979374881356508170844970068020e-01), SC_(6.8632862449791482956006904604873948497946345253883765393884403923726665619594485953811111705621852125e-01), SC_(7.1040189995260597042413081545340360538288277461787326957080257406133271715687985449508776065695190867e-01) }},
      {{ SC_(9.1337585449218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.6886777877807617187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.2712956002394947631420375400798072082221377177630136507400001399517572361358630209846695782533182430e-01), SC_(6.8650025705703683709401614032771115319380648003945659590166434458294854416700474012545240108247777996e-01), SC_(7.0971153008876086030802465211910776703329569005841818584589618132482137750827121865705431964049230319e-01) }},
      {{ SC_(9.1337585449218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.9288129806518554687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.2376421411795013781876382997964877246386044974977570266974044690882290588228048169251607567133984599e-01), SC_(6.9004736240509319579342780821811323843885837731498759120449859487051012318286418542125764010664910669e-01), SC_(6.9541128971165909642180517226861973826912875776495066163049108929300304505924490440623149447784437403e-01) }},
      {{ SC_(9.1337585449218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.9646115303039550781250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.2325451860642897188152828045862869429735547800828760691392936026869092888583987755704967764203313624e-01), SC_(6.9058156745990743835036974787930069481462217685018082013140677507915710683611361133769712669561546807e-01), SC_(6.9325224233776771514419828579232133958797884786951121700455108796658537637600754481809036530756037498e-01) }},
      {{ SC_(9.5750665664672851562500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.7540378570556640625000000000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(8.1709210993663495433724049865926552371932963305159468559210085234170340653438550915590681983464200995e-01), SC_(5.7650714122142325611593563191029953038681105649361290750646770425170350891677643395822499920448126015e-01), SC_(9.9681893736381418090238653958398570460763205804420111955339855670113783050292889755343489535934876951e-01) }},
      {{ SC_(9.5750665664672851562500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.2698680162429809570312500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.1662811092584171155600896320355671172506061214954960728686062113437446664812903861595066350392197715e-01), SC_(5.7716421272086089468838998122438480510788377412305676930582794691228516302427637425187512619066812419e-01), SC_(9.9460851809854972420332642129155468766675291406056363678783422652618614588187504867495246792521083278e-01) }},
      {{ SC_(9.5750665664672851562500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.3547700643539428710937500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.1647162388018632592126392297015506039032802541957745474422918611226470962892025950902185570469980654e-01), SC_(5.7738556216660938783816583618334331785869656737892488198969273801339470934539794709960436953484912910e-01), SC_(9.9386353950249765185205266104110460891397608791805965326037367000824199707174472334641525460543536214e-01) }},
      {{ SC_(9.5750665664672851562500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.8838196992874145507812500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.1526674381910711984311727412201753197457963494198834042266727315229933008227488628048160025270172213e-01), SC_(5.7908560370863163325931188146423525111471112700795917688258027753104276966520505790159179169093558844e-01), SC_(9.8813597540865294270651309191241569380210939981586008982939529962234682493780461621401781779617654353e-01) }},
      {{ SC_(9.5750665664672851562500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.2103404998779296875000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.1432461851757072723696758566175492092418960599882008780818287260527803616254393279788432544689985247e-01), SC_(5.8040969640092411729879917885692377407517550359723181988462399033284082820000053118611202551306699125e-01), SC_(9.8366780536951880428910485167321808369787968511555206084169136855660782482855445459009531279875197420e-01) }},
      {{ SC_(9.5750665664672851562500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.7849817276000976562500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.1229562319061812978125588918876052019483207133418702007276229393601208904118966582830972412252326582e-01), SC_(5.8324593487255899261081288613894845182307560990412435606137883156617098605950425970701739572895625419e-01), SC_(9.7407557385754807772237815910852090414065016911343206131063430542221154169570616871301623802352894399e-01) }},
      {{ SC_(9.5750665664672851562500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(3.0816698074340820312500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.1106135432772818118207615170403853132257742175468207387846657842398119594503261892247140988360409186e-01), SC_(5.8496109230962648627726309529515706502263992959812695751552726775788163518174287740983664340142963901e-01), SC_(9.6826072536977889098729286069446366761499761169516218997758352281518573925570009098623283163652065565e-01) }},
      {{ SC_(9.5750665664672851562500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.4688143730163574218750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.9636945631050270069278375114188689623095223969427572568041642408174456930637833783100943259338740317e-01), SC_(6.0481045713158294418493161372134231131546824327444109853680115145230214170303655131544543991210159719e-01), SC_(9.0017921244916811522232681679034495932477715475802375211038059628478845517612433630015266779451137741e-01) }},
      {{ SC_(9.5750665664672851562500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.4722046852111816406250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.9634239963617005724228966297509274172728348516176373579589170017576924302352754706332782147102576034e-01), SC_(6.0484608169492709336061602443344085328860716135415394575823552233266931677569598278331755633111429440e-01), SC_(9.0005570410526376672910706381605698291076770844649658392126239214858154233298947276700439344206734217e-01) }},
      {{ SC_(9.5750665664672851562500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(6.3235926628112792968750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.8897092534081221262602685804594561757297571640256886944856646006317395269052464463697743614392627218e-01), SC_(6.1443053225475581145537892452906008145987784409202735689781970862748832907912669886505749771743935140e-01), SC_(8.6665203116902580373676597295081657808871031714832220008596420053565738172373905185660078524229910777e-01) }},
      {{ SC_(9.5750665664672851562500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.1472349166870117187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.6918148518185517828751465517055732565365423776541057368053251198171976630234381770578827801900326803e-01), SC_(6.3903039274625702483784886100024023774175466194771007761916044479085265244186887790182651584684555659e-01), SC_(7.7928456206926411697556858030722458687889899566035085253994101967268841860699471175827605726497342983e-01) }},
      {{ SC_(9.5750665664672851562500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.3500838279724121093750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.6663066531761220468493633019722121346791524592862397048655946005593557288695287098876258725431493397e-01), SC_(6.4208832958922035177848884081001370368176131406049302540075227956354621809332450392493049890528449187e-01), SC_(7.6825575072257236620486867444172947416173309054434824153081412148023851960029776656072457811223166667e-01) }},
      {{ SC_(9.5750665664672851562500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.0579175949096679687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.5716245105161454239276950897273466663748558672916903124444664977516862140735703942921532749826770291e-01), SC_(6.5322662431771059292103377737985892037717090167591464310137066549208556358115561689400212259532272311e-01), SC_(7.2776036000457704594059915141741480889472894082073408496540881174084505197293111282555716829159845841e-01) }},
      {{ SC_(9.5750665664672851562500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.1337585449218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.5609505142250801461611916997824554077157399558031721566062619155561021800781029775069820859332733265e-01), SC_(6.5446181952379388676680022129550328723322041065202659190624914142461258546314443755125766218888423401e-01), SC_(7.2323790786811069200199080342525881916304208506534947131141101069823743265991496906461075198350873156e-01) }},
      {{ SC_(9.5750665664672851562500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.5750665664672851562500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.4967782857809769790072114554227242812988486320892838685251105240143400748771307874689439350509950300e-01), SC_(6.6180295658030144720374118879541902185191498999530166532679784805985684529509188750901122813239140880e-01), SC_(6.9622717417005126815080131460878093141463991875088811785595207611112557494727555374097043138134059482e-01) }},
      {{ SC_(9.5750665664672851562500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.6488833427429199218750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.4856984927033150786175697799766307767729303079201730034707452674512772459719133083666683546666256020e-01), SC_(6.6305594090045914231313480209005331121786032847725076900701023096192174896172216027039021669145123008e-01), SC_(6.9159415789562596737640892274106790287856213010560934318225194966898674623924280033663958746128236636e-01) }},
      {{ SC_(9.5750665664672851562500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.6769475936889648437500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.4814599271357649629799500304722155106212019315723163922420952919869188934415149603621263443327491063e-01), SC_(6.6353415404681102527476054647232979712575379460213360275414944287930588466582175330991228778831306232e-01), SC_(6.8982415629906089943281077447431831873678794861226726322914842387529785902801572268470819042286705265e-01) }},
      {{ SC_(9.5750665664672851562500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.6886777877807617187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.4796840303838460885797666828478262317148014682815479699161629641034700623809208396016110889904286836e-01), SC_(6.6373433545071980238962427396513920588286723061444232938711478985607895231699991438826542163941744708e-01), SC_(6.8908293809584683023333648518684484623384757316724035011856901994988108245925477572718093182075235849e-01) }},
      {{ SC_(9.5750665664672851562500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.9288129806518554687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.4427729076373856348147633057106166090668009036465706046277977466948835105141546292069425877965626529e-01), SC_(6.6787073184366251491859779564088267420354373267982094244436747592639064896662061404064052390895342535e-01), SC_(6.7372845698754952270913128904213728875397529306579526453026169222509167607311813511339203503598104554e-01) }},
      {{ SC_(9.5750665664672851562500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.9646115303039550781250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.4371792708291468926079538249312496341506792697661742632647718601653584457875763163025716515087334230e-01), SC_(6.6849356386990921377548650054494443308359557811328462408893834993684094765401057888979707720168079981e-01), SC_(6.7141008801707762362327536838127753447002520003258664677614361701912169844786139960602713495152533063e-01) }},
      {{ SC_(9.6488833427429199218750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.7540378570556640625000000000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(8.2131193486226606250625499629749497854752055574747120536746701245313629314469887614089288005731686675e-01), SC_(5.7047936479140139746669847055606994659967032816435812589478361019934676875941093002412967747372449143e-01), SC_(9.9678594258433021858689676066227929388179912927245324921636243761409445079938945025080860403318041464e-01) }},
      {{ SC_(9.6488833427429199218750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.2698680162429809570312500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.2084341553209472146562808192609232933209407598479188522352638557506404375984242889414017165810352109e-01), SC_(5.7115329569004929114351626335668744333962972991872549955914473717711541664414804064232090803778978366e-01), SC_(9.9455256167657378206230420476881068670602937322290345512769421069155144782425694605730920457776266070e-01) }},
      {{ SC_(9.6488833427429199218750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.3547700643539428710937500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.2068539929917309197277880318884556179046821750855604445073356240937548088108742752185188772927021087e-01), SC_(5.7138032463251377010921927825616598925398514795148620103074916097505906115935866461333074165581244351e-01), SC_(9.9379983794244956376224110680694956468007893042151611192412528820134585255715460122836647234814555731e-01) }},
      {{ SC_(9.6488833427429199218750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.8838196992874145507812500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.1946866662140749681077657770922817113781733518493063193202252377034768044872244618704887096408454137e-01), SC_(5.7312398695721373436789113597313998540558361779223728209570246830974029266949714967197870638874995852e-01), SC_(9.8801262101886996153018749459609351546336480346579650607908280193038758961648964193468975034262406307e-01) }},
      {{ SC_(9.6488833427429199218750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.2103404998779296875000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.1851717727164519189725759952455695981884160008269433982313137319932486326649868332117582170910296887e-01), SC_(5.7448205412463334814279706763524472696171543630899843640358774977250307815877481054286137026086890214e-01), SC_(9.8349778509643456301818367755396284092802415568416778559937885211074902703240044981957122292843246663e-01) }},
      {{ SC_(9.6488833427429199218750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.7849817276000976562500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.1646773213603068834995371864925070033079252422093184436349556547524208099031492834451886001206564625e-01), SC_(5.7739106537999602196660906518838361383887095794516632542941067065848828252737252103313328648386852908e-01), SC_(9.7380499366247998547621671547573235453893877292299246462579307810149662735474112233307455692336379651e-01) }},
      {{ SC_(9.6488833427429199218750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(3.0816698074340820312500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.1522083663566896426198212302886928292003695201446367823375742224387149817471819356746172579075940665e-01), SC_(5.7915022879650141312876776425328073529089277189932859812589446893688685639390463535856396735941530096e-01), SC_(9.6792893826935084826244682024658378755436219132734703802325673191393950852779436233450146654104589798e-01) }},
      {{ SC_(9.6488833427429199218750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.4688143730163574218750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.0036835985160407061860142024937073650128806281762248567929239015374589737976909585946579888773109338e-01), SC_(5.9950853917892880438629976100023568332275666194676771428572628280172242660578764951106496500290170575e-01), SC_(8.9911786390119747516846811546566561312116692591862386856327314403539885062829235575595967673030998552e-01) }},
      {{ SC_(9.6488833427429199218750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.4722046852111816406250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.0034099077285934257473556649207277754503531976083706690469257593284201786741755143743230552192567550e-01), SC_(5.9954507627760389828603853607696846054198344730055531339965451524510332251112751479976179477948202816e-01), SC_(8.9899301176539656133542737128020935408473563824891345713529151364050373637790086550689042609076966507e-01) }},
      {{ SC_(9.6488833427429199218750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(6.3235926628112792968750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.9288226373407539099657625774058075663855175843418220314674774723219797048674963528491418072095956012e-01), SC_(6.0937485659971901732807958489956171816905758228874718802834510728936226644777209566539050349131226797e-01), SC_(8.6522345739339842508445718566636355118627285595248903220328408773346094227736634682116145166775246179e-01) }},
      {{ SC_(9.6488833427429199218750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.1472349166870117187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.7283907779600574238298726500807519105031134800149547840362640138078728818760010298949894983733970521e-01), SC_(6.3460204839837964700969039274086406341063656055624592565430927699681508747853190822957482520780202612e-01), SC_(7.7687881045680034063840537471194015164718690787530250979302574735755682826371055351056997822605050305e-01) }},
      {{ SC_(9.6488833427429199218750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.3500838279724121093750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.7025365246057229628184271772822819677021474531275760515708099194381205736283751607961404628967180331e-01), SC_(6.3773765050461612944680698447100308532817677281651360961496538581935142161509820011316651364370731097e-01), SC_(7.6572488113752242752471983008983098558749240212551022467129929877596332371401574099044475307104679140e-01) }},
      {{ SC_(9.6488833427429199218750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.0579175949096679687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.6065352930802865651458160911982969755109485112790185018001910112076240297313893216755568678438785261e-01), SC_(6.4915807655088139531961807803615654600591737283142145111692962124785935629047364708944319601958026852e-01), SC_(7.2476733038005768575717842095599739061539508374259879588945753040894493641687671128376890509205230347e-01) }},
      {{ SC_(9.6488833427429199218750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.1337585449218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.5957092957755003407094165951468863670701860474689066696492191870523755147632512360234887898217314436e-01), SC_(6.5042447904479773417163739982255031733981404717163423593278670440342589268809882901127390160198460151e-01), SC_(7.2019302147498498599713865991233770866456652606267229190262797505011161565305278412643666875334106024e-01) }},
      {{ SC_(9.6488833427429199218750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.5750665664672851562500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.5306098313012437382119981817235304056646059102892509879166681351032591498173055216149139648819416208e-01), SC_(6.5795072436094371493440508727398609648111456999852921548332786783110006443882936221469029580577512415e-01), SC_(6.9287168539543243875194587571954595837510044988781456935678304416414791013363642801359807502507792076e-01) }},
      {{ SC_(9.6488833427429199218750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.6488833427429199218750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.5193676736458960965570431720588593617966950378988318883283231292627456519651530479590121504706421394e-01), SC_(6.5923523713867953869343745903513031683149762747837317879400480771944718381037645907673195540389086913e-01), SC_(6.8818525274310444585915595709756879222267508792232730528906782247009893732040876192454826468827150193e-01) }},
      {{ SC_(9.6488833427429199218750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.6769475936889648437500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.5150668227914627001583099416342846485302813888670659023818489033542646812895326801841902176596613306e-01), SC_(6.5972547812691780380310153431804191821533387618413823530558372307011759001902040926441013863421998185e-01), SC_(6.8639483390116318321155800673503976493411535088137683562764031240150961058999287251091219811628127201e-01) }},
      {{ SC_(9.6488833427429199218750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.6886777877807617187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.5132648011211215595798125481331039701823560169869808980219290236009600137913180109910726958697060385e-01), SC_(6.5993069354466605002150399320091229843601044198927322398097849756259986650753602160061147357329873197e-01), SC_(6.8564506401626160271171842874524010309055922830431896824539519739437997062030451374689146787487530781e-01) }},
      {{ SC_(9.6488833427429199218750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.9288129806518554687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.4758069477057013391574652109255664370799399981217622500216414190246661449997599048804262257458969292e-01), SC_(6.6417099063897066026711338333367991232402871885371755602905174126204515577198526294703543951793627782e-01), SC_(6.7011322869895766262266616309476221702976500647081258807254357309329791362445914035381162846448653746e-01) }},
      {{ SC_(9.6488833427429199218750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.9646115303039550781250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.4701298430089359295147136693129527494556022702342800533982208022899036268507806343641147136695653544e-01), SC_(6.6480944735004548702856445474659279468841811340652807425996930955577094122120913454774183575301141004e-01), SC_(6.6776804885182623920093599737224595718620847152894051466931301663667807505226045554678159833643222629e-01) }},
      {{ SC_(9.6769475936889648437500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.7540378570556640625000000000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(8.2290457111253887473908313939245018213897489051996243922302870845519870013448752399939306968140799242e-01), SC_(5.6817960790764785252802507039254804963806348426102146751909981337840032784386860756864183492747195408e-01), SC_(9.9677344531020381901032528665975858665113852594143102577249044327798737543598494057908391980884353336e-01) }},
      {{ SC_(9.6769475936889648437500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.2698680162429809570312500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.2243436642005751480218838131842145885627448240801196517603576352912929786461802168945967270368583964e-01), SC_(5.6886001171750381006215001215838939909166777702837660753229395281924109901511537708291684764717336992e-01), SC_(9.9453136675479240235839344954759209405829411534021156355062745398078172754466120070850726083160987593e-01) }},
      {{ SC_(9.6769475936889648437500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.3547700643539428710937500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.2227577994237623230182903416522126979279514863383769269312498955777480795688297513577065844147137421e-01), SC_(5.6908922122999031289409066876478193115906762011607574397533727746763029989830910108118355251095139006e-01), SC_(9.9377570913146199849356460289715868636874097497589447803131736981002358544537058116375040722230817369e-01) }},
      {{ SC_(9.6769475936889648437500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.8838196992874145507812500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.2105462565767400296515270515809265289247544879930691133359314017795918135961718996263818126891294319e-01), SC_(5.7084963141455807618977143780180643824052423631803678615784073941770206841217934511311294309049815225e-01), SC_(9.8796589370495485384060722580960477151570346691928655949335857342190597226956824786544521711187070072e-01) }},
      {{ SC_(9.6769475936889648437500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.2103404998779296875000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.2009964101155388793059205073559408785558517342373801031421648841318672155228913460581990406170812730e-01), SC_(5.7222074308147938749676020538407074252731257860536282580445635260427532727758581889850959973742827277e-01), SC_(9.8343337701285313692908079037072547047422908076974386722487296418331900761562663816347632475685546396e-01) }},
      {{ SC_(9.6769475936889648437500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.7849817276000976562500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.1804255665488529819322283839325596197932363865135650863664703989381585393525137324509636359064884327e-01), SC_(5.7515769620299681523196131763354382790044194476205354554242731792785701940378257534923859485188127818e-01), SC_(9.7370247913980116506693171056257938307622554467592079769518122440038173446344985687573898455590147591e-01) }},
      {{ SC_(9.6769475936889648437500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(3.0816698074340820312500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.1679094046693952502938239267864816843160993386275573078389016894405556199500299096235398336842339941e-01), SC_(5.7693375665767075362949565002993315706207504670532509722532032738287980041353787935153841729533590685e-01), SC_(9.6780322572908544856491996206604313323680371365869951691363042195024334098251376025437450867926998594e-01) }},
      {{ SC_(9.6769475936889648437500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.4688143730163574218750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.0187821680805304630558639705627993241718501691107186718352602068931054437687122368597383078948398848e-01), SC_(5.9748751067176046281369976515983650719059587575431096485679546651992362280308046035362211346989086927e-01), SC_(8.9871542300786182828281829008317925084220673208591066754263746395327940747215146370054262058045157987e-01) }},
      {{ SC_(9.6769475936889648437500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.4722046852111816406250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.0185073019682977963683422775572704612418139912126519998098266422819830870919931340521167448809539501e-01), SC_(5.9752439823224866788807615624968789474466576475850469369153669493177667144144426612402235526320982750e-01), SC_(8.9859006082222448834603311045779974038680023386968048822084202704760078221441929576773325326811912978e-01) }},
      {{ SC_(9.6769475936889648437500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(6.3235926628112792968750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.9435913763483211310016474429763763173528265140226268975431776953159286021555657034247957167846839063e-01), SC_(6.0744840147624543040480565568163117989997372650801964839815121737042482199503461037450630724992543260e-01), SC_(8.6468159138744413396676005812607091707475628349565244633553770984743736483327550798687056853327772052e-01) }},
      {{ SC_(9.6769475936889648437500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.1472349166870117187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.7422002119763573473022623974551410429046260550355443672621918356301324658058585281552760801233427763e-01), SC_(6.3291654961513881524068979352985619510502927664804954969190227990891563890330800872123970143335658305e-01), SC_(7.7596559065281167382515614392972377522238408669878244063700030487129625550376187275458425693350557422e-01) }},
      {{ SC_(9.6769475936889648437500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.3500838279724121093750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.7162148123008930152905691560073306151712507444276036087688373153719037062934206939803916176869436881e-01), SC_(6.3608198347719529143079866456450674087822361859221122849022938598779033771861560046768816110494651123e-01), SC_(7.6476408243660183840419938109485003200588303810330465781765121116440529805281648672155130549192660968e-01) }},
      {{ SC_(9.6769475936889648437500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.0579175949096679687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.6197131286133462534204872724364709861867369546323659190098293514758935073046368715096134135212740687e-01), SC_(6.4761077691494148433932645716991492971825945207019429799126542704355365929598932189484512379662997760e-01), SC_(7.2363073525569356837483695936341447405343073512169278357288732324035829816287170087781405390007594456e-01) }},
      {{ SC_(9.6769475936889648437500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.1337585449218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.6088294122829192189573593899691209220551365404260297666051613679509605974627682887646299693478431344e-01), SC_(6.4888916599661583583191742839431267563913837793401085100474817550981256544702424652895450685317946783e-01), SC_(7.1903669658091869553499199723598392543318386020078614605424692086290835425606330134384951182427119007e-01) }},
      {{ SC_(9.6769475936889648437500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.5750665664672851562500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.5433776470804632538324450018895332039721555930120901426285341043481183062962676486460115661955828826e-01), SC_(6.5648650917994357494882237730056456372621121747467258246174714677288534952434434252098723294607005142e-01), SC_(6.9159716974889647394204562866543921808541093893677771305067303346034052168217340109729994267836183328e-01) }},
      {{ SC_(9.6769475936889648437500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.6488833427429199218750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.5320737654974403818310311550248746937758979318147137777958389820151113451434657120343491381090515956e-01), SC_(6.5778313136705785756914782552304084216334532826937060523201299640532546731877887807878831983864485253e-01), SC_(6.8689040829185670065390304733192123964252637656477894836629161735495986779850296074438142596672260076e-01) }},
      {{ SC_(9.6769475936889648437500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.6769475936889648437500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.5277492339448833032552620506923247079771087701254348756756670037290998319223094391589534577560671670e-01), SC_(6.5827799196724040705352386928652807480817343947077911986655016959551394553098507848093018430808359670e-01), SC_(6.8509221900702294142990062822217607731079329596150694082154543649138114162529890455098812968721938686e-01) }},
      {{ SC_(9.6769475936889648437500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.6886777877807617187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.5259372792347120511208513900171174265523078027907650428877002244570064512585395228003591118682413736e-01), SC_(6.5848514082722641045318515780959690004522427184714447582206578000919535583692874944154251813966815621e-01), SC_(6.8433919447059491606317899698937253156643345961432599538868823519863437224873075338860093401391862480e-01) }},
      {{ SC_(9.6769475936889648437500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.9288129806518554687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.4882714966564911589963464678291815197753223248921823778925915402821932270786437951781525638609762067e-01), SC_(6.6276534303146806830614033011904607423425272802815367380509024969437916152187152160400506578947262940e-01), SC_(6.6873985640819720499332503574984933626443424090193551101156252052265636689158713355326660102608676341e-01) }},
      {{ SC_(9.6769475936889648437500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.9646115303039550781250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.4825626390094247536750523338876072188027602808974214783645295667839420744583174838551457695326641261e-01), SC_(6.6340980060065673602846694939196477957722304199269235219373169524729882531597609958364997345354268725e-01), SC_(6.6638447140760840656106799845864705102968024899678634931061640323086244579035971006255115170607672299e-01) }},
      {{ SC_(9.6886777877807617187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.7540378570556640625000000000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(8.2356834198085297284638478882497893412871816334589239621590810510460229027024591898040465703289158342e-01), SC_(5.6721705376946205390427961665970059736024841347410653486325329192867205735266890106050044610393894154e-01), SC_(9.9676822956541174544458979160294111982717781368520479345239517921988891797274233681385758635050499762e-01) }},
      {{ SC_(9.6886777877807617187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.2698680162429809570312500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.2309743837436966617404061584025810958487423040924350745309837708523570239371915944832658715891326762e-01), SC_(5.6790017339454187709733967122169530737079369773124248179099101248653094850062872466345658961432021183e-01), SC_(9.9452252094573889268247067182602749357866296011926998156214020668071509030438569097887424492259441666e-01) }},
      {{ SC_(9.6886777877807617187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.3547700643539428710937500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.2293861540116714301114335748965692532281676426488813572080092006509710620671895225911746597112432437e-01), SC_(5.6813029780289829983158313693826276033204904230163591427582885571016405684240547942280906020516683342e-01), SC_(9.9376563881206421642154109673095286405454050276318869190608203974597576262167810669283035654944420139e-01) }},
      {{ SC_(9.6886777877807617187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.8838196992874145507812500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.2171562707541775283216100518725032460530587522999902077396394047464341865763221201438546301611964744e-01), SC_(5.6989773487885787427179047802937349935171858785204126189725011686947470165923388163284176312884215337e-01), SC_(9.8794639120759730563653981236447199276857561704765650822290723062342415862695712517241150453892666499e-01) }},
      {{ SC_(9.6886777877807617187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.2103404998779296875000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.2075919226741995860022293674808777165673493462865717943354941450379543531249526640795508237388354910e-01), SC_(5.7127431966484574129410659614727900954745850414292458284566734397702205511739341962362486090994521498e-01), SC_(9.8340649454532446402419297890771787264934785106713169722850236155930692812853696193840725165746138568e-01) }},
      {{ SC_(9.6886777877807617187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.7849817276000976562500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.1869893747042249014406416644412480636494428461317268675781299070794448073340348713329720284678420176e-01), SC_(5.7422299656562105117704036305857527950101084350416418369079686840586197166015317351976176674764678545e-01), SC_(9.7365968996184065528156835106043389832177131562045965008484624330161311734711663406971859565483591185e-01) }},
      {{ SC_(9.6886777877807617187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(3.0816698074340820312500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.1744536144048384709618262057324557989663805267623815469742810747661577325596655931632062666861254782e-01), SC_(5.7600614672018624561593666057872500780703090380284416620870806713853583547307032685078280291517026984e-01), SC_(9.6775075235597857654791139580214060936061914305308331448561529533864166673810715230627716567282370817e-01) }},
      {{ SC_(9.6886777877807617187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.4688143730163574218750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.0250758998479945716347885271315282721654486695283688765554142442562109426930428849726020493702485942e-01), SC_(5.9664190937009193806033628846764837334468769042097557387464882791398394285168604616060139501162232953e-01), SC_(8.9854739107724205860696760277356868115949305655710313163768421227636744084800871317745275812810807031e-01) }},
      {{ SC_(9.6886777877807617187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.4722046852111816406250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.0248005445491159930111905368543142667223077966946578947414112732678262325062889025008371371612595005e-01), SC_(5.9667894399085519787354441025116704239857773974702616021827449409407386541310766101282955598804924174e-01), SC_(8.9842181584438304721651085167770832139260472965064476312598487193878808801064907941163420527623331326e-01) }},
      {{ SC_(9.6886777877807617187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(6.3235926628112792968750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.9497477620164296772231968264033896521568678700617499548275530289350711240846408412648625274765408205e-01), SC_(6.0664248549137050838422773608047910448152667213498483233803291801277241435887758016633584572057242047e-01), SC_(8.6445531493435749587895765218694575073680275066920830435364274438099261586760681243447394402098571110e-01) }},
      {{ SC_(9.6886777877807617187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.1472349166870117187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.7479565394946284927234692341620507659649155584903095699478075711276977096863790391945111287047434699e-01), SC_(6.3221174824660148314365931999525650173201810373982859374672975529330674400521540533658537701860560478e-01), SC_(7.7558412442871289406615116723807701226119455675297337367001613402115828839211338193942671458005539751e-01) }},
      {{ SC_(9.6886777877807617187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.3500838279724121093750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.7219163949613172248590117969892223179795415018676581801066175755131413013347567019849892308484991672e-01), SC_(6.3538970080752500568485317471259135629980941976570735643282972254169548854638005016885241071859798674e-01), SC_(7.6436272776650432487665949146155026357687034770265683695986530198115778111166478410030519782867601898e-01) }},
      {{ SC_(9.6886777877807617187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.0579175949096679687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.6252057143127864915059263626930247618031854747565939517712927479260711142674626510247877184882667041e-01), SC_(6.4696396974183676343406986487958204792705002099258320832068524880356740049422150438932076464559177964e-01), SC_(7.2315588770236712038032010841854560477959726174036412347081320983155650922277083131934646560167211293e-01) }},
      {{ SC_(9.6886777877807617187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.1337585449218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.6142978850939479787275348601441484643541987325099658333214820832771970604198580658686151252731821391e-01), SC_(6.4824738886519111827632554463258721203457628779469471392160403957721185599032005102500449699827483095e-01), SC_(7.1855360011912210013653339935336949161412457665447326456542947645392663837703554952171651147339573102e-01) }},
      {{ SC_(9.6886777877807617187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.5750665664672851562500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.5486989077957704607751459319424252886558140204011058855703749743821491287355883048447574713911841678e-01), SC_(6.5587456727214954675935582401678084426731514721678965344884100275154915290479931670060897130352919612e-01), SC_(6.9106465557890191216007891266926390489078279068397906417112859654056825662650923649081040266614398079e-01) }},
      {{ SC_(9.6886777877807617187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.6488833427429199218750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.5373692286611959450453573860950992838774094974104092359774471134704801443129910501516572904715573077e-01), SC_(6.5717627095651687167846045087164594537656753877866000524919588158125479357038090641347830885991955275e-01), SC_(6.8634939382280689383938911264509535411630305944708678838769499267964044821387513467180728766925887195e-01) }},
      {{ SC_(9.6886777877807617187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.6769475936889648437500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.5330347993237233557058141218687045383091080771011016159558884363102277351786376773643504207409058457e-01), SC_(6.5767307009013065557421215154987024596096919026746445996495662494986513953475812583774305790284562070e-01), SC_(6.8454795536689524047556283012263023564263168946965089523781771181264963024025148459276925576291486267e-01) }},
      {{ SC_(9.6886777877807617187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.6886777877807617187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.5312186928470898774927370519378445513457379856947947534151774653365658368741861759056990792970803281e-01), SC_(6.5788103028215193322238585172265745241751638152286875290052429814137712553051399151156781860023980947e-01), SC_(6.8379356990913200292234726733780193764104630525534248630545704475029821506216977965377383686606439784e-01) }},
      {{ SC_(9.6886777877807617187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.9288129806518554687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.4934659918729493598363301389197093405642604690705700237172252786179976494710469901652844638241245568e-01), SC_(6.6217797780236964958939378553550407079885401563454607487246554307384099704235296009633890245319823067e-01), SC_(6.6816600511180792625101812555786169988745030740393627812069050638195632794922362344327133038874450951e-01) }},
      {{ SC_(9.6886777877807617187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.9646115303039550781250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.4877438593924676589255020842150792947534551745391740552992610573480038421929429854758692266029518173e-01), SC_(6.6282495348417890952162129867036387605454324121281646088490944802233037459695252793860197884801881198e-01), SC_(6.6580635264515609757499322352189439924637650574701108900350085477882355550135496634274167977559355901e-01) }},
      {{ SC_(9.9288129806518554687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.7540378570556640625000000000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(8.3690729532435869439533333466655854703547124397541829121270122335751422391304180830076208301386177268e-01), SC_(5.4734466201185031728910041317993517063542072024831507808864007001256776554845212955652373177217287441e-01), SC_(9.9666251812698509905732810013969053497377741467271954171523048440130494063580290129589808301610474073e-01) }},
      {{ SC_(9.9288129806518554687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.2698680162429809570312500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.3642283394304054286540539280717559353510883688748686863614096765854314639208925699418438602097539950e-01), SC_(5.4808470409115854573062854657031911305103434241742745363848341917895238265197778148365429811885245139e-01), SC_(9.9434322338789426112945818175678690487452432807214054071324366571663660798955061739422645061847815284e-01) }},
      {{ SC_(9.9288129806518554687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.3547700643539428710937500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.3625942105255306617886823793469730623336248696711803317378381872271014876467379162928369890950216060e-01), SC_(5.4833400469134573416884901132322831627064156210198355242701994012819216873885463602772391097389430164e-01), SC_(9.9356151647425055726622624481485490948761772040937186866816095509573559110707049958130643463135610807e-01) }},
      {{ SC_(9.9288129806518554687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.8838196992874145507812500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.3500079910696591519035882875511589047376502387554543692778629252639257606953473950976872988697085878e-01), SC_(5.5024873056712120841014945163476243324871801203868143135596956205181048728344978740533588991662911911e-01), SC_(9.8755100859529386245352913552765772294523342812678855872735998396923060099811788986599136768797526725e-01) }},
      {{ SC_(9.9288129806518554687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.2103404998779296875000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.3401614229055776499468115769005675952063649400456309790504079973244225219383622112214759040479050752e-01), SC_(5.5174004241016992144402269196766975816550009854595648707133992405564875928350829851673858242901943798e-01), SC_(9.8286141695328291645517343720405778498281454546620372507543417391182102046877121206088946156390024124e-01) }},
      {{ SC_(9.9288129806518554687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.7849817276000976562500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.3189405035698601049688582460383137103184031079269918907127711398907547694934213023298058566129854283e-01), SC_(5.5493449071097430188190574380996956328824195829882703265157381759683283537544216618530767052032197745e-01), SC_(9.7279182087994986021911844449080064986881114407678269529911939615613889746841219354010110333210728629e-01) }},
      {{ SC_(9.9288129806518554687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(3.0816698074340820312500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.3060216035439315083782486941891219215811048267682169794441474780935389790118328202319679585810561842e-01), SC_(5.5686627767769792178035295982889666713242360034836567639836607271767329586724400629867322237929431701e-01), SC_(9.6668627217848917325097682663441182908314631783133642789853712787548277415361309772062855935369233954e-01) }},
      {{ SC_(9.9288129806518554687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.4688143730163574218750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.1516988789033993096394881170296116606970498834871042797671051153401638437406466335388475308836053139e-01), SC_(5.7922193835942594447032830613655820673718384816658822035340199720354747423329103266995243214356940258e-01), SC_(8.9513195608735658804297085322617147495308598250673683940924321381648461660586538877240503996987645118e-01) }},
      {{ SC_(9.9288129806518554687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.4722046852111816406250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.1514137926330539011686285537938845410454863596518470319178046783421376328948371569200018200784413651e-01), SC_(5.7926205797783452039438930839968407852340924858641722606164912027056256742827068213185202175441546116e-01), SC_(8.9500203899522364025899818323075106072039973606788335778531604394315737862176691029238126954706682144e-01) }},
      {{ SC_(9.9288129806518554687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(6.3235926628112792968750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.0736297145187781404636691866172702777068660431480646292491885780225336349391440768819407983856885791e-01), SC_(5.9005510956892351093701980424855298830842639272402687961075319282502646736001419095514239513520704035e-01), SC_(8.5985195195478075048987330507289494169930694746461766018967545183788650273183374811605598358715407360e-01) }},
      {{ SC_(9.9288129806518554687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.1472349166870117187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.8637747588742202182040482010189002543834693790545268513033463497170723171441039581381353129286233249e-01), SC_(6.1774627916073035352884595588439805547878259401255276962743603871591956336991370779279813707835799667e-01), SC_(7.6780783896784181806209044930196735589329828521967416621646911972230243433635734758715266386541835071e-01) }},
      {{ SC_(9.9288129806518554687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.3500838279724121093750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.8366239945649301881493736346610076933805258741893282619495268828397597708373598579737419101854780724e-01), SC_(6.2118696354486703787455543576328568763623975502349979381785345756189626695411793592996562281739625541e-01), SC_(7.5617912887963976840730609080207847328376759174517163383892286167317612498237038674779298124168369770e-01) }},
      {{ SC_(9.9288129806518554687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.0579175949096679687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.7356609972222363681408167273709209988640499098959682482324394002540666295832191978444971419667127175e-01), SC_(6.3371562183722972808470150142078023775170205315784982660677195450820519950914159869200867370641796872e-01), SC_(7.1346605119516359158027343012463430995048953255593912514471078973952459143517844538363178675290663125e-01) }},
      {{ SC_(9.9288129806518554687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.1337585449218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.7242614144398140457300338492200118214072555055305288855043470107020123590274592501326932606186454982e-01), SC_(6.3510460241913098010195194517082269022113306623936764258418927477344489155305905286617400173768822320e-01), SC_(7.0869460188690080683551019029101618735059710095864890139995230855493381946417265275705458389561276647e-01) }},
      {{ SC_(9.9288129806518554687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.5750665664672851562500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.6556556611358773549465861886827182155373335151856724477440258948814231485288171443681364331095195516e-01), SC_(6.4335788172772230828417009576464734214974166586442289425853124661169150160915416343135096655023329864e-01), SC_(6.8019186310020591789807578388042819121340659460056861974331942997217228010351762798606583512444962951e-01) }},
      {{ SC_(9.9288129806518554687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.6488833427429199218750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.6437983111644691459360795752253471910139810234095141493430713921685213905679951578784456097576791608e-01), SC_(6.4476621637799238309385529739200586114972717572477009746665152601569769930591453451788053959138671487e-01), SC_(6.7530215818979407870111967706863226045049414176457263785533267714751808185991135424765891047482483718e-01) }},
      {{ SC_(9.9288129806518554687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.6769475936889648437500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.6392613724538872506773072571541873578851865129384544729119932518860326505861570891149954008636044267e-01), SC_(6.4530369349116506457824351831464781661329544804671797723132124100302655948736345227872841837122701477e-01), SC_(6.7343403576546853152372215300345460543470524775748942286958954939741913460539401157210310196800877651e-01) }},
      {{ SC_(9.9288129806518554687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.6886777877807617187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.6373603112203327878166764943097162175073091464875141069367987846443605732111613895027358260154185849e-01), SC_(6.4552867850000639225035851490362218653214813622116240555434994177680402871491668095744506265991983242e-01), SC_(6.7265171887828520645957464785546346725016162314238569517170652979668827782540865497945270979286786973e-01) }},
      {{ SC_(9.9288129806518554687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.9288129806518554687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.5978278283822479211376439731268141642022108080095832555933973987704296865652470937104603229869288191e-01), SC_(6.5017699351992065569746064599627737154536888227390453834366792436726148721533868773119735826598551074e-01), SC_(6.5644473766197150059277953711487155980360915730283952501378037406371103715133686833849501666306310513e-01) }},
      {{ SC_(9.9288129806518554687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.9646115303039550781250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.5918336733663972037219871212498362117551081339580453396486836115142190979661014478954656059145811300e-01), SC_(6.5087680459469498453412617782386488677994476550785121126771057160918237120006786151538232665099459464e-01), SC_(6.5399747100900172007298509080282708005245020667670621531355072097410857580673026605001215944240422120e-01) }},
      {{ SC_(9.9646115303039550781250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.7540378570556640625000000000000000000000000000000000000000000000000000000000000000000000000000000000e-02), SC_(8.3885482409737487793132986525390252548599016635647076881425605198439856189635291019635684986647676933e-01), SC_(5.4435520029532394631766859531442445028924423939805843855900693679606882689380332392533232650416764803e-01), SC_(9.9664694089105561049436599014171427205430440750206219053630830466477486541729108074262628038967567197e-01) }},
      {{ SC_(9.9646115303039550781250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.2698680162429809570312500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.3836846976079144894023795726943708541833389995672584811366755923228253071174017567635353431121846609e-01), SC_(5.4510394321720780766887536717356250054610572085005960031610835416626521365025255202834856505988398552e-01), SC_(9.9431680058555042048560821892288124889668236747200833373307558342592799237570669113081508646858944123e-01) }},
      {{ SC_(9.9646115303039550781250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.3547700643539428710937500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.3820441560966632694840359993609916279790205370061844267576841794174497598281495713485622976344391591e-01), SC_(5.4535617503834845711324861801153301842141480493596794361183694684559717959677144037999716529712971962e-01), SC_(9.9353143444262221939465586259809215783089086048975947684621927841892919843078927555582450058279233656e-01) }},
      {{ SC_(9.9646115303039550781250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(1.8838196992874145507812500000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.3694080839939330368414271429214551959961793583075530257748487453202093020709691019075041846416360706e-01), SC_(5.4729341603546632401734901252585114956817351177725909693254699621320094637152673766320203739840879612e-01), SC_(9.8749272761250703526071418423335735642830175784158270003092854064131945258173428320458022832662895698e-01) }},
      {{ SC_(9.9646115303039550781250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.2103404998779296875000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.3595219488333541745953223658793448369279376370877659139211318590602107483272687491384205103621224117e-01), SC_(5.4880226664048500692879221583078985251740360874646904338195445074557839493958187702092044696804312843e-01), SC_(9.8278105708386568298282282875597998137429996085178472000521847835028605762176132021719290137727508239e-01) }},
      {{ SC_(9.9646115303039550781250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(2.7849817276000976562500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.3382140916514258364057514275189395234076096015656622904743683896148751450562302576019453974647090151e-01), SC_(5.5203429025546581114852096977818457319004303981372761755614161259277270015439079181206829579325032785e-01), SC_(9.7266382772180763980428823267587850291886472907988601665506049159784515142450655743912151433457442980e-01) }},
      {{ SC_(9.9646115303039550781250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(3.0816698074340820312500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.3252411677796080099984218005465406247603158092900382879848475335969228461284474294838346745658610338e-01), SC_(5.5398880402321876447537992744785992051147320066434509696867298206540346295080549987859520437777915381e-01), SC_(9.6652925010955620940395542670963601024004192923501024067547444076347996257852171861223080733972851268e-01) }},
      {{ SC_(9.9646115303039550781250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.4688143730163574218750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.1702126153451325670867681664834862284442900110619845692881310008319720517769069946797733509893494105e-01), SC_(5.7660754261503767522810562864064328455649166811864815390603109965795766966575540449279700563129428370e-01), SC_(8.9462699615741016868034408689337159403352108892081501750962490910797925647981891785415699133208532444e-01) }},
      {{ SC_(9.9646115303039550781250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(5.4722046852111816406250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.1699261272360843718094896717933608151745983515066309372984104102996139405622722607210355081833891513e-01), SC_(5.7664813426824850966137934301882037328247242522271394061105905414771445854256739255757146117096354987e-01), SC_(8.9449643518753563454611035039011276118628076201799942256582642209492573307351767556846756787034337047e-01) }},
      {{ SC_(9.9646115303039550781250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(6.3235926628112792968750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.0917470232222200804623180098129133036872476212345687946408231027401224355414186080302191412417315445e-01), SC_(5.8756812466448807626035048020623505899237385118588318521559957175811892777170782847243623726402163039e-01), SC_(8.5917067186634159636297999262881680727474209461119658335870527906879501356002165645327808755884914641e-01) }},
      {{ SC_(9.9646115303039550781250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.1472349166870117187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.8807119444979816800923969304385287292785209340565035630430040254664427368175755115143127657804319275e-01), SC_(6.1558410674616056493571795007635947841655775384258519636348871522168706473724532307349806008226940840e-01), SC_(7.6665429525726110361447413684552291171054174846338591438308890401356527577849589856356276150225732188e-01) }},
      {{ SC_(9.9646115303039550781250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(8.3500838279724121093750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.8533974060861189062248546305583049909685081062975650698710874051826667020351572955065423608667621888e-01), SC_(6.1906501421159166628343674250361648671913040974698965825105617076167069374238270072189557585460007272e-01), SC_(7.5496484350046113300800020039074081961933680785286101512645919124096025389484980045855949751906931482e-01) }},
      {{ SC_(9.9646115303039550781250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.0579175949096679687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.7518052347000925314010007943527768455040920946345973339627012081381376695222757183254277030896944957e-01), SC_(6.3173978506404235602086192410695037495356623570300207001965408561482576560706910009779017218552967902e-01), SC_(7.1202695591348996943901212719172676293237917080282599202090818283760895203386224684127468737115722039e-01) }},
      {{ SC_(9.9646115303039550781250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.1337585449218750000000000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.7403326959640178723563496098403563126044877288657909026716436291016997542128873110698916026557616324e-01), SC_(6.3314492618823376986676740088221455887438346847232176226658849048417517890369368618344349029048271542e-01), SC_(7.0723024179015572507350410631921738029759560477969903360400060435126461530726016656465837852310688792e-01) }},
      {{ SC_(9.9646115303039550781250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.5750665664672851562500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.6712800823285619471798123561258913583803638220534736201364708009370629428320353958750416444955694982e-01), SC_(6.4149405218185064504992339458407016741795699167416304441730489787216690117110750201301703730190120252e-01), SC_(6.7857602589593721337697403304549699145452424462317392210364305668406670401778150852638680470506706518e-01) }},
      {{ SC_(9.9646115303039550781250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.6488833427429199218750000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.6593441813020686107904272195284976164911143038148978940760933715399917785398101606027733051459971132e-01), SC_(6.4291870957652293482277601636810697919275457997668849096935959115861162055784408260876292546568984644e-01), SC_(6.7366024601538257589655742562219072544530334312218911862590121331700593411003613779831508617892420325e-01) }},
      {{ SC_(9.9646115303039550781250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.6769475936889648437500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.6547770865632652104311857431350648982519639693036504351701283181609474922881977308885338563907679349e-01), SC_(6.4346241347126103408603307544875846579869659656475523368458255827578551435308991733382243465986469958e-01), SC_(6.7178215521760534606784911003038819524570089099102635584446923804691272196126068898352982615576142014e-01) }},
      {{ SC_(9.9646115303039550781250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.6886777877807617187500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.6528633729797841460176785222203390514942625072618331938529597075420681577693034777030027274670865291e-01), SC_(6.4369000454026378494764961458275300252507916799112249356864558832261907901572939091058344628185994802e-01), SC_(6.7099566282750678306967995163385198199449520575839393027024329721293501791261343629006364525136879702e-01) }},
      {{ SC_(9.9646115303039550781250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.9288129806518554687500000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.6130656170513378346158650596006841065509926127276492299715158864622868192915634720105938405478654273e-01), SC_(6.4839210290125166440291833468322114687478245067783826919074500661090573579759551799996853065323027448e-01), SC_(6.5470204815482800802602415811048971704607358039770120289884409108362609917793951796905679822441221683e-01) }},
      {{ SC_(9.9646115303039550781250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(9.9646115303039550781250000000000000000000000000000000000000000000000000000000000000000000000000000000e-01), SC_(7.6070308834386404159049681239553434730978977615881969147142722819631969635063229458010769940901615571e-01), SC_(6.4910000106617422443762696869434170692368988825415526998433303308325407487195203453870690819261137407e-01), SC_(6.5224167903128336698276201258993391810194122946207851950380395682119994293224476046299862066823494348e-01) }}
   }};
//#undef SC_

