/* This testcase is part of GDB, the GNU debugger.

   Copyright 2014-2021 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

#include <pthread.h>

__thread int global_scope;

static __thread int static_scope;

int foo ()
{
  /* Ensure we link against pthreads even with --as-needed.  */
  pthread_testcancel();
  return 27;
}

int
main (void)
{
  static __thread int local_scope;

  /* break-here */
  foo ();

  return 0;
}
