/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.wrapper;

import net.sf.saxon.Configuration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.tree.wrapper.TypeStrippedDocument;
import net.sf.saxon.tree.wrapper.VirtualNode;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;

public class TypeStrippedNode
implements NodeInfo,
VirtualNode {
    protected NodeInfo node;
    protected TypeStrippedNode parent;
    protected TypeStrippedDocument docWrapper;

    protected TypeStrippedNode() {
    }

    protected TypeStrippedNode(NodeInfo node, TypeStrippedNode parent) {
        this.node = node;
        this.parent = parent;
    }

    protected TypeStrippedNode makeWrapper(NodeInfo node, TypeStrippedDocument docWrapper, TypeStrippedNode parent) {
        TypeStrippedNode wrapper = new TypeStrippedNode(node, parent);
        wrapper.docWrapper = docWrapper;
        return wrapper;
    }

    public Object getUnderlyingNode() {
        return this.node;
    }

    public Object getRealNode() {
        Object u = this;
        while ((u = ((VirtualNode)u).getUnderlyingNode()) instanceof VirtualNode) {
        }
        return u;
    }

    public Configuration getConfiguration() {
        return this.node.getConfiguration();
    }

    public NamePool getNamePool() {
        return this.node.getNamePool();
    }

    public int getNodeKind() {
        return this.node.getNodeKind();
    }

    public SequenceIterator getTypedValue() throws XPathException {
        return this.atomize().iterate();
    }

    public Value atomize() throws XPathException {
        return new UntypedAtomicValue(this.getStringValueCS());
    }

    public int getTypeAnnotation() {
        if (this.getNodeKind() == 1) {
            return 630;
        }
        return 631;
    }

    public boolean isSameNodeInfo(NodeInfo other) {
        if (other instanceof TypeStrippedNode) {
            return this.node.isSameNodeInfo(((TypeStrippedNode)other).node);
        }
        return this.node.isSameNodeInfo(other);
    }

    public boolean equals(Object other) {
        return other instanceof NodeInfo && this.isSameNodeInfo((NodeInfo)other);
    }

    public int hashCode() {
        return ((Object)this.node).hashCode() ^ 0x2C2C2C2C;
    }

    public String getSystemId() {
        return this.node.getSystemId();
    }

    public void setSystemId(String uri) {
        this.node.setSystemId(uri);
    }

    public String getBaseURI() {
        return this.node.getBaseURI();
    }

    public int getLineNumber() {
        return this.node.getLineNumber();
    }

    public int getColumnNumber() {
        return this.node.getColumnNumber();
    }

    public int compareOrder(NodeInfo other) {
        if (other instanceof TypeStrippedNode) {
            return this.node.compareOrder(((TypeStrippedNode)other).node);
        }
        return this.node.compareOrder(other);
    }

    public String getStringValue() {
        return ((Object)this.getStringValueCS()).toString();
    }

    public CharSequence getStringValueCS() {
        return this.node.getStringValueCS();
    }

    public int getNameCode() {
        return this.node.getNameCode();
    }

    public int getFingerprint() {
        return this.node.getFingerprint();
    }

    public String getLocalPart() {
        return this.node.getLocalPart();
    }

    public String getURI() {
        return this.node.getURI();
    }

    public String getPrefix() {
        return this.node.getPrefix();
    }

    public String getDisplayName() {
        return this.node.getDisplayName();
    }

    public NodeInfo getParent() {
        NodeInfo realParent;
        if (this.parent == null && (realParent = this.node.getParent()) != null) {
            this.parent = this.makeWrapper(realParent, this.docWrapper, null);
        }
        return this.parent;
    }

    public AxisIterator iterateAxis(byte axisNumber) {
        return new WrappingIterator(this.node.iterateAxis(axisNumber), null);
    }

    public AxisIterator iterateAxis(byte axisNumber, NodeTest nodeTest) {
        return new Navigator.AxisFilter(this.iterateAxis(axisNumber), nodeTest);
    }

    public String getAttributeValue(int fingerprint) {
        return this.node.getAttributeValue(fingerprint);
    }

    public NodeInfo getRoot() {
        return this.docWrapper;
    }

    public DocumentInfo getDocumentRoot() {
        return this.docWrapper;
    }

    public boolean hasChildNodes() {
        return this.node.hasChildNodes();
    }

    public void generateId(FastStringBuffer buffer) {
        this.node.generateId(buffer);
    }

    public long getDocumentNumber() {
        return this.docWrapper.getDocumentNumber();
    }

    public void copy(Receiver out, int copyOptions, int locationId) throws XPathException {
        this.node.copy(out, copyOptions & 0xFFFFFFFB, locationId);
    }

    public int[] getDeclaredNamespaces(int[] buffer) {
        return this.node.getDeclaredNamespaces(buffer);
    }

    public boolean isId() {
        return this.node.isId();
    }

    public boolean isIdref() {
        return this.node.isIdref();
    }

    public boolean isNilled() {
        return false;
    }

    private final class WrappingIterator
    implements AxisIterator {
        AxisIterator base;
        TypeStrippedNode parent;
        NodeInfo current;
        boolean atomizing = false;

        public WrappingIterator(AxisIterator base, TypeStrippedNode parent) {
            this.base = base;
            this.parent = parent;
        }

        public boolean moveNext() {
            return this.next() != null;
        }

        public Item next() {
            Item n = this.base.next();
            this.current = n instanceof NodeInfo && !this.atomizing ? TypeStrippedNode.this.makeWrapper((NodeInfo)n, TypeStrippedNode.this.docWrapper, this.parent) : (NodeInfo)n;
            return this.current;
        }

        public Item current() {
            return this.current;
        }

        public int position() {
            return this.base.position();
        }

        public void close() {
            this.base.close();
        }

        public AxisIterator iterateAxis(byte axis, NodeTest test) {
            return this.current.iterateAxis(axis, test);
        }

        public Value atomize() throws XPathException {
            return this.current.atomize();
        }

        public CharSequence getStringValue() {
            return this.current.getStringValueCS();
        }

        public SequenceIterator getAnother() {
            return new WrappingIterator((AxisIterator)this.base.getAnother(), this.parent);
        }

        public int getProperties() {
            return 0;
        }
    }
}

