/*
 *  This is the Ethiopic Unicode table as per pDAM ISO/IEC JTC1/SC2/WG2 N 1485.
 *  Ethiopic begins on the 18th "row" of 256 columns in the Unicode specification,
 *  hence the name choice here.  There are 384 entries that begin at position
 *  159 in the Ethiopic console fonts.
 *
 *  { "iso-10646-18", iso_10646_18_syms, 159 },
 */
static sym const iso10646_18_syms[] = {
	/* 0x1200 - 0x137F */
	{ 0x1200, "ethiopic_syllable_ha" },
	{ 0x1201, "ethiopic_syllable_hu" },
	{ 0x1202, "ethiopic_syllable_hi" },
	{ 0x1203, "ethiopic_syllable_haa" },
	{ 0x1204, "ethiopic_syllable_hee" },
	{ 0x1205, "ethiopic_syllable_he" },
	{ 0x1206, "ethiopic_syllable_ho" },
	{ 0x1207, "ethiopic_syllable_hoa" },
	{ 0x1208, "ethiopic_syllable_la" },
	{ 0x1209, "ethiopic_syllable_lu" },
	{ 0x120A, "ethiopic_syllable_li" },
	{ 0x120B, "ethiopic_syllable_laa" },
	{ 0x120C, "ethiopic_syllable_lee" },
	{ 0x120D, "ethiopic_syllable_le" },
	{ 0x120E, "ethiopic_syllable_lo" },
	{ 0x120F, "ethiopic_syllable_lwa" },
	{ 0x1210, "ethiopic_syllable_hha" },
	{ 0x1211, "ethiopic_syllable_hhu" },
	{ 0x1212, "ethiopic_syllable_hhi" },
	{ 0x1213, "ethiopic_syllable_hhaa" },
	{ 0x1214, "ethiopic_syllable_hhee" },
	{ 0x1215, "ethiopic_syllable_hhe" },
	{ 0x1216, "ethiopic_syllable_hho" },
	{ 0x1217, "ethiopic_syllable_hhwa" },
	{ 0x1218, "ethiopic_syllable_ma" },
	{ 0x1219, "ethiopic_syllable_mu" },
	{ 0x121A, "ethiopic_syllable_mi" },
	{ 0x121B, "ethiopic_syllable_maa" },
	{ 0x121C, "ethiopic_syllable_mee" },
	{ 0x121D, "ethiopic_syllable_me" },
	{ 0x121E, "ethiopic_syllable_mo" },
	{ 0x121F, "ethiopic_syllable_mwaa" },
	{ 0x1220, "ethiopic_syllable_sza" },
	{ 0x1221, "ethiopic_syllable_szu" },
	{ 0x1222, "ethiopic_syllable_szi" },
	{ 0x1223, "ethiopic_syllable_szaa" },
	{ 0x1224, "ethiopic_syllable_szee" },
	{ 0x1225, "ethiopic_syllable_sze" },
	{ 0x1226, "ethiopic_syllable_szo" },
	{ 0x1227, "ethiopic_syllable_szwa" },
	{ 0x1228, "ethiopic_syllable_ra" },
	{ 0x1229, "ethiopic_syllable_ru" },
	{ 0x122A, "ethiopic_syllable_ri" },
	{ 0x122B, "ethiopic_syllable_raa" },
	{ 0x122C, "ethiopic_syllable_ree" },
	{ 0x122D, "ethiopic_syllable_re" },
	{ 0x122E, "ethiopic_syllable_ro" },
	{ 0x122F, "ethiopic_syllable_rwa" },
	{ 0x1230, "ethiopic_syllable_sa" },
	{ 0x1231, "ethiopic_syllable_su" },
	{ 0x1232, "ethiopic_syllable_si" },
	{ 0x1233, "ethiopic_syllable_saa" },
	{ 0x1234, "ethiopic_syllable_see" },
	{ 0x1235, "ethiopic_syllable_se" },
	{ 0x1236, "ethiopic_syllable_so" },
	{ 0x1237, "ethiopic_syllable_swa" },
	{ 0x1238, "ethiopic_syllable_sha" },
	{ 0x1239, "ethiopic_syllable_shu" },
	{ 0x123A, "ethiopic_syllable_shi" },
	{ 0x123B, "ethiopic_syllable_shaa" },
	{ 0x123C, "ethiopic_syllable_shee" },
	{ 0x123D, "ethiopic_syllable_she" },
	{ 0x123E, "ethiopic_syllable_sho" },
	{ 0x123F, "ethiopic_syllable_shwa" },
	{ 0x1240, "ethiopic_syllable_qa" },
	{ 0x1241, "ethiopic_syllable_qu" },
	{ 0x1242, "ethiopic_syllable_qi" },
	{ 0x1243, "ethiopic_syllable_qaa" },
	{ 0x1244, "ethiopic_syllable_qee" },
	{ 0x1245, "ethiopic_syllable_qe" },
	{ 0x1246, "ethiopic_syllable_qo" },
	{ 0x1247, "ethiopic_syllable_qoa" },
	{ 0x1248, "ethiopic_syllable_qwa" },
	{ 0x1249, "" },
	{ 0x124A, "ethiopic_syllable_qwi" },
	{ 0x124B, "ethiopic_syllable_qwaa" },
	{ 0x124C, "ethiopic_syllable_qwee" },
	{ 0x124D, "ethiopic_syllable_qwe" },
	{ 0x124E, "" },
	{ 0x124F, "" },
	{ 0x1250, "ethiopic_syllable_qha" },
	{ 0x1251, "ethiopic_syllable_qhu" },
	{ 0x1252, "ethiopic_syllable_qhi" },
	{ 0x1253, "ethiopic_syllable_qhaa" },
	{ 0x1254, "ethiopic_syllable_qhee" },
	{ 0x1255, "ethiopic_syllable_qhe" },
	{ 0x1256, "ethiopic_syllable_qho" },
	{ 0x1257, "" },
	{ 0x1258, "ethiopic_syllable_qhwa" },
	{ 0x1259, "" },
	{ 0x125A, "ethiopic_syllable_qhwi" },
	{ 0x125B, "ethiopic_syllable_qhwaa" },
	{ 0x125C, "ethiopic_syllable_qhwee" },
	{ 0x125D, "ethiopic_syllable_qhwe" },
	{ 0x125E, "" },
	{ 0x125F, "" },
	{ 0x1260, "ethiopic_syllable_ba" },
	{ 0x1261, "ethiopic_syllable_bu" },
	{ 0x1262, "ethiopic_syllable_bi" },
	{ 0x1263, "ethiopic_syllable_baa" },
	{ 0x1264, "ethiopic_syllable_bee" },
	{ 0x1265, "ethiopic_syllable_be" },
	{ 0x1266, "ethiopic_syllable_bo" },
	{ 0x1267, "ethiopic_syllable_bwaa" },
	{ 0x1268, "ethiopic_syllable_va" },
	{ 0x1269, "ethiopic_syllable_vu" },
	{ 0x126A, "ethiopic_syllable_vi" },
	{ 0x126B, "ethiopic_syllable_vaa" },
	{ 0x126C, "ethiopic_syllable_vee" },
	{ 0x126D, "ethiopic_syllable_ve" },
	{ 0x126E, "ethiopic_syllable_vo" },
	{ 0x126F, "ethiopic_syllable_vwa" },
	{ 0x1270, "ethiopic_syllable_ta" },
	{ 0x1271, "ethiopic_syllable_tu" },
	{ 0x1272, "ethiopic_syllable_ti" },
	{ 0x1273, "ethiopic_syllable_taa" },
	{ 0x1274, "ethiopic_syllable_tee" },
	{ 0x1275, "ethiopic_syllable_te" },
	{ 0x1276, "ethiopic_syllable_to" },
	{ 0x1277, "ethiopic_syllable_twa" },
	{ 0x1278, "ethiopic_syllable_ca" },
	{ 0x1279, "ethiopic_syllable_cu" },
	{ 0x127A, "ethiopic_syllable_ci" },
	{ 0x127B, "ethiopic_syllable_caa" },
	{ 0x127C, "ethiopic_syllable_cee" },
	{ 0x127D, "ethiopic_syllable_ce" },
	{ 0x127E, "ethiopic_syllable_co" },
	{ 0x127F, "ethiopic_syllable_cwa" },
	{ 0x1280, "ethiopic_syllable_xa" },
	{ 0x1281, "ethiopic_syllable_xu" },
	{ 0x1282, "ethiopic_syllable_xi" },
	{ 0x1283, "ethiopic_syllable_xaa" },
	{ 0x1284, "ethiopic_syllable_xee" },
	{ 0x1285, "ethiopic_syllable_xe" },
	{ 0x1286, "ethiopic_syllable_xo" },
	{ 0x1287, "ethiopic_syllable_xoa" },
	{ 0x1288, "ethiopic_syllable_xwa" },
	{ 0x1289, "" },
	{ 0x128A, "ethiopic_syllable_xwi" },
	{ 0x128B, "ethiopic_syllable_xwaa" },
	{ 0x128C, "ethiopic_syllable_xwee" },
	{ 0x128D, "ethiopic_syllable_xwe" },
	{ 0x128E, "" },
	{ 0x128F, "" },
	{ 0x1290, "ethiopic_syllable_na" },
	{ 0x1291, "ethiopic_syllable_nu" },
	{ 0x1292, "ethiopic_syllable_ni" },
	{ 0x1293, "ethiopic_syllable_naa" },
	{ 0x1294, "ethiopic_syllable_nee" },
	{ 0x1295, "ethiopic_syllable_ne" },
	{ 0x1296, "ethiopic_syllable_no" },
	{ 0x1297, "ethiopic_syllable_nwa" },
	{ 0x1298, "ethiopic_syllable_nya" },
	{ 0x1299, "ethiopic_syllable_nyu" },
	{ 0x129A, "ethiopic_syllable_nyi" },
	{ 0x129B, "ethiopic_syllable_nyaa" },
	{ 0x129C, "ethiopic_syllable_nyee" },
	{ 0x129D, "ethiopic_syllable_nye" },
	{ 0x129E, "ethiopic_syllable_nyo" },
	{ 0x129F, "ethiopic_syllable_nywa" },
	{ 0x12A0, "ethiopic_syllable_glottal_a" },
	{ 0x12A1, "ethiopic_syllable_glottal_u" },
	{ 0x12A2, "ethiopic_syllable_glottal_i" },
	{ 0x12A3, "ethiopic_syllable_glottal_aa" },
	{ 0x12A4, "ethiopic_syllable_glottal_ee" },
	{ 0x12A5, "ethiopic_syllable_glottal_e" },
	{ 0x12A6, "ethiopic_syllable_glottal_o" },
	{ 0x12A7, "ethiopic_syllable_glottal_wa" },
	{ 0x12A8, "ethiopic_syllable_ka" },
	{ 0x12A9, "ethiopic_syllable_ku" },
	{ 0x12AA, "ethiopic_syllable_ki" },
	{ 0x12AB, "ethiopic_syllable_kaa" },
	{ 0x12AC, "ethiopic_syllable_kee" },
	{ 0x12AD, "ethiopic_syllable_ke" },
	{ 0x12AE, "ethiopic_syllable_ko" },
	{ 0x12AF, "ethiopic_syllable_koa" },
	{ 0x12B0, "ethiopic_syllable_kwa" },
	{ 0x12B1, "" },
	{ 0x12B2, "ethiopic_syllable_kwi" },
	{ 0x12B3, "ethiopic_syllable_kwaa" },
	{ 0x12B4, "ethiopic_syllable_kwee" },
	{ 0x12B5, "ethiopic_syllable_kwe" },
	{ 0x12B6, "" },
	{ 0x12B7, "" },
	{ 0x12B8, "ethiopic_syllable_kxa" },
	{ 0x12B9, "ethiopic_syllable_kxu" },
	{ 0x12BA, "ethiopic_syllable_kxi" },
	{ 0x12BB, "ethiopic_syllable_kxaa" },
	{ 0x12BC, "ethiopic_syllable_kxee" },
	{ 0x12BD, "ethiopic_syllable_kxe" },
	{ 0x12BE, "ethiopic_syllable_kxo" },
	{ 0x12BF, "" },
	{ 0x12C0, "ethiopic_syllable_kxwa" },
	{ 0x12C1, "" },
	{ 0x12C2, "ethiopic_syllable_kxwi" },
	{ 0x12C3, "ethiopic_syllable_kxwaa" },
	{ 0x12C4, "ethiopic_syllable_kxwee" },
	{ 0x12C5, "ethiopic_syllable_kxwe" },
	{ 0x12C6, "" },
	{ 0x12C7, "" },
	{ 0x12C8, "ethiopic_syllable_wa" },
	{ 0x12C9, "ethiopic_syllable_wu" },
	{ 0x12CA, "ethiopic_syllable_wi" },
	{ 0x12CB, "ethiopic_syllable_waa" },
	{ 0x12CC, "ethiopic_syllable_wee" },
	{ 0x12CD, "ethiopic_syllable_we" },
	{ 0x12CE, "ethiopic_syllable_wo" },
	{ 0x12CF, "ethiopic_syllable_woa" },
	{ 0x12D0, "ethiopic_syllable_pharyngeal_a" },
	{ 0x12D1, "ethiopic_syllable_pharyngeal_u" },
	{ 0x12D2, "ethiopic_syllable_pharyngeal_i" },
	{ 0x12D3, "ethiopic_syllable_pharyngeal_aa" },
	{ 0x12D4, "ethiopic_syllable_pharyngeal_ee" },
	{ 0x12D5, "ethiopic_syllable_pharyngeal_e" },
	{ 0x12D6, "ethiopic_syllable_pharyngeal_o" },
	{ 0x12D7, "" },
	{ 0x12D8, "ethiopic_syllable_za" },
	{ 0x12D9, "ethiopic_syllable_zu" },
	{ 0x12DA, "ethiopic_syllable_zi" },
	{ 0x12DB, "ethiopic_syllable_zaa" },
	{ 0x12DC, "ethiopic_syllable_zee" },
	{ 0x12DD, "ethiopic_syllable_ze" },
	{ 0x12DE, "ethiopic_syllable_zo" },
	{ 0x12DF, "ethiopic_syllable_zwa" },
	{ 0x12E0, "ethiopic_syllable_zha" },
	{ 0x12E1, "ethiopic_syllable_zhu" },
	{ 0x12E2, "ethiopic_syllable_zhi" },
	{ 0x12E3, "ethiopic_syllable_zhaa" },
	{ 0x12E4, "ethiopic_syllable_zhee" },
	{ 0x12E5, "ethiopic_syllable_zhe" },
	{ 0x12E6, "ethiopic_syllable_zho" },
	{ 0x12E7, "ethiopic_syllable_zhwa" },
	{ 0x12E8, "ethiopic_syllable_ya" },
	{ 0x12E9, "ethiopic_syllable_yu" },
	{ 0x12EA, "ethiopic_syllable_yi" },
	{ 0x12EB, "ethiopic_syllable_yaa" },
	{ 0x12EC, "ethiopic_syllable_yee" },
	{ 0x12ED, "ethiopic_syllable_ye" },
	{ 0x12EE, "ethiopic_syllable_yo" },
	{ 0x12EF, "ethiopic_syllable_yoa" },
	{ 0x12F0, "ethiopic_syllable_da" },
	{ 0x12F1, "ethiopic_syllable_du" },
	{ 0x12F2, "ethiopic_syllable_di" },
	{ 0x12F3, "ethiopic_syllable_daa" },
	{ 0x12F4, "ethiopic_syllable_dee" },
	{ 0x12F5, "ethiopic_syllable_de" },
	{ 0x12F6, "ethiopic_syllable_do" },
	{ 0x12F7, "ethiopic_syllable_dwa" },
	{ 0x12F8, "ethiopic_syllable_dda" },
	{ 0x12F9, "ethiopic_syllable_ddu" },
	{ 0x12FA, "ethiopic_syllable_ddi" },
	{ 0x12FB, "ethiopic_syllable_ddaa" },
	{ 0x12FC, "ethiopic_syllable_ddee" },
	{ 0x12FD, "ethiopic_syllable_dde" },
	{ 0x12FE, "ethiopic_syllable_ddo" },
	{ 0x12FF, "ethiopic_syllable_ddwa" },
	{ 0x1300, "ethiopic_syllable_ja" },
	{ 0x1301, "ethiopic_syllable_ju" },
	{ 0x1302, "ethiopic_syllable_ji" },
	{ 0x1303, "ethiopic_syllable_jaa" },
	{ 0x1304, "ethiopic_syllable_jee" },
	{ 0x1305, "ethiopic_syllable_je" },
	{ 0x1306, "ethiopic_syllable_jo" },
	{ 0x1307, "ethiopic_syllable_jwa" },
	{ 0x1308, "ethiopic_syllable_ga" },
	{ 0x1309, "ethiopic_syllable_gu" },
	{ 0x130A, "ethiopic_syllable_gi" },
	{ 0x130B, "ethiopic_syllable_gaa" },
	{ 0x130C, "ethiopic_syllable_gee" },
	{ 0x130D, "ethiopic_syllable_ge" },
	{ 0x130E, "ethiopic_syllable_go" },
	{ 0x130F, "ethiopic_syllable_goa" },
	{ 0x1310, "ethiopic_syllable_gwa" },
	{ 0x1311, "" },
	{ 0x1312, "ethiopic_syllable_gwi" },
	{ 0x1313, "ethiopic_syllable_gwaa" },
	{ 0x1314, "ethiopic_syllable_gwee" },
	{ 0x1315, "ethiopic_syllable_gwe" },
	{ 0x1316, "" },
	{ 0x1317, "" },
	{ 0x1318, "ethiopic_syllable_gga" },
	{ 0x1319, "ethiopic_syllable_ggu" },
	{ 0x131A, "ethiopic_syllable_ggi" },
	{ 0x131B, "ethiopic_syllable_ggaa" },
	{ 0x131C, "ethiopic_syllable_ggee" },
	{ 0x131D, "ethiopic_syllable_gge" },
	{ 0x131E, "ethiopic_syllable_ggo" },
	{ 0x131F, "ethiopic_syllable_ggwaa" },
	{ 0x1320, "ethiopic_syllable_tha" },
	{ 0x1321, "ethiopic_syllable_thu" },
	{ 0x1322, "ethiopic_syllable_thi" },
	{ 0x1323, "ethiopic_syllable_thaa" },
	{ 0x1324, "ethiopic_syllable_thee" },
	{ 0x1325, "ethiopic_syllable_the" },
	{ 0x1326, "ethiopic_syllable_tho" },
	{ 0x1327, "ethiopic_syllable_thwa" },
	{ 0x1328, "ethiopic_syllable_cha" },
	{ 0x1329, "ethiopic_syllable_chu" },
	{ 0x132A, "ethiopic_syllable_chi" },
	{ 0x132B, "ethiopic_syllable_chaa" },
	{ 0x132C, "ethiopic_syllable_chee" },
	{ 0x132D, "ethiopic_syllable_che" },
	{ 0x132E, "ethiopic_syllable_cho" },
	{ 0x132F, "ethiopic_syllable_chwa" },
	{ 0x1330, "ethiopic_syllable_pha" },
	{ 0x1331, "ethiopic_syllable_phu" },
	{ 0x1332, "ethiopic_syllable_phi" },
	{ 0x1333, "ethiopic_syllable_phaa" },
	{ 0x1334, "ethiopic_syllable_phee" },
	{ 0x1335, "ethiopic_syllable_phe" },
	{ 0x1336, "ethiopic_syllable_pho" },
	{ 0x1337, "ethiopic_syllable_phwa" },
	{ 0x1338, "ethiopic_syllable_tsa" },
	{ 0x1339, "ethiopic_syllable_tsu" },
	{ 0x133A, "ethiopic_syllable_tsi" },
	{ 0x133B, "ethiopic_syllable_tsaa" },
	{ 0x133C, "ethiopic_syllable_tsee" },
	{ 0x133D, "ethiopic_syllable_tse" },
	{ 0x133E, "ethiopic_syllable_tso" },
	{ 0x133F, "ethiopic_syllable_tswa" },
	{ 0x1340, "ethiopic_syllable_tza" },
	{ 0x1341, "ethiopic_syllable_tzu" },
	{ 0x1342, "ethiopic_syllable_tzi" },
	{ 0x1343, "ethiopic_syllable_tzaa" },
	{ 0x1344, "ethiopic_syllable_tzee" },
	{ 0x1345, "ethiopic_syllable_tze" },
	{ 0x1346, "ethiopic_syllable_tzo" },
	{ 0x1347, "ethiopic_syllable_tzoa" },
	{ 0x1348, "ethiopic_syllable_fa" },
	{ 0x1349, "ethiopic_syllable_fu" },
	{ 0x134A, "ethiopic_syllable_fi" },
	{ 0x134B, "ethiopic_syllable_faa" },
	{ 0x134C, "ethiopic_syllable_fee" },
	{ 0x134D, "ethiopic_syllable_fe" },
	{ 0x134E, "ethiopic_syllable_fo" },
	{ 0x134F, "ethiopic_syllable_fwaa" },
	{ 0x1350, "ethiopic_syllable_pa" },
	{ 0x1351, "ethiopic_syllable_pu" },
	{ 0x1352, "ethiopic_syllable_pi" },
	{ 0x1353, "ethiopic_syllable_paa" },
	{ 0x1354, "ethiopic_syllable_pee" },
	{ 0x1355, "ethiopic_syllable_pe" },
	{ 0x1356, "ethiopic_syllable_po" },
	{ 0x1357, "ethiopic_syllable_pwaa" },
	{ 0x1358, "ethiopic_syllable_mya" },
	{ 0x1359, "ethiopic_syllable_rya" },
	{ 0x135A, "ethiopic_syllable_fya" },
	{ 0x135B, "" },
	{ 0x135C, "" },
	{ 0x135D, "" }, // TODO(dmage): ETHIOPIC COMBINING GEMINATION AND VOWEL LENGTH MARK
	{ 0x135E, "" }, // TODO(dmage): ETHIOPIC COMBINING VOWEL LENGTH MARK
	{ 0x135F, "" }, // TODO(dmage): ETHIOPIC COMBINING GEMINATION MARK
	{ 0x1360, "" }, // TODO(dmage): ETHIOPIC SECTION MARK
	{ 0x1361, "ethiopic_wordspace" },
	{ 0x1362, "ethiopic_full_stop" },
	{ 0x1363, "ethiopic_comma" },
	{ 0x1364, "ethiopic_semicolon" },
	{ 0x1365, "ethiopic_colon" },
	{ 0x1366, "ethiopic_preface_colon" },
	{ 0x1367, "ethiopic_question_mark" },
	{ 0x1368, "ethiopic_paragraph_separator" },
	{ 0x1369, "ethiopic_digit_one" },
	{ 0x136A, "ethiopic_digit_two" },
	{ 0x136B, "ethiopic_digit_three" },
	{ 0x136C, "ethiopic_digit_four" },
	{ 0x136D, "ethiopic_digit_five" },
	{ 0x136E, "ethiopic_digit_six" },
	{ 0x136F, "ethiopic_digit_seven" },
	{ 0x1370, "ethiopic_digit_eight" },
	{ 0x1371, "ethiopic_digit_nine" },
	{ 0x1372, "ethiopic_number_ten" },
	{ 0x1373, "ethiopic_number_twenty" },
	{ 0x1374, "ethiopic_number_thirty" },
	{ 0x1375, "ethiopic_number_forty" },
	{ 0x1376, "ethiopic_number_fifty" },
	{ 0x1377, "ethiopic_number_sixty" },
	{ 0x1378, "ethiopic_number_seventy" },
	{ 0x1379, "ethiopic_number_eighty" },
	{ 0x137A, "ethiopic_number_ninety" },
	{ 0x137B, "ethiopic_number_hundred" },
	{ 0x137C, "ethiopic_number_ten_thousand" },
	{ 0x137D, "" },
	{ 0x137E, "" },
	{ 0x137F, "" }
};
