/* setValueIsAdjusting.java -- some checks for the setValueIsAdjusting() method
       in the JList class.
   Copyright (C) 2006 David Gilbert <david.gilbert@object-refinery.com>
This file is part of Mauve.

Mauve is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Mauve is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with Mauve; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
02110-1301 USA.

*/

// Tags: JDK1.4

package gnu.testlet.javax.swing.JList;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;

import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class setValueIsAdjusting 
  implements Testlet, PropertyChangeListener, ListSelectionListener 
{
  List events = new java.util.ArrayList();
  
  public void valueChanged(ListSelectionEvent e) 
  {
    events.add(e);
  }
  
  public void propertyChange(PropertyChangeEvent e) 
  {
    events.add(e); 
  }
  
  public void test(TestHarness harness) 
  {
    JList list = new JList();
    list.addListSelectionListener(this);
    harness.check(list.getValueIsAdjusting(), false);
    harness.check(list.getSelectionModel().getValueIsAdjusting(), false);
    list.setValueIsAdjusting(true);
    harness.check(list.getValueIsAdjusting(), true);
    harness.check(list.getSelectionModel().getValueIsAdjusting(), true);
    harness.check(events.size(), 0);
    
    list.getSelectionModel().setValueIsAdjusting(false);
    harness.check(list.getValueIsAdjusting(), false);
  }

}
