// Copyright 2009 the Sputnik authors.  All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
info: Check operator x << y in distinct points
es5id: 11.7.1_A4_T3
description: ShiftExpression = 2^n - 1, n = 0...15
---*/

//CHECK

if (0 << 0 !== 0) { 
  $ERROR('#1: 0 << 0 === 0. Actual: ' + (0 << 0)); 
} 


if (1 << 0 !== 1) { 
  $ERROR('#2: 1 << 0 === 1. Actual: ' + (1 << 0)); 
} 


if (3 << 0 !== 3) { 
  $ERROR('#3: 3 << 0 === 3. Actual: ' + (3 << 0)); 
} 


if (7 << 0 !== 7) { 
  $ERROR('#4: 7 << 0 === 7. Actual: ' + (7 << 0)); 
} 


if (15 << 0 !== 15) { 
  $ERROR('#5: 15 << 0 === 15. Actual: ' + (15 << 0)); 
} 


if (31 << 0 !== 31) { 
  $ERROR('#6: 31 << 0 === 31. Actual: ' + (31 << 0)); 
} 


if (63 << 0 !== 63) { 
  $ERROR('#7: 63 << 0 === 63. Actual: ' + (63 << 0)); 
} 


if (127 << 0 !== 127) { 
  $ERROR('#8: 127 << 0 === 127. Actual: ' + (127 << 0)); 
} 


if (255 << 0 !== 255) { 
  $ERROR('#9: 255 << 0 === 255. Actual: ' + (255 << 0)); 
} 


if (511 << 0 !== 511) { 
  $ERROR('#10: 511 << 0 === 511. Actual: ' + (511 << 0)); 
} 


if (1023 << 0 !== 1023) { 
  $ERROR('#11: 1023 << 0 === 1023. Actual: ' + (1023 << 0)); 
} 


if (2047 << 0 !== 2047) { 
  $ERROR('#12: 2047 << 0 === 2047. Actual: ' + (2047 << 0)); 
} 


if (4095 << 0 !== 4095) { 
  $ERROR('#13: 4095 << 0 === 4095. Actual: ' + (4095 << 0)); 
} 


if (8191 << 0 !== 8191) { 
  $ERROR('#14: 8191 << 0 === 8191. Actual: ' + (8191 << 0)); 
} 


if (16383 << 0 !== 16383) { 
  $ERROR('#15: 16383 << 0 === 16383. Actual: ' + (16383 << 0)); 
} 


if (32767 << 0 !== 32767) { 
  $ERROR('#16: 32767 << 0 === 32767. Actual: ' + (32767 << 0)); 
} 


if (65535 << 0 !== 65535) { 
  $ERROR('#17: 65535 << 0 === 65535. Actual: ' + (65535 << 0)); 
} 


if (131071 << 0 !== 131071) { 
  $ERROR('#18: 131071 << 0 === 131071. Actual: ' + (131071 << 0)); 
} 


if (262143 << 0 !== 262143) { 
  $ERROR('#19: 262143 << 0 === 262143. Actual: ' + (262143 << 0)); 
} 


if (524287 << 0 !== 524287) { 
  $ERROR('#20: 524287 << 0 === 524287. Actual: ' + (524287 << 0)); 
} 


if (1048575 << 0 !== 1048575) { 
  $ERROR('#21: 1048575 << 0 === 1048575. Actual: ' + (1048575 << 0)); 
} 


if (2097151 << 0 !== 2097151) { 
  $ERROR('#22: 2097151 << 0 === 2097151. Actual: ' + (2097151 << 0)); 
} 


if (4194303 << 0 !== 4194303) { 
  $ERROR('#23: 4194303 << 0 === 4194303. Actual: ' + (4194303 << 0)); 
} 


if (8388607 << 0 !== 8388607) { 
  $ERROR('#24: 8388607 << 0 === 8388607. Actual: ' + (8388607 << 0)); 
} 


if (16777215 << 0 !== 16777215) { 
  $ERROR('#25: 16777215 << 0 === 16777215. Actual: ' + (16777215 << 0)); 
} 


if (33554431 << 0 !== 33554431) { 
  $ERROR('#26: 33554431 << 0 === 33554431. Actual: ' + (33554431 << 0)); 
} 


if (67108863 << 0 !== 67108863) { 
  $ERROR('#27: 67108863 << 0 === 67108863. Actual: ' + (67108863 << 0)); 
} 


if (134217727 << 0 !== 134217727) { 
  $ERROR('#28: 134217727 << 0 === 134217727. Actual: ' + (134217727 << 0)); 
} 


if (268435455 << 0 !== 268435455) { 
  $ERROR('#29: 268435455 << 0 === 268435455. Actual: ' + (268435455 << 0)); 
} 


if (536870911 << 0 !== 536870911) { 
  $ERROR('#30: 536870911 << 0 === 536870911. Actual: ' + (536870911 << 0)); 
} 


if (1073741823 << 0 !== 1073741823) { 
  $ERROR('#31: 1073741823 << 0 === 1073741823. Actual: ' + (1073741823 << 0)); 
} 


if (2147483647 << 0 !== 2147483647) { 
  $ERROR('#32: 2147483647 << 0 === 2147483647. Actual: ' + (2147483647 << 0)); 
} 


if (0 << 1 !== 0) { 
  $ERROR('#33: 0 << 1 === 0. Actual: ' + (0 << 1)); 
} 


if (1 << 1 !== 2) { 
  $ERROR('#34: 1 << 1 === 2. Actual: ' + (1 << 1)); 
} 


if (3 << 1 !== 6) { 
  $ERROR('#35: 3 << 1 === 6. Actual: ' + (3 << 1)); 
} 


if (7 << 1 !== 14) { 
  $ERROR('#36: 7 << 1 === 14. Actual: ' + (7 << 1)); 
} 


if (15 << 1 !== 30) { 
  $ERROR('#37: 15 << 1 === 30. Actual: ' + (15 << 1)); 
} 


if (31 << 1 !== 62) { 
  $ERROR('#38: 31 << 1 === 62. Actual: ' + (31 << 1)); 
} 


if (63 << 1 !== 126) { 
  $ERROR('#39: 63 << 1 === 126. Actual: ' + (63 << 1)); 
} 


if (127 << 1 !== 254) { 
  $ERROR('#40: 127 << 1 === 254. Actual: ' + (127 << 1)); 
} 


if (255 << 1 !== 510) { 
  $ERROR('#41: 255 << 1 === 510. Actual: ' + (255 << 1)); 
} 


if (511 << 1 !== 1022) { 
  $ERROR('#42: 511 << 1 === 1022. Actual: ' + (511 << 1)); 
} 


if (1023 << 1 !== 2046) { 
  $ERROR('#43: 1023 << 1 === 2046. Actual: ' + (1023 << 1)); 
} 


if (2047 << 1 !== 4094) { 
  $ERROR('#44: 2047 << 1 === 4094. Actual: ' + (2047 << 1)); 
} 


if (4095 << 1 !== 8190) { 
  $ERROR('#45: 4095 << 1 === 8190. Actual: ' + (4095 << 1)); 
} 


if (8191 << 1 !== 16382) { 
  $ERROR('#46: 8191 << 1 === 16382. Actual: ' + (8191 << 1)); 
} 


if (16383 << 1 !== 32766) { 
  $ERROR('#47: 16383 << 1 === 32766. Actual: ' + (16383 << 1)); 
} 


if (32767 << 1 !== 65534) { 
  $ERROR('#48: 32767 << 1 === 65534. Actual: ' + (32767 << 1)); 
} 


if (65535 << 1 !== 131070) { 
  $ERROR('#49: 65535 << 1 === 131070. Actual: ' + (65535 << 1)); 
} 


if (131071 << 1 !== 262142) { 
  $ERROR('#50: 131071 << 1 === 262142. Actual: ' + (131071 << 1)); 
} 


if (262143 << 1 !== 524286) { 
  $ERROR('#51: 262143 << 1 === 524286. Actual: ' + (262143 << 1)); 
} 


if (524287 << 1 !== 1048574) { 
  $ERROR('#52: 524287 << 1 === 1048574. Actual: ' + (524287 << 1)); 
} 


if (1048575 << 1 !== 2097150) { 
  $ERROR('#53: 1048575 << 1 === 2097150. Actual: ' + (1048575 << 1)); 
} 


if (2097151 << 1 !== 4194302) { 
  $ERROR('#54: 2097151 << 1 === 4194302. Actual: ' + (2097151 << 1)); 
} 


if (4194303 << 1 !== 8388606) { 
  $ERROR('#55: 4194303 << 1 === 8388606. Actual: ' + (4194303 << 1)); 
} 


if (8388607 << 1 !== 16777214) { 
  $ERROR('#56: 8388607 << 1 === 16777214. Actual: ' + (8388607 << 1)); 
} 


if (16777215 << 1 !== 33554430) { 
  $ERROR('#57: 16777215 << 1 === 33554430. Actual: ' + (16777215 << 1)); 
} 


if (33554431 << 1 !== 67108862) { 
  $ERROR('#58: 33554431 << 1 === 67108862. Actual: ' + (33554431 << 1)); 
} 


if (67108863 << 1 !== 134217726) { 
  $ERROR('#59: 67108863 << 1 === 134217726. Actual: ' + (67108863 << 1)); 
} 


if (134217727 << 1 !== 268435454) { 
  $ERROR('#60: 134217727 << 1 === 268435454. Actual: ' + (134217727 << 1)); 
} 


if (268435455 << 1 !== 536870910) { 
  $ERROR('#61: 268435455 << 1 === 536870910. Actual: ' + (268435455 << 1)); 
} 


if (536870911 << 1 !== 1073741822) { 
  $ERROR('#62: 536870911 << 1 === 1073741822. Actual: ' + (536870911 << 1)); 
} 


if (1073741823 << 1 !== 2147483646) { 
  $ERROR('#63: 1073741823 << 1 === 2147483646. Actual: ' + (1073741823 << 1)); 
} 


if (2147483647 << 1 !== -2) { 
  $ERROR('#64: 2147483647 << 1 === -2. Actual: ' + (2147483647 << 1)); 
} 


if (0 << 2 !== 0) { 
  $ERROR('#65: 0 << 2 === 0. Actual: ' + (0 << 2)); 
} 


if (1 << 2 !== 4) { 
  $ERROR('#66: 1 << 2 === 4. Actual: ' + (1 << 2)); 
} 


if (3 << 2 !== 12) { 
  $ERROR('#67: 3 << 2 === 12. Actual: ' + (3 << 2)); 
} 


if (7 << 2 !== 28) { 
  $ERROR('#68: 7 << 2 === 28. Actual: ' + (7 << 2)); 
} 


if (15 << 2 !== 60) { 
  $ERROR('#69: 15 << 2 === 60. Actual: ' + (15 << 2)); 
} 


if (31 << 2 !== 124) { 
  $ERROR('#70: 31 << 2 === 124. Actual: ' + (31 << 2)); 
} 


if (63 << 2 !== 252) { 
  $ERROR('#71: 63 << 2 === 252. Actual: ' + (63 << 2)); 
} 


if (127 << 2 !== 508) { 
  $ERROR('#72: 127 << 2 === 508. Actual: ' + (127 << 2)); 
} 


if (255 << 2 !== 1020) { 
  $ERROR('#73: 255 << 2 === 1020. Actual: ' + (255 << 2)); 
} 


if (511 << 2 !== 2044) { 
  $ERROR('#74: 511 << 2 === 2044. Actual: ' + (511 << 2)); 
} 


if (1023 << 2 !== 4092) { 
  $ERROR('#75: 1023 << 2 === 4092. Actual: ' + (1023 << 2)); 
} 


if (2047 << 2 !== 8188) { 
  $ERROR('#76: 2047 << 2 === 8188. Actual: ' + (2047 << 2)); 
} 


if (4095 << 2 !== 16380) { 
  $ERROR('#77: 4095 << 2 === 16380. Actual: ' + (4095 << 2)); 
} 


if (8191 << 2 !== 32764) { 
  $ERROR('#78: 8191 << 2 === 32764. Actual: ' + (8191 << 2)); 
} 


if (16383 << 2 !== 65532) { 
  $ERROR('#79: 16383 << 2 === 65532. Actual: ' + (16383 << 2)); 
} 


if (32767 << 2 !== 131068) { 
  $ERROR('#80: 32767 << 2 === 131068. Actual: ' + (32767 << 2)); 
} 


if (65535 << 2 !== 262140) { 
  $ERROR('#81: 65535 << 2 === 262140. Actual: ' + (65535 << 2)); 
} 


if (131071 << 2 !== 524284) { 
  $ERROR('#82: 131071 << 2 === 524284. Actual: ' + (131071 << 2)); 
} 


if (262143 << 2 !== 1048572) { 
  $ERROR('#83: 262143 << 2 === 1048572. Actual: ' + (262143 << 2)); 
} 


if (524287 << 2 !== 2097148) { 
  $ERROR('#84: 524287 << 2 === 2097148. Actual: ' + (524287 << 2)); 
} 


if (1048575 << 2 !== 4194300) { 
  $ERROR('#85: 1048575 << 2 === 4194300. Actual: ' + (1048575 << 2)); 
} 


if (2097151 << 2 !== 8388604) { 
  $ERROR('#86: 2097151 << 2 === 8388604. Actual: ' + (2097151 << 2)); 
} 


if (4194303 << 2 !== 16777212) { 
  $ERROR('#87: 4194303 << 2 === 16777212. Actual: ' + (4194303 << 2)); 
} 


if (8388607 << 2 !== 33554428) { 
  $ERROR('#88: 8388607 << 2 === 33554428. Actual: ' + (8388607 << 2)); 
} 


if (16777215 << 2 !== 67108860) { 
  $ERROR('#89: 16777215 << 2 === 67108860. Actual: ' + (16777215 << 2)); 
} 


if (33554431 << 2 !== 134217724) { 
  $ERROR('#90: 33554431 << 2 === 134217724. Actual: ' + (33554431 << 2)); 
} 


if (67108863 << 2 !== 268435452) { 
  $ERROR('#91: 67108863 << 2 === 268435452. Actual: ' + (67108863 << 2)); 
} 


if (134217727 << 2 !== 536870908) { 
  $ERROR('#92: 134217727 << 2 === 536870908. Actual: ' + (134217727 << 2)); 
} 


if (268435455 << 2 !== 1073741820) { 
  $ERROR('#93: 268435455 << 2 === 1073741820. Actual: ' + (268435455 << 2)); 
} 


if (536870911 << 2 !== 2147483644) { 
  $ERROR('#94: 536870911 << 2 === 2147483644. Actual: ' + (536870911 << 2)); 
} 


if (1073741823 << 2 !== -4) { 
  $ERROR('#95: 1073741823 << 2 === -4. Actual: ' + (1073741823 << 2)); 
} 


if (2147483647 << 2 !== -4) { 
  $ERROR('#96: 2147483647 << 2 === -4. Actual: ' + (2147483647 << 2)); 
} 


if (0 << 3 !== 0) { 
  $ERROR('#97: 0 << 3 === 0. Actual: ' + (0 << 3)); 
} 


if (1 << 3 !== 8) { 
  $ERROR('#98: 1 << 3 === 8. Actual: ' + (1 << 3)); 
} 


if (3 << 3 !== 24) { 
  $ERROR('#99: 3 << 3 === 24. Actual: ' + (3 << 3)); 
} 


if (7 << 3 !== 56) { 
  $ERROR('#100: 7 << 3 === 56. Actual: ' + (7 << 3)); 
} 


if (15 << 3 !== 120) { 
  $ERROR('#101: 15 << 3 === 120. Actual: ' + (15 << 3)); 
} 


if (31 << 3 !== 248) { 
  $ERROR('#102: 31 << 3 === 248. Actual: ' + (31 << 3)); 
} 


if (63 << 3 !== 504) { 
  $ERROR('#103: 63 << 3 === 504. Actual: ' + (63 << 3)); 
} 


if (127 << 3 !== 1016) { 
  $ERROR('#104: 127 << 3 === 1016. Actual: ' + (127 << 3)); 
} 


if (255 << 3 !== 2040) { 
  $ERROR('#105: 255 << 3 === 2040. Actual: ' + (255 << 3)); 
} 


if (511 << 3 !== 4088) { 
  $ERROR('#106: 511 << 3 === 4088. Actual: ' + (511 << 3)); 
} 


if (1023 << 3 !== 8184) { 
  $ERROR('#107: 1023 << 3 === 8184. Actual: ' + (1023 << 3)); 
} 


if (2047 << 3 !== 16376) { 
  $ERROR('#108: 2047 << 3 === 16376. Actual: ' + (2047 << 3)); 
} 


if (4095 << 3 !== 32760) { 
  $ERROR('#109: 4095 << 3 === 32760. Actual: ' + (4095 << 3)); 
} 


if (8191 << 3 !== 65528) { 
  $ERROR('#110: 8191 << 3 === 65528. Actual: ' + (8191 << 3)); 
} 


if (16383 << 3 !== 131064) { 
  $ERROR('#111: 16383 << 3 === 131064. Actual: ' + (16383 << 3)); 
} 


if (32767 << 3 !== 262136) { 
  $ERROR('#112: 32767 << 3 === 262136. Actual: ' + (32767 << 3)); 
} 


if (65535 << 3 !== 524280) { 
  $ERROR('#113: 65535 << 3 === 524280. Actual: ' + (65535 << 3)); 
} 


if (131071 << 3 !== 1048568) { 
  $ERROR('#114: 131071 << 3 === 1048568. Actual: ' + (131071 << 3)); 
} 


if (262143 << 3 !== 2097144) { 
  $ERROR('#115: 262143 << 3 === 2097144. Actual: ' + (262143 << 3)); 
} 


if (524287 << 3 !== 4194296) { 
  $ERROR('#116: 524287 << 3 === 4194296. Actual: ' + (524287 << 3)); 
} 


if (1048575 << 3 !== 8388600) { 
  $ERROR('#117: 1048575 << 3 === 8388600. Actual: ' + (1048575 << 3)); 
} 


if (2097151 << 3 !== 16777208) { 
  $ERROR('#118: 2097151 << 3 === 16777208. Actual: ' + (2097151 << 3)); 
} 


if (4194303 << 3 !== 33554424) { 
  $ERROR('#119: 4194303 << 3 === 33554424. Actual: ' + (4194303 << 3)); 
} 


if (8388607 << 3 !== 67108856) { 
  $ERROR('#120: 8388607 << 3 === 67108856. Actual: ' + (8388607 << 3)); 
} 


if (16777215 << 3 !== 134217720) { 
  $ERROR('#121: 16777215 << 3 === 134217720. Actual: ' + (16777215 << 3)); 
} 


if (33554431 << 3 !== 268435448) { 
  $ERROR('#122: 33554431 << 3 === 268435448. Actual: ' + (33554431 << 3)); 
} 


if (67108863 << 3 !== 536870904) { 
  $ERROR('#123: 67108863 << 3 === 536870904. Actual: ' + (67108863 << 3)); 
} 


if (134217727 << 3 !== 1073741816) { 
  $ERROR('#124: 134217727 << 3 === 1073741816. Actual: ' + (134217727 << 3)); 
} 


if (268435455 << 3 !== 2147483640) { 
  $ERROR('#125: 268435455 << 3 === 2147483640. Actual: ' + (268435455 << 3)); 
} 


if (536870911 << 3 !== -8) { 
  $ERROR('#126: 536870911 << 3 === -8. Actual: ' + (536870911 << 3)); 
} 


if (1073741823 << 3 !== -8) { 
  $ERROR('#127: 1073741823 << 3 === -8. Actual: ' + (1073741823 << 3)); 
} 


if (2147483647 << 3 !== -8) { 
  $ERROR('#128: 2147483647 << 3 === -8. Actual: ' + (2147483647 << 3)); 
} 


if (0 << 4 !== 0) { 
  $ERROR('#129: 0 << 4 === 0. Actual: ' + (0 << 4)); 
} 


if (1 << 4 !== 16) { 
  $ERROR('#130: 1 << 4 === 16. Actual: ' + (1 << 4)); 
} 


if (3 << 4 !== 48) { 
  $ERROR('#131: 3 << 4 === 48. Actual: ' + (3 << 4)); 
} 


if (7 << 4 !== 112) { 
  $ERROR('#132: 7 << 4 === 112. Actual: ' + (7 << 4)); 
} 


if (15 << 4 !== 240) { 
  $ERROR('#133: 15 << 4 === 240. Actual: ' + (15 << 4)); 
} 


if (31 << 4 !== 496) { 
  $ERROR('#134: 31 << 4 === 496. Actual: ' + (31 << 4)); 
} 


if (63 << 4 !== 1008) { 
  $ERROR('#135: 63 << 4 === 1008. Actual: ' + (63 << 4)); 
} 


if (127 << 4 !== 2032) { 
  $ERROR('#136: 127 << 4 === 2032. Actual: ' + (127 << 4)); 
} 


if (255 << 4 !== 4080) { 
  $ERROR('#137: 255 << 4 === 4080. Actual: ' + (255 << 4)); 
} 


if (511 << 4 !== 8176) { 
  $ERROR('#138: 511 << 4 === 8176. Actual: ' + (511 << 4)); 
} 


if (1023 << 4 !== 16368) { 
  $ERROR('#139: 1023 << 4 === 16368. Actual: ' + (1023 << 4)); 
} 


if (2047 << 4 !== 32752) { 
  $ERROR('#140: 2047 << 4 === 32752. Actual: ' + (2047 << 4)); 
} 


if (4095 << 4 !== 65520) { 
  $ERROR('#141: 4095 << 4 === 65520. Actual: ' + (4095 << 4)); 
} 


if (8191 << 4 !== 131056) { 
  $ERROR('#142: 8191 << 4 === 131056. Actual: ' + (8191 << 4)); 
} 


if (16383 << 4 !== 262128) { 
  $ERROR('#143: 16383 << 4 === 262128. Actual: ' + (16383 << 4)); 
} 


if (32767 << 4 !== 524272) { 
  $ERROR('#144: 32767 << 4 === 524272. Actual: ' + (32767 << 4)); 
} 


if (65535 << 4 !== 1048560) { 
  $ERROR('#145: 65535 << 4 === 1048560. Actual: ' + (65535 << 4)); 
} 


if (131071 << 4 !== 2097136) { 
  $ERROR('#146: 131071 << 4 === 2097136. Actual: ' + (131071 << 4)); 
} 


if (262143 << 4 !== 4194288) { 
  $ERROR('#147: 262143 << 4 === 4194288. Actual: ' + (262143 << 4)); 
} 


if (524287 << 4 !== 8388592) { 
  $ERROR('#148: 524287 << 4 === 8388592. Actual: ' + (524287 << 4)); 
} 


if (1048575 << 4 !== 16777200) { 
  $ERROR('#149: 1048575 << 4 === 16777200. Actual: ' + (1048575 << 4)); 
} 


if (2097151 << 4 !== 33554416) { 
  $ERROR('#150: 2097151 << 4 === 33554416. Actual: ' + (2097151 << 4)); 
} 


if (4194303 << 4 !== 67108848) { 
  $ERROR('#151: 4194303 << 4 === 67108848. Actual: ' + (4194303 << 4)); 
} 


if (8388607 << 4 !== 134217712) { 
  $ERROR('#152: 8388607 << 4 === 134217712. Actual: ' + (8388607 << 4)); 
} 


if (16777215 << 4 !== 268435440) { 
  $ERROR('#153: 16777215 << 4 === 268435440. Actual: ' + (16777215 << 4)); 
} 


if (33554431 << 4 !== 536870896) { 
  $ERROR('#154: 33554431 << 4 === 536870896. Actual: ' + (33554431 << 4)); 
} 


if (67108863 << 4 !== 1073741808) { 
  $ERROR('#155: 67108863 << 4 === 1073741808. Actual: ' + (67108863 << 4)); 
} 


if (134217727 << 4 !== 2147483632) { 
  $ERROR('#156: 134217727 << 4 === 2147483632. Actual: ' + (134217727 << 4)); 
} 


if (268435455 << 4 !== -16) { 
  $ERROR('#157: 268435455 << 4 === -16. Actual: ' + (268435455 << 4)); 
} 


if (536870911 << 4 !== -16) { 
  $ERROR('#158: 536870911 << 4 === -16. Actual: ' + (536870911 << 4)); 
} 


if (1073741823 << 4 !== -16) { 
  $ERROR('#159: 1073741823 << 4 === -16. Actual: ' + (1073741823 << 4)); 
} 


if (2147483647 << 4 !== -16) { 
  $ERROR('#160: 2147483647 << 4 === -16. Actual: ' + (2147483647 << 4)); 
} 


if (0 << 5 !== 0) { 
  $ERROR('#161: 0 << 5 === 0. Actual: ' + (0 << 5)); 
} 


if (1 << 5 !== 32) { 
  $ERROR('#162: 1 << 5 === 32. Actual: ' + (1 << 5)); 
} 


if (3 << 5 !== 96) { 
  $ERROR('#163: 3 << 5 === 96. Actual: ' + (3 << 5)); 
} 


if (7 << 5 !== 224) { 
  $ERROR('#164: 7 << 5 === 224. Actual: ' + (7 << 5)); 
} 


if (15 << 5 !== 480) { 
  $ERROR('#165: 15 << 5 === 480. Actual: ' + (15 << 5)); 
} 


if (31 << 5 !== 992) { 
  $ERROR('#166: 31 << 5 === 992. Actual: ' + (31 << 5)); 
} 


if (63 << 5 !== 2016) { 
  $ERROR('#167: 63 << 5 === 2016. Actual: ' + (63 << 5)); 
} 


if (127 << 5 !== 4064) { 
  $ERROR('#168: 127 << 5 === 4064. Actual: ' + (127 << 5)); 
} 


if (255 << 5 !== 8160) { 
  $ERROR('#169: 255 << 5 === 8160. Actual: ' + (255 << 5)); 
} 


if (511 << 5 !== 16352) { 
  $ERROR('#170: 511 << 5 === 16352. Actual: ' + (511 << 5)); 
} 


if (1023 << 5 !== 32736) { 
  $ERROR('#171: 1023 << 5 === 32736. Actual: ' + (1023 << 5)); 
} 


if (2047 << 5 !== 65504) { 
  $ERROR('#172: 2047 << 5 === 65504. Actual: ' + (2047 << 5)); 
} 


if (4095 << 5 !== 131040) { 
  $ERROR('#173: 4095 << 5 === 131040. Actual: ' + (4095 << 5)); 
} 


if (8191 << 5 !== 262112) { 
  $ERROR('#174: 8191 << 5 === 262112. Actual: ' + (8191 << 5)); 
} 


if (16383 << 5 !== 524256) { 
  $ERROR('#175: 16383 << 5 === 524256. Actual: ' + (16383 << 5)); 
} 


if (32767 << 5 !== 1048544) { 
  $ERROR('#176: 32767 << 5 === 1048544. Actual: ' + (32767 << 5)); 
} 


if (65535 << 5 !== 2097120) { 
  $ERROR('#177: 65535 << 5 === 2097120. Actual: ' + (65535 << 5)); 
} 


if (131071 << 5 !== 4194272) { 
  $ERROR('#178: 131071 << 5 === 4194272. Actual: ' + (131071 << 5)); 
} 


if (262143 << 5 !== 8388576) { 
  $ERROR('#179: 262143 << 5 === 8388576. Actual: ' + (262143 << 5)); 
} 


if (524287 << 5 !== 16777184) { 
  $ERROR('#180: 524287 << 5 === 16777184. Actual: ' + (524287 << 5)); 
} 


if (1048575 << 5 !== 33554400) { 
  $ERROR('#181: 1048575 << 5 === 33554400. Actual: ' + (1048575 << 5)); 
} 


if (2097151 << 5 !== 67108832) { 
  $ERROR('#182: 2097151 << 5 === 67108832. Actual: ' + (2097151 << 5)); 
} 


if (4194303 << 5 !== 134217696) { 
  $ERROR('#183: 4194303 << 5 === 134217696. Actual: ' + (4194303 << 5)); 
} 


if (8388607 << 5 !== 268435424) { 
  $ERROR('#184: 8388607 << 5 === 268435424. Actual: ' + (8388607 << 5)); 
} 


if (16777215 << 5 !== 536870880) { 
  $ERROR('#185: 16777215 << 5 === 536870880. Actual: ' + (16777215 << 5)); 
} 


if (33554431 << 5 !== 1073741792) { 
  $ERROR('#186: 33554431 << 5 === 1073741792. Actual: ' + (33554431 << 5)); 
} 


if (67108863 << 5 !== 2147483616) { 
  $ERROR('#187: 67108863 << 5 === 2147483616. Actual: ' + (67108863 << 5)); 
} 


if (134217727 << 5 !== -32) { 
  $ERROR('#188: 134217727 << 5 === -32. Actual: ' + (134217727 << 5)); 
} 


if (268435455 << 5 !== -32) { 
  $ERROR('#189: 268435455 << 5 === -32. Actual: ' + (268435455 << 5)); 
} 


if (536870911 << 5 !== -32) { 
  $ERROR('#190: 536870911 << 5 === -32. Actual: ' + (536870911 << 5)); 
} 


if (1073741823 << 5 !== -32) { 
  $ERROR('#191: 1073741823 << 5 === -32. Actual: ' + (1073741823 << 5)); 
} 


if (2147483647 << 5 !== -32) { 
  $ERROR('#192: 2147483647 << 5 === -32. Actual: ' + (2147483647 << 5)); 
} 


if (0 << 6 !== 0) { 
  $ERROR('#193: 0 << 6 === 0. Actual: ' + (0 << 6)); 
} 


if (1 << 6 !== 64) { 
  $ERROR('#194: 1 << 6 === 64. Actual: ' + (1 << 6)); 
} 


if (3 << 6 !== 192) { 
  $ERROR('#195: 3 << 6 === 192. Actual: ' + (3 << 6)); 
} 


if (7 << 6 !== 448) { 
  $ERROR('#196: 7 << 6 === 448. Actual: ' + (7 << 6)); 
} 


if (15 << 6 !== 960) { 
  $ERROR('#197: 15 << 6 === 960. Actual: ' + (15 << 6)); 
} 


if (31 << 6 !== 1984) { 
  $ERROR('#198: 31 << 6 === 1984. Actual: ' + (31 << 6)); 
} 


if (63 << 6 !== 4032) { 
  $ERROR('#199: 63 << 6 === 4032. Actual: ' + (63 << 6)); 
} 


if (127 << 6 !== 8128) { 
  $ERROR('#200: 127 << 6 === 8128. Actual: ' + (127 << 6)); 
} 


if (255 << 6 !== 16320) { 
  $ERROR('#201: 255 << 6 === 16320. Actual: ' + (255 << 6)); 
} 


if (511 << 6 !== 32704) { 
  $ERROR('#202: 511 << 6 === 32704. Actual: ' + (511 << 6)); 
} 


if (1023 << 6 !== 65472) { 
  $ERROR('#203: 1023 << 6 === 65472. Actual: ' + (1023 << 6)); 
} 


if (2047 << 6 !== 131008) { 
  $ERROR('#204: 2047 << 6 === 131008. Actual: ' + (2047 << 6)); 
} 


if (4095 << 6 !== 262080) { 
  $ERROR('#205: 4095 << 6 === 262080. Actual: ' + (4095 << 6)); 
} 


if (8191 << 6 !== 524224) { 
  $ERROR('#206: 8191 << 6 === 524224. Actual: ' + (8191 << 6)); 
} 


if (16383 << 6 !== 1048512) { 
  $ERROR('#207: 16383 << 6 === 1048512. Actual: ' + (16383 << 6)); 
} 


if (32767 << 6 !== 2097088) { 
  $ERROR('#208: 32767 << 6 === 2097088. Actual: ' + (32767 << 6)); 
} 


if (65535 << 6 !== 4194240) { 
  $ERROR('#209: 65535 << 6 === 4194240. Actual: ' + (65535 << 6)); 
} 


if (131071 << 6 !== 8388544) { 
  $ERROR('#210: 131071 << 6 === 8388544. Actual: ' + (131071 << 6)); 
} 


if (262143 << 6 !== 16777152) { 
  $ERROR('#211: 262143 << 6 === 16777152. Actual: ' + (262143 << 6)); 
} 


if (524287 << 6 !== 33554368) { 
  $ERROR('#212: 524287 << 6 === 33554368. Actual: ' + (524287 << 6)); 
} 


if (1048575 << 6 !== 67108800) { 
  $ERROR('#213: 1048575 << 6 === 67108800. Actual: ' + (1048575 << 6)); 
} 


if (2097151 << 6 !== 134217664) { 
  $ERROR('#214: 2097151 << 6 === 134217664. Actual: ' + (2097151 << 6)); 
} 


if (4194303 << 6 !== 268435392) { 
  $ERROR('#215: 4194303 << 6 === 268435392. Actual: ' + (4194303 << 6)); 
} 


if (8388607 << 6 !== 536870848) { 
  $ERROR('#216: 8388607 << 6 === 536870848. Actual: ' + (8388607 << 6)); 
} 


if (16777215 << 6 !== 1073741760) { 
  $ERROR('#217: 16777215 << 6 === 1073741760. Actual: ' + (16777215 << 6)); 
} 


if (33554431 << 6 !== 2147483584) { 
  $ERROR('#218: 33554431 << 6 === 2147483584. Actual: ' + (33554431 << 6)); 
} 


if (67108863 << 6 !== -64) { 
  $ERROR('#219: 67108863 << 6 === -64. Actual: ' + (67108863 << 6)); 
} 


if (134217727 << 6 !== -64) { 
  $ERROR('#220: 134217727 << 6 === -64. Actual: ' + (134217727 << 6)); 
} 


if (268435455 << 6 !== -64) { 
  $ERROR('#221: 268435455 << 6 === -64. Actual: ' + (268435455 << 6)); 
} 


if (536870911 << 6 !== -64) { 
  $ERROR('#222: 536870911 << 6 === -64. Actual: ' + (536870911 << 6)); 
} 


if (1073741823 << 6 !== -64) { 
  $ERROR('#223: 1073741823 << 6 === -64. Actual: ' + (1073741823 << 6)); 
} 


if (2147483647 << 6 !== -64) { 
  $ERROR('#224: 2147483647 << 6 === -64. Actual: ' + (2147483647 << 6)); 
} 


if (0 << 7 !== 0) { 
  $ERROR('#225: 0 << 7 === 0. Actual: ' + (0 << 7)); 
} 


if (1 << 7 !== 128) { 
  $ERROR('#226: 1 << 7 === 128. Actual: ' + (1 << 7)); 
} 


if (3 << 7 !== 384) { 
  $ERROR('#227: 3 << 7 === 384. Actual: ' + (3 << 7)); 
} 


if (7 << 7 !== 896) { 
  $ERROR('#228: 7 << 7 === 896. Actual: ' + (7 << 7)); 
} 


if (15 << 7 !== 1920) { 
  $ERROR('#229: 15 << 7 === 1920. Actual: ' + (15 << 7)); 
} 


if (31 << 7 !== 3968) { 
  $ERROR('#230: 31 << 7 === 3968. Actual: ' + (31 << 7)); 
} 


if (63 << 7 !== 8064) { 
  $ERROR('#231: 63 << 7 === 8064. Actual: ' + (63 << 7)); 
} 


if (127 << 7 !== 16256) { 
  $ERROR('#232: 127 << 7 === 16256. Actual: ' + (127 << 7)); 
} 


if (255 << 7 !== 32640) { 
  $ERROR('#233: 255 << 7 === 32640. Actual: ' + (255 << 7)); 
} 


if (511 << 7 !== 65408) { 
  $ERROR('#234: 511 << 7 === 65408. Actual: ' + (511 << 7)); 
} 


if (1023 << 7 !== 130944) { 
  $ERROR('#235: 1023 << 7 === 130944. Actual: ' + (1023 << 7)); 
} 


if (2047 << 7 !== 262016) { 
  $ERROR('#236: 2047 << 7 === 262016. Actual: ' + (2047 << 7)); 
} 


if (4095 << 7 !== 524160) { 
  $ERROR('#237: 4095 << 7 === 524160. Actual: ' + (4095 << 7)); 
} 


if (8191 << 7 !== 1048448) { 
  $ERROR('#238: 8191 << 7 === 1048448. Actual: ' + (8191 << 7)); 
} 


if (16383 << 7 !== 2097024) { 
  $ERROR('#239: 16383 << 7 === 2097024. Actual: ' + (16383 << 7)); 
} 


if (32767 << 7 !== 4194176) { 
  $ERROR('#240: 32767 << 7 === 4194176. Actual: ' + (32767 << 7)); 
} 


if (65535 << 7 !== 8388480) { 
  $ERROR('#241: 65535 << 7 === 8388480. Actual: ' + (65535 << 7)); 
} 


if (131071 << 7 !== 16777088) { 
  $ERROR('#242: 131071 << 7 === 16777088. Actual: ' + (131071 << 7)); 
} 


if (262143 << 7 !== 33554304) { 
  $ERROR('#243: 262143 << 7 === 33554304. Actual: ' + (262143 << 7)); 
} 


if (524287 << 7 !== 67108736) { 
  $ERROR('#244: 524287 << 7 === 67108736. Actual: ' + (524287 << 7)); 
} 


if (1048575 << 7 !== 134217600) { 
  $ERROR('#245: 1048575 << 7 === 134217600. Actual: ' + (1048575 << 7)); 
} 


if (2097151 << 7 !== 268435328) { 
  $ERROR('#246: 2097151 << 7 === 268435328. Actual: ' + (2097151 << 7)); 
} 


if (4194303 << 7 !== 536870784) { 
  $ERROR('#247: 4194303 << 7 === 536870784. Actual: ' + (4194303 << 7)); 
} 


if (8388607 << 7 !== 1073741696) { 
  $ERROR('#248: 8388607 << 7 === 1073741696. Actual: ' + (8388607 << 7)); 
} 


if (16777215 << 7 !== 2147483520) { 
  $ERROR('#249: 16777215 << 7 === 2147483520. Actual: ' + (16777215 << 7)); 
} 


if (33554431 << 7 !== -128) { 
  $ERROR('#250: 33554431 << 7 === -128. Actual: ' + (33554431 << 7)); 
} 


if (67108863 << 7 !== -128) { 
  $ERROR('#251: 67108863 << 7 === -128. Actual: ' + (67108863 << 7)); 
} 


if (134217727 << 7 !== -128) { 
  $ERROR('#252: 134217727 << 7 === -128. Actual: ' + (134217727 << 7)); 
} 


if (268435455 << 7 !== -128) { 
  $ERROR('#253: 268435455 << 7 === -128. Actual: ' + (268435455 << 7)); 
} 


if (536870911 << 7 !== -128) { 
  $ERROR('#254: 536870911 << 7 === -128. Actual: ' + (536870911 << 7)); 
} 


if (1073741823 << 7 !== -128) { 
  $ERROR('#255: 1073741823 << 7 === -128. Actual: ' + (1073741823 << 7)); 
} 


if (2147483647 << 7 !== -128) { 
  $ERROR('#256: 2147483647 << 7 === -128. Actual: ' + (2147483647 << 7)); 
} 


if (0 << 8 !== 0) { 
  $ERROR('#257: 0 << 8 === 0. Actual: ' + (0 << 8)); 
} 


if (1 << 8 !== 256) { 
  $ERROR('#258: 1 << 8 === 256. Actual: ' + (1 << 8)); 
} 


if (3 << 8 !== 768) { 
  $ERROR('#259: 3 << 8 === 768. Actual: ' + (3 << 8)); 
} 


if (7 << 8 !== 1792) { 
  $ERROR('#260: 7 << 8 === 1792. Actual: ' + (7 << 8)); 
} 


if (15 << 8 !== 3840) { 
  $ERROR('#261: 15 << 8 === 3840. Actual: ' + (15 << 8)); 
} 


if (31 << 8 !== 7936) { 
  $ERROR('#262: 31 << 8 === 7936. Actual: ' + (31 << 8)); 
} 


if (63 << 8 !== 16128) { 
  $ERROR('#263: 63 << 8 === 16128. Actual: ' + (63 << 8)); 
} 


if (127 << 8 !== 32512) { 
  $ERROR('#264: 127 << 8 === 32512. Actual: ' + (127 << 8)); 
} 


if (255 << 8 !== 65280) { 
  $ERROR('#265: 255 << 8 === 65280. Actual: ' + (255 << 8)); 
} 


if (511 << 8 !== 130816) { 
  $ERROR('#266: 511 << 8 === 130816. Actual: ' + (511 << 8)); 
} 


if (1023 << 8 !== 261888) { 
  $ERROR('#267: 1023 << 8 === 261888. Actual: ' + (1023 << 8)); 
} 


if (2047 << 8 !== 524032) { 
  $ERROR('#268: 2047 << 8 === 524032. Actual: ' + (2047 << 8)); 
} 


if (4095 << 8 !== 1048320) { 
  $ERROR('#269: 4095 << 8 === 1048320. Actual: ' + (4095 << 8)); 
} 


if (8191 << 8 !== 2096896) { 
  $ERROR('#270: 8191 << 8 === 2096896. Actual: ' + (8191 << 8)); 
} 


if (16383 << 8 !== 4194048) { 
  $ERROR('#271: 16383 << 8 === 4194048. Actual: ' + (16383 << 8)); 
} 


if (32767 << 8 !== 8388352) { 
  $ERROR('#272: 32767 << 8 === 8388352. Actual: ' + (32767 << 8)); 
} 


if (65535 << 8 !== 16776960) { 
  $ERROR('#273: 65535 << 8 === 16776960. Actual: ' + (65535 << 8)); 
} 


if (131071 << 8 !== 33554176) { 
  $ERROR('#274: 131071 << 8 === 33554176. Actual: ' + (131071 << 8)); 
} 


if (262143 << 8 !== 67108608) { 
  $ERROR('#275: 262143 << 8 === 67108608. Actual: ' + (262143 << 8)); 
} 


if (524287 << 8 !== 134217472) { 
  $ERROR('#276: 524287 << 8 === 134217472. Actual: ' + (524287 << 8)); 
} 


if (1048575 << 8 !== 268435200) { 
  $ERROR('#277: 1048575 << 8 === 268435200. Actual: ' + (1048575 << 8)); 
} 


if (2097151 << 8 !== 536870656) { 
  $ERROR('#278: 2097151 << 8 === 536870656. Actual: ' + (2097151 << 8)); 
} 


if (4194303 << 8 !== 1073741568) { 
  $ERROR('#279: 4194303 << 8 === 1073741568. Actual: ' + (4194303 << 8)); 
} 


if (8388607 << 8 !== 2147483392) { 
  $ERROR('#280: 8388607 << 8 === 2147483392. Actual: ' + (8388607 << 8)); 
} 


if (16777215 << 8 !== -256) { 
  $ERROR('#281: 16777215 << 8 === -256. Actual: ' + (16777215 << 8)); 
} 


if (33554431 << 8 !== -256) { 
  $ERROR('#282: 33554431 << 8 === -256. Actual: ' + (33554431 << 8)); 
} 


if (67108863 << 8 !== -256) { 
  $ERROR('#283: 67108863 << 8 === -256. Actual: ' + (67108863 << 8)); 
} 


if (134217727 << 8 !== -256) { 
  $ERROR('#284: 134217727 << 8 === -256. Actual: ' + (134217727 << 8)); 
} 


if (268435455 << 8 !== -256) { 
  $ERROR('#285: 268435455 << 8 === -256. Actual: ' + (268435455 << 8)); 
} 


if (536870911 << 8 !== -256) { 
  $ERROR('#286: 536870911 << 8 === -256. Actual: ' + (536870911 << 8)); 
} 


if (1073741823 << 8 !== -256) { 
  $ERROR('#287: 1073741823 << 8 === -256. Actual: ' + (1073741823 << 8)); 
} 


if (2147483647 << 8 !== -256) { 
  $ERROR('#288: 2147483647 << 8 === -256. Actual: ' + (2147483647 << 8)); 
} 


if (0 << 9 !== 0) { 
  $ERROR('#289: 0 << 9 === 0. Actual: ' + (0 << 9)); 
} 


if (1 << 9 !== 512) { 
  $ERROR('#290: 1 << 9 === 512. Actual: ' + (1 << 9)); 
} 


if (3 << 9 !== 1536) { 
  $ERROR('#291: 3 << 9 === 1536. Actual: ' + (3 << 9)); 
} 


if (7 << 9 !== 3584) { 
  $ERROR('#292: 7 << 9 === 3584. Actual: ' + (7 << 9)); 
} 


if (15 << 9 !== 7680) { 
  $ERROR('#293: 15 << 9 === 7680. Actual: ' + (15 << 9)); 
} 


if (31 << 9 !== 15872) { 
  $ERROR('#294: 31 << 9 === 15872. Actual: ' + (31 << 9)); 
} 


if (63 << 9 !== 32256) { 
  $ERROR('#295: 63 << 9 === 32256. Actual: ' + (63 << 9)); 
} 


if (127 << 9 !== 65024) { 
  $ERROR('#296: 127 << 9 === 65024. Actual: ' + (127 << 9)); 
} 


if (255 << 9 !== 130560) { 
  $ERROR('#297: 255 << 9 === 130560. Actual: ' + (255 << 9)); 
} 


if (511 << 9 !== 261632) { 
  $ERROR('#298: 511 << 9 === 261632. Actual: ' + (511 << 9)); 
} 


if (1023 << 9 !== 523776) { 
  $ERROR('#299: 1023 << 9 === 523776. Actual: ' + (1023 << 9)); 
} 


if (2047 << 9 !== 1048064) { 
  $ERROR('#300: 2047 << 9 === 1048064. Actual: ' + (2047 << 9)); 
} 


if (4095 << 9 !== 2096640) { 
  $ERROR('#301: 4095 << 9 === 2096640. Actual: ' + (4095 << 9)); 
} 


if (8191 << 9 !== 4193792) { 
  $ERROR('#302: 8191 << 9 === 4193792. Actual: ' + (8191 << 9)); 
} 


if (16383 << 9 !== 8388096) { 
  $ERROR('#303: 16383 << 9 === 8388096. Actual: ' + (16383 << 9)); 
} 


if (32767 << 9 !== 16776704) { 
  $ERROR('#304: 32767 << 9 === 16776704. Actual: ' + (32767 << 9)); 
} 


if (65535 << 9 !== 33553920) { 
  $ERROR('#305: 65535 << 9 === 33553920. Actual: ' + (65535 << 9)); 
} 


if (131071 << 9 !== 67108352) { 
  $ERROR('#306: 131071 << 9 === 67108352. Actual: ' + (131071 << 9)); 
} 


if (262143 << 9 !== 134217216) { 
  $ERROR('#307: 262143 << 9 === 134217216. Actual: ' + (262143 << 9)); 
} 


if (524287 << 9 !== 268434944) { 
  $ERROR('#308: 524287 << 9 === 268434944. Actual: ' + (524287 << 9)); 
} 


if (1048575 << 9 !== 536870400) { 
  $ERROR('#309: 1048575 << 9 === 536870400. Actual: ' + (1048575 << 9)); 
} 


if (2097151 << 9 !== 1073741312) { 
  $ERROR('#310: 2097151 << 9 === 1073741312. Actual: ' + (2097151 << 9)); 
} 


if (4194303 << 9 !== 2147483136) { 
  $ERROR('#311: 4194303 << 9 === 2147483136. Actual: ' + (4194303 << 9)); 
} 


if (8388607 << 9 !== -512) { 
  $ERROR('#312: 8388607 << 9 === -512. Actual: ' + (8388607 << 9)); 
} 


if (16777215 << 9 !== -512) { 
  $ERROR('#313: 16777215 << 9 === -512. Actual: ' + (16777215 << 9)); 
} 


if (33554431 << 9 !== -512) { 
  $ERROR('#314: 33554431 << 9 === -512. Actual: ' + (33554431 << 9)); 
} 


if (67108863 << 9 !== -512) { 
  $ERROR('#315: 67108863 << 9 === -512. Actual: ' + (67108863 << 9)); 
} 


if (134217727 << 9 !== -512) { 
  $ERROR('#316: 134217727 << 9 === -512. Actual: ' + (134217727 << 9)); 
} 


if (268435455 << 9 !== -512) { 
  $ERROR('#317: 268435455 << 9 === -512. Actual: ' + (268435455 << 9)); 
} 


if (536870911 << 9 !== -512) { 
  $ERROR('#318: 536870911 << 9 === -512. Actual: ' + (536870911 << 9)); 
} 


if (1073741823 << 9 !== -512) { 
  $ERROR('#319: 1073741823 << 9 === -512. Actual: ' + (1073741823 << 9)); 
} 


if (2147483647 << 9 !== -512) { 
  $ERROR('#320: 2147483647 << 9 === -512. Actual: ' + (2147483647 << 9)); 
} 


if (0 << 10 !== 0) { 
  $ERROR('#321: 0 << 10 === 0. Actual: ' + (0 << 10)); 
} 


if (1 << 10 !== 1024) { 
  $ERROR('#322: 1 << 10 === 1024. Actual: ' + (1 << 10)); 
} 


if (3 << 10 !== 3072) { 
  $ERROR('#323: 3 << 10 === 3072. Actual: ' + (3 << 10)); 
} 


if (7 << 10 !== 7168) { 
  $ERROR('#324: 7 << 10 === 7168. Actual: ' + (7 << 10)); 
} 


if (15 << 10 !== 15360) { 
  $ERROR('#325: 15 << 10 === 15360. Actual: ' + (15 << 10)); 
} 


if (31 << 10 !== 31744) { 
  $ERROR('#326: 31 << 10 === 31744. Actual: ' + (31 << 10)); 
} 


if (63 << 10 !== 64512) { 
  $ERROR('#327: 63 << 10 === 64512. Actual: ' + (63 << 10)); 
} 


if (127 << 10 !== 130048) { 
  $ERROR('#328: 127 << 10 === 130048. Actual: ' + (127 << 10)); 
} 


if (255 << 10 !== 261120) { 
  $ERROR('#329: 255 << 10 === 261120. Actual: ' + (255 << 10)); 
} 


if (511 << 10 !== 523264) { 
  $ERROR('#330: 511 << 10 === 523264. Actual: ' + (511 << 10)); 
} 


if (1023 << 10 !== 1047552) { 
  $ERROR('#331: 1023 << 10 === 1047552. Actual: ' + (1023 << 10)); 
} 


if (2047 << 10 !== 2096128) { 
  $ERROR('#332: 2047 << 10 === 2096128. Actual: ' + (2047 << 10)); 
} 


if (4095 << 10 !== 4193280) { 
  $ERROR('#333: 4095 << 10 === 4193280. Actual: ' + (4095 << 10)); 
} 


if (8191 << 10 !== 8387584) { 
  $ERROR('#334: 8191 << 10 === 8387584. Actual: ' + (8191 << 10)); 
} 


if (16383 << 10 !== 16776192) { 
  $ERROR('#335: 16383 << 10 === 16776192. Actual: ' + (16383 << 10)); 
} 


if (32767 << 10 !== 33553408) { 
  $ERROR('#336: 32767 << 10 === 33553408. Actual: ' + (32767 << 10)); 
} 


if (65535 << 10 !== 67107840) { 
  $ERROR('#337: 65535 << 10 === 67107840. Actual: ' + (65535 << 10)); 
} 


if (131071 << 10 !== 134216704) { 
  $ERROR('#338: 131071 << 10 === 134216704. Actual: ' + (131071 << 10)); 
} 


if (262143 << 10 !== 268434432) { 
  $ERROR('#339: 262143 << 10 === 268434432. Actual: ' + (262143 << 10)); 
} 


if (524287 << 10 !== 536869888) { 
  $ERROR('#340: 524287 << 10 === 536869888. Actual: ' + (524287 << 10)); 
} 


if (1048575 << 10 !== 1073740800) { 
  $ERROR('#341: 1048575 << 10 === 1073740800. Actual: ' + (1048575 << 10)); 
} 


if (2097151 << 10 !== 2147482624) { 
  $ERROR('#342: 2097151 << 10 === 2147482624. Actual: ' + (2097151 << 10)); 
} 


if (4194303 << 10 !== -1024) { 
  $ERROR('#343: 4194303 << 10 === -1024. Actual: ' + (4194303 << 10)); 
} 


if (8388607 << 10 !== -1024) { 
  $ERROR('#344: 8388607 << 10 === -1024. Actual: ' + (8388607 << 10)); 
} 


if (16777215 << 10 !== -1024) { 
  $ERROR('#345: 16777215 << 10 === -1024. Actual: ' + (16777215 << 10)); 
} 


if (33554431 << 10 !== -1024) { 
  $ERROR('#346: 33554431 << 10 === -1024. Actual: ' + (33554431 << 10)); 
} 


if (67108863 << 10 !== -1024) { 
  $ERROR('#347: 67108863 << 10 === -1024. Actual: ' + (67108863 << 10)); 
} 


if (134217727 << 10 !== -1024) { 
  $ERROR('#348: 134217727 << 10 === -1024. Actual: ' + (134217727 << 10)); 
} 


if (268435455 << 10 !== -1024) { 
  $ERROR('#349: 268435455 << 10 === -1024. Actual: ' + (268435455 << 10)); 
} 


if (536870911 << 10 !== -1024) { 
  $ERROR('#350: 536870911 << 10 === -1024. Actual: ' + (536870911 << 10)); 
} 


if (1073741823 << 10 !== -1024) { 
  $ERROR('#351: 1073741823 << 10 === -1024. Actual: ' + (1073741823 << 10)); 
} 


if (2147483647 << 10 !== -1024) { 
  $ERROR('#352: 2147483647 << 10 === -1024. Actual: ' + (2147483647 << 10)); 
} 


if (0 << 11 !== 0) { 
  $ERROR('#353: 0 << 11 === 0. Actual: ' + (0 << 11)); 
} 


if (1 << 11 !== 2048) { 
  $ERROR('#354: 1 << 11 === 2048. Actual: ' + (1 << 11)); 
} 


if (3 << 11 !== 6144) { 
  $ERROR('#355: 3 << 11 === 6144. Actual: ' + (3 << 11)); 
} 


if (7 << 11 !== 14336) { 
  $ERROR('#356: 7 << 11 === 14336. Actual: ' + (7 << 11)); 
} 


if (15 << 11 !== 30720) { 
  $ERROR('#357: 15 << 11 === 30720. Actual: ' + (15 << 11)); 
} 


if (31 << 11 !== 63488) { 
  $ERROR('#358: 31 << 11 === 63488. Actual: ' + (31 << 11)); 
} 


if (63 << 11 !== 129024) { 
  $ERROR('#359: 63 << 11 === 129024. Actual: ' + (63 << 11)); 
} 


if (127 << 11 !== 260096) { 
  $ERROR('#360: 127 << 11 === 260096. Actual: ' + (127 << 11)); 
} 


if (255 << 11 !== 522240) { 
  $ERROR('#361: 255 << 11 === 522240. Actual: ' + (255 << 11)); 
} 


if (511 << 11 !== 1046528) { 
  $ERROR('#362: 511 << 11 === 1046528. Actual: ' + (511 << 11)); 
} 


if (1023 << 11 !== 2095104) { 
  $ERROR('#363: 1023 << 11 === 2095104. Actual: ' + (1023 << 11)); 
} 


if (2047 << 11 !== 4192256) { 
  $ERROR('#364: 2047 << 11 === 4192256. Actual: ' + (2047 << 11)); 
} 


if (4095 << 11 !== 8386560) { 
  $ERROR('#365: 4095 << 11 === 8386560. Actual: ' + (4095 << 11)); 
} 


if (8191 << 11 !== 16775168) { 
  $ERROR('#366: 8191 << 11 === 16775168. Actual: ' + (8191 << 11)); 
} 


if (16383 << 11 !== 33552384) { 
  $ERROR('#367: 16383 << 11 === 33552384. Actual: ' + (16383 << 11)); 
} 


if (32767 << 11 !== 67106816) { 
  $ERROR('#368: 32767 << 11 === 67106816. Actual: ' + (32767 << 11)); 
} 


if (65535 << 11 !== 134215680) { 
  $ERROR('#369: 65535 << 11 === 134215680. Actual: ' + (65535 << 11)); 
} 


if (131071 << 11 !== 268433408) { 
  $ERROR('#370: 131071 << 11 === 268433408. Actual: ' + (131071 << 11)); 
} 


if (262143 << 11 !== 536868864) { 
  $ERROR('#371: 262143 << 11 === 536868864. Actual: ' + (262143 << 11)); 
} 


if (524287 << 11 !== 1073739776) { 
  $ERROR('#372: 524287 << 11 === 1073739776. Actual: ' + (524287 << 11)); 
} 


if (1048575 << 11 !== 2147481600) { 
  $ERROR('#373: 1048575 << 11 === 2147481600. Actual: ' + (1048575 << 11)); 
} 


if (2097151 << 11 !== -2048) { 
  $ERROR('#374: 2097151 << 11 === -2048. Actual: ' + (2097151 << 11)); 
} 


if (4194303 << 11 !== -2048) { 
  $ERROR('#375: 4194303 << 11 === -2048. Actual: ' + (4194303 << 11)); 
} 


if (8388607 << 11 !== -2048) { 
  $ERROR('#376: 8388607 << 11 === -2048. Actual: ' + (8388607 << 11)); 
} 


if (16777215 << 11 !== -2048) { 
  $ERROR('#377: 16777215 << 11 === -2048. Actual: ' + (16777215 << 11)); 
} 


if (33554431 << 11 !== -2048) { 
  $ERROR('#378: 33554431 << 11 === -2048. Actual: ' + (33554431 << 11)); 
} 


if (67108863 << 11 !== -2048) { 
  $ERROR('#379: 67108863 << 11 === -2048. Actual: ' + (67108863 << 11)); 
} 


if (134217727 << 11 !== -2048) { 
  $ERROR('#380: 134217727 << 11 === -2048. Actual: ' + (134217727 << 11)); 
} 


if (268435455 << 11 !== -2048) { 
  $ERROR('#381: 268435455 << 11 === -2048. Actual: ' + (268435455 << 11)); 
} 


if (536870911 << 11 !== -2048) { 
  $ERROR('#382: 536870911 << 11 === -2048. Actual: ' + (536870911 << 11)); 
} 


if (1073741823 << 11 !== -2048) { 
  $ERROR('#383: 1073741823 << 11 === -2048. Actual: ' + (1073741823 << 11)); 
} 


if (2147483647 << 11 !== -2048) { 
  $ERROR('#384: 2147483647 << 11 === -2048. Actual: ' + (2147483647 << 11)); 
} 


if (0 << 12 !== 0) { 
  $ERROR('#385: 0 << 12 === 0. Actual: ' + (0 << 12)); 
} 


if (1 << 12 !== 4096) { 
  $ERROR('#386: 1 << 12 === 4096. Actual: ' + (1 << 12)); 
} 


if (3 << 12 !== 12288) { 
  $ERROR('#387: 3 << 12 === 12288. Actual: ' + (3 << 12)); 
} 


if (7 << 12 !== 28672) { 
  $ERROR('#388: 7 << 12 === 28672. Actual: ' + (7 << 12)); 
} 


if (15 << 12 !== 61440) { 
  $ERROR('#389: 15 << 12 === 61440. Actual: ' + (15 << 12)); 
} 


if (31 << 12 !== 126976) { 
  $ERROR('#390: 31 << 12 === 126976. Actual: ' + (31 << 12)); 
} 


if (63 << 12 !== 258048) { 
  $ERROR('#391: 63 << 12 === 258048. Actual: ' + (63 << 12)); 
} 


if (127 << 12 !== 520192) { 
  $ERROR('#392: 127 << 12 === 520192. Actual: ' + (127 << 12)); 
} 


if (255 << 12 !== 1044480) { 
  $ERROR('#393: 255 << 12 === 1044480. Actual: ' + (255 << 12)); 
} 


if (511 << 12 !== 2093056) { 
  $ERROR('#394: 511 << 12 === 2093056. Actual: ' + (511 << 12)); 
} 


if (1023 << 12 !== 4190208) { 
  $ERROR('#395: 1023 << 12 === 4190208. Actual: ' + (1023 << 12)); 
} 


if (2047 << 12 !== 8384512) { 
  $ERROR('#396: 2047 << 12 === 8384512. Actual: ' + (2047 << 12)); 
} 


if (4095 << 12 !== 16773120) { 
  $ERROR('#397: 4095 << 12 === 16773120. Actual: ' + (4095 << 12)); 
} 


if (8191 << 12 !== 33550336) { 
  $ERROR('#398: 8191 << 12 === 33550336. Actual: ' + (8191 << 12)); 
} 


if (16383 << 12 !== 67104768) { 
  $ERROR('#399: 16383 << 12 === 67104768. Actual: ' + (16383 << 12)); 
} 


if (32767 << 12 !== 134213632) { 
  $ERROR('#400: 32767 << 12 === 134213632. Actual: ' + (32767 << 12)); 
} 


if (65535 << 12 !== 268431360) { 
  $ERROR('#401: 65535 << 12 === 268431360. Actual: ' + (65535 << 12)); 
} 


if (131071 << 12 !== 536866816) { 
  $ERROR('#402: 131071 << 12 === 536866816. Actual: ' + (131071 << 12)); 
} 


if (262143 << 12 !== 1073737728) { 
  $ERROR('#403: 262143 << 12 === 1073737728. Actual: ' + (262143 << 12)); 
} 


if (524287 << 12 !== 2147479552) { 
  $ERROR('#404: 524287 << 12 === 2147479552. Actual: ' + (524287 << 12)); 
} 


if (1048575 << 12 !== -4096) { 
  $ERROR('#405: 1048575 << 12 === -4096. Actual: ' + (1048575 << 12)); 
} 


if (2097151 << 12 !== -4096) { 
  $ERROR('#406: 2097151 << 12 === -4096. Actual: ' + (2097151 << 12)); 
} 


if (4194303 << 12 !== -4096) { 
  $ERROR('#407: 4194303 << 12 === -4096. Actual: ' + (4194303 << 12)); 
} 


if (8388607 << 12 !== -4096) { 
  $ERROR('#408: 8388607 << 12 === -4096. Actual: ' + (8388607 << 12)); 
} 


if (16777215 << 12 !== -4096) { 
  $ERROR('#409: 16777215 << 12 === -4096. Actual: ' + (16777215 << 12)); 
} 


if (33554431 << 12 !== -4096) { 
  $ERROR('#410: 33554431 << 12 === -4096. Actual: ' + (33554431 << 12)); 
} 


if (67108863 << 12 !== -4096) { 
  $ERROR('#411: 67108863 << 12 === -4096. Actual: ' + (67108863 << 12)); 
} 


if (134217727 << 12 !== -4096) { 
  $ERROR('#412: 134217727 << 12 === -4096. Actual: ' + (134217727 << 12)); 
} 


if (268435455 << 12 !== -4096) { 
  $ERROR('#413: 268435455 << 12 === -4096. Actual: ' + (268435455 << 12)); 
} 


if (536870911 << 12 !== -4096) { 
  $ERROR('#414: 536870911 << 12 === -4096. Actual: ' + (536870911 << 12)); 
} 


if (1073741823 << 12 !== -4096) { 
  $ERROR('#415: 1073741823 << 12 === -4096. Actual: ' + (1073741823 << 12)); 
} 


if (2147483647 << 12 !== -4096) { 
  $ERROR('#416: 2147483647 << 12 === -4096. Actual: ' + (2147483647 << 12)); 
} 


if (0 << 13 !== 0) { 
  $ERROR('#417: 0 << 13 === 0. Actual: ' + (0 << 13)); 
} 


if (1 << 13 !== 8192) { 
  $ERROR('#418: 1 << 13 === 8192. Actual: ' + (1 << 13)); 
} 


if (3 << 13 !== 24576) { 
  $ERROR('#419: 3 << 13 === 24576. Actual: ' + (3 << 13)); 
} 


if (7 << 13 !== 57344) { 
  $ERROR('#420: 7 << 13 === 57344. Actual: ' + (7 << 13)); 
} 


if (15 << 13 !== 122880) { 
  $ERROR('#421: 15 << 13 === 122880. Actual: ' + (15 << 13)); 
} 


if (31 << 13 !== 253952) { 
  $ERROR('#422: 31 << 13 === 253952. Actual: ' + (31 << 13)); 
} 


if (63 << 13 !== 516096) { 
  $ERROR('#423: 63 << 13 === 516096. Actual: ' + (63 << 13)); 
} 


if (127 << 13 !== 1040384) { 
  $ERROR('#424: 127 << 13 === 1040384. Actual: ' + (127 << 13)); 
} 


if (255 << 13 !== 2088960) { 
  $ERROR('#425: 255 << 13 === 2088960. Actual: ' + (255 << 13)); 
} 


if (511 << 13 !== 4186112) { 
  $ERROR('#426: 511 << 13 === 4186112. Actual: ' + (511 << 13)); 
} 


if (1023 << 13 !== 8380416) { 
  $ERROR('#427: 1023 << 13 === 8380416. Actual: ' + (1023 << 13)); 
} 


if (2047 << 13 !== 16769024) { 
  $ERROR('#428: 2047 << 13 === 16769024. Actual: ' + (2047 << 13)); 
} 


if (4095 << 13 !== 33546240) { 
  $ERROR('#429: 4095 << 13 === 33546240. Actual: ' + (4095 << 13)); 
} 


if (8191 << 13 !== 67100672) { 
  $ERROR('#430: 8191 << 13 === 67100672. Actual: ' + (8191 << 13)); 
} 


if (16383 << 13 !== 134209536) { 
  $ERROR('#431: 16383 << 13 === 134209536. Actual: ' + (16383 << 13)); 
} 


if (32767 << 13 !== 268427264) { 
  $ERROR('#432: 32767 << 13 === 268427264. Actual: ' + (32767 << 13)); 
} 


if (65535 << 13 !== 536862720) { 
  $ERROR('#433: 65535 << 13 === 536862720. Actual: ' + (65535 << 13)); 
} 


if (131071 << 13 !== 1073733632) { 
  $ERROR('#434: 131071 << 13 === 1073733632. Actual: ' + (131071 << 13)); 
} 


if (262143 << 13 !== 2147475456) { 
  $ERROR('#435: 262143 << 13 === 2147475456. Actual: ' + (262143 << 13)); 
} 


if (524287 << 13 !== -8192) { 
  $ERROR('#436: 524287 << 13 === -8192. Actual: ' + (524287 << 13)); 
} 


if (1048575 << 13 !== -8192) { 
  $ERROR('#437: 1048575 << 13 === -8192. Actual: ' + (1048575 << 13)); 
} 


if (2097151 << 13 !== -8192) { 
  $ERROR('#438: 2097151 << 13 === -8192. Actual: ' + (2097151 << 13)); 
} 


if (4194303 << 13 !== -8192) { 
  $ERROR('#439: 4194303 << 13 === -8192. Actual: ' + (4194303 << 13)); 
} 


if (8388607 << 13 !== -8192) { 
  $ERROR('#440: 8388607 << 13 === -8192. Actual: ' + (8388607 << 13)); 
} 


if (16777215 << 13 !== -8192) { 
  $ERROR('#441: 16777215 << 13 === -8192. Actual: ' + (16777215 << 13)); 
} 


if (33554431 << 13 !== -8192) { 
  $ERROR('#442: 33554431 << 13 === -8192. Actual: ' + (33554431 << 13)); 
} 


if (67108863 << 13 !== -8192) { 
  $ERROR('#443: 67108863 << 13 === -8192. Actual: ' + (67108863 << 13)); 
} 


if (134217727 << 13 !== -8192) { 
  $ERROR('#444: 134217727 << 13 === -8192. Actual: ' + (134217727 << 13)); 
} 


if (268435455 << 13 !== -8192) { 
  $ERROR('#445: 268435455 << 13 === -8192. Actual: ' + (268435455 << 13)); 
} 


if (536870911 << 13 !== -8192) { 
  $ERROR('#446: 536870911 << 13 === -8192. Actual: ' + (536870911 << 13)); 
} 


if (1073741823 << 13 !== -8192) { 
  $ERROR('#447: 1073741823 << 13 === -8192. Actual: ' + (1073741823 << 13)); 
} 


if (2147483647 << 13 !== -8192) { 
  $ERROR('#448: 2147483647 << 13 === -8192. Actual: ' + (2147483647 << 13)); 
} 


if (0 << 14 !== 0) { 
  $ERROR('#449: 0 << 14 === 0. Actual: ' + (0 << 14)); 
} 


if (1 << 14 !== 16384) { 
  $ERROR('#450: 1 << 14 === 16384. Actual: ' + (1 << 14)); 
} 


if (3 << 14 !== 49152) { 
  $ERROR('#451: 3 << 14 === 49152. Actual: ' + (3 << 14)); 
} 


if (7 << 14 !== 114688) { 
  $ERROR('#452: 7 << 14 === 114688. Actual: ' + (7 << 14)); 
} 


if (15 << 14 !== 245760) { 
  $ERROR('#453: 15 << 14 === 245760. Actual: ' + (15 << 14)); 
} 


if (31 << 14 !== 507904) { 
  $ERROR('#454: 31 << 14 === 507904. Actual: ' + (31 << 14)); 
} 


if (63 << 14 !== 1032192) { 
  $ERROR('#455: 63 << 14 === 1032192. Actual: ' + (63 << 14)); 
} 


if (127 << 14 !== 2080768) { 
  $ERROR('#456: 127 << 14 === 2080768. Actual: ' + (127 << 14)); 
} 


if (255 << 14 !== 4177920) { 
  $ERROR('#457: 255 << 14 === 4177920. Actual: ' + (255 << 14)); 
} 


if (511 << 14 !== 8372224) { 
  $ERROR('#458: 511 << 14 === 8372224. Actual: ' + (511 << 14)); 
} 


if (1023 << 14 !== 16760832) { 
  $ERROR('#459: 1023 << 14 === 16760832. Actual: ' + (1023 << 14)); 
} 


if (2047 << 14 !== 33538048) { 
  $ERROR('#460: 2047 << 14 === 33538048. Actual: ' + (2047 << 14)); 
} 


if (4095 << 14 !== 67092480) { 
  $ERROR('#461: 4095 << 14 === 67092480. Actual: ' + (4095 << 14)); 
} 


if (8191 << 14 !== 134201344) { 
  $ERROR('#462: 8191 << 14 === 134201344. Actual: ' + (8191 << 14)); 
} 


if (16383 << 14 !== 268419072) { 
  $ERROR('#463: 16383 << 14 === 268419072. Actual: ' + (16383 << 14)); 
} 


if (32767 << 14 !== 536854528) { 
  $ERROR('#464: 32767 << 14 === 536854528. Actual: ' + (32767 << 14)); 
} 


if (65535 << 14 !== 1073725440) { 
  $ERROR('#465: 65535 << 14 === 1073725440. Actual: ' + (65535 << 14)); 
} 


if (131071 << 14 !== 2147467264) { 
  $ERROR('#466: 131071 << 14 === 2147467264. Actual: ' + (131071 << 14)); 
} 


if (262143 << 14 !== -16384) { 
  $ERROR('#467: 262143 << 14 === -16384. Actual: ' + (262143 << 14)); 
} 


if (524287 << 14 !== -16384) { 
  $ERROR('#468: 524287 << 14 === -16384. Actual: ' + (524287 << 14)); 
} 


if (1048575 << 14 !== -16384) { 
  $ERROR('#469: 1048575 << 14 === -16384. Actual: ' + (1048575 << 14)); 
} 


if (2097151 << 14 !== -16384) { 
  $ERROR('#470: 2097151 << 14 === -16384. Actual: ' + (2097151 << 14)); 
} 


if (4194303 << 14 !== -16384) { 
  $ERROR('#471: 4194303 << 14 === -16384. Actual: ' + (4194303 << 14)); 
} 


if (8388607 << 14 !== -16384) { 
  $ERROR('#472: 8388607 << 14 === -16384. Actual: ' + (8388607 << 14)); 
} 


if (16777215 << 14 !== -16384) { 
  $ERROR('#473: 16777215 << 14 === -16384. Actual: ' + (16777215 << 14)); 
} 


if (33554431 << 14 !== -16384) { 
  $ERROR('#474: 33554431 << 14 === -16384. Actual: ' + (33554431 << 14)); 
} 


if (67108863 << 14 !== -16384) { 
  $ERROR('#475: 67108863 << 14 === -16384. Actual: ' + (67108863 << 14)); 
} 


if (134217727 << 14 !== -16384) { 
  $ERROR('#476: 134217727 << 14 === -16384. Actual: ' + (134217727 << 14)); 
} 


if (268435455 << 14 !== -16384) { 
  $ERROR('#477: 268435455 << 14 === -16384. Actual: ' + (268435455 << 14)); 
} 


if (536870911 << 14 !== -16384) { 
  $ERROR('#478: 536870911 << 14 === -16384. Actual: ' + (536870911 << 14)); 
} 


if (1073741823 << 14 !== -16384) { 
  $ERROR('#479: 1073741823 << 14 === -16384. Actual: ' + (1073741823 << 14)); 
} 


if (2147483647 << 14 !== -16384) { 
  $ERROR('#480: 2147483647 << 14 === -16384. Actual: ' + (2147483647 << 14)); 
} 


if (0 << 15 !== 0) { 
  $ERROR('#481: 0 << 15 === 0. Actual: ' + (0 << 15)); 
} 


if (1 << 15 !== 32768) { 
  $ERROR('#482: 1 << 15 === 32768. Actual: ' + (1 << 15)); 
} 


if (3 << 15 !== 98304) { 
  $ERROR('#483: 3 << 15 === 98304. Actual: ' + (3 << 15)); 
} 


if (7 << 15 !== 229376) { 
  $ERROR('#484: 7 << 15 === 229376. Actual: ' + (7 << 15)); 
} 


if (15 << 15 !== 491520) { 
  $ERROR('#485: 15 << 15 === 491520. Actual: ' + (15 << 15)); 
} 


if (31 << 15 !== 1015808) { 
  $ERROR('#486: 31 << 15 === 1015808. Actual: ' + (31 << 15)); 
} 


if (63 << 15 !== 2064384) { 
  $ERROR('#487: 63 << 15 === 2064384. Actual: ' + (63 << 15)); 
} 


if (127 << 15 !== 4161536) { 
  $ERROR('#488: 127 << 15 === 4161536. Actual: ' + (127 << 15)); 
} 


if (255 << 15 !== 8355840) { 
  $ERROR('#489: 255 << 15 === 8355840. Actual: ' + (255 << 15)); 
} 


if (511 << 15 !== 16744448) { 
  $ERROR('#490: 511 << 15 === 16744448. Actual: ' + (511 << 15)); 
} 


if (1023 << 15 !== 33521664) { 
  $ERROR('#491: 1023 << 15 === 33521664. Actual: ' + (1023 << 15)); 
} 


if (2047 << 15 !== 67076096) { 
  $ERROR('#492: 2047 << 15 === 67076096. Actual: ' + (2047 << 15)); 
} 


if (4095 << 15 !== 134184960) { 
  $ERROR('#493: 4095 << 15 === 134184960. Actual: ' + (4095 << 15)); 
} 


if (8191 << 15 !== 268402688) { 
  $ERROR('#494: 8191 << 15 === 268402688. Actual: ' + (8191 << 15)); 
} 


if (16383 << 15 !== 536838144) { 
  $ERROR('#495: 16383 << 15 === 536838144. Actual: ' + (16383 << 15)); 
} 


if (32767 << 15 !== 1073709056) { 
  $ERROR('#496: 32767 << 15 === 1073709056. Actual: ' + (32767 << 15)); 
} 


if (65535 << 15 !== 2147450880) { 
  $ERROR('#497: 65535 << 15 === 2147450880. Actual: ' + (65535 << 15)); 
} 


if (131071 << 15 !== -32768) { 
  $ERROR('#498: 131071 << 15 === -32768. Actual: ' + (131071 << 15)); 
} 


if (262143 << 15 !== -32768) { 
  $ERROR('#499: 262143 << 15 === -32768. Actual: ' + (262143 << 15)); 
} 


if (524287 << 15 !== -32768) { 
  $ERROR('#500: 524287 << 15 === -32768. Actual: ' + (524287 << 15)); 
} 


if (1048575 << 15 !== -32768) { 
  $ERROR('#501: 1048575 << 15 === -32768. Actual: ' + (1048575 << 15)); 
} 


if (2097151 << 15 !== -32768) { 
  $ERROR('#502: 2097151 << 15 === -32768. Actual: ' + (2097151 << 15)); 
} 


if (4194303 << 15 !== -32768) { 
  $ERROR('#503: 4194303 << 15 === -32768. Actual: ' + (4194303 << 15)); 
} 


if (8388607 << 15 !== -32768) { 
  $ERROR('#504: 8388607 << 15 === -32768. Actual: ' + (8388607 << 15)); 
} 


if (16777215 << 15 !== -32768) { 
  $ERROR('#505: 16777215 << 15 === -32768. Actual: ' + (16777215 << 15)); 
} 


if (33554431 << 15 !== -32768) { 
  $ERROR('#506: 33554431 << 15 === -32768. Actual: ' + (33554431 << 15)); 
} 


if (67108863 << 15 !== -32768) { 
  $ERROR('#507: 67108863 << 15 === -32768. Actual: ' + (67108863 << 15)); 
} 


if (134217727 << 15 !== -32768) { 
  $ERROR('#508: 134217727 << 15 === -32768. Actual: ' + (134217727 << 15)); 
} 


if (268435455 << 15 !== -32768) { 
  $ERROR('#509: 268435455 << 15 === -32768. Actual: ' + (268435455 << 15)); 
} 


if (536870911 << 15 !== -32768) { 
  $ERROR('#510: 536870911 << 15 === -32768. Actual: ' + (536870911 << 15)); 
} 


if (1073741823 << 15 !== -32768) { 
  $ERROR('#511: 1073741823 << 15 === -32768. Actual: ' + (1073741823 << 15)); 
} 


if (2147483647 << 15 !== -32768) { 
  $ERROR('#512: 2147483647 << 15 === -32768. Actual: ' + (2147483647 << 15)); 
}

reportCompare(0, 0);
