.\" -*-nroff-*-
.\"
.\"
.\"     Copyright (C) 1996-2023 Michael R. Elkins <me@cs.hmc.edu>
.\" 
.\"     This program is free software; you can redistribute it and/or modify
.\"     it under the terms of the GNU General Public License as published by
.\"     the Free Software Foundation; either version 2 of the License, or
.\"     (at your option) any later version.
.\" 
.\"     This program is distributed in the hope that it will be useful,
.\"     but WITHOUT ANY WARRANTY; without even the implied warranty of
.\"     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\"     GNU General Public License for more details.
.\" 
.\"     You should have received a copy of the GNU General Public License
.\"     along with this program; if not, write to the Free Software
.\"     Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
.\"
.TH MUTT 1 "July 24, 2020" Unix "User Manuals"
.SH NAME
mutt \- The Mutt Mail User Agent
.SH SYNOPSIS
.TP 6
.B mutt
[\fB\-nRyzZ\fR]
[\fB\-e \fIcommand\fR]
[\fB\-F \fIrcfile\fR]
[\fB\-m \fItype\fR]
[\fB\-f \fImailbox\fR]
.TP 6
.B mutt
[\fB\-Enx\fR]
[\fB\-e \fIcommand\fR]
[\fB\-F \fIrcfile\fR]
[\fB\-H \fIdraft\fR]
[\fB\-i \fIinclude\fR]
.br
[\fB\-b \fIbcc-addr\fR]
[\fB\-c \fIcc-addr\fR]
[\fB\-s \fIsubject\fR]
.br
[\fB\-a \fIfile ... \fB\-\-\fR]
\fIto-addr ...
.TP 6
.B mutt
[\fB\-nx\fR]
[\fB\-e \fIcommand\fR]
[\fB\-F \fIrcfile\fR]
[\fB\-b \fIbcc-addr\fR]
[\fB\-c \fIcc-addr\fR]
.br
[\fB\-s \fIsubject\fR]
[\fB\-a \fIfile ... \fB\-\-\fR]
\fIto-addr ... \fR< message
.TP 6
.B mutt
[\fB\-n\fR]
[\fB\-e \fIcommand\fR]
[\fB\-F \fIrcfile\fR]
\fB\-p
.TP 6
.B mutt
[\fB\-n\fR]
[\fB\-e \fIcommand\fR]
[\fB\-F \fIrcfile\fR]
\fB\-A \fIalias
.TP 6
.B mutt
[\fB\-n\fR]
[\fB\-e \fIcommand\fR]
[\fB\-F \fIrcfile\fR]
\fB\-Q \fIvariable
.TP 6
.B mutt
\fB\-v\fR[\fBv\fR]
.TP 6
.B mutt
\fB\-D
.SH DESCRIPTION
.PP
Mutt is a small but very powerful text based program for reading and sending electronic
mail under unix operating systems, including support for color terminals, MIME,
OpenPGP, and a threaded sorting mode.
.PP
.BR Note :
This manual page gives a brief overview of the \fBmutt\fP executable command
line options.
A copy of the full manual is located in \fI@docdir@\fP, in text, HTML, and/or
PDF format.
Please refer to the manual to learn how to use and configure Mutt.
.SH OPTIONS
.TP
.BI \-A " alias"
Print an expanded version of the given \fIalias\fP and exit.
.TP
.BI \-a " file ... "
Attach a \fIfile\fP using MIME.
Separating \fIfile\fP and \fIto-addr\fP arguments with \*(lq\fB\-\-\fP\*(rq is
mandatory.
For example:
.sp
.in +4m
.nf
mutt \-a image.jpg \-\- to-addr
mutt \-a img.jpg *.png \-\- to-addr-1 to-addr-2
.fi
.in
.sp
The \fB\-a\fP option must be placed at the end of command line options.
.TP
.BI \-b " bcc-addr"
Specify a blind carbon copy (BCC) address.
.TP
.BI \-c " cc-addr"
Specify a carbon copy (CC) address.
.TP
.BI \-d " level"
If Mutt was compiled with \fB+DEBUG\fP log debugging output to
\fI~/.muttdebug0\fP.
\fILevel\fP can range from -5 to 5 and affects verbosity. A value of
zero disables debugging. A value less than zero disables automatic log
file rotation; the log level is then its absolute value. A value of 2
(-2) is recommended for most diagnosis.
.TP
.B \-D
Print the value of all configuration options to stdout.
.TP
.B \-E
Edit the \fIdraft\fP file specified by \fB\-H\fP or \fIinclude\fP file
specified by \fB-i\fP during message composition.
.TP
.BI \-e " command"
Specify a configuration \fIcommand\fP to be run after processing of
initialization files.
.TP
.BI \-f " mailbox"
Specify a \fImailbox\fP to load.
.TP
.BI \-F " rcfile"
Use \fIrcfile\fP instead of the user configuration file.
.TP
.B \-h
Display a short option summary and exit.
.TP
.BI \-H " draft"
Specify a \fIdraft\fP file which contains header and body to use to
send a message.  If \fIdraft\fP is \*(lq\fB\-\fP\*(rq, then data is
read from stdin.  The draft file is expected to contain just an RFC822
email \(em headers and a body.  Although it is not an mbox file, if an
mbox "\fBFrom\~\fP" line is present, it will be silently discarded.
Draft files are processed the same in interactive and batch mode; they
are not passed through untouched.  For example, encrypted draft files
will be decrypted.
.TP
.BI \-i " include"
Specify an \fIinclude\fP file to be inserted into the body of a message.
Ignored if \fB\-H\fP is set.
If \fIinclude\fP is \*(lq\fB\-\fP\*(rq, then data is read from stdin.
.TP
.BI \-m " type"
Specify a default mailbox \fItype\fP for newly created folders.
Can be one of the following: mbox, MMDF, MH or Maildir.
See also \fB$mbox_type\fP in the manual.
.TP
.B \-n
Do not read the system-wide Muttrc configuration file.
.TP
.B \-p
Resume a postponed message.
Exit immediately if there are no postponed messages.
.TP
.BI \-Q " variable"
Query a configuration \fIvariable\fP.
The query is performed after all configuration files have been parsed, and any
\fIcommands\fP given on the command line have been executed.
.TP
.B \-R
Open a mailbox in read-only mode.
.TP
.BI \-s " subject"
Specify the \fIsubject\fP of the message.
Must be enclosed in quotes if it contains spaces.
.TP
.B \-v
Display the Mutt version number and compile-time definitions.
.TP
.B \-vv
Display license and copyright information.
.TP
.B \-x
Emulate the
.BR mailx (1)
compose mode.
.TP
.B \-y
Start Mutt with a listing of all mailboxes specified by the \fImailboxes\fP
configuration command.
.TP
.B \-z
Exit immediately with code 1 if \fImailbox\fP specified by \fB\-f\fP does not
contain any messages.
.TP
.B \-Z
Open the first mailbox specified by the \fImailboxes\fP configuration command
which contains new mail.
Exit immediately with code 1 if there is no new mail in any of them.
.TP
.B \-\-
Treat remaining arguments as \fIto-addr\fP even if they start with a dash.
See also \fB\-a\fP above.
\fITo-addr\fP can be a local or network mail address as well as mailto: URL.
.SH ENVIRONMENT
.IP "EDITOR, VISUAL"
Specifies the editor to use when composing messages.
If both EDITOR and VISUAL are set, VISUAL takes precedence.
If neither EDITOR nor VISUAL are set, the default is
.BR vi (1).
.IP "EGDSOCKET, RANDFILE"
Paths used to initialize the random engine for SSL library.
.IP "EMAIL"
The user's e-mail address.
.IP "HOME"
Full path of the user's home directory.
.IP "MAIL"
Full path of the user's spool mailbox.
.IP "MAILDIR"
Full path of the user's spool mailbox if MAIL is unset.
Commonly used when the spool mailbox is a
.BR maildir (5)
folder.
.IP "MAILCAPS"
Path to search for mailcap files.
.IP "MM_NOASK"
If this variable is set, mailcap are always used without prompting first.
.IP "PGPPATH"
Directory in which the user's PGP public keyring can be found.
When used with the original PGP program, mutt and
.BR mutt_pgpring (1)
rely on this being set.
.IP "REPLYTO"
Default Reply-To address.
.IP "TMPDIR"
Directory in which temporary files are created.
If unset, \fI/tmp\fP is used.
See also $tmpdir configuration variable.
.IP "LC_ALL, LC_CTYPE, LANG"
Used to determine charset and locale to use.
.IP TEXTDOMAINDIR
Directory containing translation files.
If set, this path overwrite the Mutt installation directory.
Used for testing translation changes.
.SH FILES
.TP
.I ~/.muttrc
.TQ
.I ~/.mutt/muttrc
.TQ
.I $XDG_CONFIG_HOME/mutt/muttrc
User configuration files.
.TP
.I @sysconfdir@/Muttrc or @pkgdatadir@/Muttrc
System-wide configuration file.
.TP
.I /tmp/muttXXXXXX
Temporary files created by Mutt.
.TP
.I ~/.muttdebug0
File containing debugging output.
Log files are automatically rotated by \fBmutt\fP changing the number at the end.
See \fB\-d\fP option above.
.TP
.I ~/.mailcap
User definition for handling non-text MIME types.
.TP
.I @sysconfdir@/mailcap
System definition for handling non-text MIME types.
.TP
.I ~/.mime.types
User's personal mapping between MIME types and file extensions.
.TP
.I @sysconfdir@/mime.types
System mapping between MIME types and file extensions.
.TP
.I @bindir@/mutt_dotlock
The privileged dotlocking program.
.TP
.I @docdir@/manual.txt
The Mutt manual.
.SH BUGS
.PP
None.  Mutts have fleas, not bugs.
.SH FLEAS
.PP
Suspend/resume while editing a file with an external editor does not work
under SunOS 4.x if you use the curses lib in /usr/5lib.  It \fIdoes\fP work
with the S-Lang library, however.
.PP
Resizing the screen while using an external pager causes Mutt to go haywire
on some systems.
.PP
Suspend/resume does not work under Ultrix.
.PP
The help line for the index menu is not updated if you change the bindings
for one of the functions listed while Mutt is running.
.PP
For a more up-to-date list of bugs, errm, fleas, please visit the
mutt project's bug tracking system under https://gitlab.com/muttmua/mutt/issues.
.SH NO WARRANTIES
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
.SH SEE ALSO
.PP
.BR mutt_dotlock (1),
.BR mutt_pgpring (1),
.BR pgpewrap (1),
.BR sendmail (1),
.BR smail (1),
.BR smime_keys (1),
.BR curses (3),
.BR ncurses (3),
.BR mailcap (5),
.BR maildir (5),
.BR mbox (5),
.BR mmdf (5),
.BR muttrc (5)
.PP
Mutt Home Page: http://www.mutt.org/
.PP
The Mutt manual
.PP
RFC5322 \(em Internet Message Format: https://tools.ietf.org/rfcmarkup/5322
(obsoletes RFC2822 and RFC822)
.SH AUTHOR
.PP
Michael Elkins, and others.
Use <mutt-dev@mutt.org> to contact the developers.
