/*
 * vim:noexpandtab:shiftwidth=8:tabstop=8:
 *
 * Contributeur: Sachin Bhamare sbhamare@panasas.com
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 3 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 * -------------
 */

/**
 * @file    os/freebsd/memstream.h
 * @brief   Set of functions to provide platform dependent memstream APIs
 */

#ifndef MEMSTREAM_FREEBSD_H
#define MEMSTREAM_FREEBSD_H

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include <sys/types.h>

struct memstream {
	char **cp;
	size_t *lenp;
	size_t offset;
};

FILE *open_memstream(char **cp, size_t *lenp);

#endif /* MEMSTREAM_FREEBSD_H */
