/* gkr-item.c generated by valac 0.28.0, the Vala compiler
 * generated from gkr-item.vala, do not modify */

/*
 * Seahorse
 *
 * Copyright (C) 2006 Stefan Walter
 * Copyright (C) 2011 Collabora Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include "seahorse-gkr.h"
#include <stdlib.h>
#include <string.h>
#include <libsecret/secret.h>
#include <gio/gio.h>
#include "seahorse-common.h"
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>


#define SEAHORSE_GKR_TYPE_DISPLAY_INFO (seahorse_gkr_display_info_get_type ())
typedef struct _SeahorseGkrDisplayInfo SeahorseGkrDisplayInfo;
#define _g_free0(var) (var = (g_free (var), NULL))

#define SEAHORSE_GKR_TYPE_DISPLAY_ENTRY (seahorse_gkr_display_entry_get_type ())
typedef struct _SeahorseGkrDisplayEntry SeahorseGkrDisplayEntry;
#define _secret_value_unref0(var) ((var == NULL) ? NULL : (var = (secret_value_unref (var), NULL)))
#define _seahorse_gkr_display_info_free0(var) ((var == NULL) ? NULL : (var = (seahorse_gkr_display_info_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define SEAHORSE_GKR_TYPE_ITEM_DELETER (seahorse_gkr_item_deleter_get_type ())
#define SEAHORSE_GKR_ITEM_DELETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SEAHORSE_GKR_TYPE_ITEM_DELETER, SeahorseGkrItemDeleter))
#define SEAHORSE_GKR_ITEM_DELETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SEAHORSE_GKR_TYPE_ITEM_DELETER, SeahorseGkrItemDeleterClass))
#define SEAHORSE_GKR_IS_ITEM_DELETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SEAHORSE_GKR_TYPE_ITEM_DELETER))
#define SEAHORSE_GKR_IS_ITEM_DELETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SEAHORSE_GKR_TYPE_ITEM_DELETER))
#define SEAHORSE_GKR_ITEM_DELETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SEAHORSE_GKR_TYPE_ITEM_DELETER, SeahorseGkrItemDeleterClass))

typedef struct _SeahorseGkrItemDeleter SeahorseGkrItemDeleter;
typedef struct _SeahorseGkrItemDeleterClass SeahorseGkrItemDeleterClass;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _SeahorseGkrItemSetSecretData SeahorseGkrItemSetSecretData;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_match_info_free0(var) ((var == NULL) ? NULL : (var = (g_match_info_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

#define SEAHORSE_GKR_TYPE_MAPPING_ENTRY (seahorse_gkr_mapping_entry_get_type ())
typedef struct _SeahorseGkrMappingEntry SeahorseGkrMappingEntry;
typedef struct _SeahorseGkrItemDeleterPrivate SeahorseGkrItemDeleterPrivate;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _SeahorseGkrItemDeleterDeleteData SeahorseGkrItemDeleterDeleteData;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _SeahorseGkrDisplayInfo {
	gchar* item_type;
	gchar* label;
	gchar* details;
	gchar* description;
};

typedef void (*SeahorseGkrDisplayCustom) (const gchar* label, GHashTable* item_attrs, SeahorseGkrDisplayInfo* info);
struct _SeahorseGkrDisplayEntry {
	gchar* item_type;
	gchar* description;
	SeahorseGkrDisplayCustom custom_func;
};

struct _SeahorseGkrItemPrivate {
	SecretValue* _item_secret;
	SeahorseGkrDisplayInfo* _info;
	GWeakRef _place;
	GCancellable* _req_secret;
};

struct _SeahorseGkrItemSetSecretData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SeahorseGkrItem* self;
	SecretValue* value;
	GCancellable* cancellable;
	gboolean result;
	SecretValue* _tmp0_;
	GCancellable* _tmp1_;
	SecretValue* _tmp2_;
	SecretValue* _tmp3_;
	GError * _inner_error_;
};

struct _SeahorseGkrMappingEntry {
	gchar* item_type;
	gchar* mapped_type;
	gchar* match_attribute;
	gchar* match_pattern;
};

struct _SeahorseGkrItemDeleter {
	SeahorseDeleter parent_instance;
	SeahorseGkrItemDeleterPrivate * priv;
};

struct _SeahorseGkrItemDeleterClass {
	SeahorseDeleterClass parent_class;
};

struct _SeahorseGkrItemDeleterPrivate {
	GList* _items;
};

struct _SeahorseGkrItemDeleterDeleteData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SeahorseGkrItemDeleter* self;
	GCancellable* cancellable;
	gboolean result;
	GList* items;
	GList* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	GList* item_collection;
	GList* item_it;
	SeahorseGkrItem* item;
	SeahorseGkrItem* _tmp3_;
	GCancellable* _tmp4_;
	GError * _inner_error_;
};


static gpointer seahorse_gkr_item_parent_class = NULL;
static SeahorseDeletableIface* seahorse_gkr_item_seahorse_deletable_parent_iface = NULL;
static SeahorseViewableIface* seahorse_gkr_item_seahorse_viewable_parent_iface = NULL;
static gpointer seahorse_gkr_item_deleter_parent_class = NULL;

GType seahorse_gkr_display_info_get_type (void) G_GNUC_CONST;
SeahorseGkrDisplayInfo* seahorse_gkr_display_info_dup (const SeahorseGkrDisplayInfo* self);
void seahorse_gkr_display_info_free (SeahorseGkrDisplayInfo* self);
void seahorse_gkr_display_info_copy (const SeahorseGkrDisplayInfo* self, SeahorseGkrDisplayInfo* dest);
void seahorse_gkr_display_info_destroy (SeahorseGkrDisplayInfo* self);
GType seahorse_gkr_display_entry_get_type (void) G_GNUC_CONST;
SeahorseGkrDisplayEntry* seahorse_gkr_display_entry_dup (const SeahorseGkrDisplayEntry* self);
void seahorse_gkr_display_entry_free (SeahorseGkrDisplayEntry* self);
void seahorse_gkr_display_entry_copy (const SeahorseGkrDisplayEntry* self, SeahorseGkrDisplayEntry* dest);
void seahorse_gkr_display_entry_destroy (SeahorseGkrDisplayEntry* self);
#define SEAHORSE_GKR_ITEM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SEAHORSE_GKR_TYPE_ITEM, SeahorseGkrItemPrivate))
enum  {
	SEAHORSE_GKR_ITEM_DUMMY_PROPERTY,
	SEAHORSE_GKR_ITEM_DESCRIPTION,
	SEAHORSE_GKR_ITEM_USE,
	SEAHORSE_GKR_ITEM_HAS_SECRET,
	SEAHORSE_GKR_ITEM_PLACE,
	SEAHORSE_GKR_ITEM_OBJECT_FLAGS,
	SEAHORSE_GKR_ITEM_ICON,
	SEAHORSE_GKR_ITEM_LABEL,
	SEAHORSE_GKR_ITEM_MARKUP,
	SEAHORSE_GKR_ITEM_USAGE,
	SEAHORSE_GKR_ITEM_ACTIONS,
	SEAHORSE_GKR_ITEM_DELETABLE
};
static void seahorse_gkr_item_real_dispose (GObject* base);
static SeahorseDeleter* seahorse_gkr_item_real_create_deleter (SeahorseDeletable* base);
SeahorseGkrItemDeleter* seahorse_gkr_item_deleter_new (SeahorseGkrItem* item);
SeahorseGkrItemDeleter* seahorse_gkr_item_deleter_construct (GType object_type, SeahorseGkrItem* item);
GType seahorse_gkr_item_deleter_get_type (void) G_GNUC_CONST;
static GtkWindow* seahorse_gkr_item_real_create_viewer (SeahorseViewable* base, GtkWindow* parent);
static void seahorse_gkr_item_ensure_display_info (SeahorseGkrItem* self);
gchar* seahorse_gkr_get_attribute_string (GHashTable* attrs, const gchar* name);
gchar* seahorse_gkr_map_item_type_to_specific (const gchar* item_type, GHashTable* attrs);
#define SEAHORSE_GKR_GENERIC_SECRET "org.freedesktop.Secret.Generic"
#define SEAHORSE_GKR_NETWORK_PASSWORD "org.gnome.keyring.NetworkPassword"
void seahorse_gkr_network_custom (const gchar* display, GHashTable* attrs, SeahorseGkrDisplayInfo* info);
static void _seahorse_gkr_network_custom_seahorse_gkr_display_custom (const gchar* label, GHashTable* item_attrs, SeahorseGkrDisplayInfo* info);
#define SEAHORSE_GKR_KEYRING_NOTE "org.gnome.keyring.Note"
#define SEAHORSE_GKR_CHAINED_KEYRING "org.gnome.keyring.ChainedKeyring"
#define SEAHORSE_GKR_ENCRYPTION_KEY "org.gnome.keyring.EncryptionKey"
#define SEAHORSE_GKR_PK_STORAGE "org.gnome.keyring.PkStorage"
#define SEAHORSE_GKR_CHROME_PASSWORD "x.internal.Chrome"
void seahorse_gkr_chrome_custom (const gchar* display, GHashTable* attrs, SeahorseGkrDisplayInfo* info);
static void _seahorse_gkr_chrome_custom_seahorse_gkr_display_custom (const gchar* label, GHashTable* item_attrs, SeahorseGkrDisplayInfo* info);
#define SEAHORSE_GKR_GOA_PASSWORD "org.gnome.OnlineAccounts"
#define SEAHORSE_GKR_TELEPATHY_PASSWORD "org.freedesktop.Telepathy"
void seahorse_gkr_telepathy_custom (const gchar* display, GHashTable* attrs, SeahorseGkrDisplayInfo* info);
static void _seahorse_gkr_telepathy_custom_seahorse_gkr_display_custom (const gchar* label, GHashTable* item_attrs, SeahorseGkrDisplayInfo* info);
#define SEAHORSE_GKR_EMPATHY_PASSWORD "org.freedesktop.Empathy"
void seahorse_gkr_empathy_custom (const gchar* display, GHashTable* attrs, SeahorseGkrDisplayInfo* info);
static void _seahorse_gkr_empathy_custom_seahorse_gkr_display_custom (const gchar* label, GHashTable* item_attrs, SeahorseGkrDisplayInfo* info);
#define SEAHORSE_GKR_NETWORK_MANAGER_SECRET "org.freedesktop.NetworkManager"
static void seahorse_gkr_item_load_item_secret (SeahorseGkrItem* self);
static void ___lambda20_ (SeahorseGkrItem* self, GObject* obj, GAsyncResult* res);
static void ____lambda20__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void seahorse_gkr_item_set_secret_data_free (gpointer _data);
static gboolean seahorse_gkr_item_set_secret_co (SeahorseGkrItemSetSecretData* _data_);
static void seahorse_gkr_item_set_secret_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static GObject * seahorse_gkr_item_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _seahorse_gkr_item___lambda30_ (SeahorseGkrItem* self, GVariant* changed_properties, gchar** invalidated_properties, int invalidated_properties_length1);
static void __seahorse_gkr_item___lambda30__g_dbus_proxy_g_properties_changed (GDBusProxy* _sender, GVariant* changed_properties, gchar** invalidated_properties, gpointer self);
static void seahorse_gkr_item_finalize (GObject* obj);
static void _vala_seahorse_gkr_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_seahorse_gkr_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
gint seahorse_gkr_get_attribute_int (GHashTable* attrs, const gchar* name);
gboolean seahorse_gkr_is_network_item (GHashTable* attrs, const gchar* match);
gboolean seahorse_gkr_is_custom_network_label (const gchar* server, const gchar* user, const gchar* object, gint port, const gchar* display);
gchar* seahorse_gkr_calc_network_label (GHashTable* attrs, gboolean always);
gchar* seahorse_gkr_decode_telepathy_id (const gchar* account);
GType seahorse_gkr_mapping_entry_get_type (void) G_GNUC_CONST;
SeahorseGkrMappingEntry* seahorse_gkr_mapping_entry_dup (const SeahorseGkrMappingEntry* self);
void seahorse_gkr_mapping_entry_free (SeahorseGkrMappingEntry* self);
void seahorse_gkr_mapping_entry_copy (const SeahorseGkrMappingEntry* self, SeahorseGkrMappingEntry* dest);
void seahorse_gkr_mapping_entry_destroy (SeahorseGkrMappingEntry* self);
#define SEAHORSE_GKR_ITEM_DELETER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SEAHORSE_GKR_TYPE_ITEM_DELETER, SeahorseGkrItemDeleterPrivate))
enum  {
	SEAHORSE_GKR_ITEM_DELETER_DUMMY_PROPERTY
};
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static GtkDialog* seahorse_gkr_item_deleter_real_create_confirm (SeahorseDeleter* base, GtkWindow* parent);
static GList* seahorse_gkr_item_deleter_real_get_objects (SeahorseDeleter* base);
static gboolean seahorse_gkr_item_deleter_real_add_object (SeahorseDeleter* base, GObject* obj);
static void seahorse_gkr_item_deleter_real_delete_data_free (gpointer _data);
static void seahorse_gkr_item_deleter_real_delete (SeahorseDeleter* base, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean seahorse_gkr_item_deleter_real_delete_co (SeahorseGkrItemDeleterDeleteData* _data_);
static void seahorse_gkr_item_deleter_delete_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void seahorse_gkr_item_deleter_finalize (GObject* obj);
static gint _vala_array_length (gpointer array);

const SeahorseGkrDisplayEntry SEAHORSE_GKR_DISPLAY_ENTRIES[11] = {{SEAHORSE_GKR_GENERIC_SECRET, "Password or secret", NULL}, {SEAHORSE_GKR_NETWORK_PASSWORD, "Network password", _seahorse_gkr_network_custom_seahorse_gkr_display_custom}, {SEAHORSE_GKR_KEYRING_NOTE, "Stored note", NULL}, {SEAHORSE_GKR_CHAINED_KEYRING, "Keyring password", NULL}, {SEAHORSE_GKR_ENCRYPTION_KEY, "Encryption key password", NULL}, {SEAHORSE_GKR_PK_STORAGE, "Key storage password", NULL}, {SEAHORSE_GKR_CHROME_PASSWORD, "Google Chrome password", _seahorse_gkr_chrome_custom_seahorse_gkr_display_custom}, {SEAHORSE_GKR_GOA_PASSWORD, "Gnome Online Accounts password", NULL}, {SEAHORSE_GKR_TELEPATHY_PASSWORD, "Telepathy password", _seahorse_gkr_telepathy_custom_seahorse_gkr_display_custom}, {SEAHORSE_GKR_EMPATHY_PASSWORD, "Instant messaging password", _seahorse_gkr_empathy_custom_seahorse_gkr_display_custom}, {SEAHORSE_GKR_NETWORK_MANAGER_SECRET, "Network Manager secret", NULL}};
const SeahorseGkrMappingEntry SEAHORSE_GKR_MAPPING_ENTRIES[5] = {{SEAHORSE_GKR_GENERIC_SECRET, SEAHORSE_GKR_CHROME_PASSWORD, "application", "chrome*"}, {SEAHORSE_GKR_GENERIC_SECRET, SEAHORSE_GKR_GOA_PASSWORD, "goa-identity", NULL}, {SEAHORSE_GKR_GENERIC_SECRET, SEAHORSE_GKR_TELEPATHY_PASSWORD, "account", "*/*/*"}, {SEAHORSE_GKR_GENERIC_SECRET, SEAHORSE_GKR_EMPATHY_PASSWORD, "account-id", "*/*/*"}, {SEAHORSE_GKR_GENERIC_SECRET, SEAHORSE_GKR_NETWORK_MANAGER_SECRET, "connection-uuid", NULL}};

GType seahorse_gkr_use_get_type (void) {
	static volatile gsize seahorse_gkr_use_type_id__volatile = 0;
	if (g_once_init_enter (&seahorse_gkr_use_type_id__volatile)) {
		static const GEnumValue values[] = {{SEAHORSE_GKR_USE_OTHER, "SEAHORSE_GKR_USE_OTHER", "other"}, {SEAHORSE_GKR_USE_NETWORK, "SEAHORSE_GKR_USE_NETWORK", "network"}, {SEAHORSE_GKR_USE_WEB, "SEAHORSE_GKR_USE_WEB", "web"}, {SEAHORSE_GKR_USE_PGP, "SEAHORSE_GKR_USE_PGP", "pgp"}, {SEAHORSE_GKR_USE_SSH, "SEAHORSE_GKR_USE_SSH", "ssh"}, {0, NULL, NULL}};
		GType seahorse_gkr_use_type_id;
		seahorse_gkr_use_type_id = g_enum_register_static ("SeahorseGkrUse", values);
		g_once_init_leave (&seahorse_gkr_use_type_id__volatile, seahorse_gkr_use_type_id);
	}
	return seahorse_gkr_use_type_id__volatile;
}


void seahorse_gkr_display_info_copy (const SeahorseGkrDisplayInfo* self, SeahorseGkrDisplayInfo* dest) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	_tmp0_ = (*self).item_type;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).item_type);
	(*dest).item_type = _tmp1_;
	_tmp2_ = (*self).label;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).label);
	(*dest).label = _tmp3_;
	_tmp4_ = (*self).details;
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 ((*dest).details);
	(*dest).details = _tmp5_;
	_tmp6_ = (*self).description;
	_tmp7_ = g_strdup (_tmp6_);
	_g_free0 ((*dest).description);
	(*dest).description = _tmp7_;
}


void seahorse_gkr_display_info_destroy (SeahorseGkrDisplayInfo* self) {
	_g_free0 ((*self).item_type);
	_g_free0 ((*self).label);
	_g_free0 ((*self).details);
	_g_free0 ((*self).description);
}


SeahorseGkrDisplayInfo* seahorse_gkr_display_info_dup (const SeahorseGkrDisplayInfo* self) {
	SeahorseGkrDisplayInfo* dup;
	dup = g_new0 (SeahorseGkrDisplayInfo, 1);
	seahorse_gkr_display_info_copy (self, dup);
	return dup;
}


void seahorse_gkr_display_info_free (SeahorseGkrDisplayInfo* self) {
	seahorse_gkr_display_info_destroy (self);
	g_free (self);
}


GType seahorse_gkr_display_info_get_type (void) {
	static volatile gsize seahorse_gkr_display_info_type_id__volatile = 0;
	if (g_once_init_enter (&seahorse_gkr_display_info_type_id__volatile)) {
		GType seahorse_gkr_display_info_type_id;
		seahorse_gkr_display_info_type_id = g_boxed_type_register_static ("SeahorseGkrDisplayInfo", (GBoxedCopyFunc) seahorse_gkr_display_info_dup, (GBoxedFreeFunc) seahorse_gkr_display_info_free);
		g_once_init_leave (&seahorse_gkr_display_info_type_id__volatile, seahorse_gkr_display_info_type_id);
	}
	return seahorse_gkr_display_info_type_id__volatile;
}


void seahorse_gkr_display_entry_copy (const SeahorseGkrDisplayEntry* self, SeahorseGkrDisplayEntry* dest) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	SeahorseGkrDisplayCustom _tmp4_ = NULL;
	_tmp0_ = (*self).item_type;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).item_type);
	(*dest).item_type = _tmp1_;
	_tmp2_ = (*self).description;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).description);
	(*dest).description = _tmp3_;
	_tmp4_ = (*self).custom_func;
	(*dest).custom_func = _tmp4_;
}


void seahorse_gkr_display_entry_destroy (SeahorseGkrDisplayEntry* self) {
	_g_free0 ((*self).item_type);
	_g_free0 ((*self).description);
}


SeahorseGkrDisplayEntry* seahorse_gkr_display_entry_dup (const SeahorseGkrDisplayEntry* self) {
	SeahorseGkrDisplayEntry* dup;
	dup = g_new0 (SeahorseGkrDisplayEntry, 1);
	seahorse_gkr_display_entry_copy (self, dup);
	return dup;
}


void seahorse_gkr_display_entry_free (SeahorseGkrDisplayEntry* self) {
	seahorse_gkr_display_entry_destroy (self);
	g_free (self);
}


GType seahorse_gkr_display_entry_get_type (void) {
	static volatile gsize seahorse_gkr_display_entry_type_id__volatile = 0;
	if (g_once_init_enter (&seahorse_gkr_display_entry_type_id__volatile)) {
		GType seahorse_gkr_display_entry_type_id;
		seahorse_gkr_display_entry_type_id = g_boxed_type_register_static ("SeahorseGkrDisplayEntry", (GBoxedCopyFunc) seahorse_gkr_display_entry_dup, (GBoxedFreeFunc) seahorse_gkr_display_entry_free);
		g_once_init_leave (&seahorse_gkr_display_entry_type_id__volatile, seahorse_gkr_display_entry_type_id);
	}
	return seahorse_gkr_display_entry_type_id__volatile;
}


static void seahorse_gkr_item_real_dispose (GObject* base) {
	SeahorseGkrItem * self;
	GCancellable* _tmp0_ = NULL;
	self = (SeahorseGkrItem*) base;
	_tmp0_ = self->priv->_req_secret;
	if (_tmp0_ != NULL) {
		GCancellable* _tmp1_ = NULL;
		_tmp1_ = self->priv->_req_secret;
		g_cancellable_cancel (_tmp1_);
	}
	_g_object_unref0 (self->priv->_req_secret);
	self->priv->_req_secret = NULL;
	G_OBJECT_CLASS (seahorse_gkr_item_parent_class)->dispose ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, secret_item_get_type (), SecretItem));
}


static SeahorseDeleter* seahorse_gkr_item_real_create_deleter (SeahorseDeletable* base) {
	SeahorseGkrItem * self;
	SeahorseDeleter* result = NULL;
	SeahorseGkrItemDeleter* _tmp0_ = NULL;
	self = (SeahorseGkrItem*) base;
	_tmp0_ = seahorse_gkr_item_deleter_new (self);
	result = (SeahorseDeleter*) _tmp0_;
	return result;
}


static GtkWindow* seahorse_gkr_item_real_create_viewer (SeahorseViewable* base, GtkWindow* parent) {
	SeahorseGkrItem * self;
	GtkWindow* result = NULL;
	GtkWindow* _tmp0_ = NULL;
	SeahorseGkrItemProperties* _tmp1_ = NULL;
	self = (SeahorseGkrItem*) base;
	_tmp0_ = parent;
	_tmp1_ = seahorse_gkr_item_properties_new (self, _tmp0_);
	g_object_ref_sink (_tmp1_);
	result = (GtkWindow*) _tmp1_;
	return result;
}


static gpointer _seahorse_gkr_display_info_dup0 (gpointer self) {
	return self ? seahorse_gkr_display_info_dup (self) : NULL;
}


static void _seahorse_gkr_network_custom_seahorse_gkr_display_custom (const gchar* label, GHashTable* item_attrs, SeahorseGkrDisplayInfo* info) {
	seahorse_gkr_network_custom (label, item_attrs, info);
}


static void _seahorse_gkr_chrome_custom_seahorse_gkr_display_custom (const gchar* label, GHashTable* item_attrs, SeahorseGkrDisplayInfo* info) {
	seahorse_gkr_chrome_custom (label, item_attrs, info);
}


static void _seahorse_gkr_telepathy_custom_seahorse_gkr_display_custom (const gchar* label, GHashTable* item_attrs, SeahorseGkrDisplayInfo* info) {
	seahorse_gkr_telepathy_custom (label, item_attrs, info);
}


static void _seahorse_gkr_empathy_custom_seahorse_gkr_display_custom (const gchar* label, GHashTable* item_attrs, SeahorseGkrDisplayInfo* info) {
	seahorse_gkr_empathy_custom (label, item_attrs, info);
}


static void seahorse_gkr_item_ensure_display_info (SeahorseGkrItem* self) {
	SeahorseGkrDisplayInfo* _tmp0_ = NULL;
	SeahorseGkrDisplayInfo _tmp1_ = {0};
	SeahorseGkrDisplayInfo _tmp2_ = {0};
	SeahorseGkrDisplayInfo* _tmp3_ = NULL;
	GHashTable* attrs = NULL;
	GHashTable* _tmp4_ = NULL;
	GHashTable* _tmp5_ = NULL;
	gchar* item_type = NULL;
	GHashTable* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	GHashTable* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	SeahorseGkrDisplayInfo* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gchar* label = NULL;
	gchar* _tmp15_ = NULL;
	SeahorseGkrDisplayInfo* _tmp32_ = NULL;
	const gchar* _tmp33_ = NULL;
	SeahorseGkrDisplayInfo* _tmp37_ = NULL;
	const gchar* _tmp38_ = NULL;
	SeahorseGkrDisplayInfo* _tmp41_ = NULL;
	const gchar* _tmp42_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_info;
	if (_tmp0_ != NULL) {
		return;
	}
	memset (&_tmp1_, 0, sizeof (SeahorseGkrDisplayInfo));
	_tmp2_ = _tmp1_;
	_tmp3_ = _seahorse_gkr_display_info_dup0 (&_tmp2_);
	_seahorse_gkr_display_info_free0 (self->priv->_info);
	self->priv->_info = _tmp3_;
	seahorse_gkr_display_info_destroy (&_tmp2_);
	g_object_get ((SecretItem*) self, "attributes", &_tmp4_, NULL);
	_tmp5_ = _tmp4_;
	attrs = _tmp5_;
	_tmp6_ = attrs;
	_tmp7_ = seahorse_gkr_get_attribute_string (_tmp6_, "xdg:schema");
	item_type = _tmp7_;
	_tmp8_ = item_type;
	_tmp9_ = attrs;
	_tmp10_ = seahorse_gkr_map_item_type_to_specific (_tmp8_, _tmp9_);
	_g_free0 (item_type);
	item_type = _tmp10_;
	_tmp11_ = item_type;
	_vala_assert (_tmp11_ != NULL, "item_type != null");
	_tmp12_ = self->priv->_info;
	_tmp13_ = item_type;
	_tmp14_ = g_strdup (_tmp13_);
	_g_free0 ((*_tmp12_).item_type);
	(*_tmp12_).item_type = _tmp14_;
	_tmp15_ = secret_item_get_label (G_TYPE_CHECK_INSTANCE_CAST (self, secret_item_get_type (), SecretItem));
	label = _tmp15_;
	{
		SeahorseGkrDisplayEntry* entry_collection = NULL;
		gint entry_collection_length1 = 0;
		gint _entry_collection_size_ = 0;
		gint entry_it = 0;
		entry_collection = SEAHORSE_GKR_DISPLAY_ENTRIES;
		entry_collection_length1 = G_N_ELEMENTS (SEAHORSE_GKR_DISPLAY_ENTRIES);
		for (entry_it = 0; entry_it < G_N_ELEMENTS (SEAHORSE_GKR_DISPLAY_ENTRIES); entry_it = entry_it + 1) {
			SeahorseGkrDisplayEntry entry = {0};
			entry = entry_collection[entry_it];
			{
				SeahorseGkrDisplayEntry _tmp16_ = {0};
				const gchar* _tmp17_ = NULL;
				const gchar* _tmp18_ = NULL;
				_tmp16_ = entry;
				_tmp17_ = _tmp16_.item_type;
				_tmp18_ = item_type;
				if (g_strcmp0 (_tmp17_, _tmp18_) == 0) {
					SeahorseGkrDisplayEntry _tmp19_ = {0};
					SeahorseGkrDisplayCustom _tmp20_ = NULL;
					SeahorseGkrDisplayInfo* _tmp25_ = NULL;
					const gchar* _tmp26_ = NULL;
					_tmp19_ = entry;
					_tmp20_ = _tmp19_.custom_func;
					if (_tmp20_ != NULL) {
						SeahorseGkrDisplayEntry _tmp21_ = {0};
						SeahorseGkrDisplayCustom _tmp22_ = NULL;
						const gchar* _tmp23_ = NULL;
						GHashTable* _tmp24_ = NULL;
						_tmp21_ = entry;
						_tmp22_ = _tmp21_.custom_func;
						_tmp23_ = label;
						_tmp24_ = attrs;
						_tmp22_ (_tmp23_, _tmp24_, self->priv->_info);
					}
					_tmp25_ = self->priv->_info;
					_tmp26_ = (*_tmp25_).description;
					if (_tmp26_ == NULL) {
						SeahorseGkrDisplayInfo* _tmp27_ = NULL;
						SeahorseGkrDisplayEntry _tmp28_ = {0};
						const gchar* _tmp29_ = NULL;
						const gchar* _tmp30_ = NULL;
						gchar* _tmp31_ = NULL;
						_tmp27_ = self->priv->_info;
						_tmp28_ = entry;
						_tmp29_ = _tmp28_.description;
						_tmp30_ = _ (_tmp29_);
						_tmp31_ = g_strdup (_tmp30_);
						_g_free0 ((*_tmp27_).description);
						(*_tmp27_).description = _tmp31_;
					}
					break;
				}
			}
		}
	}
	_tmp32_ = self->priv->_info;
	_tmp33_ = (*_tmp32_).label;
	if (_tmp33_ == NULL) {
		SeahorseGkrDisplayInfo* _tmp34_ = NULL;
		const gchar* _tmp35_ = NULL;
		gchar* _tmp36_ = NULL;
		_tmp34_ = self->priv->_info;
		_tmp35_ = label;
		_tmp36_ = g_strdup (_tmp35_);
		_g_free0 ((*_tmp34_).label);
		(*_tmp34_).label = _tmp36_;
	}
	_tmp37_ = self->priv->_info;
	_tmp38_ = (*_tmp37_).label;
	if (_tmp38_ == NULL) {
		SeahorseGkrDisplayInfo* _tmp39_ = NULL;
		gchar* _tmp40_ = NULL;
		_tmp39_ = self->priv->_info;
		_tmp40_ = g_strdup ("");
		_g_free0 ((*_tmp39_).label);
		(*_tmp39_).label = _tmp40_;
	}
	_tmp41_ = self->priv->_info;
	_tmp42_ = (*_tmp41_).details;
	if (_tmp42_ == NULL) {
		SeahorseGkrDisplayInfo* _tmp43_ = NULL;
		gchar* _tmp44_ = NULL;
		_tmp43_ = self->priv->_info;
		_tmp44_ = g_strdup ("");
		_g_free0 ((*_tmp43_).details);
		(*_tmp43_).details = _tmp44_;
	}
	_g_free0 (label);
	_g_free0 (item_type);
	_g_hash_table_unref0 (attrs);
}


static void ___lambda20_ (SeahorseGkrItem* self, GObject* obj, GAsyncResult* res) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (res != NULL);
	{
		GAsyncResult* _tmp0_ = NULL;
		SecretValue* _tmp1_ = NULL;
		_g_object_unref0 (self->priv->_req_secret);
		self->priv->_req_secret = NULL;
		_tmp0_ = res;
		secret_item_load_secret_finish ((SecretItem*) self, _tmp0_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch2_g_error;
		}
		_tmp1_ = secret_item_get_secret (G_TYPE_CHECK_INSTANCE_CAST (self, secret_item_get_type (), SecretItem));
		_secret_value_unref0 (self->priv->_item_secret);
		self->priv->_item_secret = _tmp1_;
		g_object_notify ((GObject*) self, "has-secret");
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* err = NULL;
		GError* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = err;
		_tmp3_ = _tmp2_->message;
		g_warning ("gkr-item.vala:190: Couldn't retrieve secret: %s", _tmp3_);
		_g_error_free0 (err);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ____lambda20__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	___lambda20_ ((SeahorseGkrItem*) self, source_object, res);
	g_object_unref (self);
}


static void seahorse_gkr_item_load_item_secret (SeahorseGkrItem* self) {
	GCancellable* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_req_secret;
	if (_tmp0_ == NULL) {
		GCancellable* _tmp1_ = NULL;
		GCancellable* _tmp2_ = NULL;
		_tmp1_ = g_cancellable_new ();
		_g_object_unref0 (self->priv->_req_secret);
		self->priv->_req_secret = _tmp1_;
		_tmp2_ = self->priv->_req_secret;
		secret_item_load_secret ((SecretItem*) self, _tmp2_, ____lambda20__gasync_ready_callback, g_object_ref (self));
	}
}


void seahorse_gkr_item_refresh (SeahorseGkrItem* self) {
	SecretValue* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	secret_item_refresh (G_TYPE_CHECK_INSTANCE_CAST (self, secret_item_get_type (), SecretItem));
	_tmp0_ = self->priv->_item_secret;
	if (_tmp0_ != NULL) {
		seahorse_gkr_item_load_item_secret (self);
	}
}


static gpointer _secret_value_ref0 (gpointer self) {
	return self ? secret_value_ref (self) : NULL;
}


SecretValue* seahorse_gkr_item_get_secret (SeahorseGkrItem* self) {
	SecretValue* result = NULL;
	SecretValue* _tmp0_ = NULL;
	SecretValue* _tmp1_ = NULL;
	SecretValue* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_item_secret;
	if (_tmp0_ == NULL) {
		seahorse_gkr_item_load_item_secret (self);
	}
	_tmp1_ = self->priv->_item_secret;
	_tmp2_ = _secret_value_ref0 (_tmp1_);
	result = _tmp2_;
	return result;
}


gchar* seahorse_gkr_item_get_attribute (SeahorseGkrItem* self, const gchar* name) {
	gchar* result = NULL;
	GHashTable* _tmp0_ = NULL;
	GHashTable* _tmp1_ = NULL;
	GHashTable* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GHashTable* _tmp4_ = NULL;
	GHashTable* _tmp5_ = NULL;
	GHashTable* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gconstpointer _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_object_get ((SecretItem*) self, "attributes", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_ == NULL;
	_g_hash_table_unref0 (_tmp2_);
	if (_tmp3_) {
		result = NULL;
		return result;
	}
	g_object_get ((SecretItem*) self, "attributes", &_tmp4_, NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_;
	_tmp7_ = name;
	_tmp8_ = g_hash_table_lookup (_tmp6_, _tmp7_);
	_tmp9_ = g_strdup ((const gchar*) _tmp8_);
	_tmp10_ = _tmp9_;
	_g_hash_table_unref0 (_tmp6_);
	result = _tmp10_;
	return result;
}


static void seahorse_gkr_item_set_secret_data_free (gpointer _data) {
	SeahorseGkrItemSetSecretData* _data_;
	_data_ = _data;
	_secret_value_unref0 (_data_->value);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (SeahorseGkrItemSetSecretData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void seahorse_gkr_item_set_secret (SeahorseGkrItem* self, SecretValue* value, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SeahorseGkrItemSetSecretData* _data_;
	SeahorseGkrItem* _tmp0_ = NULL;
	SecretValue* _tmp1_ = NULL;
	SecretValue* _tmp2_ = NULL;
	GCancellable* _tmp3_ = NULL;
	GCancellable* _tmp4_ = NULL;
	_data_ = g_slice_new0 (SeahorseGkrItemSetSecretData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, seahorse_gkr_item_set_secret);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, seahorse_gkr_item_set_secret_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = value;
	_tmp2_ = _secret_value_ref0 (_tmp1_);
	_secret_value_unref0 (_data_->value);
	_data_->value = _tmp2_;
	_tmp3_ = cancellable;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp4_;
	seahorse_gkr_item_set_secret_co (_data_);
}


gboolean seahorse_gkr_item_set_secret_finish (SeahorseGkrItem* self, GAsyncResult* _res_, GError** error) {
	gboolean result;
	SeahorseGkrItemSetSecretData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return FALSE;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static void seahorse_gkr_item_set_secret_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SeahorseGkrItemSetSecretData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	seahorse_gkr_item_set_secret_co (_data_);
}


static gboolean seahorse_gkr_item_set_secret_co (SeahorseGkrItemSetSecretData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->value;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->cancellable;
	_data_->_state_ = 1;
	secret_item_set_secret (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, secret_item_get_type (), SecretItem), _data_->_tmp0_, _data_->_tmp1_, seahorse_gkr_item_set_secret_ready, _data_);
	return FALSE;
	_state_1:
	secret_item_set_secret_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, secret_item_get_type (), SecretItem), _data_->_res_, &_data_->_inner_error_);
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->value;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _secret_value_ref0 (_data_->_tmp2_);
	_secret_value_unref0 (_data_->self->priv->_item_secret);
	_data_->self->priv->_item_secret = _data_->_tmp3_;
	g_object_notify ((GObject*) _data_->self, "has-secret");
	_data_->result = TRUE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


SeahorseGkrItem* seahorse_gkr_item_construct (GType object_type) {
	SeahorseGkrItem * self = NULL;
	self = (SeahorseGkrItem*) g_object_new (object_type, NULL);
	return self;
}


SeahorseGkrItem* seahorse_gkr_item_new (void) {
	return seahorse_gkr_item_construct (SEAHORSE_GKR_TYPE_ITEM);
}


gchar* seahorse_gkr_item_get_description (SeahorseGkrItem* self) {
	gchar* result;
	SeahorseGkrDisplayInfo* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	seahorse_gkr_item_ensure_display_info (self);
	_tmp0_ = self->priv->_info;
	_tmp1_ = (*_tmp0_).description;
	_tmp2_ = g_strdup (_tmp1_);
	result = _tmp2_;
	return result;
}


SeahorseGkrUse seahorse_gkr_item_get_use (SeahorseGkrItem* self) {
	SeahorseGkrUse result;
	gchar* schema_name = NULL;
	gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = seahorse_gkr_item_get_attribute (self, "xdg:schema");
	schema_name = _tmp0_;
	_tmp2_ = schema_name;
	if (_tmp2_ != NULL) {
		const gchar* _tmp3_ = NULL;
		_tmp3_ = schema_name;
		_tmp1_ = g_strcmp0 (_tmp3_, SEAHORSE_GKR_NETWORK_PASSWORD) == 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		result = SEAHORSE_GKR_USE_NETWORK;
		_g_free0 (schema_name);
		return result;
	}
	result = SEAHORSE_GKR_USE_OTHER;
	_g_free0 (schema_name);
	return result;
}


gboolean seahorse_gkr_item_get_has_secret (SeahorseGkrItem* self) {
	gboolean result;
	SecretValue* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_item_secret;
	result = _tmp0_ != NULL;
	return result;
}


SeahorseGkrKeyring* seahorse_gkr_item_get_place (SeahorseGkrItem* self) {
	SeahorseGkrKeyring* result;
	GObject* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_weak_ref_get (&self->priv->_place);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, SEAHORSE_GKR_TYPE_KEYRING, SeahorseGkrKeyring);
	return result;
}


void seahorse_gkr_item_set_place (SeahorseGkrItem* self, SeahorseGkrKeyring* value) {
	SeahorseGkrKeyring* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	g_weak_ref_set (&self->priv->_place, (GObject*) _tmp0_);
	g_object_notify ((GObject *) self, "place");
}


SeahorseFlags seahorse_gkr_item_get_object_flags (SeahorseGkrItem* self) {
	SeahorseFlags result;
	g_return_val_if_fail (self != NULL, 0);
	result = SEAHORSE_FLAG_DELETABLE | SEAHORSE_FLAG_PERSONAL;
	return result;
}


GIcon* seahorse_gkr_item_get_icon (SeahorseGkrItem* self) {
	GIcon* result;
	GThemedIcon* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (GThemedIcon*) g_themed_icon_new (SEAHORSE_ICON_PASSWORD);
	result = (GIcon*) _tmp0_;
	return result;
}


gchar* seahorse_gkr_item_get_label (SeahorseGkrItem* self) {
	gchar* result;
	SeahorseGkrDisplayInfo* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	seahorse_gkr_item_ensure_display_info (self);
	_tmp0_ = self->priv->_info;
	_tmp1_ = (*_tmp0_).label;
	_tmp2_ = g_strdup (_tmp1_);
	result = _tmp2_;
	return result;
}


gchar* seahorse_gkr_item_get_markup (SeahorseGkrItem* self) {
	gchar* result;
	GString* _result_ = NULL;
	GString* _tmp0_ = NULL;
	SeahorseGkrDisplayInfo* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	SeahorseGkrDisplayInfo* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	seahorse_gkr_item_ensure_display_info (self);
	_tmp0_ = g_string_new ("");
	_result_ = _tmp0_;
	_tmp1_ = self->priv->_info;
	_tmp2_ = (*_tmp1_).label;
	_tmp3_ = g_markup_escape_text (_tmp2_, (gssize) (-1));
	_tmp4_ = _tmp3_;
	g_string_append (_result_, _tmp4_);
	_g_free0 (_tmp4_);
	g_string_append (_result_, "<span size='small' rise='0' foreground='#555555'>\n");
	_tmp5_ = self->priv->_info;
	_tmp6_ = (*_tmp5_).details;
	g_string_append (_result_, _tmp6_);
	g_string_append (_result_, "</span>");
	_tmp7_ = _result_->str;
	_tmp8_ = g_strdup (_tmp7_);
	result = _tmp8_;
	_g_string_free0 (_result_);
	return result;
}


SeahorseUsage seahorse_gkr_item_get_usage (SeahorseGkrItem* self) {
	SeahorseUsage result;
	g_return_val_if_fail (self != NULL, 0);
	result = SEAHORSE_USAGE_CREDENTIALS;
	return result;
}


GtkActionGroup* seahorse_gkr_item_get_actions (SeahorseGkrItem* self) {
	GtkActionGroup* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = NULL;
	return result;
}


static gboolean seahorse_gkr_item_real_get_deletable (SeahorseDeletable* base) {
	gboolean result;
	SeahorseGkrItem* self;
	self = (SeahorseGkrItem*) base;
	result = TRUE;
	return result;
}


static void _seahorse_gkr_item___lambda30_ (SeahorseGkrItem* self, GVariant* changed_properties, gchar** invalidated_properties, int invalidated_properties_length1) {
	g_return_if_fail (changed_properties != NULL);
	_seahorse_gkr_display_info_free0 (self->priv->_info);
	self->priv->_info = NULL;
	g_object_freeze_notify ((GObject*) self);
	g_object_notify ((GObject*) self, "has-secret");
	g_object_notify ((GObject*) self, "use");
	g_object_notify ((GObject*) self, "label");
	g_object_notify ((GObject*) self, "icon");
	g_object_notify ((GObject*) self, "markup");
	g_object_notify ((GObject*) self, "description");
	g_object_notify ((GObject*) self, "object-flags");
	g_object_thaw_notify ((GObject*) self);
}


static void __seahorse_gkr_item___lambda30__g_dbus_proxy_g_properties_changed (GDBusProxy* _sender, GVariant* changed_properties, gchar** invalidated_properties, gpointer self) {
	_seahorse_gkr_item___lambda30_ ((SeahorseGkrItem*) self, changed_properties, invalidated_properties, _vala_array_length (invalidated_properties));
}


static GObject * seahorse_gkr_item_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	SeahorseGkrItem * self;
	parent_class = G_OBJECT_CLASS (seahorse_gkr_item_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_GKR_TYPE_ITEM, SeahorseGkrItem);
	g_signal_connect_object ((GDBusProxy*) self, "g-properties-changed", (GCallback) __seahorse_gkr_item___lambda30__g_dbus_proxy_g_properties_changed, self, 0);
	return obj;
}


static void seahorse_gkr_item_class_init (SeahorseGkrItemClass * klass) {
	seahorse_gkr_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SeahorseGkrItemPrivate));
	((GObjectClass *) klass)->dispose = seahorse_gkr_item_real_dispose;
	G_OBJECT_CLASS (klass)->get_property = _vala_seahorse_gkr_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_seahorse_gkr_item_set_property;
	G_OBJECT_CLASS (klass)->constructor = seahorse_gkr_item_constructor;
	G_OBJECT_CLASS (klass)->finalize = seahorse_gkr_item_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_ITEM_DESCRIPTION, g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_ITEM_USE, g_param_spec_enum ("use", "use", "use", SEAHORSE_GKR_TYPE_USE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_ITEM_HAS_SECRET, g_param_spec_boolean ("has-secret", "has-secret", "has-secret", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_ITEM_PLACE, g_param_spec_object ("place", "place", "place", SEAHORSE_GKR_TYPE_KEYRING, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_ITEM_OBJECT_FLAGS, g_param_spec_flags ("object-flags", "object-flags", "object-flags", SEAHORSE_TYPE_FLAGS, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_ITEM_ICON, g_param_spec_object ("icon", "icon", "icon", G_TYPE_ICON, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_ITEM_LABEL, g_param_spec_string ("label", "label", "label", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_ITEM_MARKUP, g_param_spec_string ("markup", "markup", "markup", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_ITEM_USAGE, g_param_spec_enum ("usage", "usage", "usage", SEAHORSE_TYPE_USAGE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_ITEM_ACTIONS, g_param_spec_object ("actions", "actions", "actions", gtk_action_group_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_GKR_ITEM_DELETABLE, g_param_spec_boolean ("deletable", "deletable", "deletable", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void seahorse_gkr_item_seahorse_deletable_interface_init (SeahorseDeletableIface * iface) {
	seahorse_gkr_item_seahorse_deletable_parent_iface = g_type_interface_peek_parent (iface);
	iface->create_deleter = (SeahorseDeleter* (*)(SeahorseDeletable*)) seahorse_gkr_item_real_create_deleter;
	iface->get_deletable = seahorse_gkr_item_real_get_deletable;
}


static void seahorse_gkr_item_seahorse_viewable_interface_init (SeahorseViewableIface * iface) {
	seahorse_gkr_item_seahorse_viewable_parent_iface = g_type_interface_peek_parent (iface);
	iface->create_viewer = (GtkWindow* (*)(SeahorseViewable*, GtkWindow*)) seahorse_gkr_item_real_create_viewer;
}


static void seahorse_gkr_item_instance_init (SeahorseGkrItem * self) {
	self->priv = SEAHORSE_GKR_ITEM_GET_PRIVATE (self);
	self->priv->_item_secret = NULL;
	self->priv->_info = NULL;
	self->priv->_req_secret = NULL;
}


static void seahorse_gkr_item_finalize (GObject* obj) {
	SeahorseGkrItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_GKR_TYPE_ITEM, SeahorseGkrItem);
	_secret_value_unref0 (self->priv->_item_secret);
	_seahorse_gkr_display_info_free0 (self->priv->_info);
	g_weak_ref_clear (&self->priv->_place);
	_g_object_unref0 (self->priv->_req_secret);
	G_OBJECT_CLASS (seahorse_gkr_item_parent_class)->finalize (obj);
}


GType seahorse_gkr_item_get_type (void) {
	static volatile gsize seahorse_gkr_item_type_id__volatile = 0;
	if (g_once_init_enter (&seahorse_gkr_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SeahorseGkrItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) seahorse_gkr_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SeahorseGkrItem), 0, (GInstanceInitFunc) seahorse_gkr_item_instance_init, NULL };
		static const GInterfaceInfo seahorse_deletable_info = { (GInterfaceInitFunc) seahorse_gkr_item_seahorse_deletable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo seahorse_viewable_info = { (GInterfaceInitFunc) seahorse_gkr_item_seahorse_viewable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType seahorse_gkr_item_type_id;
		seahorse_gkr_item_type_id = g_type_register_static (secret_item_get_type (), "SeahorseGkrItem", &g_define_type_info, 0);
		g_type_add_interface_static (seahorse_gkr_item_type_id, SEAHORSE_TYPE_DELETABLE, &seahorse_deletable_info);
		g_type_add_interface_static (seahorse_gkr_item_type_id, SEAHORSE_TYPE_VIEWABLE, &seahorse_viewable_info);
		g_once_init_leave (&seahorse_gkr_item_type_id__volatile, seahorse_gkr_item_type_id);
	}
	return seahorse_gkr_item_type_id__volatile;
}


static void _vala_seahorse_gkr_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SeahorseGkrItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_GKR_TYPE_ITEM, SeahorseGkrItem);
	switch (property_id) {
		case SEAHORSE_GKR_ITEM_DESCRIPTION:
		g_value_take_string (value, seahorse_gkr_item_get_description (self));
		break;
		case SEAHORSE_GKR_ITEM_USE:
		g_value_set_enum (value, seahorse_gkr_item_get_use (self));
		break;
		case SEAHORSE_GKR_ITEM_HAS_SECRET:
		g_value_set_boolean (value, seahorse_gkr_item_get_has_secret (self));
		break;
		case SEAHORSE_GKR_ITEM_PLACE:
		g_value_take_object (value, seahorse_gkr_item_get_place (self));
		break;
		case SEAHORSE_GKR_ITEM_OBJECT_FLAGS:
		g_value_set_flags (value, seahorse_gkr_item_get_object_flags (self));
		break;
		case SEAHORSE_GKR_ITEM_ICON:
		g_value_take_object (value, seahorse_gkr_item_get_icon (self));
		break;
		case SEAHORSE_GKR_ITEM_LABEL:
		g_value_take_string (value, seahorse_gkr_item_get_label (self));
		break;
		case SEAHORSE_GKR_ITEM_MARKUP:
		g_value_take_string (value, seahorse_gkr_item_get_markup (self));
		break;
		case SEAHORSE_GKR_ITEM_USAGE:
		g_value_set_enum (value, seahorse_gkr_item_get_usage (self));
		break;
		case SEAHORSE_GKR_ITEM_ACTIONS:
		g_value_set_object (value, seahorse_gkr_item_get_actions (self));
		break;
		case SEAHORSE_GKR_ITEM_DELETABLE:
		g_value_set_boolean (value, seahorse_deletable_get_deletable ((SeahorseDeletable*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_seahorse_gkr_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SeahorseGkrItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_GKR_TYPE_ITEM, SeahorseGkrItem);
	switch (property_id) {
		case SEAHORSE_GKR_ITEM_PLACE:
		seahorse_gkr_item_set_place (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


gchar* seahorse_gkr_get_attribute_string (GHashTable* attrs, const gchar* name) {
	gchar* result = NULL;
	GHashTable* _tmp0_ = NULL;
	GHashTable* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gconstpointer _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = attrs;
	if (_tmp0_ == NULL) {
		result = NULL;
		return result;
	}
	_tmp1_ = attrs;
	_tmp2_ = name;
	_tmp3_ = g_hash_table_lookup (_tmp1_, _tmp2_);
	_tmp4_ = g_strdup ((const gchar*) _tmp3_);
	result = _tmp4_;
	return result;
}


gint seahorse_gkr_get_attribute_int (GHashTable* attrs, const gchar* name) {
	gint result = 0;
	GHashTable* _tmp0_ = NULL;
	gchar* value = NULL;
	GHashTable* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gconstpointer _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	g_return_val_if_fail (name != NULL, 0);
	_tmp0_ = attrs;
	if (_tmp0_ == NULL) {
		result = 0;
		return result;
	}
	_tmp1_ = attrs;
	_tmp2_ = name;
	_tmp3_ = g_hash_table_lookup (_tmp1_, _tmp2_);
	_tmp4_ = g_strdup ((const gchar*) _tmp3_);
	value = _tmp4_;
	_tmp5_ = value;
	if (_tmp5_ != NULL) {
		const gchar* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		_tmp6_ = value;
		_tmp7_ = atoi (_tmp6_);
		result = _tmp7_;
		_g_free0 (value);
		return result;
	}
	result = 0;
	_g_free0 (value);
	return result;
}


gboolean seahorse_gkr_is_network_item (GHashTable* attrs, const gchar* match) {
	gboolean result = FALSE;
	gchar* protocol = NULL;
	GHashTable* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_ = NULL;
	g_return_val_if_fail (match != NULL, FALSE);
	_tmp0_ = attrs;
	_tmp1_ = seahorse_gkr_get_attribute_string (_tmp0_, "protocol");
	protocol = _tmp1_;
	_tmp3_ = protocol;
	if (_tmp3_ != NULL) {
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		_tmp4_ = protocol;
		_tmp5_ = match;
		_tmp6_ = g_ascii_strcasecmp (_tmp4_, _tmp5_);
		_tmp2_ = _tmp6_ == 0;
	} else {
		_tmp2_ = FALSE;
	}
	result = _tmp2_;
	_g_free0 (protocol);
	return result;
}


gboolean seahorse_gkr_is_custom_network_label (const gchar* server, const gchar* user, const gchar* object, gint port, const gchar* display) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	GString* generated = NULL;
	GString* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GString* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	const gchar* _tmp10_ = NULL;
	GString* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	_tmp0_ = server;
	if (_tmp0_ == NULL) {
		result = TRUE;
		return result;
	}
	_tmp1_ = g_string_new ("");
	generated = _tmp1_;
	_tmp2_ = user;
	if (_tmp2_ != NULL) {
		GString* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		_tmp3_ = generated;
		_tmp4_ = user;
		g_string_append_printf (_tmp3_, "%s@", _tmp4_);
	}
	_tmp5_ = generated;
	_tmp6_ = server;
	g_string_append (_tmp5_, _tmp6_);
	_tmp7_ = port;
	if (_tmp7_ != 0) {
		GString* _tmp8_ = NULL;
		gint _tmp9_ = 0;
		_tmp8_ = generated;
		_tmp9_ = port;
		g_string_append_printf (_tmp8_, ":%d", _tmp9_);
	}
	_tmp10_ = object;
	if (_tmp10_ != NULL) {
		GString* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		_tmp11_ = generated;
		_tmp12_ = object;
		g_string_append_printf (_tmp11_, "/%s", _tmp12_);
	}
	_tmp13_ = generated;
	_tmp14_ = _tmp13_->str;
	_tmp15_ = display;
	result = g_strcmp0 (_tmp14_, _tmp15_) == 0;
	_g_string_free0 (generated);
	return result;
}


gchar* seahorse_gkr_calc_network_label (GHashTable* attrs, gboolean always) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	GHashTable* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	_tmp1_ = attrs;
	_tmp2_ = seahorse_gkr_is_network_item (_tmp1_, "http");
	if (_tmp2_) {
		GHashTable* _tmp3_ = NULL;
		_tmp3_ = attrs;
		_tmp0_ = _tmp3_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar* val = NULL;
		GHashTable* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
		const gchar* _tmp7_ = NULL;
		gboolean _tmp9_ = FALSE;
		_tmp4_ = attrs;
		_tmp5_ = seahorse_gkr_get_attribute_string (_tmp4_, "object");
		val = _tmp5_;
		_tmp7_ = val;
		if (_tmp7_ != NULL) {
			const gchar* _tmp8_ = NULL;
			_tmp8_ = val;
			_tmp6_ = g_strcmp0 (_tmp8_, "") != 0;
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			result = val;
			return result;
		}
		_tmp9_ = always;
		if (_tmp9_) {
			GHashTable* _tmp10_ = NULL;
			gchar* _tmp11_ = NULL;
			gboolean _tmp12_ = FALSE;
			const gchar* _tmp13_ = NULL;
			_tmp10_ = attrs;
			_tmp11_ = seahorse_gkr_get_attribute_string (_tmp10_, "server");
			_g_free0 (val);
			val = _tmp11_;
			_tmp13_ = val;
			if (_tmp13_ != NULL) {
				const gchar* _tmp14_ = NULL;
				_tmp14_ = val;
				_tmp12_ = g_strcmp0 (_tmp14_, "") != 0;
			} else {
				_tmp12_ = FALSE;
			}
			if (_tmp12_) {
				result = val;
				return result;
			}
		}
		_g_free0 (val);
	}
	result = NULL;
	return result;
}


void seahorse_gkr_network_custom (const gchar* display, GHashTable* attrs, SeahorseGkrDisplayInfo* info) {
	gchar* server = NULL;
	GHashTable* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* protocol = NULL;
	GHashTable* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* object = NULL;
	GHashTable* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* user = NULL;
	GHashTable* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gint port = 0;
	GHashTable* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	const gchar* _tmp15_ = NULL;
	gboolean _tmp16_ = FALSE;
	SeahorseGkrDisplayInfo _tmp19_ = {0};
	const gchar* _tmp20_ = NULL;
	gchar* symbol = NULL;
	gchar* _tmp23_ = NULL;
	const gchar* _tmp24_ = NULL;
	const gchar* _tmp27_ = NULL;
	gboolean _tmp29_ = FALSE;
	const gchar* _tmp30_ = NULL;
	g_return_if_fail (info != NULL);
	_tmp0_ = attrs;
	_tmp1_ = seahorse_gkr_get_attribute_string (_tmp0_, "server");
	server = _tmp1_;
	_tmp2_ = attrs;
	_tmp3_ = seahorse_gkr_get_attribute_string (_tmp2_, "protocol");
	protocol = _tmp3_;
	_tmp4_ = attrs;
	_tmp5_ = seahorse_gkr_get_attribute_string (_tmp4_, "object");
	object = _tmp5_;
	_tmp6_ = attrs;
	_tmp7_ = seahorse_gkr_get_attribute_string (_tmp6_, "user");
	user = _tmp7_;
	_tmp8_ = attrs;
	_tmp9_ = seahorse_gkr_get_attribute_int (_tmp8_, "port");
	port = _tmp9_;
	_tmp10_ = protocol;
	if (_tmp10_ == NULL) {
		_g_free0 (user);
		_g_free0 (object);
		_g_free0 (protocol);
		_g_free0 (server);
		return;
	}
	_tmp11_ = server;
	_tmp12_ = user;
	_tmp13_ = object;
	_tmp14_ = port;
	_tmp15_ = display;
	_tmp16_ = seahorse_gkr_is_custom_network_label (_tmp11_, _tmp12_, _tmp13_, _tmp14_, _tmp15_);
	if (!_tmp16_) {
		GHashTable* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		_tmp17_ = attrs;
		_tmp18_ = seahorse_gkr_calc_network_label (_tmp17_, TRUE);
		_g_free0 ((*info).label);
		(*info).label = _tmp18_;
	}
	_tmp19_ = *info;
	_tmp20_ = _tmp19_.label;
	if (_tmp20_ == NULL) {
		const gchar* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
		_tmp21_ = display;
		_tmp22_ = g_strdup (_tmp21_);
		_g_free0 ((*info).label);
		(*info).label = _tmp22_;
	}
	_tmp23_ = g_strdup ("@");
	symbol = _tmp23_;
	_tmp24_ = user;
	if (_tmp24_ == NULL) {
		gchar* _tmp25_ = NULL;
		gchar* _tmp26_ = NULL;
		_tmp25_ = g_strdup ("");
		_g_free0 (user);
		user = _tmp25_;
		_tmp26_ = g_strdup ("");
		_g_free0 (symbol);
		symbol = _tmp26_;
	}
	_tmp27_ = object;
	if (_tmp27_ == NULL) {
		gchar* _tmp28_ = NULL;
		_tmp28_ = g_strdup ("");
		_g_free0 (object);
		object = _tmp28_;
	}
	_tmp30_ = server;
	if (_tmp30_ != NULL) {
		const gchar* _tmp31_ = NULL;
		_tmp31_ = protocol;
		_tmp29_ = _tmp31_ != NULL;
	} else {
		_tmp29_ = FALSE;
	}
	if (_tmp29_) {
		const gchar* _tmp32_ = NULL;
		const gchar* _tmp33_ = NULL;
		const gchar* _tmp34_ = NULL;
		const gchar* _tmp35_ = NULL;
		const gchar* _tmp36_ = NULL;
		gchar* _tmp37_ = NULL;
		_tmp32_ = protocol;
		_tmp33_ = user;
		_tmp34_ = symbol;
		_tmp35_ = server;
		_tmp36_ = object;
		_tmp37_ = g_markup_printf_escaped ("%s://%s%s%s/%s", _tmp32_, _tmp33_, _tmp34_, _tmp35_, _tmp36_);
		_g_free0 ((*info).details);
		(*info).details = _tmp37_;
	}
	_g_free0 (symbol);
	_g_free0 (user);
	_g_free0 (object);
	_g_free0 (protocol);
	_g_free0 (server);
}


void seahorse_gkr_chrome_custom (const gchar* display, GHashTable* attrs, SeahorseGkrDisplayInfo* info) {
	gchar* origin = NULL;
	GHashTable* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_ = NULL;
	SeahorseGkrDisplayInfo _tmp17_ = {0};
	const gchar* _tmp18_ = NULL;
	const gchar* _tmp21_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (info != NULL);
	_tmp0_ = attrs;
	_tmp1_ = seahorse_gkr_get_attribute_string (_tmp0_, "origin_url");
	origin = _tmp1_;
	_tmp3_ = display;
	if (_tmp3_ != NULL) {
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		_tmp4_ = display;
		_tmp5_ = origin;
		_tmp2_ = g_strcmp0 (_tmp4_, _tmp5_) == 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		{
			GRegex* regex = NULL;
			GRegex* _tmp6_ = NULL;
			GMatchInfo* match = NULL;
			GRegex* _tmp7_ = NULL;
			const gchar* _tmp8_ = NULL;
			GMatchInfo* _tmp9_ = NULL;
			gboolean _tmp10_ = FALSE;
			_tmp6_ = g_regex_new ("[a-z]+://([^/]+)/", G_REGEX_CASELESS, 0, &_inner_error_);
			regex = _tmp6_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == G_REGEX_ERROR) {
					goto __catch3_g_regex_error;
				}
				_g_free0 (origin);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			_tmp7_ = regex;
			_tmp8_ = display;
			_tmp10_ = g_regex_match (_tmp7_, _tmp8_, G_REGEX_MATCH_ANCHORED, &_tmp9_);
			_g_match_info_free0 (match);
			match = _tmp9_;
			if (_tmp10_) {
				GMatchInfo* _tmp11_ = NULL;
				gboolean _tmp12_ = FALSE;
				_tmp11_ = match;
				_tmp12_ = g_match_info_matches (_tmp11_);
				if (_tmp12_) {
					GMatchInfo* _tmp13_ = NULL;
					gchar* _tmp14_ = NULL;
					_tmp13_ = match;
					_tmp14_ = g_match_info_fetch (_tmp13_, 1);
					_g_free0 ((*info).label);
					(*info).label = _tmp14_;
				}
			}
			_g_match_info_free0 (match);
			_g_regex_unref0 (regex);
		}
		goto __finally3;
		__catch3_g_regex_error:
		{
			GError* err = NULL;
			GError* _tmp15_ = NULL;
			const gchar* _tmp16_ = NULL;
			err = _inner_error_;
			_inner_error_ = NULL;
			_tmp15_ = err;
			_tmp16_ = _tmp15_->message;
			g_critical ("gkr-item.vala:362: %s", _tmp16_);
			_g_error_free0 (err);
			_g_free0 (origin);
			return;
		}
		__finally3:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (origin);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp17_ = *info;
	_tmp18_ = _tmp17_.label;
	if (_tmp18_ == NULL) {
		const gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		_tmp19_ = display;
		_tmp20_ = g_strdup (_tmp19_);
		_g_free0 ((*info).label);
		(*info).label = _tmp20_;
	}
	_tmp21_ = origin;
	if (_tmp21_ != NULL) {
		const gchar* _tmp22_ = NULL;
		gchar* _tmp23_ = NULL;
		_tmp22_ = origin;
		_tmp23_ = g_markup_escape_text (_tmp22_, (gssize) (-1));
		_g_free0 ((*info).details);
		(*info).details = _tmp23_;
	} else {
		gchar* _tmp24_ = NULL;
		_tmp24_ = g_strdup ("");
		_g_free0 ((*info).details);
		(*info).details = _tmp24_;
	}
	_g_free0 (origin);
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch4_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp6_ = regex;
		_tmp7_ = replacement;
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) (-1), 0, _tmp7_, 0, &_inner_error_);
		_tmp5_ = _tmp8_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch4_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp9_ = _tmp5_;
		_tmp5_ = NULL;
		result = _tmp9_;
		_g_free0 (_tmp5_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally4;
	__catch4_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally4:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


gchar* seahorse_gkr_decode_telepathy_id (const gchar* account) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	g_return_val_if_fail (account != NULL, NULL);
	_tmp0_ = account;
	_tmp1_ = string_replace (_tmp0_, "_", "%");
	_tmp2_ = _tmp1_;
	_g_free0 (_tmp2_);
	_tmp3_ = account;
	_tmp4_ = g_uri_unescape_string (_tmp3_, NULL);
	result = _tmp4_;
	return result;
}


static gint string_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	gunichar _tmp1_ = 0U;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = c;
	_tmp2_ = g_utf8_strchr (((gchar*) self) + _tmp0_, (gssize) (-1), _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_ = NULL;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	glong _tmp2_ = 0L;
	glong _tmp5_ = 0L;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_ = 0L;
	gboolean _tmp12_ = FALSE;
	glong _tmp13_ = 0L;
	glong _tmp16_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	gchar* _tmp21_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_ = 0L;
		glong _tmp7_ = 0L;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	g_return_val_if_fail (_tmp8_, NULL);
	_tmp13_ = end;
	if (_tmp13_ >= ((glong) 0)) {
		glong _tmp14_ = 0L;
		glong _tmp15_ = 0L;
		_tmp14_ = end;
		_tmp15_ = string_length;
		_tmp12_ = _tmp14_ <= _tmp15_;
	} else {
		_tmp12_ = FALSE;
	}
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp16_ = start;
	_tmp17_ = end;
	g_return_val_if_fail (_tmp16_ <= _tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	_tmp20_ = start;
	_tmp21_ = g_strndup (((gchar*) self) + _tmp18_, (gsize) (_tmp19_ - _tmp20_));
	result = _tmp21_;
	return result;
}


void seahorse_gkr_empathy_custom (const gchar* display, GHashTable* attrs, SeahorseGkrDisplayInfo* info) {
	gchar* account = NULL;
	GHashTable* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* prefix = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_ = NULL;
	SeahorseGkrDisplayInfo _tmp33_ = {0};
	const gchar* _tmp34_ = NULL;
	SeahorseGkrDisplayInfo _tmp37_ = {0};
	const gchar* _tmp38_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (info != NULL);
	_tmp0_ = attrs;
	_tmp1_ = seahorse_gkr_get_attribute_string (_tmp0_, "account-id");
	account = _tmp1_;
	_tmp2_ = _ ("IM account password for ");
	_tmp3_ = g_strdup (_tmp2_);
	prefix = _tmp3_;
	_tmp5_ = display;
	if (_tmp5_ != NULL) {
		const gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
		_tmp6_ = display;
		_tmp7_ = prefix;
		_tmp8_ = g_str_has_prefix (_tmp6_, _tmp7_);
		_tmp4_ = _tmp8_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		gint len = 0;
		const gchar* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
		gint pos = 0;
		const gchar* _tmp12_ = NULL;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
		_tmp9_ = prefix;
		_tmp10_ = strlen (_tmp9_);
		_tmp11_ = _tmp10_;
		len = _tmp11_;
		_tmp12_ = display;
		_tmp13_ = len;
		_tmp14_ = string_index_of_char (_tmp12_, (gunichar) '(', (gint) _tmp13_);
		pos = _tmp14_;
		_tmp15_ = pos;
		if (_tmp15_ != (-1)) {
			const gchar* _tmp16_ = NULL;
			gint _tmp17_ = 0;
			gint _tmp18_ = 0;
			gchar* _tmp19_ = NULL;
			_tmp16_ = display;
			_tmp17_ = len;
			_tmp18_ = pos;
			_tmp19_ = string_slice (_tmp16_, (glong) _tmp17_, (glong) _tmp18_);
			_g_free0 ((*info).label);
			(*info).label = _tmp19_;
		}
		{
			GRegex* regex = NULL;
			GRegex* _tmp20_ = NULL;
			GMatchInfo* match = NULL;
			GRegex* _tmp21_ = NULL;
			const gchar* _tmp22_ = NULL;
			GMatchInfo* _tmp23_ = NULL;
			gboolean _tmp24_ = FALSE;
			_tmp20_ = g_regex_new ("^.+/.+/(.+)$", G_REGEX_CASELESS, 0, &_inner_error_);
			regex = _tmp20_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == G_REGEX_ERROR) {
					goto __catch5_g_regex_error;
				}
				_g_free0 (prefix);
				_g_free0 (account);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			_tmp21_ = regex;
			_tmp22_ = account;
			_tmp24_ = g_regex_match (_tmp21_, _tmp22_, G_REGEX_MATCH_ANCHORED, &_tmp23_);
			_g_match_info_free0 (match);
			match = _tmp23_;
			if (_tmp24_) {
				GMatchInfo* _tmp25_ = NULL;
				gboolean _tmp26_ = FALSE;
				_tmp25_ = match;
				_tmp26_ = g_match_info_matches (_tmp25_);
				if (_tmp26_) {
					GMatchInfo* _tmp27_ = NULL;
					gchar* _tmp28_ = NULL;
					gchar* _tmp29_ = NULL;
					gchar* _tmp30_ = NULL;
					_tmp27_ = match;
					_tmp28_ = g_match_info_fetch (_tmp27_, 1);
					_tmp29_ = _tmp28_;
					_tmp30_ = seahorse_gkr_decode_telepathy_id (_tmp29_);
					_g_free0 ((*info).details);
					(*info).details = _tmp30_;
					_g_free0 (_tmp29_);
				}
			}
			_g_match_info_free0 (match);
			_g_regex_unref0 (regex);
		}
		goto __finally5;
		__catch5_g_regex_error:
		{
			GError* err = NULL;
			GError* _tmp31_ = NULL;
			const gchar* _tmp32_ = NULL;
			err = _inner_error_;
			_inner_error_ = NULL;
			_tmp31_ = err;
			_tmp32_ = _tmp31_->message;
			g_critical ("gkr-item.vala:404: %s", _tmp32_);
			_g_error_free0 (err);
			_g_free0 (prefix);
			_g_free0 (account);
			return;
		}
		__finally5:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (prefix);
			_g_free0 (account);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp33_ = *info;
	_tmp34_ = _tmp33_.label;
	if (_tmp34_ == NULL) {
		const gchar* _tmp35_ = NULL;
		gchar* _tmp36_ = NULL;
		_tmp35_ = display;
		_tmp36_ = g_strdup (_tmp35_);
		_g_free0 ((*info).label);
		(*info).label = _tmp36_;
	}
	_tmp37_ = *info;
	_tmp38_ = _tmp37_.details;
	if (_tmp38_ == NULL) {
		const gchar* _tmp39_ = NULL;
		gchar* _tmp40_ = NULL;
		_tmp39_ = account;
		_tmp40_ = g_markup_escape_text (_tmp39_, (gssize) (-1));
		_g_free0 ((*info).details);
		(*info).details = _tmp40_;
	}
	_g_free0 (prefix);
	_g_free0 (account);
}


static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = needle;
	_tmp2_ = strstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_ = NULL;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


void seahorse_gkr_telepathy_custom (const gchar* display, GHashTable* attrs, SeahorseGkrDisplayInfo* info) {
	gchar* account = NULL;
	GHashTable* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_ = NULL;
	SeahorseGkrDisplayInfo _tmp22_ = {0};
	const gchar* _tmp23_ = NULL;
	const gchar* _tmp26_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (info != NULL);
	_tmp0_ = attrs;
	_tmp1_ = seahorse_gkr_get_attribute_string (_tmp0_, "account");
	account = _tmp1_;
	_tmp4_ = account;
	if (_tmp4_ != NULL) {
		const gchar* _tmp5_ = NULL;
		_tmp5_ = display;
		_tmp3_ = _tmp5_ != NULL;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		const gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		_tmp6_ = display;
		_tmp7_ = account;
		_tmp8_ = string_index_of (_tmp6_, _tmp7_, 0);
		_tmp2_ = _tmp8_ != (-1);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		{
			GRegex* regex = NULL;
			GRegex* _tmp9_ = NULL;
			GMatchInfo* match = NULL;
			GRegex* _tmp10_ = NULL;
			const gchar* _tmp11_ = NULL;
			GMatchInfo* _tmp12_ = NULL;
			gboolean _tmp13_ = FALSE;
			_tmp9_ = g_regex_new ("^.+/.+/(.+)$", G_REGEX_CASELESS, 0, &_inner_error_);
			regex = _tmp9_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == G_REGEX_ERROR) {
					goto __catch6_g_regex_error;
				}
				_g_free0 (account);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			_tmp10_ = regex;
			_tmp11_ = account;
			_tmp13_ = g_regex_match (_tmp10_, _tmp11_, G_REGEX_MATCH_ANCHORED, &_tmp12_);
			_g_match_info_free0 (match);
			match = _tmp12_;
			if (_tmp13_) {
				GMatchInfo* _tmp14_ = NULL;
				gboolean _tmp15_ = FALSE;
				_tmp14_ = match;
				_tmp15_ = g_match_info_matches (_tmp14_);
				if (_tmp15_) {
					gchar* identifier = NULL;
					GMatchInfo* _tmp16_ = NULL;
					gchar* _tmp17_ = NULL;
					const gchar* _tmp18_ = NULL;
					gchar* _tmp19_ = NULL;
					_tmp16_ = match;
					_tmp17_ = g_match_info_fetch (_tmp16_, 1);
					identifier = _tmp17_;
					_tmp18_ = identifier;
					_tmp19_ = seahorse_gkr_decode_telepathy_id (_tmp18_);
					_g_free0 ((*info).label);
					(*info).label = _tmp19_;
					_g_free0 (identifier);
				}
			}
			_g_match_info_free0 (match);
			_g_regex_unref0 (regex);
		}
		goto __finally6;
		__catch6_g_regex_error:
		{
			GError* err = NULL;
			GError* _tmp20_ = NULL;
			const gchar* _tmp21_ = NULL;
			err = _inner_error_;
			_inner_error_ = NULL;
			_tmp20_ = err;
			_tmp21_ = _tmp20_->message;
			g_critical ("gkr-item.vala:431: %s", _tmp21_);
			_g_error_free0 (err);
			_g_free0 (account);
			return;
		}
		__finally6:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (account);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp22_ = *info;
	_tmp23_ = _tmp22_.label;
	if (_tmp23_ == NULL) {
		const gchar* _tmp24_ = NULL;
		gchar* _tmp25_ = NULL;
		_tmp24_ = display;
		_tmp25_ = g_strdup (_tmp24_);
		_g_free0 ((*info).label);
		(*info).label = _tmp25_;
	}
	_tmp26_ = account;
	if (_tmp26_ != NULL) {
		const gchar* _tmp27_ = NULL;
		gchar* _tmp28_ = NULL;
		_tmp27_ = account;
		_tmp28_ = g_markup_escape_text (_tmp27_, (gssize) (-1));
		_g_free0 ((*info).details);
		(*info).details = _tmp28_;
	}
	_g_free0 (account);
}


void seahorse_gkr_mapping_entry_copy (const SeahorseGkrMappingEntry* self, SeahorseGkrMappingEntry* dest) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	_tmp0_ = (*self).item_type;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).item_type);
	(*dest).item_type = _tmp1_;
	_tmp2_ = (*self).mapped_type;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).mapped_type);
	(*dest).mapped_type = _tmp3_;
	_tmp4_ = (*self).match_attribute;
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 ((*dest).match_attribute);
	(*dest).match_attribute = _tmp5_;
	_tmp6_ = (*self).match_pattern;
	_tmp7_ = g_strdup (_tmp6_);
	_g_free0 ((*dest).match_pattern);
	(*dest).match_pattern = _tmp7_;
}


void seahorse_gkr_mapping_entry_destroy (SeahorseGkrMappingEntry* self) {
	_g_free0 ((*self).item_type);
	_g_free0 ((*self).mapped_type);
	_g_free0 ((*self).match_attribute);
	_g_free0 ((*self).match_pattern);
}


SeahorseGkrMappingEntry* seahorse_gkr_mapping_entry_dup (const SeahorseGkrMappingEntry* self) {
	SeahorseGkrMappingEntry* dup;
	dup = g_new0 (SeahorseGkrMappingEntry, 1);
	seahorse_gkr_mapping_entry_copy (self, dup);
	return dup;
}


void seahorse_gkr_mapping_entry_free (SeahorseGkrMappingEntry* self) {
	seahorse_gkr_mapping_entry_destroy (self);
	g_free (self);
}


GType seahorse_gkr_mapping_entry_get_type (void) {
	static volatile gsize seahorse_gkr_mapping_entry_type_id__volatile = 0;
	if (g_once_init_enter (&seahorse_gkr_mapping_entry_type_id__volatile)) {
		GType seahorse_gkr_mapping_entry_type_id;
		seahorse_gkr_mapping_entry_type_id = g_boxed_type_register_static ("SeahorseGkrMappingEntry", (GBoxedCopyFunc) seahorse_gkr_mapping_entry_dup, (GBoxedFreeFunc) seahorse_gkr_mapping_entry_free);
		g_once_init_leave (&seahorse_gkr_mapping_entry_type_id__volatile, seahorse_gkr_mapping_entry_type_id);
	}
	return seahorse_gkr_mapping_entry_type_id__volatile;
}


gchar* seahorse_gkr_map_item_type_to_specific (const gchar* item_type, GHashTable* attrs) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	GHashTable* _tmp2_ = NULL;
	const gchar* _tmp27_ = NULL;
	gchar* _tmp28_ = NULL;
	_tmp0_ = item_type;
	if (_tmp0_ == NULL) {
		gchar* _tmp1_ = NULL;
		_tmp1_ = g_strdup (SEAHORSE_GKR_GENERIC_SECRET);
		result = _tmp1_;
		return result;
	}
	_tmp2_ = attrs;
	if (_tmp2_ == NULL) {
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		_tmp3_ = item_type;
		_tmp4_ = g_strdup (_tmp3_);
		result = _tmp4_;
		return result;
	}
	{
		SeahorseGkrMappingEntry* mapping_collection = NULL;
		gint mapping_collection_length1 = 0;
		gint _mapping_collection_size_ = 0;
		gint mapping_it = 0;
		mapping_collection = SEAHORSE_GKR_MAPPING_ENTRIES;
		mapping_collection_length1 = G_N_ELEMENTS (SEAHORSE_GKR_MAPPING_ENTRIES);
		for (mapping_it = 0; mapping_it < G_N_ELEMENTS (SEAHORSE_GKR_MAPPING_ENTRIES); mapping_it = mapping_it + 1) {
			SeahorseGkrMappingEntry mapping = {0};
			mapping = mapping_collection[mapping_it];
			{
				const gchar* _tmp5_ = NULL;
				SeahorseGkrMappingEntry _tmp6_ = {0};
				const gchar* _tmp7_ = NULL;
				_tmp5_ = item_type;
				_tmp6_ = mapping;
				_tmp7_ = _tmp6_.item_type;
				if (g_strcmp0 (_tmp5_, _tmp7_) == 0) {
					gchar* value = NULL;
					GHashTable* _tmp8_ = NULL;
					SeahorseGkrMappingEntry _tmp9_ = {0};
					const gchar* _tmp10_ = NULL;
					gchar* _tmp11_ = NULL;
					gboolean _tmp12_ = FALSE;
					const gchar* _tmp13_ = NULL;
					_tmp8_ = attrs;
					_tmp9_ = mapping;
					_tmp10_ = _tmp9_.match_attribute;
					_tmp11_ = seahorse_gkr_get_attribute_string (_tmp8_, _tmp10_);
					value = _tmp11_;
					_tmp13_ = value;
					if (_tmp13_ != NULL) {
						SeahorseGkrMappingEntry _tmp14_ = {0};
						const gchar* _tmp15_ = NULL;
						_tmp14_ = mapping;
						_tmp15_ = _tmp14_.match_pattern;
						_tmp12_ = _tmp15_ != NULL;
					} else {
						_tmp12_ = FALSE;
					}
					if (_tmp12_) {
						SeahorseGkrMappingEntry _tmp16_ = {0};
						const gchar* _tmp17_ = NULL;
						const gchar* _tmp18_ = NULL;
						gboolean _tmp19_ = FALSE;
						_tmp16_ = mapping;
						_tmp17_ = _tmp16_.match_pattern;
						_tmp18_ = value;
						_tmp19_ = g_pattern_match_simple (_tmp17_, _tmp18_);
						if (_tmp19_) {
							SeahorseGkrMappingEntry _tmp20_ = {0};
							const gchar* _tmp21_ = NULL;
							gchar* _tmp22_ = NULL;
							_tmp20_ = mapping;
							_tmp21_ = _tmp20_.mapped_type;
							_tmp22_ = g_strdup (_tmp21_);
							result = _tmp22_;
							_g_free0 (value);
							return result;
						}
					} else {
						const gchar* _tmp23_ = NULL;
						_tmp23_ = value;
						if (_tmp23_ != NULL) {
							SeahorseGkrMappingEntry _tmp24_ = {0};
							const gchar* _tmp25_ = NULL;
							gchar* _tmp26_ = NULL;
							_tmp24_ = mapping;
							_tmp25_ = _tmp24_.mapped_type;
							_tmp26_ = g_strdup (_tmp25_);
							result = _tmp26_;
							_g_free0 (value);
							return result;
						}
					}
					_g_free0 (value);
				}
			}
		}
	}
	_tmp27_ = item_type;
	_tmp28_ = g_strdup (_tmp27_);
	result = _tmp28_;
	return result;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static GtkDialog* seahorse_gkr_item_deleter_real_create_confirm (SeahorseDeleter* base, GtkWindow* parent) {
	SeahorseGkrItemDeleter * self;
	GtkDialog* result = NULL;
	guint num = 0U;
	GList* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	self = (SeahorseGkrItemDeleter*) base;
	_tmp0_ = self->priv->_items;
	_tmp1_ = g_list_length (_tmp0_);
	num = _tmp1_;
	_tmp2_ = num;
	if (_tmp2_ == ((guint) 1)) {
		gchar* label = NULL;
		GList* _tmp3_ = NULL;
		gconstpointer _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		GtkWindow* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		SeahorseDeleteDialog* _tmp10_ = NULL;
		_tmp3_ = self->priv->_items;
		_tmp4_ = _tmp3_->data;
		g_object_get (G_TYPE_CHECK_INSTANCE_CAST ((SeahorseGkrItem*) _tmp4_, secret_item_get_type (), SecretItem), "label", &_tmp5_, NULL);
		_tmp6_ = _tmp5_;
		label = _tmp6_;
		_tmp7_ = parent;
		_tmp8_ = _ ("Are you sure you want to delete the password '%s'?");
		_tmp9_ = label;
		_tmp10_ = (SeahorseDeleteDialog*) seahorse_delete_dialog_new (_tmp7_, _tmp8_, _tmp9_, NULL);
		g_object_ref_sink (_tmp10_);
		result = (GtkDialog*) _tmp10_;
		_g_free0 (label);
		return result;
	} else {
		GtkWindow* _tmp11_ = NULL;
		guint _tmp12_ = 0U;
		const gchar* _tmp13_ = NULL;
		guint _tmp14_ = 0U;
		SeahorseDeleteDialog* _tmp15_ = NULL;
		_tmp11_ = parent;
		_tmp12_ = num;
		_tmp13_ = ngettext ("Are you sure you want to delete %d password?", "Are you sure you want to delete %d passwords?", (gulong) _tmp12_);
		_tmp14_ = num;
		_tmp15_ = (SeahorseDeleteDialog*) seahorse_delete_dialog_new (_tmp11_, _tmp13_, _tmp14_, NULL);
		g_object_ref_sink (_tmp15_);
		result = (GtkDialog*) _tmp15_;
		return result;
	}
}


SeahorseGkrItemDeleter* seahorse_gkr_item_deleter_construct (GType object_type, SeahorseGkrItem* item) {
	SeahorseGkrItemDeleter * self = NULL;
	SeahorseGkrItem* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (item != NULL, NULL);
	self = (SeahorseGkrItemDeleter*) seahorse_deleter_construct (object_type);
	_tmp0_ = item;
	_tmp1_ = seahorse_deleter_add_object ((SeahorseDeleter*) self, (GObject*) _tmp0_);
	if (!_tmp1_) {
		g_assert_not_reached ();
	}
	return self;
}


SeahorseGkrItemDeleter* seahorse_gkr_item_deleter_new (SeahorseGkrItem* item) {
	return seahorse_gkr_item_deleter_construct (SEAHORSE_GKR_TYPE_ITEM_DELETER, item);
}


static GList* seahorse_gkr_item_deleter_real_get_objects (SeahorseDeleter* base) {
	SeahorseGkrItemDeleter * self;
	GList* result = NULL;
	GList* _tmp0_ = NULL;
	self = (SeahorseGkrItemDeleter*) base;
	_tmp0_ = self->priv->_items;
	result = _tmp0_;
	return result;
}


static gboolean seahorse_gkr_item_deleter_real_add_object (SeahorseDeleter* base, GObject* obj) {
	SeahorseGkrItemDeleter * self;
	gboolean result = FALSE;
	GObject* _tmp0_ = NULL;
	self = (SeahorseGkrItemDeleter*) base;
	g_return_val_if_fail (obj != NULL, FALSE);
	_tmp0_ = obj;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, SEAHORSE_GKR_TYPE_ITEM)) {
		GObject* _tmp1_ = NULL;
		SeahorseGkrItem* _tmp2_ = NULL;
		_tmp1_ = obj;
		_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, SEAHORSE_GKR_TYPE_ITEM, SeahorseGkrItem));
		self->priv->_items = g_list_append (self->priv->_items, _tmp2_);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static void seahorse_gkr_item_deleter_real_delete_data_free (gpointer _data) {
	SeahorseGkrItemDeleterDeleteData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (SeahorseGkrItemDeleterDeleteData, _data_);
}


static void seahorse_gkr_item_deleter_real_delete (SeahorseDeleter* base, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SeahorseGkrItemDeleter * self;
	SeahorseGkrItemDeleterDeleteData* _data_;
	SeahorseGkrItemDeleter* _tmp0_ = NULL;
	GCancellable* _tmp1_ = NULL;
	GCancellable* _tmp2_ = NULL;
	self = (SeahorseGkrItemDeleter*) base;
	_data_ = g_slice_new0 (SeahorseGkrItemDeleterDeleteData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, seahorse_gkr_item_deleter_real_delete);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, seahorse_gkr_item_deleter_real_delete_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = cancellable;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	seahorse_gkr_item_deleter_real_delete_co (_data_);
}


static gboolean seahorse_gkr_item_deleter_real_delete_finish (SeahorseDeleter* base, GAsyncResult* _res_, GError** error) {
	gboolean result;
	SeahorseGkrItemDeleterDeleteData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return FALSE;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static void seahorse_gkr_item_deleter_delete_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SeahorseGkrItemDeleterDeleteData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	seahorse_gkr_item_deleter_real_delete_co (_data_);
}


static gboolean seahorse_gkr_item_deleter_real_delete_co (SeahorseGkrItemDeleterDeleteData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->self->priv->_items;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = g_list_copy (_data_->_tmp0_);
	_data_->items = _data_->_tmp1_;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->items;
	{
		_data_->item_collection = _data_->_tmp2_;
		for (_data_->item_it = _data_->item_collection; _data_->item_it != NULL; _data_->item_it = _data_->item_it->next) {
			_data_->item = (SeahorseGkrItem*) _data_->item_it->data;
			{
				_data_->_tmp3_ = NULL;
				_data_->_tmp3_ = _data_->item;
				_data_->_tmp4_ = NULL;
				_data_->_tmp4_ = _data_->cancellable;
				_data_->_state_ = 1;
				secret_item_delete ((SecretItem*) _data_->_tmp3_, _data_->_tmp4_, seahorse_gkr_item_deleter_delete_ready, _data_);
				return FALSE;
				_state_1:
				secret_item_delete_finish ((SecretItem*) _data_->_tmp3_, _data_->_res_, &_data_->_inner_error_);
				if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
					g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
					g_error_free (_data_->_inner_error_);
					_g_list_free0 (_data_->items);
					if (_data_->_state_ == 0) {
						g_simple_async_result_complete_in_idle (_data_->_async_result);
					} else {
						g_simple_async_result_complete (_data_->_async_result);
					}
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
			}
		}
	}
	_data_->result = TRUE;
	_g_list_free0 (_data_->items);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_list_free0 (_data_->items);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void seahorse_gkr_item_deleter_class_init (SeahorseGkrItemDeleterClass * klass) {
	seahorse_gkr_item_deleter_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SeahorseGkrItemDeleterPrivate));
	((SeahorseDeleterClass *) klass)->create_confirm = seahorse_gkr_item_deleter_real_create_confirm;
	((SeahorseDeleterClass *) klass)->get_objects = seahorse_gkr_item_deleter_real_get_objects;
	((SeahorseDeleterClass *) klass)->add_object = seahorse_gkr_item_deleter_real_add_object;
	((SeahorseDeleterClass *) klass)->delete = seahorse_gkr_item_deleter_real_delete;
	((SeahorseDeleterClass *) klass)->delete_finish = seahorse_gkr_item_deleter_real_delete_finish;
	G_OBJECT_CLASS (klass)->finalize = seahorse_gkr_item_deleter_finalize;
}


static void seahorse_gkr_item_deleter_instance_init (SeahorseGkrItemDeleter * self) {
	self->priv = SEAHORSE_GKR_ITEM_DELETER_GET_PRIVATE (self);
}


static void seahorse_gkr_item_deleter_finalize (GObject* obj) {
	SeahorseGkrItemDeleter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_GKR_TYPE_ITEM_DELETER, SeahorseGkrItemDeleter);
	__g_list_free__g_object_unref0_0 (self->priv->_items);
	G_OBJECT_CLASS (seahorse_gkr_item_deleter_parent_class)->finalize (obj);
}


GType seahorse_gkr_item_deleter_get_type (void) {
	static volatile gsize seahorse_gkr_item_deleter_type_id__volatile = 0;
	if (g_once_init_enter (&seahorse_gkr_item_deleter_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SeahorseGkrItemDeleterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) seahorse_gkr_item_deleter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SeahorseGkrItemDeleter), 0, (GInstanceInitFunc) seahorse_gkr_item_deleter_instance_init, NULL };
		GType seahorse_gkr_item_deleter_type_id;
		seahorse_gkr_item_deleter_type_id = g_type_register_static (SEAHORSE_TYPE_DELETER, "SeahorseGkrItemDeleter", &g_define_type_info, 0);
		g_once_init_leave (&seahorse_gkr_item_deleter_type_id__volatile, seahorse_gkr_item_deleter_type_id);
	}
	return seahorse_gkr_item_deleter_type_id__volatile;
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



