/* DirectPhoto.c generated by valac 0.36.6, the Vala compiler
 * generated from DirectPhoto.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gio/gio.h>
#include <time.h>
#include <gee.h>
#include "shotwell-graphics-processor.h"


#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;
typedef struct _DataObjectPrivate DataObjectPrivate;

#define TYPE_ALTERATION (alteration_get_type ())
#define ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ALTERATION, Alteration))
#define ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ALTERATION, AlterationClass))
#define IS_ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ALTERATION))
#define IS_ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ALTERATION))
#define ALTERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ALTERATION, AlterationClass))

typedef struct _Alteration Alteration;
typedef struct _AlterationClass AlterationClass;

#define TYPE_DATA_COLLECTION (data_collection_get_type ())
#define DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_COLLECTION, DataCollection))
#define DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_COLLECTION, DataCollectionClass))
#define IS_DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_COLLECTION))
#define IS_DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_COLLECTION))
#define DATA_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_COLLECTION, DataCollectionClass))

typedef struct _DataCollection DataCollection;
typedef struct _DataCollectionClass DataCollectionClass;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;
typedef struct _DataSourcePrivate DataSourcePrivate;

#define TYPE_SOURCE_HOLDING_TANK (source_holding_tank_get_type ())
#define SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_HOLDING_TANK, SourceHoldingTank))
#define SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_HOLDING_TANK, SourceHoldingTankClass))
#define IS_SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_HOLDING_TANK))
#define IS_SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_HOLDING_TANK))
#define SOURCE_HOLDING_TANK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_HOLDING_TANK, SourceHoldingTankClass))

typedef struct _SourceHoldingTank SourceHoldingTank;
typedef struct _SourceHoldingTankClass SourceHoldingTankClass;

#define TYPE_SOURCE_COLLECTION (source_collection_get_type ())
#define SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_COLLECTION, SourceCollection))
#define SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_COLLECTION, SourceCollectionClass))
#define IS_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_COLLECTION))
#define IS_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_COLLECTION))
#define SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_COLLECTION, SourceCollectionClass))

typedef struct _SourceCollection SourceCollection;
typedef struct _SourceCollectionClass SourceCollectionClass;

#define TYPE_SOURCE_SNAPSHOT (source_snapshot_get_type ())
#define SOURCE_SNAPSHOT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_SNAPSHOT, SourceSnapshot))
#define SOURCE_SNAPSHOT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_SNAPSHOT, SourceSnapshotClass))
#define IS_SOURCE_SNAPSHOT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_SNAPSHOT))
#define IS_SOURCE_SNAPSHOT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_SNAPSHOT))
#define SOURCE_SNAPSHOT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_SNAPSHOT, SourceSnapshotClass))

typedef struct _SourceSnapshot SourceSnapshot;
typedef struct _SourceSnapshotClass SourceSnapshotClass;

#define TYPE_THUMBNAIL_SOURCE (thumbnail_source_get_type ())
#define THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSource))
#define THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))
#define IS_THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_SOURCE))
#define IS_THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_SOURCE))
#define THUMBNAIL_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))

typedef struct _ThumbnailSource ThumbnailSource;
typedef struct _ThumbnailSourceClass ThumbnailSourceClass;
typedef struct _ThumbnailSourcePrivate ThumbnailSourcePrivate;

#define TYPE_PHOTO_FILE_FORMAT (photo_file_format_get_type ())

#define TYPE_INDEXABLE (indexable_get_type ())
#define INDEXABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_INDEXABLE, Indexable))
#define IS_INDEXABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_INDEXABLE))
#define INDEXABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_INDEXABLE, IndexableIface))

typedef struct _Indexable Indexable;
typedef struct _IndexableIface IndexableIface;

#define TYPE_MEDIA_SOURCE (media_source_get_type ())
#define MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE, MediaSource))
#define MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE, MediaSourceClass))
#define IS_MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE))
#define IS_MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE))
#define MEDIA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE, MediaSourceClass))

typedef struct _MediaSource MediaSource;
typedef struct _MediaSourceClass MediaSourceClass;
typedef struct _MediaSourcePrivate MediaSourcePrivate;

#define TYPE_EVENT_ID (event_id_get_type ())
typedef struct _EventID EventID;

#define TYPE_BACKING_FILE_STATE (backing_file_state_get_type ())
#define BACKING_FILE_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKING_FILE_STATE, BackingFileState))
#define BACKING_FILE_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKING_FILE_STATE, BackingFileStateClass))
#define IS_BACKING_FILE_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKING_FILE_STATE))
#define IS_BACKING_FILE_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKING_FILE_STATE))
#define BACKING_FILE_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKING_FILE_STATE, BackingFileStateClass))

typedef struct _BackingFileState BackingFileState;
typedef struct _BackingFileStateClass BackingFileStateClass;

#define TYPE_RATING (rating_get_type ())

#define PHOTO_TYPE_EXCEPTION (photo_exception_get_type ())

#define TYPE_DIMENSIONS (dimensions_get_type ())
typedef struct _Dimensions Dimensions;

#define TYPE_SCALING (scaling_get_type ())

#define TYPE_SCALE_CONSTRAINT (scale_constraint_get_type ())
typedef struct _Scaling Scaling;

#define TYPE_IMPORT_ID (import_id_get_type ())
typedef struct _ImportID ImportID;

#define TYPE_PHOTO_SOURCE (photo_source_get_type ())
#define PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_SOURCE, PhotoSource))
#define PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_SOURCE, PhotoSourceClass))
#define IS_PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_SOURCE))
#define IS_PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_SOURCE))
#define PHOTO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_SOURCE, PhotoSourceClass))

typedef struct _PhotoSource PhotoSource;
typedef struct _PhotoSourceClass PhotoSourceClass;
typedef struct _PhotoSourcePrivate PhotoSourcePrivate;

#define TYPE_MEDIA_METADATA (media_metadata_get_type ())
#define MEDIA_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_METADATA, MediaMetadata))
#define MEDIA_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_METADATA, MediaMetadataClass))
#define IS_MEDIA_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_METADATA))
#define IS_MEDIA_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_METADATA))
#define MEDIA_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_METADATA, MediaMetadataClass))

typedef struct _MediaMetadata MediaMetadata;
typedef struct _MediaMetadataClass MediaMetadataClass;

#define TYPE_PHOTO_METADATA (photo_metadata_get_type ())
#define PHOTO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_METADATA, PhotoMetadata))
#define PHOTO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_METADATA, PhotoMetadataClass))
#define IS_PHOTO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_METADATA))
#define IS_PHOTO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_METADATA))
#define PHOTO_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_METADATA, PhotoMetadataClass))

typedef struct _PhotoMetadata PhotoMetadata;
typedef struct _PhotoMetadataClass PhotoMetadataClass;

#define TYPE_DATEABLE (dateable_get_type ())
#define DATEABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATEABLE, Dateable))
#define IS_DATEABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATEABLE))
#define DATEABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_DATEABLE, DateableIface))

typedef struct _Dateable Dateable;
typedef struct _DateableIface DateableIface;

#define TYPE_PHOTO (photo_get_type ())
#define PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO, Photo))
#define PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO, PhotoClass))
#define IS_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO))
#define IS_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO))
#define PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO, PhotoClass))

typedef struct _Photo Photo;
typedef struct _PhotoClass PhotoClass;
typedef struct _PhotoPrivate PhotoPrivate;

#define TYPE_ROTATION (rotation_get_type ())

#define TYPE_PHOTO_ROW (photo_row_get_type ())
#define PHOTO_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_ROW, PhotoRow))
#define PHOTO_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_ROW, PhotoRowClass))
#define IS_PHOTO_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_ROW))
#define IS_PHOTO_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_ROW))
#define PHOTO_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_ROW, PhotoRowClass))

typedef struct _PhotoRow PhotoRow;
typedef struct _PhotoRowClass PhotoRowClass;

#define TYPE_BACKING_PHOTO_ROW (backing_photo_row_get_type ())
#define BACKING_PHOTO_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKING_PHOTO_ROW, BackingPhotoRow))
#define BACKING_PHOTO_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKING_PHOTO_ROW, BackingPhotoRowClass))
#define IS_BACKING_PHOTO_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKING_PHOTO_ROW))
#define IS_BACKING_PHOTO_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKING_PHOTO_ROW))
#define BACKING_PHOTO_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKING_PHOTO_ROW, BackingPhotoRowClass))

typedef struct _BackingPhotoRow BackingPhotoRow;
typedef struct _BackingPhotoRowClass BackingPhotoRowClass;

#define TYPE_DIRECT_PHOTO (direct_photo_get_type ())
#define DIRECT_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DIRECT_PHOTO, DirectPhoto))
#define DIRECT_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DIRECT_PHOTO, DirectPhotoClass))
#define IS_DIRECT_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DIRECT_PHOTO))
#define IS_DIRECT_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DIRECT_PHOTO))
#define DIRECT_PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DIRECT_PHOTO, DirectPhotoClass))

typedef struct _DirectPhoto DirectPhoto;
typedef struct _DirectPhotoClass DirectPhotoClass;
typedef struct _DirectPhotoPrivate DirectPhotoPrivate;

#define TYPE_DATABASE_SOURCE_COLLECTION (database_source_collection_get_type ())
#define DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollection))
#define DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))
#define IS_DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_SOURCE_COLLECTION))
#define IS_DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_SOURCE_COLLECTION))
#define DATABASE_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))

typedef struct _DatabaseSourceCollection DatabaseSourceCollection;
typedef struct _DatabaseSourceCollectionClass DatabaseSourceCollectionClass;

#define TYPE_DIRECT_PHOTO_SOURCE_COLLECTION (direct_photo_source_collection_get_type ())
#define DIRECT_PHOTO_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DIRECT_PHOTO_SOURCE_COLLECTION, DirectPhotoSourceCollection))
#define DIRECT_PHOTO_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DIRECT_PHOTO_SOURCE_COLLECTION, DirectPhotoSourceCollectionClass))
#define IS_DIRECT_PHOTO_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DIRECT_PHOTO_SOURCE_COLLECTION))
#define IS_DIRECT_PHOTO_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DIRECT_PHOTO_SOURCE_COLLECTION))
#define DIRECT_PHOTO_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DIRECT_PHOTO_SOURCE_COLLECTION, DirectPhotoSourceCollectionClass))

typedef struct _DirectPhotoSourceCollection DirectPhotoSourceCollection;
typedef struct _DirectPhotoSourceCollectionClass DirectPhotoSourceCollectionClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_ORIENTATION (orientation_get_type ())
typedef struct _PhotoRowPrivate PhotoRowPrivate;

#define TYPE_PHOTO_ID (photo_id_get_type ())
typedef struct _PhotoID PhotoID;

#define TYPE_BACKING_PHOTO_ID (backing_photo_id_get_type ())
typedef struct _BackingPhotoID BackingPhotoID;

#define TYPE_RAW_DEVELOPER (raw_developer_get_type ())
typedef struct _BackingPhotoRowPrivate BackingPhotoRowPrivate;
#define _data_collection_unref0(var) ((var == NULL) ? NULL : (var = (data_collection_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_BACKING_FETCH_MODE (backing_fetch_mode_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_IMPORT_RESULT (import_result_get_type ())

#define PHOTO_TYPE_REIMPORT_MASTER_STATE (photo_reimport_master_state_get_type ())
#define PHOTO_REIMPORT_MASTER_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PHOTO_TYPE_REIMPORT_MASTER_STATE, PhotoReimportMasterState))
#define PHOTO_REIMPORT_MASTER_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PHOTO_TYPE_REIMPORT_MASTER_STATE, PhotoReimportMasterStateClass))
#define PHOTO_IS_REIMPORT_MASTER_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PHOTO_TYPE_REIMPORT_MASTER_STATE))
#define PHOTO_IS_REIMPORT_MASTER_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PHOTO_TYPE_REIMPORT_MASTER_STATE))
#define PHOTO_REIMPORT_MASTER_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PHOTO_TYPE_REIMPORT_MASTER_STATE, PhotoReimportMasterStateClass))

typedef struct _PhotoReimportMasterState PhotoReimportMasterState;
typedef struct _PhotoReimportMasterStateClass PhotoReimportMasterStateClass;
#define _photo_reimport_master_state_unref0(var) ((var == NULL) ? NULL : (var = (photo_reimport_master_state_unref (var), NULL)))

#define TYPE_PHOTO_IMPORT_PARAMS (photo_import_params_get_type ())
#define PHOTO_IMPORT_PARAMS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_IMPORT_PARAMS, PhotoImportParams))
#define PHOTO_IMPORT_PARAMS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_IMPORT_PARAMS, PhotoImportParamsClass))
#define IS_PHOTO_IMPORT_PARAMS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_IMPORT_PARAMS))
#define IS_PHOTO_IMPORT_PARAMS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_IMPORT_PARAMS))
#define PHOTO_IMPORT_PARAMS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_IMPORT_PARAMS, PhotoImportParamsClass))

typedef struct _PhotoImportParams PhotoImportParams;
typedef struct _PhotoImportParamsClass PhotoImportParamsClass;

#define TYPE_DATABASE_TABLE (database_table_get_type ())
#define DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_TABLE, DatabaseTable))
#define DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_TABLE, DatabaseTableClass))
#define IS_DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_TABLE))
#define IS_DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_TABLE))
#define DATABASE_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_TABLE, DatabaseTableClass))

typedef struct _DatabaseTable DatabaseTable;
typedef struct _DatabaseTableClass DatabaseTableClass;

#define TYPE_PHOTO_TABLE (photo_table_get_type ())
#define PHOTO_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_TABLE, PhotoTable))
#define PHOTO_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_TABLE, PhotoTableClass))
#define IS_PHOTO_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_TABLE))
#define IS_PHOTO_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_TABLE))
#define PHOTO_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_TABLE, PhotoTableClass))

typedef struct _PhotoTable PhotoTable;
typedef struct _PhotoTableClass PhotoTableClass;
typedef struct _PhotoImportParamsPrivate PhotoImportParamsPrivate;

#define PHOTO_FILE_SNIFFER_TYPE_OPTIONS (photo_file_sniffer_options_get_type ())

#define TYPE_THUMBNAILS (thumbnails_get_type ())
#define THUMBNAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAILS, Thumbnails))
#define THUMBNAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAILS, ThumbnailsClass))
#define IS_THUMBNAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAILS))
#define IS_THUMBNAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAILS))
#define THUMBNAILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAILS, ThumbnailsClass))

typedef struct _Thumbnails Thumbnails;
typedef struct _ThumbnailsClass ThumbnailsClass;
#define _database_table_unref0(var) ((var == NULL) ? NULL : (var = (database_table_unref (var), NULL)))
#define _photo_import_params_unref0(var) ((var == NULL) ? NULL : (var = (photo_import_params_unref (var), NULL)))

#define TYPE_PHOTO_PREVIEW (photo_preview_get_type ())
#define PHOTO_PREVIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_PREVIEW, PhotoPreview))
#define PHOTO_PREVIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_PREVIEW, PhotoPreviewClass))
#define IS_PHOTO_PREVIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_PREVIEW))
#define IS_PHOTO_PREVIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_PREVIEW))
#define PHOTO_PREVIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_PREVIEW, PhotoPreviewClass))

typedef struct _PhotoPreview PhotoPreview;
typedef struct _PhotoPreviewClass PhotoPreviewClass;
#define _photo_preview_unref0(var) ((var == NULL) ? NULL : (var = (photo_preview_unref (var), NULL)))
#define _media_metadata_unref0(var) ((var == NULL) ? NULL : (var = (media_metadata_unref (var), NULL)))
enum  {
	DIRECT_PHOTO_CAN_ROTATE_CHANGED_SIGNAL,
	DIRECT_PHOTO_LAST_SIGNAL
};
static guint direct_photo_signals[DIRECT_PHOTO_LAST_SIGNAL] = {0};
typedef struct _DataCollectionPrivate DataCollectionPrivate;

#define TYPE_MARKER (marker_get_type ())
#define MARKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MARKER, Marker))
#define IS_MARKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MARKER))
#define MARKER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_MARKER, MarkerIface))

typedef struct _Marker Marker;
typedef struct _MarkerIface MarkerIface;
typedef struct _SourceCollectionPrivate SourceCollectionPrivate;

#define TYPE_SOURCE_BACKLINK (source_backlink_get_type ())
#define SOURCE_BACKLINK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_BACKLINK, SourceBacklink))
#define SOURCE_BACKLINK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_BACKLINK, SourceBacklinkClass))
#define IS_SOURCE_BACKLINK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_BACKLINK))
#define IS_SOURCE_BACKLINK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_BACKLINK))
#define SOURCE_BACKLINK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_BACKLINK, SourceBacklinkClass))

typedef struct _SourceBacklink SourceBacklink;
typedef struct _SourceBacklinkClass SourceBacklinkClass;
typedef struct _DatabaseSourceCollectionPrivate DatabaseSourceCollectionPrivate;
typedef struct _DirectPhotoSourceCollectionPrivate DirectPhotoSourceCollectionPrivate;

#define TYPE_DIRECTORY_MONITOR (directory_monitor_get_type ())
#define DIRECTORY_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DIRECTORY_MONITOR, DirectoryMonitor))
#define DIRECTORY_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DIRECTORY_MONITOR, DirectoryMonitorClass))
#define IS_DIRECTORY_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DIRECTORY_MONITOR))
#define IS_DIRECTORY_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DIRECTORY_MONITOR))
#define DIRECTORY_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DIRECTORY_MONITOR, DirectoryMonitorClass))

typedef struct _DirectoryMonitor DirectoryMonitor;
typedef struct _DirectoryMonitorClass DirectoryMonitorClass;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _DataObject {
	GObject parent_instance;
	DataObjectPrivate * priv;
};

struct _DataObjectClass {
	GObjectClass parent_class;
	void (*notify_altered) (DataObject* self, Alteration* alteration);
	void (*notify_membership_changed) (DataObject* self, DataCollection* collection);
	void (*notify_collection_property_set) (DataObject* self, const gchar* name, GValue* old, GValue* val);
	void (*notify_collection_property_cleared) (DataObject* self, const gchar* name);
	gchar* (*get_name) (DataObject* self);
	gchar* (*to_string) (DataObject* self);
};

struct _DataSource {
	DataObject parent_instance;
	DataSourcePrivate * priv;
};

struct _DataSourceClass {
	DataObjectClass parent_class;
	void (*notify_held_in_tank) (DataSource* self, SourceHoldingTank* holding_tank);
	void (*notify_unlinking) (DataSource* self, SourceCollection* collection);
	void (*notify_unlinked) (DataSource* self);
	void (*notify_relinking) (DataSource* self, SourceCollection* collection);
	void (*notify_relinked) (DataSource* self);
	gchar* (*get_typename) (DataSource* self);
	gint64 (*get_instance_id) (DataSource* self);
	gchar* (*get_source_id) (DataSource* self);
	void (*commit_backlinks) (DataSource* self, SourceCollection* sources, const gchar* dehydrated);
	SourceSnapshot* (*save_snapshot) (DataSource* self);
	gboolean (*internal_delete_backing) (DataSource* self, GError** error);
	gboolean (*equals) (DataSource* self, DataSource* source);
	void (*destroy) (DataSource* self);
	void (*unlinked) (DataSource* self, SourceCollection* sources);
	void (*relinked) (DataSource* self, SourceCollection* sources);
	void (*destroyed) (DataSource* self);
};

typedef enum  {
	PHOTO_FILE_FORMAT_JFIF,
	PHOTO_FILE_FORMAT_RAW,
	PHOTO_FILE_FORMAT_PNG,
	PHOTO_FILE_FORMAT_TIFF,
	PHOTO_FILE_FORMAT_BMP,
	PHOTO_FILE_FORMAT_UNKNOWN
} PhotoFileFormat;

struct _ThumbnailSource {
	DataSource parent_instance;
	ThumbnailSourcePrivate * priv;
};

struct _ThumbnailSourceClass {
	DataSourceClass parent_class;
	void (*notify_thumbnail_altered) (ThumbnailSource* self);
	GdkPixbuf* (*get_thumbnail) (ThumbnailSource* self, gint scale, GError** error);
	GdkPixbuf* (*create_thumbnail) (ThumbnailSource* self, gint scale, GError** error);
	gchar* (*get_representative_id) (ThumbnailSource* self);
	PhotoFileFormat (*get_preferred_thumbnail_format) (ThumbnailSource* self);
	void (*thumbnail_altered) (ThumbnailSource* self);
};

struct _IndexableIface {
	GTypeInterface parent_iface;
	const gchar* (*get_indexable_keywords) (Indexable* self);
};

struct _EventID {
	gint64 id;
};

typedef enum  {
	RATING_REJECTED = -1,
	RATING_UNRATED = 0,
	RATING_ONE = 1,
	RATING_TWO = 2,
	RATING_THREE = 3,
	RATING_FOUR = 4,
	RATING_FIVE = 5
} Rating;

typedef enum  {
	PHOTO_EXCEPTION_NONE = 0,
	PHOTO_EXCEPTION_ORIENTATION = 1 << 0,
	PHOTO_EXCEPTION_CROP = 1 << 1,
	PHOTO_EXCEPTION_REDEYE = 1 << 2,
	PHOTO_EXCEPTION_ADJUST = 1 << 3,
	PHOTO_EXCEPTION_STRAIGHTEN = 1 << 4,
	PHOTO_EXCEPTION_ALL = 0xFFFFFFFFLL
} PhotoException;

struct _Dimensions {
	gint width;
	gint height;
};

typedef enum  {
	SCALE_CONSTRAINT_ORIGINAL,
	SCALE_CONSTRAINT_DIMENSIONS,
	SCALE_CONSTRAINT_WIDTH,
	SCALE_CONSTRAINT_HEIGHT,
	SCALE_CONSTRAINT_FILL_VIEWPORT
} ScaleConstraint;

struct _Scaling {
	ScaleConstraint constraint;
	gint scale;
	Dimensions viewport;
	gboolean scale_up;
};

struct _ImportID {
	gint64 id;
};

struct _MediaSource {
	ThumbnailSource parent_instance;
	MediaSourcePrivate * priv;
};

struct _MediaSourceClass {
	ThumbnailSourceClass parent_class;
	void (*notify_master_replaced) (MediaSource* self, GFile* old_file, GFile* new_file);
	gboolean (*set_event_id) (MediaSource* self, EventID* id);
	gchar* (*get_basename) (MediaSource* self);
	GFile* (*get_file) (MediaSource* self);
	GFile* (*get_master_file) (MediaSource* self);
	guint64 (*get_master_filesize) (MediaSource* self);
	guint64 (*get_filesize) (MediaSource* self);
	time_t (*get_timestamp) (MediaSource* self);
	BackingFileState** (*get_backing_files_state) (MediaSource* self, int* result_length1);
	gchar* (*get_title) (MediaSource* self);
	gchar* (*get_comment) (MediaSource* self);
	void (*set_title) (MediaSource* self, const gchar* title);
	gboolean (*set_comment) (MediaSource* self, const gchar* comment);
	Rating (*get_rating) (MediaSource* self);
	void (*set_rating) (MediaSource* self, Rating rating);
	void (*increase_rating) (MediaSource* self);
	void (*decrease_rating) (MediaSource* self);
	void (*get_dimensions) (MediaSource* self, PhotoException disallowed_steps, Dimensions* result);
	GdkPixbuf* (*get_preview_pixbuf) (MediaSource* self, Scaling* scaling, GError** error);
	gboolean (*is_trashed) (MediaSource* self);
	void (*trash) (MediaSource* self);
	void (*untrash) (MediaSource* self);
	gboolean (*is_offline) (MediaSource* self);
	void (*mark_offline) (MediaSource* self);
	void (*mark_online) (MediaSource* self);
	gchar* (*get_master_md5) (MediaSource* self);
	void (*get_event_id) (MediaSource* self, EventID* result);
	time_t (*get_exposure_time) (MediaSource* self);
	void (*get_import_id) (MediaSource* self, ImportID* result);
	void (*master_replaced) (MediaSource* self, GFile* old_file, GFile* new_file);
};

struct _PhotoSource {
	MediaSource parent_instance;
	PhotoSourcePrivate * priv;
};

struct _PhotoSourceClass {
	MediaSourceClass parent_class;
	PhotoMetadata* (*get_metadata) (PhotoSource* self);
	GdkPixbuf* (*get_pixbuf) (PhotoSource* self, Scaling* scaling, GError** error);
};

struct _DateableIface {
	GTypeInterface parent_iface;
	void (*set_exposure_time) (Dateable* self, time_t target_time);
	time_t (*get_exposure_time) (Dateable* self);
};

typedef enum  {
	ROTATION_CLOCKWISE,
	ROTATION_COUNTERCLOCKWISE,
	ROTATION_MIRROR,
	ROTATION_UPSIDE_DOWN
} Rotation;

struct _Photo {
	PhotoSource parent_instance;
	PhotoPrivate * priv;
	PhotoRow* row;
	gboolean can_rotate_now;
	BackingPhotoRow* backing_photo_row;
};

struct _PhotoClass {
	PhotoSourceClass parent_class;
	void (*notify_editable_replaced) (Photo* self, GFile* old_file, GFile* new_file);
	void (*notify_raw_development_modified) (Photo* self);
	void (*notify_baseline_replaced) (Photo* self);
	void (*notify_master_reimported) (Photo* self, PhotoMetadata* metadata);
	void (*notify_editable_reimported) (Photo* self, PhotoMetadata* metadata);
	void (*notify_source_reimported) (Photo* self, PhotoMetadata* metadata);
	void (*notify_baseline_reimported) (Photo* self, PhotoMetadata* metadata);
	void (*apply_user_metadata_for_reimport) (Photo* self, PhotoMetadata* metadata);
	void (*rotate) (Photo* self, Rotation rotation);
	gboolean (*has_user_generated_metadata) (Photo* self);
	void (*set_user_metadata_for_export) (Photo* self, PhotoMetadata* metadata);
	void (*editable_replaced) (Photo* self, GFile* old_file, GFile* new_file);
	void (*raw_development_modified) (Photo* self);
	void (*baseline_replaced) (Photo* self);
	void (*master_reimported) (Photo* self, PhotoMetadata* metadata);
	void (*editable_reimported) (Photo* self, PhotoMetadata* metadata);
	void (*baseline_reimported) (Photo* self, PhotoMetadata* metadata);
	void (*source_reimported) (Photo* self, PhotoMetadata* metadata);
};

struct _DirectPhoto {
	Photo parent_instance;
	DirectPhotoPrivate * priv;
};

struct _DirectPhotoClass {
	PhotoClass parent_class;
};

struct _DirectPhotoPrivate {
	GdkPixbuf* preview;
	gboolean loaded;
};

typedef enum  {
	ORIENTATION_MIN = 1,
	ORIENTATION_TOP_LEFT = 1,
	ORIENTATION_TOP_RIGHT = 2,
	ORIENTATION_BOTTOM_RIGHT = 3,
	ORIENTATION_BOTTOM_LEFT = 4,
	ORIENTATION_LEFT_TOP = 5,
	ORIENTATION_RIGHT_TOP = 6,
	ORIENTATION_RIGHT_BOTTOM = 7,
	ORIENTATION_LEFT_BOTTOM = 8,
	ORIENTATION_MAX = 8
} Orientation;

struct _PhotoID {
	gint64 id;
};

struct _BackingPhotoID {
	gint64 id;
};

typedef enum  {
	RAW_DEVELOPER_SHOTWELL = 0,
	RAW_DEVELOPER_CAMERA,
	RAW_DEVELOPER_EMBEDDED
} RawDeveloper;

struct _PhotoRow {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PhotoRowPrivate * priv;
	PhotoID photo_id;
	BackingPhotoRow* master;
	time_t exposure_time;
	ImportID import_id;
	EventID event_id;
	Orientation orientation;
	GeeHashMap* transformations;
	gchar* md5;
	gchar* thumbnail_md5;
	gchar* exif_md5;
	time_t time_created;
	guint64 flags;
	Rating rating;
	gchar* title;
	gchar* comment;
	gchar* backlinks;
	time_t time_reimported;
	BackingPhotoID editable_id;
	gboolean metadata_dirty;
	RawDeveloper developer;
	BackingPhotoID* development_ids;
	gint development_ids_length1;
};

struct _PhotoRowClass {
	GTypeClass parent_class;
	void (*finalize) (PhotoRow *self);
};

struct _BackingPhotoRow {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BackingPhotoRowPrivate * priv;
	BackingPhotoID id;
	time_t time_created;
	gchar* filepath;
	gint64 filesize;
	time_t timestamp;
	PhotoFileFormat file_format;
	Dimensions dim;
	Orientation original_orientation;
};

struct _BackingPhotoRowClass {
	GTypeClass parent_class;
	void (*finalize) (BackingPhotoRow *self);
};

typedef enum  {
	BACKING_FETCH_MODE_SOURCE,
	BACKING_FETCH_MODE_BASELINE,
	BACKING_FETCH_MODE_MASTER,
	BACKING_FETCH_MODE_UNMODIFIED
} BackingFetchMode;

typedef enum  {
	IMPORT_RESULT_SUCCESS,
	IMPORT_RESULT_FILE_ERROR,
	IMPORT_RESULT_DECODE_ERROR,
	IMPORT_RESULT_DATABASE_ERROR,
	IMPORT_RESULT_USER_ABORT,
	IMPORT_RESULT_NOT_A_FILE,
	IMPORT_RESULT_PHOTO_EXISTS,
	IMPORT_RESULT_UNSUPPORTED_FORMAT,
	IMPORT_RESULT_NOT_AN_IMAGE,
	IMPORT_RESULT_DISK_FAILURE,
	IMPORT_RESULT_DISK_FULL,
	IMPORT_RESULT_CAMERA_ERROR,
	IMPORT_RESULT_FILE_WRITE_ERROR,
	IMPORT_RESULT_PIXBUF_CORRUPT_IMAGE
} ImportResult;

typedef enum  {
	DATABASE_ERROR_ERROR,
	DATABASE_ERROR_BACKING,
	DATABASE_ERROR_MEMORY,
	DATABASE_ERROR_ABORT,
	DATABASE_ERROR_LIMITS,
	DATABASE_ERROR_TYPESPEC
} DatabaseError;
#define DATABASE_ERROR database_error_quark ()
typedef enum  {
	PHOTO_FILE_SNIFFER_OPTIONS_GET_ALL = 0x00000000,
	PHOTO_FILE_SNIFFER_OPTIONS_NO_MD5 = 0x00000001
} PhotoFileSnifferOptions;

struct _PhotoImportParams {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PhotoImportParamsPrivate * priv;
	GFile* file;
	GFile* final_associated_file;
	ImportID import_id;
	PhotoFileSnifferOptions sniffer_options;
	gchar* exif_md5;
	gchar* thumbnail_md5;
	gchar* full_md5;
	Thumbnails* thumbnails;
	PhotoRow* row;
	GeeCollection* keywords;
};

struct _PhotoImportParamsClass {
	GTypeClass parent_class;
	void (*finalize) (PhotoImportParams *self);
};

typedef gint64 (*Comparator) (void* a, void* b, void* user_data);
typedef gboolean (*ComparatorPredicate) (DataObject* object, Alteration* alteration, void* user_data);
typedef gboolean (*ProgressMonitor) (guint64 current, guint64 total, gboolean do_event_loop, void* user_data);
struct _MarkerIface {
	GTypeInterface parent_iface;
	void (*mark) (Marker* self, DataObject* object);
	void (*unmark) (Marker* self, DataObject* object);
	gboolean (*toggle) (Marker* self, DataObject* object);
	void (*mark_many) (Marker* self, GeeCollection* list);
	void (*unmark_many) (Marker* self, GeeCollection* list);
	void (*mark_all) (Marker* self);
	gint (*get_count) (Marker* self);
	GeeCollection* (*get_all) (Marker* self);
};

struct _DataCollection {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DataCollectionPrivate * priv;
};

struct _DataCollectionClass {
	GTypeClass parent_class;
	void (*finalize) (DataCollection *self);
	gchar* (*to_string) (DataCollection* self);
	void (*notify_items_added) (DataCollection* self, GeeIterable* added);
	void (*notify_items_removed) (DataCollection* self, GeeIterable* removed);
	void (*notify_contents_altered) (DataCollection* self, GeeIterable* added, GeeIterable* removed);
	void (*notify_items_altered) (DataCollection* self, GeeMap* items);
	void (*notify_ordering_changed) (DataCollection* self);
	void (*notify_property_set) (DataCollection* self, const gchar* name, GValue* old, GValue* val);
	void (*notify_property_cleared) (DataCollection* self, const gchar* name);
	gboolean (*valid_type) (DataCollection* self, DataObject* object);
	void (*set_comparator) (DataCollection* self, Comparator comparator, void* comparator_target, ComparatorPredicate predicate, void* predicate_target);
	void (*reset_comparator) (DataCollection* self);
	GeeCollection* (*get_all) (DataCollection* self);
	gint (*get_count) (DataCollection* self);
	DataObject* (*get_at) (DataCollection* self, gint index);
	gint (*index_of) (DataCollection* self, DataObject* object);
	gboolean (*contains) (DataCollection* self, DataObject* object);
	gboolean (*add) (DataCollection* self, DataObject* object);
	GeeCollection* (*add_many) (DataCollection* self, GeeCollection* objects, ProgressMonitor monitor, void* monitor_target);
	void (*remove_marked) (DataCollection* self, Marker* m);
	void (*clear) (DataCollection* self);
	void (*close) (DataCollection* self);
	void (*notify_frozen) (DataCollection* self);
	void (*notify_thawed) (DataCollection* self);
	void (*items_added) (DataCollection* self, GeeIterable* added);
	void (*items_removed) (DataCollection* self, GeeIterable* removed);
	void (*contents_altered) (DataCollection* self, GeeIterable* added, GeeIterable* removed);
	void (*items_altered) (DataCollection* self, GeeMap* items);
	void (*ordering_changed) (DataCollection* self);
	void (*property_set) (DataCollection* self, const gchar* name, GValue* old, GValue* val);
	void (*property_cleared) (DataCollection* self, const gchar* name);
	void (*frozen) (DataCollection* self);
	void (*thawed) (DataCollection* self);
};

struct _SourceCollection {
	DataCollection parent_instance;
	SourceCollectionPrivate * priv;
};

struct _SourceCollectionClass {
	DataCollectionClass parent_class;
	gboolean (*holds_type_of_source) (SourceCollection* self, DataSource* source);
	void (*notify_items_unlinking) (SourceCollection* self, GeeCollection* unlinking);
	void (*notify_items_relinked) (SourceCollection* self, GeeCollection* relinked);
	void (*notify_item_destroyed) (SourceCollection* self, DataSource* source);
	void (*notify_items_destroyed) (SourceCollection* self, GeeCollection* destroyed);
	void (*notify_unlinked_destroyed) (SourceCollection* self, DataSource* unlinked);
	void (*notify_backlink_removed) (SourceCollection* self, SourceBacklink* backlink, GeeCollection* sources);
	gboolean (*has_backlink) (SourceCollection* self, SourceBacklink* backlink);
	void (*remove_backlink) (SourceCollection* self, SourceBacklink* backlink);
	void (*items_unlinking) (SourceCollection* self, GeeCollection* unlinking);
	void (*items_relinked) (SourceCollection* self, GeeCollection* relinked);
	void (*item_destroyed) (SourceCollection* self, DataSource* source);
	void (*items_destroyed) (SourceCollection* self, GeeCollection* destroyed);
	void (*unlinked_destroyed) (SourceCollection* self, DataSource* source);
	void (*backlink_removed) (SourceCollection* self, SourceBacklink* backlink, GeeCollection* sources);
};

struct _DatabaseSourceCollection {
	SourceCollection parent_instance;
	DatabaseSourceCollectionPrivate * priv;
};

struct _DatabaseSourceCollectionClass {
	SourceCollectionClass parent_class;
};

struct _DirectPhotoSourceCollection {
	DatabaseSourceCollection parent_instance;
	DirectPhotoSourceCollectionPrivate * priv;
};

struct _DirectPhotoSourceCollectionClass {
	DatabaseSourceCollectionClass parent_class;
};

struct _DirectPhotoSourceCollectionPrivate {
	GeeCollection* prepared_photos;
	GeeHashMap* file_map;
	DirectoryMonitor* monitor;
};

typedef gint64 (*GetSourceDatabaseKey) (DataSource* source, void* user_data);

static gpointer direct_photo_parent_class = NULL;
extern DirectPhotoSourceCollection* direct_photo_global;
DirectPhotoSourceCollection* direct_photo_global = NULL;
static gpointer direct_photo_source_collection_parent_class = NULL;

GType data_object_get_type (void) G_GNUC_CONST;
gpointer alteration_ref (gpointer instance);
void alteration_unref (gpointer instance);
GParamSpec* param_spec_alteration (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_alteration (GValue* value, gpointer v_object);
void value_take_alteration (GValue* value, gpointer v_object);
gpointer value_get_alteration (const GValue* value);
GType alteration_get_type (void) G_GNUC_CONST;
gpointer data_collection_ref (gpointer instance);
void data_collection_unref (gpointer instance);
GParamSpec* param_spec_data_collection (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_data_collection (GValue* value, gpointer v_object);
void value_take_data_collection (GValue* value, gpointer v_object);
gpointer value_get_data_collection (const GValue* value);
GType data_collection_get_type (void) G_GNUC_CONST;
GType data_source_get_type (void) G_GNUC_CONST;
gpointer source_holding_tank_ref (gpointer instance);
void source_holding_tank_unref (gpointer instance);
GParamSpec* param_spec_source_holding_tank (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_source_holding_tank (GValue* value, gpointer v_object);
void value_take_source_holding_tank (GValue* value, gpointer v_object);
gpointer value_get_source_holding_tank (const GValue* value);
GType source_holding_tank_get_type (void) G_GNUC_CONST;
GType source_collection_get_type (void) G_GNUC_CONST;
gpointer source_snapshot_ref (gpointer instance);
void source_snapshot_unref (gpointer instance);
GParamSpec* param_spec_source_snapshot (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_source_snapshot (GValue* value, gpointer v_object);
void value_take_source_snapshot (GValue* value, gpointer v_object);
gpointer value_get_source_snapshot (const GValue* value);
GType source_snapshot_get_type (void) G_GNUC_CONST;
GType thumbnail_source_get_type (void) G_GNUC_CONST;
GType photo_file_format_get_type (void) G_GNUC_CONST;
GType indexable_get_type (void) G_GNUC_CONST;
GType media_source_get_type (void) G_GNUC_CONST;
GType event_id_get_type (void) G_GNUC_CONST;
EventID* event_id_dup (const EventID* self);
void event_id_free (EventID* self);
gpointer backing_file_state_ref (gpointer instance);
void backing_file_state_unref (gpointer instance);
GParamSpec* param_spec_backing_file_state (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_backing_file_state (GValue* value, gpointer v_object);
void value_take_backing_file_state (GValue* value, gpointer v_object);
gpointer value_get_backing_file_state (const GValue* value);
GType backing_file_state_get_type (void) G_GNUC_CONST;
GType rating_get_type (void) G_GNUC_CONST;
GType photo_exception_get_type (void) G_GNUC_CONST;
GType dimensions_get_type (void) G_GNUC_CONST;
Dimensions* dimensions_dup (const Dimensions* self);
void dimensions_free (Dimensions* self);
GType scaling_get_type (void) G_GNUC_CONST;
GType scale_constraint_get_type (void) G_GNUC_CONST;
Scaling* scaling_dup (const Scaling* self);
void scaling_free (Scaling* self);
GType import_id_get_type (void) G_GNUC_CONST;
ImportID* import_id_dup (const ImportID* self);
void import_id_free (ImportID* self);
GType photo_source_get_type (void) G_GNUC_CONST;
gpointer media_metadata_ref (gpointer instance);
void media_metadata_unref (gpointer instance);
GParamSpec* param_spec_media_metadata (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_media_metadata (GValue* value, gpointer v_object);
void value_take_media_metadata (GValue* value, gpointer v_object);
gpointer value_get_media_metadata (const GValue* value);
GType media_metadata_get_type (void) G_GNUC_CONST;
GType photo_metadata_get_type (void) G_GNUC_CONST;
GType dateable_get_type (void) G_GNUC_CONST;
GType photo_get_type (void) G_GNUC_CONST;
GType rotation_get_type (void) G_GNUC_CONST;
gpointer photo_row_ref (gpointer instance);
void photo_row_unref (gpointer instance);
GParamSpec* param_spec_photo_row (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_photo_row (GValue* value, gpointer v_object);
void value_take_photo_row (GValue* value, gpointer v_object);
gpointer value_get_photo_row (const GValue* value);
GType photo_row_get_type (void) G_GNUC_CONST;
gpointer backing_photo_row_ref (gpointer instance);
void backing_photo_row_unref (gpointer instance);
GParamSpec* param_spec_backing_photo_row (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_backing_photo_row (GValue* value, gpointer v_object);
void value_take_backing_photo_row (GValue* value, gpointer v_object);
gpointer value_get_backing_photo_row (const GValue* value);
GType backing_photo_row_get_type (void) G_GNUC_CONST;
GType direct_photo_get_type (void) G_GNUC_CONST;
#define DIRECT_PHOTO_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_DIRECT_PHOTO, DirectPhotoPrivate))
enum  {
	DIRECT_PHOTO_DUMMY_PROPERTY
};
GType database_source_collection_get_type (void) G_GNUC_CONST;
GType direct_photo_source_collection_get_type (void) G_GNUC_CONST;
#define DIRECT_PHOTO_PREVIEW_BEST_FIT 360
static DirectPhoto* direct_photo_new (PhotoRow* row);
static DirectPhoto* direct_photo_construct (GType object_type, PhotoRow* row);
Photo* photo_construct (GType object_type, PhotoRow* row);
GType orientation_get_type (void) G_GNUC_CONST;
void direct_photo_fixup_orientation_after_reimport (DirectPhoto* self, Orientation dest);
GType photo_id_get_type (void) G_GNUC_CONST;
PhotoID* photo_id_dup (const PhotoID* self);
void photo_id_free (PhotoID* self);
GType backing_photo_id_get_type (void) G_GNUC_CONST;
BackingPhotoID* backing_photo_id_dup (const BackingPhotoID* self);
void backing_photo_id_free (BackingPhotoID* self);
GType raw_developer_get_type (void) G_GNUC_CONST;
void direct_photo_init (GFile* initial_file);
void photo_init_photo (void);
DirectPhotoSourceCollection* direct_photo_source_collection_new (GFile* initial_file);
DirectPhotoSourceCollection* direct_photo_source_collection_construct (GType object_type, GFile* initial_file);
gchar* direct_photo_source_collection_fetch (DirectPhotoSourceCollection* self, GFile* file, DirectPhoto* * photo, gboolean reimport);
gboolean data_collection_add (DataCollection* self, DataObject* object);
void direct_photo_terminate (void);
void photo_terminate_photo (void);
static void direct_photo_save_dims (DirectPhoto* self);
GType backing_fetch_mode_get_type (void) G_GNUC_CONST;
GdkPixbuf* photo_get_pixbuf_with_options (Photo* self, Scaling* scaling, PhotoException exceptions, BackingFetchMode fetch_mode, GError** error);
void scaling_for_original (Scaling* result);
void dimensions_for_pixbuf (GdkPixbuf* pixbuf, Dimensions* result);
gchar* data_object_to_string (DataObject* self);
GType import_result_get_type (void) G_GNUC_CONST;
ImportResult direct_photo_demand_load (DirectPhoto* self);
gpointer photo_reimport_master_state_ref (gpointer instance);
void photo_reimport_master_state_unref (gpointer instance);
GParamSpec* photo_param_spec_reimport_master_state (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void photo_value_set_reimport_master_state (GValue* value, gpointer v_object);
void photo_value_take_reimport_master_state (GValue* value, gpointer v_object);
gpointer photo_value_get_reimport_master_state (const GValue* value);
GType photo_reimport_master_state_get_type (void) G_GNUC_CONST;
gboolean photo_prepare_for_reimport_master (Photo* self, PhotoReimportMasterState* * reimport_state, GError** error);
GQuark database_error_quark (void);
void photo_finish_reimport_master (Photo* self, PhotoReimportMasterState* state, GError** error);
ImportResult direct_photo_internal_import (GFile* file, DirectPhoto* * photo);
gpointer photo_import_params_ref (gpointer instance);
void photo_import_params_unref (gpointer instance);
GParamSpec* param_spec_photo_import_params (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_photo_import_params (GValue* value, gpointer v_object);
void value_take_photo_import_params (GValue* value, gpointer v_object);
gpointer value_get_photo_import_params (const GValue* value);
GType photo_import_params_get_type (void) G_GNUC_CONST;
void import_id_generate (ImportID* result);
PhotoImportParams* photo_import_params_new_create_placeholder (GFile* file, ImportID* import_id);
PhotoImportParams* photo_import_params_construct_create_placeholder (GType object_type, GFile* file, ImportID* import_id);
void photo_create_pre_import (PhotoImportParams* params);
gpointer database_table_ref (gpointer instance);
void database_table_unref (gpointer instance);
GParamSpec* param_spec_database_table (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_database_table (GValue* value, gpointer v_object);
void value_take_database_table (GValue* value, gpointer v_object);
gpointer value_get_database_table (const GValue* value);
GType database_table_get_type (void) G_GNUC_CONST;
GType photo_table_get_type (void) G_GNUC_CONST;
PhotoTable* photo_table_get_instance (void);
void photo_table_add (PhotoTable* self, PhotoRow* photo_row, PhotoID* result);
GType photo_file_sniffer_options_get_type (void) G_GNUC_CONST;
gpointer thumbnails_ref (gpointer instance);
void thumbnails_unref (gpointer instance);
GParamSpec* param_spec_thumbnails (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_thumbnails (GValue* value, gpointer v_object);
void value_take_thumbnails (GValue* value, gpointer v_object);
gpointer value_get_thumbnails (const GValue* value);
GType thumbnails_get_type (void) G_GNUC_CONST;
static GdkPixbuf* direct_photo_real_get_preview_pixbuf (MediaSource* base, Scaling* scaling, GError** error);
GdkPixbuf* thumbnail_source_get_thumbnail (ThumbnailSource* self, gint scale, GError** error);
GdkPixbuf* photo_source_get_pixbuf (PhotoSource* self, Scaling* scaling, GError** error);
GdkPixbuf* scaling_perform_on_pixbuf (Scaling *self, GdkPixbuf* pixbuf, GdkInterpType interp, gboolean scale_up);
static void direct_photo_real_rotate (Photo* base, Rotation rotation);
void photo_rotate (Photo* self, Rotation rotation);
static GdkPixbuf* direct_photo_real_get_pixbuf (PhotoSource* base, Scaling* scaling, GError** error);
static GdkPixbuf* direct_photo_real_get_thumbnail (ThumbnailSource* base, gint scale, GError** error);
PhotoMetadata* photo_source_get_metadata (PhotoSource* self);
guint photo_metadata_get_preview_count (PhotoMetadata* self);
gpointer photo_preview_ref (gpointer instance);
void photo_preview_unref (gpointer instance);
GParamSpec* param_spec_photo_preview (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_photo_preview (GValue* value, gpointer v_object);
void value_take_photo_preview (GValue* value, gpointer v_object);
gpointer value_get_photo_preview (const GValue* value);
GType photo_preview_get_type (void) G_GNUC_CONST;
PhotoPreview* photo_metadata_get_preview (PhotoMetadata* self, guint number);
GdkPixbuf* photo_preview_get_pixbuf (PhotoPreview* self, GError** error);
Orientation photo_get_orientation (Photo* self);
GdkPixbuf* orientation_rotate_pixbuf (Orientation self, GdkPixbuf* pixbuf);
static void direct_photo_real_notify_altered (DataObject* base, Alteration* alteration);
void data_object_notify_altered (DataObject* self, Alteration* alteration);
static gboolean direct_photo_real_has_user_generated_metadata (Photo* base);
static void direct_photo_real_set_user_metadata_for_export (Photo* base, PhotoMetadata* metadata);
static void direct_photo_real_apply_user_metadata_for_reimport (Photo* base, PhotoMetadata* metadata);
static gboolean direct_photo_real_is_trashed (MediaSource* base);
static gboolean direct_photo_real_is_offline (MediaSource* base);
static void direct_photo_real_trash (MediaSource* base);
static void direct_photo_real_untrash (MediaSource* base);
static void direct_photo_real_mark_offline (MediaSource* base);
static void direct_photo_real_mark_online (MediaSource* base);
static void direct_photo_finalize (GObject * obj);
GType marker_get_type (void) G_GNUC_CONST;
gpointer source_backlink_ref (gpointer instance);
void source_backlink_unref (gpointer instance);
GParamSpec* param_spec_source_backlink (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_source_backlink (GValue* value, gpointer v_object);
void value_take_source_backlink (GValue* value, gpointer v_object);
gpointer value_get_source_backlink (const GValue* value);
GType source_backlink_get_type (void) G_GNUC_CONST;
GType directory_monitor_get_type (void) G_GNUC_CONST;
#define DIRECT_PHOTO_SOURCE_COLLECTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_DIRECT_PHOTO_SOURCE_COLLECTION, DirectPhotoSourceCollectionPrivate))
enum  {
	DIRECT_PHOTO_SOURCE_COLLECTION_DUMMY_PROPERTY
};
guint file_hash (GFile* file);
static guint _file_hash_gee_hash_data_func (gconstpointer v, gpointer self);
gboolean file_equal (GFile* a, GFile* b);
static gboolean _file_equal_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self);
#define DIRECT_PHOTO_SOURCE_COLLECTION_DISCOVERED_FILES_BATCH_ADD 500
static gint64 direct_photo_source_collection_get_direct_key (DataSource* source);
static gint64 _direct_photo_source_collection_get_direct_key_get_source_database_key (DataSource* source, gpointer self);
DatabaseSourceCollection* database_source_collection_construct (GType object_type, const gchar* name, GetSourceDatabaseKey source_key_func, void* source_key_func_target);
DirectoryMonitor* directory_monitor_new (GFile* root, gboolean recurse, gboolean monitoring);
DirectoryMonitor* directory_monitor_construct (GType object_type, GFile* root, gboolean recurse, gboolean monitoring);
static void direct_photo_source_collection_on_file_discovered (DirectPhotoSourceCollection* self, GFile* file, GFileInfo* info);
static void _direct_photo_source_collection_on_file_discovered_directory_monitor_file_discovered (DirectoryMonitor* _sender, GFile* file, GFileInfo* info, gpointer self);
static void direct_photo_source_collection_on_discovery_completed (DirectPhotoSourceCollection* self);
static void _direct_photo_source_collection_on_discovery_completed_directory_monitor_discovery_completed (DirectoryMonitor* _sender, gpointer self);
void directory_monitor_start_discovery (DirectoryMonitor* self);
static gboolean direct_photo_source_collection_real_holds_type_of_source (SourceCollection* base, DataSource* source);
void photo_get_photo_id (Photo* self, PhotoID* result);
static void direct_photo_source_collection_real_notify_items_added (DataCollection* base, GeeIterable* added);
GFile* media_source_get_file (MediaSource* self);
void data_collection_notify_items_added (DataCollection* self, GeeIterable* added);
static void direct_photo_source_collection_real_notify_items_removed (DataCollection* base, GeeIterable* removed);
void data_collection_notify_items_removed (DataCollection* self, GeeIterable* removed);
gboolean direct_photo_source_collection_has_source_for_file (DirectPhotoSourceCollection* self, GFile* file);
gboolean photo_file_format_is_file_supported (GFile* file);
static void direct_photo_source_collection_flush_prepared_photos (DirectPhotoSourceCollection* self);
GeeCollection* data_collection_add_many (DataCollection* self, GeeCollection* objects, ProgressMonitor monitor, void* monitor_target);
gboolean direct_photo_source_collection_has_file (DirectPhotoSourceCollection* self, GFile* file);
void direct_photo_source_collection_reimport_photo (DirectPhotoSourceCollection* self, DirectPhoto* photo);
void photo_discard_prefetched (Photo* self);
gboolean photo_only_metadata_changed (Photo* self);
PhotoFileFormat photo_get_file_format (Photo* self);
gchar* import_result_to_string (ImportResult self);
gboolean direct_photo_source_collection_has_file_source (DirectPhotoSourceCollection* self, GFile* file);
DirectPhoto* direct_photo_source_collection_get_file_source (DirectPhotoSourceCollection* self, GFile* file);
static void direct_photo_source_collection_finalize (DataCollection * obj);


static DirectPhoto* direct_photo_construct (GType object_type, PhotoRow* row) {
	DirectPhoto * self = NULL;
	PhotoRow* _tmp0_;
#line 17 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	g_return_val_if_fail (IS_PHOTO_ROW (row), NULL);
#line 18 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_tmp0_ = row;
#line 18 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	self = (DirectPhoto*) photo_construct (object_type, _tmp0_);
#line 17 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	return self;
#line 1114 "DirectPhoto.c"
}


static DirectPhoto* direct_photo_new (PhotoRow* row) {
#line 17 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	return direct_photo_construct (TYPE_DIRECT_PHOTO, row);
#line 1121 "DirectPhoto.c"
}


/**
     * @brief Because all transformations are discarded on reimport by design, including
     * Orientation, a JFIF file that is only rotated or flipped, then saved, has the orientation
     * change the user made before saving removed (recall that fetch() remembers which images it
     * has seen before and will only add a file to the file map once; every time it sees it
     * again after this is considered a reimport). This will set the orientation to the
     * specified value, fixing up both the row and the backing row.
     *
     * @warning Only reimported JFIF files should need this; non-lossy image types have their
     * actual pixels physically rotated in the file when they're exported.
     *
     * @param dest The orientation to set the photo to; usually, this should be a value
     * obtained by calling get_orientation() prior to export()ing a DirectPhoto.
     */
void direct_photo_fixup_orientation_after_reimport (DirectPhoto* self, Orientation dest) {
	PhotoRow* _tmp0_;
	Orientation _tmp1_;
	BackingPhotoRow* _tmp2_;
	Orientation _tmp3_;
#line 35 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	g_return_if_fail (IS_DIRECT_PHOTO (self));
#line 36 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_tmp0_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO, Photo)->row;
#line 36 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_tmp1_ = dest;
#line 36 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_tmp0_->orientation = _tmp1_;
#line 37 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_tmp2_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO, Photo)->backing_photo_row;
#line 37 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_tmp3_ = dest;
#line 37 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_tmp2_->original_orientation = _tmp3_;
#line 1158 "DirectPhoto.c"
}


void direct_photo_init (GFile* initial_file) {
	GFile* _tmp0_;
	DirectPhotoSourceCollection* _tmp1_;
	DirectPhoto* photo = NULL;
	gchar* reason = NULL;
	DirectPhotoSourceCollection* _tmp2_;
	GFile* _tmp3_;
	DirectPhoto* _tmp4_ = NULL;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	DirectPhotoSourceCollection* _tmp8_;
	DirectPhoto* _tmp9_;
#line 40 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	g_return_if_fail (G_IS_FILE (initial_file));
#line 41 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	photo_init_photo ();
#line 43 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_tmp0_ = initial_file;
#line 43 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_tmp1_ = direct_photo_source_collection_new (_tmp0_);
#line 43 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_data_collection_unref0 (direct_photo_global);
#line 43 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	direct_photo_global = _tmp1_;
#line 45 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_tmp2_ = direct_photo_global;
#line 45 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_tmp3_ = initial_file;
#line 45 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_tmp5_ = direct_photo_source_collection_fetch (_tmp2_, _tmp3_, &_tmp4_, FALSE);
#line 45 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_g_object_unref0 (photo);
#line 45 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	photo = _tmp4_;
#line 45 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	reason = _tmp5_;
#line 46 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_tmp6_ = reason;
#line 46 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	if (_tmp6_ != NULL) {
#line 1202 "DirectPhoto.c"
		const gchar* _tmp7_;
#line 47 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		_tmp7_ = reason;
#line 47 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		g_warning ("DirectPhoto.vala:47: fetch error: %s", _tmp7_);
#line 1208 "DirectPhoto.c"
	}
#line 48 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_tmp8_ = direct_photo_global;
#line 48 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_tmp9_ = photo;
#line 48 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	data_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_DATA_COLLECTION, DataCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_DATA_OBJECT, DataObject));
#line 40 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_g_free0 (reason);
#line 40 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_g_object_unref0 (photo);
#line 1220 "DirectPhoto.c"
}


void direct_photo_terminate (void) {
#line 52 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	photo_terminate_photo ();
#line 1227 "DirectPhoto.c"
}


static void direct_photo_save_dims (DirectPhoto* self) {
	GError * _inner_error_ = NULL;
#line 57 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	g_return_if_fail (IS_DIRECT_PHOTO (self));
#line 1235 "DirectPhoto.c"
	{
		GdkPixbuf* _tmp0_ = NULL;
		Scaling _tmp1_ = {0};
		GdkPixbuf* _tmp2_;
		BackingPhotoRow* _tmp3_;
		Dimensions _tmp4_ = {0};
#line 59 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		scaling_for_original (&_tmp1_);
#line 59 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		_tmp2_ = photo_get_pixbuf_with_options (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO, Photo), &_tmp1_, (PHOTO_EXCEPTION_CROP | PHOTO_EXCEPTION_STRAIGHTEN) | PHOTO_EXCEPTION_ORIENTATION, BACKING_FETCH_MODE_BASELINE, &_inner_error_);
#line 59 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		_tmp0_ = _tmp2_;
#line 59 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1250 "DirectPhoto.c"
			goto __catch49_g_error;
		}
#line 59 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		_tmp3_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO, Photo)->backing_photo_row;
#line 59 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		dimensions_for_pixbuf (_tmp0_, &_tmp4_);
#line 59 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		_tmp3_->dim = _tmp4_;
#line 58 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		_g_object_unref0 (_tmp0_);
#line 1261 "DirectPhoto.c"
	}
	goto __finally49;
	__catch49_g_error:
	{
		GError* e = NULL;
		gchar* _tmp5_;
		gchar* _tmp6_;
#line 58 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		e = _inner_error_;
#line 58 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		_inner_error_ = NULL;
#line 62 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		_tmp5_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject));
#line 62 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		_tmp6_ = _tmp5_;
#line 62 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		g_warning ("DirectPhoto.vala:62: Dimensions for image %s could not be gotten.", _tmp6_);
#line 62 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		_g_free0 (_tmp6_);
#line 58 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		_g_error_free0 (e);
#line 1283 "DirectPhoto.c"
	}
	__finally49:
#line 58 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 58 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 58 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		g_clear_error (&_inner_error_);
#line 58 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		return;
#line 1294 "DirectPhoto.c"
	}
}


ImportResult direct_photo_demand_load (DirectPhoto* self) {
	ImportResult result = 0;
	gboolean _tmp0_;
	PhotoReimportMasterState* reimport_state = NULL;
	GError * _inner_error_ = NULL;
#line 67 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	g_return_val_if_fail (IS_DIRECT_PHOTO (self), 0);
#line 68 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_tmp0_ = self->priv->loaded;
#line 68 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	if (_tmp0_) {
#line 69 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		direct_photo_save_dims (self);
#line 70 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		result = IMPORT_RESULT_SUCCESS;
#line 70 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		return result;
#line 1316 "DirectPhoto.c"
	}
	{
		PhotoReimportMasterState* _tmp1_ = NULL;
		PhotoReimportMasterState* _tmp2_;
#line 75 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		photo_prepare_for_reimport_master (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO, Photo), &_tmp1_, &_inner_error_);
#line 75 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		_photo_reimport_master_state_unref0 (reimport_state);
#line 75 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		reimport_state = _tmp1_;
#line 75 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1329 "DirectPhoto.c"
			goto __catch50_g_error;
		}
#line 76 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		_tmp2_ = reimport_state;
#line 76 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		photo_finish_reimport_master (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO, Photo), _tmp2_, &_inner_error_);
#line 76 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1338 "DirectPhoto.c"
			goto __catch50_g_error;
		}
	}
	goto __finally50;
	__catch50_g_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
#line 74 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		err = _inner_error_;
#line 74 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		_inner_error_ = NULL;
#line 78 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		_tmp3_ = err;
#line 78 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		_tmp4_ = _tmp3_->message;
#line 78 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		g_warning ("DirectPhoto.vala:78: Database error on re-importing image: %s", _tmp4_);
#line 79 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		result = IMPORT_RESULT_DATABASE_ERROR;
#line 79 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		_g_error_free0 (err);
#line 79 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		_photo_reimport_master_state_unref0 (reimport_state);
#line 79 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		return result;
#line 1366 "DirectPhoto.c"
	}
	__finally50:
#line 74 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 74 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		_photo_reimport_master_state_unref0 (reimport_state);
#line 74 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 74 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		g_clear_error (&_inner_error_);
#line 74 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		return 0;
#line 1379 "DirectPhoto.c"
	}
#line 82 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	self->priv->loaded = TRUE;
#line 83 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	direct_photo_save_dims (self);
#line 84 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	result = IMPORT_RESULT_SUCCESS;
#line 84 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_photo_reimport_master_state_unref0 (reimport_state);
#line 84 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	return result;
#line 1391 "DirectPhoto.c"
}


ImportResult direct_photo_internal_import (GFile* file, DirectPhoto* * photo) {
	DirectPhoto* _vala_photo = NULL;
	ImportResult result = 0;
	PhotoImportParams* params = NULL;
	GFile* _tmp0_;
	ImportID _tmp1_ = {0};
	PhotoImportParams* _tmp2_;
	PhotoTable* _tmp3_;
	PhotoTable* _tmp4_;
	PhotoRow* _tmp5_;
	PhotoID _tmp6_ = {0};
	PhotoRow* _tmp7_;
	DirectPhoto* _tmp8_;
#line 89 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	g_return_val_if_fail (G_IS_FILE (file), 0);
#line 90 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_tmp0_ = file;
#line 90 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	import_id_generate (&_tmp1_);
#line 90 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_tmp2_ = photo_import_params_new_create_placeholder (_tmp0_, &_tmp1_);
#line 90 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	params = _tmp2_;
#line 91 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	photo_create_pre_import (params);
#line 92 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_tmp3_ = photo_table_get_instance ();
#line 92 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_tmp4_ = _tmp3_;
#line 92 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_tmp5_ = params->row;
#line 92 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	photo_table_add (_tmp4_, _tmp5_, &_tmp6_);
#line 92 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_database_table_unref0 (_tmp4_);
#line 94 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_tmp7_ = params->row;
#line 94 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_tmp8_ = direct_photo_new (_tmp7_);
#line 94 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_g_object_unref0 (_vala_photo);
#line 94 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_vala_photo = _tmp8_;
#line 96 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	result = IMPORT_RESULT_SUCCESS;
#line 96 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_photo_import_params_unref0 (params);
#line 96 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	if (photo) {
#line 96 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		*photo = _vala_photo;
#line 1446 "DirectPhoto.c"
	} else {
#line 96 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		_g_object_unref0 (_vala_photo);
#line 1450 "DirectPhoto.c"
	}
#line 96 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	return result;
#line 1454 "DirectPhoto.c"
}


static GdkPixbuf* direct_photo_real_get_preview_pixbuf (MediaSource* base, Scaling* scaling, GError** error) {
	DirectPhoto * self;
	GdkPixbuf* result = NULL;
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp9_;
	GdkPixbuf* _tmp10_;
	GError * _inner_error_ = NULL;
#line 99 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DIRECT_PHOTO, DirectPhoto);
#line 99 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	g_return_val_if_fail (scaling != NULL, NULL);
#line 100 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_tmp0_ = self->priv->preview;
#line 100 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	if (_tmp0_ == NULL) {
#line 1473 "DirectPhoto.c"
		GdkPixbuf* _tmp1_ = NULL;
		GdkPixbuf* _tmp2_;
		GdkPixbuf* _tmp3_;
		GdkPixbuf* _tmp4_;
#line 101 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		_tmp2_ = thumbnail_source_get_thumbnail (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_THUMBNAIL_SOURCE, ThumbnailSource), DIRECT_PHOTO_PREVIEW_BEST_FIT, &_inner_error_);
#line 101 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		_tmp1_ = _tmp2_;
#line 101 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 101 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
			g_propagate_error (error, _inner_error_);
#line 101 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
			return NULL;
#line 1488 "DirectPhoto.c"
		}
#line 101 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		_tmp3_ = _tmp1_;
#line 101 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		_tmp1_ = NULL;
#line 101 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		_g_object_unref0 (self->priv->preview);
#line 101 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		self->priv->preview = _tmp3_;
#line 103 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		_tmp4_ = self->priv->preview;
#line 103 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		if (_tmp4_ == NULL) {
#line 1502 "DirectPhoto.c"
			GdkPixbuf* _tmp5_ = NULL;
			Scaling _tmp6_;
			GdkPixbuf* _tmp7_;
			GdkPixbuf* _tmp8_;
#line 104 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
			_tmp6_ = *scaling;
#line 104 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
			_tmp7_ = photo_source_get_pixbuf (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_SOURCE, PhotoSource), &_tmp6_, &_inner_error_);
#line 104 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
			_tmp5_ = _tmp7_;
#line 104 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 104 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
				g_propagate_error (error, _inner_error_);
#line 104 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
				_g_object_unref0 (_tmp1_);
#line 104 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
				return NULL;
#line 1521 "DirectPhoto.c"
			}
#line 104 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
			_tmp8_ = _tmp5_;
#line 104 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
			_tmp5_ = NULL;
#line 104 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
			_g_object_unref0 (self->priv->preview);
#line 104 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
			self->priv->preview = _tmp8_;
#line 103 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
			_g_object_unref0 (_tmp5_);
#line 1533 "DirectPhoto.c"
		}
#line 100 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		_g_object_unref0 (_tmp1_);
#line 1537 "DirectPhoto.c"
	}
#line 107 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_tmp9_ = self->priv->preview;
#line 107 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_tmp10_ = scaling_perform_on_pixbuf (scaling, _tmp9_, GDK_INTERP_BILINEAR, TRUE);
#line 107 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	result = _tmp10_;
#line 107 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	return result;
#line 1547 "DirectPhoto.c"
}


static void direct_photo_real_rotate (Photo* base, Rotation rotation) {
	DirectPhoto * self;
	Rotation _tmp0_;
#line 110 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DIRECT_PHOTO, DirectPhoto);
#line 111 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO, Photo)->can_rotate_now = FALSE;
#line 112 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	g_signal_emit (self, direct_photo_signals[DIRECT_PHOTO_CAN_ROTATE_CHANGED_SIGNAL], 0, FALSE);
#line 113 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_tmp0_ = rotation;
#line 113 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	PHOTO_CLASS (direct_photo_parent_class)->rotate (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO, Photo), _tmp0_);
#line 1564 "DirectPhoto.c"
}


static GdkPixbuf* direct_photo_real_get_pixbuf (PhotoSource* base, Scaling* scaling, GError** error) {
	DirectPhoto * self;
	GdkPixbuf* result = NULL;
	GdkPixbuf* ret = NULL;
	Scaling _tmp0_;
	GdkPixbuf* _tmp1_;
	GError * _inner_error_ = NULL;
#line 116 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DIRECT_PHOTO, DirectPhoto);
#line 116 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	g_return_val_if_fail (scaling != NULL, NULL);
#line 117 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_tmp0_ = *scaling;
#line 117 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_tmp1_ = PHOTO_SOURCE_CLASS (direct_photo_parent_class)->get_pixbuf (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO, Photo), TYPE_PHOTO_SOURCE, PhotoSource), &_tmp0_, &_inner_error_);
#line 117 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	ret = _tmp1_;
#line 117 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 117 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		g_propagate_error (error, _inner_error_);
#line 117 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		return NULL;
#line 1591 "DirectPhoto.c"
	}
#line 118 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	g_signal_emit (self, direct_photo_signals[DIRECT_PHOTO_CAN_ROTATE_CHANGED_SIGNAL], 0, TRUE);
#line 119 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO, Photo)->can_rotate_now = TRUE;
#line 120 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	result = ret;
#line 120 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	return result;
#line 1601 "DirectPhoto.c"
}


static GdkPixbuf* direct_photo_real_get_thumbnail (ThumbnailSource* base, gint scale, GError** error) {
	DirectPhoto * self;
	GdkPixbuf* result = NULL;
	PhotoMetadata* metadata = NULL;
	PhotoMetadata* _tmp0_;
	GdkPixbuf* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	PhotoMetadata* _tmp3_;
	GError * _inner_error_ = NULL;
#line 123 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DIRECT_PHOTO, DirectPhoto);
#line 124 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_tmp0_ = photo_source_get_metadata (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_SOURCE, PhotoSource));
#line 124 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	metadata = _tmp0_;
#line 126 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_tmp3_ = metadata;
#line 126 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	if (_tmp3_ == NULL) {
#line 126 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		_tmp2_ = TRUE;
#line 1626 "DirectPhoto.c"
	} else {
		PhotoMetadata* _tmp4_;
		guint _tmp5_;
#line 126 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		_tmp4_ = metadata;
#line 126 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		_tmp5_ = photo_metadata_get_preview_count (_tmp4_);
#line 126 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		_tmp2_ = _tmp5_ == ((guint) 0);
#line 1636 "DirectPhoto.c"
	}
#line 126 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	if (_tmp2_) {
#line 126 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		_g_object_unref0 (_tmp1_);
#line 126 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		_tmp1_ = NULL;
#line 1644 "DirectPhoto.c"
	} else {
		GdkPixbuf* _tmp6_ = NULL;
		PhotoMetadata* _tmp7_;
		PhotoPreview* _tmp8_;
		PhotoPreview* _tmp9_;
		GdkPixbuf* _tmp10_;
		GdkPixbuf* _tmp11_;
		Orientation _tmp12_;
		GdkPixbuf* _tmp13_;
#line 127 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		_tmp7_ = metadata;
#line 127 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		_tmp8_ = photo_metadata_get_preview (_tmp7_, (guint) 0);
#line 127 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		_tmp9_ = _tmp8_;
#line 127 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		_tmp10_ = photo_preview_get_pixbuf (_tmp9_, &_inner_error_);
#line 127 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		_tmp11_ = _tmp10_;
#line 127 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		_photo_preview_unref0 (_tmp9_);
#line 127 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		_tmp6_ = _tmp11_;
#line 127 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 127 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
			g_propagate_error (error, _inner_error_);
#line 127 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
			_g_object_unref0 (_tmp1_);
#line 127 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
			_media_metadata_unref0 (metadata);
#line 127 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
			return NULL;
#line 1678 "DirectPhoto.c"
		}
#line 127 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		_tmp12_ = photo_get_orientation (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO, Photo));
#line 127 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		_tmp13_ = orientation_rotate_pixbuf (_tmp12_, _tmp6_);
#line 127 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		_g_object_unref0 (_tmp1_);
#line 127 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		_tmp1_ = _tmp13_;
#line 126 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		_g_object_unref0 (_tmp6_);
#line 1690 "DirectPhoto.c"
	}
#line 126 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	result = _tmp1_;
#line 126 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_media_metadata_unref0 (metadata);
#line 126 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	return result;
#line 1698 "DirectPhoto.c"
}


static void direct_photo_real_notify_altered (DataObject* base, Alteration* alteration) {
	DirectPhoto * self;
	Alteration* _tmp0_;
#line 130 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DIRECT_PHOTO, DirectPhoto);
#line 130 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	g_return_if_fail (IS_ALTERATION (alteration));
#line 131 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_g_object_unref0 (self->priv->preview);
#line 131 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	self->priv->preview = NULL;
#line 133 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_tmp0_ = alteration;
#line 133 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	DATA_OBJECT_CLASS (direct_photo_parent_class)->notify_altered (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO, Photo), TYPE_DATA_OBJECT, DataObject), _tmp0_);
#line 1717 "DirectPhoto.c"
}


static gboolean direct_photo_real_has_user_generated_metadata (Photo* base) {
	DirectPhoto * self;
	gboolean result = FALSE;
#line 136 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DIRECT_PHOTO, DirectPhoto);
#line 138 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	result = FALSE;
#line 138 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	return result;
#line 1730 "DirectPhoto.c"
}


static void direct_photo_real_set_user_metadata_for_export (Photo* base, PhotoMetadata* metadata) {
	DirectPhoto * self;
#line 141 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DIRECT_PHOTO, DirectPhoto);
#line 141 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	g_return_if_fail (IS_PHOTO_METADATA (metadata));
#line 1740 "DirectPhoto.c"
}


static void direct_photo_real_apply_user_metadata_for_reimport (Photo* base, PhotoMetadata* metadata) {
	DirectPhoto * self;
#line 145 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DIRECT_PHOTO, DirectPhoto);
#line 145 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	g_return_if_fail (IS_PHOTO_METADATA (metadata));
#line 1750 "DirectPhoto.c"
}


static gboolean direct_photo_real_is_trashed (MediaSource* base) {
	DirectPhoto * self;
	gboolean result = FALSE;
#line 148 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DIRECT_PHOTO, DirectPhoto);
#line 150 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	result = FALSE;
#line 150 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	return result;
#line 1763 "DirectPhoto.c"
}


static gboolean direct_photo_real_is_offline (MediaSource* base) {
	DirectPhoto * self;
	gboolean result = FALSE;
#line 153 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DIRECT_PHOTO, DirectPhoto);
#line 155 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	result = FALSE;
#line 155 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	return result;
#line 1776 "DirectPhoto.c"
}


static void direct_photo_real_trash (MediaSource* base) {
	DirectPhoto * self;
#line 158 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DIRECT_PHOTO, DirectPhoto);
#line 1784 "DirectPhoto.c"
}


static void direct_photo_real_untrash (MediaSource* base) {
	DirectPhoto * self;
#line 162 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DIRECT_PHOTO, DirectPhoto);
#line 1792 "DirectPhoto.c"
}


static void direct_photo_real_mark_offline (MediaSource* base) {
	DirectPhoto * self;
#line 166 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DIRECT_PHOTO, DirectPhoto);
#line 1800 "DirectPhoto.c"
}


static void direct_photo_real_mark_online (MediaSource* base) {
	DirectPhoto * self;
#line 170 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DIRECT_PHOTO, DirectPhoto);
#line 1808 "DirectPhoto.c"
}


static void direct_photo_class_init (DirectPhotoClass * klass) {
#line 7 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	direct_photo_parent_class = g_type_class_peek_parent (klass);
#line 7 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	g_type_class_add_private (klass, sizeof (DirectPhotoPrivate));
#line 7 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	((MediaSourceClass *) klass)->get_preview_pixbuf = (GdkPixbuf* (*) (MediaSource *, Scaling*, GError**)) direct_photo_real_get_preview_pixbuf;
#line 7 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	((PhotoClass *) klass)->rotate = (void (*) (Photo *, Rotation)) direct_photo_real_rotate;
#line 7 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	((PhotoSourceClass *) klass)->get_pixbuf = (GdkPixbuf* (*) (PhotoSource *, Scaling*, GError**)) direct_photo_real_get_pixbuf;
#line 7 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	((ThumbnailSourceClass *) klass)->get_thumbnail = (GdkPixbuf* (*) (ThumbnailSource *, gint, GError**)) direct_photo_real_get_thumbnail;
#line 7 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	((DataObjectClass *) klass)->notify_altered = (void (*) (DataObject *, Alteration*)) direct_photo_real_notify_altered;
#line 7 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	((PhotoClass *) klass)->has_user_generated_metadata = (gboolean (*) (Photo *)) direct_photo_real_has_user_generated_metadata;
#line 7 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	((PhotoClass *) klass)->set_user_metadata_for_export = (void (*) (Photo *, PhotoMetadata*)) direct_photo_real_set_user_metadata_for_export;
#line 7 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	((PhotoClass *) klass)->apply_user_metadata_for_reimport = (void (*) (Photo *, PhotoMetadata*)) direct_photo_real_apply_user_metadata_for_reimport;
#line 7 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	((MediaSourceClass *) klass)->is_trashed = (gboolean (*) (MediaSource *)) direct_photo_real_is_trashed;
#line 7 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	((MediaSourceClass *) klass)->is_offline = (gboolean (*) (MediaSource *)) direct_photo_real_is_offline;
#line 7 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	((MediaSourceClass *) klass)->trash = (void (*) (MediaSource *)) direct_photo_real_trash;
#line 7 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	((MediaSourceClass *) klass)->untrash = (void (*) (MediaSource *)) direct_photo_real_untrash;
#line 7 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	((MediaSourceClass *) klass)->mark_offline = (void (*) (MediaSource *)) direct_photo_real_mark_offline;
#line 7 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	((MediaSourceClass *) klass)->mark_online = (void (*) (MediaSource *)) direct_photo_real_mark_online;
#line 7 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	G_OBJECT_CLASS (klass)->finalize = direct_photo_finalize;
#line 7 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	direct_photo_signals[DIRECT_PHOTO_CAN_ROTATE_CHANGED_SIGNAL] = g_signal_new ("can-rotate-changed", TYPE_DIRECT_PHOTO, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
#line 1849 "DirectPhoto.c"
}


static void direct_photo_instance_init (DirectPhoto * self) {
#line 7 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	self->priv = DIRECT_PHOTO_GET_PRIVATE (self);
#line 14 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	self->priv->preview = NULL;
#line 15 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	self->priv->loaded = FALSE;
#line 1860 "DirectPhoto.c"
}


static void direct_photo_finalize (GObject * obj) {
	DirectPhoto * self;
#line 7 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DIRECT_PHOTO, DirectPhoto);
#line 14 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_g_object_unref0 (self->priv->preview);
#line 7 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	G_OBJECT_CLASS (direct_photo_parent_class)->finalize (obj);
#line 1872 "DirectPhoto.c"
}


GType direct_photo_get_type (void) {
	static volatile gsize direct_photo_type_id__volatile = 0;
	if (g_once_init_enter (&direct_photo_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DirectPhotoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) direct_photo_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DirectPhoto), 0, (GInstanceInitFunc) direct_photo_instance_init, NULL };
		GType direct_photo_type_id;
		direct_photo_type_id = g_type_register_static (TYPE_PHOTO, "DirectPhoto", &g_define_type_info, 0);
		g_once_init_leave (&direct_photo_type_id__volatile, direct_photo_type_id);
	}
	return direct_photo_type_id__volatile;
}


static guint _file_hash_gee_hash_data_func (gconstpointer v, gpointer self) {
	guint result;
	result = file_hash ((GFile*) v);
#line 178 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	return result;
#line 1893 "DirectPhoto.c"
}


static gboolean _file_equal_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gboolean result;
	result = file_equal ((GFile*) a, (GFile*) b);
#line 178 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	return result;
#line 1902 "DirectPhoto.c"
}


static gint64 _direct_photo_source_collection_get_direct_key_get_source_database_key (DataSource* source, gpointer self) {
	gint64 result;
	result = direct_photo_source_collection_get_direct_key (source);
#line 183 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	return result;
#line 1911 "DirectPhoto.c"
}


static void _direct_photo_source_collection_on_file_discovered_directory_monitor_file_discovered (DirectoryMonitor* _sender, GFile* file, GFileInfo* info, gpointer self) {
#line 187 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	direct_photo_source_collection_on_file_discovered ((DirectPhotoSourceCollection*) self, file, info);
#line 1918 "DirectPhoto.c"
}


static void _direct_photo_source_collection_on_discovery_completed_directory_monitor_discovery_completed (DirectoryMonitor* _sender, gpointer self) {
#line 188 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	direct_photo_source_collection_on_discovery_completed ((DirectPhotoSourceCollection*) self);
#line 1925 "DirectPhoto.c"
}


DirectPhotoSourceCollection* direct_photo_source_collection_construct (GType object_type, GFile* initial_file) {
	DirectPhotoSourceCollection* self = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	DirectoryMonitor* _tmp3_;
	DirectoryMonitor* _tmp4_;
	DirectoryMonitor* _tmp5_;
	DirectoryMonitor* _tmp6_;
#line 182 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	g_return_val_if_fail (G_IS_FILE (initial_file), NULL);
#line 183 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	self = (DirectPhotoSourceCollection*) database_source_collection_construct (object_type, "DirectPhotoSourceCollection", _direct_photo_source_collection_get_direct_key_get_source_database_key, NULL);
#line 186 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_tmp0_ = initial_file;
#line 186 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_tmp1_ = g_file_get_parent (_tmp0_);
#line 186 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_tmp2_ = _tmp1_;
#line 186 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_tmp3_ = directory_monitor_new (_tmp2_, FALSE, FALSE);
#line 186 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_g_object_unref0 (self->priv->monitor);
#line 186 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	self->priv->monitor = _tmp3_;
#line 186 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_g_object_unref0 (_tmp2_);
#line 187 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_tmp4_ = self->priv->monitor;
#line 187 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	g_signal_connect (_tmp4_, "file-discovered", (GCallback) _direct_photo_source_collection_on_file_discovered_directory_monitor_file_discovered, self);
#line 188 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_tmp5_ = self->priv->monitor;
#line 188 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	g_signal_connect (_tmp5_, "discovery-completed", (GCallback) _direct_photo_source_collection_on_discovery_completed_directory_monitor_discovery_completed, self);
#line 190 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_tmp6_ = self->priv->monitor;
#line 190 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	directory_monitor_start_discovery (_tmp6_);
#line 182 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	return self;
#line 1970 "DirectPhoto.c"
}


DirectPhotoSourceCollection* direct_photo_source_collection_new (GFile* initial_file) {
#line 182 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	return direct_photo_source_collection_construct (TYPE_DIRECT_PHOTO_SOURCE_COLLECTION, initial_file);
#line 1977 "DirectPhoto.c"
}


static gboolean direct_photo_source_collection_real_holds_type_of_source (SourceCollection* base, DataSource* source) {
	DirectPhotoSourceCollection * self;
	gboolean result = FALSE;
	DataSource* _tmp0_;
#line 193 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DIRECT_PHOTO_SOURCE_COLLECTION, DirectPhotoSourceCollection);
#line 193 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	g_return_val_if_fail (IS_DATA_SOURCE (source), FALSE);
#line 194 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_tmp0_ = source;
#line 194 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	result = G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, TYPE_DIRECT_PHOTO);
#line 194 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	return result;
#line 1995 "DirectPhoto.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 198 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	return self ? g_object_ref (self) : NULL;
#line 2002 "DirectPhoto.c"
}


static gint64 direct_photo_source_collection_get_direct_key (DataSource* source) {
	gint64 result = 0LL;
	DirectPhoto* photo = NULL;
	DataSource* _tmp0_;
	DirectPhoto* _tmp1_;
	PhotoID photo_id = {0};
	PhotoID _tmp2_ = {0};
	PhotoID _tmp3_;
	gint64 _tmp4_;
#line 197 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	g_return_val_if_fail (IS_DATA_SOURCE (source), 0LL);
#line 198 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_tmp0_ = source;
#line 198 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_DIRECT_PHOTO, DirectPhoto));
#line 198 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	photo = _tmp1_;
#line 199 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	photo_get_photo_id (G_TYPE_CHECK_INSTANCE_CAST (photo, TYPE_PHOTO, Photo), &_tmp2_);
#line 199 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	photo_id = _tmp2_;
#line 201 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_tmp3_ = photo_id;
#line 201 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_tmp4_ = _tmp3_.id;
#line 201 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	result = _tmp4_;
#line 201 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_g_object_unref0 (photo);
#line 201 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	return result;
#line 2037 "DirectPhoto.c"
}


static void direct_photo_source_collection_real_notify_items_added (DataCollection* base, GeeIterable* added) {
	DirectPhotoSourceCollection * self;
	GeeIterable* _tmp16_;
#line 204 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DIRECT_PHOTO_SOURCE_COLLECTION, DirectPhotoSourceCollection);
#line 204 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	g_return_if_fail (GEE_IS_ITERABLE (added));
#line 2048 "DirectPhoto.c"
	{
		GeeIterator* _object_it = NULL;
		GeeIterable* _tmp0_;
		GeeIterator* _tmp1_;
#line 205 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		_tmp0_ = added;
#line 205 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		_tmp1_ = gee_iterable_iterator (_tmp0_);
#line 205 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		_object_it = _tmp1_;
#line 205 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		while (TRUE) {
#line 2061 "DirectPhoto.c"
			GeeIterator* _tmp2_;
			gboolean _tmp3_;
			DataObject* object = NULL;
			GeeIterator* _tmp4_;
			gpointer _tmp5_;
			DirectPhoto* photo = NULL;
			DataObject* _tmp6_;
			DirectPhoto* _tmp7_;
			GFile* file = NULL;
			DirectPhoto* _tmp8_;
			GFile* _tmp9_;
			GeeHashMap* _tmp10_;
			GFile* _tmp11_;
			gboolean _tmp12_;
			GeeHashMap* _tmp13_;
			GFile* _tmp14_;
			DirectPhoto* _tmp15_;
#line 205 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
			_tmp2_ = _object_it;
#line 205 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
			_tmp3_ = gee_iterator_next (_tmp2_);
#line 205 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
			if (!_tmp3_) {
#line 205 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
				break;
#line 2087 "DirectPhoto.c"
			}
#line 205 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
			_tmp4_ = _object_it;
#line 205 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
			_tmp5_ = gee_iterator_get (_tmp4_);
#line 205 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
			object = (DataObject*) _tmp5_;
#line 206 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
			_tmp6_ = object;
#line 206 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
			_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_DIRECT_PHOTO, DirectPhoto));
#line 206 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
			photo = _tmp7_;
#line 207 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
			_tmp8_ = photo;
#line 207 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
			_tmp9_ = media_source_get_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_MEDIA_SOURCE, MediaSource));
#line 207 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
			file = _tmp9_;
#line 209 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
			_tmp10_ = self->priv->file_map;
#line 209 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
			_tmp11_ = file;
#line 209 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
			_tmp12_ = gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp11_);
#line 209 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
			_vala_assert (!_tmp12_, "!file_map.has_key(file)");
#line 211 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
			_tmp13_ = self->priv->file_map;
#line 211 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
			_tmp14_ = file;
#line 211 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
			_tmp15_ = photo;
#line 211 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
			gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp14_, _tmp15_);
#line 205 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
			_g_object_unref0 (file);
#line 205 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
			_g_object_unref0 (photo);
#line 205 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
			_g_object_unref0 (object);
#line 2129 "DirectPhoto.c"
		}
#line 205 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		_g_object_unref0 (_object_it);
#line 2133 "DirectPhoto.c"
	}
#line 214 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_tmp16_ = added;
#line 214 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	DATA_COLLECTION_CLASS (direct_photo_source_collection_parent_class)->notify_items_added (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollection), TYPE_DATA_COLLECTION, DataCollection), _tmp16_);
#line 2139 "DirectPhoto.c"
}


static void direct_photo_source_collection_real_notify_items_removed (DataCollection* base, GeeIterable* removed) {
	DirectPhotoSourceCollection * self;
	GeeIterable* _tmp14_;
#line 217 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DIRECT_PHOTO_SOURCE_COLLECTION, DirectPhotoSourceCollection);
#line 217 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	g_return_if_fail (GEE_IS_ITERABLE (removed));
#line 2150 "DirectPhoto.c"
	{
		GeeIterator* _object_it = NULL;
		GeeIterable* _tmp0_;
		GeeIterator* _tmp1_;
#line 218 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		_tmp0_ = removed;
#line 218 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		_tmp1_ = gee_iterable_iterator (_tmp0_);
#line 218 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		_object_it = _tmp1_;
#line 218 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		while (TRUE) {
#line 2163 "DirectPhoto.c"
			GeeIterator* _tmp2_;
			gboolean _tmp3_;
			DataObject* object = NULL;
			GeeIterator* _tmp4_;
			gpointer _tmp5_;
			DirectPhoto* photo = NULL;
			DataObject* _tmp6_;
			DirectPhoto* _tmp7_;
			GFile* file = NULL;
			DirectPhoto* _tmp8_;
			GFile* _tmp9_;
			gboolean is_removed = FALSE;
			GeeHashMap* _tmp10_;
			GFile* _tmp11_;
			gboolean _tmp12_;
			gboolean _tmp13_;
#line 218 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
			_tmp2_ = _object_it;
#line 218 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
			_tmp3_ = gee_iterator_next (_tmp2_);
#line 218 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
			if (!_tmp3_) {
#line 218 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
				break;
#line 2188 "DirectPhoto.c"
			}
#line 218 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
			_tmp4_ = _object_it;
#line 218 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
			_tmp5_ = gee_iterator_get (_tmp4_);
#line 218 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
			object = (DataObject*) _tmp5_;
#line 219 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
			_tmp6_ = object;
#line 219 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
			_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_DIRECT_PHOTO, DirectPhoto));
#line 219 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
			photo = _tmp7_;
#line 220 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
			_tmp8_ = photo;
#line 220 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
			_tmp9_ = media_source_get_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_MEDIA_SOURCE, MediaSource));
#line 220 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
			file = _tmp9_;
#line 222 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
			_tmp10_ = self->priv->file_map;
#line 222 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
			_tmp11_ = file;
#line 222 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
			_tmp12_ = gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp11_, NULL);
#line 222 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
			is_removed = _tmp12_;
#line 223 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
			_tmp13_ = is_removed;
#line 223 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
			_vala_assert (_tmp13_, "is_removed");
#line 218 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
			_g_object_unref0 (file);
#line 218 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
			_g_object_unref0 (photo);
#line 218 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
			_g_object_unref0 (object);
#line 2226 "DirectPhoto.c"
		}
#line 218 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		_g_object_unref0 (_object_it);
#line 2230 "DirectPhoto.c"
	}
#line 226 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_tmp14_ = removed;
#line 226 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	DATA_COLLECTION_CLASS (direct_photo_source_collection_parent_class)->notify_items_removed (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollection), TYPE_DATA_COLLECTION, DataCollection), _tmp14_);
#line 2236 "DirectPhoto.c"
}


gboolean direct_photo_source_collection_has_source_for_file (DirectPhotoSourceCollection* self, GFile* file) {
	gboolean result = FALSE;
	GeeHashMap* _tmp0_;
	GFile* _tmp1_;
	gboolean _tmp2_;
#line 229 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	g_return_val_if_fail (IS_DIRECT_PHOTO_SOURCE_COLLECTION (self), FALSE);
#line 229 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	g_return_val_if_fail (G_IS_FILE (file), FALSE);
#line 230 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_tmp0_ = self->priv->file_map;
#line 230 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_tmp1_ = file;
#line 230 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_tmp2_ = gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp1_);
#line 230 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	result = _tmp2_;
#line 230 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	return result;
#line 2259 "DirectPhoto.c"
}


static void direct_photo_source_collection_on_file_discovered (DirectPhotoSourceCollection* self, GFile* file, GFileInfo* info) {
	GFile* _tmp0_;
	gboolean _tmp1_;
	GFile* _tmp2_;
	gboolean _tmp3_;
	DirectPhoto* photo = NULL;
	gchar* reason = NULL;
	GFile* _tmp4_;
	DirectPhoto* _tmp5_ = NULL;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	GeeCollection* _tmp9_;
	DirectPhoto* _tmp10_;
	GeeCollection* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
#line 233 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	g_return_if_fail (IS_DIRECT_PHOTO_SOURCE_COLLECTION (self));
#line 233 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	g_return_if_fail (G_IS_FILE (file));
#line 233 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	g_return_if_fail (G_IS_FILE_INFO (info));
#line 235 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_tmp0_ = file;
#line 235 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_tmp1_ = direct_photo_source_collection_has_source_for_file (self, _tmp0_);
#line 235 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	if (_tmp1_) {
#line 236 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		return;
#line 2293 "DirectPhoto.c"
	}
#line 239 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_tmp2_ = file;
#line 239 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_tmp3_ = photo_file_format_is_file_supported (_tmp2_);
#line 239 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	if (!_tmp3_) {
#line 240 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		return;
#line 2303 "DirectPhoto.c"
	}
#line 243 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_tmp4_ = file;
#line 243 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_tmp6_ = direct_photo_source_collection_fetch (self, _tmp4_, &_tmp5_, FALSE);
#line 243 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_g_object_unref0 (photo);
#line 243 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	photo = _tmp5_;
#line 243 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	reason = _tmp6_;
#line 244 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_tmp7_ = reason;
#line 244 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	if (_tmp7_ != NULL) {
#line 2319 "DirectPhoto.c"
		const gchar* _tmp8_;
#line 245 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		_tmp8_ = reason;
#line 245 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		g_warning ("DirectPhoto.vala:245: Error fetching file: %s", _tmp8_);
#line 2325 "DirectPhoto.c"
	}
#line 246 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_tmp9_ = self->priv->prepared_photos;
#line 246 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_tmp10_ = photo;
#line 246 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	gee_collection_add (_tmp9_, _tmp10_);
#line 247 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_tmp11_ = self->priv->prepared_photos;
#line 247 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_tmp12_ = gee_collection_get_size (_tmp11_);
#line 247 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_tmp13_ = _tmp12_;
#line 247 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	if (_tmp13_ >= DIRECT_PHOTO_SOURCE_COLLECTION_DISCOVERED_FILES_BATCH_ADD) {
#line 248 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		direct_photo_source_collection_flush_prepared_photos (self);
#line 2343 "DirectPhoto.c"
	}
#line 233 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_g_free0 (reason);
#line 233 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_g_object_unref0 (photo);
#line 2349 "DirectPhoto.c"
}


static void direct_photo_source_collection_on_discovery_completed (DirectPhotoSourceCollection* self) {
#line 251 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	g_return_if_fail (IS_DIRECT_PHOTO_SOURCE_COLLECTION (self));
#line 252 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	direct_photo_source_collection_flush_prepared_photos (self);
#line 2358 "DirectPhoto.c"
}


static void direct_photo_source_collection_flush_prepared_photos (DirectPhotoSourceCollection* self) {
	GeeCollection* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* _tmp2_;
	GeeCollection* _tmp3_;
#line 255 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	g_return_if_fail (IS_DIRECT_PHOTO_SOURCE_COLLECTION (self));
#line 256 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_tmp0_ = self->priv->prepared_photos;
#line 256 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_tmp1_ = data_collection_add_many (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), _tmp0_, NULL, NULL);
#line 256 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_tmp2_ = _tmp1_;
#line 256 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_g_object_unref0 (_tmp2_);
#line 257 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_tmp3_ = self->priv->prepared_photos;
#line 257 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	gee_collection_clear (_tmp3_);
#line 2381 "DirectPhoto.c"
}


gboolean direct_photo_source_collection_has_file (DirectPhotoSourceCollection* self, GFile* file) {
	gboolean result = FALSE;
	GeeHashMap* _tmp0_;
	GFile* _tmp1_;
	gboolean _tmp2_;
#line 260 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	g_return_val_if_fail (IS_DIRECT_PHOTO_SOURCE_COLLECTION (self), FALSE);
#line 260 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	g_return_val_if_fail (G_IS_FILE (file), FALSE);
#line 261 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_tmp0_ = self->priv->file_map;
#line 261 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_tmp1_ = file;
#line 261 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_tmp2_ = gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp1_);
#line 261 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	result = _tmp2_;
#line 261 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	return result;
#line 2404 "DirectPhoto.c"
}


void direct_photo_source_collection_reimport_photo (DirectPhotoSourceCollection* self, DirectPhoto* photo) {
	DirectPhoto* _tmp0_;
	DirectPhoto* reimported_photo = NULL;
	DirectPhoto* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	DirectPhoto* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_;
#line 264 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	g_return_if_fail (IS_DIRECT_PHOTO_SOURCE_COLLECTION (self));
#line 264 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	g_return_if_fail (IS_DIRECT_PHOTO (photo));
#line 265 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_tmp0_ = photo;
#line 265 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	photo_discard_prefetched (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_PHOTO, Photo));
#line 267 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_tmp1_ = photo;
#line 267 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_tmp2_ = media_source_get_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_MEDIA_SOURCE, MediaSource));
#line 267 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_tmp3_ = _tmp2_;
#line 267 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_tmp5_ = direct_photo_source_collection_fetch (self, _tmp3_, &_tmp4_, TRUE);
#line 267 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_g_object_unref0 (reimported_photo);
#line 267 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	reimported_photo = _tmp4_;
#line 267 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_tmp6_ = _tmp5_;
#line 267 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_g_free0 (_tmp6_);
#line 267 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_g_object_unref0 (_tmp3_);
#line 264 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_g_object_unref0 (reimported_photo);
#line 2445 "DirectPhoto.c"
}


gchar* direct_photo_source_collection_fetch (DirectPhotoSourceCollection* self, GFile* file, DirectPhoto* * photo, gboolean reimport) {
	DirectPhoto* _vala_photo = NULL;
	gchar* result = NULL;
	GeeHashMap* _tmp0_;
	GFile* _tmp1_;
	gpointer _tmp2_;
	DirectPhoto* _tmp3_;
	ImportResult _result_ = 0;
	GFile* _tmp25_;
	DirectPhoto* _tmp26_ = NULL;
	ImportResult _tmp27_;
	gchar* _tmp28_ = NULL;
	ImportResult _tmp29_;
	GError * _inner_error_ = NULL;
#line 271 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	g_return_val_if_fail (IS_DIRECT_PHOTO_SOURCE_COLLECTION (self), NULL);
#line 271 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	g_return_val_if_fail (G_IS_FILE (file), NULL);
#line 273 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_tmp0_ = self->priv->file_map;
#line 273 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_tmp1_ = file;
#line 273 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_tmp2_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp1_);
#line 273 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_g_object_unref0 (_vala_photo);
#line 273 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_vala_photo = (DirectPhoto*) _tmp2_;
#line 274 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_tmp3_ = _vala_photo;
#line 274 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	if (_tmp3_ != NULL) {
#line 2481 "DirectPhoto.c"
		gchar* reason = NULL;
		gboolean _tmp4_;
#line 275 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		reason = NULL;
#line 277 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		_tmp4_ = reimport;
#line 277 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		if (_tmp4_) {
#line 2490 "DirectPhoto.c"
			{
				Orientation ori_tmp = 0;
				gboolean should_restore_ori = FALSE;
				gboolean _tmp5_ = FALSE;
				DirectPhoto* _tmp6_;
				gboolean _tmp7_;
				PhotoReimportMasterState* reimport_state = NULL;
				gboolean _tmp12_ = FALSE;
				DirectPhoto* _tmp13_;
				PhotoReimportMasterState* _tmp14_ = NULL;
				gboolean _tmp15_;
#line 279 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
				ori_tmp = ORIENTATION_TOP_LEFT;
#line 280 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
				should_restore_ori = FALSE;
#line 282 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
				_tmp6_ = _vala_photo;
#line 282 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
				_tmp7_ = photo_only_metadata_changed (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_PHOTO, Photo));
#line 282 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
				if (_tmp7_) {
#line 282 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
					_tmp5_ = TRUE;
#line 2514 "DirectPhoto.c"
				} else {
					DirectPhoto* _tmp8_;
					PhotoFileFormat _tmp9_;
#line 283 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
					_tmp8_ = _vala_photo;
#line 283 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
					_tmp9_ = photo_get_file_format (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_PHOTO, Photo));
#line 283 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
					_tmp5_ = _tmp9_ == PHOTO_FILE_FORMAT_JFIF;
#line 2524 "DirectPhoto.c"
				}
#line 282 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
				if (_tmp5_) {
#line 2528 "DirectPhoto.c"
					DirectPhoto* _tmp10_;
					Orientation _tmp11_;
#line 284 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
					_tmp10_ = _vala_photo;
#line 284 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
					_tmp11_ = photo_get_orientation (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_PHOTO, Photo));
#line 284 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
					ori_tmp = _tmp11_;
#line 285 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
					should_restore_ori = TRUE;
#line 2539 "DirectPhoto.c"
				}
#line 289 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
				_tmp13_ = _vala_photo;
#line 289 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
				_tmp15_ = photo_prepare_for_reimport_master (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, TYPE_PHOTO, Photo), &_tmp14_, &_inner_error_);
#line 289 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
				_photo_reimport_master_state_unref0 (reimport_state);
#line 289 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
				reimport_state = _tmp14_;
#line 289 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
				_tmp12_ = _tmp15_;
#line 289 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 289 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
					_photo_reimport_master_state_unref0 (reimport_state);
#line 2555 "DirectPhoto.c"
					goto __catch51_g_error;
				}
#line 289 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
				if (_tmp12_) {
#line 2560 "DirectPhoto.c"
					DirectPhoto* _tmp16_;
					PhotoReimportMasterState* _tmp17_;
					gboolean _tmp18_;
#line 290 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
					_tmp16_ = _vala_photo;
#line 290 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
					_tmp17_ = reimport_state;
#line 290 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
					photo_finish_reimport_master (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, TYPE_PHOTO, Photo), _tmp17_, &_inner_error_);
#line 290 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 290 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
						_photo_reimport_master_state_unref0 (reimport_state);
#line 2574 "DirectPhoto.c"
						goto __catch51_g_error;
					}
#line 291 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
					_tmp18_ = should_restore_ori;
#line 291 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
					if (_tmp18_) {
#line 2581 "DirectPhoto.c"
						DirectPhoto* _tmp19_;
						Orientation _tmp20_;
#line 292 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
						_tmp19_ = _vala_photo;
#line 292 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
						_tmp20_ = ori_tmp;
#line 292 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
						direct_photo_fixup_orientation_after_reimport (_tmp19_, _tmp20_);
#line 2590 "DirectPhoto.c"
					}
				} else {
					gchar* _tmp21_;
#line 296 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
					_tmp21_ = import_result_to_string (IMPORT_RESULT_FILE_ERROR);
#line 296 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
					_g_free0 (reason);
#line 296 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
					reason = _tmp21_;
#line 2600 "DirectPhoto.c"
				}
#line 278 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
				_photo_reimport_master_state_unref0 (reimport_state);
#line 2604 "DirectPhoto.c"
			}
			goto __finally51;
			__catch51_g_error:
			{
				GError* err = NULL;
				GError* _tmp22_;
				const gchar* _tmp23_;
				gchar* _tmp24_;
#line 278 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
				err = _inner_error_;
#line 278 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
				_inner_error_ = NULL;
#line 299 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
				_tmp22_ = err;
#line 299 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
				_tmp23_ = _tmp22_->message;
#line 299 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
				_tmp24_ = g_strdup (_tmp23_);
#line 299 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
				_g_free0 (reason);
#line 299 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
				reason = _tmp24_;
#line 278 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
				_g_error_free0 (err);
#line 2629 "DirectPhoto.c"
			}
			__finally51:
#line 278 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 278 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
				_g_free0 (reason);
#line 278 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 278 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
				g_clear_error (&_inner_error_);
#line 278 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
				return NULL;
#line 2642 "DirectPhoto.c"
			}
		}
#line 303 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		result = reason;
#line 303 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		if (photo) {
#line 303 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
			*photo = _vala_photo;
#line 2651 "DirectPhoto.c"
		} else {
#line 303 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
			_g_object_unref0 (_vala_photo);
#line 2655 "DirectPhoto.c"
		}
#line 303 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		return result;
#line 2659 "DirectPhoto.c"
	}
#line 308 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_tmp25_ = file;
#line 308 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_tmp27_ = direct_photo_internal_import (_tmp25_, &_tmp26_);
#line 308 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_g_object_unref0 (_vala_photo);
#line 308 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_vala_photo = _tmp26_;
#line 308 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_result_ = _tmp27_;
#line 310 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_tmp29_ = _result_;
#line 310 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	if (_tmp29_ == IMPORT_RESULT_SUCCESS) {
#line 310 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		_g_free0 (_tmp28_);
#line 310 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		_tmp28_ = NULL;
#line 2679 "DirectPhoto.c"
	} else {
		ImportResult _tmp30_;
		gchar* _tmp31_;
#line 310 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		_tmp30_ = _result_;
#line 310 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		_tmp31_ = import_result_to_string (_tmp30_);
#line 310 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		_g_free0 (_tmp28_);
#line 310 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		_tmp28_ = _tmp31_;
#line 2691 "DirectPhoto.c"
	}
#line 310 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	result = _tmp28_;
#line 310 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	if (photo) {
#line 310 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		*photo = _vala_photo;
#line 2699 "DirectPhoto.c"
	} else {
#line 310 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
		_g_object_unref0 (_vala_photo);
#line 2703 "DirectPhoto.c"
	}
#line 310 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	return result;
#line 2707 "DirectPhoto.c"
}


gboolean direct_photo_source_collection_has_file_source (DirectPhotoSourceCollection* self, GFile* file) {
	gboolean result = FALSE;
	GeeHashMap* _tmp0_;
	GFile* _tmp1_;
	gboolean _tmp2_;
#line 313 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	g_return_val_if_fail (IS_DIRECT_PHOTO_SOURCE_COLLECTION (self), FALSE);
#line 313 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	g_return_val_if_fail (G_IS_FILE (file), FALSE);
#line 314 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_tmp0_ = self->priv->file_map;
#line 314 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_tmp1_ = file;
#line 314 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_tmp2_ = gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp1_);
#line 314 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	result = _tmp2_;
#line 314 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	return result;
#line 2730 "DirectPhoto.c"
}


DirectPhoto* direct_photo_source_collection_get_file_source (DirectPhotoSourceCollection* self, GFile* file) {
	DirectPhoto* result = NULL;
	GeeHashMap* _tmp0_;
	GFile* _tmp1_;
	gpointer _tmp2_;
#line 317 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	g_return_val_if_fail (IS_DIRECT_PHOTO_SOURCE_COLLECTION (self), NULL);
#line 317 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	g_return_val_if_fail (G_IS_FILE (file), NULL);
#line 318 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_tmp0_ = self->priv->file_map;
#line 318 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_tmp1_ = file;
#line 318 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_tmp2_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp1_);
#line 318 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	result = (DirectPhoto*) _tmp2_;
#line 318 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	return result;
#line 2753 "DirectPhoto.c"
}


static void direct_photo_source_collection_class_init (DirectPhotoSourceCollectionClass * klass) {
#line 175 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	direct_photo_source_collection_parent_class = g_type_class_peek_parent (klass);
#line 175 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	((DataCollectionClass *) klass)->finalize = direct_photo_source_collection_finalize;
#line 175 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	g_type_class_add_private (klass, sizeof (DirectPhotoSourceCollectionPrivate));
#line 175 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	((SourceCollectionClass *) klass)->holds_type_of_source = (gboolean (*) (SourceCollection *, DataSource*)) direct_photo_source_collection_real_holds_type_of_source;
#line 175 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	((DataCollectionClass *) klass)->notify_items_added = (void (*) (DataCollection *, GeeIterable*)) direct_photo_source_collection_real_notify_items_added;
#line 175 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	((DataCollectionClass *) klass)->notify_items_removed = (void (*) (DataCollection *, GeeIterable*)) direct_photo_source_collection_real_notify_items_removed;
#line 2770 "DirectPhoto.c"
}


static void direct_photo_source_collection_instance_init (DirectPhotoSourceCollection * self) {
	GeeArrayList* _tmp0_;
	GeeHashMap* _tmp1_;
#line 175 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	self->priv = DIRECT_PHOTO_SOURCE_COLLECTION_GET_PRIVATE (self);
#line 177 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_tmp0_ = gee_array_list_new (TYPE_DIRECT_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 177 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	self->priv->prepared_photos = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection);
#line 178 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_tmp1_ = gee_hash_map_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, TYPE_DIRECT_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _file_hash_gee_hash_data_func, NULL, NULL, _file_equal_gee_equal_data_func, NULL, NULL, NULL, NULL, NULL);
#line 178 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	self->priv->file_map = _tmp1_;
#line 2787 "DirectPhoto.c"
}


static void direct_photo_source_collection_finalize (DataCollection * obj) {
	DirectPhotoSourceCollection * self;
#line 175 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DIRECT_PHOTO_SOURCE_COLLECTION, DirectPhotoSourceCollection);
#line 177 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_g_object_unref0 (self->priv->prepared_photos);
#line 178 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_g_object_unref0 (self->priv->file_map);
#line 180 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	_g_object_unref0 (self->priv->monitor);
#line 175 "/home/jens/Source/shotwell/src/direct/DirectPhoto.vala"
	DATA_COLLECTION_CLASS (direct_photo_source_collection_parent_class)->finalize (obj);
#line 2803 "DirectPhoto.c"
}


GType direct_photo_source_collection_get_type (void) {
	static volatile gsize direct_photo_source_collection_type_id__volatile = 0;
	if (g_once_init_enter (&direct_photo_source_collection_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DirectPhotoSourceCollectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) direct_photo_source_collection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DirectPhotoSourceCollection), 0, (GInstanceInitFunc) direct_photo_source_collection_instance_init, NULL };
		GType direct_photo_source_collection_type_id;
		direct_photo_source_collection_type_id = g_type_register_static (TYPE_DATABASE_SOURCE_COLLECTION, "DirectPhotoSourceCollection", &g_define_type_info, 0);
		g_once_init_leave (&direct_photo_source_collection_type_id__volatile, direct_photo_source_collection_type_id);
	}
	return direct_photo_source_collection_type_id__volatile;
}



