/* ChessEffect.c generated by valac 0.40.4, the Vala compiler
 * generated from ChessEffect.vala, do not modify */

/* Copyright 2013 Jens Bav
 * Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */


#include <glib.h>
#include <glib-object.h>
#include <shotwell-plugin-dev-1.0.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <cairo.h>
#include <gdk/gdk.h>


#define TYPE_SHOTWELL_TRANSITION_DESCRIPTOR (shotwell_transition_descriptor_get_type ())
#define SHOTWELL_TRANSITION_DESCRIPTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SHOTWELL_TRANSITION_DESCRIPTOR, ShotwellTransitionDescriptor))
#define SHOTWELL_TRANSITION_DESCRIPTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SHOTWELL_TRANSITION_DESCRIPTOR, ShotwellTransitionDescriptorClass))
#define IS_SHOTWELL_TRANSITION_DESCRIPTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SHOTWELL_TRANSITION_DESCRIPTOR))
#define IS_SHOTWELL_TRANSITION_DESCRIPTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SHOTWELL_TRANSITION_DESCRIPTOR))
#define SHOTWELL_TRANSITION_DESCRIPTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SHOTWELL_TRANSITION_DESCRIPTOR, ShotwellTransitionDescriptorClass))

typedef struct _ShotwellTransitionDescriptor ShotwellTransitionDescriptor;
typedef struct _ShotwellTransitionDescriptorClass ShotwellTransitionDescriptorClass;
typedef struct _ShotwellTransitionDescriptorPrivate ShotwellTransitionDescriptorPrivate;

#define TYPE_CHESS_EFFECT_DESCRIPTOR (chess_effect_descriptor_get_type ())
#define CHESS_EFFECT_DESCRIPTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_EFFECT_DESCRIPTOR, ChessEffectDescriptor))
#define CHESS_EFFECT_DESCRIPTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_EFFECT_DESCRIPTOR, ChessEffectDescriptorClass))
#define IS_CHESS_EFFECT_DESCRIPTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_EFFECT_DESCRIPTOR))
#define IS_CHESS_EFFECT_DESCRIPTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_EFFECT_DESCRIPTOR))
#define CHESS_EFFECT_DESCRIPTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_EFFECT_DESCRIPTOR, ChessEffectDescriptorClass))

typedef struct _ChessEffectDescriptor ChessEffectDescriptor;
typedef struct _ChessEffectDescriptorClass ChessEffectDescriptorClass;
typedef struct _ChessEffectDescriptorPrivate ChessEffectDescriptorPrivate;
enum  {
	CHESS_EFFECT_DESCRIPTOR_0_PROPERTY,
	CHESS_EFFECT_DESCRIPTOR_NUM_PROPERTIES
};
static GParamSpec* chess_effect_descriptor_properties[CHESS_EFFECT_DESCRIPTOR_NUM_PROPERTIES];

#define TYPE_CHESS_EFFECT (chess_effect_get_type ())
#define CHESS_EFFECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_EFFECT, ChessEffect))
#define CHESS_EFFECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_EFFECT, ChessEffectClass))
#define IS_CHESS_EFFECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_EFFECT))
#define IS_CHESS_EFFECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_EFFECT))
#define CHESS_EFFECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_EFFECT, ChessEffectClass))

typedef struct _ChessEffect ChessEffect;
typedef struct _ChessEffectClass ChessEffectClass;
typedef struct _ChessEffectPrivate ChessEffectPrivate;
enum  {
	CHESS_EFFECT_0_PROPERTY,
	CHESS_EFFECT_NUM_PROPERTIES
};
static GParamSpec* chess_effect_properties[CHESS_EFFECT_NUM_PROPERTIES];

struct _ShotwellTransitionDescriptor {
	GObject parent_instance;
	ShotwellTransitionDescriptorPrivate * priv;
};

struct _ShotwellTransitionDescriptorClass {
	GObjectClass parent_class;
	const gchar* (*get_id) (ShotwellTransitionDescriptor* self);
	const gchar* (*get_pluggable_name) (ShotwellTransitionDescriptor* self);
	SpitTransitionsEffect* (*create) (ShotwellTransitionDescriptor* self, SpitHostInterface* host);
};

struct _ChessEffectDescriptor {
	ShotwellTransitionDescriptor parent_instance;
	ChessEffectDescriptorPrivate * priv;
};

struct _ChessEffectDescriptorClass {
	ShotwellTransitionDescriptorClass parent_class;
};

struct _ChessEffect {
	GObject parent_instance;
	ChessEffectPrivate * priv;
};

struct _ChessEffectClass {
	GObjectClass parent_class;
};

struct _ChessEffectPrivate {
	gdouble square_count_x;
	gdouble square_count_y;
};


static gpointer chess_effect_descriptor_parent_class = NULL;
static gpointer chess_effect_parent_class = NULL;
static SpitTransitionsEffectIface * chess_effect_spit_transitions_effect_parent_iface = NULL;

GType shotwell_transition_descriptor_get_type (void) G_GNUC_CONST;
GType chess_effect_descriptor_get_type (void) G_GNUC_CONST;
ChessEffectDescriptor* chess_effect_descriptor_new (GFile* resource_directory);
ChessEffectDescriptor* chess_effect_descriptor_construct (GType object_type,
                                                          GFile* resource_directory);
ShotwellTransitionDescriptor* shotwell_transition_descriptor_construct (GType object_type,
                                                                        GFile* resource_directory);
static const gchar* chess_effect_descriptor_real_get_id (ShotwellTransitionDescriptor* base);
static const gchar* chess_effect_descriptor_real_get_pluggable_name (ShotwellTransitionDescriptor* base);
static SpitTransitionsEffect* chess_effect_descriptor_real_create (ShotwellTransitionDescriptor* base,
                                                            SpitHostInterface* host);
ChessEffect* chess_effect_new (void);
ChessEffect* chess_effect_construct (GType object_type);
GType chess_effect_get_type (void) G_GNUC_CONST;
#define CHESS_EFFECT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CHESS_EFFECT, ChessEffectPrivate))
#define CHESS_EFFECT_DESIRED_FPS 25
#define CHESS_EFFECT_MIN_FPS 10
#define CHESS_EFFECT_SQUARE_SIZE 100
static void chess_effect_real_get_fps (SpitTransitionsEffect* base,
                                gint* desired_fps,
                                gint* min_fps);
static void chess_effect_real_start (SpitTransitionsEffect* base,
                              SpitTransitionsVisuals* visuals,
                              SpitTransitionsMotion* motion);
static gboolean chess_effect_real_needs_clear_background (SpitTransitionsEffect* base);
static void chess_effect_real_paint (SpitTransitionsEffect* base,
                              SpitTransitionsVisuals* visuals,
                              SpitTransitionsMotion* motion,
                              cairo_t* ctx,
                              gint width,
                              gint height,
                              gint frame_number);
static void chess_effect_real_advance (SpitTransitionsEffect* base,
                                SpitTransitionsVisuals* visuals,
                                SpitTransitionsMotion* motion,
                                gint frame_number);
static void chess_effect_real_cancel (SpitTransitionsEffect* base);
static void chess_effect_finalize (GObject * obj);


ChessEffectDescriptor*
chess_effect_descriptor_construct (GType object_type,
                                   GFile* resource_directory)
{
	ChessEffectDescriptor * self = NULL;
#line 11 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	g_return_val_if_fail (G_IS_FILE (resource_directory), NULL);
#line 12 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	self = (ChessEffectDescriptor*) shotwell_transition_descriptor_construct (object_type, resource_directory);
#line 11 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	return self;
#line 160 "ChessEffect.c"
}


ChessEffectDescriptor*
chess_effect_descriptor_new (GFile* resource_directory)
{
#line 11 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	return chess_effect_descriptor_construct (TYPE_CHESS_EFFECT_DESCRIPTOR, resource_directory);
#line 169 "ChessEffect.c"
}


static const gchar*
chess_effect_descriptor_real_get_id (ShotwellTransitionDescriptor* base)
{
	ChessEffectDescriptor * self;
	const gchar* result = NULL;
#line 15 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CHESS_EFFECT_DESCRIPTOR, ChessEffectDescriptor);
#line 16 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	result = "org.yorba.shotwell.transitions.chess";
#line 16 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	return result;
#line 184 "ChessEffect.c"
}


static const gchar*
chess_effect_descriptor_real_get_pluggable_name (ShotwellTransitionDescriptor* base)
{
	ChessEffectDescriptor * self;
	const gchar* result = NULL;
#line 19 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CHESS_EFFECT_DESCRIPTOR, ChessEffectDescriptor);
#line 20 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	result = _ ("Chess");
#line 20 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	return result;
#line 199 "ChessEffect.c"
}


static SpitTransitionsEffect*
chess_effect_descriptor_real_create (ShotwellTransitionDescriptor* base,
                                     SpitHostInterface* host)
{
	ChessEffectDescriptor * self;
	SpitTransitionsEffect* result = NULL;
	ChessEffect* _tmp0_;
#line 23 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CHESS_EFFECT_DESCRIPTOR, ChessEffectDescriptor);
#line 23 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	g_return_val_if_fail (SPIT_IS_HOST_INTERFACE (host), NULL);
#line 24 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	_tmp0_ = chess_effect_new ();
#line 24 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, SPIT_TRANSITIONS_TYPE_EFFECT, SpitTransitionsEffect);
#line 24 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	return result;
#line 220 "ChessEffect.c"
}


static void
chess_effect_descriptor_class_init (ChessEffectDescriptorClass * klass)
{
#line 10 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	chess_effect_descriptor_parent_class = g_type_class_peek_parent (klass);
#line 10 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	((ShotwellTransitionDescriptorClass *) klass)->get_id = (const gchar* (*) (ShotwellTransitionDescriptor *)) chess_effect_descriptor_real_get_id;
#line 10 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	((ShotwellTransitionDescriptorClass *) klass)->get_pluggable_name = (const gchar* (*) (ShotwellTransitionDescriptor *)) chess_effect_descriptor_real_get_pluggable_name;
#line 10 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	((ShotwellTransitionDescriptorClass *) klass)->create = (SpitTransitionsEffect* (*) (ShotwellTransitionDescriptor *, SpitHostInterface*)) chess_effect_descriptor_real_create;
#line 235 "ChessEffect.c"
}


static void
chess_effect_descriptor_instance_init (ChessEffectDescriptor * self)
{
}


GType
chess_effect_descriptor_get_type (void)
{
	static volatile gsize chess_effect_descriptor_type_id__volatile = 0;
	if (g_once_init_enter (&chess_effect_descriptor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ChessEffectDescriptorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) chess_effect_descriptor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ChessEffectDescriptor), 0, (GInstanceInitFunc) chess_effect_descriptor_instance_init, NULL };
		GType chess_effect_descriptor_type_id;
		chess_effect_descriptor_type_id = g_type_register_static (TYPE_SHOTWELL_TRANSITION_DESCRIPTOR, "ChessEffectDescriptor", &g_define_type_info, 0);
		g_once_init_leave (&chess_effect_descriptor_type_id__volatile, chess_effect_descriptor_type_id);
	}
	return chess_effect_descriptor_type_id__volatile;
}


ChessEffect*
chess_effect_construct (GType object_type)
{
	ChessEffect * self = NULL;
#line 35 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	self = (ChessEffect*) g_object_new (object_type, NULL);
#line 35 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	return self;
#line 267 "ChessEffect.c"
}


ChessEffect*
chess_effect_new (void)
{
#line 35 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	return chess_effect_construct (TYPE_CHESS_EFFECT);
#line 276 "ChessEffect.c"
}


static void
chess_effect_real_get_fps (SpitTransitionsEffect* base,
                           gint* desired_fps,
                           gint* min_fps)
{
	ChessEffect * self;
	gint _vala_desired_fps = 0;
	gint _vala_min_fps = 0;
#line 38 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CHESS_EFFECT, ChessEffect);
#line 39 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	_vala_desired_fps = CHESS_EFFECT_DESIRED_FPS;
#line 40 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	_vala_min_fps = CHESS_EFFECT_MIN_FPS;
#line 38 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	if (desired_fps) {
#line 38 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
		*desired_fps = _vala_desired_fps;
#line 298 "ChessEffect.c"
	}
#line 38 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	if (min_fps) {
#line 38 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
		*min_fps = _vala_min_fps;
#line 304 "ChessEffect.c"
	}
}


static void
chess_effect_real_start (SpitTransitionsEffect* base,
                         SpitTransitionsVisuals* visuals,
                         SpitTransitionsMotion* motion)
{
	ChessEffect * self;
	GdkRectangle _tmp0_ = {0};
	GdkRectangle _tmp1_;
	gint _tmp2_;
	GdkRectangle _tmp3_ = {0};
	GdkRectangle _tmp4_;
	gint _tmp5_;
#line 43 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CHESS_EFFECT, ChessEffect);
#line 43 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_VISUALS (visuals));
#line 43 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_MOTION (motion));
#line 44 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	spit_transitions_visuals_get_to_pos (visuals, &_tmp0_);
#line 44 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	_tmp1_ = _tmp0_;
#line 44 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	_tmp2_ = _tmp1_.height;
#line 44 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	self->priv->square_count_y = (gdouble) ((_tmp2_ / CHESS_EFFECT_SQUARE_SIZE) + 2);
#line 45 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	spit_transitions_visuals_get_to_pos (visuals, &_tmp3_);
#line 45 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	_tmp4_ = _tmp3_;
#line 45 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	_tmp5_ = _tmp4_.width;
#line 45 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	self->priv->square_count_x = (gdouble) ((_tmp5_ / CHESS_EFFECT_SQUARE_SIZE) + 2);
#line 343 "ChessEffect.c"
}


static gboolean
chess_effect_real_needs_clear_background (SpitTransitionsEffect* base)
{
	ChessEffect * self;
	gboolean result = FALSE;
#line 48 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CHESS_EFFECT, ChessEffect);
#line 49 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	result = TRUE;
#line 49 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	return result;
#line 358 "ChessEffect.c"
}


static void
chess_effect_real_paint (SpitTransitionsEffect* base,
                         SpitTransitionsVisuals* visuals,
                         SpitTransitionsMotion* motion,
                         cairo_t* ctx,
                         gint width,
                         gint height,
                         gint frame_number)
{
	ChessEffect * self;
	gdouble alpha = 0.0;
	gdouble size = 0.0;
	gdouble _tmp0_;
	GdkPixbuf* _tmp1_;
	GdkPixbuf* _tmp2_;
	GdkPixbuf* _tmp12_;
	GdkPixbuf* _tmp13_;
#line 52 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CHESS_EFFECT, ChessEffect);
#line 52 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_VISUALS (visuals));
#line 52 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_MOTION (motion));
#line 52 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	g_return_if_fail (ctx != NULL);
#line 54 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	alpha = spit_transitions_motion_get_alpha (motion, frame_number);
#line 55 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	_tmp0_ = alpha;
#line 55 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	size = (2 * _tmp0_) * CHESS_EFFECT_SQUARE_SIZE;
#line 56 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	_tmp1_ = spit_transitions_visuals_get_from_pixbuf (visuals);
#line 56 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	_tmp2_ = _tmp1_;
#line 56 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	if (_tmp2_ != NULL) {
#line 399 "ChessEffect.c"
		GdkPixbuf* _tmp3_;
		GdkPixbuf* _tmp4_;
		GdkRectangle _tmp5_ = {0};
		GdkRectangle _tmp6_;
		gint _tmp7_;
		GdkRectangle _tmp8_ = {0};
		GdkRectangle _tmp9_;
		gint _tmp10_;
		gdouble _tmp11_;
#line 57 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
		_tmp3_ = spit_transitions_visuals_get_from_pixbuf (visuals);
#line 57 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
		_tmp4_ = _tmp3_;
#line 57 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
		spit_transitions_visuals_get_from_pos (visuals, &_tmp5_);
#line 57 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
		_tmp6_ = _tmp5_;
#line 57 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
		_tmp7_ = _tmp6_.x;
#line 57 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
		spit_transitions_visuals_get_from_pos (visuals, &_tmp8_);
#line 57 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
		_tmp9_ = _tmp8_;
#line 57 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
		_tmp10_ = _tmp9_.y;
#line 57 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
		gdk_cairo_set_source_pixbuf (ctx, _tmp4_, (gdouble) _tmp7_, (gdouble) _tmp10_);
#line 59 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
		_tmp11_ = alpha;
#line 59 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
		cairo_paint_with_alpha (ctx, 1 - _tmp11_);
#line 431 "ChessEffect.c"
	}
#line 62 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	_tmp12_ = spit_transitions_visuals_get_to_pixbuf (visuals);
#line 62 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	_tmp13_ = _tmp12_;
#line 62 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	if (_tmp13_ != NULL) {
#line 439 "ChessEffect.c"
		GdkPixbuf* _tmp14_;
		GdkPixbuf* _tmp15_;
		GdkRectangle _tmp16_ = {0};
		GdkRectangle _tmp17_;
		gint _tmp18_;
		GdkRectangle _tmp19_ = {0};
		GdkRectangle _tmp20_;
		gint _tmp21_;
		gdouble _tmp59_;
#line 63 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
		_tmp14_ = spit_transitions_visuals_get_to_pixbuf (visuals);
#line 63 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
		_tmp15_ = _tmp14_;
#line 63 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
		spit_transitions_visuals_get_to_pos (visuals, &_tmp16_);
#line 63 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
		_tmp17_ = _tmp16_;
#line 63 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
		_tmp18_ = _tmp17_.x;
#line 63 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
		spit_transitions_visuals_get_to_pos (visuals, &_tmp19_);
#line 63 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
		_tmp20_ = _tmp19_;
#line 63 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
		_tmp21_ = _tmp20_.y;
#line 63 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
		gdk_cairo_set_source_pixbuf (ctx, _tmp15_, (gdouble) _tmp18_, (gdouble) _tmp21_);
#line 467 "ChessEffect.c"
		{
			gdouble y = 0.0;
#line 64 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
			y = (gdouble) 0;
#line 472 "ChessEffect.c"
			{
				gboolean _tmp22_ = FALSE;
#line 64 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
				_tmp22_ = TRUE;
#line 64 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
				while (TRUE) {
#line 479 "ChessEffect.c"
					gdouble _tmp24_;
					gdouble _tmp25_;
#line 64 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
					if (!_tmp22_) {
#line 484 "ChessEffect.c"
						gdouble _tmp23_;
#line 64 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
						_tmp23_ = y;
#line 64 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
						y = _tmp23_ + 1;
#line 490 "ChessEffect.c"
					}
#line 64 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
					_tmp22_ = FALSE;
#line 64 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
					_tmp24_ = y;
#line 64 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
					_tmp25_ = self->priv->square_count_y;
#line 64 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
					if (!(_tmp24_ <= _tmp25_)) {
#line 64 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
						break;
#line 502 "ChessEffect.c"
					}
					{
						gdouble x = 0.0;
#line 65 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
						x = (gdouble) 0;
#line 508 "ChessEffect.c"
						{
							gboolean _tmp26_ = FALSE;
#line 65 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
							_tmp26_ = TRUE;
#line 65 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
							while (TRUE) {
#line 515 "ChessEffect.c"
								gdouble _tmp28_;
								gdouble _tmp29_;
								gdouble _tmp30_ = 0.0;
								gdouble _tmp31_;
								gdouble _tmp32_;
								gdouble translation = 0.0;
								SpitTransitionsDirection _tmp33_;
								SpitTransitionsDirection _tmp34_;
#line 65 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
								if (!_tmp26_) {
#line 526 "ChessEffect.c"
									gdouble _tmp27_;
#line 65 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
									_tmp27_ = x;
#line 65 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
									x = _tmp27_ + 1;
#line 532 "ChessEffect.c"
								}
#line 65 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
								_tmp26_ = FALSE;
#line 65 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
								_tmp28_ = x;
#line 65 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
								_tmp29_ = self->priv->square_count_x;
#line 65 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
								if (!(_tmp28_ <= _tmp29_)) {
#line 65 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
									break;
#line 544 "ChessEffect.c"
								}
#line 66 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
								_tmp31_ = x;
#line 66 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
								_tmp32_ = y;
#line 66 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
								if (fmod (_tmp31_ + _tmp32_, 2) == ((gdouble) 0)) {
#line 66 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
									_tmp30_ = (-1.5) * CHESS_EFFECT_SQUARE_SIZE;
#line 554 "ChessEffect.c"
								} else {
#line 66 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
									_tmp30_ = 1.5 * CHESS_EFFECT_SQUARE_SIZE;
#line 558 "ChessEffect.c"
								}
#line 66 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
								translation = _tmp30_;
#line 67 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
								_tmp33_ = spit_transitions_motion_get_direction (motion);
#line 67 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
								_tmp34_ = _tmp33_;
#line 67 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
								if (_tmp34_ == SPIT_TRANSITIONS_DIRECTION_FORWARD) {
#line 568 "ChessEffect.c"
									GdkRectangle _tmp35_ = {0};
									GdkRectangle _tmp36_;
									gint _tmp37_;
									gdouble _tmp38_;
									gdouble _tmp39_;
									GdkRectangle _tmp40_ = {0};
									GdkRectangle _tmp41_;
									gint _tmp42_;
									gdouble _tmp43_;
									gdouble _tmp44_;
#line 68 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
									spit_transitions_visuals_get_to_pos (visuals, &_tmp35_);
#line 68 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
									_tmp36_ = _tmp35_;
#line 68 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
									_tmp37_ = _tmp36_.x;
#line 68 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
									_tmp38_ = translation;
#line 68 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
									_tmp39_ = x;
#line 68 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
									spit_transitions_visuals_get_to_pos (visuals, &_tmp40_);
#line 68 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
									_tmp41_ = _tmp40_;
#line 68 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
									_tmp42_ = _tmp41_.y;
#line 68 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
									_tmp43_ = y;
#line 68 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
									_tmp44_ = size;
#line 68 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
									cairo_rectangle (ctx, (_tmp37_ + _tmp38_) + (_tmp39_ * CHESS_EFFECT_SQUARE_SIZE), _tmp42_ + (_tmp43_ * CHESS_EFFECT_SQUARE_SIZE), _tmp44_, (gdouble) CHESS_EFFECT_SQUARE_SIZE);
#line 601 "ChessEffect.c"
								} else {
									GdkRectangle _tmp45_ = {0};
									GdkRectangle _tmp46_;
									gint _tmp47_;
									GdkRectangle _tmp48_ = {0};
									GdkRectangle _tmp49_;
									gint _tmp50_;
									gdouble _tmp51_;
									gdouble _tmp52_;
									gdouble _tmp53_;
									GdkRectangle _tmp54_ = {0};
									GdkRectangle _tmp55_;
									gint _tmp56_;
									gdouble _tmp57_;
									gdouble _tmp58_;
#line 71 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
									spit_transitions_visuals_get_to_pos (visuals, &_tmp45_);
#line 71 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
									_tmp46_ = _tmp45_;
#line 71 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
									_tmp47_ = _tmp46_.x;
#line 71 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
									spit_transitions_visuals_get_to_pos (visuals, &_tmp48_);
#line 71 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
									_tmp49_ = _tmp48_;
#line 71 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
									_tmp50_ = _tmp49_.width;
#line 71 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
									_tmp51_ = translation;
#line 71 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
									_tmp52_ = x;
#line 71 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
									_tmp53_ = size;
#line 71 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
									spit_transitions_visuals_get_to_pos (visuals, &_tmp54_);
#line 71 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
									_tmp55_ = _tmp54_;
#line 71 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
									_tmp56_ = _tmp55_.y;
#line 71 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
									_tmp57_ = y;
#line 71 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
									_tmp58_ = size;
#line 71 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
									cairo_rectangle (ctx, (((_tmp47_ + _tmp50_) + _tmp51_) - (_tmp52_ * CHESS_EFFECT_SQUARE_SIZE)) - _tmp53_, _tmp56_ + (_tmp57_ * CHESS_EFFECT_SQUARE_SIZE), _tmp58_, (gdouble) CHESS_EFFECT_SQUARE_SIZE);
#line 647 "ChessEffect.c"
								}
							}
						}
					}
				}
			}
		}
#line 78 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
		cairo_clip (ctx);
#line 79 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
		_tmp59_ = alpha;
#line 79 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
		cairo_paint_with_alpha (ctx, _tmp59_);
#line 661 "ChessEffect.c"
	}
}


static void
chess_effect_real_advance (SpitTransitionsEffect* base,
                           SpitTransitionsVisuals* visuals,
                           SpitTransitionsMotion* motion,
                           gint frame_number)
{
	ChessEffect * self;
#line 83 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CHESS_EFFECT, ChessEffect);
#line 83 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_VISUALS (visuals));
#line 83 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_MOTION (motion));
#line 679 "ChessEffect.c"
}


static void
chess_effect_real_cancel (SpitTransitionsEffect* base)
{
	ChessEffect * self;
#line 86 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CHESS_EFFECT, ChessEffect);
#line 689 "ChessEffect.c"
}


static void
chess_effect_class_init (ChessEffectClass * klass)
{
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	chess_effect_parent_class = g_type_class_peek_parent (klass);
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	g_type_class_add_private (klass, sizeof (ChessEffectPrivate));
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	G_OBJECT_CLASS (klass)->finalize = chess_effect_finalize;
#line 702 "ChessEffect.c"
}


static void
chess_effect_spit_transitions_effect_interface_init (SpitTransitionsEffectIface * iface)
{
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	chess_effect_spit_transitions_effect_parent_iface = g_type_interface_peek_parent (iface);
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	iface->get_fps = (void (*) (SpitTransitionsEffect *, gint*, gint*)) chess_effect_real_get_fps;
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	iface->start = (void (*) (SpitTransitionsEffect *, SpitTransitionsVisuals*, SpitTransitionsMotion*)) chess_effect_real_start;
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	iface->needs_clear_background = (gboolean (*) (SpitTransitionsEffect *)) chess_effect_real_needs_clear_background;
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	iface->paint = (void (*) (SpitTransitionsEffect *, SpitTransitionsVisuals*, SpitTransitionsMotion*, cairo_t*, gint, gint, gint)) chess_effect_real_paint;
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	iface->advance = (void (*) (SpitTransitionsEffect *, SpitTransitionsVisuals*, SpitTransitionsMotion*, gint)) chess_effect_real_advance;
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	iface->cancel = (void (*) (SpitTransitionsEffect *)) chess_effect_real_cancel;
#line 723 "ChessEffect.c"
}


static void
chess_effect_instance_init (ChessEffect * self)
{
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	self->priv = CHESS_EFFECT_GET_PRIVATE (self);
#line 732 "ChessEffect.c"
}


static void
chess_effect_finalize (GObject * obj)
{
	ChessEffect * self;
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHESS_EFFECT, ChessEffect);
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/ChessEffect.vala"
	G_OBJECT_CLASS (chess_effect_parent_class)->finalize (obj);
#line 744 "ChessEffect.c"
}


GType
chess_effect_get_type (void)
{
	static volatile gsize chess_effect_type_id__volatile = 0;
	if (g_once_init_enter (&chess_effect_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ChessEffectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) chess_effect_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ChessEffect), 0, (GInstanceInitFunc) chess_effect_instance_init, NULL };
		static const GInterfaceInfo spit_transitions_effect_info = { (GInterfaceInitFunc) chess_effect_spit_transitions_effect_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType chess_effect_type_id;
		chess_effect_type_id = g_type_register_static (G_TYPE_OBJECT, "ChessEffect", &g_define_type_info, 0);
		g_type_add_interface_static (chess_effect_type_id, SPIT_TRANSITIONS_TYPE_EFFECT, &spit_transitions_effect_info);
		g_once_init_leave (&chess_effect_type_id__volatile, chess_effect_type_id);
	}
	return chess_effect_type_id__volatile;
}



