/* DataCollection.c generated by valac 0.40.4, the Vala compiler
 * generated from DataCollection.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gobject/gvaluecollector.h>


#define TYPE_DATA_COLLECTION (data_collection_get_type ())
#define DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_COLLECTION, DataCollection))
#define DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_COLLECTION, DataCollectionClass))
#define IS_DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_COLLECTION))
#define IS_DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_COLLECTION))
#define DATA_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_COLLECTION, DataCollectionClass))

typedef struct _DataCollection DataCollection;
typedef struct _DataCollectionClass DataCollectionClass;
typedef struct _DataCollectionPrivate DataCollectionPrivate;

#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;

#define TYPE_ALTERATION (alteration_get_type ())
#define ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ALTERATION, Alteration))
#define ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ALTERATION, AlterationClass))
#define IS_ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ALTERATION))
#define IS_ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ALTERATION))
#define ALTERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ALTERATION, AlterationClass))

typedef struct _Alteration Alteration;
typedef struct _AlterationClass AlterationClass;

#define TYPE_MARKER (marker_get_type ())
#define MARKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MARKER, Marker))
#define IS_MARKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MARKER))
#define MARKER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_MARKER, MarkerIface))

typedef struct _Marker Marker;
typedef struct _MarkerIface MarkerIface;

#define TYPE_DATA_SET (data_set_get_type ())
#define DATA_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SET, DataSet))
#define DATA_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SET, DataSetClass))
#define IS_DATA_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SET))
#define IS_DATA_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SET))
#define DATA_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SET, DataSetClass))

typedef struct _DataSet DataSet;
typedef struct _DataSetClass DataSetClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _data_set_unref0(var) ((var == NULL) ? NULL : (var = (data_set_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_SINGLETON_COLLECTION (singleton_collection_get_type ())
#define SINGLETON_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SINGLETON_COLLECTION, SingletonCollection))
#define SINGLETON_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SINGLETON_COLLECTION, SingletonCollectionClass))
#define IS_SINGLETON_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SINGLETON_COLLECTION))
#define IS_SINGLETON_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SINGLETON_COLLECTION))
#define SINGLETON_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SINGLETON_COLLECTION, SingletonCollectionClass))

typedef struct _SingletonCollection SingletonCollection;
typedef struct _SingletonCollectionClass SingletonCollectionClass;
#define _data_collection_unref0(var) ((var == NULL) ? NULL : (var = (data_collection_unref (var), NULL)))

#define DATA_COLLECTION_TYPE_MARKER_IMPL (data_collection_marker_impl_get_type ())
#define DATA_COLLECTION_MARKER_IMPL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DATA_COLLECTION_TYPE_MARKER_IMPL, DataCollectionMarkerImpl))
#define DATA_COLLECTION_MARKER_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DATA_COLLECTION_TYPE_MARKER_IMPL, DataCollectionMarkerImplClass))
#define DATA_COLLECTION_IS_MARKER_IMPL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DATA_COLLECTION_TYPE_MARKER_IMPL))
#define DATA_COLLECTION_IS_MARKER_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DATA_COLLECTION_TYPE_MARKER_IMPL))
#define DATA_COLLECTION_MARKER_IMPL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DATA_COLLECTION_TYPE_MARKER_IMPL, DataCollectionMarkerImplClass))

typedef struct _DataCollectionMarkerImpl DataCollectionMarkerImpl;
typedef struct _DataCollectionMarkerImplClass DataCollectionMarkerImplClass;
typedef struct _DataCollectionMarkerImplPrivate DataCollectionMarkerImplPrivate;
#define _alteration_unref0(var) ((var == NULL) ? NULL : (var = (alteration_unref (var), NULL)))
#define __vala_GValue_free0(var) ((var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL)))
enum  {
	DATA_COLLECTION_MARKER_IMPL_0_PROPERTY,
	DATA_COLLECTION_MARKER_IMPL_NUM_PROPERTIES
};
static GParamSpec* data_collection_marker_impl_properties[DATA_COLLECTION_MARKER_IMPL_NUM_PROPERTIES];
typedef struct _ParamSpecDataCollection ParamSpecDataCollection;
enum  {
	DATA_COLLECTION_ITEMS_ADDED_SIGNAL,
	DATA_COLLECTION_ITEMS_REMOVED_SIGNAL,
	DATA_COLLECTION_CONTENTS_ALTERED_SIGNAL,
	DATA_COLLECTION_ITEMS_ALTERED_SIGNAL,
	DATA_COLLECTION_ORDERING_CHANGED_SIGNAL,
	DATA_COLLECTION_PROPERTY_SET_SIGNAL,
	DATA_COLLECTION_PROPERTY_CLEARED_SIGNAL,
	DATA_COLLECTION_FROZEN_SIGNAL,
	DATA_COLLECTION_THAWED_SIGNAL,
	DATA_COLLECTION_NUM_SIGNALS
};
static guint data_collection_signals[DATA_COLLECTION_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef gint64 (*Comparator) (void* a, void* b, void* user_data);
typedef gboolean (*ComparatorPredicate) (DataObject* object, Alteration* alteration, void* user_data);
typedef gboolean (*ProgressMonitor) (guint64 current, guint64 total, gboolean do_event_loop, void* user_data);
struct _MarkerIface {
	GTypeInterface parent_iface;
	void (*mark) (Marker* self, DataObject* object);
	void (*unmark) (Marker* self, DataObject* object);
	gboolean (*toggle) (Marker* self, DataObject* object);
	void (*mark_many) (Marker* self, GeeCollection* list);
	void (*unmark_many) (Marker* self, GeeCollection* list);
	void (*mark_all) (Marker* self);
	gint (*get_count) (Marker* self);
	GeeCollection* (*get_all) (Marker* self);
};

struct _DataCollection {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DataCollectionPrivate * priv;
};

struct _DataCollectionClass {
	GTypeClass parent_class;
	void (*finalize) (DataCollection *self);
	gchar* (*to_string) (DataCollection* self);
	void (*notify_items_added) (DataCollection* self, GeeIterable* added);
	void (*notify_items_removed) (DataCollection* self, GeeIterable* removed);
	void (*notify_contents_altered) (DataCollection* self, GeeIterable* added, GeeIterable* removed);
	void (*notify_items_altered) (DataCollection* self, GeeMap* items);
	void (*notify_ordering_changed) (DataCollection* self);
	void (*notify_property_set) (DataCollection* self, const gchar* name, GValue* old, GValue* val);
	void (*notify_property_cleared) (DataCollection* self, const gchar* name);
	gboolean (*valid_type) (DataCollection* self, DataObject* object);
	void (*set_comparator) (DataCollection* self, Comparator comparator, void* comparator_target, ComparatorPredicate predicate, void* predicate_target);
	void (*reset_comparator) (DataCollection* self);
	GeeCollection* (*get_all) (DataCollection* self);
	gint (*get_count) (DataCollection* self);
	DataObject* (*get_at) (DataCollection* self, gint index);
	gint (*index_of) (DataCollection* self, DataObject* object);
	gboolean (*contains) (DataCollection* self, DataObject* object);
	gboolean (*add) (DataCollection* self, DataObject* object);
	GeeCollection* (*add_many) (DataCollection* self, GeeCollection* objects, ProgressMonitor monitor, void* monitor_target);
	void (*remove_marked) (DataCollection* self, Marker* m);
	void (*clear) (DataCollection* self);
	void (*close) (DataCollection* self);
	void (*notify_frozen) (DataCollection* self);
	void (*notify_thawed) (DataCollection* self);
	void (*items_added) (DataCollection* self, GeeIterable* added);
	void (*items_removed) (DataCollection* self, GeeIterable* removed);
	void (*contents_altered) (DataCollection* self, GeeIterable* added, GeeIterable* removed);
	void (*items_altered) (DataCollection* self, GeeMap* items);
	void (*ordering_changed) (DataCollection* self);
	void (*property_set) (DataCollection* self, const gchar* name, GValue* old, GValue* val);
	void (*property_cleared) (DataCollection* self, const gchar* name);
	void (*frozen) (DataCollection* self);
	void (*thawed) (DataCollection* self);
};

struct _DataCollectionPrivate {
	gchar* name;
	DataSet* dataset;
	GeeHashMap* properties;
	gint64 object_ordinal_generator;
	gint notifies_frozen;
	GeeHashMap* frozen_items_altered;
	gboolean fire_ordering_changed;
};

typedef gboolean (*MarkedAction) (DataObject* object, GObject* user, void* user_data);
struct _DataCollectionMarkerImpl {
	GObject parent_instance;
	DataCollectionMarkerImplPrivate * priv;
	DataCollection* owner;
	GeeHashSet* marked;
	gint freeze_count;
};

struct _DataCollectionMarkerImplClass {
	GObjectClass parent_class;
};

typedef gboolean (*ValueEqualFunc) (GValue* a, GValue* b, void* user_data);
struct _ParamSpecDataCollection {
	GParamSpec parent_instance;
};


static gpointer data_collection_parent_class = NULL;
static gpointer data_collection_marker_impl_parent_class = NULL;
static MarkerIface * data_collection_marker_impl_marker_parent_iface = NULL;

gpointer data_collection_ref (gpointer instance);
void data_collection_unref (gpointer instance);
GParamSpec* param_spec_data_collection (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
void value_set_data_collection (GValue* value,
                                gpointer v_object);
void value_take_data_collection (GValue* value,
                                 gpointer v_object);
gpointer value_get_data_collection (const GValue* value);
GType data_collection_get_type (void) G_GNUC_CONST;
GType data_object_get_type (void) G_GNUC_CONST;
gpointer alteration_ref (gpointer instance);
void alteration_unref (gpointer instance);
GParamSpec* param_spec_alteration (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags);
void value_set_alteration (GValue* value,
                           gpointer v_object);
void value_take_alteration (GValue* value,
                            gpointer v_object);
gpointer value_get_alteration (const GValue* value);
GType alteration_get_type (void) G_GNUC_CONST;
GType marker_get_type (void) G_GNUC_CONST;
gpointer data_set_ref (gpointer instance);
void data_set_unref (gpointer instance);
GParamSpec* param_spec_data_set (const gchar* name,
                                 const gchar* nick,
                                 const gchar* blurb,
                                 GType object_type,
                                 GParamFlags flags);
void value_set_data_set (GValue* value,
                         gpointer v_object);
void value_take_data_set (GValue* value,
                          gpointer v_object);
gpointer value_get_data_set (const GValue* value);
GType data_set_get_type (void) G_GNUC_CONST;
#define DATA_COLLECTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_DATA_COLLECTION, DataCollectionPrivate))
DataSet* data_set_new (void);
DataSet* data_set_construct (GType object_type);
static GValue* _g_value_dup (GValue* self);
static void _vala_GValue_free (GValue* self);
#define DATA_COLLECTION_INVALID_OBJECT_ORDINAL ((gint64) -1)
DataCollection* data_collection_new (const gchar* name);
DataCollection* data_collection_construct (GType object_type,
                                           const gchar* name);
gchar* data_collection_to_string (DataCollection* self);
static gchar* data_collection_real_to_string (DataCollection* self);
gint data_collection_get_count (DataCollection* self);
void data_collection_notify_items_added (DataCollection* self,
                                         GeeIterable* added);
static void data_collection_real_notify_items_added (DataCollection* self,
                                              GeeIterable* added);
void data_collection_notify_items_removed (DataCollection* self,
                                           GeeIterable* removed);
static void data_collection_real_notify_items_removed (DataCollection* self,
                                                GeeIterable* removed);
void data_collection_notify_contents_altered (DataCollection* self,
                                              GeeIterable* added,
                                              GeeIterable* removed);
static void data_collection_real_notify_contents_altered (DataCollection* self,
                                                   GeeIterable* added,
                                                   GeeIterable* removed);
void data_collection_notify_items_altered (DataCollection* self,
                                           GeeMap* items);
static void data_collection_real_notify_items_altered (DataCollection* self,
                                                GeeMap* items);
void data_collection_notify_ordering_changed (DataCollection* self);
static void data_collection_real_notify_ordering_changed (DataCollection* self);
void data_collection_notify_property_set (DataCollection* self,
                                          const gchar* name,
                                          GValue* old,
                                          GValue* val);
static void data_collection_real_notify_property_set (DataCollection* self,
                                               const gchar* name,
                                               GValue* old,
                                               GValue* val);
void data_collection_notify_property_cleared (DataCollection* self,
                                              const gchar* name);
static void data_collection_real_notify_property_cleared (DataCollection* self,
                                                   const gchar* name);
GeeCollection* data_collection_get_singleton (DataObject* object);
SingletonCollection* singleton_collection_new (GType g_type,
                                               GBoxedCopyFunc g_dup_func,
                                               GDestroyNotify g_destroy_func,
                                               gconstpointer object);
SingletonCollection* singleton_collection_construct (GType object_type,
                                                     GType g_type,
                                                     GBoxedCopyFunc g_dup_func,
                                                     GDestroyNotify g_destroy_func,
                                                     gconstpointer object);
GType singleton_collection_get_type (void) G_GNUC_CONST;
GeeMap* data_collection_get_alteration_singleton (DataObject* object,
                                                  Alteration* alteration);
gboolean data_collection_valid_type (DataCollection* self,
                                     DataObject* object);
static gboolean data_collection_real_valid_type (DataCollection* self,
                                          DataObject* object);
Comparator data_collection_get_comparator (DataCollection* self,
                                           void** result_target);
Comparator data_set_get_comparator (DataSet* self,
                                    void** result_target);
ComparatorPredicate data_collection_get_comparator_predicate (DataCollection* self,
                                                              void** result_target);
ComparatorPredicate data_set_get_comparator_predicate (DataSet* self,
                                                       void** result_target);
void data_collection_set_comparator (DataCollection* self,
                                     Comparator comparator,
                                     void* comparator_target,
                                     ComparatorPredicate predicate,
                                     void* predicate_target);
static void data_collection_real_set_comparator (DataCollection* self,
                                          Comparator comparator,
                                          void* comparator_target,
                                          ComparatorPredicate predicate,
                                          void* predicate_target);
void data_set_set_comparator (DataSet* self,
                              Comparator user_comparator,
                              void* user_comparator_target,
                              ComparatorPredicate comparator_predicate,
                              void* comparator_predicate_target);
void data_collection_reset_comparator (DataCollection* self);
static void data_collection_real_reset_comparator (DataCollection* self);
void data_set_reset_comparator (DataSet* self);
GeeCollection* data_collection_get_all (DataCollection* self);
static GeeCollection* data_collection_real_get_all (DataCollection* self);
GeeList* data_set_get_all (DataSet* self);
DataSet* data_collection_get_dataset_copy (DataCollection* self);
DataSet* data_set_copy (DataSet* self);
static gint data_collection_real_get_count (DataCollection* self);
gint data_set_get_count (DataSet* self);
DataObject* data_collection_get_at (DataCollection* self,
                                    gint index);
static DataObject* data_collection_real_get_at (DataCollection* self,
                                         gint index);
DataObject* data_set_get_at (DataSet* self,
                             gint index);
gint data_collection_index_of (DataCollection* self,
                               DataObject* object);
static gint data_collection_real_index_of (DataCollection* self,
                                    DataObject* object);
gint data_set_index_of (DataSet* self,
                        DataObject* object);
gboolean data_collection_contains (DataCollection* self,
                                   DataObject* object);
static gboolean data_collection_real_contains (DataCollection* self,
                                        DataObject* object);
static gboolean data_collection_internal_contains (DataCollection* self,
                                            DataObject* object);
gboolean data_set_contains (DataSet* self,
                            DataObject* object);
DataCollection* data_object_get_membership (DataObject* self);
static void data_collection_internal_add (DataCollection* self,
                                   DataObject* object);
void data_object_internal_set_membership (DataObject* self,
                                          DataCollection* collection,
                                          gint64 ordinal);
gboolean data_set_add (DataSet* self,
                       DataObject* object);
static void data_collection_internal_add_many (DataCollection* self,
                                        GeeList* objects,
                                        ProgressMonitor monitor,
                                        void* monitor_target);
gboolean data_set_add_many (DataSet* self,
                            GeeCollection* objects);
static void data_collection_internal_remove (DataCollection* self,
                                      DataObject* object);
gboolean data_set_remove (DataSet* self,
                          DataObject* object);
void data_object_internal_clear_membership (DataObject* self);
gboolean data_collection_add (DataCollection* self,
                              DataObject* object);
static gboolean data_collection_real_add (DataCollection* self,
                                   DataObject* object);
gchar* data_object_to_string (DataObject* self);
void data_object_notify_membership_changed (DataObject* self,
                                            DataCollection* collection);
GeeCollection* data_collection_add_many (DataCollection* self,
                                         GeeCollection* objects,
                                         ProgressMonitor monitor,
                                         void* monitor_target);
static GeeCollection* data_collection_real_add_many (DataCollection* self,
                                              GeeCollection* objects,
                                              ProgressMonitor monitor,
                                              void* monitor_target);
Marker* data_collection_start_marking (DataCollection* self);
static DataCollectionMarkerImpl* data_collection_marker_impl_new (DataCollection* owner);
static DataCollectionMarkerImpl* data_collection_marker_impl_construct (GType object_type,
                                                                 DataCollection* owner);
static GType data_collection_marker_impl_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
Marker* data_collection_mark (DataCollection* self,
                              DataObject* object);
void marker_mark (Marker* self,
                  DataObject* object);
Marker* data_collection_mark_many (DataCollection* self,
                                   GeeCollection* objects);
void marker_mark_many (Marker* self,
                       GeeCollection* list);
void data_collection_act_on_marked (DataCollection* self,
                                    Marker* m,
                                    MarkedAction action,
                                    void* action_target,
                                    ProgressMonitor monitor,
                                    void* monitor_target,
                                    GObject* user);
static gboolean data_collection_marker_impl_is_valid (DataCollectionMarkerImpl* self,
                                               DataCollection* collection);
static void data_collection_marker_impl_freeze (DataCollectionMarkerImpl* self);
static void data_collection_marker_impl_finished (DataCollectionMarkerImpl* self);
void data_collection_remove_marked (DataCollection* self,
                                    Marker* m);
static void data_collection_real_remove_marked (DataCollection* self,
                                         Marker* m);
void data_collection_clear (DataCollection* self);
static void data_collection_real_clear (DataCollection* self);
void data_collection_close (DataCollection* self);
static void data_collection_real_close (DataCollection* self);
void data_collection_internal_notify_altered (DataCollection* self,
                                              DataObject* object,
                                              Alteration* alteration);
gboolean data_set_resort_object (DataSet* self,
                                 DataObject* object,
                                 Alteration* alteration);
gboolean data_collection_are_notifications_frozen (DataCollection* self);
Alteration* alteration_compress (Alteration* self,
                                 Alteration* other);
GValue* data_collection_get_property (DataCollection* self,
                                      const gchar* name);
void data_collection_set_property (DataCollection* self,
                                   const gchar* name,
                                   GValue* val,
                                   ValueEqualFunc value_equals,
                                   void* value_equals_target);
gboolean bool_value_equals (GValue* a,
                            GValue* b);
static gboolean _bool_value_equals_value_equal_func (GValue* a,
                                              GValue* b,
                                              gpointer self);
gboolean int_value_equals (GValue* a,
                           GValue* b);
static gboolean _int_value_equals_value_equal_func (GValue* a,
                                             GValue* b,
                                             gpointer self);
void data_object_notify_collection_property_set (DataObject* self,
                                                 const gchar* name,
                                                 GValue* old,
                                                 GValue* val);
void data_collection_clear_property (DataCollection* self,
                                     const gchar* name);
void data_object_notify_collection_property_cleared (DataObject* self,
                                                     const gchar* name);
void data_collection_freeze_notifications (DataCollection* self);
void data_collection_notify_frozen (DataCollection* self);
void data_collection_thaw_notifications (DataCollection* self);
void data_collection_notify_thawed (DataCollection* self);
static void data_collection_real_notify_frozen (DataCollection* self);
static void data_collection_real_notify_thawed (DataCollection* self);
static void data_collection_real_items_added (DataCollection* self,
                                       GeeIterable* added);
static void data_collection_real_items_removed (DataCollection* self,
                                         GeeIterable* removed);
static void data_collection_real_contents_altered (DataCollection* self,
                                            GeeIterable* added,
                                            GeeIterable* removed);
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure,
                                                  GValue * return_value,
                                                  guint n_param_values,
                                                  const GValue * param_values,
                                                  gpointer invocation_hint,
                                                  gpointer marshal_data);
static void data_collection_real_items_altered (DataCollection* self,
                                         GeeMap* items);
static void data_collection_real_ordering_changed (DataCollection* self);
static void data_collection_real_property_set (DataCollection* self,
                                        const gchar* name,
                                        GValue* old,
                                        GValue* val);
static void g_cclosure_user_marshal_VOID__STRING_POINTER_BOXED (GClosure * closure,
                                                         GValue * return_value,
                                                         guint n_param_values,
                                                         const GValue * param_values,
                                                         gpointer invocation_hint,
                                                         gpointer marshal_data);
static void data_collection_real_property_cleared (DataCollection* self,
                                            const gchar* name);
static void data_collection_real_frozen (DataCollection* self);
static void data_collection_real_thawed (DataCollection* self);
static void data_collection_marker_impl_on_items_removed (DataCollectionMarkerImpl* self,
                                                   GeeIterable* removed);
static void _data_collection_marker_impl_on_items_removed_data_collection_items_removed (DataCollection* _sender,
                                                                                  GeeIterable* removed,
                                                                                  gpointer self);
static void data_collection_marker_impl_real_mark (Marker* base,
                                            DataObject* object);
static void data_collection_marker_impl_real_unmark (Marker* base,
                                              DataObject* object);
static gboolean data_collection_marker_impl_real_toggle (Marker* base,
                                                  DataObject* object);
static void data_collection_marker_impl_real_mark_many (Marker* base,
                                                 GeeCollection* list);
static void data_collection_marker_impl_real_unmark_many (Marker* base,
                                                   GeeCollection* list);
static void data_collection_marker_impl_real_mark_all (Marker* base);
static gint data_collection_marker_impl_real_get_count (Marker* base);
static GeeCollection* data_collection_marker_impl_real_get_all (Marker* base);
static void data_collection_marker_impl_finalize (GObject * obj);
static void data_collection_finalize (DataCollection * obj);


static GValue*
_g_value_dup (GValue* self)
{
#line 109 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	return g_boxed_copy (G_TYPE_VALUE, self);
#line 528 "DataCollection.c"
}


static void
_vala_GValue_free (GValue* self)
{
#line 109 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_value_unset (self);
#line 109 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_free (self);
#line 539 "DataCollection.c"
}


DataCollection*
data_collection_construct (GType object_type,
                           const gchar* name)
{
	DataCollection* self = NULL;
	gchar* _tmp0_;
#line 157 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 157 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	self = (DataCollection*) g_type_create_instance (object_type);
#line 158 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp0_ = g_strdup (name);
#line 158 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_g_free0 (self->priv->name);
#line 158 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	self->priv->name = _tmp0_;
#line 157 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	return self;
#line 561 "DataCollection.c"
}


DataCollection*
data_collection_new (const gchar* name)
{
#line 157 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	return data_collection_construct (TYPE_DATA_COLLECTION, name);
#line 570 "DataCollection.c"
}


static gchar*
data_collection_real_to_string (DataCollection* self)
{
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 168 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp0_ = self->priv->name;
#line 168 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp1_ = g_strdup_printf ("%s (%d)", _tmp0_, data_collection_get_count (self));
#line 168 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	result = _tmp1_;
#line 168 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	return result;
#line 588 "DataCollection.c"
}


gchar*
data_collection_to_string (DataCollection* self)
{
#line 167 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_val_if_fail (IS_DATA_COLLECTION (self), NULL);
#line 167 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	return DATA_COLLECTION_GET_CLASS (self)->to_string (self);
#line 599 "DataCollection.c"
}


static void
data_collection_real_notify_items_added (DataCollection* self,
                                         GeeIterable* added)
{
#line 172 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_if_fail (GEE_IS_ITERABLE (added));
#line 173 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_signal_emit (self, data_collection_signals[DATA_COLLECTION_ITEMS_ADDED_SIGNAL], 0, added);
#line 611 "DataCollection.c"
}


void
data_collection_notify_items_added (DataCollection* self,
                                    GeeIterable* added)
{
#line 172 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_if_fail (IS_DATA_COLLECTION (self));
#line 172 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	DATA_COLLECTION_GET_CLASS (self)->notify_items_added (self, added);
#line 623 "DataCollection.c"
}


static void
data_collection_real_notify_items_removed (DataCollection* self,
                                           GeeIterable* removed)
{
#line 176 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_if_fail (GEE_IS_ITERABLE (removed));
#line 177 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_signal_emit (self, data_collection_signals[DATA_COLLECTION_ITEMS_REMOVED_SIGNAL], 0, removed);
#line 635 "DataCollection.c"
}


void
data_collection_notify_items_removed (DataCollection* self,
                                      GeeIterable* removed)
{
#line 176 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_if_fail (IS_DATA_COLLECTION (self));
#line 176 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	DATA_COLLECTION_GET_CLASS (self)->notify_items_removed (self, removed);
#line 647 "DataCollection.c"
}


static void
data_collection_real_notify_contents_altered (DataCollection* self,
                                              GeeIterable* added,
                                              GeeIterable* removed)
{
#line 180 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_if_fail ((added == NULL) || GEE_IS_ITERABLE (added));
#line 180 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_if_fail ((removed == NULL) || GEE_IS_ITERABLE (removed));
#line 182 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_signal_emit (self, data_collection_signals[DATA_COLLECTION_CONTENTS_ALTERED_SIGNAL], 0, added, removed);
#line 662 "DataCollection.c"
}


void
data_collection_notify_contents_altered (DataCollection* self,
                                         GeeIterable* added,
                                         GeeIterable* removed)
{
#line 180 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_if_fail (IS_DATA_COLLECTION (self));
#line 180 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	DATA_COLLECTION_GET_CLASS (self)->notify_contents_altered (self, added, removed);
#line 675 "DataCollection.c"
}


static void
data_collection_real_notify_items_altered (DataCollection* self,
                                           GeeMap* items)
{
#line 185 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_if_fail (GEE_IS_MAP (items));
#line 186 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_signal_emit (self, data_collection_signals[DATA_COLLECTION_ITEMS_ALTERED_SIGNAL], 0, items);
#line 687 "DataCollection.c"
}


void
data_collection_notify_items_altered (DataCollection* self,
                                      GeeMap* items)
{
#line 185 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_if_fail (IS_DATA_COLLECTION (self));
#line 185 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	DATA_COLLECTION_GET_CLASS (self)->notify_items_altered (self, items);
#line 699 "DataCollection.c"
}


static void
data_collection_real_notify_ordering_changed (DataCollection* self)
{
#line 190 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_signal_emit (self, data_collection_signals[DATA_COLLECTION_ORDERING_CHANGED_SIGNAL], 0);
#line 708 "DataCollection.c"
}


void
data_collection_notify_ordering_changed (DataCollection* self)
{
#line 189 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_if_fail (IS_DATA_COLLECTION (self));
#line 189 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	DATA_COLLECTION_GET_CLASS (self)->notify_ordering_changed (self);
#line 719 "DataCollection.c"
}


static void
data_collection_real_notify_property_set (DataCollection* self,
                                          const gchar* name,
                                          GValue* old,
                                          GValue* val)
{
	GValue _tmp0_;
#line 193 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_if_fail (name != NULL);
#line 193 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_if_fail (val != NULL);
#line 194 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp0_ = *val;
#line 194 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_signal_emit (self, data_collection_signals[DATA_COLLECTION_PROPERTY_SET_SIGNAL], 0, name, old, &_tmp0_);
#line 738 "DataCollection.c"
}


void
data_collection_notify_property_set (DataCollection* self,
                                     const gchar* name,
                                     GValue* old,
                                     GValue* val)
{
#line 193 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_if_fail (IS_DATA_COLLECTION (self));
#line 193 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	DATA_COLLECTION_GET_CLASS (self)->notify_property_set (self, name, old, val);
#line 752 "DataCollection.c"
}


static void
data_collection_real_notify_property_cleared (DataCollection* self,
                                              const gchar* name)
{
#line 197 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_if_fail (name != NULL);
#line 198 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_signal_emit (self, data_collection_signals[DATA_COLLECTION_PROPERTY_CLEARED_SIGNAL], 0, name);
#line 764 "DataCollection.c"
}


void
data_collection_notify_property_cleared (DataCollection* self,
                                         const gchar* name)
{
#line 197 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_if_fail (IS_DATA_COLLECTION (self));
#line 197 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	DATA_COLLECTION_GET_CLASS (self)->notify_property_cleared (self, name);
#line 776 "DataCollection.c"
}


GeeCollection*
data_collection_get_singleton (DataObject* object)
{
	GeeCollection* result = NULL;
	SingletonCollection* _tmp0_;
#line 206 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_val_if_fail (IS_DATA_OBJECT (object), NULL);
#line 207 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp0_ = singleton_collection_new (TYPE_DATA_OBJECT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, object);
#line 207 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection);
#line 207 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	return result;
#line 793 "DataCollection.c"
}


GeeMap*
data_collection_get_alteration_singleton (DataObject* object,
                                          Alteration* alteration)
{
	GeeMap* result = NULL;
	GeeMap* map = NULL;
	GeeHashMap* _tmp0_;
#line 210 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_val_if_fail (IS_DATA_OBJECT (object), NULL);
#line 210 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_val_if_fail (IS_ALTERATION (alteration), NULL);
#line 212 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp0_ = gee_hash_map_new (TYPE_DATA_OBJECT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, TYPE_ALTERATION, (GBoxedCopyFunc) alteration_ref, (GDestroyNotify) alteration_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 212 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	map = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_MAP, GeeMap);
#line 213 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	gee_map_set (map, object, alteration);
#line 215 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	result = map;
#line 215 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	return result;
#line 818 "DataCollection.c"
}


static gboolean
data_collection_real_valid_type (DataCollection* self,
                                 DataObject* object)
{
	gboolean result = FALSE;
#line 218 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_val_if_fail (IS_DATA_OBJECT (object), FALSE);
#line 219 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	result = TRUE;
#line 219 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	return result;
#line 833 "DataCollection.c"
}


gboolean
data_collection_valid_type (DataCollection* self,
                            DataObject* object)
{
#line 218 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_val_if_fail (IS_DATA_COLLECTION (self), FALSE);
#line 218 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	return DATA_COLLECTION_GET_CLASS (self)->valid_type (self, object);
#line 845 "DataCollection.c"
}


Comparator
data_collection_get_comparator (DataCollection* self,
                                void** result_target)
{
	Comparator result = NULL;
	DataSet* _tmp0_;
	void* _tmp1_;
	Comparator _tmp2_;
	Comparator _tmp3_;
	void* _tmp3__target;
#line 222 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_val_if_fail (IS_DATA_COLLECTION (self), NULL);
#line 223 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp0_ = self->priv->dataset;
#line 223 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp2_ = data_set_get_comparator (_tmp0_, &_tmp1_);
#line 223 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp3_ = _tmp2_;
#line 223 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp3__target = _tmp1_;
#line 223 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	*result_target = _tmp3__target;
#line 223 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	result = _tmp3_;
#line 223 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	return result;
#line 875 "DataCollection.c"
}


ComparatorPredicate
data_collection_get_comparator_predicate (DataCollection* self,
                                          void** result_target)
{
	ComparatorPredicate result = NULL;
	DataSet* _tmp0_;
	void* _tmp1_;
	ComparatorPredicate _tmp2_;
	ComparatorPredicate _tmp3_;
	void* _tmp3__target;
#line 226 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_val_if_fail (IS_DATA_COLLECTION (self), NULL);
#line 227 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp0_ = self->priv->dataset;
#line 227 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp2_ = data_set_get_comparator_predicate (_tmp0_, &_tmp1_);
#line 227 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp3_ = _tmp2_;
#line 227 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp3__target = _tmp1_;
#line 227 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	*result_target = _tmp3__target;
#line 227 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	result = _tmp3_;
#line 227 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	return result;
#line 905 "DataCollection.c"
}


static void
data_collection_real_set_comparator (DataCollection* self,
                                     Comparator comparator,
                                     void* comparator_target,
                                     ComparatorPredicate predicate,
                                     void* predicate_target)
{
	DataSet* _tmp0_;
#line 231 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp0_ = self->priv->dataset;
#line 231 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	data_set_set_comparator (_tmp0_, comparator, comparator_target, predicate, predicate_target);
#line 232 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	data_collection_notify_ordering_changed (self);
#line 923 "DataCollection.c"
}


void
data_collection_set_comparator (DataCollection* self,
                                Comparator comparator,
                                void* comparator_target,
                                ComparatorPredicate predicate,
                                void* predicate_target)
{
#line 230 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_if_fail (IS_DATA_COLLECTION (self));
#line 230 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	DATA_COLLECTION_GET_CLASS (self)->set_comparator (self, comparator, comparator_target, predicate, predicate_target);
#line 938 "DataCollection.c"
}


static void
data_collection_real_reset_comparator (DataCollection* self)
{
	DataSet* _tmp0_;
#line 237 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp0_ = self->priv->dataset;
#line 237 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	data_set_reset_comparator (_tmp0_);
#line 238 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	data_collection_notify_ordering_changed (self);
#line 952 "DataCollection.c"
}


void
data_collection_reset_comparator (DataCollection* self)
{
#line 236 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_if_fail (IS_DATA_COLLECTION (self));
#line 236 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	DATA_COLLECTION_GET_CLASS (self)->reset_comparator (self);
#line 963 "DataCollection.c"
}


static GeeCollection*
data_collection_real_get_all (DataCollection* self)
{
	GeeCollection* result = NULL;
	DataSet* _tmp0_;
	GeeList* _tmp1_;
#line 242 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp0_ = self->priv->dataset;
#line 242 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp1_ = data_set_get_all (_tmp0_);
#line 242 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_COLLECTION, GeeCollection);
#line 242 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	return result;
#line 981 "DataCollection.c"
}


GeeCollection*
data_collection_get_all (DataCollection* self)
{
#line 241 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_val_if_fail (IS_DATA_COLLECTION (self), NULL);
#line 241 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	return DATA_COLLECTION_GET_CLASS (self)->get_all (self);
#line 992 "DataCollection.c"
}


DataSet*
data_collection_get_dataset_copy (DataCollection* self)
{
	DataSet* result = NULL;
	DataSet* _tmp0_;
	DataSet* _tmp1_;
#line 245 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_val_if_fail (IS_DATA_COLLECTION (self), NULL);
#line 246 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp0_ = self->priv->dataset;
#line 246 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp1_ = data_set_copy (_tmp0_);
#line 246 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	result = _tmp1_;
#line 246 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	return result;
#line 1012 "DataCollection.c"
}


static gint
data_collection_real_get_count (DataCollection* self)
{
	gint result = 0;
	DataSet* _tmp0_;
#line 250 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp0_ = self->priv->dataset;
#line 250 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	result = data_set_get_count (_tmp0_);
#line 250 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	return result;
#line 1027 "DataCollection.c"
}


gint
data_collection_get_count (DataCollection* self)
{
#line 249 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_val_if_fail (IS_DATA_COLLECTION (self), 0);
#line 249 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	return DATA_COLLECTION_GET_CLASS (self)->get_count (self);
#line 1038 "DataCollection.c"
}


static DataObject*
data_collection_real_get_at (DataCollection* self,
                             gint index)
{
	DataObject* result = NULL;
	DataSet* _tmp0_;
	DataObject* _tmp1_;
#line 254 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp0_ = self->priv->dataset;
#line 254 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp1_ = data_set_get_at (_tmp0_, index);
#line 254 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	result = _tmp1_;
#line 254 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	return result;
#line 1057 "DataCollection.c"
}


DataObject*
data_collection_get_at (DataCollection* self,
                        gint index)
{
#line 253 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_val_if_fail (IS_DATA_COLLECTION (self), NULL);
#line 253 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	return DATA_COLLECTION_GET_CLASS (self)->get_at (self, index);
#line 1069 "DataCollection.c"
}


static gint
data_collection_real_index_of (DataCollection* self,
                               DataObject* object)
{
	gint result = 0;
	DataSet* _tmp0_;
#line 257 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_val_if_fail (IS_DATA_OBJECT (object), 0);
#line 258 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp0_ = self->priv->dataset;
#line 258 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	result = data_set_index_of (_tmp0_, object);
#line 258 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	return result;
#line 1087 "DataCollection.c"
}


gint
data_collection_index_of (DataCollection* self,
                          DataObject* object)
{
#line 257 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_val_if_fail (IS_DATA_COLLECTION (self), 0);
#line 257 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	return DATA_COLLECTION_GET_CLASS (self)->index_of (self, object);
#line 1099 "DataCollection.c"
}


static gboolean
data_collection_real_contains (DataCollection* self,
                               DataObject* object)
{
	gboolean result = FALSE;
#line 261 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_val_if_fail (IS_DATA_OBJECT (object), FALSE);
#line 262 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	result = data_collection_internal_contains (self, object);
#line 262 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	return result;
#line 1114 "DataCollection.c"
}


gboolean
data_collection_contains (DataCollection* self,
                          DataObject* object)
{
#line 261 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_val_if_fail (IS_DATA_COLLECTION (self), FALSE);
#line 261 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	return DATA_COLLECTION_GET_CLASS (self)->contains (self, object);
#line 1126 "DataCollection.c"
}


static gboolean
data_collection_internal_contains (DataCollection* self,
                                   DataObject* object)
{
	gboolean result = FALSE;
	DataSet* _tmp0_;
	DataCollection* _tmp1_;
	DataCollection* _tmp2_;
#line 267 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_val_if_fail (IS_DATA_COLLECTION (self), FALSE);
#line 267 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_val_if_fail (IS_DATA_OBJECT (object), FALSE);
#line 268 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp0_ = self->priv->dataset;
#line 268 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	if (!data_set_contains (_tmp0_, object)) {
#line 269 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		result = FALSE;
#line 269 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		return result;
#line 1150 "DataCollection.c"
	}
#line 271 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp1_ = data_object_get_membership (object);
#line 271 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp2_ = _tmp1_;
#line 271 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_vala_assert (_tmp2_ == self, "object.get_membership() == this");
#line 271 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_data_collection_unref0 (_tmp2_);
#line 273 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	result = TRUE;
#line 273 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	return result;
#line 1164 "DataCollection.c"
}


static void
data_collection_internal_add (DataCollection* self,
                              DataObject* object)
{
	gint64 _tmp0_;
	gboolean added = FALSE;
	DataSet* _tmp1_;
#line 276 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_if_fail (IS_DATA_COLLECTION (self));
#line 276 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_if_fail (IS_DATA_OBJECT (object));
#line 277 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_vala_assert (data_collection_valid_type (self, object), "valid_type(object)");
#line 279 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp0_ = self->priv->object_ordinal_generator;
#line 279 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	self->priv->object_ordinal_generator = _tmp0_ + 1;
#line 279 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	data_object_internal_set_membership (object, self, _tmp0_);
#line 281 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp1_ = self->priv->dataset;
#line 281 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	added = data_set_add (_tmp1_, object);
#line 282 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_vala_assert (added, "added");
#line 1193 "DataCollection.c"
}


static void
data_collection_internal_add_many (DataCollection* self,
                                   GeeList* objects,
                                   ProgressMonitor monitor,
                                   void* monitor_target)
{
	gint count = 0;
	gint _tmp0_;
	gint _tmp1_;
	gboolean added = FALSE;
	DataSet* _tmp13_;
#line 285 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_if_fail (IS_DATA_COLLECTION (self));
#line 285 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_if_fail (GEE_IS_LIST (objects));
#line 286 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp0_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (objects, GEE_TYPE_COLLECTION, GeeCollection));
#line 286 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp1_ = _tmp0_;
#line 286 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	count = _tmp1_;
#line 1218 "DataCollection.c"
	{
		gint ctr = 0;
#line 287 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		ctr = 0;
#line 1223 "DataCollection.c"
		{
			gboolean _tmp2_ = FALSE;
#line 287 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			_tmp2_ = TRUE;
#line 287 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			while (TRUE) {
#line 1230 "DataCollection.c"
				gint _tmp4_;
				gint _tmp5_;
				DataObject* object = NULL;
				gint _tmp6_;
				gpointer _tmp7_;
				DataObject* _tmp8_;
				DataObject* _tmp9_;
				gint64 _tmp10_;
#line 287 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				if (!_tmp2_) {
#line 1241 "DataCollection.c"
					gint _tmp3_;
#line 287 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
					_tmp3_ = ctr;
#line 287 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
					ctr = _tmp3_ + 1;
#line 1247 "DataCollection.c"
				}
#line 287 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				_tmp2_ = FALSE;
#line 287 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				_tmp4_ = ctr;
#line 287 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				_tmp5_ = count;
#line 287 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				if (!(_tmp4_ < _tmp5_)) {
#line 287 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
					break;
#line 1259 "DataCollection.c"
				}
#line 288 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				_tmp6_ = ctr;
#line 288 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				_tmp7_ = gee_list_get (objects, _tmp6_);
#line 288 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				object = (DataObject*) _tmp7_;
#line 289 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				_tmp8_ = object;
#line 289 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				_vala_assert (data_collection_valid_type (self, _tmp8_), "valid_type(object)");
#line 291 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				_tmp9_ = object;
#line 291 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				_tmp10_ = self->priv->object_ordinal_generator;
#line 291 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				self->priv->object_ordinal_generator = _tmp10_ + 1;
#line 291 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				data_object_internal_set_membership (_tmp9_, self, _tmp10_);
#line 293 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				if (monitor != NULL) {
#line 1281 "DataCollection.c"
					gint _tmp11_;
					gint _tmp12_;
#line 294 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
					_tmp11_ = ctr;
#line 294 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
					_tmp12_ = count;
#line 294 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
					monitor ((guint64) _tmp11_, (guint64) _tmp12_, TRUE, monitor_target);
#line 1290 "DataCollection.c"
				}
#line 287 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				_g_object_unref0 (object);
#line 1294 "DataCollection.c"
			}
		}
	}
#line 297 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp13_ = self->priv->dataset;
#line 297 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	added = data_set_add_many (_tmp13_, G_TYPE_CHECK_INSTANCE_CAST (objects, GEE_TYPE_COLLECTION, GeeCollection));
#line 298 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_vala_assert (added, "added");
#line 1304 "DataCollection.c"
}


static void
data_collection_internal_remove (DataCollection* self,
                                 DataObject* object)
{
	gboolean removed = FALSE;
	DataSet* _tmp0_;
#line 301 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_if_fail (IS_DATA_COLLECTION (self));
#line 301 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_if_fail (IS_DATA_OBJECT (object));
#line 302 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp0_ = self->priv->dataset;
#line 302 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	removed = data_set_remove (_tmp0_, object);
#line 303 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_vala_assert (removed, "removed");
#line 305 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	data_object_internal_clear_membership (object);
#line 1326 "DataCollection.c"
}


static gboolean
data_collection_real_add (DataCollection* self,
                          DataObject* object)
{
	gboolean result = FALSE;
	GeeCollection* added = NULL;
	GeeCollection* _tmp4_;
	GeeCollection* _tmp5_;
	GeeCollection* _tmp6_;
#line 309 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_val_if_fail (IS_DATA_OBJECT (object), FALSE);
#line 310 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	if (data_collection_internal_contains (self, object)) {
#line 1343 "DataCollection.c"
		gchar* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
#line 311 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		_tmp0_ = data_collection_to_string (self);
#line 311 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		_tmp1_ = _tmp0_;
#line 311 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		_tmp2_ = data_object_to_string (object);
#line 311 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		_tmp3_ = _tmp2_;
#line 311 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		g_debug ("DataCollection.vala:311: %s cannot add %s: already present", _tmp1_, _tmp3_);
#line 311 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		_g_free0 (_tmp3_);
#line 311 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		_g_free0 (_tmp1_);
#line 313 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		result = FALSE;
#line 313 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		return result;
#line 1366 "DataCollection.c"
	}
#line 316 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	data_collection_internal_add (self, object);
#line 319 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp4_ = data_collection_get_singleton (object);
#line 319 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	added = _tmp4_;
#line 320 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp5_ = added;
#line 320 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	data_collection_notify_items_added (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_ITERABLE, GeeIterable));
#line 321 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp6_ = added;
#line 321 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	data_collection_notify_contents_altered (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_ITERABLE, GeeIterable), NULL);
#line 324 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	data_object_notify_membership_changed (object, self);
#line 326 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	result = TRUE;
#line 326 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_g_object_unref0 (added);
#line 326 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	return result;
#line 1390 "DataCollection.c"
}


gboolean
data_collection_add (DataCollection* self,
                     DataObject* object)
{
#line 309 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_val_if_fail (IS_DATA_COLLECTION (self), FALSE);
#line 309 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	return DATA_COLLECTION_GET_CLASS (self)->add (self, object);
#line 1402 "DataCollection.c"
}


static GeeCollection*
data_collection_real_add_many (DataCollection* self,
                               GeeCollection* objects,
                               ProgressMonitor monitor,
                               void* monitor_target)
{
	GeeCollection* result = NULL;
	GeeArrayList* added = NULL;
	GeeArrayList* _tmp0_;
	gint count = 0;
	GeeArrayList* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	GeeArrayList* _tmp17_;
	GeeArrayList* _tmp18_;
	GeeArrayList* _tmp19_;
#line 330 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_val_if_fail (GEE_IS_COLLECTION (objects), NULL);
#line 332 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp0_ = gee_array_list_new (TYPE_DATA_OBJECT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 332 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	added = _tmp0_;
#line 1429 "DataCollection.c"
	{
		GeeIterator* _object_it = NULL;
		GeeIterator* _tmp1_;
#line 333 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		_tmp1_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (objects, GEE_TYPE_ITERABLE, GeeIterable));
#line 333 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		_object_it = _tmp1_;
#line 333 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		while (TRUE) {
#line 1439 "DataCollection.c"
			GeeIterator* _tmp2_;
			DataObject* object = NULL;
			GeeIterator* _tmp3_;
			gpointer _tmp4_;
			DataObject* _tmp5_;
			GeeArrayList* _tmp11_;
			DataObject* _tmp12_;
#line 333 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			_tmp2_ = _object_it;
#line 333 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			if (!gee_iterator_next (_tmp2_)) {
#line 333 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				break;
#line 1453 "DataCollection.c"
			}
#line 333 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			_tmp3_ = _object_it;
#line 333 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			_tmp4_ = gee_iterator_get (_tmp3_);
#line 333 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			object = (DataObject*) _tmp4_;
#line 334 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			_tmp5_ = object;
#line 334 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			if (data_collection_internal_contains (self, _tmp5_)) {
#line 1465 "DataCollection.c"
				gchar* _tmp6_;
				gchar* _tmp7_;
				DataObject* _tmp8_;
				gchar* _tmp9_;
				gchar* _tmp10_;
#line 335 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				_tmp6_ = data_collection_to_string (self);
#line 335 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				_tmp7_ = _tmp6_;
#line 335 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				_tmp8_ = object;
#line 335 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				_tmp9_ = data_object_to_string (_tmp8_);
#line 335 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				_tmp10_ = _tmp9_;
#line 335 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				g_debug ("DataCollection.vala:335: %s cannot add %s: already present", _tmp7_, _tmp10_);
#line 335 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				_g_free0 (_tmp10_);
#line 335 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				_g_free0 (_tmp7_);
#line 337 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				_g_object_unref0 (object);
#line 337 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				continue;
#line 1491 "DataCollection.c"
			}
#line 340 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			_tmp11_ = added;
#line 340 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			_tmp12_ = object;
#line 340 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp12_);
#line 333 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			_g_object_unref0 (object);
#line 1501 "DataCollection.c"
		}
#line 333 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		_g_object_unref0 (_object_it);
#line 1505 "DataCollection.c"
	}
#line 343 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp13_ = added;
#line 343 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp14_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 343 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp15_ = _tmp14_;
#line 343 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	count = _tmp15_;
#line 344 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp16_ = count;
#line 344 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	if (_tmp16_ == 0) {
#line 345 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		result = G_TYPE_CHECK_INSTANCE_CAST (added, GEE_TYPE_COLLECTION, GeeCollection);
#line 345 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		return result;
#line 1523 "DataCollection.c"
	}
#line 347 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp17_ = added;
#line 347 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	data_collection_internal_add_many (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, GEE_TYPE_LIST, GeeList), monitor, monitor_target);
#line 350 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp18_ = added;
#line 350 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	data_collection_notify_items_added (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, GEE_TYPE_ITERABLE, GeeIterable));
#line 351 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp19_ = added;
#line 351 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	data_collection_notify_contents_altered (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, GEE_TYPE_ITERABLE, GeeIterable), NULL);
#line 1537 "DataCollection.c"
	{
		gint ctr = 0;
#line 354 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		ctr = 0;
#line 1542 "DataCollection.c"
		{
			gboolean _tmp20_ = FALSE;
#line 354 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			_tmp20_ = TRUE;
#line 354 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			while (TRUE) {
#line 1549 "DataCollection.c"
				gint _tmp22_;
				gint _tmp23_;
				GeeArrayList* _tmp24_;
				gint _tmp25_;
				gpointer _tmp26_;
				DataObject* _tmp27_;
#line 354 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				if (!_tmp20_) {
#line 1558 "DataCollection.c"
					gint _tmp21_;
#line 354 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
					_tmp21_ = ctr;
#line 354 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
					ctr = _tmp21_ + 1;
#line 1564 "DataCollection.c"
				}
#line 354 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				_tmp20_ = FALSE;
#line 354 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				_tmp22_ = ctr;
#line 354 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				_tmp23_ = count;
#line 354 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				if (!(_tmp22_ < _tmp23_)) {
#line 354 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
					break;
#line 1576 "DataCollection.c"
				}
#line 355 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				_tmp24_ = added;
#line 355 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				_tmp25_ = ctr;
#line 355 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				_tmp26_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp25_);
#line 355 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				_tmp27_ = (DataObject*) _tmp26_;
#line 355 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				data_object_notify_membership_changed (_tmp27_, self);
#line 355 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				_g_object_unref0 (_tmp27_);
#line 1590 "DataCollection.c"
			}
		}
	}
#line 357 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (added, GEE_TYPE_COLLECTION, GeeCollection);
#line 357 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	return result;
#line 1598 "DataCollection.c"
}


GeeCollection*
data_collection_add_many (DataCollection* self,
                          GeeCollection* objects,
                          ProgressMonitor monitor,
                          void* monitor_target)
{
#line 330 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_val_if_fail (IS_DATA_COLLECTION (self), NULL);
#line 330 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	return DATA_COLLECTION_GET_CLASS (self)->add_many (self, objects, monitor, monitor_target);
#line 1612 "DataCollection.c"
}


Marker*
data_collection_start_marking (DataCollection* self)
{
	Marker* result = NULL;
	DataCollectionMarkerImpl* _tmp0_;
#line 361 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_val_if_fail (IS_DATA_COLLECTION (self), NULL);
#line 362 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp0_ = data_collection_marker_impl_new (self);
#line 362 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_MARKER, Marker);
#line 362 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	return result;
#line 1629 "DataCollection.c"
}


Marker*
data_collection_mark (DataCollection* self,
                      DataObject* object)
{
	Marker* result = NULL;
	Marker* marker = NULL;
	DataCollectionMarkerImpl* _tmp0_;
#line 366 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_val_if_fail (IS_DATA_COLLECTION (self), NULL);
#line 366 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_val_if_fail (IS_DATA_OBJECT (object), NULL);
#line 367 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp0_ = data_collection_marker_impl_new (self);
#line 367 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	marker = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_MARKER, Marker);
#line 368 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	marker_mark (marker, object);
#line 370 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	result = marker;
#line 370 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	return result;
#line 1654 "DataCollection.c"
}


Marker*
data_collection_mark_many (DataCollection* self,
                           GeeCollection* objects)
{
	Marker* result = NULL;
	Marker* marker = NULL;
	DataCollectionMarkerImpl* _tmp0_;
#line 374 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_val_if_fail (IS_DATA_COLLECTION (self), NULL);
#line 374 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_val_if_fail (GEE_IS_COLLECTION (objects), NULL);
#line 375 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp0_ = data_collection_marker_impl_new (self);
#line 375 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	marker = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_MARKER, Marker);
#line 376 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	marker_mark_many (marker, objects);
#line 378 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	result = marker;
#line 378 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	return result;
#line 1679 "DataCollection.c"
}


static gpointer
_g_object_ref0 (gpointer self)
{
#line 385 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	return self ? g_object_ref (self) : NULL;
#line 1688 "DataCollection.c"
}


void
data_collection_act_on_marked (DataCollection* self,
                               Marker* m,
                               MarkedAction action,
                               void* action_target,
                               ProgressMonitor monitor,
                               void* monitor_target,
                               GObject* user)
{
	DataCollectionMarkerImpl* marker = NULL;
	DataCollectionMarkerImpl* _tmp0_;
	DataCollectionMarkerImpl* _tmp1_;
	DataCollectionMarkerImpl* _tmp2_;
	guint64 count = 0ULL;
	guint64 total = 0ULL;
	DataCollectionMarkerImpl* _tmp3_;
	GeeHashSet* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	DataCollectionMarkerImpl* _tmp21_;
#line 383 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_if_fail (IS_DATA_COLLECTION (self));
#line 383 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_if_fail (IS_MARKER (m));
#line 383 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_if_fail ((user == NULL) || G_IS_OBJECT (user));
#line 385 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (m, DATA_COLLECTION_TYPE_MARKER_IMPL, DataCollectionMarkerImpl));
#line 385 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	marker = _tmp0_;
#line 387 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp1_ = marker;
#line 387 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_vala_assert (data_collection_marker_impl_is_valid (_tmp1_, self), "marker.is_valid(this)");
#line 390 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp2_ = marker;
#line 390 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	data_collection_marker_impl_freeze (_tmp2_);
#line 392 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	count = (guint64) 0;
#line 393 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp3_ = marker;
#line 393 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp4_ = _tmp3_->marked;
#line 393 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp5_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 393 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp6_ = _tmp5_;
#line 393 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	total = (guint64) _tmp6_;
#line 1742 "DataCollection.c"
	{
		GeeIterator* _object_it = NULL;
		DataCollectionMarkerImpl* _tmp7_;
		GeeHashSet* _tmp8_;
		GeeIterator* _tmp9_;
#line 396 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		_tmp7_ = marker;
#line 396 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		_tmp8_ = _tmp7_->marked;
#line 396 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		_tmp9_ = gee_abstract_collection_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 396 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		_object_it = _tmp9_;
#line 396 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		while (TRUE) {
#line 1758 "DataCollection.c"
			GeeIterator* _tmp10_;
			DataObject* object = NULL;
			GeeIterator* _tmp11_;
			gpointer _tmp12_;
			DataObject* _tmp13_;
			DataObject* _tmp17_;
#line 396 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			_tmp10_ = _object_it;
#line 396 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			if (!gee_iterator_next (_tmp10_)) {
#line 396 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				break;
#line 1771 "DataCollection.c"
			}
#line 396 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			_tmp11_ = _object_it;
#line 396 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			_tmp12_ = gee_iterator_get (_tmp11_);
#line 396 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			object = (DataObject*) _tmp12_;
#line 398 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			_tmp13_ = object;
#line 398 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			if (!data_collection_internal_contains (self, _tmp13_)) {
#line 1783 "DataCollection.c"
				DataObject* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
#line 399 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				_tmp14_ = object;
#line 399 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				_tmp15_ = data_object_to_string (_tmp14_);
#line 399 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				_tmp16_ = _tmp15_;
#line 399 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				g_warning ("DataCollection.vala:399: act_on_marked: marker holding ref to unknown " \
"%s", _tmp16_);
#line 399 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				_g_free0 (_tmp16_);
#line 401 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				_g_object_unref0 (object);
#line 401 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				continue;
#line 1801 "DataCollection.c"
			}
#line 404 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			_tmp17_ = object;
#line 404 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			if (!action (_tmp17_, user, action_target)) {
#line 405 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				_g_object_unref0 (object);
#line 405 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				break;
#line 1811 "DataCollection.c"
			}
#line 407 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			if (monitor != NULL) {
#line 1815 "DataCollection.c"
				guint64 _tmp18_;
				guint64 _tmp19_;
				guint64 _tmp20_;
#line 408 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				_tmp18_ = count;
#line 408 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				count = _tmp18_ + 1;
#line 408 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				_tmp19_ = count;
#line 408 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				_tmp20_ = total;
#line 408 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				if (!monitor (_tmp19_, _tmp20_, TRUE, monitor_target)) {
#line 409 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
					_g_object_unref0 (object);
#line 409 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
					break;
#line 1833 "DataCollection.c"
				}
			}
#line 396 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			_g_object_unref0 (object);
#line 1838 "DataCollection.c"
		}
#line 396 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		_g_object_unref0 (_object_it);
#line 1842 "DataCollection.c"
	}
#line 414 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp21_ = marker;
#line 414 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	data_collection_marker_impl_finished (_tmp21_);
#line 383 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_g_object_unref0 (marker);
#line 1850 "DataCollection.c"
}


static void
data_collection_real_remove_marked (DataCollection* self,
                                    Marker* m)
{
	DataCollectionMarkerImpl* marker = NULL;
	DataCollectionMarkerImpl* _tmp0_;
	DataCollectionMarkerImpl* _tmp1_;
	DataCollectionMarkerImpl* _tmp2_;
	GeeArrayList* skipped = NULL;
	GeeArrayList* _tmp18_;
	DataCollectionMarkerImpl* _tmp22_;
	GeeHashSet* _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	DataCollectionMarkerImpl* _tmp37_;
#line 419 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_if_fail (IS_MARKER (m));
#line 420 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (m, DATA_COLLECTION_TYPE_MARKER_IMPL, DataCollectionMarkerImpl));
#line 420 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	marker = _tmp0_;
#line 422 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp1_ = marker;
#line 422 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_vala_assert (data_collection_marker_impl_is_valid (_tmp1_, self), "marker.is_valid(this)");
#line 425 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp2_ = marker;
#line 425 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	data_collection_marker_impl_freeze (_tmp2_);
#line 428 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	skipped = NULL;
#line 1885 "DataCollection.c"
	{
		GeeIterator* _object_it = NULL;
		DataCollectionMarkerImpl* _tmp3_;
		GeeHashSet* _tmp4_;
		GeeIterator* _tmp5_;
#line 429 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		_tmp3_ = marker;
#line 429 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		_tmp4_ = _tmp3_->marked;
#line 429 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		_tmp5_ = gee_abstract_collection_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 429 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		_object_it = _tmp5_;
#line 429 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		while (TRUE) {
#line 1901 "DataCollection.c"
			GeeIterator* _tmp6_;
			DataObject* object = NULL;
			GeeIterator* _tmp7_;
			gpointer _tmp8_;
			DataObject* _tmp9_;
			DataObject* _tmp17_;
#line 429 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			_tmp6_ = _object_it;
#line 429 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			if (!gee_iterator_next (_tmp6_)) {
#line 429 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				break;
#line 1914 "DataCollection.c"
			}
#line 429 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			_tmp7_ = _object_it;
#line 429 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			_tmp8_ = gee_iterator_get (_tmp7_);
#line 429 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			object = (DataObject*) _tmp8_;
#line 431 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			_tmp9_ = object;
#line 431 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			if (!data_collection_internal_contains (self, _tmp9_)) {
#line 1926 "DataCollection.c"
				DataObject* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
				GeeArrayList* _tmp13_;
				GeeArrayList* _tmp15_;
				DataObject* _tmp16_;
#line 432 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				_tmp10_ = object;
#line 432 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				_tmp11_ = data_object_to_string (_tmp10_);
#line 432 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				_tmp12_ = _tmp11_;
#line 432 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				g_warning ("DataCollection.vala:432: remove_marked: marker holding ref to unknown " \
"%s", _tmp12_);
#line 432 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				_g_free0 (_tmp12_);
#line 434 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				_tmp13_ = skipped;
#line 434 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				if (_tmp13_ == NULL) {
#line 1947 "DataCollection.c"
					GeeArrayList* _tmp14_;
#line 435 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
					_tmp14_ = gee_array_list_new (TYPE_DATA_OBJECT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 435 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
					_g_object_unref0 (skipped);
#line 435 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
					skipped = _tmp14_;
#line 1955 "DataCollection.c"
				}
#line 437 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				_tmp15_ = skipped;
#line 437 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				_tmp16_ = object;
#line 437 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp16_);
#line 439 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				_g_object_unref0 (object);
#line 439 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				continue;
#line 1967 "DataCollection.c"
			}
#line 442 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			_tmp17_ = object;
#line 442 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			data_collection_internal_remove (self, _tmp17_);
#line 429 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			_g_object_unref0 (object);
#line 1975 "DataCollection.c"
		}
#line 429 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		_g_object_unref0 (_object_it);
#line 1979 "DataCollection.c"
	}
#line 445 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp18_ = skipped;
#line 445 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	if (_tmp18_ != NULL) {
#line 1985 "DataCollection.c"
		DataCollectionMarkerImpl* _tmp19_;
		GeeHashSet* _tmp20_;
		GeeArrayList* _tmp21_;
#line 446 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		_tmp19_ = marker;
#line 446 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		_tmp20_ = _tmp19_->marked;
#line 446 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		_tmp21_ = skipped;
#line 446 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		gee_collection_remove_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, GEE_TYPE_COLLECTION, GeeCollection));
#line 1997 "DataCollection.c"
	}
#line 449 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp22_ = marker;
#line 449 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp23_ = _tmp22_->marked;
#line 449 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp24_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 449 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp25_ = _tmp24_;
#line 449 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	if (_tmp25_ > 0) {
#line 2009 "DataCollection.c"
		DataCollectionMarkerImpl* _tmp26_;
		GeeHashSet* _tmp27_;
		DataCollectionMarkerImpl* _tmp28_;
		GeeHashSet* _tmp29_;
#line 450 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		_tmp26_ = marker;
#line 450 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		_tmp27_ = _tmp26_->marked;
#line 450 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		data_collection_notify_items_removed (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, GEE_TYPE_ITERABLE, GeeIterable));
#line 451 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		_tmp28_ = marker;
#line 451 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		_tmp29_ = _tmp28_->marked;
#line 451 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		data_collection_notify_contents_altered (self, NULL, G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, GEE_TYPE_ITERABLE, GeeIterable));
#line 2026 "DataCollection.c"
		{
			GeeIterator* _object_it = NULL;
			DataCollectionMarkerImpl* _tmp30_;
			GeeHashSet* _tmp31_;
			GeeIterator* _tmp32_;
#line 454 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			_tmp30_ = marker;
#line 454 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			_tmp31_ = _tmp30_->marked;
#line 454 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			_tmp32_ = gee_abstract_collection_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 454 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			_object_it = _tmp32_;
#line 454 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			while (TRUE) {
#line 2042 "DataCollection.c"
				GeeIterator* _tmp33_;
				DataObject* object = NULL;
				GeeIterator* _tmp34_;
				gpointer _tmp35_;
				DataObject* _tmp36_;
#line 454 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				_tmp33_ = _object_it;
#line 454 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				if (!gee_iterator_next (_tmp33_)) {
#line 454 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
					break;
#line 2054 "DataCollection.c"
				}
#line 454 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				_tmp34_ = _object_it;
#line 454 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				_tmp35_ = gee_iterator_get (_tmp34_);
#line 454 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				object = (DataObject*) _tmp35_;
#line 455 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				_tmp36_ = object;
#line 455 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				data_object_notify_membership_changed (_tmp36_, NULL);
#line 454 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				_g_object_unref0 (object);
#line 2068 "DataCollection.c"
			}
#line 454 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			_g_object_unref0 (_object_it);
#line 2072 "DataCollection.c"
		}
	}
#line 459 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp37_ = marker;
#line 459 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	data_collection_marker_impl_finished (_tmp37_);
#line 419 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_g_object_unref0 (skipped);
#line 419 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_g_object_unref0 (marker);
#line 2083 "DataCollection.c"
}


void
data_collection_remove_marked (DataCollection* self,
                               Marker* m)
{
#line 419 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_if_fail (IS_DATA_COLLECTION (self));
#line 419 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	DATA_COLLECTION_GET_CLASS (self)->remove_marked (self, m);
#line 2095 "DataCollection.c"
}


static void
data_collection_real_clear (DataCollection* self)
{
	DataSet* _tmp0_;
	GeeArrayList* removed = NULL;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp10_;
	GeeArrayList* _tmp11_;
#line 463 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp0_ = self->priv->dataset;
#line 463 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	if (data_set_get_count (_tmp0_) == 0) {
#line 464 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		return;
#line 2113 "DataCollection.c"
	}
#line 468 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp1_ = gee_array_list_new (TYPE_DATA_OBJECT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 468 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	removed = _tmp1_;
#line 2119 "DataCollection.c"
	{
		gboolean _tmp2_ = FALSE;
#line 469 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		_tmp2_ = TRUE;
#line 469 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		while (TRUE) {
#line 2126 "DataCollection.c"
			DataObject* object = NULL;
			DataSet* _tmp4_;
			DataObject* _tmp5_;
			DataObject* _tmp6_;
			GeeArrayList* _tmp7_;
			DataObject* _tmp8_;
			DataObject* _tmp9_;
#line 469 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			if (!_tmp2_) {
#line 2136 "DataCollection.c"
				DataSet* _tmp3_;
#line 475 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				_tmp3_ = self->priv->dataset;
#line 475 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				if (!(data_set_get_count (_tmp3_) > 0)) {
#line 475 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
					break;
#line 2144 "DataCollection.c"
				}
			}
#line 469 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			_tmp2_ = FALSE;
#line 470 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			_tmp4_ = self->priv->dataset;
#line 470 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			_tmp5_ = data_set_get_at (_tmp4_, 0);
#line 470 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			object = _tmp5_;
#line 471 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			_tmp6_ = object;
#line 471 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			_vala_assert (_tmp6_ != NULL, "object != null");
#line 473 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			_tmp7_ = removed;
#line 473 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			_tmp8_ = object;
#line 473 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp8_);
#line 474 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			_tmp9_ = object;
#line 474 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			data_collection_internal_remove (self, _tmp9_);
#line 469 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			_g_object_unref0 (object);
#line 2171 "DataCollection.c"
		}
	}
#line 478 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp10_ = removed;
#line 478 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	data_collection_notify_items_removed (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_ITERABLE, GeeIterable));
#line 479 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp11_ = removed;
#line 479 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	data_collection_notify_contents_altered (self, NULL, G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GEE_TYPE_ITERABLE, GeeIterable));
#line 2182 "DataCollection.c"
	{
		GeeArrayList* _object_list = NULL;
		GeeArrayList* _tmp12_;
		GeeArrayList* _tmp13_;
		gint _object_size = 0;
		GeeArrayList* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gint _object_index = 0;
#line 482 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		_tmp12_ = removed;
#line 482 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		_tmp13_ = _g_object_ref0 (_tmp12_);
#line 482 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		_object_list = _tmp13_;
#line 482 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		_tmp14_ = _object_list;
#line 482 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		_tmp15_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 482 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		_tmp16_ = _tmp15_;
#line 482 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		_object_size = _tmp16_;
#line 482 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		_object_index = -1;
#line 482 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		while (TRUE) {
#line 2210 "DataCollection.c"
			gint _tmp17_;
			gint _tmp18_;
			gint _tmp19_;
			DataObject* object = NULL;
			GeeArrayList* _tmp20_;
			gint _tmp21_;
			gpointer _tmp22_;
			DataObject* _tmp23_;
#line 482 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			_tmp17_ = _object_index;
#line 482 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			_object_index = _tmp17_ + 1;
#line 482 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			_tmp18_ = _object_index;
#line 482 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			_tmp19_ = _object_size;
#line 482 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			if (!(_tmp18_ < _tmp19_)) {
#line 482 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				break;
#line 2231 "DataCollection.c"
			}
#line 482 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			_tmp20_ = _object_list;
#line 482 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			_tmp21_ = _object_index;
#line 482 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			_tmp22_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp21_);
#line 482 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			object = (DataObject*) _tmp22_;
#line 483 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			_tmp23_ = object;
#line 483 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			data_object_notify_membership_changed (_tmp23_, NULL);
#line 482 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			_g_object_unref0 (object);
#line 2247 "DataCollection.c"
		}
#line 482 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		_g_object_unref0 (_object_list);
#line 2251 "DataCollection.c"
	}
#line 462 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_g_object_unref0 (removed);
#line 2255 "DataCollection.c"
}


void
data_collection_clear (DataCollection* self)
{
#line 462 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_if_fail (IS_DATA_COLLECTION (self));
#line 462 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	DATA_COLLECTION_GET_CLASS (self)->clear (self);
#line 2266 "DataCollection.c"
}


static void
data_collection_real_close (DataCollection* self)
{
#line 493 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	data_collection_clear (self);
#line 2275 "DataCollection.c"
}


void
data_collection_close (DataCollection* self)
{
#line 492 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_if_fail (IS_DATA_COLLECTION (self));
#line 492 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	DATA_COLLECTION_GET_CLASS (self)->close (self);
#line 2286 "DataCollection.c"
}


static gpointer
_alteration_ref0 (gpointer self)
{
#line 513 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	return self ? alteration_ref (self) : NULL;
#line 2295 "DataCollection.c"
}


void
data_collection_internal_notify_altered (DataCollection* self,
                                         DataObject* object,
                                         Alteration* alteration)
{
	gboolean resort_occurred = FALSE;
	DataSet* _tmp0_;
	gboolean _tmp14_;
	GeeMap* _tmp15_;
	GeeMap* _tmp16_;
#line 498 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_if_fail (IS_DATA_COLLECTION (self));
#line 498 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_if_fail (IS_DATA_OBJECT (object));
#line 498 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_if_fail (IS_ALTERATION (alteration));
#line 499 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_vala_assert (data_collection_internal_contains (self, object), "internal_contains(object)");
#line 501 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp0_ = self->priv->dataset;
#line 501 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	resort_occurred = data_set_resort_object (_tmp0_, object, alteration);
#line 503 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	if (data_collection_are_notifications_frozen (self)) {
#line 2323 "DataCollection.c"
		GeeHashMap* _tmp1_;
		Alteration* current = NULL;
		GeeHashMap* _tmp3_;
		gpointer _tmp4_;
		Alteration* _tmp5_;
		GeeHashMap* _tmp9_;
		Alteration* _tmp10_;
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_;
#line 504 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		_tmp1_ = self->priv->frozen_items_altered;
#line 504 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		if (_tmp1_ == NULL) {
#line 2337 "DataCollection.c"
			GeeHashMap* _tmp2_;
#line 505 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			_tmp2_ = gee_hash_map_new (TYPE_DATA_OBJECT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, TYPE_ALTERATION, (GBoxedCopyFunc) alteration_ref, (GDestroyNotify) alteration_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 505 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			_g_object_unref0 (self->priv->frozen_items_altered);
#line 505 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			self->priv->frozen_items_altered = _tmp2_;
#line 2345 "DataCollection.c"
		}
#line 509 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		_tmp3_ = self->priv->frozen_items_altered;
#line 509 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		_tmp4_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), object);
#line 509 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		current = (Alteration*) _tmp4_;
#line 510 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		_tmp5_ = current;
#line 510 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		if (_tmp5_ != NULL) {
#line 2357 "DataCollection.c"
			Alteration* _tmp6_;
			Alteration* _tmp7_;
#line 511 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			_tmp6_ = current;
#line 511 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			_tmp7_ = alteration_compress (_tmp6_, alteration);
#line 511 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			_alteration_unref0 (current);
#line 511 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			current = _tmp7_;
#line 2368 "DataCollection.c"
		} else {
			Alteration* _tmp8_;
#line 513 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			_tmp8_ = _alteration_ref0 (alteration);
#line 513 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			_alteration_unref0 (current);
#line 513 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			current = _tmp8_;
#line 2377 "DataCollection.c"
		}
#line 515 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		_tmp9_ = self->priv->frozen_items_altered;
#line 515 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		_tmp10_ = current;
#line 515 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), object, _tmp10_);
#line 517 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		_tmp12_ = self->priv->fire_ordering_changed;
#line 517 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		if (_tmp12_) {
#line 517 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			_tmp11_ = TRUE;
#line 2391 "DataCollection.c"
		} else {
			gboolean _tmp13_;
#line 517 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			_tmp13_ = resort_occurred;
#line 517 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			_tmp11_ = _tmp13_;
#line 2398 "DataCollection.c"
		}
#line 517 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		self->priv->fire_ordering_changed = _tmp11_;
#line 519 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		_alteration_unref0 (current);
#line 519 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		return;
#line 2406 "DataCollection.c"
	}
#line 522 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp14_ = resort_occurred;
#line 522 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	if (_tmp14_) {
#line 523 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		data_collection_notify_ordering_changed (self);
#line 2414 "DataCollection.c"
	}
#line 525 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp15_ = data_collection_get_alteration_singleton (object, alteration);
#line 525 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp16_ = _tmp15_;
#line 525 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	data_collection_notify_items_altered (self, _tmp16_);
#line 525 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_g_object_unref0 (_tmp16_);
#line 2424 "DataCollection.c"
}


GValue*
data_collection_get_property (DataCollection* self,
                              const gchar* name)
{
	GValue* result = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
#line 528 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_val_if_fail (IS_DATA_COLLECTION (self), NULL);
#line 528 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 529 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp0_ = self->priv->properties;
#line 529 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp1_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), name);
#line 529 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	result = (GValue*) _tmp1_;
#line 529 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	return result;
#line 2447 "DataCollection.c"
}


static gboolean
_bool_value_equals_value_equal_func (GValue* a,
                                     GValue* b,
                                     gpointer self)
{
	gboolean result;
	result = bool_value_equals (a, b);
#line 535 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	return result;
#line 2460 "DataCollection.c"
}


static gboolean
_int_value_equals_value_equal_func (GValue* a,
                                    GValue* b,
                                    gpointer self)
{
	gboolean result;
	result = int_value_equals (a, b);
#line 537 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	return result;
#line 2473 "DataCollection.c"
}


void
data_collection_set_property (DataCollection* self,
                              const gchar* name,
                              GValue* val,
                              ValueEqualFunc value_equals,
                              void* value_equals_target)
{
	GValue* old = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	GValue* _tmp2_;
	GeeHashMap* _tmp6_;
	GValue _tmp7_;
	GValue* _tmp8_;
	GValue _tmp9_;
	gint count = 0;
	DataSet* _tmp10_;
#line 532 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_if_fail (IS_DATA_COLLECTION (self));
#line 532 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_if_fail (name != NULL);
#line 532 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_if_fail (val != NULL);
#line 533 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	if (value_equals == NULL) {
#line 534 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		if (G_VALUE_HOLDS (val, G_TYPE_BOOLEAN)) {
#line 535 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			value_equals = _bool_value_equals_value_equal_func;
#line 535 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			value_equals_target = NULL;
#line 2508 "DataCollection.c"
		} else {
#line 536 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			if (G_VALUE_HOLDS (val, G_TYPE_INT)) {
#line 537 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				value_equals = _int_value_equals_value_equal_func;
#line 537 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				value_equals_target = NULL;
#line 2516 "DataCollection.c"
			} else {
#line 539 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				g_error ("DataCollection.vala:539: value_equals must be specified for this type");
#line 2520 "DataCollection.c"
			}
		}
	}
#line 542 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp0_ = self->priv->properties;
#line 542 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp1_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), name);
#line 542 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	old = (GValue*) _tmp1_;
#line 543 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp2_ = old;
#line 543 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	if (_tmp2_ != NULL) {
#line 2534 "DataCollection.c"
		GValue* _tmp3_;
		GValue _tmp4_;
		GValue _tmp5_;
#line 544 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		_tmp3_ = old;
#line 544 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		_tmp4_ = *val;
#line 544 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		_tmp5_ = *_tmp3_;
#line 544 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		if (value_equals (&_tmp5_, &_tmp4_, value_equals_target)) {
#line 545 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			__vala_GValue_free0 (old);
#line 545 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			return;
#line 2550 "DataCollection.c"
		}
	}
#line 548 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp6_ = self->priv->properties;
#line 548 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp7_ = *val;
#line 548 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), name, &_tmp7_);
#line 550 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp8_ = old;
#line 550 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp9_ = *val;
#line 550 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	data_collection_notify_property_set (self, name, _tmp8_, &_tmp9_);
#line 553 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp10_ = self->priv->dataset;
#line 553 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	count = data_set_get_count (_tmp10_);
#line 2569 "DataCollection.c"
	{
		gint ctr = 0;
#line 554 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		ctr = 0;
#line 2574 "DataCollection.c"
		{
			gboolean _tmp11_ = FALSE;
#line 554 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			_tmp11_ = TRUE;
#line 554 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			while (TRUE) {
#line 2581 "DataCollection.c"
				gint _tmp13_;
				gint _tmp14_;
				DataSet* _tmp15_;
				gint _tmp16_;
				DataObject* _tmp17_;
				DataObject* _tmp18_;
				GValue* _tmp19_;
				GValue _tmp20_;
#line 554 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				if (!_tmp11_) {
#line 2592 "DataCollection.c"
					gint _tmp12_;
#line 554 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
					_tmp12_ = ctr;
#line 554 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
					ctr = _tmp12_ + 1;
#line 2598 "DataCollection.c"
				}
#line 554 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				_tmp11_ = FALSE;
#line 554 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				_tmp13_ = ctr;
#line 554 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				_tmp14_ = count;
#line 554 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				if (!(_tmp13_ < _tmp14_)) {
#line 554 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
					break;
#line 2610 "DataCollection.c"
				}
#line 555 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				_tmp15_ = self->priv->dataset;
#line 555 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				_tmp16_ = ctr;
#line 555 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				_tmp17_ = data_set_get_at (_tmp15_, _tmp16_);
#line 555 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				_tmp18_ = _tmp17_;
#line 555 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				_tmp19_ = old;
#line 555 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				_tmp20_ = *val;
#line 555 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				data_object_notify_collection_property_set (_tmp18_, name, _tmp19_, &_tmp20_);
#line 555 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				_g_object_unref0 (_tmp18_);
#line 2628 "DataCollection.c"
			}
		}
	}
#line 532 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	__vala_GValue_free0 (old);
#line 2634 "DataCollection.c"
}


void
data_collection_clear_property (DataCollection* self,
                                const gchar* name)
{
	GeeHashMap* _tmp0_;
	gboolean _tmp1_;
	gint count = 0;
	DataSet* _tmp2_;
#line 558 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_if_fail (IS_DATA_COLLECTION (self));
#line 558 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_if_fail (name != NULL);
#line 559 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp0_ = self->priv->properties;
#line 559 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp1_ = gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), name, NULL);
#line 559 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	if (!_tmp1_) {
#line 560 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		return;
#line 2658 "DataCollection.c"
	}
#line 563 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	data_collection_notify_property_cleared (self, name);
#line 566 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp2_ = self->priv->dataset;
#line 566 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	count = data_set_get_count (_tmp2_);
#line 2666 "DataCollection.c"
	{
		gint ctr = 0;
#line 567 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		ctr = 0;
#line 2671 "DataCollection.c"
		{
			gboolean _tmp3_ = FALSE;
#line 567 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			_tmp3_ = TRUE;
#line 567 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			while (TRUE) {
#line 2678 "DataCollection.c"
				gint _tmp5_;
				gint _tmp6_;
				DataSet* _tmp7_;
				gint _tmp8_;
				DataObject* _tmp9_;
				DataObject* _tmp10_;
#line 567 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				if (!_tmp3_) {
#line 2687 "DataCollection.c"
					gint _tmp4_;
#line 567 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
					_tmp4_ = ctr;
#line 567 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
					ctr = _tmp4_ + 1;
#line 2693 "DataCollection.c"
				}
#line 567 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				_tmp3_ = FALSE;
#line 567 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				_tmp5_ = ctr;
#line 567 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				_tmp6_ = count;
#line 567 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				if (!(_tmp5_ < _tmp6_)) {
#line 567 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
					break;
#line 2705 "DataCollection.c"
				}
#line 568 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				_tmp7_ = self->priv->dataset;
#line 568 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				_tmp8_ = ctr;
#line 568 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				_tmp9_ = data_set_get_at (_tmp7_, _tmp8_);
#line 568 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				_tmp10_ = _tmp9_;
#line 568 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				data_object_notify_collection_property_cleared (_tmp10_, name);
#line 568 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				_g_object_unref0 (_tmp10_);
#line 2719 "DataCollection.c"
			}
		}
	}
}


void
data_collection_freeze_notifications (DataCollection* self)
{
	gint _tmp0_;
#line 581 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_if_fail (IS_DATA_COLLECTION (self));
#line 582 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp0_ = self->priv->notifies_frozen;
#line 582 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	self->priv->notifies_frozen = _tmp0_ + 1;
#line 582 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	if (_tmp0_ == 0) {
#line 583 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		data_collection_notify_frozen (self);
#line 2740 "DataCollection.c"
	}
}


void
data_collection_thaw_notifications (DataCollection* self)
{
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
#line 586 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_if_fail (IS_DATA_COLLECTION (self));
#line 587 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp0_ = self->priv->notifies_frozen;
#line 587 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	if (_tmp0_ == 0) {
#line 588 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		return;
#line 2759 "DataCollection.c"
	}
#line 590 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp1_ = self->priv->notifies_frozen;
#line 590 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	self->priv->notifies_frozen = _tmp1_ - 1;
#line 590 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp2_ = self->priv->notifies_frozen;
#line 590 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	if (_tmp2_ == 0) {
#line 591 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		data_collection_notify_thawed (self);
#line 2771 "DataCollection.c"
	}
}


gboolean
data_collection_are_notifications_frozen (DataCollection* self)
{
	gboolean result = FALSE;
	gint _tmp0_;
#line 594 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_val_if_fail (IS_DATA_COLLECTION (self), FALSE);
#line 595 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp0_ = self->priv->notifies_frozen;
#line 595 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	result = _tmp0_ > 0;
#line 595 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	return result;
#line 2789 "DataCollection.c"
}


static void
data_collection_real_notify_frozen (DataCollection* self)
{
#line 601 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_signal_emit (self, data_collection_signals[DATA_COLLECTION_FROZEN_SIGNAL], 0);
#line 2798 "DataCollection.c"
}


void
data_collection_notify_frozen (DataCollection* self)
{
#line 600 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_if_fail (IS_DATA_COLLECTION (self));
#line 600 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	DATA_COLLECTION_GET_CLASS (self)->notify_frozen (self);
#line 2809 "DataCollection.c"
}


static void
data_collection_real_notify_thawed (DataCollection* self)
{
	GeeHashMap* _tmp0_;
	gboolean _tmp4_;
#line 607 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp0_ = self->priv->frozen_items_altered;
#line 607 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	if (_tmp0_ != NULL) {
#line 2822 "DataCollection.c"
		GeeMap* copy = NULL;
		GeeHashMap* _tmp1_;
		GeeMap* _tmp2_;
		GeeMap* _tmp3_;
#line 609 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		_tmp1_ = self->priv->frozen_items_altered;
#line 609 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_MAP, GeeMap));
#line 609 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		copy = _tmp2_;
#line 610 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		_g_object_unref0 (self->priv->frozen_items_altered);
#line 610 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		self->priv->frozen_items_altered = NULL;
#line 612 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		_tmp3_ = copy;
#line 612 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		data_collection_notify_items_altered (self, _tmp3_);
#line 607 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		_g_object_unref0 (copy);
#line 2843 "DataCollection.c"
	}
#line 615 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp4_ = self->priv->fire_ordering_changed;
#line 615 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	if (_tmp4_) {
#line 616 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		self->priv->fire_ordering_changed = FALSE;
#line 617 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		data_collection_notify_ordering_changed (self);
#line 2853 "DataCollection.c"
	}
#line 620 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_signal_emit (self, data_collection_signals[DATA_COLLECTION_THAWED_SIGNAL], 0);
#line 2857 "DataCollection.c"
}


void
data_collection_notify_thawed (DataCollection* self)
{
#line 606 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_if_fail (IS_DATA_COLLECTION (self));
#line 606 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	DATA_COLLECTION_GET_CLASS (self)->notify_thawed (self);
#line 2868 "DataCollection.c"
}


static void
data_collection_real_items_added (DataCollection* self,
                                  GeeIterable* added)
{
#line 116 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_if_fail (GEE_IS_ITERABLE (added));
#line 2878 "DataCollection.c"
}


static void
data_collection_real_items_removed (DataCollection* self,
                                    GeeIterable* removed)
{
#line 120 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_if_fail (GEE_IS_ITERABLE (removed));
#line 2888 "DataCollection.c"
}


static void
data_collection_real_contents_altered (DataCollection* self,
                                       GeeIterable* added,
                                       GeeIterable* removed)
{
#line 124 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_if_fail ((added == NULL) || GEE_IS_ITERABLE (added));
#line 124 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_if_fail ((removed == NULL) || GEE_IS_ITERABLE (removed));
#line 2901 "DataCollection.c"
}


static void
g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure,
                                             GValue * return_value,
                                             guint n_param_values,
                                             const GValue * param_values,
                                             gpointer invocation_hint,
                                             gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_if_fail (n_param_values == 3);
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		data1 = closure->data;
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		data2 = param_values->data[0].v_pointer;
#line 2927 "DataCollection.c"
	} else {
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		data1 = param_values->data[0].v_pointer;
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		data2 = closure->data;
#line 2933 "DataCollection.c"
	}
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT) (marshal_data ? marshal_data : cc->callback);
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), data2);
#line 2939 "DataCollection.c"
}


static void
data_collection_real_items_altered (DataCollection* self,
                                    GeeMap* items)
{
#line 130 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_if_fail (GEE_IS_MAP (items));
#line 2949 "DataCollection.c"
}


static void
data_collection_real_ordering_changed (DataCollection* self)
{
}


static void
data_collection_real_property_set (DataCollection* self,
                                   const gchar* name,
                                   GValue* old,
                                   GValue* val)
{
#line 140 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_if_fail (name != NULL);
#line 140 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_if_fail (val != NULL);
#line 2969 "DataCollection.c"
}


static void
g_cclosure_user_marshal_VOID__STRING_POINTER_BOXED (GClosure * closure,
                                                    GValue * return_value,
                                                    guint n_param_values,
                                                    const GValue * param_values,
                                                    gpointer invocation_hint,
                                                    gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__STRING_POINTER_BOXED) (gpointer data1, const char* arg_1, gpointer arg_2, gpointer arg_3, gpointer data2);
	register GMarshalFunc_VOID__STRING_POINTER_BOXED callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_if_fail (n_param_values == 4);
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		data1 = closure->data;
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		data2 = param_values->data[0].v_pointer;
#line 2995 "DataCollection.c"
	} else {
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		data1 = param_values->data[0].v_pointer;
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		data2 = closure->data;
#line 3001 "DataCollection.c"
	}
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	callback = (GMarshalFunc_VOID__STRING_POINTER_BOXED) (marshal_data ? marshal_data : cc->callback);
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	callback (data1, g_value_get_string (param_values + 1), g_value_get_pointer (param_values + 2), g_value_get_boxed (param_values + 3), data2);
#line 3007 "DataCollection.c"
}


static void
data_collection_real_property_cleared (DataCollection* self,
                                       const gchar* name)
{
#line 144 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_if_fail (name != NULL);
#line 3017 "DataCollection.c"
}


static void
data_collection_real_frozen (DataCollection* self)
{
}


static void
data_collection_real_thawed (DataCollection* self)
{
}


static void
_data_collection_marker_impl_on_items_removed_data_collection_items_removed (DataCollection* _sender,
                                                                             GeeIterable* removed,
                                                                             gpointer self)
{
#line 24 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	data_collection_marker_impl_on_items_removed ((DataCollectionMarkerImpl*) self, removed);
#line 3040 "DataCollection.c"
}


static gpointer
_data_collection_ref0 (gpointer self)
{
#line 16 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	return self ? data_collection_ref (self) : NULL;
#line 3049 "DataCollection.c"
}


static DataCollectionMarkerImpl*
data_collection_marker_impl_construct (GType object_type,
                                       DataCollection* owner)
{
	DataCollectionMarkerImpl * self = NULL;
	DataCollection* _tmp0_;
#line 15 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_val_if_fail (IS_DATA_COLLECTION (owner), NULL);
#line 15 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	self = (DataCollectionMarkerImpl*) g_object_new (object_type, NULL);
#line 16 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp0_ = _data_collection_ref0 (owner);
#line 16 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_data_collection_unref0 (self->owner);
#line 16 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	self->owner = _tmp0_;
#line 20 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_signal_connect_object (owner, "items-removed", (GCallback) _data_collection_marker_impl_on_items_removed_data_collection_items_removed, self, 0);
#line 15 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	return self;
#line 3073 "DataCollection.c"
}


static DataCollectionMarkerImpl*
data_collection_marker_impl_new (DataCollection* owner)
{
#line 15 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	return data_collection_marker_impl_construct (DATA_COLLECTION_TYPE_MARKER_IMPL, owner);
#line 3082 "DataCollection.c"
}


static void
data_collection_marker_impl_real_mark (Marker* base,
                                       DataObject* object)
{
	DataCollectionMarkerImpl * self;
	DataCollection* _tmp0_;
	GeeHashSet* _tmp1_;
#line 27 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, DATA_COLLECTION_TYPE_MARKER_IMPL, DataCollectionMarkerImpl);
#line 27 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_if_fail (IS_DATA_OBJECT (object));
#line 28 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp0_ = self->owner;
#line 28 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_vala_assert (data_collection_internal_contains (_tmp0_, object), "owner.internal_contains(object)");
#line 30 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp1_ = self->marked;
#line 30 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), object);
#line 3105 "DataCollection.c"
}


static void
data_collection_marker_impl_real_unmark (Marker* base,
                                         DataObject* object)
{
	DataCollectionMarkerImpl * self;
	DataCollection* _tmp0_;
	GeeHashSet* _tmp1_;
#line 33 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, DATA_COLLECTION_TYPE_MARKER_IMPL, DataCollectionMarkerImpl);
#line 33 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_if_fail (IS_DATA_OBJECT (object));
#line 34 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp0_ = self->owner;
#line 34 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_vala_assert (data_collection_internal_contains (_tmp0_, object), "owner.internal_contains(object)");
#line 36 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp1_ = self->marked;
#line 36 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	gee_abstract_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), object);
#line 3128 "DataCollection.c"
}


static gboolean
data_collection_marker_impl_real_toggle (Marker* base,
                                         DataObject* object)
{
	DataCollectionMarkerImpl * self;
	gboolean result = FALSE;
	DataCollection* _tmp0_;
	GeeHashSet* _tmp1_;
	GeeHashSet* _tmp4_;
#line 39 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, DATA_COLLECTION_TYPE_MARKER_IMPL, DataCollectionMarkerImpl);
#line 39 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_val_if_fail (IS_DATA_OBJECT (object), FALSE);
#line 40 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp0_ = self->owner;
#line 40 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_vala_assert (data_collection_internal_contains (_tmp0_, object), "owner.internal_contains(object)");
#line 42 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp1_ = self->marked;
#line 42 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	if (gee_abstract_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), object)) {
#line 3153 "DataCollection.c"
		GeeHashSet* _tmp2_;
#line 43 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		_tmp2_ = self->marked;
#line 43 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		gee_abstract_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), object);
#line 3159 "DataCollection.c"
	} else {
		GeeHashSet* _tmp3_;
#line 45 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		_tmp3_ = self->marked;
#line 45 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), object);
#line 3166 "DataCollection.c"
	}
#line 48 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp4_ = self->marked;
#line 48 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	result = gee_abstract_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), object);
#line 48 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	return result;
#line 3174 "DataCollection.c"
}


static void
data_collection_marker_impl_real_mark_many (Marker* base,
                                            GeeCollection* list)
{
	DataCollectionMarkerImpl * self;
#line 51 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, DATA_COLLECTION_TYPE_MARKER_IMPL, DataCollectionMarkerImpl);
#line 51 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_if_fail (GEE_IS_COLLECTION (list));
#line 3187 "DataCollection.c"
	{
		GeeIterator* _object_it = NULL;
		GeeIterator* _tmp0_;
#line 52 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		_tmp0_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (list, GEE_TYPE_ITERABLE, GeeIterable));
#line 52 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		_object_it = _tmp0_;
#line 52 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		while (TRUE) {
#line 3197 "DataCollection.c"
			GeeIterator* _tmp1_;
			DataObject* object = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			DataCollection* _tmp4_;
			DataObject* _tmp5_;
			GeeHashSet* _tmp6_;
			DataObject* _tmp7_;
#line 52 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			_tmp1_ = _object_it;
#line 52 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			if (!gee_iterator_next (_tmp1_)) {
#line 52 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				break;
#line 3212 "DataCollection.c"
			}
#line 52 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			_tmp2_ = _object_it;
#line 52 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			_tmp3_ = gee_iterator_get (_tmp2_);
#line 52 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			object = (DataObject*) _tmp3_;
#line 53 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			_tmp4_ = self->owner;
#line 53 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			_tmp5_ = object;
#line 53 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			_vala_assert (data_collection_internal_contains (_tmp4_, _tmp5_), "owner.internal_contains(object)");
#line 55 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			_tmp6_ = self->marked;
#line 55 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			_tmp7_ = object;
#line 55 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp7_);
#line 52 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			_g_object_unref0 (object);
#line 3234 "DataCollection.c"
		}
#line 52 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		_g_object_unref0 (_object_it);
#line 3238 "DataCollection.c"
	}
}


static void
data_collection_marker_impl_real_unmark_many (Marker* base,
                                              GeeCollection* list)
{
	DataCollectionMarkerImpl * self;
#line 59 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, DATA_COLLECTION_TYPE_MARKER_IMPL, DataCollectionMarkerImpl);
#line 59 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_if_fail (GEE_IS_COLLECTION (list));
#line 3252 "DataCollection.c"
	{
		GeeIterator* _object_it = NULL;
		GeeIterator* _tmp0_;
#line 60 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		_tmp0_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (list, GEE_TYPE_ITERABLE, GeeIterable));
#line 60 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		_object_it = _tmp0_;
#line 60 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		while (TRUE) {
#line 3262 "DataCollection.c"
			GeeIterator* _tmp1_;
			DataObject* object = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			DataCollection* _tmp4_;
			DataObject* _tmp5_;
			GeeHashSet* _tmp6_;
			DataObject* _tmp7_;
#line 60 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			_tmp1_ = _object_it;
#line 60 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			if (!gee_iterator_next (_tmp1_)) {
#line 60 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				break;
#line 3277 "DataCollection.c"
			}
#line 60 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			_tmp2_ = _object_it;
#line 60 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			_tmp3_ = gee_iterator_get (_tmp2_);
#line 60 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			object = (DataObject*) _tmp3_;
#line 61 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			_tmp4_ = self->owner;
#line 61 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			_tmp5_ = object;
#line 61 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			_vala_assert (data_collection_internal_contains (_tmp4_, _tmp5_), "owner.internal_contains(object)");
#line 63 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			_tmp6_ = self->marked;
#line 63 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			_tmp7_ = object;
#line 63 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			gee_abstract_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp7_);
#line 60 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			_g_object_unref0 (object);
#line 3299 "DataCollection.c"
		}
#line 60 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		_g_object_unref0 (_object_it);
#line 3303 "DataCollection.c"
	}
}


static void
data_collection_marker_impl_real_mark_all (Marker* base)
{
	DataCollectionMarkerImpl * self;
#line 67 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, DATA_COLLECTION_TYPE_MARKER_IMPL, DataCollectionMarkerImpl);
#line 3314 "DataCollection.c"
	{
		GeeIterator* _object_it = NULL;
		DataCollection* _tmp0_;
		GeeCollection* _tmp1_;
		GeeCollection* _tmp2_;
		GeeIterator* _tmp3_;
		GeeIterator* _tmp4_;
#line 68 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		_tmp0_ = self->owner;
#line 68 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		_tmp1_ = data_collection_get_all (_tmp0_);
#line 68 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		_tmp2_ = _tmp1_;
#line 68 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		_tmp3_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ITERABLE, GeeIterable));
#line 68 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		_tmp4_ = _tmp3_;
#line 68 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		_g_object_unref0 (_tmp2_);
#line 68 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		_object_it = _tmp4_;
#line 68 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		while (TRUE) {
#line 3338 "DataCollection.c"
			GeeIterator* _tmp5_;
			DataObject* object = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			GeeHashSet* _tmp8_;
			DataObject* _tmp9_;
#line 68 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			_tmp5_ = _object_it;
#line 68 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			if (!gee_iterator_next (_tmp5_)) {
#line 68 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				break;
#line 3351 "DataCollection.c"
			}
#line 68 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			_tmp6_ = _object_it;
#line 68 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			_tmp7_ = gee_iterator_get (_tmp6_);
#line 68 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			object = (DataObject*) _tmp7_;
#line 69 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			_tmp8_ = self->marked;
#line 69 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			_tmp9_ = object;
#line 69 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp9_);
#line 68 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			_g_object_unref0 (object);
#line 3367 "DataCollection.c"
		}
#line 68 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		_g_object_unref0 (_object_it);
#line 3371 "DataCollection.c"
	}
}


static gint
data_collection_marker_impl_real_get_count (Marker* base)
{
	DataCollectionMarkerImpl * self;
	gint result = 0;
	gint _tmp0_ = 0;
	GeeHashSet* _tmp1_;
#line 72 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, DATA_COLLECTION_TYPE_MARKER_IMPL, DataCollectionMarkerImpl);
#line 73 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp1_ = self->marked;
#line 73 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	if (_tmp1_ != NULL) {
#line 3389 "DataCollection.c"
		GeeHashSet* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
#line 73 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		_tmp2_ = self->marked;
#line 73 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		_tmp3_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 73 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		_tmp4_ = _tmp3_;
#line 73 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		_tmp0_ = _tmp4_;
#line 3401 "DataCollection.c"
	} else {
		gint _tmp5_;
#line 73 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		_tmp5_ = self->freeze_count;
#line 73 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		_tmp0_ = _tmp5_;
#line 3408 "DataCollection.c"
	}
#line 73 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	result = _tmp0_;
#line 73 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	return result;
#line 3414 "DataCollection.c"
}


static GeeCollection*
data_collection_marker_impl_real_get_all (Marker* base)
{
	DataCollectionMarkerImpl * self;
	GeeCollection* result = NULL;
	GeeArrayList* copy = NULL;
	GeeArrayList* _tmp0_;
	GeeHashSet* _tmp1_;
#line 76 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, DATA_COLLECTION_TYPE_MARKER_IMPL, DataCollectionMarkerImpl);
#line 77 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp0_ = gee_array_list_new (TYPE_DATA_OBJECT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 77 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	copy = _tmp0_;
#line 78 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp1_ = self->marked;
#line 78 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	gee_array_list_add_all (copy, G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_COLLECTION, GeeCollection));
#line 80 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (copy, GEE_TYPE_COLLECTION, GeeCollection);
#line 80 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	return result;
#line 3440 "DataCollection.c"
}


static void
data_collection_marker_impl_on_items_removed (DataCollectionMarkerImpl* self,
                                              GeeIterable* removed)
{
#line 83 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_if_fail (DATA_COLLECTION_IS_MARKER_IMPL (self));
#line 83 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_if_fail (GEE_IS_ITERABLE (removed));
#line 3452 "DataCollection.c"
	{
		GeeIterator* _object_it = NULL;
		GeeIterator* _tmp0_;
#line 84 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		_tmp0_ = gee_iterable_iterator (removed);
#line 84 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		_object_it = _tmp0_;
#line 84 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		while (TRUE) {
#line 3462 "DataCollection.c"
			GeeIterator* _tmp1_;
			DataObject* object = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			GeeHashSet* _tmp4_;
			DataObject* _tmp5_;
#line 84 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			_tmp1_ = _object_it;
#line 84 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			if (!gee_iterator_next (_tmp1_)) {
#line 84 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
				break;
#line 3475 "DataCollection.c"
			}
#line 84 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			_tmp2_ = _object_it;
#line 84 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			_tmp3_ = gee_iterator_get (_tmp2_);
#line 84 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			object = (DataObject*) _tmp3_;
#line 85 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			_tmp4_ = self->marked;
#line 85 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			_tmp5_ = object;
#line 85 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			gee_abstract_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp5_);
#line 84 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			_g_object_unref0 (object);
#line 3491 "DataCollection.c"
		}
#line 84 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		_g_object_unref0 (_object_it);
#line 3495 "DataCollection.c"
	}
}


static void
data_collection_marker_impl_freeze (DataCollectionMarkerImpl* self)
{
	DataCollection* _tmp0_;
	guint _tmp1_;
#line 91 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_if_fail (DATA_COLLECTION_IS_MARKER_IMPL (self));
#line 92 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp0_ = self->owner;
#line 92 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_signal_parse_name ("items-removed", TYPE_DATA_COLLECTION, &_tmp1_, NULL, FALSE);
#line 92 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _data_collection_marker_impl_on_items_removed_data_collection_items_removed, self);
#line 3513 "DataCollection.c"
}


static void
data_collection_marker_impl_finished (DataCollectionMarkerImpl* self)
{
	GeeHashSet* _tmp0_;
#line 95 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_if_fail (DATA_COLLECTION_IS_MARKER_IMPL (self));
#line 96 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp0_ = self->marked;
#line 96 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	if (_tmp0_ != NULL) {
#line 3527 "DataCollection.c"
		GeeHashSet* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
#line 97 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		_tmp1_ = self->marked;
#line 97 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		_tmp2_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 97 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		_tmp3_ = _tmp2_;
#line 97 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		self->freeze_count = _tmp3_;
#line 3539 "DataCollection.c"
	}
#line 99 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_g_object_unref0 (self->marked);
#line 99 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	self->marked = NULL;
#line 3545 "DataCollection.c"
}


static gboolean
data_collection_marker_impl_is_valid (DataCollectionMarkerImpl* self,
                                      DataCollection* collection)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	DataCollection* _tmp1_;
#line 102 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_val_if_fail (DATA_COLLECTION_IS_MARKER_IMPL (self), FALSE);
#line 102 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_val_if_fail (IS_DATA_COLLECTION (collection), FALSE);
#line 103 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp1_ = self->owner;
#line 103 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	if (collection == _tmp1_) {
#line 3564 "DataCollection.c"
		GeeHashSet* _tmp2_;
#line 103 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		_tmp2_ = self->marked;
#line 103 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		_tmp0_ = _tmp2_ != NULL;
#line 3570 "DataCollection.c"
	} else {
#line 103 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		_tmp0_ = FALSE;
#line 3574 "DataCollection.c"
	}
#line 103 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	result = _tmp0_;
#line 103 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	return result;
#line 3580 "DataCollection.c"
}


static void
data_collection_marker_impl_class_init (DataCollectionMarkerImplClass * klass)
{
#line 10 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	data_collection_marker_impl_parent_class = g_type_class_peek_parent (klass);
#line 10 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	G_OBJECT_CLASS (klass)->finalize = data_collection_marker_impl_finalize;
#line 3591 "DataCollection.c"
}


static void
data_collection_marker_impl_marker_interface_init (MarkerIface * iface)
{
#line 10 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	data_collection_marker_impl_marker_parent_iface = g_type_interface_peek_parent (iface);
#line 10 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	iface->mark = (void (*) (Marker *, DataObject*)) data_collection_marker_impl_real_mark;
#line 10 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	iface->unmark = (void (*) (Marker *, DataObject*)) data_collection_marker_impl_real_unmark;
#line 10 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	iface->toggle = (gboolean (*) (Marker *, DataObject*)) data_collection_marker_impl_real_toggle;
#line 10 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	iface->mark_many = (void (*) (Marker *, GeeCollection*)) data_collection_marker_impl_real_mark_many;
#line 10 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	iface->unmark_many = (void (*) (Marker *, GeeCollection*)) data_collection_marker_impl_real_unmark_many;
#line 10 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	iface->mark_all = (void (*) (Marker *)) data_collection_marker_impl_real_mark_all;
#line 10 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	iface->get_count = (gint (*) (Marker *)) data_collection_marker_impl_real_get_count;
#line 10 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	iface->get_all = (GeeCollection* (*) (Marker *)) data_collection_marker_impl_real_get_all;
#line 3616 "DataCollection.c"
}


static void
data_collection_marker_impl_instance_init (DataCollectionMarkerImpl * self)
{
	GeeHashSet* _tmp0_;
#line 12 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp0_ = gee_hash_set_new (TYPE_DATA_OBJECT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
#line 12 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	self->marked = _tmp0_;
#line 13 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	self->freeze_count = 0;
#line 3630 "DataCollection.c"
}


static void
data_collection_marker_impl_finalize (GObject * obj)
{
	DataCollectionMarkerImpl * self;
	DataCollection* _tmp0_;
	guint _tmp1_;
#line 10 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DATA_COLLECTION_TYPE_MARKER_IMPL, DataCollectionMarkerImpl);
#line 24 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp0_ = self->owner;
#line 24 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_signal_parse_name ("items-removed", TYPE_DATA_COLLECTION, &_tmp1_, NULL, FALSE);
#line 24 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _data_collection_marker_impl_on_items_removed_data_collection_items_removed, self);
#line 11 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_data_collection_unref0 (self->owner);
#line 12 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_g_object_unref0 (self->marked);
#line 10 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	G_OBJECT_CLASS (data_collection_marker_impl_parent_class)->finalize (obj);
#line 3654 "DataCollection.c"
}


static GType
data_collection_marker_impl_get_type (void)
{
	static volatile gsize data_collection_marker_impl_type_id__volatile = 0;
	if (g_once_init_enter (&data_collection_marker_impl_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DataCollectionMarkerImplClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) data_collection_marker_impl_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DataCollectionMarkerImpl), 0, (GInstanceInitFunc) data_collection_marker_impl_instance_init, NULL };
		static const GInterfaceInfo marker_info = { (GInterfaceInitFunc) data_collection_marker_impl_marker_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType data_collection_marker_impl_type_id;
		data_collection_marker_impl_type_id = g_type_register_static (G_TYPE_OBJECT, "DataCollectionMarkerImpl", &g_define_type_info, 0);
		g_type_add_interface_static (data_collection_marker_impl_type_id, TYPE_MARKER, &marker_info);
		g_once_init_leave (&data_collection_marker_impl_type_id__volatile, data_collection_marker_impl_type_id);
	}
	return data_collection_marker_impl_type_id__volatile;
}


static void
value_data_collection_init (GValue* value)
{
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	value->data[0].v_pointer = NULL;
#line 3679 "DataCollection.c"
}


static void
value_data_collection_free_value (GValue* value)
{
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	if (value->data[0].v_pointer) {
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		data_collection_unref (value->data[0].v_pointer);
#line 3690 "DataCollection.c"
	}
}


static void
value_data_collection_copy_value (const GValue* src_value,
                                  GValue* dest_value)
{
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	if (src_value->data[0].v_pointer) {
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		dest_value->data[0].v_pointer = data_collection_ref (src_value->data[0].v_pointer);
#line 3703 "DataCollection.c"
	} else {
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		dest_value->data[0].v_pointer = NULL;
#line 3707 "DataCollection.c"
	}
}


static gpointer
value_data_collection_peek_pointer (const GValue* value)
{
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	return value->data[0].v_pointer;
#line 3717 "DataCollection.c"
}


static gchar*
value_data_collection_collect_value (GValue* value,
                                     guint n_collect_values,
                                     GTypeCValue* collect_values,
                                     guint collect_flags)
{
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	if (collect_values[0].v_pointer) {
#line 3729 "DataCollection.c"
		DataCollection * object;
		object = collect_values[0].v_pointer;
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		if (object->parent_instance.g_class == NULL) {
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3736 "DataCollection.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3740 "DataCollection.c"
		}
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		value->data[0].v_pointer = data_collection_ref (object);
#line 3744 "DataCollection.c"
	} else {
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		value->data[0].v_pointer = NULL;
#line 3748 "DataCollection.c"
	}
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	return NULL;
#line 3752 "DataCollection.c"
}


static gchar*
value_data_collection_lcopy_value (const GValue* value,
                                   guint n_collect_values,
                                   GTypeCValue* collect_values,
                                   guint collect_flags)
{
	DataCollection ** object_p;
	object_p = collect_values[0].v_pointer;
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	if (!object_p) {
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 3768 "DataCollection.c"
	}
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	if (!value->data[0].v_pointer) {
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		*object_p = NULL;
#line 3774 "DataCollection.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		*object_p = value->data[0].v_pointer;
#line 3778 "DataCollection.c"
	} else {
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		*object_p = data_collection_ref (value->data[0].v_pointer);
#line 3782 "DataCollection.c"
	}
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	return NULL;
#line 3786 "DataCollection.c"
}


GParamSpec*
param_spec_data_collection (const gchar* name,
                            const gchar* nick,
                            const gchar* blurb,
                            GType object_type,
                            GParamFlags flags)
{
	ParamSpecDataCollection* spec;
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_DATA_COLLECTION), NULL);
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	return G_PARAM_SPEC (spec);
#line 3806 "DataCollection.c"
}


gpointer
value_get_data_collection (const GValue* value)
{
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_DATA_COLLECTION), NULL);
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	return value->data[0].v_pointer;
#line 3817 "DataCollection.c"
}


void
value_set_data_collection (GValue* value,
                           gpointer v_object)
{
	DataCollection * old;
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_DATA_COLLECTION));
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	old = value->data[0].v_pointer;
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	if (v_object) {
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_DATA_COLLECTION));
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		value->data[0].v_pointer = v_object;
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		data_collection_ref (value->data[0].v_pointer);
#line 3840 "DataCollection.c"
	} else {
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		value->data[0].v_pointer = NULL;
#line 3844 "DataCollection.c"
	}
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	if (old) {
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		data_collection_unref (old);
#line 3850 "DataCollection.c"
	}
}


void
value_take_data_collection (GValue* value,
                            gpointer v_object)
{
	DataCollection * old;
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_DATA_COLLECTION));
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	old = value->data[0].v_pointer;
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	if (v_object) {
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_DATA_COLLECTION));
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		value->data[0].v_pointer = v_object;
#line 3872 "DataCollection.c"
	} else {
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		value->data[0].v_pointer = NULL;
#line 3876 "DataCollection.c"
	}
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	if (old) {
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		data_collection_unref (old);
#line 3882 "DataCollection.c"
	}
}


static void
data_collection_class_init (DataCollectionClass * klass)
{
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	data_collection_parent_class = g_type_class_peek_parent (klass);
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	((DataCollectionClass *) klass)->finalize = data_collection_finalize;
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_type_class_add_private (klass, sizeof (DataCollectionPrivate));
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	((DataCollectionClass *) klass)->to_string = (gchar* (*) (DataCollection *)) data_collection_real_to_string;
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	((DataCollectionClass *) klass)->notify_items_added = (void (*) (DataCollection *, GeeIterable*)) data_collection_real_notify_items_added;
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	((DataCollectionClass *) klass)->notify_items_removed = (void (*) (DataCollection *, GeeIterable*)) data_collection_real_notify_items_removed;
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	((DataCollectionClass *) klass)->notify_contents_altered = (void (*) (DataCollection *, GeeIterable*, GeeIterable*)) data_collection_real_notify_contents_altered;
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	((DataCollectionClass *) klass)->notify_items_altered = (void (*) (DataCollection *, GeeMap*)) data_collection_real_notify_items_altered;
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	((DataCollectionClass *) klass)->notify_ordering_changed = (void (*) (DataCollection *)) data_collection_real_notify_ordering_changed;
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	((DataCollectionClass *) klass)->notify_property_set = (void (*) (DataCollection *, const gchar*, GValue*, GValue*)) data_collection_real_notify_property_set;
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	((DataCollectionClass *) klass)->notify_property_cleared = (void (*) (DataCollection *, const gchar*)) data_collection_real_notify_property_cleared;
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	((DataCollectionClass *) klass)->valid_type = (gboolean (*) (DataCollection *, DataObject*)) data_collection_real_valid_type;
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	((DataCollectionClass *) klass)->set_comparator = (void (*) (DataCollection *, Comparator, void*, ComparatorPredicate, void*)) data_collection_real_set_comparator;
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	((DataCollectionClass *) klass)->reset_comparator = (void (*) (DataCollection *)) data_collection_real_reset_comparator;
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	((DataCollectionClass *) klass)->get_all = (GeeCollection* (*) (DataCollection *)) data_collection_real_get_all;
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	((DataCollectionClass *) klass)->get_count = (gint (*) (DataCollection *)) data_collection_real_get_count;
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	((DataCollectionClass *) klass)->get_at = (DataObject* (*) (DataCollection *, gint)) data_collection_real_get_at;
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	((DataCollectionClass *) klass)->index_of = (gint (*) (DataCollection *, DataObject*)) data_collection_real_index_of;
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	((DataCollectionClass *) klass)->contains = (gboolean (*) (DataCollection *, DataObject*)) data_collection_real_contains;
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	((DataCollectionClass *) klass)->add = (gboolean (*) (DataCollection *, DataObject*)) data_collection_real_add;
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	((DataCollectionClass *) klass)->add_many = (GeeCollection* (*) (DataCollection *, GeeCollection*, ProgressMonitor, void*)) data_collection_real_add_many;
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	((DataCollectionClass *) klass)->remove_marked = (void (*) (DataCollection *, Marker*)) data_collection_real_remove_marked;
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	((DataCollectionClass *) klass)->clear = (void (*) (DataCollection *)) data_collection_real_clear;
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	((DataCollectionClass *) klass)->close = (void (*) (DataCollection *)) data_collection_real_close;
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	((DataCollectionClass *) klass)->notify_frozen = (void (*) (DataCollection *)) data_collection_real_notify_frozen;
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	((DataCollectionClass *) klass)->notify_thawed = (void (*) (DataCollection *)) data_collection_real_notify_thawed;
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	((DataCollectionClass *) klass)->items_added = data_collection_real_items_added;
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	((DataCollectionClass *) klass)->items_removed = data_collection_real_items_removed;
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	((DataCollectionClass *) klass)->contents_altered = data_collection_real_contents_altered;
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	((DataCollectionClass *) klass)->items_altered = data_collection_real_items_altered;
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	((DataCollectionClass *) klass)->ordering_changed = data_collection_real_ordering_changed;
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	((DataCollectionClass *) klass)->property_set = data_collection_real_property_set;
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	((DataCollectionClass *) klass)->property_cleared = data_collection_real_property_cleared;
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	((DataCollectionClass *) klass)->frozen = data_collection_real_frozen;
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	((DataCollectionClass *) klass)->thawed = data_collection_real_thawed;
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	data_collection_signals[DATA_COLLECTION_ITEMS_ADDED_SIGNAL] = g_signal_new ("items-added", TYPE_DATA_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DataCollectionClass, items_added), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEE_TYPE_ITERABLE);
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	data_collection_signals[DATA_COLLECTION_ITEMS_REMOVED_SIGNAL] = g_signal_new ("items-removed", TYPE_DATA_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DataCollectionClass, items_removed), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEE_TYPE_ITERABLE);
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	data_collection_signals[DATA_COLLECTION_CONTENTS_ALTERED_SIGNAL] = g_signal_new ("contents-altered", TYPE_DATA_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DataCollectionClass, contents_altered), NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, GEE_TYPE_ITERABLE, GEE_TYPE_ITERABLE);
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	data_collection_signals[DATA_COLLECTION_ITEMS_ALTERED_SIGNAL] = g_signal_new ("items-altered", TYPE_DATA_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DataCollectionClass, items_altered), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEE_TYPE_MAP);
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	data_collection_signals[DATA_COLLECTION_ORDERING_CHANGED_SIGNAL] = g_signal_new ("ordering-changed", TYPE_DATA_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DataCollectionClass, ordering_changed), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	data_collection_signals[DATA_COLLECTION_PROPERTY_SET_SIGNAL] = g_signal_new ("property-set", TYPE_DATA_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DataCollectionClass, property_set), NULL, NULL, g_cclosure_user_marshal_VOID__STRING_POINTER_BOXED, G_TYPE_NONE, 3, G_TYPE_STRING, G_TYPE_POINTER, G_TYPE_VALUE);
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	data_collection_signals[DATA_COLLECTION_PROPERTY_CLEARED_SIGNAL] = g_signal_new ("property-cleared", TYPE_DATA_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DataCollectionClass, property_cleared), NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	data_collection_signals[DATA_COLLECTION_FROZEN_SIGNAL] = g_signal_new ("frozen", TYPE_DATA_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DataCollectionClass, frozen), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	data_collection_signals[DATA_COLLECTION_THAWED_SIGNAL] = g_signal_new ("thawed", TYPE_DATA_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DataCollectionClass, thawed), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 3978 "DataCollection.c"
}


static void
data_collection_instance_init (DataCollection * self)
{
	DataSet* _tmp0_;
	GeeHashMap* _tmp1_;
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	self->priv = DATA_COLLECTION_GET_PRIVATE (self);
#line 108 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp0_ = data_set_new ();
#line 108 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	self->priv->dataset = _tmp0_;
#line 109 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_VALUE, (GBoxedCopyFunc) _g_value_dup, (GDestroyNotify) _vala_GValue_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 109 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	self->priv->properties = _tmp1_;
#line 110 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	self->priv->object_ordinal_generator = (gint64) 0;
#line 111 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	self->priv->notifies_frozen = 0;
#line 112 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	self->priv->frozen_items_altered = NULL;
#line 113 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	self->priv->fire_ordering_changed = FALSE;
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	self->ref_count = 1;
#line 4007 "DataCollection.c"
}


static void
data_collection_finalize (DataCollection * obj)
{
	DataCollection * self;
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DATA_COLLECTION, DataCollection);
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_signal_handlers_destroy (self);
#line 107 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_g_free0 (self->priv->name);
#line 108 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_data_set_unref0 (self->priv->dataset);
#line 109 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_g_object_unref0 (self->priv->properties);
#line 112 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	_g_object_unref0 (self->priv->frozen_items_altered);
#line 4027 "DataCollection.c"
}


GType
data_collection_get_type (void)
{
	static volatile gsize data_collection_type_id__volatile = 0;
	if (g_once_init_enter (&data_collection_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_data_collection_init, value_data_collection_free_value, value_data_collection_copy_value, value_data_collection_peek_pointer, "p", value_data_collection_collect_value, "p", value_data_collection_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (DataCollectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) data_collection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DataCollection), 0, (GInstanceInitFunc) data_collection_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType data_collection_type_id;
		data_collection_type_id = g_type_register_fundamental (g_type_fundamental_next (), "DataCollection", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&data_collection_type_id__volatile, data_collection_type_id);
	}
	return data_collection_type_id__volatile;
}


gpointer
data_collection_ref (gpointer instance)
{
	DataCollection * self;
	self = instance;
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	g_atomic_int_inc (&self->ref_count);
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	return instance;
#line 4056 "DataCollection.c"
}


void
data_collection_unref (gpointer instance)
{
	DataCollection * self;
	self = instance;
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		DATA_COLLECTION_GET_CLASS (self)->finalize (self);
#line 7 "/home/jens/Source/shotwell/src/core/DataCollection.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 4071 "DataCollection.c"
	}
}



