/* DesktopIntegration.c generated by valac 0.40.4, the Vala compiler
 * generated from DesktopIntegration.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gee.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <glib/gstdio.h>
#include <gobject/gvaluecollector.h>


#define TYPE_EXPORTER_UI (exporter_ui_get_type ())
#define EXPORTER_UI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXPORTER_UI, ExporterUI))
#define EXPORTER_UI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXPORTER_UI, ExporterUIClass))
#define IS_EXPORTER_UI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXPORTER_UI))
#define IS_EXPORTER_UI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXPORTER_UI))
#define EXPORTER_UI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXPORTER_UI, ExporterUIClass))

typedef struct _ExporterUI ExporterUI;
typedef struct _ExporterUIClass ExporterUIClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_SORTED_LIST (sorted_list_get_type ())
#define SORTED_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SORTED_LIST, SortedList))
#define SORTED_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SORTED_LIST, SortedListClass))
#define IS_SORTED_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SORTED_LIST))
#define IS_SORTED_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SORTED_LIST))
#define SORTED_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SORTED_LIST, SortedListClass))

typedef struct _SortedList SortedList;
typedef struct _SortedListClass SortedListClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))

#define TYPE_PAGE_WINDOW (page_window_get_type ())
#define PAGE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE_WINDOW, PageWindow))
#define PAGE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE_WINDOW, PageWindowClass))
#define IS_PAGE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE_WINDOW))
#define IS_PAGE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE_WINDOW))
#define PAGE_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE_WINDOW, PageWindowClass))

typedef struct _PageWindow PageWindow;
typedef struct _PageWindowClass PageWindowClass;

#define TYPE_APP_WINDOW (app_window_get_type ())
#define APP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_WINDOW, AppWindow))
#define APP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_WINDOW, AppWindowClass))
#define IS_APP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_WINDOW))
#define IS_APP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_WINDOW))
#define APP_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_WINDOW, AppWindowClass))

typedef struct _AppWindow AppWindow;
typedef struct _AppWindowClass AppWindowClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;

#define TYPE_THUMBNAIL_SOURCE (thumbnail_source_get_type ())
#define THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSource))
#define THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))
#define IS_THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_SOURCE))
#define IS_THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_SOURCE))
#define THUMBNAIL_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))

typedef struct _ThumbnailSource ThumbnailSource;
typedef struct _ThumbnailSourceClass ThumbnailSourceClass;

#define TYPE_MEDIA_SOURCE (media_source_get_type ())
#define MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE, MediaSource))
#define MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE, MediaSourceClass))
#define IS_MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE))
#define IS_MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE))
#define MEDIA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE, MediaSourceClass))

typedef struct _MediaSource MediaSource;
typedef struct _MediaSourceClass MediaSourceClass;

#define TYPE_EXPORT_DIALOG (export_dialog_get_type ())
#define EXPORT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXPORT_DIALOG, ExportDialog))
#define EXPORT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXPORT_DIALOG, ExportDialogClass))
#define IS_EXPORT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXPORT_DIALOG))
#define IS_EXPORT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXPORT_DIALOG))
#define EXPORT_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXPORT_DIALOG, ExportDialogClass))

typedef struct _ExportDialog ExportDialog;
typedef struct _ExportDialogClass ExportDialogClass;

#define TYPE_VIDEO_SOURCE (video_source_get_type ())
#define VIDEO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_SOURCE, VideoSource))
#define VIDEO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_SOURCE, VideoSourceClass))
#define IS_VIDEO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_SOURCE))
#define IS_VIDEO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_SOURCE))
#define VIDEO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_SOURCE, VideoSourceClass))

typedef struct _VideoSource VideoSource;
typedef struct _VideoSourceClass VideoSourceClass;

#define TYPE_VIDEO (video_get_type ())
#define VIDEO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO, Video))
#define VIDEO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO, VideoClass))
#define IS_VIDEO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO))
#define IS_VIDEO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO))
#define VIDEO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO, VideoClass))

typedef struct _Video Video;
typedef struct _VideoClass VideoClass;

#define TYPE_EXPORTER (exporter_get_type ())
#define EXPORTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXPORTER, Exporter))
#define EXPORTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXPORTER, ExporterClass))
#define IS_EXPORTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXPORTER))
#define IS_EXPORTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXPORTER))
#define EXPORTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXPORTER, ExporterClass))

typedef struct _Exporter Exporter;
typedef struct _ExporterClass ExporterClass;
#define _exporter_ui_unref0(var) ((var == NULL) ? NULL : (var = (exporter_ui_unref (var), NULL)))

#define TYPE_SCALE_CONSTRAINT (scale_constraint_get_type ())

#define TYPE_EXPORT_FORMAT_PARAMETERS (export_format_parameters_get_type ())

#define TYPE_EXPORT_FORMAT_MODE (export_format_mode_get_type ())

#define TYPE_PHOTO_FILE_FORMAT (photo_file_format_get_type ())

#define JPEG_TYPE_QUALITY (jpeg_quality_get_type ())
typedef struct _ExportFormatParameters ExportFormatParameters;

#define TYPE_SCALING (scaling_get_type ())

#define TYPE_DIMENSIONS (dimensions_get_type ())
typedef struct _Dimensions Dimensions;
typedef struct _Scaling Scaling;

#define TYPE_PHOTO_SOURCE (photo_source_get_type ())
#define PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_SOURCE, PhotoSource))
#define PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_SOURCE, PhotoSourceClass))
#define IS_PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_SOURCE))
#define IS_PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_SOURCE))
#define PHOTO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_SOURCE, PhotoSourceClass))

typedef struct _PhotoSource PhotoSource;
typedef struct _PhotoSourceClass PhotoSourceClass;

#define TYPE_PHOTO (photo_get_type ())
#define PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO, Photo))
#define PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO, PhotoClass))
#define IS_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO))
#define IS_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO))
#define PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO, PhotoClass))

typedef struct _Photo Photo;
typedef struct _PhotoClass PhotoClass;

#define TYPE_CONFIGURATION_FACADE (configuration_facade_get_type ())
#define CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacade))
#define CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))
#define IS_CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONFIGURATION_FACADE))
#define IS_CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONFIGURATION_FACADE))
#define CONFIGURATION_FACADE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))

typedef struct _ConfigurationFacade ConfigurationFacade;
typedef struct _ConfigurationFacadeClass ConfigurationFacadeClass;

#define CONFIG_TYPE_FACADE (config_facade_get_type ())
#define CONFIG_FACADE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONFIG_TYPE_FACADE, ConfigFacade))
#define CONFIG_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONFIG_TYPE_FACADE, ConfigFacadeClass))
#define CONFIG_IS_FACADE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONFIG_TYPE_FACADE))
#define CONFIG_IS_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONFIG_TYPE_FACADE))
#define CONFIG_FACADE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONFIG_TYPE_FACADE, ConfigFacadeClass))

typedef struct _ConfigFacade ConfigFacade;
typedef struct _ConfigFacadeClass ConfigFacadeClass;

#define DESKTOP_INTEGRATION_TYPE_BACKGROUND_SLIDESHOW_XML_BUILDER (desktop_integration_background_slideshow_xml_builder_get_type ())
#define DESKTOP_INTEGRATION_BACKGROUND_SLIDESHOW_XML_BUILDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_INTEGRATION_TYPE_BACKGROUND_SLIDESHOW_XML_BUILDER, DesktopIntegrationBackgroundSlideshowXMLBuilder))
#define DESKTOP_INTEGRATION_BACKGROUND_SLIDESHOW_XML_BUILDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DESKTOP_INTEGRATION_TYPE_BACKGROUND_SLIDESHOW_XML_BUILDER, DesktopIntegrationBackgroundSlideshowXMLBuilderClass))
#define DESKTOP_INTEGRATION_IS_BACKGROUND_SLIDESHOW_XML_BUILDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_INTEGRATION_TYPE_BACKGROUND_SLIDESHOW_XML_BUILDER))
#define DESKTOP_INTEGRATION_IS_BACKGROUND_SLIDESHOW_XML_BUILDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DESKTOP_INTEGRATION_TYPE_BACKGROUND_SLIDESHOW_XML_BUILDER))
#define DESKTOP_INTEGRATION_BACKGROUND_SLIDESHOW_XML_BUILDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DESKTOP_INTEGRATION_TYPE_BACKGROUND_SLIDESHOW_XML_BUILDER, DesktopIntegrationBackgroundSlideshowXMLBuilderClass))

typedef struct _DesktopIntegrationBackgroundSlideshowXMLBuilder DesktopIntegrationBackgroundSlideshowXMLBuilder;
typedef struct _DesktopIntegrationBackgroundSlideshowXMLBuilderClass DesktopIntegrationBackgroundSlideshowXMLBuilderClass;
typedef struct _DesktopIntegrationBackgroundSlideshowXMLBuilderPrivate DesktopIntegrationBackgroundSlideshowXMLBuilderPrivate;
typedef struct _DesktopIntegrationParamSpecBackgroundSlideshowXMLBuilder DesktopIntegrationParamSpecBackgroundSlideshowXMLBuilder;
#define _desktop_integration_background_slideshow_xml_builder_unref0(var) ((var == NULL) ? NULL : (var = (desktop_integration_background_slideshow_xml_builder_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef gint64 (*Comparator) (void* a, void* b, void* user_data);
typedef void (*ExporterCompletionCallback) (Exporter* exporter, gboolean is_cancelled, void* user_data);
typedef enum  {
	SCALE_CONSTRAINT_ORIGINAL,
	SCALE_CONSTRAINT_DIMENSIONS,
	SCALE_CONSTRAINT_WIDTH,
	SCALE_CONSTRAINT_HEIGHT,
	SCALE_CONSTRAINT_FILL_VIEWPORT
} ScaleConstraint;

typedef enum  {
	EXPORT_FORMAT_MODE_UNMODIFIED,
	EXPORT_FORMAT_MODE_CURRENT,
	EXPORT_FORMAT_MODE_SPECIFIED,
	EXPORT_FORMAT_MODE_LAST
} ExportFormatMode;

typedef enum  {
	PHOTO_FILE_FORMAT_JFIF,
	PHOTO_FILE_FORMAT_RAW,
	PHOTO_FILE_FORMAT_PNG,
	PHOTO_FILE_FORMAT_TIFF,
	PHOTO_FILE_FORMAT_BMP,
	PHOTO_FILE_FORMAT_UNKNOWN
} PhotoFileFormat;

typedef enum  {
	JPEG_QUALITY_LOW = 50,
	JPEG_QUALITY_MEDIUM = 75,
	JPEG_QUALITY_HIGH = 90,
	JPEG_QUALITY_MAXIMUM = 100
} JpegQuality;

struct _ExportFormatParameters {
	ExportFormatMode mode;
	PhotoFileFormat specified_format;
	JpegQuality quality;
	gboolean export_metadata;
};

struct _Dimensions {
	gint width;
	gint height;
};

struct _Scaling {
	ScaleConstraint constraint;
	gint scale;
	Dimensions viewport;
	gboolean scale_up;
};

struct _DesktopIntegrationBackgroundSlideshowXMLBuilder {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DesktopIntegrationBackgroundSlideshowXMLBuilderPrivate * priv;
};

struct _DesktopIntegrationBackgroundSlideshowXMLBuilderClass {
	GTypeClass parent_class;
	void (*finalize) (DesktopIntegrationBackgroundSlideshowXMLBuilder *self);
};

struct _DesktopIntegrationBackgroundSlideshowXMLBuilderPrivate {
	GFile* destination;
	gdouble duration;
	gdouble transition;
	GFile* tmp_file;
	GDataOutputStream* outs;
	GFile* first_file;
	GFile* last_file;
};

struct _DesktopIntegrationParamSpecBackgroundSlideshowXMLBuilder {
	GParamSpec parent_instance;
};

typedef gboolean (*ProgressMonitor) (guint64 current, guint64 total, gboolean do_event_loop, void* user_data);

extern gint desktop_integration_init_count;
gint desktop_integration_init_count = 0;
extern gboolean desktop_integration_send_to_installed;
gboolean desktop_integration_send_to_installed = FALSE;
extern ExporterUI* desktop_integration_send_to_exporter;
ExporterUI* desktop_integration_send_to_exporter = NULL;
extern ExporterUI* desktop_integration_desktop_slideshow_exporter;
ExporterUI* desktop_integration_desktop_slideshow_exporter = NULL;
extern gdouble desktop_integration_desktop_slideshow_transition;
gdouble desktop_integration_desktop_slideshow_transition = 0.0;
extern gdouble desktop_integration_desktop_slideshow_duration;
gdouble desktop_integration_desktop_slideshow_duration = 0.0;
extern gboolean desktop_integration_set_desktop_background;
gboolean desktop_integration_set_desktop_background = FALSE;
extern gboolean desktop_integration_set_screensaver;
gboolean desktop_integration_set_screensaver = FALSE;
static gpointer desktop_integration_background_slideshow_xml_builder_parent_class = NULL;

#define DESKTOP_INTEGRATION_SENDTO_EXEC "nautilus-sendto"
#define DESKTOP_INTEGRATION_DESKTOP_SLIDESHOW_XML_FILENAME "wallpaper.xml"
gpointer exporter_ui_ref (gpointer instance);
void exporter_ui_unref (gpointer instance);
GParamSpec* param_spec_exporter_ui (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags);
void value_set_exporter_ui (GValue* value,
                            gpointer v_object);
void value_take_exporter_ui (GValue* value,
                             gpointer v_object);
gpointer value_get_exporter_ui (const GValue* value);
GType exporter_ui_get_type (void) G_GNUC_CONST;
void desktop_integration_init (void);
void desktop_integration_terminate (void);
GAppInfo* desktop_integration_get_default_app_for_mime_types (gchar** mime_types,
                                                              int mime_types_length1,
                                                              GeeArrayList* preferred_apps);
GType sorted_list_get_type (void) G_GNUC_CONST;
SortedList* desktop_integration_get_apps_for_mime_types (gchar** mime_types,
                                                         int mime_types_length1);
gint64 desktop_integration_app_info_comparator (void* a,
                                                void* b);
static gint64 _desktop_integration_app_info_comparator_comparator (void* a,
                                                            void* b,
                                                            gpointer self);
SortedList* sorted_list_new (GType g_type,
                             GBoxedCopyFunc g_dup_func,
                             GDestroyNotify g_destroy_func,
                             Comparator cmp,
                             void* cmp_target);
SortedList* sorted_list_construct (GType object_type,
                                   GType g_type,
                                   GBoxedCopyFunc g_dup_func,
                                   GDestroyNotify g_destroy_func,
                                   Comparator cmp,
                                   void* cmp_target);
#define RESOURCES_APP_TITLE "Shotwell"
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
gchar* desktop_integration_get_app_open_command (GAppInfo* app_info);
gboolean desktop_integration_is_send_to_installed (void);
void desktop_integration_files_send_to (GFile** files,
                                        int files_length1);
GType page_window_get_type (void) G_GNUC_CONST;
GType app_window_get_type (void) G_GNUC_CONST;
AppWindow* app_window_get_instance (void);
void page_window_set_busy_cursor (PageWindow* self);
void page_window_set_normal_cursor (PageWindow* self);
void app_window_error_message (const gchar* message,
                               GtkWindow* parent);
GType data_object_get_type (void) G_GNUC_CONST;
GType data_source_get_type (void) G_GNUC_CONST;
GType thumbnail_source_get_type (void) G_GNUC_CONST;
GType media_source_get_type (void) G_GNUC_CONST;
void desktop_integration_send_to (GeeCollection* media);
GType export_dialog_get_type (void) G_GNUC_CONST;
ExportDialog* export_dialog_new (const gchar* title);
ExportDialog* export_dialog_construct (GType object_type,
                                       const gchar* title);
gboolean media_source_collection_has_video (GeeCollection* media);
gboolean media_source_collection_has_photo (GeeCollection* media);
GType video_source_get_type (void) G_GNUC_CONST;
GType video_get_type (void) G_GNUC_CONST;
GType exporter_get_type (void) G_GNUC_CONST;
ExporterUI* video_export_many (GeeCollection* videos,
                               ExporterCompletionCallback done,
                               void* done_target,
                               gboolean export_in_place);
void desktop_integration_on_send_to_export_completed (Exporter* exporter,
                                                      gboolean is_cancelled);
static void _desktop_integration_on_send_to_export_completed_exporter_completion_callback (Exporter* exporter,
                                                                                    gboolean is_cancelled,
                                                                                    gpointer self);
GType scale_constraint_get_type (void) G_GNUC_CONST;
GType export_format_parameters_get_type (void) G_GNUC_CONST;
GType export_format_mode_get_type (void) G_GNUC_CONST;
GType photo_file_format_get_type (void) G_GNUC_CONST;
GType jpeg_quality_get_type (void) G_GNUC_CONST;
ExportFormatParameters* export_format_parameters_dup (const ExportFormatParameters* self);
void export_format_parameters_free (ExportFormatParameters* self);
void export_format_parameters_current (ExportFormatParameters* result);
gboolean export_dialog_execute (ExportDialog* self,
                                gint* scale,
                                ScaleConstraint* constraint,
                                ExportFormatParameters* parameters);
GType scaling_get_type (void) G_GNUC_CONST;
GType dimensions_get_type (void) G_GNUC_CONST;
Dimensions* dimensions_dup (const Dimensions* self);
void dimensions_free (Dimensions* self);
Scaling* scaling_dup (const Scaling* self);
void scaling_free (Scaling* self);
void scaling_for_constraint (ScaleConstraint constraint,
                             gint scale,
                             gboolean scale_up,
                             Scaling* result);
Exporter* exporter_new_for_temp_file (GeeCollection* to_export,
                                      Scaling* scaling,
                                      ExportFormatParameters* export_params);
Exporter* exporter_construct_for_temp_file (GType object_type,
                                            GeeCollection* to_export,
                                            Scaling* scaling,
                                            ExportFormatParameters* export_params);
ExporterUI* exporter_ui_new (Exporter* exporter);
ExporterUI* exporter_ui_construct (GType object_type,
                                   Exporter* exporter);
void exporter_ui_export (ExporterUI* self,
                         ExporterCompletionCallback completion_callback,
                         void* completion_callback_target);
GFile** exporter_get_exported_files (Exporter* self,
                                     int* result_length1);
GType photo_source_get_type (void) G_GNUC_CONST;
GType photo_get_type (void) G_GNUC_CONST;
void desktop_integration_set_background (Photo* photo,
                                         gboolean desktop,
                                         gboolean screensaver);
PhotoFileFormat photo_get_best_export_file_format (Photo* self);
GFile* app_dirs_get_data_subdir (const gchar* name,
                                 const gchar* subname);
gchar* photo_file_format_get_default_basename (PhotoFileFormat self,
                                               const gchar* name);
GType configuration_facade_get_type (void) G_GNUC_CONST;
GType config_facade_get_type (void) G_GNUC_CONST;
ConfigFacade* config_facade_get_instance (void);
gchar* configuration_facade_get_desktop_background (ConfigurationFacade* self);
void photo_export (Photo* self,
                   GFile* dest_file,
                   Scaling* scaling,
                   JpegQuality quality,
                   PhotoFileFormat export_format,
                   gboolean direct_copy_unmodified,
                   gboolean export_metadata,
                   GError** error);
void scaling_for_original (Scaling* result);
void configuration_facade_set_desktop_background (ConfigurationFacade* self,
                                                  const gchar* filename);
void configuration_facade_set_screensaver (ConfigurationFacade* self,
                                           const gchar* filename);
gpointer desktop_integration_background_slideshow_xml_builder_ref (gpointer instance);
void desktop_integration_background_slideshow_xml_builder_unref (gpointer instance);
GParamSpec* desktop_integration_param_spec_background_slideshow_xml_builder (const gchar* name,
                                                                             const gchar* nick,
                                                                             const gchar* blurb,
                                                                             GType object_type,
                                                                             GParamFlags flags);
void desktop_integration_value_set_background_slideshow_xml_builder (GValue* value,
                                                                     gpointer v_object);
void desktop_integration_value_take_background_slideshow_xml_builder (GValue* value,
                                                                      gpointer v_object);
gpointer desktop_integration_value_get_background_slideshow_xml_builder (const GValue* value);
GType desktop_integration_background_slideshow_xml_builder_get_type (void) G_GNUC_CONST;
#define DESKTOP_INTEGRATION_BACKGROUND_SLIDESHOW_XML_BUILDER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DESKTOP_INTEGRATION_TYPE_BACKGROUND_SLIDESHOW_XML_BUILDER, DesktopIntegrationBackgroundSlideshowXMLBuilderPrivate))
DesktopIntegrationBackgroundSlideshowXMLBuilder* desktop_integration_background_slideshow_xml_builder_new (GFile* destination,
                                                                                                           gdouble duration,
                                                                                                           gdouble transition);
DesktopIntegrationBackgroundSlideshowXMLBuilder* desktop_integration_background_slideshow_xml_builder_construct (GType object_type,
                                                                                                                 GFile* destination,
                                                                                                                 gdouble duration,
                                                                                                                 gdouble transition);
void desktop_integration_background_slideshow_xml_builder_open (DesktopIntegrationBackgroundSlideshowXMLBuilder* self,
                                                                GError** error);
static void desktop_integration_background_slideshow_xml_builder_write_transition (DesktopIntegrationBackgroundSlideshowXMLBuilder* self,
                                                                            GFile* from,
                                                                            GFile* to,
                                                                            GError** error);
static void desktop_integration_background_slideshow_xml_builder_write_static (DesktopIntegrationBackgroundSlideshowXMLBuilder* self,
                                                                        GFile* file,
                                                                        GError** error);
void desktop_integration_background_slideshow_xml_builder_add_photo (DesktopIntegrationBackgroundSlideshowXMLBuilder* self,
                                                                     GFile* file,
                                                                     GError** error);
GFile* desktop_integration_background_slideshow_xml_builder_close (DesktopIntegrationBackgroundSlideshowXMLBuilder* self,
                                                                   GError** error);
static void desktop_integration_background_slideshow_xml_builder_finalize (DesktopIntegrationBackgroundSlideshowXMLBuilder * obj);
void desktop_integration_set_background_slideshow (GeeCollection* photos,
                                                   gdouble duration,
                                                   gdouble transition,
                                                   gboolean desktop_background,
                                                   gboolean screensaver);
void delete_all_files (GFile* dir,
                       GeeSet* exceptions,
                       ProgressMonitor monitor,
                       void* monitor_target,
                       guint64 file_count,
                       GCancellable* cancellable,
                       GError** error);
void scaling_to_fill_screen (GtkWindow* window,
                             Scaling* result);
Exporter* exporter_new (GeeCollection* to_export,
                        GFile* dir,
                        Scaling* scaling,
                        ExportFormatParameters* export_params,
                        gboolean auto_replace_all);
Exporter* exporter_construct (GType object_type,
                              GeeCollection* to_export,
                              GFile* dir,
                              Scaling* scaling,
                              ExportFormatParameters* export_params,
                              gboolean auto_replace_all);
void desktop_integration_on_desktop_slideshow_exported (Exporter* exporter,
                                                        gboolean is_cancelled);
static void _desktop_integration_on_desktop_slideshow_exported_exporter_completion_callback (Exporter* exporter,
                                                                                      gboolean is_cancelled,
                                                                                      gpointer self);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);


void
desktop_integration_init (void)
{
	gint _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
#line 23 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp0_ = desktop_integration_init_count;
#line 23 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	desktop_integration_init_count = _tmp0_ + 1;
#line 23 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (_tmp0_ != 0) {
#line 24 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		return;
#line 550 "DesktopIntegration.c"
	}
#line 26 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp1_ = g_find_program_in_path (DESKTOP_INTEGRATION_SENDTO_EXEC);
#line 26 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp2_ = _tmp1_;
#line 26 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	desktop_integration_send_to_installed = _tmp2_ != NULL;
#line 26 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_free0 (_tmp2_);
#line 560 "DesktopIntegration.c"
}


void
desktop_integration_terminate (void)
{
	gint _tmp0_;
	gint _tmp1_;
#line 30 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp0_ = desktop_integration_init_count;
#line 30 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	desktop_integration_init_count = _tmp0_ - 1;
#line 30 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp1_ = desktop_integration_init_count;
#line 30 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (_tmp1_ == 0) {
#line 31 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		return;
#line 579 "DesktopIntegration.c"
	}
}


static gpointer
_g_object_ref0 (gpointer self)
{
#line 38 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	return self ? g_object_ref (self) : NULL;
#line 589 "DesktopIntegration.c"
}


static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gboolean result = FALSE;
	gchar* _tmp0_;
#line 1417 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1417 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 1418 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
#line 1418 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	result = _tmp0_ != NULL;
#line 1418 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	return result;
#line 609 "DesktopIntegration.c"
}


GAppInfo*
desktop_integration_get_default_app_for_mime_types (gchar** mime_types,
                                                    int mime_types_length1,
                                                    GeeArrayList* preferred_apps)
{
	GAppInfo* result = NULL;
	SortedList* external_apps = NULL;
	SortedList* _tmp0_;
#line 34 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	g_return_val_if_fail (GEE_IS_ARRAY_LIST (preferred_apps), NULL);
#line 36 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp0_ = desktop_integration_get_apps_for_mime_types (mime_types, mime_types_length1);
#line 36 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	external_apps = _tmp0_;
#line 627 "DesktopIntegration.c"
	{
		GeeArrayList* _preferred_app_list = NULL;
		GeeArrayList* _tmp1_;
		gint _preferred_app_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _preferred_app_index = 0;
#line 38 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp1_ = _g_object_ref0 (preferred_apps);
#line 38 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_preferred_app_list = _tmp1_;
#line 38 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp2_ = _preferred_app_list;
#line 38 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp3_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 38 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp4_ = _tmp3_;
#line 38 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_preferred_app_size = _tmp4_;
#line 38 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_preferred_app_index = -1;
#line 38 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		while (TRUE) {
#line 652 "DesktopIntegration.c"
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			gchar* preferred_app = NULL;
			GeeArrayList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
#line 38 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
			_tmp5_ = _preferred_app_index;
#line 38 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
			_preferred_app_index = _tmp5_ + 1;
#line 38 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
			_tmp6_ = _preferred_app_index;
#line 38 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
			_tmp7_ = _preferred_app_size;
#line 38 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
			if (!(_tmp6_ < _tmp7_)) {
#line 38 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
				break;
#line 672 "DesktopIntegration.c"
			}
#line 38 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
			_tmp8_ = _preferred_app_list;
#line 38 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
			_tmp9_ = _preferred_app_index;
#line 38 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
			_tmp10_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp9_);
#line 38 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
			preferred_app = (gchar*) _tmp10_;
#line 682 "DesktopIntegration.c"
			{
				GeeIterator* _external_app_it = NULL;
				SortedList* _tmp11_;
				GeeIterator* _tmp12_;
#line 39 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
				_tmp11_ = external_apps;
#line 39 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
				_tmp12_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GEE_TYPE_ITERABLE, GeeIterable));
#line 39 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
				_external_app_it = _tmp12_;
#line 39 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
				while (TRUE) {
#line 695 "DesktopIntegration.c"
					GeeIterator* _tmp13_;
					GAppInfo* external_app = NULL;
					GeeIterator* _tmp14_;
					gpointer _tmp15_;
					GAppInfo* _tmp16_;
					const gchar* _tmp17_;
					const gchar* _tmp18_;
#line 39 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
					_tmp13_ = _external_app_it;
#line 39 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
					if (!gee_iterator_next (_tmp13_)) {
#line 39 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
						break;
#line 709 "DesktopIntegration.c"
					}
#line 39 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
					_tmp14_ = _external_app_it;
#line 39 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
					_tmp15_ = gee_iterator_get (_tmp14_);
#line 39 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
					external_app = (GAppInfo*) _tmp15_;
#line 40 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
					_tmp16_ = external_app;
#line 40 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
					_tmp17_ = g_app_info_get_name (_tmp16_);
#line 40 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
					_tmp18_ = preferred_app;
#line 40 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
					if (string_contains (_tmp17_, _tmp18_)) {
#line 41 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
						result = external_app;
#line 41 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
						_g_object_unref0 (_external_app_it);
#line 41 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
						_g_free0 (preferred_app);
#line 41 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
						_g_object_unref0 (_preferred_app_list);
#line 41 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
						_g_object_unref0 (external_apps);
#line 41 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
						return result;
#line 737 "DesktopIntegration.c"
					}
#line 39 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
					_g_object_unref0 (external_app);
#line 741 "DesktopIntegration.c"
				}
#line 39 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
				_g_object_unref0 (_external_app_it);
#line 745 "DesktopIntegration.c"
			}
#line 38 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
			_g_free0 (preferred_app);
#line 749 "DesktopIntegration.c"
		}
#line 38 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_g_object_unref0 (_preferred_app_list);
#line 753 "DesktopIntegration.c"
	}
#line 45 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	result = NULL;
#line 45 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_object_unref0 (external_apps);
#line 45 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	return result;
#line 761 "DesktopIntegration.c"
}


gint64
desktop_integration_app_info_comparator (void* a,
                                         void* b)
{
	gint64 result = 0LL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gint64 _tmp6_;
#line 50 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp0_ = g_app_info_get_name (G_TYPE_CHECK_INSTANCE_CAST (a, g_app_info_get_type (), GAppInfo));
#line 50 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp1_ = g_utf8_strdown (_tmp0_, (gssize) -1);
#line 50 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp2_ = _tmp1_;
#line 50 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp3_ = g_app_info_get_name (G_TYPE_CHECK_INSTANCE_CAST (b, g_app_info_get_type (), GAppInfo));
#line 50 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp4_ = g_utf8_strdown (_tmp3_, (gssize) -1);
#line 50 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp5_ = _tmp4_;
#line 50 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp6_ = (gint64) g_utf8_collate (_tmp2_, _tmp5_);
#line 50 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_free0 (_tmp5_);
#line 50 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_free0 (_tmp2_);
#line 50 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	result = _tmp6_;
#line 50 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	return result;
#line 799 "DesktopIntegration.c"
}


static gint64
_desktop_integration_app_info_comparator_comparator (void* a,
                                                     void* b,
                                                     gpointer self)
{
	gint64 result;
	result = desktop_integration_app_info_comparator (a, b);
#line 54 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	return result;
#line 812 "DesktopIntegration.c"
}


static void
_g_object_unref0_ (gpointer var)
{
#line 66 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 821 "DesktopIntegration.c"
}


static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
#line 66 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
#line 830 "DesktopIntegration.c"
}


SortedList*
desktop_integration_get_apps_for_mime_types (gchar** mime_types,
                                             int mime_types_length1)
{
	SortedList* result = NULL;
	SortedList* external_apps = NULL;
	SortedList* _tmp0_;
#line 54 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp0_ = sorted_list_new (g_app_info_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _desktop_integration_app_info_comparator_comparator, NULL);
#line 54 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	external_apps = _tmp0_;
#line 56 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (mime_types_length1 == 0) {
#line 57 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		result = external_apps;
#line 57 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		return result;
#line 851 "DesktopIntegration.c"
	}
	{
		gchar** mime_type_collection = NULL;
		gint mime_type_collection_length1 = 0;
		gint _mime_type_collection_size_ = 0;
		gint mime_type_it = 0;
#line 61 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		mime_type_collection = mime_types;
#line 61 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		mime_type_collection_length1 = mime_types_length1;
#line 61 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		for (mime_type_it = 0; mime_type_it < mime_types_length1; mime_type_it = mime_type_it + 1) {
#line 864 "DesktopIntegration.c"
			gchar* _tmp1_;
			gchar* mime_type = NULL;
#line 61 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
			_tmp1_ = g_strdup (mime_type_collection[mime_type_it]);
#line 61 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
			mime_type = _tmp1_;
#line 871 "DesktopIntegration.c"
			{
				gchar* content_type = NULL;
				const gchar* _tmp2_;
				gchar* _tmp3_;
				const gchar* _tmp4_;
				const gchar* _tmp5_;
				GList* _tmp6_;
#line 62 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
				_tmp2_ = mime_type;
#line 62 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
				_tmp3_ = g_content_type_from_mime_type (_tmp2_);
#line 62 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
				content_type = _tmp3_;
#line 63 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
				_tmp4_ = content_type;
#line 63 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
				if (_tmp4_ == NULL) {
#line 64 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
					_g_free0 (content_type);
#line 64 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
					_g_free0 (mime_type);
#line 64 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
					break;
#line 895 "DesktopIntegration.c"
				}
#line 66 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
				_tmp5_ = content_type;
#line 66 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
				_tmp6_ = g_app_info_get_all_for_type (_tmp5_);
#line 901 "DesktopIntegration.c"
				{
					GList* external_app_collection = NULL;
					GList* external_app_it = NULL;
#line 66 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
					external_app_collection = _tmp6_;
#line 66 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
					for (external_app_it = external_app_collection; external_app_it != NULL; external_app_it = external_app_it->next) {
#line 909 "DesktopIntegration.c"
						GAppInfo* _tmp7_;
						GAppInfo* external_app = NULL;
#line 66 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
						_tmp7_ = _g_object_ref0 ((GAppInfo*) external_app_it->data);
#line 66 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
						external_app = _tmp7_;
#line 916 "DesktopIntegration.c"
						{
							gboolean already_contains = FALSE;
							gboolean _tmp17_ = FALSE;
							gboolean _tmp18_;
#line 68 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
							already_contains = FALSE;
#line 923 "DesktopIntegration.c"
							{
								GeeIterator* _app_it = NULL;
								SortedList* _tmp8_;
								GeeIterator* _tmp9_;
#line 70 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
								_tmp8_ = external_apps;
#line 70 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
								_tmp9_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_ITERABLE, GeeIterable));
#line 70 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
								_app_it = _tmp9_;
#line 70 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
								while (TRUE) {
#line 936 "DesktopIntegration.c"
									GeeIterator* _tmp10_;
									GAppInfo* app = NULL;
									GeeIterator* _tmp11_;
									gpointer _tmp12_;
									GAppInfo* _tmp13_;
									const gchar* _tmp14_;
									GAppInfo* _tmp15_;
									const gchar* _tmp16_;
#line 70 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
									_tmp10_ = _app_it;
#line 70 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
									if (!gee_iterator_next (_tmp10_)) {
#line 70 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
										break;
#line 951 "DesktopIntegration.c"
									}
#line 70 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
									_tmp11_ = _app_it;
#line 70 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
									_tmp12_ = gee_iterator_get (_tmp11_);
#line 70 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
									app = (GAppInfo*) _tmp12_;
#line 71 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
									_tmp13_ = app;
#line 71 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
									_tmp14_ = g_app_info_get_name (_tmp13_);
#line 71 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
									_tmp15_ = external_app;
#line 71 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
									_tmp16_ = g_app_info_get_name (_tmp15_);
#line 71 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
									if (g_strcmp0 (_tmp14_, _tmp16_) == 0) {
#line 72 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
										already_contains = TRUE;
#line 73 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
										_g_object_unref0 (app);
#line 73 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
										break;
#line 975 "DesktopIntegration.c"
									}
#line 70 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
									_g_object_unref0 (app);
#line 979 "DesktopIntegration.c"
								}
#line 70 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
								_g_object_unref0 (_app_it);
#line 983 "DesktopIntegration.c"
							}
#line 78 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
							_tmp18_ = already_contains;
#line 78 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
							if (!_tmp18_) {
#line 989 "DesktopIntegration.c"
								GAppInfo* _tmp19_;
								const gchar* _tmp20_;
#line 78 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
								_tmp19_ = external_app;
#line 78 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
								_tmp20_ = g_app_info_get_name (_tmp19_);
#line 78 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
								_tmp17_ = !string_contains (_tmp20_, RESOURCES_APP_TITLE);
#line 998 "DesktopIntegration.c"
							} else {
#line 78 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
								_tmp17_ = FALSE;
#line 1002 "DesktopIntegration.c"
							}
#line 78 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
							if (_tmp17_) {
#line 1006 "DesktopIntegration.c"
								SortedList* _tmp21_;
								GAppInfo* _tmp22_;
#line 79 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
								_tmp21_ = external_apps;
#line 79 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
								_tmp22_ = external_app;
#line 79 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
								gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, GEE_TYPE_COLLECTION, GeeCollection), _tmp22_);
#line 1015 "DesktopIntegration.c"
							}
#line 66 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
							_g_object_unref0 (external_app);
#line 1019 "DesktopIntegration.c"
						}
					}
#line 66 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
					__g_list_free__g_object_unref0_0 (external_app_collection);
#line 1024 "DesktopIntegration.c"
				}
#line 61 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
				_g_free0 (content_type);
#line 61 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
				_g_free0 (mime_type);
#line 1030 "DesktopIntegration.c"
			}
		}
	}
#line 83 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	result = external_apps;
#line 83 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	return result;
#line 1038 "DesktopIntegration.c"
}


gchar*
desktop_integration_get_app_open_command (GAppInfo* app_info)
{
	gchar* result = NULL;
	gchar* str = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_;
	gchar* _tmp6_;
#line 86 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	g_return_val_if_fail (G_IS_APP_INFO (app_info), NULL);
#line 87 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp0_ = g_app_info_get_commandline (app_info);
#line 87 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 87 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	str = _tmp1_;
#line 89 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp3_ = str;
#line 89 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (_tmp3_ != NULL) {
#line 1064 "DesktopIntegration.c"
		const gchar* _tmp4_;
#line 89 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp4_ = str;
#line 89 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp2_ = _tmp4_;
#line 1070 "DesktopIntegration.c"
	} else {
		const gchar* _tmp5_;
#line 89 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp5_ = g_app_info_get_executable (app_info);
#line 89 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp2_ = _tmp5_;
#line 1077 "DesktopIntegration.c"
	}
#line 89 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp6_ = g_strdup (_tmp2_);
#line 89 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	result = _tmp6_;
#line 89 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_free0 (str);
#line 89 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	return result;
#line 1087 "DesktopIntegration.c"
}


gboolean
desktop_integration_is_send_to_installed (void)
{
	gboolean result = FALSE;
	gboolean _tmp0_;
#line 93 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp0_ = desktop_integration_send_to_installed;
#line 93 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	result = _tmp0_;
#line 93 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	return result;
#line 1102 "DesktopIntegration.c"
}


void
desktop_integration_files_send_to (GFile** files,
                                   int files_length1)
{
	gchar** argv = NULL;
	gchar** _tmp0_;
	gint argv_length1;
	gint _argv_size_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GError * _inner_error_ = NULL;
#line 97 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (files_length1 == 0) {
#line 98 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		return;
#line 1123 "DesktopIntegration.c"
	}
#line 100 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp0_ = g_new0 (gchar*, (files_length1 + 1) + 1);
#line 100 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	argv = _tmp0_;
#line 100 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	argv_length1 = files_length1 + 1;
#line 100 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_argv_size_ = argv_length1;
#line 101 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp1_ = argv;
#line 101 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp1__length1 = argv_length1;
#line 101 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp2_ = g_strdup (DESKTOP_INTEGRATION_SENDTO_EXEC);
#line 101 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_free0 (_tmp1_[0]);
#line 101 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp1_[0] = _tmp2_;
#line 101 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp3_ = _tmp1_[0];
#line 1145 "DesktopIntegration.c"
	{
		gint ctr = 0;
#line 103 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		ctr = 0;
#line 1150 "DesktopIntegration.c"
		{
			gboolean _tmp4_ = FALSE;
#line 103 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
			_tmp4_ = TRUE;
#line 103 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
			while (TRUE) {
#line 1157 "DesktopIntegration.c"
				gint _tmp6_;
				gchar** _tmp7_;
				gint _tmp7__length1;
				gint _tmp8_;
				gint _tmp9_;
				GFile* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
#line 103 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
				if (!_tmp4_) {
#line 1168 "DesktopIntegration.c"
					gint _tmp5_;
#line 103 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
					_tmp5_ = ctr;
#line 103 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
					ctr = _tmp5_ + 1;
#line 1174 "DesktopIntegration.c"
				}
#line 103 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
				_tmp4_ = FALSE;
#line 103 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
				_tmp6_ = ctr;
#line 103 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
				if (!(_tmp6_ < files_length1)) {
#line 103 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
					break;
#line 1184 "DesktopIntegration.c"
				}
#line 104 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
				_tmp7_ = argv;
#line 104 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
				_tmp7__length1 = argv_length1;
#line 104 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
				_tmp8_ = ctr;
#line 104 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
				_tmp9_ = ctr;
#line 104 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
				_tmp10_ = files[_tmp9_];
#line 104 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
				_tmp11_ = g_file_get_path (_tmp10_);
#line 104 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
				_g_free0 (_tmp7_[_tmp8_ + 1]);
#line 104 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
				_tmp7_[_tmp8_ + 1] = _tmp11_;
#line 104 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
				_tmp12_ = _tmp7_[_tmp8_ + 1];
#line 1204 "DesktopIntegration.c"
			}
		}
	}
	{
		AppWindow* _tmp13_;
		AppWindow* _tmp14_;
		GPid child_pid = 0;
		gchar** _tmp15_;
		gint _tmp15__length1;
		GPid _tmp16_ = 0;
		AppWindow* _tmp17_;
		AppWindow* _tmp18_;
#line 107 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp13_ = app_window_get_instance ();
#line 107 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp14_ = _tmp13_;
#line 107 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		page_window_set_busy_cursor (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, TYPE_PAGE_WINDOW, PageWindow));
#line 107 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_g_object_unref0 (_tmp14_);
#line 110 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp15_ = argv;
#line 110 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp15__length1 = argv_length1;
#line 110 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		g_spawn_async ("/", _tmp15_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp16_, &_inner_error_);
#line 110 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		child_pid = _tmp16_;
#line 110 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1235 "DesktopIntegration.c"
			goto __catch577_g_error;
		}
#line 118 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp17_ = app_window_get_instance ();
#line 118 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp18_ = _tmp17_;
#line 118 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		page_window_set_normal_cursor (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, TYPE_PAGE_WINDOW, PageWindow));
#line 118 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_g_object_unref0 (_tmp18_);
#line 1246 "DesktopIntegration.c"
	}
	goto __finally577;
	__catch577_g_error:
	{
		GError* err = NULL;
		AppWindow* _tmp19_;
		AppWindow* _tmp20_;
		GError* _tmp21_;
		const gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
#line 106 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		err = _inner_error_;
#line 106 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_inner_error_ = NULL;
#line 120 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp19_ = app_window_get_instance ();
#line 120 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp20_ = _tmp19_;
#line 120 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		page_window_set_normal_cursor (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, TYPE_PAGE_WINDOW, PageWindow));
#line 120 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_g_object_unref0 (_tmp20_);
#line 121 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp21_ = err;
#line 121 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp22_ = _tmp21_->message;
#line 121 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp23_ = g_strdup_printf (_ ("Unable to launch Nautilus Send-To: %s"), _tmp22_);
#line 121 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp24_ = _tmp23_;
#line 121 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		app_window_error_message (_tmp24_, NULL);
#line 121 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_g_free0 (_tmp24_);
#line 106 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_g_error_free0 (err);
#line 1284 "DesktopIntegration.c"
	}
	__finally577:
#line 106 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 106 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
#line 106 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 106 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		g_clear_error (&_inner_error_);
#line 106 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		return;
#line 1297 "DesktopIntegration.c"
	}
#line 96 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
#line 1301 "DesktopIntegration.c"
}


static void
_desktop_integration_on_send_to_export_completed_exporter_completion_callback (Exporter* exporter,
                                                                               gboolean is_cancelled,
                                                                               gpointer self)
{
#line 135 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	desktop_integration_on_send_to_export_completed (exporter, is_cancelled);
#line 1312 "DesktopIntegration.c"
}


void
desktop_integration_send_to (GeeCollection* media)
{
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	gint _tmp2_;
	ExportDialog* dialog = NULL;
	ExportDialog* _tmp4_;
	gboolean _tmp5_ = FALSE;
	gint scale = 0;
	ScaleConstraint constraint = 0;
	ExportFormatParameters export_params = {0};
	ExportFormatParameters _tmp7_ = {0};
	ExportDialog* _tmp8_;
	gint _tmp9_ = 0;
	ScaleConstraint _tmp10_ = 0;
	gboolean _tmp11_;
	ScaleConstraint _tmp12_;
	gint _tmp13_;
	Scaling _tmp14_ = {0};
	ExportFormatParameters _tmp15_;
	Exporter* _tmp16_;
	Exporter* _tmp17_;
	ExporterUI* _tmp18_;
	ExporterUI* _tmp19_;
#line 125 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	g_return_if_fail (GEE_IS_COLLECTION (media));
#line 126 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp1_ = gee_collection_get_size (media);
#line 126 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp2_ = _tmp1_;
#line 126 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (_tmp2_ == 0) {
#line 126 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp0_ = TRUE;
#line 1351 "DesktopIntegration.c"
	} else {
		ExporterUI* _tmp3_;
#line 126 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp3_ = desktop_integration_send_to_exporter;
#line 126 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp0_ = _tmp3_ != NULL;
#line 1358 "DesktopIntegration.c"
	}
#line 126 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (_tmp0_) {
#line 127 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		return;
#line 1364 "DesktopIntegration.c"
	}
#line 129 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp4_ = export_dialog_new (_ ("Send To"));
#line 129 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	g_object_ref_sink (_tmp4_);
#line 129 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	dialog = _tmp4_;
#line 134 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (media_source_collection_has_video (media)) {
#line 134 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp5_ = !media_source_collection_has_photo (media);
#line 1376 "DesktopIntegration.c"
	} else {
#line 134 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp5_ = FALSE;
#line 1380 "DesktopIntegration.c"
	}
#line 134 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (_tmp5_) {
#line 1384 "DesktopIntegration.c"
		ExporterUI* _tmp6_;
#line 135 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp6_ = video_export_many (G_TYPE_CHECK_INSTANCE_CAST (media, GEE_TYPE_COLLECTION, GeeCollection), _desktop_integration_on_send_to_export_completed_exporter_completion_callback, NULL, TRUE);
#line 135 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_exporter_ui_unref0 (desktop_integration_send_to_exporter);
#line 135 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		desktop_integration_send_to_exporter = _tmp6_;
#line 137 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_g_object_unref0 (dialog);
#line 137 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		return;
#line 1396 "DesktopIntegration.c"
	}
#line 142 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	export_format_parameters_current (&_tmp7_);
#line 142 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	export_params = _tmp7_;
#line 143 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp8_ = dialog;
#line 143 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp11_ = export_dialog_execute (_tmp8_, &_tmp9_, &_tmp10_, &export_params);
#line 143 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	scale = _tmp9_;
#line 143 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	constraint = _tmp10_;
#line 143 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (!_tmp11_) {
#line 144 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_g_object_unref0 (dialog);
#line 144 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		return;
#line 1416 "DesktopIntegration.c"
	}
#line 146 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp12_ = constraint;
#line 146 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp13_ = scale;
#line 146 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	scaling_for_constraint (_tmp12_, _tmp13_, FALSE, &_tmp14_);
#line 146 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp15_ = export_params;
#line 146 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp16_ = exporter_new_for_temp_file (media, &_tmp14_, &_tmp15_);
#line 146 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp17_ = _tmp16_;
#line 146 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp18_ = exporter_ui_new (_tmp17_);
#line 146 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_exporter_ui_unref0 (desktop_integration_send_to_exporter);
#line 146 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	desktop_integration_send_to_exporter = _tmp18_;
#line 146 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_object_unref0 (_tmp17_);
#line 148 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp19_ = desktop_integration_send_to_exporter;
#line 148 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	exporter_ui_export (_tmp19_, _desktop_integration_on_send_to_export_completed_exporter_completion_callback, NULL);
#line 125 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_object_unref0 (dialog);
#line 1444 "DesktopIntegration.c"
}


void
desktop_integration_on_send_to_export_completed (Exporter* exporter,
                                                 gboolean is_cancelled)
{
#line 151 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	g_return_if_fail (IS_EXPORTER (exporter));
#line 152 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (!is_cancelled) {
#line 1456 "DesktopIntegration.c"
		gint _tmp0_;
		GFile** _tmp1_;
		GFile** _tmp2_;
		gint _tmp2__length1;
#line 153 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp1_ = exporter_get_exported_files (exporter, &_tmp0_);
#line 153 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp2_ = _tmp1_;
#line 153 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp2__length1 = _tmp0_;
#line 153 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		desktop_integration_files_send_to (_tmp2_, _tmp0_);
#line 153 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp2_ = (_vala_array_free (_tmp2_, _tmp2__length1, (GDestroyNotify) g_object_unref), NULL);
#line 1471 "DesktopIntegration.c"
	}
#line 155 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_exporter_ui_unref0 (desktop_integration_send_to_exporter);
#line 155 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	desktop_integration_send_to_exporter = NULL;
#line 1477 "DesktopIntegration.c"
}


void
desktop_integration_set_background (Photo* photo,
                                    gboolean desktop,
                                    gboolean screensaver)
{
	PhotoFileFormat file_format = 0;
	GFile* save_as = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	PhotoFileFormat _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GFile* _tmp5_;
	GFile* _tmp6_;
	ConfigFacade* _tmp7_;
	ConfigFacade* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GFile* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gboolean _tmp14_;
	GFile* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	GError * _inner_error_ = NULL;
#line 158 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	g_return_if_fail (IS_PHOTO (photo));
#line 161 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	file_format = photo_get_best_export_file_format (photo);
#line 163 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp0_ = app_dirs_get_data_subdir ("wallpaper", NULL);
#line 163 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp1_ = _tmp0_;
#line 163 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp2_ = file_format;
#line 163 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp3_ = photo_file_format_get_default_basename (_tmp2_, "wallpaper");
#line 163 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp4_ = _tmp3_;
#line 163 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp5_ = g_file_get_child (_tmp1_, _tmp4_);
#line 163 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp6_ = _tmp5_;
#line 163 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_free0 (_tmp4_);
#line 163 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_object_unref0 (_tmp1_);
#line 163 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	save_as = _tmp6_;
#line 166 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp7_ = config_facade_get_instance ();
#line 166 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp8_ = _tmp7_;
#line 166 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp9_ = configuration_facade_get_desktop_background (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
#line 166 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp10_ = _tmp9_;
#line 166 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp11_ = save_as;
#line 166 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp12_ = g_file_get_path (_tmp11_);
#line 166 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp13_ = _tmp12_;
#line 166 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp14_ = g_strcmp0 (_tmp10_, _tmp13_) == 0;
#line 166 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_free0 (_tmp13_);
#line 166 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_free0 (_tmp10_);
#line 166 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_object_unref0 (_tmp8_);
#line 166 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (_tmp14_) {
#line 1555 "DesktopIntegration.c"
		GFile* _tmp15_;
		GFile* _tmp16_;
		PhotoFileFormat _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		GFile* _tmp20_;
#line 167 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp15_ = app_dirs_get_data_subdir ("wallpaper", NULL);
#line 167 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp16_ = _tmp15_;
#line 167 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp17_ = file_format;
#line 167 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp18_ = photo_file_format_get_default_basename (_tmp17_, "wallpaper_alt");
#line 167 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp19_ = _tmp18_;
#line 167 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp20_ = g_file_get_child (_tmp16_, _tmp19_);
#line 167 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_g_object_unref0 (save_as);
#line 167 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		save_as = _tmp20_;
#line 167 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_g_free0 (_tmp19_);
#line 167 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_g_object_unref0 (_tmp16_);
#line 1582 "DesktopIntegration.c"
	}
	{
		GFile* _tmp21_;
		Scaling _tmp22_ = {0};
		PhotoFileFormat _tmp23_;
#line 172 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp21_ = save_as;
#line 172 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		scaling_for_original (&_tmp22_);
#line 172 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp23_ = file_format;
#line 172 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		photo_export (photo, _tmp21_, &_tmp22_, JPEG_QUALITY_HIGH, _tmp23_, FALSE, TRUE, &_inner_error_);
#line 172 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1598 "DesktopIntegration.c"
			goto __catch578_g_error;
		}
	}
	goto __finally578;
	__catch578_g_error:
	{
		GError* err = NULL;
		GFile* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		GError* _tmp27_;
		const gchar* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
#line 171 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		err = _inner_error_;
#line 171 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_inner_error_ = NULL;
#line 174 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp24_ = save_as;
#line 174 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp25_ = g_file_get_path (_tmp24_);
#line 174 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp26_ = _tmp25_;
#line 174 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp27_ = err;
#line 174 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp28_ = _tmp27_->message;
#line 174 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp29_ = g_strdup_printf (_ ("Unable to export background to %s: %s"), _tmp26_, _tmp28_);
#line 174 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp30_ = _tmp29_;
#line 174 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		app_window_error_message (_tmp30_, NULL);
#line 174 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_g_free0 (_tmp30_);
#line 174 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_g_free0 (_tmp26_);
#line 177 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_g_error_free0 (err);
#line 177 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_g_object_unref0 (save_as);
#line 177 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		return;
#line 1643 "DesktopIntegration.c"
	}
	__finally578:
#line 171 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 171 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_g_object_unref0 (save_as);
#line 171 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 171 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		g_clear_error (&_inner_error_);
#line 171 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		return;
#line 1656 "DesktopIntegration.c"
	}
#line 180 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (desktop) {
#line 1660 "DesktopIntegration.c"
		ConfigFacade* _tmp31_;
		ConfigFacade* _tmp32_;
		GFile* _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_;
#line 181 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp31_ = config_facade_get_instance ();
#line 181 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp32_ = _tmp31_;
#line 181 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp33_ = save_as;
#line 181 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp34_ = g_file_get_path (_tmp33_);
#line 181 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp35_ = _tmp34_;
#line 181 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		configuration_facade_set_desktop_background (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), _tmp35_);
#line 181 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_g_free0 (_tmp35_);
#line 181 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_g_object_unref0 (_tmp32_);
#line 1682 "DesktopIntegration.c"
	}
#line 183 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (screensaver) {
#line 1686 "DesktopIntegration.c"
		ConfigFacade* _tmp36_;
		ConfigFacade* _tmp37_;
		GFile* _tmp38_;
		gchar* _tmp39_;
		gchar* _tmp40_;
#line 184 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp36_ = config_facade_get_instance ();
#line 184 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp37_ = _tmp36_;
#line 184 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp38_ = save_as;
#line 184 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp39_ = g_file_get_path (_tmp38_);
#line 184 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp40_ = _tmp39_;
#line 184 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		configuration_facade_set_screensaver (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), _tmp40_);
#line 184 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_g_free0 (_tmp40_);
#line 184 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_g_object_unref0 (_tmp37_);
#line 1708 "DesktopIntegration.c"
	}
#line 187 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp41_ = save_as;
#line 187 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp42_ = g_file_get_parse_name (_tmp41_);
#line 187 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp43_ = _tmp42_;
#line 187 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	g_chmod (_tmp43_, 0644);
#line 187 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_free0 (_tmp43_);
#line 158 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_object_unref0 (save_as);
#line 1722 "DesktopIntegration.c"
}


DesktopIntegrationBackgroundSlideshowXMLBuilder*
desktop_integration_background_slideshow_xml_builder_construct (GType object_type,
                                                                GFile* destination,
                                                                gdouble duration,
                                                                gdouble transition)
{
	DesktopIntegrationBackgroundSlideshowXMLBuilder* self = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GFile* _tmp7_;
#line 202 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	g_return_val_if_fail (G_IS_FILE (destination), NULL);
#line 202 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	self = (DesktopIntegrationBackgroundSlideshowXMLBuilder*) g_type_create_instance (object_type);
#line 203 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp0_ = _g_object_ref0 (destination);
#line 203 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_object_unref0 (self->priv->destination);
#line 203 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	self->priv->destination = _tmp0_;
#line 204 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	self->priv->duration = duration;
#line 205 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	self->priv->transition = transition;
#line 207 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp1_ = g_file_get_parent (destination);
#line 207 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp2_ = _tmp1_;
#line 207 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp3_ = g_file_get_basename (destination);
#line 207 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp4_ = _tmp3_;
#line 207 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp5_ = g_strconcat (_tmp4_, ".tmp", NULL);
#line 207 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp6_ = _tmp5_;
#line 207 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp7_ = g_file_get_child (_tmp2_, _tmp6_);
#line 207 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_object_unref0 (self->priv->tmp_file);
#line 207 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	self->priv->tmp_file = _tmp7_;
#line 207 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_free0 (_tmp6_);
#line 207 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_free0 (_tmp4_);
#line 207 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_object_unref0 (_tmp2_);
#line 202 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	return self;
#line 1781 "DesktopIntegration.c"
}


DesktopIntegrationBackgroundSlideshowXMLBuilder*
desktop_integration_background_slideshow_xml_builder_new (GFile* destination,
                                                          gdouble duration,
                                                          gdouble transition)
{
#line 202 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	return desktop_integration_background_slideshow_xml_builder_construct (DESKTOP_INTEGRATION_TYPE_BACKGROUND_SLIDESHOW_XML_BUILDER, destination, duration, transition);
#line 1792 "DesktopIntegration.c"
}


void
desktop_integration_background_slideshow_xml_builder_open (DesktopIntegrationBackgroundSlideshowXMLBuilder* self,
                                                           GError** error)
{
	GFileOutputStream* _tmp0_ = NULL;
	GFile* _tmp1_;
	GFileOutputStream* _tmp2_;
	GDataOutputStream* _tmp3_;
	GDataOutputStream* _tmp4_;
	GError * _inner_error_ = NULL;
#line 210 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	g_return_if_fail (DESKTOP_INTEGRATION_IS_BACKGROUND_SLIDESHOW_XML_BUILDER (self));
#line 211 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp1_ = self->priv->tmp_file;
#line 211 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp2_ = g_file_replace (_tmp1_, NULL, FALSE, G_FILE_CREATE_NONE, NULL, &_inner_error_);
#line 211 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp0_ = _tmp2_;
#line 211 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 211 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		g_propagate_error (error, _inner_error_);
#line 211 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		return;
#line 1820 "DesktopIntegration.c"
	}
#line 211 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp3_ = g_data_output_stream_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, g_output_stream_get_type (), GOutputStream));
#line 211 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_object_unref0 (self->priv->outs);
#line 211 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	self->priv->outs = _tmp3_;
#line 212 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp4_ = self->priv->outs;
#line 212 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	g_data_output_stream_put_string (_tmp4_, "<background>\n", NULL, &_inner_error_);
#line 212 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 212 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		g_propagate_error (error, _inner_error_);
#line 212 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_g_object_unref0 (_tmp0_);
#line 212 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		return;
#line 1840 "DesktopIntegration.c"
	}
#line 210 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_object_unref0 (_tmp0_);
#line 1844 "DesktopIntegration.c"
}


static void
desktop_integration_background_slideshow_xml_builder_write_transition (DesktopIntegrationBackgroundSlideshowXMLBuilder* self,
                                                                       GFile* from,
                                                                       GFile* to,
                                                                       GError** error)
{
	GDataOutputStream* _tmp0_;
	GDataOutputStream* _tmp1_;
	gdouble _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GDataOutputStream* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GDataOutputStream* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	GDataOutputStream* _tmp19_;
	GError * _inner_error_ = NULL;
#line 215 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	g_return_if_fail (DESKTOP_INTEGRATION_IS_BACKGROUND_SLIDESHOW_XML_BUILDER (self));
#line 215 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	g_return_if_fail (G_IS_FILE (from));
#line 215 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	g_return_if_fail (G_IS_FILE (to));
#line 216 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp0_ = self->priv->outs;
#line 216 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	g_data_output_stream_put_string (_tmp0_, "  <transition>\n", NULL, &_inner_error_);
#line 216 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 216 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		g_propagate_error (error, _inner_error_);
#line 216 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		return;
#line 1891 "DesktopIntegration.c"
	}
#line 217 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp1_ = self->priv->outs;
#line 217 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp2_ = self->priv->transition;
#line 217 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp3_ = g_strdup_printf ("    <duration>%2.2f</duration>\n", _tmp2_);
#line 217 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp4_ = _tmp3_;
#line 217 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	g_data_output_stream_put_string (_tmp1_, _tmp4_, NULL, &_inner_error_);
#line 217 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_free0 (_tmp4_);
#line 217 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 217 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		g_propagate_error (error, _inner_error_);
#line 217 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		return;
#line 1911 "DesktopIntegration.c"
	}
#line 218 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp5_ = self->priv->outs;
#line 218 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp6_ = g_file_get_path (from);
#line 218 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp7_ = _tmp6_;
#line 218 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp8_ = g_markup_escape_text (_tmp7_, (gssize) -1);
#line 218 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp9_ = _tmp8_;
#line 218 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp10_ = g_strdup_printf ("    <from>%s</from>\n", _tmp9_);
#line 218 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp11_ = _tmp10_;
#line 218 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	g_data_output_stream_put_string (_tmp5_, _tmp11_, NULL, &_inner_error_);
#line 218 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_free0 (_tmp11_);
#line 218 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_free0 (_tmp9_);
#line 218 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_free0 (_tmp7_);
#line 218 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 218 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		g_propagate_error (error, _inner_error_);
#line 218 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		return;
#line 1941 "DesktopIntegration.c"
	}
#line 219 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp12_ = self->priv->outs;
#line 219 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp13_ = g_file_get_path (to);
#line 219 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp14_ = _tmp13_;
#line 219 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp15_ = g_markup_escape_text (_tmp14_, (gssize) -1);
#line 219 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp16_ = _tmp15_;
#line 219 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp17_ = g_strdup_printf ("    <to>%s</to>\n", _tmp16_);
#line 219 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp18_ = _tmp17_;
#line 219 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	g_data_output_stream_put_string (_tmp12_, _tmp18_, NULL, &_inner_error_);
#line 219 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_free0 (_tmp18_);
#line 219 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_free0 (_tmp16_);
#line 219 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_free0 (_tmp14_);
#line 219 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 219 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		g_propagate_error (error, _inner_error_);
#line 219 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		return;
#line 1971 "DesktopIntegration.c"
	}
#line 220 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp19_ = self->priv->outs;
#line 220 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	g_data_output_stream_put_string (_tmp19_, "  </transition>\n", NULL, &_inner_error_);
#line 220 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 220 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		g_propagate_error (error, _inner_error_);
#line 220 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		return;
#line 1983 "DesktopIntegration.c"
	}
}


static void
desktop_integration_background_slideshow_xml_builder_write_static (DesktopIntegrationBackgroundSlideshowXMLBuilder* self,
                                                                   GFile* file,
                                                                   GError** error)
{
	GDataOutputStream* _tmp0_;
	GDataOutputStream* _tmp1_;
	gdouble _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GDataOutputStream* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GDataOutputStream* _tmp12_;
	GError * _inner_error_ = NULL;
#line 223 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	g_return_if_fail (DESKTOP_INTEGRATION_IS_BACKGROUND_SLIDESHOW_XML_BUILDER (self));
#line 223 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	g_return_if_fail (G_IS_FILE (file));
#line 224 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp0_ = self->priv->outs;
#line 224 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	g_data_output_stream_put_string (_tmp0_, "  <static>\n", NULL, &_inner_error_);
#line 224 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 224 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		g_propagate_error (error, _inner_error_);
#line 224 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		return;
#line 2021 "DesktopIntegration.c"
	}
#line 225 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp1_ = self->priv->outs;
#line 225 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp2_ = self->priv->duration;
#line 225 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp3_ = g_strdup_printf ("    <duration>%2.2f</duration>\n", _tmp2_);
#line 225 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp4_ = _tmp3_;
#line 225 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	g_data_output_stream_put_string (_tmp1_, _tmp4_, NULL, &_inner_error_);
#line 225 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_free0 (_tmp4_);
#line 225 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 225 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		g_propagate_error (error, _inner_error_);
#line 225 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		return;
#line 2041 "DesktopIntegration.c"
	}
#line 226 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp5_ = self->priv->outs;
#line 226 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp6_ = g_file_get_path (file);
#line 226 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp7_ = _tmp6_;
#line 226 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp8_ = g_markup_escape_text (_tmp7_, (gssize) -1);
#line 226 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp9_ = _tmp8_;
#line 226 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp10_ = g_strdup_printf ("    <file>%s</file>\n", _tmp9_);
#line 226 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp11_ = _tmp10_;
#line 226 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	g_data_output_stream_put_string (_tmp5_, _tmp11_, NULL, &_inner_error_);
#line 226 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_free0 (_tmp11_);
#line 226 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_free0 (_tmp9_);
#line 226 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_free0 (_tmp7_);
#line 226 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 226 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		g_propagate_error (error, _inner_error_);
#line 226 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		return;
#line 2071 "DesktopIntegration.c"
	}
#line 227 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp12_ = self->priv->outs;
#line 227 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	g_data_output_stream_put_string (_tmp12_, "  </static>\n", NULL, &_inner_error_);
#line 227 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 227 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		g_propagate_error (error, _inner_error_);
#line 227 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		return;
#line 2083 "DesktopIntegration.c"
	}
}


void
desktop_integration_background_slideshow_xml_builder_add_photo (DesktopIntegrationBackgroundSlideshowXMLBuilder* self,
                                                                GFile* file,
                                                                GError** error)
{
	GDataOutputStream* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp3_;
	GFile* _tmp5_;
	GError * _inner_error_ = NULL;
#line 230 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	g_return_if_fail (DESKTOP_INTEGRATION_IS_BACKGROUND_SLIDESHOW_XML_BUILDER (self));
#line 230 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	g_return_if_fail (G_IS_FILE (file));
#line 231 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp0_ = self->priv->outs;
#line 231 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_vala_assert (_tmp0_ != NULL, "outs != null");
#line 233 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp1_ = self->priv->first_file;
#line 233 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (_tmp1_ == NULL) {
#line 2110 "DesktopIntegration.c"
		GFile* _tmp2_;
#line 234 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp2_ = _g_object_ref0 (file);
#line 234 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_g_object_unref0 (self->priv->first_file);
#line 234 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		self->priv->first_file = _tmp2_;
#line 2118 "DesktopIntegration.c"
	}
#line 236 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp3_ = self->priv->last_file;
#line 236 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (_tmp3_ != NULL) {
#line 2124 "DesktopIntegration.c"
		GFile* _tmp4_;
#line 237 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp4_ = self->priv->last_file;
#line 237 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		desktop_integration_background_slideshow_xml_builder_write_transition (self, _tmp4_, file, &_inner_error_);
#line 237 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 237 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
			g_propagate_error (error, _inner_error_);
#line 237 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
			return;
#line 2136 "DesktopIntegration.c"
		}
	}
#line 239 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	desktop_integration_background_slideshow_xml_builder_write_static (self, file, &_inner_error_);
#line 239 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 239 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		g_propagate_error (error, _inner_error_);
#line 239 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		return;
#line 2147 "DesktopIntegration.c"
	}
#line 241 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp5_ = _g_object_ref0 (file);
#line 241 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_object_unref0 (self->priv->last_file);
#line 241 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	self->priv->last_file = _tmp5_;
#line 2155 "DesktopIntegration.c"
}


GFile*
desktop_integration_background_slideshow_xml_builder_close (DesktopIntegrationBackgroundSlideshowXMLBuilder* self,
                                                            GError** error)
{
	GFile* result = NULL;
	GDataOutputStream* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GFile* _tmp2_;
	GDataOutputStream* _tmp6_;
	GDataOutputStream* _tmp7_;
	GFile* _tmp8_;
	GFile* _tmp9_;
	GFile* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	GFile* _tmp13_;
	GFile* _tmp14_;
	GError * _inner_error_ = NULL;
#line 244 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	g_return_val_if_fail (DESKTOP_INTEGRATION_IS_BACKGROUND_SLIDESHOW_XML_BUILDER (self), NULL);
#line 245 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp0_ = self->priv->outs;
#line 245 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (_tmp0_ == NULL) {
#line 246 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		result = NULL;
#line 246 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		return result;
#line 2187 "DesktopIntegration.c"
	}
#line 249 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp2_ = self->priv->first_file;
#line 249 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (_tmp2_ != NULL) {
#line 2193 "DesktopIntegration.c"
		GFile* _tmp3_;
#line 249 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp3_ = self->priv->last_file;
#line 249 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp1_ = _tmp3_ != NULL;
#line 2199 "DesktopIntegration.c"
	} else {
#line 249 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp1_ = FALSE;
#line 2203 "DesktopIntegration.c"
	}
#line 249 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (_tmp1_) {
#line 2207 "DesktopIntegration.c"
		GFile* _tmp4_;
		GFile* _tmp5_;
#line 250 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp4_ = self->priv->last_file;
#line 250 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp5_ = self->priv->first_file;
#line 250 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		desktop_integration_background_slideshow_xml_builder_write_transition (self, _tmp4_, _tmp5_, &_inner_error_);
#line 250 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 250 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
			g_propagate_error (error, _inner_error_);
#line 250 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
			return NULL;
#line 2222 "DesktopIntegration.c"
		}
	}
#line 252 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp6_ = self->priv->outs;
#line 252 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	g_data_output_stream_put_string (_tmp6_, "</background>\n", NULL, &_inner_error_);
#line 252 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 252 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		g_propagate_error (error, _inner_error_);
#line 252 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		return NULL;
#line 2235 "DesktopIntegration.c"
	}
#line 254 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp7_ = self->priv->outs;
#line 254 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	g_output_stream_close (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, g_output_stream_get_type (), GOutputStream), NULL, &_inner_error_);
#line 254 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 254 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		g_propagate_error (error, _inner_error_);
#line 254 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		return NULL;
#line 2247 "DesktopIntegration.c"
	}
#line 255 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_object_unref0 (self->priv->outs);
#line 255 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	self->priv->outs = NULL;
#line 258 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp8_ = self->priv->tmp_file;
#line 258 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp9_ = self->priv->destination;
#line 258 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	g_file_move (_tmp8_, _tmp9_, G_FILE_COPY_OVERWRITE, NULL, NULL, NULL, &_inner_error_);
#line 258 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 258 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		g_propagate_error (error, _inner_error_);
#line 258 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		return NULL;
#line 2265 "DesktopIntegration.c"
	}
#line 259 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp10_ = self->priv->destination;
#line 259 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp11_ = g_file_get_parse_name (_tmp10_);
#line 259 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp12_ = _tmp11_;
#line 259 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	g_chmod (_tmp12_, 0644);
#line 259 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_free0 (_tmp12_);
#line 261 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp13_ = self->priv->destination;
#line 261 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp14_ = _g_object_ref0 (_tmp13_);
#line 261 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	result = _tmp14_;
#line 261 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	return result;
#line 2285 "DesktopIntegration.c"
}


static void
desktop_integration_value_background_slideshow_xml_builder_init (GValue* value)
{
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	value->data[0].v_pointer = NULL;
#line 2294 "DesktopIntegration.c"
}


static void
desktop_integration_value_background_slideshow_xml_builder_free_value (GValue* value)
{
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (value->data[0].v_pointer) {
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		desktop_integration_background_slideshow_xml_builder_unref (value->data[0].v_pointer);
#line 2305 "DesktopIntegration.c"
	}
}


static void
desktop_integration_value_background_slideshow_xml_builder_copy_value (const GValue* src_value,
                                                                       GValue* dest_value)
{
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (src_value->data[0].v_pointer) {
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		dest_value->data[0].v_pointer = desktop_integration_background_slideshow_xml_builder_ref (src_value->data[0].v_pointer);
#line 2318 "DesktopIntegration.c"
	} else {
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		dest_value->data[0].v_pointer = NULL;
#line 2322 "DesktopIntegration.c"
	}
}


static gpointer
desktop_integration_value_background_slideshow_xml_builder_peek_pointer (const GValue* value)
{
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	return value->data[0].v_pointer;
#line 2332 "DesktopIntegration.c"
}


static gchar*
desktop_integration_value_background_slideshow_xml_builder_collect_value (GValue* value,
                                                                          guint n_collect_values,
                                                                          GTypeCValue* collect_values,
                                                                          guint collect_flags)
{
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (collect_values[0].v_pointer) {
#line 2344 "DesktopIntegration.c"
		DesktopIntegrationBackgroundSlideshowXMLBuilder * object;
		object = collect_values[0].v_pointer;
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		if (object->parent_instance.g_class == NULL) {
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2351 "DesktopIntegration.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2355 "DesktopIntegration.c"
		}
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		value->data[0].v_pointer = desktop_integration_background_slideshow_xml_builder_ref (object);
#line 2359 "DesktopIntegration.c"
	} else {
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		value->data[0].v_pointer = NULL;
#line 2363 "DesktopIntegration.c"
	}
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	return NULL;
#line 2367 "DesktopIntegration.c"
}


static gchar*
desktop_integration_value_background_slideshow_xml_builder_lcopy_value (const GValue* value,
                                                                        guint n_collect_values,
                                                                        GTypeCValue* collect_values,
                                                                        guint collect_flags)
{
	DesktopIntegrationBackgroundSlideshowXMLBuilder ** object_p;
	object_p = collect_values[0].v_pointer;
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (!object_p) {
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 2383 "DesktopIntegration.c"
	}
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (!value->data[0].v_pointer) {
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		*object_p = NULL;
#line 2389 "DesktopIntegration.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		*object_p = value->data[0].v_pointer;
#line 2393 "DesktopIntegration.c"
	} else {
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		*object_p = desktop_integration_background_slideshow_xml_builder_ref (value->data[0].v_pointer);
#line 2397 "DesktopIntegration.c"
	}
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	return NULL;
#line 2401 "DesktopIntegration.c"
}


GParamSpec*
desktop_integration_param_spec_background_slideshow_xml_builder (const gchar* name,
                                                                 const gchar* nick,
                                                                 const gchar* blurb,
                                                                 GType object_type,
                                                                 GParamFlags flags)
{
	DesktopIntegrationParamSpecBackgroundSlideshowXMLBuilder* spec;
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	g_return_val_if_fail (g_type_is_a (object_type, DESKTOP_INTEGRATION_TYPE_BACKGROUND_SLIDESHOW_XML_BUILDER), NULL);
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	return G_PARAM_SPEC (spec);
#line 2421 "DesktopIntegration.c"
}


gpointer
desktop_integration_value_get_background_slideshow_xml_builder (const GValue* value)
{
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, DESKTOP_INTEGRATION_TYPE_BACKGROUND_SLIDESHOW_XML_BUILDER), NULL);
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	return value->data[0].v_pointer;
#line 2432 "DesktopIntegration.c"
}


void
desktop_integration_value_set_background_slideshow_xml_builder (GValue* value,
                                                                gpointer v_object)
{
	DesktopIntegrationBackgroundSlideshowXMLBuilder * old;
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, DESKTOP_INTEGRATION_TYPE_BACKGROUND_SLIDESHOW_XML_BUILDER));
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	old = value->data[0].v_pointer;
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (v_object) {
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, DESKTOP_INTEGRATION_TYPE_BACKGROUND_SLIDESHOW_XML_BUILDER));
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		value->data[0].v_pointer = v_object;
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		desktop_integration_background_slideshow_xml_builder_ref (value->data[0].v_pointer);
#line 2455 "DesktopIntegration.c"
	} else {
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		value->data[0].v_pointer = NULL;
#line 2459 "DesktopIntegration.c"
	}
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (old) {
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		desktop_integration_background_slideshow_xml_builder_unref (old);
#line 2465 "DesktopIntegration.c"
	}
}


void
desktop_integration_value_take_background_slideshow_xml_builder (GValue* value,
                                                                 gpointer v_object)
{
	DesktopIntegrationBackgroundSlideshowXMLBuilder * old;
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, DESKTOP_INTEGRATION_TYPE_BACKGROUND_SLIDESHOW_XML_BUILDER));
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	old = value->data[0].v_pointer;
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (v_object) {
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, DESKTOP_INTEGRATION_TYPE_BACKGROUND_SLIDESHOW_XML_BUILDER));
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		value->data[0].v_pointer = v_object;
#line 2487 "DesktopIntegration.c"
	} else {
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		value->data[0].v_pointer = NULL;
#line 2491 "DesktopIntegration.c"
	}
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (old) {
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		desktop_integration_background_slideshow_xml_builder_unref (old);
#line 2497 "DesktopIntegration.c"
	}
}


static void
desktop_integration_background_slideshow_xml_builder_class_init (DesktopIntegrationBackgroundSlideshowXMLBuilderClass * klass)
{
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	desktop_integration_background_slideshow_xml_builder_parent_class = g_type_class_peek_parent (klass);
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	((DesktopIntegrationBackgroundSlideshowXMLBuilderClass *) klass)->finalize = desktop_integration_background_slideshow_xml_builder_finalize;
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	g_type_class_add_private (klass, sizeof (DesktopIntegrationBackgroundSlideshowXMLBuilderPrivate));
#line 2511 "DesktopIntegration.c"
}


static void
desktop_integration_background_slideshow_xml_builder_instance_init (DesktopIntegrationBackgroundSlideshowXMLBuilder * self)
{
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	self->priv = DESKTOP_INTEGRATION_BACKGROUND_SLIDESHOW_XML_BUILDER_GET_PRIVATE (self);
#line 198 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	self->priv->outs = NULL;
#line 199 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	self->priv->first_file = NULL;
#line 200 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	self->priv->last_file = NULL;
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	self->ref_count = 1;
#line 2528 "DesktopIntegration.c"
}


static void
desktop_integration_background_slideshow_xml_builder_finalize (DesktopIntegrationBackgroundSlideshowXMLBuilder * obj)
{
	DesktopIntegrationBackgroundSlideshowXMLBuilder * self;
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DESKTOP_INTEGRATION_TYPE_BACKGROUND_SLIDESHOW_XML_BUILDER, DesktopIntegrationBackgroundSlideshowXMLBuilder);
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	g_signal_handlers_destroy (self);
#line 194 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_object_unref0 (self->priv->destination);
#line 197 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_object_unref0 (self->priv->tmp_file);
#line 198 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_object_unref0 (self->priv->outs);
#line 199 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_object_unref0 (self->priv->first_file);
#line 200 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_object_unref0 (self->priv->last_file);
#line 2550 "DesktopIntegration.c"
}


GType
desktop_integration_background_slideshow_xml_builder_get_type (void)
{
	static volatile gsize desktop_integration_background_slideshow_xml_builder_type_id__volatile = 0;
	if (g_once_init_enter (&desktop_integration_background_slideshow_xml_builder_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { desktop_integration_value_background_slideshow_xml_builder_init, desktop_integration_value_background_slideshow_xml_builder_free_value, desktop_integration_value_background_slideshow_xml_builder_copy_value, desktop_integration_value_background_slideshow_xml_builder_peek_pointer, "p", desktop_integration_value_background_slideshow_xml_builder_collect_value, "p", desktop_integration_value_background_slideshow_xml_builder_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (DesktopIntegrationBackgroundSlideshowXMLBuilderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) desktop_integration_background_slideshow_xml_builder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DesktopIntegrationBackgroundSlideshowXMLBuilder), 0, (GInstanceInitFunc) desktop_integration_background_slideshow_xml_builder_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType desktop_integration_background_slideshow_xml_builder_type_id;
		desktop_integration_background_slideshow_xml_builder_type_id = g_type_register_fundamental (g_type_fundamental_next (), "DesktopIntegrationBackgroundSlideshowXMLBuilder", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&desktop_integration_background_slideshow_xml_builder_type_id__volatile, desktop_integration_background_slideshow_xml_builder_type_id);
	}
	return desktop_integration_background_slideshow_xml_builder_type_id__volatile;
}


gpointer
desktop_integration_background_slideshow_xml_builder_ref (gpointer instance)
{
	DesktopIntegrationBackgroundSlideshowXMLBuilder * self;
	self = instance;
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	g_atomic_int_inc (&self->ref_count);
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	return instance;
#line 2579 "DesktopIntegration.c"
}


void
desktop_integration_background_slideshow_xml_builder_unref (gpointer instance)
{
	DesktopIntegrationBackgroundSlideshowXMLBuilder * self;
	self = instance;
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		DESKTOP_INTEGRATION_BACKGROUND_SLIDESHOW_XML_BUILDER_GET_CLASS (self)->finalize (self);
#line 193 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 2594 "DesktopIntegration.c"
	}
}


static void
_desktop_integration_on_desktop_slideshow_exported_exporter_completion_callback (Exporter* exporter,
                                                                                 gboolean is_cancelled,
                                                                                 gpointer self)
{
#line 290 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	desktop_integration_on_desktop_slideshow_exported (exporter, is_cancelled);
#line 2606 "DesktopIntegration.c"
}


void
desktop_integration_set_background_slideshow (GeeCollection* photos,
                                              gdouble duration,
                                              gdouble transition,
                                              gboolean desktop_background,
                                              gboolean screensaver)
{
	ExporterUI* _tmp0_;
	GFile* wallpaper_dir = NULL;
	GFile* _tmp1_;
	GeeSet* exceptions = NULL;
	GeeHashSet* _tmp2_;
	GeeSet* _tmp3_;
	Exporter* exporter = NULL;
	GFile* _tmp8_;
	AppWindow* _tmp9_;
	AppWindow* _tmp10_;
	Scaling _tmp11_ = {0};
	ExportFormatParameters _tmp12_ = {0};
	Exporter* _tmp13_;
	Exporter* _tmp14_;
	Exporter* _tmp15_;
	ExporterUI* _tmp16_;
	ExporterUI* _tmp17_;
	GError * _inner_error_ = NULL;
#line 265 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	g_return_if_fail (GEE_IS_COLLECTION (photos));
#line 267 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp0_ = desktop_integration_desktop_slideshow_exporter;
#line 267 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (_tmp0_ != NULL) {
#line 268 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		return;
#line 2643 "DesktopIntegration.c"
	}
#line 270 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	desktop_integration_set_desktop_background = desktop_background;
#line 271 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	desktop_integration_set_screensaver = screensaver;
#line 273 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp1_ = app_dirs_get_data_subdir ("wallpaper", NULL);
#line 273 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	wallpaper_dir = _tmp1_;
#line 275 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp2_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
#line 275 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	exceptions = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_SET, GeeSet);
#line 276 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp3_ = exceptions;
#line 276 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_COLLECTION, GeeCollection), DESKTOP_INTEGRATION_DESKTOP_SLIDESHOW_XML_FILENAME);
#line 2661 "DesktopIntegration.c"
	{
		GFile* _tmp4_;
		GeeSet* _tmp5_;
#line 278 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp4_ = wallpaper_dir;
#line 278 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp5_ = exceptions;
#line 278 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		delete_all_files (_tmp4_, _tmp5_, NULL, NULL, (guint64) 0, NULL, &_inner_error_);
#line 278 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2673 "DesktopIntegration.c"
			goto __catch579_g_error;
		}
	}
	goto __finally579;
	__catch579_g_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
#line 277 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		err = _inner_error_;
#line 277 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_inner_error_ = NULL;
#line 280 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp6_ = err;
#line 280 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp7_ = _tmp6_->message;
#line 280 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		g_warning ("DesktopIntegration.vala:280: Error attempting to clear wallpaper direc" \
"tory: %s", _tmp7_);
#line 277 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_g_error_free0 (err);
#line 2695 "DesktopIntegration.c"
	}
	__finally579:
#line 277 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 277 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_g_object_unref0 (exceptions);
#line 277 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_g_object_unref0 (wallpaper_dir);
#line 277 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 277 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		g_clear_error (&_inner_error_);
#line 277 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		return;
#line 2710 "DesktopIntegration.c"
	}
#line 283 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	desktop_integration_desktop_slideshow_duration = duration;
#line 284 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	desktop_integration_desktop_slideshow_transition = transition;
#line 286 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp8_ = wallpaper_dir;
#line 286 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp9_ = app_window_get_instance ();
#line 286 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp10_ = _tmp9_;
#line 286 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	scaling_to_fill_screen (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_window_get_type (), GtkWindow), &_tmp11_);
#line 286 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	export_format_parameters_current (&_tmp12_);
#line 286 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp13_ = exporter_new (photos, _tmp8_, &_tmp11_, &_tmp12_, TRUE);
#line 286 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp14_ = _tmp13_;
#line 286 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_object_unref0 (_tmp10_);
#line 286 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	exporter = _tmp14_;
#line 289 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp15_ = exporter;
#line 289 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp16_ = exporter_ui_new (_tmp15_);
#line 289 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_exporter_ui_unref0 (desktop_integration_desktop_slideshow_exporter);
#line 289 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	desktop_integration_desktop_slideshow_exporter = _tmp16_;
#line 290 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp17_ = desktop_integration_desktop_slideshow_exporter;
#line 290 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	exporter_ui_export (_tmp17_, _desktop_integration_on_desktop_slideshow_exported_exporter_completion_callback, NULL);
#line 265 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_object_unref0 (exporter);
#line 265 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_object_unref0 (exceptions);
#line 265 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_object_unref0 (wallpaper_dir);
#line 2752 "DesktopIntegration.c"
}


void
desktop_integration_on_desktop_slideshow_exported (Exporter* exporter,
                                                   gboolean is_cancelled)
{
	GFile* xml_file = NULL;
	DesktopIntegrationBackgroundSlideshowXMLBuilder* xml_builder = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	gdouble _tmp4_;
	gdouble _tmp5_;
	DesktopIntegrationBackgroundSlideshowXMLBuilder* _tmp6_;
	DesktopIntegrationBackgroundSlideshowXMLBuilder* _tmp7_;
	gboolean _tmp22_;
	gboolean _tmp28_;
	GError * _inner_error_ = NULL;
#line 293 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	g_return_if_fail (IS_EXPORTER (exporter));
#line 294 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_exporter_ui_unref0 (desktop_integration_desktop_slideshow_exporter);
#line 294 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	desktop_integration_desktop_slideshow_exporter = NULL;
#line 296 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (is_cancelled) {
#line 297 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		return;
#line 2783 "DesktopIntegration.c"
	}
#line 299 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	xml_file = NULL;
#line 300 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp0_ = app_dirs_get_data_subdir ("wallpaper", NULL);
#line 300 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp1_ = _tmp0_;
#line 300 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp2_ = g_file_get_child (_tmp1_, DESKTOP_INTEGRATION_DESKTOP_SLIDESHOW_XML_FILENAME);
#line 300 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp3_ = _tmp2_;
#line 300 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp4_ = desktop_integration_desktop_slideshow_duration;
#line 300 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp5_ = desktop_integration_desktop_slideshow_transition;
#line 300 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp6_ = desktop_integration_background_slideshow_xml_builder_new (_tmp3_, _tmp4_, _tmp5_);
#line 300 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp7_ = _tmp6_;
#line 300 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_object_unref0 (_tmp3_);
#line 300 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_object_unref0 (_tmp1_);
#line 300 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	xml_builder = _tmp7_;
#line 2809 "DesktopIntegration.c"
	{
		DesktopIntegrationBackgroundSlideshowXMLBuilder* _tmp8_;
		gint _tmp9_;
		GFile** _tmp10_;
		GFile* _tmp14_ = NULL;
		DesktopIntegrationBackgroundSlideshowXMLBuilder* _tmp15_;
		GFile* _tmp16_;
		GFile* _tmp17_;
#line 304 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp8_ = xml_builder;
#line 304 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		desktop_integration_background_slideshow_xml_builder_open (_tmp8_, &_inner_error_);
#line 304 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2824 "DesktopIntegration.c"
			goto __catch580_g_error;
		}
#line 306 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp10_ = exporter_get_exported_files (exporter, &_tmp9_);
#line 2829 "DesktopIntegration.c"
		{
			GFile** file_collection = NULL;
			gint file_collection_length1 = 0;
			gint _file_collection_size_ = 0;
			gint file_it = 0;
#line 306 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
			file_collection = _tmp10_;
#line 306 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
			file_collection_length1 = _tmp9_;
#line 306 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
			for (file_it = 0; file_it < _tmp9_; file_it = file_it + 1) {
#line 2841 "DesktopIntegration.c"
				GFile* _tmp11_;
				GFile* file = NULL;
#line 306 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
				_tmp11_ = _g_object_ref0 (file_collection[file_it]);
#line 306 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
				file = _tmp11_;
#line 2848 "DesktopIntegration.c"
				{
					DesktopIntegrationBackgroundSlideshowXMLBuilder* _tmp12_;
					GFile* _tmp13_;
#line 307 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
					_tmp12_ = xml_builder;
#line 307 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
					_tmp13_ = file;
#line 307 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
					desktop_integration_background_slideshow_xml_builder_add_photo (_tmp12_, _tmp13_, &_inner_error_);
#line 307 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 307 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
						_g_object_unref0 (file);
#line 307 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
						file_collection = (_vala_array_free (file_collection, file_collection_length1, (GDestroyNotify) g_object_unref), NULL);
#line 2864 "DesktopIntegration.c"
						goto __catch580_g_error;
					}
#line 306 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
					_g_object_unref0 (file);
#line 2869 "DesktopIntegration.c"
				}
			}
#line 306 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
			file_collection = (_vala_array_free (file_collection, file_collection_length1, (GDestroyNotify) g_object_unref), NULL);
#line 2874 "DesktopIntegration.c"
		}
#line 309 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp15_ = xml_builder;
#line 309 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp16_ = desktop_integration_background_slideshow_xml_builder_close (_tmp15_, &_inner_error_);
#line 309 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp14_ = _tmp16_;
#line 309 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2884 "DesktopIntegration.c"
			goto __catch580_g_error;
		}
#line 309 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp17_ = _tmp14_;
#line 309 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp14_ = NULL;
#line 309 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_g_object_unref0 (xml_file);
#line 309 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		xml_file = _tmp17_;
#line 303 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_g_object_unref0 (_tmp14_);
#line 2897 "DesktopIntegration.c"
	}
	goto __finally580;
	__catch580_g_error:
	{
		GError* err = NULL;
		GError* _tmp18_;
		const gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
#line 303 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		err = _inner_error_;
#line 303 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_inner_error_ = NULL;
#line 311 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp18_ = err;
#line 311 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp19_ = _tmp18_->message;
#line 311 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp20_ = g_strdup_printf (_ ("Unable to prepare desktop slideshow: %s"), _tmp19_);
#line 311 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp21_ = _tmp20_;
#line 311 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		app_window_error_message (_tmp21_, NULL);
#line 311 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_g_free0 (_tmp21_);
#line 314 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_g_error_free0 (err);
#line 314 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_desktop_integration_background_slideshow_xml_builder_unref0 (xml_builder);
#line 314 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_g_object_unref0 (xml_file);
#line 314 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		return;
#line 2931 "DesktopIntegration.c"
	}
	__finally580:
#line 303 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 303 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_desktop_integration_background_slideshow_xml_builder_unref0 (xml_builder);
#line 303 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_g_object_unref0 (xml_file);
#line 303 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 303 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		g_clear_error (&_inner_error_);
#line 303 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		return;
#line 2946 "DesktopIntegration.c"
	}
#line 317 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp22_ = desktop_integration_set_desktop_background;
#line 317 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (_tmp22_) {
#line 2952 "DesktopIntegration.c"
		ConfigFacade* _tmp23_;
		ConfigFacade* _tmp24_;
		GFile* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
#line 318 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp23_ = config_facade_get_instance ();
#line 318 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp24_ = _tmp23_;
#line 318 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp25_ = xml_file;
#line 318 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp26_ = g_file_get_path (_tmp25_);
#line 318 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp27_ = _tmp26_;
#line 318 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		configuration_facade_set_desktop_background (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), _tmp27_);
#line 318 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_g_free0 (_tmp27_);
#line 318 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_g_object_unref0 (_tmp24_);
#line 2974 "DesktopIntegration.c"
	}
#line 320 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_tmp28_ = desktop_integration_set_screensaver;
#line 320 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	if (_tmp28_) {
#line 2980 "DesktopIntegration.c"
		ConfigFacade* _tmp29_;
		ConfigFacade* _tmp30_;
		GFile* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
#line 321 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp29_ = config_facade_get_instance ();
#line 321 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp30_ = _tmp29_;
#line 321 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp31_ = xml_file;
#line 321 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp32_ = g_file_get_path (_tmp31_);
#line 321 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_tmp33_ = _tmp32_;
#line 321 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		configuration_facade_set_screensaver (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), _tmp33_);
#line 321 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_g_free0 (_tmp33_);
#line 321 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
		_g_object_unref0 (_tmp30_);
#line 3002 "DesktopIntegration.c"
	}
#line 293 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_desktop_integration_background_slideshow_xml_builder_unref0 (xml_builder);
#line 293 "/home/jens/Source/shotwell/src/DesktopIntegration.vala"
	_g_object_unref0 (xml_file);
#line 3008 "DesktopIntegration.c"
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



