/* MetadataWriter.c generated by valac 0.40.4, the Vala compiler
 * generated from MetadataWriter.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */
/* MetadataWriter tracks LibraryPhotos for alterations to their metadata and commits those changes*/
/* in a timely manner to their backing files.  Because only the MetadataWriter knows when the*/
/* metadata has been properly committed, it is also responsible for updating the metadata-dirty*/
/* flag in Photo.  Thus, MetadataWriter should *always* be running, even if the user has turned off*/
/* the feature, so if they turn it on MetadataWriter can properly go out and update the backing*/
/* files.*/


#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <time.h>


#define TYPE_METADATA_WRITER (metadata_writer_get_type ())
#define METADATA_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_METADATA_WRITER, MetadataWriter))
#define METADATA_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_METADATA_WRITER, MetadataWriterClass))
#define IS_METADATA_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_METADATA_WRITER))
#define IS_METADATA_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_METADATA_WRITER))
#define METADATA_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_METADATA_WRITER, MetadataWriterClass))

typedef struct _MetadataWriter MetadataWriter;
typedef struct _MetadataWriterClass MetadataWriterClass;
typedef struct _MetadataWriterPrivate MetadataWriterPrivate;

#define TYPE_WORKERS (workers_get_type ())
#define WORKERS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WORKERS, Workers))
#define WORKERS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WORKERS, WorkersClass))
#define IS_WORKERS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WORKERS))
#define IS_WORKERS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WORKERS))
#define WORKERS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WORKERS, WorkersClass))

typedef struct _Workers Workers;
typedef struct _WorkersClass WorkersClass;

#define TYPE_TIMED_QUEUE (timed_queue_get_type ())
#define TIMED_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TIMED_QUEUE, TimedQueue))
#define TIMED_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TIMED_QUEUE, TimedQueueClass))
#define IS_TIMED_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TIMED_QUEUE))
#define IS_TIMED_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TIMED_QUEUE))
#define TIMED_QUEUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TIMED_QUEUE, TimedQueueClass))

typedef struct _TimedQueue TimedQueue;
typedef struct _TimedQueueClass TimedQueueClass;

#define TYPE_HASH_TIMED_QUEUE (hash_timed_queue_get_type ())
#define HASH_TIMED_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HASH_TIMED_QUEUE, HashTimedQueue))
#define HASH_TIMED_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HASH_TIMED_QUEUE, HashTimedQueueClass))
#define IS_HASH_TIMED_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HASH_TIMED_QUEUE))
#define IS_HASH_TIMED_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HASH_TIMED_QUEUE))
#define HASH_TIMED_QUEUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HASH_TIMED_QUEUE, HashTimedQueueClass))

typedef struct _HashTimedQueue HashTimedQueue;
typedef struct _HashTimedQueueClass HashTimedQueueClass;

#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;

#define TYPE_THUMBNAIL_SOURCE (thumbnail_source_get_type ())
#define THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSource))
#define THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))
#define IS_THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_SOURCE))
#define IS_THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_SOURCE))
#define THUMBNAIL_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))

typedef struct _ThumbnailSource ThumbnailSource;
typedef struct _ThumbnailSourceClass ThumbnailSourceClass;

#define TYPE_MEDIA_SOURCE (media_source_get_type ())
#define MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE, MediaSource))
#define MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE, MediaSourceClass))
#define IS_MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE))
#define IS_MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE))
#define MEDIA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE, MediaSourceClass))

typedef struct _MediaSource MediaSource;
typedef struct _MediaSourceClass MediaSourceClass;

#define TYPE_PHOTO_SOURCE (photo_source_get_type ())
#define PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_SOURCE, PhotoSource))
#define PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_SOURCE, PhotoSourceClass))
#define IS_PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_SOURCE))
#define IS_PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_SOURCE))
#define PHOTO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_SOURCE, PhotoSourceClass))

typedef struct _PhotoSource PhotoSource;
typedef struct _PhotoSourceClass PhotoSourceClass;

#define TYPE_PHOTO (photo_get_type ())
#define PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO, Photo))
#define PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO, PhotoClass))
#define IS_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO))
#define IS_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO))
#define PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO, PhotoClass))

typedef struct _Photo Photo;
typedef struct _PhotoClass PhotoClass;

#define TYPE_LIBRARY_PHOTO (library_photo_get_type ())
#define LIBRARY_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIBRARY_PHOTO, LibraryPhoto))
#define LIBRARY_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIBRARY_PHOTO, LibraryPhotoClass))
#define IS_LIBRARY_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIBRARY_PHOTO))
#define IS_LIBRARY_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIBRARY_PHOTO))
#define LIBRARY_PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIBRARY_PHOTO, LibraryPhotoClass))

typedef struct _LibraryPhoto LibraryPhoto;
typedef struct _LibraryPhotoClass LibraryPhotoClass;

#define TYPE_BACKGROUND_JOB (background_job_get_type ())
#define BACKGROUND_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKGROUND_JOB, BackgroundJob))
#define BACKGROUND_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKGROUND_JOB, BackgroundJobClass))
#define IS_BACKGROUND_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKGROUND_JOB))
#define IS_BACKGROUND_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKGROUND_JOB))
#define BACKGROUND_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKGROUND_JOB, BackgroundJobClass))

typedef struct _BackgroundJob BackgroundJob;
typedef struct _BackgroundJobClass BackgroundJobClass;

#define METADATA_WRITER_TYPE_COMMIT_JOB (metadata_writer_commit_job_get_type ())
#define METADATA_WRITER_COMMIT_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), METADATA_WRITER_TYPE_COMMIT_JOB, MetadataWriterCommitJob))
#define METADATA_WRITER_COMMIT_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), METADATA_WRITER_TYPE_COMMIT_JOB, MetadataWriterCommitJobClass))
#define METADATA_WRITER_IS_COMMIT_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), METADATA_WRITER_TYPE_COMMIT_JOB))
#define METADATA_WRITER_IS_COMMIT_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), METADATA_WRITER_TYPE_COMMIT_JOB))
#define METADATA_WRITER_COMMIT_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), METADATA_WRITER_TYPE_COMMIT_JOB, MetadataWriterCommitJobClass))

typedef struct _MetadataWriterCommitJob MetadataWriterCommitJob;
typedef struct _MetadataWriterCommitJobClass MetadataWriterCommitJobClass;
enum  {
	METADATA_WRITER_0_PROPERTY,
	METADATA_WRITER_NUM_PROPERTIES
};
static GParamSpec* metadata_writer_properties[METADATA_WRITER_NUM_PROPERTIES];

#define TYPE_CONFIGURATION_FACADE (configuration_facade_get_type ())
#define CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacade))
#define CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))
#define IS_CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONFIGURATION_FACADE))
#define IS_CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONFIGURATION_FACADE))
#define CONFIGURATION_FACADE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))

typedef struct _ConfigurationFacade ConfigurationFacade;
typedef struct _ConfigurationFacadeClass ConfigurationFacadeClass;

#define CONFIG_TYPE_FACADE (config_facade_get_type ())
#define CONFIG_FACADE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONFIG_TYPE_FACADE, ConfigFacade))
#define CONFIG_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONFIG_TYPE_FACADE, ConfigFacadeClass))
#define CONFIG_IS_FACADE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONFIG_TYPE_FACADE))
#define CONFIG_IS_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONFIG_TYPE_FACADE))
#define CONFIG_FACADE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONFIG_TYPE_FACADE, ConfigFacadeClass))

typedef struct _ConfigFacade ConfigFacade;
typedef struct _ConfigFacadeClass ConfigFacadeClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_DATA_COLLECTION (data_collection_get_type ())
#define DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_COLLECTION, DataCollection))
#define DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_COLLECTION, DataCollectionClass))
#define IS_DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_COLLECTION))
#define IS_DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_COLLECTION))
#define DATA_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_COLLECTION, DataCollectionClass))

typedef struct _DataCollection DataCollection;
typedef struct _DataCollectionClass DataCollectionClass;

#define TYPE_SOURCE_COLLECTION (source_collection_get_type ())
#define SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_COLLECTION, SourceCollection))
#define SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_COLLECTION, SourceCollectionClass))
#define IS_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_COLLECTION))
#define IS_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_COLLECTION))
#define SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_COLLECTION, SourceCollectionClass))

typedef struct _SourceCollection SourceCollection;
typedef struct _SourceCollectionClass SourceCollectionClass;

#define TYPE_DATABASE_SOURCE_COLLECTION (database_source_collection_get_type ())
#define DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollection))
#define DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))
#define IS_DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_SOURCE_COLLECTION))
#define IS_DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_SOURCE_COLLECTION))
#define DATABASE_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))

typedef struct _DatabaseSourceCollection DatabaseSourceCollection;
typedef struct _DatabaseSourceCollectionClass DatabaseSourceCollectionClass;

#define TYPE_MEDIA_SOURCE_COLLECTION (media_source_collection_get_type ())
#define MEDIA_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection))
#define MEDIA_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollectionClass))
#define IS_MEDIA_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE_COLLECTION))
#define IS_MEDIA_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE_COLLECTION))
#define MEDIA_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollectionClass))

typedef struct _MediaSourceCollection MediaSourceCollection;
typedef struct _MediaSourceCollectionClass MediaSourceCollectionClass;

#define TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION (library_photo_source_collection_get_type ())
#define LIBRARY_PHOTO_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION, LibraryPhotoSourceCollection))
#define LIBRARY_PHOTO_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION, LibraryPhotoSourceCollectionClass))
#define IS_LIBRARY_PHOTO_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION))
#define IS_LIBRARY_PHOTO_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION))
#define LIBRARY_PHOTO_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION, LibraryPhotoSourceCollectionClass))

typedef struct _LibraryPhotoSourceCollection LibraryPhotoSourceCollection;
typedef struct _LibraryPhotoSourceCollectionClass LibraryPhotoSourceCollectionClass;

#define TYPE_ALTERATION (alteration_get_type ())
#define ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ALTERATION, Alteration))
#define ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ALTERATION, AlterationClass))
#define IS_ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ALTERATION))
#define IS_ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ALTERATION))
#define ALTERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ALTERATION, AlterationClass))

typedef struct _Alteration Alteration;
typedef struct _AlterationClass AlterationClass;

#define TYPE_CONTAINER_SOURCE_COLLECTION (container_source_collection_get_type ())
#define CONTAINER_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollection))
#define CONTAINER_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollectionClass))
#define IS_CONTAINER_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONTAINER_SOURCE_COLLECTION))
#define IS_CONTAINER_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONTAINER_SOURCE_COLLECTION))
#define CONTAINER_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollectionClass))

typedef struct _ContainerSourceCollection ContainerSourceCollection;
typedef struct _ContainerSourceCollectionClass ContainerSourceCollectionClass;

#define TYPE_TAG_SOURCE_COLLECTION (tag_source_collection_get_type ())
#define TAG_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAG_SOURCE_COLLECTION, TagSourceCollection))
#define TAG_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAG_SOURCE_COLLECTION, TagSourceCollectionClass))
#define IS_TAG_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAG_SOURCE_COLLECTION))
#define IS_TAG_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAG_SOURCE_COLLECTION))
#define TAG_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAG_SOURCE_COLLECTION, TagSourceCollectionClass))

typedef struct _TagSourceCollection TagSourceCollection;
typedef struct _TagSourceCollectionClass TagSourceCollectionClass;

#define TYPE_CONTAINER_SOURCE (container_source_get_type ())
#define CONTAINER_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONTAINER_SOURCE, ContainerSource))
#define IS_CONTAINER_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONTAINER_SOURCE))
#define CONTAINER_SOURCE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_CONTAINER_SOURCE, ContainerSourceIface))

typedef struct _ContainerSource ContainerSource;
typedef struct _ContainerSourceIface ContainerSourceIface;

#define TYPE_SOURCE_BACKLINK (source_backlink_get_type ())
#define SOURCE_BACKLINK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_BACKLINK, SourceBacklink))
#define SOURCE_BACKLINK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_BACKLINK, SourceBacklinkClass))
#define IS_SOURCE_BACKLINK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_BACKLINK))
#define IS_SOURCE_BACKLINK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_BACKLINK))
#define SOURCE_BACKLINK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_BACKLINK, SourceBacklinkClass))

typedef struct _SourceBacklink SourceBacklink;
typedef struct _SourceBacklinkClass SourceBacklinkClass;

#define TYPE_APPLICATION (application_get_type ())
#define APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APPLICATION, Application))
#define APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APPLICATION, ApplicationClass))
#define IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APPLICATION))
#define IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APPLICATION))
#define APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APPLICATION, ApplicationClass))

typedef struct _Application Application;
typedef struct _ApplicationClass ApplicationClass;
#define _application_unref0(var) ((var == NULL) ? NULL : (var = (application_unref (var), NULL)))

#define TYPE_LIBRARY_MONITOR_POOL (library_monitor_pool_get_type ())
#define LIBRARY_MONITOR_POOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIBRARY_MONITOR_POOL, LibraryMonitorPool))
#define LIBRARY_MONITOR_POOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIBRARY_MONITOR_POOL, LibraryMonitorPoolClass))
#define IS_LIBRARY_MONITOR_POOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIBRARY_MONITOR_POOL))
#define IS_LIBRARY_MONITOR_POOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIBRARY_MONITOR_POOL))
#define LIBRARY_MONITOR_POOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIBRARY_MONITOR_POOL, LibraryMonitorPoolClass))

typedef struct _LibraryMonitorPool LibraryMonitorPool;
typedef struct _LibraryMonitorPoolClass LibraryMonitorPoolClass;

#define TYPE_DIRECTORY_MONITOR (directory_monitor_get_type ())
#define DIRECTORY_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DIRECTORY_MONITOR, DirectoryMonitor))
#define DIRECTORY_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DIRECTORY_MONITOR, DirectoryMonitorClass))
#define IS_DIRECTORY_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DIRECTORY_MONITOR))
#define IS_DIRECTORY_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DIRECTORY_MONITOR))
#define DIRECTORY_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DIRECTORY_MONITOR, DirectoryMonitorClass))

typedef struct _DirectoryMonitor DirectoryMonitor;
typedef struct _DirectoryMonitorClass DirectoryMonitorClass;

#define TYPE_LIBRARY_MONITOR (library_monitor_get_type ())
#define LIBRARY_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIBRARY_MONITOR, LibraryMonitor))
#define LIBRARY_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIBRARY_MONITOR, LibraryMonitorClass))
#define IS_LIBRARY_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIBRARY_MONITOR))
#define IS_LIBRARY_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIBRARY_MONITOR))
#define LIBRARY_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIBRARY_MONITOR, LibraryMonitorClass))

typedef struct _LibraryMonitor LibraryMonitor;
typedef struct _LibraryMonitorClass LibraryMonitorClass;
#define _library_monitor_pool_unref0(var) ((var == NULL) ? NULL : (var = (library_monitor_pool_unref (var), NULL)))
#define _workers_unref0(var) ((var == NULL) ? NULL : (var = (workers_unref (var), NULL)))
#define _timed_queue_unref0(var) ((var == NULL) ? NULL : (var = (timed_queue_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _alteration_unref0(var) ((var == NULL) ? NULL : (var = (alteration_unref (var), NULL)))

#define TYPE_TAG (tag_get_type ())
#define TAG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAG, Tag))
#define TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAG, TagClass))
#define IS_TAG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAG))
#define IS_TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAG))
#define TAG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAG, TagClass))

typedef struct _Tag Tag;
typedef struct _TagClass TagClass;

#define TYPE_TRANSACTION_CONTROLLER (transaction_controller_get_type ())
#define TRANSACTION_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TRANSACTION_CONTROLLER, TransactionController))
#define TRANSACTION_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TRANSACTION_CONTROLLER, TransactionControllerClass))
#define IS_TRANSACTION_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TRANSACTION_CONTROLLER))
#define IS_TRANSACTION_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TRANSACTION_CONTROLLER))
#define TRANSACTION_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TRANSACTION_CONTROLLER, TransactionControllerClass))

typedef struct _TransactionController TransactionController;
typedef struct _TransactionControllerClass TransactionControllerClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _background_job_unref0(var) ((var == NULL) ? NULL : (var = (background_job_unref (var), NULL)))
typedef struct _BackgroundJobPrivate BackgroundJobPrivate;

#define BACKGROUND_JOB_TYPE_JOB_PRIORITY (background_job_job_priority_get_type ())
typedef struct _MetadataWriterCommitJobPrivate MetadataWriterCommitJobPrivate;

#define PHOTO_TYPE_REIMPORT_MASTER_STATE (photo_reimport_master_state_get_type ())
#define PHOTO_REIMPORT_MASTER_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PHOTO_TYPE_REIMPORT_MASTER_STATE, PhotoReimportMasterState))
#define PHOTO_REIMPORT_MASTER_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PHOTO_TYPE_REIMPORT_MASTER_STATE, PhotoReimportMasterStateClass))
#define PHOTO_IS_REIMPORT_MASTER_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PHOTO_TYPE_REIMPORT_MASTER_STATE))
#define PHOTO_IS_REIMPORT_MASTER_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PHOTO_TYPE_REIMPORT_MASTER_STATE))
#define PHOTO_REIMPORT_MASTER_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PHOTO_TYPE_REIMPORT_MASTER_STATE, PhotoReimportMasterStateClass))

typedef struct _PhotoReimportMasterState PhotoReimportMasterState;
typedef struct _PhotoReimportMasterStateClass PhotoReimportMasterStateClass;

#define PHOTO_TYPE_REIMPORT_EDITABLE_STATE (photo_reimport_editable_state_get_type ())
#define PHOTO_REIMPORT_EDITABLE_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PHOTO_TYPE_REIMPORT_EDITABLE_STATE, PhotoReimportEditableState))
#define PHOTO_REIMPORT_EDITABLE_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PHOTO_TYPE_REIMPORT_EDITABLE_STATE, PhotoReimportEditableStateClass))
#define PHOTO_IS_REIMPORT_EDITABLE_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PHOTO_TYPE_REIMPORT_EDITABLE_STATE))
#define PHOTO_IS_REIMPORT_EDITABLE_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PHOTO_TYPE_REIMPORT_EDITABLE_STATE))
#define PHOTO_REIMPORT_EDITABLE_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PHOTO_TYPE_REIMPORT_EDITABLE_STATE, PhotoReimportEditableStateClass))

typedef struct _PhotoReimportEditableState PhotoReimportEditableState;
typedef struct _PhotoReimportEditableStateClass PhotoReimportEditableStateClass;
#define _photo_reimport_master_state_unref0(var) ((var == NULL) ? NULL : (var = (photo_reimport_master_state_unref (var), NULL)))
#define _photo_reimport_editable_state_unref0(var) ((var == NULL) ? NULL : (var = (photo_reimport_editable_state_unref (var), NULL)))

#define TYPE_ABSTRACT_SEMAPHORE (abstract_semaphore_get_type ())
#define ABSTRACT_SEMAPHORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ABSTRACT_SEMAPHORE, AbstractSemaphore))
#define ABSTRACT_SEMAPHORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ABSTRACT_SEMAPHORE, AbstractSemaphoreClass))
#define IS_ABSTRACT_SEMAPHORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ABSTRACT_SEMAPHORE))
#define IS_ABSTRACT_SEMAPHORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ABSTRACT_SEMAPHORE))
#define ABSTRACT_SEMAPHORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ABSTRACT_SEMAPHORE, AbstractSemaphoreClass))

typedef struct _AbstractSemaphore AbstractSemaphore;
typedef struct _AbstractSemaphoreClass AbstractSemaphoreClass;

#define TYPE_PHOTO_FILE_FORMAT (photo_file_format_get_type ())

#define TYPE_MEDIA_METADATA (media_metadata_get_type ())
#define MEDIA_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_METADATA, MediaMetadata))
#define MEDIA_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_METADATA, MediaMetadataClass))
#define IS_MEDIA_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_METADATA))
#define IS_MEDIA_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_METADATA))
#define MEDIA_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_METADATA, MediaMetadataClass))

typedef struct _MediaMetadata MediaMetadata;
typedef struct _MediaMetadataClass MediaMetadataClass;

#define TYPE_PHOTO_METADATA (photo_metadata_get_type ())
#define PHOTO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_METADATA, PhotoMetadata))
#define PHOTO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_METADATA, PhotoMetadataClass))
#define IS_PHOTO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_METADATA))
#define IS_PHOTO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_METADATA))
#define PHOTO_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_METADATA, PhotoMetadataClass))

typedef struct _PhotoMetadata PhotoMetadata;
typedef struct _PhotoMetadataClass PhotoMetadataClass;
#define _media_metadata_unref0(var) ((var == NULL) ? NULL : (var = (media_metadata_unref (var), NULL)))

#define PHOTO_METADATA_TYPE_SET_OPTION (photo_metadata_set_option_get_type ())

#define TYPE_RATING (rating_get_type ())

#define TYPE_METADATA_DATE_TIME (metadata_date_time_get_type ())
#define METADATA_DATE_TIME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_METADATA_DATE_TIME, MetadataDateTime))
#define METADATA_DATE_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_METADATA_DATE_TIME, MetadataDateTimeClass))
#define IS_METADATA_DATE_TIME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_METADATA_DATE_TIME))
#define IS_METADATA_DATE_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_METADATA_DATE_TIME))
#define METADATA_DATE_TIME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_METADATA_DATE_TIME, MetadataDateTimeClass))

typedef struct _MetadataDateTime MetadataDateTime;
typedef struct _MetadataDateTimeClass MetadataDateTimeClass;
#define _metadata_date_time_unref0(var) ((var == NULL) ? NULL : (var = (metadata_date_time_unref (var), NULL)))

#define TYPE_ORIENTATION (orientation_get_type ())
enum  {
	METADATA_WRITER_PROGRESS_SIGNAL,
	METADATA_WRITER_NUM_SIGNALS
};
static guint metadata_writer_signals[METADATA_WRITER_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _MetadataWriter {
	GObject parent_instance;
	MetadataWriterPrivate * priv;
};

struct _MetadataWriterClass {
	GObjectClass parent_class;
};

struct _MetadataWriterPrivate {
	Workers* workers;
	gboolean enabled;
	HashTimedQueue* dirty;
	GeeHashMap* pending;
	GeeHashSet* pending_cancel;
	GeeHashSet* interested_photo_details;
	LibraryPhoto* ignore_photo_alteration;
	guint outstanding_total;
	guint outstanding_completed;
	gboolean closed;
	gint pause_count;
	GeeHashSet* importing_photos;
};

struct _ContainerSourceIface {
	GTypeInterface parent_iface;
	gboolean (*has_links) (ContainerSource* self);
	SourceBacklink* (*get_backlink) (ContainerSource* self);
	void (*break_link) (ContainerSource* self, DataSource* source);
	void (*break_link_many) (ContainerSource* self, GeeCollection* sources);
	void (*establish_link) (ContainerSource* self, DataSource* source);
	void (*establish_link_many) (ContainerSource* self, GeeCollection* sources);
};

typedef void (*DequeuedCallback) (gconstpointer item, void* user_data);
typedef enum  {
	DATABASE_ERROR_ERROR,
	DATABASE_ERROR_BACKING,
	DATABASE_ERROR_MEMORY,
	DATABASE_ERROR_ABORT,
	DATABASE_ERROR_LIMITS,
	DATABASE_ERROR_TYPESPEC
} DatabaseError;
#define DATABASE_ERROR database_error_quark ()
typedef enum  {
	BACKGROUND_JOB_JOB_PRIORITY_HIGHEST = 100,
	BACKGROUND_JOB_JOB_PRIORITY_HIGH = 75,
	BACKGROUND_JOB_JOB_PRIORITY_NORMAL = 50,
	BACKGROUND_JOB_JOB_PRIORITY_LOW = 25,
	BACKGROUND_JOB_JOB_PRIORITY_LOWEST = 0
} BackgroundJobJobPriority;

struct _BackgroundJob {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BackgroundJobPrivate * priv;
};

struct _BackgroundJobClass {
	GTypeClass parent_class;
	void (*finalize) (BackgroundJob *self);
	void (*execute) (BackgroundJob* self);
	BackgroundJobJobPriority (*get_priority) (BackgroundJob* self);
};

struct _MetadataWriterCommitJob {
	BackgroundJob parent_instance;
	MetadataWriterCommitJobPrivate * priv;
	LibraryPhoto* photo;
	GeeSet* current_keywords;
	PhotoReimportMasterState* reimport_master_state;
	PhotoReimportEditableState* reimport_editable_state;
	GError* err;
	gboolean wrote_master;
	gboolean wrote_editable;
};

struct _MetadataWriterCommitJobClass {
	BackgroundJobClass parent_class;
};

typedef void (*CompletionCallback) (BackgroundJob* job, void* user_data);
typedef void (*CancellationCallback) (BackgroundJob* job, void* user_data);
typedef enum  {
	PHOTO_FILE_FORMAT_JFIF,
	PHOTO_FILE_FORMAT_RAW,
	PHOTO_FILE_FORMAT_PNG,
	PHOTO_FILE_FORMAT_TIFF,
	PHOTO_FILE_FORMAT_BMP,
	PHOTO_FILE_FORMAT_UNKNOWN
} PhotoFileFormat;

typedef enum  {
	PHOTO_METADATA_SET_OPTION_ALL_DOMAINS,
	PHOTO_METADATA_SET_OPTION_ONLY_IF_DOMAIN_PRESENT,
	PHOTO_METADATA_SET_OPTION_AT_LEAST_DEFAULT_DOMAIN
} PhotoMetadataSetOption;

typedef enum  {
	RATING_REJECTED = -1,
	RATING_UNRATED = 0,
	RATING_ONE = 1,
	RATING_TWO = 2,
	RATING_THREE = 3,
	RATING_FOUR = 4,
	RATING_FIVE = 5
} Rating;

typedef enum  {
	ORIENTATION_MIN = 1,
	ORIENTATION_TOP_LEFT = 1,
	ORIENTATION_TOP_RIGHT = 2,
	ORIENTATION_BOTTOM_RIGHT = 3,
	ORIENTATION_BOTTOM_LEFT = 4,
	ORIENTATION_LEFT_TOP = 5,
	ORIENTATION_RIGHT_TOP = 6,
	ORIENTATION_RIGHT_BOTTOM = 7,
	ORIENTATION_LEFT_BOTTOM = 8,
	ORIENTATION_MAX = 8
} Orientation;


static gpointer metadata_writer_parent_class = NULL;
extern LibraryPhotoSourceCollection* library_photo_global;
extern TagSourceCollection* tag_global;
static MetadataWriter* metadata_writer_instance;
static MetadataWriter* metadata_writer_instance = NULL;
static gpointer metadata_writer_commit_job_parent_class = NULL;

GType metadata_writer_get_type (void) G_GNUC_CONST;
gpointer workers_ref (gpointer instance);
void workers_unref (gpointer instance);
GParamSpec* param_spec_workers (const gchar* name,
                                const gchar* nick,
                                const gchar* blurb,
                                GType object_type,
                                GParamFlags flags);
void value_set_workers (GValue* value,
                        gpointer v_object);
void value_take_workers (GValue* value,
                         gpointer v_object);
gpointer value_get_workers (const GValue* value);
GType workers_get_type (void) G_GNUC_CONST;
gpointer timed_queue_ref (gpointer instance);
void timed_queue_unref (gpointer instance);
GParamSpec* param_spec_timed_queue (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags);
void value_set_timed_queue (GValue* value,
                            gpointer v_object);
void value_take_timed_queue (GValue* value,
                             gpointer v_object);
gpointer value_get_timed_queue (const GValue* value);
GType timed_queue_get_type (void) G_GNUC_CONST;
GType hash_timed_queue_get_type (void) G_GNUC_CONST;
GType data_object_get_type (void) G_GNUC_CONST;
GType data_source_get_type (void) G_GNUC_CONST;
GType thumbnail_source_get_type (void) G_GNUC_CONST;
GType media_source_get_type (void) G_GNUC_CONST;
GType photo_source_get_type (void) G_GNUC_CONST;
GType photo_get_type (void) G_GNUC_CONST;
GType library_photo_get_type (void) G_GNUC_CONST;
gpointer background_job_ref (gpointer instance);
void background_job_unref (gpointer instance);
GParamSpec* param_spec_background_job (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
void value_set_background_job (GValue* value,
                               gpointer v_object);
void value_take_background_job (GValue* value,
                                gpointer v_object);
gpointer value_get_background_job (const GValue* value);
GType background_job_get_type (void) G_GNUC_CONST;
static GType metadata_writer_commit_job_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define METADATA_WRITER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_METADATA_WRITER, MetadataWriterPrivate))
GType configuration_facade_get_type (void) G_GNUC_CONST;
GType config_facade_get_type (void) G_GNUC_CONST;
ConfigFacade* config_facade_get_instance (void);
static void metadata_writer_on_config_changed (MetadataWriter* self);
static void _metadata_writer_on_config_changed_configuration_facade_commit_metadata_to_masters_changed (ConfigurationFacade* _sender,
                                                                                                 gpointer self);
gpointer data_collection_ref (gpointer instance);
void data_collection_unref (gpointer instance);
GParamSpec* param_spec_data_collection (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
void value_set_data_collection (GValue* value,
                                gpointer v_object);
void value_take_data_collection (GValue* value,
                                 gpointer v_object);
gpointer value_get_data_collection (const GValue* value);
GType data_collection_get_type (void) G_GNUC_CONST;
GType source_collection_get_type (void) G_GNUC_CONST;
GType database_source_collection_get_type (void) G_GNUC_CONST;
GType media_source_collection_get_type (void) G_GNUC_CONST;
GType library_photo_source_collection_get_type (void) G_GNUC_CONST;
static void metadata_writer_on_importing_photos (MetadataWriter* self,
                                          GeeCollection* media_sources);
static void _metadata_writer_on_importing_photos_media_source_collection_media_import_starting (MediaSourceCollection* _sender,
                                                                                         GeeCollection* media,
                                                                                         gpointer self);
static void metadata_writer_on_photos_imported (MetadataWriter* self,
                                         GeeCollection* media_sources);
static void _metadata_writer_on_photos_imported_media_source_collection_media_import_completed (MediaSourceCollection* _sender,
                                                                                         GeeCollection* media,
                                                                                         gpointer self);
static void metadata_writer_on_photos_added_removed (MetadataWriter* self,
                                              GeeIterable* added,
                                              GeeIterable* removed);
static void _metadata_writer_on_photos_added_removed_data_collection_contents_altered (DataCollection* _sender,
                                                                                GeeIterable* added,
                                                                                GeeIterable* removed,
                                                                                gpointer self);
gpointer alteration_ref (gpointer instance);
void alteration_unref (gpointer instance);
GParamSpec* param_spec_alteration (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags);
void value_set_alteration (GValue* value,
                           gpointer v_object);
void value_take_alteration (GValue* value,
                            gpointer v_object);
gpointer value_get_alteration (const GValue* value);
GType alteration_get_type (void) G_GNUC_CONST;
static void metadata_writer_on_photos_altered (MetadataWriter* self,
                                        GeeMap* items);
static void _metadata_writer_on_photos_altered_data_collection_items_altered (DataCollection* _sender,
                                                                       GeeMap* items,
                                                                       gpointer self);
static void metadata_writer_on_collection_frozen (MetadataWriter* self);
static void _metadata_writer_on_collection_frozen_data_collection_frozen (DataCollection* _sender,
                                                                   gpointer self);
static void metadata_writer_on_collection_thawed (MetadataWriter* self);
static void _metadata_writer_on_collection_thawed_data_collection_thawed (DataCollection* _sender,
                                                                   gpointer self);
static void metadata_writer_on_photos_destroyed (MetadataWriter* self,
                                          GeeCollection* destroyed);
static void _metadata_writer_on_photos_destroyed_source_collection_items_destroyed (SourceCollection* _sender,
                                                                             GeeCollection* destroyed,
                                                                             gpointer self);
GType container_source_collection_get_type (void) G_GNUC_CONST;
GType tag_source_collection_get_type (void) G_GNUC_CONST;
static void metadata_writer_on_tags_altered (MetadataWriter* self,
                                      GeeMap* map);
static void _metadata_writer_on_tags_altered_data_collection_items_altered (DataCollection* _sender,
                                                                     GeeMap* items,
                                                                     gpointer self);
gpointer source_backlink_ref (gpointer instance);
void source_backlink_unref (gpointer instance);
GParamSpec* param_spec_source_backlink (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
void value_set_source_backlink (GValue* value,
                                gpointer v_object);
void value_take_source_backlink (GValue* value,
                                 gpointer v_object);
gpointer value_get_source_backlink (const GValue* value);
GType source_backlink_get_type (void) G_GNUC_CONST;
GType container_source_get_type (void) G_GNUC_CONST;
static void metadata_writer_on_tag_contents_altered (MetadataWriter* self,
                                              ContainerSource* container,
                                              GeeCollection* added,
                                              gboolean relinking,
                                              GeeCollection* removed,
                                              gboolean unlinking);
static void _metadata_writer_on_tag_contents_altered_container_source_collection_container_contents_altered (ContainerSourceCollection* _sender,
                                                                                                      ContainerSource* container,
                                                                                                      GeeCollection* added,
                                                                                                      gboolean relinked,
                                                                                                      GeeCollection* removed,
                                                                                                      gboolean unlinked,
                                                                                                      gpointer self);
static void metadata_writer_on_tag_backlink_removed (MetadataWriter* self,
                                              ContainerSource* container,
                                              GeeCollection* sources);
static void _metadata_writer_on_tag_backlink_removed_container_source_collection_backlink_to_container_removed (ContainerSourceCollection* _sender,
                                                                                                         ContainerSource* container,
                                                                                                         GeeCollection* sources,
                                                                                                         gpointer self);
gpointer application_ref (gpointer instance);
void application_unref (gpointer instance);
GParamSpec* param_spec_application (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags);
void value_set_application (GValue* value,
                            gpointer v_object);
void value_take_application (GValue* value,
                             gpointer v_object);
gpointer value_get_application (const GValue* value);
GType application_get_type (void) G_GNUC_CONST;
Application* application_get_instance (void);
static void metadata_writer_on_application_exiting (MetadataWriter* self);
static void _metadata_writer_on_application_exiting_application_exiting (Application* _sender,
                                                                  gboolean panicked,
                                                                  gpointer self);
gpointer library_monitor_pool_ref (gpointer instance);
void library_monitor_pool_unref (gpointer instance);
GParamSpec* param_spec_library_monitor_pool (const gchar* name,
                                             const gchar* nick,
                                             const gchar* blurb,
                                             GType object_type,
                                             GParamFlags flags);
void value_set_library_monitor_pool (GValue* value,
                                     gpointer v_object);
void value_take_library_monitor_pool (GValue* value,
                                      gpointer v_object);
gpointer value_get_library_monitor_pool (const GValue* value);
GType library_monitor_pool_get_type (void) G_GNUC_CONST;
LibraryMonitorPool* library_monitor_pool_get_instance (void);
GType directory_monitor_get_type (void) G_GNUC_CONST;
GType library_monitor_get_type (void) G_GNUC_CONST;
static void metadata_writer_on_monitor_installed (MetadataWriter* self,
                                           LibraryMonitor* monitor);
static void _metadata_writer_on_monitor_installed_library_monitor_pool_monitor_installed (LibraryMonitorPool* _sender,
                                                                                   LibraryMonitor* monitor,
                                                                                   gpointer self);
static void metadata_writer_on_monitor_destroyed (MetadataWriter* self,
                                           LibraryMonitor* monitor);
static void _metadata_writer_on_monitor_destroyed_library_monitor_pool_monitor_destroyed (LibraryMonitorPool* _sender,
                                                                                   LibraryMonitor* monitor,
                                                                                   gpointer self);
Workers* workers_new (guint max_threads,
                      gboolean exclusive);
Workers* workers_construct (GType object_type,
                            guint max_threads,
                            gboolean exclusive);
#define METADATA_WRITER_COMMIT_DELAY_MSEC ((guint) 3000)
#define METADATA_WRITER_COMMIT_SPACING_MSEC ((guint) 50)
static MetadataWriter* metadata_writer_new (void);
static MetadataWriter* metadata_writer_construct (GType object_type);
static void metadata_writer_on_photo_dequeued (MetadataWriter* self,
                                        LibraryPhoto* photo);
static void _metadata_writer_on_photo_dequeued_dequeued_callback (gconstpointer item,
                                                           gpointer self);
HashTimedQueue* hash_timed_queue_new (GType g_type,
                                      GBoxedCopyFunc g_dup_func,
                                      GDestroyNotify g_destroy_func,
                                      guint hold_msec,
                                      DequeuedCallback callback,
                                      void* callback_target,
                                      GeeHashDataFunc hash_func,
                                      void* hash_func_target,
                                      GDestroyNotify hash_func_target_destroy_notify,
                                      GeeEqualDataFunc equal_func,
                                      void* equal_func_target,
                                      GDestroyNotify equal_func_target_destroy_notify,
                                      gint priority);
HashTimedQueue* hash_timed_queue_construct (GType object_type,
                                            GType g_type,
                                            GBoxedCopyFunc g_dup_func,
                                            GDestroyNotify g_destroy_func,
                                            guint hold_msec,
                                            DequeuedCallback callback,
                                            void* callback_target,
                                            GeeHashDataFunc hash_func,
                                            void* hash_func_target,
                                            GDestroyNotify hash_func_target_destroy_notify,
                                            GeeEqualDataFunc equal_func,
                                            void* equal_func_target,
                                            GDestroyNotify equal_func_target_destroy_notify,
                                            gint priority);
void timed_queue_set_dequeue_spacing_msec (TimedQueue* self,
                                           guint msec);
void metadata_writer_pause (MetadataWriter* self);
gboolean configuration_facade_get_commit_metadata_to_masters (ConfigurationFacade* self);
void metadata_writer_force_rescan (MetadataWriter* self);
void metadata_writer_init (void);
void metadata_writer_terminate (void);
void metadata_writer_close (MetadataWriter* self);
MetadataWriter* metadata_writer_get_instance (void);
static void metadata_writer_schedule_if_dirty (MetadataWriter* self,
                                        GeeIterable* media_sources,
                                        const gchar* reason);
GeeCollection* data_collection_get_all (DataCollection* self);
void timed_queue_pause (TimedQueue* self);
void metadata_writer_unpause (MetadataWriter* self);
void timed_queue_unpause (TimedQueue* self);
static void metadata_writer_cancel_all (MetadataWriter* self,
                                 gboolean wait);
static void metadata_writer_on_discovery_completed (MetadataWriter* self);
static void _metadata_writer_on_discovery_completed_directory_monitor_discovery_completed (DirectoryMonitor* _sender,
                                                                                    gpointer self);
static gboolean metadata_writer_cancel_job (MetadataWriter* self,
                                     LibraryPhoto* photo);
gboolean alteration_has_detail (Alteration* self,
                                const gchar* subject,
                                const gchar* detail);
GeeCollection* alteration_get_details (Alteration* self,
                                       const gchar* subject);
static void metadata_writer_photos_are_dirty (MetadataWriter* self,
                                       GeeCollection* photos,
                                       const gchar* reason,
                                       gboolean already_marked);
GType tag_get_type (void) G_GNUC_CONST;
GeeCollection* tag_get_sources (Tag* self);
gchar* data_object_to_string (DataObject* self);
static void metadata_writer_count_enqueued_work (MetadataWriter* self,
                                          gint count,
                                          gboolean report);
static void metadata_writer_count_cancelled_work (MetadataWriter* self,
                                           gint count,
                                           gboolean report);
static void metadata_writer_count_completed_work (MetadataWriter* self,
                                           gint count,
                                           gboolean report);
gboolean photo_is_master_metadata_dirty (Photo* self);
gpointer transaction_controller_ref (gpointer instance);
void transaction_controller_unref (gpointer instance);
GParamSpec* param_spec_transaction_controller (const gchar* name,
                                               const gchar* nick,
                                               const gchar* blurb,
                                               GType object_type,
                                               GParamFlags flags);
void value_set_transaction_controller (GValue* value,
                                       gpointer v_object);
void value_take_transaction_controller (GValue* value,
                                        gpointer v_object);
gpointer value_get_transaction_controller (const GValue* value);
GType transaction_controller_get_type (void) G_GNUC_CONST;
TransactionController* media_source_collection_get_transaction_controller (MediaSourceCollection* self);
void transaction_controller_begin (TransactionController* self);
GQuark database_error_quark (void);
void photo_set_master_metadata_dirty (Photo* self,
                                      gboolean dirty,
                                      GError** error);
void transaction_controller_commit (TransactionController* self);
void app_window_database_error (GError* err);
gboolean timed_queue_enqueue (TimedQueue* self,
                              gconstpointer item);
void timed_queue_clear (TimedQueue* self);
void background_job_cancel (BackgroundJob* self);
void workers_wait_for_empty_queue (Workers* self);
gboolean timed_queue_contains (TimedQueue* self,
                               gconstpointer item);
gboolean timed_queue_remove_first (TimedQueue* self,
                                   gconstpointer item);
GeeList* tag_source_collection_fetch_for_source (TagSourceCollection* self,
                                                 MediaSource* source);
gchar* data_object_get_name (DataObject* self);
static MetadataWriterCommitJob* metadata_writer_commit_job_new (MetadataWriter* owner,
                                                         LibraryPhoto* photo,
                                                         GeeSet* keywords);
static MetadataWriterCommitJob* metadata_writer_commit_job_construct (GType object_type,
                                                               MetadataWriter* owner,
                                                               LibraryPhoto* photo,
                                                               GeeSet* keywords);
void workers_enqueue (Workers* self,
                      BackgroundJob* job);
static void metadata_writer_on_update_completed (MetadataWriter* self,
                                          BackgroundJob* j);
GType background_job_job_priority_get_type (void) G_GNUC_CONST;
gpointer photo_reimport_master_state_ref (gpointer instance);
void photo_reimport_master_state_unref (gpointer instance);
GParamSpec* photo_param_spec_reimport_master_state (const gchar* name,
                                                    const gchar* nick,
                                                    const gchar* blurb,
                                                    GType object_type,
                                                    GParamFlags flags);
void photo_value_set_reimport_master_state (GValue* value,
                                            gpointer v_object);
void photo_value_take_reimport_master_state (GValue* value,
                                             gpointer v_object);
gpointer photo_value_get_reimport_master_state (const GValue* value);
GType photo_reimport_master_state_get_type (void) G_GNUC_CONST;
gpointer photo_reimport_editable_state_ref (gpointer instance);
void photo_reimport_editable_state_unref (gpointer instance);
GParamSpec* photo_param_spec_reimport_editable_state (const gchar* name,
                                                      const gchar* nick,
                                                      const gchar* blurb,
                                                      GType object_type,
                                                      GParamFlags flags);
void photo_value_set_reimport_editable_state (GValue* value,
                                              gpointer v_object);
void photo_value_take_reimport_editable_state (GValue* value,
                                               gpointer v_object);
gpointer photo_value_get_reimport_editable_state (const GValue* value);
GType photo_reimport_editable_state_get_type (void) G_GNUC_CONST;
GFile* media_source_get_master_file (MediaSource* self);
GFile* photo_get_editable_file (Photo* self);
void photo_finish_update_master_metadata (Photo* self,
                                          PhotoReimportMasterState* state,
                                          GError** error);
void photo_finish_update_editable_metadata (Photo* self,
                                            PhotoReimportEditableState* state,
                                            GError** error);
static void metadata_writer_on_update_cancelled (MetadataWriter* self,
                                          BackgroundJob* j);
static void g_cclosure_user_marshal_VOID__UINT_UINT (GClosure * closure,
                                              GValue * return_value,
                                              guint n_param_values,
                                              const GValue * param_values,
                                              gpointer invocation_hint,
                                              gpointer marshal_data);
static void _metadata_writer_on_update_completed_completion_callback (BackgroundJob* job,
                                                               gpointer self);
static void _metadata_writer_on_update_cancelled_cancellation_callback (BackgroundJob* job,
                                                                 gpointer self);
gpointer abstract_semaphore_ref (gpointer instance);
void abstract_semaphore_unref (gpointer instance);
GParamSpec* param_spec_abstract_semaphore (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags);
void value_set_abstract_semaphore (GValue* value,
                                   gpointer v_object);
void value_take_abstract_semaphore (GValue* value,
                                    gpointer v_object);
gpointer value_get_abstract_semaphore (const GValue* value);
GType abstract_semaphore_get_type (void) G_GNUC_CONST;
BackgroundJob* background_job_construct (GType object_type,
                                         GObject* owner,
                                         CompletionCallback callback,
                                         void* callback_target,
                                         GCancellable* cancellable,
                                         CancellationCallback cancellation,
                                         void* cancellation_target,
                                         AbstractSemaphore* completion_semaphore);
static void metadata_writer_commit_job_real_execute (BackgroundJob* base);
static void metadata_writer_commit_job_commit_master (MetadataWriterCommitJob* self,
                                               GError** error);
static void metadata_writer_commit_job_commit_editable (MetadataWriterCommitJob* self,
                                                 GError** error);
gboolean photo_has_editable (Photo* self);
GType photo_file_format_get_type (void) G_GNUC_CONST;
PhotoFileFormat photo_get_master_file_format (Photo* self);
gboolean photo_file_format_can_write_metadata (PhotoFileFormat self);
gpointer media_metadata_ref (gpointer instance);
void media_metadata_unref (gpointer instance);
GParamSpec* param_spec_media_metadata (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
void value_set_media_metadata (GValue* value,
                               gpointer v_object);
void value_take_media_metadata (GValue* value,
                                gpointer v_object);
gpointer value_get_media_metadata (const GValue* value);
GType media_metadata_get_type (void) G_GNUC_CONST;
GType photo_metadata_get_type (void) G_GNUC_CONST;
PhotoMetadata* photo_get_master_metadata (Photo* self,
                                          GError** error);
static gboolean metadata_writer_commit_job_update_metadata (MetadataWriterCommitJob* self,
                                                     PhotoMetadata* metadata,
                                                     gboolean skip_orientation);
void library_monitor_blacklist_file (GFile* file,
                                     const gchar* reason);
gboolean photo_persist_master_metadata (Photo* self,
                                        PhotoMetadata* metadata,
                                        PhotoReimportMasterState* * state,
                                        GError** error);
void library_monitor_unblacklist_file (GFile* file);
PhotoFileFormat* photo_get_editable_file_format (Photo* self);
PhotoMetadata* photo_get_editable_metadata (Photo* self,
                                            GError** error);
gboolean photo_persist_editable_metadata (Photo* self,
                                          PhotoMetadata* metadata,
                                          PhotoReimportEditableState* * state,
                                          GError** error);
gchar* media_source_get_title (MediaSource* self);
gchar* media_metadata_get_title (MediaMetadata* self);
GType photo_metadata_set_option_get_type (void) G_GNUC_CONST;
void photo_metadata_set_title (PhotoMetadata* self,
                               const gchar* title,
                               PhotoMetadataSetOption option);
gchar* media_source_get_comment (MediaSource* self);
gchar* media_metadata_get_comment (MediaMetadata* self);
void photo_metadata_set_comment (PhotoMetadata* self,
                                 const gchar* comment,
                                 PhotoMetadataSetOption option);
GType rating_get_type (void) G_GNUC_CONST;
Rating media_source_get_rating (MediaSource* self);
Rating photo_metadata_get_rating (PhotoMetadata* self);
void photo_metadata_set_rating (PhotoMetadata* self,
                                Rating rating);
time_t media_source_get_exposure_time (MediaSource* self);
gpointer metadata_date_time_ref (gpointer instance);
void metadata_date_time_unref (gpointer instance);
GParamSpec* param_spec_metadata_date_time (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags);
void value_set_metadata_date_time (GValue* value,
                                   gpointer v_object);
void value_take_metadata_date_time (GValue* value,
                                    gpointer v_object);
gpointer value_get_metadata_date_time (const GValue* value);
GType metadata_date_time_get_type (void) G_GNUC_CONST;
MetadataDateTime* photo_metadata_get_exposure_date_time (PhotoMetadata* self);
time_t metadata_date_time_get_timestamp (MetadataDateTime* self);
MetadataDateTime* metadata_date_time_new (time_t timestamp);
MetadataDateTime* metadata_date_time_construct (GType object_type,
                                                time_t timestamp);
void photo_metadata_set_exposure_date_time (PhotoMetadata* self,
                                            MetadataDateTime* date_time,
                                            PhotoMetadataSetOption option);
Tag* tag_for_path (const gchar* name);
gchar* tag_get_user_visible_name (Tag* self);
gboolean equal_sets (GeeSet* a,
                     GeeSet* b);
GeeSet* photo_metadata_get_keywords (PhotoMetadata* self,
                                     GCompareDataFunc compare_func,
                                     void* compare_func_target,
                                     GDestroyNotify compare_func_target_destroy_notify);
void photo_metadata_set_keywords (PhotoMetadata* self,
                                  GeeCollection* keywords,
                                  PhotoMetadataSetOption option);
GType orientation_get_type (void) G_GNUC_CONST;
Orientation photo_get_orientation (Photo* self);
Orientation photo_metadata_get_orientation (PhotoMetadata* self);
void photo_metadata_set_orientation (PhotoMetadata* self,
                                     Orientation orientation);
void photo_metadata_set_software (PhotoMetadata* self,
                                  const gchar* software,
                                  const gchar* version);
#define RESOURCES_APP_TITLE "Shotwell"
#define RESOURCES_APP_VERSION _VERSION
static void metadata_writer_commit_job_finalize (BackgroundJob * obj);
static void metadata_writer_finalize (GObject * obj);

static const gchar* METADATA_WRITER_INTERESTED_PHOTO_METADATA_DETAILS[4] = {"name", "comment", "rating", "exposure-time"};

static void
_metadata_writer_on_config_changed_configuration_facade_commit_metadata_to_masters_changed (ConfigurationFacade* _sender,
                                                                                            gpointer self)
{
#line 220 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	metadata_writer_on_config_changed ((MetadataWriter*) self);
#line 1077 "MetadataWriter.c"
}


static void
_metadata_writer_on_importing_photos_media_source_collection_media_import_starting (MediaSourceCollection* _sender,
                                                                                    GeeCollection* media,
                                                                                    gpointer self)
{
#line 222 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	metadata_writer_on_importing_photos ((MetadataWriter*) self, media);
#line 1088 "MetadataWriter.c"
}


static void
_metadata_writer_on_photos_imported_media_source_collection_media_import_completed (MediaSourceCollection* _sender,
                                                                                    GeeCollection* media,
                                                                                    gpointer self)
{
#line 223 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	metadata_writer_on_photos_imported ((MetadataWriter*) self, media);
#line 1099 "MetadataWriter.c"
}


static void
_metadata_writer_on_photos_added_removed_data_collection_contents_altered (DataCollection* _sender,
                                                                           GeeIterable* added,
                                                                           GeeIterable* removed,
                                                                           gpointer self)
{
#line 224 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	metadata_writer_on_photos_added_removed ((MetadataWriter*) self, added, removed);
#line 1111 "MetadataWriter.c"
}


static void
_metadata_writer_on_photos_altered_data_collection_items_altered (DataCollection* _sender,
                                                                  GeeMap* items,
                                                                  gpointer self)
{
#line 225 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	metadata_writer_on_photos_altered ((MetadataWriter*) self, items);
#line 1122 "MetadataWriter.c"
}


static void
_metadata_writer_on_collection_frozen_data_collection_frozen (DataCollection* _sender,
                                                              gpointer self)
{
#line 226 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	metadata_writer_on_collection_frozen ((MetadataWriter*) self);
#line 1132 "MetadataWriter.c"
}


static void
_metadata_writer_on_collection_thawed_data_collection_thawed (DataCollection* _sender,
                                                              gpointer self)
{
#line 227 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	metadata_writer_on_collection_thawed ((MetadataWriter*) self);
#line 1142 "MetadataWriter.c"
}


static void
_metadata_writer_on_photos_destroyed_source_collection_items_destroyed (SourceCollection* _sender,
                                                                        GeeCollection* destroyed,
                                                                        gpointer self)
{
#line 228 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	metadata_writer_on_photos_destroyed ((MetadataWriter*) self, destroyed);
#line 1153 "MetadataWriter.c"
}


static void
_metadata_writer_on_tags_altered_data_collection_items_altered (DataCollection* _sender,
                                                                GeeMap* items,
                                                                gpointer self)
{
#line 230 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	metadata_writer_on_tags_altered ((MetadataWriter*) self, items);
#line 1164 "MetadataWriter.c"
}


static void
_metadata_writer_on_tag_contents_altered_container_source_collection_container_contents_altered (ContainerSourceCollection* _sender,
                                                                                                 ContainerSource* container,
                                                                                                 GeeCollection* added,
                                                                                                 gboolean relinked,
                                                                                                 GeeCollection* removed,
                                                                                                 gboolean unlinked,
                                                                                                 gpointer self)
{
#line 231 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	metadata_writer_on_tag_contents_altered ((MetadataWriter*) self, container, added, relinked, removed, unlinked);
#line 1179 "MetadataWriter.c"
}


static void
_metadata_writer_on_tag_backlink_removed_container_source_collection_backlink_to_container_removed (ContainerSourceCollection* _sender,
                                                                                                    ContainerSource* container,
                                                                                                    GeeCollection* sources,
                                                                                                    gpointer self)
{
#line 232 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	metadata_writer_on_tag_backlink_removed ((MetadataWriter*) self, container, sources);
#line 1191 "MetadataWriter.c"
}


static void
_metadata_writer_on_application_exiting_application_exiting (Application* _sender,
                                                             gboolean panicked,
                                                             gpointer self)
{
#line 236 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	metadata_writer_on_application_exiting ((MetadataWriter*) self);
#line 1202 "MetadataWriter.c"
}


static void
_metadata_writer_on_monitor_installed_library_monitor_pool_monitor_installed (LibraryMonitorPool* _sender,
                                                                              LibraryMonitor* monitor,
                                                                              gpointer self)
{
#line 238 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	metadata_writer_on_monitor_installed ((MetadataWriter*) self, monitor);
#line 1213 "MetadataWriter.c"
}


static void
_metadata_writer_on_monitor_destroyed_library_monitor_pool_monitor_destroyed (LibraryMonitorPool* _sender,
                                                                              LibraryMonitor* monitor,
                                                                              gpointer self)
{
#line 239 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	metadata_writer_on_monitor_destroyed ((MetadataWriter*) self, monitor);
#line 1224 "MetadataWriter.c"
}


static void
_metadata_writer_on_photo_dequeued_dequeued_callback (gconstpointer item,
                                                      gpointer self)
{
#line 180 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	metadata_writer_on_photo_dequeued ((MetadataWriter*) self, (LibraryPhoto*) item);
#line 1234 "MetadataWriter.c"
}


static MetadataWriter*
metadata_writer_construct (GType object_type)
{
	MetadataWriter * self = NULL;
	HashTimedQueue* _tmp0_;
	HashTimedQueue* _tmp1_;
	ConfigFacade* _tmp5_;
	ConfigFacade* _tmp6_;
	ConfigFacade* _tmp7_;
	ConfigFacade* _tmp8_;
	LibraryPhotoSourceCollection* _tmp9_;
	LibraryPhotoSourceCollection* _tmp10_;
	LibraryPhotoSourceCollection* _tmp11_;
	LibraryPhotoSourceCollection* _tmp12_;
	LibraryPhotoSourceCollection* _tmp13_;
	LibraryPhotoSourceCollection* _tmp14_;
	LibraryPhotoSourceCollection* _tmp15_;
	TagSourceCollection* _tmp16_;
	TagSourceCollection* _tmp17_;
	TagSourceCollection* _tmp18_;
	TagSourceCollection* _tmp19_;
	TagSourceCollection* _tmp20_;
	Application* _tmp21_;
	Application* _tmp22_;
	LibraryMonitorPool* _tmp23_;
	LibraryMonitorPool* _tmp24_;
	LibraryMonitorPool* _tmp25_;
	LibraryMonitorPool* _tmp26_;
#line 179 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	self = (MetadataWriter*) g_object_new (object_type, NULL);
#line 180 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp0_ = hash_timed_queue_new (TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, METADATA_WRITER_COMMIT_DELAY_MSEC, _metadata_writer_on_photo_dequeued_dequeued_callback, self, NULL, NULL, NULL, NULL, NULL, NULL, G_PRIORITY_DEFAULT);
#line 180 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_timed_queue_unref0 (self->priv->dirty);
#line 180 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	self->priv->dirty = _tmp0_;
#line 181 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp1_ = self->priv->dirty;
#line 181 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	timed_queue_set_dequeue_spacing_msec (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_TIMED_QUEUE, TimedQueue), METADATA_WRITER_COMMIT_SPACING_MSEC);
#line 186 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	metadata_writer_pause (self);
#line 1280 "MetadataWriter.c"
	{
		const gchar** detail_collection = NULL;
		gint detail_collection_length1 = 0;
		gint _detail_collection_size_ = 0;
		gint detail_it = 0;
#line 189 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		detail_collection = METADATA_WRITER_INTERESTED_PHOTO_METADATA_DETAILS;
#line 189 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		detail_collection_length1 = G_N_ELEMENTS (METADATA_WRITER_INTERESTED_PHOTO_METADATA_DETAILS);
#line 189 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		for (detail_it = 0; detail_it < G_N_ELEMENTS (METADATA_WRITER_INTERESTED_PHOTO_METADATA_DETAILS); detail_it = detail_it + 1) {
#line 1292 "MetadataWriter.c"
			gchar* _tmp2_;
			gchar* detail = NULL;
#line 189 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp2_ = g_strdup (detail_collection[detail_it]);
#line 189 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			detail = _tmp2_;
#line 1299 "MetadataWriter.c"
			{
				GeeHashSet* _tmp3_;
				const gchar* _tmp4_;
#line 190 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_tmp3_ = self->priv->interested_photo_details;
#line 190 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_tmp4_ = detail;
#line 190 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp4_);
#line 189 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_g_free0 (detail);
#line 1311 "MetadataWriter.c"
			}
		}
	}
#line 193 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp5_ = config_facade_get_instance ();
#line 193 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp6_ = _tmp5_;
#line 193 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	self->priv->enabled = configuration_facade_get_commit_metadata_to_masters (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
#line 193 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_g_object_unref0 (_tmp6_);
#line 194 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp7_ = config_facade_get_instance ();
#line 194 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp8_ = _tmp7_;
#line 194 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), "commit-metadata-to-masters-changed", (GCallback) _metadata_writer_on_config_changed_configuration_facade_commit_metadata_to_masters_changed, self, 0);
#line 194 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_g_object_unref0 (_tmp8_);
#line 197 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	metadata_writer_force_rescan (self);
#line 199 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp9_ = library_photo_global;
#line 199 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection), "media-import-starting", (GCallback) _metadata_writer_on_importing_photos_media_source_collection_media_import_starting, self, 0);
#line 200 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp10_ = library_photo_global;
#line 200 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection), "media-import-completed", (GCallback) _metadata_writer_on_photos_imported_media_source_collection_media_import_completed, self, 0);
#line 201 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp11_ = library_photo_global;
#line 201 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, TYPE_DATA_COLLECTION, DataCollection), "contents-altered", (GCallback) _metadata_writer_on_photos_added_removed_data_collection_contents_altered, self, 0);
#line 202 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp12_ = library_photo_global;
#line 202 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, TYPE_DATA_COLLECTION, DataCollection), "items-altered", (GCallback) _metadata_writer_on_photos_altered_data_collection_items_altered, self, 0);
#line 203 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp13_ = library_photo_global;
#line 203 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, TYPE_DATA_COLLECTION, DataCollection), "frozen", (GCallback) _metadata_writer_on_collection_frozen_data_collection_frozen, self, 0);
#line 204 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp14_ = library_photo_global;
#line 204 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, TYPE_DATA_COLLECTION, DataCollection), "thawed", (GCallback) _metadata_writer_on_collection_thawed_data_collection_thawed, self, 0);
#line 205 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp15_ = library_photo_global;
#line 205 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, TYPE_SOURCE_COLLECTION, SourceCollection), "items-destroyed", (GCallback) _metadata_writer_on_photos_destroyed_source_collection_items_destroyed, self, 0);
#line 207 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp16_ = tag_global;
#line 207 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, TYPE_DATA_COLLECTION, DataCollection), "items-altered", (GCallback) _metadata_writer_on_tags_altered_data_collection_items_altered, self, 0);
#line 208 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp17_ = tag_global;
#line 208 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollection), "container-contents-altered", (GCallback) _metadata_writer_on_tag_contents_altered_container_source_collection_container_contents_altered, self, 0);
#line 209 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp18_ = tag_global;
#line 209 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollection), "backlink-to-container-removed", (GCallback) _metadata_writer_on_tag_backlink_removed_container_source_collection_backlink_to_container_removed, self, 0);
#line 210 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp19_ = tag_global;
#line 210 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, TYPE_DATA_COLLECTION, DataCollection), "frozen", (GCallback) _metadata_writer_on_collection_frozen_data_collection_frozen, self, 0);
#line 211 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp20_ = tag_global;
#line 211 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, TYPE_DATA_COLLECTION, DataCollection), "thawed", (GCallback) _metadata_writer_on_collection_thawed_data_collection_thawed, self, 0);
#line 213 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp21_ = application_get_instance ();
#line 213 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp22_ = _tmp21_;
#line 213 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_signal_connect_object (_tmp22_, "exiting", (GCallback) _metadata_writer_on_application_exiting_application_exiting, self, 0);
#line 213 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_application_unref0 (_tmp22_);
#line 215 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp23_ = library_monitor_pool_get_instance ();
#line 215 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp24_ = _tmp23_;
#line 215 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_signal_connect_object (_tmp24_, "monitor-installed", (GCallback) _metadata_writer_on_monitor_installed_library_monitor_pool_monitor_installed, self, 0);
#line 215 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_library_monitor_pool_unref0 (_tmp24_);
#line 216 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp25_ = library_monitor_pool_get_instance ();
#line 216 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp26_ = _tmp25_;
#line 216 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_signal_connect_object (_tmp26_, "monitor-destroyed", (GCallback) _metadata_writer_on_monitor_destroyed_library_monitor_pool_monitor_destroyed, self, 0);
#line 216 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_library_monitor_pool_unref0 (_tmp26_);
#line 179 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	return self;
#line 1407 "MetadataWriter.c"
}


static MetadataWriter*
metadata_writer_new (void)
{
#line 179 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	return metadata_writer_construct (TYPE_METADATA_WRITER);
#line 1416 "MetadataWriter.c"
}


void
metadata_writer_init (void)
{
	MetadataWriter* _tmp0_;
#line 243 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp0_ = metadata_writer_new ();
#line 243 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_g_object_unref0 (metadata_writer_instance);
#line 243 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	metadata_writer_instance = _tmp0_;
#line 1430 "MetadataWriter.c"
}


void
metadata_writer_terminate (void)
{
	MetadataWriter* _tmp0_;
#line 247 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp0_ = metadata_writer_instance;
#line 247 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	if (_tmp0_ != NULL) {
#line 1442 "MetadataWriter.c"
		MetadataWriter* _tmp1_;
#line 248 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp1_ = metadata_writer_instance;
#line 248 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		metadata_writer_close (_tmp1_);
#line 1448 "MetadataWriter.c"
	}
#line 250 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_g_object_unref0 (metadata_writer_instance);
#line 250 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	metadata_writer_instance = NULL;
#line 1454 "MetadataWriter.c"
}


static gpointer
_g_object_ref0 (gpointer self)
{
#line 254 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	return self ? g_object_ref (self) : NULL;
#line 1463 "MetadataWriter.c"
}


MetadataWriter*
metadata_writer_get_instance (void)
{
	MetadataWriter* result = NULL;
	MetadataWriter* _tmp0_;
	MetadataWriter* _tmp1_;
#line 254 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp0_ = metadata_writer_instance;
#line 254 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 254 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	result = _tmp1_;
#line 254 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	return result;
#line 1481 "MetadataWriter.c"
}


void
metadata_writer_force_rescan (MetadataWriter* self)
{
	LibraryPhotoSourceCollection* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* _tmp2_;
#line 258 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_return_if_fail (IS_METADATA_WRITER (self));
#line 259 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp0_ = library_photo_global;
#line 259 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp1_ = data_collection_get_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_DATA_COLLECTION, DataCollection));
#line 259 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp2_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_COLLECTION, GeeCollection);
#line 259 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	metadata_writer_schedule_if_dirty (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ITERABLE, GeeIterable), "force rescan");
#line 259 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_g_object_unref0 (_tmp2_);
#line 1503 "MetadataWriter.c"
}


void
metadata_writer_pause (MetadataWriter* self)
{
	gint _tmp0_;
	HashTimedQueue* _tmp1_;
#line 262 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_return_if_fail (IS_METADATA_WRITER (self));
#line 263 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp0_ = self->priv->pause_count;
#line 263 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	self->priv->pause_count = _tmp0_ + 1;
#line 263 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	if (_tmp0_ != 0) {
#line 264 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		return;
#line 1522 "MetadataWriter.c"
	}
#line 266 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp1_ = self->priv->dirty;
#line 266 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	timed_queue_pause (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_TIMED_QUEUE, TimedQueue));
#line 268 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_signal_emit (self, metadata_writer_signals[METADATA_WRITER_PROGRESS_SIGNAL], 0, (guint) 0, (guint) 0);
#line 1530 "MetadataWriter.c"
}


void
metadata_writer_unpause (MetadataWriter* self)
{
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	HashTimedQueue* _tmp4_;
#line 271 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_return_if_fail (IS_METADATA_WRITER (self));
#line 272 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp1_ = self->priv->pause_count;
#line 272 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	if (_tmp1_ == 0) {
#line 272 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp0_ = TRUE;
#line 1548 "MetadataWriter.c"
	} else {
		gint _tmp2_;
		gint _tmp3_;
#line 272 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp2_ = self->priv->pause_count;
#line 272 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		self->priv->pause_count = _tmp2_ - 1;
#line 272 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp3_ = self->priv->pause_count;
#line 272 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp0_ = _tmp3_ != 0;
#line 1560 "MetadataWriter.c"
	}
#line 272 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	if (_tmp0_) {
#line 273 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		return;
#line 1566 "MetadataWriter.c"
	}
#line 275 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp4_ = self->priv->dirty;
#line 275 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	timed_queue_unpause (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_TIMED_QUEUE, TimedQueue));
#line 1572 "MetadataWriter.c"
}


void
metadata_writer_close (MetadataWriter* self)
{
	gboolean _tmp0_;
#line 278 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_return_if_fail (IS_METADATA_WRITER (self));
#line 279 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp0_ = self->priv->closed;
#line 279 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	if (_tmp0_) {
#line 280 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		return;
#line 1588 "MetadataWriter.c"
	}
#line 282 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	metadata_writer_cancel_all (self, TRUE);
#line 284 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	self->priv->closed = TRUE;
#line 1594 "MetadataWriter.c"
}


static void
metadata_writer_on_config_changed (MetadataWriter* self)
{
	gboolean value = FALSE;
	ConfigFacade* _tmp0_;
	ConfigFacade* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
#line 287 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_return_if_fail (IS_METADATA_WRITER (self));
#line 288 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp0_ = config_facade_get_instance ();
#line 288 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp1_ = _tmp0_;
#line 288 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp2_ = configuration_facade_get_commit_metadata_to_masters (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
#line 288 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_g_object_unref0 (_tmp1_);
#line 288 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	value = _tmp2_;
#line 290 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp3_ = self->priv->enabled;
#line 290 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp4_ = value;
#line 290 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	if (_tmp3_ == _tmp4_) {
#line 291 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		return;
#line 1629 "MetadataWriter.c"
	}
#line 293 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp5_ = value;
#line 293 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	self->priv->enabled = _tmp5_;
#line 294 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp6_ = self->priv->enabled;
#line 294 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	if (_tmp6_) {
#line 295 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		metadata_writer_force_rescan (self);
#line 1641 "MetadataWriter.c"
	} else {
#line 297 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		metadata_writer_cancel_all (self, FALSE);
#line 1645 "MetadataWriter.c"
	}
}


static void
metadata_writer_on_application_exiting (MetadataWriter* self)
{
#line 300 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_return_if_fail (IS_METADATA_WRITER (self));
#line 301 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	metadata_writer_close (self);
#line 1657 "MetadataWriter.c"
}


static void
_metadata_writer_on_discovery_completed_directory_monitor_discovery_completed (DirectoryMonitor* _sender,
                                                                               gpointer self)
{
#line 305 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	metadata_writer_on_discovery_completed ((MetadataWriter*) self);
#line 1667 "MetadataWriter.c"
}


static void
metadata_writer_on_monitor_installed (MetadataWriter* self,
                                      LibraryMonitor* monitor)
{
#line 304 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_return_if_fail (IS_METADATA_WRITER (self));
#line 304 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_return_if_fail (IS_LIBRARY_MONITOR (monitor));
#line 305 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (monitor, TYPE_DIRECTORY_MONITOR, DirectoryMonitor), "discovery-completed", (GCallback) _metadata_writer_on_discovery_completed_directory_monitor_discovery_completed, self, 0);
#line 1681 "MetadataWriter.c"
}


static void
metadata_writer_on_monitor_destroyed (MetadataWriter* self,
                                      LibraryMonitor* monitor)
{
	guint _tmp0_;
#line 308 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_return_if_fail (IS_METADATA_WRITER (self));
#line 308 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_return_if_fail (IS_LIBRARY_MONITOR (monitor));
#line 309 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_signal_parse_name ("discovery-completed", TYPE_DIRECTORY_MONITOR, &_tmp0_, NULL, FALSE);
#line 309 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (monitor, TYPE_DIRECTORY_MONITOR, DirectoryMonitor), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _metadata_writer_on_discovery_completed_directory_monitor_discovery_completed, self);
#line 1698 "MetadataWriter.c"
}


static void
metadata_writer_on_discovery_completed (MetadataWriter* self)
{
#line 312 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_return_if_fail (IS_METADATA_WRITER (self));
#line 313 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	metadata_writer_unpause (self);
#line 1709 "MetadataWriter.c"
}


static void
metadata_writer_on_collection_frozen (MetadataWriter* self)
{
#line 316 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_return_if_fail (IS_METADATA_WRITER (self));
#line 317 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	metadata_writer_pause (self);
#line 1720 "MetadataWriter.c"
}


static void
metadata_writer_on_collection_thawed (MetadataWriter* self)
{
#line 320 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_return_if_fail (IS_METADATA_WRITER (self));
#line 321 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	metadata_writer_unpause (self);
#line 1731 "MetadataWriter.c"
}


static void
metadata_writer_on_importing_photos (MetadataWriter* self,
                                     GeeCollection* media_sources)
{
	GeeHashSet* _tmp0_;
#line 324 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_return_if_fail (IS_METADATA_WRITER (self));
#line 324 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_return_if_fail (GEE_IS_COLLECTION (media_sources));
#line 325 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp0_ = self->priv->importing_photos;
#line 325 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	gee_collection_add_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (media_sources, GEE_TYPE_COLLECTION, GeeCollection));
#line 1748 "MetadataWriter.c"
}


static void
metadata_writer_on_photos_imported (MetadataWriter* self,
                                    GeeCollection* media_sources)
{
	GeeHashSet* _tmp0_;
#line 328 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_return_if_fail (IS_METADATA_WRITER (self));
#line 328 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_return_if_fail (GEE_IS_COLLECTION (media_sources));
#line 329 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp0_ = self->priv->importing_photos;
#line 329 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	gee_collection_remove_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (media_sources, GEE_TYPE_COLLECTION, GeeCollection));
#line 1765 "MetadataWriter.c"
}


static void
metadata_writer_on_photos_added_removed (MetadataWriter* self,
                                         GeeIterable* added,
                                         GeeIterable* removed)
{
	gboolean _tmp0_ = FALSE;
#line 332 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_return_if_fail (IS_METADATA_WRITER (self));
#line 332 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_return_if_fail ((added == NULL) || GEE_IS_ITERABLE (added));
#line 332 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_return_if_fail ((removed == NULL) || GEE_IS_ITERABLE (removed));
#line 335 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	if (added != NULL) {
#line 1783 "MetadataWriter.c"
		gboolean _tmp1_;
#line 335 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp1_ = self->priv->enabled;
#line 335 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp0_ = _tmp1_;
#line 1789 "MetadataWriter.c"
	} else {
#line 335 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp0_ = FALSE;
#line 1793 "MetadataWriter.c"
	}
#line 335 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	if (_tmp0_) {
#line 336 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		metadata_writer_schedule_if_dirty (self, G_TYPE_CHECK_INSTANCE_CAST (added, GEE_TYPE_ITERABLE, GeeIterable), "added to LibraryPhoto.global");
#line 1799 "MetadataWriter.c"
	}
#line 339 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	if (removed != NULL) {
#line 1803 "MetadataWriter.c"
		gboolean cancelled = FALSE;
		gboolean _tmp9_;
#line 340 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		cancelled = FALSE;
#line 1808 "MetadataWriter.c"
		{
			GeeIterator* _object_it = NULL;
			GeeIterator* _tmp2_;
#line 341 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp2_ = gee_iterable_iterator (removed);
#line 341 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_object_it = _tmp2_;
#line 341 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			while (TRUE) {
#line 1818 "MetadataWriter.c"
				GeeIterator* _tmp3_;
				DataObject* object = NULL;
				GeeIterator* _tmp4_;
				gpointer _tmp5_;
				gboolean _tmp6_ = FALSE;
				DataObject* _tmp7_;
#line 341 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_tmp3_ = _object_it;
#line 341 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				if (!gee_iterator_next (_tmp3_)) {
#line 341 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
					break;
#line 1831 "MetadataWriter.c"
				}
#line 341 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_tmp4_ = _object_it;
#line 341 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_tmp5_ = gee_iterator_get (_tmp4_);
#line 341 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				object = (DataObject*) _tmp5_;
#line 342 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_tmp7_ = object;
#line 342 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				if (metadata_writer_cancel_job (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_LIBRARY_PHOTO, LibraryPhoto))) {
#line 342 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
					_tmp6_ = TRUE;
#line 1845 "MetadataWriter.c"
				} else {
					gboolean _tmp8_;
#line 342 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
					_tmp8_ = cancelled;
#line 342 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
					_tmp6_ = _tmp8_;
#line 1852 "MetadataWriter.c"
				}
#line 342 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				cancelled = _tmp6_;
#line 341 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_g_object_unref0 (object);
#line 1858 "MetadataWriter.c"
			}
#line 341 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_g_object_unref0 (_object_it);
#line 1862 "MetadataWriter.c"
		}
#line 344 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp9_ = cancelled;
#line 344 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		if (_tmp9_) {
#line 1868 "MetadataWriter.c"
			guint _tmp10_;
			guint _tmp11_;
#line 345 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp10_ = self->priv->outstanding_completed;
#line 345 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp11_ = self->priv->outstanding_total;
#line 345 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			g_signal_emit (self, metadata_writer_signals[METADATA_WRITER_PROGRESS_SIGNAL], 0, _tmp10_, _tmp11_);
#line 1877 "MetadataWriter.c"
		}
	}
}


static void
metadata_writer_on_photos_altered (MetadataWriter* self,
                                   GeeMap* items)
{
	GeeHashSet* photos = NULL;
	GeeHashSet* _tmp33_;
#line 349 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_return_if_fail (IS_METADATA_WRITER (self));
#line 349 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_return_if_fail (GEE_IS_MAP (items));
#line 350 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	photos = NULL;
#line 1895 "MetadataWriter.c"
	{
		GeeIterator* _object_it = NULL;
		GeeSet* _tmp0_;
		GeeSet* _tmp1_;
		GeeSet* _tmp2_;
		GeeIterator* _tmp3_;
		GeeIterator* _tmp4_;
#line 351 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp0_ = gee_map_get_keys (items);
#line 351 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp1_ = _tmp0_;
#line 351 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp2_ = _tmp1_;
#line 351 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp3_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ITERABLE, GeeIterable));
#line 351 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp4_ = _tmp3_;
#line 351 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_g_object_unref0 (_tmp2_);
#line 351 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_object_it = _tmp4_;
#line 351 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		while (TRUE) {
#line 1919 "MetadataWriter.c"
			GeeIterator* _tmp5_;
			DataObject* object = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			LibraryPhoto* photo = NULL;
			DataObject* _tmp8_;
			LibraryPhoto* _tmp9_;
			LibraryPhoto* _tmp10_;
			LibraryPhoto* _tmp11_;
			Alteration* alteration = NULL;
			DataObject* _tmp12_;
			gpointer _tmp13_;
			Alteration* _tmp14_;
			GeeCollection* details = NULL;
			Alteration* _tmp19_;
			GeeCollection* _tmp20_;
			GeeCollection* _tmp21_;
#line 351 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp5_ = _object_it;
#line 351 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			if (!gee_iterator_next (_tmp5_)) {
#line 351 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				break;
#line 1943 "MetadataWriter.c"
			}
#line 351 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp6_ = _object_it;
#line 351 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp7_ = gee_iterator_get (_tmp6_);
#line 351 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			object = (DataObject*) _tmp7_;
#line 352 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp8_ = object;
#line 352 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_LIBRARY_PHOTO, LibraryPhoto));
#line 352 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			photo = _tmp9_;
#line 356 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp10_ = photo;
#line 356 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp11_ = self->priv->ignore_photo_alteration;
#line 356 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			if (_tmp10_ == _tmp11_) {
#line 357 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_g_object_unref0 (photo);
#line 357 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_g_object_unref0 (object);
#line 357 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				continue;
#line 1969 "MetadataWriter.c"
			}
#line 359 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp12_ = object;
#line 359 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp13_ = gee_map_get (items, _tmp12_);
#line 359 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			alteration = (Alteration*) _tmp13_;
#line 362 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp14_ = alteration;
#line 362 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			if (alteration_has_detail (_tmp14_, "image", "orientation")) {
#line 1981 "MetadataWriter.c"
				GeeHashSet* _tmp15_;
				GeeHashSet* _tmp17_;
				LibraryPhoto* _tmp18_;
#line 363 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_tmp15_ = photos;
#line 363 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				if (_tmp15_ == NULL) {
#line 1989 "MetadataWriter.c"
					GeeHashSet* _tmp16_;
#line 364 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
					_tmp16_ = gee_hash_set_new (TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
#line 364 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
					_g_object_unref0 (photos);
#line 364 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
					photos = _tmp16_;
#line 1997 "MetadataWriter.c"
				}
#line 366 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_tmp17_ = photos;
#line 366 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_tmp18_ = photo;
#line 366 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp18_);
#line 368 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_alteration_unref0 (alteration);
#line 368 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_g_object_unref0 (photo);
#line 368 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_g_object_unref0 (object);
#line 368 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				continue;
#line 2013 "MetadataWriter.c"
			}
#line 372 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp19_ = alteration;
#line 372 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp20_ = alteration_get_details (_tmp19_, "metadata");
#line 372 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			details = _tmp20_;
#line 373 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp21_ = details;
#line 373 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			if (_tmp21_ == NULL) {
#line 374 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_g_object_unref0 (details);
#line 374 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_alteration_unref0 (alteration);
#line 374 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_g_object_unref0 (photo);
#line 374 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_g_object_unref0 (object);
#line 374 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				continue;
#line 2035 "MetadataWriter.c"
			}
			{
				GeeIterator* _detail_it = NULL;
				GeeCollection* _tmp22_;
				GeeIterator* _tmp23_;
#line 377 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_tmp22_ = details;
#line 377 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_tmp23_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, GEE_TYPE_ITERABLE, GeeIterable));
#line 377 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_detail_it = _tmp23_;
#line 377 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				while (TRUE) {
#line 2049 "MetadataWriter.c"
					GeeIterator* _tmp24_;
					gchar* detail = NULL;
					GeeIterator* _tmp25_;
					gpointer _tmp26_;
					GeeHashSet* _tmp27_;
					const gchar* _tmp28_;
#line 377 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
					_tmp24_ = _detail_it;
#line 377 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
					if (!gee_iterator_next (_tmp24_)) {
#line 377 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
						break;
#line 2062 "MetadataWriter.c"
					}
#line 377 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
					_tmp25_ = _detail_it;
#line 377 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
					_tmp26_ = gee_iterator_get (_tmp25_);
#line 377 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
					detail = (gchar*) _tmp26_;
#line 378 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
					_tmp27_ = self->priv->interested_photo_details;
#line 378 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
					_tmp28_ = detail;
#line 378 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
					if (gee_abstract_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp28_)) {
#line 2076 "MetadataWriter.c"
						GeeHashSet* _tmp29_;
						GeeHashSet* _tmp31_;
						LibraryPhoto* _tmp32_;
#line 379 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
						_tmp29_ = photos;
#line 379 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
						if (_tmp29_ == NULL) {
#line 2084 "MetadataWriter.c"
							GeeHashSet* _tmp30_;
#line 380 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
							_tmp30_ = gee_hash_set_new (TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
#line 380 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
							_g_object_unref0 (photos);
#line 380 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
							photos = _tmp30_;
#line 2092 "MetadataWriter.c"
						}
#line 382 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
						_tmp31_ = photos;
#line 382 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
						_tmp32_ = photo;
#line 382 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
						gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp32_);
#line 384 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
						_g_free0 (detail);
#line 384 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
						break;
#line 2104 "MetadataWriter.c"
					}
#line 377 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
					_g_free0 (detail);
#line 2108 "MetadataWriter.c"
				}
#line 377 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_g_object_unref0 (_detail_it);
#line 2112 "MetadataWriter.c"
			}
#line 351 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_g_object_unref0 (details);
#line 351 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_alteration_unref0 (alteration);
#line 351 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_g_object_unref0 (photo);
#line 351 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_g_object_unref0 (object);
#line 2122 "MetadataWriter.c"
		}
#line 351 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_g_object_unref0 (_object_it);
#line 2126 "MetadataWriter.c"
	}
#line 389 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp33_ = photos;
#line 389 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	if (_tmp33_ != NULL) {
#line 2132 "MetadataWriter.c"
		GeeHashSet* _tmp34_;
#line 390 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp34_ = photos;
#line 390 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		metadata_writer_photos_are_dirty (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, GEE_TYPE_COLLECTION, GeeCollection), "alteration", FALSE);
#line 2138 "MetadataWriter.c"
	}
#line 349 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_g_object_unref0 (photos);
#line 2142 "MetadataWriter.c"
}


static void
metadata_writer_on_photos_destroyed (MetadataWriter* self,
                                     GeeCollection* destroyed)
{
#line 393 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_return_if_fail (IS_METADATA_WRITER (self));
#line 393 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_return_if_fail (GEE_IS_COLLECTION (destroyed));
#line 2154 "MetadataWriter.c"
	{
		GeeIterator* _source_it = NULL;
		GeeIterator* _tmp0_;
#line 394 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp0_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (destroyed, GEE_TYPE_ITERABLE, GeeIterable));
#line 394 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_source_it = _tmp0_;
#line 394 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		while (TRUE) {
#line 2164 "MetadataWriter.c"
			GeeIterator* _tmp1_;
			DataSource* source = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			LibraryPhoto* photo = NULL;
			DataSource* _tmp4_;
			LibraryPhoto* _tmp5_;
			LibraryPhoto* _tmp6_;
			GeeHashSet* _tmp7_;
			LibraryPhoto* _tmp8_;
#line 394 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp1_ = _source_it;
#line 394 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			if (!gee_iterator_next (_tmp1_)) {
#line 394 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				break;
#line 2181 "MetadataWriter.c"
			}
#line 394 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp2_ = _source_it;
#line 394 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp3_ = gee_iterator_get (_tmp2_);
#line 394 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			source = (DataSource*) _tmp3_;
#line 395 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp4_ = source;
#line 395 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_LIBRARY_PHOTO, LibraryPhoto));
#line 395 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			photo = _tmp5_;
#line 396 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp6_ = photo;
#line 396 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			metadata_writer_cancel_job (self, _tmp6_);
#line 397 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp7_ = self->priv->importing_photos;
#line 397 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp8_ = photo;
#line 397 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			gee_abstract_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp8_);
#line 394 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_g_object_unref0 (photo);
#line 394 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_g_object_unref0 (source);
#line 2209 "MetadataWriter.c"
		}
#line 394 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_g_object_unref0 (_source_it);
#line 2213 "MetadataWriter.c"
	}
}


static void
metadata_writer_on_tags_altered (MetadataWriter* self,
                                 GeeMap* map)
{
	GeeHashSet* photos = NULL;
	GeeHashSet* _tmp27_;
#line 401 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_return_if_fail (IS_METADATA_WRITER (self));
#line 401 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_return_if_fail (GEE_IS_MAP (map));
#line 402 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	photos = NULL;
#line 2230 "MetadataWriter.c"
	{
		GeeIterator* _object_it = NULL;
		GeeSet* _tmp0_;
		GeeSet* _tmp1_;
		GeeSet* _tmp2_;
		GeeIterator* _tmp3_;
		GeeIterator* _tmp4_;
#line 403 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp0_ = gee_map_get_keys (map);
#line 403 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp1_ = _tmp0_;
#line 403 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp2_ = _tmp1_;
#line 403 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp3_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ITERABLE, GeeIterable));
#line 403 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp4_ = _tmp3_;
#line 403 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_g_object_unref0 (_tmp2_);
#line 403 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_object_it = _tmp4_;
#line 403 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		while (TRUE) {
#line 2254 "MetadataWriter.c"
			GeeIterator* _tmp5_;
			DataObject* object = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			DataObject* _tmp8_;
			gpointer _tmp9_;
			Alteration* _tmp10_;
			gboolean _tmp11_;
			GeeHashSet* _tmp12_;
#line 403 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp5_ = _object_it;
#line 403 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			if (!gee_iterator_next (_tmp5_)) {
#line 403 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				break;
#line 2270 "MetadataWriter.c"
			}
#line 403 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp6_ = _object_it;
#line 403 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp7_ = gee_iterator_get (_tmp6_);
#line 403 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			object = (DataObject*) _tmp7_;
#line 404 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp8_ = object;
#line 404 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp9_ = gee_map_get (map, _tmp8_);
#line 404 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp10_ = (Alteration*) _tmp9_;
#line 404 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp11_ = !alteration_has_detail (_tmp10_, "metadata", "name");
#line 404 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_alteration_unref0 (_tmp10_);
#line 404 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			if (_tmp11_) {
#line 405 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_g_object_unref0 (object);
#line 405 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				continue;
#line 2294 "MetadataWriter.c"
			}
#line 407 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp12_ = photos;
#line 407 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			if (_tmp12_ == NULL) {
#line 2300 "MetadataWriter.c"
				GeeHashSet* _tmp13_;
#line 408 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_tmp13_ = gee_hash_set_new (TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
#line 408 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_g_object_unref0 (photos);
#line 408 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				photos = _tmp13_;
#line 2308 "MetadataWriter.c"
			}
			{
				GeeIterator* _media_it = NULL;
				DataObject* _tmp14_;
				GeeCollection* _tmp15_;
				GeeCollection* _tmp16_;
				GeeIterator* _tmp17_;
				GeeIterator* _tmp18_;
#line 410 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_tmp14_ = object;
#line 410 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_tmp15_ = tag_get_sources (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, TYPE_TAG, Tag));
#line 410 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_tmp16_ = _tmp15_;
#line 410 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_tmp17_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, GEE_TYPE_ITERABLE, GeeIterable));
#line 410 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_tmp18_ = _tmp17_;
#line 410 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_g_object_unref0 (_tmp16_);
#line 410 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_media_it = _tmp18_;
#line 410 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				while (TRUE) {
#line 2333 "MetadataWriter.c"
					GeeIterator* _tmp19_;
					MediaSource* media = NULL;
					GeeIterator* _tmp20_;
					gpointer _tmp21_;
					LibraryPhoto* photo = NULL;
					MediaSource* _tmp22_;
					LibraryPhoto* _tmp23_;
					LibraryPhoto* _tmp24_;
#line 410 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
					_tmp19_ = _media_it;
#line 410 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
					if (!gee_iterator_next (_tmp19_)) {
#line 410 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
						break;
#line 2348 "MetadataWriter.c"
					}
#line 410 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
					_tmp20_ = _media_it;
#line 410 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
					_tmp21_ = gee_iterator_get (_tmp20_);
#line 410 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
					media = (MediaSource*) _tmp21_;
#line 411 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
					_tmp22_ = media;
#line 411 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
					_tmp23_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp22_, TYPE_LIBRARY_PHOTO) ? ((LibraryPhoto*) _tmp22_) : NULL);
#line 411 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
					photo = _tmp23_;
#line 412 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
					_tmp24_ = photo;
#line 412 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
					if (_tmp24_ != NULL) {
#line 2366 "MetadataWriter.c"
						GeeHashSet* _tmp25_;
						LibraryPhoto* _tmp26_;
#line 413 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
						_tmp25_ = photos;
#line 413 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
						_tmp26_ = photo;
#line 413 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
						gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp26_);
#line 2375 "MetadataWriter.c"
					}
#line 410 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
					_g_object_unref0 (photo);
#line 410 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
					_g_object_unref0 (media);
#line 2381 "MetadataWriter.c"
				}
#line 410 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_g_object_unref0 (_media_it);
#line 2385 "MetadataWriter.c"
			}
#line 403 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_g_object_unref0 (object);
#line 2389 "MetadataWriter.c"
		}
#line 403 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_g_object_unref0 (_object_it);
#line 2393 "MetadataWriter.c"
	}
#line 417 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp27_ = photos;
#line 417 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	if (_tmp27_ != NULL) {
#line 2399 "MetadataWriter.c"
		GeeHashSet* _tmp28_;
#line 418 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp28_ = photos;
#line 418 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		metadata_writer_photos_are_dirty (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, GEE_TYPE_COLLECTION, GeeCollection), "tag renamed", FALSE);
#line 2405 "MetadataWriter.c"
	}
#line 401 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_g_object_unref0 (photos);
#line 2409 "MetadataWriter.c"
}


static void
metadata_writer_on_tag_contents_altered (MetadataWriter* self,
                                         ContainerSource* container,
                                         GeeCollection* added,
                                         gboolean relinking,
                                         GeeCollection* removed,
                                         gboolean unlinking)
{
	Tag* tag = NULL;
	Tag* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp21_ = FALSE;
#line 421 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_return_if_fail (IS_METADATA_WRITER (self));
#line 421 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_return_if_fail (IS_CONTAINER_SOURCE (container));
#line 421 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_return_if_fail ((added == NULL) || GEE_IS_COLLECTION (added));
#line 421 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_return_if_fail ((removed == NULL) || GEE_IS_COLLECTION (removed));
#line 423 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (container, TYPE_TAG, Tag));
#line 423 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	tag = _tmp0_;
#line 425 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	if (added != NULL) {
#line 425 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp1_ = !relinking;
#line 2441 "MetadataWriter.c"
	} else {
#line 425 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp1_ = FALSE;
#line 2445 "MetadataWriter.c"
	}
#line 425 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	if (_tmp1_) {
#line 2449 "MetadataWriter.c"
		GeeArrayList* added_photos = NULL;
		GeeArrayList* _tmp2_;
		GeeArrayList* _tmp15_;
		Tag* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
#line 426 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp2_ = gee_array_list_new (TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 426 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		added_photos = _tmp2_;
#line 2462 "MetadataWriter.c"
		{
			GeeIterator* _source_it = NULL;
			GeeIterator* _tmp3_;
#line 427 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp3_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (added, GEE_TYPE_ITERABLE, GeeIterable));
#line 427 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_source_it = _tmp3_;
#line 427 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			while (TRUE) {
#line 2472 "MetadataWriter.c"
				GeeIterator* _tmp4_;
				DataSource* source = NULL;
				GeeIterator* _tmp5_;
				gpointer _tmp6_;
				LibraryPhoto* photo = NULL;
				DataSource* _tmp7_;
				LibraryPhoto* _tmp8_;
				gboolean _tmp9_ = FALSE;
				LibraryPhoto* _tmp10_;
#line 427 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_tmp4_ = _source_it;
#line 427 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				if (!gee_iterator_next (_tmp4_)) {
#line 427 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
					break;
#line 2488 "MetadataWriter.c"
				}
#line 427 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_tmp5_ = _source_it;
#line 427 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_tmp6_ = gee_iterator_get (_tmp5_);
#line 427 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				source = (DataSource*) _tmp6_;
#line 428 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_tmp7_ = source;
#line 428 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, TYPE_LIBRARY_PHOTO) ? ((LibraryPhoto*) _tmp7_) : NULL);
#line 428 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				photo = _tmp8_;
#line 429 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_tmp10_ = photo;
#line 429 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				if (_tmp10_ != NULL) {
#line 2506 "MetadataWriter.c"
					GeeHashSet* _tmp11_;
					LibraryPhoto* _tmp12_;
#line 429 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
					_tmp11_ = self->priv->importing_photos;
#line 429 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
					_tmp12_ = photo;
#line 429 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
					_tmp9_ = !gee_abstract_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp12_);
#line 2515 "MetadataWriter.c"
				} else {
#line 429 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
					_tmp9_ = FALSE;
#line 2519 "MetadataWriter.c"
				}
#line 429 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				if (_tmp9_) {
#line 2523 "MetadataWriter.c"
					GeeArrayList* _tmp13_;
					LibraryPhoto* _tmp14_;
#line 430 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
					_tmp13_ = added_photos;
#line 430 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
					_tmp14_ = photo;
#line 430 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
					gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp14_);
#line 2532 "MetadataWriter.c"
				}
#line 427 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_g_object_unref0 (photo);
#line 427 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_g_object_unref0 (source);
#line 2538 "MetadataWriter.c"
			}
#line 427 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_g_object_unref0 (_source_it);
#line 2542 "MetadataWriter.c"
		}
#line 433 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp15_ = added_photos;
#line 433 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp16_ = tag;
#line 433 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp17_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, TYPE_DATA_OBJECT, DataObject));
#line 433 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp18_ = _tmp17_;
#line 433 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp19_ = g_strdup_printf ("added to %s", _tmp18_);
#line 433 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp20_ = _tmp19_;
#line 433 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		metadata_writer_photos_are_dirty (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, GEE_TYPE_COLLECTION, GeeCollection), _tmp20_, FALSE);
#line 433 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_g_free0 (_tmp20_);
#line 433 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_g_free0 (_tmp18_);
#line 425 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_g_object_unref0 (added_photos);
#line 2564 "MetadataWriter.c"
	}
#line 436 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	if (removed != NULL) {
#line 436 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp21_ = !unlinking;
#line 2570 "MetadataWriter.c"
	} else {
#line 436 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp21_ = FALSE;
#line 2574 "MetadataWriter.c"
	}
#line 436 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	if (_tmp21_) {
#line 2578 "MetadataWriter.c"
		GeeArrayList* removed_photos = NULL;
		GeeArrayList* _tmp22_;
		GeeArrayList* _tmp32_;
		Tag* _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_;
		gchar* _tmp36_;
		gchar* _tmp37_;
#line 437 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp22_ = gee_array_list_new (TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 437 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		removed_photos = _tmp22_;
#line 2591 "MetadataWriter.c"
		{
			GeeIterator* _source_it = NULL;
			GeeIterator* _tmp23_;
#line 438 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp23_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (removed, GEE_TYPE_ITERABLE, GeeIterable));
#line 438 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_source_it = _tmp23_;
#line 438 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			while (TRUE) {
#line 2601 "MetadataWriter.c"
				GeeIterator* _tmp24_;
				DataSource* source = NULL;
				GeeIterator* _tmp25_;
				gpointer _tmp26_;
				LibraryPhoto* photo = NULL;
				DataSource* _tmp27_;
				LibraryPhoto* _tmp28_;
				LibraryPhoto* _tmp29_;
#line 438 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_tmp24_ = _source_it;
#line 438 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				if (!gee_iterator_next (_tmp24_)) {
#line 438 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
					break;
#line 2616 "MetadataWriter.c"
				}
#line 438 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_tmp25_ = _source_it;
#line 438 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_tmp26_ = gee_iterator_get (_tmp25_);
#line 438 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				source = (DataSource*) _tmp26_;
#line 439 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_tmp27_ = source;
#line 439 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_tmp28_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp27_, TYPE_LIBRARY_PHOTO) ? ((LibraryPhoto*) _tmp27_) : NULL);
#line 439 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				photo = _tmp28_;
#line 440 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_tmp29_ = photo;
#line 440 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				if (_tmp29_ != NULL) {
#line 2634 "MetadataWriter.c"
					GeeArrayList* _tmp30_;
					LibraryPhoto* _tmp31_;
#line 441 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
					_tmp30_ = removed_photos;
#line 441 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
					_tmp31_ = photo;
#line 441 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
					gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp31_);
#line 2643 "MetadataWriter.c"
				}
#line 438 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_g_object_unref0 (photo);
#line 438 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_g_object_unref0 (source);
#line 2649 "MetadataWriter.c"
			}
#line 438 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_g_object_unref0 (_source_it);
#line 2653 "MetadataWriter.c"
		}
#line 444 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp32_ = removed_photos;
#line 444 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp33_ = tag;
#line 444 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp34_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, TYPE_DATA_OBJECT, DataObject));
#line 444 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp35_ = _tmp34_;
#line 444 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp36_ = g_strdup_printf ("removed from %s", _tmp35_);
#line 444 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp37_ = _tmp36_;
#line 444 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		metadata_writer_photos_are_dirty (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, GEE_TYPE_COLLECTION, GeeCollection), _tmp37_, FALSE);
#line 444 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_g_free0 (_tmp37_);
#line 444 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_g_free0 (_tmp35_);
#line 436 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_g_object_unref0 (removed_photos);
#line 2675 "MetadataWriter.c"
	}
#line 421 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_g_object_unref0 (tag);
#line 2679 "MetadataWriter.c"
}


static void
metadata_writer_on_tag_backlink_removed (MetadataWriter* self,
                                         ContainerSource* container,
                                         GeeCollection* sources)
{
	GeeArrayList* photos = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
#line 448 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_return_if_fail (IS_METADATA_WRITER (self));
#line 448 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_return_if_fail (IS_CONTAINER_SOURCE (container));
#line 448 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_return_if_fail (GEE_IS_COLLECTION (sources));
#line 449 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp0_ = gee_array_list_new (TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 449 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	photos = _tmp0_;
#line 2705 "MetadataWriter.c"
	{
		GeeIterator* _source_it = NULL;
		GeeIterator* _tmp1_;
#line 450 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp1_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (sources, GEE_TYPE_ITERABLE, GeeIterable));
#line 450 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_source_it = _tmp1_;
#line 450 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		while (TRUE) {
#line 2715 "MetadataWriter.c"
			GeeIterator* _tmp2_;
			DataSource* source = NULL;
			GeeIterator* _tmp3_;
			gpointer _tmp4_;
			LibraryPhoto* photo = NULL;
			DataSource* _tmp5_;
			LibraryPhoto* _tmp6_;
			LibraryPhoto* _tmp7_;
#line 450 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp2_ = _source_it;
#line 450 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			if (!gee_iterator_next (_tmp2_)) {
#line 450 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				break;
#line 2730 "MetadataWriter.c"
			}
#line 450 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp3_ = _source_it;
#line 450 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp4_ = gee_iterator_get (_tmp3_);
#line 450 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			source = (DataSource*) _tmp4_;
#line 451 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp5_ = source;
#line 451 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, TYPE_LIBRARY_PHOTO) ? ((LibraryPhoto*) _tmp5_) : NULL);
#line 451 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			photo = _tmp6_;
#line 452 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp7_ = photo;
#line 452 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			if (_tmp7_ != NULL) {
#line 2748 "MetadataWriter.c"
				GeeArrayList* _tmp8_;
				LibraryPhoto* _tmp9_;
#line 453 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_tmp8_ = photos;
#line 453 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_tmp9_ = photo;
#line 453 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp9_);
#line 2757 "MetadataWriter.c"
			}
#line 450 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_g_object_unref0 (photo);
#line 450 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_g_object_unref0 (source);
#line 2763 "MetadataWriter.c"
		}
#line 450 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_g_object_unref0 (_source_it);
#line 2767 "MetadataWriter.c"
	}
#line 456 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp10_ = photos;
#line 456 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp11_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (container, TYPE_DATA_OBJECT, DataObject));
#line 456 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp12_ = _tmp11_;
#line 456 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp13_ = g_strdup_printf ("backlink removed from %s", _tmp12_);
#line 456 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp14_ = _tmp13_;
#line 456 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	metadata_writer_photos_are_dirty (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_COLLECTION, GeeCollection), _tmp14_, FALSE);
#line 456 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_g_free0 (_tmp14_);
#line 456 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_g_free0 (_tmp12_);
#line 448 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_g_object_unref0 (photos);
#line 2787 "MetadataWriter.c"
}


static void
metadata_writer_count_enqueued_work (MetadataWriter* self,
                                     gint count,
                                     gboolean report)
{
	guint _tmp0_;
#line 459 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_return_if_fail (IS_METADATA_WRITER (self));
#line 460 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp0_ = self->priv->outstanding_total;
#line 460 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	self->priv->outstanding_total = _tmp0_ + count;
#line 466 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	if (report) {
#line 2805 "MetadataWriter.c"
		guint _tmp1_;
		guint _tmp2_;
#line 467 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp1_ = self->priv->outstanding_completed;
#line 467 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp2_ = self->priv->outstanding_total;
#line 467 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		g_signal_emit (self, metadata_writer_signals[METADATA_WRITER_PROGRESS_SIGNAL], 0, _tmp1_, _tmp2_);
#line 2814 "MetadataWriter.c"
	}
}


static void
metadata_writer_count_cancelled_work (MetadataWriter* self,
                                      gint count,
                                      gboolean report)
{
	guint _tmp0_ = 0U;
	guint _tmp1_;
	guint _tmp3_;
	guint _tmp4_;
#line 470 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_return_if_fail (IS_METADATA_WRITER (self));
#line 471 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp1_ = self->priv->outstanding_total;
#line 471 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	if (_tmp1_ >= ((guint) count)) {
#line 2834 "MetadataWriter.c"
		guint _tmp2_;
#line 471 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp2_ = self->priv->outstanding_total;
#line 471 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp0_ = _tmp2_ - count;
#line 2840 "MetadataWriter.c"
	} else {
#line 471 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp0_ = (guint) 0;
#line 2844 "MetadataWriter.c"
	}
#line 471 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	self->priv->outstanding_total = _tmp0_;
#line 472 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp3_ = self->priv->outstanding_completed;
#line 472 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp4_ = self->priv->outstanding_total;
#line 472 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	if (_tmp3_ >= _tmp4_) {
#line 473 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		self->priv->outstanding_completed = (guint) 0;
#line 474 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		self->priv->outstanding_total = (guint) 0;
#line 2858 "MetadataWriter.c"
	}
#line 481 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	if (report) {
#line 2862 "MetadataWriter.c"
		guint _tmp5_;
		guint _tmp6_;
#line 482 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp5_ = self->priv->outstanding_completed;
#line 482 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp6_ = self->priv->outstanding_total;
#line 482 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		g_signal_emit (self, metadata_writer_signals[METADATA_WRITER_PROGRESS_SIGNAL], 0, _tmp5_, _tmp6_);
#line 2871 "MetadataWriter.c"
	}
}


static void
metadata_writer_count_completed_work (MetadataWriter* self,
                                      gint count,
                                      gboolean report)
{
	guint _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
#line 485 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_return_if_fail (IS_METADATA_WRITER (self));
#line 486 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp0_ = self->priv->outstanding_completed;
#line 486 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	self->priv->outstanding_completed = _tmp0_ + count;
#line 487 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp1_ = self->priv->outstanding_completed;
#line 487 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp2_ = self->priv->outstanding_total;
#line 487 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	if (_tmp1_ >= _tmp2_) {
#line 488 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		self->priv->outstanding_completed = (guint) 0;
#line 489 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		self->priv->outstanding_total = (guint) 0;
#line 2900 "MetadataWriter.c"
	}
#line 496 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	if (report) {
#line 2904 "MetadataWriter.c"
		guint _tmp3_;
		guint _tmp4_;
#line 497 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp3_ = self->priv->outstanding_completed;
#line 497 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp4_ = self->priv->outstanding_total;
#line 497 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		g_signal_emit (self, metadata_writer_signals[METADATA_WRITER_PROGRESS_SIGNAL], 0, _tmp3_, _tmp4_);
#line 2913 "MetadataWriter.c"
	}
}


static void
metadata_writer_schedule_if_dirty (MetadataWriter* self,
                                   GeeIterable* media_sources,
                                   const gchar* reason)
{
	GeeArrayList* photos = NULL;
	GeeArrayList* _tmp14_;
#line 500 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_return_if_fail (IS_METADATA_WRITER (self));
#line 500 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_return_if_fail (GEE_IS_ITERABLE (media_sources));
#line 500 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_return_if_fail (reason != NULL);
#line 501 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	photos = NULL;
#line 2933 "MetadataWriter.c"
	{
		GeeIterator* _media_it = NULL;
		GeeIterator* _tmp0_;
#line 502 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp0_ = gee_iterable_iterator (media_sources);
#line 502 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_media_it = _tmp0_;
#line 502 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		while (TRUE) {
#line 2943 "MetadataWriter.c"
			GeeIterator* _tmp1_;
			MediaSource* media = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			LibraryPhoto* photo = NULL;
			MediaSource* _tmp4_;
			LibraryPhoto* _tmp5_;
			LibraryPhoto* _tmp6_;
			GeeHashSet* _tmp7_;
			LibraryPhoto* _tmp8_;
			LibraryPhoto* _tmp9_;
#line 502 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp1_ = _media_it;
#line 502 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			if (!gee_iterator_next (_tmp1_)) {
#line 502 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				break;
#line 2961 "MetadataWriter.c"
			}
#line 502 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp2_ = _media_it;
#line 502 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp3_ = gee_iterator_get (_tmp2_);
#line 502 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			media = (MediaSource*) _tmp3_;
#line 503 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp4_ = media;
#line 503 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, TYPE_LIBRARY_PHOTO) ? ((LibraryPhoto*) _tmp4_) : NULL);
#line 503 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			photo = _tmp5_;
#line 504 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp6_ = photo;
#line 504 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			if (_tmp6_ == NULL) {
#line 505 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_g_object_unref0 (photo);
#line 505 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_g_object_unref0 (media);
#line 505 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				continue;
#line 2985 "MetadataWriter.c"
			}
#line 508 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp7_ = self->priv->importing_photos;
#line 508 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp8_ = photo;
#line 508 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			if (gee_abstract_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp8_)) {
#line 509 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_g_object_unref0 (photo);
#line 509 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_g_object_unref0 (media);
#line 509 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				continue;
#line 2999 "MetadataWriter.c"
			}
#line 511 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp9_ = photo;
#line 511 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			if (photo_is_master_metadata_dirty (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_PHOTO, Photo))) {
#line 3005 "MetadataWriter.c"
				GeeArrayList* _tmp10_;
				GeeArrayList* _tmp12_;
				LibraryPhoto* _tmp13_;
#line 512 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_tmp10_ = photos;
#line 512 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				if (_tmp10_ == NULL) {
#line 3013 "MetadataWriter.c"
					GeeArrayList* _tmp11_;
#line 513 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
					_tmp11_ = gee_array_list_new (TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 513 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
					_g_object_unref0 (photos);
#line 513 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
					photos = _tmp11_;
#line 3021 "MetadataWriter.c"
				}
#line 515 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_tmp12_ = photos;
#line 515 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_tmp13_ = photo;
#line 515 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp13_);
#line 3029 "MetadataWriter.c"
			}
#line 502 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_g_object_unref0 (photo);
#line 502 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_g_object_unref0 (media);
#line 3035 "MetadataWriter.c"
		}
#line 502 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_g_object_unref0 (_media_it);
#line 3039 "MetadataWriter.c"
	}
#line 519 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp14_ = photos;
#line 519 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	if (_tmp14_ != NULL) {
#line 3045 "MetadataWriter.c"
		GeeArrayList* _tmp15_;
#line 520 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp15_ = photos;
#line 520 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		metadata_writer_photos_are_dirty (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, GEE_TYPE_COLLECTION, GeeCollection), reason, TRUE);
#line 3051 "MetadataWriter.c"
	}
#line 500 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_g_object_unref0 (photos);
#line 3055 "MetadataWriter.c"
}


static void
metadata_writer_photos_are_dirty (MetadataWriter* self,
                                  GeeCollection* photos,
                                  const gchar* reason,
                                  gboolean already_marked)
{
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp22_ = FALSE;
	gboolean _tmp23_;
	gint _tmp32_;
	gint _tmp33_;
	GError * _inner_error_ = NULL;
#line 524 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_return_if_fail (IS_METADATA_WRITER (self));
#line 524 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_return_if_fail (GEE_IS_COLLECTION (photos));
#line 524 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_return_if_fail (reason != NULL);
#line 525 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp0_ = gee_collection_get_size (photos);
#line 525 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp1_ = _tmp0_;
#line 525 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	if (_tmp1_ == 0) {
#line 526 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		return;
#line 3086 "MetadataWriter.c"
	}
	{
		GeeIterator* _photo_it = NULL;
		GeeIterator* _tmp2_;
#line 529 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp2_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (photos, GEE_TYPE_ITERABLE, GeeIterable));
#line 529 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_photo_it = _tmp2_;
#line 529 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		while (TRUE) {
#line 3097 "MetadataWriter.c"
			GeeIterator* _tmp3_;
			LibraryPhoto* photo = NULL;
			GeeIterator* _tmp4_;
			gpointer _tmp5_;
			LibraryPhoto* _tmp6_;
#line 529 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp3_ = _photo_it;
#line 529 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			if (!gee_iterator_next (_tmp3_)) {
#line 529 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				break;
#line 3109 "MetadataWriter.c"
			}
#line 529 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp4_ = _photo_it;
#line 529 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp5_ = gee_iterator_get (_tmp4_);
#line 529 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			photo = (LibraryPhoto*) _tmp5_;
#line 530 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp6_ = photo;
#line 530 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			metadata_writer_cancel_job (self, _tmp6_);
#line 529 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_g_object_unref0 (photo);
#line 3123 "MetadataWriter.c"
		}
#line 529 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_g_object_unref0 (_photo_it);
#line 3127 "MetadataWriter.c"
	}
#line 533 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	if (!already_marked) {
#line 3131 "MetadataWriter.c"
		{
			LibraryPhotoSourceCollection* _tmp7_;
			TransactionController* _tmp8_;
			TransactionController* _tmp9_;
			LibraryPhotoSourceCollection* _tmp15_;
			TransactionController* _tmp16_;
			TransactionController* _tmp17_;
#line 535 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp7_ = library_photo_global;
#line 535 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp8_ = media_source_collection_get_transaction_controller (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection));
#line 535 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp9_ = _tmp8_;
#line 535 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			transaction_controller_begin (_tmp9_);
#line 3147 "MetadataWriter.c"
			{
				GeeIterator* _photo_it = NULL;
				GeeIterator* _tmp10_;
#line 537 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_tmp10_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (photos, GEE_TYPE_ITERABLE, GeeIterable));
#line 537 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_photo_it = _tmp10_;
#line 537 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				while (TRUE) {
#line 3157 "MetadataWriter.c"
					GeeIterator* _tmp11_;
					LibraryPhoto* photo = NULL;
					GeeIterator* _tmp12_;
					gpointer _tmp13_;
					LibraryPhoto* _tmp14_;
#line 537 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
					_tmp11_ = _photo_it;
#line 537 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
					if (!gee_iterator_next (_tmp11_)) {
#line 537 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
						break;
#line 3169 "MetadataWriter.c"
					}
#line 537 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
					_tmp12_ = _photo_it;
#line 537 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
					_tmp13_ = gee_iterator_get (_tmp12_);
#line 537 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
					photo = (LibraryPhoto*) _tmp13_;
#line 538 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
					_tmp14_ = photo;
#line 538 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
					photo_set_master_metadata_dirty (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, TYPE_PHOTO, Photo), TRUE, &_inner_error_);
#line 538 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 538 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
						_g_object_unref0 (photo);
#line 538 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
						_g_object_unref0 (_photo_it);
#line 3187 "MetadataWriter.c"
						goto __catch563_g_error;
					}
#line 537 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
					_g_object_unref0 (photo);
#line 3192 "MetadataWriter.c"
				}
#line 537 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_g_object_unref0 (_photo_it);
#line 3196 "MetadataWriter.c"
			}
#line 540 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp15_ = library_photo_global;
#line 540 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp16_ = media_source_collection_get_transaction_controller (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection));
#line 540 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp17_ = _tmp16_;
#line 540 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			transaction_controller_commit (_tmp17_);
#line 3206 "MetadataWriter.c"
		}
		goto __finally563;
		__catch563_g_error:
		{
			GError* err = NULL;
			GError* _tmp18_;
#line 534 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			err = _inner_error_;
#line 534 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_inner_error_ = NULL;
#line 542 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp18_ = err;
#line 542 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			if (_tmp18_->domain == DATABASE_ERROR) {
#line 3221 "MetadataWriter.c"
				GError* _tmp19_;
#line 543 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_tmp19_ = err;
#line 543 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				app_window_database_error ((GError*) _tmp19_);
#line 3227 "MetadataWriter.c"
			} else {
				GError* _tmp20_;
				const gchar* _tmp21_;
#line 545 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_tmp20_ = err;
#line 545 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_tmp21_ = _tmp20_->message;
#line 545 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				g_error ("MetadataWriter.vala:545: Unable to mark metadata as dirty: %s", _tmp21_);
#line 3237 "MetadataWriter.c"
			}
#line 534 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_g_error_free0 (err);
#line 3241 "MetadataWriter.c"
		}
		__finally563:
#line 534 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 534 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 534 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			g_clear_error (&_inner_error_);
#line 534 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			return;
#line 3252 "MetadataWriter.c"
		}
	}
#line 551 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp23_ = self->priv->closed;
#line 551 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	if (_tmp23_) {
#line 551 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp22_ = TRUE;
#line 3261 "MetadataWriter.c"
	} else {
		gboolean _tmp24_;
#line 551 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp24_ = self->priv->enabled;
#line 551 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp22_ = !_tmp24_;
#line 3268 "MetadataWriter.c"
	}
#line 551 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	if (_tmp22_) {
#line 552 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		return;
#line 3274 "MetadataWriter.c"
	}
	{
		GeeIterator* _photo_it = NULL;
		GeeIterator* _tmp25_;
#line 558 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp25_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (photos, GEE_TYPE_ITERABLE, GeeIterable));
#line 558 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_photo_it = _tmp25_;
#line 558 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		while (TRUE) {
#line 3285 "MetadataWriter.c"
			GeeIterator* _tmp26_;
			LibraryPhoto* photo = NULL;
			GeeIterator* _tmp27_;
			gpointer _tmp28_;
			gboolean enqueued = FALSE;
			HashTimedQueue* _tmp29_;
			LibraryPhoto* _tmp30_;
			gboolean _tmp31_;
#line 558 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp26_ = _photo_it;
#line 558 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			if (!gee_iterator_next (_tmp26_)) {
#line 558 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				break;
#line 3300 "MetadataWriter.c"
			}
#line 558 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp27_ = _photo_it;
#line 558 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp28_ = gee_iterator_get (_tmp27_);
#line 558 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			photo = (LibraryPhoto*) _tmp28_;
#line 559 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp29_ = self->priv->dirty;
#line 559 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp30_ = photo;
#line 559 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			enqueued = timed_queue_enqueue (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, TYPE_TIMED_QUEUE, TimedQueue), _tmp30_);
#line 560 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp31_ = enqueued;
#line 560 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_vala_assert (_tmp31_, "enqueued");
#line 558 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_g_object_unref0 (photo);
#line 3320 "MetadataWriter.c"
		}
#line 558 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_g_object_unref0 (_photo_it);
#line 3324 "MetadataWriter.c"
	}
#line 563 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp32_ = gee_collection_get_size (photos);
#line 563 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp33_ = _tmp32_;
#line 563 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	metadata_writer_count_enqueued_work (self, _tmp33_, TRUE);
#line 3332 "MetadataWriter.c"
}


static void
metadata_writer_cancel_all (MetadataWriter* self,
                            gboolean wait)
{
	HashTimedQueue* _tmp0_;
#line 566 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_return_if_fail (IS_METADATA_WRITER (self));
#line 567 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp0_ = self->priv->dirty;
#line 567 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	timed_queue_clear (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_TIMED_QUEUE, TimedQueue));
#line 3347 "MetadataWriter.c"
	{
		GeeIterator* _job_it = NULL;
		GeeHashMap* _tmp1_;
		GeeCollection* _tmp2_;
		GeeCollection* _tmp3_;
		GeeCollection* _tmp4_;
		GeeIterator* _tmp5_;
		GeeIterator* _tmp6_;
#line 569 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp1_ = self->priv->pending;
#line 569 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp2_ = gee_abstract_map_get_values (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
#line 569 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp3_ = _tmp2_;
#line 569 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp4_ = _tmp3_;
#line 569 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp5_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_ITERABLE, GeeIterable));
#line 569 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp6_ = _tmp5_;
#line 569 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_g_object_unref0 (_tmp4_);
#line 569 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_job_it = _tmp6_;
#line 569 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		while (TRUE) {
#line 3374 "MetadataWriter.c"
			GeeIterator* _tmp7_;
			MetadataWriterCommitJob* job = NULL;
			GeeIterator* _tmp8_;
			gpointer _tmp9_;
			MetadataWriterCommitJob* _tmp10_;
#line 569 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp7_ = _job_it;
#line 569 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			if (!gee_iterator_next (_tmp7_)) {
#line 569 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				break;
#line 3386 "MetadataWriter.c"
			}
#line 569 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp8_ = _job_it;
#line 569 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp9_ = gee_iterator_get (_tmp8_);
#line 569 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			job = (MetadataWriterCommitJob*) _tmp9_;
#line 570 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp10_ = job;
#line 570 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			background_job_cancel (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_BACKGROUND_JOB, BackgroundJob));
#line 569 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_background_job_unref0 (job);
#line 3400 "MetadataWriter.c"
		}
#line 569 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_g_object_unref0 (_job_it);
#line 3404 "MetadataWriter.c"
	}
#line 572 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	if (wait) {
#line 3408 "MetadataWriter.c"
		Workers* _tmp11_;
#line 573 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp11_ = self->priv->workers;
#line 573 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		workers_wait_for_empty_queue (_tmp11_);
#line 3414 "MetadataWriter.c"
	}
#line 575 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	metadata_writer_count_cancelled_work (self, G_MAXINT, TRUE);
#line 3418 "MetadataWriter.c"
}


static gboolean
metadata_writer_cancel_job (MetadataWriter* self,
                            LibraryPhoto* photo)
{
	gboolean result = FALSE;
	gboolean cancelled = FALSE;
	GeeHashMap* _tmp0_;
	HashTimedQueue* _tmp7_;
#line 578 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_return_val_if_fail (IS_METADATA_WRITER (self), FALSE);
#line 578 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_return_val_if_fail (IS_LIBRARY_PHOTO (photo), FALSE);
#line 579 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	cancelled = FALSE;
#line 581 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp0_ = self->priv->pending;
#line 581 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	if (gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), photo)) {
#line 3440 "MetadataWriter.c"
		MetadataWriterCommitJob* j = NULL;
		GeeHashMap* _tmp1_;
		gpointer _tmp2_;
		GeeHashSet* _tmp3_;
		MetadataWriterCommitJob* _tmp4_;
		MetadataWriterCommitJob* _tmp5_;
		GeeHashMap* _tmp6_;
#line 582 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp1_ = self->priv->pending;
#line 582 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp2_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), photo);
#line 582 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		j = G_TYPE_CHECK_INSTANCE_CAST ((MetadataWriterCommitJob*) _tmp2_, METADATA_WRITER_TYPE_COMMIT_JOB, MetadataWriterCommitJob);
#line 583 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp3_ = self->priv->pending_cancel;
#line 583 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp4_ = j;
#line 583 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp4_);
#line 584 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp5_ = j;
#line 584 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		background_job_cancel (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_BACKGROUND_JOB, BackgroundJob));
#line 585 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp6_ = self->priv->pending;
#line 585 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), photo, NULL);
#line 586 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		cancelled = TRUE;
#line 581 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_background_job_unref0 (j);
#line 3472 "MetadataWriter.c"
	}
#line 589 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp7_ = self->priv->dirty;
#line 589 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	if (timed_queue_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_TIMED_QUEUE, TimedQueue), photo)) {
#line 3478 "MetadataWriter.c"
		gboolean removed = FALSE;
		HashTimedQueue* _tmp8_;
		gboolean _tmp9_;
		HashTimedQueue* _tmp10_;
#line 590 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp8_ = self->priv->dirty;
#line 590 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		removed = timed_queue_remove_first (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_TIMED_QUEUE, TimedQueue), photo);
#line 591 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp9_ = removed;
#line 591 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_vala_assert (_tmp9_, "removed");
#line 593 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp10_ = self->priv->dirty;
#line 593 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_vala_assert (!timed_queue_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_TIMED_QUEUE, TimedQueue), photo), "!dirty.contains(photo)");
#line 595 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		metadata_writer_count_cancelled_work (self, 1, FALSE);
#line 596 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		cancelled = TRUE;
#line 3499 "MetadataWriter.c"
	}
#line 599 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	result = cancelled;
#line 599 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	return result;
#line 3505 "MetadataWriter.c"
}


static void
metadata_writer_on_photo_dequeued (MetadataWriter* self,
                                   LibraryPhoto* photo)
{
	gboolean _tmp0_;
	GeeSet* keywords = NULL;
	GeeCollection* tags = NULL;
	TagSourceCollection* _tmp1_;
	GeeList* _tmp2_;
	GeeCollection* _tmp3_;
	GeeHashMap* _tmp14_;
	MetadataWriterCommitJob* job = NULL;
	GeeSet* _tmp15_;
	MetadataWriterCommitJob* _tmp16_;
	GeeHashMap* _tmp17_;
	MetadataWriterCommitJob* _tmp18_;
	Workers* _tmp19_;
	MetadataWriterCommitJob* _tmp20_;
#line 602 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_return_if_fail (IS_METADATA_WRITER (self));
#line 602 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_return_if_fail (IS_LIBRARY_PHOTO (photo));
#line 603 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp0_ = self->priv->enabled;
#line 603 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	if (!_tmp0_) {
#line 604 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		metadata_writer_count_cancelled_work (self, 1, TRUE);
#line 606 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		return;
#line 3539 "MetadataWriter.c"
	}
#line 609 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	keywords = NULL;
#line 610 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp1_ = tag_global;
#line 610 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp2_ = tag_source_collection_fetch_for_source (_tmp1_, G_TYPE_CHECK_INSTANCE_CAST (photo, TYPE_MEDIA_SOURCE, MediaSource));
#line 610 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	tags = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_COLLECTION, GeeCollection);
#line 611 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp3_ = tags;
#line 611 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	if (_tmp3_ != NULL) {
#line 3553 "MetadataWriter.c"
		GeeHashSet* _tmp4_;
#line 612 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp4_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
#line 612 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_g_object_unref0 (keywords);
#line 612 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		keywords = G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_SET, GeeSet);
#line 3561 "MetadataWriter.c"
		{
			GeeIterator* _tag_it = NULL;
			GeeCollection* _tmp5_;
			GeeIterator* _tmp6_;
#line 613 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp5_ = tags;
#line 613 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp6_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_ITERABLE, GeeIterable));
#line 613 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tag_it = _tmp6_;
#line 613 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			while (TRUE) {
#line 3574 "MetadataWriter.c"
				GeeIterator* _tmp7_;
				Tag* tag = NULL;
				GeeIterator* _tmp8_;
				gpointer _tmp9_;
				GeeSet* _tmp10_;
				Tag* _tmp11_;
				gchar* _tmp12_;
				gchar* _tmp13_;
#line 613 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_tmp7_ = _tag_it;
#line 613 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				if (!gee_iterator_next (_tmp7_)) {
#line 613 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
					break;
#line 3589 "MetadataWriter.c"
				}
#line 613 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_tmp8_ = _tag_it;
#line 613 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_tmp9_ = gee_iterator_get (_tmp8_);
#line 613 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				tag = (Tag*) _tmp9_;
#line 614 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_tmp10_ = keywords;
#line 614 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_tmp11_ = tag;
#line 614 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_tmp12_ = data_object_get_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, TYPE_DATA_OBJECT, DataObject));
#line 614 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_tmp13_ = _tmp12_;
#line 614 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_COLLECTION, GeeCollection), _tmp13_);
#line 614 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_g_free0 (_tmp13_);
#line 613 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_g_object_unref0 (tag);
#line 3611 "MetadataWriter.c"
			}
#line 613 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_g_object_unref0 (_tag_it);
#line 3615 "MetadataWriter.c"
		}
	}
#line 618 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp14_ = self->priv->pending;
#line 618 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	if (gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), photo)) {
#line 619 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		metadata_writer_cancel_job (self, photo);
#line 3624 "MetadataWriter.c"
	}
#line 621 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp15_ = keywords;
#line 621 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp16_ = metadata_writer_commit_job_new (self, photo, _tmp15_);
#line 621 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	job = _tmp16_;
#line 622 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp17_ = self->priv->pending;
#line 622 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp18_ = job;
#line 622 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), photo, _tmp18_);
#line 628 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp19_ = self->priv->workers;
#line 628 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp20_ = job;
#line 628 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	workers_enqueue (_tmp19_, G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, TYPE_BACKGROUND_JOB, BackgroundJob));
#line 602 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_background_job_unref0 (job);
#line 602 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_g_object_unref0 (tags);
#line 602 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_g_object_unref0 (keywords);
#line 3650 "MetadataWriter.c"
}


static gpointer
_background_job_ref0 (gpointer self)
{
#line 632 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	return self ? background_job_ref (self) : NULL;
#line 3659 "MetadataWriter.c"
}


static void
metadata_writer_on_update_completed (MetadataWriter* self,
                                     BackgroundJob* j)
{
	MetadataWriterCommitJob* job = NULL;
	MetadataWriterCommitJob* _tmp0_;
	MetadataWriterCommitJob* _tmp1_;
	GError* _tmp2_;
	gboolean removed = FALSE;
	GeeHashMap* _tmp43_;
	MetadataWriterCommitJob* _tmp44_;
	LibraryPhoto* _tmp45_;
	gboolean _tmp46_;
	gboolean _tmp47_;
	LibraryPhotoSourceCollection* _tmp48_;
	TransactionController* _tmp49_;
	TransactionController* _tmp50_;
	gboolean _tmp51_ = FALSE;
	MetadataWriterCommitJob* _tmp52_;
	PhotoReimportMasterState* _tmp53_;
	LibraryPhotoSourceCollection* _tmp85_;
	TransactionController* _tmp86_;
	TransactionController* _tmp87_;
	GError * _inner_error_ = NULL;
#line 631 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_return_if_fail (IS_METADATA_WRITER (self));
#line 631 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_return_if_fail (IS_BACKGROUND_JOB (j));
#line 632 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp0_ = _background_job_ref0 (G_TYPE_CHECK_INSTANCE_CAST (j, METADATA_WRITER_TYPE_COMMIT_JOB, MetadataWriterCommitJob));
#line 632 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	job = _tmp0_;
#line 634 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp1_ = job;
#line 634 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp2_ = _tmp1_->err;
#line 634 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	if (_tmp2_ != NULL) {
#line 3701 "MetadataWriter.c"
		MetadataWriterCommitJob* _tmp3_;
		LibraryPhoto* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		MetadataWriterCommitJob* _tmp7_;
		GError* _tmp8_;
		const gchar* _tmp9_;
#line 635 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp3_ = job;
#line 635 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp4_ = _tmp3_->photo;
#line 635 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp5_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_DATA_OBJECT, DataObject));
#line 635 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp6_ = _tmp5_;
#line 635 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp7_ = job;
#line 635 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp8_ = _tmp7_->err;
#line 635 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp9_ = _tmp8_->message;
#line 635 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		g_warning ("MetadataWriter.vala:635: Unable to write metadata to %s: %s", _tmp6_, _tmp9_);
#line 635 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_g_free0 (_tmp6_);
#line 3727 "MetadataWriter.c"
	} else {
		MetadataWriterCommitJob* _tmp10_;
		gboolean _tmp11_;
		MetadataWriterCommitJob* _tmp24_;
		LibraryPhoto* _tmp25_;
		GFile* _tmp26_;
		GFile* _tmp27_;
		gboolean _tmp28_;
#line 637 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp10_ = job;
#line 637 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp11_ = _tmp10_->wrote_master;
#line 637 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		if (_tmp11_) {
#line 3742 "MetadataWriter.c"
			MetadataWriterCommitJob* _tmp12_;
			LibraryPhoto* _tmp13_;
			GFile* _tmp14_;
			GFile* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
#line 638 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp12_ = job;
#line 638 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp13_ = _tmp12_->photo;
#line 638 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp14_ = media_source_get_master_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, TYPE_MEDIA_SOURCE, MediaSource));
#line 638 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp15_ = _tmp14_;
#line 638 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp16_ = g_file_get_path (_tmp15_);
#line 638 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp17_ = _tmp16_;
#line 638 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			g_message ("MetadataWriter.vala:638: Completed writing metadata to %s", _tmp17_);
#line 638 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_g_free0 (_tmp17_);
#line 638 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_g_object_unref0 (_tmp15_);
#line 3767 "MetadataWriter.c"
		} else {
			MetadataWriterCommitJob* _tmp18_;
			LibraryPhoto* _tmp19_;
			GFile* _tmp20_;
			GFile* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
#line 640 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp18_ = job;
#line 640 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp19_ = _tmp18_->photo;
#line 640 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp20_ = media_source_get_master_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, TYPE_MEDIA_SOURCE, MediaSource));
#line 640 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp21_ = _tmp20_;
#line 640 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp22_ = g_file_get_path (_tmp21_);
#line 640 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp23_ = _tmp22_;
#line 640 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			g_message ("MetadataWriter.vala:640: Unable to write metadata to %s", _tmp23_);
#line 640 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_g_free0 (_tmp23_);
#line 640 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_g_object_unref0 (_tmp21_);
#line 3793 "MetadataWriter.c"
		}
#line 642 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp24_ = job;
#line 642 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp25_ = _tmp24_->photo;
#line 642 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp26_ = photo_get_editable_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, TYPE_PHOTO, Photo));
#line 642 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp27_ = _tmp26_;
#line 642 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp28_ = _tmp27_ != NULL;
#line 642 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_g_object_unref0 (_tmp27_);
#line 642 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		if (_tmp28_) {
#line 3809 "MetadataWriter.c"
			MetadataWriterCommitJob* _tmp29_;
			gboolean _tmp30_;
#line 643 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp29_ = job;
#line 643 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp30_ = _tmp29_->wrote_editable;
#line 643 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			if (_tmp30_) {
#line 3818 "MetadataWriter.c"
				MetadataWriterCommitJob* _tmp31_;
				LibraryPhoto* _tmp32_;
				GFile* _tmp33_;
				GFile* _tmp34_;
				gchar* _tmp35_;
				gchar* _tmp36_;
#line 644 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_tmp31_ = job;
#line 644 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_tmp32_ = _tmp31_->photo;
#line 644 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_tmp33_ = photo_get_editable_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, TYPE_PHOTO, Photo));
#line 644 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_tmp34_ = _tmp33_;
#line 644 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_tmp35_ = g_file_get_path (_tmp34_);
#line 644 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_tmp36_ = _tmp35_;
#line 644 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				g_message ("MetadataWriter.vala:644: Completed writing metadata to %s", _tmp36_);
#line 644 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_g_free0 (_tmp36_);
#line 644 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_g_object_unref0 (_tmp34_);
#line 3843 "MetadataWriter.c"
			} else {
				MetadataWriterCommitJob* _tmp37_;
				LibraryPhoto* _tmp38_;
				GFile* _tmp39_;
				GFile* _tmp40_;
				gchar* _tmp41_;
				gchar* _tmp42_;
#line 646 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_tmp37_ = job;
#line 646 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_tmp38_ = _tmp37_->photo;
#line 646 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_tmp39_ = photo_get_editable_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, TYPE_PHOTO, Photo));
#line 646 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_tmp40_ = _tmp39_;
#line 646 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_tmp41_ = g_file_get_path (_tmp40_);
#line 646 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_tmp42_ = _tmp41_;
#line 646 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				g_message ("MetadataWriter.vala:646: Unable to write metadata to %s", _tmp42_);
#line 646 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_g_free0 (_tmp42_);
#line 646 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_g_object_unref0 (_tmp40_);
#line 3869 "MetadataWriter.c"
			}
		}
	}
#line 650 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp43_ = self->priv->pending;
#line 650 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp44_ = job;
#line 650 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp45_ = _tmp44_->photo;
#line 650 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp46_ = gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp43_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp45_, NULL);
#line 650 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	removed = _tmp46_;
#line 651 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp47_ = removed;
#line 651 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_vala_assert (_tmp47_, "removed");
#line 655 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp48_ = library_photo_global;
#line 655 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp49_ = media_source_collection_get_transaction_controller (G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection));
#line 655 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp50_ = _tmp49_;
#line 655 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	transaction_controller_begin (_tmp50_);
#line 657 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp52_ = job;
#line 657 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp53_ = _tmp52_->reimport_master_state;
#line 657 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	if (_tmp53_ != NULL) {
#line 657 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp51_ = TRUE;
#line 3903 "MetadataWriter.c"
	} else {
		MetadataWriterCommitJob* _tmp54_;
		PhotoReimportEditableState* _tmp55_;
#line 657 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp54_ = job;
#line 657 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp55_ = _tmp54_->reimport_editable_state;
#line 657 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp51_ = _tmp55_ != NULL;
#line 3913 "MetadataWriter.c"
	}
#line 657 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	if (_tmp51_) {
#line 3917 "MetadataWriter.c"
		LibraryPhoto* _tmp56_;
		MetadataWriterCommitJob* _tmp57_;
		LibraryPhoto* _tmp58_;
		LibraryPhoto* _tmp59_;
#line 660 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp56_ = self->priv->ignore_photo_alteration;
#line 660 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_vala_assert (_tmp56_ == NULL, "ignore_photo_alteration == null");
#line 661 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp57_ = job;
#line 661 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp58_ = _tmp57_->photo;
#line 661 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp59_ = _g_object_ref0 (_tmp58_);
#line 661 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_g_object_unref0 (self->priv->ignore_photo_alteration);
#line 661 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		self->priv->ignore_photo_alteration = _tmp59_;
#line 3936 "MetadataWriter.c"
		{
			MetadataWriterCommitJob* _tmp60_;
			PhotoReimportMasterState* _tmp61_;
			MetadataWriterCommitJob* _tmp69_;
			PhotoReimportEditableState* _tmp70_;
#line 663 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp60_ = job;
#line 663 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp61_ = _tmp60_->reimport_master_state;
#line 663 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			if (_tmp61_ != NULL) {
#line 3948 "MetadataWriter.c"
				MetadataWriterCommitJob* _tmp62_;
				LibraryPhoto* _tmp63_;
				MetadataWriterCommitJob* _tmp64_;
				PhotoReimportMasterState* _tmp65_;
#line 664 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_tmp62_ = job;
#line 664 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_tmp63_ = _tmp62_->photo;
#line 664 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_tmp64_ = job;
#line 664 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_tmp65_ = _tmp64_->reimport_master_state;
#line 664 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				photo_finish_update_master_metadata (G_TYPE_CHECK_INSTANCE_CAST (_tmp63_, TYPE_PHOTO, Photo), _tmp65_, &_inner_error_);
#line 664 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 664 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
					if (_inner_error_->domain == DATABASE_ERROR) {
#line 3967 "MetadataWriter.c"
						goto __catch564_database_error;
					}
					{
						LibraryPhoto* _tmp66_;
						MetadataWriterCommitJob* _tmp67_;
						LibraryPhoto* _tmp68_;
#line 672 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
						_tmp66_ = self->priv->ignore_photo_alteration;
#line 672 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
						_tmp67_ = job;
#line 672 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
						_tmp68_ = _tmp67_->photo;
#line 672 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
						_vala_assert (_tmp66_ == _tmp68_, "ignore_photo_alteration == job.photo");
#line 673 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
						_g_object_unref0 (self->priv->ignore_photo_alteration);
#line 673 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
						self->priv->ignore_photo_alteration = NULL;
#line 3986 "MetadataWriter.c"
					}
#line 664 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
					_background_job_unref0 (job);
#line 664 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 664 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
					g_clear_error (&_inner_error_);
#line 664 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
					return;
#line 3996 "MetadataWriter.c"
				}
			}
#line 666 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp69_ = job;
#line 666 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp70_ = _tmp69_->reimport_editable_state;
#line 666 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			if (_tmp70_ != NULL) {
#line 4005 "MetadataWriter.c"
				MetadataWriterCommitJob* _tmp71_;
				LibraryPhoto* _tmp72_;
				MetadataWriterCommitJob* _tmp73_;
				PhotoReimportEditableState* _tmp74_;
#line 667 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_tmp71_ = job;
#line 667 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_tmp72_ = _tmp71_->photo;
#line 667 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_tmp73_ = job;
#line 667 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_tmp74_ = _tmp73_->reimport_editable_state;
#line 667 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				photo_finish_update_editable_metadata (G_TYPE_CHECK_INSTANCE_CAST (_tmp72_, TYPE_PHOTO, Photo), _tmp74_, &_inner_error_);
#line 667 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 667 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
					if (_inner_error_->domain == DATABASE_ERROR) {
#line 4024 "MetadataWriter.c"
						goto __catch564_database_error;
					}
					{
						LibraryPhoto* _tmp75_;
						MetadataWriterCommitJob* _tmp76_;
						LibraryPhoto* _tmp77_;
#line 672 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
						_tmp75_ = self->priv->ignore_photo_alteration;
#line 672 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
						_tmp76_ = job;
#line 672 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
						_tmp77_ = _tmp76_->photo;
#line 672 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
						_vala_assert (_tmp75_ == _tmp77_, "ignore_photo_alteration == job.photo");
#line 673 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
						_g_object_unref0 (self->priv->ignore_photo_alteration);
#line 673 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
						self->priv->ignore_photo_alteration = NULL;
#line 4043 "MetadataWriter.c"
					}
#line 667 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
					_background_job_unref0 (job);
#line 667 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 667 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
					g_clear_error (&_inner_error_);
#line 667 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
					return;
#line 4053 "MetadataWriter.c"
				}
			}
		}
		goto __finally564;
		__catch564_database_error:
		{
			GError* err = NULL;
			GError* _tmp78_;
#line 662 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			err = _inner_error_;
#line 662 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_inner_error_ = NULL;
#line 669 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp78_ = err;
#line 669 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			app_window_database_error (_tmp78_);
#line 662 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_g_error_free0 (err);
#line 4072 "MetadataWriter.c"
		}
		__finally564:
		{
			LibraryPhoto* _tmp79_;
			MetadataWriterCommitJob* _tmp80_;
			LibraryPhoto* _tmp81_;
#line 672 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp79_ = self->priv->ignore_photo_alteration;
#line 672 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp80_ = job;
#line 672 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp81_ = _tmp80_->photo;
#line 672 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_vala_assert (_tmp79_ == _tmp81_, "ignore_photo_alteration == job.photo");
#line 673 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_g_object_unref0 (self->priv->ignore_photo_alteration);
#line 673 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			self->priv->ignore_photo_alteration = NULL;
#line 4091 "MetadataWriter.c"
		}
#line 662 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 662 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_background_job_unref0 (job);
#line 662 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 662 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			g_clear_error (&_inner_error_);
#line 662 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			return;
#line 4103 "MetadataWriter.c"
		}
	} else {
	}
	{
		MetadataWriterCommitJob* _tmp82_;
		LibraryPhoto* _tmp83_;
#line 683 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp82_ = job;
#line 683 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp83_ = _tmp82_->photo;
#line 683 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		photo_set_master_metadata_dirty (G_TYPE_CHECK_INSTANCE_CAST (_tmp83_, TYPE_PHOTO, Photo), FALSE, &_inner_error_);
#line 683 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 683 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 4120 "MetadataWriter.c"
				goto __catch565_database_error;
			}
#line 683 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_background_job_unref0 (job);
#line 683 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 683 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			g_clear_error (&_inner_error_);
#line 683 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			return;
#line 4131 "MetadataWriter.c"
		}
	}
	goto __finally565;
	__catch565_database_error:
	{
		GError* err = NULL;
		GError* _tmp84_;
#line 682 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		err = _inner_error_;
#line 682 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_inner_error_ = NULL;
#line 685 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp84_ = err;
#line 685 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		app_window_database_error (_tmp84_);
#line 682 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_g_error_free0 (err);
#line 4149 "MetadataWriter.c"
	}
	__finally565:
#line 682 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 682 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_background_job_unref0 (job);
#line 682 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 682 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		g_clear_error (&_inner_error_);
#line 682 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		return;
#line 4162 "MetadataWriter.c"
	}
#line 688 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp85_ = library_photo_global;
#line 688 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp86_ = media_source_collection_get_transaction_controller (G_TYPE_CHECK_INSTANCE_CAST (_tmp85_, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection));
#line 688 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp87_ = _tmp86_;
#line 688 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	transaction_controller_commit (_tmp87_);
#line 690 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	metadata_writer_count_completed_work (self, 1, TRUE);
#line 631 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_background_job_unref0 (job);
#line 4176 "MetadataWriter.c"
}


static void
metadata_writer_on_update_cancelled (MetadataWriter* self,
                                     BackgroundJob* j)
{
	gboolean removed = FALSE;
	GeeHashSet* _tmp0_;
#line 693 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_return_if_fail (IS_METADATA_WRITER (self));
#line 693 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_return_if_fail (IS_BACKGROUND_JOB (j));
#line 694 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp0_ = self->priv->pending_cancel;
#line 694 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	removed = gee_abstract_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), G_TYPE_CHECK_INSTANCE_CAST (j, METADATA_WRITER_TYPE_COMMIT_JOB, MetadataWriterCommitJob));
#line 695 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_vala_assert (removed, "removed");
#line 697 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	metadata_writer_count_cancelled_work (self, 1, TRUE);
#line 4198 "MetadataWriter.c"
}


static void
g_cclosure_user_marshal_VOID__UINT_UINT (GClosure * closure,
                                         GValue * return_value,
                                         guint n_param_values,
                                         const GValue * param_values,
                                         gpointer invocation_hint,
                                         gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__UINT_UINT) (gpointer data1, guint arg_1, guint arg_2, gpointer data2);
	register GMarshalFunc_VOID__UINT_UINT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 14 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_return_if_fail (n_param_values == 3);
#line 14 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 14 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		data1 = closure->data;
#line 14 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		data2 = param_values->data[0].v_pointer;
#line 4224 "MetadataWriter.c"
	} else {
#line 14 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		data1 = param_values->data[0].v_pointer;
#line 14 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		data2 = closure->data;
#line 4230 "MetadataWriter.c"
	}
#line 14 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	callback = (GMarshalFunc_VOID__UINT_UINT) (marshal_data ? marshal_data : cc->callback);
#line 14 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	callback (data1, g_value_get_uint (param_values + 1), g_value_get_uint (param_values + 2), data2);
#line 4236 "MetadataWriter.c"
}


static void
_metadata_writer_on_update_completed_completion_callback (BackgroundJob* job,
                                                          gpointer self)
{
#line 30 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	metadata_writer_on_update_completed ((MetadataWriter*) self, job);
#line 4246 "MetadataWriter.c"
}


static void
_metadata_writer_on_update_cancelled_cancellation_callback (BackgroundJob* job,
                                                            gpointer self)
{
#line 30 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	metadata_writer_on_update_cancelled ((MetadataWriter*) self, job);
#line 4256 "MetadataWriter.c"
}


static MetadataWriterCommitJob*
metadata_writer_commit_job_construct (GType object_type,
                                      MetadataWriter* owner,
                                      LibraryPhoto* photo,
                                      GeeSet* keywords)
{
	MetadataWriterCommitJob* self = NULL;
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
	LibraryPhoto* _tmp2_;
	GeeSet* _tmp3_;
#line 29 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_return_val_if_fail (IS_METADATA_WRITER (owner), NULL);
#line 29 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_return_val_if_fail (IS_LIBRARY_PHOTO (photo), NULL);
#line 29 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_return_val_if_fail ((keywords == NULL) || GEE_IS_SET (keywords), NULL);
#line 30 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp0_ = g_cancellable_new ();
#line 30 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp1_ = _tmp0_;
#line 30 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	self = (MetadataWriterCommitJob*) background_job_construct (object_type, G_TYPE_CHECK_INSTANCE_CAST (owner, G_TYPE_OBJECT, GObject), _metadata_writer_on_update_completed_completion_callback, owner, _tmp1_, _metadata_writer_on_update_cancelled_cancellation_callback, owner, NULL);
#line 30 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_g_object_unref0 (_tmp1_);
#line 32 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp2_ = _g_object_ref0 (photo);
#line 32 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_g_object_unref0 (self->photo);
#line 32 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	self->photo = _tmp2_;
#line 33 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp3_ = _g_object_ref0 (keywords);
#line 33 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_g_object_unref0 (self->current_keywords);
#line 33 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	self->current_keywords = _tmp3_;
#line 29 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	return self;
#line 4299 "MetadataWriter.c"
}


static MetadataWriterCommitJob*
metadata_writer_commit_job_new (MetadataWriter* owner,
                                LibraryPhoto* photo,
                                GeeSet* keywords)
{
#line 29 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	return metadata_writer_commit_job_construct (METADATA_WRITER_TYPE_COMMIT_JOB, owner, photo, keywords);
#line 4310 "MetadataWriter.c"
}


static gpointer
_g_error_copy0 (gpointer self)
{
#line 41 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	return self ? g_error_copy (self) : NULL;
#line 4319 "MetadataWriter.c"
}


static void
metadata_writer_commit_job_real_execute (BackgroundJob* base)
{
	MetadataWriterCommitJob * self;
	GError * _inner_error_ = NULL;
#line 36 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, METADATA_WRITER_TYPE_COMMIT_JOB, MetadataWriterCommitJob);
#line 4330 "MetadataWriter.c"
	{
#line 38 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		metadata_writer_commit_job_commit_master (self, &_inner_error_);
#line 38 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 4336 "MetadataWriter.c"
			goto __catch566_g_error;
		}
#line 39 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		metadata_writer_commit_job_commit_editable (self, &_inner_error_);
#line 39 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 4343 "MetadataWriter.c"
			goto __catch566_g_error;
		}
	}
	goto __finally566;
	__catch566_g_error:
	{
		GError* err = NULL;
		GError* _tmp0_;
		GError* _tmp1_;
#line 37 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		err = _inner_error_;
#line 37 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_inner_error_ = NULL;
#line 41 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp0_ = err;
#line 41 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp1_ = _g_error_copy0 (_tmp0_);
#line 41 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_g_error_free0 (self->err);
#line 41 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		self->err = _tmp1_;
#line 37 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_g_error_free0 (err);
#line 4367 "MetadataWriter.c"
	}
	__finally566:
#line 37 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 37 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 37 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		g_clear_error (&_inner_error_);
#line 37 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		return;
#line 4378 "MetadataWriter.c"
	}
}


static void
metadata_writer_commit_job_commit_master (MetadataWriterCommitJob* self,
                                          GError** error)
{
	gboolean skip_orientation = FALSE;
	LibraryPhoto* _tmp0_;
	LibraryPhoto* _tmp1_;
	PhotoMetadata* metadata = NULL;
	LibraryPhoto* _tmp2_;
	PhotoMetadata* _tmp3_;
	PhotoMetadata* _tmp4_;
	gboolean _tmp5_;
	GError * _inner_error_ = NULL;
#line 45 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_return_if_fail (METADATA_WRITER_IS_COMMIT_JOB (self));
#line 49 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp0_ = self->photo;
#line 49 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	skip_orientation = photo_has_editable (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_PHOTO, Photo));
#line 51 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp1_ = self->photo;
#line 51 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	if (!photo_file_format_can_write_metadata (photo_get_master_file_format (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_PHOTO, Photo)))) {
#line 52 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		return;
#line 4408 "MetadataWriter.c"
	}
#line 54 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp2_ = self->photo;
#line 54 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp3_ = photo_get_master_metadata (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_PHOTO, Photo), &_inner_error_);
#line 54 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	metadata = _tmp3_;
#line 54 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 54 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		g_propagate_error (error, _inner_error_);
#line 54 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		return;
#line 4422 "MetadataWriter.c"
	}
#line 55 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp4_ = metadata;
#line 55 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp5_ = skip_orientation;
#line 55 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	if (metadata_writer_commit_job_update_metadata (self, _tmp4_, _tmp5_)) {
#line 4430 "MetadataWriter.c"
		LibraryPhoto* _tmp6_;
		GFile* _tmp7_;
		GFile* _tmp8_;
#line 56 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp6_ = self->photo;
#line 56 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp7_ = media_source_get_master_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_MEDIA_SOURCE, MediaSource));
#line 56 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp8_ = _tmp7_;
#line 56 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		library_monitor_blacklist_file (_tmp8_, "MetadataWriter.commit_master");
#line 56 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_g_object_unref0 (_tmp8_);
#line 4444 "MetadataWriter.c"
		{
			LibraryPhoto* _tmp9_;
			PhotoMetadata* _tmp10_;
			PhotoReimportMasterState* _tmp11_ = NULL;
#line 58 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp9_ = self->photo;
#line 58 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp10_ = metadata;
#line 58 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			photo_persist_master_metadata (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_PHOTO, Photo), _tmp10_, &_tmp11_, &_inner_error_);
#line 58 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_photo_reimport_master_state_unref0 (self->reimport_master_state);
#line 58 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			self->reimport_master_state = _tmp11_;
#line 58 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 4461 "MetadataWriter.c"
				goto __finally567;
			}
		}
		__finally567:
		{
			LibraryPhoto* _tmp12_;
			GFile* _tmp13_;
			GFile* _tmp14_;
#line 60 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp12_ = self->photo;
#line 60 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp13_ = media_source_get_master_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, TYPE_MEDIA_SOURCE, MediaSource));
#line 60 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp14_ = _tmp13_;
#line 60 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			library_monitor_unblacklist_file (_tmp14_);
#line 60 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_g_object_unref0 (_tmp14_);
#line 4480 "MetadataWriter.c"
		}
#line 57 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 57 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			g_propagate_error (error, _inner_error_);
#line 57 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_media_metadata_unref0 (metadata);
#line 57 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			return;
#line 4490 "MetadataWriter.c"
		}
	}
#line 64 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	self->wrote_master = TRUE;
#line 45 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_media_metadata_unref0 (metadata);
#line 4497 "MetadataWriter.c"
}


static void
metadata_writer_commit_job_commit_editable (MetadataWriterCommitJob* self,
                                            GError** error)
{
	gboolean _tmp0_ = FALSE;
	LibraryPhoto* _tmp1_;
	PhotoMetadata* metadata = NULL;
	LibraryPhoto* _tmp5_;
	PhotoMetadata* _tmp6_;
	PhotoMetadata* _tmp7_;
	PhotoMetadata* _tmp8_;
	GError * _inner_error_ = NULL;
#line 67 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_return_if_fail (METADATA_WRITER_IS_COMMIT_JOB (self));
#line 68 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp1_ = self->photo;
#line 68 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	if (!photo_has_editable (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_PHOTO, Photo))) {
#line 68 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp0_ = TRUE;
#line 4521 "MetadataWriter.c"
	} else {
		LibraryPhoto* _tmp2_;
		PhotoFileFormat* _tmp3_;
		PhotoFileFormat* _tmp4_;
#line 68 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp2_ = self->photo;
#line 68 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp3_ = photo_get_editable_file_format (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_PHOTO, Photo));
#line 68 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp4_ = _tmp3_;
#line 68 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp0_ = !photo_file_format_can_write_metadata (*_tmp4_);
#line 68 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_g_free0 (_tmp4_);
#line 4536 "MetadataWriter.c"
	}
#line 68 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	if (_tmp0_) {
#line 69 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		return;
#line 4542 "MetadataWriter.c"
	}
#line 71 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp5_ = self->photo;
#line 71 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp6_ = photo_get_editable_metadata (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_PHOTO, Photo), &_inner_error_);
#line 71 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	metadata = _tmp6_;
#line 71 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 71 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		g_propagate_error (error, _inner_error_);
#line 71 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		return;
#line 4556 "MetadataWriter.c"
	}
#line 72 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp7_ = metadata;
#line 72 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_vala_assert (_tmp7_ != NULL, "metadata != null");
#line 74 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp8_ = metadata;
#line 74 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	if (metadata_writer_commit_job_update_metadata (self, _tmp8_, FALSE)) {
#line 4566 "MetadataWriter.c"
		LibraryPhoto* _tmp9_;
		GFile* _tmp10_;
		GFile* _tmp11_;
#line 75 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp9_ = self->photo;
#line 75 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp10_ = photo_get_editable_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_PHOTO, Photo));
#line 75 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp11_ = _tmp10_;
#line 75 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		library_monitor_blacklist_file (_tmp11_, "MetadataWriter.commit_editable");
#line 75 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_g_object_unref0 (_tmp11_);
#line 4580 "MetadataWriter.c"
		{
			LibraryPhoto* _tmp12_;
			PhotoMetadata* _tmp13_;
			PhotoReimportEditableState* _tmp14_ = NULL;
#line 77 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp12_ = self->photo;
#line 77 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp13_ = metadata;
#line 77 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			photo_persist_editable_metadata (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, TYPE_PHOTO, Photo), _tmp13_, &_tmp14_, &_inner_error_);
#line 77 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_photo_reimport_editable_state_unref0 (self->reimport_editable_state);
#line 77 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			self->reimport_editable_state = _tmp14_;
#line 77 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 4597 "MetadataWriter.c"
				goto __finally568;
			}
		}
		__finally568:
		{
			LibraryPhoto* _tmp15_;
			GFile* _tmp16_;
			GFile* _tmp17_;
#line 79 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp15_ = self->photo;
#line 79 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp16_ = photo_get_editable_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, TYPE_PHOTO, Photo));
#line 79 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp17_ = _tmp16_;
#line 79 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			library_monitor_unblacklist_file (_tmp17_);
#line 79 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_g_object_unref0 (_tmp17_);
#line 4616 "MetadataWriter.c"
		}
#line 76 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 76 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			g_propagate_error (error, _inner_error_);
#line 76 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_media_metadata_unref0 (metadata);
#line 76 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			return;
#line 4626 "MetadataWriter.c"
		}
	}
#line 83 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	self->wrote_editable = TRUE;
#line 67 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_media_metadata_unref0 (metadata);
#line 4633 "MetadataWriter.c"
}


static gboolean
metadata_writer_commit_job_update_metadata (MetadataWriterCommitJob* self,
                                            PhotoMetadata* metadata,
                                            gboolean skip_orientation)
{
	gboolean result = FALSE;
	gboolean changed = FALSE;
	gchar* current_title = NULL;
	LibraryPhoto* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_;
	gchar* current_comment = NULL;
	LibraryPhoto* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gboolean _tmp12_;
	Rating current_rating = 0;
	LibraryPhoto* _tmp14_;
	Rating _tmp15_;
	time_t current_exposure_time = 0;
	LibraryPhoto* _tmp17_;
	time_t metadata_exposure_time = 0;
	MetadataDateTime* metadata_exposure_date_time = NULL;
	MetadataDateTime* _tmp18_;
	MetadataDateTime* _tmp19_;
	time_t _tmp21_;
	time_t _tmp22_;
	GeeSet* safe_keywords = NULL;
	GeeHashSet* _tmp27_;
	GeeSet* _tmp28_;
	GeeSet* _tmp40_;
	GeeSet* _tmp41_;
	GeeSet* _tmp42_;
	gboolean _tmp43_;
	gboolean _tmp48_;
#line 86 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_return_val_if_fail (METADATA_WRITER_IS_COMMIT_JOB (self), FALSE);
#line 86 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_return_val_if_fail (IS_PHOTO_METADATA (metadata), FALSE);
#line 87 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	changed = FALSE;
#line 90 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp0_ = self->photo;
#line 90 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp1_ = media_source_get_title (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_MEDIA_SOURCE, MediaSource));
#line 90 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	current_title = _tmp1_;
#line 91 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp2_ = current_title;
#line 91 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp3_ = media_metadata_get_title (G_TYPE_CHECK_INSTANCE_CAST (metadata, TYPE_MEDIA_METADATA, MediaMetadata));
#line 91 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp4_ = _tmp3_;
#line 91 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp5_ = g_strcmp0 (_tmp2_, _tmp4_) != 0;
#line 91 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_g_free0 (_tmp4_);
#line 91 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	if (_tmp5_) {
#line 4701 "MetadataWriter.c"
		const gchar* _tmp6_;
#line 92 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp6_ = current_title;
#line 92 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		photo_metadata_set_title (metadata, _tmp6_, PHOTO_METADATA_SET_OPTION_ALL_DOMAINS);
#line 93 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		changed = TRUE;
#line 4709 "MetadataWriter.c"
	}
#line 97 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp7_ = self->photo;
#line 97 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp8_ = media_source_get_comment (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_MEDIA_SOURCE, MediaSource));
#line 97 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	current_comment = _tmp8_;
#line 98 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp9_ = current_comment;
#line 98 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp10_ = media_metadata_get_comment (G_TYPE_CHECK_INSTANCE_CAST (metadata, TYPE_MEDIA_METADATA, MediaMetadata));
#line 98 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp11_ = _tmp10_;
#line 98 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp12_ = g_strcmp0 (_tmp9_, _tmp11_) != 0;
#line 98 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_g_free0 (_tmp11_);
#line 98 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	if (_tmp12_) {
#line 4729 "MetadataWriter.c"
		const gchar* _tmp13_;
#line 99 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp13_ = current_comment;
#line 99 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		photo_metadata_set_comment (metadata, _tmp13_, PHOTO_METADATA_SET_OPTION_ALL_DOMAINS);
#line 100 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		changed = TRUE;
#line 4737 "MetadataWriter.c"
	}
#line 104 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp14_ = self->photo;
#line 104 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	current_rating = media_source_get_rating (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, TYPE_MEDIA_SOURCE, MediaSource));
#line 105 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp15_ = current_rating;
#line 105 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	if (_tmp15_ != photo_metadata_get_rating (metadata)) {
#line 4747 "MetadataWriter.c"
		Rating _tmp16_;
#line 106 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp16_ = current_rating;
#line 106 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		photo_metadata_set_rating (metadata, _tmp16_);
#line 107 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		changed = TRUE;
#line 4755 "MetadataWriter.c"
	}
#line 111 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp17_ = self->photo;
#line 111 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	current_exposure_time = media_source_get_exposure_time (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, TYPE_MEDIA_SOURCE, MediaSource));
#line 112 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	metadata_exposure_time = (time_t) 0;
#line 113 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp18_ = photo_metadata_get_exposure_date_time (metadata);
#line 113 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	metadata_exposure_date_time = _tmp18_;
#line 114 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp19_ = metadata_exposure_date_time;
#line 114 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	if (_tmp19_ != NULL) {
#line 4771 "MetadataWriter.c"
		MetadataDateTime* _tmp20_;
#line 115 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp20_ = metadata_exposure_date_time;
#line 115 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		metadata_exposure_time = metadata_date_time_get_timestamp (_tmp20_);
#line 4777 "MetadataWriter.c"
	}
#line 116 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp21_ = current_exposure_time;
#line 116 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp22_ = metadata_exposure_time;
#line 116 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	if (_tmp21_ != _tmp22_) {
#line 4785 "MetadataWriter.c"
		MetadataDateTime* _tmp23_ = NULL;
		time_t _tmp24_;
#line 117 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp24_ = current_exposure_time;
#line 117 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		if (_tmp24_ != ((time_t) 0)) {
#line 4792 "MetadataWriter.c"
			time_t _tmp25_;
			MetadataDateTime* _tmp26_;
#line 118 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp25_ = current_exposure_time;
#line 118 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp26_ = metadata_date_time_new (_tmp25_);
#line 118 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_metadata_date_time_unref0 (_tmp23_);
#line 118 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp23_ = _tmp26_;
#line 4803 "MetadataWriter.c"
		} else {
#line 119 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_metadata_date_time_unref0 (_tmp23_);
#line 119 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp23_ = NULL;
#line 4809 "MetadataWriter.c"
		}
#line 117 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		photo_metadata_set_exposure_date_time (metadata, _tmp23_, PHOTO_METADATA_SET_OPTION_ALL_DOMAINS);
#line 120 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		changed = TRUE;
#line 116 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_metadata_date_time_unref0 (_tmp23_);
#line 4817 "MetadataWriter.c"
	}
#line 124 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp27_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
#line 124 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	safe_keywords = G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, GEE_TYPE_SET, GeeSet);
#line 133 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp28_ = self->current_keywords;
#line 133 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	if (_tmp28_ != NULL) {
#line 4827 "MetadataWriter.c"
		{
			GeeIterator* _tmp_it = NULL;
			GeeSet* _tmp29_;
			GeeIterator* _tmp30_;
#line 134 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp29_ = self->current_keywords;
#line 134 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp30_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, GEE_TYPE_ITERABLE, GeeIterable));
#line 134 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp_it = _tmp30_;
#line 134 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			while (TRUE) {
#line 4840 "MetadataWriter.c"
				GeeIterator* _tmp31_;
				gchar* tmp = NULL;
				GeeIterator* _tmp32_;
				gpointer _tmp33_;
				Tag* tag = NULL;
				const gchar* _tmp34_;
				Tag* _tmp35_;
				GeeSet* _tmp36_;
				Tag* _tmp37_;
				gchar* _tmp38_;
				gchar* _tmp39_;
#line 134 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_tmp31_ = _tmp_it;
#line 134 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				if (!gee_iterator_next (_tmp31_)) {
#line 134 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
					break;
#line 4858 "MetadataWriter.c"
				}
#line 134 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_tmp32_ = _tmp_it;
#line 134 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_tmp33_ = gee_iterator_get (_tmp32_);
#line 134 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				tmp = (gchar*) _tmp33_;
#line 135 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_tmp34_ = tmp;
#line 135 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_tmp35_ = tag_for_path (_tmp34_);
#line 135 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				tag = _tmp35_;
#line 136 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_tmp36_ = safe_keywords;
#line 136 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_tmp37_ = tag;
#line 136 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_tmp38_ = tag_get_user_visible_name (_tmp37_);
#line 136 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_tmp39_ = _tmp38_;
#line 136 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, GEE_TYPE_COLLECTION, GeeCollection), _tmp39_);
#line 136 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_g_free0 (_tmp39_);
#line 134 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_g_object_unref0 (tag);
#line 134 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
				_g_free0 (tmp);
#line 4888 "MetadataWriter.c"
			}
#line 134 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_g_object_unref0 (_tmp_it);
#line 4892 "MetadataWriter.c"
		}
	}
#line 140 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp40_ = safe_keywords;
#line 140 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp41_ = photo_metadata_get_keywords (metadata, NULL, NULL, NULL);
#line 140 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp42_ = _tmp41_;
#line 140 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp43_ = !equal_sets (_tmp40_, _tmp42_);
#line 140 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_g_object_unref0 (_tmp42_);
#line 140 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	if (_tmp43_) {
#line 4907 "MetadataWriter.c"
		GeeSet* _tmp44_;
#line 141 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp44_ = self->current_keywords;
#line 141 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		photo_metadata_set_keywords (metadata, G_TYPE_CHECK_INSTANCE_CAST (_tmp44_, GEE_TYPE_COLLECTION, GeeCollection), PHOTO_METADATA_SET_OPTION_ALL_DOMAINS);
#line 142 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		changed = TRUE;
#line 4915 "MetadataWriter.c"
	}
#line 146 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	if (!skip_orientation) {
#line 4919 "MetadataWriter.c"
		Orientation current_orientation = 0;
		LibraryPhoto* _tmp45_;
		Orientation _tmp46_;
#line 147 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp45_ = self->photo;
#line 147 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		current_orientation = photo_get_orientation (G_TYPE_CHECK_INSTANCE_CAST (_tmp45_, TYPE_PHOTO, Photo));
#line 148 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		_tmp46_ = current_orientation;
#line 148 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		if (_tmp46_ != photo_metadata_get_orientation (metadata)) {
#line 4931 "MetadataWriter.c"
			Orientation _tmp47_;
#line 149 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			_tmp47_ = current_orientation;
#line 149 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			photo_metadata_set_orientation (metadata, _tmp47_);
#line 150 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
			changed = TRUE;
#line 4939 "MetadataWriter.c"
		}
	}
#line 155 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp48_ = changed;
#line 155 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	if (_tmp48_) {
#line 156 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
		photo_metadata_set_software (metadata, RESOURCES_APP_TITLE, RESOURCES_APP_VERSION);
#line 4948 "MetadataWriter.c"
	}
#line 158 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	result = changed;
#line 158 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_g_object_unref0 (safe_keywords);
#line 158 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_metadata_date_time_unref0 (metadata_exposure_date_time);
#line 158 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_g_free0 (current_comment);
#line 158 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_g_free0 (current_title);
#line 158 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	return result;
#line 4962 "MetadataWriter.c"
}


static void
metadata_writer_commit_job_class_init (MetadataWriterCommitJobClass * klass)
{
#line 20 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	metadata_writer_commit_job_parent_class = g_type_class_peek_parent (klass);
#line 20 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	((BackgroundJobClass *) klass)->finalize = metadata_writer_commit_job_finalize;
#line 20 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	((BackgroundJobClass *) klass)->execute = (void (*) (BackgroundJob *)) metadata_writer_commit_job_real_execute;
#line 4975 "MetadataWriter.c"
}


static void
metadata_writer_commit_job_instance_init (MetadataWriterCommitJob * self)
{
#line 23 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	self->reimport_master_state = NULL;
#line 24 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	self->reimport_editable_state = NULL;
#line 25 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	self->err = NULL;
#line 26 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	self->wrote_master = FALSE;
#line 27 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	self->wrote_editable = FALSE;
#line 4992 "MetadataWriter.c"
}


static void
metadata_writer_commit_job_finalize (BackgroundJob * obj)
{
	MetadataWriterCommitJob * self;
#line 20 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, METADATA_WRITER_TYPE_COMMIT_JOB, MetadataWriterCommitJob);
#line 21 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_g_object_unref0 (self->photo);
#line 22 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_g_object_unref0 (self->current_keywords);
#line 23 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_photo_reimport_master_state_unref0 (self->reimport_master_state);
#line 24 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_photo_reimport_editable_state_unref0 (self->reimport_editable_state);
#line 25 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_g_error_free0 (self->err);
#line 20 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	BACKGROUND_JOB_CLASS (metadata_writer_commit_job_parent_class)->finalize (obj);
#line 5014 "MetadataWriter.c"
}


static GType
metadata_writer_commit_job_get_type (void)
{
	static volatile gsize metadata_writer_commit_job_type_id__volatile = 0;
	if (g_once_init_enter (&metadata_writer_commit_job_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MetadataWriterCommitJobClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) metadata_writer_commit_job_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MetadataWriterCommitJob), 0, (GInstanceInitFunc) metadata_writer_commit_job_instance_init, NULL };
		GType metadata_writer_commit_job_type_id;
		metadata_writer_commit_job_type_id = g_type_register_static (TYPE_BACKGROUND_JOB, "MetadataWriterCommitJob", &g_define_type_info, 0);
		g_once_init_leave (&metadata_writer_commit_job_type_id__volatile, metadata_writer_commit_job_type_id);
	}
	return metadata_writer_commit_job_type_id__volatile;
}


static void
metadata_writer_class_init (MetadataWriterClass * klass)
{
#line 14 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	metadata_writer_parent_class = g_type_class_peek_parent (klass);
#line 14 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_type_class_add_private (klass, sizeof (MetadataWriterPrivate));
#line 14 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	G_OBJECT_CLASS (klass)->finalize = metadata_writer_finalize;
#line 14 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	metadata_writer_signals[METADATA_WRITER_PROGRESS_SIGNAL] = g_signal_new ("progress", TYPE_METADATA_WRITER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_UINT, G_TYPE_NONE, 2, G_TYPE_UINT, G_TYPE_UINT);
#line 5043 "MetadataWriter.c"
}


static void
metadata_writer_instance_init (MetadataWriter * self)
{
	Workers* _tmp0_;
	GeeHashMap* _tmp1_;
	GeeHashSet* _tmp2_;
	GeeHashSet* _tmp3_;
	GeeHashSet* _tmp4_;
#line 14 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	self->priv = METADATA_WRITER_GET_PRIVATE (self);
#line 164 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp0_ = workers_new ((guint) 1, FALSE);
#line 164 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	self->priv->workers = _tmp0_;
#line 165 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	self->priv->enabled = FALSE;
#line 167 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp1_ = gee_hash_map_new (TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, METADATA_WRITER_TYPE_COMMIT_JOB, (GBoxedCopyFunc) background_job_ref, (GDestroyNotify) background_job_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 167 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	self->priv->pending = _tmp1_;
#line 168 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp2_ = gee_hash_set_new (METADATA_WRITER_TYPE_COMMIT_JOB, (GBoxedCopyFunc) background_job_ref, (GDestroyNotify) background_job_unref, NULL, NULL, NULL, NULL, NULL, NULL);
#line 168 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	self->priv->pending_cancel = _tmp2_;
#line 169 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp3_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
#line 169 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	self->priv->interested_photo_details = _tmp3_;
#line 170 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	self->priv->ignore_photo_alteration = NULL;
#line 171 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	self->priv->outstanding_total = (guint) 0;
#line 172 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	self->priv->outstanding_completed = (guint) 0;
#line 173 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	self->priv->closed = FALSE;
#line 174 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	self->priv->pause_count = 0;
#line 175 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp4_ = gee_hash_set_new (TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
#line 175 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	self->priv->importing_photos = _tmp4_;
#line 5089 "MetadataWriter.c"
}


static void
metadata_writer_finalize (GObject * obj)
{
	MetadataWriter * self;
	ConfigFacade* _tmp0_;
	ConfigFacade* _tmp1_;
	guint _tmp2_;
	LibraryPhotoSourceCollection* _tmp3_;
	guint _tmp4_;
	LibraryPhotoSourceCollection* _tmp5_;
	guint _tmp6_;
	LibraryPhotoSourceCollection* _tmp7_;
	guint _tmp8_;
	LibraryPhotoSourceCollection* _tmp9_;
	guint _tmp10_;
	LibraryPhotoSourceCollection* _tmp11_;
	guint _tmp12_;
	LibraryPhotoSourceCollection* _tmp13_;
	guint _tmp14_;
	LibraryPhotoSourceCollection* _tmp15_;
	guint _tmp16_;
	TagSourceCollection* _tmp17_;
	guint _tmp18_;
	TagSourceCollection* _tmp19_;
	guint _tmp20_;
	TagSourceCollection* _tmp21_;
	guint _tmp22_;
	TagSourceCollection* _tmp23_;
	guint _tmp24_;
	TagSourceCollection* _tmp25_;
	guint _tmp26_;
	Application* _tmp27_;
	Application* _tmp28_;
	guint _tmp29_;
	LibraryMonitorPool* _tmp30_;
	LibraryMonitorPool* _tmp31_;
	guint _tmp32_;
	LibraryMonitorPool* _tmp33_;
	LibraryMonitorPool* _tmp34_;
	guint _tmp35_;
#line 14 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_METADATA_WRITER, MetadataWriter);
#line 220 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp0_ = config_facade_get_instance ();
#line 220 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp1_ = _tmp0_;
#line 220 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_signal_parse_name ("commit-metadata-to-masters-changed", TYPE_CONFIGURATION_FACADE, &_tmp2_, NULL, FALSE);
#line 220 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _metadata_writer_on_config_changed_configuration_facade_commit_metadata_to_masters_changed, self);
#line 220 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_g_object_unref0 (_tmp1_);
#line 222 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp3_ = library_photo_global;
#line 222 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_signal_parse_name ("media-import-starting", TYPE_MEDIA_SOURCE_COLLECTION, &_tmp4_, NULL, FALSE);
#line 222 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, 0, NULL, (GCallback) _metadata_writer_on_importing_photos_media_source_collection_media_import_starting, self);
#line 223 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp5_ = library_photo_global;
#line 223 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_signal_parse_name ("media-import-completed", TYPE_MEDIA_SOURCE_COLLECTION, &_tmp6_, NULL, FALSE);
#line 223 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp6_, 0, NULL, (GCallback) _metadata_writer_on_photos_imported_media_source_collection_media_import_completed, self);
#line 224 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp7_ = library_photo_global;
#line 224 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_signal_parse_name ("contents-altered", TYPE_DATA_COLLECTION, &_tmp8_, NULL, FALSE);
#line 224 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_DATA_COLLECTION, DataCollection), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp8_, 0, NULL, (GCallback) _metadata_writer_on_photos_added_removed_data_collection_contents_altered, self);
#line 225 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp9_ = library_photo_global;
#line 225 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_signal_parse_name ("items-altered", TYPE_DATA_COLLECTION, &_tmp10_, NULL, FALSE);
#line 225 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_DATA_COLLECTION, DataCollection), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp10_, 0, NULL, (GCallback) _metadata_writer_on_photos_altered_data_collection_items_altered, self);
#line 226 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp11_ = library_photo_global;
#line 226 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_signal_parse_name ("frozen", TYPE_DATA_COLLECTION, &_tmp12_, NULL, FALSE);
#line 226 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, TYPE_DATA_COLLECTION, DataCollection), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp12_, 0, NULL, (GCallback) _metadata_writer_on_collection_frozen_data_collection_frozen, self);
#line 227 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp13_ = library_photo_global;
#line 227 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_signal_parse_name ("thawed", TYPE_DATA_COLLECTION, &_tmp14_, NULL, FALSE);
#line 227 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, TYPE_DATA_COLLECTION, DataCollection), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp14_, 0, NULL, (GCallback) _metadata_writer_on_collection_thawed_data_collection_thawed, self);
#line 228 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp15_ = library_photo_global;
#line 228 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_signal_parse_name ("items-destroyed", TYPE_SOURCE_COLLECTION, &_tmp16_, NULL, FALSE);
#line 228 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, TYPE_SOURCE_COLLECTION, SourceCollection), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp16_, 0, NULL, (GCallback) _metadata_writer_on_photos_destroyed_source_collection_items_destroyed, self);
#line 230 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp17_ = tag_global;
#line 230 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_signal_parse_name ("items-altered", TYPE_DATA_COLLECTION, &_tmp18_, NULL, FALSE);
#line 230 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, TYPE_DATA_COLLECTION, DataCollection), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp18_, 0, NULL, (GCallback) _metadata_writer_on_tags_altered_data_collection_items_altered, self);
#line 231 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp19_ = tag_global;
#line 231 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_signal_parse_name ("container-contents-altered", TYPE_CONTAINER_SOURCE_COLLECTION, &_tmp20_, NULL, FALSE);
#line 231 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollection), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp20_, 0, NULL, (GCallback) _metadata_writer_on_tag_contents_altered_container_source_collection_container_contents_altered, self);
#line 232 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp21_ = tag_global;
#line 232 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_signal_parse_name ("backlink-to-container-removed", TYPE_CONTAINER_SOURCE_COLLECTION, &_tmp22_, NULL, FALSE);
#line 232 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollection), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp22_, 0, NULL, (GCallback) _metadata_writer_on_tag_backlink_removed_container_source_collection_backlink_to_container_removed, self);
#line 233 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp23_ = tag_global;
#line 233 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_signal_parse_name ("frozen", TYPE_DATA_COLLECTION, &_tmp24_, NULL, FALSE);
#line 233 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, TYPE_DATA_COLLECTION, DataCollection), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp24_, 0, NULL, (GCallback) _metadata_writer_on_collection_frozen_data_collection_frozen, self);
#line 234 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp25_ = tag_global;
#line 234 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_signal_parse_name ("thawed", TYPE_DATA_COLLECTION, &_tmp26_, NULL, FALSE);
#line 234 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, TYPE_DATA_COLLECTION, DataCollection), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp26_, 0, NULL, (GCallback) _metadata_writer_on_collection_thawed_data_collection_thawed, self);
#line 236 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp27_ = application_get_instance ();
#line 236 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp28_ = _tmp27_;
#line 236 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_signal_parse_name ("exiting", TYPE_APPLICATION, &_tmp29_, NULL, FALSE);
#line 236 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_signal_handlers_disconnect_matched (_tmp28_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp29_, 0, NULL, (GCallback) _metadata_writer_on_application_exiting_application_exiting, self);
#line 236 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_application_unref0 (_tmp28_);
#line 238 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp30_ = library_monitor_pool_get_instance ();
#line 238 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp31_ = _tmp30_;
#line 238 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_signal_parse_name ("monitor-installed", TYPE_LIBRARY_MONITOR_POOL, &_tmp32_, NULL, FALSE);
#line 238 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_signal_handlers_disconnect_matched (_tmp31_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp32_, 0, NULL, (GCallback) _metadata_writer_on_monitor_installed_library_monitor_pool_monitor_installed, self);
#line 238 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_library_monitor_pool_unref0 (_tmp31_);
#line 239 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp33_ = library_monitor_pool_get_instance ();
#line 239 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_tmp34_ = _tmp33_;
#line 239 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_signal_parse_name ("monitor-destroyed", TYPE_LIBRARY_MONITOR_POOL, &_tmp35_, NULL, FALSE);
#line 239 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	g_signal_handlers_disconnect_matched (_tmp34_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp35_, 0, NULL, (GCallback) _metadata_writer_on_monitor_destroyed_library_monitor_pool_monitor_destroyed, self);
#line 239 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_library_monitor_pool_unref0 (_tmp34_);
#line 164 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_workers_unref0 (self->priv->workers);
#line 166 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_timed_queue_unref0 (self->priv->dirty);
#line 167 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_g_object_unref0 (self->priv->pending);
#line 168 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_g_object_unref0 (self->priv->pending_cancel);
#line 169 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_g_object_unref0 (self->priv->interested_photo_details);
#line 170 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_g_object_unref0 (self->priv->ignore_photo_alteration);
#line 175 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	_g_object_unref0 (self->priv->importing_photos);
#line 14 "/home/jens/Source/shotwell/src/MetadataWriter.vala"
	G_OBJECT_CLASS (metadata_writer_parent_class)->finalize (obj);
#line 5263 "MetadataWriter.c"
}


GType
metadata_writer_get_type (void)
{
	static volatile gsize metadata_writer_type_id__volatile = 0;
	if (g_once_init_enter (&metadata_writer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MetadataWriterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) metadata_writer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MetadataWriter), 0, (GInstanceInitFunc) metadata_writer_instance_init, NULL };
		GType metadata_writer_type_id;
		metadata_writer_type_id = g_type_register_static (G_TYPE_OBJECT, "MetadataWriter", &g_define_type_info, 0);
		g_once_init_leave (&metadata_writer_type_id__volatile, metadata_writer_type_id);
	}
	return metadata_writer_type_id__volatile;
}



