#
# Copyright 2009-2018 Canonical Ltd.
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License version 3,
#    as published by the Free Software Foundation.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# Based on work by Didier Roche <didrocks@ubuntu.com>
#

_ufw_commands()
{
    commands=$("$SNAP"/command-ufw.wrapper --help | sed -e '1,/^Commands:/d' -e '/^Application profile commands:/Q' -e 's/^[ \t]\+\([a-z|]\+\)[ \t]\+.*/\1/g' -e 's/|/ /g' | uniq)
    echo "$commands app"
}

_ufw_app_commands()
{
    "$SNAP"/command-ufw.wrapper --help | sed -e '1,/^Application profile commands:/d' -e '/^ [^ ]/!d' -e 's/[ \t]\+app[ \t]\+\([a-z|]\+\)[ \t]\+.*/\1/g'
}

_ufw_logging_commands()
{
    echo "off on low medium high full"
}

_ufw_default_commands()
{
    echo "allow deny reject"
}

_ufw_rule_commands()
{
    echo "`_ufw_default_commands` limit"
}

_ufw_route_commands()
{
    echo "`_ufw_default_commands` limit delete insert"
}

_ufw_show_commands()
{
    echo "raw"
}

_ufw_status_commands()
{
    echo "numbered verbose"
}

# Don't use '_have' with snaps
# _have ufw &&
_ufw()
{
    cur=${COMP_WORDS[COMP_CWORD]}
    prev=${COMP_WORDS[COMP_CWORD-1]}
    if [ $COMP_CWORD -eq 1 ]; then
        COMPREPLY=( $( compgen -W "--dry-run --force --help $(_ufw_commands)" -- $cur ) )
    elif [ $COMP_CWORD -eq 2 ]; then
        case "$prev" in
        app)
            COMPREPLY=( $( compgen -W "$(_ufw_app_commands)" -- $cur ) )
            ;;
        status)
            COMPREPLY=( $( compgen -W "$(_ufw_status_commands)" -- $cur ) )
            ;;
        delete)
            COMPREPLY=( $( compgen -W "$(_ufw_rule_commands)" -- $cur ) )
            ;;
        route)
            COMPREPLY=( $( compgen -W "$(_ufw_route_commands)" -- $cur ) )
            ;;
        logging)
            COMPREPLY=( $( compgen -W "$(_ufw_logging_commands)" -- $cur ) )
            ;;
        show)
            COMPREPLY=( $( compgen -W "$(_ufw_show_commands)" -- $cur ) )
            ;;
        default)
            COMPREPLY=( $( compgen -W "$(_ufw_default_commands)" -- $cur ) )
            ;;
        esac
    fi
}

# Don't use '_have' with snaps
#_have ufw && complete -F _ufw ufw
complete -F _ufw ufw
