/* test-umockdev-vala.c generated by valac 0.28.0, the Vala compiler
 * generated from test-umockdev-vala.vala, do not modify */

/*
 * test-umockdev.vala
 *
 * Copyright (C) 2012 Canonical Ltd.
 * Author: Martin Pitt <martin.pitt@ubuntu.com>
 *
 * umockdev is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * umockdev is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <umockdev.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <gudev/gudev.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include "linux/usbdevice_fs.h"
#include <errno.h>
#include <unistd.h>
#include <glib/gstdio.h>
#include <sys/stat.h>
#include <gobject/gvaluecollector.h>

#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_ATTRIBUTE_COUNTER_THREAD (attribute_counter_thread_get_type ())
#define ATTRIBUTE_COUNTER_THREAD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ATTRIBUTE_COUNTER_THREAD, AttributeCounterThread))
#define ATTRIBUTE_COUNTER_THREAD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ATTRIBUTE_COUNTER_THREAD, AttributeCounterThreadClass))
#define IS_ATTRIBUTE_COUNTER_THREAD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ATTRIBUTE_COUNTER_THREAD))
#define IS_ATTRIBUTE_COUNTER_THREAD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ATTRIBUTE_COUNTER_THREAD))
#define ATTRIBUTE_COUNTER_THREAD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ATTRIBUTE_COUNTER_THREAD, AttributeCounterThreadClass))

typedef struct _AttributeCounterThread AttributeCounterThread;
typedef struct _AttributeCounterThreadClass AttributeCounterThreadClass;
typedef struct _AttributeCounterThreadPrivate AttributeCounterThreadPrivate;
typedef struct _ParamSpecAttributeCounterThread ParamSpecAttributeCounterThread;
#define _g_thread_unref0(var) ((var == NULL) ? NULL : (var = (g_thread_unref (var), NULL)))
#define _attribute_counter_thread_unref0(var) ((var == NULL) ? NULL : (var = (attribute_counter_thread_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _AttributeCounterThread {
	GTypeInstance parent_instance;
	volatile int ref_count;
	AttributeCounterThreadPrivate * priv;
};

struct _AttributeCounterThreadClass {
	GTypeClass parent_class;
	void (*finalize) (AttributeCounterThread *self);
};

struct _AttributeCounterThreadPrivate {
	UMockdevTestbed* tb;
	gchar* name;
	gchar* syspath;
	guint count;
};

struct _ParamSpecAttributeCounterThread {
	GParamSpec parent_instance;
};

struct _Block1Data {
	int _ref_count_;
	UMockdevTestbed* tb;
	GMainLoop* ml;
	guint add_count;
	guint change_count;
	guint num_changes;
	gchar* syspath;
};


static gpointer attribute_counter_thread_parent_class = NULL;

void tb_add_from_string (UMockdevTestbed* tb, const gchar* s);
void t_testbed_empty (void);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
void t_testbed_add_device (void);
void t_testbed_gudev_query_list (void);
void t_usbfs_ioctl_static (void);
void t_usbfs_ioctl_tree (void);
static guint8* _vala_array_dup1 (guint8* self, int length);
void t_usbfs_ioctl_tree_with_default_device (void);
void t_usbfs_ioctl_tree_override_default_device (void);
void t_usbfs_ioctl_tree_xz (void);
void t_tty_stty (void);
void t_tty_data (void);
void t_detects_running_in_testbed (void);
void t_detects_not_running_in_testbed (void);
gint is_test_inside_testbed (gint pipefd);
gpointer attribute_counter_thread_ref (gpointer instance);
void attribute_counter_thread_unref (gpointer instance);
GParamSpec* param_spec_attribute_counter_thread (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_attribute_counter_thread (GValue* value, gpointer v_object);
void value_take_attribute_counter_thread (GValue* value, gpointer v_object);
gpointer value_get_attribute_counter_thread (const GValue* value);
GType attribute_counter_thread_get_type (void) G_GNUC_CONST;
#define ATTRIBUTE_COUNTER_THREAD_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_ATTRIBUTE_COUNTER_THREAD, AttributeCounterThreadPrivate))
enum  {
	ATTRIBUTE_COUNTER_THREAD_DUMMY_PROPERTY
};
AttributeCounterThread* attribute_counter_thread_new (UMockdevTestbed* tb, const gchar* syspath, const gchar* name, guint max);
AttributeCounterThread* attribute_counter_thread_construct (GType object_type, UMockdevTestbed* tb, const gchar* syspath, const gchar* name, guint max);
void* attribute_counter_thread_run (AttributeCounterThread* self);
static void attribute_counter_thread_finalize (AttributeCounterThread* obj);
void t_mt_parallel_attr_distinct (void);
static gpointer _attribute_counter_thread_run_gthread_func (gpointer self);
void t_mt_uevent (void);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda4_ (Block1Data* _data1_, GUdevClient* client, const gchar* action, GUdevDevice* device);
static void ___lambda4__g_udev_client_uevent (GUdevClient* _sender, const gchar* action, GUdevDevice* device, gpointer self);
static void* __lambda5_ (Block1Data* _data1_);
static gpointer ___lambda5__gthread_func (gpointer self);
static void* __lambda6_ (Block1Data* _data1_);
static gpointer ___lambda6__gthread_func (gpointer self);
static gboolean __lambda7_ (Block1Data* _data1_);
static gboolean ___lambda7__gsource_func (gpointer self);
gint _vala_main (gchar** args, int args_length1);
static void _t_testbed_empty_gtest_func (void);
static void _t_testbed_add_device_gtest_func (void);
static void _t_testbed_gudev_query_list_gtest_func (void);
static void _t_usbfs_ioctl_static_gtest_func (void);
static void _t_usbfs_ioctl_tree_gtest_func (void);
static void _t_usbfs_ioctl_tree_with_default_device_gtest_func (void);
static void _t_usbfs_ioctl_tree_override_default_device_gtest_func (void);
static void _t_usbfs_ioctl_tree_xz_gtest_func (void);
static void _t_tty_stty_gtest_func (void);
static void _t_tty_data_gtest_func (void);
static void _t_detects_running_in_testbed_gtest_func (void);
static void _t_detects_not_running_in_testbed_gtest_func (void);
static void _t_mt_parallel_attr_distinct_gtest_func (void);
static void _t_mt_uevent_gtest_func (void);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


void tb_add_from_string (UMockdevTestbed* tb, const gchar* s) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (tb != NULL);
	g_return_if_fail (s != NULL);
	{
		gboolean _tmp0_ = FALSE;
		UMockdevTestbed* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		_tmp1_ = tb;
		_tmp2_ = s;
		_tmp3_ = umockdev_testbed_add_from_string (_tmp1_, _tmp2_, &_inner_error_);
		_tmp0_ = _tmp3_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch0_g_error;
		}
		_vala_assert (_tmp0_, "tb.add_from_string (s)");
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		FILE* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = stderr;
		_tmp5_ = e->message;
		fprintf (_tmp4_, "Failed to call Testbed.add_from_string(): %s\n", _tmp5_);
		abort ();
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


void t_testbed_empty (void) {
	UMockdevTestbed* tb = NULL;
	UMockdevTestbed* _tmp0_ = NULL;
	GUdevEnumerator* enumerator = NULL;
	GUdevClient* _tmp1_ = NULL;
	GUdevClient* _tmp2_ = NULL;
	GUdevEnumerator* _tmp3_ = NULL;
	GUdevEnumerator* _tmp4_ = NULL;
	GList* devices = NULL;
	GList* _tmp5_ = NULL;
	guint _tmp6_ = 0U;
	_tmp0_ = umockdev_testbed_new ();
	tb = _tmp0_;
	_vala_assert (tb != NULL, "tb != null");
	_tmp1_ = g_udev_client_new (NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_udev_enumerator_new (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp2_);
	enumerator = _tmp4_;
	_tmp5_ = g_udev_enumerator_execute (enumerator);
	devices = _tmp5_;
	_tmp6_ = g_list_length (devices);
	g_assert_cmpuint (_tmp6_, ==, (guint) 0);
	__g_list_free__g_object_unref0_0 (devices);
	_g_object_unref0 (enumerator);
	_g_object_unref0 (tb);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void t_testbed_add_device (void) {
	UMockdevTestbed* tb = NULL;
	UMockdevTestbed* _tmp0_ = NULL;
	gchar* syspath = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar** _tmp5_ = NULL;
	gchar** _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar** _tmp11_ = NULL;
	gchar** _tmp12_ = NULL;
	gint _tmp12__length1 = 0;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	GUdevEnumerator* enumerator = NULL;
	GUdevClient* _tmp15_ = NULL;
	GUdevClient* _tmp16_ = NULL;
	GUdevEnumerator* _tmp17_ = NULL;
	GUdevEnumerator* _tmp18_ = NULL;
	GList* devices = NULL;
	GList* _tmp19_ = NULL;
	guint _tmp20_ = 0U;
	GUdevDevice* device = NULL;
	gconstpointer _tmp21_ = NULL;
	GUdevDevice* _tmp22_ = NULL;
	const gchar* _tmp23_ = NULL;
	const gchar* _tmp24_ = NULL;
	const gchar* _tmp25_ = NULL;
	const gchar* _tmp26_ = NULL;
	const gchar* _tmp27_ = NULL;
	const gchar* _tmp28_ = NULL;
	const gchar* _tmp29_ = NULL;
	const gchar* _tmp30_ = NULL;
	const gchar* _tmp31_ = NULL;
	const gchar* _tmp32_ = NULL;
	const gchar* _tmp33_ = NULL;
	_tmp0_ = umockdev_testbed_new ();
	tb = _tmp0_;
	_tmp1_ = g_strdup ("idVendor");
	_tmp2_ = g_strdup ("0815");
	_tmp3_ = g_strdup ("idProduct");
	_tmp4_ = g_strdup ("AFFE");
	_tmp5_ = g_new0 (gchar*, 4 + 1);
	_tmp5_[0] = _tmp1_;
	_tmp5_[1] = _tmp2_;
	_tmp5_[2] = _tmp3_;
	_tmp5_[3] = _tmp4_;
	_tmp6_ = _tmp5_;
	_tmp6__length1 = 4;
	_tmp7_ = g_strdup ("ID_INPUT");
	_tmp8_ = g_strdup ("1");
	_tmp9_ = g_strdup ("ID_INPUT_KEYBOARD");
	_tmp10_ = g_strdup ("1");
	_tmp11_ = g_new0 (gchar*, 4 + 1);
	_tmp11_[0] = _tmp7_;
	_tmp11_[1] = _tmp8_;
	_tmp11_[2] = _tmp9_;
	_tmp11_[3] = _tmp10_;
	_tmp12_ = _tmp11_;
	_tmp12__length1 = 4;
	_tmp13_ = umockdev_testbed_add_devicev (tb, "usb", "extkeyboard1", NULL, _tmp6_, _tmp12_);
	_tmp14_ = _tmp13_;
	_tmp12_ = (_vala_array_free (_tmp12_, _tmp12__length1, (GDestroyNotify) g_free), NULL);
	_tmp6_ = (_vala_array_free (_tmp6_, _tmp6__length1, (GDestroyNotify) g_free), NULL);
	syspath = _tmp14_;
	g_assert_cmpstr (syspath, ==, "/sys/devices/extkeyboard1");
	_tmp15_ = g_udev_client_new (NULL);
	_tmp16_ = _tmp15_;
	_tmp17_ = g_udev_enumerator_new (_tmp16_);
	_tmp18_ = _tmp17_;
	_g_object_unref0 (_tmp16_);
	enumerator = _tmp18_;
	_tmp19_ = g_udev_enumerator_execute (enumerator);
	devices = _tmp19_;
	_tmp20_ = g_list_length (devices);
	g_assert_cmpuint (_tmp20_, ==, (guint) 1);
	_tmp21_ = g_list_nth_data (devices, (guint) 0);
	_tmp22_ = _g_object_ref0 ((GUdevDevice*) _tmp21_);
	device = _tmp22_;
	_tmp23_ = g_udev_device_get_name (device);
	g_assert_cmpstr (_tmp23_, ==, "extkeyboard1");
	_tmp24_ = g_udev_device_get_sysfs_path (device);
	g_assert_cmpstr (_tmp24_, ==, "/sys/devices/extkeyboard1");
	_tmp25_ = g_udev_device_get_subsystem (device);
	g_assert_cmpstr (_tmp25_, ==, "usb");
	_tmp26_ = g_udev_device_get_sysfs_attr (device, "idVendor");
	g_assert_cmpstr (_tmp26_, ==, "0815");
	_tmp27_ = g_udev_device_get_sysfs_attr (device, "idProduct");
	g_assert_cmpstr (_tmp27_, ==, "AFFE");
	_tmp28_ = g_udev_device_get_sysfs_attr (device, "noSuchAttr");
	g_assert_cmpstr (_tmp28_, ==, NULL);
	_tmp29_ = g_udev_device_get_property (device, "DEVPATH");
	g_assert_cmpstr (_tmp29_, ==, "/devices/extkeyboard1");
	_tmp30_ = g_udev_device_get_property (device, "SUBSYSTEM");
	g_assert_cmpstr (_tmp30_, ==, "usb");
	_tmp31_ = g_udev_device_get_property (device, "ID_INPUT");
	g_assert_cmpstr (_tmp31_, ==, "1");
	_tmp32_ = g_udev_device_get_property (device, "ID_INPUT_KEYBOARD");
	g_assert_cmpstr (_tmp32_, ==, "1");
	_tmp33_ = g_udev_device_get_property (device, "NO_SUCH_PROP");
	g_assert_cmpstr (_tmp33_, ==, NULL);
	_g_object_unref0 (device);
	__g_list_free__g_object_unref0_0 (devices);
	_g_object_unref0 (enumerator);
	_g_free0 (syspath);
	_g_object_unref0 (tb);
}


void t_testbed_gudev_query_list (void) {
	UMockdevTestbed* tb = NULL;
	UMockdevTestbed* _tmp0_ = NULL;
	UMockdevTestbed* _tmp1_ = NULL;
	GUdevClient* client = NULL;
	GUdevClient* _tmp2_ = NULL;
	GList* devices = NULL;
	GUdevClient* _tmp3_ = NULL;
	GList* _tmp4_ = NULL;
	GList* _tmp5_ = NULL;
	guint _tmp6_ = 0U;
	GList* _tmp7_ = NULL;
	_tmp0_ = umockdev_testbed_new ();
	tb = _tmp0_;
	_tmp1_ = tb;
	tb_add_from_string (_tmp1_, "P: /devices/myusbhub/cam\n" \
"N: bus/usb/001/002\n" \
"E: SUBSYSTEM=usb\n" \
"E: DEVTYPE=usb_device\n" \
"E: DEVNAME=/dev/bus/usb/001/002\n" \
"\n" \
"P: /devices/myusbhub\n" \
"N: bus/usb/001/001\n" \
"E: SUBSYSTEM=usb\n" \
"E: DEVTYPE=usb_device\n" \
"E: DEVNAME=/dev/bus/usb/001/001\n");
	_tmp2_ = g_udev_client_new (NULL);
	client = _tmp2_;
	_tmp3_ = client;
	_tmp4_ = g_udev_client_query_by_subsystem (_tmp3_, NULL);
	devices = _tmp4_;
	_tmp5_ = devices;
	_tmp6_ = g_list_length (_tmp5_);
	g_assert_cmpuint (_tmp6_, ==, (guint) 2);
	_tmp7_ = devices;
	{
		GList* dev_collection = NULL;
		GList* dev_it = NULL;
		dev_collection = _tmp7_;
		for (dev_it = dev_collection; dev_it != NULL; dev_it = dev_it->next) {
			GUdevDevice* _tmp8_ = NULL;
			GUdevDevice* dev = NULL;
			_tmp8_ = _g_object_ref0 ((GUdevDevice*) dev_it->data);
			dev = _tmp8_;
			{
				GUdevDevice* _tmp9_ = NULL;
				const gchar* _tmp10_ = NULL;
				GUdevDevice* _tmp11_ = NULL;
				const gchar* _tmp12_ = NULL;
				_tmp9_ = dev;
				_tmp10_ = g_udev_device_get_subsystem (_tmp9_);
				g_assert_cmpstr (_tmp10_, ==, "usb");
				_tmp11_ = dev;
				_tmp12_ = g_udev_device_get_sysfs_path (_tmp11_);
				if (g_strcmp0 (_tmp12_, "/sys/devices/myusbhub") == 0) {
					GUdevDevice* _tmp13_ = NULL;
					const gchar* _tmp14_ = NULL;
					GUdevDevice* _tmp15_ = NULL;
					const gchar* _tmp16_ = NULL;
					_tmp13_ = dev;
					_tmp14_ = g_udev_device_get_name (_tmp13_);
					g_assert_cmpstr (_tmp14_, ==, "myusbhub");
					_tmp15_ = dev;
					_tmp16_ = g_udev_device_get_device_file (_tmp15_);
					g_assert_cmpstr (_tmp16_, ==, "/dev/bus/usb/001/001");
				} else {
					GUdevDevice* _tmp17_ = NULL;
					const gchar* _tmp18_ = NULL;
					GUdevDevice* _tmp19_ = NULL;
					const gchar* _tmp20_ = NULL;
					GUdevDevice* _tmp21_ = NULL;
					const gchar* _tmp22_ = NULL;
					_tmp17_ = dev;
					_tmp18_ = g_udev_device_get_sysfs_path (_tmp17_);
					g_assert_cmpstr (_tmp18_, ==, "/sys/devices/myusbhub/cam");
					_tmp19_ = dev;
					_tmp20_ = g_udev_device_get_name (_tmp19_);
					g_assert_cmpstr (_tmp20_, ==, "cam");
					_tmp21_ = dev;
					_tmp22_ = g_udev_device_get_device_file (_tmp21_);
					g_assert_cmpstr (_tmp22_, ==, "/dev/bus/usb/001/002");
				}
				_g_object_unref0 (dev);
			}
		}
	}
	__g_list_free__g_object_unref0_0 (devices);
	_g_object_unref0 (client);
	_g_object_unref0 (tb);
}


void t_usbfs_ioctl_static (void) {
	UMockdevTestbed* tb = NULL;
	UMockdevTestbed* _tmp0_ = NULL;
	UMockdevTestbed* _tmp1_ = NULL;
	gint fd = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint i = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	struct usbdevfs_connectinfo ci = {0};
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	gint fd2 = 0;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	gint _tmp22_ = 0;
	_tmp0_ = umockdev_testbed_new ();
	tb = _tmp0_;
	_tmp1_ = tb;
	tb_add_from_string (_tmp1_, "P: /devices/mycam\nN: 001\nE: SUBSYSTEM=usb\n");
	_tmp2_ = open ("/dev/001", O_RDWR, (mode_t) 0);
	fd = _tmp2_;
	_tmp3_ = fd;
	g_assert_cmpint (_tmp3_, >=, 0);
	i = 1;
	_tmp4_ = fd;
	_tmp5_ = ioctl (_tmp4_, USBDEVFS_CLAIMINTERFACE, &i);
	g_assert_cmpint (_tmp5_, ==, 0);
	_tmp6_ = errno;
	g_assert_cmpint (_tmp6_, ==, 0);
	_tmp7_ = fd;
	_tmp8_ = ioctl (_tmp7_, USBDEVFS_GETDRIVER, &i);
	g_assert_cmpint (_tmp8_, ==, -1);
	_tmp9_ = errno;
	g_assert_cmpint (_tmp9_, ==, ENODATA);
	errno = 0;
	memset (&ci, 0, sizeof (struct usbdevfs_connectinfo));
	_tmp10_ = fd;
	_tmp11_ = ioctl (_tmp10_, USBDEVFS_CONNECTINFO, &ci);
	g_assert_cmpint (_tmp11_, ==, -1);
	_tmp12_ = errno;
	g_assert_cmpint (_tmp12_, >=, 22);
	errno = 0;
	_tmp13_ = fd;
	_tmp14_ = ioctl (_tmp13_, TIOCSBRK, 0);
	g_assert_cmpint (_tmp14_, ==, -1);
	_tmp15_ = errno;
	g_assert_cmpint (_tmp15_, ==, ENOTTY);
	errno = 0;
	_tmp16_ = open ("/dev/tty", O_RDWR, (mode_t) 0);
	fd2 = _tmp16_;
	_tmp17_ = fd2;
	if (_tmp17_ > 0) {
		gint _tmp18_ = 0;
		gint _tmp19_ = 0;
		gint _tmp20_ = 0;
		gint _tmp21_ = 0;
		_tmp18_ = fd2;
		_tmp19_ = ioctl (_tmp18_, TIOCSBRK, 0);
		g_assert_cmpint (_tmp19_, ==, 0);
		_tmp20_ = errno;
		g_assert_cmpint (_tmp20_, ==, 0);
		_tmp21_ = fd2;
		close (_tmp21_);
	}
	_tmp22_ = fd;
	close (_tmp22_);
	_g_object_unref0 (tb);
}


static guint8* _vala_array_dup1 (guint8* self, int length) {
	return g_memdup (self, length * sizeof (guint8));
}


void t_usbfs_ioctl_tree (void) {
	UMockdevTestbed* tb = NULL;
	UMockdevTestbed* _tmp0_ = NULL;
	UMockdevTestbed* _tmp1_ = NULL;
	gchar* test_tree = NULL;
	gchar* tmppath = NULL;
	gint fd = 0;
	gint _tmp7_ = 0;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gssize _tmp12_ = 0L;
	gint i = 0;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	gint _tmp20_ = 0;
	gint _tmp21_ = 0;
	gint _tmp22_ = 0;
	gint _tmp23_ = 0;
	gint _tmp24_ = 0;
	struct usbdevfs_connectinfo ci = {0};
	gint _tmp25_ = 0;
	gint _tmp26_ = 0;
	gint _tmp27_ = 0;
	struct usbdevfs_connectinfo _tmp28_ = {0};
	guint _tmp29_ = 0U;
	struct usbdevfs_connectinfo _tmp30_ = {0};
	guint _tmp31_ = 0U;
	guint8* urb_buffer = NULL;
	guint8* _tmp32_ = NULL;
	gint urb_buffer_length1 = 0;
	gint _urb_buffer_size_ = 0;
	struct usbdevfs_urb urb = {0};
	guint8* _tmp33_ = NULL;
	gint _tmp33__length1 = 0;
	struct usbdevfs_urb _tmp34_ = {0};
	gint _tmp35_ = 0;
	gint _tmp36_ = 0;
	gint _tmp37_ = 0;
	struct usbdevfs_urb _tmp38_ = {0};
	gint _tmp39_ = 0;
	guint8 _tmp40_ = 0U;
	struct usbdevfs_urb* urb_reap = NULL;
	gint _tmp41_ = 0;
	gint _tmp42_ = 0;
	gint _tmp43_ = 0;
	struct usbdevfs_urb* _tmp44_ = NULL;
	struct usbdevfs_urb _tmp45_ = {0};
	gint _tmp46_ = 0;
	struct usbdevfs_urb _tmp47_ = {0};
	guint8* _tmp48_ = NULL;
	gint _tmp48__length1 = 0;
	guint8 _tmp49_ = 0U;
	struct usbdevfs_urb _tmp50_ = {0};
	guint8* _tmp51_ = NULL;
	gint _tmp51__length1 = 0;
	guint8 _tmp52_ = 0U;
	struct usbdevfs_urb _tmp53_ = {0};
	guint8* _tmp54_ = NULL;
	gint _tmp54__length1 = 0;
	guint8 _tmp55_ = 0U;
	struct usbdevfs_urb _tmp56_ = {0};
	guint8* _tmp57_ = NULL;
	gint _tmp57__length1 = 0;
	guint8 _tmp58_ = 0U;
	gint fd2 = 0;
	gint _tmp59_ = 0;
	gint _tmp60_ = 0;
	gint _tmp61_ = 0;
	struct usbdevfs_connectinfo _tmp62_ = {0};
	guint _tmp63_ = 0U;
	struct usbdevfs_connectinfo _tmp64_ = {0};
	guint _tmp65_ = 0U;
	gint _tmp66_ = 0;
	gint _tmp67_ = 0;
	gint _tmp68_ = 0;
	struct usbdevfs_connectinfo _tmp69_ = {0};
	guint _tmp70_ = 0U;
	struct usbdevfs_connectinfo _tmp71_ = {0};
	guint _tmp72_ = 0U;
	gint _tmp73_ = 0;
	gint _tmp74_ = 0;
	gint _tmp75_ = 0;
	struct usbdevfs_connectinfo _tmp76_ = {0};
	guint _tmp77_ = 0U;
	struct usbdevfs_connectinfo _tmp78_ = {0};
	guint _tmp79_ = 0U;
	GError * _inner_error_ = NULL;
	_tmp0_ = umockdev_testbed_new ();
	tb = _tmp0_;
	_tmp1_ = tb;
	tb_add_from_string (_tmp1_, "P: /devices/mycam\nN: 001\nE: SUBSYSTEM=usb\n");
	if (G_BYTE_ORDER == G_LITTLE_ENDIAN) {
		gchar* _tmp2_ = NULL;
		_tmp2_ = g_strdup ("# little-endian test ioctls\n" \
"USBDEVFS_CONNECTINFO 0 0B00000000000000\n" \
"USBDEVFS_REAPURB 0 1 129 -1 0 4 4 0 9902AAFF\n" \
"\n" \
"# another connect info\n" \
"USBDEVFS_CONNECTINFO 42 0C00000001000000\n");
		_g_free0 (test_tree);
		test_tree = _tmp2_;
	} else {
		gchar* _tmp3_ = NULL;
		_tmp3_ = g_strdup ("# big-endian test ioctls\n" \
"USBDEVFS_CONNECTINFO 0 0000000B00000000\n" \
"USBDEVFS_REAPURB 0 1 129 -1 0 4 4 0 9902AAFF\n" \
"\n" \
"# another connect info\n" \
"USBDEVFS_CONNECTINFO 42 0000000C01000000\n");
		_g_free0 (test_tree);
		test_tree = _tmp3_;
	}
	{
		gint _tmp4_ = 0;
		gchar* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		_tmp6_ = g_file_open_tmp ("test_ioctl_tree.XXXXXX", &_tmp5_, &_inner_error_);
		_g_free0 (tmppath);
		tmppath = _tmp5_;
		_tmp4_ = _tmp6_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch1_g_error;
		}
		fd = _tmp4_;
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		abort ();
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (tmppath);
		_g_free0 (test_tree);
		_g_object_unref0 (tb);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp7_ = fd;
	_tmp8_ = test_tree;
	_tmp9_ = test_tree;
	_tmp10_ = strlen (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = write (_tmp7_, _tmp8_, (gsize) _tmp11_);
	g_assert_cmpint ((gint) _tmp12_, >, 20);
	i = 1;
	_tmp13_ = fd;
	_tmp14_ = ioctl (_tmp13_, USBDEVFS_CLAIMINTERFACE, &i);
	g_assert_cmpint (_tmp14_, ==, -1);
	_tmp15_ = errno;
	g_assert_cmpint (_tmp15_, >=, 22);
	_tmp16_ = fd;
	close (_tmp16_);
	{
		UMockdevTestbed* _tmp17_ = NULL;
		_tmp17_ = tb;
		umockdev_testbed_load_ioctl (_tmp17_, "/dev/001", tmppath, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		FILE* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp18_ = stderr;
		_tmp19_ = e->message;
		fprintf (_tmp18_, "Cannot load ioctls: %s\n", _tmp19_);
		abort ();
		_g_error_free0 (e);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (tmppath);
		_g_free0 (test_tree);
		_g_object_unref0 (tb);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	g_unlink (tmppath);
	_tmp20_ = open ("/dev/001", O_RDWR, (mode_t) 0);
	fd = _tmp20_;
	_tmp21_ = fd;
	g_assert_cmpint (_tmp21_, >=, 0);
	_tmp22_ = fd;
	_tmp23_ = ioctl (_tmp22_, USBDEVFS_CLAIMINTERFACE, &i);
	g_assert_cmpint (_tmp23_, ==, 0);
	_tmp24_ = errno;
	g_assert_cmpint (_tmp24_, ==, 0);
	memset (&ci, 0, sizeof (struct usbdevfs_connectinfo));
	_tmp25_ = fd;
	_tmp26_ = ioctl (_tmp25_, USBDEVFS_CONNECTINFO, &ci);
	g_assert_cmpint (_tmp26_, ==, 0);
	_tmp27_ = errno;
	g_assert_cmpint (_tmp27_, ==, 0);
	_tmp28_ = ci;
	_tmp29_ = _tmp28_.devnum;
	g_assert_cmpuint (_tmp29_, ==, (guint) 11);
	_tmp30_ = ci;
	_tmp31_ = _tmp30_.slow;
	g_assert_cmpuint (_tmp31_, ==, (guint) 0);
	_tmp32_ = g_new0 (guint8, 4);
	urb_buffer = _tmp32_;
	urb_buffer_length1 = 4;
	_urb_buffer_size_ = urb_buffer_length1;
	_tmp33_ = (urb_buffer != NULL) ? _vala_array_dup1 (urb_buffer, urb_buffer_length1) : ((gpointer) urb_buffer);
	_tmp33__length1 = urb_buffer_length1;
	_tmp34_.type = (guint8) 1;
	_tmp34_.endpoint = (guint8) 129;
	_tmp34_.status = 0;
	_tmp34_.flags = (guint) 0;
	_tmp34_.buffer = (g_free (_tmp34_.buffer), NULL);
	_tmp34_.buffer = _tmp33_;
	_tmp34_.buffer_length = 4;
	_tmp34_.actual_length = 0;
	urb = _tmp34_;
	_tmp35_ = fd;
	_tmp36_ = ioctl (_tmp35_, USBDEVFS_SUBMITURB, &urb);
	g_assert_cmpint (_tmp36_, ==, 0);
	_tmp37_ = errno;
	g_assert_cmpint (_tmp37_, ==, 0);
	_tmp38_ = urb;
	_tmp39_ = _tmp38_.status;
	g_assert_cmpuint ((guint) _tmp39_, ==, (guint) 0);
	_tmp40_ = urb_buffer[0];
	g_assert_cmpint ((gint) _tmp40_, ==, 0);
	urb_reap = NULL;
	_tmp41_ = fd;
	_tmp42_ = ioctl (_tmp41_, USBDEVFS_REAPURB, &urb_reap);
	g_assert_cmpint (_tmp42_, ==, 0);
	_tmp43_ = errno;
	g_assert_cmpint (_tmp43_, ==, 0);
	_tmp44_ = urb_reap;
	_vala_assert (_tmp44_ == (&urb), "urb_reap == &urb");
	_tmp45_ = urb;
	_tmp46_ = _tmp45_.status;
	g_assert_cmpint (_tmp46_, ==, -1);
	_tmp47_ = urb;
	_tmp48_ = _tmp47_.buffer;
	_tmp48__length1 = -1;
	_tmp49_ = _tmp48_[0];
	g_assert_cmpuint ((guint) _tmp49_, ==, (guint) 0x99);
	_tmp50_ = urb;
	_tmp51_ = _tmp50_.buffer;
	_tmp51__length1 = -1;
	_tmp52_ = _tmp51_[1];
	g_assert_cmpuint ((guint) _tmp52_, ==, (guint) 0x02);
	_tmp53_ = urb;
	_tmp54_ = _tmp53_.buffer;
	_tmp54__length1 = -1;
	_tmp55_ = _tmp54_[2];
	g_assert_cmpuint ((guint) _tmp55_, ==, (guint) 0xAA);
	_tmp56_ = urb;
	_tmp57_ = _tmp56_.buffer;
	_tmp57__length1 = -1;
	_tmp58_ = _tmp57_[3];
	g_assert_cmpuint ((guint) _tmp58_, ==, (guint) 0xFF);
	_tmp59_ = open ("/dev/001", O_RDWR, (mode_t) 0);
	fd2 = _tmp59_;
	g_assert_cmpint (fd2, >=, 0);
	ci.devnum = (guint) 99;
	ci.slow = (guint) 99;
	_tmp60_ = ioctl (fd2, USBDEVFS_CONNECTINFO, &ci);
	g_assert_cmpint (_tmp60_, ==, 0);
	_tmp61_ = errno;
	g_assert_cmpint (_tmp61_, ==, 0);
	_tmp62_ = ci;
	_tmp63_ = _tmp62_.devnum;
	g_assert_cmpuint (_tmp63_, ==, (guint) 11);
	_tmp64_ = ci;
	_tmp65_ = _tmp64_.slow;
	g_assert_cmpuint (_tmp65_, ==, (guint) 0);
	ci.devnum = (guint) 99;
	ci.slow = (guint) 99;
	_tmp66_ = fd;
	_tmp67_ = ioctl (_tmp66_, USBDEVFS_CONNECTINFO, &ci);
	g_assert_cmpint (_tmp67_, ==, 42);
	_tmp68_ = errno;
	g_assert_cmpint (_tmp68_, ==, 0);
	_tmp69_ = ci;
	_tmp70_ = _tmp69_.devnum;
	g_assert_cmpuint (_tmp70_, ==, (guint) 12);
	_tmp71_ = ci;
	_tmp72_ = _tmp71_.slow;
	g_assert_cmpuint (_tmp72_, ==, (guint) 1);
	_tmp73_ = fd;
	close (_tmp73_);
	ci.devnum = (guint) 99;
	ci.slow = (guint) 99;
	_tmp74_ = ioctl (fd2, USBDEVFS_CONNECTINFO, &ci);
	g_assert_cmpint (_tmp74_, ==, 42);
	_tmp75_ = errno;
	g_assert_cmpint (_tmp75_, ==, 0);
	_tmp76_ = ci;
	_tmp77_ = _tmp76_.devnum;
	g_assert_cmpuint (_tmp77_, ==, (guint) 12);
	_tmp78_ = ci;
	_tmp79_ = _tmp78_.slow;
	g_assert_cmpuint (_tmp79_, ==, (guint) 1);
	close (fd2);
	 (&urb);
	urb_buffer = (g_free (urb_buffer), NULL);
	_g_free0 (tmppath);
	_g_free0 (test_tree);
	_g_object_unref0 (tb);
}


void t_usbfs_ioctl_tree_with_default_device (void) {
	UMockdevTestbed* tb = NULL;
	UMockdevTestbed* _tmp0_ = NULL;
	UMockdevTestbed* _tmp1_ = NULL;
	gchar* test_tree = NULL;
	gchar* tmppath = NULL;
	gint fd = 0;
	gint _tmp7_ = 0;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gssize _tmp12_ = 0L;
	gint _tmp13_ = 0;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	struct usbdevfs_connectinfo ci = {0};
	gint _tmp19_ = 0;
	gint _tmp20_ = 0;
	gint _tmp21_ = 0;
	struct usbdevfs_connectinfo _tmp22_ = {0};
	guint _tmp23_ = 0U;
	struct usbdevfs_connectinfo _tmp24_ = {0};
	guint _tmp25_ = 0U;
	GError * _inner_error_ = NULL;
	_tmp0_ = umockdev_testbed_new ();
	tb = _tmp0_;
	_tmp1_ = tb;
	tb_add_from_string (_tmp1_, "P: /devices/mycam\nN: 001\nE: SUBSYSTEM=usb\n");
	if (G_BYTE_ORDER == G_LITTLE_ENDIAN) {
		gchar* _tmp2_ = NULL;
		_tmp2_ = g_strdup ("# little-endian test ioctls\n" \
"@DEV /dev/001\n" \
"USBDEVFS_CONNECTINFO 0 0B00000000000000\n");
		_g_free0 (test_tree);
		test_tree = _tmp2_;
	} else {
		gchar* _tmp3_ = NULL;
		_tmp3_ = g_strdup ("# big-endian test ioctls\n" \
"@DEV /dev/001\n" \
"USBDEVFS_CONNECTINFO 0 0000000B00000000\n");
		_g_free0 (test_tree);
		test_tree = _tmp3_;
	}
	{
		gint _tmp4_ = 0;
		gchar* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		_tmp6_ = g_file_open_tmp ("test_ioctl_tree.XXXXXX", &_tmp5_, &_inner_error_);
		_g_free0 (tmppath);
		tmppath = _tmp5_;
		_tmp4_ = _tmp6_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch3_g_error;
		}
		fd = _tmp4_;
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		abort ();
		_g_error_free0 (e);
	}
	__finally3:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (tmppath);
		_g_free0 (test_tree);
		_g_object_unref0 (tb);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp7_ = fd;
	_tmp8_ = test_tree;
	_tmp9_ = test_tree;
	_tmp10_ = strlen (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = write (_tmp7_, _tmp8_, (gsize) _tmp11_);
	g_assert_cmpint ((gint) _tmp12_, >, 20);
	_tmp13_ = fd;
	close (_tmp13_);
	{
		UMockdevTestbed* _tmp14_ = NULL;
		_tmp14_ = tb;
		umockdev_testbed_load_ioctl (_tmp14_, NULL, tmppath, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch4_g_error;
		}
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e = NULL;
		FILE* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp15_ = stderr;
		_tmp16_ = e->message;
		fprintf (_tmp15_, "Cannot load ioctls: %s\n", _tmp16_);
		abort ();
		_g_error_free0 (e);
	}
	__finally4:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (tmppath);
		_g_free0 (test_tree);
		_g_object_unref0 (tb);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	g_unlink (tmppath);
	_tmp17_ = open ("/dev/001", O_RDWR, (mode_t) 0);
	fd = _tmp17_;
	_tmp18_ = fd;
	g_assert_cmpint (_tmp18_, >=, 0);
	memset (&ci, 0, sizeof (struct usbdevfs_connectinfo));
	_tmp19_ = fd;
	_tmp20_ = ioctl (_tmp19_, USBDEVFS_CONNECTINFO, &ci);
	g_assert_cmpint (_tmp20_, ==, 0);
	_tmp21_ = errno;
	g_assert_cmpint (_tmp21_, ==, 0);
	_tmp22_ = ci;
	_tmp23_ = _tmp22_.devnum;
	g_assert_cmpuint (_tmp23_, ==, (guint) 11);
	_tmp24_ = ci;
	_tmp25_ = _tmp24_.slow;
	g_assert_cmpuint (_tmp25_, ==, (guint) 0);
	_g_free0 (tmppath);
	_g_free0 (test_tree);
	_g_object_unref0 (tb);
}


void t_usbfs_ioctl_tree_override_default_device (void) {
	UMockdevTestbed* tb = NULL;
	UMockdevTestbed* _tmp0_ = NULL;
	UMockdevTestbed* _tmp1_ = NULL;
	gchar* test_tree = NULL;
	gchar* tmppath = NULL;
	gint fd = 0;
	gint _tmp7_ = 0;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gssize _tmp12_ = 0L;
	gint _tmp13_ = 0;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	struct usbdevfs_connectinfo ci = {0};
	gint _tmp19_ = 0;
	gint _tmp20_ = 0;
	gint _tmp21_ = 0;
	struct usbdevfs_connectinfo _tmp22_ = {0};
	guint _tmp23_ = 0U;
	struct usbdevfs_connectinfo _tmp24_ = {0};
	guint _tmp25_ = 0U;
	GError * _inner_error_ = NULL;
	_tmp0_ = umockdev_testbed_new ();
	tb = _tmp0_;
	_tmp1_ = tb;
	tb_add_from_string (_tmp1_, "P: /devices/mycam\nN: 002\nE: SUBSYSTEM=usb\n");
	if (G_BYTE_ORDER == G_LITTLE_ENDIAN) {
		gchar* _tmp2_ = NULL;
		_tmp2_ = g_strdup ("# little-endian test ioctls\n" \
"@DEV /dev/001\n" \
"USBDEVFS_CONNECTINFO 0 0B00000000000000\n");
		_g_free0 (test_tree);
		test_tree = _tmp2_;
	} else {
		gchar* _tmp3_ = NULL;
		_tmp3_ = g_strdup ("# big-endian test ioctls\n" \
"@DEV /dev/001\n" \
"USBDEVFS_CONNECTINFO 0 0000000B00000000\n");
		_g_free0 (test_tree);
		test_tree = _tmp3_;
	}
	{
		gint _tmp4_ = 0;
		gchar* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		_tmp6_ = g_file_open_tmp ("test_ioctl_tree.XXXXXX", &_tmp5_, &_inner_error_);
		_g_free0 (tmppath);
		tmppath = _tmp5_;
		_tmp4_ = _tmp6_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch5_g_error;
		}
		fd = _tmp4_;
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		abort ();
		_g_error_free0 (e);
	}
	__finally5:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (tmppath);
		_g_free0 (test_tree);
		_g_object_unref0 (tb);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp7_ = fd;
	_tmp8_ = test_tree;
	_tmp9_ = test_tree;
	_tmp10_ = strlen (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = write (_tmp7_, _tmp8_, (gsize) _tmp11_);
	g_assert_cmpint ((gint) _tmp12_, >, 20);
	_tmp13_ = fd;
	close (_tmp13_);
	{
		UMockdevTestbed* _tmp14_ = NULL;
		_tmp14_ = tb;
		umockdev_testbed_load_ioctl (_tmp14_, "/dev/002", tmppath, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch6_g_error;
		}
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError* e = NULL;
		FILE* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp15_ = stderr;
		_tmp16_ = e->message;
		fprintf (_tmp15_, "Cannot load ioctls: %s\n", _tmp16_);
		abort ();
		_g_error_free0 (e);
	}
	__finally6:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (tmppath);
		_g_free0 (test_tree);
		_g_object_unref0 (tb);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	g_unlink (tmppath);
	_tmp17_ = open ("/dev/002", O_RDWR, (mode_t) 0);
	fd = _tmp17_;
	_tmp18_ = fd;
	g_assert_cmpint (_tmp18_, >=, 0);
	memset (&ci, 0, sizeof (struct usbdevfs_connectinfo));
	_tmp19_ = fd;
	_tmp20_ = ioctl (_tmp19_, USBDEVFS_CONNECTINFO, &ci);
	g_assert_cmpint (_tmp20_, ==, 0);
	_tmp21_ = errno;
	g_assert_cmpint (_tmp21_, ==, 0);
	_tmp22_ = ci;
	_tmp23_ = _tmp22_.devnum;
	g_assert_cmpuint (_tmp23_, ==, (guint) 11);
	_tmp24_ = ci;
	_tmp25_ = _tmp24_.slow;
	g_assert_cmpuint (_tmp25_, ==, (guint) 0);
	_g_free0 (tmppath);
	_g_free0 (test_tree);
	_g_object_unref0 (tb);
}


void t_usbfs_ioctl_tree_xz (void) {
	UMockdevTestbed* tb = NULL;
	UMockdevTestbed* _tmp0_ = NULL;
	UMockdevTestbed* _tmp1_ = NULL;
	gchar* test_tree = NULL;
	gchar* tmppath = NULL;
	gint exit = 0;
	gint fd = 0;
	gint _tmp22_ = 0;
	struct usbdevfs_connectinfo ci = {0};
	gint _tmp23_ = 0;
	gint _tmp24_ = 0;
	struct usbdevfs_connectinfo _tmp25_ = {0};
	guint _tmp26_ = 0U;
	struct usbdevfs_connectinfo _tmp27_ = {0};
	guint _tmp28_ = 0U;
	gint _tmp29_ = 0;
	gint _tmp30_ = 0;
	struct usbdevfs_connectinfo _tmp31_ = {0};
	guint _tmp32_ = 0U;
	struct usbdevfs_connectinfo _tmp33_ = {0};
	guint _tmp34_ = 0U;
	GError * _inner_error_ = NULL;
	_tmp0_ = umockdev_testbed_new ();
	tb = _tmp0_;
	_tmp1_ = tb;
	tb_add_from_string (_tmp1_, "P: /devices/mycam\nN: 001\nE: SUBSYSTEM=usb\n");
	if (G_BYTE_ORDER == G_LITTLE_ENDIAN) {
		gchar* _tmp2_ = NULL;
		_tmp2_ = g_strdup ("USBDEVFS_CONNECTINFO 0 0B00000000000000\n" \
"USBDEVFS_REAPURB 0 1 129 -1 0 4 4 0 9902AAFF\n" \
"USBDEVFS_CONNECTINFO 42 0C00000001000000\n");
		_g_free0 (test_tree);
		test_tree = _tmp2_;
	} else {
		gchar* _tmp3_ = NULL;
		_tmp3_ = g_strdup ("USBDEVFS_CONNECTINFO 0 0000000B00000000\n" \
"USBDEVFS_REAPURB 0 1 129 -1 0 4 4 0 9902AAFF\n" \
"USBDEVFS_CONNECTINFO 42 0000000C01000000\n");
		_g_free0 (test_tree);
		test_tree = _tmp3_;
	}
	{
		gint _tmp4_ = 0;
		gchar* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		_tmp6_ = g_file_open_tmp ("test_ioctl_tree.XXXXXX.xz", &_tmp5_, &_inner_error_);
		_g_free0 (tmppath);
		tmppath = _tmp5_;
		_tmp4_ = _tmp6_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch7_g_error;
		}
		close (_tmp4_);
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		abort ();
		_g_error_free0 (e);
	}
	__finally7:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (tmppath);
		_g_free0 (test_tree);
		_g_object_unref0 (tb);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	{
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		gint _tmp16_ = 0;
		_tmp7_ = test_tree;
		_tmp8_ = g_strconcat ("sh -c 'echo \"", _tmp7_, NULL);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strconcat (_tmp9_, "\" | xz -9c > ", NULL);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_strconcat (_tmp11_, tmppath, NULL);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_strconcat (_tmp13_, "; sync'", NULL);
		_tmp15_ = _tmp14_;
		g_spawn_command_line_sync (_tmp15_, NULL, NULL, &_tmp16_, &_inner_error_);
		exit = _tmp16_;
		_g_free0 (_tmp15_);
		_g_free0 (_tmp13_);
		_g_free0 (_tmp11_);
		_g_free0 (_tmp9_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch8_g_spawn_error;
			}
			_g_free0 (tmppath);
			_g_free0 (test_tree);
			_g_object_unref0 (tb);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally8;
	__catch8_g_spawn_error:
	{
		GError* e = NULL;
		FILE* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp17_ = stderr;
		_tmp18_ = e->message;
		fprintf (_tmp17_, "Cannot call xz: %s\n", _tmp18_);
		abort ();
		_g_error_free0 (e);
	}
	__finally8:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (tmppath);
		_g_free0 (test_tree);
		_g_object_unref0 (tb);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	g_assert_cmpint (exit, ==, 0);
	{
		UMockdevTestbed* _tmp19_ = NULL;
		_tmp19_ = tb;
		umockdev_testbed_load_ioctl (_tmp19_, "/dev/001", tmppath, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch9_g_error;
		}
	}
	goto __finally9;
	__catch9_g_error:
	{
		GError* e = NULL;
		FILE* _tmp20_ = NULL;
		const gchar* _tmp21_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp20_ = stderr;
		_tmp21_ = e->message;
		fprintf (_tmp20_, "Cannot load ioctls: %s\n", _tmp21_);
		abort ();
		_g_error_free0 (e);
	}
	__finally9:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (tmppath);
		_g_free0 (test_tree);
		_g_object_unref0 (tb);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	g_unlink (tmppath);
	_tmp22_ = open ("/dev/001", O_RDWR, (mode_t) 0);
	fd = _tmp22_;
	g_assert_cmpint (fd, >=, 0);
	memset (&ci, 0, sizeof (struct usbdevfs_connectinfo));
	_tmp23_ = ioctl (fd, USBDEVFS_CONNECTINFO, &ci);
	g_assert_cmpint (_tmp23_, ==, 0);
	_tmp24_ = errno;
	g_assert_cmpint (_tmp24_, ==, 0);
	_tmp25_ = ci;
	_tmp26_ = _tmp25_.devnum;
	g_assert_cmpuint (_tmp26_, ==, (guint) 11);
	_tmp27_ = ci;
	_tmp28_ = _tmp27_.slow;
	g_assert_cmpuint (_tmp28_, ==, (guint) 0);
	_tmp29_ = ioctl (fd, USBDEVFS_CONNECTINFO, &ci);
	g_assert_cmpint (_tmp29_, ==, 42);
	_tmp30_ = errno;
	g_assert_cmpint (_tmp30_, ==, 0);
	_tmp31_ = ci;
	_tmp32_ = _tmp31_.devnum;
	g_assert_cmpuint (_tmp32_, ==, (guint) 12);
	_tmp33_ = ci;
	_tmp34_ = _tmp33_.slow;
	g_assert_cmpuint (_tmp34_, ==, (guint) 1);
	close (fd);
	_g_free0 (tmppath);
	_g_free0 (test_tree);
	_g_object_unref0 (tb);
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


void t_tty_stty (void) {
	UMockdevTestbed* tb = NULL;
	UMockdevTestbed* _tmp0_ = NULL;
	struct stat st = {0};
	struct stat _tmp1_ = {0};
	gint _tmp2_ = 0;
	struct stat _tmp3_ = {0};
	mode_t _tmp4_ = {0};
	gboolean _tmp5_ = FALSE;
	struct stat _tmp6_ = {0};
	dev_t _tmp7_ = {0};
	guint _tmp8_ = 0U;
	struct stat _tmp9_ = {0};
	dev_t _tmp10_ = {0};
	guint _tmp11_ = 0U;
	gchar* pout = NULL;
	gchar* perr = NULL;
	gint pexit = 0;
	gboolean _tmp17_ = FALSE;
	GError * _inner_error_ = NULL;
	_tmp0_ = umockdev_testbed_new ();
	tb = _tmp0_;
	tb_add_from_string (tb, "P: /devices/usb/tty/ttyUSB1\n" \
"N: ttyUSB1\n" \
"E: DEVNAME=/dev/ttyUSB1\n" \
"E: SUBSYSTEM=tty\n" \
"A: dev=188:1\n");
	_tmp2_ = lstat ("/dev/ttyUSB1", &_tmp1_);
	st = _tmp1_;
	g_assert_cmpint (_tmp2_, ==, 0);
	_tmp3_ = st;
	_tmp4_ = _tmp3_.st_mode;
	_tmp5_ = S_ISCHR (_tmp4_);
	_vala_assert (_tmp5_, "Posix.S_ISCHR (st.st_mode)");
	_tmp6_ = st;
	_tmp7_ = _tmp6_.st_rdev;
	_tmp8_ = major (_tmp7_);
	g_assert_cmpuint (_tmp8_, ==, (guint) 188);
	_tmp9_ = st;
	_tmp10_ = _tmp9_.st_rdev;
	_tmp11_ = minor (_tmp10_);
	g_assert_cmpuint (_tmp11_, ==, (guint) 1);
	{
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		gint _tmp14_ = 0;
		g_spawn_command_line_sync ("stty -F /dev/ttyUSB1", &_tmp12_, &_tmp13_, &_tmp14_, &_inner_error_);
		_g_free0 (pout);
		pout = _tmp12_;
		_g_free0 (perr);
		perr = _tmp13_;
		pexit = _tmp14_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch10_g_spawn_error;
			}
			_g_free0 (perr);
			_g_free0 (pout);
			_g_object_unref0 (tb);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally10;
	__catch10_g_spawn_error:
	{
		GError* e = NULL;
		FILE* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp15_ = stderr;
		_tmp16_ = e->message;
		fprintf (_tmp15_, "Cannot call stty: %s\n", _tmp16_);
		abort ();
		_g_error_free0 (e);
	}
	__finally10:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (perr);
		_g_free0 (pout);
		_g_object_unref0 (tb);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	g_assert_cmpstr (perr, ==, "");
	g_assert_cmpint (pexit, ==, 0);
	_tmp17_ = string_contains (pout, "speed 38400 baud");
	_vala_assert (_tmp17_, "pout.contains (\"speed 38400 baud\")");
	_g_free0 (perr);
	_g_free0 (pout);
	_g_object_unref0 (tb);
}


void t_tty_data (void) {
	UMockdevTestbed* tb = NULL;
	UMockdevTestbed* _tmp0_ = NULL;
	gint client_fd = 0;
	gint _tmp1_ = 0;
	gint master_fd = 0;
	gint _tmp2_ = 0;
	gchar* buf = NULL;
	gchar* _tmp3_ = NULL;
	gint buf_length1 = 0;
	gint _buf_size_ = 0;
	gssize _tmp4_ = 0L;
	gchar* _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	gssize _tmp6_ = 0L;
	gchar* _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	gchar* _tmp8_ = NULL;
	gssize _tmp9_ = 0L;
	gchar* _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	gssize _tmp11_ = 0L;
	gchar* _tmp12_ = NULL;
	gint _tmp12__length1 = 0;
	_tmp0_ = umockdev_testbed_new ();
	tb = _tmp0_;
	tb_add_from_string (tb, "P: /devices/serial/ttyS10\n" \
"N: ttyS10\n" \
"E: DEVNAME=/dev/ttyS10\n" \
"E: SUBSYSTEM=tty\n" \
"A: dev=4:74\n");
	_tmp1_ = open ("/dev/ttyS10", O_RDWR, (mode_t) 0);
	client_fd = _tmp1_;
	g_assert_cmpint (client_fd, >=, 0);
	_tmp2_ = umockdev_testbed_get_dev_fd (tb, "/dev/ttyS10");
	master_fd = _tmp2_;
	g_assert_cmpint (master_fd, >=, 0);
	_tmp3_ = g_new0 (gchar, 100);
	buf = _tmp3_;
	buf_length1 = 100;
	_buf_size_ = buf_length1;
	_tmp4_ = write (client_fd, "hello\n", (gsize) 6);
	g_assert_cmpint ((gint) _tmp4_, ==, 6);
	_tmp5_ = buf;
	_tmp5__length1 = buf_length1;
	_tmp6_ = read (master_fd, _tmp5_, (gsize) 100);
	g_assert_cmpint ((gint) _tmp6_, ==, 6);
	_tmp7_ = buf;
	_tmp7__length1 = buf_length1;
	g_assert_cmpstr ((const gchar*) _tmp7_, ==, "hello\n");
	_tmp8_ = g_new0 (gchar, 100);
	buf = (g_free (buf), NULL);
	buf = _tmp8_;
	buf_length1 = 100;
	_buf_size_ = buf_length1;
	_tmp9_ = write (master_fd, "world\n", (gsize) 6);
	g_assert_cmpint ((gint) _tmp9_, ==, 6);
	_tmp10_ = buf;
	_tmp10__length1 = buf_length1;
	_tmp11_ = read (client_fd, _tmp10_, (gsize) 100);
	g_assert_cmpint ((gint) _tmp11_, ==, 6);
	_tmp12_ = buf;
	_tmp12__length1 = buf_length1;
	g_assert_cmpstr ((const gchar*) _tmp12_, ==, "world\n");
	close (client_fd);
	buf = (g_free (buf), NULL);
	_g_object_unref0 (tb);
}


void t_detects_running_in_testbed (void) {
	gboolean _tmp0_ = FALSE;
	_tmp0_ = umockdev_in_mock_environment ();
	_vala_assert (_tmp0_, "UMockdev.in_mock_environment()");
}


void t_detects_not_running_in_testbed (void) {
	gint pipefds[2] = {0};
	gint _tmp0_ = 0;
	pid_t pid = 0;
	pid_t _tmp1_ = 0;
	pid_t _tmp2_ = 0;
	pid_t _tmp3_ = 0;
	gint _tmp10_ = 0;
	gchar buf = '\0';
	gint _tmp11_ = 0;
	gssize _tmp12_ = 0L;
	gint _tmp13_ = 0;
	_tmp0_ = pipe (pipefds);
	g_assert_cmpint (_tmp0_, ==, 0);
	_tmp1_ = fork ();
	pid = _tmp1_;
	_tmp2_ = pid;
	g_assert_cmpint ((gint) _tmp2_, !=, -1);
	_tmp3_ = pid;
	if (_tmp3_ == ((pid_t) 0)) {
		gint _tmp4_ = 0;
		gchar** argv = NULL;
		gchar* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		gchar* _tmp7_ = NULL;
		gchar** _tmp8_ = NULL;
		gint argv_length1 = 0;
		gint _argv_size_ = 0;
		gchar** _tmp9_ = NULL;
		gint _tmp9__length1 = 0;
		_tmp4_ = pipefds[0];
		close (_tmp4_);
		g_unsetenv ("LD_PRELOAD");
		_tmp5_ = g_strdup ("--test-outside-testbed");
		_tmp6_ = pipefds[1];
		_tmp7_ = g_strdup_printf ("%i", _tmp6_);
		_tmp8_ = g_new0 (gchar*, 2 + 1);
		_tmp8_[0] = _tmp5_;
		_tmp8_[1] = _tmp7_;
		argv = _tmp8_;
		argv_length1 = 2;
		_argv_size_ = argv_length1;
		_tmp9_ = argv;
		_tmp9__length1 = argv_length1;
		execv ("/proc/self/exe", _tmp9_);
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp10_ = pipefds[1];
	close (_tmp10_);
	buf = 'x';
	_tmp11_ = pipefds[0];
	_tmp12_ = read (_tmp11_, &buf, (gsize) 1);
	g_assert_cmpint ((gint) _tmp12_, ==, 1);
	g_assert_cmpint ((gint) buf, ==, (gint) '0');
	_tmp13_ = pipefds[0];
	close (_tmp13_);
}


gint is_test_inside_testbed (gint pipefd) {
	gint result = 0;
	gchar buf[1] = {0};
	gchar _tmp0_ = '\0';
	gboolean _tmp1_ = FALSE;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	buf[0] = '0';
	_tmp0_ = buf[0];
	_tmp1_ = umockdev_in_mock_environment ();
	if (_tmp1_) {
		gchar _tmp2_ = '\0';
		buf[0] = '1';
		_tmp2_ = buf[0];
	}
	_tmp3_ = pipefd;
	write (_tmp3_, buf, (gsize) 1);
	_tmp4_ = atoi ((const gchar*) buf);
	result = _tmp4_;
	return result;
}


AttributeCounterThread* attribute_counter_thread_construct (GType object_type, UMockdevTestbed* tb, const gchar* syspath, const gchar* name, guint max) {
	AttributeCounterThread* self = NULL;
	UMockdevTestbed* _tmp0_ = NULL;
	UMockdevTestbed* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	guint _tmp6_ = 0U;
	g_return_val_if_fail (tb != NULL, NULL);
	g_return_val_if_fail (syspath != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	self = (AttributeCounterThread*) g_type_create_instance (object_type);
	_tmp0_ = tb;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->tb);
	self->priv->tb = _tmp1_;
	_tmp2_ = syspath;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (self->priv->syspath);
	self->priv->syspath = _tmp3_;
	_tmp4_ = name;
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 (self->priv->name);
	self->priv->name = _tmp5_;
	_tmp6_ = max;
	self->priv->count = _tmp6_;
	return self;
}


AttributeCounterThread* attribute_counter_thread_new (UMockdevTestbed* tb, const gchar* syspath, const gchar* name, guint max) {
	return attribute_counter_thread_construct (TYPE_ATTRIBUTE_COUNTER_THREAD, tb, syspath, name, max);
}


void* attribute_counter_thread_run (AttributeCounterThread* self) {
	void* result = NULL;
	gchar* attr_path = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->syspath;
	_tmp1_ = self->priv->name;
	_tmp2_ = g_build_filename (_tmp0_, _tmp1_, NULL);
	attr_path = _tmp2_;
	{
		gboolean _tmp3_ = FALSE;
		_tmp3_ = TRUE;
		while (TRUE) {
			guint _tmp5_ = 0U;
			gchar* cur_value = NULL;
			UMockdevTestbed* _tmp11_ = NULL;
			const gchar* _tmp12_ = NULL;
			const gchar* _tmp13_ = NULL;
			const gchar* _tmp14_ = NULL;
			gint _tmp15_ = 0;
			if (!_tmp3_) {
				guint _tmp4_ = 0U;
				_tmp4_ = self->priv->count;
				self->priv->count = _tmp4_ - 1;
			}
			_tmp3_ = FALSE;
			_tmp5_ = self->priv->count;
			if (!(_tmp5_ > ((guint) 0))) {
				break;
			}
			{
				const gchar* _tmp6_ = NULL;
				gchar* _tmp7_ = NULL;
				_tmp6_ = attr_path;
				g_file_get_contents (_tmp6_, &_tmp7_, NULL, &_inner_error_);
				_g_free0 (cur_value);
				cur_value = _tmp7_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == G_FILE_ERROR) {
						goto __catch11_g_file_error;
					}
					_g_free0 (cur_value);
					_g_free0 (attr_path);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			goto __finally11;
			__catch11_g_file_error:
			{
				GError* e = NULL;
				guint _tmp8_ = 0U;
				const gchar* _tmp9_ = NULL;
				const gchar* _tmp10_ = NULL;
				e = _inner_error_;
				_inner_error_ = NULL;
				_tmp8_ = self->priv->count;
				_tmp9_ = attr_path;
				_tmp10_ = e->message;
				g_error ("test-umockdev-vala.vala:552: (count %u) failed to read %s: %s", _tmp8_, _tmp9_, _tmp10_);
				_g_error_free0 (e);
			}
			__finally11:
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_free0 (cur_value);
				_g_free0 (attr_path);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			_tmp11_ = self->priv->tb;
			_tmp12_ = self->priv->syspath;
			_tmp13_ = self->priv->name;
			_tmp14_ = cur_value;
			_tmp15_ = atoi (_tmp14_);
			umockdev_testbed_set_attribute_int (_tmp11_, _tmp12_, _tmp13_, _tmp15_ + 1);
			_g_free0 (cur_value);
		}
	}
	result = NULL;
	_g_free0 (attr_path);
	return result;
}


static void value_attribute_counter_thread_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_attribute_counter_thread_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		attribute_counter_thread_unref (value->data[0].v_pointer);
	}
}


static void value_attribute_counter_thread_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = attribute_counter_thread_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_attribute_counter_thread_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_attribute_counter_thread_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		AttributeCounterThread* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = attribute_counter_thread_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_attribute_counter_thread_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	AttributeCounterThread** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = attribute_counter_thread_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_attribute_counter_thread (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecAttributeCounterThread* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_ATTRIBUTE_COUNTER_THREAD), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_attribute_counter_thread (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ATTRIBUTE_COUNTER_THREAD), NULL);
	return value->data[0].v_pointer;
}


void value_set_attribute_counter_thread (GValue* value, gpointer v_object) {
	AttributeCounterThread* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ATTRIBUTE_COUNTER_THREAD));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_ATTRIBUTE_COUNTER_THREAD));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		attribute_counter_thread_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		attribute_counter_thread_unref (old);
	}
}


void value_take_attribute_counter_thread (GValue* value, gpointer v_object) {
	AttributeCounterThread* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ATTRIBUTE_COUNTER_THREAD));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_ATTRIBUTE_COUNTER_THREAD));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		attribute_counter_thread_unref (old);
	}
}


static void attribute_counter_thread_class_init (AttributeCounterThreadClass * klass) {
	attribute_counter_thread_parent_class = g_type_class_peek_parent (klass);
	((AttributeCounterThreadClass *) klass)->finalize = attribute_counter_thread_finalize;
	g_type_class_add_private (klass, sizeof (AttributeCounterThreadPrivate));
}


static void attribute_counter_thread_instance_init (AttributeCounterThread * self) {
	self->priv = ATTRIBUTE_COUNTER_THREAD_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void attribute_counter_thread_finalize (AttributeCounterThread* obj) {
	AttributeCounterThread * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ATTRIBUTE_COUNTER_THREAD, AttributeCounterThread);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->tb);
	_g_free0 (self->priv->name);
	_g_free0 (self->priv->syspath);
}


GType attribute_counter_thread_get_type (void) {
	static volatile gsize attribute_counter_thread_type_id__volatile = 0;
	if (g_once_init_enter (&attribute_counter_thread_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_attribute_counter_thread_init, value_attribute_counter_thread_free_value, value_attribute_counter_thread_copy_value, value_attribute_counter_thread_peek_pointer, "p", value_attribute_counter_thread_collect_value, "p", value_attribute_counter_thread_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (AttributeCounterThreadClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) attribute_counter_thread_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AttributeCounterThread), 0, (GInstanceInitFunc) attribute_counter_thread_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType attribute_counter_thread_type_id;
		attribute_counter_thread_type_id = g_type_register_fundamental (g_type_fundamental_next (), "AttributeCounterThread", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&attribute_counter_thread_type_id__volatile, attribute_counter_thread_type_id);
	}
	return attribute_counter_thread_type_id__volatile;
}


gpointer attribute_counter_thread_ref (gpointer instance) {
	AttributeCounterThread* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void attribute_counter_thread_unref (gpointer instance) {
	AttributeCounterThread* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		ATTRIBUTE_COUNTER_THREAD_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static gpointer _attribute_counter_thread_run_gthread_func (gpointer self) {
	gpointer result;
	result = attribute_counter_thread_run ((AttributeCounterThread*) self);
	return result;
}


static gpointer _g_thread_ref0 (gpointer self) {
	return self ? g_thread_ref (self) : NULL;
}


void t_mt_parallel_attr_distinct (void) {
	UMockdevTestbed* tb = NULL;
	UMockdevTestbed* _tmp0_ = NULL;
	gchar* syspath = NULL;
	UMockdevTestbed* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar** _tmp8_ = NULL;
	gchar** _tmp9_ = NULL;
	gint _tmp9__length1 = 0;
	gchar** _tmp10_ = NULL;
	gchar** _tmp11_ = NULL;
	gint _tmp11__length1 = 0;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	AttributeCounterThread* t1d = NULL;
	UMockdevTestbed* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	AttributeCounterThread* _tmp16_ = NULL;
	AttributeCounterThread* t2d = NULL;
	UMockdevTestbed* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	AttributeCounterThread* _tmp19_ = NULL;
	AttributeCounterThread* t3d = NULL;
	UMockdevTestbed* _tmp20_ = NULL;
	const gchar* _tmp21_ = NULL;
	AttributeCounterThread* _tmp22_ = NULL;
	GThread* t1 = NULL;
	AttributeCounterThread* _tmp23_ = NULL;
	GThread* _tmp24_ = NULL;
	GThread* t2 = NULL;
	AttributeCounterThread* _tmp25_ = NULL;
	GThread* _tmp26_ = NULL;
	GThread* t3 = NULL;
	AttributeCounterThread* _tmp27_ = NULL;
	GThread* _tmp28_ = NULL;
	GThread* _tmp29_ = NULL;
	GThread* _tmp30_ = NULL;
	GThread* _tmp31_ = NULL;
	GThread* _tmp32_ = NULL;
	GThread* _tmp33_ = NULL;
	GThread* _tmp34_ = NULL;
	gchar* val = NULL;
	GError * _inner_error_ = NULL;
	_tmp0_ = umockdev_testbed_new ();
	tb = _tmp0_;
	_tmp1_ = tb;
	_tmp2_ = g_strdup ("c1");
	_tmp3_ = g_strdup ("0");
	_tmp4_ = g_strdup ("c2");
	_tmp5_ = g_strdup ("0");
	_tmp6_ = g_strdup ("c3");
	_tmp7_ = g_strdup ("0");
	_tmp8_ = g_new0 (gchar*, 6 + 1);
	_tmp8_[0] = _tmp2_;
	_tmp8_[1] = _tmp3_;
	_tmp8_[2] = _tmp4_;
	_tmp8_[3] = _tmp5_;
	_tmp8_[4] = _tmp6_;
	_tmp8_[5] = _tmp7_;
	_tmp9_ = _tmp8_;
	_tmp9__length1 = 6;
	_tmp10_ = g_new0 (gchar*, 0 + 1);
	_tmp11_ = _tmp10_;
	_tmp11__length1 = 0;
	_tmp12_ = umockdev_testbed_add_devicev (_tmp1_, "changelings", "rapid", NULL, _tmp9_, _tmp11_);
	_tmp13_ = _tmp12_;
	_tmp11_ = (_vala_array_free (_tmp11_, _tmp11__length1, (GDestroyNotify) g_free), NULL);
	_tmp9_ = (_vala_array_free (_tmp9_, _tmp9__length1, (GDestroyNotify) g_free), NULL);
	syspath = _tmp13_;
	_tmp14_ = tb;
	_tmp15_ = syspath;
	_tmp16_ = attribute_counter_thread_new (_tmp14_, _tmp15_, "c1", (guint) 100);
	t1d = _tmp16_;
	_tmp17_ = tb;
	_tmp18_ = syspath;
	_tmp19_ = attribute_counter_thread_new (_tmp17_, _tmp18_, "c2", (guint) 100);
	t2d = _tmp19_;
	_tmp20_ = tb;
	_tmp21_ = syspath;
	_tmp22_ = attribute_counter_thread_new (_tmp20_, _tmp21_, "c3", (guint) 100);
	t3d = _tmp22_;
	_tmp23_ = t1d;
	_tmp24_ = g_thread_new ("t_c1", _attribute_counter_thread_run_gthread_func, attribute_counter_thread_ref (_tmp23_));
	t1 = _tmp24_;
	_tmp25_ = t2d;
	_tmp26_ = g_thread_new ("t_c2", _attribute_counter_thread_run_gthread_func, attribute_counter_thread_ref (_tmp25_));
	t2 = _tmp26_;
	_tmp27_ = t3d;
	_tmp28_ = g_thread_new ("t_c3", _attribute_counter_thread_run_gthread_func, attribute_counter_thread_ref (_tmp27_));
	t3 = _tmp28_;
	_tmp29_ = t1;
	_tmp30_ = _g_thread_ref0 (_tmp29_);
	g_thread_join (_tmp30_);
	_tmp31_ = t2;
	_tmp32_ = _g_thread_ref0 (_tmp31_);
	g_thread_join (_tmp32_);
	_tmp33_ = t3;
	_tmp34_ = _g_thread_ref0 (_tmp33_);
	g_thread_join (_tmp34_);
	{
		const gchar* _tmp35_ = NULL;
		gchar* _tmp36_ = NULL;
		gchar* _tmp37_ = NULL;
		gchar* _tmp38_ = NULL;
		const gchar* _tmp39_ = NULL;
		const gchar* _tmp40_ = NULL;
		gchar* _tmp41_ = NULL;
		gchar* _tmp42_ = NULL;
		gchar* _tmp43_ = NULL;
		const gchar* _tmp44_ = NULL;
		const gchar* _tmp45_ = NULL;
		gchar* _tmp46_ = NULL;
		gchar* _tmp47_ = NULL;
		gchar* _tmp48_ = NULL;
		const gchar* _tmp49_ = NULL;
		_tmp35_ = syspath;
		_tmp36_ = g_build_filename (_tmp35_, "c1", NULL);
		_tmp37_ = _tmp36_;
		g_file_get_contents (_tmp37_, &_tmp38_, NULL, &_inner_error_);
		_g_free0 (val);
		val = _tmp38_;
		_g_free0 (_tmp37_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch12_g_file_error;
			}
			_g_free0 (val);
			_g_thread_unref0 (t3);
			_g_thread_unref0 (t2);
			_g_thread_unref0 (t1);
			_attribute_counter_thread_unref0 (t3d);
			_attribute_counter_thread_unref0 (t2d);
			_attribute_counter_thread_unref0 (t1d);
			_g_free0 (syspath);
			_g_object_unref0 (tb);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp39_ = val;
		g_assert_cmpstr (_tmp39_, ==, "100");
		_tmp40_ = syspath;
		_tmp41_ = g_build_filename (_tmp40_, "c2", NULL);
		_tmp42_ = _tmp41_;
		g_file_get_contents (_tmp42_, &_tmp43_, NULL, &_inner_error_);
		_g_free0 (val);
		val = _tmp43_;
		_g_free0 (_tmp42_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch12_g_file_error;
			}
			_g_free0 (val);
			_g_thread_unref0 (t3);
			_g_thread_unref0 (t2);
			_g_thread_unref0 (t1);
			_attribute_counter_thread_unref0 (t3d);
			_attribute_counter_thread_unref0 (t2d);
			_attribute_counter_thread_unref0 (t1d);
			_g_free0 (syspath);
			_g_object_unref0 (tb);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp44_ = val;
		g_assert_cmpstr (_tmp44_, ==, "100");
		_tmp45_ = syspath;
		_tmp46_ = g_build_filename (_tmp45_, "c3", NULL);
		_tmp47_ = _tmp46_;
		g_file_get_contents (_tmp47_, &_tmp48_, NULL, &_inner_error_);
		_g_free0 (val);
		val = _tmp48_;
		_g_free0 (_tmp47_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch12_g_file_error;
			}
			_g_free0 (val);
			_g_thread_unref0 (t3);
			_g_thread_unref0 (t2);
			_g_thread_unref0 (t1);
			_attribute_counter_thread_unref0 (t3d);
			_attribute_counter_thread_unref0 (t2d);
			_attribute_counter_thread_unref0 (t1d);
			_g_free0 (syspath);
			_g_object_unref0 (tb);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp49_ = val;
		g_assert_cmpstr (_tmp49_, ==, "100");
	}
	goto __finally12;
	__catch12_g_file_error:
	{
		GError* e = NULL;
		const gchar* _tmp50_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp50_ = e->message;
		g_error ("test-umockdev-vala.vala:595: failed to read attribute: %s", _tmp50_);
		_g_error_free0 (e);
	}
	__finally12:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (val);
		_g_thread_unref0 (t3);
		_g_thread_unref0 (t2);
		_g_thread_unref0 (t1);
		_attribute_counter_thread_unref0 (t3d);
		_attribute_counter_thread_unref0 (t2d);
		_attribute_counter_thread_unref0 (t1d);
		_g_free0 (syspath);
		_g_object_unref0 (tb);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (val);
	_g_thread_unref0 (t3);
	_g_thread_unref0 (t2);
	_g_thread_unref0 (t1);
	_attribute_counter_thread_unref0 (t3d);
	_attribute_counter_thread_unref0 (t2d);
	_attribute_counter_thread_unref0 (t1d);
	_g_free0 (syspath);
	_g_object_unref0 (tb);
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_free0 (_data1_->syspath);
		_g_main_loop_unref0 (_data1_->ml);
		_g_object_unref0 (_data1_->tb);
		g_slice_free (Block1Data, _data1_);
	}
}


static void __lambda4_ (Block1Data* _data1_, GUdevClient* client, const gchar* action, GUdevDevice* device) {
	const gchar* _tmp0_ = NULL;
	g_return_if_fail (client != NULL);
	g_return_if_fail (action != NULL);
	g_return_if_fail (device != NULL);
	_tmp0_ = action;
	if (g_strcmp0 (_tmp0_, "add") == 0) {
		guint _tmp1_ = 0U;
		_tmp1_ = _data1_->add_count;
		_data1_->add_count = _tmp1_ + 1;
	} else {
		_data1_->change_count = _data1_->change_count + 1;
		if (_data1_->change_count == _data1_->num_changes) {
			g_main_loop_quit (_data1_->ml);
		}
	}
}


static void ___lambda4__g_udev_client_uevent (GUdevClient* _sender, const gchar* action, GUdevDevice* device, gpointer self) {
	__lambda4_ (self, _sender, action, device);
}


static void* __lambda5_ (Block1Data* _data1_) {
	void* result = NULL;
	gchar* contents = NULL;
	GError * _inner_error_ = NULL;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		const gchar* _tmp3_ = NULL;
		_tmp0_ = g_main_loop_is_running (_data1_->ml);
		if (!_tmp0_) {
			break;
		}
		{
			gchar* _tmp1_ = NULL;
			g_file_get_contents ("/sys/devices/dev1/a", &_tmp1_, NULL, &_inner_error_);
			_g_free0 (contents);
			contents = _tmp1_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == G_FILE_ERROR) {
					goto __catch13_g_file_error;
				}
				_g_free0 (contents);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		goto __finally13;
		__catch13_g_file_error:
		{
			GError* e = NULL;
			const gchar* _tmp2_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp2_ = e->message;
			g_error ("test-umockdev-vala.vala:630: (#changes: %u) Error opening attribute fi" \
"le: %s", _data1_->change_count, _tmp2_);
			_g_error_free0 (e);
		}
		__finally13:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (contents);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp3_ = contents;
		g_assert_cmpstr (_tmp3_, ==, "1");
		umockdev_testbed_set_property (_data1_->tb, _data1_->syspath, "ID_FOO", "1");
	}
	result = NULL;
	_g_free0 (contents);
	return result;
}


static gpointer ___lambda5__gthread_func (gpointer self) {
	gpointer result;
	result = __lambda5_ (self);
	block1_data_unref (self);
	return result;
}


static void* __lambda6_ (Block1Data* _data1_) {
	void* result = NULL;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				guint _tmp2_ = 0U;
				if (!_tmp0_) {
					guint _tmp1_ = 0U;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				if (!(_tmp2_ < _data1_->num_changes)) {
					break;
				}
				umockdev_testbed_uevent (_data1_->tb, _data1_->syspath, "change");
			}
		}
	}
	result = NULL;
	return result;
}


static gpointer ___lambda6__gthread_func (gpointer self) {
	gpointer result;
	result = __lambda6_ (self);
	block1_data_unref (self);
	return result;
}


static gboolean __lambda7_ (Block1Data* _data1_) {
	gboolean result = FALSE;
	g_main_loop_quit (_data1_->ml);
	result = FALSE;
	return result;
}


static gboolean ___lambda7__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda7_ (self);
	return result;
}


void t_mt_uevent (void) {
	Block1Data* _data1_;
	UMockdevTestbed* _tmp0_ = NULL;
	GUdevClient* gudev = NULL;
	gchar* _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	GUdevClient* _tmp4_ = NULL;
	GUdevClient* _tmp5_ = NULL;
	GMainLoop* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar** _tmp9_ = NULL;
	gchar** _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar** _tmp13_ = NULL;
	gchar** _tmp14_ = NULL;
	gint _tmp14__length1 = 0;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	GThread* t_noise = NULL;
	GThread* _tmp17_ = NULL;
	GThread* t_emitter = NULL;
	GThread* _tmp18_ = NULL;
	GThread* _tmp19_ = NULL;
	GThread* _tmp20_ = NULL;
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_tmp0_ = umockdev_testbed_new ();
	_data1_->tb = _tmp0_;
	_tmp1_ = g_strdup ("pci");
	_tmp2_ = g_new0 (gchar*, 1 + 1);
	_tmp2_[0] = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp3__length1 = 1;
	_tmp4_ = g_udev_client_new (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) g_free), NULL);
	gudev = _tmp5_;
	_tmp6_ = g_main_loop_new (NULL, FALSE);
	_data1_->ml = _tmp6_;
	_data1_->add_count = (guint) 0;
	_data1_->change_count = (guint) 0;
	_data1_->num_changes = (guint) 10;
	g_signal_connect_data (gudev, "uevent", (GCallback) ___lambda4__g_udev_client_uevent, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp7_ = g_strdup ("a");
	_tmp8_ = g_strdup ("1");
	_tmp9_ = g_new0 (gchar*, 2 + 1);
	_tmp9_[0] = _tmp7_;
	_tmp9_[1] = _tmp8_;
	_tmp10_ = _tmp9_;
	_tmp10__length1 = 2;
	_tmp11_ = g_strdup ("DEVTYPE");
	_tmp12_ = g_strdup ("fancy");
	_tmp13_ = g_new0 (gchar*, 2 + 1);
	_tmp13_[0] = _tmp11_;
	_tmp13_[1] = _tmp12_;
	_tmp14_ = _tmp13_;
	_tmp14__length1 = 2;
	_tmp15_ = umockdev_testbed_add_devicev (_data1_->tb, "pci", "dev1", NULL, _tmp10_, _tmp14_);
	_tmp16_ = _tmp15_;
	_tmp14_ = (_vala_array_free (_tmp14_, _tmp14__length1, (GDestroyNotify) g_free), NULL);
	_tmp10_ = (_vala_array_free (_tmp10_, _tmp10__length1, (GDestroyNotify) g_free), NULL);
	_data1_->syspath = _tmp16_;
	_tmp17_ = g_thread_new ("noise", ___lambda5__gthread_func, block1_data_ref (_data1_));
	t_noise = _tmp17_;
	_tmp18_ = g_thread_new ("emitter", ___lambda6__gthread_func, block1_data_ref (_data1_));
	t_emitter = _tmp18_;
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 3000, ___lambda7__gsource_func, block1_data_ref (_data1_), block1_data_unref);
	g_main_loop_run (_data1_->ml);
	_tmp19_ = _g_thread_ref0 (t_emitter);
	g_thread_join (_tmp19_);
	_tmp20_ = _g_thread_ref0 (t_noise);
	g_thread_join (_tmp20_);
	g_assert_cmpuint (_data1_->add_count, ==, (guint) 1);
	g_assert_cmpuint (_data1_->change_count, ==, _data1_->num_changes);
	_g_thread_unref0 (t_emitter);
	_g_thread_unref0 (t_noise);
	_g_object_unref0 (gudev);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}


static void _t_testbed_empty_gtest_func (void) {
	t_testbed_empty ();
}


static void _t_testbed_add_device_gtest_func (void) {
	t_testbed_add_device ();
}


static void _t_testbed_gudev_query_list_gtest_func (void) {
	t_testbed_gudev_query_list ();
}


static void _t_usbfs_ioctl_static_gtest_func (void) {
	t_usbfs_ioctl_static ();
}


static void _t_usbfs_ioctl_tree_gtest_func (void) {
	t_usbfs_ioctl_tree ();
}


static void _t_usbfs_ioctl_tree_with_default_device_gtest_func (void) {
	t_usbfs_ioctl_tree_with_default_device ();
}


static void _t_usbfs_ioctl_tree_override_default_device_gtest_func (void) {
	t_usbfs_ioctl_tree_override_default_device ();
}


static void _t_usbfs_ioctl_tree_xz_gtest_func (void) {
	t_usbfs_ioctl_tree_xz ();
}


static void _t_tty_stty_gtest_func (void) {
	t_tty_stty ();
}


static void _t_tty_data_gtest_func (void) {
	t_tty_data ();
}


static void _t_detects_running_in_testbed_gtest_func (void) {
	t_detects_running_in_testbed ();
}


static void _t_detects_not_running_in_testbed_gtest_func (void) {
	t_detects_not_running_in_testbed ();
}


static void _t_mt_parallel_attr_distinct_gtest_func (void) {
	t_mt_parallel_attr_distinct ();
}


static void _t_mt_uevent_gtest_func (void) {
	t_mt_uevent ();
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	gint _tmp12_ = 0;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				gchar** _tmp3_ = NULL;
				gint _tmp3__length1 = 0;
				gchar** _tmp4_ = NULL;
				gint _tmp4__length1 = 0;
				gint _tmp5_ = 0;
				const gchar* _tmp6_ = NULL;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = args;
				_tmp3__length1 = args_length1;
				if (!(_tmp2_ < _tmp3__length1)) {
					break;
				}
				_tmp4_ = args;
				_tmp4__length1 = args_length1;
				_tmp5_ = i;
				_tmp6_ = _tmp4_[_tmp5_];
				if (g_strcmp0 (_tmp6_, "--test-outside-testbed") == 0) {
					gchar** _tmp7_ = NULL;
					gint _tmp7__length1 = 0;
					gint _tmp8_ = 0;
					const gchar* _tmp9_ = NULL;
					gint _tmp10_ = 0;
					gint _tmp11_ = 0;
					_tmp7_ = args;
					_tmp7__length1 = args_length1;
					_tmp8_ = i;
					_tmp9_ = _tmp7_[_tmp8_ + 1];
					_tmp10_ = atoi (_tmp9_);
					_tmp11_ = is_test_inside_testbed (_tmp10_);
					result = _tmp11_;
					return result;
				}
			}
		}
	}
	g_test_init (&args_length1, &args, NULL);
	g_test_add_func ("/umockdev-testbed-vala/empty", _t_testbed_empty_gtest_func);
	g_test_add_func ("/umockdev-testbed-vala/add_devicev", _t_testbed_add_device_gtest_func);
	g_test_add_func ("/umockdev-testbed-vala/gudev-query-list", _t_testbed_gudev_query_list_gtest_func);
	g_test_add_func ("/umockdev-testbed-vala/usbfs_ioctl_static", _t_usbfs_ioctl_static_gtest_func);
	g_test_add_func ("/umockdev-testbed-vala/usbfs_ioctl_tree", _t_usbfs_ioctl_tree_gtest_func);
	g_test_add_func ("/umockdev-testbed-vala/usbfs_ioctl_tree_with_default_device", _t_usbfs_ioctl_tree_with_default_device_gtest_func);
	g_test_add_func ("/umockdev-testbed-vala/usbfs_ioctl_tree_override_default_device", _t_usbfs_ioctl_tree_override_default_device_gtest_func);
	g_test_add_func ("/umockdev-testbed-vala/usbfs_ioctl_tree_xz", _t_usbfs_ioctl_tree_xz_gtest_func);
	g_test_add_func ("/umockdev-testbed-vala/tty_stty", _t_tty_stty_gtest_func);
	g_test_add_func ("/umockdev-testbed-vala/tty_data", _t_tty_data_gtest_func);
	g_test_add_func ("/umockdev-testbed-vala/detects_running_in_testbed", _t_detects_running_in_testbed_gtest_func);
	g_test_add_func ("/umockdev-testbed-vala/detects_running_outside_testbed", _t_detects_not_running_in_testbed_gtest_func);
	g_test_add_func ("/umockdev-testbed-vala/mt_parallel_attr_distinct", _t_mt_parallel_attr_distinct_gtest_func);
	g_test_add_func ("/umockdev-testbed-vala/mt_uevent", _t_mt_uevent_gtest_func);
	_tmp12_ = g_test_run ();
	result = _tmp12_;
	return result;
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
	return _vala_main (argv, argc);
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



