/* gstreamer-interfaces-0.10.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "Gst", lower_case_cprefix = "gst_")]
namespace Gst {
	[CCode (cheader_filename = "gst/interfaces/colorbalance.h")]
	public class ColorBalanceChannel : GLib.Object {
		public weak string label;
		public int max_value;
		public int min_value;
		[CCode (has_construct_function = false)]
		protected ColorBalanceChannel ();
		public virtual signal void value_changed (int value);
	}
	[CCode (cheader_filename = "gst/interfaces/mixer.h")]
	public class MixerOptions : Gst.MixerTrack {
		[CCode (has_construct_function = false)]
		protected MixerOptions ();
		public unowned GLib.List<string> get_values ();
		public static void list_changed (Gst.Mixer mixer, Gst.MixerOptions opts);
	}
	[CCode (cheader_filename = "gst/interfaces/mixer.h")]
	public class MixerTrack : GLib.Object {
		[CCode (has_construct_function = false)]
		protected MixerTrack ();
		[NoAccessorMethod]
		public uint flags { get; }
		[NoAccessorMethod]
		public uint index { get; construct; }
		[NoAccessorMethod]
		public string label { owned get; }
		[NoAccessorMethod]
		public int max_volume { get; }
		[NoAccessorMethod]
		public int min_volume { get; }
		[NoAccessorMethod]
		public int num_channels { get; }
		[NoAccessorMethod]
		public string untranslated_label { owned get; construct; }
	}
	[CCode (cheader_filename = "gst/interfaces/tuner.h")]
	public class TunerChannel : GLib.Object {
		public Gst.TunerChannelFlags flags;
		public float freq_multiplicator;
		public weak string label;
		public ulong max_frequency;
		public int max_signal;
		public ulong min_frequency;
		public int min_signal;
		[CCode (has_construct_function = false)]
		protected TunerChannel ();
		public static void changed (Gst.Tuner tuner, Gst.TunerChannel channel);
		public virtual signal void frequency_changed (ulong frequency);
		public virtual signal void signal_changed (int @signal);
	}
	[CCode (cheader_filename = "gst/interfaces/tuner.h")]
	public class TunerNorm : GLib.Object {
		public Gst.Value framerate;
		public weak string label;
		[CCode (has_construct_function = false)]
		protected TunerNorm ();
		public static void changed (Gst.Tuner tuner, Gst.TunerNorm norm);
	}
	[CCode (cheader_filename = "gst/interfaces/colorbalance.h")]
	public interface ColorBalance : Gst.ImplementsInterface, Gst.Element {
		public Gst.ColorBalanceType get_balance_type ();
		public abstract int get_value (Gst.ColorBalanceChannel channel);
		public abstract unowned GLib.List<Gst.ColorBalanceChannel> list_channels ();
		public abstract void set_value (Gst.ColorBalanceChannel channel, int value);
		[HasEmitter]
		public signal void value_changed (Gst.ColorBalanceChannel channel, int value);
	}
	[CCode (cheader_filename = "gst/interfaces/mixer.h")]
	public interface Mixer : Gst.ImplementsInterface, Gst.Element {
		public abstract Gst.MixerFlags get_mixer_flags ();
		public Gst.MixerType get_mixer_type ();
		public abstract unowned string get_option (Gst.MixerOptions opts);
		public abstract void get_volume (Gst.MixerTrack track, int volumes);
		public abstract unowned GLib.List<Gst.MixerTrack> list_tracks ();
		public static Gst.MixerMessageType message_get_type (Gst.Message message);
		public static void message_parse_mute_toggled (Gst.Message message, out unowned Gst.MixerTrack track, bool mute);
		public static void message_parse_option_changed (Gst.Message message, out unowned Gst.MixerOptions options, string value);
		public static void message_parse_options_list_changed (Gst.Message message, out unowned Gst.MixerOptions options);
		public static void message_parse_record_toggled (Gst.Message message, out unowned Gst.MixerTrack track, bool record);
		public static void message_parse_volume_changed (Gst.Message message, out unowned Gst.MixerTrack track, int volumes, int num_channels);
		public void mixer_changed ();
		public abstract void set_mute (Gst.MixerTrack track, bool mute);
		public abstract void set_option (Gst.MixerOptions opts, string value);
		public abstract void set_record (Gst.MixerTrack track, bool record);
		public abstract void set_volume (Gst.MixerTrack track, int volumes);
	}
	[CCode (cheader_filename = "gst/interfaces/navigation.h")]
	public interface Navigation : Gst.Element {
		public static Gst.NavigationEventType event_get_type (Gst.Event event);
		public static bool event_parse_command (Gst.Event event, Gst.NavigationCommand command);
		public static bool event_parse_key_event (Gst.Event event, string key);
		public static bool event_parse_mouse_button_event (Gst.Event event, int button, double x, double y);
		public static bool event_parse_mouse_move_event (Gst.Event event, double x, double y);
		public static Gst.NavigationMessageType message_get_type (Gst.Message message);
		public static unowned Gst.Message message_new_angles_changed (Gst.Object src, uint cur_angle, uint n_angles);
		public static unowned Gst.Message message_new_commands_changed (Gst.Object src);
		public static unowned Gst.Message message_new_mouse_over (Gst.Object src, bool active);
		public static bool message_parse_angles_changed (Gst.Message message, uint cur_angle, uint n_angles);
		public static bool message_parse_mouse_over (Gst.Message message, bool active);
		public static Gst.NavigationQueryType query_get_type (Gst.Query query);
		public static unowned Gst.Query query_new_angles ();
		public static unowned Gst.Query query_new_commands ();
		public static bool query_parse_angles (Gst.Query query, uint cur_angle, uint n_angles);
		public static bool query_parse_commands_length (Gst.Query query, uint n_cmds);
		public static bool query_parse_commands_nth (Gst.Query query, uint nth, Gst.NavigationCommand cmd);
		public static void query_set_angles (Gst.Query query, uint cur_angle, uint n_angles);
		public static void query_set_commands (Gst.Query query, int n_cmds);
		public static void query_set_commandsv (Gst.Query query, int n_cmds, Gst.NavigationCommand cmds);
		public void send_command (Gst.NavigationCommand command);
		public abstract void send_event (Gst.Structure structure);
		public void send_key_event (string event, string key);
		public void send_mouse_event (string event, int button, double x, double y);
	}
	[CCode (cheader_filename = "gst/interfaces/propertyprobe.h")]
	public interface PropertyProbe {
		public abstract unowned GLib.List<string> get_properties ();
		public unowned GLib.ParamSpec get_property (string name);
		public abstract unowned GLib.ValueArray get_values (GLib.ParamSpec pspec);
		public unowned GLib.ValueArray get_values_name (string name);
		public abstract bool needs_probe (GLib.ParamSpec pspec);
		public bool needs_probe_name (string name);
		public unowned GLib.ValueArray probe_and_get_values (GLib.ParamSpec pspec);
		public unowned GLib.ValueArray probe_and_get_values_name (string name);
		public abstract void probe_property (GLib.ParamSpec pspec);
		public void probe_property_name (string name);
		public signal void probe_needed (void* pspec);
	}
	[CCode (cheader_filename = "gst/gst.h")]
	public interface StreamVolume : GLib.Object {
		public static double convert_volume (Gst.StreamVolumeFormat from, Gst.StreamVolumeFormat to, double val);
		public bool get_mute ();
		public double get_volume (Gst.StreamVolumeFormat format);
		public void set_mute (bool mute);
		public void set_volume (Gst.StreamVolumeFormat format, double val);
		public bool mute { get; set; }
		public double volume { get; set; }
	}
	[CCode (cheader_filename = "gst/interfaces/tuner.h")]
	public interface Tuner : Gst.ImplementsInterface, Gst.Element {
		public unowned Gst.TunerChannel find_channel_by_name (string channel);
		public unowned Gst.TunerNorm find_norm_by_name (string norm);
		public abstract unowned Gst.TunerChannel get_channel ();
		public abstract ulong get_frequency (Gst.TunerChannel channel);
		public abstract unowned Gst.TunerNorm get_norm ();
		public abstract unowned GLib.List<Gst.TunerChannel> list_channels ();
		public abstract unowned GLib.List<Gst.TunerNorm> list_norms ();
		public abstract void set_channel (Gst.TunerChannel channel);
		public abstract void set_frequency (Gst.TunerChannel channel, ulong frequency);
		public abstract void set_norm (Gst.TunerNorm norm);
		public abstract int signal_strength (Gst.TunerChannel channel);
		public signal void channel_changed (Gst.TunerChannel channel);
		[HasEmitter]
		public signal void frequency_changed (Gst.TunerChannel channel, ulong frequency);
		public signal void norm_changed (Gst.TunerNorm norm);
		[HasEmitter]
		public signal void signal_changed (Gst.TunerChannel channel, int @signal);
	}
	[CCode (cheader_filename = "gst/interfaces/videoorientation.h")]
	public interface VideoOrientation : Gst.ImplementsInterface, Gst.Element {
		public abstract bool get_hcenter (int center);
		public abstract bool get_hflip (bool flip);
		public abstract bool get_vcenter (int center);
		public abstract bool get_vflip (bool flip);
		public abstract bool set_hcenter (int center);
		public abstract bool set_hflip (bool flip);
		public abstract bool set_vcenter (int center);
		public abstract bool set_vflip (bool flip);
	}
	[CCode (cheader_filename = "gst/interfaces/xoverlay.h", lower_case_csuffix = "x_overlay")]
	public interface XOverlay : Gst.ImplementsInterface, Gst.Element {
		[CCode (cname = "gst_x_overlay_expose")]
		public abstract void expose ();
		[CCode (cname = "gst_x_overlay_got_window_handle")]
		public void got_window_handle (uint handle);
		[CCode (cname = "gst_x_overlay_got_xwindow_id")]
		public void got_xwindow_id (ulong xwindow_id);
		[CCode (cname = "gst_x_overlay_handle_events")]
		public abstract void handle_events (bool handle_events);
		[CCode (cname = "gst_x_overlay_prepare_xwindow_id")]
		public void prepare_xwindow_id ();
		[CCode (cname = "gst_x_overlay_set_render_rectangle")]
		public abstract void set_render_rectangle (int x, int y, int width, int height);
		[CCode (cname = "gst_x_overlay_set_window_handle")]
		public abstract void set_window_handle (uint handle);
		[CCode (cname = "gst_x_overlay_set_xwindow_id")]
		public abstract void set_xwindow_id (ulong xwindow_id);
	}
	[CCode (cheader_filename = "gst/interfaces/colorbalance.h", cprefix = "GST_COLOR_BALANCE_")]
	public enum ColorBalanceType {
		HARDWARE,
		SOFTWARE
	}
	[CCode (cheader_filename = "gst/interfaces/mixer.h", cprefix = "GST_MIXER_FLAG_")]
	[Flags]
	public enum MixerFlags {
		NONE,
		AUTO_NOTIFICATIONS,
		HAS_WHITELIST,
		GROUPING
	}
	[CCode (cheader_filename = "gst/interfaces/mixer.h", cprefix = "GST_MIXER_MESSAGE_")]
	public enum MixerMessageType {
		INVALID,
		MUTE_TOGGLED,
		RECORD_TOGGLED,
		VOLUME_CHANGED,
		OPTION_CHANGED,
		OPTIONS_LIST_CHANGED,
		MIXER_CHANGED
	}
	[CCode (cheader_filename = "gst/interfaces/mixertrack.h", cprefix = "GST_MIXER_TRACK_")]
	[Flags]
	public enum MixerTrackFlags {
		INPUT,
		OUTPUT,
		MUTE,
		RECORD,
		MASTER,
		SOFTWARE,
		NO_RECORD,
		NO_MUTE,
		WHITELIST,
		READONLY,
		WRITEONLY
	}
	[CCode (cheader_filename = "gst/interfaces/mixer.h", cprefix = "GST_MIXER_")]
	public enum MixerType {
		HARDWARE,
		SOFTWARE
	}
	[CCode (cheader_filename = "gst/gst.h", cprefix = "GST_NAVIGATION_COMMAND_")]
	public enum NavigationCommand {
		INVALID,
		MENU1,
		MENU2,
		MENU3,
		MENU4,
		MENU5,
		MENU6,
		MENU7,
		LEFT,
		RIGHT,
		UP,
		DOWN,
		ACTIVATE,
		PREV_ANGLE,
		NEXT_ANGLE
	}
	[CCode (cheader_filename = "gst/gst.h", cprefix = "GST_NAVIGATION_EVENT_")]
	public enum NavigationEventType {
		INVALID,
		KEY_PRESS,
		KEY_RELEASE,
		MOUSE_BUTTON_PRESS,
		MOUSE_BUTTON_RELEASE,
		MOUSE_MOVE,
		COMMAND
	}
	[CCode (cheader_filename = "gst/gst.h", cprefix = "GST_NAVIGATION_MESSAGE_")]
	public enum NavigationMessageType {
		INVALID,
		MOUSE_OVER,
		COMMANDS_CHANGED,
		ANGLES_CHANGED
	}
	[CCode (cheader_filename = "gst/gst.h", cprefix = "GST_NAVIGATION_QUERY_")]
	public enum NavigationQueryType {
		INVALID,
		COMMANDS,
		ANGLES
	}
	[CCode (cheader_filename = "gst/gst.h", cprefix = "GST_STREAM_VOLUME_FORMAT_")]
	public enum StreamVolumeFormat {
		LINEAR,
		CUBIC,
		DB
	}
	[CCode (cheader_filename = "gst/interfaces/tuner.h", cprefix = "GST_TUNER_CHANNEL_")]
	[Flags]
	public enum TunerChannelFlags {
		INPUT,
		OUTPUT,
		FREQUENCY,
		AUDIO
	}
}
