/* valascanner.c generated by valac, the Vala compiler
 * generated from valascanner.vala, do not modify */

/* valascanner.vala
 *
 * Copyright (C) 2008-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 * 	Jukka-Pekka Iivonen <jp0409@jippii.fi>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>


#define VALA_TYPE_SCANNER (vala_scanner_get_type ())
#define VALA_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SCANNER, ValaScanner))
#define VALA_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SCANNER, ValaScannerClass))
#define VALA_IS_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SCANNER))
#define VALA_IS_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SCANNER))
#define VALA_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SCANNER, ValaScannerClass))

typedef struct _ValaScanner ValaScanner;
typedef struct _ValaScannerClass ValaScannerClass;
typedef struct _ValaScannerPrivate ValaScannerPrivate;

#define VALA_TYPE_SOURCE_FILE (vala_source_file_get_type ())
#define VALA_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFile))
#define VALA_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))
#define VALA_IS_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_FILE))
#define VALA_IS_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_FILE))
#define VALA_SOURCE_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))

typedef struct _ValaSourceFile ValaSourceFile;
typedef struct _ValaSourceFileClass ValaSourceFileClass;

#define VALA_TYPE_TOKEN_TYPE (vala_token_type_get_type ())

#define VALA_TYPE_COMMENT (vala_comment_get_type ())
#define VALA_COMMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_COMMENT, ValaComment))
#define VALA_COMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_COMMENT, ValaCommentClass))
#define VALA_IS_COMMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_COMMENT))
#define VALA_IS_COMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_COMMENT))
#define VALA_COMMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_COMMENT, ValaCommentClass))

typedef struct _ValaComment ValaComment;
typedef struct _ValaCommentClass ValaCommentClass;

#define VALA_SCANNER_TYPE_CONDITIONAL (vala_scanner_conditional_get_type ())
typedef struct _ValaScannerConditional ValaScannerConditional;

#define VALA_SCANNER_TYPE_STATE (vala_scanner_state_get_type ())
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_comment_unref0(var) ((var == NULL) ? NULL : (var = (vala_comment_unref (var), NULL)))

#define VALA_TYPE_SOURCE_LOCATION (vala_source_location_get_type ())
typedef struct _ValaSourceLocation ValaSourceLocation;

#define VALA_TYPE_SOURCE_REFERENCE (vala_source_reference_get_type ())
#define VALA_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReference))
#define VALA_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))
#define VALA_IS_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_IS_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_SOURCE_REFERENCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))

typedef struct _ValaSourceReference ValaSourceReference;
typedef struct _ValaSourceReferenceClass ValaSourceReferenceClass;
#define _vala_source_reference_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_reference_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define VALA_TYPE_CODE_CONTEXT (vala_code_context_get_type ())
#define VALA_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContext))
#define VALA_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))
#define VALA_IS_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_CONTEXT))
#define VALA_IS_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_CONTEXT))
#define VALA_CODE_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))

typedef struct _ValaCodeContext ValaCodeContext;
typedef struct _ValaCodeContextClass ValaCodeContextClass;
typedef struct _ValaParamSpecScanner ValaParamSpecScanner;

struct _ValaScanner {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaScannerPrivate * priv;
};

struct _ValaScannerClass {
	GTypeClass parent_class;
	void (*finalize) (ValaScanner *self);
};

typedef enum  {
	VALA_TOKEN_TYPE_NONE,
	VALA_TOKEN_TYPE_ABSTRACT,
	VALA_TOKEN_TYPE_AS,
	VALA_TOKEN_TYPE_ASSIGN,
	VALA_TOKEN_TYPE_ASSIGN_ADD,
	VALA_TOKEN_TYPE_ASSIGN_BITWISE_AND,
	VALA_TOKEN_TYPE_ASSIGN_BITWISE_OR,
	VALA_TOKEN_TYPE_ASSIGN_BITWISE_XOR,
	VALA_TOKEN_TYPE_ASSIGN_DIV,
	VALA_TOKEN_TYPE_ASSIGN_MUL,
	VALA_TOKEN_TYPE_ASSIGN_PERCENT,
	VALA_TOKEN_TYPE_ASSIGN_SHIFT_LEFT,
	VALA_TOKEN_TYPE_ASSIGN_SUB,
	VALA_TOKEN_TYPE_ASYNC,
	VALA_TOKEN_TYPE_BASE,
	VALA_TOKEN_TYPE_BITWISE_AND,
	VALA_TOKEN_TYPE_BITWISE_OR,
	VALA_TOKEN_TYPE_BREAK,
	VALA_TOKEN_TYPE_CARRET,
	VALA_TOKEN_TYPE_CASE,
	VALA_TOKEN_TYPE_CATCH,
	VALA_TOKEN_TYPE_CHARACTER_LITERAL,
	VALA_TOKEN_TYPE_CLASS,
	VALA_TOKEN_TYPE_CLOSE_BRACE,
	VALA_TOKEN_TYPE_CLOSE_BRACKET,
	VALA_TOKEN_TYPE_CLOSE_PARENS,
	VALA_TOKEN_TYPE_CLOSE_REGEX_LITERAL,
	VALA_TOKEN_TYPE_CLOSE_TEMPLATE,
	VALA_TOKEN_TYPE_COLON,
	VALA_TOKEN_TYPE_COMMA,
	VALA_TOKEN_TYPE_CONST,
	VALA_TOKEN_TYPE_CONSTRUCT,
	VALA_TOKEN_TYPE_CONTINUE,
	VALA_TOKEN_TYPE_DEFAULT,
	VALA_TOKEN_TYPE_DELEGATE,
	VALA_TOKEN_TYPE_DELETE,
	VALA_TOKEN_TYPE_DIV,
	VALA_TOKEN_TYPE_DO,
	VALA_TOKEN_TYPE_DOUBLE_COLON,
	VALA_TOKEN_TYPE_DOT,
	VALA_TOKEN_TYPE_DYNAMIC,
	VALA_TOKEN_TYPE_ELLIPSIS,
	VALA_TOKEN_TYPE_ELSE,
	VALA_TOKEN_TYPE_ENUM,
	VALA_TOKEN_TYPE_ENSURES,
	VALA_TOKEN_TYPE_ERRORDOMAIN,
	VALA_TOKEN_TYPE_EOF,
	VALA_TOKEN_TYPE_EXTERN,
	VALA_TOKEN_TYPE_FALSE,
	VALA_TOKEN_TYPE_FINALLY,
	VALA_TOKEN_TYPE_FOR,
	VALA_TOKEN_TYPE_FOREACH,
	VALA_TOKEN_TYPE_GET,
	VALA_TOKEN_TYPE_HASH,
	VALA_TOKEN_TYPE_IDENTIFIER,
	VALA_TOKEN_TYPE_IF,
	VALA_TOKEN_TYPE_IN,
	VALA_TOKEN_TYPE_INLINE,
	VALA_TOKEN_TYPE_INTEGER_LITERAL,
	VALA_TOKEN_TYPE_INTERFACE,
	VALA_TOKEN_TYPE_INTERNAL,
	VALA_TOKEN_TYPE_INTERR,
	VALA_TOKEN_TYPE_IS,
	VALA_TOKEN_TYPE_LAMBDA,
	VALA_TOKEN_TYPE_LOCK,
	VALA_TOKEN_TYPE_MINUS,
	VALA_TOKEN_TYPE_NAMESPACE,
	VALA_TOKEN_TYPE_NEW,
	VALA_TOKEN_TYPE_NULL,
	VALA_TOKEN_TYPE_OUT,
	VALA_TOKEN_TYPE_OP_AND,
	VALA_TOKEN_TYPE_OP_COALESCING,
	VALA_TOKEN_TYPE_OP_DEC,
	VALA_TOKEN_TYPE_OP_EQ,
	VALA_TOKEN_TYPE_OP_GE,
	VALA_TOKEN_TYPE_OP_GT,
	VALA_TOKEN_TYPE_OP_INC,
	VALA_TOKEN_TYPE_OP_LE,
	VALA_TOKEN_TYPE_OP_LT,
	VALA_TOKEN_TYPE_OP_NE,
	VALA_TOKEN_TYPE_OP_NEG,
	VALA_TOKEN_TYPE_OP_OR,
	VALA_TOKEN_TYPE_OP_PTR,
	VALA_TOKEN_TYPE_OP_SHIFT_LEFT,
	VALA_TOKEN_TYPE_OPEN_BRACE,
	VALA_TOKEN_TYPE_OPEN_BRACKET,
	VALA_TOKEN_TYPE_OPEN_PARENS,
	VALA_TOKEN_TYPE_OPEN_REGEX_LITERAL,
	VALA_TOKEN_TYPE_OPEN_TEMPLATE,
	VALA_TOKEN_TYPE_OVERRIDE,
	VALA_TOKEN_TYPE_OWNED,
	VALA_TOKEN_TYPE_PARAMS,
	VALA_TOKEN_TYPE_PERCENT,
	VALA_TOKEN_TYPE_PLUS,
	VALA_TOKEN_TYPE_PRIVATE,
	VALA_TOKEN_TYPE_PROTECTED,
	VALA_TOKEN_TYPE_PUBLIC,
	VALA_TOKEN_TYPE_REAL_LITERAL,
	VALA_TOKEN_TYPE_REF,
	VALA_TOKEN_TYPE_REGEX_LITERAL,
	VALA_TOKEN_TYPE_REQUIRES,
	VALA_TOKEN_TYPE_RETURN,
	VALA_TOKEN_TYPE_SEALED,
	VALA_TOKEN_TYPE_SEMICOLON,
	VALA_TOKEN_TYPE_SET,
	VALA_TOKEN_TYPE_SIGNAL,
	VALA_TOKEN_TYPE_SIZEOF,
	VALA_TOKEN_TYPE_STAR,
	VALA_TOKEN_TYPE_STATIC,
	VALA_TOKEN_TYPE_STRING_LITERAL,
	VALA_TOKEN_TYPE_STRUCT,
	VALA_TOKEN_TYPE_SWITCH,
	VALA_TOKEN_TYPE_TEMPLATE_STRING_LITERAL,
	VALA_TOKEN_TYPE_THIS,
	VALA_TOKEN_TYPE_THROW,
	VALA_TOKEN_TYPE_THROWS,
	VALA_TOKEN_TYPE_TILDE,
	VALA_TOKEN_TYPE_TRUE,
	VALA_TOKEN_TYPE_TRY,
	VALA_TOKEN_TYPE_TYPEOF,
	VALA_TOKEN_TYPE_UNOWNED,
	VALA_TOKEN_TYPE_USING,
	VALA_TOKEN_TYPE_VAR,
	VALA_TOKEN_TYPE_VERBATIM_STRING_LITERAL,
	VALA_TOKEN_TYPE_VIRTUAL,
	VALA_TOKEN_TYPE_VOID,
	VALA_TOKEN_TYPE_VOLATILE,
	VALA_TOKEN_TYPE_WEAK,
	VALA_TOKEN_TYPE_WHILE,
	VALA_TOKEN_TYPE_YIELD
} ValaTokenType;

struct _ValaScannerConditional {
	gboolean matched;
	gboolean else_found;
	gboolean skip_section;
};

typedef enum  {
	VALA_SCANNER_STATE_PARENS,
	VALA_SCANNER_STATE_BRACE,
	VALA_SCANNER_STATE_BRACKET,
	VALA_SCANNER_STATE_TEMPLATE,
	VALA_SCANNER_STATE_TEMPLATE_PART,
	VALA_SCANNER_STATE_REGEX_LITERAL
} ValaScannerState;

struct _ValaScannerPrivate {
	ValaSourceFile* _source_file;
	ValaTokenType previous;
	gchar* current;
	gchar* end;
	gint line;
	gint column;
	ValaComment* _comment;
	ValaScannerConditional* conditional_stack;
	gint conditional_stack_length1;
	gint _conditional_stack_size_;
	ValaScannerState* state_stack;
	gint state_stack_length1;
	gint _state_stack_size_;
};

struct _ValaSourceLocation {
	gchar* pos;
	gint line;
	gint column;
};

struct _ValaParamSpecScanner {
	GParamSpec parent_instance;
};


static gpointer vala_scanner_parent_class = NULL;

gpointer vala_scanner_ref (gpointer instance);
void vala_scanner_unref (gpointer instance);
GParamSpec* vala_param_spec_scanner (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_scanner (GValue* value, gpointer v_object);
void vala_value_take_scanner (GValue* value, gpointer v_object);
gpointer vala_value_get_scanner (const GValue* value);
GType vala_scanner_get_type (void) G_GNUC_CONST;
gpointer vala_source_file_ref (gpointer instance);
void vala_source_file_unref (gpointer instance);
GParamSpec* vala_param_spec_source_file (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_file (GValue* value, gpointer v_object);
void vala_value_take_source_file (GValue* value, gpointer v_object);
gpointer vala_value_get_source_file (const GValue* value);
GType vala_source_file_get_type (void) G_GNUC_CONST;
GType vala_token_type_get_type (void) G_GNUC_CONST;
gpointer vala_comment_ref (gpointer instance);
void vala_comment_unref (gpointer instance);
GParamSpec* vala_param_spec_comment (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_comment (GValue* value, gpointer v_object);
void vala_value_take_comment (GValue* value, gpointer v_object);
gpointer vala_value_get_comment (const GValue* value);
GType vala_comment_get_type (void) G_GNUC_CONST;
static GType vala_scanner_conditional_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static ValaScannerConditional* vala_scanner_conditional_dup (const ValaScannerConditional* self);
static void vala_scanner_conditional_free (ValaScannerConditional* self);
static GType vala_scanner_state_get_type (void) G_GNUC_UNUSED;
#define VALA_SCANNER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_SCANNER, ValaScannerPrivate))
enum  {
	VALA_SCANNER_DUMMY_PROPERTY
};
ValaScanner* vala_scanner_new (ValaSourceFile* source_file);
ValaScanner* vala_scanner_construct (GType object_type, ValaSourceFile* source_file);
static void vala_scanner_set_source_file (ValaScanner* self, ValaSourceFile* value);
gchar* vala_source_file_get_mapped_contents (ValaSourceFile* self);
gsize vala_source_file_get_mapped_length (ValaSourceFile* self);
GType vala_source_location_get_type (void) G_GNUC_CONST;
ValaSourceLocation* vala_source_location_dup (const ValaSourceLocation* self);
void vala_source_location_free (ValaSourceLocation* self);
void vala_scanner_seek (ValaScanner* self, ValaSourceLocation* location);
static gboolean vala_scanner_in_template (ValaScanner* self);
static gboolean vala_scanner_in_template_part (ValaScanner* self);
static gboolean vala_scanner_in_regex_literal (ValaScanner* self);
static gboolean vala_scanner_is_ident_char (ValaScanner* self, gchar c);
gpointer vala_source_reference_ref (gpointer instance);
void vala_source_reference_unref (gpointer instance);
GParamSpec* vala_param_spec_source_reference (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_reference (GValue* value, gpointer v_object);
void vala_value_take_source_reference (GValue* value, gpointer v_object);
gpointer vala_value_get_source_reference (const GValue* value);
GType vala_source_reference_get_type (void) G_GNUC_CONST;
static ValaSourceReference* vala_scanner_get_source_reference (ValaScanner* self, gint offset, gint length);
ValaSourceFile* vala_scanner_get_source_file (ValaScanner* self);
void vala_source_location_init (ValaSourceLocation *self, gchar* _pos, gint _line, gint _column);
ValaSourceReference* vala_source_reference_new (ValaSourceFile* _file, ValaSourceLocation* begin, ValaSourceLocation* end);
ValaSourceReference* vala_source_reference_construct (GType object_type, ValaSourceFile* _file, ValaSourceLocation* begin, ValaSourceLocation* end);
ValaTokenType vala_scanner_read_regex_token (ValaScanner* self, ValaSourceLocation* token_begin, ValaSourceLocation* token_end);
void vala_report_error (ValaSourceReference* source, const gchar* message);
ValaTokenType vala_scanner_read_token (ValaScanner* self, ValaSourceLocation* token_begin, ValaSourceLocation* token_end);
ValaTokenType vala_scanner_get_identifier_or_keyword (gchar* begin, gint len);
static gboolean vala_scanner_matches (gchar* begin, const gchar* keyword);
static ValaTokenType vala_scanner_read_number (ValaScanner* self);
ValaTokenType vala_scanner_read_template_token (ValaScanner* self, ValaSourceLocation* token_begin, ValaSourceLocation* token_end);
static void _vala_array_add13 (ValaScannerState** array, int* length, int* size, ValaScannerState value);
static void _vala_array_add14 (ValaScannerState** array, int* length, int* size, ValaScannerState value);
static void _vala_array_add15 (ValaScannerState** array, int* length, int* size, ValaScannerState value);
static void _vala_array_add16 (ValaScannerState** array, int* length, int* size, ValaScannerState value);
static void vala_scanner_space (ValaScanner* self);
static void _vala_array_add17 (ValaScannerState** array, int* length, int* size, ValaScannerState value);
static void _vala_array_add18 (ValaScannerState** array, int* length, int* size, ValaScannerState value);
static void _vala_array_add19 (ValaScannerState** array, int* length, int* size, ValaScannerState value);
static void _vala_array_add20 (ValaScannerState** array, int* length, int* size, ValaScannerState value);
static void _vala_array_add21 (ValaScannerState** array, int* length, int* size, ValaScannerState value);
static gboolean vala_scanner_pp_whitespace (ValaScanner* self);
static void vala_scanner_pp_space (ValaScanner* self);
static gboolean vala_scanner_comment (ValaScanner* self, gboolean file_comment);
static void vala_scanner_pp_directive (ValaScanner* self);
static void vala_scanner_parse_pp_if (ValaScanner* self);
static void vala_scanner_parse_pp_elif (ValaScanner* self);
static void vala_scanner_parse_pp_else (ValaScanner* self);
static void vala_scanner_parse_pp_endif (ValaScanner* self);
static void vala_scanner_pp_eol (ValaScanner* self);
static gboolean vala_scanner_parse_pp_expression (ValaScanner* self);
static void _vala_array_add22 (ValaScannerConditional** array, int* length, int* size, const ValaScannerConditional* value);
static gboolean vala_scanner_parse_pp_symbol (ValaScanner* self);
gpointer vala_code_context_ref (gpointer instance);
void vala_code_context_unref (gpointer instance);
GParamSpec* vala_param_spec_code_context (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_context (GValue* value, gpointer v_object);
void vala_value_take_code_context (GValue* value, gpointer v_object);
gpointer vala_value_get_code_context (const GValue* value);
GType vala_code_context_get_type (void) G_GNUC_CONST;
ValaCodeContext* vala_source_file_get_context (ValaSourceFile* self);
gboolean vala_code_context_is_defined (ValaCodeContext* self, const gchar* define);
static gboolean vala_scanner_parse_pp_primary_expression (ValaScanner* self);
static gboolean vala_scanner_parse_pp_unary_expression (ValaScanner* self);
static gboolean vala_scanner_parse_pp_equality_expression (ValaScanner* self);
static gboolean vala_scanner_parse_pp_and_expression (ValaScanner* self);
static gboolean vala_scanner_parse_pp_or_expression (ValaScanner* self);
static gboolean vala_scanner_whitespace (ValaScanner* self);
static void vala_scanner_push_comment (ValaScanner* self, const gchar* comment_item, ValaSourceReference* source_reference, gboolean file_comment);
void vala_scanner_parse_file_comments (ValaScanner* self);
void vala_source_file_add_comment (ValaSourceFile* self, ValaComment* comment);
ValaComment* vala_comment_new (const gchar* comment, ValaSourceReference* _source_reference);
ValaComment* vala_comment_construct (GType object_type, const gchar* comment, ValaSourceReference* _source_reference);
ValaComment* vala_scanner_pop_comment (ValaScanner* self);
static void vala_scanner_finalize (ValaScanner* obj);


static GType vala_scanner_state_get_type (void) {
	static volatile gsize vala_scanner_state_type_id__volatile = 0;
	if (g_once_init_enter (&vala_scanner_state_type_id__volatile)) {
		static const GEnumValue values[] = {{VALA_SCANNER_STATE_PARENS, "VALA_SCANNER_STATE_PARENS", "parens"}, {VALA_SCANNER_STATE_BRACE, "VALA_SCANNER_STATE_BRACE", "brace"}, {VALA_SCANNER_STATE_BRACKET, "VALA_SCANNER_STATE_BRACKET", "bracket"}, {VALA_SCANNER_STATE_TEMPLATE, "VALA_SCANNER_STATE_TEMPLATE", "template"}, {VALA_SCANNER_STATE_TEMPLATE_PART, "VALA_SCANNER_STATE_TEMPLATE_PART", "template-part"}, {VALA_SCANNER_STATE_REGEX_LITERAL, "VALA_SCANNER_STATE_REGEX_LITERAL", "regex-literal"}, {0, NULL, NULL}};
		GType vala_scanner_state_type_id;
		vala_scanner_state_type_id = g_enum_register_static ("ValaScannerState", values);
		g_once_init_leave (&vala_scanner_state_type_id__volatile, vala_scanner_state_type_id);
	}
	return vala_scanner_state_type_id__volatile;
}


ValaScanner* vala_scanner_construct (GType object_type, ValaSourceFile* source_file) {
	ValaScanner* self = NULL;
	ValaSourceFile* _tmp0_ = NULL;
	gchar* begin = NULL;
	ValaSourceFile* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	ValaSourceFile* _tmp3_ = NULL;
	gsize _tmp4_ = 0UL;
	g_return_val_if_fail (source_file != NULL, NULL);
	self = (ValaScanner*) g_type_create_instance (object_type);
	_tmp0_ = source_file;
	vala_scanner_set_source_file (self, _tmp0_);
	_tmp1_ = source_file;
	_tmp2_ = vala_source_file_get_mapped_contents (_tmp1_);
	begin = _tmp2_;
	_tmp3_ = source_file;
	_tmp4_ = vala_source_file_get_mapped_length (_tmp3_);
	self->priv->end = begin + _tmp4_;
	self->priv->current = begin;
	self->priv->line = 1;
	self->priv->column = 1;
	return self;
}


ValaScanner* vala_scanner_new (ValaSourceFile* source_file) {
	return vala_scanner_construct (VALA_TYPE_SCANNER, source_file);
}


void vala_scanner_seek (ValaScanner* self, ValaSourceLocation* location) {
	ValaSourceLocation _tmp0_ = {0};
	gchar* _tmp1_ = NULL;
	ValaSourceLocation _tmp2_ = {0};
	gint _tmp3_ = 0;
	ValaSourceLocation _tmp4_ = {0};
	gint _tmp5_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (location != NULL);
	_tmp0_ = *location;
	_tmp1_ = _tmp0_.pos;
	self->priv->current = _tmp1_;
	_tmp2_ = *location;
	_tmp3_ = _tmp2_.line;
	self->priv->line = _tmp3_;
	_tmp4_ = *location;
	_tmp5_ = _tmp4_.column;
	self->priv->column = _tmp5_;
	self->priv->conditional_stack = (g_free (self->priv->conditional_stack), NULL);
	self->priv->conditional_stack = NULL;
	self->priv->conditional_stack_length1 = 0;
	self->priv->_conditional_stack_size_ = self->priv->conditional_stack_length1;
	self->priv->state_stack = (g_free (self->priv->state_stack), NULL);
	self->priv->state_stack = NULL;
	self->priv->state_stack_length1 = 0;
	self->priv->_state_stack_size_ = self->priv->state_stack_length1;
}


static gboolean vala_scanner_in_template (ValaScanner* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ValaScannerState* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gboolean _tmp5_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->state_stack;
	_tmp1__length1 = self->priv->state_stack_length1;
	if (_tmp1__length1 > 0) {
		ValaScannerState* _tmp2_ = NULL;
		gint _tmp2__length1 = 0;
		ValaScannerState* _tmp3_ = NULL;
		gint _tmp3__length1 = 0;
		ValaScannerState _tmp4_ = 0;
		_tmp2_ = self->priv->state_stack;
		_tmp2__length1 = self->priv->state_stack_length1;
		_tmp3_ = self->priv->state_stack;
		_tmp3__length1 = self->priv->state_stack_length1;
		_tmp4_ = _tmp2_[_tmp3__length1 - 1];
		_tmp0_ = _tmp4_ == VALA_SCANNER_STATE_TEMPLATE;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp5_ = _tmp0_;
	result = _tmp5_;
	return result;
}


static gboolean vala_scanner_in_template_part (ValaScanner* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ValaScannerState* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gboolean _tmp5_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->state_stack;
	_tmp1__length1 = self->priv->state_stack_length1;
	if (_tmp1__length1 > 0) {
		ValaScannerState* _tmp2_ = NULL;
		gint _tmp2__length1 = 0;
		ValaScannerState* _tmp3_ = NULL;
		gint _tmp3__length1 = 0;
		ValaScannerState _tmp4_ = 0;
		_tmp2_ = self->priv->state_stack;
		_tmp2__length1 = self->priv->state_stack_length1;
		_tmp3_ = self->priv->state_stack;
		_tmp3__length1 = self->priv->state_stack_length1;
		_tmp4_ = _tmp2_[_tmp3__length1 - 1];
		_tmp0_ = _tmp4_ == VALA_SCANNER_STATE_TEMPLATE_PART;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp5_ = _tmp0_;
	result = _tmp5_;
	return result;
}


static gboolean vala_scanner_in_regex_literal (ValaScanner* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ValaScannerState* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gboolean _tmp5_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->state_stack;
	_tmp1__length1 = self->priv->state_stack_length1;
	if (_tmp1__length1 > 0) {
		ValaScannerState* _tmp2_ = NULL;
		gint _tmp2__length1 = 0;
		ValaScannerState* _tmp3_ = NULL;
		gint _tmp3__length1 = 0;
		ValaScannerState _tmp4_ = 0;
		_tmp2_ = self->priv->state_stack;
		_tmp2__length1 = self->priv->state_stack_length1;
		_tmp3_ = self->priv->state_stack;
		_tmp3__length1 = self->priv->state_stack_length1;
		_tmp4_ = _tmp2_[_tmp3__length1 - 1];
		_tmp0_ = _tmp4_ == VALA_SCANNER_STATE_REGEX_LITERAL;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp5_ = _tmp0_;
	result = _tmp5_;
	return result;
}


static gboolean vala_scanner_is_ident_char (ValaScanner* self, gchar c) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gchar _tmp1_ = '\0';
	gboolean _tmp2_ = FALSE;
	gboolean _tmp4_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = c;
	_tmp2_ = g_ascii_isalnum (_tmp1_);
	if (_tmp2_) {
		_tmp0_ = TRUE;
	} else {
		gchar _tmp3_ = '\0';
		_tmp3_ = c;
		_tmp0_ = _tmp3_ == '_';
	}
	_tmp4_ = _tmp0_;
	result = _tmp4_;
	return result;
}


static ValaSourceReference* vala_scanner_get_source_reference (ValaScanner* self, gint offset, gint length) {
	ValaSourceReference* result = NULL;
	ValaSourceFile* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	ValaSourceLocation _tmp5_ = {0};
	gchar* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	ValaSourceLocation _tmp12_ = {0};
	ValaSourceReference* _tmp13_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_source_file;
	_tmp1_ = self->priv->current;
	_tmp2_ = self->priv->line;
	_tmp3_ = self->priv->column;
	_tmp4_ = offset;
	vala_source_location_init (&_tmp5_, _tmp1_, _tmp2_, _tmp3_ + _tmp4_);
	_tmp6_ = self->priv->current;
	_tmp7_ = length;
	_tmp8_ = self->priv->line;
	_tmp9_ = self->priv->column;
	_tmp10_ = offset;
	_tmp11_ = length;
	vala_source_location_init (&_tmp12_, _tmp6_ + _tmp7_, _tmp8_, (_tmp9_ + _tmp10_) + _tmp11_);
	_tmp13_ = vala_source_reference_new (_tmp0_, &_tmp5_, &_tmp12_);
	result = _tmp13_;
	return result;
}


ValaTokenType vala_scanner_read_regex_token (ValaScanner* self, ValaSourceLocation* token_begin, ValaSourceLocation* token_end) {
	ValaSourceLocation _vala_token_begin = {0};
	ValaSourceLocation _vala_token_end = {0};
	ValaTokenType result = 0;
	ValaTokenType type = 0;
	gchar* begin = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint token_length_in_chars = 0;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gint _tmp130_ = 0;
	gchar* _tmp136_ = NULL;
	gint _tmp137_ = 0;
	gint _tmp138_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->current;
	begin = _tmp0_;
	_tmp1_ = begin;
	_tmp2_ = self->priv->line;
	_tmp3_ = self->priv->column;
	vala_source_location_init (&_vala_token_begin, _tmp1_, _tmp2_, _tmp3_);
	token_length_in_chars = -1;
	_tmp4_ = self->priv->current;
	_tmp5_ = self->priv->end;
	if (_tmp4_ >= _tmp5_) {
		type = VALA_TOKEN_TYPE_EOF;
	} else {
		gchar* _tmp6_ = NULL;
		gchar _tmp7_ = '\0';
		_tmp6_ = self->priv->current;
		_tmp7_ = _tmp6_[0];
		switch (_tmp7_) {
			case '/':
			{
				gchar* _tmp8_ = NULL;
				gint _tmp9_ = 0;
				gboolean fl_i = FALSE;
				gboolean fl_s = FALSE;
				gboolean fl_m = FALSE;
				gboolean fl_x = FALSE;
				type = VALA_TOKEN_TYPE_CLOSE_REGEX_LITERAL;
				_tmp8_ = self->priv->current;
				self->priv->current = _tmp8_ + 1;
				_tmp9_ = self->priv->state_stack_length1;
				self->priv->state_stack_length1 = _tmp9_ - 1;
				fl_i = FALSE;
				fl_s = FALSE;
				fl_m = FALSE;
				fl_x = FALSE;
				while (TRUE) {
					gboolean _tmp10_ = FALSE;
					gboolean _tmp11_ = FALSE;
					gboolean _tmp12_ = FALSE;
					gchar* _tmp13_ = NULL;
					gchar _tmp14_ = '\0';
					gboolean _tmp17_ = FALSE;
					gboolean _tmp20_ = FALSE;
					gboolean _tmp23_ = FALSE;
					gchar* _tmp24_ = NULL;
					gchar _tmp25_ = '\0';
					gchar* _tmp42_ = NULL;
					gint _tmp43_ = 0;
					_tmp13_ = self->priv->current;
					_tmp14_ = _tmp13_[0];
					if (_tmp14_ == 'i') {
						_tmp12_ = TRUE;
					} else {
						gchar* _tmp15_ = NULL;
						gchar _tmp16_ = '\0';
						_tmp15_ = self->priv->current;
						_tmp16_ = _tmp15_[0];
						_tmp12_ = _tmp16_ == 's';
					}
					_tmp17_ = _tmp12_;
					if (_tmp17_) {
						_tmp11_ = TRUE;
					} else {
						gchar* _tmp18_ = NULL;
						gchar _tmp19_ = '\0';
						_tmp18_ = self->priv->current;
						_tmp19_ = _tmp18_[0];
						_tmp11_ = _tmp19_ == 'm';
					}
					_tmp20_ = _tmp11_;
					if (_tmp20_) {
						_tmp10_ = TRUE;
					} else {
						gchar* _tmp21_ = NULL;
						gchar _tmp22_ = '\0';
						_tmp21_ = self->priv->current;
						_tmp22_ = _tmp21_[0];
						_tmp10_ = _tmp22_ == 'x';
					}
					_tmp23_ = _tmp10_;
					if (!_tmp23_) {
						break;
					}
					_tmp24_ = self->priv->current;
					_tmp25_ = _tmp24_[0];
					switch (_tmp25_) {
						case 'i':
						{
							gboolean _tmp26_ = FALSE;
							_tmp26_ = fl_i;
							if (_tmp26_) {
								gint _tmp27_ = 0;
								ValaSourceReference* _tmp28_ = NULL;
								ValaSourceReference* _tmp29_ = NULL;
								_tmp27_ = token_length_in_chars;
								_tmp28_ = vala_scanner_get_source_reference (self, _tmp27_, 0);
								_tmp29_ = _tmp28_;
								vala_report_error (_tmp29_, "modifier 'i' used more than once");
								_vala_source_reference_unref0 (_tmp29_);
							}
							fl_i = TRUE;
							break;
						}
						case 's':
						{
							gboolean _tmp30_ = FALSE;
							_tmp30_ = fl_s;
							if (_tmp30_) {
								gint _tmp31_ = 0;
								ValaSourceReference* _tmp32_ = NULL;
								ValaSourceReference* _tmp33_ = NULL;
								_tmp31_ = token_length_in_chars;
								_tmp32_ = vala_scanner_get_source_reference (self, _tmp31_, 0);
								_tmp33_ = _tmp32_;
								vala_report_error (_tmp33_, "modifier 's' used more than once");
								_vala_source_reference_unref0 (_tmp33_);
							}
							fl_s = TRUE;
							break;
						}
						case 'm':
						{
							gboolean _tmp34_ = FALSE;
							_tmp34_ = fl_m;
							if (_tmp34_) {
								gint _tmp35_ = 0;
								ValaSourceReference* _tmp36_ = NULL;
								ValaSourceReference* _tmp37_ = NULL;
								_tmp35_ = token_length_in_chars;
								_tmp36_ = vala_scanner_get_source_reference (self, _tmp35_, 0);
								_tmp37_ = _tmp36_;
								vala_report_error (_tmp37_, "modifier 'm' used more than once");
								_vala_source_reference_unref0 (_tmp37_);
							}
							fl_m = TRUE;
							break;
						}
						case 'x':
						{
							gboolean _tmp38_ = FALSE;
							_tmp38_ = fl_x;
							if (_tmp38_) {
								gint _tmp39_ = 0;
								ValaSourceReference* _tmp40_ = NULL;
								ValaSourceReference* _tmp41_ = NULL;
								_tmp39_ = token_length_in_chars;
								_tmp40_ = vala_scanner_get_source_reference (self, _tmp39_, 0);
								_tmp41_ = _tmp40_;
								vala_report_error (_tmp41_, "modifier 'x' used more than once");
								_vala_source_reference_unref0 (_tmp41_);
							}
							fl_x = TRUE;
							break;
						}
						default:
						break;
					}
					_tmp42_ = self->priv->current;
					self->priv->current = _tmp42_ + 1;
					_tmp43_ = token_length_in_chars;
					token_length_in_chars = _tmp43_ + 1;
				}
				break;
			}
			default:
			{
				gboolean _tmp117_ = FALSE;
				gchar* _tmp118_ = NULL;
				gchar* _tmp119_ = NULL;
				gboolean _tmp122_ = FALSE;
				type = VALA_TOKEN_TYPE_REGEX_LITERAL;
				token_length_in_chars = 0;
				while (TRUE) {
					gboolean _tmp44_ = FALSE;
					gchar* _tmp45_ = NULL;
					gchar* _tmp46_ = NULL;
					gboolean _tmp49_ = FALSE;
					gchar* _tmp50_ = NULL;
					gchar _tmp51_ = '\0';
					_tmp45_ = self->priv->current;
					_tmp46_ = self->priv->end;
					if (_tmp45_ < _tmp46_) {
						gchar* _tmp47_ = NULL;
						gchar _tmp48_ = '\0';
						_tmp47_ = self->priv->current;
						_tmp48_ = _tmp47_[0];
						_tmp44_ = _tmp48_ != '/';
					} else {
						_tmp44_ = FALSE;
					}
					_tmp49_ = _tmp44_;
					if (!_tmp49_) {
						break;
					}
					_tmp50_ = self->priv->current;
					_tmp51_ = _tmp50_[0];
					if (_tmp51_ == '\\') {
						gchar* _tmp52_ = NULL;
						gint _tmp53_ = 0;
						gchar* _tmp54_ = NULL;
						gchar* _tmp55_ = NULL;
						gchar* _tmp56_ = NULL;
						gchar _tmp57_ = '\0';
						_tmp52_ = self->priv->current;
						self->priv->current = _tmp52_ + 1;
						_tmp53_ = token_length_in_chars;
						token_length_in_chars = _tmp53_ + 1;
						_tmp54_ = self->priv->current;
						_tmp55_ = self->priv->end;
						if (_tmp54_ >= _tmp55_) {
							break;
						}
						_tmp56_ = self->priv->current;
						_tmp57_ = _tmp56_[0];
						switch (_tmp57_) {
							case '\'':
							case '"':
							case '\\':
							case '/':
							case '^':
							case '$':
							case '.':
							case '[':
							case ']':
							case '{':
							case '}':
							case '(':
							case ')':
							case '?':
							case '*':
							case '+':
							case '-':
							case '#':
							case '&':
							case '~':
							case ':':
							case ';':
							case '<':
							case '>':
							case '|':
							case '%':
							case '=':
							case '@':
							case '0':
							case 'b':
							case 'B':
							case 'f':
							case 'n':
							case 'r':
							case 't':
							case 'a':
							case 'A':
							case 'p':
							case 'P':
							case 'e':
							case 'd':
							case 'D':
							case 's':
							case 'S':
							case 'w':
							case 'W':
							case 'G':
							case 'z':
							case 'Z':
							{
								gchar* _tmp58_ = NULL;
								gint _tmp59_ = 0;
								_tmp58_ = self->priv->current;
								self->priv->current = _tmp58_ + 1;
								_tmp59_ = token_length_in_chars;
								token_length_in_chars = _tmp59_ + 1;
								break;
							}
							case 'u':
							{
								gchar* _tmp60_ = NULL;
								gint _tmp61_ = 0;
								gint digit_length = 0;
								gint _tmp77_ = 0;
								_tmp60_ = self->priv->current;
								self->priv->current = _tmp60_ + 1;
								_tmp61_ = token_length_in_chars;
								token_length_in_chars = _tmp61_ + 1;
								{
									gboolean _tmp62_ = FALSE;
									digit_length = 0;
									_tmp62_ = TRUE;
									while (TRUE) {
										gboolean _tmp63_ = FALSE;
										gboolean _tmp65_ = FALSE;
										gboolean _tmp66_ = FALSE;
										gint _tmp67_ = 0;
										gboolean _tmp70_ = FALSE;
										gboolean _tmp74_ = FALSE;
										gchar* _tmp75_ = NULL;
										gint _tmp76_ = 0;
										_tmp63_ = _tmp62_;
										if (!_tmp63_) {
											gint _tmp64_ = 0;
											_tmp64_ = digit_length;
											digit_length = _tmp64_ + 1;
										}
										_tmp62_ = FALSE;
										_tmp67_ = digit_length;
										if (_tmp67_ < 4) {
											gchar* _tmp68_ = NULL;
											gchar* _tmp69_ = NULL;
											_tmp68_ = self->priv->current;
											_tmp69_ = self->priv->end;
											_tmp66_ = _tmp68_ < _tmp69_;
										} else {
											_tmp66_ = FALSE;
										}
										_tmp70_ = _tmp66_;
										if (_tmp70_) {
											gchar* _tmp71_ = NULL;
											gchar _tmp72_ = '\0';
											gboolean _tmp73_ = FALSE;
											_tmp71_ = self->priv->current;
											_tmp72_ = _tmp71_[0];
											_tmp73_ = g_ascii_isxdigit (_tmp72_);
											_tmp65_ = _tmp73_;
										} else {
											_tmp65_ = FALSE;
										}
										_tmp74_ = _tmp65_;
										if (!_tmp74_) {
											break;
										}
										_tmp75_ = self->priv->current;
										self->priv->current = _tmp75_ + 1;
										_tmp76_ = token_length_in_chars;
										token_length_in_chars = _tmp76_ + 1;
									}
								}
								_tmp77_ = digit_length;
								if (_tmp77_ != 4) {
									gint _tmp78_ = 0;
									ValaSourceReference* _tmp79_ = NULL;
									ValaSourceReference* _tmp80_ = NULL;
									_tmp78_ = token_length_in_chars;
									_tmp79_ = vala_scanner_get_source_reference (self, _tmp78_, 0);
									_tmp80_ = _tmp79_;
									vala_report_error (_tmp80_, "\\u requires four hex digits");
									_vala_source_reference_unref0 (_tmp80_);
								}
								break;
							}
							case 'x':
							{
								gchar* _tmp81_ = NULL;
								gint _tmp82_ = 0;
								gint digit_length = 0;
								gint _tmp95_ = 0;
								_tmp81_ = self->priv->current;
								self->priv->current = _tmp81_ + 1;
								_tmp82_ = token_length_in_chars;
								token_length_in_chars = _tmp82_ + 1;
								{
									gboolean _tmp83_ = FALSE;
									digit_length = 0;
									_tmp83_ = TRUE;
									while (TRUE) {
										gboolean _tmp84_ = FALSE;
										gboolean _tmp86_ = FALSE;
										gchar* _tmp87_ = NULL;
										gchar* _tmp88_ = NULL;
										gboolean _tmp92_ = FALSE;
										gchar* _tmp93_ = NULL;
										gint _tmp94_ = 0;
										_tmp84_ = _tmp83_;
										if (!_tmp84_) {
											gint _tmp85_ = 0;
											_tmp85_ = digit_length;
											digit_length = _tmp85_ + 1;
										}
										_tmp83_ = FALSE;
										_tmp87_ = self->priv->current;
										_tmp88_ = self->priv->end;
										if (_tmp87_ < _tmp88_) {
											gchar* _tmp89_ = NULL;
											gchar _tmp90_ = '\0';
											gboolean _tmp91_ = FALSE;
											_tmp89_ = self->priv->current;
											_tmp90_ = _tmp89_[0];
											_tmp91_ = g_ascii_isxdigit (_tmp90_);
											_tmp86_ = _tmp91_;
										} else {
											_tmp86_ = FALSE;
										}
										_tmp92_ = _tmp86_;
										if (!_tmp92_) {
											break;
										}
										_tmp93_ = self->priv->current;
										self->priv->current = _tmp93_ + 1;
										_tmp94_ = token_length_in_chars;
										token_length_in_chars = _tmp94_ + 1;
									}
								}
								_tmp95_ = digit_length;
								if (_tmp95_ < 1) {
									gint _tmp96_ = 0;
									ValaSourceReference* _tmp97_ = NULL;
									ValaSourceReference* _tmp98_ = NULL;
									_tmp96_ = token_length_in_chars;
									_tmp97_ = vala_scanner_get_source_reference (self, _tmp96_, 0);
									_tmp98_ = _tmp97_;
									vala_report_error (_tmp98_, "\\x requires at least one hex digit");
									_vala_source_reference_unref0 (_tmp98_);
								}
								break;
							}
							default:
							{
								gint _tmp99_ = 0;
								ValaSourceReference* _tmp100_ = NULL;
								ValaSourceReference* _tmp101_ = NULL;
								_tmp99_ = token_length_in_chars;
								_tmp100_ = vala_scanner_get_source_reference (self, _tmp99_, 0);
								_tmp101_ = _tmp100_;
								vala_report_error (_tmp101_, "invalid escape sequence");
								_vala_source_reference_unref0 (_tmp101_);
								break;
							}
						}
					} else {
						gchar* _tmp102_ = NULL;
						gchar _tmp103_ = '\0';
						_tmp102_ = self->priv->current;
						_tmp103_ = _tmp102_[0];
						if (_tmp103_ == '\n') {
							break;
						} else {
							gunichar u = 0U;
							gchar* _tmp104_ = NULL;
							gchar* _tmp105_ = NULL;
							gchar* _tmp106_ = NULL;
							gunichar _tmp107_ = 0U;
							gunichar _tmp108_ = 0U;
							_tmp104_ = self->priv->current;
							_tmp105_ = self->priv->end;
							_tmp106_ = self->priv->current;
							_tmp107_ = g_utf8_get_char_validated ((const gchar*) _tmp104_, (gssize) ((glong) (_tmp105_ - _tmp106_)));
							u = _tmp107_;
							_tmp108_ = u;
							if (_tmp108_ != ((gunichar) (-1))) {
								gchar* _tmp109_ = NULL;
								gunichar _tmp110_ = 0U;
								gint _tmp111_ = 0;
								gint _tmp112_ = 0;
								_tmp109_ = self->priv->current;
								_tmp110_ = u;
								_tmp111_ = g_unichar_to_utf8 (_tmp110_, NULL);
								self->priv->current = _tmp109_ + _tmp111_;
								_tmp112_ = token_length_in_chars;
								token_length_in_chars = _tmp112_ + 1;
							} else {
								gchar* _tmp113_ = NULL;
								gint _tmp114_ = 0;
								ValaSourceReference* _tmp115_ = NULL;
								ValaSourceReference* _tmp116_ = NULL;
								_tmp113_ = self->priv->current;
								self->priv->current = _tmp113_ + 1;
								_tmp114_ = token_length_in_chars;
								_tmp115_ = vala_scanner_get_source_reference (self, _tmp114_, 0);
								_tmp116_ = _tmp115_;
								vala_report_error (_tmp116_, "invalid UTF-8 character");
								_vala_source_reference_unref0 (_tmp116_);
							}
						}
					}
				}
				_tmp118_ = self->priv->current;
				_tmp119_ = self->priv->end;
				if (_tmp118_ >= _tmp119_) {
					_tmp117_ = TRUE;
				} else {
					gchar* _tmp120_ = NULL;
					gchar _tmp121_ = '\0';
					_tmp120_ = self->priv->current;
					_tmp121_ = _tmp120_[0];
					_tmp117_ = _tmp121_ == '\n';
				}
				_tmp122_ = _tmp117_;
				if (_tmp122_) {
					gint _tmp123_ = 0;
					ValaSourceReference* _tmp124_ = NULL;
					ValaSourceReference* _tmp125_ = NULL;
					gint _tmp126_ = 0;
					ValaSourceLocation _tmp127_ = {0};
					ValaSourceLocation _tmp128_ = {0};
					ValaTokenType _tmp129_ = 0;
					_tmp123_ = token_length_in_chars;
					_tmp124_ = vala_scanner_get_source_reference (self, _tmp123_, 0);
					_tmp125_ = _tmp124_;
					vala_report_error (_tmp125_, "syntax error, expected \"");
					_vala_source_reference_unref0 (_tmp125_);
					_tmp126_ = self->priv->state_stack_length1;
					self->priv->state_stack_length1 = _tmp126_ - 1;
					_tmp129_ = vala_scanner_read_token (self, &_tmp127_, &_tmp128_);
					_vala_token_begin = _tmp127_;
					_vala_token_end = _tmp128_;
					result = _tmp129_;
					if (token_begin) {
						*token_begin = _vala_token_begin;
					}
					if (token_end) {
						*token_end = _vala_token_end;
					}
					return result;
				}
				break;
			}
		}
	}
	_tmp130_ = token_length_in_chars;
	if (_tmp130_ < 0) {
		gint _tmp131_ = 0;
		gchar* _tmp132_ = NULL;
		gchar* _tmp133_ = NULL;
		_tmp131_ = self->priv->column;
		_tmp132_ = self->priv->current;
		_tmp133_ = begin;
		self->priv->column = _tmp131_ + ((gint) (_tmp132_ - _tmp133_));
	} else {
		gint _tmp134_ = 0;
		gint _tmp135_ = 0;
		_tmp134_ = self->priv->column;
		_tmp135_ = token_length_in_chars;
		self->priv->column = _tmp134_ + _tmp135_;
	}
	_tmp136_ = self->priv->current;
	_tmp137_ = self->priv->line;
	_tmp138_ = self->priv->column;
	vala_source_location_init (&_vala_token_end, _tmp136_, _tmp137_, _tmp138_ - 1);
	result = type;
	if (token_begin) {
		*token_begin = _vala_token_begin;
	}
	if (token_end) {
		*token_end = _vala_token_end;
	}
	return result;
}


ValaTokenType vala_scanner_get_identifier_or_keyword (gchar* begin, gint len) {
	ValaTokenType result = 0;
	gint _tmp0_ = 0;
	_tmp0_ = len;
	switch (_tmp0_) {
		case 2:
		{
			gchar* _tmp1_ = NULL;
			gchar _tmp2_ = '\0';
			_tmp1_ = begin;
			_tmp2_ = _tmp1_[0];
			switch (_tmp2_) {
				case 'a':
				{
					gchar* _tmp3_ = NULL;
					gboolean _tmp4_ = FALSE;
					_tmp3_ = begin;
					_tmp4_ = vala_scanner_matches (_tmp3_, "as");
					if (_tmp4_) {
						result = VALA_TOKEN_TYPE_AS;
						return result;
					}
					break;
				}
				case 'd':
				{
					gchar* _tmp5_ = NULL;
					gboolean _tmp6_ = FALSE;
					_tmp5_ = begin;
					_tmp6_ = vala_scanner_matches (_tmp5_, "do");
					if (_tmp6_) {
						result = VALA_TOKEN_TYPE_DO;
						return result;
					}
					break;
				}
				case 'i':
				{
					gchar* _tmp7_ = NULL;
					gchar _tmp8_ = '\0';
					_tmp7_ = begin;
					_tmp8_ = _tmp7_[1];
					switch (_tmp8_) {
						case 'f':
						{
							result = VALA_TOKEN_TYPE_IF;
							return result;
						}
						case 'n':
						{
							result = VALA_TOKEN_TYPE_IN;
							return result;
						}
						case 's':
						{
							result = VALA_TOKEN_TYPE_IS;
							return result;
						}
						default:
						break;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 3:
		{
			gchar* _tmp9_ = NULL;
			gchar _tmp10_ = '\0';
			_tmp9_ = begin;
			_tmp10_ = _tmp9_[0];
			switch (_tmp10_) {
				case 'f':
				{
					gchar* _tmp11_ = NULL;
					gboolean _tmp12_ = FALSE;
					_tmp11_ = begin;
					_tmp12_ = vala_scanner_matches (_tmp11_, "for");
					if (_tmp12_) {
						result = VALA_TOKEN_TYPE_FOR;
						return result;
					}
					break;
				}
				case 'g':
				{
					gchar* _tmp13_ = NULL;
					gboolean _tmp14_ = FALSE;
					_tmp13_ = begin;
					_tmp14_ = vala_scanner_matches (_tmp13_, "get");
					if (_tmp14_) {
						result = VALA_TOKEN_TYPE_GET;
						return result;
					}
					break;
				}
				case 'n':
				{
					gchar* _tmp15_ = NULL;
					gboolean _tmp16_ = FALSE;
					_tmp15_ = begin;
					_tmp16_ = vala_scanner_matches (_tmp15_, "new");
					if (_tmp16_) {
						result = VALA_TOKEN_TYPE_NEW;
						return result;
					}
					break;
				}
				case 'o':
				{
					gchar* _tmp17_ = NULL;
					gboolean _tmp18_ = FALSE;
					_tmp17_ = begin;
					_tmp18_ = vala_scanner_matches (_tmp17_, "out");
					if (_tmp18_) {
						result = VALA_TOKEN_TYPE_OUT;
						return result;
					}
					break;
				}
				case 'r':
				{
					gchar* _tmp19_ = NULL;
					gboolean _tmp20_ = FALSE;
					_tmp19_ = begin;
					_tmp20_ = vala_scanner_matches (_tmp19_, "ref");
					if (_tmp20_) {
						result = VALA_TOKEN_TYPE_REF;
						return result;
					}
					break;
				}
				case 's':
				{
					gchar* _tmp21_ = NULL;
					gboolean _tmp22_ = FALSE;
					_tmp21_ = begin;
					_tmp22_ = vala_scanner_matches (_tmp21_, "set");
					if (_tmp22_) {
						result = VALA_TOKEN_TYPE_SET;
						return result;
					}
					break;
				}
				case 't':
				{
					gchar* _tmp23_ = NULL;
					gboolean _tmp24_ = FALSE;
					_tmp23_ = begin;
					_tmp24_ = vala_scanner_matches (_tmp23_, "try");
					if (_tmp24_) {
						result = VALA_TOKEN_TYPE_TRY;
						return result;
					}
					break;
				}
				case 'v':
				{
					gchar* _tmp25_ = NULL;
					gboolean _tmp26_ = FALSE;
					_tmp25_ = begin;
					_tmp26_ = vala_scanner_matches (_tmp25_, "var");
					if (_tmp26_) {
						result = VALA_TOKEN_TYPE_VAR;
						return result;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 4:
		{
			gchar* _tmp27_ = NULL;
			gchar _tmp28_ = '\0';
			_tmp27_ = begin;
			_tmp28_ = _tmp27_[0];
			switch (_tmp28_) {
				case 'b':
				{
					gchar* _tmp29_ = NULL;
					gboolean _tmp30_ = FALSE;
					_tmp29_ = begin;
					_tmp30_ = vala_scanner_matches (_tmp29_, "base");
					if (_tmp30_) {
						result = VALA_TOKEN_TYPE_BASE;
						return result;
					}
					break;
				}
				case 'c':
				{
					gchar* _tmp31_ = NULL;
					gboolean _tmp32_ = FALSE;
					_tmp31_ = begin;
					_tmp32_ = vala_scanner_matches (_tmp31_, "case");
					if (_tmp32_) {
						result = VALA_TOKEN_TYPE_CASE;
						return result;
					}
					break;
				}
				case 'e':
				{
					gchar* _tmp33_ = NULL;
					gchar _tmp34_ = '\0';
					_tmp33_ = begin;
					_tmp34_ = _tmp33_[1];
					switch (_tmp34_) {
						case 'l':
						{
							gchar* _tmp35_ = NULL;
							gboolean _tmp36_ = FALSE;
							_tmp35_ = begin;
							_tmp36_ = vala_scanner_matches (_tmp35_, "else");
							if (_tmp36_) {
								result = VALA_TOKEN_TYPE_ELSE;
								return result;
							}
							break;
						}
						case 'n':
						{
							gchar* _tmp37_ = NULL;
							gboolean _tmp38_ = FALSE;
							_tmp37_ = begin;
							_tmp38_ = vala_scanner_matches (_tmp37_, "enum");
							if (_tmp38_) {
								result = VALA_TOKEN_TYPE_ENUM;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'l':
				{
					gchar* _tmp39_ = NULL;
					gboolean _tmp40_ = FALSE;
					_tmp39_ = begin;
					_tmp40_ = vala_scanner_matches (_tmp39_, "lock");
					if (_tmp40_) {
						result = VALA_TOKEN_TYPE_LOCK;
						return result;
					}
					break;
				}
				case 'n':
				{
					gchar* _tmp41_ = NULL;
					gboolean _tmp42_ = FALSE;
					_tmp41_ = begin;
					_tmp42_ = vala_scanner_matches (_tmp41_, "null");
					if (_tmp42_) {
						result = VALA_TOKEN_TYPE_NULL;
						return result;
					}
					break;
				}
				case 't':
				{
					gchar* _tmp43_ = NULL;
					gchar _tmp44_ = '\0';
					_tmp43_ = begin;
					_tmp44_ = _tmp43_[1];
					switch (_tmp44_) {
						case 'h':
						{
							gchar* _tmp45_ = NULL;
							gboolean _tmp46_ = FALSE;
							_tmp45_ = begin;
							_tmp46_ = vala_scanner_matches (_tmp45_, "this");
							if (_tmp46_) {
								result = VALA_TOKEN_TYPE_THIS;
								return result;
							}
							break;
						}
						case 'r':
						{
							gchar* _tmp47_ = NULL;
							gboolean _tmp48_ = FALSE;
							_tmp47_ = begin;
							_tmp48_ = vala_scanner_matches (_tmp47_, "true");
							if (_tmp48_) {
								result = VALA_TOKEN_TYPE_TRUE;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'v':
				{
					gchar* _tmp49_ = NULL;
					gboolean _tmp50_ = FALSE;
					_tmp49_ = begin;
					_tmp50_ = vala_scanner_matches (_tmp49_, "void");
					if (_tmp50_) {
						result = VALA_TOKEN_TYPE_VOID;
						return result;
					}
					break;
				}
				case 'w':
				{
					gchar* _tmp51_ = NULL;
					gboolean _tmp52_ = FALSE;
					_tmp51_ = begin;
					_tmp52_ = vala_scanner_matches (_tmp51_, "weak");
					if (_tmp52_) {
						result = VALA_TOKEN_TYPE_WEAK;
						return result;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 5:
		{
			gchar* _tmp53_ = NULL;
			gchar _tmp54_ = '\0';
			_tmp53_ = begin;
			_tmp54_ = _tmp53_[0];
			switch (_tmp54_) {
				case 'a':
				{
					gchar* _tmp55_ = NULL;
					gboolean _tmp56_ = FALSE;
					_tmp55_ = begin;
					_tmp56_ = vala_scanner_matches (_tmp55_, "async");
					if (_tmp56_) {
						result = VALA_TOKEN_TYPE_ASYNC;
						return result;
					}
					break;
				}
				case 'b':
				{
					gchar* _tmp57_ = NULL;
					gboolean _tmp58_ = FALSE;
					_tmp57_ = begin;
					_tmp58_ = vala_scanner_matches (_tmp57_, "break");
					if (_tmp58_) {
						result = VALA_TOKEN_TYPE_BREAK;
						return result;
					}
					break;
				}
				case 'c':
				{
					gchar* _tmp59_ = NULL;
					gchar _tmp60_ = '\0';
					_tmp59_ = begin;
					_tmp60_ = _tmp59_[1];
					switch (_tmp60_) {
						case 'a':
						{
							gchar* _tmp61_ = NULL;
							gboolean _tmp62_ = FALSE;
							_tmp61_ = begin;
							_tmp62_ = vala_scanner_matches (_tmp61_, "catch");
							if (_tmp62_) {
								result = VALA_TOKEN_TYPE_CATCH;
								return result;
							}
							break;
						}
						case 'l':
						{
							gchar* _tmp63_ = NULL;
							gboolean _tmp64_ = FALSE;
							_tmp63_ = begin;
							_tmp64_ = vala_scanner_matches (_tmp63_, "class");
							if (_tmp64_) {
								result = VALA_TOKEN_TYPE_CLASS;
								return result;
							}
							break;
						}
						case 'o':
						{
							gchar* _tmp65_ = NULL;
							gboolean _tmp66_ = FALSE;
							_tmp65_ = begin;
							_tmp66_ = vala_scanner_matches (_tmp65_, "const");
							if (_tmp66_) {
								result = VALA_TOKEN_TYPE_CONST;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'f':
				{
					gchar* _tmp67_ = NULL;
					gboolean _tmp68_ = FALSE;
					_tmp67_ = begin;
					_tmp68_ = vala_scanner_matches (_tmp67_, "false");
					if (_tmp68_) {
						result = VALA_TOKEN_TYPE_FALSE;
						return result;
					}
					break;
				}
				case 'o':
				{
					gchar* _tmp69_ = NULL;
					gboolean _tmp70_ = FALSE;
					_tmp69_ = begin;
					_tmp70_ = vala_scanner_matches (_tmp69_, "owned");
					if (_tmp70_) {
						result = VALA_TOKEN_TYPE_OWNED;
						return result;
					}
					break;
				}
				case 't':
				{
					gchar* _tmp71_ = NULL;
					gboolean _tmp72_ = FALSE;
					_tmp71_ = begin;
					_tmp72_ = vala_scanner_matches (_tmp71_, "throw");
					if (_tmp72_) {
						result = VALA_TOKEN_TYPE_THROW;
						return result;
					}
					break;
				}
				case 'u':
				{
					gchar* _tmp73_ = NULL;
					gboolean _tmp74_ = FALSE;
					_tmp73_ = begin;
					_tmp74_ = vala_scanner_matches (_tmp73_, "using");
					if (_tmp74_) {
						result = VALA_TOKEN_TYPE_USING;
						return result;
					}
					break;
				}
				case 'w':
				{
					gchar* _tmp75_ = NULL;
					gboolean _tmp76_ = FALSE;
					_tmp75_ = begin;
					_tmp76_ = vala_scanner_matches (_tmp75_, "while");
					if (_tmp76_) {
						result = VALA_TOKEN_TYPE_WHILE;
						return result;
					}
					break;
				}
				case 'y':
				{
					gchar* _tmp77_ = NULL;
					gboolean _tmp78_ = FALSE;
					_tmp77_ = begin;
					_tmp78_ = vala_scanner_matches (_tmp77_, "yield");
					if (_tmp78_) {
						result = VALA_TOKEN_TYPE_YIELD;
						return result;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 6:
		{
			gchar* _tmp79_ = NULL;
			gchar _tmp80_ = '\0';
			_tmp79_ = begin;
			_tmp80_ = _tmp79_[0];
			switch (_tmp80_) {
				case 'd':
				{
					gchar* _tmp81_ = NULL;
					gboolean _tmp82_ = FALSE;
					_tmp81_ = begin;
					_tmp82_ = vala_scanner_matches (_tmp81_, "delete");
					if (_tmp82_) {
						result = VALA_TOKEN_TYPE_DELETE;
						return result;
					}
					break;
				}
				case 'e':
				{
					gchar* _tmp83_ = NULL;
					gboolean _tmp84_ = FALSE;
					_tmp83_ = begin;
					_tmp84_ = vala_scanner_matches (_tmp83_, "extern");
					if (_tmp84_) {
						result = VALA_TOKEN_TYPE_EXTERN;
						return result;
					}
					break;
				}
				case 'i':
				{
					gchar* _tmp85_ = NULL;
					gboolean _tmp86_ = FALSE;
					_tmp85_ = begin;
					_tmp86_ = vala_scanner_matches (_tmp85_, "inline");
					if (_tmp86_) {
						result = VALA_TOKEN_TYPE_INLINE;
						return result;
					}
					break;
				}
				case 'p':
				{
					gchar* _tmp87_ = NULL;
					gchar _tmp88_ = '\0';
					_tmp87_ = begin;
					_tmp88_ = _tmp87_[1];
					switch (_tmp88_) {
						case 'a':
						{
							gchar* _tmp89_ = NULL;
							gboolean _tmp90_ = FALSE;
							_tmp89_ = begin;
							_tmp90_ = vala_scanner_matches (_tmp89_, "params");
							if (_tmp90_) {
								result = VALA_TOKEN_TYPE_PARAMS;
								return result;
							}
							break;
						}
						case 'u':
						{
							gchar* _tmp91_ = NULL;
							gboolean _tmp92_ = FALSE;
							_tmp91_ = begin;
							_tmp92_ = vala_scanner_matches (_tmp91_, "public");
							if (_tmp92_) {
								result = VALA_TOKEN_TYPE_PUBLIC;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'r':
				{
					gchar* _tmp93_ = NULL;
					gboolean _tmp94_ = FALSE;
					_tmp93_ = begin;
					_tmp94_ = vala_scanner_matches (_tmp93_, "return");
					if (_tmp94_) {
						result = VALA_TOKEN_TYPE_RETURN;
						return result;
					}
					break;
				}
				case 's':
				{
					gchar* _tmp95_ = NULL;
					gchar _tmp96_ = '\0';
					_tmp95_ = begin;
					_tmp96_ = _tmp95_[1];
					switch (_tmp96_) {
						case 'e':
						{
							gchar* _tmp97_ = NULL;
							gboolean _tmp98_ = FALSE;
							_tmp97_ = begin;
							_tmp98_ = vala_scanner_matches (_tmp97_, "sealed");
							if (_tmp98_) {
								result = VALA_TOKEN_TYPE_SEALED;
								return result;
							}
							break;
						}
						case 'i':
						{
							gchar* _tmp99_ = NULL;
							gchar _tmp100_ = '\0';
							_tmp99_ = begin;
							_tmp100_ = _tmp99_[2];
							switch (_tmp100_) {
								case 'g':
								{
									gchar* _tmp101_ = NULL;
									gboolean _tmp102_ = FALSE;
									_tmp101_ = begin;
									_tmp102_ = vala_scanner_matches (_tmp101_, "signal");
									if (_tmp102_) {
										result = VALA_TOKEN_TYPE_SIGNAL;
										return result;
									}
									break;
								}
								case 'z':
								{
									gchar* _tmp103_ = NULL;
									gboolean _tmp104_ = FALSE;
									_tmp103_ = begin;
									_tmp104_ = vala_scanner_matches (_tmp103_, "sizeof");
									if (_tmp104_) {
										result = VALA_TOKEN_TYPE_SIZEOF;
										return result;
									}
									break;
								}
								default:
								break;
							}
							break;
						}
						case 't':
						{
							gchar* _tmp105_ = NULL;
							gchar _tmp106_ = '\0';
							_tmp105_ = begin;
							_tmp106_ = _tmp105_[2];
							switch (_tmp106_) {
								case 'a':
								{
									gchar* _tmp107_ = NULL;
									gboolean _tmp108_ = FALSE;
									_tmp107_ = begin;
									_tmp108_ = vala_scanner_matches (_tmp107_, "static");
									if (_tmp108_) {
										result = VALA_TOKEN_TYPE_STATIC;
										return result;
									}
									break;
								}
								case 'r':
								{
									gchar* _tmp109_ = NULL;
									gboolean _tmp110_ = FALSE;
									_tmp109_ = begin;
									_tmp110_ = vala_scanner_matches (_tmp109_, "struct");
									if (_tmp110_) {
										result = VALA_TOKEN_TYPE_STRUCT;
										return result;
									}
									break;
								}
								default:
								break;
							}
							break;
						}
						case 'w':
						{
							gchar* _tmp111_ = NULL;
							gboolean _tmp112_ = FALSE;
							_tmp111_ = begin;
							_tmp112_ = vala_scanner_matches (_tmp111_, "switch");
							if (_tmp112_) {
								result = VALA_TOKEN_TYPE_SWITCH;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 't':
				{
					gchar* _tmp113_ = NULL;
					gchar _tmp114_ = '\0';
					_tmp113_ = begin;
					_tmp114_ = _tmp113_[1];
					switch (_tmp114_) {
						case 'h':
						{
							gchar* _tmp115_ = NULL;
							gboolean _tmp116_ = FALSE;
							_tmp115_ = begin;
							_tmp116_ = vala_scanner_matches (_tmp115_, "throws");
							if (_tmp116_) {
								result = VALA_TOKEN_TYPE_THROWS;
								return result;
							}
							break;
						}
						case 'y':
						{
							gchar* _tmp117_ = NULL;
							gboolean _tmp118_ = FALSE;
							_tmp117_ = begin;
							_tmp118_ = vala_scanner_matches (_tmp117_, "typeof");
							if (_tmp118_) {
								result = VALA_TOKEN_TYPE_TYPEOF;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 7:
		{
			gchar* _tmp119_ = NULL;
			gchar _tmp120_ = '\0';
			_tmp119_ = begin;
			_tmp120_ = _tmp119_[0];
			switch (_tmp120_) {
				case 'd':
				{
					gchar* _tmp121_ = NULL;
					gchar _tmp122_ = '\0';
					_tmp121_ = begin;
					_tmp122_ = _tmp121_[1];
					switch (_tmp122_) {
						case 'e':
						{
							gchar* _tmp123_ = NULL;
							gboolean _tmp124_ = FALSE;
							_tmp123_ = begin;
							_tmp124_ = vala_scanner_matches (_tmp123_, "default");
							if (_tmp124_) {
								result = VALA_TOKEN_TYPE_DEFAULT;
								return result;
							}
							break;
						}
						case 'y':
						{
							gchar* _tmp125_ = NULL;
							gboolean _tmp126_ = FALSE;
							_tmp125_ = begin;
							_tmp126_ = vala_scanner_matches (_tmp125_, "dynamic");
							if (_tmp126_) {
								result = VALA_TOKEN_TYPE_DYNAMIC;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'e':
				{
					gchar* _tmp127_ = NULL;
					gboolean _tmp128_ = FALSE;
					_tmp127_ = begin;
					_tmp128_ = vala_scanner_matches (_tmp127_, "ensures");
					if (_tmp128_) {
						result = VALA_TOKEN_TYPE_ENSURES;
						return result;
					}
					break;
				}
				case 'f':
				{
					gchar* _tmp129_ = NULL;
					gchar _tmp130_ = '\0';
					_tmp129_ = begin;
					_tmp130_ = _tmp129_[1];
					switch (_tmp130_) {
						case 'i':
						{
							gchar* _tmp131_ = NULL;
							gboolean _tmp132_ = FALSE;
							_tmp131_ = begin;
							_tmp132_ = vala_scanner_matches (_tmp131_, "finally");
							if (_tmp132_) {
								result = VALA_TOKEN_TYPE_FINALLY;
								return result;
							}
							break;
						}
						case 'o':
						{
							gchar* _tmp133_ = NULL;
							gboolean _tmp134_ = FALSE;
							_tmp133_ = begin;
							_tmp134_ = vala_scanner_matches (_tmp133_, "foreach");
							if (_tmp134_) {
								result = VALA_TOKEN_TYPE_FOREACH;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'p':
				{
					gchar* _tmp135_ = NULL;
					gboolean _tmp136_ = FALSE;
					_tmp135_ = begin;
					_tmp136_ = vala_scanner_matches (_tmp135_, "private");
					if (_tmp136_) {
						result = VALA_TOKEN_TYPE_PRIVATE;
						return result;
					}
					break;
				}
				case 'u':
				{
					gchar* _tmp137_ = NULL;
					gboolean _tmp138_ = FALSE;
					_tmp137_ = begin;
					_tmp138_ = vala_scanner_matches (_tmp137_, "unowned");
					if (_tmp138_) {
						result = VALA_TOKEN_TYPE_UNOWNED;
						return result;
					}
					break;
				}
				case 'v':
				{
					gchar* _tmp139_ = NULL;
					gboolean _tmp140_ = FALSE;
					_tmp139_ = begin;
					_tmp140_ = vala_scanner_matches (_tmp139_, "virtual");
					if (_tmp140_) {
						result = VALA_TOKEN_TYPE_VIRTUAL;
						return result;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 8:
		{
			gchar* _tmp141_ = NULL;
			gchar _tmp142_ = '\0';
			_tmp141_ = begin;
			_tmp142_ = _tmp141_[0];
			switch (_tmp142_) {
				case 'a':
				{
					gchar* _tmp143_ = NULL;
					gboolean _tmp144_ = FALSE;
					_tmp143_ = begin;
					_tmp144_ = vala_scanner_matches (_tmp143_, "abstract");
					if (_tmp144_) {
						result = VALA_TOKEN_TYPE_ABSTRACT;
						return result;
					}
					break;
				}
				case 'c':
				{
					gchar* _tmp145_ = NULL;
					gboolean _tmp146_ = FALSE;
					_tmp145_ = begin;
					_tmp146_ = vala_scanner_matches (_tmp145_, "continue");
					if (_tmp146_) {
						result = VALA_TOKEN_TYPE_CONTINUE;
						return result;
					}
					break;
				}
				case 'd':
				{
					gchar* _tmp147_ = NULL;
					gboolean _tmp148_ = FALSE;
					_tmp147_ = begin;
					_tmp148_ = vala_scanner_matches (_tmp147_, "delegate");
					if (_tmp148_) {
						result = VALA_TOKEN_TYPE_DELEGATE;
						return result;
					}
					break;
				}
				case 'i':
				{
					gchar* _tmp149_ = NULL;
					gboolean _tmp150_ = FALSE;
					_tmp149_ = begin;
					_tmp150_ = vala_scanner_matches (_tmp149_, "internal");
					if (_tmp150_) {
						result = VALA_TOKEN_TYPE_INTERNAL;
						return result;
					}
					break;
				}
				case 'o':
				{
					gchar* _tmp151_ = NULL;
					gboolean _tmp152_ = FALSE;
					_tmp151_ = begin;
					_tmp152_ = vala_scanner_matches (_tmp151_, "override");
					if (_tmp152_) {
						result = VALA_TOKEN_TYPE_OVERRIDE;
						return result;
					}
					break;
				}
				case 'r':
				{
					gchar* _tmp153_ = NULL;
					gboolean _tmp154_ = FALSE;
					_tmp153_ = begin;
					_tmp154_ = vala_scanner_matches (_tmp153_, "requires");
					if (_tmp154_) {
						result = VALA_TOKEN_TYPE_REQUIRES;
						return result;
					}
					break;
				}
				case 'v':
				{
					gchar* _tmp155_ = NULL;
					gboolean _tmp156_ = FALSE;
					_tmp155_ = begin;
					_tmp156_ = vala_scanner_matches (_tmp155_, "volatile");
					if (_tmp156_) {
						result = VALA_TOKEN_TYPE_VOLATILE;
						return result;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 9:
		{
			gchar* _tmp157_ = NULL;
			gchar _tmp158_ = '\0';
			_tmp157_ = begin;
			_tmp158_ = _tmp157_[0];
			switch (_tmp158_) {
				case 'c':
				{
					gchar* _tmp159_ = NULL;
					gboolean _tmp160_ = FALSE;
					_tmp159_ = begin;
					_tmp160_ = vala_scanner_matches (_tmp159_, "construct");
					if (_tmp160_) {
						result = VALA_TOKEN_TYPE_CONSTRUCT;
						return result;
					}
					break;
				}
				case 'i':
				{
					gchar* _tmp161_ = NULL;
					gboolean _tmp162_ = FALSE;
					_tmp161_ = begin;
					_tmp162_ = vala_scanner_matches (_tmp161_, "interface");
					if (_tmp162_) {
						result = VALA_TOKEN_TYPE_INTERFACE;
						return result;
					}
					break;
				}
				case 'n':
				{
					gchar* _tmp163_ = NULL;
					gboolean _tmp164_ = FALSE;
					_tmp163_ = begin;
					_tmp164_ = vala_scanner_matches (_tmp163_, "namespace");
					if (_tmp164_) {
						result = VALA_TOKEN_TYPE_NAMESPACE;
						return result;
					}
					break;
				}
				case 'p':
				{
					gchar* _tmp165_ = NULL;
					gboolean _tmp166_ = FALSE;
					_tmp165_ = begin;
					_tmp166_ = vala_scanner_matches (_tmp165_, "protected");
					if (_tmp166_) {
						result = VALA_TOKEN_TYPE_PROTECTED;
						return result;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 11:
		{
			gchar* _tmp167_ = NULL;
			gboolean _tmp168_ = FALSE;
			_tmp167_ = begin;
			_tmp168_ = vala_scanner_matches (_tmp167_, "errordomain");
			if (_tmp168_) {
				result = VALA_TOKEN_TYPE_ERRORDOMAIN;
				return result;
			}
			break;
		}
		default:
		break;
	}
	result = VALA_TOKEN_TYPE_IDENTIFIER;
	return result;
}


static ValaTokenType vala_scanner_read_number (ValaScanner* self) {
	ValaTokenType result = 0;
	ValaTokenType type = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp32_ = FALSE;
	gboolean _tmp33_ = FALSE;
	gchar* _tmp34_ = NULL;
	gchar* _tmp35_ = NULL;
	gboolean _tmp38_ = FALSE;
	gboolean _tmp42_ = FALSE;
	gboolean _tmp52_ = FALSE;
	gchar* _tmp53_ = NULL;
	gchar* _tmp54_ = NULL;
	gboolean _tmp58_ = FALSE;
	gchar* _tmp79_ = NULL;
	gchar* _tmp80_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	type = VALA_TOKEN_TYPE_INTEGER_LITERAL;
	_tmp3_ = self->priv->current;
	_tmp4_ = self->priv->end;
	if (_tmp3_ < (_tmp4_ - 2)) {
		gchar* _tmp5_ = NULL;
		gchar _tmp6_ = '\0';
		_tmp5_ = self->priv->current;
		_tmp6_ = _tmp5_[0];
		_tmp2_ = _tmp6_ == '0';
	} else {
		_tmp2_ = FALSE;
	}
	_tmp7_ = _tmp2_;
	if (_tmp7_) {
		gchar* _tmp8_ = NULL;
		gchar _tmp9_ = '\0';
		_tmp8_ = self->priv->current;
		_tmp9_ = _tmp8_[1];
		_tmp1_ = _tmp9_ == 'x';
	} else {
		_tmp1_ = FALSE;
	}
	_tmp10_ = _tmp1_;
	if (_tmp10_) {
		gchar* _tmp11_ = NULL;
		gchar _tmp12_ = '\0';
		gboolean _tmp13_ = FALSE;
		_tmp11_ = self->priv->current;
		_tmp12_ = _tmp11_[2];
		_tmp13_ = g_ascii_isxdigit (_tmp12_);
		_tmp0_ = _tmp13_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp14_ = _tmp0_;
	if (_tmp14_) {
		gchar* _tmp15_ = NULL;
		_tmp15_ = self->priv->current;
		self->priv->current = _tmp15_ + 2;
		while (TRUE) {
			gboolean _tmp16_ = FALSE;
			gchar* _tmp17_ = NULL;
			gchar* _tmp18_ = NULL;
			gboolean _tmp22_ = FALSE;
			gchar* _tmp23_ = NULL;
			_tmp17_ = self->priv->current;
			_tmp18_ = self->priv->end;
			if (_tmp17_ < _tmp18_) {
				gchar* _tmp19_ = NULL;
				gchar _tmp20_ = '\0';
				gboolean _tmp21_ = FALSE;
				_tmp19_ = self->priv->current;
				_tmp20_ = _tmp19_[0];
				_tmp21_ = g_ascii_isxdigit (_tmp20_);
				_tmp16_ = _tmp21_;
			} else {
				_tmp16_ = FALSE;
			}
			_tmp22_ = _tmp16_;
			if (!_tmp22_) {
				break;
			}
			_tmp23_ = self->priv->current;
			self->priv->current = _tmp23_ + 1;
		}
	} else {
		while (TRUE) {
			gboolean _tmp24_ = FALSE;
			gchar* _tmp25_ = NULL;
			gchar* _tmp26_ = NULL;
			gboolean _tmp30_ = FALSE;
			gchar* _tmp31_ = NULL;
			_tmp25_ = self->priv->current;
			_tmp26_ = self->priv->end;
			if (_tmp25_ < _tmp26_) {
				gchar* _tmp27_ = NULL;
				gchar _tmp28_ = '\0';
				gboolean _tmp29_ = FALSE;
				_tmp27_ = self->priv->current;
				_tmp28_ = _tmp27_[0];
				_tmp29_ = g_ascii_isdigit (_tmp28_);
				_tmp24_ = _tmp29_;
			} else {
				_tmp24_ = FALSE;
			}
			_tmp30_ = _tmp24_;
			if (!_tmp30_) {
				break;
			}
			_tmp31_ = self->priv->current;
			self->priv->current = _tmp31_ + 1;
		}
	}
	_tmp34_ = self->priv->current;
	_tmp35_ = self->priv->end;
	if (_tmp34_ < (_tmp35_ - 1)) {
		gchar* _tmp36_ = NULL;
		gchar _tmp37_ = '\0';
		_tmp36_ = self->priv->current;
		_tmp37_ = _tmp36_[0];
		_tmp33_ = _tmp37_ == '.';
	} else {
		_tmp33_ = FALSE;
	}
	_tmp38_ = _tmp33_;
	if (_tmp38_) {
		gchar* _tmp39_ = NULL;
		gchar _tmp40_ = '\0';
		gboolean _tmp41_ = FALSE;
		_tmp39_ = self->priv->current;
		_tmp40_ = _tmp39_[1];
		_tmp41_ = g_ascii_isdigit (_tmp40_);
		_tmp32_ = _tmp41_;
	} else {
		_tmp32_ = FALSE;
	}
	_tmp42_ = _tmp32_;
	if (_tmp42_) {
		gchar* _tmp43_ = NULL;
		type = VALA_TOKEN_TYPE_REAL_LITERAL;
		_tmp43_ = self->priv->current;
		self->priv->current = _tmp43_ + 1;
		while (TRUE) {
			gboolean _tmp44_ = FALSE;
			gchar* _tmp45_ = NULL;
			gchar* _tmp46_ = NULL;
			gboolean _tmp50_ = FALSE;
			gchar* _tmp51_ = NULL;
			_tmp45_ = self->priv->current;
			_tmp46_ = self->priv->end;
			if (_tmp45_ < _tmp46_) {
				gchar* _tmp47_ = NULL;
				gchar _tmp48_ = '\0';
				gboolean _tmp49_ = FALSE;
				_tmp47_ = self->priv->current;
				_tmp48_ = _tmp47_[0];
				_tmp49_ = g_ascii_isdigit (_tmp48_);
				_tmp44_ = _tmp49_;
			} else {
				_tmp44_ = FALSE;
			}
			_tmp50_ = _tmp44_;
			if (!_tmp50_) {
				break;
			}
			_tmp51_ = self->priv->current;
			self->priv->current = _tmp51_ + 1;
		}
	}
	_tmp53_ = self->priv->current;
	_tmp54_ = self->priv->end;
	if (_tmp53_ < _tmp54_) {
		gchar* _tmp55_ = NULL;
		gchar _tmp56_ = '\0';
		gchar _tmp57_ = '\0';
		_tmp55_ = self->priv->current;
		_tmp56_ = _tmp55_[0];
		_tmp57_ = g_ascii_tolower (_tmp56_);
		_tmp52_ = _tmp57_ == 'e';
	} else {
		_tmp52_ = FALSE;
	}
	_tmp58_ = _tmp52_;
	if (_tmp58_) {
		gchar* _tmp59_ = NULL;
		gboolean _tmp60_ = FALSE;
		gchar* _tmp61_ = NULL;
		gchar* _tmp62_ = NULL;
		gboolean _tmp69_ = FALSE;
		type = VALA_TOKEN_TYPE_REAL_LITERAL;
		_tmp59_ = self->priv->current;
		self->priv->current = _tmp59_ + 1;
		_tmp61_ = self->priv->current;
		_tmp62_ = self->priv->end;
		if (_tmp61_ < _tmp62_) {
			gboolean _tmp63_ = FALSE;
			gchar* _tmp64_ = NULL;
			gchar _tmp65_ = '\0';
			gboolean _tmp68_ = FALSE;
			_tmp64_ = self->priv->current;
			_tmp65_ = _tmp64_[0];
			if (_tmp65_ == '+') {
				_tmp63_ = TRUE;
			} else {
				gchar* _tmp66_ = NULL;
				gchar _tmp67_ = '\0';
				_tmp66_ = self->priv->current;
				_tmp67_ = _tmp66_[0];
				_tmp63_ = _tmp67_ == '-';
			}
			_tmp68_ = _tmp63_;
			_tmp60_ = _tmp68_;
		} else {
			_tmp60_ = FALSE;
		}
		_tmp69_ = _tmp60_;
		if (_tmp69_) {
			gchar* _tmp70_ = NULL;
			_tmp70_ = self->priv->current;
			self->priv->current = _tmp70_ + 1;
		}
		while (TRUE) {
			gboolean _tmp71_ = FALSE;
			gchar* _tmp72_ = NULL;
			gchar* _tmp73_ = NULL;
			gboolean _tmp77_ = FALSE;
			gchar* _tmp78_ = NULL;
			_tmp72_ = self->priv->current;
			_tmp73_ = self->priv->end;
			if (_tmp72_ < _tmp73_) {
				gchar* _tmp74_ = NULL;
				gchar _tmp75_ = '\0';
				gboolean _tmp76_ = FALSE;
				_tmp74_ = self->priv->current;
				_tmp75_ = _tmp74_[0];
				_tmp76_ = g_ascii_isdigit (_tmp75_);
				_tmp71_ = _tmp76_;
			} else {
				_tmp71_ = FALSE;
			}
			_tmp77_ = _tmp71_;
			if (!_tmp77_) {
				break;
			}
			_tmp78_ = self->priv->current;
			self->priv->current = _tmp78_ + 1;
		}
	}
	_tmp79_ = self->priv->current;
	_tmp80_ = self->priv->end;
	if (_tmp79_ < _tmp80_) {
		gboolean real_literal = FALSE;
		ValaTokenType _tmp81_ = 0;
		gchar* _tmp82_ = NULL;
		gchar _tmp83_ = '\0';
		gboolean _tmp113_ = FALSE;
		gboolean _tmp114_ = FALSE;
		gboolean _tmp118_ = FALSE;
		_tmp81_ = type;
		real_literal = _tmp81_ == VALA_TOKEN_TYPE_REAL_LITERAL;
		_tmp82_ = self->priv->current;
		_tmp83_ = _tmp82_[0];
		switch (_tmp83_) {
			case 'l':
			case 'L':
			{
				ValaTokenType _tmp84_ = 0;
				_tmp84_ = type;
				if (_tmp84_ == VALA_TOKEN_TYPE_INTEGER_LITERAL) {
					gchar* _tmp85_ = NULL;
					gboolean _tmp86_ = FALSE;
					gchar* _tmp87_ = NULL;
					gchar* _tmp88_ = NULL;
					gboolean _tmp92_ = FALSE;
					_tmp85_ = self->priv->current;
					self->priv->current = _tmp85_ + 1;
					_tmp87_ = self->priv->current;
					_tmp88_ = self->priv->end;
					if (_tmp87_ < _tmp88_) {
						gchar* _tmp89_ = NULL;
						gchar _tmp90_ = '\0';
						gchar _tmp91_ = '\0';
						_tmp89_ = self->priv->current;
						_tmp90_ = _tmp89_[0];
						_tmp91_ = g_ascii_tolower (_tmp90_);
						_tmp86_ = _tmp91_ == 'l';
					} else {
						_tmp86_ = FALSE;
					}
					_tmp92_ = _tmp86_;
					if (_tmp92_) {
						gchar* _tmp93_ = NULL;
						_tmp93_ = self->priv->current;
						self->priv->current = _tmp93_ + 1;
					}
				}
				break;
			}
			case 'u':
			case 'U':
			{
				ValaTokenType _tmp94_ = 0;
				_tmp94_ = type;
				if (_tmp94_ == VALA_TOKEN_TYPE_INTEGER_LITERAL) {
					gchar* _tmp95_ = NULL;
					gboolean _tmp96_ = FALSE;
					gchar* _tmp97_ = NULL;
					gchar* _tmp98_ = NULL;
					gboolean _tmp102_ = FALSE;
					_tmp95_ = self->priv->current;
					self->priv->current = _tmp95_ + 1;
					_tmp97_ = self->priv->current;
					_tmp98_ = self->priv->end;
					if (_tmp97_ < _tmp98_) {
						gchar* _tmp99_ = NULL;
						gchar _tmp100_ = '\0';
						gchar _tmp101_ = '\0';
						_tmp99_ = self->priv->current;
						_tmp100_ = _tmp99_[0];
						_tmp101_ = g_ascii_tolower (_tmp100_);
						_tmp96_ = _tmp101_ == 'l';
					} else {
						_tmp96_ = FALSE;
					}
					_tmp102_ = _tmp96_;
					if (_tmp102_) {
						gchar* _tmp103_ = NULL;
						gboolean _tmp104_ = FALSE;
						gchar* _tmp105_ = NULL;
						gchar* _tmp106_ = NULL;
						gboolean _tmp110_ = FALSE;
						_tmp103_ = self->priv->current;
						self->priv->current = _tmp103_ + 1;
						_tmp105_ = self->priv->current;
						_tmp106_ = self->priv->end;
						if (_tmp105_ < _tmp106_) {
							gchar* _tmp107_ = NULL;
							gchar _tmp108_ = '\0';
							gchar _tmp109_ = '\0';
							_tmp107_ = self->priv->current;
							_tmp108_ = _tmp107_[0];
							_tmp109_ = g_ascii_tolower (_tmp108_);
							_tmp104_ = _tmp109_ == 'l';
						} else {
							_tmp104_ = FALSE;
						}
						_tmp110_ = _tmp104_;
						if (_tmp110_) {
							gchar* _tmp111_ = NULL;
							_tmp111_ = self->priv->current;
							self->priv->current = _tmp111_ + 1;
						}
					}
				}
				break;
			}
			case 'f':
			case 'F':
			case 'd':
			case 'D':
			{
				gchar* _tmp112_ = NULL;
				type = VALA_TOKEN_TYPE_REAL_LITERAL;
				_tmp112_ = self->priv->current;
				self->priv->current = _tmp112_ + 1;
				break;
			}
			default:
			break;
		}
		_tmp114_ = real_literal;
		if (!_tmp114_) {
			gchar* _tmp115_ = NULL;
			gchar _tmp116_ = '\0';
			gboolean _tmp117_ = FALSE;
			_tmp115_ = self->priv->current;
			_tmp116_ = _tmp115_[0];
			_tmp117_ = vala_scanner_is_ident_char (self, _tmp116_);
			_tmp113_ = _tmp117_;
		} else {
			_tmp113_ = FALSE;
		}
		_tmp118_ = _tmp113_;
		if (_tmp118_) {
			while (TRUE) {
				gboolean _tmp119_ = FALSE;
				gchar* _tmp120_ = NULL;
				gchar* _tmp121_ = NULL;
				gboolean _tmp125_ = FALSE;
				gchar* _tmp126_ = NULL;
				_tmp120_ = self->priv->current;
				_tmp121_ = self->priv->end;
				if (_tmp120_ < _tmp121_) {
					gchar* _tmp122_ = NULL;
					gchar _tmp123_ = '\0';
					gboolean _tmp124_ = FALSE;
					_tmp122_ = self->priv->current;
					_tmp123_ = _tmp122_[0];
					_tmp124_ = vala_scanner_is_ident_char (self, _tmp123_);
					_tmp119_ = _tmp124_;
				} else {
					_tmp119_ = FALSE;
				}
				_tmp125_ = _tmp119_;
				if (!_tmp125_) {
					break;
				}
				_tmp126_ = self->priv->current;
				self->priv->current = _tmp126_ + 1;
			}
			type = VALA_TOKEN_TYPE_IDENTIFIER;
		}
	}
	result = type;
	return result;
}


static void _vala_array_add13 (ValaScannerState** array, int* length, int* size, ValaScannerState value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_array_add14 (ValaScannerState** array, int* length, int* size, ValaScannerState value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_array_add15 (ValaScannerState** array, int* length, int* size, ValaScannerState value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_array_add16 (ValaScannerState** array, int* length, int* size, ValaScannerState value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


ValaTokenType vala_scanner_read_template_token (ValaScanner* self, ValaSourceLocation* token_begin, ValaSourceLocation* token_end) {
	ValaSourceLocation _vala_token_begin = {0};
	ValaSourceLocation _vala_token_end = {0};
	ValaTokenType result = 0;
	ValaTokenType type = 0;
	gchar* begin = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint token_length_in_chars = 0;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gint _tmp135_ = 0;
	gchar* _tmp141_ = NULL;
	gint _tmp142_ = 0;
	gint _tmp143_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->current;
	begin = _tmp0_;
	_tmp1_ = begin;
	_tmp2_ = self->priv->line;
	_tmp3_ = self->priv->column;
	vala_source_location_init (&_vala_token_begin, _tmp1_, _tmp2_, _tmp3_);
	token_length_in_chars = -1;
	_tmp4_ = self->priv->current;
	_tmp5_ = self->priv->end;
	if (_tmp4_ >= _tmp5_) {
		type = VALA_TOKEN_TYPE_EOF;
	} else {
		gchar* _tmp6_ = NULL;
		gchar _tmp7_ = '\0';
		_tmp6_ = self->priv->current;
		_tmp7_ = _tmp6_[0];
		switch (_tmp7_) {
			case '"':
			{
				gchar* _tmp8_ = NULL;
				gint _tmp9_ = 0;
				type = VALA_TOKEN_TYPE_CLOSE_TEMPLATE;
				_tmp8_ = self->priv->current;
				self->priv->current = _tmp8_ + 1;
				_tmp9_ = self->priv->state_stack_length1;
				self->priv->state_stack_length1 = _tmp9_ - 1;
				break;
			}
			case '$':
			{
				gchar* _tmp10_ = NULL;
				gchar* _tmp11_ = NULL;
				gboolean _tmp12_ = FALSE;
				gchar* _tmp13_ = NULL;
				gchar _tmp14_ = '\0';
				gboolean _tmp15_ = FALSE;
				gboolean _tmp18_ = FALSE;
				_tmp10_ = _vala_token_begin.pos;
				_vala_token_begin.pos = _tmp10_ + 1;
				_tmp11_ = self->priv->current;
				self->priv->current = _tmp11_ + 1;
				_tmp13_ = self->priv->current;
				_tmp14_ = _tmp13_[0];
				_tmp15_ = g_ascii_isalpha (_tmp14_);
				if (_tmp15_) {
					_tmp12_ = TRUE;
				} else {
					gchar* _tmp16_ = NULL;
					gchar _tmp17_ = '\0';
					_tmp16_ = self->priv->current;
					_tmp17_ = _tmp16_[0];
					_tmp12_ = _tmp17_ == '_';
				}
				_tmp18_ = _tmp12_;
				if (_tmp18_) {
					gint len = 0;
					ValaScannerState* _tmp28_ = NULL;
					gint _tmp28__length1 = 0;
					len = 0;
					while (TRUE) {
						gboolean _tmp19_ = FALSE;
						gchar* _tmp20_ = NULL;
						gchar* _tmp21_ = NULL;
						gboolean _tmp25_ = FALSE;
						gchar* _tmp26_ = NULL;
						gint _tmp27_ = 0;
						_tmp20_ = self->priv->current;
						_tmp21_ = self->priv->end;
						if (_tmp20_ < _tmp21_) {
							gchar* _tmp22_ = NULL;
							gchar _tmp23_ = '\0';
							gboolean _tmp24_ = FALSE;
							_tmp22_ = self->priv->current;
							_tmp23_ = _tmp22_[0];
							_tmp24_ = vala_scanner_is_ident_char (self, _tmp23_);
							_tmp19_ = _tmp24_;
						} else {
							_tmp19_ = FALSE;
						}
						_tmp25_ = _tmp19_;
						if (!_tmp25_) {
							break;
						}
						_tmp26_ = self->priv->current;
						self->priv->current = _tmp26_ + 1;
						_tmp27_ = len;
						len = _tmp27_ + 1;
					}
					type = VALA_TOKEN_TYPE_IDENTIFIER;
					_tmp28_ = self->priv->state_stack;
					_tmp28__length1 = self->priv->state_stack_length1;
					_vala_array_add13 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_SCANNER_STATE_TEMPLATE_PART);
				} else {
					gchar* _tmp29_ = NULL;
					gchar _tmp30_ = '\0';
					_tmp29_ = self->priv->current;
					_tmp30_ = _tmp29_[0];
					if (_tmp30_ == '(') {
						gchar* _tmp31_ = NULL;
						gint _tmp32_ = 0;
						ValaScannerState* _tmp33_ = NULL;
						gint _tmp33__length1 = 0;
						ValaSourceLocation _tmp34_ = {0};
						ValaSourceLocation _tmp35_ = {0};
						ValaTokenType _tmp36_ = 0;
						_tmp31_ = self->priv->current;
						self->priv->current = _tmp31_ + 1;
						_tmp32_ = self->priv->column;
						self->priv->column = _tmp32_ + 2;
						_tmp33_ = self->priv->state_stack;
						_tmp33__length1 = self->priv->state_stack_length1;
						_vala_array_add14 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_SCANNER_STATE_PARENS);
						_tmp36_ = vala_scanner_read_token (self, &_tmp34_, &_tmp35_);
						_vala_token_begin = _tmp34_;
						_vala_token_end = _tmp35_;
						result = _tmp36_;
						if (token_begin) {
							*token_begin = _vala_token_begin;
						}
						if (token_end) {
							*token_end = _vala_token_end;
						}
						return result;
					} else {
						gchar* _tmp37_ = NULL;
						gchar _tmp38_ = '\0';
						_tmp37_ = self->priv->current;
						_tmp38_ = _tmp37_[0];
						if (_tmp38_ == '$') {
							gchar* _tmp39_ = NULL;
							ValaScannerState* _tmp40_ = NULL;
							gint _tmp40__length1 = 0;
							type = VALA_TOKEN_TYPE_TEMPLATE_STRING_LITERAL;
							_tmp39_ = self->priv->current;
							self->priv->current = _tmp39_ + 1;
							_tmp40_ = self->priv->state_stack;
							_tmp40__length1 = self->priv->state_stack_length1;
							_vala_array_add15 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_SCANNER_STATE_TEMPLATE_PART);
						} else {
							ValaSourceReference* _tmp41_ = NULL;
							ValaSourceReference* _tmp42_ = NULL;
							ValaSourceLocation _tmp43_ = {0};
							ValaSourceLocation _tmp44_ = {0};
							ValaTokenType _tmp45_ = 0;
							_tmp41_ = vala_scanner_get_source_reference (self, 1, 0);
							_tmp42_ = _tmp41_;
							vala_report_error (_tmp42_, "unexpected character");
							_vala_source_reference_unref0 (_tmp42_);
							_tmp45_ = vala_scanner_read_template_token (self, &_tmp43_, &_tmp44_);
							_vala_token_begin = _tmp43_;
							_vala_token_end = _tmp44_;
							result = _tmp45_;
							if (token_begin) {
								*token_begin = _vala_token_begin;
							}
							if (token_end) {
								*token_end = _vala_token_end;
							}
							return result;
						}
					}
				}
				break;
			}
			default:
			{
				gchar* _tmp125_ = NULL;
				gchar* _tmp126_ = NULL;
				ValaScannerState* _tmp134_ = NULL;
				gint _tmp134__length1 = 0;
				type = VALA_TOKEN_TYPE_TEMPLATE_STRING_LITERAL;
				token_length_in_chars = 0;
				while (TRUE) {
					gboolean _tmp46_ = FALSE;
					gboolean _tmp47_ = FALSE;
					gchar* _tmp48_ = NULL;
					gchar* _tmp49_ = NULL;
					gboolean _tmp52_ = FALSE;
					gboolean _tmp55_ = FALSE;
					gchar* _tmp56_ = NULL;
					gchar _tmp57_ = '\0';
					_tmp48_ = self->priv->current;
					_tmp49_ = self->priv->end;
					if (_tmp48_ < _tmp49_) {
						gchar* _tmp50_ = NULL;
						gchar _tmp51_ = '\0';
						_tmp50_ = self->priv->current;
						_tmp51_ = _tmp50_[0];
						_tmp47_ = _tmp51_ != '"';
					} else {
						_tmp47_ = FALSE;
					}
					_tmp52_ = _tmp47_;
					if (_tmp52_) {
						gchar* _tmp53_ = NULL;
						gchar _tmp54_ = '\0';
						_tmp53_ = self->priv->current;
						_tmp54_ = _tmp53_[0];
						_tmp46_ = _tmp54_ != '$';
					} else {
						_tmp46_ = FALSE;
					}
					_tmp55_ = _tmp46_;
					if (!_tmp55_) {
						break;
					}
					_tmp56_ = self->priv->current;
					_tmp57_ = _tmp56_[0];
					if (_tmp57_ == '\\') {
						gchar* _tmp58_ = NULL;
						gint _tmp59_ = 0;
						gchar* _tmp60_ = NULL;
						gchar* _tmp61_ = NULL;
						gchar* _tmp62_ = NULL;
						gchar _tmp63_ = '\0';
						_tmp58_ = self->priv->current;
						self->priv->current = _tmp58_ + 1;
						_tmp59_ = token_length_in_chars;
						token_length_in_chars = _tmp59_ + 1;
						_tmp60_ = self->priv->current;
						_tmp61_ = self->priv->end;
						if (_tmp60_ >= _tmp61_) {
							break;
						}
						_tmp62_ = self->priv->current;
						_tmp63_ = _tmp62_[0];
						switch (_tmp63_) {
							case '\'':
							case '"':
							case '\\':
							case '0':
							case 'b':
							case 'f':
							case 'n':
							case 'r':
							case 't':
							{
								gchar* _tmp64_ = NULL;
								gint _tmp65_ = 0;
								_tmp64_ = self->priv->current;
								self->priv->current = _tmp64_ + 1;
								_tmp65_ = token_length_in_chars;
								token_length_in_chars = _tmp65_ + 1;
								break;
							}
							case 'u':
							{
								gchar* _tmp66_ = NULL;
								gint _tmp67_ = 0;
								gint digit_length = 0;
								gint _tmp83_ = 0;
								_tmp66_ = self->priv->current;
								self->priv->current = _tmp66_ + 1;
								_tmp67_ = token_length_in_chars;
								token_length_in_chars = _tmp67_ + 1;
								{
									gboolean _tmp68_ = FALSE;
									digit_length = 0;
									_tmp68_ = TRUE;
									while (TRUE) {
										gboolean _tmp69_ = FALSE;
										gboolean _tmp71_ = FALSE;
										gboolean _tmp72_ = FALSE;
										gint _tmp73_ = 0;
										gboolean _tmp76_ = FALSE;
										gboolean _tmp80_ = FALSE;
										gchar* _tmp81_ = NULL;
										gint _tmp82_ = 0;
										_tmp69_ = _tmp68_;
										if (!_tmp69_) {
											gint _tmp70_ = 0;
											_tmp70_ = digit_length;
											digit_length = _tmp70_ + 1;
										}
										_tmp68_ = FALSE;
										_tmp73_ = digit_length;
										if (_tmp73_ < 4) {
											gchar* _tmp74_ = NULL;
											gchar* _tmp75_ = NULL;
											_tmp74_ = self->priv->current;
											_tmp75_ = self->priv->end;
											_tmp72_ = _tmp74_ < _tmp75_;
										} else {
											_tmp72_ = FALSE;
										}
										_tmp76_ = _tmp72_;
										if (_tmp76_) {
											gchar* _tmp77_ = NULL;
											gchar _tmp78_ = '\0';
											gboolean _tmp79_ = FALSE;
											_tmp77_ = self->priv->current;
											_tmp78_ = _tmp77_[0];
											_tmp79_ = g_ascii_isxdigit (_tmp78_);
											_tmp71_ = _tmp79_;
										} else {
											_tmp71_ = FALSE;
										}
										_tmp80_ = _tmp71_;
										if (!_tmp80_) {
											break;
										}
										_tmp81_ = self->priv->current;
										self->priv->current = _tmp81_ + 1;
										_tmp82_ = token_length_in_chars;
										token_length_in_chars = _tmp82_ + 1;
									}
								}
								_tmp83_ = digit_length;
								if (_tmp83_ != 4) {
									gint _tmp84_ = 0;
									ValaSourceReference* _tmp85_ = NULL;
									ValaSourceReference* _tmp86_ = NULL;
									_tmp84_ = token_length_in_chars;
									_tmp85_ = vala_scanner_get_source_reference (self, _tmp84_, 0);
									_tmp86_ = _tmp85_;
									vala_report_error (_tmp86_, "\\u requires four hex digits");
									_vala_source_reference_unref0 (_tmp86_);
								}
								break;
							}
							case 'x':
							{
								gchar* _tmp87_ = NULL;
								gint _tmp88_ = 0;
								gint digit_length = 0;
								gint _tmp101_ = 0;
								_tmp87_ = self->priv->current;
								self->priv->current = _tmp87_ + 1;
								_tmp88_ = token_length_in_chars;
								token_length_in_chars = _tmp88_ + 1;
								{
									gboolean _tmp89_ = FALSE;
									digit_length = 0;
									_tmp89_ = TRUE;
									while (TRUE) {
										gboolean _tmp90_ = FALSE;
										gboolean _tmp92_ = FALSE;
										gchar* _tmp93_ = NULL;
										gchar* _tmp94_ = NULL;
										gboolean _tmp98_ = FALSE;
										gchar* _tmp99_ = NULL;
										gint _tmp100_ = 0;
										_tmp90_ = _tmp89_;
										if (!_tmp90_) {
											gint _tmp91_ = 0;
											_tmp91_ = digit_length;
											digit_length = _tmp91_ + 1;
										}
										_tmp89_ = FALSE;
										_tmp93_ = self->priv->current;
										_tmp94_ = self->priv->end;
										if (_tmp93_ < _tmp94_) {
											gchar* _tmp95_ = NULL;
											gchar _tmp96_ = '\0';
											gboolean _tmp97_ = FALSE;
											_tmp95_ = self->priv->current;
											_tmp96_ = _tmp95_[0];
											_tmp97_ = g_ascii_isxdigit (_tmp96_);
											_tmp92_ = _tmp97_;
										} else {
											_tmp92_ = FALSE;
										}
										_tmp98_ = _tmp92_;
										if (!_tmp98_) {
											break;
										}
										_tmp99_ = self->priv->current;
										self->priv->current = _tmp99_ + 1;
										_tmp100_ = token_length_in_chars;
										token_length_in_chars = _tmp100_ + 1;
									}
								}
								_tmp101_ = digit_length;
								if (_tmp101_ < 1) {
									gint _tmp102_ = 0;
									ValaSourceReference* _tmp103_ = NULL;
									ValaSourceReference* _tmp104_ = NULL;
									_tmp102_ = token_length_in_chars;
									_tmp103_ = vala_scanner_get_source_reference (self, _tmp102_, 0);
									_tmp104_ = _tmp103_;
									vala_report_error (_tmp104_, "\\x requires at least one hex digit");
									_vala_source_reference_unref0 (_tmp104_);
								}
								break;
							}
							default:
							{
								gint _tmp105_ = 0;
								ValaSourceReference* _tmp106_ = NULL;
								ValaSourceReference* _tmp107_ = NULL;
								_tmp105_ = token_length_in_chars;
								_tmp106_ = vala_scanner_get_source_reference (self, _tmp105_, 0);
								_tmp107_ = _tmp106_;
								vala_report_error (_tmp107_, "invalid escape sequence");
								_vala_source_reference_unref0 (_tmp107_);
								break;
							}
						}
					} else {
						gchar* _tmp108_ = NULL;
						gchar _tmp109_ = '\0';
						_tmp108_ = self->priv->current;
						_tmp109_ = _tmp108_[0];
						if (_tmp109_ == '\n') {
							gchar* _tmp110_ = NULL;
							gint _tmp111_ = 0;
							_tmp110_ = self->priv->current;
							self->priv->current = _tmp110_ + 1;
							_tmp111_ = self->priv->line;
							self->priv->line = _tmp111_ + 1;
							self->priv->column = 1;
							token_length_in_chars = 1;
						} else {
							gunichar u = 0U;
							gchar* _tmp112_ = NULL;
							gchar* _tmp113_ = NULL;
							gchar* _tmp114_ = NULL;
							gunichar _tmp115_ = 0U;
							gunichar _tmp116_ = 0U;
							_tmp112_ = self->priv->current;
							_tmp113_ = self->priv->end;
							_tmp114_ = self->priv->current;
							_tmp115_ = g_utf8_get_char_validated ((const gchar*) _tmp112_, (gssize) ((glong) (_tmp113_ - _tmp114_)));
							u = _tmp115_;
							_tmp116_ = u;
							if (_tmp116_ != ((gunichar) (-1))) {
								gchar* _tmp117_ = NULL;
								gunichar _tmp118_ = 0U;
								gint _tmp119_ = 0;
								gint _tmp120_ = 0;
								_tmp117_ = self->priv->current;
								_tmp118_ = u;
								_tmp119_ = g_unichar_to_utf8 (_tmp118_, NULL);
								self->priv->current = _tmp117_ + _tmp119_;
								_tmp120_ = token_length_in_chars;
								token_length_in_chars = _tmp120_ + 1;
							} else {
								gchar* _tmp121_ = NULL;
								gint _tmp122_ = 0;
								ValaSourceReference* _tmp123_ = NULL;
								ValaSourceReference* _tmp124_ = NULL;
								_tmp121_ = self->priv->current;
								self->priv->current = _tmp121_ + 1;
								_tmp122_ = token_length_in_chars;
								_tmp123_ = vala_scanner_get_source_reference (self, _tmp122_, 0);
								_tmp124_ = _tmp123_;
								vala_report_error (_tmp124_, "invalid UTF-8 character");
								_vala_source_reference_unref0 (_tmp124_);
							}
						}
					}
				}
				_tmp125_ = self->priv->current;
				_tmp126_ = self->priv->end;
				if (_tmp125_ >= _tmp126_) {
					gint _tmp127_ = 0;
					ValaSourceReference* _tmp128_ = NULL;
					ValaSourceReference* _tmp129_ = NULL;
					gint _tmp130_ = 0;
					ValaSourceLocation _tmp131_ = {0};
					ValaSourceLocation _tmp132_ = {0};
					ValaTokenType _tmp133_ = 0;
					_tmp127_ = token_length_in_chars;
					_tmp128_ = vala_scanner_get_source_reference (self, _tmp127_, 0);
					_tmp129_ = _tmp128_;
					vala_report_error (_tmp129_, "syntax error, expected \"");
					_vala_source_reference_unref0 (_tmp129_);
					_tmp130_ = self->priv->state_stack_length1;
					self->priv->state_stack_length1 = _tmp130_ - 1;
					_tmp133_ = vala_scanner_read_token (self, &_tmp131_, &_tmp132_);
					_vala_token_begin = _tmp131_;
					_vala_token_end = _tmp132_;
					result = _tmp133_;
					if (token_begin) {
						*token_begin = _vala_token_begin;
					}
					if (token_end) {
						*token_end = _vala_token_end;
					}
					return result;
				}
				_tmp134_ = self->priv->state_stack;
				_tmp134__length1 = self->priv->state_stack_length1;
				_vala_array_add16 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_SCANNER_STATE_TEMPLATE_PART);
				break;
			}
		}
	}
	_tmp135_ = token_length_in_chars;
	if (_tmp135_ < 0) {
		gint _tmp136_ = 0;
		gchar* _tmp137_ = NULL;
		gchar* _tmp138_ = NULL;
		_tmp136_ = self->priv->column;
		_tmp137_ = self->priv->current;
		_tmp138_ = begin;
		self->priv->column = _tmp136_ + ((gint) (_tmp137_ - _tmp138_));
	} else {
		gint _tmp139_ = 0;
		gint _tmp140_ = 0;
		_tmp139_ = self->priv->column;
		_tmp140_ = token_length_in_chars;
		self->priv->column = _tmp139_ + _tmp140_;
	}
	_tmp141_ = self->priv->current;
	_tmp142_ = self->priv->line;
	_tmp143_ = self->priv->column;
	vala_source_location_init (&_vala_token_end, _tmp141_, _tmp142_, _tmp143_ - 1);
	result = type;
	if (token_begin) {
		*token_begin = _vala_token_begin;
	}
	if (token_end) {
		*token_end = _vala_token_end;
	}
	return result;
}


static void _vala_array_add17 (ValaScannerState** array, int* length, int* size, ValaScannerState value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_array_add18 (ValaScannerState** array, int* length, int* size, ValaScannerState value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_array_add19 (ValaScannerState** array, int* length, int* size, ValaScannerState value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_array_add20 (ValaScannerState** array, int* length, int* size, ValaScannerState value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_array_add21 (ValaScannerState** array, int* length, int* size, ValaScannerState value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


ValaTokenType vala_scanner_read_token (ValaScanner* self, ValaSourceLocation* token_begin, ValaSourceLocation* token_end) {
	ValaSourceLocation _vala_token_begin = {0};
	ValaSourceLocation _vala_token_end = {0};
	ValaTokenType result = 0;
	gboolean _tmp0_ = FALSE;
	ValaTokenType type = 0;
	gchar* begin = NULL;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	gint token_length_in_chars = 0;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	gint _tmp392_ = 0;
	gchar* _tmp398_ = NULL;
	gint _tmp399_ = 0;
	gint _tmp400_ = 0;
	ValaTokenType _tmp401_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = vala_scanner_in_template (self);
	if (_tmp0_) {
		ValaSourceLocation _tmp1_ = {0};
		ValaSourceLocation _tmp2_ = {0};
		ValaTokenType _tmp3_ = 0;
		_tmp3_ = vala_scanner_read_template_token (self, &_tmp1_, &_tmp2_);
		_vala_token_begin = _tmp1_;
		_vala_token_end = _tmp2_;
		result = _tmp3_;
		if (token_begin) {
			*token_begin = _vala_token_begin;
		}
		if (token_end) {
			*token_end = _vala_token_end;
		}
		return result;
	} else {
		gboolean _tmp4_ = FALSE;
		_tmp4_ = vala_scanner_in_template_part (self);
		if (_tmp4_) {
			gint _tmp5_ = 0;
			gchar* _tmp6_ = NULL;
			gint _tmp7_ = 0;
			gint _tmp8_ = 0;
			gchar* _tmp9_ = NULL;
			gint _tmp10_ = 0;
			gint _tmp11_ = 0;
			_tmp5_ = self->priv->state_stack_length1;
			self->priv->state_stack_length1 = _tmp5_ - 1;
			_tmp6_ = self->priv->current;
			_tmp7_ = self->priv->line;
			_tmp8_ = self->priv->column;
			vala_source_location_init (&_vala_token_begin, _tmp6_, _tmp7_, _tmp8_);
			_tmp9_ = self->priv->current;
			_tmp10_ = self->priv->line;
			_tmp11_ = self->priv->column;
			vala_source_location_init (&_vala_token_end, _tmp9_, _tmp10_, _tmp11_ - 1);
			result = VALA_TOKEN_TYPE_COMMA;
			if (token_begin) {
				*token_begin = _vala_token_begin;
			}
			if (token_end) {
				*token_end = _vala_token_end;
			}
			return result;
		} else {
			gboolean _tmp12_ = FALSE;
			_tmp12_ = vala_scanner_in_regex_literal (self);
			if (_tmp12_) {
				ValaSourceLocation _tmp13_ = {0};
				ValaSourceLocation _tmp14_ = {0};
				ValaTokenType _tmp15_ = 0;
				_tmp15_ = vala_scanner_read_regex_token (self, &_tmp13_, &_tmp14_);
				_vala_token_begin = _tmp13_;
				_vala_token_end = _tmp14_;
				result = _tmp15_;
				if (token_begin) {
					*token_begin = _vala_token_begin;
				}
				if (token_end) {
					*token_end = _vala_token_end;
				}
				return result;
			}
		}
	}
	vala_scanner_space (self);
	_tmp16_ = self->priv->current;
	begin = _tmp16_;
	_tmp17_ = begin;
	_tmp18_ = self->priv->line;
	_tmp19_ = self->priv->column;
	vala_source_location_init (&_vala_token_begin, _tmp17_, _tmp18_, _tmp19_);
	token_length_in_chars = -1;
	_tmp20_ = self->priv->current;
	_tmp21_ = self->priv->end;
	if (_tmp20_ >= _tmp21_) {
		type = VALA_TOKEN_TYPE_EOF;
	} else {
		gboolean _tmp22_ = FALSE;
		gchar* _tmp23_ = NULL;
		gchar _tmp24_ = '\0';
		gboolean _tmp25_ = FALSE;
		gboolean _tmp28_ = FALSE;
		_tmp23_ = self->priv->current;
		_tmp24_ = _tmp23_[0];
		_tmp25_ = g_ascii_isalpha (_tmp24_);
		if (_tmp25_) {
			_tmp22_ = TRUE;
		} else {
			gchar* _tmp26_ = NULL;
			gchar _tmp27_ = '\0';
			_tmp26_ = self->priv->current;
			_tmp27_ = _tmp26_[0];
			_tmp22_ = _tmp27_ == '_';
		}
		_tmp28_ = _tmp22_;
		if (_tmp28_) {
			gint len = 0;
			gchar* _tmp38_ = NULL;
			gint _tmp39_ = 0;
			ValaTokenType _tmp40_ = 0;
			len = 0;
			while (TRUE) {
				gboolean _tmp29_ = FALSE;
				gchar* _tmp30_ = NULL;
				gchar* _tmp31_ = NULL;
				gboolean _tmp35_ = FALSE;
				gchar* _tmp36_ = NULL;
				gint _tmp37_ = 0;
				_tmp30_ = self->priv->current;
				_tmp31_ = self->priv->end;
				if (_tmp30_ < _tmp31_) {
					gchar* _tmp32_ = NULL;
					gchar _tmp33_ = '\0';
					gboolean _tmp34_ = FALSE;
					_tmp32_ = self->priv->current;
					_tmp33_ = _tmp32_[0];
					_tmp34_ = vala_scanner_is_ident_char (self, _tmp33_);
					_tmp29_ = _tmp34_;
				} else {
					_tmp29_ = FALSE;
				}
				_tmp35_ = _tmp29_;
				if (!_tmp35_) {
					break;
				}
				_tmp36_ = self->priv->current;
				self->priv->current = _tmp36_ + 1;
				_tmp37_ = len;
				len = _tmp37_ + 1;
			}
			_tmp38_ = begin;
			_tmp39_ = len;
			_tmp40_ = vala_scanner_get_identifier_or_keyword (_tmp38_, _tmp39_);
			type = _tmp40_;
		} else {
			gchar* _tmp41_ = NULL;
			gchar _tmp42_ = '\0';
			_tmp41_ = self->priv->current;
			_tmp42_ = _tmp41_[0];
			if (_tmp42_ == '@') {
				gboolean _tmp43_ = FALSE;
				gchar* _tmp44_ = NULL;
				gchar* _tmp45_ = NULL;
				gboolean _tmp48_ = FALSE;
				_tmp44_ = self->priv->current;
				_tmp45_ = self->priv->end;
				if (_tmp44_ < (_tmp45_ - 1)) {
					gchar* _tmp46_ = NULL;
					gchar _tmp47_ = '\0';
					_tmp46_ = self->priv->current;
					_tmp47_ = _tmp46_[1];
					_tmp43_ = _tmp47_ == '"';
				} else {
					_tmp43_ = FALSE;
				}
				_tmp48_ = _tmp43_;
				if (_tmp48_) {
					gchar* _tmp49_ = NULL;
					ValaScannerState* _tmp50_ = NULL;
					gint _tmp50__length1 = 0;
					type = VALA_TOKEN_TYPE_OPEN_TEMPLATE;
					_tmp49_ = self->priv->current;
					self->priv->current = _tmp49_ + 2;
					_tmp50_ = self->priv->state_stack;
					_tmp50__length1 = self->priv->state_stack_length1;
					_vala_array_add17 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_SCANNER_STATE_TEMPLATE);
				} else {
					gchar* _tmp51_ = NULL;
					gchar* _tmp52_ = NULL;
					gint len = 0;
					_tmp51_ = _vala_token_begin.pos;
					_vala_token_begin.pos = _tmp51_ + 1;
					_tmp52_ = self->priv->current;
					self->priv->current = _tmp52_ + 1;
					len = 0;
					while (TRUE) {
						gboolean _tmp53_ = FALSE;
						gchar* _tmp54_ = NULL;
						gchar* _tmp55_ = NULL;
						gboolean _tmp59_ = FALSE;
						gchar* _tmp60_ = NULL;
						gint _tmp61_ = 0;
						_tmp54_ = self->priv->current;
						_tmp55_ = self->priv->end;
						if (_tmp54_ < _tmp55_) {
							gchar* _tmp56_ = NULL;
							gchar _tmp57_ = '\0';
							gboolean _tmp58_ = FALSE;
							_tmp56_ = self->priv->current;
							_tmp57_ = _tmp56_[0];
							_tmp58_ = vala_scanner_is_ident_char (self, _tmp57_);
							_tmp53_ = _tmp58_;
						} else {
							_tmp53_ = FALSE;
						}
						_tmp59_ = _tmp53_;
						if (!_tmp59_) {
							break;
						}
						_tmp60_ = self->priv->current;
						self->priv->current = _tmp60_ + 1;
						_tmp61_ = len;
						len = _tmp61_ + 1;
					}
					type = VALA_TOKEN_TYPE_IDENTIFIER;
				}
			} else {
				gchar* _tmp62_ = NULL;
				gchar _tmp63_ = '\0';
				gboolean _tmp64_ = FALSE;
				_tmp62_ = self->priv->current;
				_tmp63_ = _tmp62_[0];
				_tmp64_ = g_ascii_isdigit (_tmp63_);
				if (_tmp64_) {
					ValaTokenType _tmp65_ = 0;
					_tmp65_ = vala_scanner_read_number (self);
					type = _tmp65_;
				} else {
					gchar* _tmp66_ = NULL;
					gchar _tmp67_ = '\0';
					_tmp66_ = self->priv->current;
					_tmp67_ = _tmp66_[0];
					switch (_tmp67_) {
						case '{':
						{
							gchar* _tmp68_ = NULL;
							ValaScannerState* _tmp69_ = NULL;
							gint _tmp69__length1 = 0;
							type = VALA_TOKEN_TYPE_OPEN_BRACE;
							_tmp68_ = self->priv->current;
							self->priv->current = _tmp68_ + 1;
							_tmp69_ = self->priv->state_stack;
							_tmp69__length1 = self->priv->state_stack_length1;
							_vala_array_add18 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_SCANNER_STATE_BRACE);
							break;
						}
						case '}':
						{
							gchar* _tmp70_ = NULL;
							ValaScannerState* _tmp71_ = NULL;
							gint _tmp71__length1 = 0;
							type = VALA_TOKEN_TYPE_CLOSE_BRACE;
							_tmp70_ = self->priv->current;
							self->priv->current = _tmp70_ + 1;
							_tmp71_ = self->priv->state_stack;
							_tmp71__length1 = self->priv->state_stack_length1;
							if (_tmp71__length1 > 0) {
								gint _tmp72_ = 0;
								_tmp72_ = self->priv->state_stack_length1;
								self->priv->state_stack_length1 = _tmp72_ - 1;
							}
							break;
						}
						case '(':
						{
							gchar* _tmp73_ = NULL;
							ValaScannerState* _tmp74_ = NULL;
							gint _tmp74__length1 = 0;
							type = VALA_TOKEN_TYPE_OPEN_PARENS;
							_tmp73_ = self->priv->current;
							self->priv->current = _tmp73_ + 1;
							_tmp74_ = self->priv->state_stack;
							_tmp74__length1 = self->priv->state_stack_length1;
							_vala_array_add19 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_SCANNER_STATE_PARENS);
							break;
						}
						case ')':
						{
							gchar* _tmp75_ = NULL;
							ValaScannerState* _tmp76_ = NULL;
							gint _tmp76__length1 = 0;
							gboolean _tmp78_ = FALSE;
							type = VALA_TOKEN_TYPE_CLOSE_PARENS;
							_tmp75_ = self->priv->current;
							self->priv->current = _tmp75_ + 1;
							_tmp76_ = self->priv->state_stack;
							_tmp76__length1 = self->priv->state_stack_length1;
							if (_tmp76__length1 > 0) {
								gint _tmp77_ = 0;
								_tmp77_ = self->priv->state_stack_length1;
								self->priv->state_stack_length1 = _tmp77_ - 1;
							}
							_tmp78_ = vala_scanner_in_template (self);
							if (_tmp78_) {
								type = VALA_TOKEN_TYPE_COMMA;
							}
							break;
						}
						case '[':
						{
							gchar* _tmp79_ = NULL;
							ValaScannerState* _tmp80_ = NULL;
							gint _tmp80__length1 = 0;
							type = VALA_TOKEN_TYPE_OPEN_BRACKET;
							_tmp79_ = self->priv->current;
							self->priv->current = _tmp79_ + 1;
							_tmp80_ = self->priv->state_stack;
							_tmp80__length1 = self->priv->state_stack_length1;
							_vala_array_add20 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_SCANNER_STATE_BRACKET);
							break;
						}
						case ']':
						{
							gchar* _tmp81_ = NULL;
							ValaScannerState* _tmp82_ = NULL;
							gint _tmp82__length1 = 0;
							type = VALA_TOKEN_TYPE_CLOSE_BRACKET;
							_tmp81_ = self->priv->current;
							self->priv->current = _tmp81_ + 1;
							_tmp82_ = self->priv->state_stack;
							_tmp82__length1 = self->priv->state_stack_length1;
							if (_tmp82__length1 > 0) {
								gint _tmp83_ = 0;
								_tmp83_ = self->priv->state_stack_length1;
								self->priv->state_stack_length1 = _tmp83_ - 1;
							}
							break;
						}
						case '.':
						{
							gchar* _tmp84_ = NULL;
							gchar* _tmp85_ = NULL;
							gchar* _tmp86_ = NULL;
							type = VALA_TOKEN_TYPE_DOT;
							_tmp84_ = self->priv->current;
							self->priv->current = _tmp84_ + 1;
							_tmp85_ = self->priv->current;
							_tmp86_ = self->priv->end;
							if (_tmp85_ < (_tmp86_ - 1)) {
								gboolean _tmp87_ = FALSE;
								gchar* _tmp88_ = NULL;
								gchar _tmp89_ = '\0';
								gboolean _tmp92_ = FALSE;
								_tmp88_ = self->priv->current;
								_tmp89_ = _tmp88_[0];
								if (_tmp89_ == '.') {
									gchar* _tmp90_ = NULL;
									gchar _tmp91_ = '\0';
									_tmp90_ = self->priv->current;
									_tmp91_ = _tmp90_[1];
									_tmp87_ = _tmp91_ == '.';
								} else {
									_tmp87_ = FALSE;
								}
								_tmp92_ = _tmp87_;
								if (_tmp92_) {
									gchar* _tmp93_ = NULL;
									type = VALA_TOKEN_TYPE_ELLIPSIS;
									_tmp93_ = self->priv->current;
									self->priv->current = _tmp93_ + 2;
								}
							}
							break;
						}
						case ':':
						{
							gchar* _tmp94_ = NULL;
							gboolean _tmp95_ = FALSE;
							gchar* _tmp96_ = NULL;
							gchar* _tmp97_ = NULL;
							gboolean _tmp100_ = FALSE;
							type = VALA_TOKEN_TYPE_COLON;
							_tmp94_ = self->priv->current;
							self->priv->current = _tmp94_ + 1;
							_tmp96_ = self->priv->current;
							_tmp97_ = self->priv->end;
							if (_tmp96_ < _tmp97_) {
								gchar* _tmp98_ = NULL;
								gchar _tmp99_ = '\0';
								_tmp98_ = self->priv->current;
								_tmp99_ = _tmp98_[0];
								_tmp95_ = _tmp99_ == ':';
							} else {
								_tmp95_ = FALSE;
							}
							_tmp100_ = _tmp95_;
							if (_tmp100_) {
								gchar* _tmp101_ = NULL;
								type = VALA_TOKEN_TYPE_DOUBLE_COLON;
								_tmp101_ = self->priv->current;
								self->priv->current = _tmp101_ + 1;
							}
							break;
						}
						case ',':
						{
							gchar* _tmp102_ = NULL;
							type = VALA_TOKEN_TYPE_COMMA;
							_tmp102_ = self->priv->current;
							self->priv->current = _tmp102_ + 1;
							break;
						}
						case ';':
						{
							gchar* _tmp103_ = NULL;
							type = VALA_TOKEN_TYPE_SEMICOLON;
							_tmp103_ = self->priv->current;
							self->priv->current = _tmp103_ + 1;
							break;
						}
						case '#':
						{
							gchar* _tmp104_ = NULL;
							type = VALA_TOKEN_TYPE_HASH;
							_tmp104_ = self->priv->current;
							self->priv->current = _tmp104_ + 1;
							break;
						}
						case '?':
						{
							gchar* _tmp105_ = NULL;
							gboolean _tmp106_ = FALSE;
							gchar* _tmp107_ = NULL;
							gchar* _tmp108_ = NULL;
							gboolean _tmp111_ = FALSE;
							type = VALA_TOKEN_TYPE_INTERR;
							_tmp105_ = self->priv->current;
							self->priv->current = _tmp105_ + 1;
							_tmp107_ = self->priv->current;
							_tmp108_ = self->priv->end;
							if (_tmp107_ < _tmp108_) {
								gchar* _tmp109_ = NULL;
								gchar _tmp110_ = '\0';
								_tmp109_ = self->priv->current;
								_tmp110_ = _tmp109_[0];
								_tmp106_ = _tmp110_ == '?';
							} else {
								_tmp106_ = FALSE;
							}
							_tmp111_ = _tmp106_;
							if (_tmp111_) {
								gchar* _tmp112_ = NULL;
								type = VALA_TOKEN_TYPE_OP_COALESCING;
								_tmp112_ = self->priv->current;
								self->priv->current = _tmp112_ + 1;
							}
							break;
						}
						case '|':
						{
							gchar* _tmp113_ = NULL;
							gchar* _tmp114_ = NULL;
							gchar* _tmp115_ = NULL;
							type = VALA_TOKEN_TYPE_BITWISE_OR;
							_tmp113_ = self->priv->current;
							self->priv->current = _tmp113_ + 1;
							_tmp114_ = self->priv->current;
							_tmp115_ = self->priv->end;
							if (_tmp114_ < _tmp115_) {
								gchar* _tmp116_ = NULL;
								gchar _tmp117_ = '\0';
								_tmp116_ = self->priv->current;
								_tmp117_ = _tmp116_[0];
								switch (_tmp117_) {
									case '=':
									{
										gchar* _tmp118_ = NULL;
										type = VALA_TOKEN_TYPE_ASSIGN_BITWISE_OR;
										_tmp118_ = self->priv->current;
										self->priv->current = _tmp118_ + 1;
										break;
									}
									case '|':
									{
										gchar* _tmp119_ = NULL;
										type = VALA_TOKEN_TYPE_OP_OR;
										_tmp119_ = self->priv->current;
										self->priv->current = _tmp119_ + 1;
										break;
									}
									default:
									break;
								}
							}
							break;
						}
						case '&':
						{
							gchar* _tmp120_ = NULL;
							gchar* _tmp121_ = NULL;
							gchar* _tmp122_ = NULL;
							type = VALA_TOKEN_TYPE_BITWISE_AND;
							_tmp120_ = self->priv->current;
							self->priv->current = _tmp120_ + 1;
							_tmp121_ = self->priv->current;
							_tmp122_ = self->priv->end;
							if (_tmp121_ < _tmp122_) {
								gchar* _tmp123_ = NULL;
								gchar _tmp124_ = '\0';
								_tmp123_ = self->priv->current;
								_tmp124_ = _tmp123_[0];
								switch (_tmp124_) {
									case '=':
									{
										gchar* _tmp125_ = NULL;
										type = VALA_TOKEN_TYPE_ASSIGN_BITWISE_AND;
										_tmp125_ = self->priv->current;
										self->priv->current = _tmp125_ + 1;
										break;
									}
									case '&':
									{
										gchar* _tmp126_ = NULL;
										type = VALA_TOKEN_TYPE_OP_AND;
										_tmp126_ = self->priv->current;
										self->priv->current = _tmp126_ + 1;
										break;
									}
									default:
									break;
								}
							}
							break;
						}
						case '^':
						{
							gchar* _tmp127_ = NULL;
							gboolean _tmp128_ = FALSE;
							gchar* _tmp129_ = NULL;
							gchar* _tmp130_ = NULL;
							gboolean _tmp133_ = FALSE;
							type = VALA_TOKEN_TYPE_CARRET;
							_tmp127_ = self->priv->current;
							self->priv->current = _tmp127_ + 1;
							_tmp129_ = self->priv->current;
							_tmp130_ = self->priv->end;
							if (_tmp129_ < _tmp130_) {
								gchar* _tmp131_ = NULL;
								gchar _tmp132_ = '\0';
								_tmp131_ = self->priv->current;
								_tmp132_ = _tmp131_[0];
								_tmp128_ = _tmp132_ == '=';
							} else {
								_tmp128_ = FALSE;
							}
							_tmp133_ = _tmp128_;
							if (_tmp133_) {
								gchar* _tmp134_ = NULL;
								type = VALA_TOKEN_TYPE_ASSIGN_BITWISE_XOR;
								_tmp134_ = self->priv->current;
								self->priv->current = _tmp134_ + 1;
							}
							break;
						}
						case '~':
						{
							gchar* _tmp135_ = NULL;
							type = VALA_TOKEN_TYPE_TILDE;
							_tmp135_ = self->priv->current;
							self->priv->current = _tmp135_ + 1;
							break;
						}
						case '=':
						{
							gchar* _tmp136_ = NULL;
							gchar* _tmp137_ = NULL;
							gchar* _tmp138_ = NULL;
							type = VALA_TOKEN_TYPE_ASSIGN;
							_tmp136_ = self->priv->current;
							self->priv->current = _tmp136_ + 1;
							_tmp137_ = self->priv->current;
							_tmp138_ = self->priv->end;
							if (_tmp137_ < _tmp138_) {
								gchar* _tmp139_ = NULL;
								gchar _tmp140_ = '\0';
								_tmp139_ = self->priv->current;
								_tmp140_ = _tmp139_[0];
								switch (_tmp140_) {
									case '=':
									{
										gchar* _tmp141_ = NULL;
										type = VALA_TOKEN_TYPE_OP_EQ;
										_tmp141_ = self->priv->current;
										self->priv->current = _tmp141_ + 1;
										break;
									}
									case '>':
									{
										gchar* _tmp142_ = NULL;
										type = VALA_TOKEN_TYPE_LAMBDA;
										_tmp142_ = self->priv->current;
										self->priv->current = _tmp142_ + 1;
										break;
									}
									default:
									break;
								}
							}
							break;
						}
						case '<':
						{
							gchar* _tmp143_ = NULL;
							gchar* _tmp144_ = NULL;
							gchar* _tmp145_ = NULL;
							type = VALA_TOKEN_TYPE_OP_LT;
							_tmp143_ = self->priv->current;
							self->priv->current = _tmp143_ + 1;
							_tmp144_ = self->priv->current;
							_tmp145_ = self->priv->end;
							if (_tmp144_ < _tmp145_) {
								gchar* _tmp146_ = NULL;
								gchar _tmp147_ = '\0';
								_tmp146_ = self->priv->current;
								_tmp147_ = _tmp146_[0];
								switch (_tmp147_) {
									case '=':
									{
										gchar* _tmp148_ = NULL;
										type = VALA_TOKEN_TYPE_OP_LE;
										_tmp148_ = self->priv->current;
										self->priv->current = _tmp148_ + 1;
										break;
									}
									case '<':
									{
										gchar* _tmp149_ = NULL;
										gboolean _tmp150_ = FALSE;
										gchar* _tmp151_ = NULL;
										gchar* _tmp152_ = NULL;
										gboolean _tmp155_ = FALSE;
										type = VALA_TOKEN_TYPE_OP_SHIFT_LEFT;
										_tmp149_ = self->priv->current;
										self->priv->current = _tmp149_ + 1;
										_tmp151_ = self->priv->current;
										_tmp152_ = self->priv->end;
										if (_tmp151_ < _tmp152_) {
											gchar* _tmp153_ = NULL;
											gchar _tmp154_ = '\0';
											_tmp153_ = self->priv->current;
											_tmp154_ = _tmp153_[0];
											_tmp150_ = _tmp154_ == '=';
										} else {
											_tmp150_ = FALSE;
										}
										_tmp155_ = _tmp150_;
										if (_tmp155_) {
											gchar* _tmp156_ = NULL;
											type = VALA_TOKEN_TYPE_ASSIGN_SHIFT_LEFT;
											_tmp156_ = self->priv->current;
											self->priv->current = _tmp156_ + 1;
										}
										break;
									}
									default:
									break;
								}
							}
							break;
						}
						case '>':
						{
							gchar* _tmp157_ = NULL;
							gboolean _tmp158_ = FALSE;
							gchar* _tmp159_ = NULL;
							gchar* _tmp160_ = NULL;
							gboolean _tmp163_ = FALSE;
							type = VALA_TOKEN_TYPE_OP_GT;
							_tmp157_ = self->priv->current;
							self->priv->current = _tmp157_ + 1;
							_tmp159_ = self->priv->current;
							_tmp160_ = self->priv->end;
							if (_tmp159_ < _tmp160_) {
								gchar* _tmp161_ = NULL;
								gchar _tmp162_ = '\0';
								_tmp161_ = self->priv->current;
								_tmp162_ = _tmp161_[0];
								_tmp158_ = _tmp162_ == '=';
							} else {
								_tmp158_ = FALSE;
							}
							_tmp163_ = _tmp158_;
							if (_tmp163_) {
								gchar* _tmp164_ = NULL;
								type = VALA_TOKEN_TYPE_OP_GE;
								_tmp164_ = self->priv->current;
								self->priv->current = _tmp164_ + 1;
							}
							break;
						}
						case '!':
						{
							gchar* _tmp165_ = NULL;
							gboolean _tmp166_ = FALSE;
							gchar* _tmp167_ = NULL;
							gchar* _tmp168_ = NULL;
							gboolean _tmp171_ = FALSE;
							type = VALA_TOKEN_TYPE_OP_NEG;
							_tmp165_ = self->priv->current;
							self->priv->current = _tmp165_ + 1;
							_tmp167_ = self->priv->current;
							_tmp168_ = self->priv->end;
							if (_tmp167_ < _tmp168_) {
								gchar* _tmp169_ = NULL;
								gchar _tmp170_ = '\0';
								_tmp169_ = self->priv->current;
								_tmp170_ = _tmp169_[0];
								_tmp166_ = _tmp170_ == '=';
							} else {
								_tmp166_ = FALSE;
							}
							_tmp171_ = _tmp166_;
							if (_tmp171_) {
								gchar* _tmp172_ = NULL;
								type = VALA_TOKEN_TYPE_OP_NE;
								_tmp172_ = self->priv->current;
								self->priv->current = _tmp172_ + 1;
							}
							break;
						}
						case '+':
						{
							gchar* _tmp173_ = NULL;
							gchar* _tmp174_ = NULL;
							gchar* _tmp175_ = NULL;
							type = VALA_TOKEN_TYPE_PLUS;
							_tmp173_ = self->priv->current;
							self->priv->current = _tmp173_ + 1;
							_tmp174_ = self->priv->current;
							_tmp175_ = self->priv->end;
							if (_tmp174_ < _tmp175_) {
								gchar* _tmp176_ = NULL;
								gchar _tmp177_ = '\0';
								_tmp176_ = self->priv->current;
								_tmp177_ = _tmp176_[0];
								switch (_tmp177_) {
									case '=':
									{
										gchar* _tmp178_ = NULL;
										type = VALA_TOKEN_TYPE_ASSIGN_ADD;
										_tmp178_ = self->priv->current;
										self->priv->current = _tmp178_ + 1;
										break;
									}
									case '+':
									{
										gchar* _tmp179_ = NULL;
										type = VALA_TOKEN_TYPE_OP_INC;
										_tmp179_ = self->priv->current;
										self->priv->current = _tmp179_ + 1;
										break;
									}
									default:
									break;
								}
							}
							break;
						}
						case '-':
						{
							gchar* _tmp180_ = NULL;
							gchar* _tmp181_ = NULL;
							gchar* _tmp182_ = NULL;
							type = VALA_TOKEN_TYPE_MINUS;
							_tmp180_ = self->priv->current;
							self->priv->current = _tmp180_ + 1;
							_tmp181_ = self->priv->current;
							_tmp182_ = self->priv->end;
							if (_tmp181_ < _tmp182_) {
								gchar* _tmp183_ = NULL;
								gchar _tmp184_ = '\0';
								_tmp183_ = self->priv->current;
								_tmp184_ = _tmp183_[0];
								switch (_tmp184_) {
									case '=':
									{
										gchar* _tmp185_ = NULL;
										type = VALA_TOKEN_TYPE_ASSIGN_SUB;
										_tmp185_ = self->priv->current;
										self->priv->current = _tmp185_ + 1;
										break;
									}
									case '-':
									{
										gchar* _tmp186_ = NULL;
										type = VALA_TOKEN_TYPE_OP_DEC;
										_tmp186_ = self->priv->current;
										self->priv->current = _tmp186_ + 1;
										break;
									}
									case '>':
									{
										gchar* _tmp187_ = NULL;
										type = VALA_TOKEN_TYPE_OP_PTR;
										_tmp187_ = self->priv->current;
										self->priv->current = _tmp187_ + 1;
										break;
									}
									default:
									break;
								}
							}
							break;
						}
						case '*':
						{
							gchar* _tmp188_ = NULL;
							gboolean _tmp189_ = FALSE;
							gchar* _tmp190_ = NULL;
							gchar* _tmp191_ = NULL;
							gboolean _tmp194_ = FALSE;
							type = VALA_TOKEN_TYPE_STAR;
							_tmp188_ = self->priv->current;
							self->priv->current = _tmp188_ + 1;
							_tmp190_ = self->priv->current;
							_tmp191_ = self->priv->end;
							if (_tmp190_ < _tmp191_) {
								gchar* _tmp192_ = NULL;
								gchar _tmp193_ = '\0';
								_tmp192_ = self->priv->current;
								_tmp193_ = _tmp192_[0];
								_tmp189_ = _tmp193_ == '=';
							} else {
								_tmp189_ = FALSE;
							}
							_tmp194_ = _tmp189_;
							if (_tmp194_) {
								gchar* _tmp195_ = NULL;
								type = VALA_TOKEN_TYPE_ASSIGN_MUL;
								_tmp195_ = self->priv->current;
								self->priv->current = _tmp195_ + 1;
							}
							break;
						}
						case '/':
						{
							ValaTokenType _tmp196_ = 0;
							_tmp196_ = self->priv->previous;
							switch (_tmp196_) {
								case VALA_TOKEN_TYPE_ASSIGN:
								case VALA_TOKEN_TYPE_COMMA:
								case VALA_TOKEN_TYPE_MINUS:
								case VALA_TOKEN_TYPE_OP_AND:
								case VALA_TOKEN_TYPE_OP_COALESCING:
								case VALA_TOKEN_TYPE_OP_EQ:
								case VALA_TOKEN_TYPE_OP_GE:
								case VALA_TOKEN_TYPE_OP_GT:
								case VALA_TOKEN_TYPE_OP_LE:
								case VALA_TOKEN_TYPE_OP_LT:
								case VALA_TOKEN_TYPE_OP_NE:
								case VALA_TOKEN_TYPE_OP_NEG:
								case VALA_TOKEN_TYPE_OP_OR:
								case VALA_TOKEN_TYPE_OPEN_BRACE:
								case VALA_TOKEN_TYPE_OPEN_PARENS:
								case VALA_TOKEN_TYPE_PLUS:
								case VALA_TOKEN_TYPE_RETURN:
								{
									ValaScannerState* _tmp197_ = NULL;
									gint _tmp197__length1 = 0;
									gchar* _tmp198_ = NULL;
									type = VALA_TOKEN_TYPE_OPEN_REGEX_LITERAL;
									_tmp197_ = self->priv->state_stack;
									_tmp197__length1 = self->priv->state_stack_length1;
									_vala_array_add21 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_SCANNER_STATE_REGEX_LITERAL);
									_tmp198_ = self->priv->current;
									self->priv->current = _tmp198_ + 1;
									break;
								}
								default:
								{
									gchar* _tmp199_ = NULL;
									gboolean _tmp200_ = FALSE;
									gchar* _tmp201_ = NULL;
									gchar* _tmp202_ = NULL;
									gboolean _tmp205_ = FALSE;
									type = VALA_TOKEN_TYPE_DIV;
									_tmp199_ = self->priv->current;
									self->priv->current = _tmp199_ + 1;
									_tmp201_ = self->priv->current;
									_tmp202_ = self->priv->end;
									if (_tmp201_ < _tmp202_) {
										gchar* _tmp203_ = NULL;
										gchar _tmp204_ = '\0';
										_tmp203_ = self->priv->current;
										_tmp204_ = _tmp203_[0];
										_tmp200_ = _tmp204_ == '=';
									} else {
										_tmp200_ = FALSE;
									}
									_tmp205_ = _tmp200_;
									if (_tmp205_) {
										gchar* _tmp206_ = NULL;
										type = VALA_TOKEN_TYPE_ASSIGN_DIV;
										_tmp206_ = self->priv->current;
										self->priv->current = _tmp206_ + 1;
									}
									break;
								}
							}
							break;
						}
						case '%':
						{
							gchar* _tmp207_ = NULL;
							gboolean _tmp208_ = FALSE;
							gchar* _tmp209_ = NULL;
							gchar* _tmp210_ = NULL;
							gboolean _tmp213_ = FALSE;
							type = VALA_TOKEN_TYPE_PERCENT;
							_tmp207_ = self->priv->current;
							self->priv->current = _tmp207_ + 1;
							_tmp209_ = self->priv->current;
							_tmp210_ = self->priv->end;
							if (_tmp209_ < _tmp210_) {
								gchar* _tmp211_ = NULL;
								gchar _tmp212_ = '\0';
								_tmp211_ = self->priv->current;
								_tmp212_ = _tmp211_[0];
								_tmp208_ = _tmp212_ == '=';
							} else {
								_tmp208_ = FALSE;
							}
							_tmp213_ = _tmp208_;
							if (_tmp213_) {
								gchar* _tmp214_ = NULL;
								type = VALA_TOKEN_TYPE_ASSIGN_PERCENT;
								_tmp214_ = self->priv->current;
								self->priv->current = _tmp214_ + 1;
							}
							break;
						}
						case '\'':
						case '"':
						{
							gchar* _tmp215_ = NULL;
							gchar _tmp216_ = '\0';
							gchar* _tmp274_ = NULL;
							gchar* _tmp365_ = NULL;
							gchar* _tmp366_ = NULL;
							_tmp215_ = begin;
							_tmp216_ = _tmp215_[0];
							if (_tmp216_ == '\'') {
								type = VALA_TOKEN_TYPE_CHARACTER_LITERAL;
							} else {
								gboolean _tmp217_ = FALSE;
								gboolean _tmp218_ = FALSE;
								gchar* _tmp219_ = NULL;
								gchar* _tmp220_ = NULL;
								gboolean _tmp223_ = FALSE;
								gboolean _tmp226_ = FALSE;
								_tmp219_ = self->priv->current;
								_tmp220_ = self->priv->end;
								if (_tmp219_ < (_tmp220_ - 6)) {
									gchar* _tmp221_ = NULL;
									gchar _tmp222_ = '\0';
									_tmp221_ = begin;
									_tmp222_ = _tmp221_[1];
									_tmp218_ = _tmp222_ == '"';
								} else {
									_tmp218_ = FALSE;
								}
								_tmp223_ = _tmp218_;
								if (_tmp223_) {
									gchar* _tmp224_ = NULL;
									gchar _tmp225_ = '\0';
									_tmp224_ = begin;
									_tmp225_ = _tmp224_[2];
									_tmp217_ = _tmp225_ == '"';
								} else {
									_tmp217_ = FALSE;
								}
								_tmp226_ = _tmp217_;
								if (_tmp226_) {
									gchar* _tmp227_ = NULL;
									gboolean _tmp260_ = FALSE;
									gboolean _tmp261_ = FALSE;
									gchar* _tmp262_ = NULL;
									gchar _tmp263_ = '\0';
									gboolean _tmp266_ = FALSE;
									gboolean _tmp269_ = FALSE;
									type = VALA_TOKEN_TYPE_VERBATIM_STRING_LITERAL;
									token_length_in_chars = 6;
									_tmp227_ = self->priv->current;
									self->priv->current = _tmp227_ + 3;
									while (TRUE) {
										gchar* _tmp228_ = NULL;
										gchar* _tmp229_ = NULL;
										gboolean _tmp230_ = FALSE;
										gboolean _tmp231_ = FALSE;
										gboolean _tmp232_ = FALSE;
										gchar* _tmp233_ = NULL;
										gchar _tmp234_ = '\0';
										gboolean _tmp237_ = FALSE;
										gboolean _tmp240_ = FALSE;
										gboolean _tmp243_ = FALSE;
										_tmp228_ = self->priv->current;
										_tmp229_ = self->priv->end;
										if (!(_tmp228_ < (_tmp229_ - 4))) {
											break;
										}
										_tmp233_ = self->priv->current;
										_tmp234_ = _tmp233_[0];
										if (_tmp234_ == '"') {
											gchar* _tmp235_ = NULL;
											gchar _tmp236_ = '\0';
											_tmp235_ = self->priv->current;
											_tmp236_ = _tmp235_[1];
											_tmp232_ = _tmp236_ == '"';
										} else {
											_tmp232_ = FALSE;
										}
										_tmp237_ = _tmp232_;
										if (_tmp237_) {
											gchar* _tmp238_ = NULL;
											gchar _tmp239_ = '\0';
											_tmp238_ = self->priv->current;
											_tmp239_ = _tmp238_[2];
											_tmp231_ = _tmp239_ == '"';
										} else {
											_tmp231_ = FALSE;
										}
										_tmp240_ = _tmp231_;
										if (_tmp240_) {
											gchar* _tmp241_ = NULL;
											gchar _tmp242_ = '\0';
											_tmp241_ = self->priv->current;
											_tmp242_ = _tmp241_[3];
											_tmp230_ = _tmp242_ != '"';
										} else {
											_tmp230_ = FALSE;
										}
										_tmp243_ = _tmp230_;
										if (_tmp243_) {
											break;
										} else {
											gchar* _tmp244_ = NULL;
											gchar _tmp245_ = '\0';
											_tmp244_ = self->priv->current;
											_tmp245_ = _tmp244_[0];
											if (_tmp245_ == '\n') {
												gchar* _tmp246_ = NULL;
												gint _tmp247_ = 0;
												_tmp246_ = self->priv->current;
												self->priv->current = _tmp246_ + 1;
												_tmp247_ = self->priv->line;
												self->priv->line = _tmp247_ + 1;
												self->priv->column = 1;
												token_length_in_chars = 3;
											} else {
												gunichar u = 0U;
												gchar* _tmp248_ = NULL;
												gchar* _tmp249_ = NULL;
												gchar* _tmp250_ = NULL;
												gunichar _tmp251_ = 0U;
												gunichar _tmp252_ = 0U;
												_tmp248_ = self->priv->current;
												_tmp249_ = self->priv->end;
												_tmp250_ = self->priv->current;
												_tmp251_ = g_utf8_get_char_validated ((const gchar*) _tmp248_, (gssize) ((glong) (_tmp249_ - _tmp250_)));
												u = _tmp251_;
												_tmp252_ = u;
												if (_tmp252_ != ((gunichar) (-1))) {
													gchar* _tmp253_ = NULL;
													gunichar _tmp254_ = 0U;
													gint _tmp255_ = 0;
													gint _tmp256_ = 0;
													_tmp253_ = self->priv->current;
													_tmp254_ = u;
													_tmp255_ = g_unichar_to_utf8 (_tmp254_, NULL);
													self->priv->current = _tmp253_ + _tmp255_;
													_tmp256_ = token_length_in_chars;
													token_length_in_chars = _tmp256_ + 1;
												} else {
													gint _tmp257_ = 0;
													ValaSourceReference* _tmp258_ = NULL;
													ValaSourceReference* _tmp259_ = NULL;
													_tmp257_ = token_length_in_chars;
													_tmp258_ = vala_scanner_get_source_reference (self, _tmp257_, 0);
													_tmp259_ = _tmp258_;
													vala_report_error (_tmp259_, "invalid UTF-8 character");
													_vala_source_reference_unref0 (_tmp259_);
												}
											}
										}
									}
									_tmp262_ = self->priv->current;
									_tmp263_ = _tmp262_[0];
									if (_tmp263_ == '"') {
										gchar* _tmp264_ = NULL;
										gchar _tmp265_ = '\0';
										_tmp264_ = self->priv->current;
										_tmp265_ = _tmp264_[1];
										_tmp261_ = _tmp265_ == '"';
									} else {
										_tmp261_ = FALSE;
									}
									_tmp266_ = _tmp261_;
									if (_tmp266_) {
										gchar* _tmp267_ = NULL;
										gchar _tmp268_ = '\0';
										_tmp267_ = self->priv->current;
										_tmp268_ = _tmp267_[2];
										_tmp260_ = _tmp268_ == '"';
									} else {
										_tmp260_ = FALSE;
									}
									_tmp269_ = _tmp260_;
									if (_tmp269_) {
										gchar* _tmp270_ = NULL;
										_tmp270_ = self->priv->current;
										self->priv->current = _tmp270_ + 3;
									} else {
										gint _tmp271_ = 0;
										ValaSourceReference* _tmp272_ = NULL;
										ValaSourceReference* _tmp273_ = NULL;
										_tmp271_ = token_length_in_chars;
										_tmp272_ = vala_scanner_get_source_reference (self, _tmp271_, 0);
										_tmp273_ = _tmp272_;
										vala_report_error (_tmp273_, "syntax error, expected \"\"\"");
										_vala_source_reference_unref0 (_tmp273_);
									}
									break;
								} else {
									type = VALA_TOKEN_TYPE_STRING_LITERAL;
								}
							}
							token_length_in_chars = 2;
							_tmp274_ = self->priv->current;
							self->priv->current = _tmp274_ + 1;
							while (TRUE) {
								gboolean _tmp275_ = FALSE;
								gchar* _tmp276_ = NULL;
								gchar* _tmp277_ = NULL;
								gboolean _tmp282_ = FALSE;
								gchar* _tmp283_ = NULL;
								gchar _tmp284_ = '\0';
								gboolean _tmp352_ = FALSE;
								gboolean _tmp353_ = FALSE;
								gchar* _tmp354_ = NULL;
								gchar* _tmp355_ = NULL;
								gboolean _tmp358_ = FALSE;
								gboolean _tmp361_ = FALSE;
								_tmp276_ = self->priv->current;
								_tmp277_ = self->priv->end;
								if (_tmp276_ < _tmp277_) {
									gchar* _tmp278_ = NULL;
									gchar _tmp279_ = '\0';
									gchar* _tmp280_ = NULL;
									gchar _tmp281_ = '\0';
									_tmp278_ = self->priv->current;
									_tmp279_ = _tmp278_[0];
									_tmp280_ = begin;
									_tmp281_ = _tmp280_[0];
									_tmp275_ = _tmp279_ != _tmp281_;
								} else {
									_tmp275_ = FALSE;
								}
								_tmp282_ = _tmp275_;
								if (!_tmp282_) {
									break;
								}
								_tmp283_ = self->priv->current;
								_tmp284_ = _tmp283_[0];
								if (_tmp284_ == '\\') {
									gchar* _tmp285_ = NULL;
									gint _tmp286_ = 0;
									gchar* _tmp287_ = NULL;
									gchar* _tmp288_ = NULL;
									gchar* _tmp289_ = NULL;
									gchar _tmp290_ = '\0';
									_tmp285_ = self->priv->current;
									self->priv->current = _tmp285_ + 1;
									_tmp286_ = token_length_in_chars;
									token_length_in_chars = _tmp286_ + 1;
									_tmp287_ = self->priv->current;
									_tmp288_ = self->priv->end;
									if (_tmp287_ >= _tmp288_) {
										break;
									}
									_tmp289_ = self->priv->current;
									_tmp290_ = _tmp289_[0];
									switch (_tmp290_) {
										case '\'':
										case '"':
										case '\\':
										case '0':
										case 'b':
										case 'f':
										case 'n':
										case 'r':
										case 't':
										case '$':
										{
											gchar* _tmp291_ = NULL;
											gint _tmp292_ = 0;
											_tmp291_ = self->priv->current;
											self->priv->current = _tmp291_ + 1;
											_tmp292_ = token_length_in_chars;
											token_length_in_chars = _tmp292_ + 1;
											break;
										}
										case 'u':
										{
											gchar* _tmp293_ = NULL;
											gint _tmp294_ = 0;
											gint digit_length = 0;
											gint _tmp310_ = 0;
											_tmp293_ = self->priv->current;
											self->priv->current = _tmp293_ + 1;
											_tmp294_ = token_length_in_chars;
											token_length_in_chars = _tmp294_ + 1;
											{
												gboolean _tmp295_ = FALSE;
												digit_length = 0;
												_tmp295_ = TRUE;
												while (TRUE) {
													gboolean _tmp296_ = FALSE;
													gboolean _tmp298_ = FALSE;
													gboolean _tmp299_ = FALSE;
													gint _tmp300_ = 0;
													gboolean _tmp303_ = FALSE;
													gboolean _tmp307_ = FALSE;
													gchar* _tmp308_ = NULL;
													gint _tmp309_ = 0;
													_tmp296_ = _tmp295_;
													if (!_tmp296_) {
														gint _tmp297_ = 0;
														_tmp297_ = digit_length;
														digit_length = _tmp297_ + 1;
													}
													_tmp295_ = FALSE;
													_tmp300_ = digit_length;
													if (_tmp300_ < 4) {
														gchar* _tmp301_ = NULL;
														gchar* _tmp302_ = NULL;
														_tmp301_ = self->priv->current;
														_tmp302_ = self->priv->end;
														_tmp299_ = _tmp301_ < _tmp302_;
													} else {
														_tmp299_ = FALSE;
													}
													_tmp303_ = _tmp299_;
													if (_tmp303_) {
														gchar* _tmp304_ = NULL;
														gchar _tmp305_ = '\0';
														gboolean _tmp306_ = FALSE;
														_tmp304_ = self->priv->current;
														_tmp305_ = _tmp304_[0];
														_tmp306_ = g_ascii_isxdigit (_tmp305_);
														_tmp298_ = _tmp306_;
													} else {
														_tmp298_ = FALSE;
													}
													_tmp307_ = _tmp298_;
													if (!_tmp307_) {
														break;
													}
													_tmp308_ = self->priv->current;
													self->priv->current = _tmp308_ + 1;
													_tmp309_ = token_length_in_chars;
													token_length_in_chars = _tmp309_ + 1;
												}
											}
											_tmp310_ = digit_length;
											if (_tmp310_ != 4) {
												gint _tmp311_ = 0;
												ValaSourceReference* _tmp312_ = NULL;
												ValaSourceReference* _tmp313_ = NULL;
												_tmp311_ = token_length_in_chars;
												_tmp312_ = vala_scanner_get_source_reference (self, _tmp311_, 0);
												_tmp313_ = _tmp312_;
												vala_report_error (_tmp313_, "\\u requires four hex digits");
												_vala_source_reference_unref0 (_tmp313_);
											}
											break;
										}
										case 'x':
										{
											gchar* _tmp314_ = NULL;
											gint _tmp315_ = 0;
											gint digit_length = 0;
											gint _tmp328_ = 0;
											_tmp314_ = self->priv->current;
											self->priv->current = _tmp314_ + 1;
											_tmp315_ = token_length_in_chars;
											token_length_in_chars = _tmp315_ + 1;
											{
												gboolean _tmp316_ = FALSE;
												digit_length = 0;
												_tmp316_ = TRUE;
												while (TRUE) {
													gboolean _tmp317_ = FALSE;
													gboolean _tmp319_ = FALSE;
													gchar* _tmp320_ = NULL;
													gchar* _tmp321_ = NULL;
													gboolean _tmp325_ = FALSE;
													gchar* _tmp326_ = NULL;
													gint _tmp327_ = 0;
													_tmp317_ = _tmp316_;
													if (!_tmp317_) {
														gint _tmp318_ = 0;
														_tmp318_ = digit_length;
														digit_length = _tmp318_ + 1;
													}
													_tmp316_ = FALSE;
													_tmp320_ = self->priv->current;
													_tmp321_ = self->priv->end;
													if (_tmp320_ < _tmp321_) {
														gchar* _tmp322_ = NULL;
														gchar _tmp323_ = '\0';
														gboolean _tmp324_ = FALSE;
														_tmp322_ = self->priv->current;
														_tmp323_ = _tmp322_[0];
														_tmp324_ = g_ascii_isxdigit (_tmp323_);
														_tmp319_ = _tmp324_;
													} else {
														_tmp319_ = FALSE;
													}
													_tmp325_ = _tmp319_;
													if (!_tmp325_) {
														break;
													}
													_tmp326_ = self->priv->current;
													self->priv->current = _tmp326_ + 1;
													_tmp327_ = token_length_in_chars;
													token_length_in_chars = _tmp327_ + 1;
												}
											}
											_tmp328_ = digit_length;
											if (_tmp328_ < 1) {
												gint _tmp329_ = 0;
												ValaSourceReference* _tmp330_ = NULL;
												ValaSourceReference* _tmp331_ = NULL;
												_tmp329_ = token_length_in_chars;
												_tmp330_ = vala_scanner_get_source_reference (self, _tmp329_, 0);
												_tmp331_ = _tmp330_;
												vala_report_error (_tmp331_, "\\x requires at least one hex digit");
												_vala_source_reference_unref0 (_tmp331_);
											}
											break;
										}
										default:
										{
											gint _tmp332_ = 0;
											ValaSourceReference* _tmp333_ = NULL;
											ValaSourceReference* _tmp334_ = NULL;
											_tmp332_ = token_length_in_chars;
											_tmp333_ = vala_scanner_get_source_reference (self, _tmp332_, 0);
											_tmp334_ = _tmp333_;
											vala_report_error (_tmp334_, "invalid escape sequence");
											_vala_source_reference_unref0 (_tmp334_);
											break;
										}
									}
								} else {
									gchar* _tmp335_ = NULL;
									gchar _tmp336_ = '\0';
									_tmp335_ = self->priv->current;
									_tmp336_ = _tmp335_[0];
									if (_tmp336_ == '\n') {
										gchar* _tmp337_ = NULL;
										gint _tmp338_ = 0;
										_tmp337_ = self->priv->current;
										self->priv->current = _tmp337_ + 1;
										_tmp338_ = self->priv->line;
										self->priv->line = _tmp338_ + 1;
										self->priv->column = 1;
										token_length_in_chars = 1;
									} else {
										gunichar u = 0U;
										gchar* _tmp339_ = NULL;
										gchar* _tmp340_ = NULL;
										gchar* _tmp341_ = NULL;
										gunichar _tmp342_ = 0U;
										gunichar _tmp343_ = 0U;
										_tmp339_ = self->priv->current;
										_tmp340_ = self->priv->end;
										_tmp341_ = self->priv->current;
										_tmp342_ = g_utf8_get_char_validated ((const gchar*) _tmp339_, (gssize) ((glong) (_tmp340_ - _tmp341_)));
										u = _tmp342_;
										_tmp343_ = u;
										if (_tmp343_ != ((gunichar) (-1))) {
											gchar* _tmp344_ = NULL;
											gunichar _tmp345_ = 0U;
											gint _tmp346_ = 0;
											gint _tmp347_ = 0;
											_tmp344_ = self->priv->current;
											_tmp345_ = u;
											_tmp346_ = g_unichar_to_utf8 (_tmp345_, NULL);
											self->priv->current = _tmp344_ + _tmp346_;
											_tmp347_ = token_length_in_chars;
											token_length_in_chars = _tmp347_ + 1;
										} else {
											gchar* _tmp348_ = NULL;
											gint _tmp349_ = 0;
											ValaSourceReference* _tmp350_ = NULL;
											ValaSourceReference* _tmp351_ = NULL;
											_tmp348_ = self->priv->current;
											self->priv->current = _tmp348_ + 1;
											_tmp349_ = token_length_in_chars;
											_tmp350_ = vala_scanner_get_source_reference (self, _tmp349_, 0);
											_tmp351_ = _tmp350_;
											vala_report_error (_tmp351_, "invalid UTF-8 character");
											_vala_source_reference_unref0 (_tmp351_);
										}
									}
								}
								_tmp354_ = self->priv->current;
								_tmp355_ = self->priv->end;
								if (_tmp354_ < _tmp355_) {
									gchar* _tmp356_ = NULL;
									gchar _tmp357_ = '\0';
									_tmp356_ = begin;
									_tmp357_ = _tmp356_[0];
									_tmp353_ = _tmp357_ == '\'';
								} else {
									_tmp353_ = FALSE;
								}
								_tmp358_ = _tmp353_;
								if (_tmp358_) {
									gchar* _tmp359_ = NULL;
									gchar _tmp360_ = '\0';
									_tmp359_ = self->priv->current;
									_tmp360_ = _tmp359_[0];
									_tmp352_ = _tmp360_ != '\'';
								} else {
									_tmp352_ = FALSE;
								}
								_tmp361_ = _tmp352_;
								if (_tmp361_) {
									gint _tmp362_ = 0;
									ValaSourceReference* _tmp363_ = NULL;
									ValaSourceReference* _tmp364_ = NULL;
									_tmp362_ = token_length_in_chars;
									_tmp363_ = vala_scanner_get_source_reference (self, _tmp362_, 0);
									_tmp364_ = _tmp363_;
									vala_report_error (_tmp364_, "invalid character literal");
									_vala_source_reference_unref0 (_tmp364_);
								}
							}
							_tmp365_ = self->priv->current;
							_tmp366_ = self->priv->end;
							if (_tmp365_ < _tmp366_) {
								gchar* _tmp367_ = NULL;
								_tmp367_ = self->priv->current;
								self->priv->current = _tmp367_ + 1;
							} else {
								gint _tmp368_ = 0;
								ValaSourceReference* _tmp369_ = NULL;
								ValaSourceReference* _tmp370_ = NULL;
								gchar* _tmp371_ = NULL;
								gchar _tmp372_ = '\0';
								gchar* _tmp373_ = NULL;
								gchar* _tmp374_ = NULL;
								_tmp368_ = token_length_in_chars;
								_tmp369_ = vala_scanner_get_source_reference (self, _tmp368_, 0);
								_tmp370_ = _tmp369_;
								_tmp371_ = begin;
								_tmp372_ = _tmp371_[0];
								_tmp373_ = g_strdup_printf ("syntax error, expected %c", (gint) _tmp372_);
								_tmp374_ = _tmp373_;
								vala_report_error (_tmp370_, _tmp374_);
								_g_free0 (_tmp374_);
								_vala_source_reference_unref0 (_tmp370_);
							}
							break;
						}
						default:
						{
							gunichar u = 0U;
							gchar* _tmp375_ = NULL;
							gchar* _tmp376_ = NULL;
							gchar* _tmp377_ = NULL;
							gunichar _tmp378_ = 0U;
							gunichar _tmp379_ = 0U;
							gint _tmp388_ = 0;
							ValaSourceLocation _tmp389_ = {0};
							ValaSourceLocation _tmp390_ = {0};
							ValaTokenType _tmp391_ = 0;
							_tmp375_ = self->priv->current;
							_tmp376_ = self->priv->end;
							_tmp377_ = self->priv->current;
							_tmp378_ = g_utf8_get_char_validated ((const gchar*) _tmp375_, (gssize) ((glong) (_tmp376_ - _tmp377_)));
							u = _tmp378_;
							_tmp379_ = u;
							if (_tmp379_ != ((gunichar) (-1))) {
								gchar* _tmp380_ = NULL;
								gunichar _tmp381_ = 0U;
								gint _tmp382_ = 0;
								ValaSourceReference* _tmp383_ = NULL;
								ValaSourceReference* _tmp384_ = NULL;
								_tmp380_ = self->priv->current;
								_tmp381_ = u;
								_tmp382_ = g_unichar_to_utf8 (_tmp381_, NULL);
								self->priv->current = _tmp380_ + _tmp382_;
								_tmp383_ = vala_scanner_get_source_reference (self, 0, 0);
								_tmp384_ = _tmp383_;
								vala_report_error (_tmp384_, "syntax error, unexpected character");
								_vala_source_reference_unref0 (_tmp384_);
							} else {
								gchar* _tmp385_ = NULL;
								ValaSourceReference* _tmp386_ = NULL;
								ValaSourceReference* _tmp387_ = NULL;
								_tmp385_ = self->priv->current;
								self->priv->current = _tmp385_ + 1;
								_tmp386_ = vala_scanner_get_source_reference (self, 0, 0);
								_tmp387_ = _tmp386_;
								vala_report_error (_tmp387_, "invalid UTF-8 character");
								_vala_source_reference_unref0 (_tmp387_);
							}
							_tmp388_ = self->priv->column;
							self->priv->column = _tmp388_ + 1;
							_tmp391_ = vala_scanner_read_token (self, &_tmp389_, &_tmp390_);
							_vala_token_begin = _tmp389_;
							_vala_token_end = _tmp390_;
							result = _tmp391_;
							if (token_begin) {
								*token_begin = _vala_token_begin;
							}
							if (token_end) {
								*token_end = _vala_token_end;
							}
							return result;
						}
					}
				}
			}
		}
	}
	_tmp392_ = token_length_in_chars;
	if (_tmp392_ < 0) {
		gint _tmp393_ = 0;
		gchar* _tmp394_ = NULL;
		gchar* _tmp395_ = NULL;
		_tmp393_ = self->priv->column;
		_tmp394_ = self->priv->current;
		_tmp395_ = begin;
		self->priv->column = _tmp393_ + ((gint) (_tmp394_ - _tmp395_));
	} else {
		gint _tmp396_ = 0;
		gint _tmp397_ = 0;
		_tmp396_ = self->priv->column;
		_tmp397_ = token_length_in_chars;
		self->priv->column = _tmp396_ + _tmp397_;
	}
	_tmp398_ = self->priv->current;
	_tmp399_ = self->priv->line;
	_tmp400_ = self->priv->column;
	vala_source_location_init (&_vala_token_end, _tmp398_, _tmp399_, _tmp400_ - 1);
	_tmp401_ = type;
	self->priv->previous = _tmp401_;
	result = type;
	if (token_begin) {
		*token_begin = _vala_token_begin;
	}
	if (token_end) {
		*token_end = _vala_token_end;
	}
	return result;
}


static gboolean vala_scanner_matches (gchar* begin, const gchar* keyword) {
	gboolean result = FALSE;
	gchar* keyword_array = NULL;
	const gchar* _tmp0_ = NULL;
	glong len = 0L;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	g_return_val_if_fail (keyword != NULL, FALSE);
	_tmp0_ = keyword;
	keyword_array = (gchar*) _tmp0_;
	_tmp1_ = keyword;
	_tmp2_ = strlen (_tmp1_);
	_tmp3_ = _tmp2_;
	len = (glong) _tmp3_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp5_ = FALSE;
				gint _tmp7_ = 0;
				glong _tmp8_ = 0L;
				gchar* _tmp9_ = NULL;
				gint _tmp10_ = 0;
				gchar _tmp11_ = '\0';
				gchar* _tmp12_ = NULL;
				gint _tmp13_ = 0;
				gchar _tmp14_ = '\0';
				_tmp5_ = _tmp4_;
				if (!_tmp5_) {
					gint _tmp6_ = 0;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp7_ = i;
				_tmp8_ = len;
				if (!(((glong) _tmp7_) < _tmp8_)) {
					break;
				}
				_tmp9_ = begin;
				_tmp10_ = i;
				_tmp11_ = _tmp9_[_tmp10_];
				_tmp12_ = keyword_array;
				_tmp13_ = i;
				_tmp14_ = _tmp12_[_tmp13_];
				if (_tmp11_ != _tmp14_) {
					result = FALSE;
					return result;
				}
			}
		}
	}
	result = TRUE;
	return result;
}


static gboolean vala_scanner_pp_whitespace (ValaScanner* self) {
	gboolean result = FALSE;
	gboolean found = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	found = FALSE;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gboolean _tmp7_ = FALSE;
		gboolean _tmp10_ = FALSE;
		gchar* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		_tmp2_ = self->priv->current;
		_tmp3_ = self->priv->end;
		if (_tmp2_ < _tmp3_) {
			gchar* _tmp4_ = NULL;
			gchar _tmp5_ = '\0';
			gboolean _tmp6_ = FALSE;
			_tmp4_ = self->priv->current;
			_tmp5_ = _tmp4_[0];
			_tmp6_ = g_ascii_isspace (_tmp5_);
			_tmp1_ = _tmp6_;
		} else {
			_tmp1_ = FALSE;
		}
		_tmp7_ = _tmp1_;
		if (_tmp7_) {
			gchar* _tmp8_ = NULL;
			gchar _tmp9_ = '\0';
			_tmp8_ = self->priv->current;
			_tmp9_ = _tmp8_[0];
			_tmp0_ = _tmp9_ != '\n';
		} else {
			_tmp0_ = FALSE;
		}
		_tmp10_ = _tmp0_;
		if (!_tmp10_) {
			break;
		}
		found = TRUE;
		_tmp11_ = self->priv->current;
		self->priv->current = _tmp11_ + 1;
		_tmp12_ = self->priv->column;
		self->priv->column = _tmp12_ + 1;
	}
	result = found;
	return result;
}


static void vala_scanner_pp_space (ValaScanner* self) {
	g_return_if_fail (self != NULL);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		gboolean _tmp3_ = FALSE;
		_tmp1_ = vala_scanner_pp_whitespace (self);
		if (_tmp1_) {
			_tmp0_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			_tmp2_ = vala_scanner_comment (self, FALSE);
			_tmp0_ = _tmp2_;
		}
		_tmp3_ = _tmp0_;
		if (!_tmp3_) {
			break;
		}
	}
}


static void vala_scanner_pp_directive (ValaScanner* self) {
	gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gint _tmp5_ = 0;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp13_ = FALSE;
	gchar* begin = NULL;
	gchar* _tmp21_ = NULL;
	gint len = 0;
	gboolean _tmp32_ = FALSE;
	gint _tmp33_ = 0;
	gboolean _tmp36_ = FALSE;
	gboolean _tmp56_ = FALSE;
	ValaScannerConditional* _tmp57_ = NULL;
	gint _tmp57__length1 = 0;
	gboolean _tmp62_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->current;
	self->priv->current = _tmp0_ + 1;
	_tmp1_ = self->priv->column;
	self->priv->column = _tmp1_ + 1;
	_tmp5_ = self->priv->line;
	if (_tmp5_ == 1) {
		gint _tmp6_ = 0;
		_tmp6_ = self->priv->column;
		_tmp4_ = _tmp6_ == 2;
	} else {
		_tmp4_ = FALSE;
	}
	_tmp7_ = _tmp4_;
	if (_tmp7_) {
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		_tmp8_ = self->priv->current;
		_tmp9_ = self->priv->end;
		_tmp3_ = _tmp8_ < _tmp9_;
	} else {
		_tmp3_ = FALSE;
	}
	_tmp10_ = _tmp3_;
	if (_tmp10_) {
		gchar* _tmp11_ = NULL;
		gchar _tmp12_ = '\0';
		_tmp11_ = self->priv->current;
		_tmp12_ = _tmp11_[0];
		_tmp2_ = _tmp12_ == '!';
	} else {
		_tmp2_ = FALSE;
	}
	_tmp13_ = _tmp2_;
	if (_tmp13_) {
		while (TRUE) {
			gboolean _tmp14_ = FALSE;
			gchar* _tmp15_ = NULL;
			gchar* _tmp16_ = NULL;
			gboolean _tmp19_ = FALSE;
			gchar* _tmp20_ = NULL;
			_tmp15_ = self->priv->current;
			_tmp16_ = self->priv->end;
			if (_tmp15_ < _tmp16_) {
				gchar* _tmp17_ = NULL;
				gchar _tmp18_ = '\0';
				_tmp17_ = self->priv->current;
				_tmp18_ = _tmp17_[0];
				_tmp14_ = _tmp18_ != '\n';
			} else {
				_tmp14_ = FALSE;
			}
			_tmp19_ = _tmp14_;
			if (!_tmp19_) {
				break;
			}
			_tmp20_ = self->priv->current;
			self->priv->current = _tmp20_ + 1;
		}
		return;
	}
	vala_scanner_pp_space (self);
	_tmp21_ = self->priv->current;
	begin = _tmp21_;
	len = 0;
	while (TRUE) {
		gboolean _tmp22_ = FALSE;
		gchar* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
		gboolean _tmp28_ = FALSE;
		gchar* _tmp29_ = NULL;
		gint _tmp30_ = 0;
		gint _tmp31_ = 0;
		_tmp23_ = self->priv->current;
		_tmp24_ = self->priv->end;
		if (_tmp23_ < _tmp24_) {
			gchar* _tmp25_ = NULL;
			gchar _tmp26_ = '\0';
			gboolean _tmp27_ = FALSE;
			_tmp25_ = self->priv->current;
			_tmp26_ = _tmp25_[0];
			_tmp27_ = g_ascii_isalnum (_tmp26_);
			_tmp22_ = _tmp27_;
		} else {
			_tmp22_ = FALSE;
		}
		_tmp28_ = _tmp22_;
		if (!_tmp28_) {
			break;
		}
		_tmp29_ = self->priv->current;
		self->priv->current = _tmp29_ + 1;
		_tmp30_ = self->priv->column;
		self->priv->column = _tmp30_ + 1;
		_tmp31_ = len;
		len = _tmp31_ + 1;
	}
	_tmp33_ = len;
	if (_tmp33_ == 2) {
		gchar* _tmp34_ = NULL;
		gboolean _tmp35_ = FALSE;
		_tmp34_ = begin;
		_tmp35_ = vala_scanner_matches (_tmp34_, "if");
		_tmp32_ = _tmp35_;
	} else {
		_tmp32_ = FALSE;
	}
	_tmp36_ = _tmp32_;
	if (_tmp36_) {
		vala_scanner_parse_pp_if (self);
	} else {
		gboolean _tmp37_ = FALSE;
		gint _tmp38_ = 0;
		gboolean _tmp41_ = FALSE;
		_tmp38_ = len;
		if (_tmp38_ == 4) {
			gchar* _tmp39_ = NULL;
			gboolean _tmp40_ = FALSE;
			_tmp39_ = begin;
			_tmp40_ = vala_scanner_matches (_tmp39_, "elif");
			_tmp37_ = _tmp40_;
		} else {
			_tmp37_ = FALSE;
		}
		_tmp41_ = _tmp37_;
		if (_tmp41_) {
			vala_scanner_parse_pp_elif (self);
		} else {
			gboolean _tmp42_ = FALSE;
			gint _tmp43_ = 0;
			gboolean _tmp46_ = FALSE;
			_tmp43_ = len;
			if (_tmp43_ == 4) {
				gchar* _tmp44_ = NULL;
				gboolean _tmp45_ = FALSE;
				_tmp44_ = begin;
				_tmp45_ = vala_scanner_matches (_tmp44_, "else");
				_tmp42_ = _tmp45_;
			} else {
				_tmp42_ = FALSE;
			}
			_tmp46_ = _tmp42_;
			if (_tmp46_) {
				vala_scanner_parse_pp_else (self);
			} else {
				gboolean _tmp47_ = FALSE;
				gint _tmp48_ = 0;
				gboolean _tmp51_ = FALSE;
				_tmp48_ = len;
				if (_tmp48_ == 5) {
					gchar* _tmp49_ = NULL;
					gboolean _tmp50_ = FALSE;
					_tmp49_ = begin;
					_tmp50_ = vala_scanner_matches (_tmp49_, "endif");
					_tmp47_ = _tmp50_;
				} else {
					_tmp47_ = FALSE;
				}
				_tmp51_ = _tmp47_;
				if (_tmp51_) {
					vala_scanner_parse_pp_endif (self);
				} else {
					gint _tmp52_ = 0;
					gint _tmp53_ = 0;
					ValaSourceReference* _tmp54_ = NULL;
					ValaSourceReference* _tmp55_ = NULL;
					_tmp52_ = len;
					_tmp53_ = len;
					_tmp54_ = vala_scanner_get_source_reference (self, -_tmp52_, _tmp53_);
					_tmp55_ = _tmp54_;
					vala_report_error (_tmp55_, "syntax error, invalid preprocessing directive");
					_vala_source_reference_unref0 (_tmp55_);
				}
			}
		}
	}
	_tmp57_ = self->priv->conditional_stack;
	_tmp57__length1 = self->priv->conditional_stack_length1;
	if (_tmp57__length1 > 0) {
		ValaScannerConditional* _tmp58_ = NULL;
		gint _tmp58__length1 = 0;
		ValaScannerConditional* _tmp59_ = NULL;
		gint _tmp59__length1 = 0;
		ValaScannerConditional _tmp60_ = {0};
		gboolean _tmp61_ = FALSE;
		_tmp58_ = self->priv->conditional_stack;
		_tmp58__length1 = self->priv->conditional_stack_length1;
		_tmp59_ = self->priv->conditional_stack;
		_tmp59__length1 = self->priv->conditional_stack_length1;
		_tmp60_ = _tmp58_[_tmp59__length1 - 1];
		_tmp61_ = _tmp60_.skip_section;
		_tmp56_ = _tmp61_;
	} else {
		_tmp56_ = FALSE;
	}
	_tmp62_ = _tmp56_;
	if (_tmp62_) {
		gboolean bol = FALSE;
		bol = FALSE;
		while (TRUE) {
			gchar* _tmp63_ = NULL;
			gchar* _tmp64_ = NULL;
			gboolean _tmp65_ = FALSE;
			gboolean _tmp66_ = FALSE;
			gboolean _tmp69_ = FALSE;
			gchar* _tmp72_ = NULL;
			gchar _tmp73_ = '\0';
			gchar* _tmp78_ = NULL;
			gint _tmp79_ = 0;
			_tmp63_ = self->priv->current;
			_tmp64_ = self->priv->end;
			if (!(_tmp63_ < _tmp64_)) {
				break;
			}
			_tmp66_ = bol;
			if (_tmp66_) {
				gchar* _tmp67_ = NULL;
				gchar _tmp68_ = '\0';
				_tmp67_ = self->priv->current;
				_tmp68_ = _tmp67_[0];
				_tmp65_ = _tmp68_ == '#';
			} else {
				_tmp65_ = FALSE;
			}
			_tmp69_ = _tmp65_;
			if (_tmp69_) {
				gchar* _tmp70_ = NULL;
				gint _tmp71_ = 0;
				_tmp70_ = self->priv->current;
				_tmp71_ = self->priv->column;
				self->priv->current = _tmp70_ - (_tmp71_ - 1);
				self->priv->column = 1;
				return;
			}
			_tmp72_ = self->priv->current;
			_tmp73_ = _tmp72_[0];
			if (_tmp73_ == '\n') {
				gint _tmp74_ = 0;
				_tmp74_ = self->priv->line;
				self->priv->line = _tmp74_ + 1;
				self->priv->column = 0;
				bol = TRUE;
			} else {
				gchar* _tmp75_ = NULL;
				gchar _tmp76_ = '\0';
				gboolean _tmp77_ = FALSE;
				_tmp75_ = self->priv->current;
				_tmp76_ = _tmp75_[0];
				_tmp77_ = g_ascii_isspace (_tmp76_);
				if (!_tmp77_) {
					bol = FALSE;
				}
			}
			_tmp78_ = self->priv->current;
			self->priv->current = _tmp78_ + 1;
			_tmp79_ = self->priv->column;
			self->priv->column = _tmp79_ + 1;
		}
	}
}


static void vala_scanner_pp_eol (ValaScanner* self) {
	gboolean _tmp0_ = FALSE;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gboolean _tmp5_ = FALSE;
	g_return_if_fail (self != NULL);
	vala_scanner_pp_space (self);
	_tmp1_ = self->priv->current;
	_tmp2_ = self->priv->end;
	if (_tmp1_ >= _tmp2_) {
		_tmp0_ = TRUE;
	} else {
		gchar* _tmp3_ = NULL;
		gchar _tmp4_ = '\0';
		_tmp3_ = self->priv->current;
		_tmp4_ = _tmp3_[0];
		_tmp0_ = _tmp4_ != '\n';
	}
	_tmp5_ = _tmp0_;
	if (_tmp5_) {
		ValaSourceReference* _tmp6_ = NULL;
		ValaSourceReference* _tmp7_ = NULL;
		_tmp6_ = vala_scanner_get_source_reference (self, 0, 0);
		_tmp7_ = _tmp6_;
		vala_report_error (_tmp7_, "syntax error, expected newline");
		_vala_source_reference_unref0 (_tmp7_);
	}
}


static void _vala_array_add22 (ValaScannerConditional** array, int* length, int* size, const ValaScannerConditional* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaScannerConditional, *array, *size);
	}
	(*array)[(*length)++] = *value;
}


static void vala_scanner_parse_pp_if (ValaScanner* self) {
	gboolean condition = FALSE;
	gboolean _tmp0_ = FALSE;
	ValaScannerConditional* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	ValaScannerConditional _tmp2_ = {0};
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp12_ = FALSE;
	g_return_if_fail (self != NULL);
	vala_scanner_pp_space (self);
	_tmp0_ = vala_scanner_parse_pp_expression (self);
	condition = _tmp0_;
	vala_scanner_pp_eol (self);
	_tmp1_ = self->priv->conditional_stack;
	_tmp1__length1 = self->priv->conditional_stack_length1;
	memset (&_tmp2_, 0, sizeof (ValaScannerConditional));
	_vala_array_add22 (&self->priv->conditional_stack, &self->priv->conditional_stack_length1, &self->priv->_conditional_stack_size_, &_tmp2_);
	_tmp4_ = condition;
	if (_tmp4_) {
		gboolean _tmp5_ = FALSE;
		ValaScannerConditional* _tmp6_ = NULL;
		gint _tmp6__length1 = 0;
		gboolean _tmp11_ = FALSE;
		_tmp6_ = self->priv->conditional_stack;
		_tmp6__length1 = self->priv->conditional_stack_length1;
		if (_tmp6__length1 == 1) {
			_tmp5_ = TRUE;
		} else {
			ValaScannerConditional* _tmp7_ = NULL;
			gint _tmp7__length1 = 0;
			ValaScannerConditional* _tmp8_ = NULL;
			gint _tmp8__length1 = 0;
			ValaScannerConditional _tmp9_ = {0};
			gboolean _tmp10_ = FALSE;
			_tmp7_ = self->priv->conditional_stack;
			_tmp7__length1 = self->priv->conditional_stack_length1;
			_tmp8_ = self->priv->conditional_stack;
			_tmp8__length1 = self->priv->conditional_stack_length1;
			_tmp9_ = _tmp7_[_tmp8__length1 - 2];
			_tmp10_ = _tmp9_.skip_section;
			_tmp5_ = !_tmp10_;
		}
		_tmp11_ = _tmp5_;
		_tmp3_ = _tmp11_;
	} else {
		_tmp3_ = FALSE;
	}
	_tmp12_ = _tmp3_;
	if (_tmp12_) {
		ValaScannerConditional* _tmp13_ = NULL;
		gint _tmp13__length1 = 0;
		ValaScannerConditional* _tmp14_ = NULL;
		gint _tmp14__length1 = 0;
		_tmp13_ = self->priv->conditional_stack;
		_tmp13__length1 = self->priv->conditional_stack_length1;
		_tmp14_ = self->priv->conditional_stack;
		_tmp14__length1 = self->priv->conditional_stack_length1;
		_tmp13_[_tmp14__length1 - 1].matched = TRUE;
	} else {
		ValaScannerConditional* _tmp15_ = NULL;
		gint _tmp15__length1 = 0;
		ValaScannerConditional* _tmp16_ = NULL;
		gint _tmp16__length1 = 0;
		_tmp15_ = self->priv->conditional_stack;
		_tmp15__length1 = self->priv->conditional_stack_length1;
		_tmp16_ = self->priv->conditional_stack;
		_tmp16__length1 = self->priv->conditional_stack_length1;
		_tmp15_[_tmp16__length1 - 1].skip_section = TRUE;
	}
}


static void vala_scanner_parse_pp_elif (ValaScanner* self) {
	gboolean condition = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaScannerConditional* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp25_ = FALSE;
	g_return_if_fail (self != NULL);
	vala_scanner_pp_space (self);
	_tmp0_ = vala_scanner_parse_pp_expression (self);
	condition = _tmp0_;
	vala_scanner_pp_eol (self);
	_tmp2_ = self->priv->conditional_stack;
	_tmp2__length1 = self->priv->conditional_stack_length1;
	if (_tmp2__length1 == 0) {
		_tmp1_ = TRUE;
	} else {
		ValaScannerConditional* _tmp3_ = NULL;
		gint _tmp3__length1 = 0;
		ValaScannerConditional* _tmp4_ = NULL;
		gint _tmp4__length1 = 0;
		ValaScannerConditional _tmp5_ = {0};
		gboolean _tmp6_ = FALSE;
		_tmp3_ = self->priv->conditional_stack;
		_tmp3__length1 = self->priv->conditional_stack_length1;
		_tmp4_ = self->priv->conditional_stack;
		_tmp4__length1 = self->priv->conditional_stack_length1;
		_tmp5_ = _tmp3_[_tmp4__length1 - 1];
		_tmp6_ = _tmp5_.else_found;
		_tmp1_ = _tmp6_;
	}
	_tmp7_ = _tmp1_;
	if (_tmp7_) {
		ValaSourceReference* _tmp8_ = NULL;
		ValaSourceReference* _tmp9_ = NULL;
		_tmp8_ = vala_scanner_get_source_reference (self, 0, 0);
		_tmp9_ = _tmp8_;
		vala_report_error (_tmp9_, "syntax error, unexpected #elif");
		_vala_source_reference_unref0 (_tmp9_);
		return;
	}
	_tmp12_ = condition;
	if (_tmp12_) {
		ValaScannerConditional* _tmp13_ = NULL;
		gint _tmp13__length1 = 0;
		ValaScannerConditional* _tmp14_ = NULL;
		gint _tmp14__length1 = 0;
		ValaScannerConditional _tmp15_ = {0};
		gboolean _tmp16_ = FALSE;
		_tmp13_ = self->priv->conditional_stack;
		_tmp13__length1 = self->priv->conditional_stack_length1;
		_tmp14_ = self->priv->conditional_stack;
		_tmp14__length1 = self->priv->conditional_stack_length1;
		_tmp15_ = _tmp13_[_tmp14__length1 - 1];
		_tmp16_ = _tmp15_.matched;
		_tmp11_ = !_tmp16_;
	} else {
		_tmp11_ = FALSE;
	}
	_tmp17_ = _tmp11_;
	if (_tmp17_) {
		gboolean _tmp18_ = FALSE;
		ValaScannerConditional* _tmp19_ = NULL;
		gint _tmp19__length1 = 0;
		gboolean _tmp24_ = FALSE;
		_tmp19_ = self->priv->conditional_stack;
		_tmp19__length1 = self->priv->conditional_stack_length1;
		if (_tmp19__length1 == 1) {
			_tmp18_ = TRUE;
		} else {
			ValaScannerConditional* _tmp20_ = NULL;
			gint _tmp20__length1 = 0;
			ValaScannerConditional* _tmp21_ = NULL;
			gint _tmp21__length1 = 0;
			ValaScannerConditional _tmp22_ = {0};
			gboolean _tmp23_ = FALSE;
			_tmp20_ = self->priv->conditional_stack;
			_tmp20__length1 = self->priv->conditional_stack_length1;
			_tmp21_ = self->priv->conditional_stack;
			_tmp21__length1 = self->priv->conditional_stack_length1;
			_tmp22_ = _tmp20_[_tmp21__length1 - 2];
			_tmp23_ = _tmp22_.skip_section;
			_tmp18_ = !_tmp23_;
		}
		_tmp24_ = _tmp18_;
		_tmp10_ = _tmp24_;
	} else {
		_tmp10_ = FALSE;
	}
	_tmp25_ = _tmp10_;
	if (_tmp25_) {
		ValaScannerConditional* _tmp26_ = NULL;
		gint _tmp26__length1 = 0;
		ValaScannerConditional* _tmp27_ = NULL;
		gint _tmp27__length1 = 0;
		ValaScannerConditional* _tmp28_ = NULL;
		gint _tmp28__length1 = 0;
		ValaScannerConditional* _tmp29_ = NULL;
		gint _tmp29__length1 = 0;
		_tmp26_ = self->priv->conditional_stack;
		_tmp26__length1 = self->priv->conditional_stack_length1;
		_tmp27_ = self->priv->conditional_stack;
		_tmp27__length1 = self->priv->conditional_stack_length1;
		_tmp26_[_tmp27__length1 - 1].matched = TRUE;
		_tmp28_ = self->priv->conditional_stack;
		_tmp28__length1 = self->priv->conditional_stack_length1;
		_tmp29_ = self->priv->conditional_stack;
		_tmp29__length1 = self->priv->conditional_stack_length1;
		_tmp28_[_tmp29__length1 - 1].skip_section = FALSE;
	} else {
		ValaScannerConditional* _tmp30_ = NULL;
		gint _tmp30__length1 = 0;
		ValaScannerConditional* _tmp31_ = NULL;
		gint _tmp31__length1 = 0;
		_tmp30_ = self->priv->conditional_stack;
		_tmp30__length1 = self->priv->conditional_stack_length1;
		_tmp31_ = self->priv->conditional_stack;
		_tmp31__length1 = self->priv->conditional_stack_length1;
		_tmp30_[_tmp31__length1 - 1].skip_section = TRUE;
	}
}


static void vala_scanner_parse_pp_else (ValaScanner* self) {
	gboolean _tmp0_ = FALSE;
	ValaScannerConditional* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp9_ = FALSE;
	ValaScannerConditional* _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	ValaScannerConditional* _tmp11_ = NULL;
	gint _tmp11__length1 = 0;
	ValaScannerConditional _tmp12_ = {0};
	gboolean _tmp13_ = FALSE;
	gboolean _tmp21_ = FALSE;
	g_return_if_fail (self != NULL);
	vala_scanner_pp_eol (self);
	_tmp1_ = self->priv->conditional_stack;
	_tmp1__length1 = self->priv->conditional_stack_length1;
	if (_tmp1__length1 == 0) {
		_tmp0_ = TRUE;
	} else {
		ValaScannerConditional* _tmp2_ = NULL;
		gint _tmp2__length1 = 0;
		ValaScannerConditional* _tmp3_ = NULL;
		gint _tmp3__length1 = 0;
		ValaScannerConditional _tmp4_ = {0};
		gboolean _tmp5_ = FALSE;
		_tmp2_ = self->priv->conditional_stack;
		_tmp2__length1 = self->priv->conditional_stack_length1;
		_tmp3_ = self->priv->conditional_stack;
		_tmp3__length1 = self->priv->conditional_stack_length1;
		_tmp4_ = _tmp2_[_tmp3__length1 - 1];
		_tmp5_ = _tmp4_.else_found;
		_tmp0_ = _tmp5_;
	}
	_tmp6_ = _tmp0_;
	if (_tmp6_) {
		ValaSourceReference* _tmp7_ = NULL;
		ValaSourceReference* _tmp8_ = NULL;
		_tmp7_ = vala_scanner_get_source_reference (self, 0, 0);
		_tmp8_ = _tmp7_;
		vala_report_error (_tmp8_, "syntax error, unexpected #else");
		_vala_source_reference_unref0 (_tmp8_);
		return;
	}
	_tmp10_ = self->priv->conditional_stack;
	_tmp10__length1 = self->priv->conditional_stack_length1;
	_tmp11_ = self->priv->conditional_stack;
	_tmp11__length1 = self->priv->conditional_stack_length1;
	_tmp12_ = _tmp10_[_tmp11__length1 - 1];
	_tmp13_ = _tmp12_.matched;
	if (!_tmp13_) {
		gboolean _tmp14_ = FALSE;
		ValaScannerConditional* _tmp15_ = NULL;
		gint _tmp15__length1 = 0;
		gboolean _tmp20_ = FALSE;
		_tmp15_ = self->priv->conditional_stack;
		_tmp15__length1 = self->priv->conditional_stack_length1;
		if (_tmp15__length1 == 1) {
			_tmp14_ = TRUE;
		} else {
			ValaScannerConditional* _tmp16_ = NULL;
			gint _tmp16__length1 = 0;
			ValaScannerConditional* _tmp17_ = NULL;
			gint _tmp17__length1 = 0;
			ValaScannerConditional _tmp18_ = {0};
			gboolean _tmp19_ = FALSE;
			_tmp16_ = self->priv->conditional_stack;
			_tmp16__length1 = self->priv->conditional_stack_length1;
			_tmp17_ = self->priv->conditional_stack;
			_tmp17__length1 = self->priv->conditional_stack_length1;
			_tmp18_ = _tmp16_[_tmp17__length1 - 2];
			_tmp19_ = _tmp18_.skip_section;
			_tmp14_ = !_tmp19_;
		}
		_tmp20_ = _tmp14_;
		_tmp9_ = _tmp20_;
	} else {
		_tmp9_ = FALSE;
	}
	_tmp21_ = _tmp9_;
	if (_tmp21_) {
		ValaScannerConditional* _tmp22_ = NULL;
		gint _tmp22__length1 = 0;
		ValaScannerConditional* _tmp23_ = NULL;
		gint _tmp23__length1 = 0;
		ValaScannerConditional* _tmp24_ = NULL;
		gint _tmp24__length1 = 0;
		ValaScannerConditional* _tmp25_ = NULL;
		gint _tmp25__length1 = 0;
		_tmp22_ = self->priv->conditional_stack;
		_tmp22__length1 = self->priv->conditional_stack_length1;
		_tmp23_ = self->priv->conditional_stack;
		_tmp23__length1 = self->priv->conditional_stack_length1;
		_tmp22_[_tmp23__length1 - 1].matched = TRUE;
		_tmp24_ = self->priv->conditional_stack;
		_tmp24__length1 = self->priv->conditional_stack_length1;
		_tmp25_ = self->priv->conditional_stack;
		_tmp25__length1 = self->priv->conditional_stack_length1;
		_tmp24_[_tmp25__length1 - 1].skip_section = FALSE;
	} else {
		ValaScannerConditional* _tmp26_ = NULL;
		gint _tmp26__length1 = 0;
		ValaScannerConditional* _tmp27_ = NULL;
		gint _tmp27__length1 = 0;
		_tmp26_ = self->priv->conditional_stack;
		_tmp26__length1 = self->priv->conditional_stack_length1;
		_tmp27_ = self->priv->conditional_stack;
		_tmp27__length1 = self->priv->conditional_stack_length1;
		_tmp26_[_tmp27__length1 - 1].skip_section = TRUE;
	}
}


static void vala_scanner_parse_pp_endif (ValaScanner* self) {
	ValaScannerConditional* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp3_ = 0;
	g_return_if_fail (self != NULL);
	vala_scanner_pp_eol (self);
	_tmp0_ = self->priv->conditional_stack;
	_tmp0__length1 = self->priv->conditional_stack_length1;
	if (_tmp0__length1 == 0) {
		ValaSourceReference* _tmp1_ = NULL;
		ValaSourceReference* _tmp2_ = NULL;
		_tmp1_ = vala_scanner_get_source_reference (self, 0, 0);
		_tmp2_ = _tmp1_;
		vala_report_error (_tmp2_, "syntax error, unexpected #endif");
		_vala_source_reference_unref0 (_tmp2_);
		return;
	}
	_tmp3_ = self->priv->conditional_stack_length1;
	self->priv->conditional_stack_length1 = _tmp3_ - 1;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_ = 0L;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	gboolean _tmp3_ = FALSE;
	glong _tmp9_ = 0L;
	glong _tmp15_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	glong _tmp22_ = 0L;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_ = 0L;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		glong _tmp6_ = 0L;
		_tmp4_ = offset;
		_tmp5_ = len;
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
		string_length = _tmp6_;
	} else {
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		_tmp7_ = strlen (self);
		_tmp8_ = _tmp7_;
		string_length = (glong) _tmp8_;
	}
	_tmp9_ = offset;
	if (_tmp9_ < ((glong) 0)) {
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		glong _tmp12_ = 0L;
		_tmp10_ = string_length;
		_tmp11_ = offset;
		offset = _tmp10_ + _tmp11_;
		_tmp12_ = offset;
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
	} else {
		glong _tmp13_ = 0L;
		glong _tmp14_ = 0L;
		_tmp13_ = offset;
		_tmp14_ = string_length;
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
	}
	_tmp15_ = len;
	if (_tmp15_ < ((glong) 0)) {
		glong _tmp16_ = 0L;
		glong _tmp17_ = 0L;
		_tmp16_ = string_length;
		_tmp17_ = offset;
		len = _tmp16_ - _tmp17_;
	}
	_tmp18_ = offset;
	_tmp19_ = len;
	_tmp20_ = string_length;
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
	_tmp21_ = offset;
	_tmp22_ = len;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
	result = _tmp23_;
	return result;
}


static gboolean vala_scanner_parse_pp_symbol (ValaScanner* self) {
	gboolean result = FALSE;
	gint len = 0;
	gint _tmp10_ = 0;
	gchar* identifier = NULL;
	gchar* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	gchar* _tmp16_ = NULL;
	gboolean defined = FALSE;
	const gchar* _tmp17_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	len = 0;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		gboolean _tmp6_ = FALSE;
		gchar* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		_tmp1_ = self->priv->current;
		_tmp2_ = self->priv->end;
		if (_tmp1_ < _tmp2_) {
			gchar* _tmp3_ = NULL;
			gchar _tmp4_ = '\0';
			gboolean _tmp5_ = FALSE;
			_tmp3_ = self->priv->current;
			_tmp4_ = _tmp3_[0];
			_tmp5_ = vala_scanner_is_ident_char (self, _tmp4_);
			_tmp0_ = _tmp5_;
		} else {
			_tmp0_ = FALSE;
		}
		_tmp6_ = _tmp0_;
		if (!_tmp6_) {
			break;
		}
		_tmp7_ = self->priv->current;
		self->priv->current = _tmp7_ + 1;
		_tmp8_ = self->priv->column;
		self->priv->column = _tmp8_ + 1;
		_tmp9_ = len;
		len = _tmp9_ + 1;
	}
	_tmp10_ = len;
	if (_tmp10_ == 0) {
		ValaSourceReference* _tmp11_ = NULL;
		ValaSourceReference* _tmp12_ = NULL;
		_tmp11_ = vala_scanner_get_source_reference (self, 0, 0);
		_tmp12_ = _tmp11_;
		vala_report_error (_tmp12_, "syntax error, expected identifier");
		_vala_source_reference_unref0 (_tmp12_);
		result = FALSE;
		return result;
	}
	_tmp13_ = self->priv->current;
	_tmp14_ = len;
	_tmp15_ = len;
	_tmp16_ = string_substring ((const gchar*) (_tmp13_ - _tmp14_), (glong) 0, (glong) _tmp15_);
	identifier = _tmp16_;
	_tmp17_ = identifier;
	if (g_strcmp0 (_tmp17_, "true") == 0) {
		defined = TRUE;
	} else {
		const gchar* _tmp18_ = NULL;
		_tmp18_ = identifier;
		if (g_strcmp0 (_tmp18_, "false") == 0) {
			defined = FALSE;
		} else {
			ValaSourceFile* _tmp19_ = NULL;
			ValaCodeContext* _tmp20_ = NULL;
			ValaCodeContext* _tmp21_ = NULL;
			const gchar* _tmp22_ = NULL;
			gboolean _tmp23_ = FALSE;
			_tmp19_ = self->priv->_source_file;
			_tmp20_ = vala_source_file_get_context (_tmp19_);
			_tmp21_ = _tmp20_;
			_tmp22_ = identifier;
			_tmp23_ = vala_code_context_is_defined (_tmp21_, _tmp22_);
			defined = _tmp23_;
		}
	}
	result = defined;
	_g_free0 (identifier);
	return result;
}


static gboolean vala_scanner_parse_pp_primary_expression (ValaScanner* self) {
	gboolean result = FALSE;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->current;
	_tmp1_ = self->priv->end;
	if (_tmp0_ >= _tmp1_) {
		ValaSourceReference* _tmp2_ = NULL;
		ValaSourceReference* _tmp3_ = NULL;
		_tmp2_ = vala_scanner_get_source_reference (self, 0, 0);
		_tmp3_ = _tmp2_;
		vala_report_error (_tmp3_, "syntax error, expected identifier");
		_vala_source_reference_unref0 (_tmp3_);
	} else {
		gchar* _tmp4_ = NULL;
		gchar _tmp5_ = '\0';
		gboolean _tmp6_ = FALSE;
		_tmp4_ = self->priv->current;
		_tmp5_ = _tmp4_[0];
		_tmp6_ = vala_scanner_is_ident_char (self, _tmp5_);
		if (_tmp6_) {
			gboolean _tmp7_ = FALSE;
			_tmp7_ = vala_scanner_parse_pp_symbol (self);
			result = _tmp7_;
			return result;
		} else {
			gchar* _tmp8_ = NULL;
			gchar _tmp9_ = '\0';
			_tmp8_ = self->priv->current;
			_tmp9_ = _tmp8_[0];
			if (_tmp9_ == '(') {
				gchar* _tmp10_ = NULL;
				gint _tmp11_ = 0;
				gboolean _result_ = FALSE;
				gboolean _tmp12_ = FALSE;
				gboolean _tmp13_ = FALSE;
				gchar* _tmp14_ = NULL;
				gchar* _tmp15_ = NULL;
				gboolean _tmp18_ = FALSE;
				_tmp10_ = self->priv->current;
				self->priv->current = _tmp10_ + 1;
				_tmp11_ = self->priv->column;
				self->priv->column = _tmp11_ + 1;
				vala_scanner_pp_space (self);
				_tmp12_ = vala_scanner_parse_pp_expression (self);
				_result_ = _tmp12_;
				vala_scanner_pp_space (self);
				_tmp14_ = self->priv->current;
				_tmp15_ = self->priv->end;
				if (_tmp14_ < _tmp15_) {
					gchar* _tmp16_ = NULL;
					gchar _tmp17_ = '\0';
					_tmp16_ = self->priv->current;
					_tmp17_ = _tmp16_[0];
					_tmp13_ = _tmp17_ == ')';
				} else {
					_tmp13_ = FALSE;
				}
				_tmp18_ = _tmp13_;
				if (_tmp18_) {
					gchar* _tmp19_ = NULL;
					gint _tmp20_ = 0;
					_tmp19_ = self->priv->current;
					self->priv->current = _tmp19_ + 1;
					_tmp20_ = self->priv->column;
					self->priv->column = _tmp20_ + 1;
				} else {
					ValaSourceReference* _tmp21_ = NULL;
					ValaSourceReference* _tmp22_ = NULL;
					_tmp21_ = vala_scanner_get_source_reference (self, 0, 0);
					_tmp22_ = _tmp21_;
					vala_report_error (_tmp22_, "syntax error, expected `)'");
					_vala_source_reference_unref0 (_tmp22_);
				}
				result = _result_;
				return result;
			} else {
				ValaSourceReference* _tmp23_ = NULL;
				ValaSourceReference* _tmp24_ = NULL;
				_tmp23_ = vala_scanner_get_source_reference (self, 0, 0);
				_tmp24_ = _tmp23_;
				vala_report_error (_tmp24_, "syntax error, expected identifier");
				_vala_source_reference_unref0 (_tmp24_);
			}
		}
	}
	result = FALSE;
	return result;
}


static gboolean vala_scanner_parse_pp_unary_expression (ValaScanner* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp9_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->current;
	_tmp2_ = self->priv->end;
	if (_tmp1_ < _tmp2_) {
		gchar* _tmp3_ = NULL;
		gchar _tmp4_ = '\0';
		_tmp3_ = self->priv->current;
		_tmp4_ = _tmp3_[0];
		_tmp0_ = _tmp4_ == '!';
	} else {
		_tmp0_ = FALSE;
	}
	_tmp5_ = _tmp0_;
	if (_tmp5_) {
		gchar* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		gboolean _tmp8_ = FALSE;
		_tmp6_ = self->priv->current;
		self->priv->current = _tmp6_ + 1;
		_tmp7_ = self->priv->column;
		self->priv->column = _tmp7_ + 1;
		vala_scanner_pp_space (self);
		_tmp8_ = vala_scanner_parse_pp_unary_expression (self);
		result = !_tmp8_;
		return result;
	}
	_tmp9_ = vala_scanner_parse_pp_primary_expression (self);
	result = _tmp9_;
	return result;
}


static gboolean vala_scanner_parse_pp_equality_expression (ValaScanner* self) {
	gboolean result = FALSE;
	gboolean left = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_scanner_parse_pp_unary_expression (self);
	left = _tmp0_;
	vala_scanner_pp_space (self);
	while (TRUE) {
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_ = FALSE;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gboolean _tmp7_ = FALSE;
		gboolean _tmp10_ = FALSE;
		_tmp3_ = self->priv->current;
		_tmp4_ = self->priv->end;
		if (_tmp3_ < (_tmp4_ - 1)) {
			gchar* _tmp5_ = NULL;
			gchar _tmp6_ = '\0';
			_tmp5_ = self->priv->current;
			_tmp6_ = _tmp5_[0];
			_tmp2_ = _tmp6_ == '=';
		} else {
			_tmp2_ = FALSE;
		}
		_tmp7_ = _tmp2_;
		if (_tmp7_) {
			gchar* _tmp8_ = NULL;
			gchar _tmp9_ = '\0';
			_tmp8_ = self->priv->current;
			_tmp9_ = _tmp8_[1];
			_tmp1_ = _tmp9_ == '=';
		} else {
			_tmp1_ = FALSE;
		}
		_tmp10_ = _tmp1_;
		if (_tmp10_) {
			gchar* _tmp11_ = NULL;
			gint _tmp12_ = 0;
			gboolean right = FALSE;
			gboolean _tmp13_ = FALSE;
			gboolean _tmp14_ = FALSE;
			gboolean _tmp15_ = FALSE;
			_tmp11_ = self->priv->current;
			self->priv->current = _tmp11_ + 2;
			_tmp12_ = self->priv->column;
			self->priv->column = _tmp12_ + 2;
			vala_scanner_pp_space (self);
			_tmp13_ = vala_scanner_parse_pp_unary_expression (self);
			right = _tmp13_;
			_tmp14_ = left;
			_tmp15_ = right;
			left = _tmp14_ == _tmp15_;
		} else {
			gboolean _tmp16_ = FALSE;
			gboolean _tmp17_ = FALSE;
			gchar* _tmp18_ = NULL;
			gchar* _tmp19_ = NULL;
			gboolean _tmp22_ = FALSE;
			gboolean _tmp25_ = FALSE;
			_tmp18_ = self->priv->current;
			_tmp19_ = self->priv->end;
			if (_tmp18_ < (_tmp19_ - 1)) {
				gchar* _tmp20_ = NULL;
				gchar _tmp21_ = '\0';
				_tmp20_ = self->priv->current;
				_tmp21_ = _tmp20_[0];
				_tmp17_ = _tmp21_ == '!';
			} else {
				_tmp17_ = FALSE;
			}
			_tmp22_ = _tmp17_;
			if (_tmp22_) {
				gchar* _tmp23_ = NULL;
				gchar _tmp24_ = '\0';
				_tmp23_ = self->priv->current;
				_tmp24_ = _tmp23_[1];
				_tmp16_ = _tmp24_ == '=';
			} else {
				_tmp16_ = FALSE;
			}
			_tmp25_ = _tmp16_;
			if (_tmp25_) {
				gchar* _tmp26_ = NULL;
				gint _tmp27_ = 0;
				gboolean right = FALSE;
				gboolean _tmp28_ = FALSE;
				gboolean _tmp29_ = FALSE;
				gboolean _tmp30_ = FALSE;
				_tmp26_ = self->priv->current;
				self->priv->current = _tmp26_ + 2;
				_tmp27_ = self->priv->column;
				self->priv->column = _tmp27_ + 2;
				vala_scanner_pp_space (self);
				_tmp28_ = vala_scanner_parse_pp_unary_expression (self);
				right = _tmp28_;
				_tmp29_ = left;
				_tmp30_ = right;
				left = _tmp29_ != _tmp30_;
			} else {
				break;
			}
		}
	}
	result = left;
	return result;
}


static gboolean vala_scanner_parse_pp_and_expression (ValaScanner* self) {
	gboolean result = FALSE;
	gboolean left = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_scanner_parse_pp_equality_expression (self);
	left = _tmp0_;
	vala_scanner_pp_space (self);
	while (TRUE) {
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_ = FALSE;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gboolean _tmp7_ = FALSE;
		gboolean _tmp10_ = FALSE;
		gchar* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		gboolean right = FALSE;
		gboolean _tmp13_ = FALSE;
		gboolean _tmp14_ = FALSE;
		gboolean _tmp15_ = FALSE;
		gboolean _tmp17_ = FALSE;
		_tmp3_ = self->priv->current;
		_tmp4_ = self->priv->end;
		if (_tmp3_ < (_tmp4_ - 1)) {
			gchar* _tmp5_ = NULL;
			gchar _tmp6_ = '\0';
			_tmp5_ = self->priv->current;
			_tmp6_ = _tmp5_[0];
			_tmp2_ = _tmp6_ == '&';
		} else {
			_tmp2_ = FALSE;
		}
		_tmp7_ = _tmp2_;
		if (_tmp7_) {
			gchar* _tmp8_ = NULL;
			gchar _tmp9_ = '\0';
			_tmp8_ = self->priv->current;
			_tmp9_ = _tmp8_[1];
			_tmp1_ = _tmp9_ == '&';
		} else {
			_tmp1_ = FALSE;
		}
		_tmp10_ = _tmp1_;
		if (!_tmp10_) {
			break;
		}
		_tmp11_ = self->priv->current;
		self->priv->current = _tmp11_ + 2;
		_tmp12_ = self->priv->column;
		self->priv->column = _tmp12_ + 2;
		vala_scanner_pp_space (self);
		_tmp13_ = vala_scanner_parse_pp_equality_expression (self);
		right = _tmp13_;
		_tmp15_ = left;
		if (_tmp15_) {
			gboolean _tmp16_ = FALSE;
			_tmp16_ = right;
			_tmp14_ = _tmp16_;
		} else {
			_tmp14_ = FALSE;
		}
		_tmp17_ = _tmp14_;
		left = _tmp17_;
	}
	result = left;
	return result;
}


static gboolean vala_scanner_parse_pp_or_expression (ValaScanner* self) {
	gboolean result = FALSE;
	gboolean left = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_scanner_parse_pp_and_expression (self);
	left = _tmp0_;
	vala_scanner_pp_space (self);
	while (TRUE) {
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_ = FALSE;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gboolean _tmp7_ = FALSE;
		gboolean _tmp10_ = FALSE;
		gchar* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		gboolean right = FALSE;
		gboolean _tmp13_ = FALSE;
		gboolean _tmp14_ = FALSE;
		gboolean _tmp15_ = FALSE;
		gboolean _tmp17_ = FALSE;
		_tmp3_ = self->priv->current;
		_tmp4_ = self->priv->end;
		if (_tmp3_ < (_tmp4_ - 1)) {
			gchar* _tmp5_ = NULL;
			gchar _tmp6_ = '\0';
			_tmp5_ = self->priv->current;
			_tmp6_ = _tmp5_[0];
			_tmp2_ = _tmp6_ == '|';
		} else {
			_tmp2_ = FALSE;
		}
		_tmp7_ = _tmp2_;
		if (_tmp7_) {
			gchar* _tmp8_ = NULL;
			gchar _tmp9_ = '\0';
			_tmp8_ = self->priv->current;
			_tmp9_ = _tmp8_[1];
			_tmp1_ = _tmp9_ == '|';
		} else {
			_tmp1_ = FALSE;
		}
		_tmp10_ = _tmp1_;
		if (!_tmp10_) {
			break;
		}
		_tmp11_ = self->priv->current;
		self->priv->current = _tmp11_ + 2;
		_tmp12_ = self->priv->column;
		self->priv->column = _tmp12_ + 2;
		vala_scanner_pp_space (self);
		_tmp13_ = vala_scanner_parse_pp_and_expression (self);
		right = _tmp13_;
		_tmp15_ = left;
		if (_tmp15_) {
			_tmp14_ = TRUE;
		} else {
			gboolean _tmp16_ = FALSE;
			_tmp16_ = right;
			_tmp14_ = _tmp16_;
		}
		_tmp17_ = _tmp14_;
		left = _tmp17_;
	}
	result = left;
	return result;
}


static gboolean vala_scanner_parse_pp_expression (ValaScanner* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_scanner_parse_pp_or_expression (self);
	result = _tmp0_;
	return result;
}


static gboolean vala_scanner_whitespace (ValaScanner* self) {
	gboolean result = FALSE;
	gboolean found = FALSE;
	gboolean bol = FALSE;
	gint _tmp0_ = 0;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp21_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	found = FALSE;
	_tmp0_ = self->priv->column;
	bol = _tmp0_ == 1;
	while (TRUE) {
		gboolean _tmp1_ = FALSE;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gboolean _tmp7_ = FALSE;
		gchar* _tmp8_ = NULL;
		gchar _tmp9_ = '\0';
		gchar* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		_tmp2_ = self->priv->current;
		_tmp3_ = self->priv->end;
		if (_tmp2_ < _tmp3_) {
			gchar* _tmp4_ = NULL;
			gchar _tmp5_ = '\0';
			gboolean _tmp6_ = FALSE;
			_tmp4_ = self->priv->current;
			_tmp5_ = _tmp4_[0];
			_tmp6_ = g_ascii_isspace (_tmp5_);
			_tmp1_ = _tmp6_;
		} else {
			_tmp1_ = FALSE;
		}
		_tmp7_ = _tmp1_;
		if (!_tmp7_) {
			break;
		}
		_tmp8_ = self->priv->current;
		_tmp9_ = _tmp8_[0];
		if (_tmp9_ == '\n') {
			gint _tmp10_ = 0;
			_tmp10_ = self->priv->line;
			self->priv->line = _tmp10_ + 1;
			self->priv->column = 0;
			bol = TRUE;
		}
		found = TRUE;
		_tmp11_ = self->priv->current;
		self->priv->current = _tmp11_ + 1;
		_tmp12_ = self->priv->column;
		self->priv->column = _tmp12_ + 1;
	}
	_tmp15_ = bol;
	if (_tmp15_) {
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		_tmp16_ = self->priv->current;
		_tmp17_ = self->priv->end;
		_tmp14_ = _tmp16_ < _tmp17_;
	} else {
		_tmp14_ = FALSE;
	}
	_tmp18_ = _tmp14_;
	if (_tmp18_) {
		gchar* _tmp19_ = NULL;
		gchar _tmp20_ = '\0';
		_tmp19_ = self->priv->current;
		_tmp20_ = _tmp19_[0];
		_tmp13_ = _tmp20_ == '#';
	} else {
		_tmp13_ = FALSE;
	}
	_tmp21_ = _tmp13_;
	if (_tmp21_) {
		vala_scanner_pp_directive (self);
		result = TRUE;
		return result;
	}
	result = found;
	return result;
}


static gboolean vala_scanner_comment (ValaScanner* self, gboolean file_comment) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar* _tmp3_ = NULL;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp16_ = FALSE;
	gchar* _tmp17_ = NULL;
	gchar _tmp18_ = '\0';
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp3_ = self->priv->current;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		_tmp4_ = self->priv->current;
		_tmp5_ = self->priv->end;
		_tmp2_ = _tmp4_ > (_tmp5_ - 2);
	}
	_tmp6_ = _tmp2_;
	if (_tmp6_) {
		_tmp1_ = TRUE;
	} else {
		gchar* _tmp7_ = NULL;
		gchar _tmp8_ = '\0';
		_tmp7_ = self->priv->current;
		_tmp8_ = _tmp7_[0];
		_tmp1_ = _tmp8_ != '/';
	}
	_tmp9_ = _tmp1_;
	if (_tmp9_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp10_ = FALSE;
		gchar* _tmp11_ = NULL;
		gchar _tmp12_ = '\0';
		gboolean _tmp15_ = FALSE;
		_tmp11_ = self->priv->current;
		_tmp12_ = _tmp11_[1];
		if (_tmp12_ != '/') {
			gchar* _tmp13_ = NULL;
			gchar _tmp14_ = '\0';
			_tmp13_ = self->priv->current;
			_tmp14_ = _tmp13_[1];
			_tmp10_ = _tmp14_ != '*';
		} else {
			_tmp10_ = FALSE;
		}
		_tmp15_ = _tmp10_;
		_tmp0_ = _tmp15_;
	}
	_tmp16_ = _tmp0_;
	if (_tmp16_) {
		result = FALSE;
		return result;
	}
	_tmp17_ = self->priv->current;
	_tmp18_ = _tmp17_[1];
	if (_tmp18_ == '/') {
		ValaSourceReference* source_reference = NULL;
		gboolean _tmp19_ = FALSE;
		gchar* _tmp21_ = NULL;
		gchar* begin = NULL;
		gchar* _tmp22_ = NULL;
		ValaSourceReference* _tmp30_ = NULL;
		source_reference = NULL;
		_tmp19_ = file_comment;
		if (_tmp19_) {
			ValaSourceReference* _tmp20_ = NULL;
			_tmp20_ = vala_scanner_get_source_reference (self, 0, 0);
			_vala_source_reference_unref0 (source_reference);
			source_reference = _tmp20_;
		}
		_tmp21_ = self->priv->current;
		self->priv->current = _tmp21_ + 2;
		_tmp22_ = self->priv->current;
		begin = _tmp22_;
		while (TRUE) {
			gboolean _tmp23_ = FALSE;
			gchar* _tmp24_ = NULL;
			gchar* _tmp25_ = NULL;
			gboolean _tmp28_ = FALSE;
			gchar* _tmp29_ = NULL;
			_tmp24_ = self->priv->current;
			_tmp25_ = self->priv->end;
			if (_tmp24_ < _tmp25_) {
				gchar* _tmp26_ = NULL;
				gchar _tmp27_ = '\0';
				_tmp26_ = self->priv->current;
				_tmp27_ = _tmp26_[0];
				_tmp23_ = _tmp27_ != '\n';
			} else {
				_tmp23_ = FALSE;
			}
			_tmp28_ = _tmp23_;
			if (!_tmp28_) {
				break;
			}
			_tmp29_ = self->priv->current;
			self->priv->current = _tmp29_ + 1;
		}
		_tmp30_ = source_reference;
		if (_tmp30_ != NULL) {
			gchar* _tmp31_ = NULL;
			gchar* _tmp32_ = NULL;
			gchar* _tmp33_ = NULL;
			gchar* _tmp34_ = NULL;
			gchar* _tmp35_ = NULL;
			ValaSourceReference* _tmp36_ = NULL;
			gboolean _tmp37_ = FALSE;
			_tmp31_ = begin;
			_tmp32_ = self->priv->current;
			_tmp33_ = begin;
			_tmp34_ = string_substring ((const gchar*) _tmp31_, (glong) 0, (glong) (_tmp32_ - _tmp33_));
			_tmp35_ = _tmp34_;
			_tmp36_ = source_reference;
			_tmp37_ = file_comment;
			vala_scanner_push_comment (self, _tmp35_, _tmp36_, _tmp37_);
			_g_free0 (_tmp35_);
		}
		_vala_source_reference_unref0 (source_reference);
	} else {
		ValaSourceReference* source_reference = NULL;
		gboolean _tmp38_ = FALSE;
		gboolean _tmp39_ = FALSE;
		gboolean _tmp42_ = FALSE;
		gboolean _tmp43_ = FALSE;
		gchar* _tmp44_ = NULL;
		gchar _tmp45_ = '\0';
		gboolean _tmp47_ = FALSE;
		gchar* _tmp49_ = NULL;
		gchar* begin = NULL;
		gchar* _tmp50_ = NULL;
		gchar* _tmp66_ = NULL;
		gchar* _tmp67_ = NULL;
		ValaSourceReference* _tmp70_ = NULL;
		gchar* _tmp78_ = NULL;
		gint _tmp79_ = 0;
		source_reference = NULL;
		_tmp39_ = file_comment;
		if (_tmp39_) {
			gchar* _tmp40_ = NULL;
			gchar _tmp41_ = '\0';
			_tmp40_ = self->priv->current;
			_tmp41_ = _tmp40_[2];
			_tmp38_ = _tmp41_ == '*';
		} else {
			_tmp38_ = FALSE;
		}
		_tmp42_ = _tmp38_;
		if (_tmp42_) {
			result = FALSE;
			_vala_source_reference_unref0 (source_reference);
			return result;
		}
		_tmp44_ = self->priv->current;
		_tmp45_ = _tmp44_[2];
		if (_tmp45_ == '*') {
			_tmp43_ = TRUE;
		} else {
			gboolean _tmp46_ = FALSE;
			_tmp46_ = file_comment;
			_tmp43_ = _tmp46_;
		}
		_tmp47_ = _tmp43_;
		if (_tmp47_) {
			ValaSourceReference* _tmp48_ = NULL;
			_tmp48_ = vala_scanner_get_source_reference (self, 0, 0);
			_vala_source_reference_unref0 (source_reference);
			source_reference = _tmp48_;
		}
		_tmp49_ = self->priv->current;
		self->priv->current = _tmp49_ + 2;
		_tmp50_ = self->priv->current;
		begin = _tmp50_;
		while (TRUE) {
			gboolean _tmp51_ = FALSE;
			gchar* _tmp52_ = NULL;
			gchar* _tmp53_ = NULL;
			gboolean _tmp60_ = FALSE;
			gchar* _tmp61_ = NULL;
			gchar _tmp62_ = '\0';
			gchar* _tmp64_ = NULL;
			gint _tmp65_ = 0;
			_tmp52_ = self->priv->current;
			_tmp53_ = self->priv->end;
			if (_tmp52_ < (_tmp53_ - 1)) {
				gboolean _tmp54_ = FALSE;
				gchar* _tmp55_ = NULL;
				gchar _tmp56_ = '\0';
				gboolean _tmp59_ = FALSE;
				_tmp55_ = self->priv->current;
				_tmp56_ = _tmp55_[0];
				if (_tmp56_ != '*') {
					_tmp54_ = TRUE;
				} else {
					gchar* _tmp57_ = NULL;
					gchar _tmp58_ = '\0';
					_tmp57_ = self->priv->current;
					_tmp58_ = _tmp57_[1];
					_tmp54_ = _tmp58_ != '/';
				}
				_tmp59_ = _tmp54_;
				_tmp51_ = _tmp59_;
			} else {
				_tmp51_ = FALSE;
			}
			_tmp60_ = _tmp51_;
			if (!_tmp60_) {
				break;
			}
			_tmp61_ = self->priv->current;
			_tmp62_ = _tmp61_[0];
			if (_tmp62_ == '\n') {
				gint _tmp63_ = 0;
				_tmp63_ = self->priv->line;
				self->priv->line = _tmp63_ + 1;
				self->priv->column = 0;
			}
			_tmp64_ = self->priv->current;
			self->priv->current = _tmp64_ + 1;
			_tmp65_ = self->priv->column;
			self->priv->column = _tmp65_ + 1;
		}
		_tmp66_ = self->priv->current;
		_tmp67_ = self->priv->end;
		if (_tmp66_ == (_tmp67_ - 1)) {
			ValaSourceReference* _tmp68_ = NULL;
			ValaSourceReference* _tmp69_ = NULL;
			_tmp68_ = vala_scanner_get_source_reference (self, 0, 0);
			_tmp69_ = _tmp68_;
			vala_report_error (_tmp69_, "syntax error, expected */");
			_vala_source_reference_unref0 (_tmp69_);
			result = TRUE;
			_vala_source_reference_unref0 (source_reference);
			return result;
		}
		_tmp70_ = source_reference;
		if (_tmp70_ != NULL) {
			gchar* _tmp71_ = NULL;
			gchar* _tmp72_ = NULL;
			gchar* _tmp73_ = NULL;
			gchar* _tmp74_ = NULL;
			gchar* _tmp75_ = NULL;
			ValaSourceReference* _tmp76_ = NULL;
			gboolean _tmp77_ = FALSE;
			_tmp71_ = begin;
			_tmp72_ = self->priv->current;
			_tmp73_ = begin;
			_tmp74_ = string_substring ((const gchar*) _tmp71_, (glong) 0, (glong) (_tmp72_ - _tmp73_));
			_tmp75_ = _tmp74_;
			_tmp76_ = source_reference;
			_tmp77_ = file_comment;
			vala_scanner_push_comment (self, _tmp75_, _tmp76_, _tmp77_);
			_g_free0 (_tmp75_);
		}
		_tmp78_ = self->priv->current;
		self->priv->current = _tmp78_ + 2;
		_tmp79_ = self->priv->column;
		self->priv->column = _tmp79_ + 2;
		_vala_source_reference_unref0 (source_reference);
	}
	result = TRUE;
	return result;
}


static void vala_scanner_space (ValaScanner* self) {
	g_return_if_fail (self != NULL);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		gboolean _tmp3_ = FALSE;
		_tmp1_ = vala_scanner_whitespace (self);
		if (_tmp1_) {
			_tmp0_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			_tmp2_ = vala_scanner_comment (self, FALSE);
			_tmp0_ = _tmp2_;
		}
		_tmp3_ = _tmp0_;
		if (!_tmp3_) {
			break;
		}
	}
}


void vala_scanner_parse_file_comments (ValaScanner* self) {
	g_return_if_fail (self != NULL);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		gboolean _tmp3_ = FALSE;
		_tmp1_ = vala_scanner_whitespace (self);
		if (_tmp1_) {
			_tmp0_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			_tmp2_ = vala_scanner_comment (self, TRUE);
			_tmp0_ = _tmp2_;
		}
		_tmp3_ = _tmp0_;
		if (!_tmp3_) {
			break;
		}
	}
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static void vala_scanner_push_comment (ValaScanner* self, const gchar* comment_item, ValaSourceReference* source_reference, gboolean file_comment) {
	const gchar* _tmp0_ = NULL;
	gchar _tmp1_ = '\0';
	gboolean _tmp8_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (comment_item != NULL);
	g_return_if_fail (source_reference != NULL);
	_tmp0_ = comment_item;
	_tmp1_ = string_get (_tmp0_, (glong) 0);
	if (_tmp1_ == '*') {
		ValaComment* _tmp2_ = NULL;
		const gchar* _tmp5_ = NULL;
		ValaSourceReference* _tmp6_ = NULL;
		ValaComment* _tmp7_ = NULL;
		_tmp2_ = self->priv->_comment;
		if (_tmp2_ != NULL) {
			ValaSourceFile* _tmp3_ = NULL;
			ValaComment* _tmp4_ = NULL;
			_tmp3_ = self->priv->_source_file;
			_tmp4_ = self->priv->_comment;
			vala_source_file_add_comment (_tmp3_, _tmp4_);
		}
		_tmp5_ = comment_item;
		_tmp6_ = source_reference;
		_tmp7_ = vala_comment_new (_tmp5_, _tmp6_);
		_vala_comment_unref0 (self->priv->_comment);
		self->priv->_comment = _tmp7_;
	}
	_tmp8_ = file_comment;
	if (_tmp8_) {
		ValaSourceFile* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		ValaSourceReference* _tmp11_ = NULL;
		ValaComment* _tmp12_ = NULL;
		ValaComment* _tmp13_ = NULL;
		_tmp9_ = self->priv->_source_file;
		_tmp10_ = comment_item;
		_tmp11_ = source_reference;
		_tmp12_ = vala_comment_new (_tmp10_, _tmp11_);
		_tmp13_ = _tmp12_;
		vala_source_file_add_comment (_tmp9_, _tmp13_);
		_vala_comment_unref0 (_tmp13_);
		_vala_comment_unref0 (self->priv->_comment);
		self->priv->_comment = NULL;
	}
}


/**
 * Clears and returns the content of the comment stack.
 *
 * @return saved comment
 */
static gpointer _vala_comment_ref0 (gpointer self) {
	return self ? vala_comment_ref (self) : NULL;
}


ValaComment* vala_scanner_pop_comment (ValaScanner* self) {
	ValaComment* result = NULL;
	ValaComment* _tmp0_ = NULL;
	ValaComment* comment = NULL;
	ValaComment* _tmp1_ = NULL;
	ValaComment* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_comment;
	if (_tmp0_ == NULL) {
		result = NULL;
		return result;
	}
	_tmp1_ = self->priv->_comment;
	_tmp2_ = _vala_comment_ref0 (_tmp1_);
	comment = _tmp2_;
	_vala_comment_unref0 (self->priv->_comment);
	self->priv->_comment = NULL;
	result = comment;
	return result;
}


ValaSourceFile* vala_scanner_get_source_file (ValaScanner* self) {
	ValaSourceFile* result;
	ValaSourceFile* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_source_file;
	result = _tmp0_;
	return result;
}


static gpointer _vala_source_file_ref0 (gpointer self) {
	return self ? vala_source_file_ref (self) : NULL;
}


static void vala_scanner_set_source_file (ValaScanner* self, ValaSourceFile* value) {
	ValaSourceFile* _tmp0_ = NULL;
	ValaSourceFile* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_source_file_ref0 (_tmp0_);
	_vala_source_file_unref0 (self->priv->_source_file);
	self->priv->_source_file = _tmp1_;
}


static ValaScannerConditional* vala_scanner_conditional_dup (const ValaScannerConditional* self) {
	ValaScannerConditional* dup;
	dup = g_new0 (ValaScannerConditional, 1);
	memcpy (dup, self, sizeof (ValaScannerConditional));
	return dup;
}


static void vala_scanner_conditional_free (ValaScannerConditional* self) {
	g_free (self);
}


static GType vala_scanner_conditional_get_type (void) {
	static volatile gsize vala_scanner_conditional_type_id__volatile = 0;
	if (g_once_init_enter (&vala_scanner_conditional_type_id__volatile)) {
		GType vala_scanner_conditional_type_id;
		vala_scanner_conditional_type_id = g_boxed_type_register_static ("ValaScannerConditional", (GBoxedCopyFunc) vala_scanner_conditional_dup, (GBoxedFreeFunc) vala_scanner_conditional_free);
		g_once_init_leave (&vala_scanner_conditional_type_id__volatile, vala_scanner_conditional_type_id);
	}
	return vala_scanner_conditional_type_id__volatile;
}


static void vala_value_scanner_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void vala_value_scanner_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		vala_scanner_unref (value->data[0].v_pointer);
	}
}


static void vala_value_scanner_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_scanner_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer vala_value_scanner_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* vala_value_scanner_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ValaScanner* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_scanner_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* vala_value_scanner_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ValaScanner** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_scanner_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* vala_param_spec_scanner (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ValaParamSpecScanner* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_TYPE_SCANNER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer vala_value_get_scanner (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_SCANNER), NULL);
	return value->data[0].v_pointer;
}


void vala_value_set_scanner (GValue* value, gpointer v_object) {
	ValaScanner* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_SCANNER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_SCANNER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_scanner_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_scanner_unref (old);
	}
}


void vala_value_take_scanner (GValue* value, gpointer v_object) {
	ValaScanner* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_SCANNER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_SCANNER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_scanner_unref (old);
	}
}


static void vala_scanner_class_init (ValaScannerClass * klass) {
	vala_scanner_parent_class = g_type_class_peek_parent (klass);
	VALA_SCANNER_CLASS (klass)->finalize = vala_scanner_finalize;
	g_type_class_add_private (klass, sizeof (ValaScannerPrivate));
}


static void vala_scanner_instance_init (ValaScanner * self) {
	self->priv = VALA_SCANNER_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void vala_scanner_finalize (ValaScanner* obj) {
	ValaScanner * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_SCANNER, ValaScanner);
	_vala_source_file_unref0 (self->priv->_source_file);
	_vala_comment_unref0 (self->priv->_comment);
	self->priv->conditional_stack = (g_free (self->priv->conditional_stack), NULL);
	self->priv->state_stack = (g_free (self->priv->state_stack), NULL);
}


/**
 * Lexical scanner for Vala source files.
 */
GType vala_scanner_get_type (void) {
	static volatile gsize vala_scanner_type_id__volatile = 0;
	if (g_once_init_enter (&vala_scanner_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { vala_value_scanner_init, vala_value_scanner_free_value, vala_value_scanner_copy_value, vala_value_scanner_peek_pointer, "p", vala_value_scanner_collect_value, "p", vala_value_scanner_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaScannerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_scanner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaScanner), 0, (GInstanceInitFunc) vala_scanner_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType vala_scanner_type_id;
		vala_scanner_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaScanner", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&vala_scanner_type_id__volatile, vala_scanner_type_id);
	}
	return vala_scanner_type_id__volatile;
}


gpointer vala_scanner_ref (gpointer instance) {
	ValaScanner* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void vala_scanner_unref (gpointer instance) {
	ValaScanner* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_SCANNER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



