#include <stdio.h>

unsigned long long out[2];

unsigned int msacsr;

unsigned int  flt  = 0;
unsigned int  flto = 0;
unsigned long long dbl = 0;

unsigned int reg;

unsigned long long datad[] = {
   0xfff0000000000000, 0x3fe0000000000000, // -inf, 0.5
   0xc3e0000020000000, 0xc005395810624dd3, // -9223373136366403584, -2.653
   0x8000006000000000, 0x4085e5999999999a, // -1e-49, 700.7
   0x8000000000000000, 0xc088f8f5c28f5c29, // -0, -799.12
   0x0000000000000000, 0x407b13ae147ae148, // +0, 433.23
   0x0000006000000000, 0xbfe6666666666666, // 1e-49, -0.7
   0x4141a828c51eb852, 0x3ff199999999999a, // 2314321.54, 1.1
   0x7ff0000000000000, 0xc1b59e0837b33333, // +inf, -362678327.7
   0x4082000000000000, 0x40e6252666666666, // 576.0, 45353.2
   0x4082000000000000, 0x4082000000000000, // 576.0, 576.0
   0x7ff0000000006000, 0x40e6252666666666, // qnan, 45353.2
   0x7ff8000000006000, 0x4082000000000000  // snan, 576.0
};

unsigned long long dataf[] = {
   0xff8000003f000000, // -inf, 0.5
   0xcf000001c029cac1, // -2147483904, -2.653
   0x80500000442f2ccd, // -sub, 700.7
   0x80000000c447c7ae, // -0, -799.12
   0x0000000043d89d71, // +0, 433.23
   0x00500000bf333333, // sub, -0.7
   0x46b4a3143f8ccccd, // 23121.54, 1.1
   0x7f800000c70dabb3, // +inf, -36267.7
   0xc029cac1c791bfa9, // -2.653, -74623.321
   0x44100000458db99a, // 576.0, 4535.2
   0x4410000044100000, // 576.0, 576.0
   0x7f800060458db99a, // qnan, 4535.2
   0x7fc0006044100000, // snan, 576.0
};

unsigned long long data16[] = {
   0x80006179fc00c14e,
   0xfc00c14efc003800,
   0x7e005ec57fffe23e,
   0x8000e23effff6179,
   0x75a53c660004b99a,
   0x0000b99a00005ec5,
   0x7dff6c6e7c00f86d,
   0x7c00f86d75a53c66,
   0xc14efc007dff6080,
   0x7dff60807dff6c6e,
   0x800100013c66f5a5,
   0x3c66f5a5c14efc00,
};

#define TEST_3RF(instruction, data, offset1, offset2, WD, WS, WT)      \
{                                                                      \
   __asm__ volatile (                                                  \
      ".set push;\n\t"                                                 \
      ".set noreorder;\n\t"                                            \
      "ctcmsa $1, %2\n\t"                                              \
      "move $t0, %0\n\t"                                               \
      "ld.d $"#WD", "#offset1"($t0)\n\t"                               \
      "xori.b $"#WD", $"#WD", 0xff\n\t"                                \
      "ld.d $"#WS", "#offset1"($t0)\n\t"                               \
      "ld.d $"#WT", "#offset2"($t0)\n\t"                               \
      instruction" $"#WD", $"#WS", $"#WT"\n\t"                         \
      "move $t0, %1\n\t"                                               \
      "st.d $"#WD", 0($t0)\n\t"                                        \
      "cfcmsa %2, $1\n\t"                                              \
      ".set pop;\n\t"                                                  \
      :                                                                \
      : "r" (data), "r" (out), "r"(msacsr)                             \
      : "t0", "memory"                                                 \
   );                                                                  \
   printf(instruction" $"#WD", $"#WS", $"#WT" "#WD":"                  \
          " %016llx%016llx  "#WS": %016llx%016llx  "#WT": "            \
          "%016llx%016llx msacsr %08x\n", out[1], out[0],              \
          data[offset1 / 8 + 1], data[offset1 / 8],                    \
          data[offset2 / 8 + 1], data[offset2 / 8], msacsr);           \
}

#define TEST_3RF_3(instruction, data, offset1, offset2, offset3, WD, WS, WT) \
{                                                                            \
   __asm__ volatile (                                                        \
      ".set push;\n\t"                                                       \
      ".set noreorder;\n\t"                                                  \
      "ctcmsa $1, %2\n\t"                                                    \
      "move $t0, %0\n\t"                                                     \
      "ld.d $"#WD", "#offset1"($t0)\n\t"                                     \
      "ld.d $"#WS", "#offset2"($t0)\n\t"                                     \
      "ld.d $"#WT", "#offset3"($t0)\n\t"                                     \
      instruction" $"#WD", $"#WS", $"#WT"\n\t"                               \
      "move $t0, %1\n\t"                                                     \
      "st.d $"#WD", 0($t0)\n\t"                                              \
      "cfcmsa %2, $1\n\t"                                                    \
      ".set pop;\n\t"                                                        \
      :                                                                      \
      : "r" (data), "r" (out), "r"(msacsr)                                   \
      : "t0", "memory"                                                       \
   );                                                                        \
   printf(instruction" $"#WD", $"#WS", $"#WT" "#WD":"                        \
          " %016llx%016llx  "#WS": %016llx%016llx  "#WT": "                  \
          "%016llx%016llx res: %016llx%016llx msacsr %08x\n",                \
          data[offset1 / 8 + 1], data[offset1 / 8],                          \
          data[offset2 / 8 + 1], data[offset2 / 8],                          \
          data[offset3 / 8 + 1], data[offset3 / 8], out[1], out[0], msacsr); \
}


#define TEST_2RF(instruction, data, offset, WD, WS)                    \
{                                                                      \
   __asm__ volatile (                                                  \
      ".set push;\n\t"                                                 \
      ".set noreorder;\n\t"                                            \
      "ctcmsa $1, %2\n\t"                                              \
      "move $t0, %0\n\t"                                               \
      "ld.d $"#WD", "#offset"($t0)\n\t"                                \
      "xori.b $"#WD", $"#WD", 0xff\n\t"                                \
      "ld.d $"#WS", "#offset"($t0)\n\t"                                \
      instruction" $"#WD", $"#WS"\n\t"                                 \
      "move $t0, %1\n\t"                                               \
      "st.d $"#WD", 0($t0)\n\t"                                        \
      "cfcmsa %2, $1\n\t"                                              \
      ".set pop;\n\t"                                                  \
      :                                                                \
      : "r" (data), "r" (out), "r"(msacsr)                             \
      : "t0", "memory"                                                 \
   );                                                                  \
   printf(instruction" $"#WD", $"#WS", "#WD":"                         \
          " %016llx%016llx  "#WS": %016llx%016llx msacsr %08x\n",      \
          out[1], out[0],                                              \
          data[offset / 8 + 1], data[offset / 8], msacsr);             \
}


#define TEST_MSA_FPU_REG32(WS)                                         \
{                                                                      \
   flt = 0;                                                            \
   __asm__ volatile (                                                  \
      ".set push;\n\t"                                                 \
      ".set noreorder;\n\t"                                            \
      "move $t0, %0\n\t"                                               \
      "ld.d $w"#WS", 0($t0)\n\t"                                       \
      "move $t0, %1\n\t"                                               \
      "swc1 $f"#WS", 0($t0)\n\t"                                       \
      ".set pop;\n\t"                                                  \
      :                                                                \
      : "r" (dataf), "r" (&flt)                                        \
      : "t0", "memory"                                                 \
   );                                                                  \
   printf("Load MSA store FPU  $"#WS                                   \
          " %016llx%016llx flt %08x\n",                                \
          dataf[1], dataf[0], flt );                                   \
}

#define TEST_MSA_FPU_REG64(WS)                                         \
{                                                                      \
   dbl = 0;                                                            \
   __asm__ volatile (                                                  \
      ".set push;\n\t"                                                 \
      ".set noreorder;\n\t"                                            \
      "move $t0, %0\n\t"                                               \
      "ld.d $w"#WS", 0($t0)\n\t"                                       \
      "move $t0, %1\n\t"                                               \
      "sdc1 $f"#WS", 0($t0)\n\t"                                       \
      ".set pop;\n\t"                                                  \
      :                                                                \
      : "r" (dataf), "r" (&dbl)                                        \
      : "t0", "memory"                                                 \
   );                                                                  \
   printf("Load MSA store FPU  $"#WS                                   \
          " %016llx%016llx dbl %016llx\n",                             \
          dataf[1], dataf[0], dbl );                                   \
}

#define TEST_FPU_MSA_REG32(WS)                                         \
{                                                                      \
   flt = 0xFFFFFFFF;                                                   \
   flto = 0xAAAAAAAA;                                                  \
   __asm__ volatile (                                                  \
      ".set push;\n\t"                                                 \
      ".set noreorder;\n\t"                                            \
      "ldi.b $w"#WS", 0\n\t"                                           \
      "move $t0, %1\n\t"                                               \
      "lwc1 $f"#WS", 0($t0)\n\t"                                       \
      "copy_s.w %0, $w"#WS"[0]\n\t"                                    \
      ".set pop;\n\t"                                                  \
      : "=r" (flto)                                                    \
      : "r" (&flt)                                                     \
      : "t0", "memory"                                                 \
   );                                                                  \
   printf("Load FPU store MSA  $"#WS                                   \
          " %08x flt %08x\n",                                          \
          flto, flt );                                                 \
}

#define TEST_FPU_MSA_REG64(WS)                                         \
{                                                                      \
   dbl = 0xFFFFFFFFFFFFFFFF;                                           \
   out[0]= out[1] = 0xAAAAAAAAAAAAAAAA;                                \
   __asm__ volatile (                                                  \
      ".set push;\n\t"                                                 \
      ".set noreorder;\n\t"                                            \
      "ldi.b $w"#WS", 0\n\t"                                           \
      "move $t0, %1\n\t"                                               \
      "ldc1 $f"#WS", 0($t0)\n\t"                                       \
      "move $t0, %0\n\t"                                               \
      "st.d $w"#WS", 0($t0)\n\t"                                       \
      ".set pop;\n\t"                                                  \
      :                                                                \
      : "r" (out), "r" (&dbl)                                          \
      : "t0", "memory"                                                 \
   );                                                                  \
   printf("Load FPU store MSA  $"#WS                                   \
          " %016llx dbl %016llx\n",                                    \
          out[0], dbl );                                               \
}

int main(int argc, char **argv) {
#if defined(__mips_msa)
   int i;
   msacsr = 0;

   // Rounding mode not significant.
   TEST_3RF("fmax.w", dataf,   0,   0, w26, w24, w29);
   TEST_3RF("fmax.w", dataf,   0,   8, w11, w10, w26);
   TEST_3RF("fmax.w", dataf,   0,  16, w5,  w23, w15);
   TEST_3RF("fmax.w", dataf,   0,  24, w27, w26, w8);
   TEST_3RF("fmax.w", dataf,   0,  32, w29, w27, w13);
   TEST_3RF("fmax.w", dataf,   0,  40, w3,  w6,  w28);
   TEST_3RF("fmax.w", dataf,   0,  48, w25, w15, w18);
   TEST_3RF("fmax.w", dataf,   0,  56, w16, w12, w5);
   TEST_3RF("fmax.w", dataf,   0,  64, w7,  w28, w9);
   TEST_3RF("fmax.w", dataf,   0,  72, w26, w17, w23);
   TEST_3RF("fmax.w", dataf,   8,   0, w20, w9,  w0);
   TEST_3RF("fmax.w", dataf,   8,   8, w19, w19, w15);
   TEST_3RF("fmax.w", dataf,   8,  16, w5,  w10, w30);
   TEST_3RF("fmax.w", dataf,   8,  24, w0,  w5,  w7);
   TEST_3RF("fmax.w", dataf,   8,  32, w30, w0,  w20);
   TEST_3RF("fmax.w", dataf,   8,  40, w1,  w7,  w17);
   TEST_3RF("fmax.w", dataf,   8,  48, w26, w22, w3);
   TEST_3RF("fmax.w", dataf,   8,  56, w10, w6,  w15);
   TEST_3RF("fmax.w", dataf,   8,  64, w16, w13, w11);
   TEST_3RF("fmax.w", dataf,   8,  72, w25, w7,  w28);
   TEST_3RF("fmax.w", dataf,  16,   0, w17, w28, w5);
   TEST_3RF("fmax.w", dataf,  16,   8, w5,  w28, w24);
   TEST_3RF("fmax.w", dataf,  16,  16, w20, w1,  w3);
   TEST_3RF("fmax.w", dataf,  16,  24, w19, w19, w1);
   TEST_3RF("fmax.w", dataf,  16,  32, w8,  w26, w31);
   TEST_3RF("fmax.w", dataf,  16,  40, w8,  w14, w0);
   TEST_3RF("fmax.w", dataf,  16,  48, w15, w31, w27);
   TEST_3RF("fmax.w", dataf,  16,  56, w6,  w2,  w5);
   TEST_3RF("fmax.w", dataf,  16,  64, w12, w18, w21);
   TEST_3RF("fmax.w", dataf,  16,  72, w26, w29, w15);
   TEST_3RF("fmax.w", dataf,  24,   0, w1,  w26, w0);
   TEST_3RF("fmax.w", dataf,  24,   8, w29, w31, w5);
   TEST_3RF("fmax.w", dataf,  24,  16, w25, w24, w26);
   TEST_3RF("fmax.w", dataf,  24,  24, w26, w27, w13);
   TEST_3RF("fmax.w", dataf,  24,  32, w28, w3,  w7);
   TEST_3RF("fmax.w", dataf,  24,  40, w27, w11, w21);
   TEST_3RF("fmax.w", dataf,  24,  48, w28, w27, w21);
   TEST_3RF("fmax.w", dataf,  24,  56, w23, w1,  w28);
   TEST_3RF("fmax.w", dataf,  24,  64, w13, w9,  w18);
   TEST_3RF("fmax.w", dataf,  24,  72, w7,  w1,  w9);
   TEST_3RF("fmax.w", dataf,  32,   0, w1,  w6,  w0);
   TEST_3RF("fmax.w", dataf,  32,   8, w6,  w0,  w24);
   TEST_3RF("fmax.w", dataf,  32,  16, w0,  w26, w19);
   TEST_3RF("fmax.w", dataf,  32,  24, w13, w22, w20);
   TEST_3RF("fmax.w", dataf,  32,  32, w18, w2,  w10);
   TEST_3RF("fmax.w", dataf,  32,  40, w14, w29, w29);
   TEST_3RF("fmax.w", dataf,  32,  48, w31, w5,  w30);
   TEST_3RF("fmax.w", dataf,  32,  56, w22, w1,  w11);
   TEST_3RF("fmax.w", dataf,  32,  64, w0,  w19, w7);
   TEST_3RF("fmax.w", dataf,  32,  72, w20, w28, w8);
   TEST_3RF("fmax.w", dataf,  40,   0, w21, w2,  w21);
   TEST_3RF("fmax.w", dataf,  40,   8, w8,  w28, w2);
   TEST_3RF("fmax.w", dataf,  40,  16, w1,  w28, w29);
   TEST_3RF("fmax.w", dataf,  40,  24, w20, w10, w19);
   TEST_3RF("fmax.w", dataf,  40,  32, w11, w30, w5);
   TEST_3RF("fmax.w", dataf,  40,  40, w13, w8,  w19);
   TEST_3RF("fmax.w", dataf,  40,  48, w10, w7,  w24);
   TEST_3RF("fmax.w", dataf,  40,  56, w8,  w30, w26);
   TEST_3RF("fmax.w", dataf,  40,  64, w19, w19, w30);
   TEST_3RF("fmax.w", dataf,  40,  72, w13, w6,  w5);
   TEST_3RF("fmax.w", dataf,  48,   0, w2,  w13, w23);
   TEST_3RF("fmax.w", dataf,  48,   8, w5,  w21, w19);
   TEST_3RF("fmax.w", dataf,  48,  16, w7,  w22, w16);
   TEST_3RF("fmax.w", dataf,  48,  24, w4,  w4,  w4);
   TEST_3RF("fmax.w", dataf,  48,  32, w11, w26, w24);
   TEST_3RF("fmax.w", dataf,  48,  40, w22, w24, w29);
   TEST_3RF("fmax.w", dataf,  48,  48, w3,  w1,  w17);
   TEST_3RF("fmax.w", dataf,  48,  56, w13, w8,  w9);
   TEST_3RF("fmax.w", dataf,  48,  64, w21, w6,  w21);
   TEST_3RF("fmax.w", dataf,  48,  72, w3,  w8,  w4);
   TEST_3RF("fmax.w", dataf,  56,   0, w17, w15, w9);
   TEST_3RF("fmax.w", dataf,  56,   8, w19, w19, w17);
   TEST_3RF("fmax.w", dataf,  56,  16, w22, w10, w12);
   TEST_3RF("fmax.w", dataf,  56,  24, w30, w2,  w14);
   TEST_3RF("fmax.w", dataf,  56,  32, w2,  w13, w8);
   TEST_3RF("fmax.w", dataf,  56,  40, w26, w3,  w0);
   TEST_3RF("fmax.w", dataf,  56,  48, w24, w6,  w1);
   TEST_3RF("fmax.w", dataf,  56,  56, w9,  w19, w10);
   TEST_3RF("fmax.w", dataf,  56,  64, w18, w8,  w16);
   TEST_3RF("fmax.w", dataf,  56,  72, w22, w17, w21);
   TEST_3RF("fmax.w", dataf,  64,   0, w7,  w0,  w30);
   TEST_3RF("fmax.w", dataf,  64,   8, w26, w17, w21);
   TEST_3RF("fmax.w", dataf,  64,  16, w4,  w4,  w4);
   TEST_3RF("fmax.w", dataf,  64,  24, w8,  w1,  w2);
   TEST_3RF("fmax.w", dataf,  64,  32, w6,  w3,  w16);
   TEST_3RF("fmax.w", dataf,  64,  40, w8,  w17, w24);
   TEST_3RF("fmax.w", dataf,  64,  48, w3,  w20, w25);
   TEST_3RF("fmax.w", dataf,  64,  56, w27, w26, w4);
   TEST_3RF("fmax.w", dataf,  64,  64, w14, w4,  w4);
   TEST_3RF("fmax.w", dataf,  64,  72, w22, w23, w21);
   TEST_3RF("fmax.w", dataf,  72,   0, w12, w8,  w10);
   TEST_3RF("fmax.w", dataf,  72,   8, w19, w19, w8);
   TEST_3RF("fmax.w", dataf,  72,  16, w8,  w13, w25);
   TEST_3RF("fmax.w", dataf,  72,  24, w29, w18, w1);
   TEST_3RF("fmax.w", dataf,  72,  32, w30, w20, w7);
   TEST_3RF("fmax.w", dataf,  72,  40, w2,  w5,  w16);
   TEST_3RF("fmax.w", dataf,  72,  48, w19, w19, w29);
   TEST_3RF("fmax.w", dataf,  72,  56, w19, w19, w7);
   TEST_3RF("fmax.w", dataf,  72,  64, w22, w14, w2);
   TEST_3RF("fmax.w", dataf,  72,  72, w17, w18, w21);
   TEST_3RF("fmax.d", datad,   0,   0, w8,  w10, w21);
   TEST_3RF("fmax.d", datad,   0,  16, w16, w20, w8);
   TEST_3RF("fmax.d", datad,   0,  32, w24, w29, w22);
   TEST_3RF("fmax.d", datad,   0,  48, w17, w26, w8);
   TEST_3RF("fmax.d", datad,   0,  64, w19, w19, w25);
   TEST_3RF("fmax.d", datad,   0,  80, w28, w26, w27);
   TEST_3RF("fmax.d", datad,   0,  96, w1,  w10, w14);
   TEST_3RF("fmax.d", datad,   0, 112, w31, w29, w21);
   TEST_3RF("fmax.d", datad,   0, 128, w21, w11, w21);
   TEST_3RF("fmax.d", datad,   0, 144, w24, w6,  w29);
   TEST_3RF("fmax.d", datad,  16,   0, w9,  w28, w6);
   TEST_3RF("fmax.d", datad,  16,  16, w17, w6,  w27);
   TEST_3RF("fmax.d", datad,  16,  32, w1,  w27, w3);
   TEST_3RF("fmax.d", datad,  16,  48, w25, w24, w10);
   TEST_3RF("fmax.d", datad,  16,  64, w18, w1,  w29);
   TEST_3RF("fmax.d", datad,  16,  80, w11, w30, w24);
   TEST_3RF("fmax.d", datad,  16,  96, w6,  w31, w2);
   TEST_3RF("fmax.d", datad,  16, 112, w20, w30, w0);
   TEST_3RF("fmax.d", datad,  16, 128, w10, w20, w11);
   TEST_3RF("fmax.d", datad,  16, 144, w2,  w26, w9);
   TEST_3RF("fmax.d", datad,  32,   0, w11, w22, w15);
   TEST_3RF("fmax.d", datad,  32,  16, w28, w29, w10);
   TEST_3RF("fmax.d", datad,  32,  32, w29, w24, w13);
   TEST_3RF("fmax.d", datad,  32,  48, w22, w16, w7);
   TEST_3RF("fmax.d", datad,  32,  64, w0,  w2,  w8);
   TEST_3RF("fmax.d", datad,  32,  80, w30, w14, w6);
   TEST_3RF("fmax.d", datad,  32,  96, w22, w20, w6);
   TEST_3RF("fmax.d", datad,  32, 112, w24, w9,  w4);
   TEST_3RF("fmax.d", datad,  32, 128, w24, w19, w4);
   TEST_3RF("fmax.d", datad,  32, 144, w21, w19, w21);
   TEST_3RF("fmax.d", datad,  48,   0, w13, w0,  w9);
   TEST_3RF("fmax.d", datad,  48,  16, w28, w6,  w25);
   TEST_3RF("fmax.d", datad,  48,  32, w30, w19, w15);
   TEST_3RF("fmax.d", datad,  48,  48, w14, w26, w26);
   TEST_3RF("fmax.d", datad,  48,  64, w15, w17, w3);
   TEST_3RF("fmax.d", datad,  48,  80, w13, w31, w9);
   TEST_3RF("fmax.d", datad,  48,  96, w3,  w19, w15);
   TEST_3RF("fmax.d", datad,  48, 112, w28, w20, w15);
   TEST_3RF("fmax.d", datad,  48, 128, w12, w24, w4);
   TEST_3RF("fmax.d", datad,  48, 144, w31, w5,  w4);
   TEST_3RF("fmax.d", datad,  64,   0, w9,  w1,  w0);
   TEST_3RF("fmax.d", datad,  64,  16, w15, w7,  w25);
   TEST_3RF("fmax.d", datad,  64,  32, w14, w27, w27);
   TEST_3RF("fmax.d", datad,  64,  48, w8,  w28, w21);
   TEST_3RF("fmax.d", datad,  64,  64, w24, w13, w5);
   TEST_3RF("fmax.d", datad,  64,  80, w12, w2,  w9);
   TEST_3RF("fmax.d", datad,  64,  96, w0,  w17, w5);
   TEST_3RF("fmax.d", datad,  64, 112, w28, w5,  w25);
   TEST_3RF("fmax.d", datad,  64, 128, w12, w18, w16);
   TEST_3RF("fmax.d", datad,  64, 144, w17, w23, w21);
   TEST_3RF("fmax.d", datad,  80,   0, w26, w25, w21);
   TEST_3RF("fmax.d", datad,  80,  16, w10, w0,  w15);
   TEST_3RF("fmax.d", datad,  80,  32, w24, w27, w23);
   TEST_3RF("fmax.d", datad,  80,  48, w20, w17, w15);
   TEST_3RF("fmax.d", datad,  80,  64, w2,  w9,  w21);
   TEST_3RF("fmax.d", datad,  80,  80, w14, w11, w11);
   TEST_3RF("fmax.d", datad,  80,  96, w30, w14, w29);
   TEST_3RF("fmax.d", datad,  80, 112, w3,  w11, w2);
   TEST_3RF("fmax.d", datad,  80, 128, w28, w23, w20);
   TEST_3RF("fmax.d", datad,  80, 144, w14, w7,  w7);
   TEST_3RF("fmax.d", datad,  96,   0, w6,  w28, w0);
   TEST_3RF("fmax.d", datad,  96,  16, w31, w18, w10);
   TEST_3RF("fmax.d", datad,  96,  32, w31, w1,  w2);
   TEST_3RF("fmax.d", datad,  96,  48, w27, w24, w23);
   TEST_3RF("fmax.d", datad,  96,  64, w12, w8,  w25);
   TEST_3RF("fmax.d", datad,  96,  80, w21, w29, w21);
   TEST_3RF("fmax.d", datad,  96,  96, w7,  w1,  w27);
   TEST_3RF("fmax.d", datad,  96, 112, w22, w30, w1);
   TEST_3RF("fmax.d", datad,  96, 128, w0,  w26, w24);
   TEST_3RF("fmax.d", datad,  96, 144, w21, w9,  w21);
   TEST_3RF("fmax.d", datad, 112,   0, w31, w27, w15);
   TEST_3RF("fmax.d", datad, 112,  16, w28, w27, w14);
   TEST_3RF("fmax.d", datad, 112,  32, w14, w6,  w6);
   TEST_3RF("fmax.d", datad, 112,  48, w13, w15, w8);
   TEST_3RF("fmax.d", datad, 112,  64, w8,  w7,  w31);
   TEST_3RF("fmax.d", datad, 112,  80, w20, w15, w24);
   TEST_3RF("fmax.d", datad, 112,  96, w10, w12, w0);
   TEST_3RF("fmax.d", datad, 112, 112, w11, w7,  w22);
   TEST_3RF("fmax.d", datad, 112, 128, w9,  w5,  w23);
   TEST_3RF("fmax.d", datad, 112, 144, w9,  w0,  w15);
   TEST_3RF("fmax.d", datad, 128,   0, w30, w9,  w14);
   TEST_3RF("fmax.d", datad, 128,  16, w25, w24, w10);
   TEST_3RF("fmax.d", datad, 128,  32, w21, w6,  w21);
   TEST_3RF("fmax.d", datad, 128,  48, w24, w27, w19);
   TEST_3RF("fmax.d", datad, 128,  64, w7,  w3,  w28);
   TEST_3RF("fmax.d", datad, 128,  80, w15, w3,  w16);
   TEST_3RF("fmax.d", datad, 128,  96, w30, w27, w26);
   TEST_3RF("fmax.d", datad, 128, 112, w11, w27, w5);
   TEST_3RF("fmax.d", datad, 128, 128, w18, w17, w14);
   TEST_3RF("fmax.d", datad, 128, 144, w24, w8,  w23);
   TEST_3RF("fmax.d", datad, 144,   0, w22, w1,  w6);
   TEST_3RF("fmax.d", datad, 144,  16, w16, w25, w5);
   TEST_3RF("fmax.d", datad, 144,  32, w31, w9,  w0);
   TEST_3RF("fmax.d", datad, 144,  48, w18, w16, w3);
   TEST_3RF("fmax.d", datad, 144,  64, w14, w31, w31);
   TEST_3RF("fmax.d", datad, 144,  80, w6,  w31, w30);
   TEST_3RF("fmax.d", datad, 144,  96, w2,  w25, w9);
   TEST_3RF("fmax.d", datad, 144, 112, w29, w31, w27);
   TEST_3RF("fmax.d", datad, 144, 128, w15, w13, w19);
   TEST_3RF("fmax.d", datad, 144, 144, w23, w5,  w11);
   TEST_3RF("fmax_a.w", dataf,   0,   0, w12, w5,  w12);
   TEST_3RF("fmax_a.w", dataf,   0,   8, w5,  w17, w4);
   TEST_3RF("fmax_a.w", dataf,   0,  16, w14, w17, w23);
   TEST_3RF("fmax_a.w", dataf,   0,  24, w31, w20, w5);
   TEST_3RF("fmax_a.w", dataf,   0,  32, w30, w27, w4);
   TEST_3RF("fmax_a.w", dataf,   0,  40, w28, w28, w29);
   TEST_3RF("fmax_a.w", dataf,   0,  48, w30, w5,  w26);
   TEST_3RF("fmax_a.w", dataf,   0,  56, w29, w1,  w9);
   TEST_3RF("fmax_a.w", dataf,   0,  64, w10, w20, w1);
   TEST_3RF("fmax_a.w", dataf,   0,  72, w16, w0,  w12);
   TEST_3RF("fmax_a.w", dataf,   8,   0, w12, w5,  w12);
   TEST_3RF("fmax_a.w", dataf,   8,   8, w24, w18, w10);
   TEST_3RF("fmax_a.w", dataf,   8,  16, w9,  w22, w25);
   TEST_3RF("fmax_a.w", dataf,   8,  24, w26, w13, w24);
   TEST_3RF("fmax_a.w", dataf,   8,  32, w14, w19, w22);
   TEST_3RF("fmax_a.w", dataf,   8,  40, w9,  w23, w19);
   TEST_3RF("fmax_a.w", dataf,   8,  48, w6,  w21, w24);
   TEST_3RF("fmax_a.w", dataf,   8,  56, w1,  w18, w25);
   TEST_3RF("fmax_a.w", dataf,   8,  64, w10, w29, w14);
   TEST_3RF("fmax_a.w", dataf,   8,  72, w11, w13, w14);
   TEST_3RF("fmax_a.w", dataf,  16,   0, w27, w25, w26);
   TEST_3RF("fmax_a.w", dataf,  16,   8, w0,  w17, w12);
   TEST_3RF("fmax_a.w", dataf,  16,  16, w11, w26, w3);
   TEST_3RF("fmax_a.w", dataf,  16,  24, w4,  w20, w16);
   TEST_3RF("fmax_a.w", dataf,  16,  32, w28, w28, w2);
   TEST_3RF("fmax_a.w", dataf,  16,  40, w3,  w18, w12);
   TEST_3RF("fmax_a.w", dataf,  16,  48, w27, w5,  w18);
   TEST_3RF("fmax_a.w", dataf,  16,  56, w16, w30, w19);
   TEST_3RF("fmax_a.w", dataf,  16,  64, w3,  w23, w30);
   TEST_3RF("fmax_a.w", dataf,  16,  72, w0,  w5,  w9);
   TEST_3RF("fmax_a.w", dataf,  24,   0, w13, w19, w5);
   TEST_3RF("fmax_a.w", dataf,  24,   8, w6,  w14, w5);
   TEST_3RF("fmax_a.w", dataf,  24,  16, w23, w26, w16);
   TEST_3RF("fmax_a.w", dataf,  24,  24, w17, w29, w20);
   TEST_3RF("fmax_a.w", dataf,  24,  32, w5,  w14, w16);
   TEST_3RF("fmax_a.w", dataf,  24,  40, w7,  w17, w3);
   TEST_3RF("fmax_a.w", dataf,  24,  48, w19, w12, w8);
   TEST_3RF("fmax_a.w", dataf,  24,  56, w6,  w29, w25);
   TEST_3RF("fmax_a.w", dataf,  24,  64, w0,  w30, w23);
   TEST_3RF("fmax_a.w", dataf,  24,  72, w0,  w3,  w1);
   TEST_3RF("fmax_a.w", dataf,  32,   0, w13, w23, w6);
   TEST_3RF("fmax_a.w", dataf,  32,   8, w19, w5,  w11);
   TEST_3RF("fmax_a.w", dataf,  32,  16, w10, w31, w28);
   TEST_3RF("fmax_a.w", dataf,  32,  24, w27, w29, w16);
   TEST_3RF("fmax_a.w", dataf,  32,  32, w0,  w11, w1);
   TEST_3RF("fmax_a.w", dataf,  32,  40, w7,  w28, w4);
   TEST_3RF("fmax_a.w", dataf,  32,  48, w27, w9,  w12);
   TEST_3RF("fmax_a.w", dataf,  32,  56, w1,  w6,  w19);
   TEST_3RF("fmax_a.w", dataf,  32,  64, w26, w6,  w17);
   TEST_3RF("fmax_a.w", dataf,  32,  72, w18, w6,  w20);
   TEST_3RF("fmax_a.w", dataf,  40,   0, w19, w11, w25);
   TEST_3RF("fmax_a.w", dataf,  40,   8, w6,  w16, w4);
   TEST_3RF("fmax_a.w", dataf,  40,  16, w16, w0,  w11);
   TEST_3RF("fmax_a.w", dataf,  40,  24, w13, w17, w11);
   TEST_3RF("fmax_a.w", dataf,  40,  32, w24, w18, w20);
   TEST_3RF("fmax_a.w", dataf,  40,  40, w22, w13, w29);
   TEST_3RF("fmax_a.w", dataf,  40,  48, w2,  w14, w3);
   TEST_3RF("fmax_a.w", dataf,  40,  56, w21, w9,  w9);
   TEST_3RF("fmax_a.w", dataf,  40,  64, w9,  w6,  w27);
   TEST_3RF("fmax_a.w", dataf,  40,  72, w15, w15, w15);
   TEST_3RF("fmax_a.w", dataf,  48,   0, w27, w14, w2);
   TEST_3RF("fmax_a.w", dataf,  48,   8, w6,  w7,  w8);
   TEST_3RF("fmax_a.w", dataf,  48,  16, w23, w11, w24);
   TEST_3RF("fmax_a.w", dataf,  48,  24, w7,  w12, w3);
   TEST_3RF("fmax_a.w", dataf,  48,  32, w20, w29, w14);
   TEST_3RF("fmax_a.w", dataf,  48,  40, w12, w15, w12);
   TEST_3RF("fmax_a.w", dataf,  48,  48, w1,  w0,  w5);
   TEST_3RF("fmax_a.w", dataf,  48,  56, w14, w30, w7);
   TEST_3RF("fmax_a.w", dataf,  48,  64, w29, w1,  w6);
   TEST_3RF("fmax_a.w", dataf,  48,  72, w11, w3,  w1);
   TEST_3RF("fmax_a.w", dataf,  56,   0, w26, w30, w15);
   TEST_3RF("fmax_a.w", dataf,  56,   8, w29, w5,  w22);
   TEST_3RF("fmax_a.w", dataf,  56,  16, w5,  w28, w1);
   TEST_3RF("fmax_a.w", dataf,  56,  24, w30, w3,  w13);
   TEST_3RF("fmax_a.w", dataf,  56,  32, w1,  w23, w10);
   TEST_3RF("fmax_a.w", dataf,  56,  40, w16, w3,  w25);
   TEST_3RF("fmax_a.w", dataf,  56,  48, w17, w3,  w30);
   TEST_3RF("fmax_a.w", dataf,  56,  56, w31, w1,  w6);
   TEST_3RF("fmax_a.w", dataf,  56,  64, w28, w28, w3);
   TEST_3RF("fmax_a.w", dataf,  56,  72, w3,  w2,  w14);
   TEST_3RF("fmax_a.w", dataf,  64,   0, w6,  w3,  w8);
   TEST_3RF("fmax_a.w", dataf,  64,   8, w5,  w18, w10);
   TEST_3RF("fmax_a.w", dataf,  64,  16, w8,  w11, w6);
   TEST_3RF("fmax_a.w", dataf,  64,  24, w10, w9,  w23);
   TEST_3RF("fmax_a.w", dataf,  64,  32, w10, w0,  w2);
   TEST_3RF("fmax_a.w", dataf,  64,  40, w26, w3,  w27);
   TEST_3RF("fmax_a.w", dataf,  64,  48, w11, w6,  w26);
   TEST_3RF("fmax_a.w", dataf,  64,  56, w11, w8,  w0);
   TEST_3RF("fmax_a.w", dataf,  64,  64, w7,  w11, w3);
   TEST_3RF("fmax_a.w", dataf,  64,  72, w10, w25, w9);
   TEST_3RF("fmax_a.w", dataf,  72,   0, w13, w1,  w14);
   TEST_3RF("fmax_a.w", dataf,  72,   8, w0,  w7,  w24);
   TEST_3RF("fmax_a.w", dataf,  72,  16, w8,  w18, w30);
   TEST_3RF("fmax_a.w", dataf,  72,  24, w18, w27, w7);
   TEST_3RF("fmax_a.w", dataf,  72,  32, w10, w5,  w7);
   TEST_3RF("fmax_a.w", dataf,  72,  40, w12, w0,  w12);
   TEST_3RF("fmax_a.w", dataf,  72,  48, w10, w7,  w11);
   TEST_3RF("fmax_a.w", dataf,  72,  56, w17, w1,  w22);
   TEST_3RF("fmax_a.w", dataf,  72,  64, w25, w1,  w30);
   TEST_3RF("fmax_a.w", dataf,  72,  72, w4,  w8,  w29);
   TEST_3RF("fmax_a.d", datad,   0,   0, w14, w21, w30);
   TEST_3RF("fmax_a.d", datad,   0,  16, w28, w28, w21);
   TEST_3RF("fmax_a.d", datad,   0,  32, w5,  w21, w30);
   TEST_3RF("fmax_a.d", datad,   0,  48, w23, w19, w16);
   TEST_3RF("fmax_a.d", datad,   0,  64, w18, w27, w26);
   TEST_3RF("fmax_a.d", datad,   0,  80, w24, w2,  w6);
   TEST_3RF("fmax_a.d", datad,   0,  96, w24, w13, w14);
   TEST_3RF("fmax_a.d", datad,   0, 112, w3,  w30, w15);
   TEST_3RF("fmax_a.d", datad,   0, 128, w26, w23, w17);
   TEST_3RF("fmax_a.d", datad,   0, 144, w24, w27, w21);
   TEST_3RF("fmax_a.d", datad,  16,   0, w0,  w24, w3);
   TEST_3RF("fmax_a.d", datad,  16,  16, w21, w22, w22);
   TEST_3RF("fmax_a.d", datad,  16,  32, w0,  w11, w28);
   TEST_3RF("fmax_a.d", datad,  16,  48, w21, w9,  w9);
   TEST_3RF("fmax_a.d", datad,  16,  64, w19, w8,  w25);
   TEST_3RF("fmax_a.d", datad,  16,  80, w6,  w3,  w20);
   TEST_3RF("fmax_a.d", datad,  16,  96, w30, w6,  w26);
   TEST_3RF("fmax_a.d", datad,  16, 112, w22, w19, w8);
   TEST_3RF("fmax_a.d", datad,  16, 128, w25, w17, w24);
   TEST_3RF("fmax_a.d", datad,  16, 144, w19, w8,  w9);
   TEST_3RF("fmax_a.d", datad,  32,   0, w11, w3,  w30);
   TEST_3RF("fmax_a.d", datad,  32,  16, w11, w27, w2);
   TEST_3RF("fmax_a.d", datad,  32,  32, w1,  w17, w2);
   TEST_3RF("fmax_a.d", datad,  32,  48, w12, w13, w12);
   TEST_3RF("fmax_a.d", datad,  32,  64, w23, w21, w1);
   TEST_3RF("fmax_a.d", datad,  32,  80, w31, w14, w7);
   TEST_3RF("fmax_a.d", datad,  32,  96, w3,  w2,  w5);
   TEST_3RF("fmax_a.d", datad,  32, 112, w9,  w29, w27);
   TEST_3RF("fmax_a.d", datad,  32, 128, w28, w28, w5);
   TEST_3RF("fmax_a.d", datad,  32, 144, w20, w13, w29);
   TEST_3RF("fmax_a.d", datad,  48,   0, w8,  w21, w6);
   TEST_3RF("fmax_a.d", datad,  48,  16, w19, w24, w5);
   TEST_3RF("fmax_a.d", datad,  48,  32, w31, w19, w7);
   TEST_3RF("fmax_a.d", datad,  48,  48, w0,  w4,  w9);
   TEST_3RF("fmax_a.d", datad,  48,  64, w12, w18, w12);
   TEST_3RF("fmax_a.d", datad,  48,  80, w0,  w1,  w19);
   TEST_3RF("fmax_a.d", datad,  48,  96, w31, w15, w26);
   TEST_3RF("fmax_a.d", datad,  48, 112, w2,  w18, w31);
   TEST_3RF("fmax_a.d", datad,  48, 128, w11, w15, w26);
   TEST_3RF("fmax_a.d", datad,  48, 144, w7,  w20, w14);
   TEST_3RF("fmax_a.d", datad,  64,   0, w20, w18, w22);
   TEST_3RF("fmax_a.d", datad,  64,  16, w9,  w24, w10);
   TEST_3RF("fmax_a.d", datad,  64,  32, w1,  w29, w9);
   TEST_3RF("fmax_a.d", datad,  64,  48, w20, w4,  w9);
   TEST_3RF("fmax_a.d", datad,  64,  64, w25, w13, w21);
   TEST_3RF("fmax_a.d", datad,  64,  80, w11, w13, w22);
   TEST_3RF("fmax_a.d", datad,  64,  96, w30, w13, w5);
   TEST_3RF("fmax_a.d", datad,  64, 112, w24, w15, w23);
   TEST_3RF("fmax_a.d", datad,  64, 128, w23, w27, w6);
   TEST_3RF("fmax_a.d", datad,  64, 144, w17, w2,  w27);
   TEST_3RF("fmax_a.d", datad,  80,   0, w31, w23, w13);
   TEST_3RF("fmax_a.d", datad,  80,  16, w22, w0,  w5);
   TEST_3RF("fmax_a.d", datad,  80,  32, w0,  w2,  w3);
   TEST_3RF("fmax_a.d", datad,  80,  48, w9,  w22, w7);
   TEST_3RF("fmax_a.d", datad,  80,  64, w18, w15, w21);
   TEST_3RF("fmax_a.d", datad,  80,  80, w7,  w26, w2);
   TEST_3RF("fmax_a.d", datad,  80,  96, w29, w24, w15);
   TEST_3RF("fmax_a.d", datad,  80, 112, w2,  w16, w31);
   TEST_3RF("fmax_a.d", datad,  80, 128, w26, w7,  w0);
   TEST_3RF("fmax_a.d", datad,  80, 144, w24, w28, w27);
   TEST_3RF("fmax_a.d", datad,  96,   0, w24, w19, w8);
   TEST_3RF("fmax_a.d", datad,  96,  16, w14, w20, w22);
   TEST_3RF("fmax_a.d", datad,  96,  32, w17, w23, w12);
   TEST_3RF("fmax_a.d", datad,  96,  48, w24, w9,  w28);
   TEST_3RF("fmax_a.d", datad,  96,  64, w13, w16, w22);
   TEST_3RF("fmax_a.d", datad,  96,  80, w16, w13, w15);
   TEST_3RF("fmax_a.d", datad,  96,  96, w31, w15, w30);
   TEST_3RF("fmax_a.d", datad,  96, 112, w9,  w7,  w24);
   TEST_3RF("fmax_a.d", datad,  96, 128, w10, w31, w21);
   TEST_3RF("fmax_a.d", datad,  96, 144, w5,  w23, w8);
   TEST_3RF("fmax_a.d", datad, 112,   0, w14, w5,  w28);
   TEST_3RF("fmax_a.d", datad, 112,  16, w28, w28, w19);
   TEST_3RF("fmax_a.d", datad, 112,  32, w18, w13, w10);
   TEST_3RF("fmax_a.d", datad, 112,  48, w31, w5,  w19);
   TEST_3RF("fmax_a.d", datad, 112,  64, w27, w19, w3);
   TEST_3RF("fmax_a.d", datad, 112,  80, w17, w3,  w16);
   TEST_3RF("fmax_a.d", datad, 112,  96, w0,  w2,  w1);
   TEST_3RF("fmax_a.d", datad, 112, 112, w9,  w7,  w25);
   TEST_3RF("fmax_a.d", datad, 112, 128, w19, w6,  w14);
   TEST_3RF("fmax_a.d", datad, 112, 144, w25, w30, w23);
   TEST_3RF("fmax_a.d", datad, 128,   0, w7,  w3,  w19);
   TEST_3RF("fmax_a.d", datad, 128,  16, w3,  w23, w6);
   TEST_3RF("fmax_a.d", datad, 128,  32, w16, w1,  w5);
   TEST_3RF("fmax_a.d", datad, 128,  48, w21, w0,  w0);
   TEST_3RF("fmax_a.d", datad, 128,  64, w8,  w24, w17);
   TEST_3RF("fmax_a.d", datad, 128,  80, w11, w9,  w18);
   TEST_3RF("fmax_a.d", datad, 128,  96, w14, w9,  w18);
   TEST_3RF("fmax_a.d", datad, 128, 112, w15, w15, w15);
   TEST_3RF("fmax_a.d", datad, 128, 128, w18, w25, w8);
   TEST_3RF("fmax_a.d", datad, 128, 144, w6,  w31, w23);
   TEST_3RF("fmax_a.d", datad, 144,   0, w31, w29, w14);
   TEST_3RF("fmax_a.d", datad, 144,  16, w6,  w1,  w9);
   TEST_3RF("fmax_a.d", datad, 144,  32, w24, w7,  w25);
   TEST_3RF("fmax_a.d", datad, 144,  48, w25, w12, w14);
   TEST_3RF("fmax_a.d", datad, 144,  64, w14, w12, w23);
   TEST_3RF("fmax_a.d", datad, 144,  80, w7,  w30, w2);
   TEST_3RF("fmax_a.d", datad, 144,  96, w16, w25, w2);
   TEST_3RF("fmax_a.d", datad, 144, 112, w31, w11, w27);
   TEST_3RF("fmax_a.d", datad, 144, 128, w8,  w17, w26);
   TEST_3RF("fmax_a.d", datad, 144, 144, w31, w16, w24);
   TEST_3RF("fmin.w", dataf,   0,   0, w31, w17, w22);
   TEST_3RF("fmin.w", dataf,   0,   8, w24, w10, w2);
   TEST_3RF("fmin.w", dataf,   0,  16, w7,  w25, w15);
   TEST_3RF("fmin.w", dataf,   0,  24, w30, w0,  w13);
   TEST_3RF("fmin.w", dataf,   0,  32, w0,  w16, w29);
   TEST_3RF("fmin.w", dataf,   0,  40, w17, w9,  w31);
   TEST_3RF("fmin.w", dataf,   0,  48, w16, w20, w26);
   TEST_3RF("fmin.w", dataf,   0,  56, w24, w6,  w20);
   TEST_3RF("fmin.w", dataf,   0,  64, w23, w22, w12);
   TEST_3RF("fmin.w", dataf,   0,  72, w4,  w13, w5);
   TEST_3RF("fmin.w", dataf,   8,   0, w19, w12, w22);
   TEST_3RF("fmin.w", dataf,   8,   8, w9,  w5,  w1);
   TEST_3RF("fmin.w", dataf,   8,  16, w11, w12, w26);
   TEST_3RF("fmin.w", dataf,   8,  24, w26, w10, w7);
   TEST_3RF("fmin.w", dataf,   8,  32, w10, w4,  w27);
   TEST_3RF("fmin.w", dataf,   8,  40, w19, w3,  w12);
   TEST_3RF("fmin.w", dataf,   8,  48, w7,  w29, w4);
   TEST_3RF("fmin.w", dataf,   8,  56, w13, w13, w13);
   TEST_3RF("fmin.w", dataf,   8,  64, w18, w28, w4);
   TEST_3RF("fmin.w", dataf,   8,  72, w30, w0,  w17);
   TEST_3RF("fmin.w", dataf,  16,   0, w4,  w19, w29);
   TEST_3RF("fmin.w", dataf,  16,   8, w26, w28, w2);
   TEST_3RF("fmin.w", dataf,  16,  16, w27, w8,  w14);
   TEST_3RF("fmin.w", dataf,  16,  24, w21, w2,  w24);
   TEST_3RF("fmin.w", dataf,  16,  32, w15, w10, w3);
   TEST_3RF("fmin.w", dataf,  16,  40, w25, w14, w25);
   TEST_3RF("fmin.w", dataf,  16,  48, w30, w12, w18);
   TEST_3RF("fmin.w", dataf,  16,  56, w10, w20, w15);
   TEST_3RF("fmin.w", dataf,  16,  64, w15, w1,  w11);
   TEST_3RF("fmin.w", dataf,  16,  72, w5,  w0,  w11);
   TEST_3RF("fmin.w", dataf,  24,   0, w22, w22, w4);
   TEST_3RF("fmin.w", dataf,  24,   8, w31, w20, w30);
   TEST_3RF("fmin.w", dataf,  24,  16, w27, w22, w26);
   TEST_3RF("fmin.w", dataf,  24,  24, w3,  w5,  w15);
   TEST_3RF("fmin.w", dataf,  24,  32, w6,  w29, w31);
   TEST_3RF("fmin.w", dataf,  24,  40, w16, w0,  w24);
   TEST_3RF("fmin.w", dataf,  24,  48, w30, w31, w5);
   TEST_3RF("fmin.w", dataf,  24,  56, w16, w9,  w25);
   TEST_3RF("fmin.w", dataf,  24,  64, w0,  w24, w26);
   TEST_3RF("fmin.w", dataf,  24,  72, w1,  w3,  w0);
   TEST_3RF("fmin.w", dataf,  32,   0, w1,  w15, w22);
   TEST_3RF("fmin.w", dataf,  32,   8, w5,  w14, w10);
   TEST_3RF("fmin.w", dataf,  32,  16, w4,  w9,  w1);
   TEST_3RF("fmin.w", dataf,  32,  24, w30, w13, w6);
   TEST_3RF("fmin.w", dataf,  32,  32, w13, w13, w13);
   TEST_3RF("fmin.w", dataf,  32,  40, w19, w3,  w12);
   TEST_3RF("fmin.w", dataf,  32,  48, w3,  w4,  w5);
   TEST_3RF("fmin.w", dataf,  32,  56, w1,  w3,  w10);
   TEST_3RF("fmin.w", dataf,  32,  64, w18, w12, w3);
   TEST_3RF("fmin.w", dataf,  32,  72, w18, w5,  w29);
   TEST_3RF("fmin.w", dataf,  40,   0, w19, w8,  w29);
   TEST_3RF("fmin.w", dataf,  40,   8, w21, w23, w20);
   TEST_3RF("fmin.w", dataf,  40,  16, w26, w5,  w30);
   TEST_3RF("fmin.w", dataf,  40,  24, w30, w15, w31);
   TEST_3RF("fmin.w", dataf,  40,  32, w28, w5,  w10);
   TEST_3RF("fmin.w", dataf,  40,  40, w15, w9,  w22);
   TEST_3RF("fmin.w", dataf,  40,  48, w18, w13, w27);
   TEST_3RF("fmin.w", dataf,  40,  56, w19, w16, w5);
   TEST_3RF("fmin.w", dataf,  40,  64, w5,  w28, w8);
   TEST_3RF("fmin.w", dataf,  40,  72, w23, w1,  w6);
   TEST_3RF("fmin.w", dataf,  48,   0, w11, w10, w3);
   TEST_3RF("fmin.w", dataf,  48,   8, w0,  w1,  w23);
   TEST_3RF("fmin.w", dataf,  48,  16, w26, w7,  w22);
   TEST_3RF("fmin.w", dataf,  48,  24, w25, w22, w25);
   TEST_3RF("fmin.w", dataf,  48,  32, w21, w18, w27);
   TEST_3RF("fmin.w", dataf,  48,  40, w31, w1,  w4);
   TEST_3RF("fmin.w", dataf,  48,  48, w22, w22, w19);
   TEST_3RF("fmin.w", dataf,  48,  56, w17, w6,  w1);
   TEST_3RF("fmin.w", dataf,  48,  64, w23, w12, w29);
   TEST_3RF("fmin.w", dataf,  48,  72, w31, w3,  w5);
   TEST_3RF("fmin.w", dataf,  56,   0, w14, w9,  w9);
   TEST_3RF("fmin.w", dataf,  56,   8, w9,  w14, w10);
   TEST_3RF("fmin.w", dataf,  56,  16, w0,  w9,  w17);
   TEST_3RF("fmin.w", dataf,  56,  24, w22, w22, w2);
   TEST_3RF("fmin.w", dataf,  56,  32, w7,  w12, w23);
   TEST_3RF("fmin.w", dataf,  56,  40, w25, w7,  w25);
   TEST_3RF("fmin.w", dataf,  56,  48, w23, w26, w11);
   TEST_3RF("fmin.w", dataf,  56,  56, w13, w13, w13);
   TEST_3RF("fmin.w", dataf,  56,  64, w13, w13, w13);
   TEST_3RF("fmin.w", dataf,  56,  72, w28, w30, w20);
   TEST_3RF("fmin.w", dataf,  64,   0, w29, w21, w0);
   TEST_3RF("fmin.w", dataf,  64,   8, w26, w21, w3);
   TEST_3RF("fmin.w", dataf,  64,  16, w25, w26, w25);
   TEST_3RF("fmin.w", dataf,  64,  24, w18, w2,  w3);
   TEST_3RF("fmin.w", dataf,  64,  32, w0,  w13, w4);
   TEST_3RF("fmin.w", dataf,  64,  40, w9,  w30, w26);
   TEST_3RF("fmin.w", dataf,  64,  48, w11, w6,  w3);
   TEST_3RF("fmin.w", dataf,  64,  56, w31, w13, w26);
   TEST_3RF("fmin.w", dataf,  64,  64, w26, w24, w7);
   TEST_3RF("fmin.w", dataf,  64,  72, w7,  w20, w5);
   TEST_3RF("fmin.w", dataf,  72,   0, w27, w17, w12);
   TEST_3RF("fmin.w", dataf,  72,   8, w16, w31, w5);
   TEST_3RF("fmin.w", dataf,  72,  16, w10, w17, w8);
   TEST_3RF("fmin.w", dataf,  72,  24, w14, w17, w17);
   TEST_3RF("fmin.w", dataf,  72,  32, w21, w18, w27);
   TEST_3RF("fmin.w", dataf,  72,  40, w19, w12, w6);
   TEST_3RF("fmin.w", dataf,  72,  48, w25, w19, w25);
   TEST_3RF("fmin.w", dataf,  72,  56, w9,  w25, w0);
   TEST_3RF("fmin.w", dataf,  72,  64, w3,  w19, w25);
   TEST_3RF("fmin.w", dataf,  72,  72, w10, w26, w13);
   TEST_3RF("fmin.d", datad,   0,   0, w16, w22, w31);
   TEST_3RF("fmin.d", datad,   0,  16, w11, w17, w27);
   TEST_3RF("fmin.d", datad,   0,  32, w16, w5,  w1);
   TEST_3RF("fmin.d", datad,   0,  48, w24, w19, w13);
   TEST_3RF("fmin.d", datad,   0,  64, w5,  w14, w1);
   TEST_3RF("fmin.d", datad,   0,  80, w18, w20, w26);
   TEST_3RF("fmin.d", datad,   0,  96, w5,  w30, w19);
   TEST_3RF("fmin.d", datad,   0, 112, w5,  w1,  w6);
   TEST_3RF("fmin.d", datad,   0, 128, w30, w12, w1);
   TEST_3RF("fmin.d", datad,   0, 144, w12, w28, w23);
   TEST_3RF("fmin.d", datad,  16,   0, w11, w7,  w8);
   TEST_3RF("fmin.d", datad,  16,  16, w22, w22, w2);
   TEST_3RF("fmin.d", datad,  16,  32, w25, w6,  w25);
   TEST_3RF("fmin.d", datad,  16,  48, w7,  w26, w31);
   TEST_3RF("fmin.d", datad,  16,  64, w27, w13, w12);
   TEST_3RF("fmin.d", datad,  16,  80, w0,  w27, w13);
   TEST_3RF("fmin.d", datad,  16,  96, w18, w16, w8);
   TEST_3RF("fmin.d", datad,  16, 112, w23, w14, w27);
   TEST_3RF("fmin.d", datad,  16, 128, w29, w15, w2);
   TEST_3RF("fmin.d", datad,  16, 144, w27, w3,  w7);
   TEST_3RF("fmin.d", datad,  32,   0, w23, w26, w18);
   TEST_3RF("fmin.d", datad,  32,  16, w30, w2,  w8);
   TEST_3RF("fmin.d", datad,  32,  32, w0,  w27, w15);
   TEST_3RF("fmin.d", datad,  32,  48, w8,  w22, w14);
   TEST_3RF("fmin.d", datad,  32,  64, w3,  w26, w31);
   TEST_3RF("fmin.d", datad,  32,  80, w8,  w22, w15);
   TEST_3RF("fmin.d", datad,  32,  96, w16, w13, w29);
   TEST_3RF("fmin.d", datad,  32, 112, w11, w10, w12);
   TEST_3RF("fmin.d", datad,  32, 128, w13, w13, w13);
   TEST_3RF("fmin.d", datad,  32, 144, w6,  w8,  w16);
   TEST_3RF("fmin.d", datad,  48,   0, w13, w13, w13);
   TEST_3RF("fmin.d", datad,  48,  16, w31, w10, w0);
   TEST_3RF("fmin.d", datad,  48,  32, w30, w13, w8);
   TEST_3RF("fmin.d", datad,  48,  48, w30, w8,  w23);
   TEST_3RF("fmin.d", datad,  48,  64, w6,  w30, w5);
   TEST_3RF("fmin.d", datad,  48,  80, w9,  w2,  w0);
   TEST_3RF("fmin.d", datad,  48,  96, w13, w13, w13);
   TEST_3RF("fmin.d", datad,  48, 112, w1,  w8,  w3);
   TEST_3RF("fmin.d", datad,  48, 128, w16, w24, w13);
   TEST_3RF("fmin.d", datad,  48, 144, w3,  w27, w25);
   TEST_3RF("fmin.d", datad,  64,   0, w17, w1,  w14);
   TEST_3RF("fmin.d", datad,  64,  16, w1,  w12, w14);
   TEST_3RF("fmin.d", datad,  64,  32, w31, w25, w23);
   TEST_3RF("fmin.d", datad,  64,  48, w29, w1,  w14);
   TEST_3RF("fmin.d", datad,  64,  64, w4,  w0,  w20);
   TEST_3RF("fmin.d", datad,  64,  80, w13, w13, w13);
   TEST_3RF("fmin.d", datad,  64,  96, w2,  w20, w26);
   TEST_3RF("fmin.d", datad,  64, 112, w3,  w28, w29);
   TEST_3RF("fmin.d", datad,  64, 128, w19, w20, w14);
   TEST_3RF("fmin.d", datad,  64, 144, w0,  w23, w9);
   TEST_3RF("fmin.d", datad,  80,   0, w25, w8,  w25);
   TEST_3RF("fmin.d", datad,  80,  16, w10, w27, w24);
   TEST_3RF("fmin.d", datad,  80,  32, w28, w22, w7);
   TEST_3RF("fmin.d", datad,  80,  48, w27, w15, w30);
   TEST_3RF("fmin.d", datad,  80,  64, w24, w16, w12);
   TEST_3RF("fmin.d", datad,  80,  80, w28, w16, w0);
   TEST_3RF("fmin.d", datad,  80,  96, w10, w18, w20);
   TEST_3RF("fmin.d", datad,  80, 112, w4,  w21, w16);
   TEST_3RF("fmin.d", datad,  80, 128, w2,  w8,  w4);
   TEST_3RF("fmin.d", datad,  80, 144, w16, w8,  w28);
   TEST_3RF("fmin.d", datad,  96,   0, w25, w2,  w25);
   TEST_3RF("fmin.d", datad,  96,  16, w4,  w3,  w29);
   TEST_3RF("fmin.d", datad,  96,  32, w14, w27, w27);
   TEST_3RF("fmin.d", datad,  96,  48, w25, w4,  w25);
   TEST_3RF("fmin.d", datad,  96,  64, w2,  w20, w19);
   TEST_3RF("fmin.d", datad,  96,  80, w0,  w12, w4);
   TEST_3RF("fmin.d", datad,  96,  96, w13, w13, w13);
   TEST_3RF("fmin.d", datad,  96, 112, w9,  w20, w13);
   TEST_3RF("fmin.d", datad,  96, 128, w19, w7,  w2);
   TEST_3RF("fmin.d", datad,  96, 144, w23, w28, w18);
   TEST_3RF("fmin.d", datad, 112,   0, w25, w5,  w25);
   TEST_3RF("fmin.d", datad, 112,  16, w23, w9,  w13);
   TEST_3RF("fmin.d", datad, 112,  32, w19, w2,  w15);
   TEST_3RF("fmin.d", datad, 112,  48, w23, w5,  w12);
   TEST_3RF("fmin.d", datad, 112,  64, w6,  w1,  w5);
   TEST_3RF("fmin.d", datad, 112,  80, w10, w3,  w25);
   TEST_3RF("fmin.d", datad, 112,  96, w30, w4,  w6);
   TEST_3RF("fmin.d", datad, 112, 112, w2,  w17, w15);
   TEST_3RF("fmin.d", datad, 112, 128, w22, w22, w30);
   TEST_3RF("fmin.d", datad, 112, 144, w2,  w29, w0);
   TEST_3RF("fmin.d", datad, 128,   0, w25, w26, w25);
   TEST_3RF("fmin.d", datad, 128,  16, w19, w31, w10);
   TEST_3RF("fmin.d", datad, 128,  32, w28, w12, w29);
   TEST_3RF("fmin.d", datad, 128,  48, w31, w28, w20);
   TEST_3RF("fmin.d", datad, 128,  64, w4,  w8,  w26);
   TEST_3RF("fmin.d", datad, 128,  80, w5,  w14, w9);
   TEST_3RF("fmin.d", datad, 128,  96, w7,  w3,  w13);
   TEST_3RF("fmin.d", datad, 128, 112, w13, w13, w13);
   TEST_3RF("fmin.d", datad, 128, 128, w5,  w30, w28);
   TEST_3RF("fmin.d", datad, 128, 144, w27, w28, w30);
   TEST_3RF("fmin.d", datad, 144,   0, w25, w29, w25);
   TEST_3RF("fmin.d", datad, 144,  16, w24, w19, w16);
   TEST_3RF("fmin.d", datad, 144,  32, w11, w18, w26);
   TEST_3RF("fmin.d", datad, 144,  48, w7,  w30, w23);
   TEST_3RF("fmin.d", datad, 144,  64, w6,  w26, w11);
   TEST_3RF("fmin.d", datad, 144,  80, w11, w3,  w6);
   TEST_3RF("fmin.d", datad, 144,  96, w16, w17, w11);
   TEST_3RF("fmin.d", datad, 144, 112, w25, w24, w25);
   TEST_3RF("fmin.d", datad, 144, 128, w14, w6,  w6);
   TEST_3RF("fmin.d", datad, 144, 144, w6,  w19, w4);
   TEST_3RF("fmin_a.w", dataf,   0,   0, w30, w25, w26);
   TEST_3RF("fmin_a.w", dataf,   0,   8, w14, w14, w4);
   TEST_3RF("fmin_a.w", dataf,   0,  16, w12, w8,  w11);
   TEST_3RF("fmin_a.w", dataf,   0,  24, w11, w31, w18);
   TEST_3RF("fmin_a.w", dataf,   0,  32, w5,  w10, w29);
   TEST_3RF("fmin_a.w", dataf,   0,  40, w8,  w16, w13);
   TEST_3RF("fmin_a.w", dataf,   0,  48, w25, w27, w7);
   TEST_3RF("fmin_a.w", dataf,   0,  56, w18, w9,  w13);
   TEST_3RF("fmin_a.w", dataf,   0,  64, w24, w28, w18);
   TEST_3RF("fmin_a.w", dataf,   0,  72, w26, w11, w19);
   TEST_3RF("fmin_a.w", dataf,   8,   0, w27, w18, w17);
   TEST_3RF("fmin_a.w", dataf,   8,   8, w20, w13, w31);
   TEST_3RF("fmin_a.w", dataf,   8,  16, w24, w25, w7);
   TEST_3RF("fmin_a.w", dataf,   8,  24, w4,  w6,  w22);
   TEST_3RF("fmin_a.w", dataf,   8,  32, w10, w16, w19);
   TEST_3RF("fmin_a.w", dataf,   8,  40, w18, w1,  w0);
   TEST_3RF("fmin_a.w", dataf,   8,  48, w12, w28, w7);
   TEST_3RF("fmin_a.w", dataf,   8,  56, w30, w6,  w21);
   TEST_3RF("fmin_a.w", dataf,   8,  64, w22, w2,  w7);
   TEST_3RF("fmin_a.w", dataf,   8,  72, w16, w13, w26);
   TEST_3RF("fmin_a.w", dataf,  16,   0, w12, w0,  w11);
   TEST_3RF("fmin_a.w", dataf,  16,   8, w0,  w13, w10);
   TEST_3RF("fmin_a.w", dataf,  16,  16, w25, w6,  w17);
   TEST_3RF("fmin_a.w", dataf,  16,  24, w29, w11, w23);
   TEST_3RF("fmin_a.w", dataf,  16,  32, w19, w21, w7);
   TEST_3RF("fmin_a.w", dataf,  16,  40, w6,  w7,  w8);
   TEST_3RF("fmin_a.w", dataf,  16,  48, w6,  w19, w5);
   TEST_3RF("fmin_a.w", dataf,  16,  56, w14, w14, w17);
   TEST_3RF("fmin_a.w", dataf,  16,  64, w11, w3,  w7);
   TEST_3RF("fmin_a.w", dataf,  16,  72, w13, w10, w24);
   TEST_3RF("fmin_a.w", dataf,  24,   0, w27, w4,  w15);
   TEST_3RF("fmin_a.w", dataf,  24,   8, w4,  w8,  w25);
   TEST_3RF("fmin_a.w", dataf,  24,  16, w29, w14, w10);
   TEST_3RF("fmin_a.w", dataf,  24,  24, w26, w25, w1);
   TEST_3RF("fmin_a.w", dataf,  24,  32, w13, w14, w8);
   TEST_3RF("fmin_a.w", dataf,  24,  40, w19, w22, w17);
   TEST_3RF("fmin_a.w", dataf,  24,  48, w26, w9,  w22);
   TEST_3RF("fmin_a.w", dataf,  24,  56, w8,  w27, w1);
   TEST_3RF("fmin_a.w", dataf,  24,  64, w11, w2,  w14);
   TEST_3RF("fmin_a.w", dataf,  24,  72, w21, w26, w9);
   TEST_3RF("fmin_a.w", dataf,  32,   0, w25, w30, w4);
   TEST_3RF("fmin_a.w", dataf,  32,   8, w8,  w3,  w12);
   TEST_3RF("fmin_a.w", dataf,  32,  16, w1,  w0,  w1);
   TEST_3RF("fmin_a.w", dataf,  32,  24, w27, w11, w20);
   TEST_3RF("fmin_a.w", dataf,  32,  32, w12, w8,  w3);
   TEST_3RF("fmin_a.w", dataf,  32,  40, w20, w28, w25);
   TEST_3RF("fmin_a.w", dataf,  32,  48, w5,  w22, w2);
   TEST_3RF("fmin_a.w", dataf,  32,  56, w27, w30, w29);
   TEST_3RF("fmin_a.w", dataf,  32,  64, w28, w9,  w0);
   TEST_3RF("fmin_a.w", dataf,  32,  72, w11, w30, w26);
   TEST_3RF("fmin_a.w", dataf,  40,   0, w20, w23, w25);
   TEST_3RF("fmin_a.w", dataf,  40,   8, w25, w31, w28);
   TEST_3RF("fmin_a.w", dataf,  40,  16, w5,  w0,  w28);
   TEST_3RF("fmin_a.w", dataf,  40,  24, w0,  w11, w23);
   TEST_3RF("fmin_a.w", dataf,  40,  32, w21, w23, w0);
   TEST_3RF("fmin_a.w", dataf,  40,  40, w24, w11, w28);
   TEST_3RF("fmin_a.w", dataf,  40,  48, w17, w18, w19);
   TEST_3RF("fmin_a.w", dataf,  40,  56, w12, w16, w17);
   TEST_3RF("fmin_a.w", dataf,  40,  64, w9,  w25, w17);
   TEST_3RF("fmin_a.w", dataf,  40,  72, w20, w23, w11);
   TEST_3RF("fmin_a.w", dataf,  48,   0, w8,  w14, w4);
   TEST_3RF("fmin_a.w", dataf,  48,   8, w1,  w13, w1);
   TEST_3RF("fmin_a.w", dataf,  48,  16, w0,  w7,  w13);
   TEST_3RF("fmin_a.w", dataf,  48,  24, w29, w7,  w24);
   TEST_3RF("fmin_a.w", dataf,  48,  32, w20, w28, w15);
   TEST_3RF("fmin_a.w", dataf,  48,  40, w20, w26, w16);
   TEST_3RF("fmin_a.w", dataf,  48,  48, w5,  w11, w2);
   TEST_3RF("fmin_a.w", dataf,  48,  56, w25, w24, w18);
   TEST_3RF("fmin_a.w", dataf,  48,  64, w10, w1,  w11);
   TEST_3RF("fmin_a.w", dataf,  48,  72, w27, w21, w2);
   TEST_3RF("fmin_a.w", dataf,  56,   0, w6,  w29, w16);
   TEST_3RF("fmin_a.w", dataf,  56,   8, w11, w31, w29);
   TEST_3RF("fmin_a.w", dataf,  56,  16, w11, w6,  w10);
   TEST_3RF("fmin_a.w", dataf,  56,  24, w8,  w13, w2);
   TEST_3RF("fmin_a.w", dataf,  56,  32, w29, w10, w17);
   TEST_3RF("fmin_a.w", dataf,  56,  40, w17, w30, w12);
   TEST_3RF("fmin_a.w", dataf,  56,  48, w2,  w2,  w2);
   TEST_3RF("fmin_a.w", dataf,  56,  56, w4,  w23, w29);
   TEST_3RF("fmin_a.w", dataf,  56,  64, w15, w23, w7);
   TEST_3RF("fmin_a.w", dataf,  56,  72, w16, w2,  w5);
   TEST_3RF("fmin_a.w", dataf,  64,   0, w5,  w8,  w3);
   TEST_3RF("fmin_a.w", dataf,  64,   8, w21, w19, w2);
   TEST_3RF("fmin_a.w", dataf,  64,  16, w19, w31, w8);
   TEST_3RF("fmin_a.w", dataf,  64,  24, w29, w7,  w21);
   TEST_3RF("fmin_a.w", dataf,  64,  32, w0,  w4,  w31);
   TEST_3RF("fmin_a.w", dataf,  64,  40, w17, w22, w30);
   TEST_3RF("fmin_a.w", dataf,  64,  48, w29, w24, w2);
   TEST_3RF("fmin_a.w", dataf,  64,  56, w21, w28, w31);
   TEST_3RF("fmin_a.w", dataf,  64,  64, w4,  w19, w6);
   TEST_3RF("fmin_a.w", dataf,  64,  72, w21, w22, w8);
   TEST_3RF("fmin_a.w", dataf,  72,   0, w26, w27, w16);
   TEST_3RF("fmin_a.w", dataf,  72,   8, w29, w16, w4);
   TEST_3RF("fmin_a.w", dataf,  72,  16, w31, w3,  w7);
   TEST_3RF("fmin_a.w", dataf,  72,  24, w1,  w10, w1);
   TEST_3RF("fmin_a.w", dataf,  72,  32, w29, w1,  w15);
   TEST_3RF("fmin_a.w", dataf,  72,  40, w28, w18, w5);
   TEST_3RF("fmin_a.w", dataf,  72,  48, w26, w16, w29);
   TEST_3RF("fmin_a.w", dataf,  72,  56, w28, w5,  w25);
   TEST_3RF("fmin_a.w", dataf,  72,  64, w27, w9,  w13);
   TEST_3RF("fmin_a.w", dataf,  72,  72, w1,  w30, w1);
   TEST_3RF("fmin_a.d", datad,   0,   0, w3,  w9,  w25);
   TEST_3RF("fmin_a.d", datad,   0,  16, w30, w26, w22);
   TEST_3RF("fmin_a.d", datad,   0,  32, w14, w14, w30);
   TEST_3RF("fmin_a.d", datad,   0,  48, w22, w18, w1);
   TEST_3RF("fmin_a.d", datad,   0,  64, w29, w19, w11);
   TEST_3RF("fmin_a.d", datad,   0,  80, w26, w20, w23);
   TEST_3RF("fmin_a.d", datad,   0,  96, w6,  w31, w17);
   TEST_3RF("fmin_a.d", datad,   0, 112, w22, w28, w14);
   TEST_3RF("fmin_a.d", datad,   0, 128, w27, w22, w9);
   TEST_3RF("fmin_a.d", datad,   0, 144, w5,  w3,  w11);
   TEST_3RF("fmin_a.d", datad,  16,   0, w3,  w6,  w20);
   TEST_3RF("fmin_a.d", datad,  16,  16, w28, w4,  w14);
   TEST_3RF("fmin_a.d", datad,  16,  32, w19, w18, w12);
   TEST_3RF("fmin_a.d", datad,  16,  48, w9,  w4,  w13);
   TEST_3RF("fmin_a.d", datad,  16,  64, w6,  w23, w25);
   TEST_3RF("fmin_a.d", datad,  16,  80, w1,  w11, w1);
   TEST_3RF("fmin_a.d", datad,  16,  96, w19, w24, w18);
   TEST_3RF("fmin_a.d", datad,  16, 112, w19, w9,  w8);
   TEST_3RF("fmin_a.d", datad,  16, 128, w15, w23, w4);
   TEST_3RF("fmin_a.d", datad,  16, 144, w5,  w1,  w9);
   TEST_3RF("fmin_a.d", datad,  32,   0, w8,  w12, w14);
   TEST_3RF("fmin_a.d", datad,  32,  16, w0,  w9,  w18);
   TEST_3RF("fmin_a.d", datad,  32,  32, w15, w28, w5);
   TEST_3RF("fmin_a.d", datad,  32,  48, w27, w5,  w9);
   TEST_3RF("fmin_a.d", datad,  32,  64, w9,  w11, w1);
   TEST_3RF("fmin_a.d", datad,  32,  80, w2,  w2,  w2);
   TEST_3RF("fmin_a.d", datad,  32,  96, w12, w21, w4);
   TEST_3RF("fmin_a.d", datad,  32, 112, w30, w8,  w14);
   TEST_3RF("fmin_a.d", datad,  32, 128, w7,  w24, w24);
   TEST_3RF("fmin_a.d", datad,  32, 144, w5,  w11, w29);
   TEST_3RF("fmin_a.d", datad,  48,   0, w6,  w20, w18);
   TEST_3RF("fmin_a.d", datad,  48,  16, w0,  w20, w19);
   TEST_3RF("fmin_a.d", datad,  48,  32, w9,  w7,  w2);
   TEST_3RF("fmin_a.d", datad,  48,  48, w5,  w12, w29);
   TEST_3RF("fmin_a.d", datad,  48,  64, w10, w21, w6);
   TEST_3RF("fmin_a.d", datad,  48,  80, w22, w8,  w2);
   TEST_3RF("fmin_a.d", datad,  48,  96, w3,  w30, w7);
   TEST_3RF("fmin_a.d", datad,  48, 112, w1,  w6,  w1);
   TEST_3RF("fmin_a.d", datad,  48, 128, w21, w8,  w30);
   TEST_3RF("fmin_a.d", datad,  48, 144, w26, w19, w28);
   TEST_3RF("fmin_a.d", datad,  64,   0, w1,  w7,  w1);
   TEST_3RF("fmin_a.d", datad,  64,  16, w2,  w2,  w2);
   TEST_3RF("fmin_a.d", datad,  64,  32, w19, w8,  w22);
   TEST_3RF("fmin_a.d", datad,  64,  48, w6,  w17, w29);
   TEST_3RF("fmin_a.d", datad,  64,  64, w8,  w23, w9);
   TEST_3RF("fmin_a.d", datad,  64,  80, w6,  w1,  w31);
   TEST_3RF("fmin_a.d", datad,  64,  96, w12, w23, w21);
   TEST_3RF("fmin_a.d", datad,  64, 112, w21, w26, w24);
   TEST_3RF("fmin_a.d", datad,  64, 128, w19, w1,  w26);
   TEST_3RF("fmin_a.d", datad,  64, 144, w25, w22, w2);
   TEST_3RF("fmin_a.d", datad,  80,   0, w24, w16, w22);
   TEST_3RF("fmin_a.d", datad,  80,  16, w20, w17, w29);
   TEST_3RF("fmin_a.d", datad,  80,  32, w22, w5,  w12);
   TEST_3RF("fmin_a.d", datad,  80,  48, w11, w23, w10);
   TEST_3RF("fmin_a.d", datad,  80,  64, w20, w14, w19);
   TEST_3RF("fmin_a.d", datad,  80,  80, w26, w15, w18);
   TEST_3RF("fmin_a.d", datad,  80,  96, w6,  w7,  w8);
   TEST_3RF("fmin_a.d", datad,  80, 112, w27, w1,  w0);
   TEST_3RF("fmin_a.d", datad,  80, 128, w14, w14, w2);
   TEST_3RF("fmin_a.d", datad,  80, 144, w26, w8,  w24);
   TEST_3RF("fmin_a.d", datad,  96,   0, w29, w0,  w8);
   TEST_3RF("fmin_a.d", datad,  96,  16, w19, w20, w26);
   TEST_3RF("fmin_a.d", datad,  96,  32, w16, w10, w31);
   TEST_3RF("fmin_a.d", datad,  96,  48, w22, w10, w13);
   TEST_3RF("fmin_a.d", datad,  96,  64, w0,  w30, w27);
   TEST_3RF("fmin_a.d", datad,  96,  80, w20, w24, w10);
   TEST_3RF("fmin_a.d", datad,  96,  96, w6,  w31, w17);
   TEST_3RF("fmin_a.d", datad,  96, 112, w14, w14, w26);
   TEST_3RF("fmin_a.d", datad,  96, 128, w18, w15, w9);
   TEST_3RF("fmin_a.d", datad,  96, 144, w20, w9,  w17);
   TEST_3RF("fmin_a.d", datad, 112,   0, w12, w6,  w17);
   TEST_3RF("fmin_a.d", datad, 112,  16, w21, w25, w5);
   TEST_3RF("fmin_a.d", datad, 112,  32, w15, w10, w14);
   TEST_3RF("fmin_a.d", datad, 112,  48, w0,  w5,  w24);
   TEST_3RF("fmin_a.d", datad, 112,  64, w13, w6,  w23);
   TEST_3RF("fmin_a.d", datad, 112,  80, w8,  w26, w15);
   TEST_3RF("fmin_a.d", datad, 112,  96, w18, w0,  w14);
   TEST_3RF("fmin_a.d", datad, 112, 112, w4,  w15, w9);
   TEST_3RF("fmin_a.d", datad, 112, 128, w22, w30, w18);
   TEST_3RF("fmin_a.d", datad, 112, 144, w11, w7,  w3);
   TEST_3RF("fmin_a.d", datad, 128,   0, w23, w14, w20);
   TEST_3RF("fmin_a.d", datad, 128,  16, w12, w7,  w25);
   TEST_3RF("fmin_a.d", datad, 128,  32, w27, w17, w8);
   TEST_3RF("fmin_a.d", datad, 128,  48, w9,  w17, w13);
   TEST_3RF("fmin_a.d", datad, 128,  64, w2,  w2,  w2);
   TEST_3RF("fmin_a.d", datad, 128,  80, w30, w19, w25);
   TEST_3RF("fmin_a.d", datad, 128,  96, w6,  w13, w8);
   TEST_3RF("fmin_a.d", datad, 128, 112, w25, w14, w23);
   TEST_3RF("fmin_a.d", datad, 128, 128, w29, w0,  w19);
   TEST_3RF("fmin_a.d", datad, 128, 144, w27, w18, w30);
   TEST_3RF("fmin_a.d", datad, 144,   0, w2,  w2,  w2);
   TEST_3RF("fmin_a.d", datad, 144,  16, w21, w22, w16);
   TEST_3RF("fmin_a.d", datad, 144,  32, w9,  w2,  w24);
   TEST_3RF("fmin_a.d", datad, 144,  48, w2,  w2,  w2);
   TEST_3RF("fmin_a.d", datad, 144,  64, w30, w9,  w10);
   TEST_3RF("fmin_a.d", datad, 144,  80, w7,  w27, w27);
   TEST_3RF("fmin_a.d", datad, 144,  96, w23, w9,  w25);
   TEST_3RF("fmin_a.d", datad, 144, 112, w11, w2,  w0);
   TEST_3RF("fmin_a.d", datad, 144, 128, w24, w11, w25);
   TEST_3RF("fmin_a.d", datad, 144, 144, w6,  w2,  w22);
   TEST_3RF("fcaf.w", dataf,   0,   0, w2,  w2,  w2);
   TEST_3RF("fcaf.w", dataf,   0,   8, w28, w26, w25);
   TEST_3RF("fcaf.w", dataf,   0,  16, w27, w17, w18);
   TEST_3RF("fcaf.w", dataf,   0,  24, w9,  w26, w5);
   TEST_3RF("fcaf.w", dataf,   0,  32, w0,  w27, w22);
   TEST_3RF("fcaf.w", dataf,   0,  40, w19, w22, w22);
   TEST_3RF("fcaf.w", dataf,   0,  48, w20, w3,  w14);
   TEST_3RF("fcaf.w", dataf,   0,  56, w28, w8,  w30);
   TEST_3RF("fcaf.w", dataf,   0,  64, w28, w22, w19);
   TEST_3RF("fcaf.w", dataf,   0,  72, w20, w24, w21);
   TEST_3RF("fcaf.w", dataf,   8,   0, w31, w28, w8);
   TEST_3RF("fcaf.w", dataf,   8,   8, w1,  w24, w2);
   TEST_3RF("fcaf.w", dataf,   8,  16, w26, w20, w12);
   TEST_3RF("fcaf.w", dataf,   8,  24, w29, w14, w18);
   TEST_3RF("fcaf.w", dataf,   8,  32, w30, w9,  w8);
   TEST_3RF("fcaf.w", dataf,   8,  40, w17, w31, w28);
   TEST_3RF("fcaf.w", dataf,   8,  48, w20, w13, w25);
   TEST_3RF("fcaf.w", dataf,   8,  56, w28, w21, w23);
   TEST_3RF("fcaf.w", dataf,   8,  64, w24, w11, w10);
   TEST_3RF("fcaf.w", dataf,   8,  72, w13, w3,  w31);
   TEST_3RF("fcaf.w", dataf,  16,   0, w12, w0,  w8);
   TEST_3RF("fcaf.w", dataf,  16,   8, w13, w24, w10);
   TEST_3RF("fcaf.w", dataf,  16,  16, w8,  w12, w30);
   TEST_3RF("fcaf.w", dataf,  16,  24, w20, w10, w13);
   TEST_3RF("fcaf.w", dataf,  16,  32, w6,  w8,  w22);
   TEST_3RF("fcaf.w", dataf,  16,  40, w14, w25, w22);
   TEST_3RF("fcaf.w", dataf,  16,  48, w11, w13, w3);
   TEST_3RF("fcaf.w", dataf,  16,  56, w4,  w9,  w4);
   TEST_3RF("fcaf.w", dataf,  16,  64, w25, w27, w1);
   TEST_3RF("fcaf.w", dataf,  16,  72, w4,  w5,  w4);
   TEST_3RF("fcaf.w", dataf,  24,   0, w14, w8,  w4);
   TEST_3RF("fcaf.w", dataf,  24,   8, w26, w8,  w12);
   TEST_3RF("fcaf.w", dataf,  24,  16, w8,  w0,  w23);
   TEST_3RF("fcaf.w", dataf,  24,  24, w16, w13, w21);
   TEST_3RF("fcaf.w", dataf,  24,  32, w4,  w23, w4);
   TEST_3RF("fcaf.w", dataf,  24,  40, w2,  w2,  w2);
   TEST_3RF("fcaf.w", dataf,  24,  48, w11, w31, w25);
   TEST_3RF("fcaf.w", dataf,  24,  56, w25, w24, w15);
   TEST_3RF("fcaf.w", dataf,  24,  64, w4,  w5,  w4);
   TEST_3RF("fcaf.w", dataf,  24,  72, w18, w8,  w14);
   TEST_3RF("fcaf.w", dataf,  32,   0, w11, w3,  w15);
   TEST_3RF("fcaf.w", dataf,  32,   8, w16, w8,  w30);
   TEST_3RF("fcaf.w", dataf,  32,  16, w24, w13, w0);
   TEST_3RF("fcaf.w", dataf,  32,  24, w25, w0,  w16);
   TEST_3RF("fcaf.w", dataf,  32,  32, w16, w13, w6);
   TEST_3RF("fcaf.w", dataf,  32,  40, w21, w4,  w8);
   TEST_3RF("fcaf.w", dataf,  32,  48, w0,  w3,  w1);
   TEST_3RF("fcaf.w", dataf,  32,  56, w25, w27, w16);
   TEST_3RF("fcaf.w", dataf,  32,  64, w30, w0,  w3);
   TEST_3RF("fcaf.w", dataf,  32,  72, w6,  w14, w10);
   TEST_3RF("fcaf.w", dataf,  40,   0, w30, w18, w28);
   TEST_3RF("fcaf.w", dataf,  40,   8, w22, w31, w20);
   TEST_3RF("fcaf.w", dataf,  40,  16, w22, w25, w21);
   TEST_3RF("fcaf.w", dataf,  40,  24, w23, w9,  w5);
   TEST_3RF("fcaf.w", dataf,  40,  32, w4,  w15, w4);
   TEST_3RF("fcaf.w", dataf,  40,  40, w26, w9,  w24);
   TEST_3RF("fcaf.w", dataf,  40,  48, w26, w12, w25);
   TEST_3RF("fcaf.w", dataf,  40,  56, w20, w8,  w10);
   TEST_3RF("fcaf.w", dataf,  40,  64, w18, w8,  w13);
   TEST_3RF("fcaf.w", dataf,  40,  72, w24, w23, w27);
   TEST_3RF("fcaf.w", dataf,  48,   0, w2,  w2,  w2);
   TEST_3RF("fcaf.w", dataf,  48,   8, w21, w26, w17);
   TEST_3RF("fcaf.w", dataf,  48,  16, w16, w20, w5);
   TEST_3RF("fcaf.w", dataf,  48,  24, w7,  w13, w26);
   TEST_3RF("fcaf.w", dataf,  48,  32, w30, w23, w0);
   TEST_3RF("fcaf.w", dataf,  48,  40, w2,  w2,  w2);
   TEST_3RF("fcaf.w", dataf,  48,  48, w6,  w26, w11);
   TEST_3RF("fcaf.w", dataf,  48,  56, w30, w21, w24);
   TEST_3RF("fcaf.w", dataf,  48,  64, w24, w9,  w0);
   TEST_3RF("fcaf.w", dataf,  48,  72, w2,  w2,  w2);
   TEST_3RF("fcaf.w", dataf,  56,   0, w27, w8,  w15);
   TEST_3RF("fcaf.w", dataf,  56,   8, w19, w31, w31);
   TEST_3RF("fcaf.w", dataf,  56,  16, w10, w10, w22);
   TEST_3RF("fcaf.w", dataf,  56,  24, w20, w4,  w11);
   TEST_3RF("fcaf.w", dataf,  56,  32, w5,  w21, w31);
   TEST_3RF("fcaf.w", dataf,  56,  40, w11, w28, w13);
   TEST_3RF("fcaf.w", dataf,  56,  48, w5,  w26, w4);
   TEST_3RF("fcaf.w", dataf,  56,  56, w5,  w28, w10);
   TEST_3RF("fcaf.w", dataf,  56,  64, w0,  w8,  w9);
   TEST_3RF("fcaf.w", dataf,  56,  72, w21, w0,  w1);
   TEST_3RF("fcaf.w", dataf,  64,   0, w30, w0,  w3);
   TEST_3RF("fcaf.w", dataf,  64,   8, w25, w8,  w18);
   TEST_3RF("fcaf.w", dataf,  64,  16, w12, w8,  w28);
   TEST_3RF("fcaf.w", dataf,  64,  24, w2,  w2,  w2);
   TEST_3RF("fcaf.w", dataf,  64,  32, w28, w1,  w13);
   TEST_3RF("fcaf.w", dataf,  64,  40, w2,  w2,  w2);
   TEST_3RF("fcaf.w", dataf,  64,  48, w22, w13, w18);
   TEST_3RF("fcaf.w", dataf,  64,  56, w26, w18, w12);
   TEST_3RF("fcaf.w", dataf,  64,  64, w30, w24, w8);
   TEST_3RF("fcaf.w", dataf,  64,  72, w8,  w24, w16);
   TEST_3RF("fcaf.w", dataf,  72,   0, w17, w13, w16);
   TEST_3RF("fcaf.w", dataf,  72,   8, w18, w11, w16);
   TEST_3RF("fcaf.w", dataf,  72,  16, w21, w4,  w25);
   TEST_3RF("fcaf.w", dataf,  72,  24, w7,  w16, w1);
   TEST_3RF("fcaf.w", dataf,  72,  32, w4,  w19, w4);
   TEST_3RF("fcaf.w", dataf,  72,  40, w29, w5,  w0);
   TEST_3RF("fcaf.w", dataf,  72,  48, w31, w27, w13);
   TEST_3RF("fcaf.w", dataf,  72,  56, w12, w13, w7);
   TEST_3RF("fcaf.w", dataf,  72,  64, w31, w25, w5);
   TEST_3RF("fcaf.w", dataf,  72,  72, w23, w1,  w14);
   TEST_3RF("fcaf.d", datad,   0,   0, w15, w18, w31);
   TEST_3RF("fcaf.d", datad,   0,  16, w28, w2,  w18);
   TEST_3RF("fcaf.d", datad,   0,  32, w7,  w19, w11);
   TEST_3RF("fcaf.d", datad,   0,  48, w12, w15, w27);
   TEST_3RF("fcaf.d", datad,   0,  64, w13, w19, w14);
   TEST_3RF("fcaf.d", datad,   0,  80, w10, w10, w24);
   TEST_3RF("fcaf.d", datad,   0,  96, w15, w10, w19);
   TEST_3RF("fcaf.d", datad,   0, 112, w28, w22, w0);
   TEST_3RF("fcaf.d", datad,   0, 128, w4,  w21, w4);
   TEST_3RF("fcaf.d", datad,   0, 144, w25, w9,  w12);
   TEST_3RF("fcaf.d", datad,  16,   0, w26, w23, w27);
   TEST_3RF("fcaf.d", datad,  16,  16, w12, w23, w15);
   TEST_3RF("fcaf.d", datad,  16,  32, w9,  w30, w2);
   TEST_3RF("fcaf.d", datad,  16,  48, w16, w9,  w14);
   TEST_3RF("fcaf.d", datad,  16,  64, w31, w5,  w27);
   TEST_3RF("fcaf.d", datad,  16,  80, w18, w19, w5);
   TEST_3RF("fcaf.d", datad,  16,  96, w10, w10, w2);
   TEST_3RF("fcaf.d", datad,  16, 112, w15, w29, w31);
   TEST_3RF("fcaf.d", datad,  16, 128, w6,  w29, w3);
   TEST_3RF("fcaf.d", datad,  16, 144, w27, w22, w12);
   TEST_3RF("fcaf.d", datad,  32,   0, w8,  w17, w4);
   TEST_3RF("fcaf.d", datad,  32,  16, w3,  w29, w27);
   TEST_3RF("fcaf.d", datad,  32,  32, w27, w12, w4);
   TEST_3RF("fcaf.d", datad,  32,  48, w25, w14, w20);
   TEST_3RF("fcaf.d", datad,  32,  64, w3,  w28, w20);
   TEST_3RF("fcaf.d", datad,  32,  80, w8,  w23, w6);
   TEST_3RF("fcaf.d", datad,  32,  96, w27, w29, w17);
   TEST_3RF("fcaf.d", datad,  32, 112, w30, w12, w14);
   TEST_3RF("fcaf.d", datad,  32, 128, w29, w18, w12);
   TEST_3RF("fcaf.d", datad,  32, 144, w0,  w14, w2);
   TEST_3RF("fcaf.d", datad,  48,   0, w12, w22, w19);
   TEST_3RF("fcaf.d", datad,  48,  16, w16, w25, w17);
   TEST_3RF("fcaf.d", datad,  48,  32, w11, w20, w29);
   TEST_3RF("fcaf.d", datad,  48,  48, w15, w14, w12);
   TEST_3RF("fcaf.d", datad,  48,  64, w4,  w17, w4);
   TEST_3RF("fcaf.d", datad,  48,  80, w8,  w24, w25);
   TEST_3RF("fcaf.d", datad,  48,  96, w0,  w30, w20);
   TEST_3RF("fcaf.d", datad,  48, 112, w29, w15, w18);
   TEST_3RF("fcaf.d", datad,  48, 128, w9,  w30, w15);
   TEST_3RF("fcaf.d", datad,  48, 144, w28, w10, w15);
   TEST_3RF("fcaf.d", datad,  64,   0, w10, w10, w12);
   TEST_3RF("fcaf.d", datad,  64,  16, w28, w0,  w12);
   TEST_3RF("fcaf.d", datad,  64,  32, w25, w17, w24);
   TEST_3RF("fcaf.d", datad,  64,  48, w14, w7,  w28);
   TEST_3RF("fcaf.d", datad,  64,  64, w26, w11, w13);
   TEST_3RF("fcaf.d", datad,  64,  80, w3,  w6,  w2);
   TEST_3RF("fcaf.d", datad,  64,  96, w26, w0,  w17);
   TEST_3RF("fcaf.d", datad,  64, 112, w13, w9,  w15);
   TEST_3RF("fcaf.d", datad,  64, 128, w28, w5,  w25);
   TEST_3RF("fcaf.d", datad,  64, 144, w12, w15, w6);
   TEST_3RF("fcaf.d", datad,  80,   0, w8,  w15, w6);
   TEST_3RF("fcaf.d", datad,  80,  16, w20, w9,  w23);
   TEST_3RF("fcaf.d", datad,  80,  32, w12, w23, w5);
   TEST_3RF("fcaf.d", datad,  80,  48, w20, w19, w0);
   TEST_3RF("fcaf.d", datad,  80,  64, w31, w0,  w3);
   TEST_3RF("fcaf.d", datad,  80,  80, w3,  w6,  w5);
   TEST_3RF("fcaf.d", datad,  80,  96, w0,  w6,  w22);
   TEST_3RF("fcaf.d", datad,  80, 112, w13, w15, w6);
   TEST_3RF("fcaf.d", datad,  80, 128, w10, w10, w21);
   TEST_3RF("fcaf.d", datad,  80, 144, w31, w22, w4);
   TEST_3RF("fcaf.d", datad,  96,   0, w5,  w30, w20);
   TEST_3RF("fcaf.d", datad,  96,  16, w11, w18, w29);
   TEST_3RF("fcaf.d", datad,  96,  32, w2,  w2,  w2);
   TEST_3RF("fcaf.d", datad,  96,  48, w31, w20, w8);
   TEST_3RF("fcaf.d", datad,  96,  64, w19, w7,  w7);
   TEST_3RF("fcaf.d", datad,  96,  80, w8,  w18, w7);
   TEST_3RF("fcaf.d", datad,  96,  96, w11, w21, w13);
   TEST_3RF("fcaf.d", datad,  96, 112, w17, w26, w13);
   TEST_3RF("fcaf.d", datad,  96, 128, w23, w17, w27);
   TEST_3RF("fcaf.d", datad,  96, 144, w6,  w23, w5);
   TEST_3RF("fcaf.d", datad, 112,   0, w27, w22, w0);
   TEST_3RF("fcaf.d", datad, 112,  16, w28, w25, w20);
   TEST_3RF("fcaf.d", datad, 112,  32, w7,  w11, w17);
   TEST_3RF("fcaf.d", datad, 112,  48, w10, w10, w5);
   TEST_3RF("fcaf.d", datad, 112,  64, w18, w29, w12);
   TEST_3RF("fcaf.d", datad, 112,  80, w26, w16, w19);
   TEST_3RF("fcaf.d", datad, 112,  96, w5,  w0,  w22);
   TEST_3RF("fcaf.d", datad, 112, 112, w0,  w13, w17);
   TEST_3RF("fcaf.d", datad, 112, 128, w8,  w19, w13);
   TEST_3RF("fcaf.d", datad, 112, 144, w15, w30, w8);
   TEST_3RF("fcaf.d", datad, 128,   0, w15, w26, w1);
   TEST_3RF("fcaf.d", datad, 128,  16, w3,  w2,  w13);
   TEST_3RF("fcaf.d", datad, 128,  32, w20, w12, w23);
   TEST_3RF("fcaf.d", datad, 128,  48, w25, w30, w21);
   TEST_3RF("fcaf.d", datad, 128,  64, w5,  w24, w29);
   TEST_3RF("fcaf.d", datad, 128,  80, w10, w10, w24);
   TEST_3RF("fcaf.d", datad, 128,  96, w19, w10, w10);
   TEST_3RF("fcaf.d", datad, 128, 112, w5,  w0,  w27);
   TEST_3RF("fcaf.d", datad, 128, 128, w14, w19, w3);
   TEST_3RF("fcaf.d", datad, 128, 144, w27, w2,  w4);
   TEST_3RF("fcaf.d", datad, 144,   0, w17, w28, w5);
   TEST_3RF("fcaf.d", datad, 144,  16, w20, w30, w18);
   TEST_3RF("fcaf.d", datad, 144,  32, w8,  w10, w1);
   TEST_3RF("fcaf.d", datad, 144,  48, w8,  w31, w6);
   TEST_3RF("fcaf.d", datad, 144,  64, w0,  w4,  w30);
   TEST_3RF("fcaf.d", datad, 144,  80, w29, w14, w22);
   TEST_3RF("fcaf.d", datad, 144,  96, w16, w25, w28);
   TEST_3RF("fcaf.d", datad, 144, 112, w16, w20, w10);
   TEST_3RF("fcaf.d", datad, 144, 128, w4,  w24, w4);
   TEST_3RF("fcaf.d", datad, 144, 144, w5,  w6,  w26);
   TEST_3RF("fceq.w", dataf,   0,   0, w12, w21, w1);
   TEST_3RF("fceq.w", dataf,   0,   8, w21, w31, w11);
   TEST_3RF("fceq.w", dataf,   0,  16, w22, w8,  w22);
   TEST_3RF("fceq.w", dataf,   0,  24, w10, w29, w8);
   TEST_3RF("fceq.w", dataf,   0,  32, w14, w27, w6);
   TEST_3RF("fceq.w", dataf,   0,  40, w29, w18, w22);
   TEST_3RF("fceq.w", dataf,   0,  48, w22, w14, w22);
   TEST_3RF("fceq.w", dataf,   0,  56, w7,  w10, w24);
   TEST_3RF("fceq.w", dataf,   0,  64, w11, w2,  w29);
   TEST_3RF("fceq.w", dataf,   0,  72, w17, w28, w7);
   TEST_3RF("fceq.w", dataf,   8,   0, w9,  w9,  w9);
   TEST_3RF("fceq.w", dataf,   8,   8, w19, w22, w8);
   TEST_3RF("fceq.w", dataf,   8,  16, w23, w11, w7);
   TEST_3RF("fceq.w", dataf,   8,  24, w3,  w1,  w15);
   TEST_3RF("fceq.w", dataf,   8,  32, w13, w30, w24);
   TEST_3RF("fceq.w", dataf,   8,  40, w28, w26, w30);
   TEST_3RF("fceq.w", dataf,   8,  48, w25, w12, w20);
   TEST_3RF("fceq.w", dataf,   8,  56, w15, w26, w26);
   TEST_3RF("fceq.w", dataf,   8,  64, w27, w25, w18);
   TEST_3RF("fceq.w", dataf,   8,  72, w6,  w28, w15);
   TEST_3RF("fceq.w", dataf,  16,   0, w24, w24, w22);
   TEST_3RF("fceq.w", dataf,  16,   8, w1,  w11, w12);
   TEST_3RF("fceq.w", dataf,  16,  16, w23, w19, w4);
   TEST_3RF("fceq.w", dataf,  16,  24, w2,  w27, w7);
   TEST_3RF("fceq.w", dataf,  16,  32, w4,  w10, w20);
   TEST_3RF("fceq.w", dataf,  16,  40, w2,  w16, w28);
   TEST_3RF("fceq.w", dataf,  16,  48, w0,  w9,  w8);
   TEST_3RF("fceq.w", dataf,  16,  56, w21, w24, w2);
   TEST_3RF("fceq.w", dataf,  16,  64, w16, w18, w20);
   TEST_3RF("fceq.w", dataf,  16,  72, w23, w14, w4);
   TEST_3RF("fceq.w", dataf,  24,   0, w15, w6,  w6);
   TEST_3RF("fceq.w", dataf,  24,   8, w26, w16, w18);
   TEST_3RF("fceq.w", dataf,  24,  16, w7,  w8,  w5);
   TEST_3RF("fceq.w", dataf,  24,  24, w11, w10, w0);
   TEST_3RF("fceq.w", dataf,  24,  32, w18, w14, w11);
   TEST_3RF("fceq.w", dataf,  24,  40, w6,  w17, w13);
   TEST_3RF("fceq.w", dataf,  24,  48, w23, w13, w14);
   TEST_3RF("fceq.w", dataf,  24,  56, w0,  w22, w3);
   TEST_3RF("fceq.w", dataf,  24,  64, w25, w24, w19);
   TEST_3RF("fceq.w", dataf,  24,  72, w11, w13, w10);
   TEST_3RF("fceq.w", dataf,  32,   0, w25, w17, w31);
   TEST_3RF("fceq.w", dataf,  32,   8, w11, w10, w17);
   TEST_3RF("fceq.w", dataf,  32,  16, w18, w23, w29);
   TEST_3RF("fceq.w", dataf,  32,  24, w28, w23, w15);
   TEST_3RF("fceq.w", dataf,  32,  32, w11, w2,  w22);
   TEST_3RF("fceq.w", dataf,  32,  40, w28, w16, w13);
   TEST_3RF("fceq.w", dataf,  32,  48, w9,  w9,  w9);
   TEST_3RF("fceq.w", dataf,  32,  56, w30, w13, w31);
   TEST_3RF("fceq.w", dataf,  32,  64, w1,  w6,  w24);
   TEST_3RF("fceq.w", dataf,  32,  72, w20, w17, w5);
   TEST_3RF("fceq.w", dataf,  40,   0, w31, w10, w22);
   TEST_3RF("fceq.w", dataf,  40,   8, w24, w24, w10);
   TEST_3RF("fceq.w", dataf,  40,  16, w1,  w2,  w27);
   TEST_3RF("fceq.w", dataf,  40,  24, w20, w18, w17);
   TEST_3RF("fceq.w", dataf,  40,  32, w17, w10, w1);
   TEST_3RF("fceq.w", dataf,  40,  40, w28, w12, w23);
   TEST_3RF("fceq.w", dataf,  40,  48, w24, w24, w28);
   TEST_3RF("fceq.w", dataf,  40,  56, w4,  w1,  w26);
   TEST_3RF("fceq.w", dataf,  40,  64, w17, w1,  w27);
   TEST_3RF("fceq.w", dataf,  40,  72, w24, w24, w25);
   TEST_3RF("fceq.w", dataf,  48,   0, w16, w9,  w30);
   TEST_3RF("fceq.w", dataf,  48,   8, w15, w20, w20);
   TEST_3RF("fceq.w", dataf,  48,  16, w20, w7,  w30);
   TEST_3RF("fceq.w", dataf,  48,  24, w21, w10, w25);
   TEST_3RF("fceq.w", dataf,  48,  32, w9,  w9,  w9);
   TEST_3RF("fceq.w", dataf,  48,  40, w30, w12, w27);
   TEST_3RF("fceq.w", dataf,  48,  48, w15, w22, w22);
   TEST_3RF("fceq.w", dataf,  48,  56, w28, w11, w2);
   TEST_3RF("fceq.w", dataf,  48,  64, w19, w3,  w31);
   TEST_3RF("fceq.w", dataf,  48,  72, w23, w5,  w25);
   TEST_3RF("fceq.w", dataf,  56,   0, w8,  w6,  w21);
   TEST_3RF("fceq.w", dataf,  56,   8, w0,  w31, w5);
   TEST_3RF("fceq.w", dataf,  56,  16, w10, w29, w20);
   TEST_3RF("fceq.w", dataf,  56,  24, w30, w17, w27);
   TEST_3RF("fceq.w", dataf,  56,  32, w28, w6,  w5);
   TEST_3RF("fceq.w", dataf,  56,  40, w21, w16, w4);
   TEST_3RF("fceq.w", dataf,  56,  48, w1,  w11, w19);
   TEST_3RF("fceq.w", dataf,  56,  56, w23, w7,  w31);
   TEST_3RF("fceq.w", dataf,  56,  64, w26, w2,  w25);
   TEST_3RF("fceq.w", dataf,  56,  72, w17, w7,  w18);
   TEST_3RF("fceq.w", dataf,  64,   0, w25, w13, w7);
   TEST_3RF("fceq.w", dataf,  64,   8, w26, w12, w4);
   TEST_3RF("fceq.w", dataf,  64,  16, w9,  w9,  w9);
   TEST_3RF("fceq.w", dataf,  64,  24, w0,  w2,  w26);
   TEST_3RF("fceq.w", dataf,  64,  32, w28, w30, w1);
   TEST_3RF("fceq.w", dataf,  64,  40, w1,  w19, w17);
   TEST_3RF("fceq.w", dataf,  64,  48, w5,  w21, w28);
   TEST_3RF("fceq.w", dataf,  64,  56, w25, w12, w3);
   TEST_3RF("fceq.w", dataf,  64,  64, w24, w24, w6);
   TEST_3RF("fceq.w", dataf,  64,  72, w29, w26, w31);
   TEST_3RF("fceq.w", dataf,  72,   0, w14, w2,  w18);
   TEST_3RF("fceq.w", dataf,  72,   8, w7,  w15, w25);
   TEST_3RF("fceq.w", dataf,  72,  16, w1,  w28, w6);
   TEST_3RF("fceq.w", dataf,  72,  24, w5,  w6,  w7);
   TEST_3RF("fceq.w", dataf,  72,  32, w0,  w2,  w5);
   TEST_3RF("fceq.w", dataf,  72,  40, w1,  w4,  w25);
   TEST_3RF("fceq.w", dataf,  72,  48, w18, w9,  w14);
   TEST_3RF("fceq.w", dataf,  72,  56, w14, w2,  w26);
   TEST_3RF("fceq.w", dataf,  72,  64, w17, w26, w1);
   TEST_3RF("fceq.w", dataf,  72,  72, w14, w21, w0);
   TEST_3RF("fceq.d", datad,   0,   0, w28, w23, w18);
   TEST_3RF("fceq.d", datad,   0,  16, w3,  w6,  w12);
   TEST_3RF("fceq.d", datad,   0,  32, w5,  w2,  w18);
   TEST_3RF("fceq.d", datad,   0,  48, w10, w8,  w24);
   TEST_3RF("fceq.d", datad,   0,  64, w18, w8,  w27);
   TEST_3RF("fceq.d", datad,   0,  80, w23, w9,  w31);
   TEST_3RF("fceq.d", datad,   0,  96, w16, w27, w8);
   TEST_3RF("fceq.d", datad,   0, 112, w30, w9,  w11);
   TEST_3RF("fceq.d", datad,   0, 128, w25, w26, w5);
   TEST_3RF("fceq.d", datad,   0, 144, w26, w8,  w4);
   TEST_3RF("fceq.d", datad,  16,   0, w17, w13, w7);
   TEST_3RF("fceq.d", datad,  16,  16, w24, w24, w25);
   TEST_3RF("fceq.d", datad,  16,  32, w12, w26, w11);
   TEST_3RF("fceq.d", datad,  16,  48, w23, w2,  w3);
   TEST_3RF("fceq.d", datad,  16,  64, w9,  w9,  w9);
   TEST_3RF("fceq.d", datad,  16,  80, w10, w30, w0);
   TEST_3RF("fceq.d", datad,  16,  96, w19, w29, w17);
   TEST_3RF("fceq.d", datad,  16, 112, w14, w6,  w15);
   TEST_3RF("fceq.d", datad,  16, 128, w23, w17, w8);
   TEST_3RF("fceq.d", datad,  16, 144, w17, w22, w2);
   TEST_3RF("fceq.d", datad,  32,   0, w25, w17, w29);
   TEST_3RF("fceq.d", datad,  32,  16, w29, w2,  w10);
   TEST_3RF("fceq.d", datad,  32,  32, w5,  w26, w3);
   TEST_3RF("fceq.d", datad,  32,  48, w17, w21, w14);
   TEST_3RF("fceq.d", datad,  32,  64, w8,  w23, w17);
   TEST_3RF("fceq.d", datad,  32,  80, w17, w2,  w16);
   TEST_3RF("fceq.d", datad,  32,  96, w18, w21, w13);
   TEST_3RF("fceq.d", datad,  32, 112, w3,  w4,  w19);
   TEST_3RF("fceq.d", datad,  32, 128, w18, w27, w4);
   TEST_3RF("fceq.d", datad,  32, 144, w27, w13, w29);
   TEST_3RF("fceq.d", datad,  48,   0, w6,  w12, w26);
   TEST_3RF("fceq.d", datad,  48,  16, w4,  w14, w9);
   TEST_3RF("fceq.d", datad,  48,  32, w9,  w9,  w9);
   TEST_3RF("fceq.d", datad,  48,  48, w7,  w26, w30);
   TEST_3RF("fceq.d", datad,  48,  64, w21, w3,  w7);
   TEST_3RF("fceq.d", datad,  48,  80, w20, w23, w6);
   TEST_3RF("fceq.d", datad,  48,  96, w13, w4,  w9);
   TEST_3RF("fceq.d", datad,  48, 112, w17, w24, w28);
   TEST_3RF("fceq.d", datad,  48, 128, w12, w28, w23);
   TEST_3RF("fceq.d", datad,  48, 144, w25, w23, w20);
   TEST_3RF("fceq.d", datad,  64,   0, w0,  w3,  w15);
   TEST_3RF("fceq.d", datad,  64,  16, w4,  w18, w19);
   TEST_3RF("fceq.d", datad,  64,  32, w13, w27, w7);
   TEST_3RF("fceq.d", datad,  64,  48, w25, w16, w10);
   TEST_3RF("fceq.d", datad,  64,  64, w14, w23, w31);
   TEST_3RF("fceq.d", datad,  64,  80, w6,  w14, w5);
   TEST_3RF("fceq.d", datad,  64,  96, w19, w15, w4);
   TEST_3RF("fceq.d", datad,  64, 112, w11, w16, w7);
   TEST_3RF("fceq.d", datad,  64, 128, w2,  w10, w31);
   TEST_3RF("fceq.d", datad,  64, 144, w22, w10, w22);
   TEST_3RF("fceq.d", datad,  80,   0, w2,  w5,  w14);
   TEST_3RF("fceq.d", datad,  80,  16, w20, w25, w27);
   TEST_3RF("fceq.d", datad,  80,  32, w15, w20, w20);
   TEST_3RF("fceq.d", datad,  80,  48, w2,  w8,  w4);
   TEST_3RF("fceq.d", datad,  80,  64, w13, w23, w28);
   TEST_3RF("fceq.d", datad,  80,  80, w12, w29, w10);
   TEST_3RF("fceq.d", datad,  80,  96, w17, w16, w29);
   TEST_3RF("fceq.d", datad,  80, 112, w0,  w20, w8);
   TEST_3RF("fceq.d", datad,  80, 128, w11, w4,  w16);
   TEST_3RF("fceq.d", datad,  80, 144, w13, w14, w15);
   TEST_3RF("fceq.d", datad,  96,   0, w4,  w24, w17);
   TEST_3RF("fceq.d", datad,  96,  16, w9,  w9,  w9);
   TEST_3RF("fceq.d", datad,  96,  32, w6,  w2,  w1);
   TEST_3RF("fceq.d", datad,  96,  48, w21, w22, w4);
   TEST_3RF("fceq.d", datad,  96,  64, w30, w27, w17);
   TEST_3RF("fceq.d", datad,  96,  80, w21, w23, w29);
   TEST_3RF("fceq.d", datad,  96,  96, w18, w1,  w14);
   TEST_3RF("fceq.d", datad,  96, 112, w2,  w31, w15);
   TEST_3RF("fceq.d", datad,  96, 128, w22, w7,  w22);
   TEST_3RF("fceq.d", datad,  96, 144, w26, w23, w8);
   TEST_3RF("fceq.d", datad, 112,   0, w9,  w9,  w9);
   TEST_3RF("fceq.d", datad, 112,  16, w6,  w12, w1);
   TEST_3RF("fceq.d", datad, 112,  32, w24, w24, w21);
   TEST_3RF("fceq.d", datad, 112,  48, w8,  w30, w24);
   TEST_3RF("fceq.d", datad, 112,  64, w9,  w9,  w9);
   TEST_3RF("fceq.d", datad, 112,  80, w19, w14, w13);
   TEST_3RF("fceq.d", datad, 112,  96, w17, w9,  w30);
   TEST_3RF("fceq.d", datad, 112, 112, w6,  w0,  w27);
   TEST_3RF("fceq.d", datad, 112, 128, w24, w24, w2);
   TEST_3RF("fceq.d", datad, 112, 144, w10, w26, w1);
   TEST_3RF("fceq.d", datad, 128,   0, w25, w16, w8);
   TEST_3RF("fceq.d", datad, 128,  16, w19, w11, w0);
   TEST_3RF("fceq.d", datad, 128,  32, w27, w20, w6);
   TEST_3RF("fceq.d", datad, 128,  48, w7,  w21, w30);
   TEST_3RF("fceq.d", datad, 128,  64, w29, w28, w21);
   TEST_3RF("fceq.d", datad, 128,  80, w7,  w16, w3);
   TEST_3RF("fceq.d", datad, 128,  96, w20, w1,  w13);
   TEST_3RF("fceq.d", datad, 128, 112, w19, w8,  w13);
   TEST_3RF("fceq.d", datad, 128, 128, w14, w0,  w15);
   TEST_3RF("fceq.d", datad, 128, 144, w24, w24, w27);
   TEST_3RF("fceq.d", datad, 144,   0, w16, w17, w11);
   TEST_3RF("fceq.d", datad, 144,  16, w25, w5,  w22);
   TEST_3RF("fceq.d", datad, 144,  32, w25, w0,  w10);
   TEST_3RF("fceq.d", datad, 144,  48, w31, w8,  w0);
   TEST_3RF("fceq.d", datad, 144,  64, w30, w5,  w29);
   TEST_3RF("fceq.d", datad, 144,  80, w26, w4,  w10);
   TEST_3RF("fceq.d", datad, 144,  96, w29, w25, w12);
   TEST_3RF("fceq.d", datad, 144, 112, w10, w12, w20);
   TEST_3RF("fceq.d", datad, 144, 128, w24, w24, w26);
   TEST_3RF("fceq.d", datad, 144, 144, w20, w7,  w19);
   TEST_3RF("fcle.w", dataf,   0,   0, w17, w9,  w10);
   TEST_3RF("fcle.w", dataf,   0,   8, w10, w28, w9);
   TEST_3RF("fcle.w", dataf,   0,  16, w18, w28, w7);
   TEST_3RF("fcle.w", dataf,   0,  24, w23, w25, w2);
   TEST_3RF("fcle.w", dataf,   0,  32, w17, w30, w12);
   TEST_3RF("fcle.w", dataf,   0,  40, w14, w23, w24);
   TEST_3RF("fcle.w", dataf,   0,  48, w25, w3,  w12);
   TEST_3RF("fcle.w", dataf,   0,  56, w17, w29, w1);
   TEST_3RF("fcle.w", dataf,   0,  64, w24, w24, w16);
   TEST_3RF("fcle.w", dataf,   0,  72, w16, w21, w11);
   TEST_3RF("fcle.w", dataf,   8,   0, w1,  w30, w29);
   TEST_3RF("fcle.w", dataf,   8,   8, w11, w8,  w25);
   TEST_3RF("fcle.w", dataf,   8,  16, w21, w26, w28);
   TEST_3RF("fcle.w", dataf,   8,  24, w17, w14, w30);
   TEST_3RF("fcle.w", dataf,   8,  32, w2,  w12, w11);
   TEST_3RF("fcle.w", dataf,   8,  40, w17, w3,  w10);
   TEST_3RF("fcle.w", dataf,   8,  48, w6,  w16, w27);
   TEST_3RF("fcle.w", dataf,   8,  56, w4,  w17, w4);
   TEST_3RF("fcle.w", dataf,   8,  64, w19, w20, w1);
   TEST_3RF("fcle.w", dataf,   8,  72, w4,  w9,  w4);
   TEST_3RF("fcle.w", dataf,  16,   0, w13, w5,  w8);
   TEST_3RF("fcle.w", dataf,  16,   8, w10, w17, w16);
   TEST_3RF("fcle.w", dataf,  16,  16, w3,  w6,  w11);
   TEST_3RF("fcle.w", dataf,  16,  24, w24, w24, w2);
   TEST_3RF("fcle.w", dataf,  16,  32, w28, w6,  w1);
   TEST_3RF("fcle.w", dataf,  16,  40, w31, w19, w12);
   TEST_3RF("fcle.w", dataf,  16,  48, w16, w22, w15);
   TEST_3RF("fcle.w", dataf,  16,  56, w26, w29, w31);
   TEST_3RF("fcle.w", dataf,  16,  64, w21, w1,  w16);
   TEST_3RF("fcle.w", dataf,  16,  72, w8,  w21, w18);
   TEST_3RF("fcle.w", dataf,  24,   0, w12, w31, w18);
   TEST_3RF("fcle.w", dataf,  24,   8, w7,  w9,  w3);
   TEST_3RF("fcle.w", dataf,  24,  16, w23, w12, w9);
   TEST_3RF("fcle.w", dataf,  24,  24, w2,  w4,  w11);
   TEST_3RF("fcle.w", dataf,  24,  32, w31, w10, w12);
   TEST_3RF("fcle.w", dataf,  24,  40, w30, w29, w24);
   TEST_3RF("fcle.w", dataf,  24,  48, w14, w20, w8);
   TEST_3RF("fcle.w", dataf,  24,  56, w8,  w17, w7);
   TEST_3RF("fcle.w", dataf,  24,  64, w29, w18, w24);
   TEST_3RF("fcle.w", dataf,  24,  72, w5,  w7,  w10);
   TEST_3RF("fcle.w", dataf,  32,   0, w18, w6,  w9);
   TEST_3RF("fcle.w", dataf,  32,   8, w4,  w13, w4);
   TEST_3RF("fcle.w", dataf,  32,  16, w18, w7,  w5);
   TEST_3RF("fcle.w", dataf,  32,  24, w30, w16, w7);
   TEST_3RF("fcle.w", dataf,  32,  32, w2,  w27, w6);
   TEST_3RF("fcle.w", dataf,  32,  40, w12, w8,  w4);
   TEST_3RF("fcle.w", dataf,  32,  48, w10, w0,  w18);
   TEST_3RF("fcle.w", dataf,  32,  56, w30, w8,  w26);
   TEST_3RF("fcle.w", dataf,  32,  64, w15, w15, w15);
   TEST_3RF("fcle.w", dataf,  32,  72, w16, w23, w1);
   TEST_3RF("fcle.w", dataf,  40,   0, w8,  w29, w18);
   TEST_3RF("fcle.w", dataf,  40,   8, w15, w15, w15);
   TEST_3RF("fcle.w", dataf,  40,  16, w15, w15, w15);
   TEST_3RF("fcle.w", dataf,  40,  24, w27, w19, w19);
   TEST_3RF("fcle.w", dataf,  40,  32, w28, w13, w26);
   TEST_3RF("fcle.w", dataf,  40,  40, w1,  w11, w10);
   TEST_3RF("fcle.w", dataf,  40,  48, w9,  w13, w5);
   TEST_3RF("fcle.w", dataf,  40,  56, w15, w15, w15);
   TEST_3RF("fcle.w", dataf,  40,  64, w25, w13, w20);
   TEST_3RF("fcle.w", dataf,  40,  72, w3,  w14, w6);
   TEST_3RF("fcle.w", dataf,  48,   0, w1,  w22, w16);
   TEST_3RF("fcle.w", dataf,  48,   8, w6,  w24, w17);
   TEST_3RF("fcle.w", dataf,  48,  16, w14, w21, w26);
   TEST_3RF("fcle.w", dataf,  48,  24, w0,  w4,  w9);
   TEST_3RF("fcle.w", dataf,  48,  32, w27, w23, w23);
   TEST_3RF("fcle.w", dataf,  48,  40, w5,  w8,  w17);
   TEST_3RF("fcle.w", dataf,  48,  48, w7,  w19, w27);
   TEST_3RF("fcle.w", dataf,  48,  56, w16, w0,  w1);
   TEST_3RF("fcle.w", dataf,  48,  64, w31, w26, w14);
   TEST_3RF("fcle.w", dataf,  48,  72, w19, w29, w28);
   TEST_3RF("fcle.w", dataf,  56,   0, w26, w31, w19);
   TEST_3RF("fcle.w", dataf,  56,   8, w27, w15, w15);
   TEST_3RF("fcle.w", dataf,  56,  16, w25, w19, w1);
   TEST_3RF("fcle.w", dataf,  56,  24, w8,  w9,  w27);
   TEST_3RF("fcle.w", dataf,  56,  32, w8,  w13, w4);
   TEST_3RF("fcle.w", dataf,  56,  40, w4,  w5,  w4);
   TEST_3RF("fcle.w", dataf,  56,  48, w9,  w12, w22);
   TEST_3RF("fcle.w", dataf,  56,  56, w16, w0,  w18);
   TEST_3RF("fcle.w", dataf,  56,  64, w0,  w19, w26);
   TEST_3RF("fcle.w", dataf,  56,  72, w1,  w19, w24);
   TEST_3RF("fcle.w", dataf,  64,   0, w30, w13, w23);
   TEST_3RF("fcle.w", dataf,  64,   8, w17, w8,  w6);
   TEST_3RF("fcle.w", dataf,  64,  16, w10, w28, w7);
   TEST_3RF("fcle.w", dataf,  64,  24, w18, w5,  w2);
   TEST_3RF("fcle.w", dataf,  64,  32, w27, w18, w18);
   TEST_3RF("fcle.w", dataf,  64,  40, w6,  w31, w23);
   TEST_3RF("fcle.w", dataf,  64,  48, w16, w11, w14);
   TEST_3RF("fcle.w", dataf,  64,  56, w0,  w11, w1);
   TEST_3RF("fcle.w", dataf,  64,  64, w12, w19, w1);
   TEST_3RF("fcle.w", dataf,  64,  72, w6,  w20, w30);
   TEST_3RF("fcle.w", dataf,  72,   0, w18, w2,  w21);
   TEST_3RF("fcle.w", dataf,  72,   8, w3,  w10, w28);
   TEST_3RF("fcle.w", dataf,  72,  16, w14, w6,  w3);
   TEST_3RF("fcle.w", dataf,  72,  24, w0,  w11, w6);
   TEST_3RF("fcle.w", dataf,  72,  32, w27, w30, w30);
   TEST_3RF("fcle.w", dataf,  72,  40, w12, w26, w21);
   TEST_3RF("fcle.w", dataf,  72,  48, w28, w6,  w3);
   TEST_3RF("fcle.w", dataf,  72,  56, w29, w17, w3);
   TEST_3RF("fcle.w", dataf,  72,  64, w30, w29, w22);
   TEST_3RF("fcle.w", dataf,  72,  72, w31, w4,  w11);
   TEST_3RF("fcle.d", datad,   0,   0, w19, w2,  w29);
   TEST_3RF("fcle.d", datad,   0,  16, w21, w24, w1);
   TEST_3RF("fcle.d", datad,   0,  32, w0,  w20, w15);
   TEST_3RF("fcle.d", datad,   0,  48, w6,  w23, w15);
   TEST_3RF("fcle.d", datad,   0,  64, w18, w29, w11);
   TEST_3RF("fcle.d", datad,   0,  80, w16, w10, w5);
   TEST_3RF("fcle.d", datad,   0,  96, w5,  w6,  w11);
   TEST_3RF("fcle.d", datad,   0, 112, w9,  w3,  w29);
   TEST_3RF("fcle.d", datad,   0, 128, w12, w1,  w26);
   TEST_3RF("fcle.d", datad,   0, 144, w3,  w0,  w30);
   TEST_3RF("fcle.d", datad,  16,   0, w14, w20, w1);
   TEST_3RF("fcle.d", datad,  16,  16, w11, w9,  w25);
   TEST_3RF("fcle.d", datad,  16,  32, w12, w9,  w13);
   TEST_3RF("fcle.d", datad,  16,  48, w27, w16, w16);
   TEST_3RF("fcle.d", datad,  16,  64, w4,  w11, w4);
   TEST_3RF("fcle.d", datad,  16,  80, w2,  w22, w18);
   TEST_3RF("fcle.d", datad,  16,  96, w12, w27, w23);
   TEST_3RF("fcle.d", datad,  16, 112, w18, w7,  w0);
   TEST_3RF("fcle.d", datad,  16, 128, w22, w4,  w13);
   TEST_3RF("fcle.d", datad,  16, 144, w23, w30, w16);
   TEST_3RF("fcle.d", datad,  32,   0, w24, w24, w29);
   TEST_3RF("fcle.d", datad,  32,  16, w30, w12, w9);
   TEST_3RF("fcle.d", datad,  32,  32, w21, w23, w22);
   TEST_3RF("fcle.d", datad,  32,  48, w31, w4,  w17);
   TEST_3RF("fcle.d", datad,  32,  64, w15, w15, w15);
   TEST_3RF("fcle.d", datad,  32,  80, w8,  w28, w17);
   TEST_3RF("fcle.d", datad,  32,  96, w10, w18, w3);
   TEST_3RF("fcle.d", datad,  32, 112, w22, w14, w26);
   TEST_3RF("fcle.d", datad,  32, 128, w9,  w21, w27);
   TEST_3RF("fcle.d", datad,  32, 144, w31, w25, w8);
   TEST_3RF("fcle.d", datad,  48,   0, w22, w23, w24);
   TEST_3RF("fcle.d", datad,  48,  16, w14, w20, w22);
   TEST_3RF("fcle.d", datad,  48,  32, w26, w18, w31);
   TEST_3RF("fcle.d", datad,  48,  48, w16, w9,  w21);
   TEST_3RF("fcle.d", datad,  48,  64, w15, w15, w15);
   TEST_3RF("fcle.d", datad,  48,  80, w13, w7,  w30);
   TEST_3RF("fcle.d", datad,  48,  96, w22, w3,  w15);
   TEST_3RF("fcle.d", datad,  48, 112, w0,  w22, w18);
   TEST_3RF("fcle.d", datad,  48, 128, w23, w4,  w12);
   TEST_3RF("fcle.d", datad,  48, 144, w0,  w25, w7);
   TEST_3RF("fcle.d", datad,  64,   0, w31, w18, w15);
   TEST_3RF("fcle.d", datad,  64,  16, w21, w9,  w7);
   TEST_3RF("fcle.d", datad,  64,  32, w4,  w30, w4);
   TEST_3RF("fcle.d", datad,  64,  48, w29, w30, w16);
   TEST_3RF("fcle.d", datad,  64,  64, w29, w14, w26);
   TEST_3RF("fcle.d", datad,  64,  80, w18, w29, w7);
   TEST_3RF("fcle.d", datad,  64,  96, w25, w27, w29);
   TEST_3RF("fcle.d", datad,  64, 112, w29, w10, w30);
   TEST_3RF("fcle.d", datad,  64, 128, w19, w28, w21);
   TEST_3RF("fcle.d", datad,  64, 144, w23, w9,  w21);
   TEST_3RF("fcle.d", datad,  80,   0, w16, w20, w2);
   TEST_3RF("fcle.d", datad,  80,  16, w0,  w9,  w11);
   TEST_3RF("fcle.d", datad,  80,  32, w7,  w13, w9);
   TEST_3RF("fcle.d", datad,  80,  48, w5,  w12, w26);
   TEST_3RF("fcle.d", datad,  80,  64, w2,  w26, w20);
   TEST_3RF("fcle.d", datad,  80,  80, w20, w24, w27);
   TEST_3RF("fcle.d", datad,  80,  96, w14, w19, w25);
   TEST_3RF("fcle.d", datad,  80, 112, w11, w30, w23);
   TEST_3RF("fcle.d", datad,  80, 128, w30, w26, w12);
   TEST_3RF("fcle.d", datad,  80, 144, w21, w3,  w1);
   TEST_3RF("fcle.d", datad,  96,   0, w5,  w20, w21);
   TEST_3RF("fcle.d", datad,  96,  16, w7,  w20, w30);
   TEST_3RF("fcle.d", datad,  96,  32, w18, w27, w12);
   TEST_3RF("fcle.d", datad,  96,  48, w28, w0,  w24);
   TEST_3RF("fcle.d", datad,  96,  64, w22, w2,  w18);
   TEST_3RF("fcle.d", datad,  96,  80, w10, w23, w5);
   TEST_3RF("fcle.d", datad,  96,  96, w5,  w30, w16);
   TEST_3RF("fcle.d", datad,  96, 112, w28, w21, w14);
   TEST_3RF("fcle.d", datad,  96, 128, w22, w1,  w3);
   TEST_3RF("fcle.d", datad,  96, 144, w26, w2,  w8);
   TEST_3RF("fcle.d", datad, 112,   0, w14, w23, w15);
   TEST_3RF("fcle.d", datad, 112,  16, w2,  w22, w1);
   TEST_3RF("fcle.d", datad, 112,  32, w29, w2,  w30);
   TEST_3RF("fcle.d", datad, 112,  48, w26, w19, w0);
   TEST_3RF("fcle.d", datad, 112,  64, w12, w29, w23);
   TEST_3RF("fcle.d", datad, 112,  80, w23, w3,  w28);
   TEST_3RF("fcle.d", datad, 112,  96, w21, w1,  w12);
   TEST_3RF("fcle.d", datad, 112, 112, w17, w23, w26);
   TEST_3RF("fcle.d", datad, 112, 128, w7,  w24, w29);
   TEST_3RF("fcle.d", datad, 112, 144, w1,  w27, w5);
   TEST_3RF("fcle.d", datad, 128,   0, w15, w15, w15);
   TEST_3RF("fcle.d", datad, 128,  16, w18, w20, w17);
   TEST_3RF("fcle.d", datad, 128,  32, w8,  w22, w15);
   TEST_3RF("fcle.d", datad, 128,  48, w10, w19, w13);
   TEST_3RF("fcle.d", datad, 128,  64, w4,  w7,  w4);
   TEST_3RF("fcle.d", datad, 128,  80, w13, w17, w4);
   TEST_3RF("fcle.d", datad, 128,  96, w5,  w8,  w7);
   TEST_3RF("fcle.d", datad, 128, 112, w1,  w29, w9);
   TEST_3RF("fcle.d", datad, 128, 128, w14, w0,  w8);
   TEST_3RF("fcle.d", datad, 128, 144, w21, w24, w6);
   TEST_3RF("fcle.d", datad, 144,   0, w23, w19, w11);
   TEST_3RF("fcle.d", datad, 144,  16, w6,  w0,  w24);
   TEST_3RF("fcle.d", datad, 144,  32, w14, w22, w7);
   TEST_3RF("fcle.d", datad, 144,  48, w25, w9,  w20);
   TEST_3RF("fcle.d", datad, 144,  64, w29, w16, w1);
   TEST_3RF("fcle.d", datad, 144,  80, w14, w21, w6);
   TEST_3RF("fcle.d", datad, 144,  96, w22, w28, w8);
   TEST_3RF("fcle.d", datad, 144, 112, w19, w5,  w22);
   TEST_3RF("fcle.d", datad, 144, 128, w1,  w5,  w30);
   TEST_3RF("fcle.d", datad, 144, 144, w23, w30, w4);
   TEST_3RF("fclt.w", dataf,   0,   0, w23, w16, w12);
   TEST_3RF("fclt.w", dataf,   0,   8, w6,  w19, w31);
   TEST_3RF("fclt.w", dataf,   0,  16, w15, w7,  w28);
   TEST_3RF("fclt.w", dataf,   0,  24, w0,  w9,  w11);
   TEST_3RF("fclt.w", dataf,   0,  32, w21, w15, w1);
   TEST_3RF("fclt.w", dataf,   0,  40, w17, w17, w23);
   TEST_3RF("fclt.w", dataf,   0,  48, w21, w23, w13);
   TEST_3RF("fclt.w", dataf,   0,  56, w22, w28, w12);
   TEST_3RF("fclt.w", dataf,   0,  64, w13, w26, w16);
   TEST_3RF("fclt.w", dataf,   0,  72, w27, w12, w0);
   TEST_3RF("fclt.w", dataf,   8,   0, w16, w3,  w16);
   TEST_3RF("fclt.w", dataf,   8,   8, w16, w28, w16);
   TEST_3RF("fclt.w", dataf,   8,  16, w9,  w22, w16);
   TEST_3RF("fclt.w", dataf,   8,  24, w8,  w6,  w23);
   TEST_3RF("fclt.w", dataf,   8,  32, w5,  w6,  w0);
   TEST_3RF("fclt.w", dataf,   8,  40, w16, w27, w16);
   TEST_3RF("fclt.w", dataf,   8,  48, w16, w17, w16);
   TEST_3RF("fclt.w", dataf,   8,  56, w12, w7,  w6);
   TEST_3RF("fclt.w", dataf,   8,  64, w3,  w21, w29);
   TEST_3RF("fclt.w", dataf,   8,  72, w0,  w1,  w10);
   TEST_3RF("fclt.w", dataf,  16,   0, w26, w17, w6);
   TEST_3RF("fclt.w", dataf,  16,   8, w6,  w18, w22);
   TEST_3RF("fclt.w", dataf,  16,  16, w10, w2,  w18);
   TEST_3RF("fclt.w", dataf,  16,  24, w19, w25, w2);
   TEST_3RF("fclt.w", dataf,  16,  32, w28, w31, w26);
   TEST_3RF("fclt.w", dataf,  16,  40, w1,  w5,  w26);
   TEST_3RF("fclt.w", dataf,  16,  48, w17, w17, w0);
   TEST_3RF("fclt.w", dataf,  16,  56, w10, w2,  w12);
   TEST_3RF("fclt.w", dataf,  16,  64, w18, w9,  w16);
   TEST_3RF("fclt.w", dataf,  16,  72, w7,  w6,  w16);
   TEST_3RF("fclt.w", dataf,  24,   0, w8,  w16, w10);
   TEST_3RF("fclt.w", dataf,  24,   8, w25, w22, w17);
   TEST_3RF("fclt.w", dataf,  24,  16, w11, w12, w27);
   TEST_3RF("fclt.w", dataf,  24,  24, w14, w14, w14);
   TEST_3RF("fclt.w", dataf,  24,  32, w31, w14, w7);
   TEST_3RF("fclt.w", dataf,  24,  40, w1,  w10, w6);
   TEST_3RF("fclt.w", dataf,  24,  48, w27, w11, w22);
   TEST_3RF("fclt.w", dataf,  24,  56, w28, w11, w0);
   TEST_3RF("fclt.w", dataf,  24,  64, w31, w23, w18);
   TEST_3RF("fclt.w", dataf,  24,  72, w8,  w7,  w25);
   TEST_3RF("fclt.w", dataf,  32,   0, w14, w14, w14);
   TEST_3RF("fclt.w", dataf,  32,   8, w23, w1,  w30);
   TEST_3RF("fclt.w", dataf,  32,  16, w2,  w27, w21);
   TEST_3RF("fclt.w", dataf,  32,  24, w19, w6,  w1);
   TEST_3RF("fclt.w", dataf,  32,  32, w14, w14, w14);
   TEST_3RF("fclt.w", dataf,  32,  40, w20, w0,  w0);
   TEST_3RF("fclt.w", dataf,  32,  48, w28, w27, w2);
   TEST_3RF("fclt.w", dataf,  32,  56, w7,  w1,  w29);
   TEST_3RF("fclt.w", dataf,  32,  64, w18, w12, w19);
   TEST_3RF("fclt.w", dataf,  32,  72, w15, w23, w20);
   TEST_3RF("fclt.w", dataf,  40,   0, w14, w14, w14);
   TEST_3RF("fclt.w", dataf,  40,   8, w15, w6,  w22);
   TEST_3RF("fclt.w", dataf,  40,  16, w22, w0,  w4);
   TEST_3RF("fclt.w", dataf,  40,  24, w14, w14, w14);
   TEST_3RF("fclt.w", dataf,  40,  32, w1,  w2,  w16);
   TEST_3RF("fclt.w", dataf,  40,  40, w28, w23, w3);
   TEST_3RF("fclt.w", dataf,  40,  48, w3,  w25, w17);
   TEST_3RF("fclt.w", dataf,  40,  56, w23, w25, w13);
   TEST_3RF("fclt.w", dataf,  40,  64, w19, w27, w20);
   TEST_3RF("fclt.w", dataf,  40,  72, w20, w25, w25);
   TEST_3RF("fclt.w", dataf,  48,   0, w7,  w1,  w12);
   TEST_3RF("fclt.w", dataf,  48,   8, w22, w24, w0);
   TEST_3RF("fclt.w", dataf,  48,  16, w4,  w7,  w26);
   TEST_3RF("fclt.w", dataf,  48,  24, w30, w7,  w12);
   TEST_3RF("fclt.w", dataf,  48,  32, w8,  w0,  w28);
   TEST_3RF("fclt.w", dataf,  48,  40, w5,  w24, w31);
   TEST_3RF("fclt.w", dataf,  48,  48, w8,  w17, w16);
   TEST_3RF("fclt.w", dataf,  48,  56, w31, w10, w29);
   TEST_3RF("fclt.w", dataf,  48,  64, w18, w6,  w7);
   TEST_3RF("fclt.w", dataf,  48,  72, w31, w25, w8);
   TEST_3RF("fclt.w", dataf,  56,   0, w11, w15, w0);
   TEST_3RF("fclt.w", dataf,  56,   8, w12, w19, w8);
   TEST_3RF("fclt.w", dataf,  56,  16, w19, w13, w6);
   TEST_3RF("fclt.w", dataf,  56,  24, w26, w11, w18);
   TEST_3RF("fclt.w", dataf,  56,  32, w2,  w11, w14);
   TEST_3RF("fclt.w", dataf,  56,  40, w7,  w3,  w13);
   TEST_3RF("fclt.w", dataf,  56,  48, w15, w20, w29);
   TEST_3RF("fclt.w", dataf,  56,  56, w15, w31, w26);
   TEST_3RF("fclt.w", dataf,  56,  64, w1,  w5,  w12);
   TEST_3RF("fclt.w", dataf,  56,  72, w8,  w4,  w5);
   TEST_3RF("fclt.w", dataf,  64,   0, w16, w15, w16);
   TEST_3RF("fclt.w", dataf,  64,   8, w20, w17, w17);
   TEST_3RF("fclt.w", dataf,  64,  16, w27, w7,  w25);
   TEST_3RF("fclt.w", dataf,  64,  24, w14, w14, w14);
   TEST_3RF("fclt.w", dataf,  64,  32, w20, w31, w31);
   TEST_3RF("fclt.w", dataf,  64,  40, w8,  w31, w17);
   TEST_3RF("fclt.w", dataf,  64,  48, w11, w31, w18);
   TEST_3RF("fclt.w", dataf,  64,  56, w14, w14, w14);
   TEST_3RF("fclt.w", dataf,  64,  64, w12, w2,  w3);
   TEST_3RF("fclt.w", dataf,  64,  72, w9,  w17, w2);
   TEST_3RF("fclt.w", dataf,  72,   0, w3,  w18, w7);
   TEST_3RF("fclt.w", dataf,  72,   8, w16, w27, w16);
   TEST_3RF("fclt.w", dataf,  72,  16, w11, w21, w26);
   TEST_3RF("fclt.w", dataf,  72,  24, w10, w28, w22);
   TEST_3RF("fclt.w", dataf,  72,  32, w17, w17, w21);
   TEST_3RF("fclt.w", dataf,  72,  40, w4,  w6,  w20);
   TEST_3RF("fclt.w", dataf,  72,  48, w13, w5,  w24);
   TEST_3RF("fclt.w", dataf,  72,  56, w16, w4,  w16);
   TEST_3RF("fclt.w", dataf,  72,  64, w10, w31, w16);
   TEST_3RF("fclt.w", dataf,  72,  72, w12, w2,  w25);
   TEST_3RF("fclt.d", datad,   0,   0, w29, w4,  w16);
   TEST_3RF("fclt.d", datad,   0,  16, w11, w13, w22);
   TEST_3RF("fclt.d", datad,   0,  32, w2,  w22, w16);
   TEST_3RF("fclt.d", datad,   0,  48, w12, w19, w6);
   TEST_3RF("fclt.d", datad,   0,  64, w30, w8,  w11);
   TEST_3RF("fclt.d", datad,   0,  80, w4,  w29, w24);
   TEST_3RF("fclt.d", datad,   0,  96, w9,  w2,  w16);
   TEST_3RF("fclt.d", datad,   0, 112, w26, w7,  w25);
   TEST_3RF("fclt.d", datad,   0, 128, w23, w7,  w27);
   TEST_3RF("fclt.d", datad,   0, 144, w17, w17, w4);
   TEST_3RF("fclt.d", datad,  16,   0, w31, w14, w20);
   TEST_3RF("fclt.d", datad,  16,  16, w10, w27, w31);
   TEST_3RF("fclt.d", datad,  16,  32, w0,  w29, w22);
   TEST_3RF("fclt.d", datad,  16,  48, w16, w10, w16);
   TEST_3RF("fclt.d", datad,  16,  64, w9,  w23, w8);
   TEST_3RF("fclt.d", datad,  16,  80, w17, w17, w2);
   TEST_3RF("fclt.d", datad,  16,  96, w12, w14, w26);
   TEST_3RF("fclt.d", datad,  16, 112, w21, w17, w10);
   TEST_3RF("fclt.d", datad,  16, 128, w15, w24, w4);
   TEST_3RF("fclt.d", datad,  16, 144, w8,  w15, w11);
   TEST_3RF("fclt.d", datad,  32,   0, w3,  w0,  w16);
   TEST_3RF("fclt.d", datad,  32,  16, w2,  w14, w4);
   TEST_3RF("fclt.d", datad,  32,  32, w12, w9,  w4);
   TEST_3RF("fclt.d", datad,  32,  48, w12, w7,  w26);
   TEST_3RF("fclt.d", datad,  32,  64, w29, w17, w3);
   TEST_3RF("fclt.d", datad,  32,  80, w20, w25, w25);
   TEST_3RF("fclt.d", datad,  32,  96, w20, w22, w22);
   TEST_3RF("fclt.d", datad,  32, 112, w5,  w3,  w16);
   TEST_3RF("fclt.d", datad,  32, 128, w26, w20, w10);
   TEST_3RF("fclt.d", datad,  32, 144, w12, w30, w18);
   TEST_3RF("fclt.d", datad,  48,   0, w27, w10, w22);
   TEST_3RF("fclt.d", datad,  48,  16, w28, w26, w24);
   TEST_3RF("fclt.d", datad,  48,  32, w10, w30, w5);
   TEST_3RF("fclt.d", datad,  48,  48, w20, w2,  w2);
   TEST_3RF("fclt.d", datad,  48,  64, w17, w17, w27);
   TEST_3RF("fclt.d", datad,  48,  80, w28, w14, w12);
   TEST_3RF("fclt.d", datad,  48,  96, w31, w2,  w5);
   TEST_3RF("fclt.d", datad,  48, 112, w20, w24, w24);
   TEST_3RF("fclt.d", datad,  48, 128, w10, w23, w8);
   TEST_3RF("fclt.d", datad,  48, 144, w4,  w11, w2);
   TEST_3RF("fclt.d", datad,  64,   0, w14, w14, w14);
   TEST_3RF("fclt.d", datad,  64,  16, w23, w1,  w18);
   TEST_3RF("fclt.d", datad,  64,  32, w11, w23, w14);
   TEST_3RF("fclt.d", datad,  64,  48, w5,  w15, w25);
   TEST_3RF("fclt.d", datad,  64,  64, w3,  w20, w13);
   TEST_3RF("fclt.d", datad,  64,  80, w6,  w8,  w2);
   TEST_3RF("fclt.d", datad,  64,  96, w20, w2,  w2);
   TEST_3RF("fclt.d", datad,  64, 112, w23, w25, w22);
   TEST_3RF("fclt.d", datad,  64, 128, w15, w3,  w13);
   TEST_3RF("fclt.d", datad,  64, 144, w24, w7,  w26);
   TEST_3RF("fclt.d", datad,  80,   0, w22, w15, w27);
   TEST_3RF("fclt.d", datad,  80,  16, w23, w1,  w6);
   TEST_3RF("fclt.d", datad,  80,  32, w14, w14, w14);
   TEST_3RF("fclt.d", datad,  80,  48, w16, w11, w16);
   TEST_3RF("fclt.d", datad,  80,  64, w29, w9,  w15);
   TEST_3RF("fclt.d", datad,  80,  80, w18, w22, w21);
   TEST_3RF("fclt.d", datad,  80,  96, w24, w30, w23);
   TEST_3RF("fclt.d", datad,  80, 112, w12, w18, w25);
   TEST_3RF("fclt.d", datad,  80, 128, w3,  w11, w15);
   TEST_3RF("fclt.d", datad,  80, 144, w19, w14, w28);
   TEST_3RF("fclt.d", datad,  96,   0, w11, w21, w20);
   TEST_3RF("fclt.d", datad,  96,  16, w5,  w11, w3);
   TEST_3RF("fclt.d", datad,  96,  32, w1,  w2,  w5);
   TEST_3RF("fclt.d", datad,  96,  48, w7,  w16, w21);
   TEST_3RF("fclt.d", datad,  96,  64, w19, w14, w30);
   TEST_3RF("fclt.d", datad,  96,  80, w2,  w0,  w20);
   TEST_3RF("fclt.d", datad,  96,  96, w23, w24, w18);
   TEST_3RF("fclt.d", datad,  96, 112, w14, w14, w14);
   TEST_3RF("fclt.d", datad,  96, 128, w4,  w8,  w15);
   TEST_3RF("fclt.d", datad,  96, 144, w23, w27, w29);
   TEST_3RF("fclt.d", datad, 112,   0, w20, w6,  w6);
   TEST_3RF("fclt.d", datad, 112,  16, w18, w8,  w11);
   TEST_3RF("fclt.d", datad, 112,  32, w30, w12, w0);
   TEST_3RF("fclt.d", datad, 112,  48, w17, w17, w20);
   TEST_3RF("fclt.d", datad, 112,  64, w17, w17, w6);
   TEST_3RF("fclt.d", datad, 112,  80, w7,  w31, w4);
   TEST_3RF("fclt.d", datad, 112,  96, w9,  w31, w24);
   TEST_3RF("fclt.d", datad, 112, 112, w0,  w23, w10);
   TEST_3RF("fclt.d", datad, 112, 128, w14, w14, w14);
   TEST_3RF("fclt.d", datad, 112, 144, w27, w14, w22);
   TEST_3RF("fclt.d", datad, 128,   0, w3,  w29, w14);
   TEST_3RF("fclt.d", datad, 128,  16, w30, w26, w2);
   TEST_3RF("fclt.d", datad, 128,  32, w4,  w12, w10);
   TEST_3RF("fclt.d", datad, 128,  48, w16, w10, w16);
   TEST_3RF("fclt.d", datad, 128,  64, w22, w28, w11);
   TEST_3RF("fclt.d", datad, 128,  80, w7,  w16, w28);
   TEST_3RF("fclt.d", datad, 128,  96, w13, w23, w27);
   TEST_3RF("fclt.d", datad, 128, 112, w17, w17, w0);
   TEST_3RF("fclt.d", datad, 128, 128, w26, w9,  w0);
   TEST_3RF("fclt.d", datad, 128, 144, w17, w17, w19);
   TEST_3RF("fclt.d", datad, 144,   0, w15, w12, w1);
   TEST_3RF("fclt.d", datad, 144,  16, w5,  w16, w30);
   TEST_3RF("fclt.d", datad, 144,  32, w19, w14, w24);
   TEST_3RF("fclt.d", datad, 144,  48, w21, w19, w5);
   TEST_3RF("fclt.d", datad, 144,  64, w0,  w3,  w15);
   TEST_3RF("fclt.d", datad, 144,  80, w22, w31, w26);
   TEST_3RF("fclt.d", datad, 144,  96, w30, w16, w22);
   TEST_3RF("fclt.d", datad, 144, 112, w11, w7,  w17);
   TEST_3RF("fclt.d", datad, 144, 128, w29, w8,  w11);
   TEST_3RF("fclt.d", datad, 144, 144, w6,  w8,  w28);
   TEST_3RF("fcne.w", dataf,   0,   0, w29, w25, w26);
   TEST_3RF("fcne.w", dataf,   0,   8, w16, w7,  w18);
   TEST_3RF("fcne.w", dataf,   0,  16, w6,  w26, w23);
   TEST_3RF("fcne.w", dataf,   0,  24, w6,  w29, w7);
   TEST_3RF("fcne.w", dataf,   0,  32, w28, w29, w1);
   TEST_3RF("fcne.w", dataf,   0,  40, w26, w26, w26);
   TEST_3RF("fcne.w", dataf,   0,  48, w13, w24, w6);
   TEST_3RF("fcne.w", dataf,   0,  56, w20, w9,  w3);
   TEST_3RF("fcne.w", dataf,   0,  64, w28, w21, w9);
   TEST_3RF("fcne.w", dataf,   0,  72, w5,  w17, w3);
   TEST_3RF("fcne.w", dataf,   8,   0, w28, w26, w31);
   TEST_3RF("fcne.w", dataf,   8,   8, w25, w19, w10);
   TEST_3RF("fcne.w", dataf,   8,  16, w27, w11, w11);
   TEST_3RF("fcne.w", dataf,   8,  24, w16, w21, w3);
   TEST_3RF("fcne.w", dataf,   8,  32, w22, w19, w10);
   TEST_3RF("fcne.w", dataf,   8,  40, w18, w16, w11);
   TEST_3RF("fcne.w", dataf,   8,  48, w13, w29, w3);
   TEST_3RF("fcne.w", dataf,   8,  56, w19, w17, w13);
   TEST_3RF("fcne.w", dataf,   8,  64, w22, w14, w2);
   TEST_3RF("fcne.w", dataf,   8,  72, w31, w19, w3);
   TEST_3RF("fcne.w", dataf,  16,   0, w15, w14, w2);
   TEST_3RF("fcne.w", dataf,  16,   8, w9,  w1,  w9);
   TEST_3RF("fcne.w", dataf,  16,  16, w27, w19, w19);
   TEST_3RF("fcne.w", dataf,  16,  24, w28, w6,  w3);
   TEST_3RF("fcne.w", dataf,  16,  32, w18, w9,  w25);
   TEST_3RF("fcne.w", dataf,  16,  40, w5,  w19, w11);
   TEST_3RF("fcne.w", dataf,  16,  48, w21, w31, w24);
   TEST_3RF("fcne.w", dataf,  16,  56, w18, w2,  w11);
   TEST_3RF("fcne.w", dataf,  16,  64, w3,  w15, w1);
   TEST_3RF("fcne.w", dataf,  16,  72, w17, w1,  w4);
   TEST_3RF("fcne.w", dataf,  24,   0, w5,  w4,  w20);
   TEST_3RF("fcne.w", dataf,  24,   8, w19, w6,  w29);
   TEST_3RF("fcne.w", dataf,  24,  16, w20, w1,  w16);
   TEST_3RF("fcne.w", dataf,  24,  24, w17, w7,  w19);
   TEST_3RF("fcne.w", dataf,  24,  32, w3,  w17, w12);
   TEST_3RF("fcne.w", dataf,  24,  40, w8,  w4,  w23);
   TEST_3RF("fcne.w", dataf,  24,  48, w29, w3,  w16);
   TEST_3RF("fcne.w", dataf,  24,  56, w15, w6,  w27);
   TEST_3RF("fcne.w", dataf,  24,  64, w18, w21, w29);
   TEST_3RF("fcne.w", dataf,  24,  72, w4,  w7,  w30);
   TEST_3RF("fcne.w", dataf,  32,   0, w8,  w12, w2);
   TEST_3RF("fcne.w", dataf,  32,   8, w28, w31, w8);
   TEST_3RF("fcne.w", dataf,  32,  16, w25, w19, w9);
   TEST_3RF("fcne.w", dataf,  32,  24, w9,  w4,  w9);
   TEST_3RF("fcne.w", dataf,  32,  32, w16, w28, w7);
   TEST_3RF("fcne.w", dataf,  32,  40, w1,  w8,  w15);
   TEST_3RF("fcne.w", dataf,  32,  48, w6,  w0,  w12);
   TEST_3RF("fcne.w", dataf,  32,  56, w9,  w16, w9);
   TEST_3RF("fcne.w", dataf,  32,  64, w27, w15, w15);
   TEST_3RF("fcne.w", dataf,  32,  72, w11, w14, w5);
   TEST_3RF("fcne.w", dataf,  40,   0, w8,  w18, w12);
   TEST_3RF("fcne.w", dataf,  40,   8, w6,  w26, w24);
   TEST_3RF("fcne.w", dataf,  40,  16, w8,  w23, w16);
   TEST_3RF("fcne.w", dataf,  40,  24, w16, w10, w25);
   TEST_3RF("fcne.w", dataf,  40,  32, w26, w26, w26);
   TEST_3RF("fcne.w", dataf,  40,  40, w15, w10, w22);
   TEST_3RF("fcne.w", dataf,  40,  48, w22, w11, w31);
   TEST_3RF("fcne.w", dataf,  40,  56, w6,  w17, w31);
   TEST_3RF("fcne.w", dataf,  40,  64, w18, w27, w15);
   TEST_3RF("fcne.w", dataf,  40,  72, w14, w10, w26);
   TEST_3RF("fcne.w", dataf,  48,   0, w28, w15, w3);
   TEST_3RF("fcne.w", dataf,  48,   8, w14, w27, w9);
   TEST_3RF("fcne.w", dataf,  48,  16, w8,  w19, w18);
   TEST_3RF("fcne.w", dataf,  48,  24, w31, w10, w2);
   TEST_3RF("fcne.w", dataf,  48,  32, w16, w21, w28);
   TEST_3RF("fcne.w", dataf,  48,  40, w10, w4,  w6);
   TEST_3RF("fcne.w", dataf,  48,  48, w0,  w26, w17);
   TEST_3RF("fcne.w", dataf,  48,  56, w31, w0,  w3);
   TEST_3RF("fcne.w", dataf,  48,  64, w30, w19, w13);
   TEST_3RF("fcne.w", dataf,  48,  72, w1,  w8,  w29);
   TEST_3RF("fcne.w", dataf,  56,   0, w24, w11, w19);
   TEST_3RF("fcne.w", dataf,  56,   8, w20, w19, w7);
   TEST_3RF("fcne.w", dataf,  56,  16, w6,  w19, w17);
   TEST_3RF("fcne.w", dataf,  56,  24, w9,  w3,  w9);
   TEST_3RF("fcne.w", dataf,  56,  32, w6,  w5,  w13);
   TEST_3RF("fcne.w", dataf,  56,  40, w10, w11, w13);
   TEST_3RF("fcne.w", dataf,  56,  48, w5,  w28, w13);
   TEST_3RF("fcne.w", dataf,  56,  56, w5,  w31, w11);
   TEST_3RF("fcne.w", dataf,  56,  64, w24, w29, w25);
   TEST_3RF("fcne.w", dataf,  56,  72, w25, w6,  w1);
   TEST_3RF("fcne.w", dataf,  64,   0, w22, w30, w12);
   TEST_3RF("fcne.w", dataf,  64,   8, w1,  w17, w0);
   TEST_3RF("fcne.w", dataf,  64,  16, w21, w24, w7);
   TEST_3RF("fcne.w", dataf,  64,  24, w8,  w10, w16);
   TEST_3RF("fcne.w", dataf,  64,  32, w11, w16, w21);
   TEST_3RF("fcne.w", dataf,  64,  40, w24, w27, w0);
   TEST_3RF("fcne.w", dataf,  64,  48, w5,  w0,  w28);
   TEST_3RF("fcne.w", dataf,  64,  56, w18, w5,  w28);
   TEST_3RF("fcne.w", dataf,  64,  64, w30, w25, w23);
   TEST_3RF("fcne.w", dataf,  64,  72, w23, w23, w31);
   TEST_3RF("fcne.w", dataf,  72,   0, w24, w14, w29);
   TEST_3RF("fcne.w", dataf,  72,   8, w4,  w15, w7);
   TEST_3RF("fcne.w", dataf,  72,  16, w11, w12, w17);
   TEST_3RF("fcne.w", dataf,  72,  24, w27, w23, w23);
   TEST_3RF("fcne.w", dataf,  72,  32, w2,  w16, w15);
   TEST_3RF("fcne.w", dataf,  72,  40, w29, w16, w21);
   TEST_3RF("fcne.w", dataf,  72,  48, w29, w13, w7);
   TEST_3RF("fcne.w", dataf,  72,  56, w2,  w9,  w5);
   TEST_3RF("fcne.w", dataf,  72,  64, w0,  w2,  w28);
   TEST_3RF("fcne.w", dataf,  72,  72, w24, w2,  w20);
   TEST_3RF("fcne.d", datad,   0,   0, w6,  w31, w24);
   TEST_3RF("fcne.d", datad,   0,  16, w21, w14, w29);
   TEST_3RF("fcne.d", datad,   0,  32, w26, w26, w26);
   TEST_3RF("fcne.d", datad,   0,  48, w22, w8,  w6);
   TEST_3RF("fcne.d", datad,   0,  64, w7,  w4,  w30);
   TEST_3RF("fcne.d", datad,   0,  80, w9,  w20, w9);
   TEST_3RF("fcne.d", datad,   0,  96, w13, w6,  w5);
   TEST_3RF("fcne.d", datad,   0, 112, w2,  w3,  w18);
   TEST_3RF("fcne.d", datad,   0, 128, w10, w6,  w27);
   TEST_3RF("fcne.d", datad,   0, 144, w15, w6,  w29);
   TEST_3RF("fcne.d", datad,  16,   0, w12, w30, w31);
   TEST_3RF("fcne.d", datad,  16,  16, w0,  w4,  w31);
   TEST_3RF("fcne.d", datad,  16,  32, w25, w26, w13);
   TEST_3RF("fcne.d", datad,  16,  48, w22, w20, w3);
   TEST_3RF("fcne.d", datad,  16,  64, w30, w26, w11);
   TEST_3RF("fcne.d", datad,  16,  80, w2,  w24, w20);
   TEST_3RF("fcne.d", datad,  16,  96, w23, w23, w6);
   TEST_3RF("fcne.d", datad,  16, 112, w27, w28, w28);
   TEST_3RF("fcne.d", datad,  16, 128, w8,  w30, w14);
   TEST_3RF("fcne.d", datad,  16, 144, w18, w4,  w9);
   TEST_3RF("fcne.d", datad,  32,   0, w2,  w11, w6);
   TEST_3RF("fcne.d", datad,  32,  16, w14, w9,  w6);
   TEST_3RF("fcne.d", datad,  32,  32, w14, w5,  w7);
   TEST_3RF("fcne.d", datad,  32,  48, w8,  w18, w29);
   TEST_3RF("fcne.d", datad,  32,  64, w28, w22, w1);
   TEST_3RF("fcne.d", datad,  32,  80, w30, w15, w21);
   TEST_3RF("fcne.d", datad,  32,  96, w21, w16, w17);
   TEST_3RF("fcne.d", datad,  32, 112, w29, w15, w31);
   TEST_3RF("fcne.d", datad,  32, 128, w16, w19, w8);
   TEST_3RF("fcne.d", datad,  32, 144, w18, w30, w15);
   TEST_3RF("fcne.d", datad,  48,   0, w0,  w8,  w21);
   TEST_3RF("fcne.d", datad,  48,  16, w14, w22, w26);
   TEST_3RF("fcne.d", datad,  48,  32, w22, w30, w12);
   TEST_3RF("fcne.d", datad,  48,  48, w19, w26, w2);
   TEST_3RF("fcne.d", datad,  48,  64, w15, w16, w3);
   TEST_3RF("fcne.d", datad,  48,  80, w14, w31, w25);
   TEST_3RF("fcne.d", datad,  48,  96, w3,  w20, w9);
   TEST_3RF("fcne.d", datad,  48, 112, w21, w18, w24);
   TEST_3RF("fcne.d", datad,  48, 128, w20, w2,  w12);
   TEST_3RF("fcne.d", datad,  48, 144, w29, w20, w10);
   TEST_3RF("fcne.d", datad,  64,   0, w12, w20, w18);
   TEST_3RF("fcne.d", datad,  64,  16, w1,  w2,  w8);
   TEST_3RF("fcne.d", datad,  64,  32, w27, w24, w24);
   TEST_3RF("fcne.d", datad,  64,  48, w6,  w7,  w12);
   TEST_3RF("fcne.d", datad,  64,  64, w0,  w10, w27);
   TEST_3RF("fcne.d", datad,  64,  80, w17, w13, w9);
   TEST_3RF("fcne.d", datad,  64,  96, w16, w6,  w13);
   TEST_3RF("fcne.d", datad,  64, 112, w5,  w16, w2);
   TEST_3RF("fcne.d", datad,  64, 128, w23, w23, w8);
   TEST_3RF("fcne.d", datad,  64, 144, w22, w25, w20);
   TEST_3RF("fcne.d", datad,  80,   0, w19, w13, w31);
   TEST_3RF("fcne.d", datad,  80,  16, w31, w1,  w17);
   TEST_3RF("fcne.d", datad,  80,  32, w0,  w3,  w26);
   TEST_3RF("fcne.d", datad,  80,  48, w27, w28, w28);
   TEST_3RF("fcne.d", datad,  80,  64, w0,  w3,  w8);
   TEST_3RF("fcne.d", datad,  80,  80, w1,  w13, w3);
   TEST_3RF("fcne.d", datad,  80,  96, w18, w26, w13);
   TEST_3RF("fcne.d", datad,  80, 112, w2,  w1,  w26);
   TEST_3RF("fcne.d", datad,  80, 128, w7,  w17, w28);
   TEST_3RF("fcne.d", datad,  80, 144, w30, w25, w18);
   TEST_3RF("fcne.d", datad,  96,   0, w23, w23, w14);
   TEST_3RF("fcne.d", datad,  96,  16, w6,  w4,  w13);
   TEST_3RF("fcne.d", datad,  96,  32, w5,  w30, w6);
   TEST_3RF("fcne.d", datad,  96,  48, w9,  w24, w9);
   TEST_3RF("fcne.d", datad,  96,  64, w1,  w5,  w25);
   TEST_3RF("fcne.d", datad,  96,  80, w4,  w13, w26);
   TEST_3RF("fcne.d", datad,  96,  96, w17, w16, w12);
   TEST_3RF("fcne.d", datad,  96, 112, w12, w29, w14);
   TEST_3RF("fcne.d", datad,  96, 128, w13, w23, w22);
   TEST_3RF("fcne.d", datad,  96, 144, w30, w19, w20);
   TEST_3RF("fcne.d", datad, 112,   0, w23, w23, w6);
   TEST_3RF("fcne.d", datad, 112,  16, w12, w5,  w16);
   TEST_3RF("fcne.d", datad, 112,  32, w18, w17, w22);
   TEST_3RF("fcne.d", datad, 112,  48, w17, w23, w31);
   TEST_3RF("fcne.d", datad, 112,  64, w9,  w25, w9);
   TEST_3RF("fcne.d", datad, 112,  80, w4,  w2,  w29);
   TEST_3RF("fcne.d", datad, 112,  96, w17, w28, w15);
   TEST_3RF("fcne.d", datad, 112, 112, w1,  w8,  w27);
   TEST_3RF("fcne.d", datad, 112, 128, w31, w23, w8);
   TEST_3RF("fcne.d", datad, 112, 144, w22, w13, w6);
   TEST_3RF("fcne.d", datad, 128,   0, w10, w1,  w29);
   TEST_3RF("fcne.d", datad, 128,  16, w16, w13, w3);
   TEST_3RF("fcne.d", datad, 128,  32, w28, w30, w21);
   TEST_3RF("fcne.d", datad, 128,  48, w13, w20, w6);
   TEST_3RF("fcne.d", datad, 128,  64, w5,  w19, w16);
   TEST_3RF("fcne.d", datad, 128,  80, w30, w23, w18);
   TEST_3RF("fcne.d", datad, 128,  96, w27, w8,  w8);
   TEST_3RF("fcne.d", datad, 128, 112, w15, w10, w9);
   TEST_3RF("fcne.d", datad, 128, 128, w23, w23, w5);
   TEST_3RF("fcne.d", datad, 128, 144, w8,  w14, w13);
   TEST_3RF("fcne.d", datad, 144,   0, w31, w27, w19);
   TEST_3RF("fcne.d", datad, 144,  16, w9,  w29, w9);
   TEST_3RF("fcne.d", datad, 144,  32, w17, w25, w10);
   TEST_3RF("fcne.d", datad, 144,  48, w20, w21, w8);
   TEST_3RF("fcne.d", datad, 144,  64, w9,  w2,  w9);
   TEST_3RF("fcne.d", datad, 144,  80, w28, w16, w7);
   TEST_3RF("fcne.d", datad, 144,  96, w15, w0,  w5);
   TEST_3RF("fcne.d", datad, 144, 112, w6,  w18, w1);
   TEST_3RF("fcne.d", datad, 144, 128, w14, w1,  w11);
   TEST_3RF("fcne.d", datad, 144, 144, w24, w25, w17);
   TEST_3RF("fcor.w", dataf,   0,   0, w3,  w18, w8);
   TEST_3RF("fcor.w", dataf,   0,   8, w0,  w0,  w0);
   TEST_3RF("fcor.w", dataf,   0,  16, w3,  w1,  w10);
   TEST_3RF("fcor.w", dataf,   0,  24, w23, w22, w19);
   TEST_3RF("fcor.w", dataf,   0,  32, w0,  w0,  w0);
   TEST_3RF("fcor.w", dataf,   0,  40, w25, w15, w16);
   TEST_3RF("fcor.w", dataf,   0,  48, w0,  w0,  w0);
   TEST_3RF("fcor.w", dataf,   0,  56, w31, w16, w16);
   TEST_3RF("fcor.w", dataf,   0,  64, w6,  w5,  w3);
   TEST_3RF("fcor.w", dataf,   0,  72, w7,  w7,  w20);
   TEST_3RF("fcor.w", dataf,   8,   0, w4,  w18, w12);
   TEST_3RF("fcor.w", dataf,   8,   8, w29, w3,  w12);
   TEST_3RF("fcor.w", dataf,   8,  16, w5,  w2,  w12);
   TEST_3RF("fcor.w", dataf,   8,  24, w8,  w20, w23);
   TEST_3RF("fcor.w", dataf,   8,  32, w22, w18, w14);
   TEST_3RF("fcor.w", dataf,   8,  40, w12, w5,  w14);
   TEST_3RF("fcor.w", dataf,   8,  48, w5,  w21, w31);
   TEST_3RF("fcor.w", dataf,   8,  56, w6,  w20, w15);
   TEST_3RF("fcor.w", dataf,   8,  64, w12, w25, w18);
   TEST_3RF("fcor.w", dataf,   8,  72, w19, w13, w23);
   TEST_3RF("fcor.w", dataf,  16,   0, w5,  w25, w20);
   TEST_3RF("fcor.w", dataf,  16,   8, w9,  w6,  w25);
   TEST_3RF("fcor.w", dataf,  16,  16, w11, w18, w1);
   TEST_3RF("fcor.w", dataf,  16,  24, w31, w6,  w6);
   TEST_3RF("fcor.w", dataf,  16,  32, w9,  w22, w28);
   TEST_3RF("fcor.w", dataf,  16,  40, w28, w4,  w9);
   TEST_3RF("fcor.w", dataf,  16,  48, w1,  w18, w14);
   TEST_3RF("fcor.w", dataf,  16,  56, w22, w17, w20);
   TEST_3RF("fcor.w", dataf,  16,  64, w10, w1,  w0);
   TEST_3RF("fcor.w", dataf,  16,  72, w4,  w19, w17);
   TEST_3RF("fcor.w", dataf,  24,   0, w10, w25, w11);
   TEST_3RF("fcor.w", dataf,  24,   8, w31, w2,  w2);
   TEST_3RF("fcor.w", dataf,  24,  16, w17, w24, w13);
   TEST_3RF("fcor.w", dataf,  24,  24, w3,  w26, w12);
   TEST_3RF("fcor.w", dataf,  24,  32, w9,  w3,  w2);
   TEST_3RF("fcor.w", dataf,  24,  40, w6,  w31, w15);
   TEST_3RF("fcor.w", dataf,  24,  48, w1,  w24, w29);
   TEST_3RF("fcor.w", dataf,  24,  56, w23, w10, w18);
   TEST_3RF("fcor.w", dataf,  24,  64, w2,  w11, w18);
   TEST_3RF("fcor.w", dataf,  24,  72, w6,  w30, w23);
   TEST_3RF("fcor.w", dataf,  32,   0, w9,  w31, w2);
   TEST_3RF("fcor.w", dataf,  32,   8, w8,  w1,  w19);
   TEST_3RF("fcor.w", dataf,  32,  16, w0,  w0,  w0);
   TEST_3RF("fcor.w", dataf,  32,  24, w14, w22, w26);
   TEST_3RF("fcor.w", dataf,  32,  32, w26, w0,  w30);
   TEST_3RF("fcor.w", dataf,  32,  40, w28, w6,  w29);
   TEST_3RF("fcor.w", dataf,  32,  48, w2,  w21, w30);
   TEST_3RF("fcor.w", dataf,  32,  56, w26, w18, w22);
   TEST_3RF("fcor.w", dataf,  32,  64, w4,  w24, w15);
   TEST_3RF("fcor.w", dataf,  32,  72, w23, w30, w14);
   TEST_3RF("fcor.w", dataf,  40,   0, w29, w21, w23);
   TEST_3RF("fcor.w", dataf,  40,   8, w28, w24, w31);
   TEST_3RF("fcor.w", dataf,  40,  16, w29, w11, w31);
   TEST_3RF("fcor.w", dataf,  40,  24, w11, w2,  w26);
   TEST_3RF("fcor.w", dataf,  40,  32, w5,  w2,  w24);
   TEST_3RF("fcor.w", dataf,  40,  40, w1,  w8,  w21);
   TEST_3RF("fcor.w", dataf,  40,  48, w3,  w29, w20);
   TEST_3RF("fcor.w", dataf,  40,  56, w29, w15, w10);
   TEST_3RF("fcor.w", dataf,  40,  64, w2,  w20, w17);
   TEST_3RF("fcor.w", dataf,  40,  72, w11, w0,  w31);
   TEST_3RF("fcor.w", dataf,  48,   0, w8,  w21, w22);
   TEST_3RF("fcor.w", dataf,  48,   8, w4,  w13, w21);
   TEST_3RF("fcor.w", dataf,  48,  16, w1,  w25, w21);
   TEST_3RF("fcor.w", dataf,  48,  24, w12, w27, w15);
   TEST_3RF("fcor.w", dataf,  48,  32, w17, w29, w7);
   TEST_3RF("fcor.w", dataf,  48,  40, w18, w5,  w28);
   TEST_3RF("fcor.w", dataf,  48,  48, w21, w2,  w16);
   TEST_3RF("fcor.w", dataf,  48,  56, w18, w17, w26);
   TEST_3RF("fcor.w", dataf,  48,  64, w20, w5,  w28);
   TEST_3RF("fcor.w", dataf,  48,  72, w6,  w16, w28);
   TEST_3RF("fcor.w", dataf,  56,   0, w5,  w24, w18);
   TEST_3RF("fcor.w", dataf,  56,   8, w28, w31, w17);
   TEST_3RF("fcor.w", dataf,  56,  16, w29, w24, w6);
   TEST_3RF("fcor.w", dataf,  56,  24, w9,  w19, w21);
   TEST_3RF("fcor.w", dataf,  56,  32, w26, w16, w28);
   TEST_3RF("fcor.w", dataf,  56,  40, w12, w21, w25);
   TEST_3RF("fcor.w", dataf,  56,  48, w1,  w23, w9);
   TEST_3RF("fcor.w", dataf,  56,  56, w20, w9,  w4);
   TEST_3RF("fcor.w", dataf,  56,  64, w8,  w14, w0);
   TEST_3RF("fcor.w", dataf,  56,  72, w14, w31, w29);
   TEST_3RF("fcor.w", dataf,  64,   0, w20, w23, w15);
   TEST_3RF("fcor.w", dataf,  64,   8, w16, w20, w14);
   TEST_3RF("fcor.w", dataf,  64,  16, w1,  w17, w7);
   TEST_3RF("fcor.w", dataf,  64,  24, w8,  w27, w26);
   TEST_3RF("fcor.w", dataf,  64,  32, w29, w21, w11);
   TEST_3RF("fcor.w", dataf,  64,  40, w26, w2,  w0);
   TEST_3RF("fcor.w", dataf,  64,  48, w19, w3,  w24);
   TEST_3RF("fcor.w", dataf,  64,  56, w28, w23, w1);
   TEST_3RF("fcor.w", dataf,  64,  64, w0,  w0,  w0);
   TEST_3RF("fcor.w", dataf,  64,  72, w0,  w0,  w0);
   TEST_3RF("fcor.w", dataf,  72,   0, w15, w1,  w14);
   TEST_3RF("fcor.w", dataf,  72,   8, w14, w30, w2);
   TEST_3RF("fcor.w", dataf,  72,  16, w6,  w13, w18);
   TEST_3RF("fcor.w", dataf,  72,  24, w26, w27, w20);
   TEST_3RF("fcor.w", dataf,  72,  32, w11, w2,  w28);
   TEST_3RF("fcor.w", dataf,  72,  40, w6,  w29, w25);
   TEST_3RF("fcor.w", dataf,  72,  48, w28, w8,  w19);
   TEST_3RF("fcor.w", dataf,  72,  56, w30, w8,  w30);
   TEST_3RF("fcor.w", dataf,  72,  64, w6,  w1,  w0);
   TEST_3RF("fcor.w", dataf,  72,  72, w3,  w25, w1);
   TEST_3RF("fcor.d", datad,   0,   0, w3,  w25, w17);
   TEST_3RF("fcor.d", datad,   0,  16, w4,  w7,  w31);
   TEST_3RF("fcor.d", datad,   0,  32, w2,  w10, w5);
   TEST_3RF("fcor.d", datad,   0,  48, w15, w28, w31);
   TEST_3RF("fcor.d", datad,   0,  64, w11, w16, w13);
   TEST_3RF("fcor.d", datad,   0,  80, w12, w17, w10);
   TEST_3RF("fcor.d", datad,   0,  96, w6,  w13, w18);
   TEST_3RF("fcor.d", datad,   0, 112, w25, w11, w27);
   TEST_3RF("fcor.d", datad,   0, 128, w0,  w0,  w0);
   TEST_3RF("fcor.d", datad,   0, 144, w13, w27, w3);
   TEST_3RF("fcor.d", datad,  16,   0, w6,  w29, w31);
   TEST_3RF("fcor.d", datad,  16,  16, w14, w11, w6);
   TEST_3RF("fcor.d", datad,  16,  32, w13, w16, w19);
   TEST_3RF("fcor.d", datad,  16,  48, w29, w13, w18);
   TEST_3RF("fcor.d", datad,  16,  64, w8,  w29, w21);
   TEST_3RF("fcor.d", datad,  16,  80, w10, w15, w0);
   TEST_3RF("fcor.d", datad,  16,  96, w16, w28, w18);
   TEST_3RF("fcor.d", datad,  16, 112, w9,  w8,  w13);
   TEST_3RF("fcor.d", datad,  16, 128, w9,  w21, w12);
   TEST_3RF("fcor.d", datad,  16, 144, w27, w6,  w19);
   TEST_3RF("fcor.d", datad,  32,   0, w26, w20, w30);
   TEST_3RF("fcor.d", datad,  32,  16, w0,  w0,  w0);
   TEST_3RF("fcor.d", datad,  32,  32, w1,  w11, w17);
   TEST_3RF("fcor.d", datad,  32,  48, w20, w8,  w30);
   TEST_3RF("fcor.d", datad,  32,  64, w7,  w7,  w16);
   TEST_3RF("fcor.d", datad,  32,  80, w27, w4,  w6);
   TEST_3RF("fcor.d", datad,  32,  96, w5,  w19, w6);
   TEST_3RF("fcor.d", datad,  32, 112, w21, w16, w24);
   TEST_3RF("fcor.d", datad,  32, 128, w31, w24, w24);
   TEST_3RF("fcor.d", datad,  32, 144, w6,  w8,  w13);
   TEST_3RF("fcor.d", datad,  48,   0, w15, w21, w8);
   TEST_3RF("fcor.d", datad,  48,  16, w21, w8,  w2);
   TEST_3RF("fcor.d", datad,  48,  32, w9,  w6,  w2);
   TEST_3RF("fcor.d", datad,  48,  48, w10, w17, w19);
   TEST_3RF("fcor.d", datad,  48,  64, w31, w26, w26);
   TEST_3RF("fcor.d", datad,  48,  80, w17, w6,  w10);
   TEST_3RF("fcor.d", datad,  48,  96, w13, w10, w16);
   TEST_3RF("fcor.d", datad,  48, 112, w18, w30, w22);
   TEST_3RF("fcor.d", datad,  48, 128, w8,  w14, w15);
   TEST_3RF("fcor.d", datad,  48, 144, w7,  w7,  w6);
   TEST_3RF("fcor.d", datad,  64,   0, w21, w15, w19);
   TEST_3RF("fcor.d", datad,  64,  16, w4,  w27, w25);
   TEST_3RF("fcor.d", datad,  64,  32, w12, w29, w2);
   TEST_3RF("fcor.d", datad,  64,  48, w18, w31, w12);
   TEST_3RF("fcor.d", datad,  64,  64, w4,  w19, w11);
   TEST_3RF("fcor.d", datad,  64,  80, w30, w4,  w30);
   TEST_3RF("fcor.d", datad,  64,  96, w17, w8,  w28);
   TEST_3RF("fcor.d", datad,  64, 112, w25, w4,  w26);
   TEST_3RF("fcor.d", datad,  64, 128, w15, w12, w8);
   TEST_3RF("fcor.d", datad,  64, 144, w30, w19, w30);
   TEST_3RF("fcor.d", datad,  80,   0, w14, w19, w2);
   TEST_3RF("fcor.d", datad,  80,  16, w1,  w23, w7);
   TEST_3RF("fcor.d", datad,  80,  32, w28, w16, w19);
   TEST_3RF("fcor.d", datad,  80,  48, w25, w18, w6);
   TEST_3RF("fcor.d", datad,  80,  64, w24, w31, w10);
   TEST_3RF("fcor.d", datad,  80,  80, w11, w10, w8);
   TEST_3RF("fcor.d", datad,  80,  96, w16, w28, w1);
   TEST_3RF("fcor.d", datad,  80, 112, w24, w9,  w5);
   TEST_3RF("fcor.d", datad,  80, 128, w18, w25, w17);
   TEST_3RF("fcor.d", datad,  80, 144, w26, w23, w4);
   TEST_3RF("fcor.d", datad,  96,   0, w8,  w11, w7);
   TEST_3RF("fcor.d", datad,  96,  16, w9,  w2,  w14);
   TEST_3RF("fcor.d", datad,  96,  32, w5,  w19, w1);
   TEST_3RF("fcor.d", datad,  96,  48, w30, w5,  w30);
   TEST_3RF("fcor.d", datad,  96,  64, w7,  w7,  w22);
   TEST_3RF("fcor.d", datad,  96,  80, w4,  w17, w2);
   TEST_3RF("fcor.d", datad,  96,  96, w15, w25, w18);
   TEST_3RF("fcor.d", datad,  96, 112, w11, w10, w19);
   TEST_3RF("fcor.d", datad,  96, 128, w3,  w19, w25);
   TEST_3RF("fcor.d", datad,  96, 144, w21, w12, w10);
   TEST_3RF("fcor.d", datad, 112,   0, w15, w4,  w23);
   TEST_3RF("fcor.d", datad, 112,  16, w15, w22, w0);
   TEST_3RF("fcor.d", datad, 112,  32, w17, w4,  w5);
   TEST_3RF("fcor.d", datad, 112,  48, w4,  w5,  w3);
   TEST_3RF("fcor.d", datad, 112,  64, w10, w13, w25);
   TEST_3RF("fcor.d", datad, 112,  80, w14, w30, w27);
   TEST_3RF("fcor.d", datad, 112,  96, w29, w24, w13);
   TEST_3RF("fcor.d", datad, 112, 112, w8,  w2,  w1);
   TEST_3RF("fcor.d", datad, 112, 128, w11, w21, w26);
   TEST_3RF("fcor.d", datad, 112, 144, w0,  w0,  w0);
   TEST_3RF("fcor.d", datad, 128,   0, w2,  w4,  w15);
   TEST_3RF("fcor.d", datad, 128,  16, w6,  w19, w21);
   TEST_3RF("fcor.d", datad, 128,  32, w9,  w6,  w13);
   TEST_3RF("fcor.d", datad, 128,  48, w11, w19, w14);
   TEST_3RF("fcor.d", datad, 128,  64, w21, w0,  w8);
   TEST_3RF("fcor.d", datad, 128,  80, w3,  w30, w1);
   TEST_3RF("fcor.d", datad, 128,  96, w22, w17, w9);
   TEST_3RF("fcor.d", datad, 128, 112, w24, w18, w21);
   TEST_3RF("fcor.d", datad, 128, 128, w14, w12, w21);
   TEST_3RF("fcor.d", datad, 128, 144, w16, w5,  w22);
   TEST_3RF("fcor.d", datad, 144,   0, w4,  w11, w13);
   TEST_3RF("fcor.d", datad, 144,  16, w18, w17, w27);
   TEST_3RF("fcor.d", datad, 144,  32, w29, w28, w14);
   TEST_3RF("fcor.d", datad, 144,  48, w12, w17, w14);
   TEST_3RF("fcor.d", datad, 144,  64, w20, w21, w12);
   TEST_3RF("fcor.d", datad, 144,  80, w23, w22, w3);
   TEST_3RF("fcor.d", datad, 144,  96, w8,  w31, w27);
   TEST_3RF("fcor.d", datad, 144, 112, w26, w20, w9);
   TEST_3RF("fcor.d", datad, 144, 128, w6,  w10, w25);
   TEST_3RF("fcor.d", datad, 144, 144, w23, w15, w27);
   TEST_3RF("fcueq.w", dataf,   0,   0, w10, w8,  w17);
   TEST_3RF("fcueq.w", dataf,   0,   8, w22, w26, w31);
   TEST_3RF("fcueq.w", dataf,   0,  16, w10, w15, w12);
   TEST_3RF("fcueq.w", dataf,   0,  24, w1,  w5,  w15);
   TEST_3RF("fcueq.w", dataf,   0,  32, w10, w4,  w25);
   TEST_3RF("fcueq.w", dataf,   0,  40, w20, w11, w3);
   TEST_3RF("fcueq.w", dataf,   0,  48, w13, w2,  w18);
   TEST_3RF("fcueq.w", dataf,   0,  56, w29, w12, w23);
   TEST_3RF("fcueq.w", dataf,   0,  64, w5,  w25, w3);
   TEST_3RF("fcueq.w", dataf,   0,  72, w9,  w3,  w12);
   TEST_3RF("fcueq.w", dataf,   8,   0, w26, w26, w26);
   TEST_3RF("fcueq.w", dataf,   8,   8, w25, w6,  w26);
   TEST_3RF("fcueq.w", dataf,   8,  16, w3,  w21, w21);
   TEST_3RF("fcueq.w", dataf,   8,  24, w6,  w4,  w26);
   TEST_3RF("fcueq.w", dataf,   8,  32, w21, w14, w30);
   TEST_3RF("fcueq.w", dataf,   8,  40, w31, w19, w23);
   TEST_3RF("fcueq.w", dataf,   8,  48, w19, w30, w26);
   TEST_3RF("fcueq.w", dataf,   8,  56, w1,  w0,  w12);
   TEST_3RF("fcueq.w", dataf,   8,  64, w30, w29, w25);
   TEST_3RF("fcueq.w", dataf,   8,  72, w21, w2,  w18);
   TEST_3RF("fcueq.w", dataf,  16,   0, w25, w11, w21);
   TEST_3RF("fcueq.w", dataf,  16,   8, w5,  w6,  w14);
   TEST_3RF("fcueq.w", dataf,  16,  16, w11, w0,  w17);
   TEST_3RF("fcueq.w", dataf,  16,  24, w0,  w6,  w21);
   TEST_3RF("fcueq.w", dataf,  16,  32, w26, w26, w26);
   TEST_3RF("fcueq.w", dataf,  16,  40, w27, w4,  w24);
   TEST_3RF("fcueq.w", dataf,  16,  48, w26, w26, w26);
   TEST_3RF("fcueq.w", dataf,  16,  56, w23, w16, w14);
   TEST_3RF("fcueq.w", dataf,  16,  64, w21, w10, w15);
   TEST_3RF("fcueq.w", dataf,  16,  72, w21, w23, w13);
   TEST_3RF("fcueq.w", dataf,  24,   0, w18, w16, w2);
   TEST_3RF("fcueq.w", dataf,  24,   8, w20, w2,  w27);
   TEST_3RF("fcueq.w", dataf,  24,  16, w0,  w23, w6);
   TEST_3RF("fcueq.w", dataf,  24,  24, w5,  w11, w6);
   TEST_3RF("fcueq.w", dataf,  24,  32, w22, w11, w12);
   TEST_3RF("fcueq.w", dataf,  24,  40, w11, w5,  w7);
   TEST_3RF("fcueq.w", dataf,  24,  48, w15, w30, w1);
   TEST_3RF("fcueq.w", dataf,  24,  56, w6,  w14, w15);
   TEST_3RF("fcueq.w", dataf,  24,  64, w27, w24, w30);
   TEST_3RF("fcueq.w", dataf,  24,  72, w16, w15, w11);
   TEST_3RF("fcueq.w", dataf,  32,   0, w2,  w31, w14);
   TEST_3RF("fcueq.w", dataf,  32,   8, w23, w1,  w9);
   TEST_3RF("fcueq.w", dataf,  32,  16, w23, w24, w10);
   TEST_3RF("fcueq.w", dataf,  32,  24, w29, w21, w3);
   TEST_3RF("fcueq.w", dataf,  32,  32, w19, w1,  w15);
   TEST_3RF("fcueq.w", dataf,  32,  40, w31, w6,  w22);
   TEST_3RF("fcueq.w", dataf,  32,  48, w14, w4,  w23);
   TEST_3RF("fcueq.w", dataf,  32,  56, w21, w18, w7);
   TEST_3RF("fcueq.w", dataf,  32,  64, w16, w11, w5);
   TEST_3RF("fcueq.w", dataf,  32,  72, w1,  w26, w17);
   TEST_3RF("fcueq.w", dataf,  40,   0, w3,  w26, w26);
   TEST_3RF("fcueq.w", dataf,  40,   8, w31, w26, w27);
   TEST_3RF("fcueq.w", dataf,  40,  16, w8,  w8,  w17);
   TEST_3RF("fcueq.w", dataf,  40,  24, w20, w18, w14);
   TEST_3RF("fcueq.w", dataf,  40,  32, w17, w8,  w5);
   TEST_3RF("fcueq.w", dataf,  40,  40, w9,  w0,  w4);
   TEST_3RF("fcueq.w", dataf,  40,  48, w15, w22, w18);
   TEST_3RF("fcueq.w", dataf,  40,  56, w20, w14, w7);
   TEST_3RF("fcueq.w", dataf,  40,  64, w6,  w21, w24);
   TEST_3RF("fcueq.w", dataf,  40,  72, w17, w26, w25);
   TEST_3RF("fcueq.w", dataf,  48,   0, w12, w11, w12);
   TEST_3RF("fcueq.w", dataf,  48,   8, w28, w6,  w10);
   TEST_3RF("fcueq.w", dataf,  48,  16, w23, w1,  w19);
   TEST_3RF("fcueq.w", dataf,  48,  24, w8,  w8,  w21);
   TEST_3RF("fcueq.w", dataf,  48,  32, w5,  w23, w7);
   TEST_3RF("fcueq.w", dataf,  48,  40, w13, w8,  w12);
   TEST_3RF("fcueq.w", dataf,  48,  48, w22, w9,  w16);
   TEST_3RF("fcueq.w", dataf,  48,  56, w6,  w31, w2);
   TEST_3RF("fcueq.w", dataf,  48,  64, w26, w26, w26);
   TEST_3RF("fcueq.w", dataf,  48,  72, w13, w10, w0);
   TEST_3RF("fcueq.w", dataf,  56,   0, w2,  w18, w29);
   TEST_3RF("fcueq.w", dataf,  56,   8, w27, w30, w8);
   TEST_3RF("fcueq.w", dataf,  56,  16, w23, w4,  w19);
   TEST_3RF("fcueq.w", dataf,  56,  24, w14, w5,  w6);
   TEST_3RF("fcueq.w", dataf,  56,  32, w23, w27, w11);
   TEST_3RF("fcueq.w", dataf,  56,  40, w14, w2,  w25);
   TEST_3RF("fcueq.w", dataf,  56,  48, w22, w14, w15);
   TEST_3RF("fcueq.w", dataf,  56,  56, w31, w30, w21);
   TEST_3RF("fcueq.w", dataf,  56,  64, w31, w0,  w15);
   TEST_3RF("fcueq.w", dataf,  56,  72, w12, w10, w12);
   TEST_3RF("fcueq.w", dataf,  64,   0, w16, w15, w12);
   TEST_3RF("fcueq.w", dataf,  64,   8, w2,  w12, w7);
   TEST_3RF("fcueq.w", dataf,  64,  16, w0,  w20, w31);
   TEST_3RF("fcueq.w", dataf,  64,  24, w4,  w7,  w13);
   TEST_3RF("fcueq.w", dataf,  64,  32, w9,  w13, w4);
   TEST_3RF("fcueq.w", dataf,  64,  40, w4,  w25, w18);
   TEST_3RF("fcueq.w", dataf,  64,  48, w6,  w18, w9);
   TEST_3RF("fcueq.w", dataf,  64,  56, w20, w1,  w8);
   TEST_3RF("fcueq.w", dataf,  64,  64, w18, w23, w7);
   TEST_3RF("fcueq.w", dataf,  64,  72, w19, w6,  w20);
   TEST_3RF("fcueq.w", dataf,  72,   0, w29, w22, w3);
   TEST_3RF("fcueq.w", dataf,  72,   8, w10, w24, w15);
   TEST_3RF("fcueq.w", dataf,  72,  16, w17, w24, w3);
   TEST_3RF("fcueq.w", dataf,  72,  24, w16, w28, w11);
   TEST_3RF("fcueq.w", dataf,  72,  32, w30, w6,  w24);
   TEST_3RF("fcueq.w", dataf,  72,  40, w2,  w10, w17);
   TEST_3RF("fcueq.w", dataf,  72,  48, w21, w17, w3);
   TEST_3RF("fcueq.w", dataf,  72,  56, w30, w5,  w6);
   TEST_3RF("fcueq.w", dataf,  72,  64, w24, w28, w14);
   TEST_3RF("fcueq.w", dataf,  72,  72, w11, w2,  w8);
   TEST_3RF("fcueq.d", datad,   0,   0, w25, w5,  w18);
   TEST_3RF("fcueq.d", datad,   0,  16, w17, w20, w4);
   TEST_3RF("fcueq.d", datad,   0,  32, w10, w23, w20);
   TEST_3RF("fcueq.d", datad,   0,  48, w6,  w2,  w18);
   TEST_3RF("fcueq.d", datad,   0,  64, w12, w27, w12);
   TEST_3RF("fcueq.d", datad,   0,  80, w21, w23, w12);
   TEST_3RF("fcueq.d", datad,   0,  96, w10, w8,  w16);
   TEST_3RF("fcueq.d", datad,   0, 112, w8,  w8,  w13);
   TEST_3RF("fcueq.d", datad,   0, 128, w21, w14, w5);
   TEST_3RF("fcueq.d", datad,   0, 144, w17, w28, w16);
   TEST_3RF("fcueq.d", datad,  16,   0, w19, w30, w25);
   TEST_3RF("fcueq.d", datad,  16,  16, w12, w3,  w12);
   TEST_3RF("fcueq.d", datad,  16,  32, w11, w30, w23);
   TEST_3RF("fcueq.d", datad,  16,  48, w15, w8,  w4);
   TEST_3RF("fcueq.d", datad,  16,  64, w14, w17, w22);
   TEST_3RF("fcueq.d", datad,  16,  80, w27, w12, w11);
   TEST_3RF("fcueq.d", datad,  16,  96, w18, w25, w21);
   TEST_3RF("fcueq.d", datad,  16, 112, w26, w26, w26);
   TEST_3RF("fcueq.d", datad,  16, 128, w9,  w29, w7);
   TEST_3RF("fcueq.d", datad,  16, 144, w30, w12, w13);
   TEST_3RF("fcueq.d", datad,  32,   0, w15, w8,  w29);
   TEST_3RF("fcueq.d", datad,  32,  16, w2,  w7,  w22);
   TEST_3RF("fcueq.d", datad,  32,  32, w15, w10, w2);
   TEST_3RF("fcueq.d", datad,  32,  48, w13, w2,  w17);
   TEST_3RF("fcueq.d", datad,  32,  64, w21, w17, w3);
   TEST_3RF("fcueq.d", datad,  32,  80, w2,  w12, w30);
   TEST_3RF("fcueq.d", datad,  32,  96, w15, w23, w16);
   TEST_3RF("fcueq.d", datad,  32, 112, w8,  w8,  w13);
   TEST_3RF("fcueq.d", datad,  32, 128, w10, w17, w18);
   TEST_3RF("fcueq.d", datad,  32, 144, w15, w22, w31);
   TEST_3RF("fcueq.d", datad,  48,   0, w30, w31, w28);
   TEST_3RF("fcueq.d", datad,  48,  16, w0,  w6,  w19);
   TEST_3RF("fcueq.d", datad,  48,  32, w15, w16, w21);
   TEST_3RF("fcueq.d", datad,  48,  48, w28, w18, w6);
   TEST_3RF("fcueq.d", datad,  48,  64, w17, w3,  w28);
   TEST_3RF("fcueq.d", datad,  48,  80, w21, w6,  w8);
   TEST_3RF("fcueq.d", datad,  48,  96, w19, w21, w31);
   TEST_3RF("fcueq.d", datad,  48, 112, w4,  w29, w12);
   TEST_3RF("fcueq.d", datad,  48, 128, w14, w23, w0);
   TEST_3RF("fcueq.d", datad,  48, 144, w29, w13, w31);
   TEST_3RF("fcueq.d", datad,  64,   0, w27, w12, w28);
   TEST_3RF("fcueq.d", datad,  64,  16, w27, w18, w15);
   TEST_3RF("fcueq.d", datad,  64,  32, w11, w3,  w4);
   TEST_3RF("fcueq.d", datad,  64,  48, w7,  w21, w10);
   TEST_3RF("fcueq.d", datad,  64,  64, w25, w6,  w14);
   TEST_3RF("fcueq.d", datad,  64,  80, w31, w14, w1);
   TEST_3RF("fcueq.d", datad,  64,  96, w20, w14, w5);
   TEST_3RF("fcueq.d", datad,  64, 112, w17, w26, w20);
   TEST_3RF("fcueq.d", datad,  64, 128, w31, w17, w20);
   TEST_3RF("fcueq.d", datad,  64, 144, w28, w31, w20);
   TEST_3RF("fcueq.d", datad,  80,   0, w23, w11, w16);
   TEST_3RF("fcueq.d", datad,  80,  16, w18, w30, w31);
   TEST_3RF("fcueq.d", datad,  80,  32, w29, w1,  w3);
   TEST_3RF("fcueq.d", datad,  80,  48, w5,  w22, w13);
   TEST_3RF("fcueq.d", datad,  80,  64, w30, w15, w20);
   TEST_3RF("fcueq.d", datad,  80,  80, w12, w14, w12);
   TEST_3RF("fcueq.d", datad,  80,  96, w2,  w13, w16);
   TEST_3RF("fcueq.d", datad,  80, 112, w19, w11, w7);
   TEST_3RF("fcueq.d", datad,  80, 128, w18, w28, w27);
   TEST_3RF("fcueq.d", datad,  80, 144, w14, w27, w15);
   TEST_3RF("fcueq.d", datad,  96,   0, w5,  w7,  w31);
   TEST_3RF("fcueq.d", datad,  96,  16, w24, w5,  w30);
   TEST_3RF("fcueq.d", datad,  96,  32, w21, w6,  w1);
   TEST_3RF("fcueq.d", datad,  96,  48, w26, w26, w26);
   TEST_3RF("fcueq.d", datad,  96,  64, w28, w15, w24);
   TEST_3RF("fcueq.d", datad,  96,  80, w12, w3,  w12);
   TEST_3RF("fcueq.d", datad,  96,  96, w4,  w26, w5);
   TEST_3RF("fcueq.d", datad,  96, 112, w18, w29, w22);
   TEST_3RF("fcueq.d", datad,  96, 128, w5,  w16, w1);
   TEST_3RF("fcueq.d", datad,  96, 144, w12, w3,  w12);
   TEST_3RF("fcueq.d", datad, 112,   0, w29, w7,  w17);
   TEST_3RF("fcueq.d", datad, 112,  16, w25, w23, w0);
   TEST_3RF("fcueq.d", datad, 112,  32, w22, w15, w5);
   TEST_3RF("fcueq.d", datad, 112,  48, w21, w4,  w11);
   TEST_3RF("fcueq.d", datad, 112,  64, w22, w31, w7);
   TEST_3RF("fcueq.d", datad, 112,  80, w5,  w23, w19);
   TEST_3RF("fcueq.d", datad, 112,  96, w8,  w8,  w28);
   TEST_3RF("fcueq.d", datad, 112, 112, w14, w11, w4);
   TEST_3RF("fcueq.d", datad, 112, 128, w19, w27, w5);
   TEST_3RF("fcueq.d", datad, 112, 144, w31, w30, w2);
   TEST_3RF("fcueq.d", datad, 128,   0, w6,  w16, w27);
   TEST_3RF("fcueq.d", datad, 128,  16, w29, w7,  w27);
   TEST_3RF("fcueq.d", datad, 128,  32, w20, w22, w0);
   TEST_3RF("fcueq.d", datad, 128,  48, w9,  w26, w11);
   TEST_3RF("fcueq.d", datad, 128,  64, w31, w25, w19);
   TEST_3RF("fcueq.d", datad, 128,  80, w5,  w17, w6);
   TEST_3RF("fcueq.d", datad, 128,  96, w13, w20, w27);
   TEST_3RF("fcueq.d", datad, 128, 112, w27, w31, w14);
   TEST_3RF("fcueq.d", datad, 128, 128, w27, w4,  w13);
   TEST_3RF("fcueq.d", datad, 128, 144, w25, w7,  w19);
   TEST_3RF("fcueq.d", datad, 144,   0, w9,  w2,  w17);
   TEST_3RF("fcueq.d", datad, 144,  16, w16, w30, w5);
   TEST_3RF("fcueq.d", datad, 144,  32, w6,  w30, w14);
   TEST_3RF("fcueq.d", datad, 144,  48, w1,  w10, w13);
   TEST_3RF("fcueq.d", datad, 144,  64, w26, w26, w26);
   TEST_3RF("fcueq.d", datad, 144,  80, w29, w18, w11);
   TEST_3RF("fcueq.d", datad, 144,  96, w3,  w0,  w0);
   TEST_3RF("fcueq.d", datad, 144, 112, w24, w27, w19);
   TEST_3RF("fcueq.d", datad, 144, 128, w23, w27, w1);
   TEST_3RF("fcueq.d", datad, 144, 144, w18, w31, w14);
   TEST_3RF("fcule.w", dataf,   0,   0, w9,  w19, w6);
   TEST_3RF("fcule.w", dataf,   0,   8, w7,  w24, w12);
   TEST_3RF("fcule.w", dataf,   0,  16, w5,  w6,  w13);
   TEST_3RF("fcule.w", dataf,   0,  24, w15, w19, w8);
   TEST_3RF("fcule.w", dataf,   0,  32, w12, w12, w12);
   TEST_3RF("fcule.w", dataf,   0,  40, w6,  w6,  w19);
   TEST_3RF("fcule.w", dataf,   0,  48, w16, w6,  w12);
   TEST_3RF("fcule.w", dataf,   0,  56, w8,  w1,  w31);
   TEST_3RF("fcule.w", dataf,   0,  64, w31, w28, w1);
   TEST_3RF("fcule.w", dataf,   0,  72, w18, w28, w15);
   TEST_3RF("fcule.w", dataf,   8,   0, w30, w2,  w17);
   TEST_3RF("fcule.w", dataf,   8,   8, w19, w11, w4);
   TEST_3RF("fcule.w", dataf,   8,  16, w25, w18, w28);
   TEST_3RF("fcule.w", dataf,   8,  24, w6,  w6,  w24);
   TEST_3RF("fcule.w", dataf,   8,  32, w2,  w19, w2);
   TEST_3RF("fcule.w", dataf,   8,  40, w7,  w22, w27);
   TEST_3RF("fcule.w", dataf,   8,  48, w20, w28, w15);
   TEST_3RF("fcule.w", dataf,   8,  56, w4,  w2,  w27);
   TEST_3RF("fcule.w", dataf,   8,  64, w12, w12, w12);
   TEST_3RF("fcule.w", dataf,   8,  72, w3,  w26, w11);
   TEST_3RF("fcule.w", dataf,  16,   0, w0,  w27, w29);
   TEST_3RF("fcule.w", dataf,  16,   8, w28, w11, w27);
   TEST_3RF("fcule.w", dataf,  16,  16, w30, w28, w15);
   TEST_3RF("fcule.w", dataf,  16,  24, w10, w1,  w8);
   TEST_3RF("fcule.w", dataf,  16,  32, w28, w29, w14);
   TEST_3RF("fcule.w", dataf,  16,  40, w20, w0,  w2);
   TEST_3RF("fcule.w", dataf,  16,  48, w28, w22, w29);
   TEST_3RF("fcule.w", dataf,  16,  56, w16, w18, w12);
   TEST_3RF("fcule.w", dataf,  16,  64, w20, w7,  w0);
   TEST_3RF("fcule.w", dataf,  16,  72, w23, w2,  w11);
   TEST_3RF("fcule.w", dataf,  24,   0, w23, w29, w9);
   TEST_3RF("fcule.w", dataf,  24,   8, w19, w8,  w4);
   TEST_3RF("fcule.w", dataf,  24,  16, w18, w5,  w19);
   TEST_3RF("fcule.w", dataf,  24,  24, w28, w6,  w24);
   TEST_3RF("fcule.w", dataf,  24,  32, w3,  w10, w13);
   TEST_3RF("fcule.w", dataf,  24,  40, w3,  w12, w9);
   TEST_3RF("fcule.w", dataf,  24,  48, w25, w10, w11);
   TEST_3RF("fcule.w", dataf,  24,  56, w22, w13, w31);
   TEST_3RF("fcule.w", dataf,  24,  64, w30, w13, w23);
   TEST_3RF("fcule.w", dataf,  24,  72, w0,  w24, w14);
   TEST_3RF("fcule.w", dataf,  32,   0, w29, w1,  w2);
   TEST_3RF("fcule.w", dataf,  32,   8, w6,  w6,  w20);
   TEST_3RF("fcule.w", dataf,  32,  16, w11, w25, w16);
   TEST_3RF("fcule.w", dataf,  32,  24, w17, w21, w8);
   TEST_3RF("fcule.w", dataf,  32,  32, w20, w0,  w21);
   TEST_3RF("fcule.w", dataf,  32,  40, w24, w12, w30);
   TEST_3RF("fcule.w", dataf,  32,  48, w17, w22, w23);
   TEST_3RF("fcule.w", dataf,  32,  56, w29, w13, w4);
   TEST_3RF("fcule.w", dataf,  32,  64, w28, w11, w17);
   TEST_3RF("fcule.w", dataf,  32,  72, w19, w11, w10);
   TEST_3RF("fcule.w", dataf,  40,   0, w2,  w8,  w2);
   TEST_3RF("fcule.w", dataf,  40,   8, w11, w4,  w14);
   TEST_3RF("fcule.w", dataf,  40,  16, w17, w24, w25);
   TEST_3RF("fcule.w", dataf,  40,  24, w11, w8,  w10);
   TEST_3RF("fcule.w", dataf,  40,  32, w0,  w16, w31);
   TEST_3RF("fcule.w", dataf,  40,  40, w0,  w6,  w23);
   TEST_3RF("fcule.w", dataf,  40,  48, w13, w4,  w8);
   TEST_3RF("fcule.w", dataf,  40,  56, w3,  w28, w5);
   TEST_3RF("fcule.w", dataf,  40,  64, w16, w0,  w2);
   TEST_3RF("fcule.w", dataf,  40,  72, w27, w18, w21);
   TEST_3RF("fcule.w", dataf,  48,   0, w6,  w6,  w28);
   TEST_3RF("fcule.w", dataf,  48,   8, w23, w15, w7);
   TEST_3RF("fcule.w", dataf,  48,  16, w27, w29, w25);
   TEST_3RF("fcule.w", dataf,  48,  24, w19, w23, w4);
   TEST_3RF("fcule.w", dataf,  48,  32, w27, w1,  w4);
   TEST_3RF("fcule.w", dataf,  48,  40, w12, w12, w12);
   TEST_3RF("fcule.w", dataf,  48,  48, w0,  w5,  w18);
   TEST_3RF("fcule.w", dataf,  48,  56, w23, w18, w22);
   TEST_3RF("fcule.w", dataf,  48,  64, w0,  w21, w18);
   TEST_3RF("fcule.w", dataf,  48,  72, w5,  w6,  w19);
   TEST_3RF("fcule.w", dataf,  56,   0, w7,  w1,  w5);
   TEST_3RF("fcule.w", dataf,  56,   8, w29, w8,  w1);
   TEST_3RF("fcule.w", dataf,  56,  16, w20, w23, w8);
   TEST_3RF("fcule.w", dataf,  56,  24, w16, w20, w1);
   TEST_3RF("fcule.w", dataf,  56,  32, w3,  w11, w5);
   TEST_3RF("fcule.w", dataf,  56,  40, w31, w13, w10);
   TEST_3RF("fcule.w", dataf,  56,  48, w11, w13, w15);
   TEST_3RF("fcule.w", dataf,  56,  56, w29, w5,  w1);
   TEST_3RF("fcule.w", dataf,  56,  64, w19, w5,  w22);
   TEST_3RF("fcule.w", dataf,  56,  72, w6,  w6,  w10);
   TEST_3RF("fcule.w", dataf,  64,   0, w28, w25, w18);
   TEST_3RF("fcule.w", dataf,  64,   8, w30, w15, w6);
   TEST_3RF("fcule.w", dataf,  64,  16, w31, w3,  w29);
   TEST_3RF("fcule.w", dataf,  64,  24, w7,  w19, w17);
   TEST_3RF("fcule.w", dataf,  64,  32, w9,  w23, w29);
   TEST_3RF("fcule.w", dataf,  64,  40, w14, w22, w10);
   TEST_3RF("fcule.w", dataf,  64,  48, w24, w1,  w23);
   TEST_3RF("fcule.w", dataf,  64,  56, w7,  w30, w28);
   TEST_3RF("fcule.w", dataf,  64,  64, w8,  w17, w1);
   TEST_3RF("fcule.w", dataf,  64,  72, w31, w23, w12);
   TEST_3RF("fcule.w", dataf,  72,   0, w27, w16, w30);
   TEST_3RF("fcule.w", dataf,  72,   8, w25, w14, w13);
   TEST_3RF("fcule.w", dataf,  72,  16, w31, w13, w16);
   TEST_3RF("fcule.w", dataf,  72,  24, w28, w21, w4);
   TEST_3RF("fcule.w", dataf,  72,  32, w14, w30, w27);
   TEST_3RF("fcule.w", dataf,  72,  40, w11, w12, w17);
   TEST_3RF("fcule.w", dataf,  72,  48, w21, w5,  w5);
   TEST_3RF("fcule.w", dataf,  72,  56, w18, w12, w16);
   TEST_3RF("fcule.w", dataf,  72,  64, w9,  w21, w1);
   TEST_3RF("fcule.w", dataf,  72,  72, w10, w20, w25);
   TEST_3RF("fcule.d", datad,   0,   0, w22, w15, w9);
   TEST_3RF("fcule.d", datad,   0,  16, w20, w9,  w24);
   TEST_3RF("fcule.d", datad,   0,  32, w1,  w8,  w5);
   TEST_3RF("fcule.d", datad,   0,  48, w18, w5,  w26);
   TEST_3RF("fcule.d", datad,   0,  64, w22, w19, w24);
   TEST_3RF("fcule.d", datad,   0,  80, w17, w30, w5);
   TEST_3RF("fcule.d", datad,   0,  96, w2,  w19, w2);
   TEST_3RF("fcule.d", datad,   0, 112, w10, w20, w31);
   TEST_3RF("fcule.d", datad,   0, 128, w22, w4,  w8);
   TEST_3RF("fcule.d", datad,   0, 144, w11, w5,  w19);
   TEST_3RF("fcule.d", datad,  16,   0, w31, w30, w9);
   TEST_3RF("fcule.d", datad,  16,  16, w15, w8,  w30);
   TEST_3RF("fcule.d", datad,  16,  32, w24, w0,  w31);
   TEST_3RF("fcule.d", datad,  16,  48, w0,  w5,  w17);
   TEST_3RF("fcule.d", datad,  16,  64, w5,  w0,  w7);
   TEST_3RF("fcule.d", datad,  16,  80, w24, w22, w29);
   TEST_3RF("fcule.d", datad,  16,  96, w26, w9,  w7);
   TEST_3RF("fcule.d", datad,  16, 112, w14, w9,  w30);
   TEST_3RF("fcule.d", datad,  16, 128, w18, w17, w9);
   TEST_3RF("fcule.d", datad,  16, 144, w24, w4,  w9);
   TEST_3RF("fcule.d", datad,  32,   0, w22, w14, w24);
   TEST_3RF("fcule.d", datad,  32,  16, w30, w12, w16);
   TEST_3RF("fcule.d", datad,  32,  32, w30, w11, w16);
   TEST_3RF("fcule.d", datad,  32,  48, w4,  w29, w22);
   TEST_3RF("fcule.d", datad,  32,  64, w4,  w14, w28);
   TEST_3RF("fcule.d", datad,  32,  80, w29, w5,  w26);
   TEST_3RF("fcule.d", datad,  32,  96, w23, w14, w1);
   TEST_3RF("fcule.d", datad,  32, 112, w6,  w6,  w23);
   TEST_3RF("fcule.d", datad,  32, 128, w31, w24, w9);
   TEST_3RF("fcule.d", datad,  32, 144, w9,  w16, w13);
   TEST_3RF("fcule.d", datad,  48,   0, w18, w7,  w27);
   TEST_3RF("fcule.d", datad,  48,  16, w10, w5,  w7);
   TEST_3RF("fcule.d", datad,  48,  32, w26, w4,  w19);
   TEST_3RF("fcule.d", datad,  48,  48, w10, w8,  w16);
   TEST_3RF("fcule.d", datad,  48,  64, w0,  w12, w20);
   TEST_3RF("fcule.d", datad,  48,  80, w15, w8,  w17);
   TEST_3RF("fcule.d", datad,  48,  96, w20, w2,  w9);
   TEST_3RF("fcule.d", datad,  48, 112, w2,  w4,  w2);
   TEST_3RF("fcule.d", datad,  48, 128, w15, w26, w3);
   TEST_3RF("fcule.d", datad,  48, 144, w7,  w3,  w12);
   TEST_3RF("fcule.d", datad,  64,   0, w24, w16, w30);
   TEST_3RF("fcule.d", datad,  64,  16, w31, w12, w8);
   TEST_3RF("fcule.d", datad,  64,  32, w4,  w19, w2);
   TEST_3RF("fcule.d", datad,  64,  48, w8,  w6,  w13);
   TEST_3RF("fcule.d", datad,  64,  64, w16, w22, w13);
   TEST_3RF("fcule.d", datad,  64,  80, w28, w11, w5);
   TEST_3RF("fcule.d", datad,  64,  96, w28, w16, w7);
   TEST_3RF("fcule.d", datad,  64, 112, w5,  w19, w11);
   TEST_3RF("fcule.d", datad,  64, 128, w20, w13, w15);
   TEST_3RF("fcule.d", datad,  64, 144, w28, w16, w27);
   TEST_3RF("fcule.d", datad,  80,   0, w20, w0,  w26);
   TEST_3RF("fcule.d", datad,  80,  16, w19, w12, w2);
   TEST_3RF("fcule.d", datad,  80,  32, w23, w0,  w5);
   TEST_3RF("fcule.d", datad,  80,  48, w0,  w6,  w18);
   TEST_3RF("fcule.d", datad,  80,  64, w16, w29, w31);
   TEST_3RF("fcule.d", datad,  80,  80, w13, w8,  w28);
   TEST_3RF("fcule.d", datad,  80,  96, w18, w4,  w12);
   TEST_3RF("fcule.d", datad,  80, 112, w25, w10, w31);
   TEST_3RF("fcule.d", datad,  80, 128, w5,  w30, w12);
   TEST_3RF("fcule.d", datad,  80, 144, w20, w26, w28);
   TEST_3RF("fcule.d", datad,  96,   0, w15, w14, w29);
   TEST_3RF("fcule.d", datad,  96,  16, w9,  w1,  w12);
   TEST_3RF("fcule.d", datad,  96,  32, w25, w9,  w17);
   TEST_3RF("fcule.d", datad,  96,  48, w25, w16, w3);
   TEST_3RF("fcule.d", datad,  96,  64, w9,  w13, w2);
   TEST_3RF("fcule.d", datad,  96,  80, w22, w21, w30);
   TEST_3RF("fcule.d", datad,  96,  96, w8,  w25, w11);
   TEST_3RF("fcule.d", datad,  96, 112, w2,  w3,  w2);
   TEST_3RF("fcule.d", datad,  96, 128, w10, w7,  w2);
   TEST_3RF("fcule.d", datad,  96, 144, w23, w27, w28);
   TEST_3RF("fcule.d", datad, 112,   0, w19, w10, w11);
   TEST_3RF("fcule.d", datad, 112,  16, w16, w20, w12);
   TEST_3RF("fcule.d", datad, 112,  32, w26, w0,  w5);
   TEST_3RF("fcule.d", datad, 112,  48, w3,  w17, w30);
   TEST_3RF("fcule.d", datad, 112,  64, w19, w20, w8);
   TEST_3RF("fcule.d", datad, 112,  80, w0,  w22, w30);
   TEST_3RF("fcule.d", datad, 112,  96, w21, w7,  w7);
   TEST_3RF("fcule.d", datad, 112, 112, w15, w0,  w9);
   TEST_3RF("fcule.d", datad, 112, 128, w18, w10, w16);
   TEST_3RF("fcule.d", datad, 112, 144, w20, w1,  w11);
   TEST_3RF("fcule.d", datad, 128,   0, w17, w21, w28);
   TEST_3RF("fcule.d", datad, 128,  16, w5,  w9,  w8);
   TEST_3RF("fcule.d", datad, 128,  32, w31, w9,  w14);
   TEST_3RF("fcule.d", datad, 128,  48, w3,  w26, w12);
   TEST_3RF("fcule.d", datad, 128,  64, w22, w14, w20);
   TEST_3RF("fcule.d", datad, 128,  80, w23, w5,  w19);
   TEST_3RF("fcule.d", datad, 128,  96, w12, w12, w12);
   TEST_3RF("fcule.d", datad, 128, 112, w26, w27, w3);
   TEST_3RF("fcule.d", datad, 128, 128, w14, w4,  w19);
   TEST_3RF("fcule.d", datad, 128, 144, w2,  w6,  w2);
   TEST_3RF("fcule.d", datad, 144,   0, w30, w19, w27);
   TEST_3RF("fcule.d", datad, 144,  16, w19, w15, w0);
   TEST_3RF("fcule.d", datad, 144,  32, w29, w24, w0);
   TEST_3RF("fcule.d", datad, 144,  48, w6,  w6,  w3);
   TEST_3RF("fcule.d", datad, 144,  64, w1,  w18, w25);
   TEST_3RF("fcule.d", datad, 144,  80, w15, w7,  w16);
   TEST_3RF("fcule.d", datad, 144,  96, w20, w26, w29);
   TEST_3RF("fcule.d", datad, 144, 112, w14, w20, w24);
   TEST_3RF("fcule.d", datad, 144, 128, w8,  w23, w6);
   TEST_3RF("fcule.d", datad, 144, 144, w13, w10, w9);
   TEST_3RF("fcult.w", dataf,   0,   0, w27, w12, w14);
   TEST_3RF("fcult.w", dataf,   0,   8, w24, w4,  w14);
   TEST_3RF("fcult.w", dataf,   0,  16, w31, w10, w17);
   TEST_3RF("fcult.w", dataf,   0,  24, w0,  w28, w11);
   TEST_3RF("fcult.w", dataf,   0,  32, w15, w3,  w27);
   TEST_3RF("fcult.w", dataf,   0,  40, w4,  w29, w24);
   TEST_3RF("fcult.w", dataf,   0,  48, w18, w17, w27);
   TEST_3RF("fcult.w", dataf,   0,  56, w8,  w8,  w23);
   TEST_3RF("fcult.w", dataf,   0,  64, w8,  w8,  w18);
   TEST_3RF("fcult.w", dataf,   0,  72, w0,  w27, w26);
   TEST_3RF("fcult.w", dataf,   8,   0, w29, w9,  w22);
   TEST_3RF("fcult.w", dataf,   8,   8, w9,  w23, w14);
   TEST_3RF("fcult.w", dataf,   8,  16, w13, w6,  w23);
   TEST_3RF("fcult.w", dataf,   8,  24, w23, w13, w19);
   TEST_3RF("fcult.w", dataf,   8,  32, w2,  w29, w23);
   TEST_3RF("fcult.w", dataf,   8,  40, w30, w1,  w20);
   TEST_3RF("fcult.w", dataf,   8,  48, w22, w19, w6);
   TEST_3RF("fcult.w", dataf,   8,  56, w7,  w14, w31);
   TEST_3RF("fcult.w", dataf,   8,  64, w22, w1,  w31);
   TEST_3RF("fcult.w", dataf,   8,  72, w17, w27, w28);
   TEST_3RF("fcult.w", dataf,  16,   0, w26, w17, w5);
   TEST_3RF("fcult.w", dataf,  16,   8, w18, w0,  w24);
   TEST_3RF("fcult.w", dataf,  16,  16, w13, w9,  w15);
   TEST_3RF("fcult.w", dataf,  16,  24, w27, w29, w18);
   TEST_3RF("fcult.w", dataf,  16,  32, w24, w20, w16);
   TEST_3RF("fcult.w", dataf,  16,  40, w25, w8,  w6);
   TEST_3RF("fcult.w", dataf,  16,  48, w12, w14, w27);
   TEST_3RF("fcult.w", dataf,  16,  56, w29, w13, w17);
   TEST_3RF("fcult.w", dataf,  16,  64, w30, w12, w3);
   TEST_3RF("fcult.w", dataf,  16,  72, w25, w9,  w29);
   TEST_3RF("fcult.w", dataf,  24,   0, w11, w14, w15);
   TEST_3RF("fcult.w", dataf,  24,   8, w11, w1,  w7);
   TEST_3RF("fcult.w", dataf,  24,  16, w24, w10, w23);
   TEST_3RF("fcult.w", dataf,  24,  24, w19, w19, w19);
   TEST_3RF("fcult.w", dataf,  24,  32, w7,  w9,  w11);
   TEST_3RF("fcult.w", dataf,  24,  40, w27, w25, w4);
   TEST_3RF("fcult.w", dataf,  24,  48, w4,  w31, w17);
   TEST_3RF("fcult.w", dataf,  24,  56, w18, w13, w12);
   TEST_3RF("fcult.w", dataf,  24,  64, w15, w26, w29);
   TEST_3RF("fcult.w", dataf,  24,  72, w13, w7,  w0);
   TEST_3RF("fcult.w", dataf,  32,   0, w7,  w16, w30);
   TEST_3RF("fcult.w", dataf,  32,   8, w18, w30, w13);
   TEST_3RF("fcult.w", dataf,  32,  16, w29, w31, w21);
   TEST_3RF("fcult.w", dataf,  32,  24, w21, w10, w12);
   TEST_3RF("fcult.w", dataf,  32,  32, w9,  w17, w21);
   TEST_3RF("fcult.w", dataf,  32,  40, w20, w13, w14);
   TEST_3RF("fcult.w", dataf,  32,  48, w25, w17, w13);
   TEST_3RF("fcult.w", dataf,  32,  56, w10, w3,  w27);
   TEST_3RF("fcult.w", dataf,  32,  64, w22, w19, w21);
   TEST_3RF("fcult.w", dataf,  32,  72, w19, w19, w19);
   TEST_3RF("fcult.w", dataf,  40,   0, w0,  w28, w20);
   TEST_3RF("fcult.w", dataf,  40,   8, w7,  w12, w18);
   TEST_3RF("fcult.w", dataf,  40,  16, w25, w11, w31);
   TEST_3RF("fcult.w", dataf,  40,  24, w22, w10, w20);
   TEST_3RF("fcult.w", dataf,  40,  32, w12, w20, w0);
   TEST_3RF("fcult.w", dataf,  40,  40, w21, w6,  w9);
   TEST_3RF("fcult.w", dataf,  40,  48, w19, w19, w19);
   TEST_3RF("fcult.w", dataf,  40,  56, w3,  w2,  w4);
   TEST_3RF("fcult.w", dataf,  40,  64, w17, w12, w7);
   TEST_3RF("fcult.w", dataf,  40,  72, w12, w2,  w26);
   TEST_3RF("fcult.w", dataf,  48,   0, w1,  w22, w27);
   TEST_3RF("fcult.w", dataf,  48,   8, w30, w10, w2);
   TEST_3RF("fcult.w", dataf,  48,  16, w10, w28, w21);
   TEST_3RF("fcult.w", dataf,  48,  24, w27, w18, w0);
   TEST_3RF("fcult.w", dataf,  48,  32, w16, w30, w20);
   TEST_3RF("fcult.w", dataf,  48,  40, w16, w19, w26);
   TEST_3RF("fcult.w", dataf,  48,  48, w6,  w29, w13);
   TEST_3RF("fcult.w", dataf,  48,  56, w9,  w31, w17);
   TEST_3RF("fcult.w", dataf,  48,  64, w26, w12, w25);
   TEST_3RF("fcult.w", dataf,  48,  72, w6,  w14, w19);
   TEST_3RF("fcult.w", dataf,  56,   0, w8,  w8,  w4);
   TEST_3RF("fcult.w", dataf,  56,   8, w14, w6,  w6);
   TEST_3RF("fcult.w", dataf,  56,  16, w14, w17, w17);
   TEST_3RF("fcult.w", dataf,  56,  24, w16, w10, w13);
   TEST_3RF("fcult.w", dataf,  56,  32, w6,  w31, w22);
   TEST_3RF("fcult.w", dataf,  56,  40, w30, w26, w6);
   TEST_3RF("fcult.w", dataf,  56,  48, w17, w21, w12);
   TEST_3RF("fcult.w", dataf,  56,  56, w14, w2,  w2);
   TEST_3RF("fcult.w", dataf,  56,  64, w22, w14, w20);
   TEST_3RF("fcult.w", dataf,  56,  72, w16, w26, w13);
   TEST_3RF("fcult.w", dataf,  64,   0, w23, w8,  w0);
   TEST_3RF("fcult.w", dataf,  64,   8, w31, w13, w15);
   TEST_3RF("fcult.w", dataf,  64,  16, w5,  w27, w0);
   TEST_3RF("fcult.w", dataf,  64,  24, w21, w6,  w13);
   TEST_3RF("fcult.w", dataf,  64,  32, w27, w12, w1);
   TEST_3RF("fcult.w", dataf,  64,  40, w2,  w10, w28);
   TEST_3RF("fcult.w", dataf,  64,  48, w8,  w8,  w28);
   TEST_3RF("fcult.w", dataf,  64,  56, w17, w21, w10);
   TEST_3RF("fcult.w", dataf,  64,  64, w19, w19, w19);
   TEST_3RF("fcult.w", dataf,  64,  72, w11, w24, w7);
   TEST_3RF("fcult.w", dataf,  72,   0, w27, w18, w20);
   TEST_3RF("fcult.w", dataf,  72,   8, w18, w27, w21);
   TEST_3RF("fcult.w", dataf,  72,  16, w17, w8,  w4);
   TEST_3RF("fcult.w", dataf,  72,  24, w22, w3,  w4);
   TEST_3RF("fcult.w", dataf,  72,  32, w12, w9,  w17);
   TEST_3RF("fcult.w", dataf,  72,  40, w7,  w21, w29);
   TEST_3RF("fcult.w", dataf,  72,  48, w9,  w23, w8);
   TEST_3RF("fcult.w", dataf,  72,  56, w5,  w0,  w4);
   TEST_3RF("fcult.w", dataf,  72,  64, w22, w21, w14);
   TEST_3RF("fcult.w", dataf,  72,  72, w9,  w0,  w7);
   TEST_3RF("fcult.d", datad,   0,   0, w17, w27, w25);
   TEST_3RF("fcult.d", datad,   0,  16, w5,  w14, w20);
   TEST_3RF("fcult.d", datad,   0,  32, w26, w31, w28);
   TEST_3RF("fcult.d", datad,   0,  48, w30, w22, w0);
   TEST_3RF("fcult.d", datad,   0,  64, w2,  w9,  w19);
   TEST_3RF("fcult.d", datad,   0,  80, w9,  w31, w17);
   TEST_3RF("fcult.d", datad,   0,  96, w18, w22, w25);
   TEST_3RF("fcult.d", datad,   0, 112, w23, w22, w29);
   TEST_3RF("fcult.d", datad,   0, 128, w13, w11, w23);
   TEST_3RF("fcult.d", datad,   0, 144, w11, w18, w8);
   TEST_3RF("fcult.d", datad,  16,   0, w7,  w12, w13);
   TEST_3RF("fcult.d", datad,  16,  16, w21, w0,  w8);
   TEST_3RF("fcult.d", datad,  16,  32, w20, w29, w6);
   TEST_3RF("fcult.d", datad,  16,  48, w10, w29, w9);
   TEST_3RF("fcult.d", datad,  16,  64, w12, w6,  w28);
   TEST_3RF("fcult.d", datad,  16,  80, w22, w5,  w13);
   TEST_3RF("fcult.d", datad,  16,  96, w8,  w8,  w28);
   TEST_3RF("fcult.d", datad,  16, 112, w6,  w0,  w18);
   TEST_3RF("fcult.d", datad,  16, 128, w3,  w13, w30);
   TEST_3RF("fcult.d", datad,  16, 144, w15, w4,  w9);
   TEST_3RF("fcult.d", datad,  32,   0, w1,  w12, w16);
   TEST_3RF("fcult.d", datad,  32,  16, w13, w26, w5);
   TEST_3RF("fcult.d", datad,  32,  32, w14, w2,  w2);
   TEST_3RF("fcult.d", datad,  32,  48, w26, w11, w8);
   TEST_3RF("fcult.d", datad,  32,  64, w4,  w8,  w17);
   TEST_3RF("fcult.d", datad,  32,  80, w17, w14, w7);
   TEST_3RF("fcult.d", datad,  32,  96, w20, w27, w15);
   TEST_3RF("fcult.d", datad,  32, 112, w16, w2,  w15);
   TEST_3RF("fcult.d", datad,  32, 128, w2,  w5,  w29);
   TEST_3RF("fcult.d", datad,  32, 144, w0,  w20, w1);
   TEST_3RF("fcult.d", datad,  48,   0, w10, w22, w14);
   TEST_3RF("fcult.d", datad,  48,  16, w26, w3,  w8);
   TEST_3RF("fcult.d", datad,  48,  32, w0,  w17, w10);
   TEST_3RF("fcult.d", datad,  48,  48, w26, w28, w18);
   TEST_3RF("fcult.d", datad,  48,  64, w30, w4,  w15);
   TEST_3RF("fcult.d", datad,  48,  80, w19, w19, w19);
   TEST_3RF("fcult.d", datad,  48,  96, w18, w22, w7);
   TEST_3RF("fcult.d", datad,  48, 112, w13, w6,  w23);
   TEST_3RF("fcult.d", datad,  48, 128, w15, w21, w25);
   TEST_3RF("fcult.d", datad,  48, 144, w21, w18, w26);
   TEST_3RF("fcult.d", datad,  64,   0, w9,  w20, w4);
   TEST_3RF("fcult.d", datad,  64,  16, w31, w2,  w30);
   TEST_3RF("fcult.d", datad,  64,  32, w3,  w10, w30);
   TEST_3RF("fcult.d", datad,  64,  48, w20, w24, w17);
   TEST_3RF("fcult.d", datad,  64,  64, w6,  w23, w21);
   TEST_3RF("fcult.d", datad,  64,  80, w10, w6,  w8);
   TEST_3RF("fcult.d", datad,  64,  96, w28, w29, w28);
   TEST_3RF("fcult.d", datad,  64, 112, w15, w10, w3);
   TEST_3RF("fcult.d", datad,  64, 128, w6,  w25, w24);
   TEST_3RF("fcult.d", datad,  64, 144, w0,  w14, w11);
   TEST_3RF("fcult.d", datad,  80,   0, w26, w24, w31);
   TEST_3RF("fcult.d", datad,  80,  16, w30, w23, w1);
   TEST_3RF("fcult.d", datad,  80,  32, w28, w26, w28);
   TEST_3RF("fcult.d", datad,  80,  48, w11, w27, w15);
   TEST_3RF("fcult.d", datad,  80,  64, w31, w19, w0);
   TEST_3RF("fcult.d", datad,  80,  80, w5,  w10, w21);
   TEST_3RF("fcult.d", datad,  80,  96, w16, w17, w30);
   TEST_3RF("fcult.d", datad,  80, 112, w12, w14, w13);
   TEST_3RF("fcult.d", datad,  80, 128, w22, w17, w20);
   TEST_3RF("fcult.d", datad,  80, 144, w16, w9,  w20);
   TEST_3RF("fcult.d", datad,  96,   0, w30, w20, w14);
   TEST_3RF("fcult.d", datad,  96,  16, w22, w19, w12);
   TEST_3RF("fcult.d", datad,  96,  32, w14, w20, w20);
   TEST_3RF("fcult.d", datad,  96,  48, w8,  w8,  w31);
   TEST_3RF("fcult.d", datad,  96,  64, w3,  w23, w30);
   TEST_3RF("fcult.d", datad,  96,  80, w23, w4,  w1);
   TEST_3RF("fcult.d", datad,  96,  96, w13, w20, w18);
   TEST_3RF("fcult.d", datad,  96, 112, w11, w0,  w24);
   TEST_3RF("fcult.d", datad,  96, 128, w23, w17, w12);
   TEST_3RF("fcult.d", datad,  96, 144, w7,  w27, w0);
   TEST_3RF("fcult.d", datad, 112,   0, w5,  w15, w14);
   TEST_3RF("fcult.d", datad, 112,  16, w28, w3,  w28);
   TEST_3RF("fcult.d", datad, 112,  32, w26, w10, w23);
   TEST_3RF("fcult.d", datad, 112,  48, w3,  w18, w23);
   TEST_3RF("fcult.d", datad, 112,  64, w6,  w10, w21);
   TEST_3RF("fcult.d", datad, 112,  80, w29, w1,  w25);
   TEST_3RF("fcult.d", datad, 112,  96, w31, w14, w13);
   TEST_3RF("fcult.d", datad, 112, 112, w17, w25, w14);
   TEST_3RF("fcult.d", datad, 112, 128, w18, w5,  w3);
   TEST_3RF("fcult.d", datad, 112, 144, w30, w12, w31);
   TEST_3RF("fcult.d", datad, 128,   0, w17, w14, w13);
   TEST_3RF("fcult.d", datad, 128,  16, w13, w17, w8);
   TEST_3RF("fcult.d", datad, 128,  32, w23, w8,  w11);
   TEST_3RF("fcult.d", datad, 128,  48, w10, w31, w17);
   TEST_3RF("fcult.d", datad, 128,  64, w20, w21, w15);
   TEST_3RF("fcult.d", datad, 128,  80, w21, w14, w4);
   TEST_3RF("fcult.d", datad, 128,  96, w28, w31, w28);
   TEST_3RF("fcult.d", datad, 128, 112, w29, w10, w17);
   TEST_3RF("fcult.d", datad, 128, 128, w15, w21, w14);
   TEST_3RF("fcult.d", datad, 128, 144, w27, w19, w13);
   TEST_3RF("fcult.d", datad, 144,   0, w12, w1,  w26);
   TEST_3RF("fcult.d", datad, 144,  16, w26, w18, w2);
   TEST_3RF("fcult.d", datad, 144,  32, w17, w27, w13);
   TEST_3RF("fcult.d", datad, 144,  48, w27, w26, w31);
   TEST_3RF("fcult.d", datad, 144,  64, w15, w14, w5);
   TEST_3RF("fcult.d", datad, 144,  80, w30, w28, w9);
   TEST_3RF("fcult.d", datad, 144,  96, w26, w27, w6);
   TEST_3RF("fcult.d", datad, 144, 112, w4,  w13, w22);
   TEST_3RF("fcult.d", datad, 144, 128, w19, w19, w19);
   TEST_3RF("fcult.d", datad, 144, 144, w2,  w4,  w14);
   TEST_3RF("fcun.w", dataf,   0,   0, w11, w20, w9);
   TEST_3RF("fcun.w", dataf,   0,   8, w14, w6,  w4);
   TEST_3RF("fcun.w", dataf,   0,  16, w27, w1,  w31);
   TEST_3RF("fcun.w", dataf,   0,  24, w26, w17, w26);
   TEST_3RF("fcun.w", dataf,   0,  32, w14, w8,  w22);
   TEST_3RF("fcun.w", dataf,   0,  40, w12, w4,  w31);
   TEST_3RF("fcun.w", dataf,   0,  48, w6,  w0,  w5);
   TEST_3RF("fcun.w", dataf,   0,  56, w10, w13, w27);
   TEST_3RF("fcun.w", dataf,   0,  64, w29, w15, w31);
   TEST_3RF("fcun.w", dataf,   0,  72, w11, w4,  w16);
   TEST_3RF("fcun.w", dataf,   8,   0, w6,  w27, w28);
   TEST_3RF("fcun.w", dataf,   8,   8, w26, w5,  w26);
   TEST_3RF("fcun.w", dataf,   8,  16, w10, w0,  w9);
   TEST_3RF("fcun.w", dataf,   8,  24, w5,  w2,  w8);
   TEST_3RF("fcun.w", dataf,   8,  32, w0,  w19, w23);
   TEST_3RF("fcun.w", dataf,   8,  40, w8,  w9,  w3);
   TEST_3RF("fcun.w", dataf,   8,  48, w13, w8,  w10);
   TEST_3RF("fcun.w", dataf,   8,  56, w13, w20, w26);
   TEST_3RF("fcun.w", dataf,   8,  64, w9,  w18, w8);
   TEST_3RF("fcun.w", dataf,   8,  72, w29, w13, w25);
   TEST_3RF("fcun.w", dataf,  16,   0, w3,  w9,  w21);
   TEST_3RF("fcun.w", dataf,  16,   8, w30, w14, w31);
   TEST_3RF("fcun.w", dataf,  16,  16, w30, w23, w4);
   TEST_3RF("fcun.w", dataf,  16,  24, w0,  w4,  w19);
   TEST_3RF("fcun.w", dataf,  16,  32, w23, w13, w13);
   TEST_3RF("fcun.w", dataf,  16,  40, w28, w26, w4);
   TEST_3RF("fcun.w", dataf,  16,  48, w4,  w7,  w18);
   TEST_3RF("fcun.w", dataf,  16,  56, w25, w1,  w27);
   TEST_3RF("fcun.w", dataf,  16,  64, w11, w10, w3);
   TEST_3RF("fcun.w", dataf,  16,  72, w8,  w23, w28);
   TEST_3RF("fcun.w", dataf,  24,   0, w12, w0,  w17);
   TEST_3RF("fcun.w", dataf,  24,   8, w10, w14, w16);
   TEST_3RF("fcun.w", dataf,  24,  16, w8,  w6,  w21);
   TEST_3RF("fcun.w", dataf,  24,  24, w9,  w6,  w25);
   TEST_3RF("fcun.w", dataf,  24,  32, w28, w29, w6);
   TEST_3RF("fcun.w", dataf,  24,  40, w25, w23, w0);
   TEST_3RF("fcun.w", dataf,  24,  48, w29, w28, w7);
   TEST_3RF("fcun.w", dataf,  24,  56, w15, w21, w8);
   TEST_3RF("fcun.w", dataf,  24,  64, w10, w0,  w18);
   TEST_3RF("fcun.w", dataf,  24,  72, w14, w8,  w10);
   TEST_3RF("fcun.w", dataf,  32,   0, w10, w20, w28);
   TEST_3RF("fcun.w", dataf,  32,   8, w30, w25, w12);
   TEST_3RF("fcun.w", dataf,  32,  16, w7,  w31, w1);
   TEST_3RF("fcun.w", dataf,  32,  24, w16, w5,  w27);
   TEST_3RF("fcun.w", dataf,  32,  32, w12, w2,  w1);
   TEST_3RF("fcun.w", dataf,  32,  40, w5,  w25, w2);
   TEST_3RF("fcun.w", dataf,  32,  48, w3,  w21, w9);
   TEST_3RF("fcun.w", dataf,  32,  56, w18, w10, w29);
   TEST_3RF("fcun.w", dataf,  32,  64, w10, w4,  w11);
   TEST_3RF("fcun.w", dataf,  32,  72, w19, w14, w21);
   TEST_3RF("fcun.w", dataf,  40,   0, w7,  w25, w17);
   TEST_3RF("fcun.w", dataf,  40,   8, w6,  w18, w30);
   TEST_3RF("fcun.w", dataf,  40,  16, w13, w17, w31);
   TEST_3RF("fcun.w", dataf,  40,  24, w29, w22, w26);
   TEST_3RF("fcun.w", dataf,  40,  32, w9,  w24, w28);
   TEST_3RF("fcun.w", dataf,  40,  40, w15, w17, w30);
   TEST_3RF("fcun.w", dataf,  40,  48, w18, w7,  w4);
   TEST_3RF("fcun.w", dataf,  40,  56, w17, w17, w25);
   TEST_3RF("fcun.w", dataf,  40,  64, w1,  w28, w30);
   TEST_3RF("fcun.w", dataf,  40,  72, w12, w15, w2);
   TEST_3RF("fcun.w", dataf,  48,   0, w22, w5,  w19);
   TEST_3RF("fcun.w", dataf,  48,   8, w28, w23, w17);
   TEST_3RF("fcun.w", dataf,  48,  16, w9,  w8,  w17);
   TEST_3RF("fcun.w", dataf,  48,  24, w6,  w30, w11);
   TEST_3RF("fcun.w", dataf,  48,  32, w16, w22, w7);
   TEST_3RF("fcun.w", dataf,  48,  40, w31, w8,  w5);
   TEST_3RF("fcun.w", dataf,  48,  48, w17, w17, w15);
   TEST_3RF("fcun.w", dataf,  48,  56, w13, w21, w0);
   TEST_3RF("fcun.w", dataf,  48,  64, w6,  w23, w28);
   TEST_3RF("fcun.w", dataf,  48,  72, w4,  w3,  w11);
   TEST_3RF("fcun.w", dataf,  56,   0, w17, w17, w5);
   TEST_3RF("fcun.w", dataf,  56,   8, w2,  w22, w25);
   TEST_3RF("fcun.w", dataf,  56,  16, w30, w14, w10);
   TEST_3RF("fcun.w", dataf,  56,  24, w8,  w22, w27);
   TEST_3RF("fcun.w", dataf,  56,  32, w14, w21, w7);
   TEST_3RF("fcun.w", dataf,  56,  40, w30, w11, w14);
   TEST_3RF("fcun.w", dataf,  56,  48, w29, w19, w20);
   TEST_3RF("fcun.w", dataf,  56,  56, w14, w2,  w1);
   TEST_3RF("fcun.w", dataf,  56,  64, w4,  w3,  w7);
   TEST_3RF("fcun.w", dataf,  56,  72, w27, w31, w12);
   TEST_3RF("fcun.w", dataf,  64,   0, w30, w11, w29);
   TEST_3RF("fcun.w", dataf,  64,   8, w4,  w13, w19);
   TEST_3RF("fcun.w", dataf,  64,  16, w29, w11, w1);
   TEST_3RF("fcun.w", dataf,  64,  24, w7,  w19, w24);
   TEST_3RF("fcun.w", dataf,  64,  32, w3,  w2,  w13);
   TEST_3RF("fcun.w", dataf,  64,  40, w10, w0,  w24);
   TEST_3RF("fcun.w", dataf,  64,  48, w24, w30, w12);
   TEST_3RF("fcun.w", dataf,  64,  56, w12, w14, w13);
   TEST_3RF("fcun.w", dataf,  64,  64, w16, w17, w21);
   TEST_3RF("fcun.w", dataf,  64,  72, w11, w17, w1);
   TEST_3RF("fcun.w", dataf,  72,   0, w10, w28, w30);
   TEST_3RF("fcun.w", dataf,  72,   8, w14, w9,  w17);
   TEST_3RF("fcun.w", dataf,  72,  16, w11, w20, w19);
   TEST_3RF("fcun.w", dataf,  72,  24, w18, w8,  w11);
   TEST_3RF("fcun.w", dataf,  72,  32, w21, w21, w21);
   TEST_3RF("fcun.w", dataf,  72,  40, w10, w24, w31);
   TEST_3RF("fcun.w", dataf,  72,  48, w10, w16, w24);
   TEST_3RF("fcun.w", dataf,  72,  56, w8,  w28, w4);
   TEST_3RF("fcun.w", dataf,  72,  64, w21, w21, w21);
   TEST_3RF("fcun.w", dataf,  72,  72, w11, w18, w5);
   TEST_3RF("fcun.d", datad,   0,   0, w28, w7,  w17);
   TEST_3RF("fcun.d", datad,   0,  16, w13, w8,  w27);
   TEST_3RF("fcun.d", datad,   0,  32, w9,  w6,  w18);
   TEST_3RF("fcun.d", datad,   0,  48, w23, w20, w20);
   TEST_3RF("fcun.d", datad,   0,  64, w7,  w10, w6);
   TEST_3RF("fcun.d", datad,   0,  80, w15, w21, w28);
   TEST_3RF("fcun.d", datad,   0,  96, w25, w13, w27);
   TEST_3RF("fcun.d", datad,   0, 112, w3,  w30, w19);
   TEST_3RF("fcun.d", datad,   0, 128, w12, w26, w24);
   TEST_3RF("fcun.d", datad,   0, 144, w1,  w5,  w10);
   TEST_3RF("fcun.d", datad,  16,   0, w6,  w2,  w17);
   TEST_3RF("fcun.d", datad,  16,  16, w23, w15, w15);
   TEST_3RF("fcun.d", datad,  16,  32, w25, w18, w31);
   TEST_3RF("fcun.d", datad,  16,  48, w27, w11, w22);
   TEST_3RF("fcun.d", datad,  16,  64, w15, w18, w1);
   TEST_3RF("fcun.d", datad,  16,  80, w22, w1,  w18);
   TEST_3RF("fcun.d", datad,  16,  96, w26, w4,  w26);
   TEST_3RF("fcun.d", datad,  16, 112, w13, w30, w2);
   TEST_3RF("fcun.d", datad,  16, 128, w1,  w10, w28);
   TEST_3RF("fcun.d", datad,  16, 144, w25, w11, w2);
   TEST_3RF("fcun.d", datad,  32,   0, w3,  w17, w4);
   TEST_3RF("fcun.d", datad,  32,  16, w20, w9,  w19);
   TEST_3RF("fcun.d", datad,  32,  32, w13, w27, w12);
   TEST_3RF("fcun.d", datad,  32,  48, w12, w23, w24);
   TEST_3RF("fcun.d", datad,  32,  64, w2,  w6,  w10);
   TEST_3RF("fcun.d", datad,  32,  80, w3,  w28, w12);
   TEST_3RF("fcun.d", datad,  32,  96, w26, w14, w26);
   TEST_3RF("fcun.d", datad,  32, 112, w6,  w30, w28);
   TEST_3RF("fcun.d", datad,  32, 128, w4,  w0,  w29);
   TEST_3RF("fcun.d", datad,  32, 144, w14, w28, w22);
   TEST_3RF("fcun.d", datad,  48,   0, w25, w30, w11);
   TEST_3RF("fcun.d", datad,  48,  16, w2,  w13, w20);
   TEST_3RF("fcun.d", datad,  48,  32, w22, w26, w15);
   TEST_3RF("fcun.d", datad,  48,  48, w2,  w6,  w26);
   TEST_3RF("fcun.d", datad,  48,  64, w8,  w13, w5);
   TEST_3RF("fcun.d", datad,  48,  80, w12, w9,  w17);
   TEST_3RF("fcun.d", datad,  48,  96, w6,  w24, w23);
   TEST_3RF("fcun.d", datad,  48, 112, w4,  w20, w28);
   TEST_3RF("fcun.d", datad,  48, 128, w4,  w17, w10);
   TEST_3RF("fcun.d", datad,  48, 144, w0,  w7,  w4);
   TEST_3RF("fcun.d", datad,  64,   0, w31, w0,  w15);
   TEST_3RF("fcun.d", datad,  64,  16, w1,  w13, w3);
   TEST_3RF("fcun.d", datad,  64,  32, w23, w7,  w7);
   TEST_3RF("fcun.d", datad,  64,  48, w18, w26, w13);
   TEST_3RF("fcun.d", datad,  64,  64, w25, w20, w21);
   TEST_3RF("fcun.d", datad,  64,  80, w6,  w25, w1);
   TEST_3RF("fcun.d", datad,  64,  96, w15, w10, w7);
   TEST_3RF("fcun.d", datad,  64, 112, w7,  w2,  w11);
   TEST_3RF("fcun.d", datad,  64, 128, w27, w30, w15);
   TEST_3RF("fcun.d", datad,  64, 144, w12, w8,  w16);
   TEST_3RF("fcun.d", datad,  80,   0, w19, w12, w15);
   TEST_3RF("fcun.d", datad,  80,  16, w19, w27, w16);
   TEST_3RF("fcun.d", datad,  80,  32, w0,  w30, w8);
   TEST_3RF("fcun.d", datad,  80,  48, w7,  w17, w2);
   TEST_3RF("fcun.d", datad,  80,  64, w20, w10, w22);
   TEST_3RF("fcun.d", datad,  80,  80, w10, w16, w11);
   TEST_3RF("fcun.d", datad,  80,  96, w31, w26, w19);
   TEST_3RF("fcun.d", datad,  80, 112, w7,  w28, w30);
   TEST_3RF("fcun.d", datad,  80, 128, w2,  w26, w14);
   TEST_3RF("fcun.d", datad,  80, 144, w15, w3,  w30);
   TEST_3RF("fcun.d", datad,  96,   0, w2,  w15, w13);
   TEST_3RF("fcun.d", datad,  96,  16, w22, w11, w29);
   TEST_3RF("fcun.d", datad,  96,  32, w22, w9,  w5);
   TEST_3RF("fcun.d", datad,  96,  48, w30, w26, w7);
   TEST_3RF("fcun.d", datad,  96,  64, w18, w4,  w30);
   TEST_3RF("fcun.d", datad,  96,  80, w28, w20, w14);
   TEST_3RF("fcun.d", datad,  96,  96, w8,  w20, w27);
   TEST_3RF("fcun.d", datad,  96, 112, w27, w5,  w25);
   TEST_3RF("fcun.d", datad,  96, 128, w29, w31, w7);
   TEST_3RF("fcun.d", datad,  96, 144, w12, w2,  w5);
   TEST_3RF("fcun.d", datad, 112,   0, w15, w18, w5);
   TEST_3RF("fcun.d", datad, 112,  16, w29, w16, w27);
   TEST_3RF("fcun.d", datad, 112,  32, w6,  w21, w25);
   TEST_3RF("fcun.d", datad, 112,  48, w1,  w29, w12);
   TEST_3RF("fcun.d", datad, 112,  64, w5,  w27, w8);
   TEST_3RF("fcun.d", datad, 112,  80, w26, w9,  w26);
   TEST_3RF("fcun.d", datad, 112,  96, w16, w14, w17);
   TEST_3RF("fcun.d", datad, 112, 112, w11, w9,  w22);
   TEST_3RF("fcun.d", datad, 112, 128, w5,  w6,  w22);
   TEST_3RF("fcun.d", datad, 112, 144, w12, w19, w24);
   TEST_3RF("fcun.d", datad, 128,   0, w18, w2,  w10);
   TEST_3RF("fcun.d", datad, 128,  16, w4,  w7,  w20);
   TEST_3RF("fcun.d", datad, 128,  32, w2,  w14, w10);
   TEST_3RF("fcun.d", datad, 128,  48, w28, w15, w7);
   TEST_3RF("fcun.d", datad, 128,  64, w8,  w20, w2);
   TEST_3RF("fcun.d", datad, 128,  80, w16, w14, w11);
   TEST_3RF("fcun.d", datad, 128,  96, w1,  w28, w12);
   TEST_3RF("fcun.d", datad, 128, 112, w5,  w19, w17);
   TEST_3RF("fcun.d", datad, 128, 128, w12, w9,  w30);
   TEST_3RF("fcun.d", datad, 128, 144, w31, w1,  w16);
   TEST_3RF("fcun.d", datad, 144,   0, w1,  w12, w20);
   TEST_3RF("fcun.d", datad, 144,  16, w8,  w19, w9);
   TEST_3RF("fcun.d", datad, 144,  32, w10, w1,  w19);
   TEST_3RF("fcun.d", datad, 144,  48, w6,  w16, w26);
   TEST_3RF("fcun.d", datad, 144,  64, w14, w5,  w28);
   TEST_3RF("fcun.d", datad, 144,  80, w31, w19, w7);
   TEST_3RF("fcun.d", datad, 144,  96, w0,  w16, w3);
   TEST_3RF("fcun.d", datad, 144, 112, w12, w21, w22);
   TEST_3RF("fcun.d", datad, 144, 128, w30, w1,  w31);
   TEST_3RF("fcun.d", datad, 144, 144, w28, w0,  w1);
   TEST_3RF("fcune.w", dataf,   0,   0, w9,  w0,  w20);
   TEST_3RF("fcune.w", dataf,   0,   8, w2,  w28, w26);
   TEST_3RF("fcune.w", dataf,   0,  16, w18, w22, w9);
   TEST_3RF("fcune.w", dataf,   0,  24, w23, w18, w8);
   TEST_3RF("fcune.w", dataf,   0,  32, w11, w25, w8);
   TEST_3RF("fcune.w", dataf,   0,  40, w27, w29, w20);
   TEST_3RF("fcune.w", dataf,   0,  48, w16, w19, w18);
   TEST_3RF("fcune.w", dataf,   0,  56, w18, w19, w14);
   TEST_3RF("fcune.w", dataf,   0,  64, w18, w20, w26);
   TEST_3RF("fcune.w", dataf,   0,  72, w20, w1,  w27);
   TEST_3RF("fcune.w", dataf,   8,   0, w29, w1,  w4);
   TEST_3RF("fcune.w", dataf,   8,   8, w17, w3,  w1);
   TEST_3RF("fcune.w", dataf,   8,  16, w12, w12, w12);
   TEST_3RF("fcune.w", dataf,   8,  24, w22, w23, w21);
   TEST_3RF("fcune.w", dataf,   8,  32, w13, w10, w13);
   TEST_3RF("fcune.w", dataf,   8,  40, w29, w24, w3);
   TEST_3RF("fcune.w", dataf,   8,  48, w5,  w19, w0);
   TEST_3RF("fcune.w", dataf,   8,  56, w25, w4,  w20);
   TEST_3RF("fcune.w", dataf,   8,  64, w12, w12, w12);
   TEST_3RF("fcune.w", dataf,   8,  72, w22, w7,  w26);
   TEST_3RF("fcune.w", dataf,  16,   0, w8,  w27, w21);
   TEST_3RF("fcune.w", dataf,  16,   8, w28, w16, w26);
   TEST_3RF("fcune.w", dataf,  16,  16, w29, w20, w11);
   TEST_3RF("fcune.w", dataf,  16,  24, w1,  w1,  w21);
   TEST_3RF("fcune.w", dataf,  16,  32, w23, w13, w12);
   TEST_3RF("fcune.w", dataf,  16,  40, w4,  w23, w9);
   TEST_3RF("fcune.w", dataf,  16,  48, w29, w26, w14);
   TEST_3RF("fcune.w", dataf,  16,  56, w16, w27, w8);
   TEST_3RF("fcune.w", dataf,  16,  64, w20, w15, w10);
   TEST_3RF("fcune.w", dataf,  16,  72, w22, w14, w19);
   TEST_3RF("fcune.w", dataf,  24,   0, w17, w3,  w15);
   TEST_3RF("fcune.w", dataf,  24,   8, w13, w19, w13);
   TEST_3RF("fcune.w", dataf,  24,  16, w9,  w10, w8);
   TEST_3RF("fcune.w", dataf,  24,  24, w21, w11, w29);
   TEST_3RF("fcune.w", dataf,  24,  32, w12, w12, w12);
   TEST_3RF("fcune.w", dataf,  24,  40, w2,  w10, w25);
   TEST_3RF("fcune.w", dataf,  24,  48, w7,  w1,  w2);
   TEST_3RF("fcune.w", dataf,  24,  56, w4,  w28, w17);
   TEST_3RF("fcune.w", dataf,  24,  64, w20, w23, w25);
   TEST_3RF("fcune.w", dataf,  24,  72, w9,  w6,  w13);
   TEST_3RF("fcune.w", dataf,  32,   0, w19, w28, w27);
   TEST_3RF("fcune.w", dataf,  32,   8, w6,  w13, w31);
   TEST_3RF("fcune.w", dataf,  32,  16, w22, w26, w18);
   TEST_3RF("fcune.w", dataf,  32,  24, w31, w4,  w26);
   TEST_3RF("fcune.w", dataf,  32,  32, w20, w16, w24);
   TEST_3RF("fcune.w", dataf,  32,  40, w1,  w1,  w18);
   TEST_3RF("fcune.w", dataf,  32,  48, w2,  w26, w25);
   TEST_3RF("fcune.w", dataf,  32,  56, w4,  w28, w29);
   TEST_3RF("fcune.w", dataf,  32,  64, w0,  w13, w13);
   TEST_3RF("fcune.w", dataf,  32,  72, w18, w23, w6);
   TEST_3RF("fcune.w", dataf,  40,   0, w27, w29, w19);
   TEST_3RF("fcune.w", dataf,  40,   8, w14, w25, w15);
   TEST_3RF("fcune.w", dataf,  40,  16, w21, w6,  w14);
   TEST_3RF("fcune.w", dataf,  40,  24, w11, w0,  w10);
   TEST_3RF("fcune.w", dataf,  40,  32, w4,  w27, w31);
   TEST_3RF("fcune.w", dataf,  40,  40, w20, w19, w0);
   TEST_3RF("fcune.w", dataf,  40,  48, w7,  w21, w26);
   TEST_3RF("fcune.w", dataf,  40,  56, w0,  w25, w25);
   TEST_3RF("fcune.w", dataf,  40,  64, w22, w30, w25);
   TEST_3RF("fcune.w", dataf,  40,  72, w4,  w16, w10);
   TEST_3RF("fcune.w", dataf,  48,   0, w11, w13, w30);
   TEST_3RF("fcune.w", dataf,  48,   8, w25, w6,  w13);
   TEST_3RF("fcune.w", dataf,  48,  16, w14, w12, w27);
   TEST_3RF("fcune.w", dataf,  48,  24, w25, w12, w27);
   TEST_3RF("fcune.w", dataf,  48,  32, w4,  w17, w22);
   TEST_3RF("fcune.w", dataf,  48,  40, w3,  w5,  w9);
   TEST_3RF("fcune.w", dataf,  48,  48, w3,  w12, w31);
   TEST_3RF("fcune.w", dataf,  48,  56, w29, w13, w24);
   TEST_3RF("fcune.w", dataf,  48,  64, w19, w11, w18);
   TEST_3RF("fcune.w", dataf,  48,  72, w23, w27, w2);
   TEST_3RF("fcune.w", dataf,  56,   0, w2,  w6,  w16);
   TEST_3RF("fcune.w", dataf,  56,   8, w0,  w31, w31);
   TEST_3RF("fcune.w", dataf,  56,  16, w22, w13, w14);
   TEST_3RF("fcune.w", dataf,  56,  24, w3,  w8,  w7);
   TEST_3RF("fcune.w", dataf,  56,  32, w15, w3,  w11);
   TEST_3RF("fcune.w", dataf,  56,  40, w0,  w26, w26);
   TEST_3RF("fcune.w", dataf,  56,  48, w14, w6,  w3);
   TEST_3RF("fcune.w", dataf,  56,  56, w17, w18, w2);
   TEST_3RF("fcune.w", dataf,  56,  64, w14, w31, w27);
   TEST_3RF("fcune.w", dataf,  56,  72, w2,  w10, w13);
   TEST_3RF("fcune.w", dataf,  64,   0, w25, w5,  w15);
   TEST_3RF("fcune.w", dataf,  64,   8, w27, w11, w31);
   TEST_3RF("fcune.w", dataf,  64,  16, w27, w11, w22);
   TEST_3RF("fcune.w", dataf,  64,  24, w8,  w25, w16);
   TEST_3RF("fcune.w", dataf,  64,  32, w0,  w8,  w8);
   TEST_3RF("fcune.w", dataf,  64,  40, w20, w12, w9);
   TEST_3RF("fcune.w", dataf,  64,  48, w14, w26, w15);
   TEST_3RF("fcune.w", dataf,  64,  56, w17, w12, w1);
   TEST_3RF("fcune.w", dataf,  64,  64, w20, w26, w1);
   TEST_3RF("fcune.w", dataf,  64,  72, w15, w28, w11);
   TEST_3RF("fcune.w", dataf,  72,   0, w28, w22, w17);
   TEST_3RF("fcune.w", dataf,  72,   8, w11, w17, w28);
   TEST_3RF("fcune.w", dataf,  72,  16, w11, w13, w7);
   TEST_3RF("fcune.w", dataf,  72,  24, w1,  w1,  w21);
   TEST_3RF("fcune.w", dataf,  72,  32, w0,  w26, w26);
   TEST_3RF("fcune.w", dataf,  72,  40, w6,  w1,  w2);
   TEST_3RF("fcune.w", dataf,  72,  48, w26, w13, w11);
   TEST_3RF("fcune.w", dataf,  72,  56, w8,  w7,  w26);
   TEST_3RF("fcune.w", dataf,  72,  64, w25, w19, w28);
   TEST_3RF("fcune.w", dataf,  72,  72, w13, w14, w13);
   TEST_3RF("fcune.d", datad,   0,   0, w29, w28, w10);
   TEST_3RF("fcune.d", datad,   0,  16, w8,  w24, w0);
   TEST_3RF("fcune.d", datad,   0,  32, w25, w4,  w18);
   TEST_3RF("fcune.d", datad,   0,  48, w22, w15, w31);
   TEST_3RF("fcune.d", datad,   0,  64, w29, w16, w20);
   TEST_3RF("fcune.d", datad,   0,  80, w30, w10, w26);
   TEST_3RF("fcune.d", datad,   0,  96, w31, w12, w20);
   TEST_3RF("fcune.d", datad,   0, 112, w12, w12, w12);
   TEST_3RF("fcune.d", datad,   0, 128, w24, w28, w19);
   TEST_3RF("fcune.d", datad,   0, 144, w18, w22, w7);
   TEST_3RF("fcune.d", datad,  16,   0, w14, w3,  w21);
   TEST_3RF("fcune.d", datad,  16,  16, w11, w0,  w31);
   TEST_3RF("fcune.d", datad,  16,  32, w20, w24, w0);
   TEST_3RF("fcune.d", datad,  16,  48, w13, w28, w13);
   TEST_3RF("fcune.d", datad,  16,  64, w18, w3,  w11);
   TEST_3RF("fcune.d", datad,  16,  80, w17, w1,  w27);
   TEST_3RF("fcune.d", datad,  16,  96, w5,  w31, w0);
   TEST_3RF("fcune.d", datad,  16, 112, w30, w18, w20);
   TEST_3RF("fcune.d", datad,  16, 128, w10, w17, w29);
   TEST_3RF("fcune.d", datad,  16, 144, w28, w7,  w4);
   TEST_3RF("fcune.d", datad,  32,   0, w11, w10, w25);
   TEST_3RF("fcune.d", datad,  32,  16, w22, w10, w25);
   TEST_3RF("fcune.d", datad,  32,  32, w10, w3,  w25);
   TEST_3RF("fcune.d", datad,  32,  48, w24, w31, w11);
   TEST_3RF("fcune.d", datad,  32,  64, w27, w11, w28);
   TEST_3RF("fcune.d", datad,  32,  80, w28, w6,  w1);
   TEST_3RF("fcune.d", datad,  32,  96, w27, w12, w1);
   TEST_3RF("fcune.d", datad,  32, 112, w25, w30, w22);
   TEST_3RF("fcune.d", datad,  32, 128, w3,  w8,  w7);
   TEST_3RF("fcune.d", datad,  32, 144, w1,  w1,  w4);
   TEST_3RF("fcune.d", datad,  48,   0, w14, w5,  w15);
   TEST_3RF("fcune.d", datad,  48,  16, w24, w31, w6);
   TEST_3RF("fcune.d", datad,  48,  32, w3,  w24, w16);
   TEST_3RF("fcune.d", datad,  48,  48, w6,  w17, w8);
   TEST_3RF("fcune.d", datad,  48,  64, w5,  w28, w4);
   TEST_3RF("fcune.d", datad,  48,  80, w16, w24, w0);
   TEST_3RF("fcune.d", datad,  48,  96, w23, w25, w28);
   TEST_3RF("fcune.d", datad,  48, 112, w3,  w27, w21);
   TEST_3RF("fcune.d", datad,  48, 128, w1,  w1,  w17);
   TEST_3RF("fcune.d", datad,  48, 144, w25, w9,  w24);
   TEST_3RF("fcune.d", datad,  64,   0, w26, w13, w6);
   TEST_3RF("fcune.d", datad,  64,  16, w31, w29, w30);
   TEST_3RF("fcune.d", datad,  64,  32, w30, w3,  w1);
   TEST_3RF("fcune.d", datad,  64,  48, w22, w19, w7);
   TEST_3RF("fcune.d", datad,  64,  64, w7,  w28, w13);
   TEST_3RF("fcune.d", datad,  64,  80, w3,  w0,  w29);
   TEST_3RF("fcune.d", datad,  64,  96, w27, w0,  w20);
   TEST_3RF("fcune.d", datad,  64, 112, w21, w28, w23);
   TEST_3RF("fcune.d", datad,  64, 128, w16, w18, w24);
   TEST_3RF("fcune.d", datad,  64, 144, w1,  w1,  w11);
   TEST_3RF("fcune.d", datad,  80,   0, w1,  w1,  w25);
   TEST_3RF("fcune.d", datad,  80,  16, w5,  w15, w31);
   TEST_3RF("fcune.d", datad,  80,  32, w4,  w12, w29);
   TEST_3RF("fcune.d", datad,  80,  48, w3,  w15, w31);
   TEST_3RF("fcune.d", datad,  80,  64, w25, w2,  w6);
   TEST_3RF("fcune.d", datad,  80,  80, w1,  w1,  w30);
   TEST_3RF("fcune.d", datad,  80,  96, w19, w4,  w30);
   TEST_3RF("fcune.d", datad,  80, 112, w17, w0,  w31);
   TEST_3RF("fcune.d", datad,  80, 128, w5,  w21, w27);
   TEST_3RF("fcune.d", datad,  80, 144, w29, w5,  w13);
   TEST_3RF("fcune.d", datad,  96,   0, w21, w6,  w24);
   TEST_3RF("fcune.d", datad,  96,  16, w23, w31, w29);
   TEST_3RF("fcune.d", datad,  96,  32, w6,  w30, w2);
   TEST_3RF("fcune.d", datad,  96,  48, w18, w27, w5);
   TEST_3RF("fcune.d", datad,  96,  64, w1,  w1,  w26);
   TEST_3RF("fcune.d", datad,  96,  80, w30, w3,  w1);
   TEST_3RF("fcune.d", datad,  96,  96, w31, w2,  w20);
   TEST_3RF("fcune.d", datad,  96, 112, w4,  w0,  w5);
   TEST_3RF("fcune.d", datad,  96, 128, w4,  w31, w11);
   TEST_3RF("fcune.d", datad,  96, 144, w25, w27, w8);
   TEST_3RF("fcune.d", datad, 112,   0, w30, w8,  w29);
   TEST_3RF("fcune.d", datad, 112,  16, w4,  w1,  w20);
   TEST_3RF("fcune.d", datad, 112,  32, w3,  w30, w26);
   TEST_3RF("fcune.d", datad, 112,  48, w1,  w1,  w0);
   TEST_3RF("fcune.d", datad, 112,  64, w12, w12, w12);
   TEST_3RF("fcune.d", datad, 112,  80, w28, w5,  w13);
   TEST_3RF("fcune.d", datad, 112,  96, w23, w4,  w17);
   TEST_3RF("fcune.d", datad, 112, 112, w24, w3,  w19);
   TEST_3RF("fcune.d", datad, 112, 128, w12, w12, w12);
   TEST_3RF("fcune.d", datad, 112, 144, w7,  w19, w18);
   TEST_3RF("fcune.d", datad, 128,   0, w11, w19, w29);
   TEST_3RF("fcune.d", datad, 128,  16, w4,  w14, w5);
   TEST_3RF("fcune.d", datad, 128,  32, w2,  w22, w6);
   TEST_3RF("fcune.d", datad, 128,  48, w23, w9,  w22);
   TEST_3RF("fcune.d", datad, 128,  64, w17, w10, w22);
   TEST_3RF("fcune.d", datad, 128,  80, w30, w7,  w28);
   TEST_3RF("fcune.d", datad, 128,  96, w11, w30, w0);
   TEST_3RF("fcune.d", datad, 128, 112, w28, w22, w3);
   TEST_3RF("fcune.d", datad, 128, 128, w15, w2,  w11);
   TEST_3RF("fcune.d", datad, 128, 144, w3,  w20, w22);
   TEST_3RF("fcune.d", datad, 144,   0, w22, w17, w27);
   TEST_3RF("fcune.d", datad, 144,  16, w4,  w22, w29);
   TEST_3RF("fcune.d", datad, 144,  32, w26, w25, w4);
   TEST_3RF("fcune.d", datad, 144,  48, w18, w16, w13);
   TEST_3RF("fcune.d", datad, 144,  64, w8,  w1,  w24);
   TEST_3RF("fcune.d", datad, 144,  80, w30, w31, w26);
   TEST_3RF("fcune.d", datad, 144,  96, w11, w29, w26);
   TEST_3RF("fcune.d", datad, 144, 112, w7,  w19, w30);
   TEST_3RF("fcune.d", datad, 144, 128, w23, w21, w9);
   TEST_3RF("fcune.d", datad, 144, 144, w26, w10, w31);
   TEST_3RF("fsaf.w", dataf,   0,   0, w18, w24, w14);
   TEST_3RF("fsaf.w", dataf,   0,   8, w11, w28, w0);
   TEST_3RF("fsaf.w", dataf,   0,  16, w27, w27, w9);
   TEST_3RF("fsaf.w", dataf,   0,  24, w8,  w28, w1);
   TEST_3RF("fsaf.w", dataf,   0,  32, w7,  w28, w0);
   TEST_3RF("fsaf.w", dataf,   0,  40, w1,  w7,  w29);
   TEST_3RF("fsaf.w", dataf,   0,  48, w28, w14, w16);
   TEST_3RF("fsaf.w", dataf,   0,  56, w26, w5,  w26);
   TEST_3RF("fsaf.w", dataf,   0,  64, w6,  w3,  w31);
   TEST_3RF("fsaf.w", dataf,   0,  72, w16, w16, w16);
   TEST_3RF("fsaf.w", dataf,   8,   0, w2,  w15, w11);
   TEST_3RF("fsaf.w", dataf,   8,   8, w29, w3,  w21);
   TEST_3RF("fsaf.w", dataf,   8,  16, w18, w8,  w17);
   TEST_3RF("fsaf.w", dataf,   8,  24, w18, w3,  w26);
   TEST_3RF("fsaf.w", dataf,   8,  32, w27, w27, w0);
   TEST_3RF("fsaf.w", dataf,   8,  40, w28, w2,  w3);
   TEST_3RF("fsaf.w", dataf,   8,  48, w3,  w26, w31);
   TEST_3RF("fsaf.w", dataf,   8,  56, w17, w10, w25);
   TEST_3RF("fsaf.w", dataf,   8,  64, w23, w16, w28);
   TEST_3RF("fsaf.w", dataf,   8,  72, w22, w0,  w31);
   TEST_3RF("fsaf.w", dataf,  16,   0, w6,  w12, w28);
   TEST_3RF("fsaf.w", dataf,  16,   8, w9,  w17, w27);
   TEST_3RF("fsaf.w", dataf,  16,  16, w18, w2,  w14);
   TEST_3RF("fsaf.w", dataf,  16,  24, w21, w28, w9);
   TEST_3RF("fsaf.w", dataf,  16,  32, w21, w24, w11);
   TEST_3RF("fsaf.w", dataf,  16,  40, w17, w21, w14);
   TEST_3RF("fsaf.w", dataf,  16,  48, w20, w15, w15);
   TEST_3RF("fsaf.w", dataf,  16,  56, w14, w6,  w25);
   TEST_3RF("fsaf.w", dataf,  16,  64, w7,  w29, w10);
   TEST_3RF("fsaf.w", dataf,  16,  72, w4,  w19, w10);
   TEST_3RF("fsaf.w", dataf,  24,   0, w3,  w25, w22);
   TEST_3RF("fsaf.w", dataf,  24,   8, w31, w3,  w0);
   TEST_3RF("fsaf.w", dataf,  24,  16, w16, w16, w16);
   TEST_3RF("fsaf.w", dataf,  24,  24, w30, w18, w12);
   TEST_3RF("fsaf.w", dataf,  24,  32, w7,  w14, w21);
   TEST_3RF("fsaf.w", dataf,  24,  40, w29, w7,  w0);
   TEST_3RF("fsaf.w", dataf,  24,  48, w14, w28, w15);
   TEST_3RF("fsaf.w", dataf,  24,  56, w3,  w11, w29);
   TEST_3RF("fsaf.w", dataf,  24,  64, w9,  w4,  w6);
   TEST_3RF("fsaf.w", dataf,  24,  72, w14, w8,  w25);
   TEST_3RF("fsaf.w", dataf,  32,   0, w25, w11, w19);
   TEST_3RF("fsaf.w", dataf,  32,   8, w15, w10, w22);
   TEST_3RF("fsaf.w", dataf,  32,  16, w15, w26, w20);
   TEST_3RF("fsaf.w", dataf,  32,  24, w1,  w12, w9);
   TEST_3RF("fsaf.w", dataf,  32,  32, w27, w27, w22);
   TEST_3RF("fsaf.w", dataf,  32,  40, w6,  w2,  w23);
   TEST_3RF("fsaf.w", dataf,  32,  48, w20, w30, w30);
   TEST_3RF("fsaf.w", dataf,  32,  56, w6,  w23, w9);
   TEST_3RF("fsaf.w", dataf,  32,  64, w3,  w0,  w13);
   TEST_3RF("fsaf.w", dataf,  32,  72, w7,  w6,  w28);
   TEST_3RF("fsaf.w", dataf,  40,   0, w16, w16, w16);
   TEST_3RF("fsaf.w", dataf,  40,   8, w0,  w21, w27);
   TEST_3RF("fsaf.w", dataf,  40,  16, w19, w4,  w6);
   TEST_3RF("fsaf.w", dataf,  40,  24, w9,  w20, w0);
   TEST_3RF("fsaf.w", dataf,  40,  32, w29, w21, w13);
   TEST_3RF("fsaf.w", dataf,  40,  40, w30, w8,  w21);
   TEST_3RF("fsaf.w", dataf,  40,  48, w4,  w10, w12);
   TEST_3RF("fsaf.w", dataf,  40,  56, w25, w8,  w18);
   TEST_3RF("fsaf.w", dataf,  40,  64, w16, w16, w16);
   TEST_3RF("fsaf.w", dataf,  40,  72, w17, w21, w30);
   TEST_3RF("fsaf.w", dataf,  48,   0, w28, w23, w26);
   TEST_3RF("fsaf.w", dataf,  48,   8, w12, w23, w15);
   TEST_3RF("fsaf.w", dataf,  48,  16, w8,  w10, w20);
   TEST_3RF("fsaf.w", dataf,  48,  24, w14, w19, w8);
   TEST_3RF("fsaf.w", dataf,  48,  32, w14, w17, w29);
   TEST_3RF("fsaf.w", dataf,  48,  40, w27, w27, w15);
   TEST_3RF("fsaf.w", dataf,  48,  48, w28, w3,  w4);
   TEST_3RF("fsaf.w", dataf,  48,  56, w0,  w13, w16);
   TEST_3RF("fsaf.w", dataf,  48,  64, w25, w21, w2);
   TEST_3RF("fsaf.w", dataf,  48,  72, w10, w6,  w23);
   TEST_3RF("fsaf.w", dataf,  56,   0, w27, w27, w5);
   TEST_3RF("fsaf.w", dataf,  56,   8, w20, w18, w18);
   TEST_3RF("fsaf.w", dataf,  56,  16, w31, w0,  w10);
   TEST_3RF("fsaf.w", dataf,  56,  24, w15, w8,  w20);
   TEST_3RF("fsaf.w", dataf,  56,  32, w3,  w22, w8);
   TEST_3RF("fsaf.w", dataf,  56,  40, w11, w5,  w25);
   TEST_3RF("fsaf.w", dataf,  56,  48, w8,  w0,  w4);
   TEST_3RF("fsaf.w", dataf,  56,  56, w4,  w13, w5);
   TEST_3RF("fsaf.w", dataf,  56,  64, w17, w29, w30);
   TEST_3RF("fsaf.w", dataf,  56,  72, w7,  w0,  w8);
   TEST_3RF("fsaf.w", dataf,  64,   0, w13, w23, w3);
   TEST_3RF("fsaf.w", dataf,  64,   8, w18, w11, w22);
   TEST_3RF("fsaf.w", dataf,  64,  16, w18, w12, w0);
   TEST_3RF("fsaf.w", dataf,  64,  24, w1,  w20, w4);
   TEST_3RF("fsaf.w", dataf,  64,  32, w11, w28, w15);
   TEST_3RF("fsaf.w", dataf,  64,  40, w16, w16, w16);
   TEST_3RF("fsaf.w", dataf,  64,  48, w21, w23, w16);
   TEST_3RF("fsaf.w", dataf,  64,  56, w30, w28, w20);
   TEST_3RF("fsaf.w", dataf,  64,  64, w11, w1,  w6);
   TEST_3RF("fsaf.w", dataf,  64,  72, w8,  w31, w13);
   TEST_3RF("fsaf.w", dataf,  72,   0, w8,  w26, w0);
   TEST_3RF("fsaf.w", dataf,  72,   8, w11, w13, w1);
   TEST_3RF("fsaf.w", dataf,  72,  16, w31, w23, w1);
   TEST_3RF("fsaf.w", dataf,  72,  24, w0,  w12, w22);
   TEST_3RF("fsaf.w", dataf,  72,  32, w4,  w23, w18);
   TEST_3RF("fsaf.w", dataf,  72,  40, w19, w7,  w8);
   TEST_3RF("fsaf.w", dataf,  72,  48, w10, w23, w6);
   TEST_3RF("fsaf.w", dataf,  72,  56, w6,  w12, w17);
   TEST_3RF("fsaf.w", dataf,  72,  64, w7,  w18, w25);
   TEST_3RF("fsaf.w", dataf,  72,  72, w7,  w31, w2);
   TEST_3RF("fsaf.d", datad,   0,   0, w15, w25, w2);
   TEST_3RF("fsaf.d", datad,   0,  16, w26, w6,  w26);
   TEST_3RF("fsaf.d", datad,   0,  32, w13, w28, w5);
   TEST_3RF("fsaf.d", datad,   0,  48, w5,  w29, w17);
   TEST_3RF("fsaf.d", datad,   0,  64, w19, w9,  w8);
   TEST_3RF("fsaf.d", datad,   0,  80, w6,  w28, w15);
   TEST_3RF("fsaf.d", datad,   0,  96, w14, w7,  w6);
   TEST_3RF("fsaf.d", datad,   0, 112, w20, w13, w13);
   TEST_3RF("fsaf.d", datad,   0, 128, w18, w5,  w21);
   TEST_3RF("fsaf.d", datad,   0, 144, w4,  w30, w28);
   TEST_3RF("fsaf.d", datad,  16,   0, w3,  w0,  w11);
   TEST_3RF("fsaf.d", datad,  16,  16, w29, w2,  w5);
   TEST_3RF("fsaf.d", datad,  16,  32, w3,  w16, w1);
   TEST_3RF("fsaf.d", datad,  16,  48, w9,  w21, w31);
   TEST_3RF("fsaf.d", datad,  16,  64, w14, w6,  w18);
   TEST_3RF("fsaf.d", datad,  16,  80, w24, w14, w20);
   TEST_3RF("fsaf.d", datad,  16,  96, w29, w6,  w27);
   TEST_3RF("fsaf.d", datad,  16, 112, w3,  w26, w9);
   TEST_3RF("fsaf.d", datad,  16, 128, w22, w31, w30);
   TEST_3RF("fsaf.d", datad,  16, 144, w26, w30, w26);
   TEST_3RF("fsaf.d", datad,  32,   0, w26, w30, w26);
   TEST_3RF("fsaf.d", datad,  32,  16, w30, w5,  w27);
   TEST_3RF("fsaf.d", datad,  32,  32, w1,  w10, w30);
   TEST_3RF("fsaf.d", datad,  32,  48, w17, w12, w7);
   TEST_3RF("fsaf.d", datad,  32,  64, w6,  w11, w22);
   TEST_3RF("fsaf.d", datad,  32,  80, w12, w29, w14);
   TEST_3RF("fsaf.d", datad,  32,  96, w26, w22, w26);
   TEST_3RF("fsaf.d", datad,  32, 112, w2,  w23, w28);
   TEST_3RF("fsaf.d", datad,  32, 128, w30, w26, w23);
   TEST_3RF("fsaf.d", datad,  32, 144, w7,  w16, w22);
   TEST_3RF("fsaf.d", datad,  48,   0, w5,  w11, w20);
   TEST_3RF("fsaf.d", datad,  48,  16, w31, w9,  w19);
   TEST_3RF("fsaf.d", datad,  48,  32, w4,  w20, w14);
   TEST_3RF("fsaf.d", datad,  48,  48, w2,  w5,  w26);
   TEST_3RF("fsaf.d", datad,  48,  64, w10, w11, w5);
   TEST_3RF("fsaf.d", datad,  48,  80, w0,  w23, w3);
   TEST_3RF("fsaf.d", datad,  48,  96, w14, w17, w25);
   TEST_3RF("fsaf.d", datad,  48, 112, w16, w16, w16);
   TEST_3RF("fsaf.d", datad,  48, 128, w8,  w21, w14);
   TEST_3RF("fsaf.d", datad,  48, 144, w2,  w12, w21);
   TEST_3RF("fsaf.d", datad,  64,   0, w19, w3,  w26);
   TEST_3RF("fsaf.d", datad,  64,  16, w30, w23, w25);
   TEST_3RF("fsaf.d", datad,  64,  32, w7,  w10, w29);
   TEST_3RF("fsaf.d", datad,  64,  48, w11, w30, w12);
   TEST_3RF("fsaf.d", datad,  64,  64, w13, w3,  w6);
   TEST_3RF("fsaf.d", datad,  64,  80, w23, w14, w12);
   TEST_3RF("fsaf.d", datad,  64,  96, w23, w5,  w15);
   TEST_3RF("fsaf.d", datad,  64, 112, w5,  w22, w8);
   TEST_3RF("fsaf.d", datad,  64, 128, w22, w30, w29);
   TEST_3RF("fsaf.d", datad,  64, 144, w4,  w1,  w10);
   TEST_3RF("fsaf.d", datad,  80,   0, w26, w20, w26);
   TEST_3RF("fsaf.d", datad,  80,  16, w13, w20, w18);
   TEST_3RF("fsaf.d", datad,  80,  32, w4,  w14, w25);
   TEST_3RF("fsaf.d", datad,  80,  48, w15, w11, w4);
   TEST_3RF("fsaf.d", datad,  80,  64, w13, w23, w17);
   TEST_3RF("fsaf.d", datad,  80,  80, w17, w30, w9);
   TEST_3RF("fsaf.d", datad,  80,  96, w31, w10, w0);
   TEST_3RF("fsaf.d", datad,  80, 112, w5,  w25, w6);
   TEST_3RF("fsaf.d", datad,  80, 128, w27, w27, w1);
   TEST_3RF("fsaf.d", datad,  80, 144, w28, w26, w30);
   TEST_3RF("fsaf.d", datad,  96,   0, w0,  w27, w8);
   TEST_3RF("fsaf.d", datad,  96,  16, w26, w15, w26);
   TEST_3RF("fsaf.d", datad,  96,  32, w21, w15, w1);
   TEST_3RF("fsaf.d", datad,  96,  48, w26, w29, w26);
   TEST_3RF("fsaf.d", datad,  96,  64, w26, w9,  w26);
   TEST_3RF("fsaf.d", datad,  96,  80, w8,  w30, w22);
   TEST_3RF("fsaf.d", datad,  96,  96, w0,  w15, w7);
   TEST_3RF("fsaf.d", datad,  96, 112, w30, w24, w7);
   TEST_3RF("fsaf.d", datad,  96, 128, w8,  w25, w12);
   TEST_3RF("fsaf.d", datad,  96, 144, w1,  w31, w7);
   TEST_3RF("fsaf.d", datad, 112,   0, w2,  w27, w1);
   TEST_3RF("fsaf.d", datad, 112,  16, w0,  w27, w28);
   TEST_3RF("fsaf.d", datad, 112,  32, w9,  w22, w11);
   TEST_3RF("fsaf.d", datad, 112,  48, w30, w5,  w12);
   TEST_3RF("fsaf.d", datad, 112,  64, w24, w2,  w6);
   TEST_3RF("fsaf.d", datad, 112,  80, w1,  w10, w4);
   TEST_3RF("fsaf.d", datad, 112,  96, w24, w10, w20);
   TEST_3RF("fsaf.d", datad, 112, 112, w31, w8,  w12);
   TEST_3RF("fsaf.d", datad, 112, 128, w6,  w16, w5);
   TEST_3RF("fsaf.d", datad, 112, 144, w18, w17, w4);
   TEST_3RF("fsaf.d", datad, 128,   0, w26, w19, w26);
   TEST_3RF("fsaf.d", datad, 128,  16, w31, w27, w20);
   TEST_3RF("fsaf.d", datad, 128,  32, w27, w27, w24);
   TEST_3RF("fsaf.d", datad, 128,  48, w29, w17, w3);
   TEST_3RF("fsaf.d", datad, 128,  64, w27, w27, w22);
   TEST_3RF("fsaf.d", datad, 128,  80, w16, w16, w16);
   TEST_3RF("fsaf.d", datad, 128,  96, w20, w24, w24);
   TEST_3RF("fsaf.d", datad, 128, 112, w22, w21, w2);
   TEST_3RF("fsaf.d", datad, 128, 128, w27, w27, w13);
   TEST_3RF("fsaf.d", datad, 128, 144, w13, w15, w21);
   TEST_3RF("fsaf.d", datad, 144,   0, w27, w27, w19);
   TEST_3RF("fsaf.d", datad, 144,  16, w6,  w1,  w23);
   TEST_3RF("fsaf.d", datad, 144,  32, w5,  w0,  w11);
   TEST_3RF("fsaf.d", datad, 144,  48, w5,  w27, w31);
   TEST_3RF("fsaf.d", datad, 144,  64, w0,  w19, w28);
   TEST_3RF("fsaf.d", datad, 144,  80, w17, w23, w7);
   TEST_3RF("fsaf.d", datad, 144,  96, w7,  w11, w31);
   TEST_3RF("fsaf.d", datad, 144, 112, w29, w1,  w24);
   TEST_3RF("fsaf.d", datad, 144, 128, w14, w7,  w27);
   TEST_3RF("fsaf.d", datad, 144, 144, w4,  w3,  w15);
   TEST_3RF("fseq.w", dataf,   0,   0, w9,  w21, w12);
   TEST_3RF("fseq.w", dataf,   0,   8, w14, w16, w11);
   TEST_3RF("fseq.w", dataf,   0,  16, w14, w4,  w7);
   TEST_3RF("fseq.w", dataf,   0,  24, w31, w27, w6);
   TEST_3RF("fseq.w", dataf,   0,  32, w2,  w10, w5);
   TEST_3RF("fseq.w", dataf,   0,  40, w31, w11, w7);
   TEST_3RF("fseq.w", dataf,   0,  48, w24, w26, w21);
   TEST_3RF("fseq.w", dataf,   0,  56, w31, w21, w25);
   TEST_3RF("fseq.w", dataf,   0,  64, w2,  w4,  w3);
   TEST_3RF("fseq.w", dataf,   0,  72, w6,  w25, w5);
   TEST_3RF("fseq.w", dataf,   8,   0, w16, w14, w17);
   TEST_3RF("fseq.w", dataf,   8,   8, w30, w31, w29);
   TEST_3RF("fseq.w", dataf,   8,  16, w13, w3,  w4);
   TEST_3RF("fseq.w", dataf,   8,  24, w12, w30, w3);
   TEST_3RF("fseq.w", dataf,   8,  32, w19, w0,  w14);
   TEST_3RF("fseq.w", dataf,   8,  40, w24, w31, w25);
   TEST_3RF("fseq.w", dataf,   8,  48, w31, w23, w19);
   TEST_3RF("fseq.w", dataf,   8,  56, w21, w23, w21);
   TEST_3RF("fseq.w", dataf,   8,  64, w9,  w14, w25);
   TEST_3RF("fseq.w", dataf,   8,  72, w13, w18, w0);
   TEST_3RF("fseq.w", dataf,  16,   0, w7,  w23, w16);
   TEST_3RF("fseq.w", dataf,  16,   8, w21, w8,  w21);
   TEST_3RF("fseq.w", dataf,  16,  16, w14, w20, w5);
   TEST_3RF("fseq.w", dataf,  16,  24, w27, w23, w10);
   TEST_3RF("fseq.w", dataf,  16,  32, w8,  w21, w13);
   TEST_3RF("fseq.w", dataf,  16,  40, w27, w21, w19);
   TEST_3RF("fseq.w", dataf,  16,  48, w21, w19, w21);
   TEST_3RF("fseq.w", dataf,  16,  56, w12, w8,  w3);
   TEST_3RF("fseq.w", dataf,  16,  64, w17, w22, w29);
   TEST_3RF("fseq.w", dataf,  16,  72, w31, w8,  w29);
   TEST_3RF("fseq.w", dataf,  24,   0, w6,  w31, w13);
   TEST_3RF("fseq.w", dataf,  24,   8, w27, w8,  w16);
   TEST_3RF("fseq.w", dataf,  24,  16, w13, w23, w7);
   TEST_3RF("fseq.w", dataf,  24,  24, w23, w31, w29);
   TEST_3RF("fseq.w", dataf,  24,  32, w5,  w26, w18);
   TEST_3RF("fseq.w", dataf,  24,  40, w0,  w13, w7);
   TEST_3RF("fseq.w", dataf,  24,  48, w21, w0,  w21);
   TEST_3RF("fseq.w", dataf,  24,  56, w20, w30, w8);
   TEST_3RF("fseq.w", dataf,  24,  64, w23, w15, w31);
   TEST_3RF("fseq.w", dataf,  24,  72, w20, w14, w7);
   TEST_3RF("fseq.w", dataf,  32,   0, w17, w20, w7);
   TEST_3RF("fseq.w", dataf,  32,   8, w30, w16, w15);
   TEST_3RF("fseq.w", dataf,  32,  16, w26, w0,  w28);
   TEST_3RF("fseq.w", dataf,  32,  24, w17, w7,  w20);
   TEST_3RF("fseq.w", dataf,  32,  32, w16, w4,  w25);
   TEST_3RF("fseq.w", dataf,  32,  40, w10, w10, w10);
   TEST_3RF("fseq.w", dataf,  32,  48, w23, w25, w30);
   TEST_3RF("fseq.w", dataf,  32,  56, w15, w24, w18);
   TEST_3RF("fseq.w", dataf,  32,  64, w13, w0,  w10);
   TEST_3RF("fseq.w", dataf,  32,  72, w28, w31, w30);
   TEST_3RF("fseq.w", dataf,  40,   0, w11, w7,  w16);
   TEST_3RF("fseq.w", dataf,  40,   8, w31, w14, w15);
   TEST_3RF("fseq.w", dataf,  40,  16, w29, w8,  w15);
   TEST_3RF("fseq.w", dataf,  40,  24, w25, w23, w13);
   TEST_3RF("fseq.w", dataf,  40,  32, w9,  w27, w6);
   TEST_3RF("fseq.w", dataf,  40,  40, w19, w18, w0);
   TEST_3RF("fseq.w", dataf,  40,  48, w11, w17, w15);
   TEST_3RF("fseq.w", dataf,  40,  56, w3,  w28, w13);
   TEST_3RF("fseq.w", dataf,  40,  64, w24, w3,  w12);
   TEST_3RF("fseq.w", dataf,  40,  72, w3,  w10, w28);
   TEST_3RF("fseq.w", dataf,  48,   0, w3,  w24, w10);
   TEST_3RF("fseq.w", dataf,  48,   8, w18, w21, w19);
   TEST_3RF("fseq.w", dataf,  48,  16, w2,  w14, w12);
   TEST_3RF("fseq.w", dataf,  48,  24, w25, w28, w22);
   TEST_3RF("fseq.w", dataf,  48,  32, w20, w2,  w9);
   TEST_3RF("fseq.w", dataf,  48,  40, w7,  w2,  w20);
   TEST_3RF("fseq.w", dataf,  48,  48, w24, w17, w23);
   TEST_3RF("fseq.w", dataf,  48,  56, w27, w13, w9);
   TEST_3RF("fseq.w", dataf,  48,  64, w6,  w30, w21);
   TEST_3RF("fseq.w", dataf,  48,  72, w9,  w8,  w17);
   TEST_3RF("fseq.w", dataf,  56,   0, w12, w0,  w27);
   TEST_3RF("fseq.w", dataf,  56,   8, w31, w21, w14);
   TEST_3RF("fseq.w", dataf,  56,  16, w1,  w3,  w3);
   TEST_3RF("fseq.w", dataf,  56,  24, w27, w26, w31);
   TEST_3RF("fseq.w", dataf,  56,  32, w17, w14, w2);
   TEST_3RF("fseq.w", dataf,  56,  40, w26, w21, w4);
   TEST_3RF("fseq.w", dataf,  56,  48, w15, w13, w22);
   TEST_3RF("fseq.w", dataf,  56,  56, w6,  w9,  w3);
   TEST_3RF("fseq.w", dataf,  56,  64, w1,  w18, w18);
   TEST_3RF("fseq.w", dataf,  56,  72, w9,  w31, w7);
   TEST_3RF("fseq.w", dataf,  64,   0, w19, w7,  w24);
   TEST_3RF("fseq.w", dataf,  64,   8, w31, w7,  w19);
   TEST_3RF("fseq.w", dataf,  64,  16, w30, w28, w2);
   TEST_3RF("fseq.w", dataf,  64,  24, w31, w0,  w29);
   TEST_3RF("fseq.w", dataf,  64,  32, w25, w31, w14);
   TEST_3RF("fseq.w", dataf,  64,  40, w8,  w1,  w29);
   TEST_3RF("fseq.w", dataf,  64,  48, w6,  w23, w11);
   TEST_3RF("fseq.w", dataf,  64,  56, w28, w30, w20);
   TEST_3RF("fseq.w", dataf,  64,  64, w31, w6,  w9);
   TEST_3RF("fseq.w", dataf,  64,  72, w31, w13, w28);
   TEST_3RF("fseq.w", dataf,  72,   0, w6,  w5,  w27);
   TEST_3RF("fseq.w", dataf,  72,   8, w14, w24, w26);
   TEST_3RF("fseq.w", dataf,  72,  16, w10, w10, w10);
   TEST_3RF("fseq.w", dataf,  72,  24, w26, w25, w10);
   TEST_3RF("fseq.w", dataf,  72,  32, w23, w19, w10);
   TEST_3RF("fseq.w", dataf,  72,  40, w5,  w27, w11);
   TEST_3RF("fseq.w", dataf,  72,  48, w14, w24, w17);
   TEST_3RF("fseq.w", dataf,  72,  56, w5,  w3,  w13);
   TEST_3RF("fseq.w", dataf,  72,  64, w3,  w23, w13);
   TEST_3RF("fseq.w", dataf,  72,  72, w3,  w29, w22);
   TEST_3RF("fseq.d", datad,   0,   0, w2,  w10, w18);
   TEST_3RF("fseq.d", datad,   0,  16, w8,  w15, w13);
   TEST_3RF("fseq.d", datad,   0,  32, w22, w8,  w7);
   TEST_3RF("fseq.d", datad,   0,  48, w1,  w2,  w2);
   TEST_3RF("fseq.d", datad,   0,  64, w1,  w11, w11);
   TEST_3RF("fseq.d", datad,   0,  80, w26, w20, w21);
   TEST_3RF("fseq.d", datad,   0,  96, w31, w15, w1);
   TEST_3RF("fseq.d", datad,   0, 112, w13, w7,  w18);
   TEST_3RF("fseq.d", datad,   0, 128, w19, w11, w0);
   TEST_3RF("fseq.d", datad,   0, 144, w22, w2,  w13);
   TEST_3RF("fseq.d", datad,  16,   0, w25, w0,  w3);
   TEST_3RF("fseq.d", datad,  16,  16, w27, w10, w21);
   TEST_3RF("fseq.d", datad,  16,  32, w4,  w4,  w26);
   TEST_3RF("fseq.d", datad,  16,  48, w2,  w26, w10);
   TEST_3RF("fseq.d", datad,  16,  64, w27, w4,  w11);
   TEST_3RF("fseq.d", datad,  16,  80, w7,  w30, w31);
   TEST_3RF("fseq.d", datad,  16,  96, w28, w30, w14);
   TEST_3RF("fseq.d", datad,  16, 112, w29, w11, w21);
   TEST_3RF("fseq.d", datad,  16, 128, w16, w30, w0);
   TEST_3RF("fseq.d", datad,  16, 144, w16, w21, w3);
   TEST_3RF("fseq.d", datad,  32,   0, w29, w14, w3);
   TEST_3RF("fseq.d", datad,  32,  16, w0,  w10, w13);
   TEST_3RF("fseq.d", datad,  32,  32, w21, w14, w21);
   TEST_3RF("fseq.d", datad,  32,  48, w7,  w23, w8);
   TEST_3RF("fseq.d", datad,  32,  64, w9,  w1,  w4);
   TEST_3RF("fseq.d", datad,  32,  80, w14, w12, w11);
   TEST_3RF("fseq.d", datad,  32,  96, w12, w11, w7);
   TEST_3RF("fseq.d", datad,  32, 112, w10, w10, w10);
   TEST_3RF("fseq.d", datad,  32, 128, w25, w5,  w22);
   TEST_3RF("fseq.d", datad,  32, 144, w15, w21, w20);
   TEST_3RF("fseq.d", datad,  48,   0, w15, w5,  w9);
   TEST_3RF("fseq.d", datad,  48,  16, w18, w2,  w24);
   TEST_3RF("fseq.d", datad,  48,  32, w21, w2,  w21);
   TEST_3RF("fseq.d", datad,  48,  48, w2,  w3,  w23);
   TEST_3RF("fseq.d", datad,  48,  64, w16, w10, w14);
   TEST_3RF("fseq.d", datad,  48,  80, w24, w20, w16);
   TEST_3RF("fseq.d", datad,  48,  96, w28, w2,  w7);
   TEST_3RF("fseq.d", datad,  48, 112, w14, w8,  w15);
   TEST_3RF("fseq.d", datad,  48, 128, w25, w1,  w20);
   TEST_3RF("fseq.d", datad,  48, 144, w15, w16, w9);
   TEST_3RF("fseq.d", datad,  64,   0, w3,  w0,  w14);
   TEST_3RF("fseq.d", datad,  64,  16, w13, w18, w16);
   TEST_3RF("fseq.d", datad,  64,  32, w5,  w8,  w18);
   TEST_3RF("fseq.d", datad,  64,  48, w7,  w11, w9);
   TEST_3RF("fseq.d", datad,  64,  64, w23, w21, w15);
   TEST_3RF("fseq.d", datad,  64,  80, w9,  w7,  w12);
   TEST_3RF("fseq.d", datad,  64,  96, w11, w4,  w19);
   TEST_3RF("fseq.d", datad,  64, 112, w26, w12, w2);
   TEST_3RF("fseq.d", datad,  64, 128, w19, w13, w22);
   TEST_3RF("fseq.d", datad,  64, 144, w2,  w30, w31);
   TEST_3RF("fseq.d", datad,  80,   0, w5,  w30, w13);
   TEST_3RF("fseq.d", datad,  80,  16, w18, w16, w29);
   TEST_3RF("fseq.d", datad,  80,  32, w23, w24, w15);
   TEST_3RF("fseq.d", datad,  80,  48, w30, w3,  w24);
   TEST_3RF("fseq.d", datad,  80,  64, w21, w25, w21);
   TEST_3RF("fseq.d", datad,  80,  80, w16, w5,  w2);
   TEST_3RF("fseq.d", datad,  80,  96, w23, w17, w14);
   TEST_3RF("fseq.d", datad,  80, 112, w27, w4,  w8);
   TEST_3RF("fseq.d", datad,  80, 128, w7,  w27, w21);
   TEST_3RF("fseq.d", datad,  80, 144, w29, w19, w2);
   TEST_3RF("fseq.d", datad,  96,   0, w17, w10, w21);
   TEST_3RF("fseq.d", datad,  96,  16, w1,  w8,  w8);
   TEST_3RF("fseq.d", datad,  96,  32, w12, w26, w23);
   TEST_3RF("fseq.d", datad,  96,  48, w11, w29, w16);
   TEST_3RF("fseq.d", datad,  96,  64, w0,  w22, w5);
   TEST_3RF("fseq.d", datad,  96,  80, w25, w23, w22);
   TEST_3RF("fseq.d", datad,  96,  96, w7,  w19, w27);
   TEST_3RF("fseq.d", datad,  96, 112, w15, w26, w2);
   TEST_3RF("fseq.d", datad,  96, 128, w10, w10, w10);
   TEST_3RF("fseq.d", datad,  96, 144, w15, w31, w7);
   TEST_3RF("fseq.d", datad, 112,   0, w2,  w28, w9);
   TEST_3RF("fseq.d", datad, 112,  16, w19, w7,  w30);
   TEST_3RF("fseq.d", datad, 112,  32, w21, w15, w21);
   TEST_3RF("fseq.d", datad, 112,  48, w11, w15, w6);
   TEST_3RF("fseq.d", datad, 112,  64, w22, w12, w3);
   TEST_3RF("fseq.d", datad, 112,  80, w22, w28, w14);
   TEST_3RF("fseq.d", datad, 112,  96, w18, w3,  w1);
   TEST_3RF("fseq.d", datad, 112, 112, w13, w18, w27);
   TEST_3RF("fseq.d", datad, 112, 128, w15, w28, w11);
   TEST_3RF("fseq.d", datad, 112, 144, w15, w3,  w13);
   TEST_3RF("fseq.d", datad, 128,   0, w11, w12, w1);
   TEST_3RF("fseq.d", datad, 128,  16, w18, w11, w22);
   TEST_3RF("fseq.d", datad, 128,  32, w1,  w22, w22);
   TEST_3RF("fseq.d", datad, 128,  48, w5,  w8,  w12);
   TEST_3RF("fseq.d", datad, 128,  64, w17, w30, w2);
   TEST_3RF("fseq.d", datad, 128,  80, w20, w21, w30);
   TEST_3RF("fseq.d", datad, 128,  96, w16, w3,  w17);
   TEST_3RF("fseq.d", datad, 128, 112, w19, w4,  w30);
   TEST_3RF("fseq.d", datad, 128, 128, w5,  w31, w14);
   TEST_3RF("fseq.d", datad, 128, 144, w1,  w10, w10);
   TEST_3RF("fseq.d", datad, 144,   0, w29, w4,  w24);
   TEST_3RF("fseq.d", datad, 144,  16, w8,  w17, w25);
   TEST_3RF("fseq.d", datad, 144,  32, w27, w28, w15);
   TEST_3RF("fseq.d", datad, 144,  48, w28, w18, w20);
   TEST_3RF("fseq.d", datad, 144,  64, w4,  w4,  w30);
   TEST_3RF("fseq.d", datad, 144,  80, w5,  w3,  w0);
   TEST_3RF("fseq.d", datad, 144,  96, w26, w24, w31);
   TEST_3RF("fseq.d", datad, 144, 112, w10, w10, w10);
   TEST_3RF("fseq.d", datad, 144, 128, w27, w16, w30);
   TEST_3RF("fseq.d", datad, 144, 144, w31, w14, w3);
   TEST_3RF("fsle.w", dataf,   0,   0, w25, w9,  w1);
   TEST_3RF("fsle.w", dataf,   0,   8, w2,  w26, w29);
   TEST_3RF("fsle.w", dataf,   0,  16, w22, w9,  w25);
   TEST_3RF("fsle.w", dataf,   0,  24, w8,  w29, w30);
   TEST_3RF("fsle.w", dataf,   0,  32, w6,  w2,  w1);
   TEST_3RF("fsle.w", dataf,   0,  40, w7,  w28, w25);
   TEST_3RF("fsle.w", dataf,   0,  48, w6,  w7,  w20);
   TEST_3RF("fsle.w", dataf,   0,  56, w22, w5,  w19);
   TEST_3RF("fsle.w", dataf,   0,  64, w4,  w8,  w17);
   TEST_3RF("fsle.w", dataf,   0,  72, w1,  w13, w26);
   TEST_3RF("fsle.w", dataf,   8,   0, w26, w23, w27);
   TEST_3RF("fsle.w", dataf,   8,   8, w28, w28, w17);
   TEST_3RF("fsle.w", dataf,   8,  16, w21, w25, w8);
   TEST_3RF("fsle.w", dataf,   8,  24, w30, w30, w30);
   TEST_3RF("fsle.w", dataf,   8,  32, w19, w16, w27);
   TEST_3RF("fsle.w", dataf,   8,  40, w17, w23, w30);
   TEST_3RF("fsle.w", dataf,   8,  48, w18, w30, w26);
   TEST_3RF("fsle.w", dataf,   8,  56, w11, w4,  w1);
   TEST_3RF("fsle.w", dataf,   8,  64, w31, w26, w6);
   TEST_3RF("fsle.w", dataf,   8,  72, w18, w30, w15);
   TEST_3RF("fsle.w", dataf,  16,   0, w3,  w31, w28);
   TEST_3RF("fsle.w", dataf,  16,   8, w30, w30, w30);
   TEST_3RF("fsle.w", dataf,  16,  16, w26, w19, w25);
   TEST_3RF("fsle.w", dataf,  16,  24, w22, w5,  w15);
   TEST_3RF("fsle.w", dataf,  16,  32, w16, w13, w3);
   TEST_3RF("fsle.w", dataf,  16,  40, w29, w9,  w20);
   TEST_3RF("fsle.w", dataf,  16,  48, w20, w7,  w6);
   TEST_3RF("fsle.w", dataf,  16,  56, w18, w1,  w17);
   TEST_3RF("fsle.w", dataf,  16,  64, w22, w3,  w16);
   TEST_3RF("fsle.w", dataf,  16,  72, w16, w9,  w2);
   TEST_3RF("fsle.w", dataf,  24,   0, w15, w24, w5);
   TEST_3RF("fsle.w", dataf,  24,   8, w14, w21, w3);
   TEST_3RF("fsle.w", dataf,  24,  16, w8,  w29, w31);
   TEST_3RF("fsle.w", dataf,  24,  24, w13, w12, w15);
   TEST_3RF("fsle.w", dataf,  24,  32, w26, w25, w18);
   TEST_3RF("fsle.w", dataf,  24,  40, w24, w2,  w6);
   TEST_3RF("fsle.w", dataf,  24,  48, w12, w9,  w31);
   TEST_3RF("fsle.w", dataf,  24,  56, w11, w29, w21);
   TEST_3RF("fsle.w", dataf,  24,  64, w14, w13, w6);
   TEST_3RF("fsle.w", dataf,  24,  72, w23, w15, w21);
   TEST_3RF("fsle.w", dataf,  32,   0, w16, w20, w3);
   TEST_3RF("fsle.w", dataf,  32,   8, w5,  w24, w5);
   TEST_3RF("fsle.w", dataf,  32,  16, w12, w13, w21);
   TEST_3RF("fsle.w", dataf,  32,  24, w11, w27, w1);
   TEST_3RF("fsle.w", dataf,  32,  32, w26, w21, w12);
   TEST_3RF("fsle.w", dataf,  32,  40, w13, w29, w18);
   TEST_3RF("fsle.w", dataf,  32,  48, w26, w6,  w30);
   TEST_3RF("fsle.w", dataf,  32,  56, w25, w17, w27);
   TEST_3RF("fsle.w", dataf,  32,  64, w14, w31, w8);
   TEST_3RF("fsle.w", dataf,  32,  72, w20, w23, w9);
   TEST_3RF("fsle.w", dataf,  40,   0, w7,  w11, w13);
   TEST_3RF("fsle.w", dataf,  40,   8, w12, w3,  w25);
   TEST_3RF("fsle.w", dataf,  40,  16, w25, w24, w4);
   TEST_3RF("fsle.w", dataf,  40,  24, w20, w25, w30);
   TEST_3RF("fsle.w", dataf,  40,  32, w10, w20, w23);
   TEST_3RF("fsle.w", dataf,  40,  40, w17, w28, w23);
   TEST_3RF("fsle.w", dataf,  40,  48, w26, w10, w9);
   TEST_3RF("fsle.w", dataf,  40,  56, w21, w25, w8);
   TEST_3RF("fsle.w", dataf,  40,  64, w29, w13, w31);
   TEST_3RF("fsle.w", dataf,  40,  72, w20, w23, w6);
   TEST_3RF("fsle.w", dataf,  48,   0, w31, w4,  w18);
   TEST_3RF("fsle.w", dataf,  48,   8, w3,  w29, w12);
   TEST_3RF("fsle.w", dataf,  48,  16, w27, w1,  w0);
   TEST_3RF("fsle.w", dataf,  48,  24, w21, w31, w10);
   TEST_3RF("fsle.w", dataf,  48,  32, w9,  w2,  w2);
   TEST_3RF("fsle.w", dataf,  48,  40, w26, w5,  w19);
   TEST_3RF("fsle.w", dataf,  48,  48, w17, w31, w30);
   TEST_3RF("fsle.w", dataf,  48,  56, w26, w20, w23);
   TEST_3RF("fsle.w", dataf,  48,  64, w3,  w17, w4);
   TEST_3RF("fsle.w", dataf,  48,  72, w2,  w5,  w27);
   TEST_3RF("fsle.w", dataf,  56,   0, w9,  w4,  w4);
   TEST_3RF("fsle.w", dataf,  56,   8, w31, w27, w7);
   TEST_3RF("fsle.w", dataf,  56,  16, w28, w28, w7);
   TEST_3RF("fsle.w", dataf,  56,  24, w3,  w29, w8);
   TEST_3RF("fsle.w", dataf,  56,  32, w24, w28, w18);
   TEST_3RF("fsle.w", dataf,  56,  40, w1,  w5,  w20);
   TEST_3RF("fsle.w", dataf,  56,  48, w27, w10, w8);
   TEST_3RF("fsle.w", dataf,  56,  56, w12, w9,  w6);
   TEST_3RF("fsle.w", dataf,  56,  64, w7,  w29, w10);
   TEST_3RF("fsle.w", dataf,  56,  72, w14, w1,  w12);
   TEST_3RF("fsle.w", dataf,  64,   0, w19, w29, w21);
   TEST_3RF("fsle.w", dataf,  64,   8, w24, w28, w17);
   TEST_3RF("fsle.w", dataf,  64,  16, w31, w25, w24);
   TEST_3RF("fsle.w", dataf,  64,  24, w2,  w22, w0);
   TEST_3RF("fsle.w", dataf,  64,  32, w26, w19, w27);
   TEST_3RF("fsle.w", dataf,  64,  40, w24, w7,  w22);
   TEST_3RF("fsle.w", dataf,  64,  48, w3,  w15, w12);
   TEST_3RF("fsle.w", dataf,  64,  56, w21, w10, w18);
   TEST_3RF("fsle.w", dataf,  64,  64, w20, w24, w0);
   TEST_3RF("fsle.w", dataf,  64,  72, w12, w17, w22);
   TEST_3RF("fsle.w", dataf,  72,   0, w4,  w13, w7);
   TEST_3RF("fsle.w", dataf,  72,   8, w3,  w6,  w31);
   TEST_3RF("fsle.w", dataf,  72,  16, w6,  w29, w0);
   TEST_3RF("fsle.w", dataf,  72,  24, w0,  w16, w19);
   TEST_3RF("fsle.w", dataf,  72,  32, w28, w28, w8);
   TEST_3RF("fsle.w", dataf,  72,  40, w26, w18, w11);
   TEST_3RF("fsle.w", dataf,  72,  48, w10, w21, w24);
   TEST_3RF("fsle.w", dataf,  72,  56, w31, w2,  w18);
   TEST_3RF("fsle.w", dataf,  72,  64, w19, w26, w6);
   TEST_3RF("fsle.w", dataf,  72,  72, w20, w6,  w23);
   TEST_3RF("fsle.d", datad,   0,   0, w10, w4,  w17);
   TEST_3RF("fsle.d", datad,   0,  16, w14, w11, w16);
   TEST_3RF("fsle.d", datad,   0,  32, w20, w8,  w16);
   TEST_3RF("fsle.d", datad,   0,  48, w20, w24, w3);
   TEST_3RF("fsle.d", datad,   0,  64, w16, w0,  w30);
   TEST_3RF("fsle.d", datad,   0,  80, w3,  w12, w8);
   TEST_3RF("fsle.d", datad,   0,  96, w24, w4,  w7);
   TEST_3RF("fsle.d", datad,   0, 112, w24, w6,  w25);
   TEST_3RF("fsle.d", datad,   0, 128, w11, w0,  w31);
   TEST_3RF("fsle.d", datad,   0, 144, w31, w7,  w22);
   TEST_3RF("fsle.d", datad,  16,   0, w9,  w17, w17);
   TEST_3RF("fsle.d", datad,  16,  16, w27, w26, w31);
   TEST_3RF("fsle.d", datad,  16,  32, w6,  w11, w19);
   TEST_3RF("fsle.d", datad,  16,  48, w14, w27, w8);
   TEST_3RF("fsle.d", datad,  16,  64, w6,  w31, w24);
   TEST_3RF("fsle.d", datad,  16,  80, w6,  w29, w27);
   TEST_3RF("fsle.d", datad,  16,  96, w18, w5,  w20);
   TEST_3RF("fsle.d", datad,  16, 112, w22, w12, w28);
   TEST_3RF("fsle.d", datad,  16, 128, w6,  w23, w29);
   TEST_3RF("fsle.d", datad,  16, 144, w5,  w23, w5);
   TEST_3RF("fsle.d", datad,  32,   0, w4,  w28, w0);
   TEST_3RF("fsle.d", datad,  32,  16, w21, w23, w27);
   TEST_3RF("fsle.d", datad,  32,  32, w21, w29, w6);
   TEST_3RF("fsle.d", datad,  32,  48, w8,  w11, w1);
   TEST_3RF("fsle.d", datad,  32,  64, w16, w17, w0);
   TEST_3RF("fsle.d", datad,  32,  80, w9,  w23, w23);
   TEST_3RF("fsle.d", datad,  32,  96, w29, w4,  w10);
   TEST_3RF("fsle.d", datad,  32, 112, w2,  w24, w0);
   TEST_3RF("fsle.d", datad,  32, 128, w15, w4,  w29);
   TEST_3RF("fsle.d", datad,  32, 144, w21, w28, w26);
   TEST_3RF("fsle.d", datad,  48,   0, w26, w19, w30);
   TEST_3RF("fsle.d", datad,  48,  16, w22, w19, w13);
   TEST_3RF("fsle.d", datad,  48,  32, w14, w8,  w10);
   TEST_3RF("fsle.d", datad,  48,  48, w20, w17, w21);
   TEST_3RF("fsle.d", datad,  48,  64, w22, w1,  w6);
   TEST_3RF("fsle.d", datad,  48,  80, w22, w10, w30);
   TEST_3RF("fsle.d", datad,  48,  96, w20, w15, w8);
   TEST_3RF("fsle.d", datad,  48, 112, w22, w7,  w8);
   TEST_3RF("fsle.d", datad,  48, 128, w5,  w12, w5);
   TEST_3RF("fsle.d", datad,  48, 144, w5,  w26, w5);
   TEST_3RF("fsle.d", datad,  64,   0, w8,  w31, w21);
   TEST_3RF("fsle.d", datad,  64,  16, w27, w29, w11);
   TEST_3RF("fsle.d", datad,  64,  32, w14, w17, w25);
   TEST_3RF("fsle.d", datad,  64,  48, w29, w25, w3);
   TEST_3RF("fsle.d", datad,  64,  64, w17, w10, w25);
   TEST_3RF("fsle.d", datad,  64,  80, w7,  w12, w31);
   TEST_3RF("fsle.d", datad,  64,  96, w30, w30, w30);
   TEST_3RF("fsle.d", datad,  64, 112, w22, w29, w18);
   TEST_3RF("fsle.d", datad,  64, 128, w5,  w8,  w5);
   TEST_3RF("fsle.d", datad,  64, 144, w13, w14, w25);
   TEST_3RF("fsle.d", datad,  80,   0, w19, w8,  w1);
   TEST_3RF("fsle.d", datad,  80,  16, w19, w29, w28);
   TEST_3RF("fsle.d", datad,  80,  32, w16, w9,  w10);
   TEST_3RF("fsle.d", datad,  80,  48, w1,  w2,  w7);
   TEST_3RF("fsle.d", datad,  80,  64, w27, w5,  w25);
   TEST_3RF("fsle.d", datad,  80,  80, w5,  w30, w5);
   TEST_3RF("fsle.d", datad,  80,  96, w0,  w17, w30);
   TEST_3RF("fsle.d", datad,  80, 112, w30, w30, w30);
   TEST_3RF("fsle.d", datad,  80, 128, w8,  w27, w16);
   TEST_3RF("fsle.d", datad,  80, 144, w13, w1,  w25);
   TEST_3RF("fsle.d", datad,  96,   0, w26, w15, w7);
   TEST_3RF("fsle.d", datad,  96,  16, w19, w2,  w15);
   TEST_3RF("fsle.d", datad,  96,  32, w20, w21, w13);
   TEST_3RF("fsle.d", datad,  96,  48, w16, w6,  w22);
   TEST_3RF("fsle.d", datad,  96,  64, w27, w7,  w24);
   TEST_3RF("fsle.d", datad,  96,  80, w2,  w29, w27);
   TEST_3RF("fsle.d", datad,  96,  96, w8,  w28, w25);
   TEST_3RF("fsle.d", datad,  96, 112, w26, w1,  w21);
   TEST_3RF("fsle.d", datad,  96, 128, w11, w15, w22);
   TEST_3RF("fsle.d", datad,  96, 144, w4,  w9,  w5);
   TEST_3RF("fsle.d", datad, 112,   0, w11, w29, w8);
   TEST_3RF("fsle.d", datad, 112,  16, w26, w17, w29);
   TEST_3RF("fsle.d", datad, 112,  32, w7,  w2,  w3);
   TEST_3RF("fsle.d", datad, 112,  48, w29, w11, w21);
   TEST_3RF("fsle.d", datad, 112,  64, w31, w13, w19);
   TEST_3RF("fsle.d", datad, 112,  80, w27, w21, w15);
   TEST_3RF("fsle.d", datad, 112,  96, w23, w15, w9);
   TEST_3RF("fsle.d", datad, 112, 112, w17, w16, w30);
   TEST_3RF("fsle.d", datad, 112, 128, w28, w28, w31);
   TEST_3RF("fsle.d", datad, 112, 144, w21, w0,  w9);
   TEST_3RF("fsle.d", datad, 128,   0, w26, w11, w6);
   TEST_3RF("fsle.d", datad, 128,  16, w2,  w6,  w23);
   TEST_3RF("fsle.d", datad, 128,  32, w0,  w13, w25);
   TEST_3RF("fsle.d", datad, 128,  48, w3,  w11, w22);
   TEST_3RF("fsle.d", datad, 128,  64, w14, w0,  w22);
   TEST_3RF("fsle.d", datad, 128,  80, w28, w28, w19);
   TEST_3RF("fsle.d", datad, 128,  96, w17, w2,  w8);
   TEST_3RF("fsle.d", datad, 128, 112, w0,  w11, w25);
   TEST_3RF("fsle.d", datad, 128, 128, w17, w10, w22);
   TEST_3RF("fsle.d", datad, 128, 144, w16, w31, w22);
   TEST_3RF("fsle.d", datad, 144,   0, w25, w2,  w31);
   TEST_3RF("fsle.d", datad, 144,  16, w28, w28, w8);
   TEST_3RF("fsle.d", datad, 144,  32, w23, w28, w21);
   TEST_3RF("fsle.d", datad, 144,  48, w16, w31, w0);
   TEST_3RF("fsle.d", datad, 144,  64, w7,  w14, w1);
   TEST_3RF("fsle.d", datad, 144,  80, w29, w10, w20);
   TEST_3RF("fsle.d", datad, 144,  96, w14, w27, w23);
   TEST_3RF("fsle.d", datad, 144, 112, w22, w28, w2);
   TEST_3RF("fsle.d", datad, 144, 128, w15, w13, w12);
   TEST_3RF("fsle.d", datad, 144, 144, w5,  w29, w5);
   TEST_3RF("fslt.w", dataf,   0,   0, w30, w22, w1);
   TEST_3RF("fslt.w", dataf,   0,   8, w6,  w13, w29);
   TEST_3RF("fslt.w", dataf,   0,  16, w27, w30, w28);
   TEST_3RF("fslt.w", dataf,   0,  24, w28, w28, w5);
   TEST_3RF("fslt.w", dataf,   0,  32, w10, w29, w2);
   TEST_3RF("fslt.w", dataf,   0,  40, w20, w17, w16);
   TEST_3RF("fslt.w", dataf,   0,  48, w16, w8,  w6);
   TEST_3RF("fslt.w", dataf,   0,  56, w12, w11, w21);
   TEST_3RF("fslt.w", dataf,   0,  64, w25, w23, w27);
   TEST_3RF("fslt.w", dataf,   0,  72, w22, w3,  w23);
   TEST_3RF("fslt.w", dataf,   8,   0, w13, w8,  w21);
   TEST_3RF("fslt.w", dataf,   8,   8, w4,  w9,  w27);
   TEST_3RF("fslt.w", dataf,   8,  16, w17, w6,  w22);
   TEST_3RF("fslt.w", dataf,   8,  24, w15, w2,  w18);
   TEST_3RF("fslt.w", dataf,   8,  32, w20, w13, w15);
   TEST_3RF("fslt.w", dataf,   8,  40, w22, w1,  w6);
   TEST_3RF("fslt.w", dataf,   8,  48, w17, w9,  w12);
   TEST_3RF("fslt.w", dataf,   8,  56, w29, w20, w2);
   TEST_3RF("fslt.w", dataf,   8,  64, w22, w12, w29);
   TEST_3RF("fslt.w", dataf,   8,  72, w13, w15, w20);
   TEST_3RF("fslt.w", dataf,  16,   0, w26, w23, w9);
   TEST_3RF("fslt.w", dataf,  16,   8, w30, w0,  w4);
   TEST_3RF("fslt.w", dataf,  16,  16, w16, w6,  w26);
   TEST_3RF("fslt.w", dataf,  16,  24, w31, w8,  w13);
   TEST_3RF("fslt.w", dataf,  16,  32, w20, w21, w28);
   TEST_3RF("fslt.w", dataf,  16,  40, w10, w23, w29);
   TEST_3RF("fslt.w", dataf,  16,  48, w17, w8,  w7);
   TEST_3RF("fslt.w", dataf,  16,  56, w29, w6,  w27);
   TEST_3RF("fslt.w", dataf,  16,  64, w31, w28, w7);
   TEST_3RF("fslt.w", dataf,  16,  72, w28, w28, w9);
   TEST_3RF("fslt.w", dataf,  24,   0, w22, w16, w4);
   TEST_3RF("fslt.w", dataf,  24,   8, w13, w25, w2);
   TEST_3RF("fslt.w", dataf,  24,  16, w13, w29, w18);
   TEST_3RF("fslt.w", dataf,  24,  24, w19, w24, w18);
   TEST_3RF("fslt.w", dataf,  24,  32, w28, w28, w5);
   TEST_3RF("fslt.w", dataf,  24,  40, w6,  w17, w1);
   TEST_3RF("fslt.w", dataf,  24,  48, w16, w8,  w31);
   TEST_3RF("fslt.w", dataf,  24,  56, w1,  w17, w6);
   TEST_3RF("fslt.w", dataf,  24,  64, w31, w23, w1);
   TEST_3RF("fslt.w", dataf,  24,  72, w30, w19, w9);
   TEST_3RF("fslt.w", dataf,  32,   0, w27, w29, w31);
   TEST_3RF("fslt.w", dataf,  32,   8, w11, w11, w11);
   TEST_3RF("fslt.w", dataf,  32,  16, w1,  w13, w5);
   TEST_3RF("fslt.w", dataf,  32,  24, w3,  w26, w2);
   TEST_3RF("fslt.w", dataf,  32,  32, w22, w14, w26);
   TEST_3RF("fslt.w", dataf,  32,  40, w8,  w10, w31);
   TEST_3RF("fslt.w", dataf,  32,  48, w14, w27, w1);
   TEST_3RF("fslt.w", dataf,  32,  56, w30, w4,  w0);
   TEST_3RF("fslt.w", dataf,  32,  64, w0,  w21, w6);
   TEST_3RF("fslt.w", dataf,  32,  72, w31, w12, w7);
   TEST_3RF("fslt.w", dataf,  40,   0, w29, w31, w16);
   TEST_3RF("fslt.w", dataf,  40,   8, w24, w28, w16);
   TEST_3RF("fslt.w", dataf,  40,  16, w4,  w29, w9);
   TEST_3RF("fslt.w", dataf,  40,  24, w1,  w23, w11);
   TEST_3RF("fslt.w", dataf,  40,  32, w23, w5,  w23);
   TEST_3RF("fslt.w", dataf,  40,  40, w6,  w31, w15);
   TEST_3RF("fslt.w", dataf,  40,  48, w5,  w13, w13);
   TEST_3RF("fslt.w", dataf,  40,  56, w11, w11, w11);
   TEST_3RF("fslt.w", dataf,  40,  64, w6,  w11, w15);
   TEST_3RF("fslt.w", dataf,  40,  72, w6,  w11, w4);
   TEST_3RF("fslt.w", dataf,  48,   0, w12, w10, w16);
   TEST_3RF("fslt.w", dataf,  48,   8, w20, w8,  w15);
   TEST_3RF("fslt.w", dataf,  48,  16, w4,  w0,  w12);
   TEST_3RF("fslt.w", dataf,  48,  24, w20, w4,  w9);
   TEST_3RF("fslt.w", dataf,  48,  32, w17, w13, w10);
   TEST_3RF("fslt.w", dataf,  48,  40, w9,  w25, w1);
   TEST_3RF("fslt.w", dataf,  48,  48, w14, w31, w0);
   TEST_3RF("fslt.w", dataf,  48,  56, w30, w4,  w13);
   TEST_3RF("fslt.w", dataf,  48,  64, w9,  w11, w25);
   TEST_3RF("fslt.w", dataf,  48,  72, w24, w17, w4);
   TEST_3RF("fslt.w", dataf,  56,   0, w28, w28, w30);
   TEST_3RF("fslt.w", dataf,  56,   8, w15, w12, w18);
   TEST_3RF("fslt.w", dataf,  56,  16, w23, w27, w23);
   TEST_3RF("fslt.w", dataf,  56,  24, w22, w23, w7);
   TEST_3RF("fslt.w", dataf,  56,  32, w11, w11, w11);
   TEST_3RF("fslt.w", dataf,  56,  40, w28, w28, w17);
   TEST_3RF("fslt.w", dataf,  56,  48, w28, w28, w9);
   TEST_3RF("fslt.w", dataf,  56,  56, w27, w5,  w2);
   TEST_3RF("fslt.w", dataf,  56,  64, w29, w20, w1);
   TEST_3RF("fslt.w", dataf,  56,  72, w29, w18, w6);
   TEST_3RF("fslt.w", dataf,  64,   0, w11, w11, w11);
   TEST_3RF("fslt.w", dataf,  64,   8, w27, w17, w4);
   TEST_3RF("fslt.w", dataf,  64,  16, w19, w2,  w8);
   TEST_3RF("fslt.w", dataf,  64,  24, w15, w0,  w23);
   TEST_3RF("fslt.w", dataf,  64,  32, w27, w18, w14);
   TEST_3RF("fslt.w", dataf,  64,  40, w22, w9,  w6);
   TEST_3RF("fslt.w", dataf,  64,  48, w30, w20, w2);
   TEST_3RF("fslt.w", dataf,  64,  56, w15, w16, w11);
   TEST_3RF("fslt.w", dataf,  64,  64, w10, w22, w14);
   TEST_3RF("fslt.w", dataf,  64,  72, w7,  w10, w15);
   TEST_3RF("fslt.w", dataf,  72,   0, w5,  w28, w28);
   TEST_3RF("fslt.w", dataf,  72,   8, w21, w16, w23);
   TEST_3RF("fslt.w", dataf,  72,  16, w6,  w20, w10);
   TEST_3RF("fslt.w", dataf,  72,  24, w9,  w28, w25);
   TEST_3RF("fslt.w", dataf,  72,  32, w9,  w20, w28);
   TEST_3RF("fslt.w", dataf,  72,  40, w2,  w10, w5);
   TEST_3RF("fslt.w", dataf,  72,  48, w8,  w25, w10);
   TEST_3RF("fslt.w", dataf,  72,  56, w23, w9,  w23);
   TEST_3RF("fslt.w", dataf,  72,  64, w22, w2,  w31);
   TEST_3RF("fslt.w", dataf,  72,  72, w4,  w9,  w19);
   TEST_3RF("fslt.d", datad,   0,   0, w14, w5,  w9);
   TEST_3RF("fslt.d", datad,   0,  16, w30, w28, w15);
   TEST_3RF("fslt.d", datad,   0,  32, w18, w6,  w24);
   TEST_3RF("fslt.d", datad,   0,  48, w15, w31, w2);
   TEST_3RF("fslt.d", datad,   0,  64, w3,  w19, w30);
   TEST_3RF("fslt.d", datad,   0,  80, w5,  w30, w30);
   TEST_3RF("fslt.d", datad,   0,  96, w3,  w14, w6);
   TEST_3RF("fslt.d", datad,   0, 112, w28, w28, w24);
   TEST_3RF("fslt.d", datad,   0, 128, w30, w5,  w14);
   TEST_3RF("fslt.d", datad,   0, 144, w0,  w5,  w18);
   TEST_3RF("fslt.d", datad,  16,   0, w9,  w14, w6);
   TEST_3RF("fslt.d", datad,  16,  16, w24, w20, w15);
   TEST_3RF("fslt.d", datad,  16,  32, w22, w16, w30);
   TEST_3RF("fslt.d", datad,  16,  48, w9,  w23, w24);
   TEST_3RF("fslt.d", datad,  16,  64, w22, w25, w27);
   TEST_3RF("fslt.d", datad,  16,  80, w10, w23, w0);
   TEST_3RF("fslt.d", datad,  16,  96, w8,  w26, w14);
   TEST_3RF("fslt.d", datad,  16, 112, w14, w22, w7);
   TEST_3RF("fslt.d", datad,  16, 128, w12, w27, w21);
   TEST_3RF("fslt.d", datad,  16, 144, w12, w0,  w8);
   TEST_3RF("fslt.d", datad,  32,   0, w22, w15, w14);
   TEST_3RF("fslt.d", datad,  32,  16, w14, w3,  w29);
   TEST_3RF("fslt.d", datad,  32,  32, w4,  w19, w27);
   TEST_3RF("fslt.d", datad,  32,  48, w13, w10, w18);
   TEST_3RF("fslt.d", datad,  32,  64, w5,  w1,  w1);
   TEST_3RF("fslt.d", datad,  32,  80, w11, w11, w11);
   TEST_3RF("fslt.d", datad,  32,  96, w0,  w11, w2);
   TEST_3RF("fslt.d", datad,  32, 112, w1,  w19, w28);
   TEST_3RF("fslt.d", datad,  32, 128, w15, w1,  w18);
   TEST_3RF("fslt.d", datad,  32, 144, w22, w14, w12);
   TEST_3RF("fslt.d", datad,  48,   0, w26, w14, w20);
   TEST_3RF("fslt.d", datad,  48,  16, w16, w29, w2);
   TEST_3RF("fslt.d", datad,  48,  32, w30, w0,  w31);
   TEST_3RF("fslt.d", datad,  48,  48, w3,  w20, w26);
   TEST_3RF("fslt.d", datad,  48,  64, w16, w30, w13);
   TEST_3RF("fslt.d", datad,  48,  80, w22, w31, w24);
   TEST_3RF("fslt.d", datad,  48,  96, w22, w10, w27);
   TEST_3RF("fslt.d", datad,  48, 112, w23, w29, w23);
   TEST_3RF("fslt.d", datad,  48, 128, w23, w7,  w23);
   TEST_3RF("fslt.d", datad,  48, 144, w31, w10, w29);
   TEST_3RF("fslt.d", datad,  64,   0, w13, w24, w9);
   TEST_3RF("fslt.d", datad,  64,  16, w7,  w6,  w29);
   TEST_3RF("fslt.d", datad,  64,  32, w24, w4,  w31);
   TEST_3RF("fslt.d", datad,  64,  48, w22, w4,  w30);
   TEST_3RF("fslt.d", datad,  64,  64, w25, w24, w10);
   TEST_3RF("fslt.d", datad,  64,  80, w23, w6,  w23);
   TEST_3RF("fslt.d", datad,  64,  96, w0,  w22, w30);
   TEST_3RF("fslt.d", datad,  64, 112, w22, w1,  w25);
   TEST_3RF("fslt.d", datad,  64, 128, w14, w30, w17);
   TEST_3RF("fslt.d", datad,  64, 144, w21, w29, w27);
   TEST_3RF("fslt.d", datad,  80,   0, w18, w10, w19);
   TEST_3RF("fslt.d", datad,  80,  16, w28, w28, w18);
   TEST_3RF("fslt.d", datad,  80,  32, w25, w10, w29);
   TEST_3RF("fslt.d", datad,  80,  48, w25, w0,  w2);
   TEST_3RF("fslt.d", datad,  80,  64, w23, w26, w23);
   TEST_3RF("fslt.d", datad,  80,  80, w26, w16, w4);
   TEST_3RF("fslt.d", datad,  80,  96, w17, w22, w4);
   TEST_3RF("fslt.d", datad,  80, 112, w8,  w21, w26);
   TEST_3RF("fslt.d", datad,  80, 128, w9,  w14, w8);
   TEST_3RF("fslt.d", datad,  80, 144, w7,  w31, w29);
   TEST_3RF("fslt.d", datad,  96,   0, w5,  w26, w26);
   TEST_3RF("fslt.d", datad,  96,  16, w16, w15, w13);
   TEST_3RF("fslt.d", datad,  96,  32, w12, w1,  w7);
   TEST_3RF("fslt.d", datad,  96,  48, w5,  w11, w11);
   TEST_3RF("fslt.d", datad,  96,  64, w4,  w30, w12);
   TEST_3RF("fslt.d", datad,  96,  80, w6,  w22, w1);
   TEST_3RF("fslt.d", datad,  96,  96, w6,  w10, w18);
   TEST_3RF("fslt.d", datad,  96, 112, w29, w14, w26);
   TEST_3RF("fslt.d", datad,  96, 128, w18, w8,  w3);
   TEST_3RF("fslt.d", datad,  96, 144, w0,  w17, w11);
   TEST_3RF("fslt.d", datad, 112,   0, w0,  w14, w16);
   TEST_3RF("fslt.d", datad, 112,  16, w26, w30, w31);
   TEST_3RF("fslt.d", datad, 112,  32, w8,  w10, w1);
   TEST_3RF("fslt.d", datad, 112,  48, w15, w16, w12);
   TEST_3RF("fslt.d", datad, 112,  64, w19, w14, w24);
   TEST_3RF("fslt.d", datad, 112,  80, w26, w4,  w30);
   TEST_3RF("fslt.d", datad, 112,  96, w27, w11, w8);
   TEST_3RF("fslt.d", datad, 112, 112, w13, w8,  w22);
   TEST_3RF("fslt.d", datad, 112, 128, w8,  w26, w31);
   TEST_3RF("fslt.d", datad, 112, 144, w11, w11, w11);
   TEST_3RF("fslt.d", datad, 128,   0, w26, w16, w22);
   TEST_3RF("fslt.d", datad, 128,  16, w26, w30, w6);
   TEST_3RF("fslt.d", datad, 128,  32, w21, w29, w6);
   TEST_3RF("fslt.d", datad, 128,  48, w29, w7,  w12);
   TEST_3RF("fslt.d", datad, 128,  64, w23, w19, w23);
   TEST_3RF("fslt.d", datad, 128,  80, w31, w6,  w12);
   TEST_3RF("fslt.d", datad, 128,  96, w25, w10, w20);
   TEST_3RF("fslt.d", datad, 128, 112, w21, w19, w2);
   TEST_3RF("fslt.d", datad, 128, 128, w29, w9,  w10);
   TEST_3RF("fslt.d", datad, 128, 144, w23, w8,  w23);
   TEST_3RF("fslt.d", datad, 144,   0, w21, w18, w24);
   TEST_3RF("fslt.d", datad, 144,  16, w12, w23, w18);
   TEST_3RF("fslt.d", datad, 144,  32, w1,  w20, w24);
   TEST_3RF("fslt.d", datad, 144,  48, w30, w27, w31);
   TEST_3RF("fslt.d", datad, 144,  64, w10, w19, w25);
   TEST_3RF("fslt.d", datad, 144,  80, w31, w3,  w9);
   TEST_3RF("fslt.d", datad, 144,  96, w24, w25, w28);
   TEST_3RF("fslt.d", datad, 144, 112, w26, w22, w6);
   TEST_3RF("fslt.d", datad, 144, 128, w4,  w14, w25);
   TEST_3RF("fslt.d", datad, 144, 144, w0,  w7,  w5);
   TEST_3RF("fsne.w", dataf,   0,   0, w18, w16, w12);
   TEST_3RF("fsne.w", dataf,   0,   8, w13, w16, w23);
   TEST_3RF("fsne.w", dataf,   0,  16, w0,  w3,  w1);
   TEST_3RF("fsne.w", dataf,   0,  24, w25, w2,  w4);
   TEST_3RF("fsne.w", dataf,   0,  32, w29, w11, w28);
   TEST_3RF("fsne.w", dataf,   0,  40, w22, w8,  w12);
   TEST_3RF("fsne.w", dataf,   0,  48, w14, w26, w26);
   TEST_3RF("fsne.w", dataf,   0,  56, w26, w28, w20);
   TEST_3RF("fsne.w", dataf,   0,  64, w26, w3,  w25);
   TEST_3RF("fsne.w", dataf,   0,  72, w7,  w1,  w17);
   TEST_3RF("fsne.w", dataf,   8,   0, w21, w19, w2);
   TEST_3RF("fsne.w", dataf,   8,   8, w1,  w18, w24);
   TEST_3RF("fsne.w", dataf,   8,  16, w1,  w21, w25);
   TEST_3RF("fsne.w", dataf,   8,  24, w27, w23, w30);
   TEST_3RF("fsne.w", dataf,   8,  32, w24, w2,  w24);
   TEST_3RF("fsne.w", dataf,   8,  40, w26, w14, w10);
   TEST_3RF("fsne.w", dataf,   8,  48, w17, w26, w24);
   TEST_3RF("fsne.w", dataf,   8,  56, w11, w21, w31);
   TEST_3RF("fsne.w", dataf,   8,  64, w15, w24, w25);
   TEST_3RF("fsne.w", dataf,   8,  72, w22, w26, w10);
   TEST_3RF("fsne.w", dataf,  16,   0, w11, w13, w12);
   TEST_3RF("fsne.w", dataf,  16,   8, w13, w14, w30);
   TEST_3RF("fsne.w", dataf,  16,  16, w5,  w16, w19);
   TEST_3RF("fsne.w", dataf,  16,  24, w31, w11, w10);
   TEST_3RF("fsne.w", dataf,  16,  32, w29, w3,  w13);
   TEST_3RF("fsne.w", dataf,  16,  40, w23, w17, w8);
   TEST_3RF("fsne.w", dataf,  16,  48, w11, w16, w20);
   TEST_3RF("fsne.w", dataf,  16,  56, w0,  w5,  w19);
   TEST_3RF("fsne.w", dataf,  16,  64, w16, w29, w12);
   TEST_3RF("fsne.w", dataf,  16,  72, w6,  w23, w18);
   TEST_3RF("fsne.w", dataf,  24,   0, w5,  w3,  w31);
   TEST_3RF("fsne.w", dataf,  24,   8, w19, w2,  w4);
   TEST_3RF("fsne.w", dataf,  24,  16, w3,  w21, w14);
   TEST_3RF("fsne.w", dataf,  24,  24, w0,  w17, w13);
   TEST_3RF("fsne.w", dataf,  24,  32, w24, w2,  w24);
   TEST_3RF("fsne.w", dataf,  24,  40, w4,  w0,  w14);
   TEST_3RF("fsne.w", dataf,  24,  48, w20, w14, w25);
   TEST_3RF("fsne.w", dataf,  24,  56, w8,  w30, w23);
   TEST_3RF("fsne.w", dataf,  24,  64, w20, w5,  w14);
   TEST_3RF("fsne.w", dataf,  24,  72, w11, w23, w19);
   TEST_3RF("fsne.w", dataf,  32,   0, w15, w22, w7);
   TEST_3RF("fsne.w", dataf,  32,   8, w17, w26, w10);
   TEST_3RF("fsne.w", dataf,  32,  16, w6,  w30, w25);
   TEST_3RF("fsne.w", dataf,  32,  24, w6,  w30, w10);
   TEST_3RF("fsne.w", dataf,  32,  32, w19, w22, w13);
   TEST_3RF("fsne.w", dataf,  32,  40, w24, w23, w24);
   TEST_3RF("fsne.w", dataf,  32,  48, w27, w12, w11);
   TEST_3RF("fsne.w", dataf,  32,  56, w9,  w6,  w19);
   TEST_3RF("fsne.w", dataf,  32,  64, w8,  w29, w13);
   TEST_3RF("fsne.w", dataf,  32,  72, w11, w19, w4);
   TEST_3RF("fsne.w", dataf,  40,   0, w31, w2,  w26);
   TEST_3RF("fsne.w", dataf,  40,   8, w6,  w19, w20);
   TEST_3RF("fsne.w", dataf,  40,  16, w16, w26, w18);
   TEST_3RF("fsne.w", dataf,  40,  24, w9,  w0,  w17);
   TEST_3RF("fsne.w", dataf,  40,  32, w20, w7,  w1);
   TEST_3RF("fsne.w", dataf,  40,  40, w12, w12, w12);
   TEST_3RF("fsne.w", dataf,  40,  48, w30, w30, w28);
   TEST_3RF("fsne.w", dataf,  40,  56, w24, w10, w24);
   TEST_3RF("fsne.w", dataf,  40,  64, w5,  w30, w29);
   TEST_3RF("fsne.w", dataf,  40,  72, w13, w27, w5);
   TEST_3RF("fsne.w", dataf,  48,   0, w26, w7,  w25);
   TEST_3RF("fsne.w", dataf,  48,   8, w30, w30, w6);
   TEST_3RF("fsne.w", dataf,  48,  16, w27, w24, w12);
   TEST_3RF("fsne.w", dataf,  48,  24, w15, w13, w28);
   TEST_3RF("fsne.w", dataf,  48,  32, w9,  w31, w6);
   TEST_3RF("fsne.w", dataf,  48,  40, w9,  w16, w26);
   TEST_3RF("fsne.w", dataf,  48,  48, w29, w24, w27);
   TEST_3RF("fsne.w", dataf,  48,  56, w9,  w22, w23);
   TEST_3RF("fsne.w", dataf,  48,  64, w2,  w0,  w28);
   TEST_3RF("fsne.w", dataf,  48,  72, w0,  w30, w10);
   TEST_3RF("fsne.w", dataf,  56,   0, w28, w3,  w4);
   TEST_3RF("fsne.w", dataf,  56,   8, w3,  w28, w9);
   TEST_3RF("fsne.w", dataf,  56,  16, w24, w27, w24);
   TEST_3RF("fsne.w", dataf,  56,  24, w21, w7,  w8);
   TEST_3RF("fsne.w", dataf,  56,  32, w17, w16, w8);
   TEST_3RF("fsne.w", dataf,  56,  40, w23, w25, w24);
   TEST_3RF("fsne.w", dataf,  56,  48, w17, w23, w16);
   TEST_3RF("fsne.w", dataf,  56,  56, w12, w12, w12);
   TEST_3RF("fsne.w", dataf,  56,  64, w0,  w7,  w3);
   TEST_3RF("fsne.w", dataf,  56,  72, w2,  w7,  w0);
   TEST_3RF("fsne.w", dataf,  64,   0, w3,  w5,  w10);
   TEST_3RF("fsne.w", dataf,  64,   8, w31, w9,  w14);
   TEST_3RF("fsne.w", dataf,  64,  16, w2,  w5,  w17);
   TEST_3RF("fsne.w", dataf,  64,  24, w11, w29, w13);
   TEST_3RF("fsne.w", dataf,  64,  32, w0,  w4,  w21);
   TEST_3RF("fsne.w", dataf,  64,  40, w17, w20, w29);
   TEST_3RF("fsne.w", dataf,  64,  48, w9,  w14, w22);
   TEST_3RF("fsne.w", dataf,  64,  56, w26, w5,  w6);
   TEST_3RF("fsne.w", dataf,  64,  64, w7,  w5,  w13);
   TEST_3RF("fsne.w", dataf,  64,  72, w10, w8,  w21);
   TEST_3RF("fsne.w", dataf,  72,   0, w10, w11, w26);
   TEST_3RF("fsne.w", dataf,  72,   8, w20, w10, w3);
   TEST_3RF("fsne.w", dataf,  72,  16, w3,  w12, w9);
   TEST_3RF("fsne.w", dataf,  72,  24, w20, w23, w6);
   TEST_3RF("fsne.w", dataf,  72,  32, w1,  w23, w11);
   TEST_3RF("fsne.w", dataf,  72,  40, w23, w8,  w31);
   TEST_3RF("fsne.w", dataf,  72,  48, w20, w17, w13);
   TEST_3RF("fsne.w", dataf,  72,  56, w10, w12, w18);
   TEST_3RF("fsne.w", dataf,  72,  64, w17, w19, w24);
   TEST_3RF("fsne.w", dataf,  72,  72, w30, w30, w29);
   TEST_3RF("fsne.d", datad,   0,   0, w0,  w19, w8);
   TEST_3RF("fsne.d", datad,   0,  16, w11, w14, w28);
   TEST_3RF("fsne.d", datad,   0,  32, w21, w17, w31);
   TEST_3RF("fsne.d", datad,   0,  48, w1,  w26, w20);
   TEST_3RF("fsne.d", datad,   0,  64, w24, w1,  w24);
   TEST_3RF("fsne.d", datad,   0,  80, w21, w15, w12);
   TEST_3RF("fsne.d", datad,   0,  96, w12, w12, w12);
   TEST_3RF("fsne.d", datad,   0, 112, w23, w11, w1);
   TEST_3RF("fsne.d", datad,   0, 128, w9,  w25, w11);
   TEST_3RF("fsne.d", datad,   0, 144, w21, w11, w28);
   TEST_3RF("fsne.d", datad,  16,   0, w8,  w3,  w27);
   TEST_3RF("fsne.d", datad,  16,  16, w5,  w3,  w14);
   TEST_3RF("fsne.d", datad,  16,  32, w13, w14, w28);
   TEST_3RF("fsne.d", datad,  16,  48, w10, w3,  w14);
   TEST_3RF("fsne.d", datad,  16,  64, w9,  w4,  w8);
   TEST_3RF("fsne.d", datad,  16,  80, w29, w28, w9);
   TEST_3RF("fsne.d", datad,  16,  96, w19, w11, w21);
   TEST_3RF("fsne.d", datad,  16, 112, w31, w3,  w1);
   TEST_3RF("fsne.d", datad,  16, 128, w0,  w12, w26);
   TEST_3RF("fsne.d", datad,  16, 144, w12, w12, w12);
   TEST_3RF("fsne.d", datad,  32,   0, w1,  w5,  w8);
   TEST_3RF("fsne.d", datad,  32,  16, w9,  w3,  w14);
   TEST_3RF("fsne.d", datad,  32,  32, w12, w12, w12);
   TEST_3RF("fsne.d", datad,  32,  48, w18, w28, w27);
   TEST_3RF("fsne.d", datad,  32,  64, w14, w6,  w6);
   TEST_3RF("fsne.d", datad,  32,  80, w30, w30, w28);
   TEST_3RF("fsne.d", datad,  32,  96, w15, w3,  w5);
   TEST_3RF("fsne.d", datad,  32, 112, w13, w31, w14);
   TEST_3RF("fsne.d", datad,  32, 128, w0,  w11, w4);
   TEST_3RF("fsne.d", datad,  32, 144, w31, w14, w5);
   TEST_3RF("fsne.d", datad,  48,   0, w0,  w26, w31);
   TEST_3RF("fsne.d", datad,  48,  16, w12, w12, w12);
   TEST_3RF("fsne.d", datad,  48,  32, w27, w4,  w20);
   TEST_3RF("fsne.d", datad,  48,  48, w4,  w13, w24);
   TEST_3RF("fsne.d", datad,  48,  64, w18, w26, w10);
   TEST_3RF("fsne.d", datad,  48,  80, w14, w21, w21);
   TEST_3RF("fsne.d", datad,  48,  96, w24, w20, w24);
   TEST_3RF("fsne.d", datad,  48, 112, w19, w21, w4);
   TEST_3RF("fsne.d", datad,  48, 128, w22, w26, w17);
   TEST_3RF("fsne.d", datad,  48, 144, w22, w8,  w17);
   TEST_3RF("fsne.d", datad,  64,   0, w1,  w12, w16);
   TEST_3RF("fsne.d", datad,  64,  16, w15, w17, w16);
   TEST_3RF("fsne.d", datad,  64,  32, w9,  w16, w28);
   TEST_3RF("fsne.d", datad,  64,  48, w4,  w21, w17);
   TEST_3RF("fsne.d", datad,  64,  64, w8,  w2,  w9);
   TEST_3RF("fsne.d", datad,  64,  80, w26, w28, w19);
   TEST_3RF("fsne.d", datad,  64,  96, w9,  w17, w11);
   TEST_3RF("fsne.d", datad,  64, 112, w29, w5,  w0);
   TEST_3RF("fsne.d", datad,  64, 128, w1,  w27, w26);
   TEST_3RF("fsne.d", datad,  64, 144, w18, w17, w3);
   TEST_3RF("fsne.d", datad,  80,   0, w3,  w18, w15);
   TEST_3RF("fsne.d", datad,  80,  16, w20, w1,  w4);
   TEST_3RF("fsne.d", datad,  80,  32, w10, w17, w1);
   TEST_3RF("fsne.d", datad,  80,  48, w14, w6,  w6);
   TEST_3RF("fsne.d", datad,  80,  64, w18, w22, w9);
   TEST_3RF("fsne.d", datad,  80,  80, w27, w17, w5);
   TEST_3RF("fsne.d", datad,  80,  96, w14, w26, w26);
   TEST_3RF("fsne.d", datad,  80, 112, w23, w25, w28);
   TEST_3RF("fsne.d", datad,  80, 128, w26, w25, w23);
   TEST_3RF("fsne.d", datad,  80, 144, w20, w11, w9);
   TEST_3RF("fsne.d", datad,  96,   0, w23, w15, w27);
   TEST_3RF("fsne.d", datad,  96,  16, w7,  w3,  w29);
   TEST_3RF("fsne.d", datad,  96,  32, w8,  w7,  w25);
   TEST_3RF("fsne.d", datad,  96,  48, w8,  w22, w0);
   TEST_3RF("fsne.d", datad,  96,  64, w26, w12, w9);
   TEST_3RF("fsne.d", datad,  96,  80, w21, w29, w14);
   TEST_3RF("fsne.d", datad,  96,  96, w3,  w23, w5);
   TEST_3RF("fsne.d", datad,  96, 112, w29, w15, w1);
   TEST_3RF("fsne.d", datad,  96, 128, w23, w8,  w25);
   TEST_3RF("fsne.d", datad,  96, 144, w11, w19, w2);
   TEST_3RF("fsne.d", datad, 112,   0, w3,  w2,  w29);
   TEST_3RF("fsne.d", datad, 112,  16, w10, w5,  w26);
   TEST_3RF("fsne.d", datad, 112,  32, w18, w13, w2);
   TEST_3RF("fsne.d", datad, 112,  48, w11, w21, w24);
   TEST_3RF("fsne.d", datad, 112,  64, w11, w16, w4);
   TEST_3RF("fsne.d", datad, 112,  80, w20, w5,  w2);
   TEST_3RF("fsne.d", datad, 112,  96, w3,  w9,  w25);
   TEST_3RF("fsne.d", datad, 112, 112, w8,  w6,  w10);
   TEST_3RF("fsne.d", datad, 112, 128, w29, w16, w3);
   TEST_3RF("fsne.d", datad, 112, 144, w8,  w4,  w5);
   TEST_3RF("fsne.d", datad, 128,   0, w11, w6,  w2);
   TEST_3RF("fsne.d", datad, 128,  16, w21, w12, w29);
   TEST_3RF("fsne.d", datad, 128,  32, w7,  w25, w31);
   TEST_3RF("fsne.d", datad, 128,  48, w19, w14, w23);
   TEST_3RF("fsne.d", datad, 128,  64, w30, w30, w27);
   TEST_3RF("fsne.d", datad, 128,  80, w19, w4,  w29);
   TEST_3RF("fsne.d", datad, 128,  96, w22, w13, w23);
   TEST_3RF("fsne.d", datad, 128, 112, w30, w30, w19);
   TEST_3RF("fsne.d", datad, 128, 128, w31, w8,  w16);
   TEST_3RF("fsne.d", datad, 128, 144, w16, w11, w24);
   TEST_3RF("fsne.d", datad, 144,   0, w20, w16, w4);
   TEST_3RF("fsne.d", datad, 144,  16, w26, w19, w25);
   TEST_3RF("fsne.d", datad, 144,  32, w6,  w16, w1);
   TEST_3RF("fsne.d", datad, 144,  48, w31, w15, w20);
   TEST_3RF("fsne.d", datad, 144,  64, w14, w6,  w6);
   TEST_3RF("fsne.d", datad, 144,  80, w18, w12, w1);
   TEST_3RF("fsne.d", datad, 144,  96, w5,  w16, w31);
   TEST_3RF("fsne.d", datad, 144, 112, w27, w29, w22);
   TEST_3RF("fsne.d", datad, 144, 128, w26, w16, w21);
   TEST_3RF("fsne.d", datad, 144, 144, w2,  w0,  w5);
   TEST_3RF("fsor.w", dataf,   0,   0, w20, w17, w22);
   TEST_3RF("fsor.w", dataf,   0,   8, w26, w1,  w23);
   TEST_3RF("fsor.w", dataf,   0,  16, w26, w16, w11);
   TEST_3RF("fsor.w", dataf,   0,  24, w8,  w22, w30);
   TEST_3RF("fsor.w", dataf,   0,  32, w20, w24, w3);
   TEST_3RF("fsor.w", dataf,   0,  40, w5,  w23, w31);
   TEST_3RF("fsor.w", dataf,   0,  48, w2,  w13, w25);
   TEST_3RF("fsor.w", dataf,   0,  56, w19, w2,  w27);
   TEST_3RF("fsor.w", dataf,   0,  64, w19, w8,  w9);
   TEST_3RF("fsor.w", dataf,   0,  72, w12, w1,  w8);
   TEST_3RF("fsor.w", dataf,   8,   0, w9,  w21, w25);
   TEST_3RF("fsor.w", dataf,   8,   8, w0,  w16, w27);
   TEST_3RF("fsor.w", dataf,   8,  16, w23, w10, w11);
   TEST_3RF("fsor.w", dataf,   8,  24, w3,  w18, w2);
   TEST_3RF("fsor.w", dataf,   8,  32, w1,  w6,  w26);
   TEST_3RF("fsor.w", dataf,   8,  40, w4,  w11, w17);
   TEST_3RF("fsor.w", dataf,   8,  48, w3,  w14, w30);
   TEST_3RF("fsor.w", dataf,   8,  56, w28, w1,  w0);
   TEST_3RF("fsor.w", dataf,   8,  64, w24, w20, w8);
   TEST_3RF("fsor.w", dataf,   8,  72, w1,  w10, w9);
   TEST_3RF("fsor.w", dataf,  16,   0, w10, w31, w3);
   TEST_3RF("fsor.w", dataf,  16,   8, w10, w15, w30);
   TEST_3RF("fsor.w", dataf,  16,  16, w2,  w25, w9);
   TEST_3RF("fsor.w", dataf,  16,  24, w5,  w11, w6);
   TEST_3RF("fsor.w", dataf,  16,  32, w18, w5,  w10);
   TEST_3RF("fsor.w", dataf,  16,  40, w29, w22, w22);
   TEST_3RF("fsor.w", dataf,  16,  48, w14, w14, w14);
   TEST_3RF("fsor.w", dataf,  16,  56, w11, w20, w10);
   TEST_3RF("fsor.w", dataf,  16,  64, w12, w21, w2);
   TEST_3RF("fsor.w", dataf,  16,  72, w1,  w29, w4);
   TEST_3RF("fsor.w", dataf,  24,   0, w2,  w7,  w13);
   TEST_3RF("fsor.w", dataf,  24,   8, w12, w7,  w16);
   TEST_3RF("fsor.w", dataf,  24,  16, w23, w22, w14);
   TEST_3RF("fsor.w", dataf,  24,  24, w25, w25, w16);
   TEST_3RF("fsor.w", dataf,  24,  32, w24, w30, w27);
   TEST_3RF("fsor.w", dataf,  24,  40, w3,  w4,  w13);
   TEST_3RF("fsor.w", dataf,  24,  48, w9,  w14, w11);
   TEST_3RF("fsor.w", dataf,  24,  56, w31, w28, w22);
   TEST_3RF("fsor.w", dataf,  24,  64, w20, w7,  w3);
   TEST_3RF("fsor.w", dataf,  24,  72, w9,  w4,  w6);
   TEST_3RF("fsor.w", dataf,  32,   0, w13, w6,  w14);
   TEST_3RF("fsor.w", dataf,  32,   8, w27, w18, w21);
   TEST_3RF("fsor.w", dataf,  32,  16, w11, w9,  w26);
   TEST_3RF("fsor.w", dataf,  32,  24, w2,  w27, w18);
   TEST_3RF("fsor.w", dataf,  32,  32, w0,  w23, w21);
   TEST_3RF("fsor.w", dataf,  32,  40, w4,  w30, w19);
   TEST_3RF("fsor.w", dataf,  32,  48, w15, w30, w6);
   TEST_3RF("fsor.w", dataf,  32,  56, w18, w22, w9);
   TEST_3RF("fsor.w", dataf,  32,  64, w27, w0,  w13);
   TEST_3RF("fsor.w", dataf,  32,  72, w1,  w13, w19);
   TEST_3RF("fsor.w", dataf,  40,   0, w15, w8,  w5);
   TEST_3RF("fsor.w", dataf,  40,   8, w4,  w20, w15);
   TEST_3RF("fsor.w", dataf,  40,  16, w16, w14, w17);
   TEST_3RF("fsor.w", dataf,  40,  24, w11, w0,  w18);
   TEST_3RF("fsor.w", dataf,  40,  32, w2,  w21, w22);
   TEST_3RF("fsor.w", dataf,  40,  40, w7,  w20, w9);
   TEST_3RF("fsor.w", dataf,  40,  48, w22, w18, w25);
   TEST_3RF("fsor.w", dataf,  40,  56, w28, w4,  w15);
   TEST_3RF("fsor.w", dataf,  40,  64, w5,  w31, w15);
   TEST_3RF("fsor.w", dataf,  40,  72, w18, w0,  w29);
   TEST_3RF("fsor.w", dataf,  48,   0, w5,  w16, w11);
   TEST_3RF("fsor.w", dataf,  48,   8, w20, w25, w26);
   TEST_3RF("fsor.w", dataf,  48,  16, w4,  w7,  w11);
   TEST_3RF("fsor.w", dataf,  48,  24, w16, w7,  w29);
   TEST_3RF("fsor.w", dataf,  48,  32, w18, w29, w20);
   TEST_3RF("fsor.w", dataf,  48,  40, w25, w25, w17);
   TEST_3RF("fsor.w", dataf,  48,  48, w29, w16, w16);
   TEST_3RF("fsor.w", dataf,  48,  56, w3,  w22, w12);
   TEST_3RF("fsor.w", dataf,  48,  64, w7,  w6,  w18);
   TEST_3RF("fsor.w", dataf,  48,  72, w6,  w21, w4);
   TEST_3RF("fsor.w", dataf,  56,   0, w6,  w18, w10);
   TEST_3RF("fsor.w", dataf,  56,   8, w22, w24, w21);
   TEST_3RF("fsor.w", dataf,  56,  16, w11, w17, w15);
   TEST_3RF("fsor.w", dataf,  56,  24, w15, w25, w26);
   TEST_3RF("fsor.w", dataf,  56,  32, w31, w0,  w24);
   TEST_3RF("fsor.w", dataf,  56,  40, w18, w29, w12);
   TEST_3RF("fsor.w", dataf,  56,  48, w11, w14, w9);
   TEST_3RF("fsor.w", dataf,  56,  56, w27, w17, w0);
   TEST_3RF("fsor.w", dataf,  56,  64, w8,  w24, w6);
   TEST_3RF("fsor.w", dataf,  56,  72, w26, w30, w27);
   TEST_3RF("fsor.w", dataf,  64,   0, w30, w5,  w30);
   TEST_3RF("fsor.w", dataf,  64,   8, w14, w14, w14);
   TEST_3RF("fsor.w", dataf,  64,  16, w8,  w27, w6);
   TEST_3RF("fsor.w", dataf,  64,  24, w29, w6,  w6);
   TEST_3RF("fsor.w", dataf,  64,  32, w23, w12, w22);
   TEST_3RF("fsor.w", dataf,  64,  40, w16, w7,  w21);
   TEST_3RF("fsor.w", dataf,  64,  48, w17, w31, w7);
   TEST_3RF("fsor.w", dataf,  64,  56, w14, w14, w14);
   TEST_3RF("fsor.w", dataf,  64,  64, w11, w19, w29);
   TEST_3RF("fsor.w", dataf,  64,  72, w20, w14, w22);
   TEST_3RF("fsor.w", dataf,  72,   0, w7,  w26, w16);
   TEST_3RF("fsor.w", dataf,  72,   8, w5,  w22, w15);
   TEST_3RF("fsor.w", dataf,  72,  16, w10, w4,  w23);
   TEST_3RF("fsor.w", dataf,  72,  24, w6,  w10, w21);
   TEST_3RF("fsor.w", dataf,  72,  32, w12, w1,  w2);
   TEST_3RF("fsor.w", dataf,  72,  40, w18, w8,  w24);
   TEST_3RF("fsor.w", dataf,  72,  48, w3,  w7,  w31);
   TEST_3RF("fsor.w", dataf,  72,  56, w17, w18, w14);
   TEST_3RF("fsor.w", dataf,  72,  64, w7,  w1,  w29);
   TEST_3RF("fsor.w", dataf,  72,  72, w27, w23, w4);
   TEST_3RF("fsor.d", datad,   0,   0, w22, w8,  w9);
   TEST_3RF("fsor.d", datad,   0,  16, w12, w23, w20);
   TEST_3RF("fsor.d", datad,   0,  32, w16, w14, w26);
   TEST_3RF("fsor.d", datad,   0,  48, w26, w3,  w6);
   TEST_3RF("fsor.d", datad,   0,  64, w27, w5,  w9);
   TEST_3RF("fsor.d", datad,   0,  80, w13, w1,  w16);
   TEST_3RF("fsor.d", datad,   0,  96, w21, w0,  w2);
   TEST_3RF("fsor.d", datad,   0, 112, w7,  w19, w16);
   TEST_3RF("fsor.d", datad,   0, 128, w14, w14, w14);
   TEST_3RF("fsor.d", datad,   0, 144, w20, w13, w10);
   TEST_3RF("fsor.d", datad,  16,   0, w11, w17, w0);
   TEST_3RF("fsor.d", datad,  16,  16, w19, w27, w12);
   TEST_3RF("fsor.d", datad,  16,  32, w10, w15, w28);
   TEST_3RF("fsor.d", datad,  16,  48, w25, w25, w9);
   TEST_3RF("fsor.d", datad,  16,  64, w22, w28, w15);
   TEST_3RF("fsor.d", datad,  16,  80, w17, w1,  w24);
   TEST_3RF("fsor.d", datad,  16,  96, w31, w15, w25);
   TEST_3RF("fsor.d", datad,  16, 112, w15, w4,  w26);
   TEST_3RF("fsor.d", datad,  16, 128, w17, w11, w13);
   TEST_3RF("fsor.d", datad,  16, 144, w2,  w26, w1);
   TEST_3RF("fsor.d", datad,  32,   0, w15, w4,  w12);
   TEST_3RF("fsor.d", datad,  32,  16, w1,  w4,  w0);
   TEST_3RF("fsor.d", datad,  32,  32, w28, w16, w10);
   TEST_3RF("fsor.d", datad,  32,  48, w11, w12, w3);
   TEST_3RF("fsor.d", datad,  32,  64, w20, w2,  w0);
   TEST_3RF("fsor.d", datad,  32,  80, w3,  w19, w1);
   TEST_3RF("fsor.d", datad,  32,  96, w28, w18, w16);
   TEST_3RF("fsor.d", datad,  32, 112, w21, w2,  w20);
   TEST_3RF("fsor.d", datad,  32, 128, w15, w19, w0);
   TEST_3RF("fsor.d", datad,  32, 144, w28, w21, w26);
   TEST_3RF("fsor.d", datad,  48,   0, w29, w5,  w5);
   TEST_3RF("fsor.d", datad,  48,  16, w30, w10, w30);
   TEST_3RF("fsor.d", datad,  48,  32, w6,  w2,  w10);
   TEST_3RF("fsor.d", datad,  48,  48, w2,  w18, w20);
   TEST_3RF("fsor.d", datad,  48,  64, w13, w30, w24);
   TEST_3RF("fsor.d", datad,  48,  80, w1,  w0,  w24);
   TEST_3RF("fsor.d", datad,  48,  96, w4,  w19, w25);
   TEST_3RF("fsor.d", datad,  48, 112, w0,  w6,  w10);
   TEST_3RF("fsor.d", datad,  48, 128, w22, w8,  w30);
   TEST_3RF("fsor.d", datad,  48, 144, w5,  w27, w30);
   TEST_3RF("fsor.d", datad,  64,   0, w2,  w17, w24);
   TEST_3RF("fsor.d", datad,  64,  16, w31, w22, w9);
   TEST_3RF("fsor.d", datad,  64,  32, w28, w24, w19);
   TEST_3RF("fsor.d", datad,  64,  48, w30, w10, w30);
   TEST_3RF("fsor.d", datad,  64,  64, w8,  w11, w0);
   TEST_3RF("fsor.d", datad,  64,  80, w12, w8,  w24);
   TEST_3RF("fsor.d", datad,  64,  96, w16, w28, w17);
   TEST_3RF("fsor.d", datad,  64, 112, w17, w2,  w27);
   TEST_3RF("fsor.d", datad,  64, 128, w7,  w10, w26);
   TEST_3RF("fsor.d", datad,  64, 144, w12, w5,  w24);
   TEST_3RF("fsor.d", datad,  80,   0, w14, w14, w14);
   TEST_3RF("fsor.d", datad,  80,  16, w22, w17, w14);
   TEST_3RF("fsor.d", datad,  80,  32, w12, w7,  w23);
   TEST_3RF("fsor.d", datad,  80,  48, w8,  w0,  w11);
   TEST_3RF("fsor.d", datad,  80,  64, w6,  w10, w19);
   TEST_3RF("fsor.d", datad,  80,  80, w17, w19, w29);
   TEST_3RF("fsor.d", datad,  80,  96, w27, w11, w14);
   TEST_3RF("fsor.d", datad,  80, 112, w23, w28, w31);
   TEST_3RF("fsor.d", datad,  80, 128, w25, w25, w24);
   TEST_3RF("fsor.d", datad,  80, 144, w6,  w3,  w18);
   TEST_3RF("fsor.d", datad,  96,   0, w18, w9,  w10);
   TEST_3RF("fsor.d", datad,  96,  16, w1,  w31, w27);
   TEST_3RF("fsor.d", datad,  96,  32, w15, w12, w3);
   TEST_3RF("fsor.d", datad,  96,  48, w6,  w20, w3);
   TEST_3RF("fsor.d", datad,  96,  64, w17, w27, w13);
   TEST_3RF("fsor.d", datad,  96,  80, w4,  w12, w0);
   TEST_3RF("fsor.d", datad,  96,  96, w23, w10, w28);
   TEST_3RF("fsor.d", datad,  96, 112, w2,  w24, w19);
   TEST_3RF("fsor.d", datad,  96, 128, w31, w23, w13);
   TEST_3RF("fsor.d", datad,  96, 144, w23, w29, w16);
   TEST_3RF("fsor.d", datad, 112,   0, w9,  w15, w25);
   TEST_3RF("fsor.d", datad, 112,  16, w19, w16, w25);
   TEST_3RF("fsor.d", datad, 112,  32, w15, w31, w5);
   TEST_3RF("fsor.d", datad, 112,  48, w18, w6,  w25);
   TEST_3RF("fsor.d", datad, 112,  64, w21, w23, w20);
   TEST_3RF("fsor.d", datad, 112,  80, w2,  w28, w1);
   TEST_3RF("fsor.d", datad, 112,  96, w3,  w19, w11);
   TEST_3RF("fsor.d", datad, 112, 112, w31, w22, w3);
   TEST_3RF("fsor.d", datad, 112, 128, w18, w21, w26);
   TEST_3RF("fsor.d", datad, 112, 144, w31, w12, w23);
   TEST_3RF("fsor.d", datad, 128,   0, w16, w21, w6);
   TEST_3RF("fsor.d", datad, 128,  16, w9,  w8,  w23);
   TEST_3RF("fsor.d", datad, 128,  32, w2,  w23, w22);
   TEST_3RF("fsor.d", datad, 128,  48, w7,  w9,  w28);
   TEST_3RF("fsor.d", datad, 128,  64, w1,  w30, w20);
   TEST_3RF("fsor.d", datad, 128,  80, w21, w1,  w16);
   TEST_3RF("fsor.d", datad, 128,  96, w22, w4,  w3);
   TEST_3RF("fsor.d", datad, 128, 112, w1,  w3,  w25);
   TEST_3RF("fsor.d", datad, 128, 128, w4,  w21, w14);
   TEST_3RF("fsor.d", datad, 128, 144, w30, w21, w30);
   TEST_3RF("fsor.d", datad, 144,   0, w26, w21, w5);
   TEST_3RF("fsor.d", datad, 144,  16, w15, w28, w14);
   TEST_3RF("fsor.d", datad, 144,  32, w24, w19, w17);
   TEST_3RF("fsor.d", datad, 144,  48, w15, w9,  w24);
   TEST_3RF("fsor.d", datad, 144,  64, w25, w25, w6);
   TEST_3RF("fsor.d", datad, 144,  80, w25, w25, w23);
   TEST_3RF("fsor.d", datad, 144,  96, w26, w15, w24);
   TEST_3RF("fsor.d", datad, 144, 112, w10, w5,  w28);
   TEST_3RF("fsor.d", datad, 144, 128, w13, w7,  w31);
   TEST_3RF("fsor.d", datad, 144, 144, w7,  w11, w21);
   TEST_3RF("fsueq.w", dataf,   0,   0, w15, w31, w27);
   TEST_3RF("fsueq.w", dataf,   0,   8, w29, w23, w14);
   TEST_3RF("fsueq.w", dataf,   0,  16, w14, w7,  w24);
   TEST_3RF("fsueq.w", dataf,   0,  24, w7,  w0,  w30);
   TEST_3RF("fsueq.w", dataf,   0,  32, w0,  w23, w24);
   TEST_3RF("fsueq.w", dataf,   0,  40, w15, w16, w2);
   TEST_3RF("fsueq.w", dataf,   0,  48, w21, w21, w21);
   TEST_3RF("fsueq.w", dataf,   0,  56, w12, w15, w28);
   TEST_3RF("fsueq.w", dataf,   0,  64, w12, w22, w7);
   TEST_3RF("fsueq.w", dataf,   0,  72, w1,  w12, w17);
   TEST_3RF("fsueq.w", dataf,   8,   0, w11, w28, w17);
   TEST_3RF("fsueq.w", dataf,   8,   8, w26, w27, w12);
   TEST_3RF("fsueq.w", dataf,   8,  16, w23, w19, w27);
   TEST_3RF("fsueq.w", dataf,   8,  24, w6,  w26, w19);
   TEST_3RF("fsueq.w", dataf,   8,  32, w13, w26, w17);
   TEST_3RF("fsueq.w", dataf,   8,  40, w13, w17, w9);
   TEST_3RF("fsueq.w", dataf,   8,  48, w29, w1,  w11);
   TEST_3RF("fsueq.w", dataf,   8,  56, w18, w14, w26);
   TEST_3RF("fsueq.w", dataf,   8,  64, w14, w26, w17);
   TEST_3RF("fsueq.w", dataf,   8,  72, w21, w21, w21);
   TEST_3RF("fsueq.w", dataf,  16,   0, w27, w29, w7);
   TEST_3RF("fsueq.w", dataf,  16,   8, w6,  w25, w24);
   TEST_3RF("fsueq.w", dataf,  16,  16, w0,  w20, w4);
   TEST_3RF("fsueq.w", dataf,  16,  24, w23, w7,  w31);
   TEST_3RF("fsueq.w", dataf,  16,  32, w29, w1,  w18);
   TEST_3RF("fsueq.w", dataf,  16,  40, w10, w10, w27);
   TEST_3RF("fsueq.w", dataf,  16,  48, w3,  w24, w13);
   TEST_3RF("fsueq.w", dataf,  16,  56, w12, w21, w14);
   TEST_3RF("fsueq.w", dataf,  16,  64, w23, w7,  w28);
   TEST_3RF("fsueq.w", dataf,  16,  72, w18, w21, w22);
   TEST_3RF("fsueq.w", dataf,  24,   0, w3,  w10, w17);
   TEST_3RF("fsueq.w", dataf,  24,   8, w0,  w17, w23);
   TEST_3RF("fsueq.w", dataf,  24,  16, w25, w9,  w23);
   TEST_3RF("fsueq.w", dataf,  24,  24, w13, w14, w15);
   TEST_3RF("fsueq.w", dataf,  24,  32, w21, w21, w21);
   TEST_3RF("fsueq.w", dataf,  24,  40, w13, w12, w22);
   TEST_3RF("fsueq.w", dataf,  24,  48, w0,  w23, w18);
   TEST_3RF("fsueq.w", dataf,  24,  56, w3,  w15, w31);
   TEST_3RF("fsueq.w", dataf,  24,  64, w16, w4,  w16);
   TEST_3RF("fsueq.w", dataf,  24,  72, w13, w7,  w11);
   TEST_3RF("fsueq.w", dataf,  32,   0, w10, w10, w25);
   TEST_3RF("fsueq.w", dataf,  32,   8, w0,  w28, w10);
   TEST_3RF("fsueq.w", dataf,  32,  16, w18, w28, w9);
   TEST_3RF("fsueq.w", dataf,  32,  24, w21, w21, w21);
   TEST_3RF("fsueq.w", dataf,  32,  32, w5,  w1,  w3);
   TEST_3RF("fsueq.w", dataf,  32,  40, w19, w16, w24);
   TEST_3RF("fsueq.w", dataf,  32,  48, w1,  w28, w14);
   TEST_3RF("fsueq.w", dataf,  32,  56, w1,  w19, w0);
   TEST_3RF("fsueq.w", dataf,  32,  64, w4,  w2,  w31);
   TEST_3RF("fsueq.w", dataf,  32,  72, w20, w6,  w13);
   TEST_3RF("fsueq.w", dataf,  40,   0, w28, w17, w23);
   TEST_3RF("fsueq.w", dataf,  40,   8, w21, w21, w21);
   TEST_3RF("fsueq.w", dataf,  40,  16, w17, w23, w18);
   TEST_3RF("fsueq.w", dataf,  40,  24, w28, w9,  w14);
   TEST_3RF("fsueq.w", dataf,  40,  32, w24, w19, w4);
   TEST_3RF("fsueq.w", dataf,  40,  40, w29, w20, w7);
   TEST_3RF("fsueq.w", dataf,  40,  48, w17, w4,  w31);
   TEST_3RF("fsueq.w", dataf,  40,  56, w18, w0,  w13);
   TEST_3RF("fsueq.w", dataf,  40,  64, w19, w20, w14);
   TEST_3RF("fsueq.w", dataf,  40,  72, w23, w22, w13);
   TEST_3RF("fsueq.w", dataf,  48,   0, w12, w29, w26);
   TEST_3RF("fsueq.w", dataf,  48,   8, w8,  w14, w17);
   TEST_3RF("fsueq.w", dataf,  48,  16, w29, w0,  w9);
   TEST_3RF("fsueq.w", dataf,  48,  24, w15, w28, w18);
   TEST_3RF("fsueq.w", dataf,  48,  32, w30, w20, w5);
   TEST_3RF("fsueq.w", dataf,  48,  40, w2,  w17, w25);
   TEST_3RF("fsueq.w", dataf,  48,  48, w9,  w2,  w29);
   TEST_3RF("fsueq.w", dataf,  48,  56, w8,  w20, w30);
   TEST_3RF("fsueq.w", dataf,  48,  64, w21, w21, w21);
   TEST_3RF("fsueq.w", dataf,  48,  72, w7,  w18, w3);
   TEST_3RF("fsueq.w", dataf,  56,   0, w31, w8,  w8);
   TEST_3RF("fsueq.w", dataf,  56,   8, w17, w11, w5);
   TEST_3RF("fsueq.w", dataf,  56,  16, w11, w19, w20);
   TEST_3RF("fsueq.w", dataf,  56,  24, w29, w16, w20);
   TEST_3RF("fsueq.w", dataf,  56,  32, w6,  w0,  w16);
   TEST_3RF("fsueq.w", dataf,  56,  40, w24, w30, w4);
   TEST_3RF("fsueq.w", dataf,  56,  48, w30, w0,  w21);
   TEST_3RF("fsueq.w", dataf,  56,  56, w23, w9,  w24);
   TEST_3RF("fsueq.w", dataf,  56,  64, w21, w21, w21);
   TEST_3RF("fsueq.w", dataf,  56,  72, w17, w12, w19);
   TEST_3RF("fsueq.w", dataf,  64,   0, w6,  w20, w5);
   TEST_3RF("fsueq.w", dataf,  64,   8, w10, w10, w19);
   TEST_3RF("fsueq.w", dataf,  64,  16, w13, w27, w30);
   TEST_3RF("fsueq.w", dataf,  64,  24, w19, w6,  w17);
   TEST_3RF("fsueq.w", dataf,  64,  32, w7,  w3,  w1);
   TEST_3RF("fsueq.w", dataf,  64,  40, w27, w9,  w1);
   TEST_3RF("fsueq.w", dataf,  64,  48, w11, w2,  w31);
   TEST_3RF("fsueq.w", dataf,  64,  56, w15, w0,  w31);
   TEST_3RF("fsueq.w", dataf,  64,  64, w4,  w23, w8);
   TEST_3RF("fsueq.w", dataf,  64,  72, w28, w12, w25);
   TEST_3RF("fsueq.w", dataf,  72,   0, w9,  w31, w0);
   TEST_3RF("fsueq.w", dataf,  72,   8, w29, w4,  w10);
   TEST_3RF("fsueq.w", dataf,  72,  16, w16, w18, w16);
   TEST_3RF("fsueq.w", dataf,  72,  24, w5,  w14, w11);
   TEST_3RF("fsueq.w", dataf,  72,  32, w31, w12, w12);
   TEST_3RF("fsueq.w", dataf,  72,  40, w15, w0,  w7);
   TEST_3RF("fsueq.w", dataf,  72,  48, w24, w2,  w18);
   TEST_3RF("fsueq.w", dataf,  72,  56, w26, w1,  w5);
   TEST_3RF("fsueq.w", dataf,  72,  64, w18, w9,  w2);
   TEST_3RF("fsueq.w", dataf,  72,  72, w30, w3,  w11);
   TEST_3RF("fsueq.d", datad,   0,   0, w30, w3,  w8);
   TEST_3RF("fsueq.d", datad,   0,  16, w2,  w13, w24);
   TEST_3RF("fsueq.d", datad,   0,  32, w20, w18, w6);
   TEST_3RF("fsueq.d", datad,   0,  48, w25, w29, w5);
   TEST_3RF("fsueq.d", datad,   0,  64, w5,  w12, w7);
   TEST_3RF("fsueq.d", datad,   0,  80, w30, w31, w9);
   TEST_3RF("fsueq.d", datad,   0,  96, w31, w26, w26);
   TEST_3RF("fsueq.d", datad,   0, 112, w10, w10, w5);
   TEST_3RF("fsueq.d", datad,   0, 128, w12, w19, w7);
   TEST_3RF("fsueq.d", datad,   0, 144, w10, w10, w22);
   TEST_3RF("fsueq.d", datad,  16,   0, w18, w8,  w25);
   TEST_3RF("fsueq.d", datad,  16,  16, w26, w11, w6);
   TEST_3RF("fsueq.d", datad,  16,  32, w18, w31, w24);
   TEST_3RF("fsueq.d", datad,  16,  48, w24, w25, w22);
   TEST_3RF("fsueq.d", datad,  16,  64, w29, w30, w2);
   TEST_3RF("fsueq.d", datad,  16,  80, w2,  w11, w7);
   TEST_3RF("fsueq.d", datad,  16,  96, w10, w10, w9);
   TEST_3RF("fsueq.d", datad,  16, 112, w7,  w19, w9);
   TEST_3RF("fsueq.d", datad,  16, 128, w1,  w29, w14);
   TEST_3RF("fsueq.d", datad,  16, 144, w13, w16, w21);
   TEST_3RF("fsueq.d", datad,  32,   0, w23, w7,  w0);
   TEST_3RF("fsueq.d", datad,  32,  16, w0,  w1,  w11);
   TEST_3RF("fsueq.d", datad,  32,  32, w7,  w19, w10);
   TEST_3RF("fsueq.d", datad,  32,  48, w31, w11, w11);
   TEST_3RF("fsueq.d", datad,  32,  64, w3,  w21, w8);
   TEST_3RF("fsueq.d", datad,  32,  80, w2,  w24, w10);
   TEST_3RF("fsueq.d", datad,  32,  96, w13, w31, w20);
   TEST_3RF("fsueq.d", datad,  32, 112, w22, w6,  w7);
   TEST_3RF("fsueq.d", datad,  32, 128, w31, w7,  w7);
   TEST_3RF("fsueq.d", datad,  32, 144, w4,  w13, w20);
   TEST_3RF("fsueq.d", datad,  48,   0, w21, w21, w21);
   TEST_3RF("fsueq.d", datad,  48,  16, w2,  w12, w28);
   TEST_3RF("fsueq.d", datad,  48,  32, w9,  w12, w28);
   TEST_3RF("fsueq.d", datad,  48,  48, w10, w10, w23);
   TEST_3RF("fsueq.d", datad,  48,  64, w3,  w29, w1);
   TEST_3RF("fsueq.d", datad,  48,  80, w3,  w8,  w5);
   TEST_3RF("fsueq.d", datad,  48,  96, w24, w16, w7);
   TEST_3RF("fsueq.d", datad,  48, 112, w16, w27, w16);
   TEST_3RF("fsueq.d", datad,  48, 128, w20, w16, w15);
   TEST_3RF("fsueq.d", datad,  48, 144, w10, w10, w22);
   TEST_3RF("fsueq.d", datad,  64,   0, w23, w10, w30);
   TEST_3RF("fsueq.d", datad,  64,  16, w27, w23, w18);
   TEST_3RF("fsueq.d", datad,  64,  32, w16, w26, w16);
   TEST_3RF("fsueq.d", datad,  64,  48, w30, w12, w3);
   TEST_3RF("fsueq.d", datad,  64,  64, w10, w10, w9);
   TEST_3RF("fsueq.d", datad,  64,  80, w14, w1,  w12);
   TEST_3RF("fsueq.d", datad,  64,  96, w11, w3,  w15);
   TEST_3RF("fsueq.d", datad,  64, 112, w20, w8,  w4);
   TEST_3RF("fsueq.d", datad,  64, 128, w15, w24, w31);
   TEST_3RF("fsueq.d", datad,  64, 144, w3,  w8,  w15);
   TEST_3RF("fsueq.d", datad,  80,   0, w13, w31, w6);
   TEST_3RF("fsueq.d", datad,  80,  16, w23, w29, w1);
   TEST_3RF("fsueq.d", datad,  80,  32, w15, w18, w9);
   TEST_3RF("fsueq.d", datad,  80,  48, w14, w30, w12);
   TEST_3RF("fsueq.d", datad,  80,  64, w24, w7,  w26);
   TEST_3RF("fsueq.d", datad,  80,  80, w26, w20, w6);
   TEST_3RF("fsueq.d", datad,  80,  96, w29, w3,  w26);
   TEST_3RF("fsueq.d", datad,  80, 112, w5,  w11, w30);
   TEST_3RF("fsueq.d", datad,  80, 128, w20, w4,  w30);
   TEST_3RF("fsueq.d", datad,  80, 144, w23, w12, w13);
   TEST_3RF("fsueq.d", datad,  96,   0, w4,  w11, w19);
   TEST_3RF("fsueq.d", datad,  96,  16, w28, w8,  w20);
   TEST_3RF("fsueq.d", datad,  96,  32, w11, w24, w6);
   TEST_3RF("fsueq.d", datad,  96,  48, w20, w6,  w5);
   TEST_3RF("fsueq.d", datad,  96,  64, w0,  w30, w12);
   TEST_3RF("fsueq.d", datad,  96,  80, w27, w24, w0);
   TEST_3RF("fsueq.d", datad,  96,  96, w1,  w21, w4);
   TEST_3RF("fsueq.d", datad,  96, 112, w27, w26, w15);
   TEST_3RF("fsueq.d", datad,  96, 128, w25, w14, w19);
   TEST_3RF("fsueq.d", datad,  96, 144, w23, w5,  w0);
   TEST_3RF("fsueq.d", datad, 112,   0, w4,  w10, w11);
   TEST_3RF("fsueq.d", datad, 112,  16, w23, w6,  w20);
   TEST_3RF("fsueq.d", datad, 112,  32, w12, w17, w18);
   TEST_3RF("fsueq.d", datad, 112,  48, w5,  w18, w23);
   TEST_3RF("fsueq.d", datad, 112,  64, w5,  w16, w4);
   TEST_3RF("fsueq.d", datad, 112,  80, w0,  w9,  w4);
   TEST_3RF("fsueq.d", datad, 112,  96, w1,  w30, w8);
   TEST_3RF("fsueq.d", datad, 112, 112, w28, w25, w24);
   TEST_3RF("fsueq.d", datad, 112, 128, w22, w7,  w11);
   TEST_3RF("fsueq.d", datad, 112, 144, w13, w11, w18);
   TEST_3RF("fsueq.d", datad, 128,   0, w23, w9,  w29);
   TEST_3RF("fsueq.d", datad, 128,  16, w11, w21, w14);
   TEST_3RF("fsueq.d", datad, 128,  32, w23, w8,  w19);
   TEST_3RF("fsueq.d", datad, 128,  48, w9,  w31, w24);
   TEST_3RF("fsueq.d", datad, 128,  64, w25, w3,  w2);
   TEST_3RF("fsueq.d", datad, 128,  80, w8,  w26, w1);
   TEST_3RF("fsueq.d", datad, 128,  96, w16, w23, w16);
   TEST_3RF("fsueq.d", datad, 128, 112, w26, w8,  w13);
   TEST_3RF("fsueq.d", datad, 128, 128, w1,  w20, w26);
   TEST_3RF("fsueq.d", datad, 128, 144, w14, w31, w12);
   TEST_3RF("fsueq.d", datad, 144,   0, w5,  w22, w2);
   TEST_3RF("fsueq.d", datad, 144,  16, w1,  w11, w16);
   TEST_3RF("fsueq.d", datad, 144,  32, w24, w19, w3);
   TEST_3RF("fsueq.d", datad, 144,  48, w1,  w19, w28);
   TEST_3RF("fsueq.d", datad, 144,  64, w27, w22, w21);
   TEST_3RF("fsueq.d", datad, 144,  80, w29, w30, w15);
   TEST_3RF("fsueq.d", datad, 144,  96, w30, w15, w6);
   TEST_3RF("fsueq.d", datad, 144, 112, w24, w23, w19);
   TEST_3RF("fsueq.d", datad, 144, 128, w26, w11, w14);
   TEST_3RF("fsueq.d", datad, 144, 144, w8,  w11, w26);
   TEST_3RF("fsule.w", dataf,   0,   0, w28, w1,  w27);
   TEST_3RF("fsule.w", dataf,   0,   8, w15, w4,  w29);
   TEST_3RF("fsule.w", dataf,   0,  16, w2,  w0,  w24);
   TEST_3RF("fsule.w", dataf,   0,  24, w25, w21, w23);
   TEST_3RF("fsule.w", dataf,   0,  32, w5,  w20, w6);
   TEST_3RF("fsule.w", dataf,   0,  40, w11, w12, w30);
   TEST_3RF("fsule.w", dataf,   0,  48, w31, w6,  w9);
   TEST_3RF("fsule.w", dataf,   0,  56, w13, w15, w20);
   TEST_3RF("fsule.w", dataf,   0,  64, w7,  w29, w22);
   TEST_3RF("fsule.w", dataf,   0,  72, w24, w13, w25);
   TEST_3RF("fsule.w", dataf,   8,   0, w20, w14, w3);
   TEST_3RF("fsule.w", dataf,   8,   8, w19, w17, w6);
   TEST_3RF("fsule.w", dataf,   8,  16, w19, w9,  w31);
   TEST_3RF("fsule.w", dataf,   8,  24, w9,  w31, w22);
   TEST_3RF("fsule.w", dataf,   8,  32, w14, w14, w14);
   TEST_3RF("fsule.w", dataf,   8,  40, w19, w29, w25);
   TEST_3RF("fsule.w", dataf,   8,  48, w31, w27, w24);
   TEST_3RF("fsule.w", dataf,   8,  56, w6,  w4,  w5);
   TEST_3RF("fsule.w", dataf,   8,  64, w21, w25, w13);
   TEST_3RF("fsule.w", dataf,   8,  72, w18, w15, w5);
   TEST_3RF("fsule.w", dataf,  16,   0, w31, w8,  w25);
   TEST_3RF("fsule.w", dataf,  16,   8, w14, w14, w14);
   TEST_3RF("fsule.w", dataf,  16,  16, w28, w1,  w14);
   TEST_3RF("fsule.w", dataf,  16,  24, w2,  w20, w23);
   TEST_3RF("fsule.w", dataf,  16,  32, w1,  w1,  w29);
   TEST_3RF("fsule.w", dataf,  16,  40, w22, w24, w11);
   TEST_3RF("fsule.w", dataf,  16,  48, w9,  w21, w5);
   TEST_3RF("fsule.w", dataf,  16,  56, w9,  w16, w29);
   TEST_3RF("fsule.w", dataf,  16,  64, w15, w20, w3);
   TEST_3RF("fsule.w", dataf,  16,  72, w4,  w13, w16);
   TEST_3RF("fsule.w", dataf,  24,   0, w22, w28, w21);
   TEST_3RF("fsule.w", dataf,  24,   8, w21, w4,  w14);
   TEST_3RF("fsule.w", dataf,  24,  16, w3,  w1,  w1);
   TEST_3RF("fsule.w", dataf,  24,  24, w10, w4,  w15);
   TEST_3RF("fsule.w", dataf,  24,  32, w13, w25, w6);
   TEST_3RF("fsule.w", dataf,  24,  40, w14, w14, w14);
   TEST_3RF("fsule.w", dataf,  24,  48, w22, w29, w6);
   TEST_3RF("fsule.w", dataf,  24,  56, w2,  w6,  w27);
   TEST_3RF("fsule.w", dataf,  24,  64, w7,  w15, w11);
   TEST_3RF("fsule.w", dataf,  24,  72, w4,  w30, w0);
   TEST_3RF("fsule.w", dataf,  32,   0, w7,  w2,  w13);
   TEST_3RF("fsule.w", dataf,  32,   8, w23, w24, w10);
   TEST_3RF("fsule.w", dataf,  32,  16, w12, w14, w26);
   TEST_3RF("fsule.w", dataf,  32,  24, w17, w15, w5);
   TEST_3RF("fsule.w", dataf,  32,  32, w22, w30, w18);
   TEST_3RF("fsule.w", dataf,  32,  40, w15, w5,  w0);
   TEST_3RF("fsule.w", dataf,  32,  48, w5,  w2,  w7);
   TEST_3RF("fsule.w", dataf,  32,  56, w7,  w8,  w2);
   TEST_3RF("fsule.w", dataf,  32,  64, w14, w14, w14);
   TEST_3RF("fsule.w", dataf,  32,  72, w24, w14, w19);
   TEST_3RF("fsule.w", dataf,  40,   0, w22, w14, w26);
   TEST_3RF("fsule.w", dataf,  40,   8, w25, w27, w18);
   TEST_3RF("fsule.w", dataf,  40,  16, w17, w5,  w30);
   TEST_3RF("fsule.w", dataf,  40,  24, w31, w20, w25);
   TEST_3RF("fsule.w", dataf,  40,  32, w17, w3,  w30);
   TEST_3RF("fsule.w", dataf,  40,  40, w7,  w2,  w16);
   TEST_3RF("fsule.w", dataf,  40,  48, w22, w7,  w16);
   TEST_3RF("fsule.w", dataf,  40,  56, w27, w9,  w23);
   TEST_3RF("fsule.w", dataf,  40,  64, w3,  w17, w17);
   TEST_3RF("fsule.w", dataf,  40,  72, w26, w17, w9);
   TEST_3RF("fsule.w", dataf,  48,   0, w8,  w4,  w0);
   TEST_3RF("fsule.w", dataf,  48,   8, w22, w31, w25);
   TEST_3RF("fsule.w", dataf,  48,  16, w17, w10, w23);
   TEST_3RF("fsule.w", dataf,  48,  24, w15, w10, w11);
   TEST_3RF("fsule.w", dataf,  48,  32, w8,  w27, w14);
   TEST_3RF("fsule.w", dataf,  48,  40, w6,  w2,  w16);
   TEST_3RF("fsule.w", dataf,  48,  48, w22, w24, w23);
   TEST_3RF("fsule.w", dataf,  48,  56, w7,  w19, w0);
   TEST_3RF("fsule.w", dataf,  48,  64, w30, w22, w18);
   TEST_3RF("fsule.w", dataf,  48,  72, w24, w8,  w27);
   TEST_3RF("fsule.w", dataf,  56,   0, w0,  w12, w27);
   TEST_3RF("fsule.w", dataf,  56,   8, w22, w11, w20);
   TEST_3RF("fsule.w", dataf,  56,  16, w8,  w28, w31);
   TEST_3RF("fsule.w", dataf,  56,  24, w31, w12, w9);
   TEST_3RF("fsule.w", dataf,  56,  32, w10, w20, w4);
   TEST_3RF("fsule.w", dataf,  56,  40, w24, w27, w6);
   TEST_3RF("fsule.w", dataf,  56,  48, w9,  w17, w30);
   TEST_3RF("fsule.w", dataf,  56,  56, w0,  w24, w17);
   TEST_3RF("fsule.w", dataf,  56,  64, w1,  w1,  w23);
   TEST_3RF("fsule.w", dataf,  56,  72, w8,  w19, w15);
   TEST_3RF("fsule.w", dataf,  64,   0, w16, w14, w16);
   TEST_3RF("fsule.w", dataf,  64,   8, w16, w28, w16);
   TEST_3RF("fsule.w", dataf,  64,  16, w10, w6,  w8);
   TEST_3RF("fsule.w", dataf,  64,  24, w30, w14, w4);
   TEST_3RF("fsule.w", dataf,  64,  32, w29, w13, w16);
   TEST_3RF("fsule.w", dataf,  64,  40, w6,  w23, w5);
   TEST_3RF("fsule.w", dataf,  64,  48, w10, w16, w0);
   TEST_3RF("fsule.w", dataf,  64,  56, w16, w25, w16);
   TEST_3RF("fsule.w", dataf,  64,  64, w17, w14, w25);
   TEST_3RF("fsule.w", dataf,  64,  72, w10, w0,  w26);
   TEST_3RF("fsule.w", dataf,  72,   0, w1,  w1,  w8);
   TEST_3RF("fsule.w", dataf,  72,   8, w13, w16, w24);
   TEST_3RF("fsule.w", dataf,  72,  16, w28, w0,  w20);
   TEST_3RF("fsule.w", dataf,  72,  24, w6,  w7,  w28);
   TEST_3RF("fsule.w", dataf,  72,  32, w4,  w21, w1);
   TEST_3RF("fsule.w", dataf,  72,  40, w2,  w3,  w17);
   TEST_3RF("fsule.w", dataf,  72,  48, w8,  w26, w22);
   TEST_3RF("fsule.w", dataf,  72,  56, w19, w10, w22);
   TEST_3RF("fsule.w", dataf,  72,  64, w3,  w8,  w8);
   TEST_3RF("fsule.w", dataf,  72,  72, w18, w29, w23);
   TEST_3RF("fsule.d", datad,   0,   0, w19, w26, w5);
   TEST_3RF("fsule.d", datad,   0,  16, w3,  w18, w18);
   TEST_3RF("fsule.d", datad,   0,  32, w1,  w1,  w4);
   TEST_3RF("fsule.d", datad,   0,  48, w6,  w7,  w11);
   TEST_3RF("fsule.d", datad,   0,  64, w3,  w11, w11);
   TEST_3RF("fsule.d", datad,   0,  80, w0,  w4,  w13);
   TEST_3RF("fsule.d", datad,   0,  96, w3,  w21, w21);
   TEST_3RF("fsule.d", datad,   0, 112, w22, w30, w12);
   TEST_3RF("fsule.d", datad,   0, 128, w9,  w8,  w2);
   TEST_3RF("fsule.d", datad,   0, 144, w12, w10, w30);
   TEST_3RF("fsule.d", datad,  16,   0, w9,  w28, w16);
   TEST_3RF("fsule.d", datad,  16,  16, w0,  w15, w10);
   TEST_3RF("fsule.d", datad,  16,  32, w5,  w19, w28);
   TEST_3RF("fsule.d", datad,  16,  48, w6,  w23, w3);
   TEST_3RF("fsule.d", datad,  16,  64, w13, w2,  w6);
   TEST_3RF("fsule.d", datad,  16,  80, w25, w2,  w10);
   TEST_3RF("fsule.d", datad,  16,  96, w6,  w31, w28);
   TEST_3RF("fsule.d", datad,  16, 112, w4,  w11, w5);
   TEST_3RF("fsule.d", datad,  16, 128, w12, w14, w18);
   TEST_3RF("fsule.d", datad,  16, 144, w24, w16, w1);
   TEST_3RF("fsule.d", datad,  32,   0, w21, w1,  w2);
   TEST_3RF("fsule.d", datad,  32,  16, w4,  w11, w7);
   TEST_3RF("fsule.d", datad,  32,  32, w23, w8,  w14);
   TEST_3RF("fsule.d", datad,  32,  48, w14, w14, w14);
   TEST_3RF("fsule.d", datad,  32,  64, w11, w27, w16);
   TEST_3RF("fsule.d", datad,  32,  80, w17, w20, w19);
   TEST_3RF("fsule.d", datad,  32,  96, w27, w25, w26);
   TEST_3RF("fsule.d", datad,  32, 112, w23, w29, w6);
   TEST_3RF("fsule.d", datad,  32, 128, w29, w9,  w20);
   TEST_3RF("fsule.d", datad,  32, 144, w15, w2,  w12);
   TEST_3RF("fsule.d", datad,  48,   0, w31, w3,  w1);
   TEST_3RF("fsule.d", datad,  48,  16, w0,  w5,  w6);
   TEST_3RF("fsule.d", datad,  48,  32, w12, w13, w29);
   TEST_3RF("fsule.d", datad,  48,  48, w20, w27, w12);
   TEST_3RF("fsule.d", datad,  48,  64, w31, w22, w28);
   TEST_3RF("fsule.d", datad,  48,  80, w16, w11, w16);
   TEST_3RF("fsule.d", datad,  48,  96, w15, w11, w6);
   TEST_3RF("fsule.d", datad,  48, 112, w8,  w5,  w29);
   TEST_3RF("fsule.d", datad,  48, 128, w5,  w11, w26);
   TEST_3RF("fsule.d", datad,  48, 144, w15, w31, w9);
   TEST_3RF("fsule.d", datad,  64,   0, w17, w12, w9);
   TEST_3RF("fsule.d", datad,  64,  16, w20, w13, w9);
   TEST_3RF("fsule.d", datad,  64,  32, w26, w19, w21);
   TEST_3RF("fsule.d", datad,  64,  48, w7,  w17, w9);
   TEST_3RF("fsule.d", datad,  64,  64, w2,  w29, w8);
   TEST_3RF("fsule.d", datad,  64,  80, w24, w25, w3);
   TEST_3RF("fsule.d", datad,  64,  96, w9,  w3,  w17);
   TEST_3RF("fsule.d", datad,  64, 112, w9,  w7,  w23);
   TEST_3RF("fsule.d", datad,  64, 128, w20, w1,  w6);
   TEST_3RF("fsule.d", datad,  64, 144, w20, w11, w23);
   TEST_3RF("fsule.d", datad,  80,   0, w0,  w20, w11);
   TEST_3RF("fsule.d", datad,  80,  16, w13, w29, w5);
   TEST_3RF("fsule.d", datad,  80,  32, w1,  w1,  w19);
   TEST_3RF("fsule.d", datad,  80,  48, w12, w18, w28);
   TEST_3RF("fsule.d", datad,  80,  64, w14, w14, w14);
   TEST_3RF("fsule.d", datad,  80,  80, w15, w5,  w7);
   TEST_3RF("fsule.d", datad,  80,  96, w8,  w29, w10);
   TEST_3RF("fsule.d", datad,  80, 112, w17, w1,  w20);
   TEST_3RF("fsule.d", datad,  80, 128, w3,  w10, w10);
   TEST_3RF("fsule.d", datad,  80, 144, w27, w26, w30);
   TEST_3RF("fsule.d", datad,  96,   0, w28, w0,  w18);
   TEST_3RF("fsule.d", datad,  96,  16, w7,  w23, w18);
   TEST_3RF("fsule.d", datad,  96,  32, w27, w2,  w0);
   TEST_3RF("fsule.d", datad,  96,  48, w25, w8,  w1);
   TEST_3RF("fsule.d", datad,  96,  64, w12, w20, w19);
   TEST_3RF("fsule.d", datad,  96,  80, w8,  w3,  w2);
   TEST_3RF("fsule.d", datad,  96,  96, w13, w10, w11);
   TEST_3RF("fsule.d", datad,  96, 112, w20, w28, w12);
   TEST_3RF("fsule.d", datad,  96, 128, w8,  w31, w22);
   TEST_3RF("fsule.d", datad,  96, 144, w3,  w25, w25);
   TEST_3RF("fsule.d", datad, 112,   0, w20, w0,  w25);
   TEST_3RF("fsule.d", datad, 112,  16, w7,  w16, w25);
   TEST_3RF("fsule.d", datad, 112,  32, w3,  w18, w18);
   TEST_3RF("fsule.d", datad, 112,  48, w25, w28, w26);
   TEST_3RF("fsule.d", datad, 112,  64, w26, w8,  w15);
   TEST_3RF("fsule.d", datad, 112,  80, w13, w16, w18);
   TEST_3RF("fsule.d", datad, 112,  96, w15, w30, w28);
   TEST_3RF("fsule.d", datad, 112, 112, w26, w9,  w16);
   TEST_3RF("fsule.d", datad, 112, 128, w22, w21, w25);
   TEST_3RF("fsule.d", datad, 112, 144, w21, w11, w28);
   TEST_3RF("fsule.d", datad, 128,   0, w14, w14, w14);
   TEST_3RF("fsule.d", datad, 128,  16, w31, w28, w7);
   TEST_3RF("fsule.d", datad, 128,  32, w6,  w4,  w23);
   TEST_3RF("fsule.d", datad, 128,  48, w0,  w7,  w9);
   TEST_3RF("fsule.d", datad, 128,  64, w25, w3,  w4);
   TEST_3RF("fsule.d", datad, 128,  80, w20, w11, w19);
   TEST_3RF("fsule.d", datad, 128,  96, w1,  w1,  w27);
   TEST_3RF("fsule.d", datad, 128, 112, w5,  w17, w25);
   TEST_3RF("fsule.d", datad, 128, 128, w1,  w1,  w11);
   TEST_3RF("fsule.d", datad, 128, 144, w2,  w17, w1);
   TEST_3RF("fsule.d", datad, 144,   0, w23, w10, w22);
   TEST_3RF("fsule.d", datad, 144,  16, w2,  w7,  w4);
   TEST_3RF("fsule.d", datad, 144,  32, w2,  w3,  w11);
   TEST_3RF("fsule.d", datad, 144,  48, w8,  w7,  w2);
   TEST_3RF("fsule.d", datad, 144,  64, w8,  w14, w11);
   TEST_3RF("fsule.d", datad, 144,  80, w2,  w17, w15);
   TEST_3RF("fsule.d", datad, 144,  96, w22, w28, w2);
   TEST_3RF("fsule.d", datad, 144, 112, w23, w24, w7);
   TEST_3RF("fsule.d", datad, 144, 128, w8,  w17, w19);
   TEST_3RF("fsule.d", datad, 144, 144, w20, w26, w11);
   TEST_3RF("fsult.w", dataf,   0,   0, w14, w16, w14);
   TEST_3RF("fsult.w", dataf,   0,   8, w15, w25, w24);
   TEST_3RF("fsult.w", dataf,   0,  16, w22, w27, w1);
   TEST_3RF("fsult.w", dataf,   0,  24, w5,  w7,  w3);
   TEST_3RF("fsult.w", dataf,   0,  32, w22, w25, w19);
   TEST_3RF("fsult.w", dataf,   0,  40, w25, w16, w11);
   TEST_3RF("fsult.w", dataf,   0,  48, w0,  w25, w28);
   TEST_3RF("fsult.w", dataf,   0,  56, w9,  w12, w16);
   TEST_3RF("fsult.w", dataf,   0,  64, w3,  w1,  w28);
   TEST_3RF("fsult.w", dataf,   0,  72, w7,  w11, w10);
   TEST_3RF("fsult.w", dataf,   8,   0, w19, w26, w2);
   TEST_3RF("fsult.w", dataf,   8,   8, w19, w18, w24);
   TEST_3RF("fsult.w", dataf,   8,  16, w15, w19, w29);
   TEST_3RF("fsult.w", dataf,   8,  24, w22, w20, w12);
   TEST_3RF("fsult.w", dataf,   8,  32, w15, w7,  w5);
   TEST_3RF("fsult.w", dataf,   8,  40, w0,  w18, w6);
   TEST_3RF("fsult.w", dataf,   8,  48, w25, w14, w15);
   TEST_3RF("fsult.w", dataf,   8,  56, w5,  w31, w18);
   TEST_3RF("fsult.w", dataf,   8,  64, w6,  w27, w25);
   TEST_3RF("fsult.w", dataf,   8,  72, w18, w5,  w12);
   TEST_3RF("fsult.w", dataf,  16,   0, w12, w31, w14);
   TEST_3RF("fsult.w", dataf,  16,   8, w31, w17, w7);
   TEST_3RF("fsult.w", dataf,  16,  16, w14, w5,  w14);
   TEST_3RF("fsult.w", dataf,  16,  24, w4,  w4,  w4);
   TEST_3RF("fsult.w", dataf,  16,  32, w4,  w4,  w4);
   TEST_3RF("fsult.w", dataf,  16,  40, w27, w24, w17);
   TEST_3RF("fsult.w", dataf,  16,  48, w11, w31, w31);
   TEST_3RF("fsult.w", dataf,  16,  56, w22, w11, w17);
   TEST_3RF("fsult.w", dataf,  16,  64, w28, w4,  w0);
   TEST_3RF("fsult.w", dataf,  16,  72, w11, w9,  w9);
   TEST_3RF("fsult.w", dataf,  24,   0, w31, w29, w16);
   TEST_3RF("fsult.w", dataf,  24,   8, w26, w23, w2);
   TEST_3RF("fsult.w", dataf,  24,  16, w31, w3,  w14);
   TEST_3RF("fsult.w", dataf,  24,  24, w30, w18, w13);
   TEST_3RF("fsult.w", dataf,  24,  32, w15, w25, w28);
   TEST_3RF("fsult.w", dataf,  24,  40, w20, w29, w0);
   TEST_3RF("fsult.w", dataf,  24,  48, w16, w22, w17);
   TEST_3RF("fsult.w", dataf,  24,  56, w27, w21, w8);
   TEST_3RF("fsult.w", dataf,  24,  64, w6,  w7,  w4);
   TEST_3RF("fsult.w", dataf,  24,  72, w10, w10, w7);
   TEST_3RF("fsult.w", dataf,  32,   0, w16, w19, w6);
   TEST_3RF("fsult.w", dataf,  32,   8, w13, w3,  w0);
   TEST_3RF("fsult.w", dataf,  32,  16, w4,  w4,  w4);
   TEST_3RF("fsult.w", dataf,  32,  24, w5,  w31, w8);
   TEST_3RF("fsult.w", dataf,  32,  32, w19, w29, w26);
   TEST_3RF("fsult.w", dataf,  32,  40, w1,  w12, w19);
   TEST_3RF("fsult.w", dataf,  32,  48, w29, w1,  w16);
   TEST_3RF("fsult.w", dataf,  32,  56, w29, w17, w6);
   TEST_3RF("fsult.w", dataf,  32,  64, w15, w12, w28);
   TEST_3RF("fsult.w", dataf,  32,  72, w23, w18, w3);
   TEST_3RF("fsult.w", dataf,  40,   0, w27, w28, w10);
   TEST_3RF("fsult.w", dataf,  40,   8, w11, w15, w15);
   TEST_3RF("fsult.w", dataf,  40,  16, w16, w25, w19);
   TEST_3RF("fsult.w", dataf,  40,  24, w16, w29, w24);
   TEST_3RF("fsult.w", dataf,  40,  32, w15, w5,  w12);
   TEST_3RF("fsult.w", dataf,  40,  40, w12, w31, w13);
   TEST_3RF("fsult.w", dataf,  40,  48, w24, w18, w10);
   TEST_3RF("fsult.w", dataf,  40,  56, w25, w3,  w7);
   TEST_3RF("fsult.w", dataf,  40,  64, w10, w10, w9);
   TEST_3RF("fsult.w", dataf,  40,  72, w22, w5,  w13);
   TEST_3RF("fsult.w", dataf,  48,   0, w8,  w9,  w4);
   TEST_3RF("fsult.w", dataf,  48,   8, w18, w20, w2);
   TEST_3RF("fsult.w", dataf,  48,  16, w13, w7,  w18);
   TEST_3RF("fsult.w", dataf,  48,  24, w11, w31, w31);
   TEST_3RF("fsult.w", dataf,  48,  32, w1,  w16, w11);
   TEST_3RF("fsult.w", dataf,  48,  40, w13, w16, w24);
   TEST_3RF("fsult.w", dataf,  48,  48, w6,  w2,  w31);
   TEST_3RF("fsult.w", dataf,  48,  56, w5,  w10, w15);
   TEST_3RF("fsult.w", dataf,  48,  64, w0,  w20, w14);
   TEST_3RF("fsult.w", dataf,  48,  72, w9,  w29, w23);
   TEST_3RF("fsult.w", dataf,  56,   0, w13, w15, w11);
   TEST_3RF("fsult.w", dataf,  56,   8, w1,  w18, w25);
   TEST_3RF("fsult.w", dataf,  56,  16, w8,  w4,  w6);
   TEST_3RF("fsult.w", dataf,  56,  24, w20, w19, w4);
   TEST_3RF("fsult.w", dataf,  56,  32, w12, w25, w7);
   TEST_3RF("fsult.w", dataf,  56,  40, w14, w25, w14);
   TEST_3RF("fsult.w", dataf,  56,  48, w12, w24, w3);
   TEST_3RF("fsult.w", dataf,  56,  56, w27, w25, w3);
   TEST_3RF("fsult.w", dataf,  56,  64, w16, w7,  w12);
   TEST_3RF("fsult.w", dataf,  56,  72, w13, w30, w26);
   TEST_3RF("fsult.w", dataf,  64,   0, w28, w9,  w27);
   TEST_3RF("fsult.w", dataf,  64,   8, w14, w2,  w14);
   TEST_3RF("fsult.w", dataf,  64,  16, w4,  w4,  w4);
   TEST_3RF("fsult.w", dataf,  64,  24, w19, w6,  w12);
   TEST_3RF("fsult.w", dataf,  64,  32, w25, w27, w31);
   TEST_3RF("fsult.w", dataf,  64,  40, w12, w31, w11);
   TEST_3RF("fsult.w", dataf,  64,  48, w6,  w26, w31);
   TEST_3RF("fsult.w", dataf,  64,  56, w19, w18, w2);
   TEST_3RF("fsult.w", dataf,  64,  64, w14, w11, w14);
   TEST_3RF("fsult.w", dataf,  64,  72, w5,  w30, w18);
   TEST_3RF("fsult.w", dataf,  72,   0, w18, w11, w16);
   TEST_3RF("fsult.w", dataf,  72,   8, w12, w8,  w26);
   TEST_3RF("fsult.w", dataf,  72,  16, w7,  w22, w28);
   TEST_3RF("fsult.w", dataf,  72,  24, w11, w9,  w9);
   TEST_3RF("fsult.w", dataf,  72,  32, w3,  w23, w2);
   TEST_3RF("fsult.w", dataf,  72,  40, w30, w23, w15);
   TEST_3RF("fsult.w", dataf,  72,  48, w29, w2,  w21);
   TEST_3RF("fsult.w", dataf,  72,  56, w4,  w4,  w4);
   TEST_3RF("fsult.w", dataf,  72,  64, w28, w20, w23);
   TEST_3RF("fsult.w", dataf,  72,  72, w15, w22, w5);
   TEST_3RF("fsult.d", datad,   0,   0, w26, w27, w4);
   TEST_3RF("fsult.d", datad,   0,  16, w13, w15, w29);
   TEST_3RF("fsult.d", datad,   0,  32, w25, w23, w1);
   TEST_3RF("fsult.d", datad,   0,  48, w14, w20, w14);
   TEST_3RF("fsult.d", datad,   0,  64, w12, w23, w4);
   TEST_3RF("fsult.d", datad,   0,  80, w26, w21, w27);
   TEST_3RF("fsult.d", datad,   0,  96, w9,  w18, w29);
   TEST_3RF("fsult.d", datad,   0, 112, w30, w22, w26);
   TEST_3RF("fsult.d", datad,   0, 128, w18, w13, w9);
   TEST_3RF("fsult.d", datad,   0, 144, w8,  w19, w3);
   TEST_3RF("fsult.d", datad,  16,   0, w3,  w23, w16);
   TEST_3RF("fsult.d", datad,  16,  16, w17, w6,  w14);
   TEST_3RF("fsult.d", datad,  16,  32, w10, w10, w30);
   TEST_3RF("fsult.d", datad,  16,  48, w5,  w11, w12);
   TEST_3RF("fsult.d", datad,  16,  64, w25, w24, w3);
   TEST_3RF("fsult.d", datad,  16,  80, w16, w28, w29);
   TEST_3RF("fsult.d", datad,  16,  96, w5,  w23, w6);
   TEST_3RF("fsult.d", datad,  16, 112, w24, w20, w4);
   TEST_3RF("fsult.d", datad,  16, 128, w14, w22, w14);
   TEST_3RF("fsult.d", datad,  16, 144, w28, w23, w30);
   TEST_3RF("fsult.d", datad,  32,   0, w15, w27, w2);
   TEST_3RF("fsult.d", datad,  32,  16, w6,  w11, w19);
   TEST_3RF("fsult.d", datad,  32,  32, w12, w25, w29);
   TEST_3RF("fsult.d", datad,  32,  48, w10, w10, w31);
   TEST_3RF("fsult.d", datad,  32,  64, w9,  w22, w24);
   TEST_3RF("fsult.d", datad,  32,  80, w1,  w26, w9);
   TEST_3RF("fsult.d", datad,  32,  96, w29, w23, w14);
   TEST_3RF("fsult.d", datad,  32, 112, w20, w30, w6);
   TEST_3RF("fsult.d", datad,  32, 128, w8,  w2,  w21);
   TEST_3RF("fsult.d", datad,  32, 144, w23, w25, w17);
   TEST_3RF("fsult.d", datad,  48,   0, w14, w23, w14);
   TEST_3RF("fsult.d", datad,  48,  16, w0,  w9,  w25);
   TEST_3RF("fsult.d", datad,  48,  32, w6,  w21, w12);
   TEST_3RF("fsult.d", datad,  48,  48, w18, w14, w10);
   TEST_3RF("fsult.d", datad,  48,  64, w29, w13, w19);
   TEST_3RF("fsult.d", datad,  48,  80, w19, w6,  w20);
   TEST_3RF("fsult.d", datad,  48,  96, w13, w15, w17);
   TEST_3RF("fsult.d", datad,  48, 112, w5,  w29, w3);
   TEST_3RF("fsult.d", datad,  48, 128, w4,  w4,  w4);
   TEST_3RF("fsult.d", datad,  48, 144, w13, w5,  w25);
   TEST_3RF("fsult.d", datad,  64,   0, w4,  w4,  w4);
   TEST_3RF("fsult.d", datad,  64,  16, w30, w10, w19);
   TEST_3RF("fsult.d", datad,  64,  32, w22, w10, w28);
   TEST_3RF("fsult.d", datad,  64,  48, w15, w16, w17);
   TEST_3RF("fsult.d", datad,  64,  64, w28, w2,  w0);
   TEST_3RF("fsult.d", datad,  64,  80, w6,  w31, w13);
   TEST_3RF("fsult.d", datad,  64,  96, w25, w19, w13);
   TEST_3RF("fsult.d", datad,  64, 112, w0,  w2,  w30);
   TEST_3RF("fsult.d", datad,  64, 128, w5,  w0,  w3);
   TEST_3RF("fsult.d", datad,  64, 144, w8,  w4,  w16);
   TEST_3RF("fsult.d", datad,  80,   0, w14, w29, w14);
   TEST_3RF("fsult.d", datad,  80,  16, w21, w12, w7);
   TEST_3RF("fsult.d", datad,  80,  32, w8,  w2,  w17);
   TEST_3RF("fsult.d", datad,  80,  48, w4,  w4,  w4);
   TEST_3RF("fsult.d", datad,  80,  64, w18, w1,  w22);
   TEST_3RF("fsult.d", datad,  80,  80, w14, w3,  w14);
   TEST_3RF("fsult.d", datad,  80,  96, w22, w20, w3);
   TEST_3RF("fsult.d", datad,  80, 112, w3,  w13, w22);
   TEST_3RF("fsult.d", datad,  80, 128, w23, w26, w22);
   TEST_3RF("fsult.d", datad,  80, 144, w25, w24, w28);
   TEST_3RF("fsult.d", datad,  96,   0, w25, w27, w4);
   TEST_3RF("fsult.d", datad,  96,  16, w29, w11, w18);
   TEST_3RF("fsult.d", datad,  96,  32, w26, w0,  w31);
   TEST_3RF("fsult.d", datad,  96,  48, w1,  w8,  w18);
   TEST_3RF("fsult.d", datad,  96,  64, w13, w19, w3);
   TEST_3RF("fsult.d", datad,  96,  80, w1,  w23, w25);
   TEST_3RF("fsult.d", datad,  96,  96, w21, w26, w28);
   TEST_3RF("fsult.d", datad,  96, 112, w2,  w16, w19);
   TEST_3RF("fsult.d", datad,  96, 128, w28, w6,  w13);
   TEST_3RF("fsult.d", datad,  96, 144, w20, w2,  w6);
   TEST_3RF("fsult.d", datad, 112,   0, w15, w7,  w4);
   TEST_3RF("fsult.d", datad, 112,  16, w27, w25, w30);
   TEST_3RF("fsult.d", datad, 112,  32, w27, w24, w0);
   TEST_3RF("fsult.d", datad, 112,  48, w4,  w4,  w4);
   TEST_3RF("fsult.d", datad, 112,  64, w26, w18, w17);
   TEST_3RF("fsult.d", datad, 112,  80, w13, w6,  w20);
   TEST_3RF("fsult.d", datad, 112,  96, w15, w29, w13);
   TEST_3RF("fsult.d", datad, 112, 112, w4,  w4,  w4);
   TEST_3RF("fsult.d", datad, 112, 128, w23, w9,  w7);
   TEST_3RF("fsult.d", datad, 112, 144, w7,  w29, w3);
   TEST_3RF("fsult.d", datad, 128,   0, w13, w10, w24);
   TEST_3RF("fsult.d", datad, 128,  16, w16, w7,  w23);
   TEST_3RF("fsult.d", datad, 128,  32, w20, w2,  w16);
   TEST_3RF("fsult.d", datad, 128,  48, w19, w30, w9);
   TEST_3RF("fsult.d", datad, 128,  64, w19, w2,  w3);
   TEST_3RF("fsult.d", datad, 128,  80, w5,  w19, w16);
   TEST_3RF("fsult.d", datad, 128,  96, w11, w7,  w7);
   TEST_3RF("fsult.d", datad, 128, 112, w31, w8,  w20);
   TEST_3RF("fsult.d", datad, 128, 128, w4,  w4,  w4);
   TEST_3RF("fsult.d", datad, 128, 144, w31, w29, w11);
   TEST_3RF("fsult.d", datad, 144,   0, w6,  w26, w14);
   TEST_3RF("fsult.d", datad, 144,  16, w20, w4,  w6);
   TEST_3RF("fsult.d", datad, 144,  32, w4,  w4,  w4);
   TEST_3RF("fsult.d", datad, 144,  48, w21, w14, w27);
   TEST_3RF("fsult.d", datad, 144,  64, w9,  w16, w11);
   TEST_3RF("fsult.d", datad, 144,  80, w28, w14, w20);
   TEST_3RF("fsult.d", datad, 144,  96, w15, w16, w23);
   TEST_3RF("fsult.d", datad, 144, 112, w21, w3,  w8);
   TEST_3RF("fsult.d", datad, 144, 128, w0,  w10, w7);
   TEST_3RF("fsult.d", datad, 144, 144, w9,  w30, w11);
   TEST_3RF("fsun.w", dataf,   0,   0, w22, w5,  w22);
   TEST_3RF("fsun.w", dataf,   0,   8, w3,  w27, w11);
   TEST_3RF("fsun.w", dataf,   0,  16, w7,  w16, w25);
   TEST_3RF("fsun.w", dataf,   0,  24, w2,  w25, w10);
   TEST_3RF("fsun.w", dataf,   0,  32, w13, w22, w24);
   TEST_3RF("fsun.w", dataf,   0,  40, w2,  w5,  w9);
   TEST_3RF("fsun.w", dataf,   0,  48, w25, w26, w12);
   TEST_3RF("fsun.w", dataf,   0,  56, w1,  w27, w23);
   TEST_3RF("fsun.w", dataf,   0,  64, w9,  w4,  w21);
   TEST_3RF("fsun.w", dataf,   0,  72, w20, w12, w17);
   TEST_3RF("fsun.w", dataf,   8,   0, w11, w27, w8);
   TEST_3RF("fsun.w", dataf,   8,   8, w16, w30, w3);
   TEST_3RF("fsun.w", dataf,   8,  16, w27, w5,  w19);
   TEST_3RF("fsun.w", dataf,   8,  24, w21, w7,  w12);
   TEST_3RF("fsun.w", dataf,   8,  32, w31, w21, w2);
   TEST_3RF("fsun.w", dataf,   8,  40, w23, w8,  w0);
   TEST_3RF("fsun.w", dataf,   8,  48, w16, w2,  w13);
   TEST_3RF("fsun.w", dataf,   8,  56, w18, w29, w4);
   TEST_3RF("fsun.w", dataf,   8,  64, w27, w1,  w25);
   TEST_3RF("fsun.w", dataf,   8,  72, w15, w14, w14);
   TEST_3RF("fsun.w", dataf,  16,   0, w11, w26, w9);
   TEST_3RF("fsun.w", dataf,  16,   8, w19, w10, w8);
   TEST_3RF("fsun.w", dataf,  16,  16, w22, w6,  w22);
   TEST_3RF("fsun.w", dataf,  16,  24, w13, w9,  w27);
   TEST_3RF("fsun.w", dataf,  16,  32, w21, w26, w10);
   TEST_3RF("fsun.w", dataf,  16,  40, w24, w17, w1);
   TEST_3RF("fsun.w", dataf,  16,  48, w0,  w18, w17);
   TEST_3RF("fsun.w", dataf,  16,  56, w2,  w31, w3);
   TEST_3RF("fsun.w", dataf,  16,  64, w0,  w3,  w30);
   TEST_3RF("fsun.w", dataf,  16,  72, w1,  w28, w14);
   TEST_3RF("fsun.w", dataf,  24,   0, w15, w7,  w7);
   TEST_3RF("fsun.w", dataf,  24,   8, w8,  w8,  w8);
   TEST_3RF("fsun.w", dataf,  24,  16, w25, w26, w19);
   TEST_3RF("fsun.w", dataf,  24,  24, w1,  w16, w25);
   TEST_3RF("fsun.w", dataf,  24,  32, w14, w25, w20);
   TEST_3RF("fsun.w", dataf,  24,  40, w3,  w15, w14);
   TEST_3RF("fsun.w", dataf,  24,  48, w13, w7,  w31);
   TEST_3RF("fsun.w", dataf,  24,  56, w14, w7,  w17);
   TEST_3RF("fsun.w", dataf,  24,  64, w0,  w9,  w16);
   TEST_3RF("fsun.w", dataf,  24,  72, w3,  w9,  w19);
   TEST_3RF("fsun.w", dataf,  32,   0, w2,  w11, w16);
   TEST_3RF("fsun.w", dataf,  32,   8, w16, w26, w23);
   TEST_3RF("fsun.w", dataf,  32,  16, w24, w19, w18);
   TEST_3RF("fsun.w", dataf,  32,  24, w11, w20, w2);
   TEST_3RF("fsun.w", dataf,  32,  32, w4,  w3,  w28);
   TEST_3RF("fsun.w", dataf,  32,  40, w24, w6,  w11);
   TEST_3RF("fsun.w", dataf,  32,  48, w6,  w20, w18);
   TEST_3RF("fsun.w", dataf,  32,  56, w6,  w2,  w25);
   TEST_3RF("fsun.w", dataf,  32,  64, w23, w2,  w8);
   TEST_3RF("fsun.w", dataf,  32,  72, w6,  w12, w27);
   TEST_3RF("fsun.w", dataf,  40,   0, w8,  w8,  w8);
   TEST_3RF("fsun.w", dataf,  40,   8, w23, w11, w24);
   TEST_3RF("fsun.w", dataf,  40,  16, w17, w3,  w16);
   TEST_3RF("fsun.w", dataf,  40,  24, w5,  w21, w28);
   TEST_3RF("fsun.w", dataf,  40,  32, w25, w23, w0);
   TEST_3RF("fsun.w", dataf,  40,  40, w28, w28, w19);
   TEST_3RF("fsun.w", dataf,  40,  48, w25, w3,  w30);
   TEST_3RF("fsun.w", dataf,  40,  56, w31, w23, w16);
   TEST_3RF("fsun.w", dataf,  40,  64, w5,  w25, w9);
   TEST_3RF("fsun.w", dataf,  40,  72, w29, w28, w12);
   TEST_3RF("fsun.w", dataf,  48,   0, w5,  w2,  w24);
   TEST_3RF("fsun.w", dataf,  48,   8, w0,  w10, w15);
   TEST_3RF("fsun.w", dataf,  48,  16, w12, w2,  w0);
   TEST_3RF("fsun.w", dataf,  48,  24, w15, w18, w18);
   TEST_3RF("fsun.w", dataf,  48,  32, w5,  w4,  w14);
   TEST_3RF("fsun.w", dataf,  48,  40, w31, w27, w15);
   TEST_3RF("fsun.w", dataf,  48,  48, w27, w15, w8);
   TEST_3RF("fsun.w", dataf,  48,  56, w30, w13, w7);
   TEST_3RF("fsun.w", dataf,  48,  64, w21, w30, w13);
   TEST_3RF("fsun.w", dataf,  48,  72, w15, w7,  w7);
   TEST_3RF("fsun.w", dataf,  56,   0, w10, w11, w19);
   TEST_3RF("fsun.w", dataf,  56,   8, w15, w13, w13);
   TEST_3RF("fsun.w", dataf,  56,  16, w11, w15, w23);
   TEST_3RF("fsun.w", dataf,  56,  24, w26, w27, w25);
   TEST_3RF("fsun.w", dataf,  56,  32, w27, w10, w11);
   TEST_3RF("fsun.w", dataf,  56,  40, w0,  w14, w26);
   TEST_3RF("fsun.w", dataf,  56,  48, w31, w10, w9);
   TEST_3RF("fsun.w", dataf,  56,  56, w27, w25, w17);
   TEST_3RF("fsun.w", dataf,  56,  64, w25, w6,  w24);
   TEST_3RF("fsun.w", dataf,  56,  72, w15, w4,  w4);
   TEST_3RF("fsun.w", dataf,  64,   0, w5,  w30, w12);
   TEST_3RF("fsun.w", dataf,  64,   8, w15, w9,  w9);
   TEST_3RF("fsun.w", dataf,  64,  16, w31, w30, w22);
   TEST_3RF("fsun.w", dataf,  64,  24, w11, w14, w13);
   TEST_3RF("fsun.w", dataf,  64,  32, w5,  w9,  w6);
   TEST_3RF("fsun.w", dataf,  64,  40, w0,  w20, w17);
   TEST_3RF("fsun.w", dataf,  64,  48, w1,  w2,  w11);
   TEST_3RF("fsun.w", dataf,  64,  56, w0,  w12, w20);
   TEST_3RF("fsun.w", dataf,  64,  64, w27, w5,  w21);
   TEST_3RF("fsun.w", dataf,  64,  72, w12, w30, w4);
   TEST_3RF("fsun.w", dataf,  72,   0, w16, w3,  w2);
   TEST_3RF("fsun.w", dataf,  72,   8, w28, w28, w19);
   TEST_3RF("fsun.w", dataf,  72,  16, w11, w28, w17);
   TEST_3RF("fsun.w", dataf,  72,  24, w1,  w7,  w31);
   TEST_3RF("fsun.w", dataf,  72,  32, w14, w12, w9);
   TEST_3RF("fsun.w", dataf,  72,  40, w20, w13, w29);
   TEST_3RF("fsun.w", dataf,  72,  48, w5,  w14, w31);
   TEST_3RF("fsun.w", dataf,  72,  56, w17, w14, w12);
   TEST_3RF("fsun.w", dataf,  72,  64, w5,  w10, w17);
   TEST_3RF("fsun.w", dataf,  72,  72, w11, w31, w29);
   TEST_3RF("fsun.d", datad,   0,   0, w9,  w3,  w14);
   TEST_3RF("fsun.d", datad,   0,  16, w12, w5,  w10);
   TEST_3RF("fsun.d", datad,   0,  32, w31, w16, w6);
   TEST_3RF("fsun.d", datad,   0,  48, w17, w13, w16);
   TEST_3RF("fsun.d", datad,   0,  64, w31, w26, w25);
   TEST_3RF("fsun.d", datad,   0,  80, w19, w7,  w22);
   TEST_3RF("fsun.d", datad,   0,  96, w24, w21, w22);
   TEST_3RF("fsun.d", datad,   0, 112, w9,  w3,  w2);
   TEST_3RF("fsun.d", datad,   0, 128, w15, w13, w13);
   TEST_3RF("fsun.d", datad,   0, 144, w19, w26, w12);
   TEST_3RF("fsun.d", datad,  16,   0, w17, w3,  w15);
   TEST_3RF("fsun.d", datad,  16,  16, w31, w15, w20);
   TEST_3RF("fsun.d", datad,  16,  32, w9,  w15, w4);
   TEST_3RF("fsun.d", datad,  16,  48, w16, w0,  w21);
   TEST_3RF("fsun.d", datad,  16,  64, w29, w16, w20);
   TEST_3RF("fsun.d", datad,  16,  80, w23, w10, w7);
   TEST_3RF("fsun.d", datad,  16,  96, w30, w0,  w19);
   TEST_3RF("fsun.d", datad,  16, 112, w22, w9,  w22);
   TEST_3RF("fsun.d", datad,  16, 128, w23, w24, w4);
   TEST_3RF("fsun.d", datad,  16, 144, w12, w18, w17);
   TEST_3RF("fsun.d", datad,  32,   0, w29, w21, w0);
   TEST_3RF("fsun.d", datad,  32,  16, w28, w28, w5);
   TEST_3RF("fsun.d", datad,  32,  32, w21, w5,  w20);
   TEST_3RF("fsun.d", datad,  32,  48, w25, w21, w20);
   TEST_3RF("fsun.d", datad,  32,  64, w15, w19, w19);
   TEST_3RF("fsun.d", datad,  32,  80, w4,  w3,  w10);
   TEST_3RF("fsun.d", datad,  32,  96, w14, w11, w9);
   TEST_3RF("fsun.d", datad,  32, 112, w15, w11, w11);
   TEST_3RF("fsun.d", datad,  32, 128, w28, w28, w5);
   TEST_3RF("fsun.d", datad,  32, 144, w20, w19, w30);
   TEST_3RF("fsun.d", datad,  48,   0, w13, w24, w10);
   TEST_3RF("fsun.d", datad,  48,  16, w31, w9,  w7);
   TEST_3RF("fsun.d", datad,  48,  32, w21, w9,  w3);
   TEST_3RF("fsun.d", datad,  48,  48, w26, w30, w8);
   TEST_3RF("fsun.d", datad,  48,  64, w14, w24, w30);
   TEST_3RF("fsun.d", datad,  48,  80, w2,  w7,  w17);
   TEST_3RF("fsun.d", datad,  48,  96, w6,  w10, w27);
   TEST_3RF("fsun.d", datad,  48, 112, w21, w4,  w0);
   TEST_3RF("fsun.d", datad,  48, 128, w1,  w9,  w21);
   TEST_3RF("fsun.d", datad,  48, 144, w20, w7,  w2);
   TEST_3RF("fsun.d", datad,  64,   0, w12, w17, w1);
   TEST_3RF("fsun.d", datad,  64,  16, w21, w24, w22);
   TEST_3RF("fsun.d", datad,  64,  32, w31, w27, w16);
   TEST_3RF("fsun.d", datad,  64,  48, w29, w4,  w30);
   TEST_3RF("fsun.d", datad,  64,  64, w21, w2,  w0);
   TEST_3RF("fsun.d", datad,  64,  80, w28, w28, w19);
   TEST_3RF("fsun.d", datad,  64,  96, w7,  w14, w28);
   TEST_3RF("fsun.d", datad,  64, 112, w28, w28, w19);
   TEST_3RF("fsun.d", datad,  64, 128, w0,  w29, w20);
   TEST_3RF("fsun.d", datad,  64, 144, w9,  w18, w8);
   TEST_3RF("fsun.d", datad,  80,   0, w17, w20, w21);
   TEST_3RF("fsun.d", datad,  80,  16, w2,  w21, w10);
   TEST_3RF("fsun.d", datad,  80,  32, w27, w12, w9);
   TEST_3RF("fsun.d", datad,  80,  48, w22, w28, w22);
   TEST_3RF("fsun.d", datad,  80,  64, w7,  w26, w27);
   TEST_3RF("fsun.d", datad,  80,  80, w28, w28, w27);
   TEST_3RF("fsun.d", datad,  80,  96, w25, w15, w2);
   TEST_3RF("fsun.d", datad,  80, 112, w0,  w30, w28);
   TEST_3RF("fsun.d", datad,  80, 128, w17, w30, w25);
   TEST_3RF("fsun.d", datad,  80, 144, w5,  w8,  w11);
   TEST_3RF("fsun.d", datad,  96,   0, w13, w25, w31);
   TEST_3RF("fsun.d", datad,  96,  16, w2,  w27, w21);
   TEST_3RF("fsun.d", datad,  96,  32, w13, w22, w1);
   TEST_3RF("fsun.d", datad,  96,  48, w22, w13, w22);
   TEST_3RF("fsun.d", datad,  96,  64, w29, w7,  w24);
   TEST_3RF("fsun.d", datad,  96,  80, w26, w4,  w20);
   TEST_3RF("fsun.d", datad,  96,  96, w19, w22, w17);
   TEST_3RF("fsun.d", datad,  96, 112, w21, w15, w2);
   TEST_3RF("fsun.d", datad,  96, 128, w19, w9,  w7);
   TEST_3RF("fsun.d", datad,  96, 144, w27, w20, w21);
   TEST_3RF("fsun.d", datad, 112,   0, w20, w23, w16);
   TEST_3RF("fsun.d", datad, 112,  16, w9,  w4,  w6);
   TEST_3RF("fsun.d", datad, 112,  32, w10, w27, w19);
   TEST_3RF("fsun.d", datad, 112,  48, w7,  w24, w27);
   TEST_3RF("fsun.d", datad, 112,  64, w0,  w18, w31);
   TEST_3RF("fsun.d", datad, 112,  80, w20, w5,  w18);
   TEST_3RF("fsun.d", datad, 112,  96, w10, w24, w4);
   TEST_3RF("fsun.d", datad, 112, 112, w31, w8,  w6);
   TEST_3RF("fsun.d", datad, 112, 128, w19, w17, w14);
   TEST_3RF("fsun.d", datad, 112, 144, w14, w5,  w3);
   TEST_3RF("fsun.d", datad, 128,   0, w3,  w25, w26);
   TEST_3RF("fsun.d", datad, 128,  16, w19, w2,  w31);
   TEST_3RF("fsun.d", datad, 128,  32, w25, w12, w26);
   TEST_3RF("fsun.d", datad, 128,  48, w13, w20, w18);
   TEST_3RF("fsun.d", datad, 128,  64, w8,  w8,  w8);
   TEST_3RF("fsun.d", datad, 128,  80, w20, w5,  w7);
   TEST_3RF("fsun.d", datad, 128,  96, w8,  w8,  w8);
   TEST_3RF("fsun.d", datad, 128, 112, w10, w25, w18);
   TEST_3RF("fsun.d", datad, 128, 128, w3,  w29, w18);
   TEST_3RF("fsun.d", datad, 128, 144, w11, w4,  w5);
   TEST_3RF("fsun.d", datad, 144,   0, w28, w28, w18);
   TEST_3RF("fsun.d", datad, 144,  16, w19, w1,  w21);
   TEST_3RF("fsun.d", datad, 144,  32, w22, w27, w22);
   TEST_3RF("fsun.d", datad, 144,  48, w15, w9,  w9);
   TEST_3RF("fsun.d", datad, 144,  64, w29, w14, w3);
   TEST_3RF("fsun.d", datad, 144,  80, w10, w8,  w16);
   TEST_3RF("fsun.d", datad, 144,  96, w30, w27, w24);
   TEST_3RF("fsun.d", datad, 144, 112, w18, w0,  w31);
   TEST_3RF("fsun.d", datad, 144, 128, w26, w10, w24);
   TEST_3RF("fsun.d", datad, 144, 144, w12, w13, w22);
   TEST_3RF("fsune.w", dataf,   0,   0, w20, w12, w23);
   TEST_3RF("fsune.w", dataf,   0,   8, w22, w1,  w13);
   TEST_3RF("fsune.w", dataf,   0,  16, w17, w16, w23);
   TEST_3RF("fsune.w", dataf,   0,  24, w14, w31, w26);
   TEST_3RF("fsune.w", dataf,   0,  32, w24, w24, w7);
   TEST_3RF("fsune.w", dataf,   0,  40, w10, w22, w2);
   TEST_3RF("fsune.w", dataf,   0,  48, w2,  w8,  w1);
   TEST_3RF("fsune.w", dataf,   0,  56, w2,  w13, w25);
   TEST_3RF("fsune.w", dataf,   0,  64, w15, w26, w13);
   TEST_3RF("fsune.w", dataf,   0,  72, w19, w9,  w17);
   TEST_3RF("fsune.w", dataf,   8,   0, w7,  w21, w8);
   TEST_3RF("fsune.w", dataf,   8,   8, w29, w22, w21);
   TEST_3RF("fsune.w", dataf,   8,  16, w14, w7,  w12);
   TEST_3RF("fsune.w", dataf,   8,  24, w29, w6,  w21);
   TEST_3RF("fsune.w", dataf,   8,  32, w13, w16, w12);
   TEST_3RF("fsune.w", dataf,   8,  40, w16, w18, w20);
   TEST_3RF("fsune.w", dataf,   8,  48, w18, w19, w23);
   TEST_3RF("fsune.w", dataf,   8,  56, w31, w13, w6);
   TEST_3RF("fsune.w", dataf,   8,  64, w26, w28, w26);
   TEST_3RF("fsune.w", dataf,   8,  72, w19, w13, w6);
   TEST_3RF("fsune.w", dataf,  16,   0, w4,  w20, w27);
   TEST_3RF("fsune.w", dataf,  16,   8, w12, w18, w2);
   TEST_3RF("fsune.w", dataf,  16,  16, w0,  w25, w14);
   TEST_3RF("fsune.w", dataf,  16,  24, w29, w31, w21);
   TEST_3RF("fsune.w", dataf,  16,  32, w19, w12, w5);
   TEST_3RF("fsune.w", dataf,  16,  40, w31, w28, w24);
   TEST_3RF("fsune.w", dataf,  16,  48, w19, w15, w11);
   TEST_3RF("fsune.w", dataf,  16,  56, w10, w14, w24);
   TEST_3RF("fsune.w", dataf,  16,  64, w16, w8,  w21);
   TEST_3RF("fsune.w", dataf,  16,  72, w4,  w21, w27);
   TEST_3RF("fsune.w", dataf,  24,   0, w8,  w10, w22);
   TEST_3RF("fsune.w", dataf,  24,   8, w21, w28, w8);
   TEST_3RF("fsune.w", dataf,  24,  16, w23, w28, w1);
   TEST_3RF("fsune.w", dataf,  24,  24, w5,  w26, w0);
   TEST_3RF("fsune.w", dataf,  24,  32, w26, w13, w26);
   TEST_3RF("fsune.w", dataf,  24,  40, w13, w0,  w12);
   TEST_3RF("fsune.w", dataf,  24,  48, w9,  w24, w31);
   TEST_3RF("fsune.w", dataf,  24,  56, w24, w24, w3);
   TEST_3RF("fsune.w", dataf,  24,  64, w10, w7,  w28);
   TEST_3RF("fsune.w", dataf,  24,  72, w26, w15, w26);
   TEST_3RF("fsune.w", dataf,  32,   0, w17, w30, w5);
   TEST_3RF("fsune.w", dataf,  32,   8, w12, w7,  w15);
   TEST_3RF("fsune.w", dataf,  32,  16, w2,  w28, w11);
   TEST_3RF("fsune.w", dataf,  32,  24, w11, w19, w7);
   TEST_3RF("fsune.w", dataf,  32,  32, w12, w24, w1);
   TEST_3RF("fsune.w", dataf,  32,  40, w13, w19, w14);
   TEST_3RF("fsune.w", dataf,  32,  48, w26, w19, w26);
   TEST_3RF("fsune.w", dataf,  32,  56, w26, w3,  w26);
   TEST_3RF("fsune.w", dataf,  32,  64, w11, w26, w28);
   TEST_3RF("fsune.w", dataf,  32,  72, w14, w4,  w3);
   TEST_3RF("fsune.w", dataf,  40,   0, w10, w30, w18);
   TEST_3RF("fsune.w", dataf,  40,   8, w27, w29, w23);
   TEST_3RF("fsune.w", dataf,  40,  16, w7,  w4,  w6);
   TEST_3RF("fsune.w", dataf,  40,  24, w10, w0,  w17);
   TEST_3RF("fsune.w", dataf,  40,  32, w21, w19, w25);
   TEST_3RF("fsune.w", dataf,  40,  40, w1,  w11, w26);
   TEST_3RF("fsune.w", dataf,  40,  48, w14, w30, w9);
   TEST_3RF("fsune.w", dataf,  40,  56, w8,  w17, w3);
   TEST_3RF("fsune.w", dataf,  40,  64, w12, w28, w29);
   TEST_3RF("fsune.w", dataf,  40,  72, w8,  w11, w1);
   TEST_3RF("fsune.w", dataf,  48,   0, w11, w21, w0);
   TEST_3RF("fsune.w", dataf,  48,   8, w29, w17, w21);
   TEST_3RF("fsune.w", dataf,  48,  16, w24, w24, w1);
   TEST_3RF("fsune.w", dataf,  48,  24, w27, w2,  w1);
   TEST_3RF("fsune.w", dataf,  48,  32, w13, w23, w20);
   TEST_3RF("fsune.w", dataf,  48,  40, w6,  w25, w31);
   TEST_3RF("fsune.w", dataf,  48,  48, w0,  w7,  w30);
   TEST_3RF("fsune.w", dataf,  48,  56, w9,  w16, w15);
   TEST_3RF("fsune.w", dataf,  48,  64, w13, w28, w12);
   TEST_3RF("fsune.w", dataf,  48,  72, w10, w4,  w23);
   TEST_3RF("fsune.w", dataf,  56,   0, w12, w15, w29);
   TEST_3RF("fsune.w", dataf,  56,   8, w9,  w1,  w22);
   TEST_3RF("fsune.w", dataf,  56,  16, w10, w29, w24);
   TEST_3RF("fsune.w", dataf,  56,  24, w11, w10, w16);
   TEST_3RF("fsune.w", dataf,  56,  32, w31, w16, w9);
   TEST_3RF("fsune.w", dataf,  56,  40, w30, w30, w30);
   TEST_3RF("fsune.w", dataf,  56,  48, w16, w28, w26);
   TEST_3RF("fsune.w", dataf,  56,  56, w0,  w12, w7);
   TEST_3RF("fsune.w", dataf,  56,  64, w28, w24, w17);
   TEST_3RF("fsune.w", dataf,  56,  72, w0,  w15, w29);
   TEST_3RF("fsune.w", dataf,  64,   0, w15, w27, w9);
   TEST_3RF("fsune.w", dataf,  64,   8, w28, w25, w18);
   TEST_3RF("fsune.w", dataf,  64,  16, w29, w15, w28);
   TEST_3RF("fsune.w", dataf,  64,  24, w26, w7,  w26);
   TEST_3RF("fsune.w", dataf,  64,  32, w7,  w4,  w23);
   TEST_3RF("fsune.w", dataf,  64,  40, w6,  w20, w0);
   TEST_3RF("fsune.w", dataf,  64,  48, w5,  w17, w1);
   TEST_3RF("fsune.w", dataf,  64,  56, w31, w17, w13);
   TEST_3RF("fsune.w", dataf,  64,  64, w6,  w14, w5);
   TEST_3RF("fsune.w", dataf,  64,  72, w23, w14, w20);
   TEST_3RF("fsune.w", dataf,  72,   0, w21, w30, w16);
   TEST_3RF("fsune.w", dataf,  72,   8, w30, w30, w30);
   TEST_3RF("fsune.w", dataf,  72,  16, w26, w9,  w26);
   TEST_3RF("fsune.w", dataf,  72,  24, w17, w23, w24);
   TEST_3RF("fsune.w", dataf,  72,  32, w13, w18, w31);
   TEST_3RF("fsune.w", dataf,  72,  40, w21, w22, w23);
   TEST_3RF("fsune.w", dataf,  72,  48, w27, w11, w23);
   TEST_3RF("fsune.w", dataf,  72,  56, w0,  w16, w8);
   TEST_3RF("fsune.w", dataf,  72,  64, w2,  w15, w26);
   TEST_3RF("fsune.w", dataf,  72,  72, w15, w21, w8);
   TEST_3RF("fsune.d", datad,   0,   0, w21, w12, w22);
   TEST_3RF("fsune.d", datad,   0,  16, w9,  w1,  w20);
   TEST_3RF("fsune.d", datad,   0,  32, w25, w0,  w14);
   TEST_3RF("fsune.d", datad,   0,  48, w2,  w17, w6);
   TEST_3RF("fsune.d", datad,   0,  64, w26, w30, w26);
   TEST_3RF("fsune.d", datad,   0,  80, w24, w24, w26);
   TEST_3RF("fsune.d", datad,   0,  96, w19, w14, w17);
   TEST_3RF("fsune.d", datad,   0, 112, w15, w25, w8);
   TEST_3RF("fsune.d", datad,   0, 128, w15, w9,  w17);
   TEST_3RF("fsune.d", datad,   0, 144, w17, w24, w11);
   TEST_3RF("fsune.d", datad,  16,   0, w1,  w13, w19);
   TEST_3RF("fsune.d", datad,  16,  16, w22, w26, w9);
   TEST_3RF("fsune.d", datad,  16,  32, w31, w27, w30);
   TEST_3RF("fsune.d", datad,  16,  48, w25, w27, w12);
   TEST_3RF("fsune.d", datad,  16,  64, w27, w12, w18);
   TEST_3RF("fsune.d", datad,  16,  80, w22, w11, w10);
   TEST_3RF("fsune.d", datad,  16,  96, w16, w30, w25);
   TEST_3RF("fsune.d", datad,  16, 112, w1,  w13, w18);
   TEST_3RF("fsune.d", datad,  16, 128, w9,  w29, w28);
   TEST_3RF("fsune.d", datad,  16, 144, w26, w14, w26);
   TEST_3RF("fsune.d", datad,  32,   0, w20, w5,  w15);
   TEST_3RF("fsune.d", datad,  32,  16, w2,  w24, w5);
   TEST_3RF("fsune.d", datad,  32,  32, w28, w2,  w5);
   TEST_3RF("fsune.d", datad,  32,  48, w23, w0,  w30);
   TEST_3RF("fsune.d", datad,  32,  64, w19, w12, w25);
   TEST_3RF("fsune.d", datad,  32,  80, w31, w15, w10);
   TEST_3RF("fsune.d", datad,  32,  96, w9,  w31, w2);
   TEST_3RF("fsune.d", datad,  32, 112, w0,  w22, w21);
   TEST_3RF("fsune.d", datad,  32, 128, w10, w19, w17);
   TEST_3RF("fsune.d", datad,  32, 144, w4,  w2,  w5);
   TEST_3RF("fsune.d", datad,  48,   0, w10, w17, w7);
   TEST_3RF("fsune.d", datad,  48,  16, w2,  w23, w3);
   TEST_3RF("fsune.d", datad,  48,  32, w4,  w28, w27);
   TEST_3RF("fsune.d", datad,  48,  48, w4,  w26, w14);
   TEST_3RF("fsune.d", datad,  48,  64, w17, w19, w13);
   TEST_3RF("fsune.d", datad,  48,  80, w16, w3,  w24);
   TEST_3RF("fsune.d", datad,  48,  96, w25, w2,  w1);
   TEST_3RF("fsune.d", datad,  48, 112, w28, w3,  w23);
   TEST_3RF("fsune.d", datad,  48, 128, w17, w13, w11);
   TEST_3RF("fsune.d", datad,  48, 144, w2,  w17, w13);
   TEST_3RF("fsune.d", datad,  64,   0, w7,  w27, w30);
   TEST_3RF("fsune.d", datad,  64,  16, w15, w30, w21);
   TEST_3RF("fsune.d", datad,  64,  32, w18, w2,  w17);
   TEST_3RF("fsune.d", datad,  64,  48, w13, w7,  w11);
   TEST_3RF("fsune.d", datad,  64,  64, w27, w24, w31);
   TEST_3RF("fsune.d", datad,  64,  80, w9,  w8,  w2);
   TEST_3RF("fsune.d", datad,  64,  96, w1,  w4,  w2);
   TEST_3RF("fsune.d", datad,  64, 112, w29, w7,  w25);
   TEST_3RF("fsune.d", datad,  64, 128, w14, w20, w4);
   TEST_3RF("fsune.d", datad,  64, 144, w16, w6,  w17);
   TEST_3RF("fsune.d", datad,  80,   0, w24, w24, w1);
   TEST_3RF("fsune.d", datad,  80,  16, w16, w7,  w31);
   TEST_3RF("fsune.d", datad,  80,  32, w5,  w25, w2);
   TEST_3RF("fsune.d", datad,  80,  48, w23, w7,  w9);
   TEST_3RF("fsune.d", datad,  80,  64, w2,  w1,  w11);
   TEST_3RF("fsune.d", datad,  80,  80, w9,  w3,  w12);
   TEST_3RF("fsune.d", datad,  80,  96, w10, w8,  w14);
   TEST_3RF("fsune.d", datad,  80, 112, w8,  w15, w22);
   TEST_3RF("fsune.d", datad,  80, 128, w4,  w12, w7);
   TEST_3RF("fsune.d", datad,  80, 144, w10, w30, w31);
   TEST_3RF("fsune.d", datad,  96,   0, w11, w14, w6);
   TEST_3RF("fsune.d", datad,  96,  16, w11, w19, w31);
   TEST_3RF("fsune.d", datad,  96,  32, w13, w10, w6);
   TEST_3RF("fsune.d", datad,  96,  48, w22, w13, w9);
   TEST_3RF("fsune.d", datad,  96,  64, w23, w14, w20);
   TEST_3RF("fsune.d", datad,  96,  80, w0,  w18, w1);
   TEST_3RF("fsune.d", datad,  96,  96, w10, w26, w15);
   TEST_3RF("fsune.d", datad,  96, 112, w18, w9,  w23);
   TEST_3RF("fsune.d", datad,  96, 128, w9,  w13, w4);
   TEST_3RF("fsune.d", datad,  96, 144, w16, w23, w2);
   TEST_3RF("fsune.d", datad, 112,   0, w15, w3,  w16);
   TEST_3RF("fsune.d", datad, 112,  16, w21, w14, w3);
   TEST_3RF("fsune.d", datad, 112,  32, w20, w27, w14);
   TEST_3RF("fsune.d", datad, 112,  48, w27, w17, w4);
   TEST_3RF("fsune.d", datad, 112,  64, w8,  w9,  w24);
   TEST_3RF("fsune.d", datad, 112,  80, w8,  w27, w25);
   TEST_3RF("fsune.d", datad, 112,  96, w18, w21, w9);
   TEST_3RF("fsune.d", datad, 112, 112, w5,  w31, w0);
   TEST_3RF("fsune.d", datad, 112, 128, w14, w12, w4);
   TEST_3RF("fsune.d", datad, 112, 144, w30, w30, w30);
   TEST_3RF("fsune.d", datad, 128,   0, w4,  w6,  w13);
   TEST_3RF("fsune.d", datad, 128,  16, w7,  w22, w2);
   TEST_3RF("fsune.d", datad, 128,  32, w21, w26, w22);
   TEST_3RF("fsune.d", datad, 128,  48, w16, w8,  w17);
   TEST_3RF("fsune.d", datad, 128,  64, w1,  w3,  w21);
   TEST_3RF("fsune.d", datad, 128,  80, w9,  w12, w14);
   TEST_3RF("fsune.d", datad, 128,  96, w17, w8,  w7);
   TEST_3RF("fsune.d", datad, 128, 112, w3,  w29, w29);
   TEST_3RF("fsune.d", datad, 128, 128, w16, w8,  w28);
   TEST_3RF("fsune.d", datad, 128, 144, w17, w22, w9);
   TEST_3RF("fsune.d", datad, 144,   0, w21, w20, w13);
   TEST_3RF("fsune.d", datad, 144,  16, w28, w1,  w20);
   TEST_3RF("fsune.d", datad, 144,  32, w18, w3,  w9);
   TEST_3RF("fsune.d", datad, 144,  48, w12, w26, w25);
   TEST_3RF("fsune.d", datad, 144,  64, w20, w11, w26);
   TEST_3RF("fsune.d", datad, 144,  80, w23, w1,  w3);
   TEST_3RF("fsune.d", datad, 144,  96, w4,  w15, w20);
   TEST_3RF("fsune.d", datad, 144, 112, w12, w22, w23);
   TEST_3RF("fsune.d", datad, 144, 128, w9,  w7,  w0);
   TEST_3RF("fsune.d", datad, 144, 144, w6,  w24, w22);
   TEST_2RF("fclass.w",  dataf,   0, w0,  w6);
   TEST_2RF("fclass.w",  dataf,   8, w1,  w16);
   TEST_2RF("fclass.w",  dataf,  16, w2,  w11);
   TEST_2RF("fclass.w",  dataf,  24, w3,  w5);
   TEST_2RF("fclass.w",  dataf,  32, w4,  w29);
   TEST_2RF("fclass.w",  dataf,  40, w5,  w27);
   TEST_2RF("fclass.w",  dataf,  48, w6,  w24);
   TEST_2RF("fclass.w",  dataf,  56, w7,  w8);
   TEST_2RF("fclass.w",  dataf,  64, w8,  w19);
   TEST_2RF("fclass.w",  dataf,  72, w9,  w13);
   TEST_2RF("fclass.w",  dataf,   0, w10, w28);
   TEST_2RF("fclass.w",  dataf,   8, w11, w26);
   TEST_2RF("fclass.w",  dataf,  16, w12, w8);
   TEST_2RF("fclass.w",  dataf,  24, w13, w0);
   TEST_2RF("fclass.w",  dataf,  32, w14, w10);
   TEST_2RF("fclass.w",  dataf,  40, w15, w7);
   TEST_2RF("fclass.w",  dataf,  48, w16, w13);
   TEST_2RF("fclass.w",  dataf,  56, w17, w18);
   TEST_2RF("fclass.w",  dataf,  64, w18, w27);
   TEST_2RF("fclass.w",  dataf,  72, w19, w31);
   TEST_2RF("fclass.w",  dataf,   0, w20, w31);
   TEST_2RF("fclass.w",  dataf,   8, w21, w9);
   TEST_2RF("fclass.w",  dataf,  16, w22, w17);
   TEST_2RF("fclass.w",  dataf,  24, w23, w2);
   TEST_2RF("fclass.w",  dataf,  32, w24, w24);
   TEST_2RF("fclass.w",  dataf,  40, w25, w25);
   TEST_2RF("fclass.w",  dataf,  48, w26, w15);
   TEST_2RF("fclass.w",  dataf,  56, w27, w15);
   TEST_2RF("fclass.w",  dataf,  64, w28, w25);
   TEST_2RF("fclass.w",  dataf,  72, w29, w14);
   TEST_2RF("fclass.w",  dataf,   0, w30, w20);
   TEST_2RF("fclass.w",  dataf,   8, w31, w15);
   TEST_2RF("fclass.d",  datad,   0, w0,  w22);
   TEST_2RF("fclass.d",  datad,  16, w1,  w3);
   TEST_2RF("fclass.d",  datad,  32, w2,  w1);
   TEST_2RF("fclass.d",  datad,  48, w3,  w6);
   TEST_2RF("fclass.d",  datad,  64, w4,  w27);
   TEST_2RF("fclass.d",  datad,  80, w5,  w23);
   TEST_2RF("fclass.d",  datad,  96, w6,  w9);
   TEST_2RF("fclass.d",  datad, 112, w7,  w8);
   TEST_2RF("fclass.d",  datad, 128, w8,  w16);
   TEST_2RF("fclass.d",  datad, 144, w9,  w14);
   TEST_2RF("fclass.d",  datad,   0, w10, w11);
   TEST_2RF("fclass.d",  datad,  16, w11, w6);
   TEST_2RF("fclass.d",  datad,  32, w12, w20);
   TEST_2RF("fclass.d",  datad,  48, w13, w12);
   TEST_2RF("fclass.d",  datad,  64, w14, w24);
   TEST_2RF("fclass.d",  datad,  80, w15, w25);
   TEST_2RF("fclass.d",  datad,  96, w16, w7);
   TEST_2RF("fclass.d",  datad, 112, w17, w4);
   TEST_2RF("fclass.d",  datad, 128, w18, w1);
   TEST_2RF("fclass.d",  datad, 144, w19, w0);
   TEST_2RF("fclass.d",  datad,   0, w20, w10);
   TEST_2RF("fclass.d",  datad,  16, w21, w19);
   TEST_2RF("fclass.d",  datad,  32, w22, w27);
   TEST_2RF("fclass.d",  datad,  48, w23, w22);
   TEST_2RF("fclass.d",  datad,  64, w24, w24);
   TEST_2RF("fclass.d",  datad,  80, w25, w25);
   TEST_2RF("fclass.d",  datad,  96, w26, w22);
   TEST_2RF("fclass.d",  datad, 112, w27, w25);
   TEST_2RF("fclass.d",  datad, 128, w28, w24);
   TEST_2RF("fclass.d",  datad, 144, w29, w16);
   TEST_2RF("fclass.d",  datad,   0, w30, w17);
   TEST_2RF("fclass.d",  datad,  16, w31, w19);

   // Rounding mode significant.
   for (i = 0; i < 4; i++) {
      msacsr = i;
      TEST_3RF("fadd.w", dataf,   0,   0, w30, w10, w21);
      TEST_3RF("fadd.w", dataf,   0,   8, w24, w9,  w15);
      TEST_3RF("fadd.w", dataf,   0,  16, w21, w19, w29);
      TEST_3RF("fadd.w", dataf,   0,  24, w18, w25, w15);
      TEST_3RF("fadd.w", dataf,   0,  32, w4,  w16, w18);
      TEST_3RF("fadd.w", dataf,   0,  40, w29, w25, w17);
      TEST_3RF("fadd.w", dataf,   0,  48, w6,  w9,  w14);
      TEST_3RF("fadd.w", dataf,   0,  56, w22, w30, w18);
      TEST_3RF("fadd.w", dataf,   0,  64, w27, w23, w25);
      TEST_3RF("fadd.w", dataf,   0,  72, w30, w17, w26);
      TEST_3RF("fadd.w", dataf,   8,   0, w28, w27, w16);
      TEST_3RF("fadd.w", dataf,   8,   8, w20, w4,  w31);
      TEST_3RF("fadd.w", dataf,   8,  16, w10, w23, w28);
      TEST_3RF("fadd.w", dataf,   8,  24, w28, w17, w21);
      TEST_3RF("fadd.w", dataf,   8,  32, w11, w21, w5);
      TEST_3RF("fadd.w", dataf,   8,  40, w30, w19, w31);
      TEST_3RF("fadd.w", dataf,   8,  48, w15, w25, w8);
      TEST_3RF("fadd.w", dataf,   8,  56, w29, w15, w6);
      TEST_3RF("fadd.w", dataf,   8,  64, w15, w11, w30);
      TEST_3RF("fadd.w", dataf,   8,  72, w8,  w9,  w15);
      TEST_3RF("fadd.w", dataf,  16,   0, w2,  w6,  w11);
      TEST_3RF("fadd.w", dataf,  16,   8, w18, w26, w15);
      TEST_3RF("fadd.w", dataf,  16,  16, w17, w4,  w7);
      TEST_3RF("fadd.w", dataf,  16,  24, w13, w0,  w24);
      TEST_3RF("fadd.w", dataf,  16,  32, w3,  w3,  w12);
      TEST_3RF("fadd.w", dataf,  16,  40, w13, w8,  w10);
      TEST_3RF("fadd.w", dataf,  16,  48, w0,  w7,  w25);
      TEST_3RF("fadd.w", dataf,  16,  56, w26, w16, w26);
      TEST_3RF("fadd.w", dataf,  16,  64, w22, w9,  w5);
      TEST_3RF("fadd.w", dataf,  16,  72, w20, w13, w30);
      TEST_3RF("fadd.w", dataf,  24,   0, w4,  w15, w2);
      TEST_3RF("fadd.w", dataf,  24,   8, w30, w19, w3);
      TEST_3RF("fadd.w", dataf,  24,  16, w5,  w1,  w3);
      TEST_3RF("fadd.w", dataf,  24,  24, w29, w4,  w15);
      TEST_3RF("fadd.w", dataf,  24,  32, w11, w12, w25);
      TEST_3RF("fadd.w", dataf,  24,  40, w11, w20, w18);
      TEST_3RF("fadd.w", dataf,  24,  48, w5,  w4,  w8);
      TEST_3RF("fadd.w", dataf,  24,  56, w15, w26, w13);
      TEST_3RF("fadd.w", dataf,  24,  64, w3,  w3,  w15);
      TEST_3RF("fadd.w", dataf,  24,  72, w26, w1,  w26);
      TEST_3RF("fadd.w", dataf,  32,   0, w19, w10, w5);
      TEST_3RF("fadd.w", dataf,  32,   8, w2,  w12, w4);
      TEST_3RF("fadd.w", dataf,  32,  16, w0,  w31, w7);
      TEST_3RF("fadd.w", dataf,  32,  24, w6,  w0,  w10);
      TEST_3RF("fadd.w", dataf,  32,  32, w3,  w3,  w4);
      TEST_3RF("fadd.w", dataf,  32,  40, w26, w14, w26);
      TEST_3RF("fadd.w", dataf,  32,  48, w17, w19, w26);
      TEST_3RF("fadd.w", dataf,  32,  56, w5,  w6,  w31);
      TEST_3RF("fadd.w", dataf,  32,  64, w9,  w14, w3);
      TEST_3RF("fadd.w", dataf,  32,  72, w28, w18, w22);
      TEST_3RF("fadd.w", dataf,  40,   0, w19, w5,  w0);
      TEST_3RF("fadd.w", dataf,  40,   8, w25, w7,  w12);
      TEST_3RF("fadd.w", dataf,  40,  16, w29, w8,  w12);
      TEST_3RF("fadd.w", dataf,  40,  24, w4,  w14, w12);
      TEST_3RF("fadd.w", dataf,  40,  32, w14, w17, w8);
      TEST_3RF("fadd.w", dataf,  40,  40, w0,  w2,  w28);
      TEST_3RF("fadd.w", dataf,  40,  48, w26, w7,  w26);
      TEST_3RF("fadd.w", dataf,  40,  56, w2,  w25, w16);
      TEST_3RF("fadd.w", dataf,  40,  64, w16, w8,  w19);
      TEST_3RF("fadd.w", dataf,  40,  72, w12, w26, w6);
      TEST_3RF("fadd.w", dataf,  48,   0, w3,  w3,  w13);
      TEST_3RF("fadd.w", dataf,  48,   8, w11, w3,  w6);
      TEST_3RF("fadd.w", dataf,  48,  16, w19, w16, w3);
      TEST_3RF("fadd.w", dataf,  48,  24, w27, w28, w7);
      TEST_3RF("fadd.w", dataf,  48,  32, w9,  w8,  w22);
      TEST_3RF("fadd.w", dataf,  48,  40, w26, w25, w26);
      TEST_3RF("fadd.w", dataf,  48,  48, w30, w26, w27);
      TEST_3RF("fadd.w", dataf,  48,  56, w26, w20, w26);
      TEST_3RF("fadd.w", dataf,  48,  64, w2,  w28, w14);
      TEST_3RF("fadd.w", dataf,  48,  72, w18, w13, w22);
      TEST_3RF("fadd.w", dataf,  56,   0, w6,  w25, w16);
      TEST_3RF("fadd.w", dataf,  56,   8, w12, w28, w29);
      TEST_3RF("fadd.w", dataf,  56,  16, w23, w0,  w4);
      TEST_3RF("fadd.w", dataf,  56,  24, w10, w16, w7);
      TEST_3RF("fadd.w", dataf,  56,  32, w5,  w12, w15);
      TEST_3RF("fadd.w", dataf,  56,  40, w14, w20, w5);
      TEST_3RF("fadd.w", dataf,  56,  48, w9,  w14, w3);
      TEST_3RF("fadd.w", dataf,  56,  56, w3,  w3,  w9);
      TEST_3RF("fadd.w", dataf,  56,  64, w30, w24, w12);
      TEST_3RF("fadd.w", dataf,  56,  72, w26, w6,  w26);
      TEST_3RF("fadd.w", dataf,  64,   0, w30, w7,  w28);
      TEST_3RF("fadd.w", dataf,  64,   8, w4,  w1,  w12);
      TEST_3RF("fadd.w", dataf,  64,  16, w16, w29, w9);
      TEST_3RF("fadd.w", dataf,  64,  24, w8,  w29, w13);
      TEST_3RF("fadd.w", dataf,  64,  32, w18, w13, w21);
      TEST_3RF("fadd.w", dataf,  64,  40, w24, w25, w4);
      TEST_3RF("fadd.w", dataf,  64,  48, w6,  w14, w9);
      TEST_3RF("fadd.w", dataf,  64,  56, w15, w28, w12);
      TEST_3RF("fadd.w", dataf,  64,  64, w19, w5,  w10);
      TEST_3RF("fadd.w", dataf,  64,  72, w11, w17, w5);
      TEST_3RF("fadd.w", dataf,  72,   0, w17, w16, w12);
      TEST_3RF("fadd.w", dataf,  72,   8, w13, w20, w25);
      TEST_3RF("fadd.w", dataf,  72,  16, w5,  w11, w2);
      TEST_3RF("fadd.w", dataf,  72,  24, w13, w8,  w16);
      TEST_3RF("fadd.w", dataf,  72,  32, w31, w22, w5);
      TEST_3RF("fadd.w", dataf,  72,  40, w23, w15, w9);
      TEST_3RF("fadd.w", dataf,  72,  48, w30, w29, w18);
      TEST_3RF("fadd.w", dataf,  72,  56, w13, w25, w30);
      TEST_3RF("fadd.w", dataf,  72,  64, w0,  w31, w9);
      TEST_3RF("fadd.w", dataf,  72,  72, w11, w16, w14);
      TEST_3RF("fadd.d", datad,   0,   0, w28, w0,  w26);
      TEST_3RF("fadd.d", datad,   0,  16, w9,  w21, w8);
      TEST_3RF("fadd.d", datad,   0,  32, w2,  w26, w19);
      TEST_3RF("fadd.d", datad,   0,  48, w5,  w7,  w27);
      TEST_3RF("fadd.d", datad,   0,  64, w21, w6,  w17);
      TEST_3RF("fadd.d", datad,   0,  80, w26, w30, w26);
      TEST_3RF("fadd.d", datad,   0,  96, w1,  w3,  w3);
      TEST_3RF("fadd.d", datad,   0, 112, w28, w30, w21);
      TEST_3RF("fadd.d", datad,   0, 128, w9,  w24, w19);
      TEST_3RF("fadd.d", datad,   0, 144, w10, w23, w28);
      TEST_3RF("fadd.d", datad,  16,   0, w21, w7,  w10);
      TEST_3RF("fadd.d", datad,  16,  16, w18, w8,  w5);
      TEST_3RF("fadd.d", datad,  16,  32, w27, w29, w13);
      TEST_3RF("fadd.d", datad,  16,  48, w30, w23, w0);
      TEST_3RF("fadd.d", datad,  16,  64, w3,  w3,  w30);
      TEST_3RF("fadd.d", datad,  16,  80, w27, w24, w4);
      TEST_3RF("fadd.d", datad,  16,  96, w13, w18, w2);
      TEST_3RF("fadd.d", datad,  16, 112, w14, w21, w30);
      TEST_3RF("fadd.d", datad,  16, 128, w12, w10, w8);
      TEST_3RF("fadd.d", datad,  16, 144, w4,  w29, w18);
      TEST_3RF("fadd.d", datad,  32,   0, w27, w26, w7);
      TEST_3RF("fadd.d", datad,  32,  16, w3,  w3,  w4);
      TEST_3RF("fadd.d", datad,  32,  32, w25, w11, w9);
      TEST_3RF("fadd.d", datad,  32,  48, w21, w8,  w22);
      TEST_3RF("fadd.d", datad,  32,  64, w19, w31, w22);
      TEST_3RF("fadd.d", datad,  32,  80, w22, w29, w18);
      TEST_3RF("fadd.d", datad,  32,  96, w14, w1,  w31);
      TEST_3RF("fadd.d", datad,  32, 112, w0,  w4,  w13);
      TEST_3RF("fadd.d", datad,  32, 128, w21, w2,  w25);
      TEST_3RF("fadd.d", datad,  32, 144, w31, w10, w30);
      TEST_3RF("fadd.d", datad,  48,   0, w28, w25, w22);
      TEST_3RF("fadd.d", datad,  48,  16, w4,  w28, w27);
      TEST_3RF("fadd.d", datad,  48,  32, w29, w7,  w4);
      TEST_3RF("fadd.d", datad,  48,  48, w18, w15, w27);
      TEST_3RF("fadd.d", datad,  48,  64, w5,  w14, w17);
      TEST_3RF("fadd.d", datad,  48,  80, w27, w11, w3);
      TEST_3RF("fadd.d", datad,  48,  96, w9,  w13, w2);
      TEST_3RF("fadd.d", datad,  48, 112, w9,  w17, w15);
      TEST_3RF("fadd.d", datad,  48, 128, w30, w19, w9);
      TEST_3RF("fadd.d", datad,  48, 144, w29, w30, w7);
      TEST_3RF("fadd.d", datad,  64,   0, w26, w0,  w26);
      TEST_3RF("fadd.d", datad,  64,  16, w16, w30, w29);
      TEST_3RF("fadd.d", datad,  64,  32, w11, w28, w4);
      TEST_3RF("fadd.d", datad,  64,  48, w16, w14, w20);
      TEST_3RF("fadd.d", datad,  64,  64, w11, w20, w2);
      TEST_3RF("fadd.d", datad,  64,  80, w28, w15, w14);
      TEST_3RF("fadd.d", datad,  64,  96, w0,  w25, w27);
      TEST_3RF("fadd.d", datad,  64, 112, w2,  w12, w18);
      TEST_3RF("fadd.d", datad,  64, 128, w1,  w31, w31);
      TEST_3RF("fadd.d", datad,  64, 144, w27, w30, w29);
      TEST_3RF("fadd.d", datad,  80,   0, w2,  w24, w9);
      TEST_3RF("fadd.d", datad,  80,  16, w22, w31, w20);
      TEST_3RF("fadd.d", datad,  80,  32, w18, w4,  w1);
      TEST_3RF("fadd.d", datad,  80,  48, w24, w15, w21);
      TEST_3RF("fadd.d", datad,  80,  64, w26, w12, w26);
      TEST_3RF("fadd.d", datad,  80,  80, w4,  w8,  w12);
      TEST_3RF("fadd.d", datad,  80,  96, w29, w3,  w14);
      TEST_3RF("fadd.d", datad,  80, 112, w0,  w15, w1);
      TEST_3RF("fadd.d", datad,  80, 128, w15, w27, w31);
      TEST_3RF("fadd.d", datad,  80, 144, w12, w29, w24);
      TEST_3RF("fadd.d", datad,  96,   0, w4,  w0,  w1);
      TEST_3RF("fadd.d", datad,  96,  16, w27, w31, w21);
      TEST_3RF("fadd.d", datad,  96,  32, w13, w3,  w26);
      TEST_3RF("fadd.d", datad,  96,  48, w14, w27, w9);
      TEST_3RF("fadd.d", datad,  96,  64, w3,  w3,  w22);
      TEST_3RF("fadd.d", datad,  96,  80, w21, w8,  w30);
      TEST_3RF("fadd.d", datad,  96,  96, w1,  w5,  w5);
      TEST_3RF("fadd.d", datad,  96, 112, w2,  w16, w5);
      TEST_3RF("fadd.d", datad,  96, 128, w17, w16, w6);
      TEST_3RF("fadd.d", datad,  96, 144, w0,  w12, w6);
      TEST_3RF("fadd.d", datad, 112,   0, w13, w9,  w30);
      TEST_3RF("fadd.d", datad, 112,  16, w17, w9,  w31);
      TEST_3RF("fadd.d", datad, 112,  32, w12, w9,  w20);
      TEST_3RF("fadd.d", datad, 112,  48, w26, w12, w26);
      TEST_3RF("fadd.d", datad, 112,  64, w14, w8,  w24);
      TEST_3RF("fadd.d", datad, 112,  80, w12, w30, w13);
      TEST_3RF("fadd.d", datad, 112,  96, w20, w28, w15);
      TEST_3RF("fadd.d", datad, 112, 112, w25, w30, w31);
      TEST_3RF("fadd.d", datad, 112, 128, w31, w16, w15);
      TEST_3RF("fadd.d", datad, 112, 144, w5,  w16, w27);
      TEST_3RF("fadd.d", datad, 128,   0, w11, w29, w5);
      TEST_3RF("fadd.d", datad, 128,  16, w9,  w15, w14);
      TEST_3RF("fadd.d", datad, 128,  32, w8,  w27, w23);
      TEST_3RF("fadd.d", datad, 128,  48, w29, w21, w4);
      TEST_3RF("fadd.d", datad, 128,  64, w11, w30, w12);
      TEST_3RF("fadd.d", datad, 128,  80, w3,  w3,  w10);
      TEST_3RF("fadd.d", datad, 128,  96, w10, w17, w30);
      TEST_3RF("fadd.d", datad, 128, 112, w6,  w0,  w23);
      TEST_3RF("fadd.d", datad, 128, 128, w5,  w31, w22);
      TEST_3RF("fadd.d", datad, 128, 144, w21, w14, w28);
      TEST_3RF("fadd.d", datad, 144,   0, w5,  w10, w7);
      TEST_3RF("fadd.d", datad, 144,  16, w3,  w3,  w15);
      TEST_3RF("fadd.d", datad, 144,  32, w17, w18, w29);
      TEST_3RF("fadd.d", datad, 144,  48, w25, w13, w21);
      TEST_3RF("fadd.d", datad, 144,  64, w22, w3,  w25);
      TEST_3RF("fadd.d", datad, 144,  80, w2,  w1,  w5);
      TEST_3RF("fadd.d", datad, 144,  96, w5,  w11, w15);
      TEST_3RF("fadd.d", datad, 144, 112, w22, w9,  w21);
      TEST_3RF("fadd.d", datad, 144, 128, w22, w0,  w26);
      TEST_3RF("fadd.d", datad, 144, 144, w21, w23, w15);
      TEST_3RF("fmul.w", dataf,   0,   0, w20, w8,  w1);
      TEST_3RF("fmul.w", dataf,   0,   8, w9,  w30, w9);
      TEST_3RF("fmul.w", dataf,   0,  16, w17, w18, w0);
      TEST_3RF("fmul.w", dataf,   0,  24, w9,  w20, w9);
      TEST_3RF("fmul.w", dataf,   0,  32, w30, w19, w19);
      TEST_3RF("fmul.w", dataf,   0,  40, w30, w6,  w6);
      TEST_3RF("fmul.w", dataf,   0,  48, w14, w21, w15);
      TEST_3RF("fmul.w", dataf,   0,  56, w7,  w0,  w18);
      TEST_3RF("fmul.w", dataf,   0,  64, w7,  w25, w29);
      TEST_3RF("fmul.w", dataf,   0,  72, w0,  w31, w22);
      TEST_3RF("fmul.w", dataf,   8,   0, w3,  w3,  w3);
      TEST_3RF("fmul.w", dataf,   8,   8, w1,  w0,  w21);
      TEST_3RF("fmul.w", dataf,   8,  16, w8,  w2,  w30);
      TEST_3RF("fmul.w", dataf,   8,  24, w6,  w20, w16);
      TEST_3RF("fmul.w", dataf,   8,  32, w6,  w29, w4);
      TEST_3RF("fmul.w", dataf,   8,  40, w5,  w16, w2);
      TEST_3RF("fmul.w", dataf,   8,  48, w11, w30, w23);
      TEST_3RF("fmul.w", dataf,   8,  56, w26, w6,  w24);
      TEST_3RF("fmul.w", dataf,   8,  64, w12, w13, w17);
      TEST_3RF("fmul.w", dataf,   8,  72, w9,  w14, w9);
      TEST_3RF("fmul.w", dataf,  16,   0, w16, w8,  w4);
      TEST_3RF("fmul.w", dataf,  16,   8, w19, w9,  w4);
      TEST_3RF("fmul.w", dataf,  16,  16, w21, w30, w12);
      TEST_3RF("fmul.w", dataf,  16,  24, w23, w28, w18);
      TEST_3RF("fmul.w", dataf,  16,  32, w11, w12, w25);
      TEST_3RF("fmul.w", dataf,  16,  40, w9,  w16, w9);
      TEST_3RF("fmul.w", dataf,  16,  48, w30, w25, w25);
      TEST_3RF("fmul.w", dataf,  16,  56, w18, w9,  w24);
      TEST_3RF("fmul.w", dataf,  16,  64, w10, w3,  w30);
      TEST_3RF("fmul.w", dataf,  16,  72, w2,  w2,  w16);
      TEST_3RF("fmul.w", dataf,  24,   0, w11, w19, w25);
      TEST_3RF("fmul.w", dataf,  24,   8, w25, w3,  w2);
      TEST_3RF("fmul.w", dataf,  24,  16, w30, w23, w23);
      TEST_3RF("fmul.w", dataf,  24,  24, w11, w2,  w12);
      TEST_3RF("fmul.w", dataf,  24,  32, w10, w15, w3);
      TEST_3RF("fmul.w", dataf,  24,  40, w6,  w1,  w15);
      TEST_3RF("fmul.w", dataf,  24,  48, w19, w26, w24);
      TEST_3RF("fmul.w", dataf,  24,  56, w3,  w3,  w3);
      TEST_3RF("fmul.w", dataf,  24,  64, w24, w17, w22);
      TEST_3RF("fmul.w", dataf,  24,  72, w1,  w9,  w0);
      TEST_3RF("fmul.w", dataf,  32,   0, w5,  w7,  w2);
      TEST_3RF("fmul.w", dataf,  32,   8, w21, w19, w14);
      TEST_3RF("fmul.w", dataf,  32,  16, w12, w24, w16);
      TEST_3RF("fmul.w", dataf,  32,  24, w10, w15, w28);
      TEST_3RF("fmul.w", dataf,  32,  32, w13, w27, w6);
      TEST_3RF("fmul.w", dataf,  32,  40, w28, w31, w12);
      TEST_3RF("fmul.w", dataf,  32,  48, w29, w14, w31);
      TEST_3RF("fmul.w", dataf,  32,  56, w24, w6,  w3);
      TEST_3RF("fmul.w", dataf,  32,  64, w16, w23, w25);
      TEST_3RF("fmul.w", dataf,  32,  72, w18, w1,  w25);
      TEST_3RF("fmul.w", dataf,  40,   0, w23, w8,  w27);
      TEST_3RF("fmul.w", dataf,  40,   8, w12, w27, w16);
      TEST_3RF("fmul.w", dataf,  40,  16, w26, w8,  w11);
      TEST_3RF("fmul.w", dataf,  40,  24, w18, w24, w7);
      TEST_3RF("fmul.w", dataf,  40,  32, w31, w19, w13);
      TEST_3RF("fmul.w", dataf,  40,  40, w27, w18, w25);
      TEST_3RF("fmul.w", dataf,  40,  48, w25, w0,  w17);
      TEST_3RF("fmul.w", dataf,  40,  56, w6,  w28, w1);
      TEST_3RF("fmul.w", dataf,  40,  64, w30, w21, w21);
      TEST_3RF("fmul.w", dataf,  40,  72, w19, w31, w14);
      TEST_3RF("fmul.w", dataf,  48,   0, w10, w7,  w9);
      TEST_3RF("fmul.w", dataf,  48,   8, w22, w3,  w25);
      TEST_3RF("fmul.w", dataf,  48,  16, w17, w11, w1);
      TEST_3RF("fmul.w", dataf,  48,  24, w28, w29, w25);
      TEST_3RF("fmul.w", dataf,  48,  32, w3,  w3,  w3);
      TEST_3RF("fmul.w", dataf,  48,  40, w29, w13, w16);
      TEST_3RF("fmul.w", dataf,  48,  48, w24, w31, w9);
      TEST_3RF("fmul.w", dataf,  48,  56, w17, w0,  w2);
      TEST_3RF("fmul.w", dataf,  48,  64, w2,  w2,  w6);
      TEST_3RF("fmul.w", dataf,  48,  72, w30, w4,  w4);
      TEST_3RF("fmul.w", dataf,  56,   0, w4,  w19, w23);
      TEST_3RF("fmul.w", dataf,  56,   8, w3,  w3,  w3);
      TEST_3RF("fmul.w", dataf,  56,  16, w1,  w2,  w11);
      TEST_3RF("fmul.w", dataf,  56,  24, w10, w24, w14);
      TEST_3RF("fmul.w", dataf,  56,  32, w3,  w3,  w3);
      TEST_3RF("fmul.w", dataf,  56,  40, w9,  w25, w9);
      TEST_3RF("fmul.w", dataf,  56,  48, w5,  w22, w30);
      TEST_3RF("fmul.w", dataf,  56,  56, w8,  w19, w11);
      TEST_3RF("fmul.w", dataf,  56,  64, w24, w12, w11);
      TEST_3RF("fmul.w", dataf,  56,  72, w2,  w2,  w29);
      TEST_3RF("fmul.w", dataf,  64,   0, w11, w4,  w0);
      TEST_3RF("fmul.w", dataf,  64,   8, w17, w3,  w4);
      TEST_3RF("fmul.w", dataf,  64,  16, w22, w27, w25);
      TEST_3RF("fmul.w", dataf,  64,  24, w24, w29, w4);
      TEST_3RF("fmul.w", dataf,  64,  32, w2,  w2,  w22);
      TEST_3RF("fmul.w", dataf,  64,  40, w18, w6,  w31);
      TEST_3RF("fmul.w", dataf,  64,  48, w11, w5,  w2);
      TEST_3RF("fmul.w", dataf,  64,  56, w9,  w13, w9);
      TEST_3RF("fmul.w", dataf,  64,  64, w21, w6,  w1);
      TEST_3RF("fmul.w", dataf,  64,  72, w0,  w8,  w31);
      TEST_3RF("fmul.w", dataf,  72,   0, w11, w12, w31);
      TEST_3RF("fmul.w", dataf,  72,   8, w28, w15, w3);
      TEST_3RF("fmul.w", dataf,  72,  16, w18, w6,  w30);
      TEST_3RF("fmul.w", dataf,  72,  24, w12, w30, w28);
      TEST_3RF("fmul.w", dataf,  72,  32, w16, w0,  w18);
      TEST_3RF("fmul.w", dataf,  72,  40, w3,  w3,  w3);
      TEST_3RF("fmul.w", dataf,  72,  48, w6,  w17, w14);
      TEST_3RF("fmul.w", dataf,  72,  56, w17, w22, w16);
      TEST_3RF("fmul.w", dataf,  72,  64, w27, w4,  w6);
      TEST_3RF("fmul.w", dataf,  72,  72, w16, w10, w7);
      TEST_3RF("fmul.d", datad,   0,   0, w16, w18, w6);
      TEST_3RF("fmul.d", datad,   0,  16, w27, w30, w5);
      TEST_3RF("fmul.d", datad,   0,  32, w23, w14, w8);
      TEST_3RF("fmul.d", datad,   0,  48, w10, w20, w7);
      TEST_3RF("fmul.d", datad,   0,  64, w22, w18, w3);
      TEST_3RF("fmul.d", datad,   0,  80, w6,  w18, w21);
      TEST_3RF("fmul.d", datad,   0,  96, w9,  w25, w9);
      TEST_3RF("fmul.d", datad,   0, 112, w6,  w24, w10);
      TEST_3RF("fmul.d", datad,   0, 128, w29, w8,  w5);
      TEST_3RF("fmul.d", datad,   0, 144, w1,  w14, w21);
      TEST_3RF("fmul.d", datad,  16,   0, w11, w22, w5);
      TEST_3RF("fmul.d", datad,  16,  16, w29, w28, w0);
      TEST_3RF("fmul.d", datad,  16,  32, w27, w2,  w24);
      TEST_3RF("fmul.d", datad,  16,  48, w9,  w10, w9);
      TEST_3RF("fmul.d", datad,  16,  64, w2,  w2,  w29);
      TEST_3RF("fmul.d", datad,  16,  80, w17, w24, w15);
      TEST_3RF("fmul.d", datad,  16,  96, w20, w30, w2);
      TEST_3RF("fmul.d", datad,  16, 112, w9,  w8,  w9);
      TEST_3RF("fmul.d", datad,  16, 128, w27, w16, w0);
      TEST_3RF("fmul.d", datad,  16, 144, w5,  w13, w8);
      TEST_3RF("fmul.d", datad,  32,   0, w11, w14, w23);
      TEST_3RF("fmul.d", datad,  32,  16, w0,  w25, w13);
      TEST_3RF("fmul.d", datad,  32,  32, w6,  w22, w9);
      TEST_3RF("fmul.d", datad,  32,  48, w6,  w17, w11);
      TEST_3RF("fmul.d", datad,  32,  64, w30, w27, w27);
      TEST_3RF("fmul.d", datad,  32,  80, w22, w0,  w24);
      TEST_3RF("fmul.d", datad,  32,  96, w7,  w24, w8);
      TEST_3RF("fmul.d", datad,  32, 112, w28, w23, w10);
      TEST_3RF("fmul.d", datad,  32, 128, w5,  w31, w21);
      TEST_3RF("fmul.d", datad,  32, 144, w31, w10, w2);
      TEST_3RF("fmul.d", datad,  48,   0, w7,  w21, w16);
      TEST_3RF("fmul.d", datad,  48,  16, w30, w22, w22);
      TEST_3RF("fmul.d", datad,  48,  32, w9,  w11, w9);
      TEST_3RF("fmul.d", datad,  48,  48, w28, w31, w21);
      TEST_3RF("fmul.d", datad,  48,  64, w2,  w2,  w17);
      TEST_3RF("fmul.d", datad,  48,  80, w0,  w1,  w12);
      TEST_3RF("fmul.d", datad,  48,  96, w22, w1,  w4);
      TEST_3RF("fmul.d", datad,  48, 112, w30, w26, w26);
      TEST_3RF("fmul.d", datad,  48, 128, w12, w26, w17);
      TEST_3RF("fmul.d", datad,  48, 144, w22, w31, w16);
      TEST_3RF("fmul.d", datad,  64,   0, w27, w21, w15);
      TEST_3RF("fmul.d", datad,  64,  16, w6,  w23, w22);
      TEST_3RF("fmul.d", datad,  64,  32, w27, w8,  w21);
      TEST_3RF("fmul.d", datad,  64,  48, w17, w0,  w13);
      TEST_3RF("fmul.d", datad,  64,  64, w17, w21, w16);
      TEST_3RF("fmul.d", datad,  64,  80, w2,  w2,  w22);
      TEST_3RF("fmul.d", datad,  64,  96, w17, w14, w12);
      TEST_3RF("fmul.d", datad,  64, 112, w18, w10, w12);
      TEST_3RF("fmul.d", datad,  64, 128, w31, w4,  w29);
      TEST_3RF("fmul.d", datad,  64, 144, w21, w4,  w13);
      TEST_3RF("fmul.d", datad,  80,   0, w17, w25, w28);
      TEST_3RF("fmul.d", datad,  80,  16, w23, w16, w19);
      TEST_3RF("fmul.d", datad,  80,  32, w18, w24, w8);
      TEST_3RF("fmul.d", datad,  80,  48, w4,  w10, w8);
      TEST_3RF("fmul.d", datad,  80,  64, w17, w27, w30);
      TEST_3RF("fmul.d", datad,  80,  80, w1,  w29, w20);
      TEST_3RF("fmul.d", datad,  80,  96, w18, w11, w0);
      TEST_3RF("fmul.d", datad,  80, 112, w5,  w29, w11);
      TEST_3RF("fmul.d", datad,  80, 128, w17, w28, w15);
      TEST_3RF("fmul.d", datad,  80, 144, w15, w18, w19);
      TEST_3RF("fmul.d", datad,  96,   0, w28, w3,  w12);
      TEST_3RF("fmul.d", datad,  96,  16, w25, w26, w29);
      TEST_3RF("fmul.d", datad,  96,  32, w12, w21, w20);
      TEST_3RF("fmul.d", datad,  96,  48, w16, w31, w28);
      TEST_3RF("fmul.d", datad,  96,  64, w2,  w2,  w26);
      TEST_3RF("fmul.d", datad,  96,  80, w26, w3,  w23);
      TEST_3RF("fmul.d", datad,  96,  96, w14, w22, w2);
      TEST_3RF("fmul.d", datad,  96, 112, w15, w27, w0);
      TEST_3RF("fmul.d", datad,  96, 128, w26, w12, w28);
      TEST_3RF("fmul.d", datad,  96, 144, w9,  w27, w9);
      TEST_3RF("fmul.d", datad, 112,   0, w14, w29, w24);
      TEST_3RF("fmul.d", datad, 112,  16, w17, w9,  w11);
      TEST_3RF("fmul.d", datad, 112,  32, w6,  w29, w24);
      TEST_3RF("fmul.d", datad, 112,  48, w28, w17, w8);
      TEST_3RF("fmul.d", datad, 112,  64, w27, w13, w10);
      TEST_3RF("fmul.d", datad, 112,  80, w22, w8,  w14);
      TEST_3RF("fmul.d", datad, 112,  96, w13, w22, w4);
      TEST_3RF("fmul.d", datad, 112, 112, w16, w5,  w31);
      TEST_3RF("fmul.d", datad, 112, 128, w16, w31, w11);
      TEST_3RF("fmul.d", datad, 112, 144, w12, w9,  w7);
      TEST_3RF("fmul.d", datad, 128,   0, w27, w6,  w31);
      TEST_3RF("fmul.d", datad, 128,  16, w12, w15, w16);
      TEST_3RF("fmul.d", datad, 128,  32, w24, w22, w13);
      TEST_3RF("fmul.d", datad, 128,  48, w16, w18, w30);
      TEST_3RF("fmul.d", datad, 128,  64, w24, w13, w11);
      TEST_3RF("fmul.d", datad, 128,  80, w3,  w3,  w3);
      TEST_3RF("fmul.d", datad, 128,  96, w3,  w3,  w3);
      TEST_3RF("fmul.d", datad, 128, 112, w19, w17, w10);
      TEST_3RF("fmul.d", datad, 128, 128, w21, w1,  w15);
      TEST_3RF("fmul.d", datad, 128, 144, w20, w17, w15);
      TEST_3RF("fmul.d", datad, 144,   0, w31, w29, w24);
      TEST_3RF("fmul.d", datad, 144,  16, w6,  w24, w30);
      TEST_3RF("fmul.d", datad, 144,  32, w5,  w13, w21);
      TEST_3RF("fmul.d", datad, 144,  48, w29, w3,  w2);
      TEST_3RF("fmul.d", datad, 144,  64, w13, w21, w0);
      TEST_3RF("fmul.d", datad, 144,  80, w5,  w3,  w12);
      TEST_3RF("fmul.d", datad, 144,  96, w8,  w6,  w31);
      TEST_3RF("fmul.d", datad, 144, 112, w25, w23, w9);
      TEST_3RF("fmul.d", datad, 144, 128, w14, w24, w25);
      TEST_3RF("fmul.d", datad, 144, 144, w2,  w2,  w9);
      TEST_3RF("fdiv.w", dataf,   0,   0, w8,  w8,  w8);
      TEST_3RF("fdiv.w", dataf,   0,   8, w31, w30, w14);
      TEST_3RF("fdiv.w", dataf,   0,  16, w4,  w11, w3);
      TEST_3RF("fdiv.w", dataf,   0,  24, w1,  w15, w6);
      TEST_3RF("fdiv.w", dataf,   0,  32, w14, w4,  w6);
      TEST_3RF("fdiv.w", dataf,   0,  40, w20, w7,  w18);
      TEST_3RF("fdiv.w", dataf,   0,  48, w28, w14, w18);
      TEST_3RF("fdiv.w", dataf,   0,  56, w22, w5,  w27);
      TEST_3RF("fdiv.w", dataf,   0,  64, w4,  w30, w20);
      TEST_3RF("fdiv.w", dataf,   0,  72, w7,  w28, w7);
      TEST_3RF("fdiv.w", dataf,   8,   0, w9,  w14, w28);
      TEST_3RF("fdiv.w", dataf,   8,   8, w17, w14, w26);
      TEST_3RF("fdiv.w", dataf,   8,  16, w31, w18, w6);
      TEST_3RF("fdiv.w", dataf,   8,  24, w3,  w20, w21);
      TEST_3RF("fdiv.w", dataf,   8,  32, w9,  w2,  w25);
      TEST_3RF("fdiv.w", dataf,   8,  40, w15, w22, w1);
      TEST_3RF("fdiv.w", dataf,   8,  48, w2,  w2,  w19);
      TEST_3RF("fdiv.w", dataf,   8,  56, w15, w20, w9);
      TEST_3RF("fdiv.w", dataf,   8,  64, w20, w15, w13);
      TEST_3RF("fdiv.w", dataf,   8,  72, w18, w4,  w20);
      TEST_3RF("fdiv.w", dataf,  16,   0, w26, w0,  w29);
      TEST_3RF("fdiv.w", dataf,  16,   8, w8,  w8,  w8);
      TEST_3RF("fdiv.w", dataf,  16,  16, w29, w15, w22);
      TEST_3RF("fdiv.w", dataf,  16,  24, w23, w14, w9);
      TEST_3RF("fdiv.w", dataf,  16,  32, w29, w17, w18);
      TEST_3RF("fdiv.w", dataf,  16,  40, w26, w31, w12);
      TEST_3RF("fdiv.w", dataf,  16,  48, w10, w22, w13);
      TEST_3RF("fdiv.w", dataf,  16,  56, w12, w9,  w28);
      TEST_3RF("fdiv.w", dataf,  16,  64, w0,  w18, w18);
      TEST_3RF("fdiv.w", dataf,  16,  72, w16, w15, w31);
      TEST_3RF("fdiv.w", dataf,  24,   0, w3,  w19, w20);
      TEST_3RF("fdiv.w", dataf,  24,   8, w29, w20, w17);
      TEST_3RF("fdiv.w", dataf,  24,  16, w5,  w17, w0);
      TEST_3RF("fdiv.w", dataf,  24,  24, w28, w8,  w15);
      TEST_3RF("fdiv.w", dataf,  24,  32, w5,  w6,  w0);
      TEST_3RF("fdiv.w", dataf,  24,  40, w2,  w2,  w24);
      TEST_3RF("fdiv.w", dataf,  24,  48, w27, w1,  w4);
      TEST_3RF("fdiv.w", dataf,  24,  56, w5,  w23, w17);
      TEST_3RF("fdiv.w", dataf,  24,  64, w17, w0,  w13);
      TEST_3RF("fdiv.w", dataf,  24,  72, w17, w18, w30);
      TEST_3RF("fdiv.w", dataf,  32,   0, w0,  w18, w18);
      TEST_3RF("fdiv.w", dataf,  32,   8, w1,  w20, w6);
      TEST_3RF("fdiv.w", dataf,  32,  16, w30, w8,  w23);
      TEST_3RF("fdiv.w", dataf,  32,  24, w3,  w25, w24);
      TEST_3RF("fdiv.w", dataf,  32,  32, w31, w1,  w7);
      TEST_3RF("fdiv.w", dataf,  32,  40, w4,  w7,  w6);
      TEST_3RF("fdiv.w", dataf,  32,  48, w0,  w2,  w2);
      TEST_3RF("fdiv.w", dataf,  32,  56, w8,  w8,  w8);
      TEST_3RF("fdiv.w", dataf,  32,  64, w4,  w7,  w31);
      TEST_3RF("fdiv.w", dataf,  32,  72, w22, w24, w0);
      TEST_3RF("fdiv.w", dataf,  40,   0, w3,  w9,  w18);
      TEST_3RF("fdiv.w", dataf,  40,   8, w1,  w10, w4);
      TEST_3RF("fdiv.w", dataf,  40,  16, w2,  w2,  w30);
      TEST_3RF("fdiv.w", dataf,  40,  24, w10, w0,  w6);
      TEST_3RF("fdiv.w", dataf,  40,  32, w2,  w2,  w4);
      TEST_3RF("fdiv.w", dataf,  40,  40, w31, w26, w3);
      TEST_3RF("fdiv.w", dataf,  40,  48, w0,  w1,  w1);
      TEST_3RF("fdiv.w", dataf,  40,  56, w8,  w8,  w8);
      TEST_3RF("fdiv.w", dataf,  40,  64, w8,  w8,  w8);
      TEST_3RF("fdiv.w", dataf,  40,  72, w8,  w8,  w8);
      TEST_3RF("fdiv.w", dataf,  48,   0, w14, w8,  w11);
      TEST_3RF("fdiv.w", dataf,  48,   8, w22, w12, w18);
      TEST_3RF("fdiv.w", dataf,  48,  16, w22, w2,  w11);
      TEST_3RF("fdiv.w", dataf,  48,  24, w22, w6,  w20);
      TEST_3RF("fdiv.w", dataf,  48,  32, w8,  w8,  w8);
      TEST_3RF("fdiv.w", dataf,  48,  40, w7,  w30, w7);
      TEST_3RF("fdiv.w", dataf,  48,  48, w13, w10, w28);
      TEST_3RF("fdiv.w", dataf,  48,  56, w23, w10, w2);
      TEST_3RF("fdiv.w", dataf,  48,  64, w25, w14, w1);
      TEST_3RF("fdiv.w", dataf,  48,  72, w19, w18, w2);
      TEST_3RF("fdiv.w", dataf,  56,   0, w20, w26, w10);
      TEST_3RF("fdiv.w", dataf,  56,   8, w29, w8,  w18);
      TEST_3RF("fdiv.w", dataf,  56,  16, w8,  w8,  w8);
      TEST_3RF("fdiv.w", dataf,  56,  24, w31, w30, w26);
      TEST_3RF("fdiv.w", dataf,  56,  32, w21, w1,  w5);
      TEST_3RF("fdiv.w", dataf,  56,  40, w11, w7,  w26);
      TEST_3RF("fdiv.w", dataf,  56,  48, w19, w14, w24);
      TEST_3RF("fdiv.w", dataf,  56,  56, w0,  w24, w24);
      TEST_3RF("fdiv.w", dataf,  56,  64, w21, w24, w3);
      TEST_3RF("fdiv.w", dataf,  56,  72, w23, w17, w25);
      TEST_3RF("fdiv.w", dataf,  64,   0, w5,  w3,  w27);
      TEST_3RF("fdiv.w", dataf,  64,   8, w25, w29, w5);
      TEST_3RF("fdiv.w", dataf,  64,  16, w22, w6,  w23);
      TEST_3RF("fdiv.w", dataf,  64,  24, w30, w5,  w21);
      TEST_3RF("fdiv.w", dataf,  64,  32, w25, w26, w22);
      TEST_3RF("fdiv.w", dataf,  64,  40, w30, w5,  w29);
      TEST_3RF("fdiv.w", dataf,  64,  48, w24, w12, w17);
      TEST_3RF("fdiv.w", dataf,  64,  56, w25, w4,  w6);
      TEST_3RF("fdiv.w", dataf,  64,  64, w17, w7,  w29);
      TEST_3RF("fdiv.w", dataf,  64,  72, w2,  w2,  w25);
      TEST_3RF("fdiv.w", dataf,  72,   0, w22, w7,  w28);
      TEST_3RF("fdiv.w", dataf,  72,   8, w17, w1,  w26);
      TEST_3RF("fdiv.w", dataf,  72,  16, w22, w23, w0);
      TEST_3RF("fdiv.w", dataf,  72,  24, w13, w22, w5);
      TEST_3RF("fdiv.w", dataf,  72,  32, w3,  w15, w31);
      TEST_3RF("fdiv.w", dataf,  72,  40, w25, w13, w4);
      TEST_3RF("fdiv.w", dataf,  72,  48, w23, w6,  w28);
      TEST_3RF("fdiv.w", dataf,  72,  56, w3,  w23, w21);
      TEST_3RF("fdiv.w", dataf,  72,  64, w7,  w29, w7);
      TEST_3RF("fdiv.w", dataf,  72,  72, w6,  w15, w26);
      TEST_3RF("fdiv.d", datad,   0,   0, w9,  w8,  w17);
      TEST_3RF("fdiv.d", datad,   0,  16, w16, w4,  w2);
      TEST_3RF("fdiv.d", datad,   0,  32, w17, w30, w25);
      TEST_3RF("fdiv.d", datad,   0,  48, w9,  w30, w6);
      TEST_3RF("fdiv.d", datad,   0,  64, w31, w3,  w9);
      TEST_3RF("fdiv.d", datad,   0,  80, w14, w2,  w3);
      TEST_3RF("fdiv.d", datad,   0,  96, w27, w6,  w26);
      TEST_3RF("fdiv.d", datad,   0, 112, w1,  w3,  w29);
      TEST_3RF("fdiv.d", datad,   0, 128, w24, w4,  w21);
      TEST_3RF("fdiv.d", datad,   0, 144, w31, w19, w16);
      TEST_3RF("fdiv.d", datad,  16,   0, w8,  w8,  w8);
      TEST_3RF("fdiv.d", datad,  16,  16, w27, w1,  w24);
      TEST_3RF("fdiv.d", datad,  16,  32, w0,  w3,  w3);
      TEST_3RF("fdiv.d", datad,  16,  48, w10, w30, w28);
      TEST_3RF("fdiv.d", datad,  16,  64, w19, w29, w3);
      TEST_3RF("fdiv.d", datad,  16,  80, w18, w0,  w12);
      TEST_3RF("fdiv.d", datad,  16,  96, w0,  w3,  w3);
      TEST_3RF("fdiv.d", datad,  16, 112, w15, w27, w9);
      TEST_3RF("fdiv.d", datad,  16, 128, w9,  w29, w12);
      TEST_3RF("fdiv.d", datad,  16, 144, w6,  w21, w5);
      TEST_3RF("fdiv.d", datad,  32,   0, w11, w4,  w30);
      TEST_3RF("fdiv.d", datad,  32,  16, w27, w12, w26);
      TEST_3RF("fdiv.d", datad,  32,  32, w28, w4,  w26);
      TEST_3RF("fdiv.d", datad,  32,  48, w31, w14, w24);
      TEST_3RF("fdiv.d", datad,  32,  64, w28, w1,  w21);
      TEST_3RF("fdiv.d", datad,  32,  80, w31, w19, w22);
      TEST_3RF("fdiv.d", datad,  32,  96, w11, w19, w25);
      TEST_3RF("fdiv.d", datad,  32, 112, w27, w15, w2);
      TEST_3RF("fdiv.d", datad,  32, 128, w4,  w12, w15);
      TEST_3RF("fdiv.d", datad,  32, 144, w11, w1,  w20);
      TEST_3RF("fdiv.d", datad,  48,   0, w22, w12, w24);
      TEST_3RF("fdiv.d", datad,  48,  16, w20, w7,  w4);
      TEST_3RF("fdiv.d", datad,  48,  32, w14, w3,  w8);
      TEST_3RF("fdiv.d", datad,  48,  48, w8,  w8,  w8);
      TEST_3RF("fdiv.d", datad,  48,  64, w3,  w23, w1);
      TEST_3RF("fdiv.d", datad,  48,  80, w31, w24, w22);
      TEST_3RF("fdiv.d", datad,  48,  96, w30, w12, w9);
      TEST_3RF("fdiv.d", datad,  48, 112, w31, w5,  w4);
      TEST_3RF("fdiv.d", datad,  48, 128, w14, w8,  w9);
      TEST_3RF("fdiv.d", datad,  48, 144, w26, w23, w20);
      TEST_3RF("fdiv.d", datad,  64,   0, w28, w11, w10);
      TEST_3RF("fdiv.d", datad,  64,  16, w8,  w8,  w8);
      TEST_3RF("fdiv.d", datad,  64,  32, w3,  w30, w16);
      TEST_3RF("fdiv.d", datad,  64,  48, w7,  w13, w7);
      TEST_3RF("fdiv.d", datad,  64,  64, w19, w15, w21);
      TEST_3RF("fdiv.d", datad,  64,  80, w22, w6,  w21);
      TEST_3RF("fdiv.d", datad,  64,  96, w31, w13, w19);
      TEST_3RF("fdiv.d", datad,  64, 112, w11, w25, w29);
      TEST_3RF("fdiv.d", datad,  64, 128, w10, w31, w1);
      TEST_3RF("fdiv.d", datad,  64, 144, w25, w7,  w10);
      TEST_3RF("fdiv.d", datad,  80,   0, w19, w30, w15);
      TEST_3RF("fdiv.d", datad,  80,  16, w9,  w8,  w24);
      TEST_3RF("fdiv.d", datad,  80,  32, w12, w7,  w8);
      TEST_3RF("fdiv.d", datad,  80,  48, w19, w20, w27);
      TEST_3RF("fdiv.d", datad,  80,  64, w2,  w2,  w9);
      TEST_3RF("fdiv.d", datad,  80,  80, w18, w9,  w0);
      TEST_3RF("fdiv.d", datad,  80,  96, w7,  w8,  w7);
      TEST_3RF("fdiv.d", datad,  80, 112, w13, w27, w19);
      TEST_3RF("fdiv.d", datad,  80, 128, w6,  w24, w29);
      TEST_3RF("fdiv.d", datad,  80, 144, w5,  w25, w22);
      TEST_3RF("fdiv.d", datad,  96,   0, w12, w4,  w10);
      TEST_3RF("fdiv.d", datad,  96,  16, w10, w2,  w25);
      TEST_3RF("fdiv.d", datad,  96,  32, w19, w11, w17);
      TEST_3RF("fdiv.d", datad,  96,  48, w31, w18, w25);
      TEST_3RF("fdiv.d", datad,  96,  64, w18, w6,  w21);
      TEST_3RF("fdiv.d", datad,  96,  80, w21, w15, w7);
      TEST_3RF("fdiv.d", datad,  96,  96, w30, w15, w14);
      TEST_3RF("fdiv.d", datad,  96, 112, w6,  w28, w9);
      TEST_3RF("fdiv.d", datad,  96, 128, w25, w3,  w1);
      TEST_3RF("fdiv.d", datad,  96, 144, w22, w8,  w27);
      TEST_3RF("fdiv.d", datad, 112,   0, w13, w21, w31);
      TEST_3RF("fdiv.d", datad, 112,  16, w23, w31, w1);
      TEST_3RF("fdiv.d", datad, 112,  32, w16, w19, w12);
      TEST_3RF("fdiv.d", datad, 112,  48, w2,  w2,  w18);
      TEST_3RF("fdiv.d", datad, 112,  64, w30, w27, w5);
      TEST_3RF("fdiv.d", datad, 112,  80, w4,  w16, w26);
      TEST_3RF("fdiv.d", datad, 112,  96, w20, w23, w24);
      TEST_3RF("fdiv.d", datad, 112, 112, w3,  w6,  w30);
      TEST_3RF("fdiv.d", datad, 112, 128, w0,  w15, w15);
      TEST_3RF("fdiv.d", datad, 112, 144, w23, w3,  w17);
      TEST_3RF("fdiv.d", datad, 128,   0, w13, w11, w12);
      TEST_3RF("fdiv.d", datad, 128,  16, w26, w0,  w11);
      TEST_3RF("fdiv.d", datad, 128,  32, w17, w0,  w12);
      TEST_3RF("fdiv.d", datad, 128,  48, w2,  w2,  w19);
      TEST_3RF("fdiv.d", datad, 128,  64, w25, w4,  w5);
      TEST_3RF("fdiv.d", datad, 128,  80, w23, w31, w10);
      TEST_3RF("fdiv.d", datad, 128,  96, w28, w16, w4);
      TEST_3RF("fdiv.d", datad, 128, 112, w16, w7,  w28);
      TEST_3RF("fdiv.d", datad, 128, 128, w19, w13, w26);
      TEST_3RF("fdiv.d", datad, 128, 144, w19, w29, w17);
      TEST_3RF("fdiv.d", datad, 144,   0, w22, w14, w31);
      TEST_3RF("fdiv.d", datad, 144,  16, w2,  w2,  w26);
      TEST_3RF("fdiv.d", datad, 144,  32, w25, w2,  w5);
      TEST_3RF("fdiv.d", datad, 144,  48, w11, w2,  w17);
      TEST_3RF("fdiv.d", datad, 144,  64, w13, w21, w10);
      TEST_3RF("fdiv.d", datad, 144,  80, w17, w27, w2);
      TEST_3RF("fdiv.d", datad, 144,  96, w16, w5,  w30);
      TEST_3RF("fdiv.d", datad, 144, 112, w0,  w10, w10);
      TEST_3RF("fdiv.d", datad, 144, 128, w14, w8,  w6);
      TEST_3RF("fdiv.d", datad, 144, 144, w1,  w21, w18);
      TEST_3RF("fsub.w", dataf,   0,   0, w13, w26, w11);
      TEST_3RF("fsub.w", dataf,   0,   8, w16, w31, w22);
      TEST_3RF("fsub.w", dataf,   0,  16, w18, w18, w18);
      TEST_3RF("fsub.w", dataf,   0,  24, w17, w3,  w3);
      TEST_3RF("fsub.w", dataf,   0,  32, w8,  w27, w20);
      TEST_3RF("fsub.w", dataf,   0,  40, w3,  w29, w4);
      TEST_3RF("fsub.w", dataf,   0,  48, w8,  w27, w5);
      TEST_3RF("fsub.w", dataf,   0,  56, w18, w18, w18);
      TEST_3RF("fsub.w", dataf,   0,  64, w9,  w13, w25);
      TEST_3RF("fsub.w", dataf,   0,  72, w11, w11, w2);
      TEST_3RF("fsub.w", dataf,   8,   0, w26, w0,  w21);
      TEST_3RF("fsub.w", dataf,   8,   8, w12, w11, w21);
      TEST_3RF("fsub.w", dataf,   8,  16, w30, w25, w16);
      TEST_3RF("fsub.w", dataf,   8,  24, w9,  w15, w31);
      TEST_3RF("fsub.w", dataf,   8,  32, w27, w0,  w2);
      TEST_3RF("fsub.w", dataf,   8,  40, w3,  w28, w22);
      TEST_3RF("fsub.w", dataf,   8,  48, w6,  w25, w26);
      TEST_3RF("fsub.w", dataf,   8,  56, w15, w21, w31);
      TEST_3RF("fsub.w", dataf,   8,  64, w1,  w30, w12);
      TEST_3RF("fsub.w", dataf,   8,  72, w26, w9,  w15);
      TEST_3RF("fsub.w", dataf,  16,   0, w20, w9,  w4);
      TEST_3RF("fsub.w", dataf,  16,   8, w1,  w21, w25);
      TEST_3RF("fsub.w", dataf,  16,  16, w31, w14, w9);
      TEST_3RF("fsub.w", dataf,  16,  24, w8,  w23, w25);
      TEST_3RF("fsub.w", dataf,  16,  32, w7,  w18, w25);
      TEST_3RF("fsub.w", dataf,  16,  40, w9,  w22, w21);
      TEST_3RF("fsub.w", dataf,  16,  48, w31, w28, w15);
      TEST_3RF("fsub.w", dataf,  16,  56, w25, w11, w4);
      TEST_3RF("fsub.w", dataf,  16,  64, w25, w13, w2);
      TEST_3RF("fsub.w", dataf,  16,  72, w5,  w7,  w12);
      TEST_3RF("fsub.w", dataf,  24,   0, w20, w28, w21);
      TEST_3RF("fsub.w", dataf,  24,   8, w24, w29, w10);
      TEST_3RF("fsub.w", dataf,  24,  16, w18, w18, w18);
      TEST_3RF("fsub.w", dataf,  24,  24, w28, w24, w27);
      TEST_3RF("fsub.w", dataf,  24,  32, w4,  w15, w20);
      TEST_3RF("fsub.w", dataf,  24,  40, w11, w11, w2);
      TEST_3RF("fsub.w", dataf,  24,  48, w14, w20, w24);
      TEST_3RF("fsub.w", dataf,  24,  56, w3,  w19, w20);
      TEST_3RF("fsub.w", dataf,  24,  64, w18, w18, w18);
      TEST_3RF("fsub.w", dataf,  24,  72, w12, w0,  w22);
      TEST_3RF("fsub.w", dataf,  32,   0, w5,  w13, w25);
      TEST_3RF("fsub.w", dataf,  32,   8, w11, w11, w20);
      TEST_3RF("fsub.w", dataf,  32,  16, w5,  w31, w16);
      TEST_3RF("fsub.w", dataf,  32,  24, w26, w24, w13);
      TEST_3RF("fsub.w", dataf,  32,  32, w5,  w10, w9);
      TEST_3RF("fsub.w", dataf,  32,  40, w29, w5,  w13);
      TEST_3RF("fsub.w", dataf,  32,  48, w13, w26, w24);
      TEST_3RF("fsub.w", dataf,  32,  56, w15, w8,  w12);
      TEST_3RF("fsub.w", dataf,  32,  64, w7,  w11, w31);
      TEST_3RF("fsub.w", dataf,  32,  72, w27, w30, w12);
      TEST_3RF("fsub.w", dataf,  40,   0, w27, w20, w17);
      TEST_3RF("fsub.w", dataf,  40,   8, w8,  w13, w28);
      TEST_3RF("fsub.w", dataf,  40,  16, w29, w18, w28);
      TEST_3RF("fsub.w", dataf,  40,  24, w13, w20, w27);
      TEST_3RF("fsub.w", dataf,  40,  32, w18, w18, w18);
      TEST_3RF("fsub.w", dataf,  40,  40, w30, w4,  w15);
      TEST_3RF("fsub.w", dataf,  40,  48, w3,  w18, w28);
      TEST_3RF("fsub.w", dataf,  40,  56, w29, w10, w11);
      TEST_3RF("fsub.w", dataf,  40,  64, w5,  w23, w18);
      TEST_3RF("fsub.w", dataf,  40,  72, w17, w22, w22);
      TEST_3RF("fsub.w", dataf,  48,   0, w14, w15, w2);
      TEST_3RF("fsub.w", dataf,  48,   8, w9,  w3,  w20);
      TEST_3RF("fsub.w", dataf,  48,  16, w18, w18, w18);
      TEST_3RF("fsub.w", dataf,  48,  24, w17, w16, w16);
      TEST_3RF("fsub.w", dataf,  48,  32, w15, w3,  w12);
      TEST_3RF("fsub.w", dataf,  48,  40, w28, w16, w0);
      TEST_3RF("fsub.w", dataf,  48,  48, w23, w2,  w30);
      TEST_3RF("fsub.w", dataf,  48,  56, w28, w18, w2);
      TEST_3RF("fsub.w", dataf,  48,  64, w14, w31, w24);
      TEST_3RF("fsub.w", dataf,  48,  72, w26, w5,  w15);
      TEST_3RF("fsub.w", dataf,  56,   0, w12, w22, w6);
      TEST_3RF("fsub.w", dataf,  56,   8, w26, w5,  w8);
      TEST_3RF("fsub.w", dataf,  56,  16, w4,  w8,  w28);
      TEST_3RF("fsub.w", dataf,  56,  24, w22, w25, w13);
      TEST_3RF("fsub.w", dataf,  56,  32, w5,  w29, w25);
      TEST_3RF("fsub.w", dataf,  56,  40, w1,  w13, w26);
      TEST_3RF("fsub.w", dataf,  56,  48, w25, w16, w24);
      TEST_3RF("fsub.w", dataf,  56,  56, w21, w2,  w26);
      TEST_3RF("fsub.w", dataf,  56,  64, w3,  w16, w26);
      TEST_3RF("fsub.w", dataf,  56,  72, w27, w10, w31);
      TEST_3RF("fsub.w", dataf,  64,   0, w11, w11, w23);
      TEST_3RF("fsub.w", dataf,  64,   8, w21, w17, w26);
      TEST_3RF("fsub.w", dataf,  64,  16, w25, w21, w2);
      TEST_3RF("fsub.w", dataf,  64,  24, w22, w11, w28);
      TEST_3RF("fsub.w", dataf,  64,  32, w3,  w16, w25);
      TEST_3RF("fsub.w", dataf,  64,  40, w28, w18, w6);
      TEST_3RF("fsub.w", dataf,  64,  48, w22, w11, w15);
      TEST_3RF("fsub.w", dataf,  64,  56, w0,  w24, w0);
      TEST_3RF("fsub.w", dataf,  64,  64, w9,  w3,  w30);
      TEST_3RF("fsub.w", dataf,  64,  72, w19, w2,  w9);
      TEST_3RF("fsub.w", dataf,  72,   0, w10, w23, w26);
      TEST_3RF("fsub.w", dataf,  72,   8, w28, w17, w20);
      TEST_3RF("fsub.w", dataf,  72,  16, w17, w20, w20);
      TEST_3RF("fsub.w", dataf,  72,  24, w10, w29, w16);
      TEST_3RF("fsub.w", dataf,  72,  32, w13, w9,  w31);
      TEST_3RF("fsub.w", dataf,  72,  40, w15, w0,  w10);
      TEST_3RF("fsub.w", dataf,  72,  48, w6,  w15, w10);
      TEST_3RF("fsub.w", dataf,  72,  56, w30, w24, w13);
      TEST_3RF("fsub.w", dataf,  72,  64, w7,  w28, w12);
      TEST_3RF("fsub.w", dataf,  72,  72, w27, w30, w21);
      TEST_3RF("fsub.d", datad,   0,   0, w5,  w22, w16);
      TEST_3RF("fsub.d", datad,   0,  16, w1,  w7,  w4);
      TEST_3RF("fsub.d", datad,   0,  32, w19, w27, w14);
      TEST_3RF("fsub.d", datad,   0,  48, w16, w11, w27);
      TEST_3RF("fsub.d", datad,   0,  64, w29, w20, w4);
      TEST_3RF("fsub.d", datad,   0,  80, w29, w4,  w7);
      TEST_3RF("fsub.d", datad,   0,  96, w10, w19, w18);
      TEST_3RF("fsub.d", datad,   0, 112, w8,  w12, w31);
      TEST_3RF("fsub.d", datad,   0, 128, w16, w8,  w11);
      TEST_3RF("fsub.d", datad,   0, 144, w11, w11, w6);
      TEST_3RF("fsub.d", datad,  16,   0, w1,  w16, w28);
      TEST_3RF("fsub.d", datad,  16,  16, w17, w18, w18);
      TEST_3RF("fsub.d", datad,  16,  32, w4,  w21, w5);
      TEST_3RF("fsub.d", datad,  16,  48, w31, w3,  w21);
      TEST_3RF("fsub.d", datad,  16,  64, w11, w11, w30);
      TEST_3RF("fsub.d", datad,  16,  80, w18, w18, w18);
      TEST_3RF("fsub.d", datad,  16,  96, w31, w2,  w15);
      TEST_3RF("fsub.d", datad,  16, 112, w3,  w7,  w23);
      TEST_3RF("fsub.d", datad,  16, 128, w13, w26, w9);
      TEST_3RF("fsub.d", datad,  16, 144, w22, w6,  w8);
      TEST_3RF("fsub.d", datad,  32,   0, w6,  w14, w20);
      TEST_3RF("fsub.d", datad,  32,  16, w17, w21, w21);
      TEST_3RF("fsub.d", datad,  32,  32, w21, w1,  w17);
      TEST_3RF("fsub.d", datad,  32,  48, w6,  w19, w21);
      TEST_3RF("fsub.d", datad,  32,  64, w27, w24, w21);
      TEST_3RF("fsub.d", datad,  32,  80, w30, w13, w0);
      TEST_3RF("fsub.d", datad,  32,  96, w28, w0,  w31);
      TEST_3RF("fsub.d", datad,  32, 112, w30, w15, w3);
      TEST_3RF("fsub.d", datad,  32, 128, w5,  w6,  w16);
      TEST_3RF("fsub.d", datad,  32, 144, w0,  w15, w0);
      TEST_3RF("fsub.d", datad,  48,   0, w6,  w24, w12);
      TEST_3RF("fsub.d", datad,  48,  16, w21, w12, w29);
      TEST_3RF("fsub.d", datad,  48,  32, w10, w1,  w31);
      TEST_3RF("fsub.d", datad,  48,  48, w27, w7,  w18);
      TEST_3RF("fsub.d", datad,  48,  64, w17, w2,  w2);
      TEST_3RF("fsub.d", datad,  48,  80, w11, w11, w6);
      TEST_3RF("fsub.d", datad,  48,  96, w0,  w24, w0);
      TEST_3RF("fsub.d", datad,  48, 112, w6,  w28, w24);
      TEST_3RF("fsub.d", datad,  48, 128, w5,  w26, w8);
      TEST_3RF("fsub.d", datad,  48, 144, w8,  w0,  w14);
      TEST_3RF("fsub.d", datad,  64,   0, w25, w0,  w30);
      TEST_3RF("fsub.d", datad,  64,  16, w31, w6,  w22);
      TEST_3RF("fsub.d", datad,  64,  32, w12, w27, w2);
      TEST_3RF("fsub.d", datad,  64,  48, w9,  w5,  w3);
      TEST_3RF("fsub.d", datad,  64,  64, w8,  w1,  w10);
      TEST_3RF("fsub.d", datad,  64,  80, w27, w18, w12);
      TEST_3RF("fsub.d", datad,  64,  96, w6,  w24, w12);
      TEST_3RF("fsub.d", datad,  64, 112, w30, w8,  w23);
      TEST_3RF("fsub.d", datad,  64, 128, w3,  w2,  w31);
      TEST_3RF("fsub.d", datad,  64, 144, w12, w2,  w13);
      TEST_3RF("fsub.d", datad,  80,   0, w5,  w2,  w11);
      TEST_3RF("fsub.d", datad,  80,  16, w4,  w9,  w1);
      TEST_3RF("fsub.d", datad,  80,  32, w16, w4,  w3);
      TEST_3RF("fsub.d", datad,  80,  48, w26, w10, w6);
      TEST_3RF("fsub.d", datad,  80,  64, w2,  w11, w16);
      TEST_3RF("fsub.d", datad,  80,  80, w29, w28, w3);
      TEST_3RF("fsub.d", datad,  80,  96, w21, w8,  w2);
      TEST_3RF("fsub.d", datad,  80, 112, w19, w16, w25);
      TEST_3RF("fsub.d", datad,  80, 128, w22, w19, w24);
      TEST_3RF("fsub.d", datad,  80, 144, w2,  w21, w5);
      TEST_3RF("fsub.d", datad,  96,   0, w7,  w24, w17);
      TEST_3RF("fsub.d", datad,  96,  16, w12, w1,  w18);
      TEST_3RF("fsub.d", datad,  96,  32, w28, w5,  w22);
      TEST_3RF("fsub.d", datad,  96,  48, w22, w15, w28);
      TEST_3RF("fsub.d", datad,  96,  64, w25, w26, w13);
      TEST_3RF("fsub.d", datad,  96,  80, w22, w23, w9);
      TEST_3RF("fsub.d", datad,  96,  96, w26, w12, w18);
      TEST_3RF("fsub.d", datad,  96, 112, w28, w31, w2);
      TEST_3RF("fsub.d", datad,  96, 128, w21, w22, w13);
      TEST_3RF("fsub.d", datad,  96, 144, w24, w11, w18);
      TEST_3RF("fsub.d", datad, 112,   0, w0,  w3,  w0);
      TEST_3RF("fsub.d", datad, 112,  16, w3,  w12, w4);
      TEST_3RF("fsub.d", datad, 112,  32, w22, w8,  w9);
      TEST_3RF("fsub.d", datad, 112,  48, w12, w31, w25);
      TEST_3RF("fsub.d", datad, 112,  64, w8,  w24, w19);
      TEST_3RF("fsub.d", datad, 112,  80, w21, w14, w11);
      TEST_3RF("fsub.d", datad, 112,  96, w31, w8,  w23);
      TEST_3RF("fsub.d", datad, 112, 112, w17, w4,  w4);
      TEST_3RF("fsub.d", datad, 112, 128, w23, w19, w25);
      TEST_3RF("fsub.d", datad, 112, 144, w13, w9,  w6);
      TEST_3RF("fsub.d", datad, 128,   0, w5,  w20, w25);
      TEST_3RF("fsub.d", datad, 128,  16, w5,  w23, w28);
      TEST_3RF("fsub.d", datad, 128,  32, w17, w27, w27);
      TEST_3RF("fsub.d", datad, 128,  48, w18, w18, w18);
      TEST_3RF("fsub.d", datad, 128,  64, w26, w4,  w30);
      TEST_3RF("fsub.d", datad, 128,  80, w25, w29, w7);
      TEST_3RF("fsub.d", datad, 128,  96, w17, w28, w28);
      TEST_3RF("fsub.d", datad, 128, 112, w31, w28, w27);
      TEST_3RF("fsub.d", datad, 128, 128, w8,  w19, w12);
      TEST_3RF("fsub.d", datad, 128, 144, w12, w10, w0);
      TEST_3RF("fsub.d", datad, 144,   0, w6,  w23, w9);
      TEST_3RF("fsub.d", datad, 144,  16, w12, w29, w5);
      TEST_3RF("fsub.d", datad, 144,  32, w2,  w20, w15);
      TEST_3RF("fsub.d", datad, 144,  48, w20, w14, w19);
      TEST_3RF("fsub.d", datad, 144,  64, w19, w7,  w17);
      TEST_3RF("fsub.d", datad, 144,  80, w26, w24, w2);
      TEST_3RF("fsub.d", datad, 144,  96, w22, w23, w30);
      TEST_3RF("fsub.d", datad, 144, 112, w18, w18, w18);
      TEST_3RF("fsub.d", datad, 144, 128, w31, w17, w30);
      TEST_3RF("fsub.d", datad, 144, 144, w12, w28, w30);
      TEST_3RF("fexp2.w", dataf,   0,   0, w16, w4,  w19);
      TEST_3RF("fexp2.w", dataf,   0,   8, w24, w6,  w7);
      TEST_3RF("fexp2.w", dataf,   0,  16, w7,  w26, w7);
      TEST_3RF("fexp2.w", dataf,   0,  24, w21, w27, w13);
      TEST_3RF("fexp2.w", dataf,   0,  32, w28, w12, w7);
      TEST_3RF("fexp2.w", dataf,   0,  40, w20, w14, w30);
      TEST_3RF("fexp2.w", dataf,   0,  48, w11, w12, w16);
      TEST_3RF("fexp2.w", dataf,   0,  56, w11, w29, w14);
      TEST_3RF("fexp2.w", dataf,   0,  64, w23, w25, w13);
      TEST_3RF("fexp2.w", dataf,   0,  72, w9,  w13, w20);
      TEST_3RF("fexp2.w", dataf,   8,   0, w7,  w29, w7);
      TEST_3RF("fexp2.w", dataf,   8,   8, w25, w11, w16);
      TEST_3RF("fexp2.w", dataf,   8,  16, w17, w23, w25);
      TEST_3RF("fexp2.w", dataf,   8,  24, w12, w20, w25);
      TEST_3RF("fexp2.w", dataf,   8,  32, w8,  w0,  w1);
      TEST_3RF("fexp2.w", dataf,   8,  40, w28, w14, w31);
      TEST_3RF("fexp2.w", dataf,   8,  48, w8,  w26, w15);
      TEST_3RF("fexp2.w", dataf,   8,  56, w19, w19, w23);
      TEST_3RF("fexp2.w", dataf,   8,  64, w29, w10, w17);
      TEST_3RF("fexp2.w", dataf,   8,  72, w10, w19, w30);
      TEST_3RF("fexp2.w", dataf,  16,   0, w31, w26, w27);
      TEST_3RF("fexp2.w", dataf,  16,   8, w24, w6,  w12);
      TEST_3RF("fexp2.w", dataf,  16,  16, w9,  w23, w3);
      TEST_3RF("fexp2.w", dataf,  16,  24, w2,  w3,  w16);
      TEST_3RF("fexp2.w", dataf,  16,  32, w22, w29, w24);
      TEST_3RF("fexp2.w", dataf,  16,  40, w22, w30, w21);
      TEST_3RF("fexp2.w", dataf,  16,  48, w4,  w29, w30);
      TEST_3RF("fexp2.w", dataf,  16,  56, w12, w16, w22);
      TEST_3RF("fexp2.w", dataf,  16,  64, w9,  w26, w7);
      TEST_3RF("fexp2.w", dataf,  16,  72, w20, w13, w5);
      TEST_3RF("fexp2.w", dataf,  24,   0, w19, w19, w7);
      TEST_3RF("fexp2.w", dataf,  24,   8, w0,  w11, w13);
      TEST_3RF("fexp2.w", dataf,  24,  16, w12, w20, w5);
      TEST_3RF("fexp2.w", dataf,  24,  24, w16, w23, w8);
      TEST_3RF("fexp2.w", dataf,  24,  32, w0,  w13, w5);
      TEST_3RF("fexp2.w", dataf,  24,  40, w24, w4,  w3);
      TEST_3RF("fexp2.w", dataf,  24,  48, w13, w8,  w0);
      TEST_3RF("fexp2.w", dataf,  24,  56, w10, w7,  w12);
      TEST_3RF("fexp2.w", dataf,  24,  64, w26, w29, w22);
      TEST_3RF("fexp2.w", dataf,  24,  72, w20, w4,  w10);
      TEST_3RF("fexp2.w", dataf,  32,   0, w1,  w9,  w29);
      TEST_3RF("fexp2.w", dataf,  32,   8, w9,  w8,  w22);
      TEST_3RF("fexp2.w", dataf,  32,  16, w22, w28, w27);
      TEST_3RF("fexp2.w", dataf,  32,  24, w6,  w19, w4);
      TEST_3RF("fexp2.w", dataf,  32,  32, w6,  w1,  w9);
      TEST_3RF("fexp2.w", dataf,  32,  40, w30, w5,  w5);
      TEST_3RF("fexp2.w", dataf,  32,  48, w13, w12, w22);
      TEST_3RF("fexp2.w", dataf,  32,  56, w20, w26, w17);
      TEST_3RF("fexp2.w", dataf,  32,  64, w17, w16, w5);
      TEST_3RF("fexp2.w", dataf,  32,  72, w21, w26, w7);
      TEST_3RF("fexp2.w", dataf,  40,   0, w30, w23, w23);
      TEST_3RF("fexp2.w", dataf,  40,   8, w16, w8,  w31);
      TEST_3RF("fexp2.w", dataf,  40,  16, w6,  w30, w27);
      TEST_3RF("fexp2.w", dataf,  40,  24, w2,  w4,  w15);
      TEST_3RF("fexp2.w", dataf,  40,  32, w6,  w10, w16);
      TEST_3RF("fexp2.w", dataf,  40,  40, w15, w8,  w21);
      TEST_3RF("fexp2.w", dataf,  40,  48, w28, w20, w2);
      TEST_3RF("fexp2.w", dataf,  40,  56, w10, w11, w23);
      TEST_3RF("fexp2.w", dataf,  40,  64, w4,  w28, w8);
      TEST_3RF("fexp2.w", dataf,  40,  72, w20, w1,  w30);
      TEST_3RF("fexp2.w", dataf,  48,   0, w14, w8,  w28);
      TEST_3RF("fexp2.w", dataf,  48,   8, w5,  w24, w4);
      TEST_3RF("fexp2.w", dataf,  48,  16, w4,  w31, w2);
      TEST_3RF("fexp2.w", dataf,  48,  24, w31, w1,  w6);
      TEST_3RF("fexp2.w", dataf,  48,  32, w14, w7,  w16);
      TEST_3RF("fexp2.w", dataf,  48,  40, w30, w22, w22);
      TEST_3RF("fexp2.w", dataf,  48,  48, w25, w19, w13);
      TEST_3RF("fexp2.w", dataf,  48,  56, w22, w29, w24);
      TEST_3RF("fexp2.w", dataf,  48,  64, w13, w1,  w20);
      TEST_3RF("fexp2.w", dataf,  48,  72, w21, w22, w19);
      TEST_3RF("fexp2.w", dataf,  56,   0, w3,  w30, w16);
      TEST_3RF("fexp2.w", dataf,  56,   8, w8,  w23, w20);
      TEST_3RF("fexp2.w", dataf,  56,  16, w12, w22, w23);
      TEST_3RF("fexp2.w", dataf,  56,  24, w11, w23, w29);
      TEST_3RF("fexp2.w", dataf,  56,  32, w26, w30, w14);
      TEST_3RF("fexp2.w", dataf,  56,  40, w24, w20, w7);
      TEST_3RF("fexp2.w", dataf,  56,  48, w12, w7,  w20);
      TEST_3RF("fexp2.w", dataf,  56,  56, w2,  w4,  w13);
      TEST_3RF("fexp2.w", dataf,  56,  64, w15, w5,  w1);
      TEST_3RF("fexp2.w", dataf,  56,  72, w4,  w26, w23);
      TEST_3RF("fexp2.w", dataf,  64,   0, w24, w29, w22);
      TEST_3RF("fexp2.w", dataf,  64,   8, w8,  w5,  w13);
      TEST_3RF("fexp2.w", dataf,  64,  16, w28, w17, w3);
      TEST_3RF("fexp2.w", dataf,  64,  24, w19, w19, w29);
      TEST_3RF("fexp2.w", dataf,  64,  32, w26, w17, w23);
      TEST_3RF("fexp2.w", dataf,  64,  40, w24, w31, w15);
      TEST_3RF("fexp2.w", dataf,  64,  48, w12, w6,  w27);
      TEST_3RF("fexp2.w", dataf,  64,  56, w20, w26, w29);
      TEST_3RF("fexp2.w", dataf,  64,  64, w24, w7,  w12);
      TEST_3RF("fexp2.w", dataf,  64,  72, w30, w9,  w9);
      TEST_3RF("fexp2.w", dataf,  72,   0, w17, w24, w0);
      TEST_3RF("fexp2.w", dataf,  72,   8, w9,  w22, w17);
      TEST_3RF("fexp2.w", dataf,  72,  16, w27, w3,  w13);
      TEST_3RF("fexp2.w", dataf,  72,  24, w13, w6,  w1);
      TEST_3RF("fexp2.w", dataf,  72,  32, w10, w0,  w18);
      TEST_3RF("fexp2.w", dataf,  72,  40, w1,  w24, w17);
      TEST_3RF("fexp2.w", dataf,  72,  48, w16, w5,  w23);
      TEST_3RF("fexp2.w", dataf,  72,  56, w12, w25, w17);
      TEST_3RF("fexp2.w", dataf,  72,  64, w9,  w17, w25);
      TEST_3RF("fexp2.w", dataf,  72,  72, w22, w15, w2);
      TEST_3RF("fexp2.d", datad,   0,   0, w7,  w8,  w7);
      TEST_3RF("fexp2.d", datad,   0,  16, w2,  w16, w30);
      TEST_3RF("fexp2.d", datad,   0,  32, w25, w1,  w28);
      TEST_3RF("fexp2.d", datad,   0,  48, w14, w6,  w3);
      TEST_3RF("fexp2.d", datad,   0,  64, w15, w16, w3);
      TEST_3RF("fexp2.d", datad,   0,  80, w1,  w17, w28);
      TEST_3RF("fexp2.d", datad,   0,  96, w18, w18, w18);
      TEST_3RF("fexp2.d", datad,   0, 112, w2,  w1,  w9);
      TEST_3RF("fexp2.d", datad,   0, 128, w14, w26, w27);
      TEST_3RF("fexp2.d", datad,   0, 144, w23, w11, w20);
      TEST_3RF("fexp2.d", datad,  16,   0, w13, w27, w22);
      TEST_3RF("fexp2.d", datad,  16,  16, w20, w3,  w24);
      TEST_3RF("fexp2.d", datad,  16,  32, w4,  w1,  w17);
      TEST_3RF("fexp2.d", datad,  16,  48, w5,  w26, w14);
      TEST_3RF("fexp2.d", datad,  16,  64, w20, w1,  w17);
      TEST_3RF("fexp2.d", datad,  16,  80, w3,  w17, w20);
      TEST_3RF("fexp2.d", datad,  16,  96, w5,  w3,  w16);
      TEST_3RF("fexp2.d", datad,  16, 112, w23, w5,  w17);
      TEST_3RF("fexp2.d", datad,  16, 128, w1,  w19, w11);
      TEST_3RF("fexp2.d", datad,  16, 144, w28, w10, w23);
      TEST_3RF("fexp2.d", datad,  32,   0, w16, w24, w18);
      TEST_3RF("fexp2.d", datad,  32,  16, w6,  w12, w21);
      TEST_3RF("fexp2.d", datad,  32,  32, w30, w17, w17);
      TEST_3RF("fexp2.d", datad,  32,  48, w22, w16, w30);
      TEST_3RF("fexp2.d", datad,  32,  64, w10, w17, w15);
      TEST_3RF("fexp2.d", datad,  32,  80, w14, w3,  w19);
      TEST_3RF("fexp2.d", datad,  32,  96, w6,  w20, w10);
      TEST_3RF("fexp2.d", datad,  32, 112, w11, w5,  w30);
      TEST_3RF("fexp2.d", datad,  32, 128, w17, w7,  w8);
      TEST_3RF("fexp2.d", datad,  32, 144, w8,  w23, w0);
      TEST_3RF("fexp2.d", datad,  48,   0, w26, w29, w13);
      TEST_3RF("fexp2.d", datad,  48,  16, w15, w28, w30);
      TEST_3RF("fexp2.d", datad,  48,  32, w5,  w12, w20);
      TEST_3RF("fexp2.d", datad,  48,  48, w21, w10, w31);
      TEST_3RF("fexp2.d", datad,  48,  64, w7,  w25, w7);
      TEST_3RF("fexp2.d", datad,  48,  80, w13, w10, w28);
      TEST_3RF("fexp2.d", datad,  48,  96, w0,  w16, w10);
      TEST_3RF("fexp2.d", datad,  48, 112, w27, w22, w25);
      TEST_3RF("fexp2.d", datad,  48, 128, w7,  w29, w7);
      TEST_3RF("fexp2.d", datad,  48, 144, w1,  w15, w21);
      TEST_3RF("fexp2.d", datad,  64,   0, w2,  w9,  w18);
      TEST_3RF("fexp2.d", datad,  64,  16, w15, w24, w14);
      TEST_3RF("fexp2.d", datad,  64,  32, w13, w29, w26);
      TEST_3RF("fexp2.d", datad,  64,  48, w1,  w18, w4);
      TEST_3RF("fexp2.d", datad,  64,  64, w0,  w25, w29);
      TEST_3RF("fexp2.d", datad,  64,  80, w13, w3,  w26);
      TEST_3RF("fexp2.d", datad,  64,  96, w13, w19, w10);
      TEST_3RF("fexp2.d", datad,  64, 112, w24, w14, w0);
      TEST_3RF("fexp2.d", datad,  64, 128, w14, w7,  w11);
      TEST_3RF("fexp2.d", datad,  64, 144, w9,  w22, w0);
      TEST_3RF("fexp2.d", datad,  80,   0, w11, w31, w19);
      TEST_3RF("fexp2.d", datad,  80,  16, w26, w23, w1);
      TEST_3RF("fexp2.d", datad,  80,  32, w7,  w20, w7);
      TEST_3RF("fexp2.d", datad,  80,  48, w28, w8,  w7);
      TEST_3RF("fexp2.d", datad,  80,  64, w0,  w9,  w30);
      TEST_3RF("fexp2.d", datad,  80,  80, w22, w4,  w24);
      TEST_3RF("fexp2.d", datad,  80,  96, w4,  w23, w2);
      TEST_3RF("fexp2.d", datad,  80, 112, w28, w6,  w3);
      TEST_3RF("fexp2.d", datad,  80, 128, w10, w13, w21);
      TEST_3RF("fexp2.d", datad,  80, 144, w22, w1,  w0);
      TEST_3RF("fexp2.d", datad,  96,   0, w9,  w27, w24);
      TEST_3RF("fexp2.d", datad,  96,  16, w10, w2,  w12);
      TEST_3RF("fexp2.d", datad,  96,  32, w6,  w11, w19);
      TEST_3RF("fexp2.d", datad,  96,  48, w7,  w20, w7);
      TEST_3RF("fexp2.d", datad,  96,  64, w20, w5,  w10);
      TEST_3RF("fexp2.d", datad,  96,  80, w24, w29, w14);
      TEST_3RF("fexp2.d", datad,  96,  96, w15, w31, w10);
      TEST_3RF("fexp2.d", datad,  96, 112, w21, w2,  w20);
      TEST_3RF("fexp2.d", datad,  96, 128, w3,  w13, w10);
      TEST_3RF("fexp2.d", datad,  96, 144, w25, w14, w0);
      TEST_3RF("fexp2.d", datad, 112,   0, w27, w14, w9);
      TEST_3RF("fexp2.d", datad, 112,  16, w22, w6,  w19);
      TEST_3RF("fexp2.d", datad, 112,  32, w25, w19, w26);
      TEST_3RF("fexp2.d", datad, 112,  48, w4,  w6,  w1);
      TEST_3RF("fexp2.d", datad, 112,  64, w24, w26, w6);
      TEST_3RF("fexp2.d", datad, 112,  80, w2,  w18, w3);
      TEST_3RF("fexp2.d", datad, 112,  96, w17, w2,  w27);
      TEST_3RF("fexp2.d", datad, 112, 112, w23, w5,  w16);
      TEST_3RF("fexp2.d", datad, 112, 128, w26, w18, w20);
      TEST_3RF("fexp2.d", datad, 112, 144, w0,  w26, w15);
      TEST_3RF("fexp2.d", datad, 128,   0, w14, w3,  w5);
      TEST_3RF("fexp2.d", datad, 128,  16, w21, w22, w30);
      TEST_3RF("fexp2.d", datad, 128,  32, w8,  w16, w2);
      TEST_3RF("fexp2.d", datad, 128,  48, w14, w17, w26);
      TEST_3RF("fexp2.d", datad, 128,  64, w9,  w23, w29);
      TEST_3RF("fexp2.d", datad, 128,  80, w27, w26, w14);
      TEST_3RF("fexp2.d", datad, 128,  96, w29, w9,  w21);
      TEST_3RF("fexp2.d", datad, 128, 112, w2,  w25, w15);
      TEST_3RF("fexp2.d", datad, 128, 128, w20, w19, w3);
      TEST_3RF("fexp2.d", datad, 128, 144, w20, w13, w18);
      TEST_3RF("fexp2.d", datad, 144,   0, w2,  w16, w24);
      TEST_3RF("fexp2.d", datad, 144,  16, w23, w7,  w22);
      TEST_3RF("fexp2.d", datad, 144,  32, w31, w23, w25);
      TEST_3RF("fexp2.d", datad, 144,  48, w14, w9,  w19);
      TEST_3RF("fexp2.d", datad, 144,  64, w23, w0,  w16);
      TEST_3RF("fexp2.d", datad, 144,  80, w18, w18, w18);
      TEST_3RF("fexp2.d", datad, 144,  96, w27, w30, w16);
      TEST_3RF("fexp2.d", datad, 144, 112, w24, w8,  w5);
      TEST_3RF("fexp2.d", datad, 144, 128, w26, w1,  w20);
      TEST_3RF("fexp2.d", datad, 144, 144, w14, w21, w24);
      TEST_3RF_3("fmadd.w", dataf,   0,   0,   0, w14, w11, w18);
      TEST_3RF_3("fmadd.w", dataf,   0,   0,   8, w26, w1,  w7);
      TEST_3RF_3("fmadd.w", dataf,   0,   0,  16, w17, w31, w11);
      TEST_3RF_3("fmadd.w", dataf,   0,   0,  24, w6,  w11, w13);
      TEST_3RF_3("fmadd.w", dataf,   0,   0,  32, w7,  w24, w15);
      TEST_3RF_3("fmadd.w", dataf,   0,   0,  40, w1,  w1,  w1);
      TEST_3RF_3("fmadd.w", dataf,   0,   0,  48, w0,  w3,  w0);
      TEST_3RF_3("fmadd.w", dataf,   0,   0,  56, w24, w24, w25);
      TEST_3RF_3("fmadd.w", dataf,   0,   0,  64, w17, w26, w20);
      TEST_3RF_3("fmadd.w", dataf,   0,   0,  72, w28, w0,  w21);
      TEST_3RF_3("fmadd.w", dataf,   0,   8,   0, w29, w1,  w13);
      TEST_3RF_3("fmadd.w", dataf,   0,   8,   8, w30, w28, w27);
      TEST_3RF_3("fmadd.w", dataf,   0,   8,  16, w9,  w14, w22);
      TEST_3RF_3("fmadd.w", dataf,   0,   8,  24, w11, w21, w7);
      TEST_3RF_3("fmadd.w", dataf,   0,   8,  32, w10, w1,  w14);
      TEST_3RF_3("fmadd.w", dataf,   0,   8,  40, w21, w14, w13);
      TEST_3RF_3("fmadd.w", dataf,   0,   8,  48, w29, w22, w13);
      TEST_3RF_3("fmadd.w", dataf,   0,   8,  56, w0,  w15, w0);
      TEST_3RF_3("fmadd.w", dataf,   0,   8,  64, w7,  w17, w9);
      TEST_3RF_3("fmadd.w", dataf,   0,   8,  72, w27, w14, w14);
      TEST_3RF_3("fmadd.w", dataf,   0,  16,   0, w9,  w17, w11);
      TEST_3RF_3("fmadd.w", dataf,   0,  16,   8, w11, w30, w9);
      TEST_3RF_3("fmadd.w", dataf,   0,  16,  16, w7,  w26, w19);
      TEST_3RF_3("fmadd.w", dataf,   0,  16,  24, w22, w16, w30);
      TEST_3RF_3("fmadd.w", dataf,   0,  16,  32, w11, w23, w8);
      TEST_3RF_3("fmadd.w", dataf,   0,  16,  40, w12, w5,  w29);
      TEST_3RF_3("fmadd.w", dataf,   0,  16,  48, w26, w27, w10);
      TEST_3RF_3("fmadd.w", dataf,   0,  16,  56, w24, w24, w17);
      TEST_3RF_3("fmadd.w", dataf,   0,  16,  64, w24, w24, w0);
      TEST_3RF_3("fmadd.w", dataf,   0,  16,  72, w31, w10, w9);
      TEST_3RF_3("fmadd.w", dataf,   0,  24,   0, w26, w24, w19);
      TEST_3RF_3("fmadd.w", dataf,   0,  24,   8, w11, w3,  w30);
      TEST_3RF_3("fmadd.w", dataf,   0,  24,  16, w10, w13, w5);
      TEST_3RF_3("fmadd.w", dataf,   0,  24,  24, w4,  w0,  w27);
      TEST_3RF_3("fmadd.w", dataf,   0,  24,  32, w20, w30, w7);
      TEST_3RF_3("fmadd.w", dataf,   0,  24,  40, w11, w6,  w19);
      TEST_3RF_3("fmadd.w", dataf,   0,  24,  48, w17, w3,  w14);
      TEST_3RF_3("fmadd.w", dataf,   0,  24,  56, w12, w13, w6);
      TEST_3RF_3("fmadd.w", dataf,   0,  24,  64, w29, w5,  w30);
      TEST_3RF_3("fmadd.w", dataf,   0,  24,  72, w30, w4,  w8);
      TEST_3RF_3("fmadd.w", dataf,   0,  32,   0, w7,  w31, w0);
      TEST_3RF_3("fmadd.w", dataf,   0,  32,   8, w26, w10, w4);
      TEST_3RF_3("fmadd.w", dataf,   0,  32,  16, w24, w24, w20);
      TEST_3RF_3("fmadd.w", dataf,   0,  32,  24, w17, w30, w24);
      TEST_3RF_3("fmadd.w", dataf,   0,  32,  32, w17, w25, w12);
      TEST_3RF_3("fmadd.w", dataf,   0,  32,  40, w15, w0,  w24);
      TEST_3RF_3("fmadd.w", dataf,   0,  32,  48, w21, w20, w9);
      TEST_3RF_3("fmadd.w", dataf,   0,  32,  56, w24, w24, w2);
      TEST_3RF_3("fmadd.w", dataf,   0,  32,  64, w21, w5,  w8);
      TEST_3RF_3("fmadd.w", dataf,   0,  32,  72, w18, w11, w6);
      TEST_3RF_3("fmadd.w", dataf,   0,  40,   0, w16, w15, w24);
      TEST_3RF_3("fmadd.w", dataf,   0,  40,   8, w14, w15, w18);
      TEST_3RF_3("fmadd.w", dataf,   0,  40,  16, w25, w19, w11);
      TEST_3RF_3("fmadd.w", dataf,   0,  40,  24, w13, w4,  w9);
      TEST_3RF_3("fmadd.w", dataf,   0,  40,  32, w6,  w21, w2);
      TEST_3RF_3("fmadd.w", dataf,   0,  40,  40, w18, w4,  w3);
      TEST_3RF_3("fmadd.w", dataf,   0,  40,  48, w10, w25, w23);
      TEST_3RF_3("fmadd.w", dataf,   0,  40,  56, w19, w17, w25);
      TEST_3RF_3("fmadd.w", dataf,   0,  40,  64, w8,  w23, w1);
      TEST_3RF_3("fmadd.w", dataf,   0,  40,  72, w27, w2,  w2);
      TEST_3RF_3("fmadd.w", dataf,   0,  48,   0, w7,  w11, w17);
      TEST_3RF_3("fmadd.w", dataf,   0,  48,   8, w22, w3,  w0);
      TEST_3RF_3("fmadd.w", dataf,   0,  48,  16, w6,  w22, w25);
      TEST_3RF_3("fmadd.w", dataf,   0,  48,  24, w25, w1,  w6);
      TEST_3RF_3("fmadd.w", dataf,   0,  48,  32, w30, w10, w12);
      TEST_3RF_3("fmadd.w", dataf,   0,  48,  40, w19, w12, w31);
      TEST_3RF_3("fmadd.w", dataf,   0,  48,  48, w24, w24, w15);
      TEST_3RF_3("fmadd.w", dataf,   0,  48,  56, w9,  w17, w6);
      TEST_3RF_3("fmadd.w", dataf,   0,  48,  64, w29, w3,  w31);
      TEST_3RF_3("fmadd.w", dataf,   0,  48,  72, w5,  w26, w0);
      TEST_3RF_3("fmadd.w", dataf,   0,  56,   0, w0,  w28, w0);
      TEST_3RF_3("fmadd.w", dataf,   0,  56,   8, w8,  w12, w13);
      TEST_3RF_3("fmadd.w", dataf,   0,  56,  16, w30, w15, w13);
      TEST_3RF_3("fmadd.w", dataf,   0,  56,  24, w4,  w5,  w6);
      TEST_3RF_3("fmadd.w", dataf,   0,  56,  32, w30, w6,  w13);
      TEST_3RF_3("fmadd.w", dataf,   0,  56,  40, w28, w16, w25);
      TEST_3RF_3("fmadd.w", dataf,   0,  56,  48, w15, w29, w24);
      TEST_3RF_3("fmadd.w", dataf,   0,  56,  56, w7,  w12, w2);
      TEST_3RF_3("fmadd.w", dataf,   0,  56,  64, w25, w19, w31);
      TEST_3RF_3("fmadd.w", dataf,   0,  56,  72, w28, w18, w4);
      TEST_3RF_3("fmadd.w", dataf,   0,  64,   0, w22, w19, w5);
      TEST_3RF_3("fmadd.w", dataf,   0,  64,   8, w18, w27, w17);
      TEST_3RF_3("fmadd.w", dataf,   0,  64,  16, w31, w25, w0);
      TEST_3RF_3("fmadd.w", dataf,   0,  64,  24, w13, w30, w6);
      TEST_3RF_3("fmadd.w", dataf,   0,  64,  32, w19, w28, w12);
      TEST_3RF_3("fmadd.w", dataf,   0,  64,  40, w0,  w24, w0);
      TEST_3RF_3("fmadd.w", dataf,   0,  64,  48, w29, w26, w7);
      TEST_3RF_3("fmadd.w", dataf,   0,  64,  56, w26, w18, w15);
      TEST_3RF_3("fmadd.w", dataf,   0,  64,  64, w6,  w20, w8);
      TEST_3RF_3("fmadd.w", dataf,   0,  64,  72, w25, w19, w4);
      TEST_3RF_3("fmadd.w", dataf,   0,  72,   0, w12, w24, w26);
      TEST_3RF_3("fmadd.w", dataf,   0,  72,   8, w31, w29, w12);
      TEST_3RF_3("fmadd.w", dataf,   0,  72,  16, w26, w14, w11);
      TEST_3RF_3("fmadd.w", dataf,   0,  72,  24, w19, w14, w24);
      TEST_3RF_3("fmadd.w", dataf,   0,  72,  32, w17, w20, w12);
      TEST_3RF_3("fmadd.w", dataf,   0,  72,  40, w13, w1,  w12);
      TEST_3RF_3("fmadd.w", dataf,   0,  72,  48, w5,  w30, w6);
      TEST_3RF_3("fmadd.w", dataf,   0,  72,  56, w13, w24, w25);
      TEST_3RF_3("fmadd.w", dataf,   0,  72,  64, w28, w30, w13);
      TEST_3RF_3("fmadd.w", dataf,   0,  72,  72, w4,  w24, w1);
      TEST_3RF_3("fmadd.w", dataf,   8,   0,   0, w8,  w4,  w25);
      TEST_3RF_3("fmadd.w", dataf,   8,   0,   8, w2,  w3,  w22);
      TEST_3RF_3("fmadd.w", dataf,   8,   0,  16, w14, w29, w4);
      TEST_3RF_3("fmadd.w", dataf,   8,   0,  24, w25, w16, w18);
      TEST_3RF_3("fmadd.w", dataf,   8,   0,  32, w18, w2,  w7);
      TEST_3RF_3("fmadd.w", dataf,   8,   0,  40, w30, w15, w8);
      TEST_3RF_3("fmadd.w", dataf,   8,   0,  48, w10, w21, w6);
      TEST_3RF_3("fmadd.w", dataf,   8,   0,  56, w17, w2,  w30);
      TEST_3RF_3("fmadd.w", dataf,   8,   0,  64, w10, w30, w28);
      TEST_3RF_3("fmadd.w", dataf,   8,   0,  72, w23, w2,  w20);
      TEST_3RF_3("fmadd.w", dataf,   8,   8,   0, w24, w24, w10);
      TEST_3RF_3("fmadd.w", dataf,   8,   8,   8, w24, w24, w17);
      TEST_3RF_3("fmadd.w", dataf,   8,   8,  16, w12, w27, w7);
      TEST_3RF_3("fmadd.w", dataf,   8,   8,  24, w26, w24, w11);
      TEST_3RF_3("fmadd.w", dataf,   8,   8,  32, w19, w9,  w30);
      TEST_3RF_3("fmadd.w", dataf,   8,   8,  40, w5,  w11, w3);
      TEST_3RF_3("fmadd.w", dataf,   8,   8,  48, w26, w13, w14);
      TEST_3RF_3("fmadd.w", dataf,   8,   8,  56, w15, w19, w31);
      TEST_3RF_3("fmadd.w", dataf,   8,   8,  64, w17, w9,  w15);
      TEST_3RF_3("fmadd.w", dataf,   8,   8,  72, w13, w0,  w17);
      TEST_3RF_3("fmadd.w", dataf,   8,  16,   0, w2,  w25, w27);
      TEST_3RF_3("fmadd.w", dataf,   8,  16,   8, w26, w10, w7);
      TEST_3RF_3("fmadd.w", dataf,   8,  16,  16, w22, w18, w1);
      TEST_3RF_3("fmadd.w", dataf,   8,  16,  24, w14, w29, w21);
      TEST_3RF_3("fmadd.w", dataf,   8,  16,  32, w23, w27, w26);
      TEST_3RF_3("fmadd.w", dataf,   8,  16,  40, w2,  w0,  w30);
      TEST_3RF_3("fmadd.w", dataf,   8,  16,  48, w29, w13, w12);
      TEST_3RF_3("fmadd.w", dataf,   8,  16,  56, w12, w0,  w11);
      TEST_3RF_3("fmadd.w", dataf,   8,  16,  64, w30, w17, w20);
      TEST_3RF_3("fmadd.w", dataf,   8,  16,  72, w13, w31, w20);
      TEST_3RF_3("fmadd.w", dataf,   8,  24,   0, w31, w1,  w13);
      TEST_3RF_3("fmadd.w", dataf,   8,  24,   8, w26, w27, w24);
      TEST_3RF_3("fmadd.w", dataf,   8,  24,  16, w2,  w17, w10);
      TEST_3RF_3("fmadd.w", dataf,   8,  24,  24, w3,  w0,  w7);
      TEST_3RF_3("fmadd.w", dataf,   8,  24,  32, w24, w24, w23);
      TEST_3RF_3("fmadd.w", dataf,   8,  24,  40, w3,  w19, w26);
      TEST_3RF_3("fmadd.w", dataf,   8,  24,  48, w3,  w17, w23);
      TEST_3RF_3("fmadd.w", dataf,   8,  24,  56, w17, w29, w3);
      TEST_3RF_3("fmadd.w", dataf,   8,  24,  64, w17, w8,  w1);
      TEST_3RF_3("fmadd.w", dataf,   8,  24,  72, w3,  w28, w15);
      TEST_3RF_3("fmadd.w", dataf,   8,  32,   0, w2,  w16, w14);
      TEST_3RF_3("fmadd.w", dataf,   8,  32,   8, w3,  w30, w8);
      TEST_3RF_3("fmadd.w", dataf,   8,  32,  16, w30, w22, w10);
      TEST_3RF_3("fmadd.w", dataf,   8,  32,  24, w16, w0,  w14);
      TEST_3RF_3("fmadd.w", dataf,   8,  32,  32, w16, w7,  w6);
      TEST_3RF_3("fmadd.w", dataf,   8,  32,  40, w7,  w10, w25);
      TEST_3RF_3("fmadd.w", dataf,   8,  32,  48, w1,  w1,  w1);
      TEST_3RF_3("fmadd.w", dataf,   8,  32,  56, w14, w10, w24);
      TEST_3RF_3("fmadd.w", dataf,   8,  32,  64, w31, w7,  w28);
      TEST_3RF_3("fmadd.w", dataf,   8,  32,  72, w16, w15, w29);
      TEST_3RF_3("fmadd.w", dataf,   8,  40,   0, w19, w11, w12);
      TEST_3RF_3("fmadd.w", dataf,   8,  40,   8, w21, w28, w26);
      TEST_3RF_3("fmadd.w", dataf,   8,  40,  16, w24, w24, w26);
      TEST_3RF_3("fmadd.w", dataf,   8,  40,  24, w3,  w23, w16);
      TEST_3RF_3("fmadd.w", dataf,   8,  40,  32, w13, w7,  w16);
      TEST_3RF_3("fmadd.w", dataf,   8,  40,  40, w27, w23, w23);
      TEST_3RF_3("fmadd.w", dataf,   8,  40,  48, w23, w2,  w30);
      TEST_3RF_3("fmadd.w", dataf,   8,  40,  56, w2,  w27, w0);
      TEST_3RF_3("fmadd.w", dataf,   8,  40,  64, w16, w6,  w24);
      TEST_3RF_3("fmadd.w", dataf,   8,  40,  72, w15, w13, w20);
      TEST_3RF_3("fmadd.w", dataf,   8,  48,   0, w31, w29, w18);
      TEST_3RF_3("fmadd.w", dataf,   8,  48,   8, w19, w8,  w30);
      TEST_3RF_3("fmadd.w", dataf,   8,  48,  16, w8,  w4,  w25);
      TEST_3RF_3("fmadd.w", dataf,   8,  48,  24, w1,  w1,  w1);
      TEST_3RF_3("fmadd.w", dataf,   8,  48,  32, w30, w28, w24);
      TEST_3RF_3("fmadd.w", dataf,   8,  48,  40, w14, w9,  w31);
      TEST_3RF_3("fmadd.w", dataf,   8,  48,  48, w30, w5,  w22);
      TEST_3RF_3("fmadd.w", dataf,   8,  48,  56, w22, w7,  w20);
      TEST_3RF_3("fmadd.w", dataf,   8,  48,  64, w24, w24, w2);
      TEST_3RF_3("fmadd.w", dataf,   8,  48,  72, w20, w8,  w13);
      TEST_3RF_3("fmadd.w", dataf,   8,  56,   0, w23, w22, w1);
      TEST_3RF_3("fmadd.w", dataf,   8,  56,   8, w22, w19, w9);
      TEST_3RF_3("fmadd.w", dataf,   8,  56,  16, w27, w18, w18);
      TEST_3RF_3("fmadd.w", dataf,   8,  56,  24, w18, w0,  w11);
      TEST_3RF_3("fmadd.w", dataf,   8,  56,  32, w19, w30, w7);
      TEST_3RF_3("fmadd.w", dataf,   8,  56,  40, w11, w13, w16);
      TEST_3RF_3("fmadd.w", dataf,   8,  56,  48, w10, w11, w21);
      TEST_3RF_3("fmadd.w", dataf,   8,  56,  56, w0,  w1,  w0);
      TEST_3RF_3("fmadd.w", dataf,   8,  56,  64, w28, w20, w25);
      TEST_3RF_3("fmadd.w", dataf,   8,  56,  72, w31, w9,  w1);
      TEST_3RF_3("fmadd.w", dataf,   8,  64,   0, w7,  w22, w24);
      TEST_3RF_3("fmadd.w", dataf,   8,  64,   8, w29, w23, w15);
      TEST_3RF_3("fmadd.w", dataf,   8,  64,  16, w16, w11, w24);
      TEST_3RF_3("fmadd.w", dataf,   8,  64,  24, w12, w29, w10);
      TEST_3RF_3("fmadd.w", dataf,   8,  64,  32, w12, w8,  w29);
      TEST_3RF_3("fmadd.w", dataf,   8,  64,  40, w10, w15, w8);
      TEST_3RF_3("fmadd.w", dataf,   8,  64,  48, w23, w31, w18);
      TEST_3RF_3("fmadd.w", dataf,   8,  64,  56, w3,  w21, w18);
      TEST_3RF_3("fmadd.w", dataf,   8,  64,  64, w4,  w17, w7);
      TEST_3RF_3("fmadd.w", dataf,   8,  64,  72, w30, w16, w31);
      TEST_3RF_3("fmadd.w", dataf,   8,  72,   0, w24, w24, w6);
      TEST_3RF_3("fmadd.w", dataf,   8,  72,   8, w24, w24, w21);
      TEST_3RF_3("fmadd.w", dataf,   8,  72,  16, w29, w7,  w6);
      TEST_3RF_3("fmadd.w", dataf,   8,  72,  24, w8,  w31, w18);
      TEST_3RF_3("fmadd.w", dataf,   8,  72,  32, w5,  w10, w30);
      TEST_3RF_3("fmadd.w", dataf,   8,  72,  40, w13, w7,  w8);
      TEST_3RF_3("fmadd.w", dataf,   8,  72,  48, w28, w16, w0);
      TEST_3RF_3("fmadd.w", dataf,   8,  72,  56, w28, w2,  w3);
      TEST_3RF_3("fmadd.w", dataf,   8,  72,  64, w17, w21, w7);
      TEST_3RF_3("fmadd.w", dataf,   8,  72,  72, w2,  w28, w5);
      TEST_3RF_3("fmadd.w", dataf,  16,   0,   0, w19, w12, w5);
      TEST_3RF_3("fmadd.w", dataf,  16,   0,   8, w11, w18, w29);
      TEST_3RF_3("fmadd.w", dataf,  16,   0,  16, w0,  w15, w0);
      TEST_3RF_3("fmadd.w", dataf,  16,   0,  24, w4,  w6,  w24);
      TEST_3RF_3("fmadd.w", dataf,  16,   0,  32, w3,  w24, w29);
      TEST_3RF_3("fmadd.w", dataf,  16,   0,  40, w13, w22, w11);
      TEST_3RF_3("fmadd.w", dataf,  16,   0,  48, w21, w31, w7);
      TEST_3RF_3("fmadd.w", dataf,  16,   0,  56, w5,  w31, w3);
      TEST_3RF_3("fmadd.w", dataf,  16,   0,  64, w7,  w2,  w20);
      TEST_3RF_3("fmadd.w", dataf,  16,   0,  72, w28, w9,  w23);
      TEST_3RF_3("fmadd.w", dataf,  16,   8,   0, w24, w24, w15);
      TEST_3RF_3("fmadd.w", dataf,  16,   8,   8, w10, w4,  w20);
      TEST_3RF_3("fmadd.w", dataf,  16,   8,  16, w21, w22, w17);
      TEST_3RF_3("fmadd.w", dataf,  16,   8,  24, w21, w6,  w28);
      TEST_3RF_3("fmadd.w", dataf,  16,   8,  32, w30, w24, w20);
      TEST_3RF_3("fmadd.w", dataf,  16,   8,  40, w27, w6,  w6);
      TEST_3RF_3("fmadd.w", dataf,  16,   8,  48, w11, w6,  w27);
      TEST_3RF_3("fmadd.w", dataf,  16,   8,  56, w10, w14, w0);
      TEST_3RF_3("fmadd.w", dataf,  16,   8,  64, w9,  w17, w7);
      TEST_3RF_3("fmadd.w", dataf,  16,   8,  72, w11, w6,  w4);
      TEST_3RF_3("fmadd.w", dataf,  16,  16,   0, w20, w29, w28);
      TEST_3RF_3("fmadd.w", dataf,  16,  16,   8, w3,  w7,  w1);
      TEST_3RF_3("fmadd.w", dataf,  16,  16,  16, w23, w28, w8);
      TEST_3RF_3("fmadd.w", dataf,  16,  16,  24, w17, w29, w13);
      TEST_3RF_3("fmadd.w", dataf,  16,  16,  32, w27, w22, w22);
      TEST_3RF_3("fmadd.w", dataf,  16,  16,  40, w2,  w23, w28);
      TEST_3RF_3("fmadd.w", dataf,  16,  16,  48, w13, w29, w23);
      TEST_3RF_3("fmadd.w", dataf,  16,  16,  56, w23, w11, w0);
      TEST_3RF_3("fmadd.w", dataf,  16,  16,  64, w29, w30, w11);
      TEST_3RF_3("fmadd.w", dataf,  16,  16,  72, w3,  w2,  w31);
      TEST_3RF_3("fmadd.w", dataf,  16,  24,   0, w0,  w31, w0);
      TEST_3RF_3("fmadd.w", dataf,  16,  24,   8, w3,  w7,  w0);
      TEST_3RF_3("fmadd.w", dataf,  16,  24,  16, w26, w3,  w23);
      TEST_3RF_3("fmadd.w", dataf,  16,  24,  24, w3,  w20, w21);
      TEST_3RF_3("fmadd.w", dataf,  16,  24,  32, w0,  w2,  w0);
      TEST_3RF_3("fmadd.w", dataf,  16,  24,  40, w16, w22, w4);
      TEST_3RF_3("fmadd.w", dataf,  16,  24,  48, w7,  w18, w17);
      TEST_3RF_3("fmadd.w", dataf,  16,  24,  56, w5,  w9,  w8);
      TEST_3RF_3("fmadd.w", dataf,  16,  24,  64, w16, w0,  w8);
      TEST_3RF_3("fmadd.w", dataf,  16,  24,  72, w13, w31, w19);
      TEST_3RF_3("fmadd.w", dataf,  16,  32,   0, w16, w1,  w18);
      TEST_3RF_3("fmadd.w", dataf,  16,  32,   8, w16, w0,  w21);
      TEST_3RF_3("fmadd.w", dataf,  16,  32,  16, w23, w0,  w16);
      TEST_3RF_3("fmadd.w", dataf,  16,  32,  24, w26, w24, w19);
      TEST_3RF_3("fmadd.w", dataf,  16,  32,  32, w15, w13, w19);
      TEST_3RF_3("fmadd.w", dataf,  16,  32,  40, w17, w29, w10);
      TEST_3RF_3("fmadd.w", dataf,  16,  32,  48, w21, w5,  w28);
      TEST_3RF_3("fmadd.w", dataf,  16,  32,  56, w6,  w10, w14);
      TEST_3RF_3("fmadd.w", dataf,  16,  32,  64, w26, w6,  w22);
      TEST_3RF_3("fmadd.w", dataf,  16,  32,  72, w8,  w5,  w9);
      TEST_3RF_3("fmadd.w", dataf,  16,  40,   0, w24, w24, w7);
      TEST_3RF_3("fmadd.w", dataf,  16,  40,   8, w27, w9,  w9);
      TEST_3RF_3("fmadd.w", dataf,  16,  40,  16, w7,  w17, w0);
      TEST_3RF_3("fmadd.w", dataf,  16,  40,  24, w8,  w1,  w27);
      TEST_3RF_3("fmadd.w", dataf,  16,  40,  32, w0,  w20, w0);
      TEST_3RF_3("fmadd.w", dataf,  16,  40,  40, w10, w13, w7);
      TEST_3RF_3("fmadd.w", dataf,  16,  40,  48, w27, w10, w10);
      TEST_3RF_3("fmadd.w", dataf,  16,  40,  56, w17, w16, w15);
      TEST_3RF_3("fmadd.w", dataf,  16,  40,  64, w14, w22, w25);
      TEST_3RF_3("fmadd.w", dataf,  16,  40,  72, w20, w4,  w26);
      TEST_3RF_3("fmadd.w", dataf,  16,  48,   0, w26, w28, w0);
      TEST_3RF_3("fmadd.w", dataf,  16,  48,   8, w3,  w20, w7);
      TEST_3RF_3("fmadd.w", dataf,  16,  48,  16, w30, w29, w14);
      TEST_3RF_3("fmadd.w", dataf,  16,  48,  24, w15, w30, w22);
      TEST_3RF_3("fmadd.w", dataf,  16,  48,  32, w16, w25, w22);
      TEST_3RF_3("fmadd.w", dataf,  16,  48,  40, w4,  w3,  w12);
      TEST_3RF_3("fmadd.w", dataf,  16,  48,  48, w30, w14, w29);
      TEST_3RF_3("fmadd.w", dataf,  16,  48,  56, w14, w29, w11);
      TEST_3RF_3("fmadd.w", dataf,  16,  48,  64, w4,  w23, w31);
      TEST_3RF_3("fmadd.w", dataf,  16,  48,  72, w8,  w11, w26);
      TEST_3RF_3("fmadd.w", dataf,  16,  56,   0, w2,  w7,  w26);
      TEST_3RF_3("fmadd.w", dataf,  16,  56,   8, w5,  w27, w1);
      TEST_3RF_3("fmadd.w", dataf,  16,  56,  16, w3,  w25, w15);
      TEST_3RF_3("fmadd.w", dataf,  16,  56,  24, w19, w23, w6);
      TEST_3RF_3("fmadd.w", dataf,  16,  56,  32, w3,  w16, w28);
      TEST_3RF_3("fmadd.w", dataf,  16,  56,  40, w8,  w19, w0);
      TEST_3RF_3("fmadd.w", dataf,  16,  56,  48, w20, w17, w14);
      TEST_3RF_3("fmadd.w", dataf,  16,  56,  56, w17, w31, w11);
      TEST_3RF_3("fmadd.w", dataf,  16,  56,  64, w29, w3,  w2);
      TEST_3RF_3("fmadd.w", dataf,  16,  56,  72, w28, w11, w13);
      TEST_3RF_3("fmadd.w", dataf,  16,  64,   0, w22, w13, w20);
      TEST_3RF_3("fmadd.w", dataf,  16,  64,   8, w16, w18, w17);
      TEST_3RF_3("fmadd.w", dataf,  16,  64,  16, w21, w9,  w1);
      TEST_3RF_3("fmadd.w", dataf,  16,  64,  24, w8,  w0,  w7);
      TEST_3RF_3("fmadd.w", dataf,  16,  64,  32, w12, w16, w3);
      TEST_3RF_3("fmadd.w", dataf,  16,  64,  40, w20, w3,  w8);
      TEST_3RF_3("fmadd.w", dataf,  16,  64,  48, w20, w17, w25);
      TEST_3RF_3("fmadd.w", dataf,  16,  64,  56, w19, w29, w22);
      TEST_3RF_3("fmadd.w", dataf,  16,  64,  64, w22, w31, w19);
      TEST_3RF_3("fmadd.w", dataf,  16,  64,  72, w1,  w1,  w1);
      TEST_3RF_3("fmadd.w", dataf,  16,  72,   0, w13, w9,  w14);
      TEST_3RF_3("fmadd.w", dataf,  16,  72,   8, w1,  w1,  w1);
      TEST_3RF_3("fmadd.w", dataf,  16,  72,  16, w26, w0,  w17);
      TEST_3RF_3("fmadd.w", dataf,  16,  72,  24, w11, w21, w26);
      TEST_3RF_3("fmadd.w", dataf,  16,  72,  32, w12, w30, w26);
      TEST_3RF_3("fmadd.w", dataf,  16,  72,  40, w19, w10, w23);
      TEST_3RF_3("fmadd.w", dataf,  16,  72,  48, w30, w13, w26);
      TEST_3RF_3("fmadd.w", dataf,  16,  72,  56, w6,  w1,  w12);
      TEST_3RF_3("fmadd.w", dataf,  16,  72,  64, w31, w20, w9);
      TEST_3RF_3("fmadd.w", dataf,  16,  72,  72, w22, w10, w8);
      TEST_3RF_3("fmadd.w", dataf,  24,   0,   0, w9,  w11, w21);
      TEST_3RF_3("fmadd.w", dataf,  24,   0,   8, w18, w25, w23);
      TEST_3RF_3("fmadd.w", dataf,  24,   0,  16, w12, w25, w8);
      TEST_3RF_3("fmadd.w", dataf,  24,   0,  24, w24, w24, w15);
      TEST_3RF_3("fmadd.w", dataf,  24,   0,  32, w3,  w4,  w13);
      TEST_3RF_3("fmadd.w", dataf,  24,   0,  40, w29, w24, w23);
      TEST_3RF_3("fmadd.w", dataf,  24,   0,  48, w8,  w15, w21);
      TEST_3RF_3("fmadd.w", dataf,  24,   0,  56, w21, w9,  w27);
      TEST_3RF_3("fmadd.w", dataf,  24,   0,  64, w23, w21, w26);
      TEST_3RF_3("fmadd.w", dataf,  24,   0,  72, w11, w30, w16);
      TEST_3RF_3("fmadd.w", dataf,  24,   8,   0, w22, w7,  w25);
      TEST_3RF_3("fmadd.w", dataf,  24,   8,   8, w1,  w1,  w1);
      TEST_3RF_3("fmadd.w", dataf,  24,   8,  16, w28, w12, w27);
      TEST_3RF_3("fmadd.w", dataf,  24,   8,  24, w19, w24, w20);
      TEST_3RF_3("fmadd.w", dataf,  24,   8,  32, w28, w16, w3);
      TEST_3RF_3("fmadd.w", dataf,  24,   8,  40, w31, w21, w16);
      TEST_3RF_3("fmadd.w", dataf,  24,   8,  48, w28, w13, w7);
      TEST_3RF_3("fmadd.w", dataf,  24,   8,  56, w4,  w28, w26);
      TEST_3RF_3("fmadd.w", dataf,  24,   8,  64, w5,  w23, w17);
      TEST_3RF_3("fmadd.w", dataf,  24,   8,  72, w27, w18, w18);
      TEST_3RF_3("fmadd.w", dataf,  24,  16,   0, w28, w25, w2);
      TEST_3RF_3("fmadd.w", dataf,  24,  16,   8, w18, w0,  w28);
      TEST_3RF_3("fmadd.w", dataf,  24,  16,  16, w20, w29, w8);
      TEST_3RF_3("fmadd.w", dataf,  24,  16,  24, w15, w16, w0);
      TEST_3RF_3("fmadd.w", dataf,  24,  16,  32, w3,  w12, w17);
      TEST_3RF_3("fmadd.w", dataf,  24,  16,  40, w7,  w11, w6);
      TEST_3RF_3("fmadd.w", dataf,  24,  16,  48, w23, w8,  w19);
      TEST_3RF_3("fmadd.w", dataf,  24,  16,  56, w31, w12, w15);
      TEST_3RF_3("fmadd.w", dataf,  24,  16,  64, w27, w6,  w6);
      TEST_3RF_3("fmadd.w", dataf,  24,  16,  72, w20, w19, w23);
      TEST_3RF_3("fmadd.w", dataf,  24,  24,   0, w15, w5,  w20);
      TEST_3RF_3("fmadd.w", dataf,  24,  24,   8, w9,  w7,  w6);
      TEST_3RF_3("fmadd.w", dataf,  24,  24,  16, w9,  w3,  w26);
      TEST_3RF_3("fmadd.w", dataf,  24,  24,  24, w6,  w11, w9);
      TEST_3RF_3("fmadd.w", dataf,  24,  24,  32, w23, w12, w13);
      TEST_3RF_3("fmadd.w", dataf,  24,  24,  40, w3,  w29, w20);
      TEST_3RF_3("fmadd.w", dataf,  24,  24,  48, w15, w3,  w11);
      TEST_3RF_3("fmadd.w", dataf,  24,  24,  56, w23, w22, w10);
      TEST_3RF_3("fmadd.w", dataf,  24,  24,  64, w3,  w5,  w6);
      TEST_3RF_3("fmadd.w", dataf,  24,  24,  72, w10, w25, w1);
      TEST_3RF_3("fmadd.w", dataf,  24,  32,   0, w9,  w30, w21);
      TEST_3RF_3("fmadd.w", dataf,  24,  32,   8, w18, w5,  w28);
      TEST_3RF_3("fmadd.w", dataf,  24,  32,  16, w27, w9,  w9);
      TEST_3RF_3("fmadd.w", dataf,  24,  32,  24, w22, w2,  w20);
      TEST_3RF_3("fmadd.w", dataf,  24,  32,  32, w0,  w25, w0);
      TEST_3RF_3("fmadd.w", dataf,  24,  32,  40, w0,  w13, w0);
      TEST_3RF_3("fmadd.w", dataf,  24,  32,  48, w28, w29, w1);
      TEST_3RF_3("fmadd.w", dataf,  24,  32,  56, w11, w0,  w12);
      TEST_3RF_3("fmadd.w", dataf,  24,  32,  64, w2,  w22, w23);
      TEST_3RF_3("fmadd.w", dataf,  24,  32,  72, w6,  w27, w29);
      TEST_3RF_3("fmadd.w", dataf,  24,  40,   0, w16, w21, w22);
      TEST_3RF_3("fmadd.w", dataf,  24,  40,   8, w17, w30, w20);
      TEST_3RF_3("fmadd.w", dataf,  24,  40,  16, w7,  w16, w25);
      TEST_3RF_3("fmadd.w", dataf,  24,  40,  24, w3,  w11, w2);
      TEST_3RF_3("fmadd.w", dataf,  24,  40,  32, w25, w13, w23);
      TEST_3RF_3("fmadd.w", dataf,  24,  40,  40, w25, w6,  w23);
      TEST_3RF_3("fmadd.w", dataf,  24,  40,  48, w6,  w3,  w21);
      TEST_3RF_3("fmadd.w", dataf,  24,  40,  56, w7,  w14, w21);
      TEST_3RF_3("fmadd.w", dataf,  24,  40,  64, w20, w17, w12);
      TEST_3RF_3("fmadd.w", dataf,  24,  40,  72, w11, w23, w7);
      TEST_3RF_3("fmadd.w", dataf,  24,  48,   0, w8,  w7,  w28);
      TEST_3RF_3("fmadd.w", dataf,  24,  48,   8, w30, w24, w26);
      TEST_3RF_3("fmadd.w", dataf,  24,  48,  16, w18, w31, w10);
      TEST_3RF_3("fmadd.w", dataf,  24,  48,  24, w11, w2,  w22);
      TEST_3RF_3("fmadd.w", dataf,  24,  48,  32, w14, w28, w3);
      TEST_3RF_3("fmadd.w", dataf,  24,  48,  40, w5,  w21, w10);
      TEST_3RF_3("fmadd.w", dataf,  24,  48,  48, w28, w13, w17);
      TEST_3RF_3("fmadd.w", dataf,  24,  48,  56, w3,  w27, w7);
      TEST_3RF_3("fmadd.w", dataf,  24,  48,  64, w23, w12, w19);
      TEST_3RF_3("fmadd.w", dataf,  24,  48,  72, w2,  w3,  w26);
      TEST_3RF_3("fmadd.w", dataf,  24,  56,   0, w10, w23, w8);
      TEST_3RF_3("fmadd.w", dataf,  24,  56,   8, w3,  w17, w26);
      TEST_3RF_3("fmadd.w", dataf,  24,  56,  16, w2,  w28, w6);
      TEST_3RF_3("fmadd.w", dataf,  24,  56,  24, w5,  w18, w20);
      TEST_3RF_3("fmadd.w", dataf,  24,  56,  32, w1,  w1,  w1);
      TEST_3RF_3("fmadd.w", dataf,  24,  56,  40, w21, w25, w22);
      TEST_3RF_3("fmadd.w", dataf,  24,  56,  48, w31, w21, w18);
      TEST_3RF_3("fmadd.w", dataf,  24,  56,  56, w12, w7,  w22);
      TEST_3RF_3("fmadd.w", dataf,  24,  56,  64, w8,  w14, w13);
      TEST_3RF_3("fmadd.w", dataf,  24,  56,  72, w20, w1,  w16);
      TEST_3RF_3("fmadd.w", dataf,  24,  64,   0, w24, w24, w27);
      TEST_3RF_3("fmadd.w", dataf,  24,  64,   8, w26, w2,  w18);
      TEST_3RF_3("fmadd.w", dataf,  24,  64,  16, w3,  w5,  w4);
      TEST_3RF_3("fmadd.w", dataf,  24,  64,  24, w29, w8,  w0);
      TEST_3RF_3("fmadd.w", dataf,  24,  64,  32, w3,  w13, w18);
      TEST_3RF_3("fmadd.w", dataf,  24,  64,  40, w23, w14, w7);
      TEST_3RF_3("fmadd.w", dataf,  24,  64,  48, w16, w4,  w7);
      TEST_3RF_3("fmadd.w", dataf,  24,  64,  56, w6,  w23, w19);
      TEST_3RF_3("fmadd.w", dataf,  24,  64,  64, w13, w27, w26);
      TEST_3RF_3("fmadd.w", dataf,  24,  64,  72, w16, w28, w10);
      TEST_3RF_3("fmadd.w", dataf,  24,  72,   0, w8,  w23, w5);
      TEST_3RF_3("fmadd.w", dataf,  24,  72,   8, w10, w8,  w16);
      TEST_3RF_3("fmadd.w", dataf,  24,  72,  16, w14, w5,  w24);
      TEST_3RF_3("fmadd.w", dataf,  24,  72,  24, w14, w9,  w5);
      TEST_3RF_3("fmadd.w", dataf,  24,  72,  32, w0,  w19, w0);
      TEST_3RF_3("fmadd.w", dataf,  24,  72,  40, w7,  w17, w23);
      TEST_3RF_3("fmadd.w", dataf,  24,  72,  48, w14, w23, w2);
      TEST_3RF_3("fmadd.w", dataf,  24,  72,  56, w4,  w27, w29);
      TEST_3RF_3("fmadd.w", dataf,  24,  72,  64, w31, w22, w13);
      TEST_3RF_3("fmadd.w", dataf,  24,  72,  72, w27, w0,  w0);
      TEST_3RF_3("fmadd.w", dataf,  32,   0,   0, w21, w18, w5);
      TEST_3RF_3("fmadd.w", dataf,  32,   0,   8, w0,  w28, w0);
      TEST_3RF_3("fmadd.w", dataf,  32,   0,  16, w13, w16, w10);
      TEST_3RF_3("fmadd.w", dataf,  32,   0,  24, w19, w8,  w24);
      TEST_3RF_3("fmadd.w", dataf,  32,   0,  32, w28, w13, w24);
      TEST_3RF_3("fmadd.w", dataf,  32,   0,  40, w28, w0,  w13);
      TEST_3RF_3("fmadd.w", dataf,  32,   0,  48, w23, w14, w4);
      TEST_3RF_3("fmadd.w", dataf,  32,   0,  56, w6,  w16, w8);
      TEST_3RF_3("fmadd.w", dataf,  32,   0,  64, w1,  w1,  w1);
      TEST_3RF_3("fmadd.w", dataf,  32,   0,  72, w14, w7,  w23);
      TEST_3RF_3("fmadd.w", dataf,  32,   8,   0, w27, w2,  w2);
      TEST_3RF_3("fmadd.w", dataf,  32,   8,   8, w24, w24, w17);
      TEST_3RF_3("fmadd.w", dataf,  32,   8,  16, w21, w29, w17);
      TEST_3RF_3("fmadd.w", dataf,  32,   8,  24, w17, w11, w1);
      TEST_3RF_3("fmadd.w", dataf,  32,   8,  32, w28, w30, w9);
      TEST_3RF_3("fmadd.w", dataf,  32,   8,  40, w20, w26, w22);
      TEST_3RF_3("fmadd.w", dataf,  32,   8,  48, w13, w22, w4);
      TEST_3RF_3("fmadd.w", dataf,  32,   8,  56, w13, w27, w8);
      TEST_3RF_3("fmadd.w", dataf,  32,   8,  64, w19, w12, w17);
      TEST_3RF_3("fmadd.w", dataf,  32,   8,  72, w21, w26, w24);
      TEST_3RF_3("fmadd.w", dataf,  32,  16,   0, w12, w21, w27);
      TEST_3RF_3("fmadd.w", dataf,  32,  16,   8, w4,  w6,  w16);
      TEST_3RF_3("fmadd.w", dataf,  32,  16,  16, w2,  w23, w1);
      TEST_3RF_3("fmadd.w", dataf,  32,  16,  24, w13, w24, w29);
      TEST_3RF_3("fmadd.w", dataf,  32,  16,  32, w11, w1,  w18);
      TEST_3RF_3("fmadd.w", dataf,  32,  16,  40, w5,  w23, w31);
      TEST_3RF_3("fmadd.w", dataf,  32,  16,  48, w27, w13, w13);
      TEST_3RF_3("fmadd.w", dataf,  32,  16,  56, w12, w31, w27);
      TEST_3RF_3("fmadd.w", dataf,  32,  16,  64, w7,  w8,  w14);
      TEST_3RF_3("fmadd.w", dataf,  32,  16,  72, w19, w25, w3);
      TEST_3RF_3("fmadd.w", dataf,  32,  24,   0, w13, w17, w16);
      TEST_3RF_3("fmadd.w", dataf,  32,  24,   8, w3,  w12, w20);
      TEST_3RF_3("fmadd.w", dataf,  32,  24,  16, w9,  w28, w22);
      TEST_3RF_3("fmadd.w", dataf,  32,  24,  24, w1,  w1,  w1);
      TEST_3RF_3("fmadd.w", dataf,  32,  24,  32, w30, w3,  w25);
      TEST_3RF_3("fmadd.w", dataf,  32,  24,  40, w27, w14, w14);
      TEST_3RF_3("fmadd.w", dataf,  32,  24,  48, w27, w13, w13);
      TEST_3RF_3("fmadd.w", dataf,  32,  24,  56, w19, w18, w12);
      TEST_3RF_3("fmadd.w", dataf,  32,  24,  64, w15, w0,  w24);
      TEST_3RF_3("fmadd.w", dataf,  32,  24,  72, w14, w27, w0);
      TEST_3RF_3("fmadd.w", dataf,  32,  32,   0, w22, w9,  w19);
      TEST_3RF_3("fmadd.w", dataf,  32,  32,   8, w15, w13, w1);
      TEST_3RF_3("fmadd.w", dataf,  32,  32,  16, w1,  w1,  w1);
      TEST_3RF_3("fmadd.w", dataf,  32,  32,  24, w29, w4,  w13);
      TEST_3RF_3("fmadd.w", dataf,  32,  32,  32, w17, w13, w10);
      TEST_3RF_3("fmadd.w", dataf,  32,  32,  40, w8,  w14, w11);
      TEST_3RF_3("fmadd.w", dataf,  32,  32,  48, w8,  w3,  w26);
      TEST_3RF_3("fmadd.w", dataf,  32,  32,  56, w3,  w17, w13);
      TEST_3RF_3("fmadd.w", dataf,  32,  32,  64, w21, w29, w28);
      TEST_3RF_3("fmadd.w", dataf,  32,  32,  72, w21, w22, w11);
      TEST_3RF_3("fmadd.w", dataf,  32,  40,   0, w16, w22, w1);
      TEST_3RF_3("fmadd.w", dataf,  32,  40,   8, w26, w9,  w17);
      TEST_3RF_3("fmadd.w", dataf,  32,  40,  16, w7,  w10, w18);
      TEST_3RF_3("fmadd.w", dataf,  32,  40,  24, w4,  w14, w31);
      TEST_3RF_3("fmadd.w", dataf,  32,  40,  32, w21, w28, w9);
      TEST_3RF_3("fmadd.w", dataf,  32,  40,  40, w29, w10, w17);
      TEST_3RF_3("fmadd.w", dataf,  32,  40,  48, w9,  w18, w21);
      TEST_3RF_3("fmadd.w", dataf,  32,  40,  56, w3,  w21, w6);
      TEST_3RF_3("fmadd.w", dataf,  32,  40,  64, w16, w11, w3);
      TEST_3RF_3("fmadd.w", dataf,  32,  40,  72, w13, w0,  w25);
      TEST_3RF_3("fmadd.w", dataf,  32,  48,   0, w24, w24, w17);
      TEST_3RF_3("fmadd.w", dataf,  32,  48,   8, w15, w25, w11);
      TEST_3RF_3("fmadd.w", dataf,  32,  48,  16, w25, w10, w18);
      TEST_3RF_3("fmadd.w", dataf,  32,  48,  24, w3,  w28, w22);
      TEST_3RF_3("fmadd.w", dataf,  32,  48,  32, w18, w28, w11);
      TEST_3RF_3("fmadd.w", dataf,  32,  48,  40, w14, w5,  w9);
      TEST_3RF_3("fmadd.w", dataf,  32,  48,  48, w24, w24, w23);
      TEST_3RF_3("fmadd.w", dataf,  32,  48,  56, w18, w11, w12);
      TEST_3RF_3("fmadd.w", dataf,  32,  48,  64, w21, w0,  w18);
      TEST_3RF_3("fmadd.w", dataf,  32,  48,  72, w5,  w11, w21);
      TEST_3RF_3("fmadd.w", dataf,  32,  56,   0, w18, w12, w15);
      TEST_3RF_3("fmadd.w", dataf,  32,  56,   8, w10, w29, w30);
      TEST_3RF_3("fmadd.w", dataf,  32,  56,  16, w4,  w8,  w23);
      TEST_3RF_3("fmadd.w", dataf,  32,  56,  24, w14, w26, w27);
      TEST_3RF_3("fmadd.w", dataf,  32,  56,  32, w11, w16, w13);
      TEST_3RF_3("fmadd.w", dataf,  32,  56,  40, w7,  w27, w12);
      TEST_3RF_3("fmadd.w", dataf,  32,  56,  48, w4,  w19, w3);
      TEST_3RF_3("fmadd.w", dataf,  32,  56,  56, w22, w30, w15);
      TEST_3RF_3("fmadd.w", dataf,  32,  56,  64, w11, w31, w1);
      TEST_3RF_3("fmadd.w", dataf,  32,  56,  72, w17, w10, w23);
      TEST_3RF_3("fmadd.w", dataf,  32,  64,   0, w3,  w22, w6);
      TEST_3RF_3("fmadd.w", dataf,  32,  64,   8, w14, w19, w4);
      TEST_3RF_3("fmadd.w", dataf,  32,  64,  16, w18, w27, w28);
      TEST_3RF_3("fmadd.w", dataf,  32,  64,  24, w0,  w21, w0);
      TEST_3RF_3("fmadd.w", dataf,  32,  64,  32, w23, w11, w5);
      TEST_3RF_3("fmadd.w", dataf,  32,  64,  40, w4,  w18, w1);
      TEST_3RF_3("fmadd.w", dataf,  32,  64,  48, w31, w5,  w18);
      TEST_3RF_3("fmadd.w", dataf,  32,  64,  56, w2,  w28, w17);
      TEST_3RF_3("fmadd.w", dataf,  32,  64,  64, w18, w7,  w16);
      TEST_3RF_3("fmadd.w", dataf,  32,  64,  72, w19, w24, w26);
      TEST_3RF_3("fmadd.w", dataf,  32,  72,   0, w10, w28, w17);
      TEST_3RF_3("fmadd.w", dataf,  32,  72,   8, w16, w10, w4);
      TEST_3RF_3("fmadd.w", dataf,  32,  72,  16, w21, w28, w0);
      TEST_3RF_3("fmadd.w", dataf,  32,  72,  24, w17, w28, w21);
      TEST_3RF_3("fmadd.w", dataf,  32,  72,  32, w8,  w27, w12);
      TEST_3RF_3("fmadd.w", dataf,  32,  72,  40, w26, w28, w11);
      TEST_3RF_3("fmadd.w", dataf,  32,  72,  48, w25, w1,  w29);
      TEST_3RF_3("fmadd.w", dataf,  32,  72,  56, w28, w29, w14);
      TEST_3RF_3("fmadd.w", dataf,  32,  72,  64, w14, w5,  w30);
      TEST_3RF_3("fmadd.w", dataf,  32,  72,  72, w1,  w1,  w1);
      TEST_3RF_3("fmadd.w", dataf,  40,   0,   0, w29, w25, w12);
      TEST_3RF_3("fmadd.w", dataf,  40,   0,   8, w25, w10, w28);
      TEST_3RF_3("fmadd.w", dataf,  40,   0,  16, w3,  w14, w17);
      TEST_3RF_3("fmadd.w", dataf,  40,   0,  24, w31, w14, w2);
      TEST_3RF_3("fmadd.w", dataf,  40,   0,  32, w28, w4,  w10);
      TEST_3RF_3("fmadd.w", dataf,  40,   0,  40, w4,  w31, w22);
      TEST_3RF_3("fmadd.w", dataf,  40,   0,  48, w30, w27, w1);
      TEST_3RF_3("fmadd.w", dataf,  40,   0,  56, w24, w24, w28);
      TEST_3RF_3("fmadd.w", dataf,  40,   0,  64, w31, w20, w26);
      TEST_3RF_3("fmadd.w", dataf,  40,   0,  72, w13, w2,  w31);
      TEST_3RF_3("fmadd.w", dataf,  40,   8,   0, w12, w3,  w28);
      TEST_3RF_3("fmadd.w", dataf,  40,   8,   8, w5,  w15, w22);
      TEST_3RF_3("fmadd.w", dataf,  40,   8,  16, w15, w12, w25);
      TEST_3RF_3("fmadd.w", dataf,  40,   8,  24, w29, w25, w12);
      TEST_3RF_3("fmadd.w", dataf,  40,   8,  32, w0,  w21, w0);
      TEST_3RF_3("fmadd.w", dataf,  40,   8,  40, w16, w10, w25);
      TEST_3RF_3("fmadd.w", dataf,  40,   8,  48, w15, w1,  w23);
      TEST_3RF_3("fmadd.w", dataf,  40,   8,  56, w10, w2,  w15);
      TEST_3RF_3("fmadd.w", dataf,  40,   8,  64, w6,  w1,  w3);
      TEST_3RF_3("fmadd.w", dataf,  40,   8,  72, w0,  w15, w0);
      TEST_3RF_3("fmadd.w", dataf,  40,  16,   0, w5,  w31, w27);
      TEST_3RF_3("fmadd.w", dataf,  40,  16,   8, w9,  w28, w0);
      TEST_3RF_3("fmadd.w", dataf,  40,  16,  16, w24, w24, w18);
      TEST_3RF_3("fmadd.w", dataf,  40,  16,  24, w15, w4,  w11);
      TEST_3RF_3("fmadd.w", dataf,  40,  16,  32, w12, w2,  w4);
      TEST_3RF_3("fmadd.w", dataf,  40,  16,  40, w24, w24, w2);
      TEST_3RF_3("fmadd.w", dataf,  40,  16,  48, w25, w8,  w12);
      TEST_3RF_3("fmadd.w", dataf,  40,  16,  56, w18, w23, w13);
      TEST_3RF_3("fmadd.w", dataf,  40,  16,  64, w10, w1,  w16);
      TEST_3RF_3("fmadd.w", dataf,  40,  16,  72, w25, w8,  w17);
      TEST_3RF_3("fmadd.w", dataf,  40,  24,   0, w29, w8,  w0);
      TEST_3RF_3("fmadd.w", dataf,  40,  24,   8, w2,  w8,  w27);
      TEST_3RF_3("fmadd.w", dataf,  40,  24,  16, w11, w4,  w27);
      TEST_3RF_3("fmadd.w", dataf,  40,  24,  24, w4,  w22, w10);
      TEST_3RF_3("fmadd.w", dataf,  40,  24,  32, w8,  w1,  w23);
      TEST_3RF_3("fmadd.w", dataf,  40,  24,  40, w10, w6,  w15);
      TEST_3RF_3("fmadd.w", dataf,  40,  24,  48, w12, w31, w24);
      TEST_3RF_3("fmadd.w", dataf,  40,  24,  56, w25, w18, w15);
      TEST_3RF_3("fmadd.w", dataf,  40,  24,  64, w6,  w28, w17);
      TEST_3RF_3("fmadd.w", dataf,  40,  24,  72, w22, w21, w25);
      TEST_3RF_3("fmadd.w", dataf,  40,  32,   0, w8,  w18, w1);
      TEST_3RF_3("fmadd.w", dataf,  40,  32,   8, w8,  w21, w9);
      TEST_3RF_3("fmadd.w", dataf,  40,  32,  16, w4,  w0,  w13);
      TEST_3RF_3("fmadd.w", dataf,  40,  32,  24, w31, w4,  w3);
      TEST_3RF_3("fmadd.w", dataf,  40,  32,  32, w10, w13, w5);
      TEST_3RF_3("fmadd.w", dataf,  40,  32,  40, w1,  w1,  w1);
      TEST_3RF_3("fmadd.w", dataf,  40,  32,  48, w23, w11, w16);
      TEST_3RF_3("fmadd.w", dataf,  40,  32,  56, w4,  w10, w8);
      TEST_3RF_3("fmadd.w", dataf,  40,  32,  64, w29, w28, w24);
      TEST_3RF_3("fmadd.w", dataf,  40,  32,  72, w3,  w24, w9);
      TEST_3RF_3("fmadd.w", dataf,  40,  40,   0, w26, w14, w2);
      TEST_3RF_3("fmadd.w", dataf,  40,  40,   8, w2,  w0,  w3);
      TEST_3RF_3("fmadd.w", dataf,  40,  40,  16, w10, w21, w13);
      TEST_3RF_3("fmadd.w", dataf,  40,  40,  24, w14, w22, w26);
      TEST_3RF_3("fmadd.w", dataf,  40,  40,  32, w14, w26, w30);
      TEST_3RF_3("fmadd.w", dataf,  40,  40,  40, w24, w24, w7);
      TEST_3RF_3("fmadd.w", dataf,  40,  40,  48, w3,  w25, w31);
      TEST_3RF_3("fmadd.w", dataf,  40,  40,  56, w14, w9,  w3);
      TEST_3RF_3("fmadd.w", dataf,  40,  40,  64, w24, w24, w18);
      TEST_3RF_3("fmadd.w", dataf,  40,  40,  72, w0,  w21, w0);
      TEST_3RF_3("fmadd.w", dataf,  40,  48,   0, w10, w3,  w13);
      TEST_3RF_3("fmadd.w", dataf,  40,  48,   8, w19, w29, w27);
      TEST_3RF_3("fmadd.w", dataf,  40,  48,  16, w21, w31, w28);
      TEST_3RF_3("fmadd.w", dataf,  40,  48,  24, w24, w24, w10);
      TEST_3RF_3("fmadd.w", dataf,  40,  48,  32, w17, w5,  w24);
      TEST_3RF_3("fmadd.w", dataf,  40,  48,  40, w7,  w0,  w6);
      TEST_3RF_3("fmadd.w", dataf,  40,  48,  48, w2,  w30, w9);
      TEST_3RF_3("fmadd.w", dataf,  40,  48,  56, w1,  w1,  w1);
      TEST_3RF_3("fmadd.w", dataf,  40,  48,  64, w23, w8,  w15);
      TEST_3RF_3("fmadd.w", dataf,  40,  48,  72, w1,  w1,  w1);
      TEST_3RF_3("fmadd.w", dataf,  40,  56,   0, w11, w7,  w19);
      TEST_3RF_3("fmadd.w", dataf,  40,  56,   8, w11, w28, w29);
      TEST_3RF_3("fmadd.w", dataf,  40,  56,  16, w15, w10, w16);
      TEST_3RF_3("fmadd.w", dataf,  40,  56,  24, w12, w5,  w1);
      TEST_3RF_3("fmadd.w", dataf,  40,  56,  32, w29, w22, w19);
      TEST_3RF_3("fmadd.w", dataf,  40,  56,  40, w3,  w14, w26);
      TEST_3RF_3("fmadd.w", dataf,  40,  56,  48, w3,  w21, w28);
      TEST_3RF_3("fmadd.w", dataf,  40,  56,  56, w1,  w1,  w1);
      TEST_3RF_3("fmadd.w", dataf,  40,  56,  64, w19, w6,  w2);
      TEST_3RF_3("fmadd.w", dataf,  40,  56,  72, w11, w14, w17);
      TEST_3RF_3("fmadd.w", dataf,  40,  64,   0, w12, w26, w24);
      TEST_3RF_3("fmadd.w", dataf,  40,  64,   8, w31, w5,  w21);
      TEST_3RF_3("fmadd.w", dataf,  40,  64,  16, w28, w20, w31);
      TEST_3RF_3("fmadd.w", dataf,  40,  64,  24, w12, w1,  w4);
      TEST_3RF_3("fmadd.w", dataf,  40,  64,  32, w17, w13, w6);
      TEST_3RF_3("fmadd.w", dataf,  40,  64,  40, w14, w3,  w25);
      TEST_3RF_3("fmadd.w", dataf,  40,  64,  48, w17, w19, w20);
      TEST_3RF_3("fmadd.w", dataf,  40,  64,  56, w6,  w16, w21);
      TEST_3RF_3("fmadd.w", dataf,  40,  64,  64, w26, w22, w23);
      TEST_3RF_3("fmadd.w", dataf,  40,  64,  72, w5,  w4,  w8);
      TEST_3RF_3("fmadd.w", dataf,  40,  72,   0, w17, w30, w1);
      TEST_3RF_3("fmadd.w", dataf,  40,  72,   8, w16, w4,  w22);
      TEST_3RF_3("fmadd.w", dataf,  40,  72,  16, w12, w24, w21);
      TEST_3RF_3("fmadd.w", dataf,  40,  72,  24, w24, w24, w25);
      TEST_3RF_3("fmadd.w", dataf,  40,  72,  32, w25, w9,  w6);
      TEST_3RF_3("fmadd.w", dataf,  40,  72,  40, w31, w23, w9);
      TEST_3RF_3("fmadd.w", dataf,  40,  72,  48, w24, w24, w9);
      TEST_3RF_3("fmadd.w", dataf,  40,  72,  56, w27, w12, w12);
      TEST_3RF_3("fmadd.w", dataf,  40,  72,  64, w29, w1,  w28);
      TEST_3RF_3("fmadd.w", dataf,  40,  72,  72, w19, w27, w18);
      TEST_3RF_3("fmadd.w", dataf,  48,   0,   0, w10, w0,  w22);
      TEST_3RF_3("fmadd.w", dataf,  48,   0,   8, w19, w17, w21);
      TEST_3RF_3("fmadd.w", dataf,  48,   0,  16, w20, w1,  w25);
      TEST_3RF_3("fmadd.w", dataf,  48,   0,  24, w10, w13, w17);
      TEST_3RF_3("fmadd.w", dataf,  48,   0,  32, w31, w5,  w11);
      TEST_3RF_3("fmadd.w", dataf,  48,   0,  40, w24, w24, w14);
      TEST_3RF_3("fmadd.w", dataf,  48,   0,  48, w17, w24, w6);
      TEST_3RF_3("fmadd.w", dataf,  48,   0,  56, w27, w16, w16);
      TEST_3RF_3("fmadd.w", dataf,  48,   0,  64, w15, w22, w28);
      TEST_3RF_3("fmadd.w", dataf,  48,   0,  72, w12, w23, w24);
      TEST_3RF_3("fmadd.w", dataf,  48,   8,   0, w31, w19, w10);
      TEST_3RF_3("fmadd.w", dataf,  48,   8,   8, w10, w19, w1);
      TEST_3RF_3("fmadd.w", dataf,  48,   8,  16, w29, w5,  w22);
      TEST_3RF_3("fmadd.w", dataf,  48,   8,  24, w17, w6,  w15);
      TEST_3RF_3("fmadd.w", dataf,  48,   8,  32, w27, w20, w20);
      TEST_3RF_3("fmadd.w", dataf,  48,   8,  40, w0,  w26, w0);
      TEST_3RF_3("fmadd.w", dataf,  48,   8,  48, w25, w11, w18);
      TEST_3RF_3("fmadd.w", dataf,  48,   8,  56, w8,  w29, w10);
      TEST_3RF_3("fmadd.w", dataf,  48,   8,  64, w14, w24, w27);
      TEST_3RF_3("fmadd.w", dataf,  48,   8,  72, w29, w14, w23);
      TEST_3RF_3("fmadd.w", dataf,  48,  16,   0, w9,  w5,  w16);
      TEST_3RF_3("fmadd.w", dataf,  48,  16,   8, w9,  w24, w26);
      TEST_3RF_3("fmadd.w", dataf,  48,  16,  16, w19, w12, w27);
      TEST_3RF_3("fmadd.w", dataf,  48,  16,  24, w16, w17, w1);
      TEST_3RF_3("fmadd.w", dataf,  48,  16,  32, w23, w0,  w28);
      TEST_3RF_3("fmadd.w", dataf,  48,  16,  40, w11, w1,  w22);
      TEST_3RF_3("fmadd.w", dataf,  48,  16,  48, w5,  w12, w8);
      TEST_3RF_3("fmadd.w", dataf,  48,  16,  56, w13, w9,  w19);
      TEST_3RF_3("fmadd.w", dataf,  48,  16,  64, w27, w1,  w1);
      TEST_3RF_3("fmadd.w", dataf,  48,  16,  72, w14, w24, w15);
      TEST_3RF_3("fmadd.w", dataf,  48,  24,   0, w5,  w1,  w21);
      TEST_3RF_3("fmadd.w", dataf,  48,  24,   8, w21, w10, w13);
      TEST_3RF_3("fmadd.w", dataf,  48,  24,  16, w16, w29, w25);
      TEST_3RF_3("fmadd.w", dataf,  48,  24,  24, w11, w13, w10);
      TEST_3RF_3("fmadd.w", dataf,  48,  24,  32, w29, w14, w2);
      TEST_3RF_3("fmadd.w", dataf,  48,  24,  40, w29, w10, w13);
      TEST_3RF_3("fmadd.w", dataf,  48,  24,  48, w30, w0,  w18);
      TEST_3RF_3("fmadd.w", dataf,  48,  24,  56, w11, w9,  w31);
      TEST_3RF_3("fmadd.w", dataf,  48,  24,  64, w20, w28, w26);
      TEST_3RF_3("fmadd.w", dataf,  48,  24,  72, w22, w10, w18);
      TEST_3RF_3("fmadd.w", dataf,  48,  32,   0, w5,  w15, w20);
      TEST_3RF_3("fmadd.w", dataf,  48,  32,   8, w26, w5,  w30);
      TEST_3RF_3("fmadd.w", dataf,  48,  32,  16, w8,  w21, w28);
      TEST_3RF_3("fmadd.w", dataf,  48,  32,  24, w1,  w1,  w1);
      TEST_3RF_3("fmadd.w", dataf,  48,  32,  32, w0,  w9,  w0);
      TEST_3RF_3("fmadd.w", dataf,  48,  32,  40, w12, w29, w24);
      TEST_3RF_3("fmadd.w", dataf,  48,  32,  48, w14, w27, w2);
      TEST_3RF_3("fmadd.w", dataf,  48,  32,  56, w27, w25, w25);
      TEST_3RF_3("fmadd.w", dataf,  48,  32,  64, w3,  w14, w4);
      TEST_3RF_3("fmadd.w", dataf,  48,  32,  72, w12, w13, w25);
      TEST_3RF_3("fmadd.w", dataf,  48,  40,   0, w8,  w15, w18);
      TEST_3RF_3("fmadd.w", dataf,  48,  40,   8, w26, w20, w1);
      TEST_3RF_3("fmadd.w", dataf,  48,  40,  16, w14, w15, w6);
      TEST_3RF_3("fmadd.w", dataf,  48,  40,  24, w13, w23, w27);
      TEST_3RF_3("fmadd.w", dataf,  48,  40,  32, w9,  w24, w28);
      TEST_3RF_3("fmadd.w", dataf,  48,  40,  40, w18, w4,  w25);
      TEST_3RF_3("fmadd.w", dataf,  48,  40,  48, w10, w18, w20);
      TEST_3RF_3("fmadd.w", dataf,  48,  40,  56, w13, w14, w16);
      TEST_3RF_3("fmadd.w", dataf,  48,  40,  64, w28, w18, w9);
      TEST_3RF_3("fmadd.w", dataf,  48,  40,  72, w11, w4,  w17);
      TEST_3RF_3("fmadd.w", dataf,  48,  48,   0, w26, w22, w12);
      TEST_3RF_3("fmadd.w", dataf,  48,  48,   8, w15, w23, w26);
      TEST_3RF_3("fmadd.w", dataf,  48,  48,  16, w30, w7,  w21);
      TEST_3RF_3("fmadd.w", dataf,  48,  48,  24, w25, w16, w13);
      TEST_3RF_3("fmadd.w", dataf,  48,  48,  32, w21, w3,  w18);
      TEST_3RF_3("fmadd.w", dataf,  48,  48,  40, w15, w13, w4);
      TEST_3RF_3("fmadd.w", dataf,  48,  48,  48, w3,  w26, w18);
      TEST_3RF_3("fmadd.w", dataf,  48,  48,  56, w17, w10, w14);
      TEST_3RF_3("fmadd.w", dataf,  48,  48,  64, w4,  w6,  w24);
      TEST_3RF_3("fmadd.w", dataf,  48,  48,  72, w15, w10, w9);
      TEST_3RF_3("fmadd.w", dataf,  48,  56,   0, w10, w0,  w21);
      TEST_3RF_3("fmadd.w", dataf,  48,  56,   8, w25, w24, w16);
      TEST_3RF_3("fmadd.w", dataf,  48,  56,  16, w23, w22, w12);
      TEST_3RF_3("fmadd.w", dataf,  48,  56,  24, w15, w8,  w25);
      TEST_3RF_3("fmadd.w", dataf,  48,  56,  32, w5,  w11, w20);
      TEST_3RF_3("fmadd.w", dataf,  48,  56,  40, w24, w24, w16);
      TEST_3RF_3("fmadd.w", dataf,  48,  56,  48, w23, w19, w2);
      TEST_3RF_3("fmadd.w", dataf,  48,  56,  56, w9,  w29, w17);
      TEST_3RF_3("fmadd.w", dataf,  48,  56,  64, w13, w4,  w9);
      TEST_3RF_3("fmadd.w", dataf,  48,  56,  72, w28, w14, w18);
      TEST_3RF_3("fmadd.w", dataf,  48,  64,   0, w6,  w15, w8);
      TEST_3RF_3("fmadd.w", dataf,  48,  64,   8, w31, w7,  w24);
      TEST_3RF_3("fmadd.w", dataf,  48,  64,  16, w22, w29, w15);
      TEST_3RF_3("fmadd.w", dataf,  48,  64,  24, w2,  w12, w23);
      TEST_3RF_3("fmadd.w", dataf,  48,  64,  32, w28, w17, w2);
      TEST_3RF_3("fmadd.w", dataf,  48,  64,  40, w7,  w5,  w27);
      TEST_3RF_3("fmadd.w", dataf,  48,  64,  48, w23, w29, w14);
      TEST_3RF_3("fmadd.w", dataf,  48,  64,  56, w26, w6,  w11);
      TEST_3RF_3("fmadd.w", dataf,  48,  64,  64, w11, w19, w15);
      TEST_3RF_3("fmadd.w", dataf,  48,  64,  72, w20, w15, w30);
      TEST_3RF_3("fmadd.w", dataf,  48,  72,   0, w6,  w22, w13);
      TEST_3RF_3("fmadd.w", dataf,  48,  72,   8, w14, w21, w20);
      TEST_3RF_3("fmadd.w", dataf,  48,  72,  16, w6,  w12, w17);
      TEST_3RF_3("fmadd.w", dataf,  48,  72,  24, w22, w14, w29);
      TEST_3RF_3("fmadd.w", dataf,  48,  72,  32, w13, w10, w15);
      TEST_3RF_3("fmadd.w", dataf,  48,  72,  40, w16, w18, w20);
      TEST_3RF_3("fmadd.w", dataf,  48,  72,  48, w11, w9,  w17);
      TEST_3RF_3("fmadd.w", dataf,  48,  72,  56, w25, w3,  w23);
      TEST_3RF_3("fmadd.w", dataf,  48,  72,  64, w4,  w14, w10);
      TEST_3RF_3("fmadd.w", dataf,  48,  72,  72, w20, w2,  w26);
      TEST_3RF_3("fmadd.w", dataf,  56,   0,   0, w18, w9,  w16);
      TEST_3RF_3("fmadd.w", dataf,  56,   0,   8, w31, w23, w5);
      TEST_3RF_3("fmadd.w", dataf,  56,   0,  16, w19, w30, w17);
      TEST_3RF_3("fmadd.w", dataf,  56,   0,  24, w4,  w20, w0);
      TEST_3RF_3("fmadd.w", dataf,  56,   0,  32, w1,  w1,  w1);
      TEST_3RF_3("fmadd.w", dataf,  56,   0,  40, w1,  w1,  w1);
      TEST_3RF_3("fmadd.w", dataf,  56,   0,  48, w10, w16, w17);
      TEST_3RF_3("fmadd.w", dataf,  56,   0,  56, w28, w5,  w6);
      TEST_3RF_3("fmadd.w", dataf,  56,   0,  64, w22, w21, w9);
      TEST_3RF_3("fmadd.w", dataf,  56,   0,  72, w14, w26, w24);
      TEST_3RF_3("fmadd.w", dataf,  56,   8,   0, w24, w24, w14);
      TEST_3RF_3("fmadd.w", dataf,  56,   8,   8, w26, w18, w0);
      TEST_3RF_3("fmadd.w", dataf,  56,   8,  16, w3,  w2,  w31);
      TEST_3RF_3("fmadd.w", dataf,  56,   8,  24, w27, w8,  w8);
      TEST_3RF_3("fmadd.w", dataf,  56,   8,  32, w18, w25, w22);
      TEST_3RF_3("fmadd.w", dataf,  56,   8,  40, w13, w25, w23);
      TEST_3RF_3("fmadd.w", dataf,  56,   8,  48, w14, w4,  w8);
      TEST_3RF_3("fmadd.w", dataf,  56,   8,  56, w0,  w13, w0);
      TEST_3RF_3("fmadd.w", dataf,  56,   8,  64, w28, w6,  w3);
      TEST_3RF_3("fmadd.w", dataf,  56,   8,  72, w18, w16, w17);
      TEST_3RF_3("fmadd.w", dataf,  56,  16,   0, w12, w8,  w10);
      TEST_3RF_3("fmadd.w", dataf,  56,  16,   8, w26, w2,  w28);
      TEST_3RF_3("fmadd.w", dataf,  56,  16,  16, w26, w6,  w31);
      TEST_3RF_3("fmadd.w", dataf,  56,  16,  24, w25, w1,  w7);
      TEST_3RF_3("fmadd.w", dataf,  56,  16,  32, w11, w26, w0);
      TEST_3RF_3("fmadd.w", dataf,  56,  16,  40, w1,  w1,  w1);
      TEST_3RF_3("fmadd.w", dataf,  56,  16,  48, w7,  w26, w24);
      TEST_3RF_3("fmadd.w", dataf,  56,  16,  56, w21, w30, w0);
      TEST_3RF_3("fmadd.w", dataf,  56,  16,  64, w21, w30, w13);
      TEST_3RF_3("fmadd.w", dataf,  56,  16,  72, w18, w5,  w17);
      TEST_3RF_3("fmadd.w", dataf,  56,  24,   0, w4,  w21, w2);
      TEST_3RF_3("fmadd.w", dataf,  56,  24,   8, w16, w29, w12);
      TEST_3RF_3("fmadd.w", dataf,  56,  24,  16, w10, w31, w9);
      TEST_3RF_3("fmadd.w", dataf,  56,  24,  24, w4,  w5,  w8);
      TEST_3RF_3("fmadd.w", dataf,  56,  24,  32, w29, w6,  w15);
      TEST_3RF_3("fmadd.w", dataf,  56,  24,  40, w8,  w0,  w15);
      TEST_3RF_3("fmadd.w", dataf,  56,  24,  48, w9,  w7,  w1);
      TEST_3RF_3("fmadd.w", dataf,  56,  24,  56, w29, w7,  w2);
      TEST_3RF_3("fmadd.w", dataf,  56,  24,  64, w18, w6,  w15);
      TEST_3RF_3("fmadd.w", dataf,  56,  24,  72, w4,  w11, w0);
      TEST_3RF_3("fmadd.w", dataf,  56,  32,   0, w8,  w0,  w3);
      TEST_3RF_3("fmadd.w", dataf,  56,  32,   8, w24, w24, w29);
      TEST_3RF_3("fmadd.w", dataf,  56,  32,  16, w15, w2,  w28);
      TEST_3RF_3("fmadd.w", dataf,  56,  32,  24, w24, w24, w6);
      TEST_3RF_3("fmadd.w", dataf,  56,  32,  32, w2,  w0,  w3);
      TEST_3RF_3("fmadd.w", dataf,  56,  32,  40, w8,  w15, w11);
      TEST_3RF_3("fmadd.w", dataf,  56,  32,  48, w9,  w31, w20);
      TEST_3RF_3("fmadd.w", dataf,  56,  32,  56, w16, w8,  w22);
      TEST_3RF_3("fmadd.w", dataf,  56,  32,  64, w13, w16, w24);
      TEST_3RF_3("fmadd.w", dataf,  56,  32,  72, w0,  w22, w0);
      TEST_3RF_3("fmadd.w", dataf,  56,  40,   0, w7,  w4,  w1);
      TEST_3RF_3("fmadd.w", dataf,  56,  40,   8, w8,  w13, w1);
      TEST_3RF_3("fmadd.w", dataf,  56,  40,  16, w11, w5,  w30);
      TEST_3RF_3("fmadd.w", dataf,  56,  40,  24, w26, w8,  w19);
      TEST_3RF_3("fmadd.w", dataf,  56,  40,  32, w14, w28, w19);
      TEST_3RF_3("fmadd.w", dataf,  56,  40,  40, w18, w5,  w3);
      TEST_3RF_3("fmadd.w", dataf,  56,  40,  48, w29, w14, w2);
      TEST_3RF_3("fmadd.w", dataf,  56,  40,  56, w18, w30, w10);
      TEST_3RF_3("fmadd.w", dataf,  56,  40,  64, w8,  w12, w26);
      TEST_3RF_3("fmadd.w", dataf,  56,  40,  72, w0,  w12, w0);
      TEST_3RF_3("fmadd.w", dataf,  56,  48,   0, w16, w7,  w17);
      TEST_3RF_3("fmadd.w", dataf,  56,  48,   8, w15, w29, w18);
      TEST_3RF_3("fmadd.w", dataf,  56,  48,  16, w26, w3,  w16);
      TEST_3RF_3("fmadd.w", dataf,  56,  48,  24, w21, w11, w8);
      TEST_3RF_3("fmadd.w", dataf,  56,  48,  32, w25, w7,  w27);
      TEST_3RF_3("fmadd.w", dataf,  56,  48,  40, w11, w12, w30);
      TEST_3RF_3("fmadd.w", dataf,  56,  48,  48, w9,  w26, w0);
      TEST_3RF_3("fmadd.w", dataf,  56,  48,  56, w27, w25, w25);
      TEST_3RF_3("fmadd.w", dataf,  56,  48,  64, w11, w3,  w5);
      TEST_3RF_3("fmadd.w", dataf,  56,  48,  72, w5,  w3,  w17);
      TEST_3RF_3("fmadd.w", dataf,  56,  56,   0, w22, w10, w1);
      TEST_3RF_3("fmadd.w", dataf,  56,  56,   8, w7,  w26, w31);
      TEST_3RF_3("fmadd.w", dataf,  56,  56,  16, w26, w20, w2);
      TEST_3RF_3("fmadd.w", dataf,  56,  56,  24, w10, w9,  w13);
      TEST_3RF_3("fmadd.w", dataf,  56,  56,  32, w21, w17, w6);
      TEST_3RF_3("fmadd.w", dataf,  56,  56,  40, w29, w13, w18);
      TEST_3RF_3("fmadd.w", dataf,  56,  56,  48, w9,  w11, w27);
      TEST_3RF_3("fmadd.w", dataf,  56,  56,  56, w4,  w12, w22);
      TEST_3RF_3("fmadd.w", dataf,  56,  56,  64, w29, w23, w25);
      TEST_3RF_3("fmadd.w", dataf,  56,  56,  72, w2,  w28, w19);
      TEST_3RF_3("fmadd.w", dataf,  56,  64,   0, w18, w6,  w20);
      TEST_3RF_3("fmadd.w", dataf,  56,  64,   8, w26, w0,  w19);
      TEST_3RF_3("fmadd.w", dataf,  56,  64,  16, w20, w21, w30);
      TEST_3RF_3("fmadd.w", dataf,  56,  64,  24, w30, w2,  w20);
      TEST_3RF_3("fmadd.w", dataf,  56,  64,  32, w16, w9,  w17);
      TEST_3RF_3("fmadd.w", dataf,  56,  64,  40, w29, w27, w26);
      TEST_3RF_3("fmadd.w", dataf,  56,  64,  48, w8,  w22, w30);
      TEST_3RF_3("fmadd.w", dataf,  56,  64,  56, w20, w12, w27);
      TEST_3RF_3("fmadd.w", dataf,  56,  64,  64, w11, w5,  w29);
      TEST_3RF_3("fmadd.w", dataf,  56,  64,  72, w8,  w1,  w16);
      TEST_3RF_3("fmadd.w", dataf,  56,  72,   0, w26, w7,  w5);
      TEST_3RF_3("fmadd.w", dataf,  56,  72,   8, w20, w8,  w24);
      TEST_3RF_3("fmadd.w", dataf,  56,  72,  16, w8,  w29, w14);
      TEST_3RF_3("fmadd.w", dataf,  56,  72,  24, w7,  w27, w16);
      TEST_3RF_3("fmadd.w", dataf,  56,  72,  32, w27, w11, w11);
      TEST_3RF_3("fmadd.w", dataf,  56,  72,  40, w25, w12, w8);
      TEST_3RF_3("fmadd.w", dataf,  56,  72,  48, w20, w6,  w17);
      TEST_3RF_3("fmadd.w", dataf,  56,  72,  56, w10, w5,  w22);
      TEST_3RF_3("fmadd.w", dataf,  56,  72,  64, w0,  w17, w0);
      TEST_3RF_3("fmadd.w", dataf,  56,  72,  72, w27, w30, w30);
      TEST_3RF_3("fmadd.w", dataf,  64,   0,   0, w25, w28, w14);
      TEST_3RF_3("fmadd.w", dataf,  64,   0,   8, w19, w4,  w8);
      TEST_3RF_3("fmadd.w", dataf,  64,   0,  16, w12, w16, w9);
      TEST_3RF_3("fmadd.w", dataf,  64,   0,  24, w26, w23, w4);
      TEST_3RF_3("fmadd.w", dataf,  64,   0,  32, w10, w18, w16);
      TEST_3RF_3("fmadd.w", dataf,  64,   0,  40, w4,  w30, w24);
      TEST_3RF_3("fmadd.w", dataf,  64,   0,  48, w24, w24, w5);
      TEST_3RF_3("fmadd.w", dataf,  64,   0,  56, w9,  w3,  w10);
      TEST_3RF_3("fmadd.w", dataf,  64,   0,  64, w15, w25, w10);
      TEST_3RF_3("fmadd.w", dataf,  64,   0,  72, w0,  w21, w0);
      TEST_3RF_3("fmadd.w", dataf,  64,   8,   0, w8,  w25, w17);
      TEST_3RF_3("fmadd.w", dataf,  64,   8,   8, w23, w12, w21);
      TEST_3RF_3("fmadd.w", dataf,  64,   8,  16, w10, w20, w1);
      TEST_3RF_3("fmadd.w", dataf,  64,   8,  24, w22, w5,  w10);
      TEST_3RF_3("fmadd.w", dataf,  64,   8,  32, w16, w28, w15);
      TEST_3RF_3("fmadd.w", dataf,  64,   8,  40, w27, w15, w15);
      TEST_3RF_3("fmadd.w", dataf,  64,   8,  48, w31, w13, w23);
      TEST_3RF_3("fmadd.w", dataf,  64,   8,  56, w23, w18, w1);
      TEST_3RF_3("fmadd.w", dataf,  64,   8,  64, w26, w28, w16);
      TEST_3RF_3("fmadd.w", dataf,  64,   8,  72, w20, w7,  w16);
      TEST_3RF_3("fmadd.w", dataf,  64,  16,   0, w9,  w15, w26);
      TEST_3RF_3("fmadd.w", dataf,  64,  16,   8, w6,  w21, w16);
      TEST_3RF_3("fmadd.w", dataf,  64,  16,  16, w17, w10, w7);
      TEST_3RF_3("fmadd.w", dataf,  64,  16,  24, w15, w28, w24);
      TEST_3RF_3("fmadd.w", dataf,  64,  16,  32, w11, w19, w26);
      TEST_3RF_3("fmadd.w", dataf,  64,  16,  40, w10, w18, w8);
      TEST_3RF_3("fmadd.w", dataf,  64,  16,  48, w1,  w1,  w1);
      TEST_3RF_3("fmadd.w", dataf,  64,  16,  56, w9,  w26, w2);
      TEST_3RF_3("fmadd.w", dataf,  64,  16,  64, w4,  w23, w18);
      TEST_3RF_3("fmadd.w", dataf,  64,  16,  72, w24, w24, w30);
      TEST_3RF_3("fmadd.w", dataf,  64,  24,   0, w2,  w1,  w13);
      TEST_3RF_3("fmadd.w", dataf,  64,  24,   8, w11, w27, w20);
      TEST_3RF_3("fmadd.w", dataf,  64,  24,  16, w1,  w1,  w1);
      TEST_3RF_3("fmadd.w", dataf,  64,  24,  24, w11, w5,  w29);
      TEST_3RF_3("fmadd.w", dataf,  64,  24,  32, w12, w26, w25);
      TEST_3RF_3("fmadd.w", dataf,  64,  24,  40, w4,  w5,  w23);
      TEST_3RF_3("fmadd.w", dataf,  64,  24,  48, w0,  w14, w0);
      TEST_3RF_3("fmadd.w", dataf,  64,  24,  56, w9,  w8,  w15);
      TEST_3RF_3("fmadd.w", dataf,  64,  24,  64, w19, w2,  w18);
      TEST_3RF_3("fmadd.w", dataf,  64,  24,  72, w23, w25, w4);
      TEST_3RF_3("fmadd.w", dataf,  64,  32,   0, w15, w23, w7);
      TEST_3RF_3("fmadd.w", dataf,  64,  32,   8, w16, w5,  w18);
      TEST_3RF_3("fmadd.w", dataf,  64,  32,  16, w11, w25, w19);
      TEST_3RF_3("fmadd.w", dataf,  64,  32,  24, w23, w30, w20);
      TEST_3RF_3("fmadd.w", dataf,  64,  32,  32, w10, w24, w13);
      TEST_3RF_3("fmadd.w", dataf,  64,  32,  40, w15, w30, w17);
      TEST_3RF_3("fmadd.w", dataf,  64,  32,  48, w6,  w30, w31);
      TEST_3RF_3("fmadd.w", dataf,  64,  32,  56, w16, w6,  w14);
      TEST_3RF_3("fmadd.w", dataf,  64,  32,  64, w3,  w8,  w0);
      TEST_3RF_3("fmadd.w", dataf,  64,  32,  72, w26, w2,  w5);
      TEST_3RF_3("fmadd.w", dataf,  64,  40,   0, w9,  w25, w12);
      TEST_3RF_3("fmadd.w", dataf,  64,  40,   8, w25, w30, w4);
      TEST_3RF_3("fmadd.w", dataf,  64,  40,  16, w23, w18, w27);
      TEST_3RF_3("fmadd.w", dataf,  64,  40,  24, w21, w16, w15);
      TEST_3RF_3("fmadd.w", dataf,  64,  40,  32, w0,  w9,  w0);
      TEST_3RF_3("fmadd.w", dataf,  64,  40,  40, w28, w15, w7);
      TEST_3RF_3("fmadd.w", dataf,  64,  40,  48, w13, w21, w5);
      TEST_3RF_3("fmadd.w", dataf,  64,  40,  56, w12, w5,  w11);
      TEST_3RF_3("fmadd.w", dataf,  64,  40,  64, w27, w8,  w8);
      TEST_3RF_3("fmadd.w", dataf,  64,  40,  72, w19, w27, w2);
      TEST_3RF_3("fmadd.w", dataf,  64,  48,   0, w21, w0,  w11);
      TEST_3RF_3("fmadd.w", dataf,  64,  48,   8, w15, w12, w4);
      TEST_3RF_3("fmadd.w", dataf,  64,  48,  16, w13, w11, w9);
      TEST_3RF_3("fmadd.w", dataf,  64,  48,  24, w5,  w29, w4);
      TEST_3RF_3("fmadd.w", dataf,  64,  48,  32, w26, w13, w20);
      TEST_3RF_3("fmadd.w", dataf,  64,  48,  40, w26, w22, w16);
      TEST_3RF_3("fmadd.w", dataf,  64,  48,  48, w9,  w29, w30);
      TEST_3RF_3("fmadd.w", dataf,  64,  48,  56, w31, w2,  w10);
      TEST_3RF_3("fmadd.w", dataf,  64,  48,  64, w4,  w13, w5);
      TEST_3RF_3("fmadd.w", dataf,  64,  48,  72, w13, w1,  w15);
      TEST_3RF_3("fmadd.w", dataf,  64,  56,   0, w22, w1,  w27);
      TEST_3RF_3("fmadd.w", dataf,  64,  56,   8, w5,  w14, w31);
      TEST_3RF_3("fmadd.w", dataf,  64,  56,  16, w19, w25, w8);
      TEST_3RF_3("fmadd.w", dataf,  64,  56,  24, w24, w24, w22);
      TEST_3RF_3("fmadd.w", dataf,  64,  56,  32, w13, w18, w3);
      TEST_3RF_3("fmadd.w", dataf,  64,  56,  40, w1,  w1,  w1);
      TEST_3RF_3("fmadd.w", dataf,  64,  56,  48, w13, w26, w17);
      TEST_3RF_3("fmadd.w", dataf,  64,  56,  56, w22, w23, w15);
      TEST_3RF_3("fmadd.w", dataf,  64,  56,  64, w21, w26, w7);
      TEST_3RF_3("fmadd.w", dataf,  64,  56,  72, w31, w7,  w8);
      TEST_3RF_3("fmadd.w", dataf,  64,  64,   0, w0,  w22, w0);
      TEST_3RF_3("fmadd.w", dataf,  64,  64,   8, w31, w2,  w17);
      TEST_3RF_3("fmadd.w", dataf,  64,  64,  16, w4,  w16, w17);
      TEST_3RF_3("fmadd.w", dataf,  64,  64,  24, w23, w9,  w25);
      TEST_3RF_3("fmadd.w", dataf,  64,  64,  32, w15, w31, w6);
      TEST_3RF_3("fmadd.w", dataf,  64,  64,  40, w2,  w7,  w15);
      TEST_3RF_3("fmadd.w", dataf,  64,  64,  48, w28, w25, w5);
      TEST_3RF_3("fmadd.w", dataf,  64,  64,  56, w20, w8,  w27);
      TEST_3RF_3("fmadd.w", dataf,  64,  64,  64, w14, w2,  w21);
      TEST_3RF_3("fmadd.w", dataf,  64,  64,  72, w21, w2,  w28);
      TEST_3RF_3("fmadd.w", dataf,  64,  72,   0, w30, w2,  w18);
      TEST_3RF_3("fmadd.w", dataf,  64,  72,   8, w29, w4,  w1);
      TEST_3RF_3("fmadd.w", dataf,  64,  72,  16, w20, w21, w25);
      TEST_3RF_3("fmadd.w", dataf,  64,  72,  24, w29, w14, w8);
      TEST_3RF_3("fmadd.w", dataf,  64,  72,  32, w28, w21, w10);
      TEST_3RF_3("fmadd.w", dataf,  64,  72,  40, w31, w28, w25);
      TEST_3RF_3("fmadd.w", dataf,  64,  72,  48, w27, w21, w21);
      TEST_3RF_3("fmadd.w", dataf,  64,  72,  56, w31, w15, w30);
      TEST_3RF_3("fmadd.w", dataf,  64,  72,  64, w26, w29, w0);
      TEST_3RF_3("fmadd.w", dataf,  64,  72,  72, w15, w19, w2);
      TEST_3RF_3("fmadd.w", dataf,  72,   0,   0, w11, w17, w5);
      TEST_3RF_3("fmadd.w", dataf,  72,   0,   8, w29, w14, w9);
      TEST_3RF_3("fmadd.w", dataf,  72,   0,  16, w1,  w1,  w1);
      TEST_3RF_3("fmadd.w", dataf,  72,   0,  24, w15, w30, w22);
      TEST_3RF_3("fmadd.w", dataf,  72,   0,  32, w8,  w27, w5);
      TEST_3RF_3("fmadd.w", dataf,  72,   0,  40, w17, w24, w26);
      TEST_3RF_3("fmadd.w", dataf,  72,   0,  48, w27, w23, w23);
      TEST_3RF_3("fmadd.w", dataf,  72,   0,  56, w22, w21, w18);
      TEST_3RF_3("fmadd.w", dataf,  72,   0,  64, w12, w20, w2);
      TEST_3RF_3("fmadd.w", dataf,  72,   0,  72, w10, w14, w31);
      TEST_3RF_3("fmadd.w", dataf,  72,   8,   0, w10, w29, w18);
      TEST_3RF_3("fmadd.w", dataf,  72,   8,   8, w13, w8,  w3);
      TEST_3RF_3("fmadd.w", dataf,  72,   8,  16, w18, w5,  w17);
      TEST_3RF_3("fmadd.w", dataf,  72,   8,  24, w27, w7,  w7);
      TEST_3RF_3("fmadd.w", dataf,  72,   8,  32, w1,  w1,  w1);
      TEST_3RF_3("fmadd.w", dataf,  72,   8,  40, w25, w29, w9);
      TEST_3RF_3("fmadd.w", dataf,  72,   8,  48, w21, w2,  w26);
      TEST_3RF_3("fmadd.w", dataf,  72,   8,  56, w13, w28, w22);
      TEST_3RF_3("fmadd.w", dataf,  72,   8,  64, w4,  w19, w11);
      TEST_3RF_3("fmadd.w", dataf,  72,   8,  72, w22, w31, w24);
      TEST_3RF_3("fmadd.w", dataf,  72,  16,   0, w9,  w13, w24);
      TEST_3RF_3("fmadd.w", dataf,  72,  16,   8, w19, w10, w0);
      TEST_3RF_3("fmadd.w", dataf,  72,  16,  16, w18, w14, w23);
      TEST_3RF_3("fmadd.w", dataf,  72,  16,  24, w31, w14, w30);
      TEST_3RF_3("fmadd.w", dataf,  72,  16,  32, w0,  w7,  w0);
      TEST_3RF_3("fmadd.w", dataf,  72,  16,  40, w28, w10, w30);
      TEST_3RF_3("fmadd.w", dataf,  72,  16,  48, w4,  w9,  w27);
      TEST_3RF_3("fmadd.w", dataf,  72,  16,  56, w26, w13, w14);
      TEST_3RF_3("fmadd.w", dataf,  72,  16,  64, w5,  w4,  w13);
      TEST_3RF_3("fmadd.w", dataf,  72,  16,  72, w4,  w28, w22);
      TEST_3RF_3("fmadd.w", dataf,  72,  24,   0, w17, w20, w9);
      TEST_3RF_3("fmadd.w", dataf,  72,  24,   8, w27, w31, w31);
      TEST_3RF_3("fmadd.w", dataf,  72,  24,  16, w10, w13, w28);
      TEST_3RF_3("fmadd.w", dataf,  72,  24,  24, w5,  w12, w10);
      TEST_3RF_3("fmadd.w", dataf,  72,  24,  32, w3,  w13, w18);
      TEST_3RF_3("fmadd.w", dataf,  72,  24,  40, w31, w23, w14);
      TEST_3RF_3("fmadd.w", dataf,  72,  24,  48, w30, w27, w24);
      TEST_3RF_3("fmadd.w", dataf,  72,  24,  56, w25, w22, w5);
      TEST_3RF_3("fmadd.w", dataf,  72,  24,  64, w7,  w27, w9);
      TEST_3RF_3("fmadd.w", dataf,  72,  24,  72, w20, w0,  w6);
      TEST_3RF_3("fmadd.w", dataf,  72,  32,   0, w10, w17, w26);
      TEST_3RF_3("fmadd.w", dataf,  72,  32,   8, w19, w13, w25);
      TEST_3RF_3("fmadd.w", dataf,  72,  32,  16, w29, w26, w6);
      TEST_3RF_3("fmadd.w", dataf,  72,  32,  24, w26, w31, w19);
      TEST_3RF_3("fmadd.w", dataf,  72,  32,  32, w4,  w3,  w0);
      TEST_3RF_3("fmadd.w", dataf,  72,  32,  40, w22, w2,  w23);
      TEST_3RF_3("fmadd.w", dataf,  72,  32,  48, w5,  w0,  w18);
      TEST_3RF_3("fmadd.w", dataf,  72,  32,  56, w29, w25, w8);
      TEST_3RF_3("fmadd.w", dataf,  72,  32,  64, w2,  w0,  w4);
      TEST_3RF_3("fmadd.w", dataf,  72,  32,  72, w12, w20, w4);
      TEST_3RF_3("fmadd.w", dataf,  72,  40,   0, w18, w30, w21);
      TEST_3RF_3("fmadd.w", dataf,  72,  40,   8, w12, w18, w2);
      TEST_3RF_3("fmadd.w", dataf,  72,  40,  16, w6,  w15, w29);
      TEST_3RF_3("fmadd.w", dataf,  72,  40,  24, w12, w9,  w28);
      TEST_3RF_3("fmadd.w", dataf,  72,  40,  32, w31, w14, w4);
      TEST_3RF_3("fmadd.w", dataf,  72,  40,  40, w2,  w22, w9);
      TEST_3RF_3("fmadd.w", dataf,  72,  40,  48, w2,  w9,  w6);
      TEST_3RF_3("fmadd.w", dataf,  72,  40,  56, w28, w17, w9);
      TEST_3RF_3("fmadd.w", dataf,  72,  40,  64, w28, w21, w17);
      TEST_3RF_3("fmadd.w", dataf,  72,  40,  72, w25, w7,  w15);
      TEST_3RF_3("fmadd.w", dataf,  72,  48,   0, w15, w19, w1);
      TEST_3RF_3("fmadd.w", dataf,  72,  48,   8, w17, w25, w14);
      TEST_3RF_3("fmadd.w", dataf,  72,  48,  16, w6,  w26, w11);
      TEST_3RF_3("fmadd.w", dataf,  72,  48,  24, w5,  w8,  w10);
      TEST_3RF_3("fmadd.w", dataf,  72,  48,  32, w5,  w13, w12);
      TEST_3RF_3("fmadd.w", dataf,  72,  48,  40, w27, w22, w22);
      TEST_3RF_3("fmadd.w", dataf,  72,  48,  48, w15, w4,  w29);
      TEST_3RF_3("fmadd.w", dataf,  72,  48,  56, w11, w22, w6);
      TEST_3RF_3("fmadd.w", dataf,  72,  48,  64, w7,  w11, w27);
      TEST_3RF_3("fmadd.w", dataf,  72,  48,  72, w24, w24, w5);
      TEST_3RF_3("fmadd.w", dataf,  72,  56,   0, w2,  w8,  w20);
      TEST_3RF_3("fmadd.w", dataf,  72,  56,   8, w21, w9,  w5);
      TEST_3RF_3("fmadd.w", dataf,  72,  56,  16, w15, w26, w20);
      TEST_3RF_3("fmadd.w", dataf,  72,  56,  24, w21, w31, w26);
      TEST_3RF_3("fmadd.w", dataf,  72,  56,  32, w29, w9,  w31);
      TEST_3RF_3("fmadd.w", dataf,  72,  56,  40, w10, w22, w27);
      TEST_3RF_3("fmadd.w", dataf,  72,  56,  48, w1,  w1,  w1);
      TEST_3RF_3("fmadd.w", dataf,  72,  56,  56, w5,  w31, w30);
      TEST_3RF_3("fmadd.w", dataf,  72,  56,  64, w16, w21, w4);
      TEST_3RF_3("fmadd.w", dataf,  72,  56,  72, w23, w1,  w31);
      TEST_3RF_3("fmadd.w", dataf,  72,  64,   0, w16, w6,  w1);
      TEST_3RF_3("fmadd.w", dataf,  72,  64,   8, w24, w24, w26);
      TEST_3RF_3("fmadd.w", dataf,  72,  64,  16, w22, w1,  w31);
      TEST_3RF_3("fmadd.w", dataf,  72,  64,  24, w5,  w28, w19);
      TEST_3RF_3("fmadd.w", dataf,  72,  64,  32, w26, w17, w18);
      TEST_3RF_3("fmadd.w", dataf,  72,  64,  40, w21, w14, w28);
      TEST_3RF_3("fmadd.w", dataf,  72,  64,  48, w20, w25, w18);
      TEST_3RF_3("fmadd.w", dataf,  72,  64,  56, w15, w26, w23);
      TEST_3RF_3("fmadd.w", dataf,  72,  64,  64, w15, w24, w7);
      TEST_3RF_3("fmadd.w", dataf,  72,  64,  72, w4,  w28, w30);
      TEST_3RF_3("fmadd.w", dataf,  72,  72,   0, w5,  w27, w14);
      TEST_3RF_3("fmadd.w", dataf,  72,  72,   8, w11, w28, w6);
      TEST_3RF_3("fmadd.w", dataf,  72,  72,  16, w5,  w18, w8);
      TEST_3RF_3("fmadd.w", dataf,  72,  72,  24, w5,  w24, w4);
      TEST_3RF_3("fmadd.w", dataf,  72,  72,  32, w24, w24, w18);
      TEST_3RF_3("fmadd.w", dataf,  72,  72,  40, w21, w11, w7);
      TEST_3RF_3("fmadd.w", dataf,  72,  72,  48, w3,  w7,  w28);
      TEST_3RF_3("fmadd.w", dataf,  72,  72,  56, w28, w25, w11);
      TEST_3RF_3("fmadd.w", dataf,  72,  72,  64, w22, w16, w26);
      TEST_3RF_3("fmadd.w", dataf,  72,  72,  72, w14, w23, w31);
      TEST_3RF_3("fmadd.d", datad,   0,   0,   0, w10, w21, w4);
      TEST_3RF_3("fmadd.d", datad,   0,   0,  16, w5,  w4,  w16);
      TEST_3RF_3("fmadd.d", datad,   0,   0,  32, w1,  w1,  w1);
      TEST_3RF_3("fmadd.d", datad,   0,   0,  48, w10, w21, w20);
      TEST_3RF_3("fmadd.d", datad,   0,   0,  64, w18, w26, w12);
      TEST_3RF_3("fmadd.d", datad,   0,   0,  80, w22, w19, w30);
      TEST_3RF_3("fmadd.d", datad,   0,   0,  96, w11, w30, w6);
      TEST_3RF_3("fmadd.d", datad,   0,   0, 112, w15, w5,  w2);
      TEST_3RF_3("fmadd.d", datad,   0,   0, 128, w11, w30, w13);
      TEST_3RF_3("fmadd.d", datad,   0,   0, 144, w2,  w14, w8);
      TEST_3RF_3("fmadd.d", datad,   0,  16,   0, w16, w5,  w7);
      TEST_3RF_3("fmadd.d", datad,   0,  16,  16, w27, w26, w26);
      TEST_3RF_3("fmadd.d", datad,   0,  16,  32, w11, w0,  w30);
      TEST_3RF_3("fmadd.d", datad,   0,  16,  48, w27, w2,  w2);
      TEST_3RF_3("fmadd.d", datad,   0,  16,  64, w9,  w17, w22);
      TEST_3RF_3("fmadd.d", datad,   0,  16,  80, w27, w11, w11);
      TEST_3RF_3("fmadd.d", datad,   0,  16,  96, w2,  w18, w30);
      TEST_3RF_3("fmadd.d", datad,   0,  16, 112, w0,  w29, w0);
      TEST_3RF_3("fmadd.d", datad,   0,  16, 128, w28, w6,  w12);
      TEST_3RF_3("fmadd.d", datad,   0,  16, 144, w1,  w1,  w1);
      TEST_3RF_3("fmadd.d", datad,   0,  32,   0, w8,  w24, w31);
      TEST_3RF_3("fmadd.d", datad,   0,  32,  16, w22, w26, w13);
      TEST_3RF_3("fmadd.d", datad,   0,  32,  32, w30, w10, w18);
      TEST_3RF_3("fmadd.d", datad,   0,  32,  48, w5,  w13, w16);
      TEST_3RF_3("fmadd.d", datad,   0,  32,  64, w6,  w11, w12);
      TEST_3RF_3("fmadd.d", datad,   0,  32,  80, w8,  w20, w29);
      TEST_3RF_3("fmadd.d", datad,   0,  32,  96, w30, w16, w8);
      TEST_3RF_3("fmadd.d", datad,   0,  32, 112, w0,  w2,  w0);
      TEST_3RF_3("fmadd.d", datad,   0,  32, 128, w7,  w0,  w31);
      TEST_3RF_3("fmadd.d", datad,   0,  32, 144, w3,  w7,  w12);
      TEST_3RF_3("fmadd.d", datad,   0,  48,   0, w5,  w15, w4);
      TEST_3RF_3("fmadd.d", datad,   0,  48,  16, w4,  w5,  w30);
      TEST_3RF_3("fmadd.d", datad,   0,  48,  32, w18, w3,  w8);
      TEST_3RF_3("fmadd.d", datad,   0,  48,  48, w4,  w8,  w14);
      TEST_3RF_3("fmadd.d", datad,   0,  48,  64, w17, w25, w20);
      TEST_3RF_3("fmadd.d", datad,   0,  48,  80, w29, w5,  w28);
      TEST_3RF_3("fmadd.d", datad,   0,  48,  96, w17, w2,  w26);
      TEST_3RF_3("fmadd.d", datad,   0,  48, 112, w1,  w1,  w1);
      TEST_3RF_3("fmadd.d", datad,   0,  48, 128, w10, w26, w3);
      TEST_3RF_3("fmadd.d", datad,   0,  48, 144, w17, w26, w3);
      TEST_3RF_3("fmadd.d", datad,   0,  64,   0, w21, w1,  w15);
      TEST_3RF_3("fmadd.d", datad,   0,  64,  16, w26, w17, w19);
      TEST_3RF_3("fmadd.d", datad,   0,  64,  32, w30, w22, w17);
      TEST_3RF_3("fmadd.d", datad,   0,  64,  48, w16, w26, w25);
      TEST_3RF_3("fmadd.d", datad,   0,  64,  64, w21, w2,  w7);
      TEST_3RF_3("fmadd.d", datad,   0,  64,  80, w6,  w27, w3);
      TEST_3RF_3("fmadd.d", datad,   0,  64,  96, w0,  w23, w0);
      TEST_3RF_3("fmadd.d", datad,   0,  64, 112, w21, w2,  w17);
      TEST_3RF_3("fmadd.d", datad,   0,  64, 128, w22, w13, w11);
      TEST_3RF_3("fmadd.d", datad,   0,  64, 144, w26, w30, w6);
      TEST_3RF_3("fmadd.d", datad,   0,  80,   0, w29, w19, w7);
      TEST_3RF_3("fmadd.d", datad,   0,  80,  16, w12, w13, w24);
      TEST_3RF_3("fmadd.d", datad,   0,  80,  32, w31, w12, w15);
      TEST_3RF_3("fmadd.d", datad,   0,  80,  48, w16, w28, w9);
      TEST_3RF_3("fmadd.d", datad,   0,  80,  64, w9,  w17, w11);
      TEST_3RF_3("fmadd.d", datad,   0,  80,  80, w17, w24, w7);
      TEST_3RF_3("fmadd.d", datad,   0,  80,  96, w12, w27, w7);
      TEST_3RF_3("fmadd.d", datad,   0,  80, 112, w4,  w16, w10);
      TEST_3RF_3("fmadd.d", datad,   0,  80, 128, w21, w7,  w23);
      TEST_3RF_3("fmadd.d", datad,   0,  80, 144, w1,  w1,  w1);
      TEST_3RF_3("fmadd.d", datad,   0,  96,   0, w1,  w1,  w1);
      TEST_3RF_3("fmadd.d", datad,   0,  96,  16, w21, w7,  w30);
      TEST_3RF_3("fmadd.d", datad,   0,  96,  32, w9,  w14, w10);
      TEST_3RF_3("fmadd.d", datad,   0,  96,  48, w22, w7,  w9);
      TEST_3RF_3("fmadd.d", datad,   0,  96,  64, w2,  w22, w25);
      TEST_3RF_3("fmadd.d", datad,   0,  96,  80, w31, w2,  w16);
      TEST_3RF_3("fmadd.d", datad,   0,  96,  96, w10, w19, w8);
      TEST_3RF_3("fmadd.d", datad,   0,  96, 112, w17, w0,  w4);
      TEST_3RF_3("fmadd.d", datad,   0,  96, 128, w25, w4,  w20);
      TEST_3RF_3("fmadd.d", datad,   0,  96, 144, w3,  w25, w27);
      TEST_3RF_3("fmadd.d", datad,   0, 112,   0, w26, w28, w15);
      TEST_3RF_3("fmadd.d", datad,   0, 112,  16, w1,  w1,  w1);
      TEST_3RF_3("fmadd.d", datad,   0, 112,  32, w26, w24, w16);
      TEST_3RF_3("fmadd.d", datad,   0, 112,  48, w4,  w15, w23);
      TEST_3RF_3("fmadd.d", datad,   0, 112,  64, w13, w17, w6);
      TEST_3RF_3("fmadd.d", datad,   0, 112,  80, w16, w12, w9);
      TEST_3RF_3("fmadd.d", datad,   0, 112,  96, w1,  w1,  w1);
      TEST_3RF_3("fmadd.d", datad,   0, 112, 112, w22, w28, w9);
      TEST_3RF_3("fmadd.d", datad,   0, 112, 128, w8,  w28, w13);
      TEST_3RF_3("fmadd.d", datad,   0, 112, 144, w1,  w1,  w1);
      TEST_3RF_3("fmadd.d", datad,   0, 128,   0, w0,  w2,  w0);
      TEST_3RF_3("fmadd.d", datad,   0, 128,  16, w4,  w26, w29);
      TEST_3RF_3("fmadd.d", datad,   0, 128,  32, w30, w20, w26);
      TEST_3RF_3("fmadd.d", datad,   0, 128,  48, w13, w22, w20);
      TEST_3RF_3("fmadd.d", datad,   0, 128,  64, w6,  w25, w21);
      TEST_3RF_3("fmadd.d", datad,   0, 128,  80, w29, w6,  w10);
      TEST_3RF_3("fmadd.d", datad,   0, 128,  96, w13, w23, w22);
      TEST_3RF_3("fmadd.d", datad,   0, 128, 112, w22, w24, w12);
      TEST_3RF_3("fmadd.d", datad,   0, 128, 128, w18, w1,  w20);
      TEST_3RF_3("fmadd.d", datad,   0, 128, 144, w15, w21, w17);
      TEST_3RF_3("fmadd.d", datad,   0, 144,   0, w25, w9,  w14);
      TEST_3RF_3("fmadd.d", datad,   0, 144,  16, w23, w30, w8);
      TEST_3RF_3("fmadd.d", datad,   0, 144,  32, w5,  w20, w29);
      TEST_3RF_3("fmadd.d", datad,   0, 144,  48, w11, w26, w22);
      TEST_3RF_3("fmadd.d", datad,   0, 144,  64, w0,  w23, w0);
      TEST_3RF_3("fmadd.d", datad,   0, 144,  80, w28, w6,  w1);
      TEST_3RF_3("fmadd.d", datad,   0, 144,  96, w9,  w29, w23);
      TEST_3RF_3("fmadd.d", datad,   0, 144, 112, w31, w21, w3);
      TEST_3RF_3("fmadd.d", datad,   0, 144, 128, w18, w23, w24);
      TEST_3RF_3("fmadd.d", datad,   0, 144, 144, w1,  w1,  w1);
      TEST_3RF_3("fmadd.d", datad,  16,   0,   0, w6,  w13, w16);
      TEST_3RF_3("fmadd.d", datad,  16,   0,  16, w23, w7,  w26);
      TEST_3RF_3("fmadd.d", datad,  16,   0,  32, w5,  w30, w24);
      TEST_3RF_3("fmadd.d", datad,  16,   0,  48, w14, w3,  w12);
      TEST_3RF_3("fmadd.d", datad,  16,   0,  64, w11, w14, w6);
      TEST_3RF_3("fmadd.d", datad,  16,   0,  80, w1,  w1,  w1);
      TEST_3RF_3("fmadd.d", datad,  16,   0,  96, w14, w29, w21);
      TEST_3RF_3("fmadd.d", datad,  16,   0, 112, w30, w7,  w18);
      TEST_3RF_3("fmadd.d", datad,  16,   0, 128, w21, w6,  w8);
      TEST_3RF_3("fmadd.d", datad,  16,   0, 144, w24, w24, w31);
      TEST_3RF_3("fmadd.d", datad,  16,  16,   0, w16, w25, w5);
      TEST_3RF_3("fmadd.d", datad,  16,  16,  16, w30, w10, w28);
      TEST_3RF_3("fmadd.d", datad,  16,  16,  32, w5,  w4,  w1);
      TEST_3RF_3("fmadd.d", datad,  16,  16,  48, w3,  w28, w15);
      TEST_3RF_3("fmadd.d", datad,  16,  16,  64, w7,  w8,  w26);
      TEST_3RF_3("fmadd.d", datad,  16,  16,  80, w21, w14, w27);
      TEST_3RF_3("fmadd.d", datad,  16,  16,  96, w4,  w11, w25);
      TEST_3RF_3("fmadd.d", datad,  16,  16, 112, w25, w9,  w0);
      TEST_3RF_3("fmadd.d", datad,  16,  16, 128, w11, w30, w6);
      TEST_3RF_3("fmadd.d", datad,  16,  16, 144, w19, w22, w31);
      TEST_3RF_3("fmadd.d", datad,  16,  32,   0, w18, w7,  w24);
      TEST_3RF_3("fmadd.d", datad,  16,  32,  16, w23, w5,  w2);
      TEST_3RF_3("fmadd.d", datad,  16,  32,  32, w19, w10, w6);
      TEST_3RF_3("fmadd.d", datad,  16,  32,  48, w21, w13, w2);
      TEST_3RF_3("fmadd.d", datad,  16,  32,  64, w4,  w20, w10);
      TEST_3RF_3("fmadd.d", datad,  16,  32,  80, w31, w10, w24);
      TEST_3RF_3("fmadd.d", datad,  16,  32,  96, w26, w14, w3);
      TEST_3RF_3("fmadd.d", datad,  16,  32, 112, w19, w7,  w12);
      TEST_3RF_3("fmadd.d", datad,  16,  32, 128, w19, w18, w10);
      TEST_3RF_3("fmadd.d", datad,  16,  32, 144, w26, w6,  w1);
      TEST_3RF_3("fmadd.d", datad,  16,  48,   0, w25, w24, w8);
      TEST_3RF_3("fmadd.d", datad,  16,  48,  16, w17, w16, w13);
      TEST_3RF_3("fmadd.d", datad,  16,  48,  32, w20, w3,  w23);
      TEST_3RF_3("fmadd.d", datad,  16,  48,  48, w26, w24, w4);
      TEST_3RF_3("fmadd.d", datad,  16,  48,  64, w29, w25, w7);
      TEST_3RF_3("fmadd.d", datad,  16,  48,  80, w28, w3,  w0);
      TEST_3RF_3("fmadd.d", datad,  16,  48,  96, w22, w17, w3);
      TEST_3RF_3("fmadd.d", datad,  16,  48, 112, w10, w24, w16);
      TEST_3RF_3("fmadd.d", datad,  16,  48, 128, w29, w10, w26);
      TEST_3RF_3("fmadd.d", datad,  16,  48, 144, w23, w16, w27);
      TEST_3RF_3("fmadd.d", datad,  16,  64,   0, w16, w9,  w3);
      TEST_3RF_3("fmadd.d", datad,  16,  64,  16, w2,  w25, w16);
      TEST_3RF_3("fmadd.d", datad,  16,  64,  32, w22, w28, w7);
      TEST_3RF_3("fmadd.d", datad,  16,  64,  48, w16, w21, w12);
      TEST_3RF_3("fmadd.d", datad,  16,  64,  64, w13, w18, w5);
      TEST_3RF_3("fmadd.d", datad,  16,  64,  80, w21, w14, w8);
      TEST_3RF_3("fmadd.d", datad,  16,  64,  96, w21, w4,  w25);
      TEST_3RF_3("fmadd.d", datad,  16,  64, 112, w24, w24, w14);
      TEST_3RF_3("fmadd.d", datad,  16,  64, 128, w17, w8,  w12);
      TEST_3RF_3("fmadd.d", datad,  16,  64, 144, w27, w3,  w3);
      TEST_3RF_3("fmadd.d", datad,  16,  80,   0, w3,  w12, w30);
      TEST_3RF_3("fmadd.d", datad,  16,  80,  16, w20, w21, w2);
      TEST_3RF_3("fmadd.d", datad,  16,  80,  32, w22, w14, w18);
      TEST_3RF_3("fmadd.d", datad,  16,  80,  48, w12, w10, w26);
      TEST_3RF_3("fmadd.d", datad,  16,  80,  64, w28, w31, w6);
      TEST_3RF_3("fmadd.d", datad,  16,  80,  80, w10, w17, w11);
      TEST_3RF_3("fmadd.d", datad,  16,  80,  96, w31, w19, w20);
      TEST_3RF_3("fmadd.d", datad,  16,  80, 112, w4,  w12, w18);
      TEST_3RF_3("fmadd.d", datad,  16,  80, 128, w29, w21, w30);
      TEST_3RF_3("fmadd.d", datad,  16,  80, 144, w24, w24, w2);
      TEST_3RF_3("fmadd.d", datad,  16,  96,   0, w4,  w22, w25);
      TEST_3RF_3("fmadd.d", datad,  16,  96,  16, w24, w24, w12);
      TEST_3RF_3("fmadd.d", datad,  16,  96,  32, w7,  w11, w24);
      TEST_3RF_3("fmadd.d", datad,  16,  96,  48, w18, w5,  w20);
      TEST_3RF_3("fmadd.d", datad,  16,  96,  64, w17, w11, w30);
      TEST_3RF_3("fmadd.d", datad,  16,  96,  80, w3,  w22, w29);
      TEST_3RF_3("fmadd.d", datad,  16,  96,  96, w2,  w9,  w17);
      TEST_3RF_3("fmadd.d", datad,  16,  96, 112, w6,  w21, w30);
      TEST_3RF_3("fmadd.d", datad,  16,  96, 128, w25, w18, w19);
      TEST_3RF_3("fmadd.d", datad,  16,  96, 144, w23, w10, w11);
      TEST_3RF_3("fmadd.d", datad,  16, 112,   0, w25, w15, w1);
      TEST_3RF_3("fmadd.d", datad,  16, 112,  16, w15, w8,  w26);
      TEST_3RF_3("fmadd.d", datad,  16, 112,  32, w27, w16, w16);
      TEST_3RF_3("fmadd.d", datad,  16, 112,  48, w5,  w19, w2);
      TEST_3RF_3("fmadd.d", datad,  16, 112,  64, w10, w8,  w19);
      TEST_3RF_3("fmadd.d", datad,  16, 112,  80, w21, w6,  w22);
      TEST_3RF_3("fmadd.d", datad,  16, 112,  96, w11, w4,  w25);
      TEST_3RF_3("fmadd.d", datad,  16, 112, 112, w20, w21, w31);
      TEST_3RF_3("fmadd.d", datad,  16, 112, 128, w9,  w19, w24);
      TEST_3RF_3("fmadd.d", datad,  16, 112, 144, w27, w6,  w6);
      TEST_3RF_3("fmadd.d", datad,  16, 128,   0, w16, w5,  w17);
      TEST_3RF_3("fmadd.d", datad,  16, 128,  16, w9,  w20, w19);
      TEST_3RF_3("fmadd.d", datad,  16, 128,  32, w25, w29, w13);
      TEST_3RF_3("fmadd.d", datad,  16, 128,  48, w20, w13, w18);
      TEST_3RF_3("fmadd.d", datad,  16, 128,  64, w8,  w15, w28);
      TEST_3RF_3("fmadd.d", datad,  16, 128,  80, w16, w2,  w17);
      TEST_3RF_3("fmadd.d", datad,  16, 128,  96, w22, w25, w28);
      TEST_3RF_3("fmadd.d", datad,  16, 128, 112, w26, w18, w16);
      TEST_3RF_3("fmadd.d", datad,  16, 128, 128, w16, w17, w25);
      TEST_3RF_3("fmadd.d", datad,  16, 128, 144, w3,  w10, w20);
      TEST_3RF_3("fmadd.d", datad,  16, 144,   0, w10, w26, w25);
      TEST_3RF_3("fmadd.d", datad,  16, 144,  16, w27, w3,  w3);
      TEST_3RF_3("fmadd.d", datad,  16, 144,  32, w14, w28, w11);
      TEST_3RF_3("fmadd.d", datad,  16, 144,  48, w27, w17, w17);
      TEST_3RF_3("fmadd.d", datad,  16, 144,  64, w24, w24, w13);
      TEST_3RF_3("fmadd.d", datad,  16, 144,  80, w25, w7,  w9);
      TEST_3RF_3("fmadd.d", datad,  16, 144,  96, w9,  w26, w31);
      TEST_3RF_3("fmadd.d", datad,  16, 144, 112, w2,  w22, w26);
      TEST_3RF_3("fmadd.d", datad,  16, 144, 128, w20, w6,  w10);
      TEST_3RF_3("fmadd.d", datad,  16, 144, 144, w6,  w31, w13);
      TEST_3RF_3("fmadd.d", datad,  32,   0,   0, w16, w19, w23);
      TEST_3RF_3("fmadd.d", datad,  32,   0,  16, w10, w13, w19);
      TEST_3RF_3("fmadd.d", datad,  32,   0,  32, w13, w27, w1);
      TEST_3RF_3("fmadd.d", datad,  32,   0,  48, w10, w6,  w29);
      TEST_3RF_3("fmadd.d", datad,  32,   0,  64, w27, w30, w30);
      TEST_3RF_3("fmadd.d", datad,  32,   0,  80, w10, w20, w5);
      TEST_3RF_3("fmadd.d", datad,  32,   0,  96, w20, w29, w14);
      TEST_3RF_3("fmadd.d", datad,  32,   0, 112, w14, w28, w17);
      TEST_3RF_3("fmadd.d", datad,  32,   0, 128, w5,  w22, w11);
      TEST_3RF_3("fmadd.d", datad,  32,   0, 144, w0,  w11, w0);
      TEST_3RF_3("fmadd.d", datad,  32,  16,   0, w11, w14, w27);
      TEST_3RF_3("fmadd.d", datad,  32,  16,  16, w30, w5,  w11);
      TEST_3RF_3("fmadd.d", datad,  32,  16,  32, w24, w24, w19);
      TEST_3RF_3("fmadd.d", datad,  32,  16,  48, w6,  w26, w29);
      TEST_3RF_3("fmadd.d", datad,  32,  16,  64, w12, w23, w24);
      TEST_3RF_3("fmadd.d", datad,  32,  16,  80, w10, w1,  w12);
      TEST_3RF_3("fmadd.d", datad,  32,  16,  96, w15, w21, w9);
      TEST_3RF_3("fmadd.d", datad,  32,  16, 112, w30, w4,  w5);
      TEST_3RF_3("fmadd.d", datad,  32,  16, 128, w15, w9,  w28);
      TEST_3RF_3("fmadd.d", datad,  32,  16, 144, w20, w28, w0);
      TEST_3RF_3("fmadd.d", datad,  32,  32,   0, w31, w10, w27);
      TEST_3RF_3("fmadd.d", datad,  32,  32,  16, w30, w16, w1);
      TEST_3RF_3("fmadd.d", datad,  32,  32,  32, w9,  w8,  w20);
      TEST_3RF_3("fmadd.d", datad,  32,  32,  48, w16, w2,  w17);
      TEST_3RF_3("fmadd.d", datad,  32,  32,  64, w28, w25, w9);
      TEST_3RF_3("fmadd.d", datad,  32,  32,  80, w7,  w27, w21);
      TEST_3RF_3("fmadd.d", datad,  32,  32,  96, w22, w16, w30);
      TEST_3RF_3("fmadd.d", datad,  32,  32, 112, w20, w3,  w29);
      TEST_3RF_3("fmadd.d", datad,  32,  32, 128, w31, w24, w18);
      TEST_3RF_3("fmadd.d", datad,  32,  32, 144, w28, w24, w17);
      TEST_3RF_3("fmadd.d", datad,  32,  48,   0, w6,  w19, w15);
      TEST_3RF_3("fmadd.d", datad,  32,  48,  16, w22, w20, w25);
      TEST_3RF_3("fmadd.d", datad,  32,  48,  32, w31, w8,  w9);
      TEST_3RF_3("fmadd.d", datad,  32,  48,  48, w1,  w1,  w1);
      TEST_3RF_3("fmadd.d", datad,  32,  48,  64, w25, w5,  w27);
      TEST_3RF_3("fmadd.d", datad,  32,  48,  80, w2,  w12, w22);
      TEST_3RF_3("fmadd.d", datad,  32,  48,  96, w23, w3,  w6);
      TEST_3RF_3("fmadd.d", datad,  32,  48, 112, w21, w23, w27);
      TEST_3RF_3("fmadd.d", datad,  32,  48, 128, w25, w27, w24);
      TEST_3RF_3("fmadd.d", datad,  32,  48, 144, w24, w24, w19);
      TEST_3RF_3("fmadd.d", datad,  32,  64,   0, w10, w20, w11);
      TEST_3RF_3("fmadd.d", datad,  32,  64,  16, w28, w27, w30);
      TEST_3RF_3("fmadd.d", datad,  32,  64,  32, w11, w17, w19);
      TEST_3RF_3("fmadd.d", datad,  32,  64,  48, w4,  w16, w27);
      TEST_3RF_3("fmadd.d", datad,  32,  64,  64, w13, w18, w21);
      TEST_3RF_3("fmadd.d", datad,  32,  64,  80, w19, w13, w23);
      TEST_3RF_3("fmadd.d", datad,  32,  64,  96, w31, w3,  w15);
      TEST_3RF_3("fmadd.d", datad,  32,  64, 112, w2,  w9,  w4);
      TEST_3RF_3("fmadd.d", datad,  32,  64, 128, w26, w4,  w29);
      TEST_3RF_3("fmadd.d", datad,  32,  64, 144, w21, w29, w22);
      TEST_3RF_3("fmadd.d", datad,  32,  80,   0, w8,  w7,  w10);
      TEST_3RF_3("fmadd.d", datad,  32,  80,  16, w19, w3,  w5);
      TEST_3RF_3("fmadd.d", datad,  32,  80,  32, w17, w15, w23);
      TEST_3RF_3("fmadd.d", datad,  32,  80,  48, w4,  w19, w7);
      TEST_3RF_3("fmadd.d", datad,  32,  80,  64, w0,  w1,  w0);
      TEST_3RF_3("fmadd.d", datad,  32,  80,  80, w25, w21, w20);
      TEST_3RF_3("fmadd.d", datad,  32,  80,  96, w6,  w12, w19);
      TEST_3RF_3("fmadd.d", datad,  32,  80, 112, w9,  w27, w22);
      TEST_3RF_3("fmadd.d", datad,  32,  80, 128, w19, w0,  w16);
      TEST_3RF_3("fmadd.d", datad,  32,  80, 144, w23, w29, w5);
      TEST_3RF_3("fmadd.d", datad,  32,  96,   0, w20, w19, w13);
      TEST_3RF_3("fmadd.d", datad,  32,  96,  16, w28, w30, w0);
      TEST_3RF_3("fmadd.d", datad,  32,  96,  32, w31, w3,  w17);
      TEST_3RF_3("fmadd.d", datad,  32,  96,  48, w14, w26, w22);
      TEST_3RF_3("fmadd.d", datad,  32,  96,  64, w2,  w22, w3);
      TEST_3RF_3("fmadd.d", datad,  32,  96,  80, w27, w11, w11);
      TEST_3RF_3("fmadd.d", datad,  32,  96,  96, w23, w2,  w10);
      TEST_3RF_3("fmadd.d", datad,  32,  96, 112, w11, w19, w0);
      TEST_3RF_3("fmadd.d", datad,  32,  96, 128, w30, w19, w16);
      TEST_3RF_3("fmadd.d", datad,  32,  96, 144, w22, w16, w21);
      TEST_3RF_3("fmadd.d", datad,  32, 112,   0, w10, w4,  w2);
      TEST_3RF_3("fmadd.d", datad,  32, 112,  16, w6,  w2,  w5);
      TEST_3RF_3("fmadd.d", datad,  32, 112,  32, w20, w0,  w10);
      TEST_3RF_3("fmadd.d", datad,  32, 112,  48, w22, w2,  w0);
      TEST_3RF_3("fmadd.d", datad,  32, 112,  64, w25, w29, w11);
      TEST_3RF_3("fmadd.d", datad,  32, 112,  80, w16, w31, w2);
      TEST_3RF_3("fmadd.d", datad,  32, 112,  96, w27, w11, w11);
      TEST_3RF_3("fmadd.d", datad,  32, 112, 112, w21, w27, w9);
      TEST_3RF_3("fmadd.d", datad,  32, 112, 128, w8,  w12, w31);
      TEST_3RF_3("fmadd.d", datad,  32, 112, 144, w25, w1,  w10);
      TEST_3RF_3("fmadd.d", datad,  32, 128,   0, w29, w4,  w16);
      TEST_3RF_3("fmadd.d", datad,  32, 128,  16, w31, w6,  w22);
      TEST_3RF_3("fmadd.d", datad,  32, 128,  32, w4,  w26, w11);
      TEST_3RF_3("fmadd.d", datad,  32, 128,  48, w4,  w1,  w6);
      TEST_3RF_3("fmadd.d", datad,  32, 128,  64, w4,  w27, w15);
      TEST_3RF_3("fmadd.d", datad,  32, 128,  80, w11, w3,  w18);
      TEST_3RF_3("fmadd.d", datad,  32, 128,  96, w6,  w14, w7);
      TEST_3RF_3("fmadd.d", datad,  32, 128, 112, w2,  w24, w16);
      TEST_3RF_3("fmadd.d", datad,  32, 128, 128, w14, w23, w9);
      TEST_3RF_3("fmadd.d", datad,  32, 128, 144, w15, w1,  w6);
      TEST_3RF_3("fmadd.d", datad,  32, 144,   0, w19, w18, w5);
      TEST_3RF_3("fmadd.d", datad,  32, 144,  16, w26, w8,  w9);
      TEST_3RF_3("fmadd.d", datad,  32, 144,  32, w20, w19, w14);
      TEST_3RF_3("fmadd.d", datad,  32, 144,  48, w25, w21, w20);
      TEST_3RF_3("fmadd.d", datad,  32, 144,  64, w29, w16, w24);
      TEST_3RF_3("fmadd.d", datad,  32, 144,  80, w13, w27, w28);
      TEST_3RF_3("fmadd.d", datad,  32, 144,  96, w31, w2,  w10);
      TEST_3RF_3("fmadd.d", datad,  32, 144, 112, w6,  w4,  w2);
      TEST_3RF_3("fmadd.d", datad,  32, 144, 128, w22, w18, w26);
      TEST_3RF_3("fmadd.d", datad,  32, 144, 144, w31, w1,  w27);
      TEST_3RF_3("fmadd.d", datad,  48,   0,   0, w5,  w21, w13);
      TEST_3RF_3("fmadd.d", datad,  48,   0,  16, w10, w15, w22);
      TEST_3RF_3("fmadd.d", datad,  48,   0,  32, w20, w3,  w9);
      TEST_3RF_3("fmadd.d", datad,  48,   0,  48, w2,  w28, w30);
      TEST_3RF_3("fmadd.d", datad,  48,   0,  64, w22, w26, w14);
      TEST_3RF_3("fmadd.d", datad,  48,   0,  80, w15, w7,  w10);
      TEST_3RF_3("fmadd.d", datad,  48,   0,  96, w11, w6,  w12);
      TEST_3RF_3("fmadd.d", datad,  48,   0, 112, w21, w12, w16);
      TEST_3RF_3("fmadd.d", datad,  48,   0, 128, w24, w24, w3);
      TEST_3RF_3("fmadd.d", datad,  48,   0, 144, w2,  w18, w3);
      TEST_3RF_3("fmadd.d", datad,  48,  16,   0, w13, w8,  w24);
      TEST_3RF_3("fmadd.d", datad,  48,  16,  16, w27, w18, w18);
      TEST_3RF_3("fmadd.d", datad,  48,  16,  32, w7,  w17, w6);
      TEST_3RF_3("fmadd.d", datad,  48,  16,  48, w11, w26, w8);
      TEST_3RF_3("fmadd.d", datad,  48,  16,  64, w7,  w25, w31);
      TEST_3RF_3("fmadd.d", datad,  48,  16,  80, w1,  w1,  w1);
      TEST_3RF_3("fmadd.d", datad,  48,  16,  96, w7,  w14, w8);
      TEST_3RF_3("fmadd.d", datad,  48,  16, 112, w17, w25, w14);
      TEST_3RF_3("fmadd.d", datad,  48,  16, 128, w29, w14, w27);
      TEST_3RF_3("fmadd.d", datad,  48,  16, 144, w13, w6,  w30);
      TEST_3RF_3("fmadd.d", datad,  48,  32,   0, w15, w24, w0);
      TEST_3RF_3("fmadd.d", datad,  48,  32,  16, w19, w6,  w8);
      TEST_3RF_3("fmadd.d", datad,  48,  32,  32, w11, w1,  w27);
      TEST_3RF_3("fmadd.d", datad,  48,  32,  48, w19, w18, w1);
      TEST_3RF_3("fmadd.d", datad,  48,  32,  64, w30, w12, w10);
      TEST_3RF_3("fmadd.d", datad,  48,  32,  80, w5,  w9,  w7);
      TEST_3RF_3("fmadd.d", datad,  48,  32,  96, w13, w23, w15);
      TEST_3RF_3("fmadd.d", datad,  48,  32, 112, w30, w16, w28);
      TEST_3RF_3("fmadd.d", datad,  48,  32, 128, w30, w25, w9);
      TEST_3RF_3("fmadd.d", datad,  48,  32, 144, w5,  w23, w25);
      TEST_3RF_3("fmadd.d", datad,  48,  48,   0, w29, w23, w12);
      TEST_3RF_3("fmadd.d", datad,  48,  48,  16, w3,  w0,  w23);
      TEST_3RF_3("fmadd.d", datad,  48,  48,  32, w4,  w27, w10);
      TEST_3RF_3("fmadd.d", datad,  48,  48,  48, w22, w28, w8);
      TEST_3RF_3("fmadd.d", datad,  48,  48,  64, w3,  w6,  w14);
      TEST_3RF_3("fmadd.d", datad,  48,  48,  80, w8,  w15, w21);
      TEST_3RF_3("fmadd.d", datad,  48,  48,  96, w21, w6,  w4);
      TEST_3RF_3("fmadd.d", datad,  48,  48, 112, w20, w22, w2);
      TEST_3RF_3("fmadd.d", datad,  48,  48, 128, w16, w21, w27);
      TEST_3RF_3("fmadd.d", datad,  48,  48, 144, w25, w26, w18);
      TEST_3RF_3("fmadd.d", datad,  48,  64,   0, w18, w23, w10);
      TEST_3RF_3("fmadd.d", datad,  48,  64,  16, w30, w27, w10);
      TEST_3RF_3("fmadd.d", datad,  48,  64,  32, w22, w31, w5);
      TEST_3RF_3("fmadd.d", datad,  48,  64,  48, w0,  w22, w0);
      TEST_3RF_3("fmadd.d", datad,  48,  64,  64, w1,  w1,  w1);
      TEST_3RF_3("fmadd.d", datad,  48,  64,  80, w9,  w25, w8);
      TEST_3RF_3("fmadd.d", datad,  48,  64,  96, w23, w1,  w12);
      TEST_3RF_3("fmadd.d", datad,  48,  64, 112, w23, w30, w16);
      TEST_3RF_3("fmadd.d", datad,  48,  64, 128, w11, w20, w19);
      TEST_3RF_3("fmadd.d", datad,  48,  64, 144, w27, w9,  w9);
      TEST_3RF_3("fmadd.d", datad,  48,  80,   0, w14, w20, w3);
      TEST_3RF_3("fmadd.d", datad,  48,  80,  16, w1,  w1,  w1);
      TEST_3RF_3("fmadd.d", datad,  48,  80,  32, w7,  w27, w11);
      TEST_3RF_3("fmadd.d", datad,  48,  80,  48, w5,  w22, w21);
      TEST_3RF_3("fmadd.d", datad,  48,  80,  64, w27, w21, w21);
      TEST_3RF_3("fmadd.d", datad,  48,  80,  80, w26, w28, w11);
      TEST_3RF_3("fmadd.d", datad,  48,  80,  96, w27, w5,  w5);
      TEST_3RF_3("fmadd.d", datad,  48,  80, 112, w4,  w3,  w28);
      TEST_3RF_3("fmadd.d", datad,  48,  80, 128, w6,  w27, w8);
      TEST_3RF_3("fmadd.d", datad,  48,  80, 144, w29, w25, w24);
      TEST_3RF_3("fmadd.d", datad,  48,  96,   0, w8,  w13, w11);
      TEST_3RF_3("fmadd.d", datad,  48,  96,  16, w3,  w23, w26);
      TEST_3RF_3("fmadd.d", datad,  48,  96,  32, w23, w26, w27);
      TEST_3RF_3("fmadd.d", datad,  48,  96,  48, w30, w21, w6);
      TEST_3RF_3("fmadd.d", datad,  48,  96,  64, w4,  w11, w27);
      TEST_3RF_3("fmadd.d", datad,  48,  96,  80, w31, w1,  w21);
      TEST_3RF_3("fmadd.d", datad,  48,  96,  96, w27, w12, w12);
      TEST_3RF_3("fmadd.d", datad,  48,  96, 112, w16, w0,  w17);
      TEST_3RF_3("fmadd.d", datad,  48,  96, 128, w20, w28, w23);
      TEST_3RF_3("fmadd.d", datad,  48,  96, 144, w15, w4,  w20);
      TEST_3RF_3("fmadd.d", datad,  48, 112,   0, w8,  w29, w28);
      TEST_3RF_3("fmadd.d", datad,  48, 112,  16, w21, w8,  w31);
      TEST_3RF_3("fmadd.d", datad,  48, 112,  32, w12, w2,  w22);
      TEST_3RF_3("fmadd.d", datad,  48, 112,  48, w7,  w29, w21);
      TEST_3RF_3("fmadd.d", datad,  48, 112,  64, w28, w3,  w25);
      TEST_3RF_3("fmadd.d", datad,  48, 112,  80, w8,  w30, w24);
      TEST_3RF_3("fmadd.d", datad,  48, 112,  96, w9,  w19, w20);
      TEST_3RF_3("fmadd.d", datad,  48, 112, 112, w21, w4,  w20);
      TEST_3RF_3("fmadd.d", datad,  48, 112, 128, w6,  w24, w17);
      TEST_3RF_3("fmadd.d", datad,  48, 112, 144, w29, w7,  w21);
      TEST_3RF_3("fmadd.d", datad,  48, 128,   0, w17, w15, w18);
      TEST_3RF_3("fmadd.d", datad,  48, 128,  16, w13, w4,  w27);
      TEST_3RF_3("fmadd.d", datad,  48, 128,  32, w12, w17, w29);
      TEST_3RF_3("fmadd.d", datad,  48, 128,  48, w3,  w24, w27);
      TEST_3RF_3("fmadd.d", datad,  48, 128,  64, w24, w24, w20);
      TEST_3RF_3("fmadd.d", datad,  48, 128,  80, w30, w17, w28);
      TEST_3RF_3("fmadd.d", datad,  48, 128,  96, w29, w9,  w5);
      TEST_3RF_3("fmadd.d", datad,  48, 128, 112, w16, w29, w27);
      TEST_3RF_3("fmadd.d", datad,  48, 128, 128, w20, w18, w1);
      TEST_3RF_3("fmadd.d", datad,  48, 128, 144, w12, w3,  w31);
      TEST_3RF_3("fmadd.d", datad,  48, 144,   0, w19, w24, w16);
      TEST_3RF_3("fmadd.d", datad,  48, 144,  16, w2,  w11, w30);
      TEST_3RF_3("fmadd.d", datad,  48, 144,  32, w7,  w6,  w10);
      TEST_3RF_3("fmadd.d", datad,  48, 144,  48, w24, w24, w3);
      TEST_3RF_3("fmadd.d", datad,  48, 144,  64, w13, w16, w30);
      TEST_3RF_3("fmadd.d", datad,  48, 144,  80, w5,  w4,  w29);
      TEST_3RF_3("fmadd.d", datad,  48, 144,  96, w22, w1,  w26);
      TEST_3RF_3("fmadd.d", datad,  48, 144, 112, w0,  w6,  w0);
      TEST_3RF_3("fmadd.d", datad,  48, 144, 128, w10, w29, w1);
      TEST_3RF_3("fmadd.d", datad,  48, 144, 144, w31, w15, w3);
      TEST_3RF_3("fmadd.d", datad,  64,   0,   0, w11, w18, w2);
      TEST_3RF_3("fmadd.d", datad,  64,   0,  16, w31, w11, w18);
      TEST_3RF_3("fmadd.d", datad,  64,   0,  32, w1,  w1,  w1);
      TEST_3RF_3("fmadd.d", datad,  64,   0,  48, w22, w16, w8);
      TEST_3RF_3("fmadd.d", datad,  64,   0,  64, w28, w27, w0);
      TEST_3RF_3("fmadd.d", datad,  64,   0,  80, w31, w8,  w16);
      TEST_3RF_3("fmadd.d", datad,  64,   0,  96, w30, w14, w21);
      TEST_3RF_3("fmadd.d", datad,  64,   0, 112, w27, w4,  w4);
      TEST_3RF_3("fmadd.d", datad,  64,   0, 128, w22, w21, w4);
      TEST_3RF_3("fmadd.d", datad,  64,   0, 144, w28, w31, w2);
      TEST_3RF_3("fmadd.d", datad,  64,  16,   0, w30, w17, w1);
      TEST_3RF_3("fmadd.d", datad,  64,  16,  16, w10, w4,  w3);
      TEST_3RF_3("fmadd.d", datad,  64,  16,  32, w9,  w15, w21);
      TEST_3RF_3("fmadd.d", datad,  64,  16,  48, w10, w5,  w6);
      TEST_3RF_3("fmadd.d", datad,  64,  16,  64, w19, w1,  w0);
      TEST_3RF_3("fmadd.d", datad,  64,  16,  80, w9,  w4,  w30);
      TEST_3RF_3("fmadd.d", datad,  64,  16,  96, w23, w25, w28);
      TEST_3RF_3("fmadd.d", datad,  64,  16, 112, w15, w14, w0);
      TEST_3RF_3("fmadd.d", datad,  64,  16, 128, w11, w14, w2);
      TEST_3RF_3("fmadd.d", datad,  64,  16, 144, w9,  w12, w20);
      TEST_3RF_3("fmadd.d", datad,  64,  32,   0, w10, w22, w24);
      TEST_3RF_3("fmadd.d", datad,  64,  32,  16, w13, w31, w7);
      TEST_3RF_3("fmadd.d", datad,  64,  32,  32, w3,  w10, w12);
      TEST_3RF_3("fmadd.d", datad,  64,  32,  48, w9,  w29, w13);
      TEST_3RF_3("fmadd.d", datad,  64,  32,  64, w10, w16, w13);
      TEST_3RF_3("fmadd.d", datad,  64,  32,  80, w19, w20, w12);
      TEST_3RF_3("fmadd.d", datad,  64,  32,  96, w11, w13, w5);
      TEST_3RF_3("fmadd.d", datad,  64,  32, 112, w7,  w28, w20);
      TEST_3RF_3("fmadd.d", datad,  64,  32, 128, w7,  w8,  w2);
      TEST_3RF_3("fmadd.d", datad,  64,  32, 144, w10, w17, w14);
      TEST_3RF_3("fmadd.d", datad,  64,  48,   0, w30, w28, w5);
      TEST_3RF_3("fmadd.d", datad,  64,  48,  16, w22, w9,  w4);
      TEST_3RF_3("fmadd.d", datad,  64,  48,  32, w29, w12, w14);
      TEST_3RF_3("fmadd.d", datad,  64,  48,  48, w9,  w21, w11);
      TEST_3RF_3("fmadd.d", datad,  64,  48,  64, w22, w31, w28);
      TEST_3RF_3("fmadd.d", datad,  64,  48,  80, w3,  w19, w16);
      TEST_3RF_3("fmadd.d", datad,  64,  48,  96, w15, w30, w21);
      TEST_3RF_3("fmadd.d", datad,  64,  48, 112, w5,  w26, w9);
      TEST_3RF_3("fmadd.d", datad,  64,  48, 128, w12, w2,  w11);
      TEST_3RF_3("fmadd.d", datad,  64,  48, 144, w22, w20, w25);
      TEST_3RF_3("fmadd.d", datad,  64,  64,   0, w20, w16, w30);
      TEST_3RF_3("fmadd.d", datad,  64,  64,  16, w10, w25, w3);
      TEST_3RF_3("fmadd.d", datad,  64,  64,  32, w7,  w6,  w17);
      TEST_3RF_3("fmadd.d", datad,  64,  64,  48, w16, w27, w29);
      TEST_3RF_3("fmadd.d", datad,  64,  64,  64, w6,  w27, w25);
      TEST_3RF_3("fmadd.d", datad,  64,  64,  80, w10, w14, w9);
      TEST_3RF_3("fmadd.d", datad,  64,  64,  96, w25, w12, w7);
      TEST_3RF_3("fmadd.d", datad,  64,  64, 112, w14, w17, w2);
      TEST_3RF_3("fmadd.d", datad,  64,  64, 128, w23, w29, w4);
      TEST_3RF_3("fmadd.d", datad,  64,  64, 144, w2,  w20, w24);
      TEST_3RF_3("fmadd.d", datad,  64,  80,   0, w28, w8,  w26);
      TEST_3RF_3("fmadd.d", datad,  64,  80,  16, w19, w2,  w29);
      TEST_3RF_3("fmadd.d", datad,  64,  80,  32, w26, w8,  w15);
      TEST_3RF_3("fmadd.d", datad,  64,  80,  48, w11, w3,  w12);
      TEST_3RF_3("fmadd.d", datad,  64,  80,  64, w17, w30, w5);
      TEST_3RF_3("fmadd.d", datad,  64,  80,  80, w27, w12, w12);
      TEST_3RF_3("fmadd.d", datad,  64,  80,  96, w14, w21, w24);
      TEST_3RF_3("fmadd.d", datad,  64,  80, 112, w22, w3,  w9);
      TEST_3RF_3("fmadd.d", datad,  64,  80, 128, w24, w24, w27);
      TEST_3RF_3("fmadd.d", datad,  64,  80, 144, w7,  w28, w29);
      TEST_3RF_3("fmadd.d", datad,  64,  96,   0, w27, w21, w21);
      TEST_3RF_3("fmadd.d", datad,  64,  96,  16, w25, w3,  w29);
      TEST_3RF_3("fmadd.d", datad,  64,  96,  32, w20, w22, w31);
      TEST_3RF_3("fmadd.d", datad,  64,  96,  48, w17, w7,  w0);
      TEST_3RF_3("fmadd.d", datad,  64,  96,  64, w28, w11, w12);
      TEST_3RF_3("fmadd.d", datad,  64,  96,  80, w13, w9,  w17);
      TEST_3RF_3("fmadd.d", datad,  64,  96,  96, w9,  w22, w0);
      TEST_3RF_3("fmadd.d", datad,  64,  96, 112, w30, w14, w22);
      TEST_3RF_3("fmadd.d", datad,  64,  96, 128, w1,  w1,  w1);
      TEST_3RF_3("fmadd.d", datad,  64,  96, 144, w24, w24, w14);
      TEST_3RF_3("fmadd.d", datad,  64, 112,   0, w28, w31, w10);
      TEST_3RF_3("fmadd.d", datad,  64, 112,  16, w26, w31, w19);
      TEST_3RF_3("fmadd.d", datad,  64, 112,  32, w29, w7,  w20);
      TEST_3RF_3("fmadd.d", datad,  64, 112,  48, w28, w25, w5);
      TEST_3RF_3("fmadd.d", datad,  64, 112,  64, w4,  w25, w1);
      TEST_3RF_3("fmadd.d", datad,  64, 112,  80, w15, w6,  w14);
      TEST_3RF_3("fmadd.d", datad,  64, 112,  96, w24, w24, w23);
      TEST_3RF_3("fmadd.d", datad,  64, 112, 112, w23, w14, w21);
      TEST_3RF_3("fmadd.d", datad,  64, 112, 128, w29, w13, w23);
      TEST_3RF_3("fmadd.d", datad,  64, 112, 144, w21, w27, w19);
      TEST_3RF_3("fmadd.d", datad,  64, 128,   0, w20, w6,  w13);
      TEST_3RF_3("fmadd.d", datad,  64, 128,  16, w14, w5,  w1);
      TEST_3RF_3("fmadd.d", datad,  64, 128,  32, w11, w2,  w8);
      TEST_3RF_3("fmadd.d", datad,  64, 128,  48, w31, w1,  w4);
      TEST_3RF_3("fmadd.d", datad,  64, 128,  64, w3,  w27, w5);
      TEST_3RF_3("fmadd.d", datad,  64, 128,  80, w18, w1,  w20);
      TEST_3RF_3("fmadd.d", datad,  64, 128,  96, w10, w24, w11);
      TEST_3RF_3("fmadd.d", datad,  64, 128, 112, w25, w16, w1);
      TEST_3RF_3("fmadd.d", datad,  64, 128, 128, w22, w29, w24);
      TEST_3RF_3("fmadd.d", datad,  64, 128, 144, w11, w25, w31);
      TEST_3RF_3("fmadd.d", datad,  64, 144,   0, w31, w25, w13);
      TEST_3RF_3("fmadd.d", datad,  64, 144,  16, w4,  w26, w24);
      TEST_3RF_3("fmadd.d", datad,  64, 144,  32, w7,  w2,  w24);
      TEST_3RF_3("fmadd.d", datad,  64, 144,  48, w6,  w4,  w28);
      TEST_3RF_3("fmadd.d", datad,  64, 144,  64, w9,  w31, w2);
      TEST_3RF_3("fmadd.d", datad,  64, 144,  80, w27, w0,  w0);
      TEST_3RF_3("fmadd.d", datad,  64, 144,  96, w22, w5,  w24);
      TEST_3RF_3("fmadd.d", datad,  64, 144, 112, w1,  w1,  w1);
      TEST_3RF_3("fmadd.d", datad,  64, 144, 128, w30, w8,  w2);
      TEST_3RF_3("fmadd.d", datad,  64, 144, 144, w20, w6,  w26);
      TEST_3RF_3("fmadd.d", datad,  80,   0,   0, w31, w6,  w30);
      TEST_3RF_3("fmadd.d", datad,  80,   0,  16, w30, w31, w11);
      TEST_3RF_3("fmadd.d", datad,  80,   0,  32, w2,  w25, w4);
      TEST_3RF_3("fmadd.d", datad,  80,   0,  48, w9,  w27, w28);
      TEST_3RF_3("fmadd.d", datad,  80,   0,  64, w15, w31, w24);
      TEST_3RF_3("fmadd.d", datad,  80,   0,  80, w24, w24, w30);
      TEST_3RF_3("fmadd.d", datad,  80,   0,  96, w26, w19, w30);
      TEST_3RF_3("fmadd.d", datad,  80,   0, 112, w16, w25, w23);
      TEST_3RF_3("fmadd.d", datad,  80,   0, 128, w18, w23, w31);
      TEST_3RF_3("fmadd.d", datad,  80,   0, 144, w20, w12, w5);
      TEST_3RF_3("fmadd.d", datad,  80,  16,   0, w15, w11, w4);
      TEST_3RF_3("fmadd.d", datad,  80,  16,  16, w21, w10, w2);
      TEST_3RF_3("fmadd.d", datad,  80,  16,  32, w20, w21, w5);
      TEST_3RF_3("fmadd.d", datad,  80,  16,  48, w13, w25, w14);
      TEST_3RF_3("fmadd.d", datad,  80,  16,  64, w8,  w21, w30);
      TEST_3RF_3("fmadd.d", datad,  80,  16,  80, w8,  w14, w22);
      TEST_3RF_3("fmadd.d", datad,  80,  16,  96, w6,  w8,  w10);
      TEST_3RF_3("fmadd.d", datad,  80,  16, 112, w5,  w25, w3);
      TEST_3RF_3("fmadd.d", datad,  80,  16, 128, w28, w11, w26);
      TEST_3RF_3("fmadd.d", datad,  80,  16, 144, w27, w31, w31);
      TEST_3RF_3("fmadd.d", datad,  80,  32,   0, w6,  w1,  w14);
      TEST_3RF_3("fmadd.d", datad,  80,  32,  16, w18, w5,  w3);
      TEST_3RF_3("fmadd.d", datad,  80,  32,  32, w28, w8,  w23);
      TEST_3RF_3("fmadd.d", datad,  80,  32,  48, w17, w13, w4);
      TEST_3RF_3("fmadd.d", datad,  80,  32,  64, w11, w27, w13);
      TEST_3RF_3("fmadd.d", datad,  80,  32,  80, w0,  w25, w0);
      TEST_3RF_3("fmadd.d", datad,  80,  32,  96, w21, w14, w16);
      TEST_3RF_3("fmadd.d", datad,  80,  32, 112, w27, w23, w23);
      TEST_3RF_3("fmadd.d", datad,  80,  32, 128, w26, w0,  w16);
      TEST_3RF_3("fmadd.d", datad,  80,  32, 144, w29, w28, w27);
      TEST_3RF_3("fmadd.d", datad,  80,  48,   0, w23, w24, w26);
      TEST_3RF_3("fmadd.d", datad,  80,  48,  16, w30, w25, w9);
      TEST_3RF_3("fmadd.d", datad,  80,  48,  32, w16, w30, w12);
      TEST_3RF_3("fmadd.d", datad,  80,  48,  48, w12, w6,  w4);
      TEST_3RF_3("fmadd.d", datad,  80,  48,  64, w29, w19, w8);
      TEST_3RF_3("fmadd.d", datad,  80,  48,  80, w8,  w15, w21);
      TEST_3RF_3("fmadd.d", datad,  80,  48,  96, w9,  w8,  w10);
      TEST_3RF_3("fmadd.d", datad,  80,  48, 112, w23, w24, w6);
      TEST_3RF_3("fmadd.d", datad,  80,  48, 128, w14, w18, w6);
      TEST_3RF_3("fmadd.d", datad,  80,  48, 144, w30, w15, w3);
      TEST_3RF_3("fmadd.d", datad,  80,  64,   0, w25, w7,  w27);
      TEST_3RF_3("fmadd.d", datad,  80,  64,  16, w20, w5,  w29);
      TEST_3RF_3("fmadd.d", datad,  80,  64,  32, w21, w18, w9);
      TEST_3RF_3("fmadd.d", datad,  80,  64,  48, w1,  w1,  w1);
      TEST_3RF_3("fmadd.d", datad,  80,  64,  64, w25, w13, w30);
      TEST_3RF_3("fmadd.d", datad,  80,  64,  80, w12, w22, w7);
      TEST_3RF_3("fmadd.d", datad,  80,  64,  96, w27, w11, w11);
      TEST_3RF_3("fmadd.d", datad,  80,  64, 112, w16, w4,  w22);
      TEST_3RF_3("fmadd.d", datad,  80,  64, 128, w7,  w28, w22);
      TEST_3RF_3("fmadd.d", datad,  80,  64, 144, w15, w2,  w20);
      TEST_3RF_3("fmadd.d", datad,  80,  80,   0, w30, w5,  w14);
      TEST_3RF_3("fmadd.d", datad,  80,  80,  16, w5,  w0,  w2);
      TEST_3RF_3("fmadd.d", datad,  80,  80,  32, w10, w20, w31);
      TEST_3RF_3("fmadd.d", datad,  80,  80,  48, w31, w7,  w8);
      TEST_3RF_3("fmadd.d", datad,  80,  80,  64, w0,  w22, w0);
      TEST_3RF_3("fmadd.d", datad,  80,  80,  80, w31, w12, w6);
      TEST_3RF_3("fmadd.d", datad,  80,  80,  96, w8,  w23, w22);
      TEST_3RF_3("fmadd.d", datad,  80,  80, 112, w12, w13, w29);
      TEST_3RF_3("fmadd.d", datad,  80,  80, 128, w8,  w9,  w19);
      TEST_3RF_3("fmadd.d", datad,  80,  80, 144, w23, w12, w8);
      TEST_3RF_3("fmadd.d", datad,  80,  96,   0, w22, w17, w27);
      TEST_3RF_3("fmadd.d", datad,  80,  96,  16, w18, w24, w6);
      TEST_3RF_3("fmadd.d", datad,  80,  96,  32, w6,  w23, w5);
      TEST_3RF_3("fmadd.d", datad,  80,  96,  48, w13, w31, w6);
      TEST_3RF_3("fmadd.d", datad,  80,  96,  64, w13, w21, w5);
      TEST_3RF_3("fmadd.d", datad,  80,  96,  80, w26, w1,  w11);
      TEST_3RF_3("fmadd.d", datad,  80,  96,  96, w2,  w25, w1);
      TEST_3RF_3("fmadd.d", datad,  80,  96, 112, w14, w6,  w30);
      TEST_3RF_3("fmadd.d", datad,  80,  96, 128, w22, w16, w18);
      TEST_3RF_3("fmadd.d", datad,  80,  96, 144, w14, w28, w26);
      TEST_3RF_3("fmadd.d", datad,  80, 112,   0, w4,  w13, w16);
      TEST_3RF_3("fmadd.d", datad,  80, 112,  16, w31, w8,  w5);
      TEST_3RF_3("fmadd.d", datad,  80, 112,  32, w6,  w31, w11);
      TEST_3RF_3("fmadd.d", datad,  80, 112,  48, w19, w30, w17);
      TEST_3RF_3("fmadd.d", datad,  80, 112,  64, w1,  w1,  w1);
      TEST_3RF_3("fmadd.d", datad,  80, 112,  80, w20, w22, w27);
      TEST_3RF_3("fmadd.d", datad,  80, 112,  96, w21, w1,  w29);
      TEST_3RF_3("fmadd.d", datad,  80, 112, 112, w14, w2,  w11);
      TEST_3RF_3("fmadd.d", datad,  80, 112, 128, w21, w0,  w1);
      TEST_3RF_3("fmadd.d", datad,  80, 112, 144, w5,  w18, w15);
      TEST_3RF_3("fmadd.d", datad,  80, 128,   0, w1,  w1,  w1);
      TEST_3RF_3("fmadd.d", datad,  80, 128,  16, w12, w19, w14);
      TEST_3RF_3("fmadd.d", datad,  80, 128,  32, w28, w19, w14);
      TEST_3RF_3("fmadd.d", datad,  80, 128,  48, w4,  w24, w20);
      TEST_3RF_3("fmadd.d", datad,  80, 128,  64, w3,  w7,  w2);
      TEST_3RF_3("fmadd.d", datad,  80, 128,  80, w20, w8,  w22);
      TEST_3RF_3("fmadd.d", datad,  80, 128,  96, w10, w3,  w11);
      TEST_3RF_3("fmadd.d", datad,  80, 128, 112, w11, w0,  w26);
      TEST_3RF_3("fmadd.d", datad,  80, 128, 128, w13, w11, w15);
      TEST_3RF_3("fmadd.d", datad,  80, 128, 144, w14, w13, w20);
      TEST_3RF_3("fmadd.d", datad,  80, 144,   0, w0,  w28, w0);
      TEST_3RF_3("fmadd.d", datad,  80, 144,  16, w21, w13, w16);
      TEST_3RF_3("fmadd.d", datad,  80, 144,  32, w3,  w9,  w17);
      TEST_3RF_3("fmadd.d", datad,  80, 144,  48, w14, w27, w5);
      TEST_3RF_3("fmadd.d", datad,  80, 144,  64, w17, w31, w13);
      TEST_3RF_3("fmadd.d", datad,  80, 144,  80, w19, w21, w9);
      TEST_3RF_3("fmadd.d", datad,  80, 144,  96, w30, w25, w21);
      TEST_3RF_3("fmadd.d", datad,  80, 144, 112, w9,  w25, w15);
      TEST_3RF_3("fmadd.d", datad,  80, 144, 128, w23, w5,  w30);
      TEST_3RF_3("fmadd.d", datad,  80, 144, 144, w5,  w18, w14);
      TEST_3RF_3("fmadd.d", datad,  96,   0,   0, w7,  w18, w30);
      TEST_3RF_3("fmadd.d", datad,  96,   0,  16, w10, w28, w1);
      TEST_3RF_3("fmadd.d", datad,  96,   0,  32, w28, w10, w29);
      TEST_3RF_3("fmadd.d", datad,  96,   0,  48, w1,  w1,  w1);
      TEST_3RF_3("fmadd.d", datad,  96,   0,  64, w27, w28, w28);
      TEST_3RF_3("fmadd.d", datad,  96,   0,  80, w14, w15, w4);
      TEST_3RF_3("fmadd.d", datad,  96,   0,  96, w24, w24, w13);
      TEST_3RF_3("fmadd.d", datad,  96,   0, 112, w29, w13, w23);
      TEST_3RF_3("fmadd.d", datad,  96,   0, 128, w22, w28, w14);
      TEST_3RF_3("fmadd.d", datad,  96,   0, 144, w27, w26, w26);
      TEST_3RF_3("fmadd.d", datad,  96,  16,   0, w19, w13, w12);
      TEST_3RF_3("fmadd.d", datad,  96,  16,  16, w24, w24, w28);
      TEST_3RF_3("fmadd.d", datad,  96,  16,  32, w19, w11, w26);
      TEST_3RF_3("fmadd.d", datad,  96,  16,  48, w30, w7,  w28);
      TEST_3RF_3("fmadd.d", datad,  96,  16,  64, w26, w17, w25);
      TEST_3RF_3("fmadd.d", datad,  96,  16,  80, w27, w12, w12);
      TEST_3RF_3("fmadd.d", datad,  96,  16,  96, w21, w10, w27);
      TEST_3RF_3("fmadd.d", datad,  96,  16, 112, w4,  w14, w20);
      TEST_3RF_3("fmadd.d", datad,  96,  16, 128, w18, w11, w1);
      TEST_3RF_3("fmadd.d", datad,  96,  16, 144, w9,  w1,  w30);
      TEST_3RF_3("fmadd.d", datad,  96,  32,   0, w23, w29, w24);
      TEST_3RF_3("fmadd.d", datad,  96,  32,  16, w10, w5,  w2);
      TEST_3RF_3("fmadd.d", datad,  96,  32,  32, w6,  w24, w13);
      TEST_3RF_3("fmadd.d", datad,  96,  32,  48, w1,  w1,  w1);
      TEST_3RF_3("fmadd.d", datad,  96,  32,  64, w22, w20, w29);
      TEST_3RF_3("fmadd.d", datad,  96,  32,  80, w16, w5,  w22);
      TEST_3RF_3("fmadd.d", datad,  96,  32,  96, w12, w18, w11);
      TEST_3RF_3("fmadd.d", datad,  96,  32, 112, w22, w13, w15);
      TEST_3RF_3("fmadd.d", datad,  96,  32, 128, w4,  w1,  w15);
      TEST_3RF_3("fmadd.d", datad,  96,  32, 144, w3,  w10, w16);
      TEST_3RF_3("fmadd.d", datad,  96,  48,   0, w1,  w1,  w1);
      TEST_3RF_3("fmadd.d", datad,  96,  48,  16, w1,  w1,  w1);
      TEST_3RF_3("fmadd.d", datad,  96,  48,  32, w13, w25, w11);
      TEST_3RF_3("fmadd.d", datad,  96,  48,  48, w24, w24, w30);
      TEST_3RF_3("fmadd.d", datad,  96,  48,  64, w14, w30, w23);
      TEST_3RF_3("fmadd.d", datad,  96,  48,  80, w27, w31, w31);
      TEST_3RF_3("fmadd.d", datad,  96,  48,  96, w13, w16, w28);
      TEST_3RF_3("fmadd.d", datad,  96,  48, 112, w30, w21, w18);
      TEST_3RF_3("fmadd.d", datad,  96,  48, 128, w10, w7,  w29);
      TEST_3RF_3("fmadd.d", datad,  96,  48, 144, w0,  w21, w0);
      TEST_3RF_3("fmadd.d", datad,  96,  64,   0, w13, w4,  w22);
      TEST_3RF_3("fmadd.d", datad,  96,  64,  16, w14, w19, w25);
      TEST_3RF_3("fmadd.d", datad,  96,  64,  32, w25, w3,  w26);
      TEST_3RF_3("fmadd.d", datad,  96,  64,  48, w26, w17, w20);
      TEST_3RF_3("fmadd.d", datad,  96,  64,  64, w6,  w9,  w18);
      TEST_3RF_3("fmadd.d", datad,  96,  64,  80, w20, w7,  w9);
      TEST_3RF_3("fmadd.d", datad,  96,  64,  96, w15, w7,  w23);
      TEST_3RF_3("fmadd.d", datad,  96,  64, 112, w31, w3,  w21);
      TEST_3RF_3("fmadd.d", datad,  96,  64, 128, w21, w22, w31);
      TEST_3RF_3("fmadd.d", datad,  96,  64, 144, w28, w19, w31);
      TEST_3RF_3("fmadd.d", datad,  96,  80,   0, w17, w0,  w3);
      TEST_3RF_3("fmadd.d", datad,  96,  80,  16, w8,  w15, w22);
      TEST_3RF_3("fmadd.d", datad,  96,  80,  32, w1,  w1,  w1);
      TEST_3RF_3("fmadd.d", datad,  96,  80,  48, w8,  w25, w28);
      TEST_3RF_3("fmadd.d", datad,  96,  80,  64, w2,  w10, w16);
      TEST_3RF_3("fmadd.d", datad,  96,  80,  80, w8,  w19, w2);
      TEST_3RF_3("fmadd.d", datad,  96,  80,  96, w28, w27, w12);
      TEST_3RF_3("fmadd.d", datad,  96,  80, 112, w12, w2,  w3);
      TEST_3RF_3("fmadd.d", datad,  96,  80, 128, w11, w5,  w24);
      TEST_3RF_3("fmadd.d", datad,  96,  80, 144, w0,  w27, w0);
      TEST_3RF_3("fmadd.d", datad,  96,  96,   0, w23, w29, w15);
      TEST_3RF_3("fmadd.d", datad,  96,  96,  16, w22, w14, w15);
      TEST_3RF_3("fmadd.d", datad,  96,  96,  32, w25, w22, w30);
      TEST_3RF_3("fmadd.d", datad,  96,  96,  48, w15, w24, w6);
      TEST_3RF_3("fmadd.d", datad,  96,  96,  64, w8,  w20, w9);
      TEST_3RF_3("fmadd.d", datad,  96,  96,  80, w19, w4,  w17);
      TEST_3RF_3("fmadd.d", datad,  96,  96,  96, w6,  w14, w1);
      TEST_3RF_3("fmadd.d", datad,  96,  96, 112, w18, w26, w3);
      TEST_3RF_3("fmadd.d", datad,  96,  96, 128, w21, w5,  w9);
      TEST_3RF_3("fmadd.d", datad,  96,  96, 144, w13, w6,  w4);
      TEST_3RF_3("fmadd.d", datad,  96, 112,   0, w4,  w3,  w19);
      TEST_3RF_3("fmadd.d", datad,  96, 112,  16, w26, w17, w3);
      TEST_3RF_3("fmadd.d", datad,  96, 112,  32, w19, w8,  w1);
      TEST_3RF_3("fmadd.d", datad,  96, 112,  48, w2,  w0,  w8);
      TEST_3RF_3("fmadd.d", datad,  96, 112,  64, w11, w20, w17);
      TEST_3RF_3("fmadd.d", datad,  96, 112,  80, w30, w24, w2);
      TEST_3RF_3("fmadd.d", datad,  96, 112,  96, w4,  w30, w16);
      TEST_3RF_3("fmadd.d", datad,  96, 112, 112, w6,  w17, w10);
      TEST_3RF_3("fmadd.d", datad,  96, 112, 128, w9,  w6,  w16);
      TEST_3RF_3("fmadd.d", datad,  96, 112, 144, w18, w20, w22);
      TEST_3RF_3("fmadd.d", datad,  96, 128,   0, w23, w24, w25);
      TEST_3RF_3("fmadd.d", datad,  96, 128,  16, w10, w19, w13);
      TEST_3RF_3("fmadd.d", datad,  96, 128,  32, w6,  w18, w15);
      TEST_3RF_3("fmadd.d", datad,  96, 128,  48, w9,  w18, w23);
      TEST_3RF_3("fmadd.d", datad,  96, 128,  64, w20, w6,  w8);
      TEST_3RF_3("fmadd.d", datad,  96, 128,  80, w18, w30, w10);
      TEST_3RF_3("fmadd.d", datad,  96, 128,  96, w22, w29, w27);
      TEST_3RF_3("fmadd.d", datad,  96, 128, 112, w28, w14, w5);
      TEST_3RF_3("fmadd.d", datad,  96, 128, 128, w6,  w20, w21);
      TEST_3RF_3("fmadd.d", datad,  96, 128, 144, w24, w24, w8);
      TEST_3RF_3("fmadd.d", datad,  96, 144,   0, w11, w15, w1);
      TEST_3RF_3("fmadd.d", datad,  96, 144,  16, w4,  w26, w20);
      TEST_3RF_3("fmadd.d", datad,  96, 144,  32, w15, w7,  w26);
      TEST_3RF_3("fmadd.d", datad,  96, 144,  48, w1,  w1,  w1);
      TEST_3RF_3("fmadd.d", datad,  96, 144,  64, w22, w3,  w20);
      TEST_3RF_3("fmadd.d", datad,  96, 144,  80, w13, w23, w26);
      TEST_3RF_3("fmadd.d", datad,  96, 144,  96, w21, w9,  w25);
      TEST_3RF_3("fmadd.d", datad,  96, 144, 112, w0,  w22, w0);
      TEST_3RF_3("fmadd.d", datad,  96, 144, 128, w27, w28, w28);
      TEST_3RF_3("fmadd.d", datad,  96, 144, 144, w4,  w0,  w2);
      TEST_3RF_3("fmadd.d", datad, 112,   0,   0, w24, w24, w22);
      TEST_3RF_3("fmadd.d", datad, 112,   0,  16, w27, w1,  w1);
      TEST_3RF_3("fmadd.d", datad, 112,   0,  32, w1,  w1,  w1);
      TEST_3RF_3("fmadd.d", datad, 112,   0,  48, w10, w2,  w6);
      TEST_3RF_3("fmadd.d", datad, 112,   0,  64, w4,  w22, w21);
      TEST_3RF_3("fmadd.d", datad, 112,   0,  80, w12, w16, w22);
      TEST_3RF_3("fmadd.d", datad, 112,   0,  96, w2,  w20, w10);
      TEST_3RF_3("fmadd.d", datad, 112,   0, 112, w16, w11, w5);
      TEST_3RF_3("fmadd.d", datad, 112,   0, 128, w5,  w21, w30);
      TEST_3RF_3("fmadd.d", datad, 112,   0, 144, w5,  w21, w20);
      TEST_3RF_3("fmadd.d", datad, 112,  16,   0, w0,  w17, w0);
      TEST_3RF_3("fmadd.d", datad, 112,  16,  16, w24, w24, w1);
      TEST_3RF_3("fmadd.d", datad, 112,  16,  32, w20, w16, w23);
      TEST_3RF_3("fmadd.d", datad, 112,  16,  48, w15, w17, w24);
      TEST_3RF_3("fmadd.d", datad, 112,  16,  64, w25, w19, w30);
      TEST_3RF_3("fmadd.d", datad, 112,  16,  80, w30, w9,  w19);
      TEST_3RF_3("fmadd.d", datad, 112,  16,  96, w10, w26, w12);
      TEST_3RF_3("fmadd.d", datad, 112,  16, 112, w14, w20, w28);
      TEST_3RF_3("fmadd.d", datad, 112,  16, 128, w25, w2,  w14);
      TEST_3RF_3("fmadd.d", datad, 112,  16, 144, w23, w7,  w3);
      TEST_3RF_3("fmadd.d", datad, 112,  32,   0, w11, w8,  w21);
      TEST_3RF_3("fmadd.d", datad, 112,  32,  16, w3,  w9,  w20);
      TEST_3RF_3("fmadd.d", datad, 112,  32,  32, w0,  w24, w0);
      TEST_3RF_3("fmadd.d", datad, 112,  32,  48, w5,  w24, w17);
      TEST_3RF_3("fmadd.d", datad, 112,  32,  64, w25, w23, w15);
      TEST_3RF_3("fmadd.d", datad, 112,  32,  80, w2,  w10, w25);
      TEST_3RF_3("fmadd.d", datad, 112,  32,  96, w28, w20, w6);
      TEST_3RF_3("fmadd.d", datad, 112,  32, 112, w10, w9,  w2);
      TEST_3RF_3("fmadd.d", datad, 112,  32, 128, w4,  w2,  w18);
      TEST_3RF_3("fmadd.d", datad, 112,  32, 144, w26, w12, w22);
      TEST_3RF_3("fmadd.d", datad, 112,  48,   0, w5,  w20, w11);
      TEST_3RF_3("fmadd.d", datad, 112,  48,  16, w9,  w29, w20);
      TEST_3RF_3("fmadd.d", datad, 112,  48,  32, w29, w12, w2);
      TEST_3RF_3("fmadd.d", datad, 112,  48,  48, w21, w29, w27);
      TEST_3RF_3("fmadd.d", datad, 112,  48,  64, w12, w13, w30);
      TEST_3RF_3("fmadd.d", datad, 112,  48,  80, w23, w6,  w26);
      TEST_3RF_3("fmadd.d", datad, 112,  48,  96, w11, w12, w5);
      TEST_3RF_3("fmadd.d", datad, 112,  48, 112, w20, w15, w9);
      TEST_3RF_3("fmadd.d", datad, 112,  48, 128, w23, w19, w27);
      TEST_3RF_3("fmadd.d", datad, 112,  48, 144, w17, w31, w22);
      TEST_3RF_3("fmadd.d", datad, 112,  64,   0, w19, w28, w31);
      TEST_3RF_3("fmadd.d", datad, 112,  64,  16, w16, w28, w13);
      TEST_3RF_3("fmadd.d", datad, 112,  64,  32, w28, w31, w3);
      TEST_3RF_3("fmadd.d", datad, 112,  64,  48, w26, w15, w7);
      TEST_3RF_3("fmadd.d", datad, 112,  64,  64, w24, w24, w6);
      TEST_3RF_3("fmadd.d", datad, 112,  64,  80, w13, w19, w18);
      TEST_3RF_3("fmadd.d", datad, 112,  64,  96, w26, w24, w6);
      TEST_3RF_3("fmadd.d", datad, 112,  64, 112, w9,  w1,  w29);
      TEST_3RF_3("fmadd.d", datad, 112,  64, 128, w28, w14, w5);
      TEST_3RF_3("fmadd.d", datad, 112,  64, 144, w15, w10, w4);
      TEST_3RF_3("fmadd.d", datad, 112,  80,   0, w0,  w27, w0);
      TEST_3RF_3("fmadd.d", datad, 112,  80,  16, w1,  w1,  w1);
      TEST_3RF_3("fmadd.d", datad, 112,  80,  32, w13, w23, w0);
      TEST_3RF_3("fmadd.d", datad, 112,  80,  48, w16, w17, w26);
      TEST_3RF_3("fmadd.d", datad, 112,  80,  64, w0,  w24, w0);
      TEST_3RF_3("fmadd.d", datad, 112,  80,  80, w19, w6,  w24);
      TEST_3RF_3("fmadd.d", datad, 112,  80,  96, w0,  w30, w0);
      TEST_3RF_3("fmadd.d", datad, 112,  80, 112, w31, w9,  w28);
      TEST_3RF_3("fmadd.d", datad, 112,  80, 128, w5,  w27, w11);
      TEST_3RF_3("fmadd.d", datad, 112,  80, 144, w1,  w1,  w1);
      TEST_3RF_3("fmadd.d", datad, 112,  96,   0, w9,  w16, w17);
      TEST_3RF_3("fmadd.d", datad, 112,  96,  16, w20, w17, w15);
      TEST_3RF_3("fmadd.d", datad, 112,  96,  32, w21, w30, w6);
      TEST_3RF_3("fmadd.d", datad, 112,  96,  48, w21, w15, w24);
      TEST_3RF_3("fmadd.d", datad, 112,  96,  64, w16, w15, w3);
      TEST_3RF_3("fmadd.d", datad, 112,  96,  80, w21, w22, w9);
      TEST_3RF_3("fmadd.d", datad, 112,  96,  96, w14, w22, w7);
      TEST_3RF_3("fmadd.d", datad, 112,  96, 112, w13, w31, w6);
      TEST_3RF_3("fmadd.d", datad, 112,  96, 128, w9,  w5,  w1);
      TEST_3RF_3("fmadd.d", datad, 112,  96, 144, w20, w6,  w11);
      TEST_3RF_3("fmadd.d", datad, 112, 112,   0, w4,  w23, w31);
      TEST_3RF_3("fmadd.d", datad, 112, 112,  16, w25, w8,  w14);
      TEST_3RF_3("fmadd.d", datad, 112, 112,  32, w14, w7,  w20);
      TEST_3RF_3("fmadd.d", datad, 112, 112,  48, w4,  w22, w12);
      TEST_3RF_3("fmadd.d", datad, 112, 112,  64, w20, w5,  w29);
      TEST_3RF_3("fmadd.d", datad, 112, 112,  80, w23, w26, w19);
      TEST_3RF_3("fmadd.d", datad, 112, 112,  96, w0,  w8,  w0);
      TEST_3RF_3("fmadd.d", datad, 112, 112, 112, w10, w7,  w21);
      TEST_3RF_3("fmadd.d", datad, 112, 112, 128, w9,  w13, w31);
      TEST_3RF_3("fmadd.d", datad, 112, 112, 144, w14, w19, w21);
      TEST_3RF_3("fmadd.d", datad, 112, 128,   0, w25, w24, w12);
      TEST_3RF_3("fmadd.d", datad, 112, 128,  16, w24, w24, w17);
      TEST_3RF_3("fmadd.d", datad, 112, 128,  32, w21, w6,  w31);
      TEST_3RF_3("fmadd.d", datad, 112, 128,  48, w28, w27, w3);
      TEST_3RF_3("fmadd.d", datad, 112, 128,  64, w18, w7,  w23);
      TEST_3RF_3("fmadd.d", datad, 112, 128,  80, w23, w4,  w14);
      TEST_3RF_3("fmadd.d", datad, 112, 128,  96, w17, w24, w14);
      TEST_3RF_3("fmadd.d", datad, 112, 128, 112, w26, w2,  w21);
      TEST_3RF_3("fmadd.d", datad, 112, 128, 128, w15, w11, w2);
      TEST_3RF_3("fmadd.d", datad, 112, 128, 144, w14, w26, w17);
      TEST_3RF_3("fmadd.d", datad, 112, 144,   0, w2,  w15, w10);
      TEST_3RF_3("fmadd.d", datad, 112, 144,  16, w26, w27, w3);
      TEST_3RF_3("fmadd.d", datad, 112, 144,  32, w11, w16, w9);
      TEST_3RF_3("fmadd.d", datad, 112, 144,  48, w10, w12, w4);
      TEST_3RF_3("fmadd.d", datad, 112, 144,  64, w14, w30, w12);
      TEST_3RF_3("fmadd.d", datad, 112, 144,  80, w5,  w21, w16);
      TEST_3RF_3("fmadd.d", datad, 112, 144,  96, w20, w7,  w8);
      TEST_3RF_3("fmadd.d", datad, 112, 144, 112, w2,  w1,  w10);
      TEST_3RF_3("fmadd.d", datad, 112, 144, 128, w24, w24, w16);
      TEST_3RF_3("fmadd.d", datad, 112, 144, 144, w22, w26, w31);
      TEST_3RF_3("fmadd.d", datad, 128,   0,   0, w16, w11, w1);
      TEST_3RF_3("fmadd.d", datad, 128,   0,  16, w31, w22, w27);
      TEST_3RF_3("fmadd.d", datad, 128,   0,  32, w26, w25, w6);
      TEST_3RF_3("fmadd.d", datad, 128,   0,  48, w11, w2,  w16);
      TEST_3RF_3("fmadd.d", datad, 128,   0,  64, w23, w7,  w30);
      TEST_3RF_3("fmadd.d", datad, 128,   0,  80, w22, w19, w4);
      TEST_3RF_3("fmadd.d", datad, 128,   0,  96, w11, w3,  w24);
      TEST_3RF_3("fmadd.d", datad, 128,   0, 112, w18, w12, w26);
      TEST_3RF_3("fmadd.d", datad, 128,   0, 128, w19, w22, w18);
      TEST_3RF_3("fmadd.d", datad, 128,   0, 144, w4,  w12, w13);
      TEST_3RF_3("fmadd.d", datad, 128,  16,   0, w3,  w28, w24);
      TEST_3RF_3("fmadd.d", datad, 128,  16,  16, w4,  w27, w14);
      TEST_3RF_3("fmadd.d", datad, 128,  16,  32, w31, w22, w7);
      TEST_3RF_3("fmadd.d", datad, 128,  16,  48, w5,  w1,  w10);
      TEST_3RF_3("fmadd.d", datad, 128,  16,  64, w21, w24, w17);
      TEST_3RF_3("fmadd.d", datad, 128,  16,  80, w20, w14, w4);
      TEST_3RF_3("fmadd.d", datad, 128,  16,  96, w24, w24, w26);
      TEST_3RF_3("fmadd.d", datad, 128,  16, 112, w7,  w16, w12);
      TEST_3RF_3("fmadd.d", datad, 128,  16, 128, w19, w10, w0);
      TEST_3RF_3("fmadd.d", datad, 128,  16, 144, w10, w29, w4);
      TEST_3RF_3("fmadd.d", datad, 128,  32,   0, w22, w10, w7);
      TEST_3RF_3("fmadd.d", datad, 128,  32,  16, w19, w2,  w11);
      TEST_3RF_3("fmadd.d", datad, 128,  32,  32, w14, w17, w10);
      TEST_3RF_3("fmadd.d", datad, 128,  32,  48, w4,  w24, w15);
      TEST_3RF_3("fmadd.d", datad, 128,  32,  64, w5,  w2,  w4);
      TEST_3RF_3("fmadd.d", datad, 128,  32,  80, w30, w19, w24);
      TEST_3RF_3("fmadd.d", datad, 128,  32,  96, w12, w23, w16);
      TEST_3RF_3("fmadd.d", datad, 128,  32, 112, w6,  w31, w0);
      TEST_3RF_3("fmadd.d", datad, 128,  32, 128, w19, w18, w11);
      TEST_3RF_3("fmadd.d", datad, 128,  32, 144, w19, w28, w8);
      TEST_3RF_3("fmadd.d", datad, 128,  48,   0, w23, w19, w18);
      TEST_3RF_3("fmadd.d", datad, 128,  48,  16, w30, w6,  w20);
      TEST_3RF_3("fmadd.d", datad, 128,  48,  32, w9,  w20, w5);
      TEST_3RF_3("fmadd.d", datad, 128,  48,  48, w19, w25, w30);
      TEST_3RF_3("fmadd.d", datad, 128,  48,  64, w2,  w30, w0);
      TEST_3RF_3("fmadd.d", datad, 128,  48,  80, w6,  w28, w20);
      TEST_3RF_3("fmadd.d", datad, 128,  48,  96, w31, w9,  w11);
      TEST_3RF_3("fmadd.d", datad, 128,  48, 112, w15, w10, w16);
      TEST_3RF_3("fmadd.d", datad, 128,  48, 128, w2,  w29, w27);
      TEST_3RF_3("fmadd.d", datad, 128,  48, 144, w21, w25, w3);
      TEST_3RF_3("fmadd.d", datad, 128,  64,   0, w12, w21, w10);
      TEST_3RF_3("fmadd.d", datad, 128,  64,  16, w18, w9,  w19);
      TEST_3RF_3("fmadd.d", datad, 128,  64,  32, w7,  w15, w6);
      TEST_3RF_3("fmadd.d", datad, 128,  64,  48, w0,  w13, w0);
      TEST_3RF_3("fmadd.d", datad, 128,  64,  64, w8,  w30, w13);
      TEST_3RF_3("fmadd.d", datad, 128,  64,  80, w15, w27, w1);
      TEST_3RF_3("fmadd.d", datad, 128,  64,  96, w14, w4,  w13);
      TEST_3RF_3("fmadd.d", datad, 128,  64, 112, w29, w19, w23);
      TEST_3RF_3("fmadd.d", datad, 128,  64, 128, w13, w22, w20);
      TEST_3RF_3("fmadd.d", datad, 128,  64, 144, w8,  w11, w14);
      TEST_3RF_3("fmadd.d", datad, 128,  80,   0, w11, w24, w26);
      TEST_3RF_3("fmadd.d", datad, 128,  80,  16, w0,  w2,  w0);
      TEST_3RF_3("fmadd.d", datad, 128,  80,  32, w13, w10, w22);
      TEST_3RF_3("fmadd.d", datad, 128,  80,  48, w20, w25, w28);
      TEST_3RF_3("fmadd.d", datad, 128,  80,  64, w20, w6,  w5);
      TEST_3RF_3("fmadd.d", datad, 128,  80,  80, w18, w19, w20);
      TEST_3RF_3("fmadd.d", datad, 128,  80,  96, w13, w21, w2);
      TEST_3RF_3("fmadd.d", datad, 128,  80, 112, w17, w2,  w31);
      TEST_3RF_3("fmadd.d", datad, 128,  80, 128, w5,  w25, w13);
      TEST_3RF_3("fmadd.d", datad, 128,  80, 144, w27, w14, w14);
      TEST_3RF_3("fmadd.d", datad, 128,  96,   0, w21, w6,  w28);
      TEST_3RF_3("fmadd.d", datad, 128,  96,  16, w1,  w1,  w1);
      TEST_3RF_3("fmadd.d", datad, 128,  96,  32, w30, w22, w1);
      TEST_3RF_3("fmadd.d", datad, 128,  96,  48, w1,  w1,  w1);
      TEST_3RF_3("fmadd.d", datad, 128,  96,  64, w3,  w11, w23);
      TEST_3RF_3("fmadd.d", datad, 128,  96,  80, w23, w4,  w19);
      TEST_3RF_3("fmadd.d", datad, 128,  96,  96, w11, w10, w24);
      TEST_3RF_3("fmadd.d", datad, 128,  96, 112, w30, w12, w11);
      TEST_3RF_3("fmadd.d", datad, 128,  96, 128, w19, w14, w29);
      TEST_3RF_3("fmadd.d", datad, 128,  96, 144, w21, w14, w2);
      TEST_3RF_3("fmadd.d", datad, 128, 112,   0, w14, w27, w29);
      TEST_3RF_3("fmadd.d", datad, 128, 112,  16, w28, w16, w3);
      TEST_3RF_3("fmadd.d", datad, 128, 112,  32, w24, w24, w17);
      TEST_3RF_3("fmadd.d", datad, 128, 112,  48, w2,  w15, w19);
      TEST_3RF_3("fmadd.d", datad, 128, 112,  64, w3,  w18, w30);
      TEST_3RF_3("fmadd.d", datad, 128, 112,  80, w26, w10, w3);
      TEST_3RF_3("fmadd.d", datad, 128, 112,  96, w13, w21, w6);
      TEST_3RF_3("fmadd.d", datad, 128, 112, 112, w19, w11, w18);
      TEST_3RF_3("fmadd.d", datad, 128, 112, 128, w31, w30, w1);
      TEST_3RF_3("fmadd.d", datad, 128, 112, 144, w28, w19, w15);
      TEST_3RF_3("fmadd.d", datad, 128, 128,   0, w30, w2,  w10);
      TEST_3RF_3("fmadd.d", datad, 128, 128,  16, w27, w30, w30);
      TEST_3RF_3("fmadd.d", datad, 128, 128,  32, w26, w30, w23);
      TEST_3RF_3("fmadd.d", datad, 128, 128,  48, w12, w0,  w6);
      TEST_3RF_3("fmadd.d", datad, 128, 128,  64, w31, w3,  w24);
      TEST_3RF_3("fmadd.d", datad, 128, 128,  80, w29, w2,  w0);
      TEST_3RF_3("fmadd.d", datad, 128, 128,  96, w11, w24, w14);
      TEST_3RF_3("fmadd.d", datad, 128, 128, 112, w17, w11, w25);
      TEST_3RF_3("fmadd.d", datad, 128, 128, 128, w3,  w10, w24);
      TEST_3RF_3("fmadd.d", datad, 128, 128, 144, w4,  w6,  w11);
      TEST_3RF_3("fmadd.d", datad, 128, 144,   0, w19, w4,  w13);
      TEST_3RF_3("fmadd.d", datad, 128, 144,  16, w29, w31, w12);
      TEST_3RF_3("fmadd.d", datad, 128, 144,  32, w24, w24, w30);
      TEST_3RF_3("fmadd.d", datad, 128, 144,  48, w3,  w4,  w30);
      TEST_3RF_3("fmadd.d", datad, 128, 144,  64, w9,  w3,  w2);
      TEST_3RF_3("fmadd.d", datad, 128, 144,  80, w1,  w1,  w1);
      TEST_3RF_3("fmadd.d", datad, 128, 144,  96, w0,  w31, w0);
      TEST_3RF_3("fmadd.d", datad, 128, 144, 112, w4,  w1,  w10);
      TEST_3RF_3("fmadd.d", datad, 128, 144, 128, w28, w15, w27);
      TEST_3RF_3("fmadd.d", datad, 128, 144, 144, w7,  w8,  w31);
      TEST_3RF_3("fmadd.d", datad, 144,   0,   0, w18, w0,  w3);
      TEST_3RF_3("fmadd.d", datad, 144,   0,  16, w24, w24, w12);
      TEST_3RF_3("fmadd.d", datad, 144,   0,  32, w23, w29, w25);
      TEST_3RF_3("fmadd.d", datad, 144,   0,  48, w20, w28, w5);
      TEST_3RF_3("fmadd.d", datad, 144,   0,  64, w12, w26, w8);
      TEST_3RF_3("fmadd.d", datad, 144,   0,  80, w16, w25, w17);
      TEST_3RF_3("fmadd.d", datad, 144,   0,  96, w19, w27, w20);
      TEST_3RF_3("fmadd.d", datad, 144,   0, 112, w26, w23, w21);
      TEST_3RF_3("fmadd.d", datad, 144,   0, 128, w5,  w19, w4);
      TEST_3RF_3("fmadd.d", datad, 144,   0, 144, w0,  w26, w0);
      TEST_3RF_3("fmadd.d", datad, 144,  16,   0, w12, w31, w13);
      TEST_3RF_3("fmadd.d", datad, 144,  16,  16, w3,  w5,  w25);
      TEST_3RF_3("fmadd.d", datad, 144,  16,  32, w26, w2,  w18);
      TEST_3RF_3("fmadd.d", datad, 144,  16,  48, w14, w30, w24);
      TEST_3RF_3("fmadd.d", datad, 144,  16,  64, w27, w25, w25);
      TEST_3RF_3("fmadd.d", datad, 144,  16,  80, w0,  w11, w0);
      TEST_3RF_3("fmadd.d", datad, 144,  16,  96, w18, w31, w13);
      TEST_3RF_3("fmadd.d", datad, 144,  16, 112, w5,  w19, w7);
      TEST_3RF_3("fmadd.d", datad, 144,  16, 128, w28, w8,  w12);
      TEST_3RF_3("fmadd.d", datad, 144,  16, 144, w15, w12, w13);
      TEST_3RF_3("fmadd.d", datad, 144,  32,   0, w9,  w24, w12);
      TEST_3RF_3("fmadd.d", datad, 144,  32,  16, w22, w5,  w15);
      TEST_3RF_3("fmadd.d", datad, 144,  32,  32, w27, w30, w30);
      TEST_3RF_3("fmadd.d", datad, 144,  32,  48, w9,  w29, w17);
      TEST_3RF_3("fmadd.d", datad, 144,  32,  64, w24, w24, w27);
      TEST_3RF_3("fmadd.d", datad, 144,  32,  80, w9,  w19, w20);
      TEST_3RF_3("fmadd.d", datad, 144,  32,  96, w9,  w30, w6);
      TEST_3RF_3("fmadd.d", datad, 144,  32, 112, w27, w29, w29);
      TEST_3RF_3("fmadd.d", datad, 144,  32, 128, w19, w0,  w16);
      TEST_3RF_3("fmadd.d", datad, 144,  32, 144, w27, w28, w28);
      TEST_3RF_3("fmadd.d", datad, 144,  48,   0, w24, w24, w7);
      TEST_3RF_3("fmadd.d", datad, 144,  48,  16, w11, w4,  w20);
      TEST_3RF_3("fmadd.d", datad, 144,  48,  32, w21, w29, w1);
      TEST_3RF_3("fmadd.d", datad, 144,  48,  48, w11, w2,  w16);
      TEST_3RF_3("fmadd.d", datad, 144,  48,  64, w6,  w1,  w26);
      TEST_3RF_3("fmadd.d", datad, 144,  48,  80, w3,  w18, w30);
      TEST_3RF_3("fmadd.d", datad, 144,  48,  96, w27, w5,  w5);
      TEST_3RF_3("fmadd.d", datad, 144,  48, 112, w19, w4,  w3);
      TEST_3RF_3("fmadd.d", datad, 144,  48, 128, w25, w0,  w1);
      TEST_3RF_3("fmadd.d", datad, 144,  48, 144, w13, w0,  w17);
      TEST_3RF_3("fmadd.d", datad, 144,  64,   0, w8,  w29, w10);
      TEST_3RF_3("fmadd.d", datad, 144,  64,  16, w15, w8,  w14);
      TEST_3RF_3("fmadd.d", datad, 144,  64,  32, w4,  w29, w11);
      TEST_3RF_3("fmadd.d", datad, 144,  64,  48, w5,  w8,  w14);
      TEST_3RF_3("fmadd.d", datad, 144,  64,  64, w21, w14, w15);
      TEST_3RF_3("fmadd.d", datad, 144,  64,  80, w15, w17, w1);
      TEST_3RF_3("fmadd.d", datad, 144,  64,  96, w1,  w1,  w1);
      TEST_3RF_3("fmadd.d", datad, 144,  64, 112, w16, w28, w6);
      TEST_3RF_3("fmadd.d", datad, 144,  64, 128, w3,  w0,  w10);
      TEST_3RF_3("fmadd.d", datad, 144,  64, 144, w28, w0,  w11);
      TEST_3RF_3("fmadd.d", datad, 144,  80,   0, w9,  w1,  w28);
      TEST_3RF_3("fmadd.d", datad, 144,  80,  16, w17, w30, w6);
      TEST_3RF_3("fmadd.d", datad, 144,  80,  32, w1,  w1,  w1);
      TEST_3RF_3("fmadd.d", datad, 144,  80,  48, w6,  w21, w5);
      TEST_3RF_3("fmadd.d", datad, 144,  80,  64, w4,  w0,  w10);
      TEST_3RF_3("fmadd.d", datad, 144,  80,  80, w12, w14, w31);
      TEST_3RF_3("fmadd.d", datad, 144,  80,  96, w27, w29, w29);
      TEST_3RF_3("fmadd.d", datad, 144,  80, 112, w15, w12, w30);
      TEST_3RF_3("fmadd.d", datad, 144,  80, 128, w16, w28, w26);
      TEST_3RF_3("fmadd.d", datad, 144,  80, 144, w23, w31, w27);
      TEST_3RF_3("fmadd.d", datad, 144,  96,   0, w1,  w1,  w1);
      TEST_3RF_3("fmadd.d", datad, 144,  96,  16, w28, w27, w12);
      TEST_3RF_3("fmadd.d", datad, 144,  96,  32, w5,  w28, w8);
      TEST_3RF_3("fmadd.d", datad, 144,  96,  48, w23, w26, w15);
      TEST_3RF_3("fmadd.d", datad, 144,  96,  64, w24, w24, w1);
      TEST_3RF_3("fmadd.d", datad, 144,  96,  80, w4,  w29, w5);
      TEST_3RF_3("fmadd.d", datad, 144,  96,  96, w4,  w7,  w17);
      TEST_3RF_3("fmadd.d", datad, 144,  96, 112, w19, w6,  w12);
      TEST_3RF_3("fmadd.d", datad, 144,  96, 128, w16, w21, w25);
      TEST_3RF_3("fmadd.d", datad, 144,  96, 144, w15, w6,  w21);
      TEST_3RF_3("fmadd.d", datad, 144, 112,   0, w9,  w29, w21);
      TEST_3RF_3("fmadd.d", datad, 144, 112,  16, w4,  w30, w17);
      TEST_3RF_3("fmadd.d", datad, 144, 112,  32, w0,  w10, w0);
      TEST_3RF_3("fmadd.d", datad, 144, 112,  48, w22, w28, w18);
      TEST_3RF_3("fmadd.d", datad, 144, 112,  64, w13, w23, w1);
      TEST_3RF_3("fmadd.d", datad, 144, 112,  80, w5,  w24, w2);
      TEST_3RF_3("fmadd.d", datad, 144, 112,  96, w29, w10, w9);
      TEST_3RF_3("fmadd.d", datad, 144, 112, 112, w14, w29, w16);
      TEST_3RF_3("fmadd.d", datad, 144, 112, 128, w27, w13, w13);
      TEST_3RF_3("fmadd.d", datad, 144, 112, 144, w5,  w20, w28);
      TEST_3RF_3("fmadd.d", datad, 144, 128,   0, w11, w9,  w6);
      TEST_3RF_3("fmadd.d", datad, 144, 128,  16, w8,  w30, w10);
      TEST_3RF_3("fmadd.d", datad, 144, 128,  32, w6,  w15, w10);
      TEST_3RF_3("fmadd.d", datad, 144, 128,  48, w16, w6,  w7);
      TEST_3RF_3("fmadd.d", datad, 144, 128,  64, w3,  w19, w30);
      TEST_3RF_3("fmadd.d", datad, 144, 128,  80, w4,  w25, w22);
      TEST_3RF_3("fmadd.d", datad, 144, 128,  96, w10, w27, w19);
      TEST_3RF_3("fmadd.d", datad, 144, 128, 112, w20, w5,  w1);
      TEST_3RF_3("fmadd.d", datad, 144, 128, 128, w17, w21, w28);
      TEST_3RF_3("fmadd.d", datad, 144, 128, 144, w30, w26, w16);
      TEST_3RF_3("fmadd.d", datad, 144, 144,   0, w27, w6,  w6);
      TEST_3RF_3("fmadd.d", datad, 144, 144,  16, w26, w1,  w14);
      TEST_3RF_3("fmadd.d", datad, 144, 144,  32, w24, w24, w11);
      TEST_3RF_3("fmadd.d", datad, 144, 144,  48, w21, w8,  w22);
      TEST_3RF_3("fmadd.d", datad, 144, 144,  64, w5,  w14, w29);
      TEST_3RF_3("fmadd.d", datad, 144, 144,  80, w8,  w1,  w27);
      TEST_3RF_3("fmadd.d", datad, 144, 144,  96, w13, w26, w17);
      TEST_3RF_3("fmadd.d", datad, 144, 144, 112, w23, w22, w4);
      TEST_3RF_3("fmadd.d", datad, 144, 144, 128, w11, w27, w5);
      TEST_3RF_3("fmadd.d", datad, 144, 144, 144, w28, w16, w2);
      TEST_3RF_3("fmsub.w", dataf,   0,   0,   0, w16, w12, w22);
      TEST_3RF_3("fmsub.w", dataf,   0,   0,   8, w31, w5,  w2);
      TEST_3RF_3("fmsub.w", dataf,   0,   0,  16, w20, w13, w24);
      TEST_3RF_3("fmsub.w", dataf,   0,   0,  24, w25, w27, w21);
      TEST_3RF_3("fmsub.w", dataf,   0,   0,  32, w2,  w28, w16);
      TEST_3RF_3("fmsub.w", dataf,   0,   0,  40, w15, w23, w1);
      TEST_3RF_3("fmsub.w", dataf,   0,   0,  48, w6,  w13, w5);
      TEST_3RF_3("fmsub.w", dataf,   0,   0,  56, w17, w8,  w10);
      TEST_3RF_3("fmsub.w", dataf,   0,   0,  64, w13, w24, w12);
      TEST_3RF_3("fmsub.w", dataf,   0,   0,  72, w7,  w2,  w31);
      TEST_3RF_3("fmsub.w", dataf,   0,   8,   0, w29, w19, w11);
      TEST_3RF_3("fmsub.w", dataf,   0,   8,   8, w19, w18, w16);
      TEST_3RF_3("fmsub.w", dataf,   0,   8,  16, w21, w6,  w6);
      TEST_3RF_3("fmsub.w", dataf,   0,   8,  24, w29, w13, w31);
      TEST_3RF_3("fmsub.w", dataf,   0,   8,  32, w24, w2,  w1);
      TEST_3RF_3("fmsub.w", dataf,   0,   8,  40, w21, w18, w18);
      TEST_3RF_3("fmsub.w", dataf,   0,   8,  48, w16, w12, w19);
      TEST_3RF_3("fmsub.w", dataf,   0,   8,  56, w22, w25, w24);
      TEST_3RF_3("fmsub.w", dataf,   0,   8,  64, w7,  w1,  w3);
      TEST_3RF_3("fmsub.w", dataf,   0,   8,  72, w20, w25, w15);
      TEST_3RF_3("fmsub.w", dataf,   0,  16,   0, w28, w27, w14);
      TEST_3RF_3("fmsub.w", dataf,   0,  16,   8, w25, w14, w26);
      TEST_3RF_3("fmsub.w", dataf,   0,  16,  16, w12, w0,  w10);
      TEST_3RF_3("fmsub.w", dataf,   0,  16,  24, w2,  w6,  w8);
      TEST_3RF_3("fmsub.w", dataf,   0,  16,  32, w15, w6,  w0);
      TEST_3RF_3("fmsub.w", dataf,   0,  16,  40, w18, w7,  w18);
      TEST_3RF_3("fmsub.w", dataf,   0,  16,  48, w21, w4,  w4);
      TEST_3RF_3("fmsub.w", dataf,   0,  16,  56, w24, w1,  w14);
      TEST_3RF_3("fmsub.w", dataf,   0,  16,  64, w26, w26, w26);
      TEST_3RF_3("fmsub.w", dataf,   0,  16,  72, w16, w22, w27);
      TEST_3RF_3("fmsub.w", dataf,   0,  24,   0, w19, w10, w20);
      TEST_3RF_3("fmsub.w", dataf,   0,  24,   8, w3,  w6,  w16);
      TEST_3RF_3("fmsub.w", dataf,   0,  24,  16, w17, w31, w30);
      TEST_3RF_3("fmsub.w", dataf,   0,  24,  24, w11, w12, w31);
      TEST_3RF_3("fmsub.w", dataf,   0,  24,  32, w22, w14, w5);
      TEST_3RF_3("fmsub.w", dataf,   0,  24,  40, w30, w29, w11);
      TEST_3RF_3("fmsub.w", dataf,   0,  24,  48, w30, w15, w19);
      TEST_3RF_3("fmsub.w", dataf,   0,  24,  56, w20, w11, w21);
      TEST_3RF_3("fmsub.w", dataf,   0,  24,  64, w12, w25, w16);
      TEST_3RF_3("fmsub.w", dataf,   0,  24,  72, w28, w15, w11);
      TEST_3RF_3("fmsub.w", dataf,   0,  32,   0, w16, w26, w0);
      TEST_3RF_3("fmsub.w", dataf,   0,  32,   8, w19, w0,  w16);
      TEST_3RF_3("fmsub.w", dataf,   0,  32,  16, w4,  w0,  w14);
      TEST_3RF_3("fmsub.w", dataf,   0,  32,  24, w16, w12, w13);
      TEST_3RF_3("fmsub.w", dataf,   0,  32,  32, w6,  w26, w19);
      TEST_3RF_3("fmsub.w", dataf,   0,  32,  40, w4,  w23, w30);
      TEST_3RF_3("fmsub.w", dataf,   0,  32,  48, w2,  w7,  w17);
      TEST_3RF_3("fmsub.w", dataf,   0,  32,  56, w22, w27, w28);
      TEST_3RF_3("fmsub.w", dataf,   0,  32,  64, w12, w7,  w22);
      TEST_3RF_3("fmsub.w", dataf,   0,  32,  72, w28, w3,  w5);
      TEST_3RF_3("fmsub.w", dataf,   0,  40,   0, w7,  w19, w31);
      TEST_3RF_3("fmsub.w", dataf,   0,  40,   8, w7,  w6,  w0);
      TEST_3RF_3("fmsub.w", dataf,   0,  40,  16, w23, w11, w0);
      TEST_3RF_3("fmsub.w", dataf,   0,  40,  24, w6,  w27, w12);
      TEST_3RF_3("fmsub.w", dataf,   0,  40,  32, w19, w1,  w6);
      TEST_3RF_3("fmsub.w", dataf,   0,  40,  40, w6,  w5,  w29);
      TEST_3RF_3("fmsub.w", dataf,   0,  40,  48, w5,  w7,  w4);
      TEST_3RF_3("fmsub.w", dataf,   0,  40,  56, w22, w30, w31);
      TEST_3RF_3("fmsub.w", dataf,   0,  40,  64, w19, w10, w6);
      TEST_3RF_3("fmsub.w", dataf,   0,  40,  72, w9,  w6,  w10);
      TEST_3RF_3("fmsub.w", dataf,   0,  48,   0, w14, w13, w29);
      TEST_3RF_3("fmsub.w", dataf,   0,  48,   8, w14, w21, w4);
      TEST_3RF_3("fmsub.w", dataf,   0,  48,  16, w14, w12, w15);
      TEST_3RF_3("fmsub.w", dataf,   0,  48,  24, w14, w18, w10);
      TEST_3RF_3("fmsub.w", dataf,   0,  48,  32, w26, w26, w26);
      TEST_3RF_3("fmsub.w", dataf,   0,  48,  40, w6,  w11, w0);
      TEST_3RF_3("fmsub.w", dataf,   0,  48,  48, w12, w16, w29);
      TEST_3RF_3("fmsub.w", dataf,   0,  48,  56, w17, w23, w2);
      TEST_3RF_3("fmsub.w", dataf,   0,  48,  64, w8,  w21, w1);
      TEST_3RF_3("fmsub.w", dataf,   0,  48,  72, w27, w31, w8);
      TEST_3RF_3("fmsub.w", dataf,   0,  56,   0, w4,  w5,  w18);
      TEST_3RF_3("fmsub.w", dataf,   0,  56,   8, w18, w19, w18);
      TEST_3RF_3("fmsub.w", dataf,   0,  56,  16, w15, w0,  w8);
      TEST_3RF_3("fmsub.w", dataf,   0,  56,  24, w19, w14, w20);
      TEST_3RF_3("fmsub.w", dataf,   0,  56,  32, w2,  w28, w7);
      TEST_3RF_3("fmsub.w", dataf,   0,  56,  40, w12, w22, w13);
      TEST_3RF_3("fmsub.w", dataf,   0,  56,  48, w23, w22, w25);
      TEST_3RF_3("fmsub.w", dataf,   0,  56,  56, w7,  w20, w11);
      TEST_3RF_3("fmsub.w", dataf,   0,  56,  64, w31, w22, w19);
      TEST_3RF_3("fmsub.w", dataf,   0,  56,  72, w20, w23, w14);
      TEST_3RF_3("fmsub.w", dataf,   0,  64,   0, w20, w31, w18);
      TEST_3RF_3("fmsub.w", dataf,   0,  64,   8, w25, w17, w4);
      TEST_3RF_3("fmsub.w", dataf,   0,  64,  16, w12, w1,  w5);
      TEST_3RF_3("fmsub.w", dataf,   0,  64,  24, w20, w19, w9);
      TEST_3RF_3("fmsub.w", dataf,   0,  64,  32, w23, w16, w3);
      TEST_3RF_3("fmsub.w", dataf,   0,  64,  40, w6,  w29, w27);
      TEST_3RF_3("fmsub.w", dataf,   0,  64,  48, w29, w22, w2);
      TEST_3RF_3("fmsub.w", dataf,   0,  64,  56, w17, w1,  w7);
      TEST_3RF_3("fmsub.w", dataf,   0,  64,  64, w20, w22, w30);
      TEST_3RF_3("fmsub.w", dataf,   0,  64,  72, w2,  w10, w30);
      TEST_3RF_3("fmsub.w", dataf,   0,  72,   0, w20, w3,  w15);
      TEST_3RF_3("fmsub.w", dataf,   0,  72,   8, w25, w16, w30);
      TEST_3RF_3("fmsub.w", dataf,   0,  72,  16, w4,  w5,  w17);
      TEST_3RF_3("fmsub.w", dataf,   0,  72,  24, w13, w28, w1);
      TEST_3RF_3("fmsub.w", dataf,   0,  72,  32, w29, w31, w8);
      TEST_3RF_3("fmsub.w", dataf,   0,  72,  40, w26, w26, w26);
      TEST_3RF_3("fmsub.w", dataf,   0,  72,  48, w26, w26, w26);
      TEST_3RF_3("fmsub.w", dataf,   0,  72,  56, w5,  w17, w29);
      TEST_3RF_3("fmsub.w", dataf,   0,  72,  64, w22, w18, w30);
      TEST_3RF_3("fmsub.w", dataf,   0,  72,  72, w29, w7,  w20);
      TEST_3RF_3("fmsub.w", dataf,   8,   0,   0, w27, w9,  w30);
      TEST_3RF_3("fmsub.w", dataf,   8,   0,   8, w25, w30, w2);
      TEST_3RF_3("fmsub.w", dataf,   8,   0,  16, w9,  w23, w18);
      TEST_3RF_3("fmsub.w", dataf,   8,   0,  24, w25, w21, w22);
      TEST_3RF_3("fmsub.w", dataf,   8,   0,  32, w30, w6,  w4);
      TEST_3RF_3("fmsub.w", dataf,   8,   0,  40, w26, w26, w26);
      TEST_3RF_3("fmsub.w", dataf,   8,   0,  48, w8,  w1,  w26);
      TEST_3RF_3("fmsub.w", dataf,   8,   0,  56, w16, w28, w20);
      TEST_3RF_3("fmsub.w", dataf,   8,   0,  64, w21, w13, w13);
      TEST_3RF_3("fmsub.w", dataf,   8,   0,  72, w17, w11, w31);
      TEST_3RF_3("fmsub.w", dataf,   8,   8,   0, w16, w8,  w6);
      TEST_3RF_3("fmsub.w", dataf,   8,   8,   8, w4,  w3,  w16);
      TEST_3RF_3("fmsub.w", dataf,   8,   8,  16, w3,  w29, w14);
      TEST_3RF_3("fmsub.w", dataf,   8,   8,  24, w5,  w6,  w23);
      TEST_3RF_3("fmsub.w", dataf,   8,   8,  32, w31, w26, w13);
      TEST_3RF_3("fmsub.w", dataf,   8,   8,  40, w30, w0,  w17);
      TEST_3RF_3("fmsub.w", dataf,   8,   8,  48, w24, w8,  w19);
      TEST_3RF_3("fmsub.w", dataf,   8,   8,  56, w18, w24, w18);
      TEST_3RF_3("fmsub.w", dataf,   8,   8,  64, w15, w7,  w13);
      TEST_3RF_3("fmsub.w", dataf,   8,   8,  72, w28, w24, w27);
      TEST_3RF_3("fmsub.w", dataf,   8,  16,   0, w8,  w0,  w2);
      TEST_3RF_3("fmsub.w", dataf,   8,  16,   8, w13, w4,  w18);
      TEST_3RF_3("fmsub.w", dataf,   8,  16,  16, w16, w1,  w0);
      TEST_3RF_3("fmsub.w", dataf,   8,  16,  24, w21, w7,  w7);
      TEST_3RF_3("fmsub.w", dataf,   8,  16,  32, w5,  w12, w6);
      TEST_3RF_3("fmsub.w", dataf,   8,  16,  40, w31, w25, w4);
      TEST_3RF_3("fmsub.w", dataf,   8,  16,  48, w31, w11, w29);
      TEST_3RF_3("fmsub.w", dataf,   8,  16,  56, w8,  w30, w15);
      TEST_3RF_3("fmsub.w", dataf,   8,  16,  64, w0,  w13, w22);
      TEST_3RF_3("fmsub.w", dataf,   8,  16,  72, w14, w9,  w15);
      TEST_3RF_3("fmsub.w", dataf,   8,  24,   0, w6,  w4,  w23);
      TEST_3RF_3("fmsub.w", dataf,   8,  24,   8, w7,  w6,  w4);
      TEST_3RF_3("fmsub.w", dataf,   8,  24,  16, w11, w24, w20);
      TEST_3RF_3("fmsub.w", dataf,   8,  24,  24, w12, w24, w9);
      TEST_3RF_3("fmsub.w", dataf,   8,  24,  32, w19, w29, w21);
      TEST_3RF_3("fmsub.w", dataf,   8,  24,  40, w25, w28, w15);
      TEST_3RF_3("fmsub.w", dataf,   8,  24,  48, w30, w28, w26);
      TEST_3RF_3("fmsub.w", dataf,   8,  24,  56, w27, w4,  w24);
      TEST_3RF_3("fmsub.w", dataf,   8,  24,  64, w10, w10, w4);
      TEST_3RF_3("fmsub.w", dataf,   8,  24,  72, w5,  w1,  w18);
      TEST_3RF_3("fmsub.w", dataf,   8,  32,   0, w14, w16, w25);
      TEST_3RF_3("fmsub.w", dataf,   8,  32,   8, w18, w7,  w18);
      TEST_3RF_3("fmsub.w", dataf,   8,  32,  16, w0,  w25, w12);
      TEST_3RF_3("fmsub.w", dataf,   8,  32,  24, w11, w17, w0);
      TEST_3RF_3("fmsub.w", dataf,   8,  32,  32, w23, w10, w7);
      TEST_3RF_3("fmsub.w", dataf,   8,  32,  40, w31, w3,  w4);
      TEST_3RF_3("fmsub.w", dataf,   8,  32,  48, w14, w1,  w0);
      TEST_3RF_3("fmsub.w", dataf,   8,  32,  56, w8,  w28, w4);
      TEST_3RF_3("fmsub.w", dataf,   8,  32,  64, w0,  w7,  w8);
      TEST_3RF_3("fmsub.w", dataf,   8,  32,  72, w5,  w8,  w27);
      TEST_3RF_3("fmsub.w", dataf,   8,  40,   0, w19, w24, w20);
      TEST_3RF_3("fmsub.w", dataf,   8,  40,   8, w6,  w31, w20);
      TEST_3RF_3("fmsub.w", dataf,   8,  40,  16, w31, w11, w16);
      TEST_3RF_3("fmsub.w", dataf,   8,  40,  24, w12, w22, w26);
      TEST_3RF_3("fmsub.w", dataf,   8,  40,  32, w22, w0,  w2);
      TEST_3RF_3("fmsub.w", dataf,   8,  40,  40, w21, w3,  w3);
      TEST_3RF_3("fmsub.w", dataf,   8,  40,  48, w6,  w4,  w5);
      TEST_3RF_3("fmsub.w", dataf,   8,  40,  56, w6,  w12, w1);
      TEST_3RF_3("fmsub.w", dataf,   8,  40,  64, w10, w10, w13);
      TEST_3RF_3("fmsub.w", dataf,   8,  40,  72, w8,  w18, w16);
      TEST_3RF_3("fmsub.w", dataf,   8,  48,   0, w13, w6,  w8);
      TEST_3RF_3("fmsub.w", dataf,   8,  48,   8, w1,  w12, w8);
      TEST_3RF_3("fmsub.w", dataf,   8,  48,  16, w21, w11, w11);
      TEST_3RF_3("fmsub.w", dataf,   8,  48,  24, w19, w20, w27);
      TEST_3RF_3("fmsub.w", dataf,   8,  48,  32, w31, w10, w22);
      TEST_3RF_3("fmsub.w", dataf,   8,  48,  40, w21, w10, w10);
      TEST_3RF_3("fmsub.w", dataf,   8,  48,  48, w24, w11, w14);
      TEST_3RF_3("fmsub.w", dataf,   8,  48,  56, w30, w15, w19);
      TEST_3RF_3("fmsub.w", dataf,   8,  48,  64, w4,  w27, w20);
      TEST_3RF_3("fmsub.w", dataf,   8,  48,  72, w14, w8,  w29);
      TEST_3RF_3("fmsub.w", dataf,   8,  56,   0, w0,  w27, w13);
      TEST_3RF_3("fmsub.w", dataf,   8,  56,   8, w14, w1,  w22);
      TEST_3RF_3("fmsub.w", dataf,   8,  56,  16, w15, w13, w30);
      TEST_3RF_3("fmsub.w", dataf,   8,  56,  24, w5,  w24, w17);
      TEST_3RF_3("fmsub.w", dataf,   8,  56,  32, w25, w19, w17);
      TEST_3RF_3("fmsub.w", dataf,   8,  56,  40, w4,  w9,  w6);
      TEST_3RF_3("fmsub.w", dataf,   8,  56,  48, w14, w1,  w17);
      TEST_3RF_3("fmsub.w", dataf,   8,  56,  56, w28, w31, w0);
      TEST_3RF_3("fmsub.w", dataf,   8,  56,  64, w15, w3,  w28);
      TEST_3RF_3("fmsub.w", dataf,   8,  56,  72, w4,  w17, w1);
      TEST_3RF_3("fmsub.w", dataf,   8,  64,   0, w18, w31, w18);
      TEST_3RF_3("fmsub.w", dataf,   8,  64,   8, w14, w0,  w4);
      TEST_3RF_3("fmsub.w", dataf,   8,  64,  16, w15, w13, w2);
      TEST_3RF_3("fmsub.w", dataf,   8,  64,  24, w20, w5,  w14);
      TEST_3RF_3("fmsub.w", dataf,   8,  64,  32, w25, w5,  w18);
      TEST_3RF_3("fmsub.w", dataf,   8,  64,  40, w2,  w11, w0);
      TEST_3RF_3("fmsub.w", dataf,   8,  64,  48, w4,  w29, w3);
      TEST_3RF_3("fmsub.w", dataf,   8,  64,  56, w29, w12, w7);
      TEST_3RF_3("fmsub.w", dataf,   8,  64,  64, w25, w16, w24);
      TEST_3RF_3("fmsub.w", dataf,   8,  64,  72, w30, w17, w10);
      TEST_3RF_3("fmsub.w", dataf,   8,  72,   0, w29, w0,  w10);
      TEST_3RF_3("fmsub.w", dataf,   8,  72,   8, w30, w4,  w26);
      TEST_3RF_3("fmsub.w", dataf,   8,  72,  16, w11, w7,  w14);
      TEST_3RF_3("fmsub.w", dataf,   8,  72,  24, w17, w27, w28);
      TEST_3RF_3("fmsub.w", dataf,   8,  72,  32, w10, w10, w0);
      TEST_3RF_3("fmsub.w", dataf,   8,  72,  40, w14, w12, w11);
      TEST_3RF_3("fmsub.w", dataf,   8,  72,  48, w15, w16, w8);
      TEST_3RF_3("fmsub.w", dataf,   8,  72,  56, w12, w20, w6);
      TEST_3RF_3("fmsub.w", dataf,   8,  72,  64, w24, w27, w31);
      TEST_3RF_3("fmsub.w", dataf,   8,  72,  72, w9,  w19, w29);
      TEST_3RF_3("fmsub.w", dataf,  16,   0,   0, w26, w26, w26);
      TEST_3RF_3("fmsub.w", dataf,  16,   0,   8, w30, w27, w26);
      TEST_3RF_3("fmsub.w", dataf,  16,   0,  16, w8,  w25, w31);
      TEST_3RF_3("fmsub.w", dataf,  16,   0,  24, w2,  w4,  w6);
      TEST_3RF_3("fmsub.w", dataf,  16,   0,  32, w17, w21, w1);
      TEST_3RF_3("fmsub.w", dataf,  16,   0,  40, w13, w31, w1);
      TEST_3RF_3("fmsub.w", dataf,  16,   0,  48, w28, w12, w11);
      TEST_3RF_3("fmsub.w", dataf,  16,   0,  56, w28, w21, w23);
      TEST_3RF_3("fmsub.w", dataf,  16,   0,  64, w16, w27, w15);
      TEST_3RF_3("fmsub.w", dataf,  16,   0,  72, w11, w26, w24);
      TEST_3RF_3("fmsub.w", dataf,  16,   8,   0, w31, w24, w19);
      TEST_3RF_3("fmsub.w", dataf,  16,   8,   8, w29, w19, w13);
      TEST_3RF_3("fmsub.w", dataf,  16,   8,  16, w5,  w12, w8);
      TEST_3RF_3("fmsub.w", dataf,  16,   8,  24, w16, w18, w25);
      TEST_3RF_3("fmsub.w", dataf,  16,   8,  32, w6,  w19, w5);
      TEST_3RF_3("fmsub.w", dataf,  16,   8,  40, w20, w2,  w17);
      TEST_3RF_3("fmsub.w", dataf,  16,   8,  48, w1,  w13, w14);
      TEST_3RF_3("fmsub.w", dataf,  16,   8,  56, w22, w4,  w30);
      TEST_3RF_3("fmsub.w", dataf,  16,   8,  64, w17, w20, w10);
      TEST_3RF_3("fmsub.w", dataf,  16,   8,  72, w11, w12, w9);
      TEST_3RF_3("fmsub.w", dataf,  16,  16,   0, w3,  w31, w6);
      TEST_3RF_3("fmsub.w", dataf,  16,  16,   8, w22, w13, w11);
      TEST_3RF_3("fmsub.w", dataf,  16,  16,  16, w2,  w25, w19);
      TEST_3RF_3("fmsub.w", dataf,  16,  16,  24, w19, w12, w25);
      TEST_3RF_3("fmsub.w", dataf,  16,  16,  32, w31, w19, w30);
      TEST_3RF_3("fmsub.w", dataf,  16,  16,  40, w20, w21, w16);
      TEST_3RF_3("fmsub.w", dataf,  16,  16,  48, w21, w3,  w3);
      TEST_3RF_3("fmsub.w", dataf,  16,  16,  56, w30, w11, w7);
      TEST_3RF_3("fmsub.w", dataf,  16,  16,  64, w28, w27, w6);
      TEST_3RF_3("fmsub.w", dataf,  16,  16,  72, w7,  w8,  w15);
      TEST_3RF_3("fmsub.w", dataf,  16,  24,   0, w11, w7,  w21);
      TEST_3RF_3("fmsub.w", dataf,  16,  24,   8, w1,  w20, w4);
      TEST_3RF_3("fmsub.w", dataf,  16,  24,  16, w14, w20, w23);
      TEST_3RF_3("fmsub.w", dataf,  16,  24,  24, w26, w26, w26);
      TEST_3RF_3("fmsub.w", dataf,  16,  24,  32, w1,  w16, w25);
      TEST_3RF_3("fmsub.w", dataf,  16,  24,  40, w20, w14, w13);
      TEST_3RF_3("fmsub.w", dataf,  16,  24,  48, w9,  w30, w2);
      TEST_3RF_3("fmsub.w", dataf,  16,  24,  56, w12, w28, w13);
      TEST_3RF_3("fmsub.w", dataf,  16,  24,  64, w20, w25, w9);
      TEST_3RF_3("fmsub.w", dataf,  16,  24,  72, w15, w31, w17);
      TEST_3RF_3("fmsub.w", dataf,  16,  32,   0, w23, w15, w28);
      TEST_3RF_3("fmsub.w", dataf,  16,  32,   8, w31, w4,  w29);
      TEST_3RF_3("fmsub.w", dataf,  16,  32,  16, w19, w5,  w1);
      TEST_3RF_3("fmsub.w", dataf,  16,  32,  24, w1,  w26, w24);
      TEST_3RF_3("fmsub.w", dataf,  16,  32,  32, w27, w8,  w21);
      TEST_3RF_3("fmsub.w", dataf,  16,  32,  40, w15, w23, w2);
      TEST_3RF_3("fmsub.w", dataf,  16,  32,  48, w24, w21, w5);
      TEST_3RF_3("fmsub.w", dataf,  16,  32,  56, w5,  w18, w25);
      TEST_3RF_3("fmsub.w", dataf,  16,  32,  64, w11, w28, w8);
      TEST_3RF_3("fmsub.w", dataf,  16,  32,  72, w10, w10, w13);
      TEST_3RF_3("fmsub.w", dataf,  16,  40,   0, w0,  w25, w9);
      TEST_3RF_3("fmsub.w", dataf,  16,  40,   8, w31, w30, w6);
      TEST_3RF_3("fmsub.w", dataf,  16,  40,  16, w18, w3,  w18);
      TEST_3RF_3("fmsub.w", dataf,  16,  40,  24, w8,  w20, w29);
      TEST_3RF_3("fmsub.w", dataf,  16,  40,  32, w0,  w15, w24);
      TEST_3RF_3("fmsub.w", dataf,  16,  40,  40, w9,  w4,  w7);
      TEST_3RF_3("fmsub.w", dataf,  16,  40,  48, w0,  w7,  w21);
      TEST_3RF_3("fmsub.w", dataf,  16,  40,  56, w12, w5,  w7);
      TEST_3RF_3("fmsub.w", dataf,  16,  40,  64, w30, w18, w26);
      TEST_3RF_3("fmsub.w", dataf,  16,  40,  72, w6,  w29, w7);
      TEST_3RF_3("fmsub.w", dataf,  16,  48,   0, w6,  w22, w16);
      TEST_3RF_3("fmsub.w", dataf,  16,  48,   8, w5,  w20, w23);
      TEST_3RF_3("fmsub.w", dataf,  16,  48,  16, w24, w31, w12);
      TEST_3RF_3("fmsub.w", dataf,  16,  48,  24, w21, w31, w31);
      TEST_3RF_3("fmsub.w", dataf,  16,  48,  32, w27, w14, w8);
      TEST_3RF_3("fmsub.w", dataf,  16,  48,  40, w0,  w21, w8);
      TEST_3RF_3("fmsub.w", dataf,  16,  48,  48, w7,  w21, w30);
      TEST_3RF_3("fmsub.w", dataf,  16,  48,  56, w19, w26, w5);
      TEST_3RF_3("fmsub.w", dataf,  16,  48,  64, w17, w24, w12);
      TEST_3RF_3("fmsub.w", dataf,  16,  48,  72, w31, w21, w19);
      TEST_3RF_3("fmsub.w", dataf,  16,  56,   0, w5,  w11, w4);
      TEST_3RF_3("fmsub.w", dataf,  16,  56,   8, w11, w0,  w27);
      TEST_3RF_3("fmsub.w", dataf,  16,  56,  16, w3,  w24, w26);
      TEST_3RF_3("fmsub.w", dataf,  16,  56,  24, w15, w13, w25);
      TEST_3RF_3("fmsub.w", dataf,  16,  56,  32, w10, w10, w27);
      TEST_3RF_3("fmsub.w", dataf,  16,  56,  40, w2,  w10, w17);
      TEST_3RF_3("fmsub.w", dataf,  16,  56,  48, w10, w10, w17);
      TEST_3RF_3("fmsub.w", dataf,  16,  56,  56, w6,  w8,  w4);
      TEST_3RF_3("fmsub.w", dataf,  16,  56,  64, w1,  w14, w22);
      TEST_3RF_3("fmsub.w", dataf,  16,  56,  72, w25, w6,  w2);
      TEST_3RF_3("fmsub.w", dataf,  16,  64,   0, w24, w27, w21);
      TEST_3RF_3("fmsub.w", dataf,  16,  64,   8, w30, w6,  w25);
      TEST_3RF_3("fmsub.w", dataf,  16,  64,  16, w9,  w6,  w20);
      TEST_3RF_3("fmsub.w", dataf,  16,  64,  24, w12, w30, w14);
      TEST_3RF_3("fmsub.w", dataf,  16,  64,  32, w27, w12, w8);
      TEST_3RF_3("fmsub.w", dataf,  16,  64,  40, w5,  w7,  w10);
      TEST_3RF_3("fmsub.w", dataf,  16,  64,  48, w16, w24, w20);
      TEST_3RF_3("fmsub.w", dataf,  16,  64,  56, w1,  w31, w29);
      TEST_3RF_3("fmsub.w", dataf,  16,  64,  64, w6,  w0,  w11);
      TEST_3RF_3("fmsub.w", dataf,  16,  64,  72, w28, w25, w17);
      TEST_3RF_3("fmsub.w", dataf,  16,  72,   0, w30, w18, w12);
      TEST_3RF_3("fmsub.w", dataf,  16,  72,   8, w19, w16, w18);
      TEST_3RF_3("fmsub.w", dataf,  16,  72,  16, w13, w25, w1);
      TEST_3RF_3("fmsub.w", dataf,  16,  72,  24, w5,  w23, w16);
      TEST_3RF_3("fmsub.w", dataf,  16,  72,  32, w0,  w3,  w24);
      TEST_3RF_3("fmsub.w", dataf,  16,  72,  40, w5,  w11, w2);
      TEST_3RF_3("fmsub.w", dataf,  16,  72,  48, w21, w3,  w3);
      TEST_3RF_3("fmsub.w", dataf,  16,  72,  56, w22, w23, w2);
      TEST_3RF_3("fmsub.w", dataf,  16,  72,  64, w19, w29, w2);
      TEST_3RF_3("fmsub.w", dataf,  16,  72,  72, w30, w25, w28);
      TEST_3RF_3("fmsub.w", dataf,  24,   0,   0, w15, w23, w14);
      TEST_3RF_3("fmsub.w", dataf,  24,   0,   8, w27, w10, w30);
      TEST_3RF_3("fmsub.w", dataf,  24,   0,  16, w14, w23, w7);
      TEST_3RF_3("fmsub.w", dataf,  24,   0,  24, w25, w28, w30);
      TEST_3RF_3("fmsub.w", dataf,  24,   0,  32, w9,  w28, w2);
      TEST_3RF_3("fmsub.w", dataf,  24,   0,  40, w1,  w13, w3);
      TEST_3RF_3("fmsub.w", dataf,  24,   0,  48, w23, w16, w25);
      TEST_3RF_3("fmsub.w", dataf,  24,   0,  56, w14, w19, w13);
      TEST_3RF_3("fmsub.w", dataf,  24,   0,  64, w11, w21, w4);
      TEST_3RF_3("fmsub.w", dataf,  24,   0,  72, w17, w27, w31);
      TEST_3RF_3("fmsub.w", dataf,  24,   8,   0, w22, w5,  w29);
      TEST_3RF_3("fmsub.w", dataf,  24,   8,   8, w4,  w29, w20);
      TEST_3RF_3("fmsub.w", dataf,  24,   8,  16, w11, w22, w16);
      TEST_3RF_3("fmsub.w", dataf,  24,   8,  24, w10, w10, w31);
      TEST_3RF_3("fmsub.w", dataf,  24,   8,  32, w12, w0,  w14);
      TEST_3RF_3("fmsub.w", dataf,  24,   8,  40, w25, w3,  w5);
      TEST_3RF_3("fmsub.w", dataf,  24,   8,  48, w9,  w28, w19);
      TEST_3RF_3("fmsub.w", dataf,  24,   8,  56, w28, w9,  w30);
      TEST_3RF_3("fmsub.w", dataf,  24,   8,  64, w18, w21, w18);
      TEST_3RF_3("fmsub.w", dataf,  24,   8,  72, w2,  w3,  w16);
      TEST_3RF_3("fmsub.w", dataf,  24,  16,   0, w29, w3,  w6);
      TEST_3RF_3("fmsub.w", dataf,  24,  16,   8, w2,  w0,  w11);
      TEST_3RF_3("fmsub.w", dataf,  24,  16,  16, w31, w21, w22);
      TEST_3RF_3("fmsub.w", dataf,  24,  16,  24, w21, w5,  w5);
      TEST_3RF_3("fmsub.w", dataf,  24,  16,  32, w0,  w20, w18);
      TEST_3RF_3("fmsub.w", dataf,  24,  16,  40, w12, w20, w0);
      TEST_3RF_3("fmsub.w", dataf,  24,  16,  48, w5,  w23, w15);
      TEST_3RF_3("fmsub.w", dataf,  24,  16,  56, w20, w24, w11);
      TEST_3RF_3("fmsub.w", dataf,  24,  16,  64, w29, w22, w18);
      TEST_3RF_3("fmsub.w", dataf,  24,  16,  72, w24, w1,  w2);
      TEST_3RF_3("fmsub.w", dataf,  24,  24,   0, w21, w4,  w4);
      TEST_3RF_3("fmsub.w", dataf,  24,  24,   8, w9,  w23, w4);
      TEST_3RF_3("fmsub.w", dataf,  24,  24,  16, w20, w23, w25);
      TEST_3RF_3("fmsub.w", dataf,  24,  24,  24, w10, w10, w12);
      TEST_3RF_3("fmsub.w", dataf,  24,  24,  32, w31, w11, w1);
      TEST_3RF_3("fmsub.w", dataf,  24,  24,  40, w17, w23, w21);
      TEST_3RF_3("fmsub.w", dataf,  24,  24,  48, w17, w29, w13);
      TEST_3RF_3("fmsub.w", dataf,  24,  24,  56, w22, w12, w1);
      TEST_3RF_3("fmsub.w", dataf,  24,  24,  64, w14, w23, w30);
      TEST_3RF_3("fmsub.w", dataf,  24,  24,  72, w4,  w21, w17);
      TEST_3RF_3("fmsub.w", dataf,  24,  32,   0, w28, w22, w19);
      TEST_3RF_3("fmsub.w", dataf,  24,  32,   8, w17, w26, w28);
      TEST_3RF_3("fmsub.w", dataf,  24,  32,  16, w8,  w30, w16);
      TEST_3RF_3("fmsub.w", dataf,  24,  32,  24, w31, w24, w27);
      TEST_3RF_3("fmsub.w", dataf,  24,  32,  32, w12, w23, w6);
      TEST_3RF_3("fmsub.w", dataf,  24,  32,  40, w13, w8,  w29);
      TEST_3RF_3("fmsub.w", dataf,  24,  32,  48, w2,  w25, w26);
      TEST_3RF_3("fmsub.w", dataf,  24,  32,  56, w15, w6,  w16);
      TEST_3RF_3("fmsub.w", dataf,  24,  32,  64, w29, w30, w15);
      TEST_3RF_3("fmsub.w", dataf,  24,  32,  72, w1,  w19, w0);
      TEST_3RF_3("fmsub.w", dataf,  24,  40,   0, w29, w9,  w19);
      TEST_3RF_3("fmsub.w", dataf,  24,  40,   8, w14, w3,  w16);
      TEST_3RF_3("fmsub.w", dataf,  24,  40,  16, w22, w1,  w0);
      TEST_3RF_3("fmsub.w", dataf,  24,  40,  24, w22, w25, w27);
      TEST_3RF_3("fmsub.w", dataf,  24,  40,  32, w2,  w16, w1);
      TEST_3RF_3("fmsub.w", dataf,  24,  40,  40, w15, w24, w31);
      TEST_3RF_3("fmsub.w", dataf,  24,  40,  48, w17, w25, w1);
      TEST_3RF_3("fmsub.w", dataf,  24,  40,  56, w0,  w17, w29);
      TEST_3RF_3("fmsub.w", dataf,  24,  40,  64, w30, w0,  w17);
      TEST_3RF_3("fmsub.w", dataf,  24,  40,  72, w0,  w27, w26);
      TEST_3RF_3("fmsub.w", dataf,  24,  48,   0, w20, w9,  w29);
      TEST_3RF_3("fmsub.w", dataf,  24,  48,   8, w4,  w0,  w30);
      TEST_3RF_3("fmsub.w", dataf,  24,  48,  16, w4,  w22, w24);
      TEST_3RF_3("fmsub.w", dataf,  24,  48,  24, w0,  w24, w8);
      TEST_3RF_3("fmsub.w", dataf,  24,  48,  32, w1,  w7,  w0);
      TEST_3RF_3("fmsub.w", dataf,  24,  48,  40, w24, w18, w26);
      TEST_3RF_3("fmsub.w", dataf,  24,  48,  48, w25, w19, w26);
      TEST_3RF_3("fmsub.w", dataf,  24,  48,  56, w11, w16, w24);
      TEST_3RF_3("fmsub.w", dataf,  24,  48,  64, w11, w15, w9);
      TEST_3RF_3("fmsub.w", dataf,  24,  48,  72, w12, w10, w3);
      TEST_3RF_3("fmsub.w", dataf,  24,  56,   0, w0,  w20, w4);
      TEST_3RF_3("fmsub.w", dataf,  24,  56,   8, w20, w30, w8);
      TEST_3RF_3("fmsub.w", dataf,  24,  56,  16, w10, w10, w22);
      TEST_3RF_3("fmsub.w", dataf,  24,  56,  24, w8,  w2,  w31);
      TEST_3RF_3("fmsub.w", dataf,  24,  56,  32, w10, w10, w9);
      TEST_3RF_3("fmsub.w", dataf,  24,  56,  40, w0,  w10, w1);
      TEST_3RF_3("fmsub.w", dataf,  24,  56,  48, w18, w4,  w18);
      TEST_3RF_3("fmsub.w", dataf,  24,  56,  56, w27, w5,  w30);
      TEST_3RF_3("fmsub.w", dataf,  24,  56,  64, w6,  w22, w17);
      TEST_3RF_3("fmsub.w", dataf,  24,  56,  72, w5,  w31, w29);
      TEST_3RF_3("fmsub.w", dataf,  24,  64,   0, w15, w2,  w29);
      TEST_3RF_3("fmsub.w", dataf,  24,  64,   8, w3,  w2,  w1);
      TEST_3RF_3("fmsub.w", dataf,  24,  64,  16, w23, w1,  w10);
      TEST_3RF_3("fmsub.w", dataf,  24,  64,  24, w1,  w23, w18);
      TEST_3RF_3("fmsub.w", dataf,  24,  64,  32, w3,  w22, w28);
      TEST_3RF_3("fmsub.w", dataf,  24,  64,  40, w12, w22, w7);
      TEST_3RF_3("fmsub.w", dataf,  24,  64,  48, w14, w9,  w11);
      TEST_3RF_3("fmsub.w", dataf,  24,  64,  56, w9,  w14, w10);
      TEST_3RF_3("fmsub.w", dataf,  24,  64,  64, w15, w4,  w0);
      TEST_3RF_3("fmsub.w", dataf,  24,  64,  72, w0,  w9,  w30);
      TEST_3RF_3("fmsub.w", dataf,  24,  72,   0, w25, w2,  w27);
      TEST_3RF_3("fmsub.w", dataf,  24,  72,   8, w28, w5,  w29);
      TEST_3RF_3("fmsub.w", dataf,  24,  72,  16, w20, w6,  w7);
      TEST_3RF_3("fmsub.w", dataf,  24,  72,  24, w21, w29, w29);
      TEST_3RF_3("fmsub.w", dataf,  24,  72,  32, w25, w20, w22);
      TEST_3RF_3("fmsub.w", dataf,  24,  72,  40, w5,  w10, w29);
      TEST_3RF_3("fmsub.w", dataf,  24,  72,  48, w19, w8,  w28);
      TEST_3RF_3("fmsub.w", dataf,  24,  72,  56, w2,  w18, w11);
      TEST_3RF_3("fmsub.w", dataf,  24,  72,  64, w6,  w19, w12);
      TEST_3RF_3("fmsub.w", dataf,  24,  72,  72, w16, w19, w10);
      TEST_3RF_3("fmsub.w", dataf,  32,   0,   0, w9,  w21, w5);
      TEST_3RF_3("fmsub.w", dataf,  32,   0,   8, w5,  w26, w2);
      TEST_3RF_3("fmsub.w", dataf,  32,   0,  16, w25, w0,  w9);
      TEST_3RF_3("fmsub.w", dataf,  32,   0,  24, w15, w30, w3);
      TEST_3RF_3("fmsub.w", dataf,  32,   0,  32, w8,  w18, w25);
      TEST_3RF_3("fmsub.w", dataf,  32,   0,  40, w13, w28, w22);
      TEST_3RF_3("fmsub.w", dataf,  32,   0,  48, w1,  w16, w30);
      TEST_3RF_3("fmsub.w", dataf,  32,   0,  56, w29, w18, w17);
      TEST_3RF_3("fmsub.w", dataf,  32,   0,  64, w9,  w24, w4);
      TEST_3RF_3("fmsub.w", dataf,  32,   0,  72, w21, w8,  w8);
      TEST_3RF_3("fmsub.w", dataf,  32,   8,   0, w23, w31, w17);
      TEST_3RF_3("fmsub.w", dataf,  32,   8,   8, w12, w4,  w23);
      TEST_3RF_3("fmsub.w", dataf,  32,   8,  16, w7,  w16, w31);
      TEST_3RF_3("fmsub.w", dataf,  32,   8,  24, w5,  w19, w7);
      TEST_3RF_3("fmsub.w", dataf,  32,   8,  32, w23, w12, w21);
      TEST_3RF_3("fmsub.w", dataf,  32,   8,  40, w20, w2,  w22);
      TEST_3RF_3("fmsub.w", dataf,  32,   8,  48, w4,  w1,  w19);
      TEST_3RF_3("fmsub.w", dataf,  32,   8,  56, w22, w18, w28);
      TEST_3RF_3("fmsub.w", dataf,  32,   8,  64, w14, w22, w17);
      TEST_3RF_3("fmsub.w", dataf,  32,   8,  72, w23, w13, w16);
      TEST_3RF_3("fmsub.w", dataf,  32,  16,   0, w8,  w25, w21);
      TEST_3RF_3("fmsub.w", dataf,  32,  16,   8, w31, w0,  w28);
      TEST_3RF_3("fmsub.w", dataf,  32,  16,  16, w16, w8,  w12);
      TEST_3RF_3("fmsub.w", dataf,  32,  16,  24, w15, w13, w0);
      TEST_3RF_3("fmsub.w", dataf,  32,  16,  32, w23, w5,  w12);
      TEST_3RF_3("fmsub.w", dataf,  32,  16,  40, w12, w25, w15);
      TEST_3RF_3("fmsub.w", dataf,  32,  16,  48, w2,  w29, w16);
      TEST_3RF_3("fmsub.w", dataf,  32,  16,  56, w21, w19, w19);
      TEST_3RF_3("fmsub.w", dataf,  32,  16,  64, w2,  w18, w1);
      TEST_3RF_3("fmsub.w", dataf,  32,  16,  72, w24, w3,  w5);
      TEST_3RF_3("fmsub.w", dataf,  32,  24,   0, w20, w1,  w30);
      TEST_3RF_3("fmsub.w", dataf,  32,  24,   8, w9,  w0,  w31);
      TEST_3RF_3("fmsub.w", dataf,  32,  24,  16, w5,  w16, w7);
      TEST_3RF_3("fmsub.w", dataf,  32,  24,  24, w17, w0,  w20);
      TEST_3RF_3("fmsub.w", dataf,  32,  24,  32, w17, w23, w25);
      TEST_3RF_3("fmsub.w", dataf,  32,  24,  40, w30, w3,  w18);
      TEST_3RF_3("fmsub.w", dataf,  32,  24,  48, w13, w5,  w15);
      TEST_3RF_3("fmsub.w", dataf,  32,  24,  56, w29, w26, w2);
      TEST_3RF_3("fmsub.w", dataf,  32,  24,  64, w31, w12, w4);
      TEST_3RF_3("fmsub.w", dataf,  32,  24,  72, w23, w16, w28);
      TEST_3RF_3("fmsub.w", dataf,  32,  32,   0, w28, w4,  w29);
      TEST_3RF_3("fmsub.w", dataf,  32,  32,   8, w26, w26, w26);
      TEST_3RF_3("fmsub.w", dataf,  32,  32,  16, w13, w30, w25);
      TEST_3RF_3("fmsub.w", dataf,  32,  32,  24, w18, w14, w18);
      TEST_3RF_3("fmsub.w", dataf,  32,  32,  32, w0,  w3,  w14);
      TEST_3RF_3("fmsub.w", dataf,  32,  32,  40, w21, w5,  w5);
      TEST_3RF_3("fmsub.w", dataf,  32,  32,  48, w14, w19, w8);
      TEST_3RF_3("fmsub.w", dataf,  32,  32,  56, w1,  w0,  w13);
      TEST_3RF_3("fmsub.w", dataf,  32,  32,  64, w16, w29, w8);
      TEST_3RF_3("fmsub.w", dataf,  32,  32,  72, w19, w28, w20);
      TEST_3RF_3("fmsub.w", dataf,  32,  40,   0, w23, w19, w4);
      TEST_3RF_3("fmsub.w", dataf,  32,  40,   8, w19, w15, w8);
      TEST_3RF_3("fmsub.w", dataf,  32,  40,  16, w17, w9,  w21);
      TEST_3RF_3("fmsub.w", dataf,  32,  40,  24, w15, w3,  w7);
      TEST_3RF_3("fmsub.w", dataf,  32,  40,  32, w29, w3,  w11);
      TEST_3RF_3("fmsub.w", dataf,  32,  40,  40, w12, w24, w0);
      TEST_3RF_3("fmsub.w", dataf,  32,  40,  48, w17, w7,  w19);
      TEST_3RF_3("fmsub.w", dataf,  32,  40,  56, w26, w26, w26);
      TEST_3RF_3("fmsub.w", dataf,  32,  40,  64, w8,  w19, w7);
      TEST_3RF_3("fmsub.w", dataf,  32,  40,  72, w24, w16, w15);
      TEST_3RF_3("fmsub.w", dataf,  32,  48,   0, w11, w12, w4);
      TEST_3RF_3("fmsub.w", dataf,  32,  48,   8, w2,  w31, w8);
      TEST_3RF_3("fmsub.w", dataf,  32,  48,  16, w22, w14, w17);
      TEST_3RF_3("fmsub.w", dataf,  32,  48,  24, w7,  w23, w6);
      TEST_3RF_3("fmsub.w", dataf,  32,  48,  32, w22, w26, w14);
      TEST_3RF_3("fmsub.w", dataf,  32,  48,  40, w19, w30, w25);
      TEST_3RF_3("fmsub.w", dataf,  32,  48,  48, w31, w22, w25);
      TEST_3RF_3("fmsub.w", dataf,  32,  48,  56, w17, w29, w12);
      TEST_3RF_3("fmsub.w", dataf,  32,  48,  64, w11, w5,  w31);
      TEST_3RF_3("fmsub.w", dataf,  32,  48,  72, w18, w30, w18);
      TEST_3RF_3("fmsub.w", dataf,  32,  56,   0, w15, w2,  w9);
      TEST_3RF_3("fmsub.w", dataf,  32,  56,   8, w27, w6,  w12);
      TEST_3RF_3("fmsub.w", dataf,  32,  56,  16, w26, w26, w26);
      TEST_3RF_3("fmsub.w", dataf,  32,  56,  24, w14, w2,  w8);
      TEST_3RF_3("fmsub.w", dataf,  32,  56,  32, w31, w9,  w6);
      TEST_3RF_3("fmsub.w", dataf,  32,  56,  40, w31, w26, w20);
      TEST_3RF_3("fmsub.w", dataf,  32,  56,  48, w18, w24, w18);
      TEST_3RF_3("fmsub.w", dataf,  32,  56,  56, w13, w18, w14);
      TEST_3RF_3("fmsub.w", dataf,  32,  56,  64, w6,  w3,  w12);
      TEST_3RF_3("fmsub.w", dataf,  32,  56,  72, w18, w14, w18);
      TEST_3RF_3("fmsub.w", dataf,  32,  64,   0, w17, w0,  w15);
      TEST_3RF_3("fmsub.w", dataf,  32,  64,   8, w0,  w2,  w25);
      TEST_3RF_3("fmsub.w", dataf,  32,  64,  16, w27, w8,  w5);
      TEST_3RF_3("fmsub.w", dataf,  32,  64,  24, w21, w23, w23);
      TEST_3RF_3("fmsub.w", dataf,  32,  64,  32, w7,  w29, w22);
      TEST_3RF_3("fmsub.w", dataf,  32,  64,  40, w16, w28, w15);
      TEST_3RF_3("fmsub.w", dataf,  32,  64,  48, w22, w16, w1);
      TEST_3RF_3("fmsub.w", dataf,  32,  64,  56, w14, w29, w19);
      TEST_3RF_3("fmsub.w", dataf,  32,  64,  64, w29, w3,  w22);
      TEST_3RF_3("fmsub.w", dataf,  32,  64,  72, w9,  w21, w4);
      TEST_3RF_3("fmsub.w", dataf,  32,  72,   0, w26, w26, w26);
      TEST_3RF_3("fmsub.w", dataf,  32,  72,   8, w6,  w5,  w10);
      TEST_3RF_3("fmsub.w", dataf,  32,  72,  16, w6,  w7,  w3);
      TEST_3RF_3("fmsub.w", dataf,  32,  72,  24, w1,  w16, w8);
      TEST_3RF_3("fmsub.w", dataf,  32,  72,  32, w22, w7,  w15);
      TEST_3RF_3("fmsub.w", dataf,  32,  72,  40, w19, w29, w31);
      TEST_3RF_3("fmsub.w", dataf,  32,  72,  48, w16, w26, w14);
      TEST_3RF_3("fmsub.w", dataf,  32,  72,  56, w6,  w10, w15);
      TEST_3RF_3("fmsub.w", dataf,  32,  72,  64, w21, w8,  w8);
      TEST_3RF_3("fmsub.w", dataf,  32,  72,  72, w3,  w18, w11);
      TEST_3RF_3("fmsub.w", dataf,  40,   0,   0, w25, w27, w1);
      TEST_3RF_3("fmsub.w", dataf,  40,   0,   8, w30, w21, w7);
      TEST_3RF_3("fmsub.w", dataf,  40,   0,  16, w3,  w31, w14);
      TEST_3RF_3("fmsub.w", dataf,  40,   0,  24, w10, w10, w2);
      TEST_3RF_3("fmsub.w", dataf,  40,   0,  32, w15, w26, w10);
      TEST_3RF_3("fmsub.w", dataf,  40,   0,  40, w6,  w1,  w25);
      TEST_3RF_3("fmsub.w", dataf,  40,   0,  48, w25, w31, w24);
      TEST_3RF_3("fmsub.w", dataf,  40,   0,  56, w9,  w25, w6);
      TEST_3RF_3("fmsub.w", dataf,  40,   0,  64, w16, w3,  w22);
      TEST_3RF_3("fmsub.w", dataf,  40,   0,  72, w5,  w11, w25);
      TEST_3RF_3("fmsub.w", dataf,  40,   8,   0, w23, w18, w24);
      TEST_3RF_3("fmsub.w", dataf,  40,   8,   8, w16, w7,  w31);
      TEST_3RF_3("fmsub.w", dataf,  40,   8,  16, w19, w7,  w13);
      TEST_3RF_3("fmsub.w", dataf,  40,   8,  24, w30, w9,  w29);
      TEST_3RF_3("fmsub.w", dataf,  40,   8,  32, w24, w20, w3);
      TEST_3RF_3("fmsub.w", dataf,  40,   8,  40, w26, w26, w26);
      TEST_3RF_3("fmsub.w", dataf,  40,   8,  48, w13, w28, w25);
      TEST_3RF_3("fmsub.w", dataf,  40,   8,  56, w6,  w18, w12);
      TEST_3RF_3("fmsub.w", dataf,  40,   8,  64, w22, w21, w2);
      TEST_3RF_3("fmsub.w", dataf,  40,   8,  72, w27, w1,  w18);
      TEST_3RF_3("fmsub.w", dataf,  40,  16,   0, w24, w14, w4);
      TEST_3RF_3("fmsub.w", dataf,  40,  16,   8, w16, w30, w11);
      TEST_3RF_3("fmsub.w", dataf,  40,  16,  16, w15, w18, w29);
      TEST_3RF_3("fmsub.w", dataf,  40,  16,  24, w16, w28, w26);
      TEST_3RF_3("fmsub.w", dataf,  40,  16,  32, w8,  w16, w29);
      TEST_3RF_3("fmsub.w", dataf,  40,  16,  40, w2,  w29, w25);
      TEST_3RF_3("fmsub.w", dataf,  40,  16,  48, w27, w3,  w31);
      TEST_3RF_3("fmsub.w", dataf,  40,  16,  56, w13, w16, w21);
      TEST_3RF_3("fmsub.w", dataf,  40,  16,  64, w3,  w18, w16);
      TEST_3RF_3("fmsub.w", dataf,  40,  16,  72, w4,  w14, w2);
      TEST_3RF_3("fmsub.w", dataf,  40,  24,   0, w28, w6,  w12);
      TEST_3RF_3("fmsub.w", dataf,  40,  24,   8, w26, w26, w26);
      TEST_3RF_3("fmsub.w", dataf,  40,  24,  16, w18, w27, w18);
      TEST_3RF_3("fmsub.w", dataf,  40,  24,  24, w12, w4,  w24);
      TEST_3RF_3("fmsub.w", dataf,  40,  24,  32, w28, w0,  w18);
      TEST_3RF_3("fmsub.w", dataf,  40,  24,  40, w5,  w16, w15);
      TEST_3RF_3("fmsub.w", dataf,  40,  24,  48, w7,  w14, w9);
      TEST_3RF_3("fmsub.w", dataf,  40,  24,  56, w3,  w17, w8);
      TEST_3RF_3("fmsub.w", dataf,  40,  24,  64, w16, w1,  w30);
      TEST_3RF_3("fmsub.w", dataf,  40,  24,  72, w19, w20, w14);
      TEST_3RF_3("fmsub.w", dataf,  40,  32,   0, w23, w2,  w17);
      TEST_3RF_3("fmsub.w", dataf,  40,  32,   8, w19, w30, w23);
      TEST_3RF_3("fmsub.w", dataf,  40,  32,  16, w31, w24, w9);
      TEST_3RF_3("fmsub.w", dataf,  40,  32,  24, w27, w5,  w14);
      TEST_3RF_3("fmsub.w", dataf,  40,  32,  32, w19, w1,  w14);
      TEST_3RF_3("fmsub.w", dataf,  40,  32,  40, w6,  w31, w21);
      TEST_3RF_3("fmsub.w", dataf,  40,  32,  48, w14, w13, w30);
      TEST_3RF_3("fmsub.w", dataf,  40,  32,  56, w17, w30, w7);
      TEST_3RF_3("fmsub.w", dataf,  40,  32,  64, w1,  w0,  w5);
      TEST_3RF_3("fmsub.w", dataf,  40,  32,  72, w21, w20, w20);
      TEST_3RF_3("fmsub.w", dataf,  40,  40,   0, w19, w12, w22);
      TEST_3RF_3("fmsub.w", dataf,  40,  40,   8, w4,  w0,  w20);
      TEST_3RF_3("fmsub.w", dataf,  40,  40,  16, w28, w31, w12);
      TEST_3RF_3("fmsub.w", dataf,  40,  40,  24, w5,  w26, w17);
      TEST_3RF_3("fmsub.w", dataf,  40,  40,  32, w19, w14, w2);
      TEST_3RF_3("fmsub.w", dataf,  40,  40,  40, w20, w25, w1);
      TEST_3RF_3("fmsub.w", dataf,  40,  40,  48, w9,  w7,  w14);
      TEST_3RF_3("fmsub.w", dataf,  40,  40,  56, w8,  w24, w12);
      TEST_3RF_3("fmsub.w", dataf,  40,  40,  64, w15, w26, w12);
      TEST_3RF_3("fmsub.w", dataf,  40,  40,  72, w20, w15, w0);
      TEST_3RF_3("fmsub.w", dataf,  40,  48,   0, w7,  w27, w22);
      TEST_3RF_3("fmsub.w", dataf,  40,  48,   8, w12, w27, w10);
      TEST_3RF_3("fmsub.w", dataf,  40,  48,  16, w8,  w27, w23);
      TEST_3RF_3("fmsub.w", dataf,  40,  48,  24, w13, w21, w8);
      TEST_3RF_3("fmsub.w", dataf,  40,  48,  32, w1,  w3,  w27);
      TEST_3RF_3("fmsub.w", dataf,  40,  48,  40, w3,  w23, w21);
      TEST_3RF_3("fmsub.w", dataf,  40,  48,  48, w4,  w1,  w28);
      TEST_3RF_3("fmsub.w", dataf,  40,  48,  56, w18, w9,  w18);
      TEST_3RF_3("fmsub.w", dataf,  40,  48,  64, w21, w30, w30);
      TEST_3RF_3("fmsub.w", dataf,  40,  48,  72, w24, w15, w11);
      TEST_3RF_3("fmsub.w", dataf,  40,  56,   0, w12, w30, w11);
      TEST_3RF_3("fmsub.w", dataf,  40,  56,   8, w19, w25, w2);
      TEST_3RF_3("fmsub.w", dataf,  40,  56,  16, w31, w21, w12);
      TEST_3RF_3("fmsub.w", dataf,  40,  56,  24, w7,  w16, w3);
      TEST_3RF_3("fmsub.w", dataf,  40,  56,  32, w21, w5,  w5);
      TEST_3RF_3("fmsub.w", dataf,  40,  56,  40, w12, w22, w9);
      TEST_3RF_3("fmsub.w", dataf,  40,  56,  48, w7,  w25, w0);
      TEST_3RF_3("fmsub.w", dataf,  40,  56,  56, w28, w29, w1);
      TEST_3RF_3("fmsub.w", dataf,  40,  56,  64, w25, w15, w10);
      TEST_3RF_3("fmsub.w", dataf,  40,  56,  72, w14, w13, w2);
      TEST_3RF_3("fmsub.w", dataf,  40,  64,   0, w29, w24, w14);
      TEST_3RF_3("fmsub.w", dataf,  40,  64,   8, w27, w4,  w2);
      TEST_3RF_3("fmsub.w", dataf,  40,  64,  16, w20, w6,  w1);
      TEST_3RF_3("fmsub.w", dataf,  40,  64,  24, w9,  w18, w25);
      TEST_3RF_3("fmsub.w", dataf,  40,  64,  32, w22, w30, w31);
      TEST_3RF_3("fmsub.w", dataf,  40,  64,  40, w2,  w20, w8);
      TEST_3RF_3("fmsub.w", dataf,  40,  64,  48, w9,  w13, w8);
      TEST_3RF_3("fmsub.w", dataf,  40,  64,  56, w6,  w10, w31);
      TEST_3RF_3("fmsub.w", dataf,  40,  64,  64, w25, w20, w13);
      TEST_3RF_3("fmsub.w", dataf,  40,  64,  72, w6,  w23, w10);
      TEST_3RF_3("fmsub.w", dataf,  40,  72,   0, w31, w5,  w3);
      TEST_3RF_3("fmsub.w", dataf,  40,  72,   8, w7,  w25, w9);
      TEST_3RF_3("fmsub.w", dataf,  40,  72,  16, w9,  w3,  w27);
      TEST_3RF_3("fmsub.w", dataf,  40,  72,  24, w18, w28, w18);
      TEST_3RF_3("fmsub.w", dataf,  40,  72,  32, w17, w16, w27);
      TEST_3RF_3("fmsub.w", dataf,  40,  72,  40, w19, w4,  w3);
      TEST_3RF_3("fmsub.w", dataf,  40,  72,  48, w29, w17, w12);
      TEST_3RF_3("fmsub.w", dataf,  40,  72,  56, w3,  w27, w22);
      TEST_3RF_3("fmsub.w", dataf,  40,  72,  64, w2,  w20, w10);
      TEST_3RF_3("fmsub.w", dataf,  40,  72,  72, w15, w26, w1);
      TEST_3RF_3("fmsub.w", dataf,  48,   0,   0, w25, w7,  w30);
      TEST_3RF_3("fmsub.w", dataf,  48,   0,   8, w28, w14, w23);
      TEST_3RF_3("fmsub.w", dataf,  48,   0,  16, w5,  w23, w26);
      TEST_3RF_3("fmsub.w", dataf,  48,   0,  24, w1,  w9,  w23);
      TEST_3RF_3("fmsub.w", dataf,  48,   0,  32, w18, w25, w18);
      TEST_3RF_3("fmsub.w", dataf,  48,   0,  40, w18, w6,  w18);
      TEST_3RF_3("fmsub.w", dataf,  48,   0,  48, w29, w22, w3);
      TEST_3RF_3("fmsub.w", dataf,  48,   0,  56, w14, w2,  w6);
      TEST_3RF_3("fmsub.w", dataf,  48,   0,  64, w9,  w24, w8);
      TEST_3RF_3("fmsub.w", dataf,  48,   0,  72, w29, w2,  w23);
      TEST_3RF_3("fmsub.w", dataf,  48,   8,   0, w24, w4,  w16);
      TEST_3RF_3("fmsub.w", dataf,  48,   8,   8, w17, w11, w14);
      TEST_3RF_3("fmsub.w", dataf,  48,   8,  16, w14, w25, w5);
      TEST_3RF_3("fmsub.w", dataf,  48,   8,  24, w19, w17, w0);
      TEST_3RF_3("fmsub.w", dataf,  48,   8,  32, w20, w26, w23);
      TEST_3RF_3("fmsub.w", dataf,  48,   8,  40, w7,  w20, w9);
      TEST_3RF_3("fmsub.w", dataf,  48,   8,  48, w13, w17, w31);
      TEST_3RF_3("fmsub.w", dataf,  48,   8,  56, w16, w0,  w1);
      TEST_3RF_3("fmsub.w", dataf,  48,   8,  64, w22, w9,  w25);
      TEST_3RF_3("fmsub.w", dataf,  48,   8,  72, w30, w7,  w28);
      TEST_3RF_3("fmsub.w", dataf,  48,  16,   0, w21, w31, w31);
      TEST_3RF_3("fmsub.w", dataf,  48,  16,   8, w0,  w5,  w16);
      TEST_3RF_3("fmsub.w", dataf,  48,  16,  16, w11, w19, w30);
      TEST_3RF_3("fmsub.w", dataf,  48,  16,  24, w4,  w24, w18);
      TEST_3RF_3("fmsub.w", dataf,  48,  16,  32, w21, w24, w24);
      TEST_3RF_3("fmsub.w", dataf,  48,  16,  40, w6,  w16, w15);
      TEST_3RF_3("fmsub.w", dataf,  48,  16,  48, w13, w4,  w25);
      TEST_3RF_3("fmsub.w", dataf,  48,  16,  56, w26, w26, w26);
      TEST_3RF_3("fmsub.w", dataf,  48,  16,  64, w21, w24, w24);
      TEST_3RF_3("fmsub.w", dataf,  48,  16,  72, w10, w10, w21);
      TEST_3RF_3("fmsub.w", dataf,  48,  24,   0, w26, w26, w26);
      TEST_3RF_3("fmsub.w", dataf,  48,  24,   8, w0,  w31, w19);
      TEST_3RF_3("fmsub.w", dataf,  48,  24,  16, w30, w6,  w15);
      TEST_3RF_3("fmsub.w", dataf,  48,  24,  24, w19, w5,  w15);
      TEST_3RF_3("fmsub.w", dataf,  48,  24,  32, w24, w21, w26);
      TEST_3RF_3("fmsub.w", dataf,  48,  24,  40, w11, w20, w31);
      TEST_3RF_3("fmsub.w", dataf,  48,  24,  48, w4,  w6,  w20);
      TEST_3RF_3("fmsub.w", dataf,  48,  24,  56, w28, w12, w4);
      TEST_3RF_3("fmsub.w", dataf,  48,  24,  64, w12, w26, w8);
      TEST_3RF_3("fmsub.w", dataf,  48,  24,  72, w5,  w20, w30);
      TEST_3RF_3("fmsub.w", dataf,  48,  32,   0, w29, w31, w19);
      TEST_3RF_3("fmsub.w", dataf,  48,  32,   8, w23, w31, w18);
      TEST_3RF_3("fmsub.w", dataf,  48,  32,  16, w11, w30, w24);
      TEST_3RF_3("fmsub.w", dataf,  48,  32,  24, w26, w26, w26);
      TEST_3RF_3("fmsub.w", dataf,  48,  32,  32, w17, w29, w10);
      TEST_3RF_3("fmsub.w", dataf,  48,  32,  40, w10, w10, w19);
      TEST_3RF_3("fmsub.w", dataf,  48,  32,  48, w4,  w21, w7);
      TEST_3RF_3("fmsub.w", dataf,  48,  32,  56, w3,  w25, w13);
      TEST_3RF_3("fmsub.w", dataf,  48,  32,  64, w24, w22, w25);
      TEST_3RF_3("fmsub.w", dataf,  48,  32,  72, w28, w2,  w19);
      TEST_3RF_3("fmsub.w", dataf,  48,  40,   0, w5,  w7,  w8);
      TEST_3RF_3("fmsub.w", dataf,  48,  40,   8, w3,  w4,  w7);
      TEST_3RF_3("fmsub.w", dataf,  48,  40,  16, w22, w28, w6);
      TEST_3RF_3("fmsub.w", dataf,  48,  40,  24, w9,  w7,  w4);
      TEST_3RF_3("fmsub.w", dataf,  48,  40,  32, w1,  w22, w31);
      TEST_3RF_3("fmsub.w", dataf,  48,  40,  40, w11, w0,  w18);
      TEST_3RF_3("fmsub.w", dataf,  48,  40,  48, w16, w21, w25);
      TEST_3RF_3("fmsub.w", dataf,  48,  40,  56, w19, w15, w6);
      TEST_3RF_3("fmsub.w", dataf,  48,  40,  64, w11, w5,  w31);
      TEST_3RF_3("fmsub.w", dataf,  48,  40,  72, w8,  w7,  w19);
      TEST_3RF_3("fmsub.w", dataf,  48,  48,   0, w13, w14, w27);
      TEST_3RF_3("fmsub.w", dataf,  48,  48,   8, w16, w18, w2);
      TEST_3RF_3("fmsub.w", dataf,  48,  48,  16, w6,  w14, w8);
      TEST_3RF_3("fmsub.w", dataf,  48,  48,  24, w15, w21, w13);
      TEST_3RF_3("fmsub.w", dataf,  48,  48,  32, w17, w23, w3);
      TEST_3RF_3("fmsub.w", dataf,  48,  48,  40, w16, w2,  w3);
      TEST_3RF_3("fmsub.w", dataf,  48,  48,  48, w2,  w18, w24);
      TEST_3RF_3("fmsub.w", dataf,  48,  48,  56, w27, w6,  w7);
      TEST_3RF_3("fmsub.w", dataf,  48,  48,  64, w1,  w17, w12);
      TEST_3RF_3("fmsub.w", dataf,  48,  48,  72, w0,  w25, w19);
      TEST_3RF_3("fmsub.w", dataf,  48,  56,   0, w19, w6,  w1);
      TEST_3RF_3("fmsub.w", dataf,  48,  56,   8, w14, w22, w20);
      TEST_3RF_3("fmsub.w", dataf,  48,  56,  16, w16, w29, w2);
      TEST_3RF_3("fmsub.w", dataf,  48,  56,  24, w25, w12, w24);
      TEST_3RF_3("fmsub.w", dataf,  48,  56,  32, w6,  w29, w15);
      TEST_3RF_3("fmsub.w", dataf,  48,  56,  40, w9,  w13, w17);
      TEST_3RF_3("fmsub.w", dataf,  48,  56,  48, w12, w15, w4);
      TEST_3RF_3("fmsub.w", dataf,  48,  56,  56, w4,  w10, w12);
      TEST_3RF_3("fmsub.w", dataf,  48,  56,  64, w11, w27, w24);
      TEST_3RF_3("fmsub.w", dataf,  48,  56,  72, w12, w21, w31);
      TEST_3RF_3("fmsub.w", dataf,  48,  64,   0, w27, w13, w14);
      TEST_3RF_3("fmsub.w", dataf,  48,  64,   8, w18, w1,  w18);
      TEST_3RF_3("fmsub.w", dataf,  48,  64,  16, w30, w15, w4);
      TEST_3RF_3("fmsub.w", dataf,  48,  64,  24, w23, w27, w28);
      TEST_3RF_3("fmsub.w", dataf,  48,  64,  32, w29, w25, w11);
      TEST_3RF_3("fmsub.w", dataf,  48,  64,  40, w6,  w28, w18);
      TEST_3RF_3("fmsub.w", dataf,  48,  64,  48, w22, w0,  w23);
      TEST_3RF_3("fmsub.w", dataf,  48,  64,  56, w0,  w10, w3);
      TEST_3RF_3("fmsub.w", dataf,  48,  64,  64, w12, w6,  w27);
      TEST_3RF_3("fmsub.w", dataf,  48,  64,  72, w24, w27, w7);
      TEST_3RF_3("fmsub.w", dataf,  48,  72,   0, w23, w22, w21);
      TEST_3RF_3("fmsub.w", dataf,  48,  72,   8, w5,  w8,  w22);
      TEST_3RF_3("fmsub.w", dataf,  48,  72,  16, w4,  w23, w26);
      TEST_3RF_3("fmsub.w", dataf,  48,  72,  24, w27, w19, w22);
      TEST_3RF_3("fmsub.w", dataf,  48,  72,  32, w25, w12, w1);
      TEST_3RF_3("fmsub.w", dataf,  48,  72,  40, w31, w18, w30);
      TEST_3RF_3("fmsub.w", dataf,  48,  72,  48, w18, w8,  w18);
      TEST_3RF_3("fmsub.w", dataf,  48,  72,  56, w30, w9,  w12);
      TEST_3RF_3("fmsub.w", dataf,  48,  72,  64, w21, w15, w15);
      TEST_3RF_3("fmsub.w", dataf,  48,  72,  72, w7,  w13, w10);
      TEST_3RF_3("fmsub.w", dataf,  56,   0,   0, w15, w4,  w0);
      TEST_3RF_3("fmsub.w", dataf,  56,   0,   8, w4,  w10, w9);
      TEST_3RF_3("fmsub.w", dataf,  56,   0,  16, w26, w26, w26);
      TEST_3RF_3("fmsub.w", dataf,  56,   0,  24, w14, w0,  w21);
      TEST_3RF_3("fmsub.w", dataf,  56,   0,  32, w9,  w19, w11);
      TEST_3RF_3("fmsub.w", dataf,  56,   0,  40, w2,  w31, w13);
      TEST_3RF_3("fmsub.w", dataf,  56,   0,  48, w2,  w18, w11);
      TEST_3RF_3("fmsub.w", dataf,  56,   0,  56, w20, w26, w9);
      TEST_3RF_3("fmsub.w", dataf,  56,   0,  64, w29, w3,  w18);
      TEST_3RF_3("fmsub.w", dataf,  56,   0,  72, w9,  w24, w1);
      TEST_3RF_3("fmsub.w", dataf,  56,   8,   0, w16, w5,  w11);
      TEST_3RF_3("fmsub.w", dataf,  56,   8,   8, w31, w10, w12);
      TEST_3RF_3("fmsub.w", dataf,  56,   8,  16, w3,  w20, w21);
      TEST_3RF_3("fmsub.w", dataf,  56,   8,  24, w30, w2,  w21);
      TEST_3RF_3("fmsub.w", dataf,  56,   8,  32, w19, w11, w9);
      TEST_3RF_3("fmsub.w", dataf,  56,   8,  40, w30, w14, w8);
      TEST_3RF_3("fmsub.w", dataf,  56,   8,  48, w11, w16, w26);
      TEST_3RF_3("fmsub.w", dataf,  56,   8,  56, w22, w4,  w21);
      TEST_3RF_3("fmsub.w", dataf,  56,   8,  64, w0,  w1,  w24);
      TEST_3RF_3("fmsub.w", dataf,  56,   8,  72, w18, w10, w18);
      TEST_3RF_3("fmsub.w", dataf,  56,  16,   0, w17, w20, w26);
      TEST_3RF_3("fmsub.w", dataf,  56,  16,   8, w22, w31, w26);
      TEST_3RF_3("fmsub.w", dataf,  56,  16,  16, w0,  w11, w29);
      TEST_3RF_3("fmsub.w", dataf,  56,  16,  24, w20, w0,  w27);
      TEST_3RF_3("fmsub.w", dataf,  56,  16,  32, w22, w14, w2);
      TEST_3RF_3("fmsub.w", dataf,  56,  16,  40, w31, w13, w16);
      TEST_3RF_3("fmsub.w", dataf,  56,  16,  48, w7,  w24, w0);
      TEST_3RF_3("fmsub.w", dataf,  56,  16,  56, w2,  w15, w4);
      TEST_3RF_3("fmsub.w", dataf,  56,  16,  64, w23, w15, w5);
      TEST_3RF_3("fmsub.w", dataf,  56,  16,  72, w15, w1,  w0);
      TEST_3RF_3("fmsub.w", dataf,  56,  24,   0, w21, w9,  w9);
      TEST_3RF_3("fmsub.w", dataf,  56,  24,   8, w23, w21, w3);
      TEST_3RF_3("fmsub.w", dataf,  56,  24,  16, w23, w0,  w1);
      TEST_3RF_3("fmsub.w", dataf,  56,  24,  24, w12, w1,  w28);
      TEST_3RF_3("fmsub.w", dataf,  56,  24,  32, w2,  w23, w11);
      TEST_3RF_3("fmsub.w", dataf,  56,  24,  40, w4,  w22, w24);
      TEST_3RF_3("fmsub.w", dataf,  56,  24,  48, w20, w29, w16);
      TEST_3RF_3("fmsub.w", dataf,  56,  24,  56, w20, w31, w24);
      TEST_3RF_3("fmsub.w", dataf,  56,  24,  64, w22, w14, w29);
      TEST_3RF_3("fmsub.w", dataf,  56,  24,  72, w6,  w16, w12);
      TEST_3RF_3("fmsub.w", dataf,  56,  32,   0, w6,  w5,  w22);
      TEST_3RF_3("fmsub.w", dataf,  56,  32,   8, w29, w26, w25);
      TEST_3RF_3("fmsub.w", dataf,  56,  32,  16, w21, w27, w27);
      TEST_3RF_3("fmsub.w", dataf,  56,  32,  24, w26, w26, w26);
      TEST_3RF_3("fmsub.w", dataf,  56,  32,  32, w1,  w28, w23);
      TEST_3RF_3("fmsub.w", dataf,  56,  32,  40, w3,  w19, w2);
      TEST_3RF_3("fmsub.w", dataf,  56,  32,  48, w8,  w9,  w26);
      TEST_3RF_3("fmsub.w", dataf,  56,  32,  56, w28, w6,  w10);
      TEST_3RF_3("fmsub.w", dataf,  56,  32,  64, w17, w6,  w10);
      TEST_3RF_3("fmsub.w", dataf,  56,  32,  72, w9,  w28, w24);
      TEST_3RF_3("fmsub.w", dataf,  56,  40,   0, w7,  w2,  w8);
      TEST_3RF_3("fmsub.w", dataf,  56,  40,   8, w19, w9,  w14);
      TEST_3RF_3("fmsub.w", dataf,  56,  40,  16, w9,  w6,  w8);
      TEST_3RF_3("fmsub.w", dataf,  56,  40,  24, w3,  w27, w29);
      TEST_3RF_3("fmsub.w", dataf,  56,  40,  32, w28, w31, w20);
      TEST_3RF_3("fmsub.w", dataf,  56,  40,  40, w0,  w18, w22);
      TEST_3RF_3("fmsub.w", dataf,  56,  40,  48, w8,  w27, w16);
      TEST_3RF_3("fmsub.w", dataf,  56,  40,  56, w4,  w2,  w27);
      TEST_3RF_3("fmsub.w", dataf,  56,  40,  64, w21, w8,  w8);
      TEST_3RF_3("fmsub.w", dataf,  56,  40,  72, w5,  w31, w4);
      TEST_3RF_3("fmsub.w", dataf,  56,  48,   0, w29, w6,  w7);
      TEST_3RF_3("fmsub.w", dataf,  56,  48,   8, w6,  w25, w16);
      TEST_3RF_3("fmsub.w", dataf,  56,  48,  16, w20, w3,  w22);
      TEST_3RF_3("fmsub.w", dataf,  56,  48,  24, w28, w6,  w18);
      TEST_3RF_3("fmsub.w", dataf,  56,  48,  32, w0,  w3,  w14);
      TEST_3RF_3("fmsub.w", dataf,  56,  48,  40, w31, w24, w14);
      TEST_3RF_3("fmsub.w", dataf,  56,  48,  48, w18, w14, w18);
      TEST_3RF_3("fmsub.w", dataf,  56,  48,  56, w22, w13, w31);
      TEST_3RF_3("fmsub.w", dataf,  56,  48,  64, w27, w15, w26);
      TEST_3RF_3("fmsub.w", dataf,  56,  48,  72, w16, w23, w31);
      TEST_3RF_3("fmsub.w", dataf,  56,  56,   0, w15, w28, w21);
      TEST_3RF_3("fmsub.w", dataf,  56,  56,   8, w3,  w2,  w15);
      TEST_3RF_3("fmsub.w", dataf,  56,  56,  16, w19, w22, w18);
      TEST_3RF_3("fmsub.w", dataf,  56,  56,  24, w9,  w19, w24);
      TEST_3RF_3("fmsub.w", dataf,  56,  56,  32, w27, w19, w10);
      TEST_3RF_3("fmsub.w", dataf,  56,  56,  40, w18, w19, w18);
      TEST_3RF_3("fmsub.w", dataf,  56,  56,  48, w24, w4,  w2);
      TEST_3RF_3("fmsub.w", dataf,  56,  56,  56, w15, w18, w1);
      TEST_3RF_3("fmsub.w", dataf,  56,  56,  64, w10, w10, w1);
      TEST_3RF_3("fmsub.w", dataf,  56,  56,  72, w27, w26, w25);
      TEST_3RF_3("fmsub.w", dataf,  56,  64,   0, w26, w26, w26);
      TEST_3RF_3("fmsub.w", dataf,  56,  64,   8, w10, w10, w21);
      TEST_3RF_3("fmsub.w", dataf,  56,  64,  16, w22, w31, w24);
      TEST_3RF_3("fmsub.w", dataf,  56,  64,  24, w25, w14, w11);
      TEST_3RF_3("fmsub.w", dataf,  56,  64,  32, w15, w0,  w20);
      TEST_3RF_3("fmsub.w", dataf,  56,  64,  40, w2,  w24, w16);
      TEST_3RF_3("fmsub.w", dataf,  56,  64,  48, w21, w20, w20);
      TEST_3RF_3("fmsub.w", dataf,  56,  64,  56, w26, w26, w26);
      TEST_3RF_3("fmsub.w", dataf,  56,  64,  64, w8,  w7,  w18);
      TEST_3RF_3("fmsub.w", dataf,  56,  64,  72, w12, w9,  w1);
      TEST_3RF_3("fmsub.w", dataf,  56,  72,   0, w30, w10, w11);
      TEST_3RF_3("fmsub.w", dataf,  56,  72,   8, w0,  w5,  w6);
      TEST_3RF_3("fmsub.w", dataf,  56,  72,  16, w25, w31, w16);
      TEST_3RF_3("fmsub.w", dataf,  56,  72,  24, w14, w22, w15);
      TEST_3RF_3("fmsub.w", dataf,  56,  72,  32, w6,  w15, w30);
      TEST_3RF_3("fmsub.w", dataf,  56,  72,  40, w17, w30, w5);
      TEST_3RF_3("fmsub.w", dataf,  56,  72,  48, w1,  w23, w21);
      TEST_3RF_3("fmsub.w", dataf,  56,  72,  56, w22, w11, w15);
      TEST_3RF_3("fmsub.w", dataf,  56,  72,  64, w30, w18, w2);
      TEST_3RF_3("fmsub.w", dataf,  56,  72,  72, w11, w28, w3);
      TEST_3RF_3("fmsub.w", dataf,  64,   0,   0, w9,  w6,  w15);
      TEST_3RF_3("fmsub.w", dataf,  64,   0,   8, w9,  w12, w21);
      TEST_3RF_3("fmsub.w", dataf,  64,   0,  16, w2,  w11, w5);
      TEST_3RF_3("fmsub.w", dataf,  64,   0,  24, w16, w1,  w20);
      TEST_3RF_3("fmsub.w", dataf,  64,   0,  32, w22, w16, w18);
      TEST_3RF_3("fmsub.w", dataf,  64,   0,  40, w7,  w15, w17);
      TEST_3RF_3("fmsub.w", dataf,  64,   0,  48, w13, w16, w8);
      TEST_3RF_3("fmsub.w", dataf,  64,   0,  56, w2,  w6,  w19);
      TEST_3RF_3("fmsub.w", dataf,  64,   0,  64, w18, w5,  w18);
      TEST_3RF_3("fmsub.w", dataf,  64,   0,  72, w5,  w20, w16);
      TEST_3RF_3("fmsub.w", dataf,  64,   8,   0, w1,  w23, w25);
      TEST_3RF_3("fmsub.w", dataf,  64,   8,   8, w8,  w6,  w3);
      TEST_3RF_3("fmsub.w", dataf,  64,   8,  16, w20, w27, w5);
      TEST_3RF_3("fmsub.w", dataf,  64,   8,  24, w31, w0,  w22);
      TEST_3RF_3("fmsub.w", dataf,  64,   8,  32, w1,  w21, w12);
      TEST_3RF_3("fmsub.w", dataf,  64,   8,  40, w17, w7,  w20);
      TEST_3RF_3("fmsub.w", dataf,  64,   8,  48, w0,  w24, w1);
      TEST_3RF_3("fmsub.w", dataf,  64,   8,  56, w16, w0,  w3);
      TEST_3RF_3("fmsub.w", dataf,  64,   8,  64, w23, w19, w21);
      TEST_3RF_3("fmsub.w", dataf,  64,   8,  72, w28, w25, w9);
      TEST_3RF_3("fmsub.w", dataf,  64,  16,   0, w12, w26, w1);
      TEST_3RF_3("fmsub.w", dataf,  64,  16,   8, w5,  w2,  w7);
      TEST_3RF_3("fmsub.w", dataf,  64,  16,  16, w8,  w22, w3);
      TEST_3RF_3("fmsub.w", dataf,  64,  16,  24, w14, w22, w3);
      TEST_3RF_3("fmsub.w", dataf,  64,  16,  32, w4,  w23, w24);
      TEST_3RF_3("fmsub.w", dataf,  64,  16,  40, w16, w8,  w0);
      TEST_3RF_3("fmsub.w", dataf,  64,  16,  48, w4,  w9,  w24);
      TEST_3RF_3("fmsub.w", dataf,  64,  16,  56, w5,  w25, w9);
      TEST_3RF_3("fmsub.w", dataf,  64,  16,  64, w16, w12, w30);
      TEST_3RF_3("fmsub.w", dataf,  64,  16,  72, w12, w5,  w8);
      TEST_3RF_3("fmsub.w", dataf,  64,  24,   0, w24, w0,  w9);
      TEST_3RF_3("fmsub.w", dataf,  64,  24,   8, w30, w2,  w16);
      TEST_3RF_3("fmsub.w", dataf,  64,  24,  16, w6,  w25, w19);
      TEST_3RF_3("fmsub.w", dataf,  64,  24,  24, w20, w15, w23);
      TEST_3RF_3("fmsub.w", dataf,  64,  24,  32, w24, w6,  w15);
      TEST_3RF_3("fmsub.w", dataf,  64,  24,  40, w9,  w14, w15);
      TEST_3RF_3("fmsub.w", dataf,  64,  24,  48, w13, w23, w8);
      TEST_3RF_3("fmsub.w", dataf,  64,  24,  56, w19, w17, w1);
      TEST_3RF_3("fmsub.w", dataf,  64,  24,  64, w28, w1,  w13);
      TEST_3RF_3("fmsub.w", dataf,  64,  24,  72, w26, w26, w26);
      TEST_3RF_3("fmsub.w", dataf,  64,  32,   0, w14, w19, w2);
      TEST_3RF_3("fmsub.w", dataf,  64,  32,   8, w6,  w19, w11);
      TEST_3RF_3("fmsub.w", dataf,  64,  32,  16, w4,  w21, w28);
      TEST_3RF_3("fmsub.w", dataf,  64,  32,  24, w11, w14, w15);
      TEST_3RF_3("fmsub.w", dataf,  64,  32,  32, w31, w29, w6);
      TEST_3RF_3("fmsub.w", dataf,  64,  32,  40, w24, w3,  w22);
      TEST_3RF_3("fmsub.w", dataf,  64,  32,  48, w1,  w18, w5);
      TEST_3RF_3("fmsub.w", dataf,  64,  32,  56, w14, w9,  w13);
      TEST_3RF_3("fmsub.w", dataf,  64,  32,  64, w1,  w26, w14);
      TEST_3RF_3("fmsub.w", dataf,  64,  32,  72, w29, w28, w24);
      TEST_3RF_3("fmsub.w", dataf,  64,  40,   0, w10, w10, w15);
      TEST_3RF_3("fmsub.w", dataf,  64,  40,   8, w26, w26, w26);
      TEST_3RF_3("fmsub.w", dataf,  64,  40,  16, w16, w2,  w6);
      TEST_3RF_3("fmsub.w", dataf,  64,  40,  24, w21, w23, w23);
      TEST_3RF_3("fmsub.w", dataf,  64,  40,  32, w2,  w0,  w6);
      TEST_3RF_3("fmsub.w", dataf,  64,  40,  40, w17, w31, w3);
      TEST_3RF_3("fmsub.w", dataf,  64,  40,  48, w24, w23, w7);
      TEST_3RF_3("fmsub.w", dataf,  64,  40,  56, w14, w24, w25);
      TEST_3RF_3("fmsub.w", dataf,  64,  40,  64, w19, w7,  w2);
      TEST_3RF_3("fmsub.w", dataf,  64,  40,  72, w1,  w8,  w29);
      TEST_3RF_3("fmsub.w", dataf,  64,  48,   0, w15, w6,  w25);
      TEST_3RF_3("fmsub.w", dataf,  64,  48,   8, w11, w30, w3);
      TEST_3RF_3("fmsub.w", dataf,  64,  48,  16, w26, w26, w26);
      TEST_3RF_3("fmsub.w", dataf,  64,  48,  24, w24, w19, w28);
      TEST_3RF_3("fmsub.w", dataf,  64,  48,  32, w30, w8,  w20);
      TEST_3RF_3("fmsub.w", dataf,  64,  48,  40, w0,  w8,  w26);
      TEST_3RF_3("fmsub.w", dataf,  64,  48,  48, w18, w8,  w18);
      TEST_3RF_3("fmsub.w", dataf,  64,  48,  56, w29, w10, w31);
      TEST_3RF_3("fmsub.w", dataf,  64,  48,  64, w4,  w24, w29);
      TEST_3RF_3("fmsub.w", dataf,  64,  48,  72, w11, w31, w0);
      TEST_3RF_3("fmsub.w", dataf,  64,  56,   0, w12, w7,  w29);
      TEST_3RF_3("fmsub.w", dataf,  64,  56,   8, w28, w13, w22);
      TEST_3RF_3("fmsub.w", dataf,  64,  56,  16, w7,  w11, w25);
      TEST_3RF_3("fmsub.w", dataf,  64,  56,  24, w2,  w4,  w12);
      TEST_3RF_3("fmsub.w", dataf,  64,  56,  32, w30, w2,  w21);
      TEST_3RF_3("fmsub.w", dataf,  64,  56,  40, w18, w3,  w18);
      TEST_3RF_3("fmsub.w", dataf,  64,  56,  48, w29, w12, w21);
      TEST_3RF_3("fmsub.w", dataf,  64,  56,  56, w5,  w10, w31);
      TEST_3RF_3("fmsub.w", dataf,  64,  56,  64, w5,  w14, w23);
      TEST_3RF_3("fmsub.w", dataf,  64,  56,  72, w29, w12, w2);
      TEST_3RF_3("fmsub.w", dataf,  64,  64,   0, w28, w12, w15);
      TEST_3RF_3("fmsub.w", dataf,  64,  64,   8, w3,  w9,  w11);
      TEST_3RF_3("fmsub.w", dataf,  64,  64,  16, w17, w31, w18);
      TEST_3RF_3("fmsub.w", dataf,  64,  64,  24, w28, w24, w20);
      TEST_3RF_3("fmsub.w", dataf,  64,  64,  32, w0,  w4,  w19);
      TEST_3RF_3("fmsub.w", dataf,  64,  64,  40, w3,  w25, w5);
      TEST_3RF_3("fmsub.w", dataf,  64,  64,  48, w6,  w23, w18);
      TEST_3RF_3("fmsub.w", dataf,  64,  64,  56, w27, w28, w26);
      TEST_3RF_3("fmsub.w", dataf,  64,  64,  64, w1,  w10, w17);
      TEST_3RF_3("fmsub.w", dataf,  64,  64,  72, w30, w22, w19);
      TEST_3RF_3("fmsub.w", dataf,  64,  72,   0, w26, w26, w26);
      TEST_3RF_3("fmsub.w", dataf,  64,  72,   8, w2,  w30, w11);
      TEST_3RF_3("fmsub.w", dataf,  64,  72,  16, w13, w15, w10);
      TEST_3RF_3("fmsub.w", dataf,  64,  72,  24, w0,  w11, w2);
      TEST_3RF_3("fmsub.w", dataf,  64,  72,  32, w20, w12, w7);
      TEST_3RF_3("fmsub.w", dataf,  64,  72,  40, w7,  w15, w0);
      TEST_3RF_3("fmsub.w", dataf,  64,  72,  48, w13, w21, w23);
      TEST_3RF_3("fmsub.w", dataf,  64,  72,  56, w31, w16, w20);
      TEST_3RF_3("fmsub.w", dataf,  64,  72,  64, w27, w10, w21);
      TEST_3RF_3("fmsub.w", dataf,  64,  72,  72, w5,  w27, w20);
      TEST_3RF_3("fmsub.w", dataf,  72,   0,   0, w28, w14, w30);
      TEST_3RF_3("fmsub.w", dataf,  72,   0,   8, w17, w12, w10);
      TEST_3RF_3("fmsub.w", dataf,  72,   0,  16, w30, w27, w20);
      TEST_3RF_3("fmsub.w", dataf,  72,   0,  24, w30, w7,  w23);
      TEST_3RF_3("fmsub.w", dataf,  72,   0,  32, w19, w30, w26);
      TEST_3RF_3("fmsub.w", dataf,  72,   0,  40, w2,  w30, w7);
      TEST_3RF_3("fmsub.w", dataf,  72,   0,  48, w23, w22, w6);
      TEST_3RF_3("fmsub.w", dataf,  72,   0,  56, w7,  w10, w1);
      TEST_3RF_3("fmsub.w", dataf,  72,   0,  64, w17, w31, w7);
      TEST_3RF_3("fmsub.w", dataf,  72,   0,  72, w12, w19, w3);
      TEST_3RF_3("fmsub.w", dataf,  72,   8,   0, w26, w26, w26);
      TEST_3RF_3("fmsub.w", dataf,  72,   8,   8, w2,  w1,  w11);
      TEST_3RF_3("fmsub.w", dataf,  72,   8,  16, w14, w11, w10);
      TEST_3RF_3("fmsub.w", dataf,  72,   8,  24, w10, w10, w0);
      TEST_3RF_3("fmsub.w", dataf,  72,   8,  32, w8,  w17, w23);
      TEST_3RF_3("fmsub.w", dataf,  72,   8,  40, w27, w4,  w21);
      TEST_3RF_3("fmsub.w", dataf,  72,   8,  48, w22, w6,  w19);
      TEST_3RF_3("fmsub.w", dataf,  72,   8,  56, w29, w9,  w4);
      TEST_3RF_3("fmsub.w", dataf,  72,   8,  64, w4,  w19, w5);
      TEST_3RF_3("fmsub.w", dataf,  72,   8,  72, w21, w19, w19);
      TEST_3RF_3("fmsub.w", dataf,  72,  16,   0, w12, w1,  w6);
      TEST_3RF_3("fmsub.w", dataf,  72,  16,   8, w15, w27, w8);
      TEST_3RF_3("fmsub.w", dataf,  72,  16,  16, w17, w7,  w23);
      TEST_3RF_3("fmsub.w", dataf,  72,  16,  24, w28, w17, w1);
      TEST_3RF_3("fmsub.w", dataf,  72,  16,  32, w28, w25, w18);
      TEST_3RF_3("fmsub.w", dataf,  72,  16,  40, w19, w21, w22);
      TEST_3RF_3("fmsub.w", dataf,  72,  16,  48, w8,  w11, w28);
      TEST_3RF_3("fmsub.w", dataf,  72,  16,  56, w28, w8,  w25);
      TEST_3RF_3("fmsub.w", dataf,  72,  16,  64, w5,  w12, w29);
      TEST_3RF_3("fmsub.w", dataf,  72,  16,  72, w25, w18, w12);
      TEST_3RF_3("fmsub.w", dataf,  72,  24,   0, w30, w19, w18);
      TEST_3RF_3("fmsub.w", dataf,  72,  24,   8, w14, w27, w31);
      TEST_3RF_3("fmsub.w", dataf,  72,  24,  16, w21, w18, w18);
      TEST_3RF_3("fmsub.w", dataf,  72,  24,  24, w27, w6,  w19);
      TEST_3RF_3("fmsub.w", dataf,  72,  24,  32, w24, w0,  w5);
      TEST_3RF_3("fmsub.w", dataf,  72,  24,  40, w11, w21, w27);
      TEST_3RF_3("fmsub.w", dataf,  72,  24,  48, w20, w0,  w23);
      TEST_3RF_3("fmsub.w", dataf,  72,  24,  56, w16, w8,  w21);
      TEST_3RF_3("fmsub.w", dataf,  72,  24,  64, w21, w13, w13);
      TEST_3RF_3("fmsub.w", dataf,  72,  24,  72, w14, w7,  w31);
      TEST_3RF_3("fmsub.w", dataf,  72,  32,   0, w26, w26, w26);
      TEST_3RF_3("fmsub.w", dataf,  72,  32,   8, w5,  w18, w13);
      TEST_3RF_3("fmsub.w", dataf,  72,  32,  16, w19, w0,  w8);
      TEST_3RF_3("fmsub.w", dataf,  72,  32,  24, w18, w22, w18);
      TEST_3RF_3("fmsub.w", dataf,  72,  32,  32, w26, w26, w26);
      TEST_3RF_3("fmsub.w", dataf,  72,  32,  40, w14, w28, w13);
      TEST_3RF_3("fmsub.w", dataf,  72,  32,  48, w6,  w28, w18);
      TEST_3RF_3("fmsub.w", dataf,  72,  32,  56, w17, w13, w5);
      TEST_3RF_3("fmsub.w", dataf,  72,  32,  64, w17, w4,  w21);
      TEST_3RF_3("fmsub.w", dataf,  72,  32,  72, w26, w26, w26);
      TEST_3RF_3("fmsub.w", dataf,  72,  40,   0, w20, w11, w15);
      TEST_3RF_3("fmsub.w", dataf,  72,  40,   8, w1,  w25, w22);
      TEST_3RF_3("fmsub.w", dataf,  72,  40,  16, w0,  w20, w27);
      TEST_3RF_3("fmsub.w", dataf,  72,  40,  24, w18, w1,  w18);
      TEST_3RF_3("fmsub.w", dataf,  72,  40,  32, w15, w18, w9);
      TEST_3RF_3("fmsub.w", dataf,  72,  40,  40, w1,  w8,  w3);
      TEST_3RF_3("fmsub.w", dataf,  72,  40,  48, w15, w5,  w16);
      TEST_3RF_3("fmsub.w", dataf,  72,  40,  56, w21, w1,  w1);
      TEST_3RF_3("fmsub.w", dataf,  72,  40,  64, w2,  w7,  w19);
      TEST_3RF_3("fmsub.w", dataf,  72,  40,  72, w15, w12, w4);
      TEST_3RF_3("fmsub.w", dataf,  72,  48,   0, w19, w2,  w30);
      TEST_3RF_3("fmsub.w", dataf,  72,  48,   8, w7,  w13, w8);
      TEST_3RF_3("fmsub.w", dataf,  72,  48,  16, w6,  w3,  w8);
      TEST_3RF_3("fmsub.w", dataf,  72,  48,  24, w26, w26, w26);
      TEST_3RF_3("fmsub.w", dataf,  72,  48,  32, w31, w26, w27);
      TEST_3RF_3("fmsub.w", dataf,  72,  48,  40, w14, w12, w4);
      TEST_3RF_3("fmsub.w", dataf,  72,  48,  48, w15, w21, w7);
      TEST_3RF_3("fmsub.w", dataf,  72,  48,  56, w31, w26, w23);
      TEST_3RF_3("fmsub.w", dataf,  72,  48,  64, w20, w27, w25);
      TEST_3RF_3("fmsub.w", dataf,  72,  48,  72, w27, w14, w8);
      TEST_3RF_3("fmsub.w", dataf,  72,  56,   0, w8,  w19, w27);
      TEST_3RF_3("fmsub.w", dataf,  72,  56,   8, w10, w10, w17);
      TEST_3RF_3("fmsub.w", dataf,  72,  56,  16, w2,  w23, w31);
      TEST_3RF_3("fmsub.w", dataf,  72,  56,  24, w10, w10, w29);
      TEST_3RF_3("fmsub.w", dataf,  72,  56,  32, w2,  w18, w24);
      TEST_3RF_3("fmsub.w", dataf,  72,  56,  40, w1,  w12, w19);
      TEST_3RF_3("fmsub.w", dataf,  72,  56,  48, w15, w25, w24);
      TEST_3RF_3("fmsub.w", dataf,  72,  56,  56, w31, w14, w30);
      TEST_3RF_3("fmsub.w", dataf,  72,  56,  64, w8,  w23, w18);
      TEST_3RF_3("fmsub.w", dataf,  72,  56,  72, w3,  w16, w14);
      TEST_3RF_3("fmsub.w", dataf,  72,  64,   0, w18, w25, w18);
      TEST_3RF_3("fmsub.w", dataf,  72,  64,   8, w22, w5,  w20);
      TEST_3RF_3("fmsub.w", dataf,  72,  64,  16, w0,  w22, w23);
      TEST_3RF_3("fmsub.w", dataf,  72,  64,  24, w23, w21, w1);
      TEST_3RF_3("fmsub.w", dataf,  72,  64,  32, w20, w24, w12);
      TEST_3RF_3("fmsub.w", dataf,  72,  64,  40, w25, w0,  w9);
      TEST_3RF_3("fmsub.w", dataf,  72,  64,  48, w25, w24, w8);
      TEST_3RF_3("fmsub.w", dataf,  72,  64,  56, w7,  w23, w6);
      TEST_3RF_3("fmsub.w", dataf,  72,  64,  64, w15, w14, w24);
      TEST_3RF_3("fmsub.w", dataf,  72,  64,  72, w19, w31, w6);
      TEST_3RF_3("fmsub.w", dataf,  72,  72,   0, w5,  w24, w28);
      TEST_3RF_3("fmsub.w", dataf,  72,  72,   8, w10, w10, w12);
      TEST_3RF_3("fmsub.w", dataf,  72,  72,  16, w28, w0,  w3);
      TEST_3RF_3("fmsub.w", dataf,  72,  72,  24, w19, w22, w5);
      TEST_3RF_3("fmsub.w", dataf,  72,  72,  32, w8,  w14, w25);
      TEST_3RF_3("fmsub.w", dataf,  72,  72,  40, w20, w7,  w25);
      TEST_3RF_3("fmsub.w", dataf,  72,  72,  48, w20, w16, w19);
      TEST_3RF_3("fmsub.w", dataf,  72,  72,  56, w12, w24, w26);
      TEST_3RF_3("fmsub.w", dataf,  72,  72,  64, w4,  w30, w10);
      TEST_3RF_3("fmsub.w", dataf,  72,  72,  72, w18, w23, w18);
      TEST_3RF_3("fmsub.d", datad,   0,   0,   0, w29, w17, w2);
      TEST_3RF_3("fmsub.d", datad,   0,   0,  16, w9,  w26, w12);
      TEST_3RF_3("fmsub.d", datad,   0,   0,  32, w22, w12, w25);
      TEST_3RF_3("fmsub.d", datad,   0,   0,  48, w10, w10, w2);
      TEST_3RF_3("fmsub.d", datad,   0,   0,  64, w30, w18, w16);
      TEST_3RF_3("fmsub.d", datad,   0,   0,  80, w23, w6,  w24);
      TEST_3RF_3("fmsub.d", datad,   0,   0,  96, w17, w27, w8);
      TEST_3RF_3("fmsub.d", datad,   0,   0, 112, w4,  w7,  w1);
      TEST_3RF_3("fmsub.d", datad,   0,   0, 128, w30, w11, w31);
      TEST_3RF_3("fmsub.d", datad,   0,   0, 144, w8,  w30, w22);
      TEST_3RF_3("fmsub.d", datad,   0,  16,   0, w5,  w15, w20);
      TEST_3RF_3("fmsub.d", datad,   0,  16,  16, w7,  w25, w14);
      TEST_3RF_3("fmsub.d", datad,   0,  16,  32, w19, w15, w4);
      TEST_3RF_3("fmsub.d", datad,   0,  16,  48, w0,  w8,  w14);
      TEST_3RF_3("fmsub.d", datad,   0,  16,  64, w2,  w7,  w0);
      TEST_3RF_3("fmsub.d", datad,   0,  16,  80, w19, w30, w7);
      TEST_3RF_3("fmsub.d", datad,   0,  16,  96, w11, w15, w2);
      TEST_3RF_3("fmsub.d", datad,   0,  16, 112, w19, w9,  w20);
      TEST_3RF_3("fmsub.d", datad,   0,  16, 128, w18, w21, w18);
      TEST_3RF_3("fmsub.d", datad,   0,  16, 144, w20, w26, w19);
      TEST_3RF_3("fmsub.d", datad,   0,  32,   0, w10, w10, w0);
      TEST_3RF_3("fmsub.d", datad,   0,  32,  16, w2,  w30, w7);
      TEST_3RF_3("fmsub.d", datad,   0,  32,  32, w27, w12, w10);
      TEST_3RF_3("fmsub.d", datad,   0,  32,  48, w17, w27, w19);
      TEST_3RF_3("fmsub.d", datad,   0,  32,  64, w31, w29, w26);
      TEST_3RF_3("fmsub.d", datad,   0,  32,  80, w0,  w16, w24);
      TEST_3RF_3("fmsub.d", datad,   0,  32,  96, w7,  w27, w8);
      TEST_3RF_3("fmsub.d", datad,   0,  32, 112, w9,  w15, w27);
      TEST_3RF_3("fmsub.d", datad,   0,  32, 128, w18, w3,  w18);
      TEST_3RF_3("fmsub.d", datad,   0,  32, 144, w13, w7,  w23);
      TEST_3RF_3("fmsub.d", datad,   0,  48,   0, w8,  w26, w2);
      TEST_3RF_3("fmsub.d", datad,   0,  48,  16, w8,  w29, w0);
      TEST_3RF_3("fmsub.d", datad,   0,  48,  32, w15, w24, w13);
      TEST_3RF_3("fmsub.d", datad,   0,  48,  48, w10, w10, w3);
      TEST_3RF_3("fmsub.d", datad,   0,  48,  64, w30, w5,  w22);
      TEST_3RF_3("fmsub.d", datad,   0,  48,  80, w29, w3,  w16);
      TEST_3RF_3("fmsub.d", datad,   0,  48,  96, w29, w19, w8);
      TEST_3RF_3("fmsub.d", datad,   0,  48, 112, w4,  w15, w16);
      TEST_3RF_3("fmsub.d", datad,   0,  48, 128, w13, w30, w12);
      TEST_3RF_3("fmsub.d", datad,   0,  48, 144, w0,  w1,  w25);
      TEST_3RF_3("fmsub.d", datad,   0,  64,   0, w7,  w25, w1);
      TEST_3RF_3("fmsub.d", datad,   0,  64,  16, w2,  w27, w9);
      TEST_3RF_3("fmsub.d", datad,   0,  64,  32, w31, w27, w25);
      TEST_3RF_3("fmsub.d", datad,   0,  64,  48, w23, w8,  w3);
      TEST_3RF_3("fmsub.d", datad,   0,  64,  64, w26, w26, w26);
      TEST_3RF_3("fmsub.d", datad,   0,  64,  80, w6,  w9,  w16);
      TEST_3RF_3("fmsub.d", datad,   0,  64,  96, w4,  w12, w0);
      TEST_3RF_3("fmsub.d", datad,   0,  64, 112, w1,  w31, w9);
      TEST_3RF_3("fmsub.d", datad,   0,  64, 128, w6,  w14, w25);
      TEST_3RF_3("fmsub.d", datad,   0,  64, 144, w19, w12, w5);
      TEST_3RF_3("fmsub.d", datad,   0,  80,   0, w19, w14, w31);
      TEST_3RF_3("fmsub.d", datad,   0,  80,  16, w27, w7,  w0);
      TEST_3RF_3("fmsub.d", datad,   0,  80,  32, w29, w2,  w10);
      TEST_3RF_3("fmsub.d", datad,   0,  80,  48, w28, w29, w3);
      TEST_3RF_3("fmsub.d", datad,   0,  80,  64, w19, w6,  w14);
      TEST_3RF_3("fmsub.d", datad,   0,  80,  80, w12, w15, w30);
      TEST_3RF_3("fmsub.d", datad,   0,  80,  96, w16, w27, w31);
      TEST_3RF_3("fmsub.d", datad,   0,  80, 112, w18, w27, w18);
      TEST_3RF_3("fmsub.d", datad,   0,  80, 128, w8,  w24, w9);
      TEST_3RF_3("fmsub.d", datad,   0,  80, 144, w1,  w11, w22);
      TEST_3RF_3("fmsub.d", datad,   0,  96,   0, w7,  w31, w4);
      TEST_3RF_3("fmsub.d", datad,   0,  96,  16, w6,  w26, w11);
      TEST_3RF_3("fmsub.d", datad,   0,  96,  32, w6,  w23, w13);
      TEST_3RF_3("fmsub.d", datad,   0,  96,  48, w16, w19, w10);
      TEST_3RF_3("fmsub.d", datad,   0,  96,  64, w19, w6,  w16);
      TEST_3RF_3("fmsub.d", datad,   0,  96,  80, w26, w26, w26);
      TEST_3RF_3("fmsub.d", datad,   0,  96,  96, w20, w29, w9);
      TEST_3RF_3("fmsub.d", datad,   0,  96, 112, w19, w13, w5);
      TEST_3RF_3("fmsub.d", datad,   0,  96, 128, w18, w31, w18);
      TEST_3RF_3("fmsub.d", datad,   0,  96, 144, w0,  w26, w23);
      TEST_3RF_3("fmsub.d", datad,   0, 112,   0, w9,  w27, w3);
      TEST_3RF_3("fmsub.d", datad,   0, 112,  16, w31, w2,  w3);
      TEST_3RF_3("fmsub.d", datad,   0, 112,  32, w8,  w28, w14);
      TEST_3RF_3("fmsub.d", datad,   0, 112,  48, w15, w19, w27);
      TEST_3RF_3("fmsub.d", datad,   0, 112,  64, w31, w6,  w19);
      TEST_3RF_3("fmsub.d", datad,   0, 112,  80, w12, w22, w13);
      TEST_3RF_3("fmsub.d", datad,   0, 112,  96, w1,  w19, w22);
      TEST_3RF_3("fmsub.d", datad,   0, 112, 112, w20, w1,  w27);
      TEST_3RF_3("fmsub.d", datad,   0, 112, 128, w6,  w0,  w27);
      TEST_3RF_3("fmsub.d", datad,   0, 112, 144, w0,  w24, w5);
      TEST_3RF_3("fmsub.d", datad,   0, 128,   0, w27, w4,  w30);
      TEST_3RF_3("fmsub.d", datad,   0, 128,  16, w29, w8,  w6);
      TEST_3RF_3("fmsub.d", datad,   0, 128,  32, w25, w22, w21);
      TEST_3RF_3("fmsub.d", datad,   0, 128,  48, w12, w18, w21);
      TEST_3RF_3("fmsub.d", datad,   0, 128,  64, w18, w24, w18);
      TEST_3RF_3("fmsub.d", datad,   0, 128,  80, w8,  w30, w14);
      TEST_3RF_3("fmsub.d", datad,   0, 128,  96, w21, w31, w31);
      TEST_3RF_3("fmsub.d", datad,   0, 128, 112, w2,  w11, w19);
      TEST_3RF_3("fmsub.d", datad,   0, 128, 128, w3,  w7,  w25);
      TEST_3RF_3("fmsub.d", datad,   0, 128, 144, w3,  w2,  w25);
      TEST_3RF_3("fmsub.d", datad,   0, 144,   0, w27, w7,  w21);
      TEST_3RF_3("fmsub.d", datad,   0, 144,  16, w22, w12, w19);
      TEST_3RF_3("fmsub.d", datad,   0, 144,  32, w19, w20, w25);
      TEST_3RF_3("fmsub.d", datad,   0, 144,  48, w12, w10, w15);
      TEST_3RF_3("fmsub.d", datad,   0, 144,  64, w24, w28, w4);
      TEST_3RF_3("fmsub.d", datad,   0, 144,  80, w10, w10, w20);
      TEST_3RF_3("fmsub.d", datad,   0, 144,  96, w12, w9,  w3);
      TEST_3RF_3("fmsub.d", datad,   0, 144, 112, w1,  w8,  w5);
      TEST_3RF_3("fmsub.d", datad,   0, 144, 128, w12, w28, w8);
      TEST_3RF_3("fmsub.d", datad,   0, 144, 144, w19, w21, w11);
      TEST_3RF_3("fmsub.d", datad,  16,   0,   0, w22, w15, w7);
      TEST_3RF_3("fmsub.d", datad,  16,   0,  16, w29, w4,  w9);
      TEST_3RF_3("fmsub.d", datad,  16,   0,  32, w23, w17, w29);
      TEST_3RF_3("fmsub.d", datad,  16,   0,  48, w16, w29, w8);
      TEST_3RF_3("fmsub.d", datad,  16,   0,  64, w31, w22, w4);
      TEST_3RF_3("fmsub.d", datad,  16,   0,  80, w3,  w0,  w25);
      TEST_3RF_3("fmsub.d", datad,  16,   0,  96, w15, w9,  w28);
      TEST_3RF_3("fmsub.d", datad,  16,   0, 112, w16, w18, w1);
      TEST_3RF_3("fmsub.d", datad,  16,   0, 128, w29, w14, w9);
      TEST_3RF_3("fmsub.d", datad,  16,   0, 144, w16, w3,  w20);
      TEST_3RF_3("fmsub.d", datad,  16,  16,   0, w6,  w18, w27);
      TEST_3RF_3("fmsub.d", datad,  16,  16,  16, w4,  w22, w25);
      TEST_3RF_3("fmsub.d", datad,  16,  16,  32, w13, w10, w11);
      TEST_3RF_3("fmsub.d", datad,  16,  16,  48, w30, w7,  w19);
      TEST_3RF_3("fmsub.d", datad,  16,  16,  64, w29, w23, w1);
      TEST_3RF_3("fmsub.d", datad,  16,  16,  80, w30, w16, w7);
      TEST_3RF_3("fmsub.d", datad,  16,  16,  96, w12, w1,  w25);
      TEST_3RF_3("fmsub.d", datad,  16,  16, 112, w13, w30, w7);
      TEST_3RF_3("fmsub.d", datad,  16,  16, 128, w22, w14, w11);
      TEST_3RF_3("fmsub.d", datad,  16,  16, 144, w11, w21, w29);
      TEST_3RF_3("fmsub.d", datad,  16,  32,   0, w6,  w25, w20);
      TEST_3RF_3("fmsub.d", datad,  16,  32,  16, w31, w6,  w1);
      TEST_3RF_3("fmsub.d", datad,  16,  32,  32, w9,  w17, w31);
      TEST_3RF_3("fmsub.d", datad,  16,  32,  48, w17, w4,  w29);
      TEST_3RF_3("fmsub.d", datad,  16,  32,  64, w14, w28, w30);
      TEST_3RF_3("fmsub.d", datad,  16,  32,  80, w12, w14, w20);
      TEST_3RF_3("fmsub.d", datad,  16,  32,  96, w25, w15, w13);
      TEST_3RF_3("fmsub.d", datad,  16,  32, 112, w6,  w13, w21);
      TEST_3RF_3("fmsub.d", datad,  16,  32, 128, w29, w28, w0);
      TEST_3RF_3("fmsub.d", datad,  16,  32, 144, w8,  w17, w29);
      TEST_3RF_3("fmsub.d", datad,  16,  48,   0, w14, w10, w17);
      TEST_3RF_3("fmsub.d", datad,  16,  48,  16, w14, w16, w19);
      TEST_3RF_3("fmsub.d", datad,  16,  48,  32, w23, w2,  w18);
      TEST_3RF_3("fmsub.d", datad,  16,  48,  48, w8,  w6,  w15);
      TEST_3RF_3("fmsub.d", datad,  16,  48,  64, w23, w2,  w13);
      TEST_3RF_3("fmsub.d", datad,  16,  48,  80, w3,  w15, w28);
      TEST_3RF_3("fmsub.d", datad,  16,  48,  96, w23, w8,  w11);
      TEST_3RF_3("fmsub.d", datad,  16,  48, 112, w5,  w14, w25);
      TEST_3RF_3("fmsub.d", datad,  16,  48, 128, w26, w26, w26);
      TEST_3RF_3("fmsub.d", datad,  16,  48, 144, w11, w21, w26);
      TEST_3RF_3("fmsub.d", datad,  16,  64,   0, w19, w6,  w23);
      TEST_3RF_3("fmsub.d", datad,  16,  64,  16, w2,  w16, w9);
      TEST_3RF_3("fmsub.d", datad,  16,  64,  32, w16, w0,  w28);
      TEST_3RF_3("fmsub.d", datad,  16,  64,  48, w7,  w2,  w14);
      TEST_3RF_3("fmsub.d", datad,  16,  64,  64, w16, w9,  w30);
      TEST_3RF_3("fmsub.d", datad,  16,  64,  80, w7,  w11, w10);
      TEST_3RF_3("fmsub.d", datad,  16,  64,  96, w26, w26, w26);
      TEST_3RF_3("fmsub.d", datad,  16,  64, 112, w7,  w2,  w19);
      TEST_3RF_3("fmsub.d", datad,  16,  64, 128, w7,  w17, w12);
      TEST_3RF_3("fmsub.d", datad,  16,  64, 144, w1,  w28, w27);
      TEST_3RF_3("fmsub.d", datad,  16,  80,   0, w16, w7,  w18);
      TEST_3RF_3("fmsub.d", datad,  16,  80,  16, w18, w23, w18);
      TEST_3RF_3("fmsub.d", datad,  16,  80,  32, w27, w2,  w23);
      TEST_3RF_3("fmsub.d", datad,  16,  80,  48, w23, w9,  w26);
      TEST_3RF_3("fmsub.d", datad,  16,  80,  64, w6,  w25, w3);
      TEST_3RF_3("fmsub.d", datad,  16,  80,  80, w4,  w0,  w14);
      TEST_3RF_3("fmsub.d", datad,  16,  80,  96, w15, w11, w9);
      TEST_3RF_3("fmsub.d", datad,  16,  80, 112, w23, w13, w11);
      TEST_3RF_3("fmsub.d", datad,  16,  80, 128, w10, w10, w20);
      TEST_3RF_3("fmsub.d", datad,  16,  80, 144, w28, w22, w21);
      TEST_3RF_3("fmsub.d", datad,  16,  96,   0, w25, w23, w16);
      TEST_3RF_3("fmsub.d", datad,  16,  96,  16, w9,  w30, w2);
      TEST_3RF_3("fmsub.d", datad,  16,  96,  32, w27, w21, w30);
      TEST_3RF_3("fmsub.d", datad,  16,  96,  48, w29, w12, w21);
      TEST_3RF_3("fmsub.d", datad,  16,  96,  64, w6,  w27, w0);
      TEST_3RF_3("fmsub.d", datad,  16,  96,  80, w9,  w31, w0);
      TEST_3RF_3("fmsub.d", datad,  16,  96,  96, w24, w15, w11);
      TEST_3RF_3("fmsub.d", datad,  16,  96, 112, w1,  w6,  w24);
      TEST_3RF_3("fmsub.d", datad,  16,  96, 128, w12, w16, w9);
      TEST_3RF_3("fmsub.d", datad,  16,  96, 144, w6,  w1,  w2);
      TEST_3RF_3("fmsub.d", datad,  16, 112,   0, w29, w17, w11);
      TEST_3RF_3("fmsub.d", datad,  16, 112,  16, w27, w20, w6);
      TEST_3RF_3("fmsub.d", datad,  16, 112,  32, w16, w18, w3);
      TEST_3RF_3("fmsub.d", datad,  16, 112,  48, w28, w7,  w9);
      TEST_3RF_3("fmsub.d", datad,  16, 112,  64, w3,  w9,  w12);
      TEST_3RF_3("fmsub.d", datad,  16, 112,  80, w2,  w10, w4);
      TEST_3RF_3("fmsub.d", datad,  16, 112,  96, w17, w21, w5);
      TEST_3RF_3("fmsub.d", datad,  16, 112, 112, w23, w14, w18);
      TEST_3RF_3("fmsub.d", datad,  16, 112, 128, w7,  w26, w27);
      TEST_3RF_3("fmsub.d", datad,  16, 112, 144, w13, w28, w29);
      TEST_3RF_3("fmsub.d", datad,  16, 128,   0, w10, w10, w13);
      TEST_3RF_3("fmsub.d", datad,  16, 128,  16, w8,  w5,  w1);
      TEST_3RF_3("fmsub.d", datad,  16, 128,  32, w14, w21, w19);
      TEST_3RF_3("fmsub.d", datad,  16, 128,  48, w17, w18, w27);
      TEST_3RF_3("fmsub.d", datad,  16, 128,  64, w26, w26, w26);
      TEST_3RF_3("fmsub.d", datad,  16, 128,  80, w21, w30, w30);
      TEST_3RF_3("fmsub.d", datad,  16, 128,  96, w4,  w1,  w0);
      TEST_3RF_3("fmsub.d", datad,  16, 128, 112, w14, w6,  w18);
      TEST_3RF_3("fmsub.d", datad,  16, 128, 128, w3,  w11, w9);
      TEST_3RF_3("fmsub.d", datad,  16, 128, 144, w17, w29, w12);
      TEST_3RF_3("fmsub.d", datad,  16, 144,   0, w24, w30, w8);
      TEST_3RF_3("fmsub.d", datad,  16, 144,  16, w21, w9,  w9);
      TEST_3RF_3("fmsub.d", datad,  16, 144,  32, w21, w29, w29);
      TEST_3RF_3("fmsub.d", datad,  16, 144,  48, w14, w23, w11);
      TEST_3RF_3("fmsub.d", datad,  16, 144,  64, w4,  w10, w28);
      TEST_3RF_3("fmsub.d", datad,  16, 144,  80, w22, w5,  w23);
      TEST_3RF_3("fmsub.d", datad,  16, 144,  96, w11, w3,  w27);
      TEST_3RF_3("fmsub.d", datad,  16, 144, 112, w12, w4,  w9);
      TEST_3RF_3("fmsub.d", datad,  16, 144, 128, w18, w22, w18);
      TEST_3RF_3("fmsub.d", datad,  16, 144, 144, w12, w30, w31);
      TEST_3RF_3("fmsub.d", datad,  32,   0,   0, w30, w27, w16);
      TEST_3RF_3("fmsub.d", datad,  32,   0,  16, w10, w10, w20);
      TEST_3RF_3("fmsub.d", datad,  32,   0,  32, w15, w18, w9);
      TEST_3RF_3("fmsub.d", datad,  32,   0,  48, w24, w7,  w6);
      TEST_3RF_3("fmsub.d", datad,  32,   0,  64, w30, w18, w10);
      TEST_3RF_3("fmsub.d", datad,  32,   0,  80, w9,  w15, w0);
      TEST_3RF_3("fmsub.d", datad,  32,   0,  96, w14, w6,  w11);
      TEST_3RF_3("fmsub.d", datad,  32,   0, 112, w18, w1,  w18);
      TEST_3RF_3("fmsub.d", datad,  32,   0, 128, w24, w22, w10);
      TEST_3RF_3("fmsub.d", datad,  32,   0, 144, w10, w10, w12);
      TEST_3RF_3("fmsub.d", datad,  32,  16,   0, w22, w8,  w11);
      TEST_3RF_3("fmsub.d", datad,  32,  16,  16, w20, w4,  w28);
      TEST_3RF_3("fmsub.d", datad,  32,  16,  32, w30, w24, w11);
      TEST_3RF_3("fmsub.d", datad,  32,  16,  48, w16, w1,  w3);
      TEST_3RF_3("fmsub.d", datad,  32,  16,  64, w24, w8,  w9);
      TEST_3RF_3("fmsub.d", datad,  32,  16,  80, w22, w27, w20);
      TEST_3RF_3("fmsub.d", datad,  32,  16,  96, w31, w10, w20);
      TEST_3RF_3("fmsub.d", datad,  32,  16, 112, w14, w16, w0);
      TEST_3RF_3("fmsub.d", datad,  32,  16, 128, w0,  w17, w24);
      TEST_3RF_3("fmsub.d", datad,  32,  16, 144, w22, w27, w2);
      TEST_3RF_3("fmsub.d", datad,  32,  32,   0, w2,  w17, w11);
      TEST_3RF_3("fmsub.d", datad,  32,  32,  16, w13, w6,  w15);
      TEST_3RF_3("fmsub.d", datad,  32,  32,  32, w9,  w4,  w7);
      TEST_3RF_3("fmsub.d", datad,  32,  32,  48, w20, w21, w8);
      TEST_3RF_3("fmsub.d", datad,  32,  32,  64, w23, w13, w17);
      TEST_3RF_3("fmsub.d", datad,  32,  32,  80, w1,  w3,  w12);
      TEST_3RF_3("fmsub.d", datad,  32,  32,  96, w21, w3,  w3);
      TEST_3RF_3("fmsub.d", datad,  32,  32, 112, w22, w9,  w17);
      TEST_3RF_3("fmsub.d", datad,  32,  32, 128, w6,  w9,  w17);
      TEST_3RF_3("fmsub.d", datad,  32,  32, 144, w23, w1,  w7);
      TEST_3RF_3("fmsub.d", datad,  32,  48,   0, w18, w4,  w18);
      TEST_3RF_3("fmsub.d", datad,  32,  48,  16, w9,  w3,  w15);
      TEST_3RF_3("fmsub.d", datad,  32,  48,  32, w22, w9,  w30);
      TEST_3RF_3("fmsub.d", datad,  32,  48,  48, w0,  w14, w5);
      TEST_3RF_3("fmsub.d", datad,  32,  48,  64, w20, w3,  w13);
      TEST_3RF_3("fmsub.d", datad,  32,  48,  80, w12, w16, w30);
      TEST_3RF_3("fmsub.d", datad,  32,  48,  96, w13, w19, w10);
      TEST_3RF_3("fmsub.d", datad,  32,  48, 112, w2,  w22, w0);
      TEST_3RF_3("fmsub.d", datad,  32,  48, 128, w11, w7,  w6);
      TEST_3RF_3("fmsub.d", datad,  32,  48, 144, w21, w24, w24);
      TEST_3RF_3("fmsub.d", datad,  32,  64,   0, w29, w22, w31);
      TEST_3RF_3("fmsub.d", datad,  32,  64,  16, w15, w26, w8);
      TEST_3RF_3("fmsub.d", datad,  32,  64,  32, w19, w9,  w31);
      TEST_3RF_3("fmsub.d", datad,  32,  64,  48, w28, w7,  w31);
      TEST_3RF_3("fmsub.d", datad,  32,  64,  64, w10, w10, w12);
      TEST_3RF_3("fmsub.d", datad,  32,  64,  80, w19, w13, w26);
      TEST_3RF_3("fmsub.d", datad,  32,  64,  96, w31, w29, w24);
      TEST_3RF_3("fmsub.d", datad,  32,  64, 112, w12, w17, w3);
      TEST_3RF_3("fmsub.d", datad,  32,  64, 128, w14, w7,  w3);
      TEST_3RF_3("fmsub.d", datad,  32,  64, 144, w26, w26, w26);
      TEST_3RF_3("fmsub.d", datad,  32,  80,   0, w15, w10, w7);
      TEST_3RF_3("fmsub.d", datad,  32,  80,  16, w7,  w5,  w23);
      TEST_3RF_3("fmsub.d", datad,  32,  80,  32, w0,  w15, w10);
      TEST_3RF_3("fmsub.d", datad,  32,  80,  48, w9,  w14, w6);
      TEST_3RF_3("fmsub.d", datad,  32,  80,  64, w17, w13, w29);
      TEST_3RF_3("fmsub.d", datad,  32,  80,  80, w1,  w30, w23);
      TEST_3RF_3("fmsub.d", datad,  32,  80,  96, w0,  w28, w16);
      TEST_3RF_3("fmsub.d", datad,  32,  80, 112, w13, w19, w27);
      TEST_3RF_3("fmsub.d", datad,  32,  80, 128, w20, w22, w21);
      TEST_3RF_3("fmsub.d", datad,  32,  80, 144, w3,  w0,  w4);
      TEST_3RF_3("fmsub.d", datad,  32,  96,   0, w11, w8,  w10);
      TEST_3RF_3("fmsub.d", datad,  32,  96,  16, w18, w31, w18);
      TEST_3RF_3("fmsub.d", datad,  32,  96,  32, w10, w10, w1);
      TEST_3RF_3("fmsub.d", datad,  32,  96,  48, w9,  w19, w16);
      TEST_3RF_3("fmsub.d", datad,  32,  96,  64, w15, w4,  w29);
      TEST_3RF_3("fmsub.d", datad,  32,  96,  80, w0,  w2,  w30);
      TEST_3RF_3("fmsub.d", datad,  32,  96,  96, w31, w25, w27);
      TEST_3RF_3("fmsub.d", datad,  32,  96, 112, w9,  w12, w8);
      TEST_3RF_3("fmsub.d", datad,  32,  96, 128, w28, w7,  w19);
      TEST_3RF_3("fmsub.d", datad,  32,  96, 144, w29, w0,  w19);
      TEST_3RF_3("fmsub.d", datad,  32, 112,   0, w1,  w11, w27);
      TEST_3RF_3("fmsub.d", datad,  32, 112,  16, w11, w29, w26);
      TEST_3RF_3("fmsub.d", datad,  32, 112,  32, w21, w30, w30);
      TEST_3RF_3("fmsub.d", datad,  32, 112,  48, w3,  w9,  w14);
      TEST_3RF_3("fmsub.d", datad,  32, 112,  64, w19, w13, w12);
      TEST_3RF_3("fmsub.d", datad,  32, 112,  80, w19, w15, w10);
      TEST_3RF_3("fmsub.d", datad,  32, 112,  96, w18, w9,  w18);
      TEST_3RF_3("fmsub.d", datad,  32, 112, 112, w9,  w13, w18);
      TEST_3RF_3("fmsub.d", datad,  32, 112, 128, w21, w15, w15);
      TEST_3RF_3("fmsub.d", datad,  32, 112, 144, w29, w18, w2);
      TEST_3RF_3("fmsub.d", datad,  32, 128,   0, w26, w26, w26);
      TEST_3RF_3("fmsub.d", datad,  32, 128,  16, w18, w21, w18);
      TEST_3RF_3("fmsub.d", datad,  32, 128,  32, w27, w29, w17);
      TEST_3RF_3("fmsub.d", datad,  32, 128,  48, w7,  w26, w11);
      TEST_3RF_3("fmsub.d", datad,  32, 128,  64, w28, w24, w15);
      TEST_3RF_3("fmsub.d", datad,  32, 128,  80, w5,  w7,  w2);
      TEST_3RF_3("fmsub.d", datad,  32, 128,  96, w19, w21, w2);
      TEST_3RF_3("fmsub.d", datad,  32, 128, 112, w29, w8,  w11);
      TEST_3RF_3("fmsub.d", datad,  32, 128, 128, w7,  w21, w30);
      TEST_3RF_3("fmsub.d", datad,  32, 128, 144, w28, w11, w13);
      TEST_3RF_3("fmsub.d", datad,  32, 144,   0, w25, w29, w15);
      TEST_3RF_3("fmsub.d", datad,  32, 144,  16, w19, w15, w4);
      TEST_3RF_3("fmsub.d", datad,  32, 144,  32, w15, w12, w21);
      TEST_3RF_3("fmsub.d", datad,  32, 144,  48, w22, w6,  w1);
      TEST_3RF_3("fmsub.d", datad,  32, 144,  64, w18, w30, w18);
      TEST_3RF_3("fmsub.d", datad,  32, 144,  80, w16, w24, w5);
      TEST_3RF_3("fmsub.d", datad,  32, 144,  96, w18, w11, w18);
      TEST_3RF_3("fmsub.d", datad,  32, 144, 112, w24, w7,  w13);
      TEST_3RF_3("fmsub.d", datad,  32, 144, 128, w22, w15, w25);
      TEST_3RF_3("fmsub.d", datad,  32, 144, 144, w29, w5,  w23);
      TEST_3RF_3("fmsub.d", datad,  48,   0,   0, w25, w16, w4);
      TEST_3RF_3("fmsub.d", datad,  48,   0,  16, w19, w13, w6);
      TEST_3RF_3("fmsub.d", datad,  48,   0,  32, w28, w23, w21);
      TEST_3RF_3("fmsub.d", datad,  48,   0,  48, w8,  w13, w11);
      TEST_3RF_3("fmsub.d", datad,  48,   0,  64, w14, w30, w12);
      TEST_3RF_3("fmsub.d", datad,  48,   0,  80, w30, w22, w18);
      TEST_3RF_3("fmsub.d", datad,  48,   0,  96, w16, w1,  w10);
      TEST_3RF_3("fmsub.d", datad,  48,   0, 112, w23, w14, w0);
      TEST_3RF_3("fmsub.d", datad,  48,   0, 128, w7,  w29, w12);
      TEST_3RF_3("fmsub.d", datad,  48,   0, 144, w30, w23, w28);
      TEST_3RF_3("fmsub.d", datad,  48,  16,   0, w2,  w10, w9);
      TEST_3RF_3("fmsub.d", datad,  48,  16,  16, w21, w16, w16);
      TEST_3RF_3("fmsub.d", datad,  48,  16,  32, w5,  w13, w6);
      TEST_3RF_3("fmsub.d", datad,  48,  16,  48, w13, w26, w17);
      TEST_3RF_3("fmsub.d", datad,  48,  16,  64, w27, w8,  w15);
      TEST_3RF_3("fmsub.d", datad,  48,  16,  80, w7,  w6,  w5);
      TEST_3RF_3("fmsub.d", datad,  48,  16,  96, w25, w22, w6);
      TEST_3RF_3("fmsub.d", datad,  48,  16, 112, w4,  w13, w21);
      TEST_3RF_3("fmsub.d", datad,  48,  16, 128, w4,  w20, w28);
      TEST_3RF_3("fmsub.d", datad,  48,  16, 144, w2,  w0,  w27);
      TEST_3RF_3("fmsub.d", datad,  48,  32,   0, w25, w28, w29);
      TEST_3RF_3("fmsub.d", datad,  48,  32,  16, w3,  w5,  w19);
      TEST_3RF_3("fmsub.d", datad,  48,  32,  32, w19, w10, w0);
      TEST_3RF_3("fmsub.d", datad,  48,  32,  48, w25, w23, w26);
      TEST_3RF_3("fmsub.d", datad,  48,  32,  64, w11, w18, w2);
      TEST_3RF_3("fmsub.d", datad,  48,  32,  80, w26, w26, w26);
      TEST_3RF_3("fmsub.d", datad,  48,  32,  96, w26, w26, w26);
      TEST_3RF_3("fmsub.d", datad,  48,  32, 112, w8,  w0,  w19);
      TEST_3RF_3("fmsub.d", datad,  48,  32, 128, w30, w6,  w23);
      TEST_3RF_3("fmsub.d", datad,  48,  32, 144, w11, w27, w28);
      TEST_3RF_3("fmsub.d", datad,  48,  48,   0, w0,  w24, w30);
      TEST_3RF_3("fmsub.d", datad,  48,  48,  16, w0,  w19, w23);
      TEST_3RF_3("fmsub.d", datad,  48,  48,  32, w29, w16, w26);
      TEST_3RF_3("fmsub.d", datad,  48,  48,  48, w2,  w3,  w13);
      TEST_3RF_3("fmsub.d", datad,  48,  48,  64, w13, w3,  w7);
      TEST_3RF_3("fmsub.d", datad,  48,  48,  80, w4,  w29, w18);
      TEST_3RF_3("fmsub.d", datad,  48,  48,  96, w23, w31, w12);
      TEST_3RF_3("fmsub.d", datad,  48,  48, 112, w17, w7,  w12);
      TEST_3RF_3("fmsub.d", datad,  48,  48, 128, w4,  w5,  w19);
      TEST_3RF_3("fmsub.d", datad,  48,  48, 144, w28, w17, w14);
      TEST_3RF_3("fmsub.d", datad,  48,  64,   0, w24, w17, w6);
      TEST_3RF_3("fmsub.d", datad,  48,  64,  16, w22, w17, w25);
      TEST_3RF_3("fmsub.d", datad,  48,  64,  32, w13, w14, w10);
      TEST_3RF_3("fmsub.d", datad,  48,  64,  48, w7,  w17, w13);
      TEST_3RF_3("fmsub.d", datad,  48,  64,  64, w20, w30, w17);
      TEST_3RF_3("fmsub.d", datad,  48,  64,  80, w27, w2,  w14);
      TEST_3RF_3("fmsub.d", datad,  48,  64,  96, w13, w25, w14);
      TEST_3RF_3("fmsub.d", datad,  48,  64, 112, w26, w26, w26);
      TEST_3RF_3("fmsub.d", datad,  48,  64, 128, w10, w10, w21);
      TEST_3RF_3("fmsub.d", datad,  48,  64, 144, w6,  w15, w27);
      TEST_3RF_3("fmsub.d", datad,  48,  80,   0, w25, w11, w12);
      TEST_3RF_3("fmsub.d", datad,  48,  80,  16, w8,  w3,  w29);
      TEST_3RF_3("fmsub.d", datad,  48,  80,  32, w14, w25, w8);
      TEST_3RF_3("fmsub.d", datad,  48,  80,  48, w6,  w29, w18);
      TEST_3RF_3("fmsub.d", datad,  48,  80,  64, w13, w14, w31);
      TEST_3RF_3("fmsub.d", datad,  48,  80,  80, w1,  w12, w16);
      TEST_3RF_3("fmsub.d", datad,  48,  80,  96, w29, w14, w31);
      TEST_3RF_3("fmsub.d", datad,  48,  80, 112, w10, w10, w8);
      TEST_3RF_3("fmsub.d", datad,  48,  80, 128, w13, w4,  w18);
      TEST_3RF_3("fmsub.d", datad,  48,  80, 144, w2,  w11, w1);
      TEST_3RF_3("fmsub.d", datad,  48,  96,   0, w29, w4,  w12);
      TEST_3RF_3("fmsub.d", datad,  48,  96,  16, w9,  w12, w15);
      TEST_3RF_3("fmsub.d", datad,  48,  96,  32, w6,  w27, w8);
      TEST_3RF_3("fmsub.d", datad,  48,  96,  48, w21, w3,  w3);
      TEST_3RF_3("fmsub.d", datad,  48,  96,  64, w14, w18, w21);
      TEST_3RF_3("fmsub.d", datad,  48,  96,  80, w27, w0,  w20);
      TEST_3RF_3("fmsub.d", datad,  48,  96,  96, w29, w12, w5);
      TEST_3RF_3("fmsub.d", datad,  48,  96, 112, w26, w26, w26);
      TEST_3RF_3("fmsub.d", datad,  48,  96, 128, w26, w26, w26);
      TEST_3RF_3("fmsub.d", datad,  48,  96, 144, w4,  w2,  w17);
      TEST_3RF_3("fmsub.d", datad,  48, 112,   0, w9,  w21, w19);
      TEST_3RF_3("fmsub.d", datad,  48, 112,  16, w20, w22, w17);
      TEST_3RF_3("fmsub.d", datad,  48, 112,  32, w24, w3,  w26);
      TEST_3RF_3("fmsub.d", datad,  48, 112,  48, w5,  w18, w1);
      TEST_3RF_3("fmsub.d", datad,  48, 112,  64, w0,  w27, w22);
      TEST_3RF_3("fmsub.d", datad,  48, 112,  80, w3,  w9,  w8);
      TEST_3RF_3("fmsub.d", datad,  48, 112,  96, w24, w5,  w8);
      TEST_3RF_3("fmsub.d", datad,  48, 112, 112, w12, w2,  w20);
      TEST_3RF_3("fmsub.d", datad,  48, 112, 128, w17, w28, w14);
      TEST_3RF_3("fmsub.d", datad,  48, 112, 144, w21, w0,  w0);
      TEST_3RF_3("fmsub.d", datad,  48, 128,   0, w17, w6,  w9);
      TEST_3RF_3("fmsub.d", datad,  48, 128,  16, w6,  w26, w29);
      TEST_3RF_3("fmsub.d", datad,  48, 128,  32, w28, w11, w22);
      TEST_3RF_3("fmsub.d", datad,  48, 128,  48, w31, w5,  w27);
      TEST_3RF_3("fmsub.d", datad,  48, 128,  64, w18, w6,  w18);
      TEST_3RF_3("fmsub.d", datad,  48, 128,  80, w27, w13, w28);
      TEST_3RF_3("fmsub.d", datad,  48, 128,  96, w30, w22, w4);
      TEST_3RF_3("fmsub.d", datad,  48, 128, 112, w22, w27, w12);
      TEST_3RF_3("fmsub.d", datad,  48, 128, 128, w2,  w29, w0);
      TEST_3RF_3("fmsub.d", datad,  48, 128, 144, w20, w25, w15);
      TEST_3RF_3("fmsub.d", datad,  48, 144,   0, w9,  w26, w0);
      TEST_3RF_3("fmsub.d", datad,  48, 144,  16, w16, w3,  w6);
      TEST_3RF_3("fmsub.d", datad,  48, 144,  32, w10, w10, w1);
      TEST_3RF_3("fmsub.d", datad,  48, 144,  48, w2,  w21, w23);
      TEST_3RF_3("fmsub.d", datad,  48, 144,  64, w2,  w26, w18);
      TEST_3RF_3("fmsub.d", datad,  48, 144,  80, w20, w1,  w13);
      TEST_3RF_3("fmsub.d", datad,  48, 144,  96, w1,  w29, w11);
      TEST_3RF_3("fmsub.d", datad,  48, 144, 112, w23, w2,  w1);
      TEST_3RF_3("fmsub.d", datad,  48, 144, 128, w19, w14, w3);
      TEST_3RF_3("fmsub.d", datad,  48, 144, 144, w16, w15, w23);
      TEST_3RF_3("fmsub.d", datad,  64,   0,   0, w10, w10, w30);
      TEST_3RF_3("fmsub.d", datad,  64,   0,  16, w1,  w4,  w30);
      TEST_3RF_3("fmsub.d", datad,  64,   0,  32, w17, w7,  w4);
      TEST_3RF_3("fmsub.d", datad,  64,   0,  48, w27, w8,  w6);
      TEST_3RF_3("fmsub.d", datad,  64,   0,  64, w16, w31, w8);
      TEST_3RF_3("fmsub.d", datad,  64,   0,  80, w10, w10, w17);
      TEST_3RF_3("fmsub.d", datad,  64,   0,  96, w28, w11, w30);
      TEST_3RF_3("fmsub.d", datad,  64,   0, 112, w29, w9,  w21);
      TEST_3RF_3("fmsub.d", datad,  64,   0, 128, w11, w10, w8);
      TEST_3RF_3("fmsub.d", datad,  64,   0, 144, w25, w14, w24);
      TEST_3RF_3("fmsub.d", datad,  64,  16,   0, w8,  w5,  w2);
      TEST_3RF_3("fmsub.d", datad,  64,  16,  16, w6,  w4,  w23);
      TEST_3RF_3("fmsub.d", datad,  64,  16,  32, w14, w8,  w18);
      TEST_3RF_3("fmsub.d", datad,  64,  16,  48, w22, w15, w2);
      TEST_3RF_3("fmsub.d", datad,  64,  16,  64, w22, w23, w13);
      TEST_3RF_3("fmsub.d", datad,  64,  16,  80, w7,  w20, w24);
      TEST_3RF_3("fmsub.d", datad,  64,  16,  96, w6,  w17, w1);
      TEST_3RF_3("fmsub.d", datad,  64,  16, 112, w15, w6,  w12);
      TEST_3RF_3("fmsub.d", datad,  64,  16, 128, w26, w26, w26);
      TEST_3RF_3("fmsub.d", datad,  64,  16, 144, w14, w6,  w8);
      TEST_3RF_3("fmsub.d", datad,  64,  32,   0, w7,  w14, w13);
      TEST_3RF_3("fmsub.d", datad,  64,  32,  16, w9,  w21, w20);
      TEST_3RF_3("fmsub.d", datad,  64,  32,  32, w16, w25, w11);
      TEST_3RF_3("fmsub.d", datad,  64,  32,  48, w30, w2,  w20);
      TEST_3RF_3("fmsub.d", datad,  64,  32,  64, w17, w0,  w10);
      TEST_3RF_3("fmsub.d", datad,  64,  32,  80, w8,  w13, w18);
      TEST_3RF_3("fmsub.d", datad,  64,  32,  96, w28, w6,  w24);
      TEST_3RF_3("fmsub.d", datad,  64,  32, 112, w14, w7,  w20);
      TEST_3RF_3("fmsub.d", datad,  64,  32, 128, w20, w1,  w3);
      TEST_3RF_3("fmsub.d", datad,  64,  32, 144, w26, w26, w26);
      TEST_3RF_3("fmsub.d", datad,  64,  48,   0, w9,  w10, w8);
      TEST_3RF_3("fmsub.d", datad,  64,  48,  16, w23, w19, w29);
      TEST_3RF_3("fmsub.d", datad,  64,  48,  32, w11, w3,  w23);
      TEST_3RF_3("fmsub.d", datad,  64,  48,  48, w22, w1,  w25);
      TEST_3RF_3("fmsub.d", datad,  64,  48,  64, w20, w22, w10);
      TEST_3RF_3("fmsub.d", datad,  64,  48,  80, w21, w0,  w0);
      TEST_3RF_3("fmsub.d", datad,  64,  48,  96, w18, w2,  w18);
      TEST_3RF_3("fmsub.d", datad,  64,  48, 112, w18, w15, w18);
      TEST_3RF_3("fmsub.d", datad,  64,  48, 128, w8,  w10, w29);
      TEST_3RF_3("fmsub.d", datad,  64,  48, 144, w16, w18, w17);
      TEST_3RF_3("fmsub.d", datad,  64,  64,   0, w4,  w19, w20);
      TEST_3RF_3("fmsub.d", datad,  64,  64,  16, w30, w29, w6);
      TEST_3RF_3("fmsub.d", datad,  64,  64,  32, w20, w18, w4);
      TEST_3RF_3("fmsub.d", datad,  64,  64,  48, w31, w21, w27);
      TEST_3RF_3("fmsub.d", datad,  64,  64,  64, w21, w23, w23);
      TEST_3RF_3("fmsub.d", datad,  64,  64,  80, w20, w10, w13);
      TEST_3RF_3("fmsub.d", datad,  64,  64,  96, w30, w31, w13);
      TEST_3RF_3("fmsub.d", datad,  64,  64, 112, w16, w1,  w0);
      TEST_3RF_3("fmsub.d", datad,  64,  64, 128, w31, w10, w28);
      TEST_3RF_3("fmsub.d", datad,  64,  64, 144, w26, w26, w26);
      TEST_3RF_3("fmsub.d", datad,  64,  80,   0, w28, w14, w30);
      TEST_3RF_3("fmsub.d", datad,  64,  80,  16, w16, w2,  w28);
      TEST_3RF_3("fmsub.d", datad,  64,  80,  32, w13, w1,  w2);
      TEST_3RF_3("fmsub.d", datad,  64,  80,  48, w1,  w19, w6);
      TEST_3RF_3("fmsub.d", datad,  64,  80,  64, w0,  w8,  w1);
      TEST_3RF_3("fmsub.d", datad,  64,  80,  80, w21, w31, w31);
      TEST_3RF_3("fmsub.d", datad,  64,  80,  96, w21, w31, w31);
      TEST_3RF_3("fmsub.d", datad,  64,  80, 112, w12, w19, w30);
      TEST_3RF_3("fmsub.d", datad,  64,  80, 128, w26, w26, w26);
      TEST_3RF_3("fmsub.d", datad,  64,  80, 144, w4,  w0,  w26);
      TEST_3RF_3("fmsub.d", datad,  64,  96,   0, w3,  w10, w4);
      TEST_3RF_3("fmsub.d", datad,  64,  96,  16, w0,  w4,  w1);
      TEST_3RF_3("fmsub.d", datad,  64,  96,  32, w14, w2,  w17);
      TEST_3RF_3("fmsub.d", datad,  64,  96,  48, w16, w30, w17);
      TEST_3RF_3("fmsub.d", datad,  64,  96,  64, w0,  w31, w4);
      TEST_3RF_3("fmsub.d", datad,  64,  96,  80, w7,  w31, w13);
      TEST_3RF_3("fmsub.d", datad,  64,  96,  96, w8,  w20, w12);
      TEST_3RF_3("fmsub.d", datad,  64,  96, 112, w30, w20, w25);
      TEST_3RF_3("fmsub.d", datad,  64,  96, 128, w17, w18, w19);
      TEST_3RF_3("fmsub.d", datad,  64,  96, 144, w21, w18, w18);
      TEST_3RF_3("fmsub.d", datad,  64, 112,   0, w13, w25, w28);
      TEST_3RF_3("fmsub.d", datad,  64, 112,  16, w17, w25, w0);
      TEST_3RF_3("fmsub.d", datad,  64, 112,  32, w18, w7,  w18);
      TEST_3RF_3("fmsub.d", datad,  64, 112,  48, w2,  w3,  w23);
      TEST_3RF_3("fmsub.d", datad,  64, 112,  64, w0,  w1,  w9);
      TEST_3RF_3("fmsub.d", datad,  64, 112,  80, w1,  w0,  w13);
      TEST_3RF_3("fmsub.d", datad,  64, 112,  96, w8,  w31, w26);
      TEST_3RF_3("fmsub.d", datad,  64, 112, 112, w16, w20, w7);
      TEST_3RF_3("fmsub.d", datad,  64, 112, 128, w14, w8,  w0);
      TEST_3RF_3("fmsub.d", datad,  64, 112, 144, w0,  w26, w19);
      TEST_3RF_3("fmsub.d", datad,  64, 128,   0, w21, w13, w13);
      TEST_3RF_3("fmsub.d", datad,  64, 128,  16, w0,  w14, w9);
      TEST_3RF_3("fmsub.d", datad,  64, 128,  32, w17, w7,  w10);
      TEST_3RF_3("fmsub.d", datad,  64, 128,  48, w4,  w14, w12);
      TEST_3RF_3("fmsub.d", datad,  64, 128,  64, w7,  w6,  w13);
      TEST_3RF_3("fmsub.d", datad,  64, 128,  80, w9,  w15, w14);
      TEST_3RF_3("fmsub.d", datad,  64, 128,  96, w9,  w28, w22);
      TEST_3RF_3("fmsub.d", datad,  64, 128, 112, w9,  w23, w6);
      TEST_3RF_3("fmsub.d", datad,  64, 128, 128, w29, w30, w21);
      TEST_3RF_3("fmsub.d", datad,  64, 128, 144, w5,  w30, w21);
      TEST_3RF_3("fmsub.d", datad,  64, 144,   0, w31, w17, w10);
      TEST_3RF_3("fmsub.d", datad,  64, 144,  16, w12, w17, w25);
      TEST_3RF_3("fmsub.d", datad,  64, 144,  32, w22, w2,  w0);
      TEST_3RF_3("fmsub.d", datad,  64, 144,  48, w0,  w6,  w15);
      TEST_3RF_3("fmsub.d", datad,  64, 144,  64, w12, w14, w21);
      TEST_3RF_3("fmsub.d", datad,  64, 144,  80, w25, w23, w4);
      TEST_3RF_3("fmsub.d", datad,  64, 144,  96, w7,  w0,  w29);
      TEST_3RF_3("fmsub.d", datad,  64, 144, 112, w9,  w23, w4);
      TEST_3RF_3("fmsub.d", datad,  64, 144, 128, w6,  w21, w25);
      TEST_3RF_3("fmsub.d", datad,  64, 144, 144, w11, w19, w14);
      TEST_3RF_3("fmsub.d", datad,  80,   0,   0, w11, w4,  w24);
      TEST_3RF_3("fmsub.d", datad,  80,   0,  16, w23, w21, w17);
      TEST_3RF_3("fmsub.d", datad,  80,   0,  32, w13, w24, w18);
      TEST_3RF_3("fmsub.d", datad,  80,   0,  48, w13, w30, w1);
      TEST_3RF_3("fmsub.d", datad,  80,   0,  64, w26, w26, w26);
      TEST_3RF_3("fmsub.d", datad,  80,   0,  80, w12, w22, w19);
      TEST_3RF_3("fmsub.d", datad,  80,   0,  96, w3,  w26, w27);
      TEST_3RF_3("fmsub.d", datad,  80,   0, 112, w4,  w26, w24);
      TEST_3RF_3("fmsub.d", datad,  80,   0, 128, w13, w18, w28);
      TEST_3RF_3("fmsub.d", datad,  80,   0, 144, w20, w7,  w21);
      TEST_3RF_3("fmsub.d", datad,  80,  16,   0, w31, w27, w3);
      TEST_3RF_3("fmsub.d", datad,  80,  16,  16, w10, w10, w31);
      TEST_3RF_3("fmsub.d", datad,  80,  16,  32, w28, w2,  w21);
      TEST_3RF_3("fmsub.d", datad,  80,  16,  48, w13, w15, w31);
      TEST_3RF_3("fmsub.d", datad,  80,  16,  64, w29, w11, w0);
      TEST_3RF_3("fmsub.d", datad,  80,  16,  80, w23, w24, w22);
      TEST_3RF_3("fmsub.d", datad,  80,  16,  96, w10, w10, w27);
      TEST_3RF_3("fmsub.d", datad,  80,  16, 112, w16, w5,  w31);
      TEST_3RF_3("fmsub.d", datad,  80,  16, 128, w11, w30, w13);
      TEST_3RF_3("fmsub.d", datad,  80,  16, 144, w29, w26, w1);
      TEST_3RF_3("fmsub.d", datad,  80,  32,   0, w4,  w16, w0);
      TEST_3RF_3("fmsub.d", datad,  80,  32,  16, w31, w19, w11);
      TEST_3RF_3("fmsub.d", datad,  80,  32,  32, w31, w15, w13);
      TEST_3RF_3("fmsub.d", datad,  80,  32,  48, w20, w29, w28);
      TEST_3RF_3("fmsub.d", datad,  80,  32,  64, w1,  w28, w25);
      TEST_3RF_3("fmsub.d", datad,  80,  32,  80, w12, w29, w16);
      TEST_3RF_3("fmsub.d", datad,  80,  32,  96, w4,  w19, w27);
      TEST_3RF_3("fmsub.d", datad,  80,  32, 112, w0,  w4,  w31);
      TEST_3RF_3("fmsub.d", datad,  80,  32, 128, w15, w30, w12);
      TEST_3RF_3("fmsub.d", datad,  80,  32, 144, w12, w25, w13);
      TEST_3RF_3("fmsub.d", datad,  80,  48,   0, w16, w9,  w14);
      TEST_3RF_3("fmsub.d", datad,  80,  48,  16, w16, w28, w25);
      TEST_3RF_3("fmsub.d", datad,  80,  48,  32, w15, w12, w6);
      TEST_3RF_3("fmsub.d", datad,  80,  48,  48, w3,  w9,  w2);
      TEST_3RF_3("fmsub.d", datad,  80,  48,  64, w4,  w5,  w28);
      TEST_3RF_3("fmsub.d", datad,  80,  48,  80, w16, w2,  w12);
      TEST_3RF_3("fmsub.d", datad,  80,  48,  96, w21, w22, w22);
      TEST_3RF_3("fmsub.d", datad,  80,  48, 112, w7,  w21, w26);
      TEST_3RF_3("fmsub.d", datad,  80,  48, 128, w8,  w20, w9);
      TEST_3RF_3("fmsub.d", datad,  80,  48, 144, w6,  w1,  w21);
      TEST_3RF_3("fmsub.d", datad,  80,  64,   0, w31, w14, w5);
      TEST_3RF_3("fmsub.d", datad,  80,  64,  16, w8,  w28, w21);
      TEST_3RF_3("fmsub.d", datad,  80,  64,  32, w5,  w21, w4);
      TEST_3RF_3("fmsub.d", datad,  80,  64,  48, w17, w27, w7);
      TEST_3RF_3("fmsub.d", datad,  80,  64,  64, w26, w26, w26);
      TEST_3RF_3("fmsub.d", datad,  80,  64,  80, w30, w11, w31);
      TEST_3RF_3("fmsub.d", datad,  80,  64,  96, w26, w26, w26);
      TEST_3RF_3("fmsub.d", datad,  80,  64, 112, w28, w2,  w6);
      TEST_3RF_3("fmsub.d", datad,  80,  64, 128, w17, w24, w14);
      TEST_3RF_3("fmsub.d", datad,  80,  64, 144, w6,  w18, w22);
      TEST_3RF_3("fmsub.d", datad,  80,  80,   0, w26, w26, w26);
      TEST_3RF_3("fmsub.d", datad,  80,  80,  16, w27, w28, w16);
      TEST_3RF_3("fmsub.d", datad,  80,  80,  32, w28, w10, w21);
      TEST_3RF_3("fmsub.d", datad,  80,  80,  48, w4,  w6,  w11);
      TEST_3RF_3("fmsub.d", datad,  80,  80,  64, w9,  w28, w15);
      TEST_3RF_3("fmsub.d", datad,  80,  80,  80, w26, w26, w26);
      TEST_3RF_3("fmsub.d", datad,  80,  80,  96, w23, w20, w21);
      TEST_3RF_3("fmsub.d", datad,  80,  80, 112, w2,  w20, w15);
      TEST_3RF_3("fmsub.d", datad,  80,  80, 128, w30, w22, w15);
      TEST_3RF_3("fmsub.d", datad,  80,  80, 144, w14, w4,  w21);
      TEST_3RF_3("fmsub.d", datad,  80,  96,   0, w0,  w26, w16);
      TEST_3RF_3("fmsub.d", datad,  80,  96,  16, w27, w22, w11);
      TEST_3RF_3("fmsub.d", datad,  80,  96,  32, w11, w18, w21);
      TEST_3RF_3("fmsub.d", datad,  80,  96,  48, w0,  w23, w28);
      TEST_3RF_3("fmsub.d", datad,  80,  96,  64, w11, w0,  w24);
      TEST_3RF_3("fmsub.d", datad,  80,  96,  80, w27, w15, w18);
      TEST_3RF_3("fmsub.d", datad,  80,  96,  96, w15, w5,  w20);
      TEST_3RF_3("fmsub.d", datad,  80,  96, 112, w3,  w20, w19);
      TEST_3RF_3("fmsub.d", datad,  80,  96, 128, w25, w10, w2);
      TEST_3RF_3("fmsub.d", datad,  80,  96, 144, w7,  w14, w24);
      TEST_3RF_3("fmsub.d", datad,  80, 112,   0, w7,  w8,  w2);
      TEST_3RF_3("fmsub.d", datad,  80, 112,  16, w31, w19, w13);
      TEST_3RF_3("fmsub.d", datad,  80, 112,  32, w17, w9,  w14);
      TEST_3RF_3("fmsub.d", datad,  80, 112,  48, w8,  w5,  w25);
      TEST_3RF_3("fmsub.d", datad,  80, 112,  64, w9,  w29, w20);
      TEST_3RF_3("fmsub.d", datad,  80, 112,  80, w4,  w12, w6);
      TEST_3RF_3("fmsub.d", datad,  80, 112,  96, w19, w17, w27);
      TEST_3RF_3("fmsub.d", datad,  80, 112, 112, w23, w6,  w14);
      TEST_3RF_3("fmsub.d", datad,  80, 112, 128, w16, w24, w31);
      TEST_3RF_3("fmsub.d", datad,  80, 112, 144, w8,  w31, w7);
      TEST_3RF_3("fmsub.d", datad,  80, 128,   0, w16, w2,  w6);
      TEST_3RF_3("fmsub.d", datad,  80, 128,  16, w4,  w15, w24);
      TEST_3RF_3("fmsub.d", datad,  80, 128,  32, w13, w29, w0);
      TEST_3RF_3("fmsub.d", datad,  80, 128,  48, w18, w23, w18);
      TEST_3RF_3("fmsub.d", datad,  80, 128,  64, w9,  w15, w11);
      TEST_3RF_3("fmsub.d", datad,  80, 128,  80, w13, w27, w18);
      TEST_3RF_3("fmsub.d", datad,  80, 128,  96, w1,  w13, w24);
      TEST_3RF_3("fmsub.d", datad,  80, 128, 112, w19, w27, w8);
      TEST_3RF_3("fmsub.d", datad,  80, 128, 128, w3,  w11, w0);
      TEST_3RF_3("fmsub.d", datad,  80, 128, 144, w2,  w20, w0);
      TEST_3RF_3("fmsub.d", datad,  80, 144,   0, w10, w10, w4);
      TEST_3RF_3("fmsub.d", datad,  80, 144,  16, w2,  w16, w8);
      TEST_3RF_3("fmsub.d", datad,  80, 144,  32, w17, w8,  w21);
      TEST_3RF_3("fmsub.d", datad,  80, 144,  48, w15, w9,  w7);
      TEST_3RF_3("fmsub.d", datad,  80, 144,  64, w6,  w18, w22);
      TEST_3RF_3("fmsub.d", datad,  80, 144,  80, w17, w0,  w18);
      TEST_3RF_3("fmsub.d", datad,  80, 144,  96, w3,  w1,  w31);
      TEST_3RF_3("fmsub.d", datad,  80, 144, 112, w16, w25, w18);
      TEST_3RF_3("fmsub.d", datad,  80, 144, 128, w11, w1,  w21);
      TEST_3RF_3("fmsub.d", datad,  80, 144, 144, w23, w2,  w24);
      TEST_3RF_3("fmsub.d", datad,  96,   0,   0, w11, w2,  w15);
      TEST_3RF_3("fmsub.d", datad,  96,   0,  16, w4,  w18, w24);
      TEST_3RF_3("fmsub.d", datad,  96,   0,  32, w21, w27, w27);
      TEST_3RF_3("fmsub.d", datad,  96,   0,  48, w13, w4,  w21);
      TEST_3RF_3("fmsub.d", datad,  96,   0,  64, w10, w10, w22);
      TEST_3RF_3("fmsub.d", datad,  96,   0,  80, w11, w28, w22);
      TEST_3RF_3("fmsub.d", datad,  96,   0,  96, w29, w31, w23);
      TEST_3RF_3("fmsub.d", datad,  96,   0, 112, w28, w16, w14);
      TEST_3RF_3("fmsub.d", datad,  96,   0, 128, w27, w18, w4);
      TEST_3RF_3("fmsub.d", datad,  96,   0, 144, w18, w20, w18);
      TEST_3RF_3("fmsub.d", datad,  96,  16,   0, w28, w29, w22);
      TEST_3RF_3("fmsub.d", datad,  96,  16,  16, w30, w13, w26);
      TEST_3RF_3("fmsub.d", datad,  96,  16,  32, w16, w5,  w15);
      TEST_3RF_3("fmsub.d", datad,  96,  16,  48, w11, w18, w20);
      TEST_3RF_3("fmsub.d", datad,  96,  16,  64, w15, w7,  w30);
      TEST_3RF_3("fmsub.d", datad,  96,  16,  80, w6,  w19, w26);
      TEST_3RF_3("fmsub.d", datad,  96,  16,  96, w28, w16, w26);
      TEST_3RF_3("fmsub.d", datad,  96,  16, 112, w20, w13, w10);
      TEST_3RF_3("fmsub.d", datad,  96,  16, 128, w4,  w27, w5);
      TEST_3RF_3("fmsub.d", datad,  96,  16, 144, w22, w31, w24);
      TEST_3RF_3("fmsub.d", datad,  96,  32,   0, w10, w10, w27);
      TEST_3RF_3("fmsub.d", datad,  96,  32,  16, w21, w0,  w0);
      TEST_3RF_3("fmsub.d", datad,  96,  32,  32, w25, w2,  w26);
      TEST_3RF_3("fmsub.d", datad,  96,  32,  48, w10, w10, w7);
      TEST_3RF_3("fmsub.d", datad,  96,  32,  64, w10, w10, w21);
      TEST_3RF_3("fmsub.d", datad,  96,  32,  80, w26, w26, w26);
      TEST_3RF_3("fmsub.d", datad,  96,  32,  96, w30, w5,  w1);
      TEST_3RF_3("fmsub.d", datad,  96,  32, 112, w28, w11, w20);
      TEST_3RF_3("fmsub.d", datad,  96,  32, 128, w23, w7,  w5);
      TEST_3RF_3("fmsub.d", datad,  96,  32, 144, w17, w27, w18);
      TEST_3RF_3("fmsub.d", datad,  96,  48,   0, w27, w0,  w13);
      TEST_3RF_3("fmsub.d", datad,  96,  48,  16, w0,  w22, w13);
      TEST_3RF_3("fmsub.d", datad,  96,  48,  32, w24, w1,  w8);
      TEST_3RF_3("fmsub.d", datad,  96,  48,  48, w14, w1,  w2);
      TEST_3RF_3("fmsub.d", datad,  96,  48,  64, w16, w28, w12);
      TEST_3RF_3("fmsub.d", datad,  96,  48,  80, w24, w6,  w1);
      TEST_3RF_3("fmsub.d", datad,  96,  48,  96, w18, w4,  w18);
      TEST_3RF_3("fmsub.d", datad,  96,  48, 112, w6,  w19, w0);
      TEST_3RF_3("fmsub.d", datad,  96,  48, 128, w17, w8,  w23);
      TEST_3RF_3("fmsub.d", datad,  96,  48, 144, w25, w13, w8);
      TEST_3RF_3("fmsub.d", datad,  96,  64,   0, w20, w31, w3);
      TEST_3RF_3("fmsub.d", datad,  96,  64,  16, w20, w12, w4);
      TEST_3RF_3("fmsub.d", datad,  96,  64,  32, w11, w25, w28);
      TEST_3RF_3("fmsub.d", datad,  96,  64,  48, w12, w2,  w10);
      TEST_3RF_3("fmsub.d", datad,  96,  64,  64, w13, w4,  w27);
      TEST_3RF_3("fmsub.d", datad,  96,  64,  80, w9,  w16, w19);
      TEST_3RF_3("fmsub.d", datad,  96,  64,  96, w15, w17, w5);
      TEST_3RF_3("fmsub.d", datad,  96,  64, 112, w19, w24, w20);
      TEST_3RF_3("fmsub.d", datad,  96,  64, 128, w9,  w0,  w11);
      TEST_3RF_3("fmsub.d", datad,  96,  64, 144, w2,  w13, w20);
      TEST_3RF_3("fmsub.d", datad,  96,  80,   0, w23, w12, w11);
      TEST_3RF_3("fmsub.d", datad,  96,  80,  16, w25, w27, w22);
      TEST_3RF_3("fmsub.d", datad,  96,  80,  32, w18, w24, w18);
      TEST_3RF_3("fmsub.d", datad,  96,  80,  48, w2,  w20, w16);
      TEST_3RF_3("fmsub.d", datad,  96,  80,  64, w24, w29, w25);
      TEST_3RF_3("fmsub.d", datad,  96,  80,  80, w8,  w16, w9);
      TEST_3RF_3("fmsub.d", datad,  96,  80,  96, w26, w26, w26);
      TEST_3RF_3("fmsub.d", datad,  96,  80, 112, w21, w28, w28);
      TEST_3RF_3("fmsub.d", datad,  96,  80, 128, w18, w14, w18);
      TEST_3RF_3("fmsub.d", datad,  96,  80, 144, w16, w27, w14);
      TEST_3RF_3("fmsub.d", datad,  96,  96,   0, w28, w30, w16);
      TEST_3RF_3("fmsub.d", datad,  96,  96,  16, w21, w8,  w8);
      TEST_3RF_3("fmsub.d", datad,  96,  96,  32, w7,  w0,  w1);
      TEST_3RF_3("fmsub.d", datad,  96,  96,  48, w3,  w23, w20);
      TEST_3RF_3("fmsub.d", datad,  96,  96,  64, w27, w25, w8);
      TEST_3RF_3("fmsub.d", datad,  96,  96,  80, w29, w9,  w1);
      TEST_3RF_3("fmsub.d", datad,  96,  96,  96, w27, w3,  w9);
      TEST_3RF_3("fmsub.d", datad,  96,  96, 112, w11, w12, w3);
      TEST_3RF_3("fmsub.d", datad,  96,  96, 128, w1,  w8,  w21);
      TEST_3RF_3("fmsub.d", datad,  96,  96, 144, w15, w25, w17);
      TEST_3RF_3("fmsub.d", datad,  96, 112,   0, w29, w21, w15);
      TEST_3RF_3("fmsub.d", datad,  96, 112,  16, w25, w5,  w4);
      TEST_3RF_3("fmsub.d", datad,  96, 112,  32, w2,  w12, w4);
      TEST_3RF_3("fmsub.d", datad,  96, 112,  48, w3,  w15, w27);
      TEST_3RF_3("fmsub.d", datad,  96, 112,  64, w23, w10, w21);
      TEST_3RF_3("fmsub.d", datad,  96, 112,  80, w0,  w8,  w30);
      TEST_3RF_3("fmsub.d", datad,  96, 112,  96, w1,  w3,  w10);
      TEST_3RF_3("fmsub.d", datad,  96, 112, 112, w14, w13, w15);
      TEST_3RF_3("fmsub.d", datad,  96, 112, 128, w22, w3,  w30);
      TEST_3RF_3("fmsub.d", datad,  96, 112, 144, w15, w20, w28);
      TEST_3RF_3("fmsub.d", datad,  96, 128,   0, w4,  w3,  w21);
      TEST_3RF_3("fmsub.d", datad,  96, 128,  16, w9,  w7,  w23);
      TEST_3RF_3("fmsub.d", datad,  96, 128,  32, w21, w12, w12);
      TEST_3RF_3("fmsub.d", datad,  96, 128,  48, w27, w5,  w7);
      TEST_3RF_3("fmsub.d", datad,  96, 128,  64, w18, w15, w18);
      TEST_3RF_3("fmsub.d", datad,  96, 128,  80, w28, w18, w23);
      TEST_3RF_3("fmsub.d", datad,  96, 128,  96, w27, w19, w26);
      TEST_3RF_3("fmsub.d", datad,  96, 128, 112, w28, w30, w9);
      TEST_3RF_3("fmsub.d", datad,  96, 128, 128, w10, w10, w12);
      TEST_3RF_3("fmsub.d", datad,  96, 128, 144, w24, w0,  w15);
      TEST_3RF_3("fmsub.d", datad,  96, 144,   0, w23, w15, w4);
      TEST_3RF_3("fmsub.d", datad,  96, 144,  16, w19, w7,  w8);
      TEST_3RF_3("fmsub.d", datad,  96, 144,  32, w28, w15, w0);
      TEST_3RF_3("fmsub.d", datad,  96, 144,  48, w17, w27, w22);
      TEST_3RF_3("fmsub.d", datad,  96, 144,  64, w2,  w13, w6);
      TEST_3RF_3("fmsub.d", datad,  96, 144,  80, w31, w0,  w29);
      TEST_3RF_3("fmsub.d", datad,  96, 144,  96, w26, w26, w26);
      TEST_3RF_3("fmsub.d", datad,  96, 144, 112, w19, w24, w22);
      TEST_3RF_3("fmsub.d", datad,  96, 144, 128, w17, w1,  w0);
      TEST_3RF_3("fmsub.d", datad,  96, 144, 144, w29, w25, w0);
      TEST_3RF_3("fmsub.d", datad, 112,   0,   0, w13, w16, w15);
      TEST_3RF_3("fmsub.d", datad, 112,   0,  16, w17, w3,  w2);
      TEST_3RF_3("fmsub.d", datad, 112,   0,  32, w24, w12, w30);
      TEST_3RF_3("fmsub.d", datad, 112,   0,  48, w7,  w12, w16);
      TEST_3RF_3("fmsub.d", datad, 112,   0,  64, w2,  w7,  w6);
      TEST_3RF_3("fmsub.d", datad, 112,   0,  80, w5,  w20, w12);
      TEST_3RF_3("fmsub.d", datad, 112,   0,  96, w4,  w20, w10);
      TEST_3RF_3("fmsub.d", datad, 112,   0, 112, w30, w8,  w2);
      TEST_3RF_3("fmsub.d", datad, 112,   0, 128, w20, w25, w3);
      TEST_3RF_3("fmsub.d", datad, 112,   0, 144, w21, w23, w23);
      TEST_3RF_3("fmsub.d", datad, 112,  16,   0, w28, w21, w4);
      TEST_3RF_3("fmsub.d", datad, 112,  16,  16, w13, w5,  w21);
      TEST_3RF_3("fmsub.d", datad, 112,  16,  32, w16, w7,  w13);
      TEST_3RF_3("fmsub.d", datad, 112,  16,  48, w28, w6,  w21);
      TEST_3RF_3("fmsub.d", datad, 112,  16,  64, w8,  w22, w23);
      TEST_3RF_3("fmsub.d", datad, 112,  16,  80, w15, w28, w4);
      TEST_3RF_3("fmsub.d", datad, 112,  16,  96, w9,  w0,  w24);
      TEST_3RF_3("fmsub.d", datad, 112,  16, 112, w19, w30, w0);
      TEST_3RF_3("fmsub.d", datad, 112,  16, 128, w21, w19, w19);
      TEST_3RF_3("fmsub.d", datad, 112,  16, 144, w26, w26, w26);
      TEST_3RF_3("fmsub.d", datad, 112,  32,   0, w24, w8,  w17);
      TEST_3RF_3("fmsub.d", datad, 112,  32,  16, w20, w29, w21);
      TEST_3RF_3("fmsub.d", datad, 112,  32,  32, w1,  w2,  w10);
      TEST_3RF_3("fmsub.d", datad, 112,  32,  48, w18, w10, w18);
      TEST_3RF_3("fmsub.d", datad, 112,  32,  64, w23, w14, w16);
      TEST_3RF_3("fmsub.d", datad, 112,  32,  80, w12, w23, w6);
      TEST_3RF_3("fmsub.d", datad, 112,  32,  96, w4,  w6,  w2);
      TEST_3RF_3("fmsub.d", datad, 112,  32, 112, w0,  w10, w11);
      TEST_3RF_3("fmsub.d", datad, 112,  32, 128, w1,  w3,  w30);
      TEST_3RF_3("fmsub.d", datad, 112,  32, 144, w31, w3,  w19);
      TEST_3RF_3("fmsub.d", datad, 112,  48,   0, w18, w29, w18);
      TEST_3RF_3("fmsub.d", datad, 112,  48,  16, w11, w26, w14);
      TEST_3RF_3("fmsub.d", datad, 112,  48,  32, w0,  w24, w3);
      TEST_3RF_3("fmsub.d", datad, 112,  48,  48, w1,  w26, w13);
      TEST_3RF_3("fmsub.d", datad, 112,  48,  64, w19, w4,  w5);
      TEST_3RF_3("fmsub.d", datad, 112,  48,  80, w2,  w20, w17);
      TEST_3RF_3("fmsub.d", datad, 112,  48,  96, w25, w26, w21);
      TEST_3RF_3("fmsub.d", datad, 112,  48, 112, w31, w29, w22);
      TEST_3RF_3("fmsub.d", datad, 112,  48, 128, w10, w10, w8);
      TEST_3RF_3("fmsub.d", datad, 112,  48, 144, w23, w13, w7);
      TEST_3RF_3("fmsub.d", datad, 112,  64,   0, w22, w16, w26);
      TEST_3RF_3("fmsub.d", datad, 112,  64,  16, w9,  w14, w6);
      TEST_3RF_3("fmsub.d", datad, 112,  64,  32, w3,  w28, w6);
      TEST_3RF_3("fmsub.d", datad, 112,  64,  48, w27, w0,  w7);
      TEST_3RF_3("fmsub.d", datad, 112,  64,  64, w22, w13, w27);
      TEST_3RF_3("fmsub.d", datad, 112,  64,  80, w26, w26, w26);
      TEST_3RF_3("fmsub.d", datad, 112,  64,  96, w18, w29, w18);
      TEST_3RF_3("fmsub.d", datad, 112,  64, 112, w15, w4,  w22);
      TEST_3RF_3("fmsub.d", datad, 112,  64, 128, w9,  w25, w21);
      TEST_3RF_3("fmsub.d", datad, 112,  64, 144, w6,  w15, w31);
      TEST_3RF_3("fmsub.d", datad, 112,  80,   0, w15, w6,  w12);
      TEST_3RF_3("fmsub.d", datad, 112,  80,  16, w22, w29, w16);
      TEST_3RF_3("fmsub.d", datad, 112,  80,  32, w6,  w11, w22);
      TEST_3RF_3("fmsub.d", datad, 112,  80,  48, w9,  w7,  w28);
      TEST_3RF_3("fmsub.d", datad, 112,  80,  64, w5,  w7,  w4);
      TEST_3RF_3("fmsub.d", datad, 112,  80,  80, w27, w21, w31);
      TEST_3RF_3("fmsub.d", datad, 112,  80,  96, w21, w7,  w7);
      TEST_3RF_3("fmsub.d", datad, 112,  80, 112, w28, w4,  w11);
      TEST_3RF_3("fmsub.d", datad, 112,  80, 128, w18, w14, w18);
      TEST_3RF_3("fmsub.d", datad, 112,  80, 144, w5,  w7,  w20);
      TEST_3RF_3("fmsub.d", datad, 112,  96,   0, w20, w7,  w3);
      TEST_3RF_3("fmsub.d", datad, 112,  96,  16, w27, w19, w25);
      TEST_3RF_3("fmsub.d", datad, 112,  96,  32, w24, w16, w10);
      TEST_3RF_3("fmsub.d", datad, 112,  96,  48, w30, w27, w0);
      TEST_3RF_3("fmsub.d", datad, 112,  96,  64, w7,  w3,  w29);
      TEST_3RF_3("fmsub.d", datad, 112,  96,  80, w12, w10, w1);
      TEST_3RF_3("fmsub.d", datad, 112,  96,  96, w7,  w31, w0);
      TEST_3RF_3("fmsub.d", datad, 112,  96, 112, w29, w7,  w28);
      TEST_3RF_3("fmsub.d", datad, 112,  96, 128, w1,  w18, w14);
      TEST_3RF_3("fmsub.d", datad, 112,  96, 144, w15, w23, w21);
      TEST_3RF_3("fmsub.d", datad, 112, 112,   0, w4,  w12, w28);
      TEST_3RF_3("fmsub.d", datad, 112, 112,  16, w7,  w16, w1);
      TEST_3RF_3("fmsub.d", datad, 112, 112,  32, w31, w0,  w11);
      TEST_3RF_3("fmsub.d", datad, 112, 112,  48, w29, w28, w11);
      TEST_3RF_3("fmsub.d", datad, 112, 112,  64, w4,  w31, w8);
      TEST_3RF_3("fmsub.d", datad, 112, 112,  80, w17, w9,  w24);
      TEST_3RF_3("fmsub.d", datad, 112, 112,  96, w9,  w21, w16);
      TEST_3RF_3("fmsub.d", datad, 112, 112, 112, w5,  w23, w2);
      TEST_3RF_3("fmsub.d", datad, 112, 112, 128, w19, w6,  w26);
      TEST_3RF_3("fmsub.d", datad, 112, 112, 144, w9,  w10, w6);
      TEST_3RF_3("fmsub.d", datad, 112, 128,   0, w5,  w18, w13);
      TEST_3RF_3("fmsub.d", datad, 112, 128,  16, w21, w19, w19);
      TEST_3RF_3("fmsub.d", datad, 112, 128,  32, w12, w22, w30);
      TEST_3RF_3("fmsub.d", datad, 112, 128,  48, w9,  w18, w13);
      TEST_3RF_3("fmsub.d", datad, 112, 128,  64, w17, w18, w30);
      TEST_3RF_3("fmsub.d", datad, 112, 128,  80, w26, w26, w26);
      TEST_3RF_3("fmsub.d", datad, 112, 128,  96, w27, w23, w3);
      TEST_3RF_3("fmsub.d", datad, 112, 128, 112, w5,  w12, w19);
      TEST_3RF_3("fmsub.d", datad, 112, 128, 128, w10, w10, w3);
      TEST_3RF_3("fmsub.d", datad, 112, 128, 144, w22, w30, w10);
      TEST_3RF_3("fmsub.d", datad, 112, 144,   0, w16, w7,  w20);
      TEST_3RF_3("fmsub.d", datad, 112, 144,  16, w22, w12, w6);
      TEST_3RF_3("fmsub.d", datad, 112, 144,  32, w3,  w2,  w25);
      TEST_3RF_3("fmsub.d", datad, 112, 144,  48, w15, w24, w23);
      TEST_3RF_3("fmsub.d", datad, 112, 144,  64, w24, w10, w1);
      TEST_3RF_3("fmsub.d", datad, 112, 144,  80, w5,  w27, w19);
      TEST_3RF_3("fmsub.d", datad, 112, 144,  96, w4,  w21, w14);
      TEST_3RF_3("fmsub.d", datad, 112, 144, 112, w27, w25, w19);
      TEST_3RF_3("fmsub.d", datad, 112, 144, 128, w7,  w12, w30);
      TEST_3RF_3("fmsub.d", datad, 112, 144, 144, w11, w2,  w28);
      TEST_3RF_3("fmsub.d", datad, 128,   0,   0, w21, w18, w18);
      TEST_3RF_3("fmsub.d", datad, 128,   0,  16, w3,  w9,  w8);
      TEST_3RF_3("fmsub.d", datad, 128,   0,  32, w15, w16, w11);
      TEST_3RF_3("fmsub.d", datad, 128,   0,  48, w17, w9,  w26);
      TEST_3RF_3("fmsub.d", datad, 128,   0,  64, w9,  w1,  w18);
      TEST_3RF_3("fmsub.d", datad, 128,   0,  80, w19, w2,  w24);
      TEST_3RF_3("fmsub.d", datad, 128,   0,  96, w14, w21, w28);
      TEST_3RF_3("fmsub.d", datad, 128,   0, 112, w4,  w3,  w23);
      TEST_3RF_3("fmsub.d", datad, 128,   0, 128, w29, w23, w30);
      TEST_3RF_3("fmsub.d", datad, 128,   0, 144, w9,  w21, w12);
      TEST_3RF_3("fmsub.d", datad, 128,  16,   0, w17, w30, w20);
      TEST_3RF_3("fmsub.d", datad, 128,  16,  16, w8,  w7,  w3);
      TEST_3RF_3("fmsub.d", datad, 128,  16,  32, w24, w18, w21);
      TEST_3RF_3("fmsub.d", datad, 128,  16,  48, w1,  w13, w30);
      TEST_3RF_3("fmsub.d", datad, 128,  16,  64, w2,  w31, w18);
      TEST_3RF_3("fmsub.d", datad, 128,  16,  80, w4,  w23, w0);
      TEST_3RF_3("fmsub.d", datad, 128,  16,  96, w25, w19, w4);
      TEST_3RF_3("fmsub.d", datad, 128,  16, 112, w29, w10, w1);
      TEST_3RF_3("fmsub.d", datad, 128,  16, 128, w20, w9,  w11);
      TEST_3RF_3("fmsub.d", datad, 128,  16, 144, w9,  w18, w23);
      TEST_3RF_3("fmsub.d", datad, 128,  32,   0, w26, w26, w26);
      TEST_3RF_3("fmsub.d", datad, 128,  32,  16, w17, w21, w14);
      TEST_3RF_3("fmsub.d", datad, 128,  32,  32, w25, w28, w17);
      TEST_3RF_3("fmsub.d", datad, 128,  32,  48, w17, w15, w6);
      TEST_3RF_3("fmsub.d", datad, 128,  32,  64, w18, w28, w18);
      TEST_3RF_3("fmsub.d", datad, 128,  32,  80, w5,  w21, w27);
      TEST_3RF_3("fmsub.d", datad, 128,  32,  96, w23, w25, w19);
      TEST_3RF_3("fmsub.d", datad, 128,  32, 112, w23, w19, w6);
      TEST_3RF_3("fmsub.d", datad, 128,  32, 128, w28, w16, w17);
      TEST_3RF_3("fmsub.d", datad, 128,  32, 144, w29, w4,  w26);
      TEST_3RF_3("fmsub.d", datad, 128,  48,   0, w8,  w13, w12);
      TEST_3RF_3("fmsub.d", datad, 128,  48,  16, w31, w7,  w29);
      TEST_3RF_3("fmsub.d", datad, 128,  48,  32, w21, w22, w22);
      TEST_3RF_3("fmsub.d", datad, 128,  48,  48, w17, w6,  w7);
      TEST_3RF_3("fmsub.d", datad, 128,  48,  64, w0,  w13, w26);
      TEST_3RF_3("fmsub.d", datad, 128,  48,  80, w28, w18, w15);
      TEST_3RF_3("fmsub.d", datad, 128,  48,  96, w24, w9,  w8);
      TEST_3RF_3("fmsub.d", datad, 128,  48, 112, w11, w0,  w27);
      TEST_3RF_3("fmsub.d", datad, 128,  48, 128, w17, w28, w11);
      TEST_3RF_3("fmsub.d", datad, 128,  48, 144, w2,  w26, w15);
      TEST_3RF_3("fmsub.d", datad, 128,  64,   0, w28, w2,  w9);
      TEST_3RF_3("fmsub.d", datad, 128,  64,  16, w2,  w3,  w6);
      TEST_3RF_3("fmsub.d", datad, 128,  64,  32, w23, w24, w29);
      TEST_3RF_3("fmsub.d", datad, 128,  64,  48, w8,  w31, w4);
      TEST_3RF_3("fmsub.d", datad, 128,  64,  64, w9,  w12, w30);
      TEST_3RF_3("fmsub.d", datad, 128,  64,  80, w5,  w30, w13);
      TEST_3RF_3("fmsub.d", datad, 128,  64,  96, w29, w7,  w22);
      TEST_3RF_3("fmsub.d", datad, 128,  64, 112, w8,  w7,  w17);
      TEST_3RF_3("fmsub.d", datad, 128,  64, 128, w26, w26, w26);
      TEST_3RF_3("fmsub.d", datad, 128,  64, 144, w4,  w29, w28);
      TEST_3RF_3("fmsub.d", datad, 128,  80,   0, w30, w12, w25);
      TEST_3RF_3("fmsub.d", datad, 128,  80,  16, w0,  w9,  w2);
      TEST_3RF_3("fmsub.d", datad, 128,  80,  32, w2,  w12, w8);
      TEST_3RF_3("fmsub.d", datad, 128,  80,  48, w25, w5,  w2);
      TEST_3RF_3("fmsub.d", datad, 128,  80,  64, w4,  w10, w11);
      TEST_3RF_3("fmsub.d", datad, 128,  80,  80, w16, w8,  w14);
      TEST_3RF_3("fmsub.d", datad, 128,  80,  96, w22, w14, w21);
      TEST_3RF_3("fmsub.d", datad, 128,  80, 112, w12, w22, w28);
      TEST_3RF_3("fmsub.d", datad, 128,  80, 128, w29, w16, w0);
      TEST_3RF_3("fmsub.d", datad, 128,  80, 144, w26, w26, w26);
      TEST_3RF_3("fmsub.d", datad, 128,  96,   0, w13, w30, w7);
      TEST_3RF_3("fmsub.d", datad, 128,  96,  16, w6,  w31, w16);
      TEST_3RF_3("fmsub.d", datad, 128,  96,  32, w8,  w1,  w28);
      TEST_3RF_3("fmsub.d", datad, 128,  96,  48, w16, w27, w1);
      TEST_3RF_3("fmsub.d", datad, 128,  96,  64, w22, w29, w5);
      TEST_3RF_3("fmsub.d", datad, 128,  96,  80, w0,  w8,  w21);
      TEST_3RF_3("fmsub.d", datad, 128,  96,  96, w8,  w24, w3);
      TEST_3RF_3("fmsub.d", datad, 128,  96, 112, w30, w6,  w24);
      TEST_3RF_3("fmsub.d", datad, 128,  96, 128, w10, w10, w29);
      TEST_3RF_3("fmsub.d", datad, 128,  96, 144, w21, w8,  w8);
      TEST_3RF_3("fmsub.d", datad, 128, 112,   0, w13, w21, w2);
      TEST_3RF_3("fmsub.d", datad, 128, 112,  16, w26, w26, w26);
      TEST_3RF_3("fmsub.d", datad, 128, 112,  32, w20, w9,  w0);
      TEST_3RF_3("fmsub.d", datad, 128, 112,  48, w19, w25, w8);
      TEST_3RF_3("fmsub.d", datad, 128, 112,  64, w20, w22, w25);
      TEST_3RF_3("fmsub.d", datad, 128, 112,  80, w15, w23, w12);
      TEST_3RF_3("fmsub.d", datad, 128, 112,  96, w29, w15, w20);
      TEST_3RF_3("fmsub.d", datad, 128, 112, 112, w18, w23, w18);
      TEST_3RF_3("fmsub.d", datad, 128, 112, 128, w13, w22, w19);
      TEST_3RF_3("fmsub.d", datad, 128, 112, 144, w14, w0,  w16);
      TEST_3RF_3("fmsub.d", datad, 128, 128,   0, w3,  w8,  w30);
      TEST_3RF_3("fmsub.d", datad, 128, 128,  16, w25, w11, w24);
      TEST_3RF_3("fmsub.d", datad, 128, 128,  32, w13, w20, w25);
      TEST_3RF_3("fmsub.d", datad, 128, 128,  48, w0,  w14, w1);
      TEST_3RF_3("fmsub.d", datad, 128, 128,  64, w20, w4,  w26);
      TEST_3RF_3("fmsub.d", datad, 128, 128,  80, w4,  w27, w9);
      TEST_3RF_3("fmsub.d", datad, 128, 128,  96, w16, w24, w5);
      TEST_3RF_3("fmsub.d", datad, 128, 128, 112, w11, w16, w18);
      TEST_3RF_3("fmsub.d", datad, 128, 128, 128, w1,  w6,  w5);
      TEST_3RF_3("fmsub.d", datad, 128, 128, 144, w15, w6,  w22);
      TEST_3RF_3("fmsub.d", datad, 128, 144,   0, w19, w15, w20);
      TEST_3RF_3("fmsub.d", datad, 128, 144,  16, w12, w26, w25);
      TEST_3RF_3("fmsub.d", datad, 128, 144,  32, w14, w5,  w25);
      TEST_3RF_3("fmsub.d", datad, 128, 144,  48, w28, w7,  w13);
      TEST_3RF_3("fmsub.d", datad, 128, 144,  64, w0,  w1,  w17);
      TEST_3RF_3("fmsub.d", datad, 128, 144,  80, w28, w11, w2);
      TEST_3RF_3("fmsub.d", datad, 128, 144,  96, w20, w3,  w7);
      TEST_3RF_3("fmsub.d", datad, 128, 144, 112, w31, w19, w25);
      TEST_3RF_3("fmsub.d", datad, 128, 144, 128, w0,  w25, w30);
      TEST_3RF_3("fmsub.d", datad, 128, 144, 144, w16, w0,  w20);
      TEST_3RF_3("fmsub.d", datad, 144,   0,   0, w3,  w15, w8);
      TEST_3RF_3("fmsub.d", datad, 144,   0,  16, w15, w9,  w21);
      TEST_3RF_3("fmsub.d", datad, 144,   0,  32, w8,  w23, w26);
      TEST_3RF_3("fmsub.d", datad, 144,   0,  48, w1,  w20, w14);
      TEST_3RF_3("fmsub.d", datad, 144,   0,  64, w20, w3,  w0);
      TEST_3RF_3("fmsub.d", datad, 144,   0,  80, w16, w14, w2);
      TEST_3RF_3("fmsub.d", datad, 144,   0,  96, w5,  w17, w9);
      TEST_3RF_3("fmsub.d", datad, 144,   0, 112, w4,  w5,  w2);
      TEST_3RF_3("fmsub.d", datad, 144,   0, 128, w5,  w30, w0);
      TEST_3RF_3("fmsub.d", datad, 144,   0, 144, w21, w30, w30);
      TEST_3RF_3("fmsub.d", datad, 144,  16,   0, w21, w24, w24);
      TEST_3RF_3("fmsub.d", datad, 144,  16,  16, w13, w29, w7);
      TEST_3RF_3("fmsub.d", datad, 144,  16,  32, w22, w18, w15);
      TEST_3RF_3("fmsub.d", datad, 144,  16,  48, w14, w13, w16);
      TEST_3RF_3("fmsub.d", datad, 144,  16,  64, w2,  w14, w30);
      TEST_3RF_3("fmsub.d", datad, 144,  16,  80, w22, w17, w30);
      TEST_3RF_3("fmsub.d", datad, 144,  16,  96, w7,  w31, w0);
      TEST_3RF_3("fmsub.d", datad, 144,  16, 112, w12, w17, w9);
      TEST_3RF_3("fmsub.d", datad, 144,  16, 128, w16, w22, w11);
      TEST_3RF_3("fmsub.d", datad, 144,  16, 144, w21, w20, w20);
      TEST_3RF_3("fmsub.d", datad, 144,  32,   0, w12, w10, w19);
      TEST_3RF_3("fmsub.d", datad, 144,  32,  16, w1,  w2,  w0);
      TEST_3RF_3("fmsub.d", datad, 144,  32,  32, w30, w9,  w23);
      TEST_3RF_3("fmsub.d", datad, 144,  32,  48, w17, w24, w5);
      TEST_3RF_3("fmsub.d", datad, 144,  32,  64, w30, w8,  w7);
      TEST_3RF_3("fmsub.d", datad, 144,  32,  80, w12, w7,  w29);
      TEST_3RF_3("fmsub.d", datad, 144,  32,  96, w30, w5,  w4);
      TEST_3RF_3("fmsub.d", datad, 144,  32, 112, w29, w6,  w16);
      TEST_3RF_3("fmsub.d", datad, 144,  32, 128, w14, w15, w1);
      TEST_3RF_3("fmsub.d", datad, 144,  32, 144, w4,  w27, w22);
      TEST_3RF_3("fmsub.d", datad, 144,  48,   0, w25, w7,  w1);
      TEST_3RF_3("fmsub.d", datad, 144,  48,  16, w12, w8,  w3);
      TEST_3RF_3("fmsub.d", datad, 144,  48,  32, w12, w6,  w13);
      TEST_3RF_3("fmsub.d", datad, 144,  48,  48, w3,  w23, w5);
      TEST_3RF_3("fmsub.d", datad, 144,  48,  64, w8,  w21, w14);
      TEST_3RF_3("fmsub.d", datad, 144,  48,  80, w15, w2,  w21);
      TEST_3RF_3("fmsub.d", datad, 144,  48,  96, w13, w0,  w26);
      TEST_3RF_3("fmsub.d", datad, 144,  48, 112, w17, w29, w0);
      TEST_3RF_3("fmsub.d", datad, 144,  48, 128, w2,  w12, w16);
      TEST_3RF_3("fmsub.d", datad, 144,  48, 144, w3,  w16, w11);
      TEST_3RF_3("fmsub.d", datad, 144,  64,   0, w25, w9,  w18);
      TEST_3RF_3("fmsub.d", datad, 144,  64,  16, w26, w26, w26);
      TEST_3RF_3("fmsub.d", datad, 144,  64,  32, w21, w26, w26);
      TEST_3RF_3("fmsub.d", datad, 144,  64,  48, w30, w2,  w0);
      TEST_3RF_3("fmsub.d", datad, 144,  64,  64, w11, w5,  w24);
      TEST_3RF_3("fmsub.d", datad, 144,  64,  80, w16, w14, w13);
      TEST_3RF_3("fmsub.d", datad, 144,  64,  96, w30, w29, w15);
      TEST_3RF_3("fmsub.d", datad, 144,  64, 112, w19, w10, w15);
      TEST_3RF_3("fmsub.d", datad, 144,  64, 128, w14, w28, w13);
      TEST_3RF_3("fmsub.d", datad, 144,  64, 144, w14, w30, w25);
      TEST_3RF_3("fmsub.d", datad, 144,  80,   0, w30, w1,  w9);
      TEST_3RF_3("fmsub.d", datad, 144,  80,  16, w9,  w26, w19);
      TEST_3RF_3("fmsub.d", datad, 144,  80,  32, w27, w21, w8);
      TEST_3RF_3("fmsub.d", datad, 144,  80,  48, w21, w19, w19);
      TEST_3RF_3("fmsub.d", datad, 144,  80,  64, w10, w10, w22);
      TEST_3RF_3("fmsub.d", datad, 144,  80,  80, w30, w16, w14);
      TEST_3RF_3("fmsub.d", datad, 144,  80,  96, w14, w30, w27);
      TEST_3RF_3("fmsub.d", datad, 144,  80, 112, w13, w27, w11);
      TEST_3RF_3("fmsub.d", datad, 144,  80, 128, w0,  w6,  w26);
      TEST_3RF_3("fmsub.d", datad, 144,  80, 144, w14, w2,  w7);
      TEST_3RF_3("fmsub.d", datad, 144,  96,   0, w29, w0,  w27);
      TEST_3RF_3("fmsub.d", datad, 144,  96,  16, w1,  w10, w5);
      TEST_3RF_3("fmsub.d", datad, 144,  96,  32, w27, w29, w0);
      TEST_3RF_3("fmsub.d", datad, 144,  96,  48, w16, w5,  w22);
      TEST_3RF_3("fmsub.d", datad, 144,  96,  64, w3,  w16, w12);
      TEST_3RF_3("fmsub.d", datad, 144,  96,  80, w1,  w0,  w26);
      TEST_3RF_3("fmsub.d", datad, 144,  96,  96, w16, w30, w21);
      TEST_3RF_3("fmsub.d", datad, 144,  96, 112, w29, w25, w0);
      TEST_3RF_3("fmsub.d", datad, 144,  96, 128, w29, w31, w27);
      TEST_3RF_3("fmsub.d", datad, 144,  96, 144, w12, w1,  w2);
      TEST_3RF_3("fmsub.d", datad, 144, 112,   0, w9,  w1,  w3);
      TEST_3RF_3("fmsub.d", datad, 144, 112,  16, w4,  w2,  w13);
      TEST_3RF_3("fmsub.d", datad, 144, 112,  32, w9,  w30, w10);
      TEST_3RF_3("fmsub.d", datad, 144, 112,  48, w10, w10, w14);
      TEST_3RF_3("fmsub.d", datad, 144, 112,  64, w15, w0,  w18);
      TEST_3RF_3("fmsub.d", datad, 144, 112,  80, w31, w12, w19);
      TEST_3RF_3("fmsub.d", datad, 144, 112,  96, w31, w6,  w3);
      TEST_3RF_3("fmsub.d", datad, 144, 112, 112, w29, w27, w0);
      TEST_3RF_3("fmsub.d", datad, 144, 112, 128, w23, w28, w30);
      TEST_3RF_3("fmsub.d", datad, 144, 112, 144, w22, w23, w10);
      TEST_3RF_3("fmsub.d", datad, 144, 128,   0, w24, w25, w19);
      TEST_3RF_3("fmsub.d", datad, 144, 128,  16, w25, w28, w23);
      TEST_3RF_3("fmsub.d", datad, 144, 128,  32, w28, w9,  w1);
      TEST_3RF_3("fmsub.d", datad, 144, 128,  48, w26, w26, w26);
      TEST_3RF_3("fmsub.d", datad, 144, 128,  64, w19, w11, w8);
      TEST_3RF_3("fmsub.d", datad, 144, 128,  80, w3,  w11, w26);
      TEST_3RF_3("fmsub.d", datad, 144, 128,  96, w2,  w23, w14);
      TEST_3RF_3("fmsub.d", datad, 144, 128, 112, w2,  w29, w17);
      TEST_3RF_3("fmsub.d", datad, 144, 128, 128, w31, w24, w18);
      TEST_3RF_3("fmsub.d", datad, 144, 128, 144, w22, w20, w16);
      TEST_3RF_3("fmsub.d", datad, 144, 144,   0, w13, w11, w26);
      TEST_3RF_3("fmsub.d", datad, 144, 144,  16, w5,  w13, w30);
      TEST_3RF_3("fmsub.d", datad, 144, 144,  32, w1,  w4,  w26);
      TEST_3RF_3("fmsub.d", datad, 144, 144,  48, w11, w5,  w20);
      TEST_3RF_3("fmsub.d", datad, 144, 144,  64, w30, w16, w29);
      TEST_3RF_3("fmsub.d", datad, 144, 144,  80, w1,  w27, w23);
      TEST_3RF_3("fmsub.d", datad, 144, 144,  96, w4,  w18, w5);
      TEST_3RF_3("fmsub.d", datad, 144, 144, 112, w6,  w15, w23);
      TEST_3RF_3("fmsub.d", datad, 144, 144, 128, w5,  w8,  w9);
      TEST_3RF_3("fmsub.d", datad, 144, 144, 144, w28, w25, w9);
      TEST_3RF("ftq.h", dataf,   0,   8, w1,  w31, w24);
      TEST_3RF("ftq.h", dataf,  16,  24, w26, w26, w3);
      TEST_3RF("ftq.h", dataf,  32,  40, w6,  w14, w31);
      TEST_3RF("ftq.h", dataf,  48,  56, w26, w26, w16);
      TEST_3RF("ftq.h", dataf,  64,  72, w23, w5,  w0);
      TEST_3RF("ftq.h", dataf,  16,  24, w26, w27, w3);
      TEST_3RF("ftq.h", dataf,  32,  40, w14,  w14, w31);
      TEST_3RF("ftq.h", dataf,  48,  56, w26, w26, w26);
      TEST_3RF("ftq.h", dataf,  64,  72, w23, w5,  w5);
      TEST_3RF("ftq.w", datad,   0,  16, w29, w17, w22);
      TEST_3RF("ftq.w", datad,  32,  48, w20, w17, w17);
      TEST_3RF("ftq.w", datad,  64,  80, w7,  w2,  w5);
      TEST_3RF("ftq.w", datad,  96, 112, w12, w6,  w12);
      TEST_3RF("ftq.w", datad, 128, 144, w2,  w9,  w31);
      TEST_3RF("ftq.w", datad,  32,  48, w17, w17, w17);
      TEST_3RF("ftq.w", datad,  64,  80, w5,  w2,  w5);
      TEST_3RF("ftq.w", datad,  96, 112, w12, w6,  w13);
      TEST_3RF("ftq.w", datad, 128, 144, w2,  w2,  w31);
      TEST_3RF("fexdo.h", dataf,   0,   8, w22, w27, w27);
      TEST_3RF("fexdo.h", dataf,  16,  24, w21, w15, w22);
      TEST_3RF("fexdo.h", dataf,  32,  40, w24, w21, w4);
      TEST_3RF("fexdo.h", dataf,  48,  56, w23, w16, w21);
      TEST_3RF("fexdo.h", dataf,  64,  72, w14, w21, w12);
      TEST_3RF("fexdo.h", dataf,  16,  24, w22, w22, w22);
      TEST_3RF("fexdo.h", dataf,  32,  40, w24, w21, w24);
      TEST_3RF("fexdo.h", dataf,  48,  56, w23, w23, w21);
      TEST_3RF("fexdo.h", dataf,  64,  8, w14, w21, w12);
      TEST_3RF("fexdo.w", datad,   0,  16, w7,  w12, w0);
      TEST_3RF("fexdo.w", datad,  32,  48, w24, w19, w2);
      TEST_3RF("fexdo.w", datad,  64,  80, w29, w31, w9);
      TEST_3RF("fexdo.w", datad,  96, 112, w31, w8,  w10);
      TEST_3RF("fexdo.w", datad, 128, 144, w2,  w2,  w30);
      TEST_3RF("fexdo.w", datad,  32,  48, w2, w2, w2);
      TEST_3RF("fexdo.w", datad,  64,  80, w9, w31, w9);
      TEST_3RF("fexdo.w", datad,  96, 112, w31, w10,  w10);
      TEST_3RF("fexdo.w", datad, 128, 144, w2,  w1,  w30);
      TEST_2RF("ffint_s.w",  dataf,   0, w0,  w2);
      TEST_2RF("ffint_s.w",  dataf,   8, w1,  w26);
      TEST_2RF("ffint_s.w",  dataf,  16, w2,  w31);
      TEST_2RF("ffint_s.w",  dataf,  24, w3,  w18);
      TEST_2RF("ffint_s.w",  dataf,  32, w4,  w24);
      TEST_2RF("ffint_s.w",  dataf,  40, w5,  w9);
      TEST_2RF("ffint_s.w",  dataf,  48, w6,  w20);
      TEST_2RF("ffint_s.w",  dataf,  56, w7,  w5);
      TEST_2RF("ffint_s.w",  dataf,  64, w8,  w1);
      TEST_2RF("ffint_s.w",  dataf,  72, w9,  w13);
      TEST_2RF("ffint_s.w",  dataf,   0, w10, w17);
      TEST_2RF("ffint_s.w",  dataf,   8, w11, w5);
      TEST_2RF("ffint_s.w",  dataf,  16, w12, w4);
      TEST_2RF("ffint_s.w",  dataf,  24, w13, w13);
      TEST_2RF("ffint_s.w",  dataf,  32, w14, w12);
      TEST_2RF("ffint_s.w",  dataf,  40, w15, w4);
      TEST_2RF("ffint_s.w",  dataf,  48, w16, w8);
      TEST_2RF("ffint_s.w",  dataf,  56, w17, w17);
      TEST_2RF("ffint_s.w",  dataf,  64, w18, w7);
      TEST_2RF("ffint_s.w",  dataf,  72, w19, w25);
      TEST_2RF("ffint_s.w",  dataf,   0, w20, w11);
      TEST_2RF("ffint_s.w",  dataf,   8, w21, w11);
      TEST_2RF("ffint_s.w",  dataf,  16, w22, w26);
      TEST_2RF("ffint_s.w",  dataf,  24, w23, w30);
      TEST_2RF("ffint_s.w",  dataf,  32, w24, w15);
      TEST_2RF("ffint_s.w",  dataf,  40, w25, w1);
      TEST_2RF("ffint_s.w",  dataf,  48, w26, w18);
      TEST_2RF("ffint_s.w",  dataf,  56, w27, w18);
      TEST_2RF("ffint_s.w",  dataf,  64, w28, w23);
      TEST_2RF("ffint_s.w",  dataf,  72, w29, w8);
      TEST_2RF("ffint_s.w",  dataf,   0, w30, w26);
      TEST_2RF("ffint_s.w",  dataf,   8, w31, w14);
      TEST_2RF("ffint_s.d",  datad,   0, w0,  w21);
      TEST_2RF("ffint_s.d",  datad,  16, w1,  w28);
      TEST_2RF("ffint_s.d",  datad,  32, w2,  w22);
      TEST_2RF("ffint_s.d",  datad,  48, w3,  w21);
      TEST_2RF("ffint_s.d",  datad,  64, w4,  w31);
      TEST_2RF("ffint_s.d",  datad,  80, w5,  w3);
      TEST_2RF("ffint_s.d",  datad,  96, w6,  w22);
      TEST_2RF("ffint_s.d",  datad, 112, w7,  w23);
      TEST_2RF("ffint_s.d",  datad, 128, w8,  w3);
      TEST_2RF("ffint_s.d",  datad, 144, w9,  w25);
      TEST_2RF("ffint_s.d",  datad,   0, w10, w9);
      TEST_2RF("ffint_s.d",  datad,  16, w11, w3);
      TEST_2RF("ffint_s.d",  datad,  32, w12, w25);
      TEST_2RF("ffint_s.d",  datad,  48, w13, w13);
      TEST_2RF("ffint_s.d",  datad,  64, w14, w11);
      TEST_2RF("ffint_s.d",  datad,  80, w15, w25);
      TEST_2RF("ffint_s.d",  datad,  96, w16, w14);
      TEST_2RF("ffint_s.d",  datad, 112, w17, w17);
      TEST_2RF("ffint_s.d",  datad, 128, w18, w11);
      TEST_2RF("ffint_s.d",  datad, 144, w19, w10);
      TEST_2RF("ffint_s.d",  datad,   0, w20, w21);
      TEST_2RF("ffint_s.d",  datad,  16, w21, w28);
      TEST_2RF("ffint_s.d",  datad,  32, w22, w2);
      TEST_2RF("ffint_s.d",  datad,  48, w23, w12);
      TEST_2RF("ffint_s.d",  datad,  64, w24, w10);
      TEST_2RF("ffint_s.d",  datad,  80, w25, w17);
      TEST_2RF("ffint_s.d",  datad,  96, w26, w14);
      TEST_2RF("ffint_s.d",  datad, 112, w27, w15);
      TEST_2RF("ffint_s.d",  datad, 128, w28, w9);
      TEST_2RF("ffint_s.d",  datad, 144, w29, w7);
      TEST_2RF("ffint_s.d",  datad,   0, w30, w22);
      TEST_2RF("ffint_s.d",  datad,  16, w31, w16);
      TEST_2RF("ffint_u.w",  dataf,   0, w0,  w25);
      TEST_2RF("ffint_u.w",  dataf,   8, w1,  w19);
      TEST_2RF("ffint_u.w",  dataf,  16, w2,  w30);
      TEST_2RF("ffint_u.w",  dataf,  24, w3,  w22);
      TEST_2RF("ffint_u.w",  dataf,  32, w4,  w14);
      TEST_2RF("ffint_u.w",  dataf,  40, w5,  w12);
      TEST_2RF("ffint_u.w",  dataf,  48, w6,  w6);
      TEST_2RF("ffint_u.w",  dataf,  56, w7,  w28);
      TEST_2RF("ffint_u.w",  dataf,  64, w8,  w27);
      TEST_2RF("ffint_u.w",  dataf,  72, w9,  w30);
      TEST_2RF("ffint_u.w",  dataf,   0, w10, w12);
      TEST_2RF("ffint_u.w",  dataf,   8, w11, w1);
      TEST_2RF("ffint_u.w",  dataf,  16, w12, w5);
      TEST_2RF("ffint_u.w",  dataf,  24, w13, w7);
      TEST_2RF("ffint_u.w",  dataf,  32, w14, w23);
      TEST_2RF("ffint_u.w",  dataf,  40, w15, w7);
      TEST_2RF("ffint_u.w",  dataf,  48, w16, w16);
      TEST_2RF("ffint_u.w",  dataf,  56, w17, w1);
      TEST_2RF("ffint_u.w",  dataf,  64, w18, w31);
      TEST_2RF("ffint_u.w",  dataf,  72, w19, w30);
      TEST_2RF("ffint_u.w",  dataf,   0, w20, w12);
      TEST_2RF("ffint_u.w",  dataf,   8, w21, w7);
      TEST_2RF("ffint_u.w",  dataf,  16, w22, w29);
      TEST_2RF("ffint_u.w",  dataf,  24, w23, w27);
      TEST_2RF("ffint_u.w",  dataf,  32, w24, w3);
      TEST_2RF("ffint_u.w",  dataf,  40, w25, w8);
      TEST_2RF("ffint_u.w",  dataf,  48, w26, w6);
      TEST_2RF("ffint_u.w",  dataf,  56, w27, w26);
      TEST_2RF("ffint_u.w",  dataf,  64, w28, w19);
      TEST_2RF("ffint_u.w",  dataf,  72, w29, w5);
      TEST_2RF("ffint_u.w",  dataf,   0, w30, w13);
      TEST_2RF("ffint_u.w",  dataf,   8, w31, w26);
      TEST_2RF("ffint_u.d",  datad,   0, w0,  w17);
      TEST_2RF("ffint_u.d",  datad,  16, w1,  w20);
      TEST_2RF("ffint_u.d",  datad,  32, w2,  w10);
      TEST_2RF("ffint_u.d",  datad,  48, w3,  w28);
      TEST_2RF("ffint_u.d",  datad,  64, w4,  w23);
      TEST_2RF("ffint_u.d",  datad,  80, w5,  w1);
      TEST_2RF("ffint_u.d",  datad,  96, w6,  w6);
      TEST_2RF("ffint_u.d",  datad, 112, w7,  w26);
      TEST_2RF("ffint_u.d",  datad, 128, w8,  w29);
      TEST_2RF("ffint_u.d",  datad, 144, w9,  w0);
      TEST_2RF("ffint_u.d",  datad,   0, w10, w6);
      TEST_2RF("ffint_u.d",  datad,  16, w11, w4);
      TEST_2RF("ffint_u.d",  datad,  32, w12, w24);
      TEST_2RF("ffint_u.d",  datad,  48, w13, w25);
      TEST_2RF("ffint_u.d",  datad,  64, w14, w15);
      TEST_2RF("ffint_u.d",  datad,  80, w15, w9);
      TEST_2RF("ffint_u.d",  datad,  96, w16, w16);
      TEST_2RF("ffint_u.d",  datad, 112, w17, w0);
      TEST_2RF("ffint_u.d",  datad, 128, w18, w17);
      TEST_2RF("ffint_u.d",  datad, 144, w19, w12);
      TEST_2RF("ffint_u.d",  datad,   0, w20, w14);
      TEST_2RF("ffint_u.d",  datad,  16, w21, w19);
      TEST_2RF("ffint_u.d",  datad,  32, w22, w30);
      TEST_2RF("ffint_u.d",  datad,  48, w23, w13);
      TEST_2RF("ffint_u.d",  datad,  64, w24, w16);
      TEST_2RF("ffint_u.d",  datad,  80, w25, w10);
      TEST_2RF("ffint_u.d",  datad,  96, w26, w15);
      TEST_2RF("ffint_u.d",  datad, 112, w27, w15);
      TEST_2RF("ffint_u.d",  datad, 128, w28, w7);
      TEST_2RF("ffint_u.d",  datad, 144, w29, w4);
      TEST_2RF("ffint_u.d",  datad,   0, w30, w20);
      TEST_2RF("ffint_u.d",  datad,  16, w31, w20);
      TEST_2RF("flog2.w",  dataf,   0, w0,  w7);
      TEST_2RF("flog2.w",  dataf,   8, w1,  w20);
      TEST_2RF("flog2.w",  dataf,  16, w2,  w29);
      TEST_2RF("flog2.w",  dataf,  24, w3,  w5);
      TEST_2RF("flog2.w",  dataf,  32, w4,  w23);
      TEST_2RF("flog2.w",  dataf,  40, w5,  w27);
      TEST_2RF("flog2.w",  dataf,  48, w6,  w29);
      TEST_2RF("flog2.w",  dataf,  56, w7,  w5);
      TEST_2RF("flog2.w",  dataf,  64, w8,  w13);
      TEST_2RF("flog2.w",  dataf,  72, w9,  w20);
      TEST_2RF("flog2.w",  dataf,   0, w10, w13);
      TEST_2RF("flog2.w",  dataf,   8, w11, w13);
      TEST_2RF("flog2.w",  dataf,  16, w12, w14);
      TEST_2RF("flog2.w",  dataf,  24, w13, w9);
      TEST_2RF("flog2.w",  dataf,  32, w14, w3);
      TEST_2RF("flog2.w",  dataf,  40, w15, w22);
      TEST_2RF("flog2.w",  dataf,  48, w16, w14);
      TEST_2RF("flog2.w",  dataf,  56, w17, w4);
      TEST_2RF("flog2.w",  dataf,  64, w18, w5);
      TEST_2RF("flog2.w",  dataf,  72, w19, w8);
      TEST_2RF("flog2.w",  dataf,   0, w20, w28);
      TEST_2RF("flog2.w",  dataf,   8, w21, w21);
      TEST_2RF("flog2.w",  dataf,  16, w22, w3);
      TEST_2RF("flog2.w",  dataf,  24, w23, w8);
      TEST_2RF("flog2.w",  dataf,  32, w24, w6);
      TEST_2RF("flog2.w",  dataf,  40, w25, w11);
      TEST_2RF("flog2.w",  dataf,  48, w26, w22);
      TEST_2RF("flog2.w",  dataf,  56, w27, w20);
      TEST_2RF("flog2.w",  dataf,  64, w28, w16);
      TEST_2RF("flog2.w",  dataf,  72, w29, w29);
      TEST_2RF("flog2.w",  dataf,   0, w30, w25);
      TEST_2RF("flog2.w",  dataf,   8, w31, w22);
      TEST_2RF("flog2.d",  datad,   0, w0,  w16);
      TEST_2RF("flog2.d",  datad,  16, w1,  w0);
      TEST_2RF("flog2.d",  datad,  32, w2,  w8);
      TEST_2RF("flog2.d",  datad,  48, w3,  w19);
      TEST_2RF("flog2.d",  datad,  64, w4,  w21);
      TEST_2RF("flog2.d",  datad,  80, w5,  w14);
      TEST_2RF("flog2.d",  datad,  96, w6,  w18);
      TEST_2RF("flog2.d",  datad, 112, w7,  w0);
      TEST_2RF("flog2.d",  datad, 128, w8,  w14);
      TEST_2RF("flog2.d",  datad, 144, w9,  w0);
      TEST_2RF("flog2.d",  datad,   0, w10, w25);
      TEST_2RF("flog2.d",  datad,  16, w11, w24);
      TEST_2RF("flog2.d",  datad,  32, w12, w0);
      TEST_2RF("flog2.d",  datad,  48, w13, w3);
      TEST_2RF("flog2.d",  datad,  64, w14, w6);
      TEST_2RF("flog2.d",  datad,  80, w15, w19);
      TEST_2RF("flog2.d",  datad,  96, w16, w1);
      TEST_2RF("flog2.d",  datad, 112, w17, w4);
      TEST_2RF("flog2.d",  datad, 128, w18, w0);
      TEST_2RF("flog2.d",  datad, 144, w19, w27);
      TEST_2RF("flog2.d",  datad,   0, w20, w6);
      TEST_2RF("flog2.d",  datad,  16, w21, w21);
      TEST_2RF("flog2.d",  datad,  32, w22, w13);
      TEST_2RF("flog2.d",  datad,  48, w23, w17);
      TEST_2RF("flog2.d",  datad,  64, w24, w13);
      TEST_2RF("flog2.d",  datad,  80, w25, w11);
      TEST_2RF("flog2.d",  datad,  96, w26, w8);
      TEST_2RF("flog2.d",  datad, 112, w27, w6);
      TEST_2RF("flog2.d",  datad, 128, w28, w23);
      TEST_2RF("flog2.d",  datad, 144, w29, w29);
      TEST_2RF("flog2.d",  datad,   0, w30, w29);
      TEST_2RF("flog2.d",  datad,  16, w31, w11);
      TEST_2RF("frint.w",  dataf,   0, w0,  w4);
      TEST_2RF("frint.w",  dataf,   8, w1,  w1);
      TEST_2RF("frint.w",  dataf,  16, w2,  w28);
      TEST_2RF("frint.w",  dataf,  24, w3,  w13);
      TEST_2RF("frint.w",  dataf,  32, w4,  w9);
      TEST_2RF("frint.w",  dataf,  40, w5,  w27);
      TEST_2RF("frint.w",  dataf,  48, w6,  w26);
      TEST_2RF("frint.w",  dataf,  56, w7,  w8);
      TEST_2RF("frint.w",  dataf,  64, w8,  w19);
      TEST_2RF("frint.w",  dataf,  72, w9,  w1);
      TEST_2RF("frint.w",  dataf,   0, w10, w27);
      TEST_2RF("frint.w",  dataf,   8, w11, w9);
      TEST_2RF("frint.w",  dataf,  16, w12, w6);
      TEST_2RF("frint.w",  dataf,  24, w13, w24);
      TEST_2RF("frint.w",  dataf,  32, w14, w2);
      TEST_2RF("frint.w",  dataf,  40, w15, w27);
      TEST_2RF("frint.w",  dataf,  48, w16, w0);
      TEST_2RF("frint.w",  dataf,  56, w17, w27);
      TEST_2RF("frint.w",  dataf,  64, w18, w1);
      TEST_2RF("frint.w",  dataf,  72, w19, w9);
      TEST_2RF("frint.w",  dataf,   0, w20, w25);
      TEST_2RF("frint.w",  dataf,   8, w21, w3);
      TEST_2RF("frint.w",  dataf,  16, w22, w29);
      TEST_2RF("frint.w",  dataf,  24, w23, w8);
      TEST_2RF("frint.w",  dataf,  32, w24, w6);
      TEST_2RF("frint.w",  dataf,  40, w25, w17);
      TEST_2RF("frint.w",  dataf,  48, w26, w18);
      TEST_2RF("frint.w",  dataf,  56, w27, w27);
      TEST_2RF("frint.w",  dataf,  64, w28, w10);
      TEST_2RF("frint.w",  dataf,  72, w29, w27);
      TEST_2RF("frint.w",  dataf,   0, w30, w20);
      TEST_2RF("frint.w",  dataf,   8, w31, w3);
      TEST_2RF("frint.d",  datad,   0, w0,  w9);
      TEST_2RF("frint.d",  datad,  16, w1,  w1);
      TEST_2RF("frint.d",  datad,  32, w2,  w20);
      TEST_2RF("frint.d",  datad,  48, w3,  w28);
      TEST_2RF("frint.d",  datad,  64, w4,  w6);
      TEST_2RF("frint.d",  datad,  80, w5,  w1);
      TEST_2RF("frint.d",  datad,  96, w6,  w9);
      TEST_2RF("frint.d",  datad, 112, w7,  w31);
      TEST_2RF("frint.d",  datad, 128, w8,  w12);
      TEST_2RF("frint.d",  datad, 144, w9,  w8);
      TEST_2RF("frint.d",  datad,   0, w10, w4);
      TEST_2RF("frint.d",  datad,  16, w11, w25);
      TEST_2RF("frint.d",  datad,  32, w12, w18);
      TEST_2RF("frint.d",  datad,  48, w13, w1);
      TEST_2RF("frint.d",  datad,  64, w14, w12);
      TEST_2RF("frint.d",  datad,  80, w15, w30);
      TEST_2RF("frint.d",  datad,  96, w16, w8);
      TEST_2RF("frint.d",  datad, 112, w17, w12);
      TEST_2RF("frint.d",  datad, 128, w18, w6);
      TEST_2RF("frint.d",  datad, 144, w19, w3);
      TEST_2RF("frint.d",  datad,   0, w20, w28);
      TEST_2RF("frint.d",  datad,  16, w21, w5);
      TEST_2RF("frint.d",  datad,  32, w22, w15);
      TEST_2RF("frint.d",  datad,  48, w23, w6);
      TEST_2RF("frint.d",  datad,  64, w24, w2);
      TEST_2RF("frint.d",  datad,  80, w25, w14);
      TEST_2RF("frint.d",  datad,  96, w26, w8);
      TEST_2RF("frint.d",  datad, 112, w27, w27);
      TEST_2RF("frint.d",  datad, 128, w28, w26);
      TEST_2RF("frint.d",  datad, 144, w29, w30);
      TEST_2RF("frint.d",  datad,   0, w30, w16);
      TEST_2RF("frint.d",  datad,  16, w31, w3);
      TEST_2RF("frcp.w",  dataf,   0, w0,  w21);
      TEST_2RF("frcp.w",  dataf,   8, w1,  w0);
      TEST_2RF("frcp.w",  dataf,  16, w2,  w13);
      TEST_2RF("frcp.w",  dataf,  24, w3,  w23);
      TEST_2RF("frcp.w",  dataf,  32, w4,  w10);
      TEST_2RF("frcp.w",  dataf,  40, w5,  w23);
      TEST_2RF("frcp.w",  dataf,  48, w6,  w12);
      TEST_2RF("frcp.w",  dataf,  56, w7,  w19);
      TEST_2RF("frcp.w",  dataf,  64, w8,  w2);
      TEST_2RF("frcp.w",  dataf,  72, w9,  w15);
      TEST_2RF("frcp.w",  dataf,   0, w10, w14);
      TEST_2RF("frcp.w",  dataf,   8, w11, w22);
      TEST_2RF("frcp.w",  dataf,  16, w12, w23);
      TEST_2RF("frcp.w",  dataf,  24, w13, w28);
      TEST_2RF("frcp.w",  dataf,  32, w14, w10);
      TEST_2RF("frcp.w",  dataf,  40, w15, w2);
      TEST_2RF("frcp.w",  dataf,  48, w16, w13);
      TEST_2RF("frcp.w",  dataf,  56, w17, w16);
      TEST_2RF("frcp.w",  dataf,  64, w18, w5);
      TEST_2RF("frcp.w",  dataf,  72, w19, w27);
      TEST_2RF("frcp.w",  dataf,   0, w20, w3);
      TEST_2RF("frcp.w",  dataf,   8, w21, w14);
      TEST_2RF("frcp.w",  dataf,  16, w22, w22);
      TEST_2RF("frcp.w",  dataf,  24, w23, w27);
      TEST_2RF("frcp.w",  dataf,  32, w24, w22);
      TEST_2RF("frcp.w",  dataf,  40, w25, w18);
      TEST_2RF("frcp.w",  dataf,  48, w26, w6);
      TEST_2RF("frcp.w",  dataf,  56, w27, w12);
      TEST_2RF("frcp.w",  dataf,  64, w28, w26);
      TEST_2RF("frcp.w",  dataf,  72, w29, w8);
      TEST_2RF("frcp.w",  dataf,   0, w30, w30);
      TEST_2RF("frcp.w",  dataf,   8, w31, w22);
      TEST_2RF("frcp.d",  datad,   0, w0,  w29);
      TEST_2RF("frcp.d",  datad,  16, w1,  w31);
      TEST_2RF("frcp.d",  datad,  32, w2,  w8);
      TEST_2RF("frcp.d",  datad,  48, w3,  w16);
      TEST_2RF("frcp.d",  datad,  64, w4,  w11);
      TEST_2RF("frcp.d",  datad,  80, w5,  w23);
      TEST_2RF("frcp.d",  datad,  96, w6,  w1);
      TEST_2RF("frcp.d",  datad, 112, w7,  w14);
      TEST_2RF("frcp.d",  datad, 128, w8,  w0);
      TEST_2RF("frcp.d",  datad, 144, w9,  w22);
      TEST_2RF("frcp.d",  datad,   0, w10, w21);
      TEST_2RF("frcp.d",  datad,  16, w11, w14);
      TEST_2RF("frcp.d",  datad,  32, w12, w25);
      TEST_2RF("frcp.d",  datad,  48, w13, w9);
      TEST_2RF("frcp.d",  datad,  64, w14, w10);
      TEST_2RF("frcp.d",  datad,  80, w15, w25);
      TEST_2RF("frcp.d",  datad,  96, w16, w25);
      TEST_2RF("frcp.d",  datad, 112, w17, w1);
      TEST_2RF("frcp.d",  datad, 128, w18, w9);
      TEST_2RF("frcp.d",  datad, 144, w19, w21);
      TEST_2RF("frcp.d",  datad,   0, w20, w21);
      TEST_2RF("frcp.d",  datad,  16, w21, w7);
      TEST_2RF("frcp.d",  datad,  32, w22, w22);
      TEST_2RF("frcp.d",  datad,  48, w23, w21);
      TEST_2RF("frcp.d",  datad,  64, w24, w23);
      TEST_2RF("frcp.d",  datad,  80, w25, w16);
      TEST_2RF("frcp.d",  datad,  96, w26, w5);
      TEST_2RF("frcp.d",  datad, 112, w27, w2);
      TEST_2RF("frcp.d",  datad, 128, w28, w6);
      TEST_2RF("frcp.d",  datad, 144, w29, w11);
      TEST_2RF("frcp.d",  datad,   0, w30, w30);
      TEST_2RF("frcp.d",  datad,  16, w31, w22);
      TEST_2RF("frsqrt.w",  dataf,   0, w0,  w10);
      TEST_2RF("frsqrt.w",  dataf,   8, w1,  w20);
      TEST_2RF("frsqrt.w",  dataf,  16, w2,  w26);
      TEST_2RF("frsqrt.w",  dataf,  24, w3,  w12);
      TEST_2RF("frsqrt.w",  dataf,  32, w4,  w0);
      TEST_2RF("frsqrt.w",  dataf,  40, w5,  w22);
      TEST_2RF("frsqrt.w",  dataf,  48, w6,  w26);
      TEST_2RF("frsqrt.w",  dataf,  56, w7,  w14);
      TEST_2RF("frsqrt.w",  dataf,  64, w8,  w8);
      TEST_2RF("frsqrt.w",  dataf,  72, w9,  w17);
      TEST_2RF("frsqrt.w",  dataf,   0, w10, w28);
      TEST_2RF("frsqrt.w",  dataf,   8, w11, w8);
      TEST_2RF("frsqrt.w",  dataf,  16, w12, w16);
      TEST_2RF("frsqrt.w",  dataf,  24, w13, w9);
      TEST_2RF("frsqrt.w",  dataf,  32, w14, w3);
      TEST_2RF("frsqrt.w",  dataf,  40, w15, w21);
      TEST_2RF("frsqrt.w",  dataf,  48, w16, w9);
      TEST_2RF("frsqrt.w",  dataf,  56, w17, w14);
      TEST_2RF("frsqrt.w",  dataf,  64, w18, w10);
      TEST_2RF("frsqrt.w",  dataf,  72, w19, w17);
      TEST_2RF("frsqrt.w",  dataf,   0, w20, w25);
      TEST_2RF("frsqrt.w",  dataf,   8, w21, w7);
      TEST_2RF("frsqrt.w",  dataf,  16, w22, w26);
      TEST_2RF("frsqrt.w",  dataf,  24, w23, w28);
      TEST_2RF("frsqrt.w",  dataf,  32, w24, w4);
      TEST_2RF("frsqrt.w",  dataf,  40, w25, w8);
      TEST_2RF("frsqrt.w",  dataf,  48, w26, w1);
      TEST_2RF("frsqrt.w",  dataf,  56, w27, w13);
      TEST_2RF("frsqrt.w",  dataf,  64, w28, w14);
      TEST_2RF("frsqrt.w",  dataf,  72, w29, w12);
      TEST_2RF("frsqrt.w",  dataf,   0, w30, w30);
      TEST_2RF("frsqrt.w",  dataf,   8, w31, w17);
      TEST_2RF("frsqrt.d",  datad,   0, w0,  w2);
      TEST_2RF("frsqrt.d",  datad,  16, w1,  w14);
      TEST_2RF("frsqrt.d",  datad,  32, w2,  w24);
      TEST_2RF("frsqrt.d",  datad,  48, w3,  w20);
      TEST_2RF("frsqrt.d",  datad,  64, w4,  w25);
      TEST_2RF("frsqrt.d",  datad,  80, w5,  w0);
      TEST_2RF("frsqrt.d",  datad,  96, w6,  w26);
      TEST_2RF("frsqrt.d",  datad, 112, w7,  w26);
      TEST_2RF("frsqrt.d",  datad, 128, w8,  w8);
      TEST_2RF("frsqrt.d",  datad, 144, w9,  w19);
      TEST_2RF("frsqrt.d",  datad,   0, w10, w27);
      TEST_2RF("frsqrt.d",  datad,  16, w11, w8);
      TEST_2RF("frsqrt.d",  datad,  32, w12, w2);
      TEST_2RF("frsqrt.d",  datad,  48, w13, w31);
      TEST_2RF("frsqrt.d",  datad,  64, w14, w0);
      TEST_2RF("frsqrt.d",  datad,  80, w15, w30);
      TEST_2RF("frsqrt.d",  datad,  96, w16, w5);
      TEST_2RF("frsqrt.d",  datad, 112, w17, w3);
      TEST_2RF("frsqrt.d",  datad, 128, w18, w7);
      TEST_2RF("frsqrt.d",  datad, 144, w19, w3);
      TEST_2RF("frsqrt.d",  datad,   0, w20, w30);
      TEST_2RF("frsqrt.d",  datad,  16, w21, w27);
      TEST_2RF("frsqrt.d",  datad,  32, w22, w26);
      TEST_2RF("frsqrt.d",  datad,  48, w23, w20);
      TEST_2RF("frsqrt.d",  datad,  64, w24, w7);
      TEST_2RF("frsqrt.d",  datad,  80, w25, w10);
      TEST_2RF("frsqrt.d",  datad,  96, w26, w29);
      TEST_2RF("frsqrt.d",  datad, 112, w27, w20);
      TEST_2RF("frsqrt.d",  datad, 128, w28, w6);
      TEST_2RF("frsqrt.d",  datad, 144, w29, w24);
      TEST_2RF("frsqrt.d",  datad,   0, w30, w30);
      TEST_2RF("frsqrt.d",  datad,  16, w31, w6);
      TEST_2RF("fsqrt.w",  dataf,   0, w0,  w17);
      TEST_2RF("fsqrt.w",  dataf,   8, w1,  w14);
      TEST_2RF("fsqrt.w",  dataf,  16, w2,  w8);
      TEST_2RF("fsqrt.w",  dataf,  24, w3,  w8);
      TEST_2RF("fsqrt.w",  dataf,  32, w4,  w5);
      TEST_2RF("fsqrt.w",  dataf,  40, w5,  w30);
      TEST_2RF("fsqrt.w",  dataf,  48, w6,  w25);
      TEST_2RF("fsqrt.w",  dataf,  56, w7,  w31);
      TEST_2RF("fsqrt.w",  dataf,  64, w8,  w8);
      TEST_2RF("fsqrt.w",  dataf,  72, w9,  w9);
      TEST_2RF("fsqrt.w",  dataf,   0, w10, w2);
      TEST_2RF("fsqrt.w",  dataf,   8, w11, w22);
      TEST_2RF("fsqrt.w",  dataf,  16, w12, w22);
      TEST_2RF("fsqrt.w",  dataf,  24, w13, w28);
      TEST_2RF("fsqrt.w",  dataf,  32, w14, w22);
      TEST_2RF("fsqrt.w",  dataf,  40, w15, w14);
      TEST_2RF("fsqrt.w",  dataf,  48, w16, w10);
      TEST_2RF("fsqrt.w",  dataf,  56, w17, w21);
      TEST_2RF("fsqrt.w",  dataf,  64, w18, w27);
      TEST_2RF("fsqrt.w",  dataf,  72, w19, w21);
      TEST_2RF("fsqrt.w",  dataf,   0, w20, w14);
      TEST_2RF("fsqrt.w",  dataf,   8, w21, w9);
      TEST_2RF("fsqrt.w",  dataf,  16, w22, w27);
      TEST_2RF("fsqrt.w",  dataf,  24, w23, w12);
      TEST_2RF("fsqrt.w",  dataf,  32, w24, w0);
      TEST_2RF("fsqrt.w",  dataf,  40, w25, w2);
      TEST_2RF("fsqrt.w",  dataf,  48, w26, w15);
      TEST_2RF("fsqrt.w",  dataf,  56, w27, w10);
      TEST_2RF("fsqrt.w",  dataf,  64, w28, w1);
      TEST_2RF("fsqrt.w",  dataf,  72, w29, w15);
      TEST_2RF("fsqrt.w",  dataf,   0, w30, w25);
      TEST_2RF("fsqrt.w",  dataf,   8, w31, w0);
      TEST_2RF("fsqrt.d",  datad,   0, w0,  w15);
      TEST_2RF("fsqrt.d",  datad,  16, w1,  w18);
      TEST_2RF("fsqrt.d",  datad,  32, w2,  w30);
      TEST_2RF("fsqrt.d",  datad,  48, w3,  w1);
      TEST_2RF("fsqrt.d",  datad,  64, w4,  w19);
      TEST_2RF("fsqrt.d",  datad,  80, w5,  w28);
      TEST_2RF("fsqrt.d",  datad,  96, w6,  w31);
      TEST_2RF("fsqrt.d",  datad, 112, w7,  w8);
      TEST_2RF("fsqrt.d",  datad, 128, w8,  w8);
      TEST_2RF("fsqrt.d",  datad, 144, w9,  w9);
      TEST_2RF("fsqrt.d",  datad,   0, w10, w26);
      TEST_2RF("fsqrt.d",  datad,  16, w11, w4);
      TEST_2RF("fsqrt.d",  datad,  32, w12, w6);
      TEST_2RF("fsqrt.d",  datad,  48, w13, w5);
      TEST_2RF("fsqrt.d",  datad,  64, w14, w19);
      TEST_2RF("fsqrt.d",  datad,  80, w15, w13);
      TEST_2RF("fsqrt.d",  datad,  96, w16, w20);
      TEST_2RF("fsqrt.d",  datad, 112, w17, w10);
      TEST_2RF("fsqrt.d",  datad, 128, w18, w14);
      TEST_2RF("fsqrt.d",  datad, 144, w19, w14);
      TEST_2RF("fsqrt.d",  datad,   0, w20, w1);
      TEST_2RF("fsqrt.d",  datad,  16, w21, w29);
      TEST_2RF("fsqrt.d",  datad,  32, w22, w30);
      TEST_2RF("fsqrt.d",  datad,  48, w23, w14);
      TEST_2RF("fsqrt.d",  datad,  64, w24, w16);
      TEST_2RF("fsqrt.d",  datad,  80, w25, w2);
      TEST_2RF("fsqrt.d",  datad,  96, w26, w12);
      TEST_2RF("fsqrt.d",  datad, 112, w27, w22);
      TEST_2RF("fsqrt.d",  datad, 128, w28, w29);
      TEST_2RF("fsqrt.d",  datad, 144, w29, w6);
      TEST_2RF("fsqrt.d",  datad,   0, w30, w4);
      TEST_2RF("fsqrt.d",  datad,  16, w31, w6);
      TEST_2RF("ftint_s.w",  dataf,   0, w0,  w13);
      TEST_2RF("ftint_s.w",  dataf,   8, w1,  w3);
      TEST_2RF("ftint_s.w",  dataf,  16, w2,  w7);
      TEST_2RF("ftint_s.w",  dataf,  24, w3,  w4);
      TEST_2RF("ftint_s.w",  dataf,  32, w4,  w13);
      TEST_2RF("ftint_s.w",  dataf,  40, w5,  w0);
      TEST_2RF("ftint_s.w",  dataf,  48, w6,  w26);
      TEST_2RF("ftint_s.w",  dataf,  56, w7,  w15);
      TEST_2RF("ftint_s.w",  dataf,  64, w8,  w11);
      TEST_2RF("ftint_s.w",  dataf,  72, w9,  w24);
      TEST_2RF("ftint_s.w",  dataf,   0, w10, w16);
      TEST_2RF("ftint_s.w",  dataf,   8, w11, w18);
      TEST_2RF("ftint_s.w",  dataf,  16, w12, w24);
      TEST_2RF("ftint_s.w",  dataf,  24, w13, w3);
      TEST_2RF("ftint_s.w",  dataf,  32, w14, w13);
      TEST_2RF("ftint_s.w",  dataf,  40, w15, w23);
      TEST_2RF("ftint_s.w",  dataf,  48, w16, w13);
      TEST_2RF("ftint_s.w",  dataf,  56, w17, w19);
      TEST_2RF("ftint_s.w",  dataf,  64, w18, w9);
      TEST_2RF("ftint_s.w",  dataf,  72, w19, w30);
      TEST_2RF("ftint_s.w",  dataf,   0, w20, w20);
      TEST_2RF("ftint_s.w",  dataf,   8, w21, w9);
      TEST_2RF("ftint_s.w",  dataf,  16, w22, w19);
      TEST_2RF("ftint_s.w",  dataf,  24, w23, w3);
      TEST_2RF("ftint_s.w",  dataf,  32, w24, w3);
      TEST_2RF("ftint_s.w",  dataf,  40, w25, w11);
      TEST_2RF("ftint_s.w",  dataf,  48, w26, w2);
      TEST_2RF("ftint_s.w",  dataf,  56, w27, w25);
      TEST_2RF("ftint_s.w",  dataf,  64, w28, w6);
      TEST_2RF("ftint_s.w",  dataf,  72, w29, w29);
      TEST_2RF("ftint_s.w",  dataf,   0, w30, w31);
      TEST_2RF("ftint_s.w",  dataf,   8, w31, w27);
      TEST_2RF("ftint_s.d",  datad,   0, w0,  w16);
      TEST_2RF("ftint_s.d",  datad,  16, w1,  w28);
      TEST_2RF("ftint_s.d",  datad,  32, w2,  w20);
      TEST_2RF("ftint_s.d",  datad,  48, w3,  w16);
      TEST_2RF("ftint_s.d",  datad,  64, w4,  w30);
      TEST_2RF("ftint_s.d",  datad,  80, w5,  w2);
      TEST_2RF("ftint_s.d",  datad,  96, w6,  w17);
      TEST_2RF("ftint_s.d",  datad, 112, w7,  w8);
      TEST_2RF("ftint_s.d",  datad, 128, w8,  w0);
      TEST_2RF("ftint_s.d",  datad, 144, w9,  w30);
      TEST_2RF("ftint_s.d",  datad,   0, w10, w20);
      TEST_2RF("ftint_s.d",  datad,  16, w11, w31);
      TEST_2RF("ftint_s.d",  datad,  32, w12, w2);
      TEST_2RF("ftint_s.d",  datad,  48, w13, w26);
      TEST_2RF("ftint_s.d",  datad,  64, w14, w4);
      TEST_2RF("ftint_s.d",  datad,  80, w15, w22);
      TEST_2RF("ftint_s.d",  datad,  96, w16, w27);
      TEST_2RF("ftint_s.d",  datad, 112, w17, w13);
      TEST_2RF("ftint_s.d",  datad, 128, w18, w29);
      TEST_2RF("ftint_s.d",  datad, 144, w19, w5);
      TEST_2RF("ftint_s.d",  datad,   0, w20, w20);
      TEST_2RF("ftint_s.d",  datad,  16, w21, w16);
      TEST_2RF("ftint_s.d",  datad,  32, w22, w31);
      TEST_2RF("ftint_s.d",  datad,  48, w23, w24);
      TEST_2RF("ftint_s.d",  datad,  64, w24, w31);
      TEST_2RF("ftint_s.d",  datad,  80, w25, w9);
      TEST_2RF("ftint_s.d",  datad,  96, w26, w23);
      TEST_2RF("ftint_s.d",  datad, 112, w27, w11);
      TEST_2RF("ftint_s.d",  datad, 128, w28, w12);
      TEST_2RF("ftint_s.d",  datad, 144, w29, w29);
      TEST_2RF("ftint_s.d",  datad,   0, w30, w7);
      TEST_2RF("ftint_s.d",  datad,  16, w31, w9);
      TEST_2RF("ftint_u.w",  dataf,   0, w0,  w4);
      TEST_2RF("ftint_u.w",  dataf,   8, w1,  w27);
      TEST_2RF("ftint_u.w",  dataf,  16, w2,  w22);
      TEST_2RF("ftint_u.w",  dataf,  24, w3,  w16);
      TEST_2RF("ftint_u.w",  dataf,  32, w4,  w25);
      TEST_2RF("ftint_u.w",  dataf,  40, w5,  w5);
      TEST_2RF("ftint_u.w",  dataf,  48, w6,  w22);
      TEST_2RF("ftint_u.w",  dataf,  56, w7,  w7);
      TEST_2RF("ftint_u.w",  dataf,  64, w8,  w31);
      TEST_2RF("ftint_u.w",  dataf,  72, w9,  w2);
      TEST_2RF("ftint_u.w",  dataf,   0, w10, w6);
      TEST_2RF("ftint_u.w",  dataf,   8, w11, w31);
      TEST_2RF("ftint_u.w",  dataf,  16, w12, w29);
      TEST_2RF("ftint_u.w",  dataf,  24, w13, w14);
      TEST_2RF("ftint_u.w",  dataf,  32, w14, w26);
      TEST_2RF("ftint_u.w",  dataf,  40, w15, w2);
      TEST_2RF("ftint_u.w",  dataf,  48, w16, w17);
      TEST_2RF("ftint_u.w",  dataf,  56, w17, w31);
      TEST_2RF("ftint_u.w",  dataf,  64, w18, w6);
      TEST_2RF("ftint_u.w",  dataf,  72, w19, w6);
      TEST_2RF("ftint_u.w",  dataf,   0, w20, w22);
      TEST_2RF("ftint_u.w",  dataf,   8, w21, w31);
      TEST_2RF("ftint_u.w",  dataf,  16, w22, w23);
      TEST_2RF("ftint_u.w",  dataf,  24, w23, w27);
      TEST_2RF("ftint_u.w",  dataf,  32, w24, w0);
      TEST_2RF("ftint_u.w",  dataf,  40, w25, w17);
      TEST_2RF("ftint_u.w",  dataf,  48, w26, w10);
      TEST_2RF("ftint_u.w",  dataf,  56, w27, w19);
      TEST_2RF("ftint_u.w",  dataf,  64, w28, w4);
      TEST_2RF("ftint_u.w",  dataf,  72, w29, w25);
      TEST_2RF("ftint_u.w",  dataf,   0, w30, w16);
      TEST_2RF("ftint_u.w",  dataf,   8, w31, w7);
      TEST_2RF("ftint_u.d",  datad,   0, w0,  w22);
      TEST_2RF("ftint_u.d",  datad,  16, w1,  w20);
      TEST_2RF("ftint_u.d",  datad,  32, w2,  w27);
      TEST_2RF("ftint_u.d",  datad,  48, w3,  w19);
      TEST_2RF("ftint_u.d",  datad,  64, w4,  w25);
      TEST_2RF("ftint_u.d",  datad,  80, w5,  w5);
      TEST_2RF("ftint_u.d",  datad,  96, w6,  w19);
      TEST_2RF("ftint_u.d",  datad, 112, w7,  w7);
      TEST_2RF("ftint_u.d",  datad, 128, w8,  w10);
      TEST_2RF("ftint_u.d",  datad, 144, w9,  w7);
      TEST_2RF("ftint_u.d",  datad,   0, w10, w22);
      TEST_2RF("ftint_u.d",  datad,  16, w11, w1);
      TEST_2RF("ftint_u.d",  datad,  32, w12, w14);
      TEST_2RF("ftint_u.d",  datad,  48, w13, w31);
      TEST_2RF("ftint_u.d",  datad,  64, w14, w2);
      TEST_2RF("ftint_u.d",  datad,  80, w15, w9);
      TEST_2RF("ftint_u.d",  datad,  96, w16, w31);
      TEST_2RF("ftint_u.d",  datad, 112, w17, w8);
      TEST_2RF("ftint_u.d",  datad, 128, w18, w5);
      TEST_2RF("ftint_u.d",  datad, 144, w19, w31);
      TEST_2RF("ftint_u.d",  datad,   0, w20, w25);
      TEST_2RF("ftint_u.d",  datad,  16, w21, w24);
      TEST_2RF("ftint_u.d",  datad,  32, w22, w15);
      TEST_2RF("ftint_u.d",  datad,  48, w23, w6);
      TEST_2RF("ftint_u.d",  datad,  64, w24, w21);
      TEST_2RF("ftint_u.d",  datad,  80, w25, w5);
      TEST_2RF("ftint_u.d",  datad,  96, w26, w6);
      TEST_2RF("ftint_u.d",  datad, 112, w27, w20);
      TEST_2RF("ftint_u.d",  datad, 128, w28, w11);
      TEST_2RF("ftint_u.d",  datad, 144, w29, w28);
      TEST_2RF("ftint_u.d",  datad,   0, w30, w16);
      TEST_2RF("ftint_u.d",  datad,  16, w31, w14);
      TEST_2RF("ftrunc_s.w",  dataf,   0, w0,  w3);
      TEST_2RF("ftrunc_s.w",  dataf,   8, w1,  w0);
      TEST_2RF("ftrunc_s.w",  dataf,  16, w2,  w8);
      TEST_2RF("ftrunc_s.w",  dataf,  24, w3,  w12);
      TEST_2RF("ftrunc_s.w",  dataf,  32, w4,  w20);
      TEST_2RF("ftrunc_s.w",  dataf,  40, w5,  w9);
      TEST_2RF("ftrunc_s.w",  dataf,  48, w6,  w23);
      TEST_2RF("ftrunc_s.w",  dataf,  56, w7,  w7);
      TEST_2RF("ftrunc_s.w",  dataf,  64, w8,  w17);
      TEST_2RF("ftrunc_s.w",  dataf,  72, w9,  w21);
      TEST_2RF("ftrunc_s.w",  dataf,   0, w10, w3);
      TEST_2RF("ftrunc_s.w",  dataf,   8, w11, w27);
      TEST_2RF("ftrunc_s.w",  dataf,  16, w12, w8);
      TEST_2RF("ftrunc_s.w",  dataf,  24, w13, w12);
      TEST_2RF("ftrunc_s.w",  dataf,  32, w14, w19);
      TEST_2RF("ftrunc_s.w",  dataf,  40, w15, w3);
      TEST_2RF("ftrunc_s.w",  dataf,  48, w16, w22);
      TEST_2RF("ftrunc_s.w",  dataf,  56, w17, w8);
      TEST_2RF("ftrunc_s.w",  dataf,  64, w18, w9);
      TEST_2RF("ftrunc_s.w",  dataf,  72, w19, w28);
      TEST_2RF("ftrunc_s.w",  dataf,   0, w20, w6);
      TEST_2RF("ftrunc_s.w",  dataf,   8, w21, w23);
      TEST_2RF("ftrunc_s.w",  dataf,  16, w22, w22);
      TEST_2RF("ftrunc_s.w",  dataf,  24, w23, w30);
      TEST_2RF("ftrunc_s.w",  dataf,  32, w24, w6);
      TEST_2RF("ftrunc_s.w",  dataf,  40, w25, w26);
      TEST_2RF("ftrunc_s.w",  dataf,  48, w26, w29);
      TEST_2RF("ftrunc_s.w",  dataf,  56, w27, w24);
      TEST_2RF("ftrunc_s.w",  dataf,  64, w28, w9);
      TEST_2RF("ftrunc_s.w",  dataf,  72, w29, w10);
      TEST_2RF("ftrunc_s.w",  dataf,   0, w30, w25);
      TEST_2RF("ftrunc_s.w",  dataf,   8, w31, w1);
      TEST_2RF("ftrunc_s.d",  datad,   0, w0,  w27);
      TEST_2RF("ftrunc_s.d",  datad,  16, w1,  w5);
      TEST_2RF("ftrunc_s.d",  datad,  32, w2,  w31);
      TEST_2RF("ftrunc_s.d",  datad,  48, w3,  w8);
      TEST_2RF("ftrunc_s.d",  datad,  64, w4,  w0);
      TEST_2RF("ftrunc_s.d",  datad,  80, w5,  w27);
      TEST_2RF("ftrunc_s.d",  datad,  96, w6,  w25);
      TEST_2RF("ftrunc_s.d",  datad, 112, w7,  w7);
      TEST_2RF("ftrunc_s.d",  datad, 128, w8,  w25);
      TEST_2RF("ftrunc_s.d",  datad, 144, w9,  w5);
      TEST_2RF("ftrunc_s.d",  datad,   0, w10, w0);
      TEST_2RF("ftrunc_s.d",  datad,  16, w11, w24);
      TEST_2RF("ftrunc_s.d",  datad,  32, w12, w8);
      TEST_2RF("ftrunc_s.d",  datad,  48, w13, w2);
      TEST_2RF("ftrunc_s.d",  datad,  64, w14, w7);
      TEST_2RF("ftrunc_s.d",  datad,  80, w15, w28);
      TEST_2RF("ftrunc_s.d",  datad,  96, w16, w23);
      TEST_2RF("ftrunc_s.d",  datad, 112, w17, w29);
      TEST_2RF("ftrunc_s.d",  datad, 128, w18, w3);
      TEST_2RF("ftrunc_s.d",  datad, 144, w19, w8);
      TEST_2RF("ftrunc_s.d",  datad,   0, w20, w0);
      TEST_2RF("ftrunc_s.d",  datad,  16, w21, w6);
      TEST_2RF("ftrunc_s.d",  datad,  32, w22, w22);
      TEST_2RF("ftrunc_s.d",  datad,  48, w23, w31);
      TEST_2RF("ftrunc_s.d",  datad,  64, w24, w14);
      TEST_2RF("ftrunc_s.d",  datad,  80, w25, w20);
      TEST_2RF("ftrunc_s.d",  datad,  96, w26, w7);
      TEST_2RF("ftrunc_s.d",  datad, 112, w27, w6);
      TEST_2RF("ftrunc_s.d",  datad, 128, w28, w26);
      TEST_2RF("ftrunc_s.d",  datad, 144, w29, w12);
      TEST_2RF("ftrunc_s.d",  datad,   0, w30, w27);
      TEST_2RF("ftrunc_s.d",  datad,  16, w31, w5);
      TEST_2RF("ftrunc_u.w",  dataf,   0, w0,  w22);
      TEST_2RF("ftrunc_u.w",  dataf,   8, w1,  w19);
      TEST_2RF("ftrunc_u.w",  dataf,  16, w2,  w14);
      TEST_2RF("ftrunc_u.w",  dataf,  24, w3,  w4);
      TEST_2RF("ftrunc_u.w",  dataf,  32, w4,  w19);
      TEST_2RF("ftrunc_u.w",  dataf,  40, w5,  w2);
      TEST_2RF("ftrunc_u.w",  dataf,  48, w6,  w19);
      TEST_2RF("ftrunc_u.w",  dataf,  56, w7,  w26);
      TEST_2RF("ftrunc_u.w",  dataf,  64, w8,  w1);
      TEST_2RF("ftrunc_u.w",  dataf,  72, w9,  w3);
      TEST_2RF("ftrunc_u.w",  dataf,   0, w10, w30);
      TEST_2RF("ftrunc_u.w",  dataf,   8, w11, w3);
      TEST_2RF("ftrunc_u.w",  dataf,  16, w12, w18);
      TEST_2RF("ftrunc_u.w",  dataf,  24, w13, w9);
      TEST_2RF("ftrunc_u.w",  dataf,  32, w14, w23);
      TEST_2RF("ftrunc_u.w",  dataf,  40, w15, w2);
      TEST_2RF("ftrunc_u.w",  dataf,  48, w16, w11);
      TEST_2RF("ftrunc_u.w",  dataf,  56, w17, w16);
      TEST_2RF("ftrunc_u.w",  dataf,  64, w18, w2);
      TEST_2RF("ftrunc_u.w",  dataf,  72, w19, w19);
      TEST_2RF("ftrunc_u.w",  dataf,   0, w20, w14);
      TEST_2RF("ftrunc_u.w",  dataf,   8, w21, w30);
      TEST_2RF("ftrunc_u.w",  dataf,  16, w22, w29);
      TEST_2RF("ftrunc_u.w",  dataf,  24, w23, w28);
      TEST_2RF("ftrunc_u.w",  dataf,  32, w24, w26);
      TEST_2RF("ftrunc_u.w",  dataf,  40, w25, w7);
      TEST_2RF("ftrunc_u.w",  dataf,  48, w26, w7);
      TEST_2RF("ftrunc_u.w",  dataf,  56, w27, w7);
      TEST_2RF("ftrunc_u.w",  dataf,  64, w28, w28);
      TEST_2RF("ftrunc_u.w",  dataf,  72, w29, w8);
      TEST_2RF("ftrunc_u.w",  dataf,   0, w30, w27);
      TEST_2RF("ftrunc_u.w",  dataf,   8, w31, w7);
      TEST_2RF("ftrunc_u.d",  datad,   0, w0,  w31);
      TEST_2RF("ftrunc_u.d",  datad,  16, w1,  w31);
      TEST_2RF("ftrunc_u.d",  datad,  32, w2,  w5);
      TEST_2RF("ftrunc_u.d",  datad,  48, w3,  w9);
      TEST_2RF("ftrunc_u.d",  datad,  64, w4,  w20);
      TEST_2RF("ftrunc_u.d",  datad,  80, w5,  w21);
      TEST_2RF("ftrunc_u.d",  datad,  96, w6,  w26);
      TEST_2RF("ftrunc_u.d",  datad, 112, w7,  w24);
      TEST_2RF("ftrunc_u.d",  datad, 128, w8,  w20);
      TEST_2RF("ftrunc_u.d",  datad, 144, w9,  w13);
      TEST_2RF("ftrunc_u.d",  datad,   0, w10, w7);
      TEST_2RF("ftrunc_u.d",  datad,  16, w11, w1);
      TEST_2RF("ftrunc_u.d",  datad,  32, w12, w29);
      TEST_2RF("ftrunc_u.d",  datad,  48, w13, w24);
      TEST_2RF("ftrunc_u.d",  datad,  64, w14, w20);
      TEST_2RF("ftrunc_u.d",  datad,  80, w15, w17);
      TEST_2RF("ftrunc_u.d",  datad,  96, w16, w27);
      TEST_2RF("ftrunc_u.d",  datad, 112, w17, w27);
      TEST_2RF("ftrunc_u.d",  datad, 128, w18, w3);
      TEST_2RF("ftrunc_u.d",  datad, 144, w19, w19);
      TEST_2RF("ftrunc_u.d",  datad,   0, w20, w23);
      TEST_2RF("ftrunc_u.d",  datad,  16, w21, w29);
      TEST_2RF("ftrunc_u.d",  datad,  32, w22, w27);
      TEST_2RF("ftrunc_u.d",  datad,  48, w23, w11);
      TEST_2RF("ftrunc_u.d",  datad,  64, w24, w8);
      TEST_2RF("ftrunc_u.d",  datad,  80, w25, w9);
      TEST_2RF("ftrunc_u.d",  datad,  96, w26, w4);
      TEST_2RF("ftrunc_u.d",  datad, 112, w27, w17);
      TEST_2RF("ftrunc_u.d",  datad, 128, w28, w28);
      TEST_2RF("ftrunc_u.d",  datad, 144, w29, w0);
      TEST_2RF("ftrunc_u.d",  datad,   0, w30, w14);
      TEST_2RF("ftrunc_u.d",  datad,  16, w31, w7);
      TEST_2RF("fexupl.w",  data16,   0, w0,  w29);
      TEST_2RF("fexupl.w",  data16,   8, w1,  w17);
      TEST_2RF("fexupl.w",  data16,  16, w2,  w17);
      TEST_2RF("fexupl.w",  data16,  24, w3,  w20);
      TEST_2RF("fexupl.w",  data16,  32, w4,  w24);
      TEST_2RF("fexupl.w",  data16,  40, w5,  w15);
      TEST_2RF("fexupl.w",  data16,  48, w6,  w8);
      TEST_2RF("fexupl.w",  data16,  56, w7,  w1);
      TEST_2RF("fexupl.w",  data16,  64, w8,  w20);
      TEST_2RF("fexupl.w",  data16,  72, w9,  w9);
      TEST_2RF("fexupl.w",  data16,   0, w10, w18);
      TEST_2RF("fexupl.w",  data16,   8, w11, w27);
      TEST_2RF("fexupl.w",  data16,  16, w12, w17);
      TEST_2RF("fexupl.w",  data16,  24, w13, w29);
      TEST_2RF("fexupl.w",  data16,  32, w14, w26);
      TEST_2RF("fexupl.w",  data16,  40, w15, w24);
      TEST_2RF("fexupl.w",  data16,  48, w16, w20);
      TEST_2RF("fexupl.w",  data16,  56, w17, w25);
      TEST_2RF("fexupl.w",  data16,  64, w18, w29);
      TEST_2RF("fexupl.w",  data16,  72, w19, w22);
      TEST_2RF("fexupl.w",  data16,   0, w20, w16);
      TEST_2RF("fexupl.w",  data16,   8, w21, w12);
      TEST_2RF("fexupl.w",  data16,  16, w22, w13);
      TEST_2RF("fexupl.w",  data16,  24, w23, w9);
      TEST_2RF("fexupl.w",  data16,  32, w24, w20);
      TEST_2RF("fexupl.w",  data16,  40, w25, w26);
      TEST_2RF("fexupl.w",  data16,  48, w26, w15);
      TEST_2RF("fexupl.w",  data16,  56, w27, w6);
      TEST_2RF("fexupl.w",  data16,  64, w28, w31);
      TEST_2RF("fexupl.w",  data16,  72, w29, w8);
      TEST_2RF("fexupl.w",  data16,   0, w30, w17);
      TEST_2RF("fexupl.w",  data16,   8, w31, w31);
      TEST_2RF("fexupl.d",  dataf,   0, w0,  w24);
      TEST_2RF("fexupl.d",  dataf,   8, w1,  w17);
      TEST_2RF("fexupl.d",  dataf,  16, w2,  w21);
      TEST_2RF("fexupl.d",  dataf,  24, w3,  w20);
      TEST_2RF("fexupl.d",  dataf,  32, w4,  w29);
      TEST_2RF("fexupl.d",  dataf,  40, w5,  w22);
      TEST_2RF("fexupl.d",  dataf,  48, w6,  w0);
      TEST_2RF("fexupl.d",  dataf,  56, w7,  w21);
      TEST_2RF("fexupl.d",  dataf,  64, w8,  w1);
      TEST_2RF("fexupl.d",  dataf,  72, w9,  w9);
      TEST_2RF("fexupl.d",  dataf,   0, w10, w9);
      TEST_2RF("fexupl.d",  dataf,   8, w11, w3);
      TEST_2RF("fexupl.d",  dataf,  16, w12, w26);
      TEST_2RF("fexupl.d",  dataf,  24, w13, w28);
      TEST_2RF("fexupl.d",  dataf,  32, w14, w12);
      TEST_2RF("fexupl.d",  dataf,  40, w15, w25);
      TEST_2RF("fexupl.d",  dataf,  48, w16, w25);
      TEST_2RF("fexupl.d",  dataf,  56, w17, w22);
      TEST_2RF("fexupl.d",  dataf,  64, w18, w6);
      TEST_2RF("fexupl.d",  dataf,  72, w19, w12);
      TEST_2RF("fexupl.d",  dataf,   0, w20, w0);
      TEST_2RF("fexupl.d",  dataf,   8, w21, w5);
      TEST_2RF("fexupl.d",  dataf,  16, w22, w31);
      TEST_2RF("fexupl.d",  dataf,  24, w23, w5);
      TEST_2RF("fexupl.d",  dataf,  32, w24, w20);
      TEST_2RF("fexupl.d",  dataf,  40, w25, w7);
      TEST_2RF("fexupl.d",  dataf,  48, w26, w0);
      TEST_2RF("fexupl.d",  dataf,  56, w27, w21);
      TEST_2RF("fexupl.d",  dataf,  64, w28, w16);
      TEST_2RF("fexupl.d",  dataf,  72, w29, w24);
      TEST_2RF("fexupl.d",  dataf,   0, w30, w18);
      TEST_2RF("fexupl.d",  dataf,   8, w31, w31);
      TEST_2RF("fexupr.w",  data16,   0, w0,  w25);
      TEST_2RF("fexupr.w",  data16,   8, w1,  w24);
      TEST_2RF("fexupr.w",  data16,  16, w2,  w2);
      TEST_2RF("fexupr.w",  data16,  24, w3,  w14);
      TEST_2RF("fexupr.w",  data16,  32, w4,  w29);
      TEST_2RF("fexupr.w",  data16,  40, w5,  w14);
      TEST_2RF("fexupr.w",  data16,  48, w6,  w29);
      TEST_2RF("fexupr.w",  data16,  56, w7,  w17);
      TEST_2RF("fexupr.w",  data16,  64, w8,  w20);
      TEST_2RF("fexupr.w",  data16,  72, w9,  w18);
      TEST_2RF("fexupr.w",  data16,   0, w10, w7);
      TEST_2RF("fexupr.w",  data16,   8, w11, w26);
      TEST_2RF("fexupr.w",  data16,  16, w12, w17);
      TEST_2RF("fexupr.w",  data16,  24, w13, w11);
      TEST_2RF("fexupr.w",  data16,  32, w14, w22);
      TEST_2RF("fexupr.w",  data16,  40, w15, w5);
      TEST_2RF("fexupr.w",  data16,  48, w16, w26);
      TEST_2RF("fexupr.w",  data16,  56, w17, w6);
      TEST_2RF("fexupr.w",  data16,  64, w18, w6);
      TEST_2RF("fexupr.w",  data16,  72, w19, w24);
      TEST_2RF("fexupr.w",  data16,   0, w20, w23);
      TEST_2RF("fexupr.w",  data16,   8, w21, w30);
      TEST_2RF("fexupr.w",  data16,  16, w22, w22);
      TEST_2RF("fexupr.w",  data16,  24, w23, w15);
      TEST_2RF("fexupr.w",  data16,  32, w24, w29);
      TEST_2RF("fexupr.w",  data16,  40, w25, w17);
      TEST_2RF("fexupr.w",  data16,  48, w26, w8);
      TEST_2RF("fexupr.w",  data16,  56, w27, w1);
      TEST_2RF("fexupr.w",  data16,  64, w28, w23);
      TEST_2RF("fexupr.w",  data16,  72, w29, w31);
      TEST_2RF("fexupr.w",  data16,   0, w30, w3);
      TEST_2RF("fexupr.w",  data16,   8, w31, w27);
      TEST_2RF("fexupr.d",  dataf,   0, w0,  w18);
      TEST_2RF("fexupr.d",  dataf,   8, w1,  w7);
      TEST_2RF("fexupr.d",  dataf,  16, w2,  w2);
      TEST_2RF("fexupr.d",  dataf,  24, w3,  w1);
      TEST_2RF("fexupr.d",  dataf,  32, w4,  w0);
      TEST_2RF("fexupr.d",  dataf,  40, w5,  w25);
      TEST_2RF("fexupr.d",  dataf,  48, w6,  w26);
      TEST_2RF("fexupr.d",  dataf,  56, w7,  w15);
      TEST_2RF("fexupr.d",  dataf,  64, w8,  w6);
      TEST_2RF("fexupr.d",  dataf,  72, w9,  w13);
      TEST_2RF("fexupr.d",  dataf,   0, w10, w23);
      TEST_2RF("fexupr.d",  dataf,   8, w11, w19);
      TEST_2RF("fexupr.d",  dataf,  16, w12, w22);
      TEST_2RF("fexupr.d",  dataf,  24, w13, w29);
      TEST_2RF("fexupr.d",  dataf,  32, w14, w28);
      TEST_2RF("fexupr.d",  dataf,  40, w15, w3);
      TEST_2RF("fexupr.d",  dataf,  48, w16, w22);
      TEST_2RF("fexupr.d",  dataf,  56, w17, w19);
      TEST_2RF("fexupr.d",  dataf,  64, w18, w8);
      TEST_2RF("fexupr.d",  dataf,  72, w19, w25);
      TEST_2RF("fexupr.d",  dataf,   0, w20, w8);
      TEST_2RF("fexupr.d",  dataf,   8, w21, w15);
      TEST_2RF("fexupr.d",  dataf,  16, w22, w22);
      TEST_2RF("fexupr.d",  dataf,  24, w23, w30);
      TEST_2RF("fexupr.d",  dataf,  32, w24, w6);
      TEST_2RF("fexupr.d",  dataf,  40, w25, w22);
      TEST_2RF("fexupr.d",  dataf,  48, w26, w0);
      TEST_2RF("fexupr.d",  dataf,  56, w27, w30);
      TEST_2RF("fexupr.d",  dataf,  64, w28, w30);
      TEST_2RF("fexupr.d",  dataf,  72, w29, w31);
      TEST_2RF("fexupr.d",  dataf,   0, w30, w31);
      TEST_2RF("fexupr.d",  dataf,   8, w31, w25);
      TEST_2RF("ffql.w",  data16,   0, w0,  w20);
      TEST_2RF("ffql.w",  data16,   8, w1,  w25);
      TEST_2RF("ffql.w",  data16,  16, w2,  w3);
      TEST_2RF("ffql.w",  data16,  24, w3,  w2);
      TEST_2RF("ffql.w",  data16,  32, w4,  w31);
      TEST_2RF("ffql.w",  data16,  40, w5,  w28);
      TEST_2RF("ffql.w",  data16,  48, w6,  w15);
      TEST_2RF("ffql.w",  data16,  56, w7,  w3);
      TEST_2RF("ffql.w",  data16,  64, w8,  w13);
      TEST_2RF("ffql.w",  data16,  72, w9,  w7);
      TEST_2RF("ffql.w",  data16,   0, w10, w15);
      TEST_2RF("ffql.w",  data16,   8, w11, w15);
      TEST_2RF("ffql.w",  data16,  16, w12, w12);
      TEST_2RF("ffql.w",  data16,  24, w13, w13);
      TEST_2RF("ffql.w",  data16,  32, w14, w18);
      TEST_2RF("ffql.w",  data16,  40, w15, w9);
      TEST_2RF("ffql.w",  data16,  48, w16, w15);
      TEST_2RF("ffql.w",  data16,  56, w17, w16);
      TEST_2RF("ffql.w",  data16,  64, w18, w22);
      TEST_2RF("ffql.w",  data16,  72, w19, w3);
      TEST_2RF("ffql.w",  data16,   0, w20, w1);
      TEST_2RF("ffql.w",  data16,   8, w21, w6);
      TEST_2RF("ffql.w",  data16,  16, w22, w19);
      TEST_2RF("ffql.w",  data16,  24, w23, w26);
      TEST_2RF("ffql.w",  data16,  32, w24, w17);
      TEST_2RF("ffql.w",  data16,  40, w25, w15);
      TEST_2RF("ffql.w",  data16,  48, w26, w0);
      TEST_2RF("ffql.w",  data16,  56, w27, w30);
      TEST_2RF("ffql.w",  data16,  64, w28, w31);
      TEST_2RF("ffql.w",  data16,  72, w29, w31);
      TEST_2RF("ffql.w",  data16,   0, w30, w15);
      TEST_2RF("ffql.w",  data16,   8, w31, w24);
      TEST_2RF("ffql.d",  dataf,   0, w0,  w30);
      TEST_2RF("ffql.d",  dataf,   8, w1,  w25);
      TEST_2RF("ffql.d",  dataf,  16, w2,  w5);
      TEST_2RF("ffql.d",  dataf,  24, w3,  w19);
      TEST_2RF("ffql.d",  dataf,  32, w4,  w23);
      TEST_2RF("ffql.d",  dataf,  40, w5,  w6);
      TEST_2RF("ffql.d",  dataf,  48, w6,  w15);
      TEST_2RF("ffql.d",  dataf,  56, w7,  w2);
      TEST_2RF("ffql.d",  dataf,  64, w8,  w18);
      TEST_2RF("ffql.d",  dataf,  72, w9,  w0);
      TEST_2RF("ffql.d",  dataf,   0, w10, w18);
      TEST_2RF("ffql.d",  dataf,   8, w11, w0);
      TEST_2RF("ffql.d",  dataf,  16, w12, w12);
      TEST_2RF("ffql.d",  dataf,  24, w13, w13);
      TEST_2RF("ffql.d",  dataf,  32, w14, w17);
      TEST_2RF("ffql.d",  dataf,  40, w15, w12);
      TEST_2RF("ffql.d",  dataf,  48, w16, w9);
      TEST_2RF("ffql.d",  dataf,  56, w17, w3);
      TEST_2RF("ffql.d",  dataf,  64, w18, w6);
      TEST_2RF("ffql.d",  dataf,  72, w19, w25);
      TEST_2RF("ffql.d",  dataf,   0, w20, w13);
      TEST_2RF("ffql.d",  dataf,   8, w21, w19);
      TEST_2RF("ffql.d",  dataf,  16, w22, w6);
      TEST_2RF("ffql.d",  dataf,  24, w23, w16);
      TEST_2RF("ffql.d",  dataf,  32, w24, w26);
      TEST_2RF("ffql.d",  dataf,  40, w25, w7);
      TEST_2RF("ffql.d",  dataf,  48, w26, w11);
      TEST_2RF("ffql.d",  dataf,  56, w27, w8);
      TEST_2RF("ffql.d",  dataf,  64, w28, w22);
      TEST_2RF("ffql.d",  dataf,  72, w29, w25);
      TEST_2RF("ffql.d",  dataf,   0, w30, w5);
      TEST_2RF("ffql.d",  dataf,   8, w31, w29);
      TEST_2RF("ffqr.w",  data16,   0, w0,  w28);
      TEST_2RF("ffqr.w",  data16,   8, w1,  w11);
      TEST_2RF("ffqr.w",  data16,  16, w2,  w11);
      TEST_2RF("ffqr.w",  data16,  24, w3,  w8);
      TEST_2RF("ffqr.w",  data16,  32, w4,  w6);
      TEST_2RF("ffqr.w",  data16,  40, w5,  w5);
      TEST_2RF("ffqr.w",  data16,  48, w6,  w13);
      TEST_2RF("ffqr.w",  data16,  56, w7,  w31);
      TEST_2RF("ffqr.w",  data16,  64, w8,  w11);
      TEST_2RF("ffqr.w",  data16,  72, w9,  w30);
      TEST_2RF("ffqr.w",  data16,   0, w10, w15);
      TEST_2RF("ffqr.w",  data16,   8, w11, w24);
      TEST_2RF("ffqr.w",  data16,  16, w12, w18);
      TEST_2RF("ffqr.w",  data16,  24, w13, w30);
      TEST_2RF("ffqr.w",  data16,  32, w14, w27);
      TEST_2RF("ffqr.w",  data16,  40, w15, w8);
      TEST_2RF("ffqr.w",  data16,  48, w16, w16);
      TEST_2RF("ffqr.w",  data16,  56, w17, w14);
      TEST_2RF("ffqr.w",  data16,  64, w18, w26);
      TEST_2RF("ffqr.w",  data16,  72, w19, w2);
      TEST_2RF("ffqr.w",  data16,   0, w20, w30);
      TEST_2RF("ffqr.w",  data16,   8, w21, w3);
      TEST_2RF("ffqr.w",  data16,  16, w22, w19);
      TEST_2RF("ffqr.w",  data16,  24, w23, w1);
      TEST_2RF("ffqr.w",  data16,  32, w24, w0);
      TEST_2RF("ffqr.w",  data16,  40, w25, w7);
      TEST_2RF("ffqr.w",  data16,  48, w26, w24);
      TEST_2RF("ffqr.w",  data16,  56, w27, w10);
      TEST_2RF("ffqr.w",  data16,  64, w28, w26);
      TEST_2RF("ffqr.w",  data16,  72, w29, w13);
      TEST_2RF("ffqr.w",  data16,   0, w30, w1);
      TEST_2RF("ffqr.w",  data16,   8, w31, w20);
      TEST_2RF("ffqr.d",  dataf,   0, w0,  w15);
      TEST_2RF("ffqr.d",  dataf,   8, w1,  w14);
      TEST_2RF("ffqr.d",  dataf,  16, w2,  w5);
      TEST_2RF("ffqr.d",  dataf,  24, w3,  w31);
      TEST_2RF("ffqr.d",  dataf,  32, w4,  w2);
      TEST_2RF("ffqr.d",  dataf,  40, w5,  w5);
      TEST_2RF("ffqr.d",  dataf,  48, w6,  w8);
      TEST_2RF("ffqr.d",  dataf,  56, w7,  w16);
      TEST_2RF("ffqr.d",  dataf,  64, w8,  w16);
      TEST_2RF("ffqr.d",  dataf,  72, w9,  w3);
      TEST_2RF("ffqr.d",  dataf,   0, w10, w5);
      TEST_2RF("ffqr.d",  dataf,   8, w11, w18);
      TEST_2RF("ffqr.d",  dataf,  16, w12, w25);
      TEST_2RF("ffqr.d",  dataf,  24, w13, w4);
      TEST_2RF("ffqr.d",  dataf,  32, w14, w12);
      TEST_2RF("ffqr.d",  dataf,  40, w15, w22);
      TEST_2RF("ffqr.d",  dataf,  48, w16, w16);
      TEST_2RF("ffqr.d",  dataf,  56, w17, w4);
      TEST_2RF("ffqr.d",  dataf,  64, w18, w30);
      TEST_2RF("ffqr.d",  dataf,  72, w19, w4);
      TEST_2RF("ffqr.d",  dataf,   0, w20, w10);
      TEST_2RF("ffqr.d",  dataf,   8, w21, w15);
      TEST_2RF("ffqr.d",  dataf,  16, w22, w10);
      TEST_2RF("ffqr.d",  dataf,  24, w23, w25);
      TEST_2RF("ffqr.d",  dataf,  32, w24, w15);
      TEST_2RF("ffqr.d",  dataf,  40, w25, w10);
      TEST_2RF("ffqr.d",  dataf,  48, w26, w23);
      TEST_2RF("ffqr.d",  dataf,  56, w27, w9);
      TEST_2RF("ffqr.d",  dataf,  64, w28, w2);
      TEST_2RF("ffqr.d",  dataf,  72, w29, w4);
      TEST_2RF("ffqr.d",  dataf,   0, w30, w15);
      TEST_2RF("ffqr.d",  dataf,   8, w31, w28);
   }

   // Registers ovelapping tests.

   TEST_MSA_FPU_REG32(0);
   TEST_MSA_FPU_REG32(1);
   TEST_MSA_FPU_REG32(2);
   TEST_MSA_FPU_REG32(3);
   TEST_MSA_FPU_REG32(4);
   TEST_MSA_FPU_REG32(5);
   TEST_MSA_FPU_REG32(6);
   TEST_MSA_FPU_REG32(7);
   TEST_MSA_FPU_REG32(8);
   TEST_MSA_FPU_REG32(9);
   TEST_MSA_FPU_REG32(10);
   TEST_MSA_FPU_REG32(11);
   TEST_MSA_FPU_REG32(12);
   TEST_MSA_FPU_REG32(13);
   TEST_MSA_FPU_REG32(14);
   TEST_MSA_FPU_REG32(15);
   TEST_MSA_FPU_REG32(16);
   TEST_MSA_FPU_REG32(17);
   TEST_MSA_FPU_REG32(18);
   TEST_MSA_FPU_REG32(19);
   TEST_MSA_FPU_REG32(20);
   TEST_MSA_FPU_REG32(21);
   TEST_MSA_FPU_REG32(22);
   TEST_MSA_FPU_REG32(23);
   TEST_MSA_FPU_REG32(24);
   TEST_MSA_FPU_REG32(25);
   TEST_MSA_FPU_REG32(26);
   TEST_MSA_FPU_REG32(27);
   TEST_MSA_FPU_REG32(28);
   TEST_MSA_FPU_REG32(29);
   TEST_MSA_FPU_REG32(30);
   TEST_MSA_FPU_REG32(31);
   TEST_MSA_FPU_REG64(0);
   TEST_MSA_FPU_REG64(1);
   TEST_MSA_FPU_REG64(2);
   TEST_MSA_FPU_REG64(3);
   TEST_MSA_FPU_REG64(4);
   TEST_MSA_FPU_REG64(5);
   TEST_MSA_FPU_REG64(6);
   TEST_MSA_FPU_REG64(7);
   TEST_MSA_FPU_REG64(8);
   TEST_MSA_FPU_REG64(9);
   TEST_MSA_FPU_REG64(10);
   TEST_MSA_FPU_REG64(11);
   TEST_MSA_FPU_REG64(12);
   TEST_MSA_FPU_REG64(13);
   TEST_MSA_FPU_REG64(14);
   TEST_MSA_FPU_REG64(15);
   TEST_MSA_FPU_REG64(16);
   TEST_MSA_FPU_REG64(17);
   TEST_MSA_FPU_REG64(18);
   TEST_MSA_FPU_REG64(19);
   TEST_MSA_FPU_REG64(20);
   TEST_MSA_FPU_REG64(21);
   TEST_MSA_FPU_REG64(22);
   TEST_MSA_FPU_REG64(23);
   TEST_MSA_FPU_REG64(24);
   TEST_MSA_FPU_REG64(25);
   TEST_MSA_FPU_REG64(26);
   TEST_MSA_FPU_REG64(27);
   TEST_MSA_FPU_REG64(28);
   TEST_MSA_FPU_REG64(29);
   TEST_MSA_FPU_REG64(30);
   TEST_MSA_FPU_REG64(31);
   TEST_FPU_MSA_REG32(0);
   TEST_FPU_MSA_REG32(1);
   TEST_FPU_MSA_REG32(2);
   TEST_FPU_MSA_REG32(3);
   TEST_FPU_MSA_REG32(4);
   TEST_FPU_MSA_REG32(5);
   TEST_FPU_MSA_REG32(6);
   TEST_FPU_MSA_REG32(7);
   TEST_FPU_MSA_REG32(8);
   TEST_FPU_MSA_REG32(9);
   TEST_FPU_MSA_REG32(10);
   TEST_FPU_MSA_REG32(11);
   TEST_FPU_MSA_REG32(12);
   TEST_FPU_MSA_REG32(13);
   TEST_FPU_MSA_REG32(14);
   TEST_FPU_MSA_REG32(15);
   TEST_FPU_MSA_REG32(16);
   TEST_FPU_MSA_REG32(17);
   TEST_FPU_MSA_REG32(18);
   TEST_FPU_MSA_REG32(19);
   TEST_FPU_MSA_REG32(20);
   TEST_FPU_MSA_REG32(21);
   TEST_FPU_MSA_REG32(22);
   TEST_FPU_MSA_REG32(23);
   TEST_FPU_MSA_REG32(24);
   TEST_FPU_MSA_REG32(25);
   TEST_FPU_MSA_REG32(26);
   TEST_FPU_MSA_REG32(27);
   TEST_FPU_MSA_REG32(28);
   TEST_FPU_MSA_REG32(29);
   TEST_FPU_MSA_REG32(30);
   TEST_FPU_MSA_REG32(31);
   TEST_FPU_MSA_REG64(0);
   TEST_FPU_MSA_REG64(1);
   TEST_FPU_MSA_REG64(2);
   TEST_FPU_MSA_REG64(3);
   TEST_FPU_MSA_REG64(4);
   TEST_FPU_MSA_REG64(5);
   TEST_FPU_MSA_REG64(6);
   TEST_FPU_MSA_REG64(7);
   TEST_FPU_MSA_REG64(8);
   TEST_FPU_MSA_REG64(9);
   TEST_FPU_MSA_REG64(10);
   TEST_FPU_MSA_REG64(11);
   TEST_FPU_MSA_REG64(12);
   TEST_FPU_MSA_REG64(13);
   TEST_FPU_MSA_REG64(14);
   TEST_FPU_MSA_REG64(15);
   TEST_FPU_MSA_REG64(16);
   TEST_FPU_MSA_REG64(17);
   TEST_FPU_MSA_REG64(18);
   TEST_FPU_MSA_REG64(19);
   TEST_FPU_MSA_REG64(20);
   TEST_FPU_MSA_REG64(21);
   TEST_FPU_MSA_REG64(22);
   TEST_FPU_MSA_REG64(23);
   TEST_FPU_MSA_REG64(24);
   TEST_FPU_MSA_REG64(25);
   TEST_FPU_MSA_REG64(26);
   TEST_FPU_MSA_REG64(27);
   TEST_FPU_MSA_REG64(28);
   TEST_FPU_MSA_REG64(29);
   TEST_FPU_MSA_REG64(30);
   TEST_FPU_MSA_REG64(31);
#else
   printf("This test requires MSA extension.\n");
#endif
   return 0;
}
