/* fts.c generated by valac 0.29.2.5-8632, the Vala compiler
 * generated from fts.vala, do not modify */

/* fts.vala
 *
 * Copyright © 2011 Seif Lotfy <seif@lotfy.com>
 * Copyright © 2011 Canonical Ltd.
 *             By Michal Hruby <michal.hruby@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include "zeitgeist-engine.h"
#include "zeitgeist.h"
#include "zeitgeist-datamodel.h"


#define ZEITGEIST_TYPE_REMOTE_SEARCH_ENGINE (zeitgeist_remote_search_engine_get_type ())
#define ZEITGEIST_REMOTE_SEARCH_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_REMOTE_SEARCH_ENGINE, ZeitgeistRemoteSearchEngine))
#define ZEITGEIST_IS_REMOTE_SEARCH_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_REMOTE_SEARCH_ENGINE))
#define ZEITGEIST_REMOTE_SEARCH_ENGINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), ZEITGEIST_TYPE_REMOTE_SEARCH_ENGINE, ZeitgeistRemoteSearchEngineIface))

typedef struct _ZeitgeistRemoteSearchEngine ZeitgeistRemoteSearchEngine;
typedef struct _ZeitgeistRemoteSearchEngineIface ZeitgeistRemoteSearchEngineIface;

#define ZEITGEIST_TYPE_REMOTE_SEARCH_ENGINE_PROXY (zeitgeist_remote_search_engine_proxy_get_type ())
typedef GDBusProxy ZeitgeistRemoteSearchEngineProxy;
typedef GDBusProxyClass ZeitgeistRemoteSearchEngineProxyClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

#define ZEITGEIST_TYPE_SEARCH_ENGINE (zeitgeist_search_engine_get_type ())
#define ZEITGEIST_SEARCH_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_SEARCH_ENGINE, ZeitgeistSearchEngine))
#define ZEITGEIST_SEARCH_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_SEARCH_ENGINE, ZeitgeistSearchEngineClass))
#define ZEITGEIST_IS_SEARCH_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_SEARCH_ENGINE))
#define ZEITGEIST_IS_SEARCH_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_SEARCH_ENGINE))
#define ZEITGEIST_SEARCH_ENGINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_SEARCH_ENGINE, ZeitgeistSearchEngineClass))

typedef struct _ZeitgeistSearchEngine ZeitgeistSearchEngine;
typedef struct _ZeitgeistSearchEngineClass ZeitgeistSearchEngineClass;
typedef struct _ZeitgeistSearchEnginePrivate ZeitgeistSearchEnginePrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ZeitgeistSearchEngineWaitForProxyData ZeitgeistSearchEngineWaitForProxyData;
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
typedef struct _ZeitgeistSearchEngineSearchData ZeitgeistSearchEngineSearchData;
typedef struct _ZeitgeistSearchEngineSearchWithRelevanciesData ZeitgeistSearchEngineSearchWithRelevanciesData;
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

struct _ZeitgeistRemoteSearchEngineIface {
	GTypeInterface parent_iface;
	void (*search) (ZeitgeistRemoteSearchEngine* self, const gchar* query_string, GVariant* time_range, GVariant* filter_templates, guint offset, guint count, guint result_type, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*search_finish) (ZeitgeistRemoteSearchEngine* self, GAsyncResult* _res_, GVariant** events, guint* matches, GError** error);
	void (*search_with_relevancies) (ZeitgeistRemoteSearchEngine* self, const gchar* query_string, GVariant* time_range, GVariant* filter_templates, guint storage_state, guint offset, guint count, guint result_type, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*search_with_relevancies_finish) (ZeitgeistRemoteSearchEngine* self, GAsyncResult* _res_, GVariant** events, gdouble** relevancies, int* relevancies_length1, guint* matches, GError** error);
};

struct _ZeitgeistSearchEngine {
	ZeitgeistExtension parent_instance;
	ZeitgeistSearchEnginePrivate * priv;
};

struct _ZeitgeistSearchEngineClass {
	ZeitgeistExtensionClass parent_class;
};

struct _ZeitgeistSearchEnginePrivate {
	ZeitgeistRemoteSimpleIndexer* siin;
	gboolean siin_connection_failed;
	guint registration_id;
	ZeitgeistMonitorManager* notifier;
};

struct _ZeitgeistSearchEngineWaitForProxyData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	ZeitgeistSearchEngine* self;
	gint i;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ZeitgeistRemoteSimpleIndexer* _tmp2_;
	gint _tmp3_;
	gboolean _tmp4_;
	gint _tmp5_;
	gboolean _tmp6_;
	ZeitgeistRemoteSimpleIndexer* _tmp7_;
	ZeitgeistRemoteSimpleIndexer* _tmp8_;
	GError* _tmp9_;
	GError * _inner_error_;
};

struct _ZeitgeistSearchEngineSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	ZeitgeistSearchEngine* self;
	gchar* query_string;
	GVariant* time_range;
	GVariant* filter_templates;
	guint offset;
	guint count;
	guint result_type;
	GVariant* events;
	guint matches;
	ZeitgeistRemoteSimpleIndexer* _tmp0_;
	GTimer* timer;
	GTimer* _tmp1_;
	ZeitgeistRemoteSimpleIndexer* _tmp2_;
	const gchar* _tmp3_;
	GVariant* _tmp4_;
	GVariant* _tmp5_;
	guint _tmp6_;
	guint _tmp7_;
	guint _tmp8_;
	GVariant* _tmp9_;
	guint _tmp10_;
	GVariant* _tmp11_;
	gsize _tmp12_;
	guint _tmp13_;
	GTimer* _tmp14_;
	gdouble _tmp15_;
	GError * _inner_error_;
};

struct _ZeitgeistSearchEngineSearchWithRelevanciesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	ZeitgeistSearchEngine* self;
	gchar* query_string;
	GVariant* time_range;
	GVariant* filter_templates;
	guint storage_state;
	guint offset;
	guint count;
	guint result_type;
	GVariant* events;
	gdouble* relevancies;
	gint relevancies_length1;
	guint matches;
	ZeitgeistRemoteSimpleIndexer* _tmp0_;
	GTimer* timer;
	GTimer* _tmp1_;
	ZeitgeistRemoteSimpleIndexer* _tmp2_;
	const gchar* _tmp3_;
	GVariant* _tmp4_;
	GVariant* _tmp5_;
	guint _tmp6_;
	guint _tmp7_;
	guint _tmp8_;
	guint _tmp9_;
	GVariant* _tmp10_;
	gdouble* _tmp11_;
	gint _tmp12_;
	guint _tmp13_;
	GVariant* _tmp14_;
	gsize _tmp15_;
	guint _tmp16_;
	GTimer* _tmp17_;
	gdouble _tmp18_;
	GError * _inner_error_;
};


static GType zeitgeist_remote_search_engine_type_id = 0;
static gpointer zeitgeist_search_engine_parent_class = NULL;
static ZeitgeistRemoteSearchEngineIface* zeitgeist_search_engine_zeitgeist_remote_search_engine_parent_iface = NULL;
static GType zeitgeist_search_engine_type_id = 0;

GType zeitgeist_remote_search_engine_proxy_get_type (void) G_GNUC_CONST;
void zeitgeist_remote_search_engine_proxy_register_dynamic_type (GTypeModule* module);
guint zeitgeist_remote_search_engine_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType zeitgeist_remote_search_engine_get_type (void) G_GNUC_CONST;
GType zeitgeist_remote_search_engine_register_type (GTypeModule * module);
void zeitgeist_remote_search_engine_search (ZeitgeistRemoteSearchEngine* self, const gchar* query_string, GVariant* time_range, GVariant* filter_templates, guint offset, guint count, guint result_type, GAsyncReadyCallback _callback_, gpointer _user_data_);
void zeitgeist_remote_search_engine_search_finish (ZeitgeistRemoteSearchEngine* self, GAsyncResult* _res_, GVariant** events, guint* matches, GError** error);
void zeitgeist_remote_search_engine_search_with_relevancies (ZeitgeistRemoteSearchEngine* self, const gchar* query_string, GVariant* time_range, GVariant* filter_templates, guint storage_state, guint offset, guint count, guint result_type, GAsyncReadyCallback _callback_, gpointer _user_data_);
void zeitgeist_remote_search_engine_search_with_relevancies_finish (ZeitgeistRemoteSearchEngine* self, GAsyncResult* _res_, GVariant** events, gdouble** relevancies, int* relevancies_length1, guint* matches, GError** error);
static void zeitgeist_remote_search_engine_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static void _vala_g_async_ready_callback (GObject *source_object, GAsyncResult *res, void *user_data);
static void zeitgeist_remote_search_engine_proxy_search_async (ZeitgeistRemoteSearchEngine* self, const gchar* query_string, GVariant* time_range, GVariant* filter_templates, guint offset, guint count, guint result_type, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void zeitgeist_remote_search_engine_proxy_search_finish (ZeitgeistRemoteSearchEngine* self, GAsyncResult* _res_, GVariant** events, guint* matches, GError** error);
static void zeitgeist_remote_search_engine_proxy_search_with_relevancies_async (ZeitgeistRemoteSearchEngine* self, const gchar* query_string, GVariant* time_range, GVariant* filter_templates, guint storage_state, guint offset, guint count, guint result_type, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void zeitgeist_remote_search_engine_proxy_search_with_relevancies_finish (ZeitgeistRemoteSearchEngine* self, GAsyncResult* _res_, GVariant** events, gdouble** relevancies, int* relevancies_length1, guint* matches, GError** error);
static void zeitgeist_remote_search_engine_proxy_zeitgeist_remote_search_engine_interface_init (ZeitgeistRemoteSearchEngineIface* iface);
static void _dbus_zeitgeist_remote_search_engine_search (ZeitgeistRemoteSearchEngine* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _dbus_zeitgeist_remote_search_engine_search_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void _dbus_zeitgeist_remote_search_engine_search_with_relevancies (ZeitgeistRemoteSearchEngine* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _dbus_zeitgeist_remote_search_engine_search_with_relevancies_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void zeitgeist_remote_search_engine_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* zeitgeist_remote_search_engine_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean zeitgeist_remote_search_engine_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _zeitgeist_remote_search_engine_unregister_object (gpointer user_data);
GType zeitgeist_search_engine_get_type (void) G_GNUC_CONST;
GType zeitgeist_search_engine_register_type (GTypeModule * module);
#define ZEITGEIST_SEARCH_ENGINE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), ZEITGEIST_TYPE_SEARCH_ENGINE, ZeitgeistSearchEnginePrivate))
enum  {
	ZEITGEIST_SEARCH_ENGINE_DUMMY_PROPERTY
};
#define ZEITGEIST_SEARCH_ENGINE_INDEXER_NAME "org.gnome.zeitgeist.SimpleIndexer"
static ZeitgeistSearchEngine* zeitgeist_search_engine_new (void);
static ZeitgeistSearchEngine* zeitgeist_search_engine_construct (GType object_type);
static void zeitgeist_search_engine_proxy_not_present (ZeitgeistSearchEngine* self);
static void zeitgeist_search_engine_proxy_acquired (ZeitgeistSearchEngine* self, GObject* obj, GAsyncResult* res);
static void zeitgeist_search_engine_wait_for_proxy_data_free (gpointer _data);
void zeitgeist_search_engine_wait_for_proxy (ZeitgeistSearchEngine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void zeitgeist_search_engine_wait_for_proxy_finish (ZeitgeistSearchEngine* self, GAsyncResult* _res_, GError** error);
static gboolean zeitgeist_search_engine_wait_for_proxy_co (ZeitgeistSearchEngineWaitForProxyData* _data_);
static gboolean _zeitgeist_search_engine_wait_for_proxy_co_gsource_func (gpointer self);
static void zeitgeist_search_engine_real_unload (ZeitgeistExtension* base);
static void zeitgeist_search_engine_real_search_data_free (gpointer _data);
static void zeitgeist_search_engine_real_search (ZeitgeistRemoteSearchEngine* base, const gchar* query_string, GVariant* time_range, GVariant* filter_templates, guint offset, guint count, guint result_type, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean zeitgeist_search_engine_real_search_co (ZeitgeistSearchEngineSearchData* _data_);
static void zeitgeist_search_engine_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void zeitgeist_search_engine_real_search_with_relevancies_data_free (gpointer _data);
static void zeitgeist_search_engine_real_search_with_relevancies (ZeitgeistRemoteSearchEngine* base, const gchar* query_string, GVariant* time_range, GVariant* filter_templates, guint storage_state, guint offset, guint count, guint result_type, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean zeitgeist_search_engine_real_search_with_relevancies_co (ZeitgeistSearchEngineSearchWithRelevanciesData* _data_);
static void zeitgeist_search_engine_search_with_relevancies_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static GObject * zeitgeist_search_engine_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _g_object_unref0_ (gpointer var);
static void _g_free0_ (gpointer var);
static GVariant* _variant_new1 (GHashTable* value);
static void _zeitgeist_search_engine_proxy_acquired_gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void zeitgeist_search_engine_finalize (GObject* obj);
GType zeitgeist_extension_register (GTypeModule* module);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GDBusArgInfo _zeitgeist_remote_search_engine_dbus_arg_info_search_query_string = {-1, "query_string", "s"};
static const GDBusArgInfo _zeitgeist_remote_search_engine_dbus_arg_info_search_time_range = {-1, "time_range", "(xx)"};
static const GDBusArgInfo _zeitgeist_remote_search_engine_dbus_arg_info_search_filter_templates = {-1, "filter_templates", "a(asaasay)"};
static const GDBusArgInfo _zeitgeist_remote_search_engine_dbus_arg_info_search_offset = {-1, "offset", "u"};
static const GDBusArgInfo _zeitgeist_remote_search_engine_dbus_arg_info_search_count = {-1, "count", "u"};
static const GDBusArgInfo _zeitgeist_remote_search_engine_dbus_arg_info_search_result_type = {-1, "result_type", "u"};
static const GDBusArgInfo _zeitgeist_remote_search_engine_dbus_arg_info_search_events = {-1, "events", "a(asaasay)"};
static const GDBusArgInfo _zeitgeist_remote_search_engine_dbus_arg_info_search_matches = {-1, "matches", "u"};
static const GDBusArgInfo * const _zeitgeist_remote_search_engine_dbus_arg_info_search_in[] = {&_zeitgeist_remote_search_engine_dbus_arg_info_search_query_string, &_zeitgeist_remote_search_engine_dbus_arg_info_search_time_range, &_zeitgeist_remote_search_engine_dbus_arg_info_search_filter_templates, &_zeitgeist_remote_search_engine_dbus_arg_info_search_offset, &_zeitgeist_remote_search_engine_dbus_arg_info_search_count, &_zeitgeist_remote_search_engine_dbus_arg_info_search_result_type, NULL};
static const GDBusArgInfo * const _zeitgeist_remote_search_engine_dbus_arg_info_search_out[] = {&_zeitgeist_remote_search_engine_dbus_arg_info_search_events, &_zeitgeist_remote_search_engine_dbus_arg_info_search_matches, NULL};
static const GDBusMethodInfo _zeitgeist_remote_search_engine_dbus_method_info_search = {-1, "Search", (GDBusArgInfo **) (&_zeitgeist_remote_search_engine_dbus_arg_info_search_in), (GDBusArgInfo **) (&_zeitgeist_remote_search_engine_dbus_arg_info_search_out)};
static const GDBusArgInfo _zeitgeist_remote_search_engine_dbus_arg_info_search_with_relevancies_query_string = {-1, "query_string", "s"};
static const GDBusArgInfo _zeitgeist_remote_search_engine_dbus_arg_info_search_with_relevancies_time_range = {-1, "time_range", "(xx)"};
static const GDBusArgInfo _zeitgeist_remote_search_engine_dbus_arg_info_search_with_relevancies_filter_templates = {-1, "filter_templates", "a(asaasay)"};
static const GDBusArgInfo _zeitgeist_remote_search_engine_dbus_arg_info_search_with_relevancies_storage_state = {-1, "storage_state", "u"};
static const GDBusArgInfo _zeitgeist_remote_search_engine_dbus_arg_info_search_with_relevancies_offset = {-1, "offset", "u"};
static const GDBusArgInfo _zeitgeist_remote_search_engine_dbus_arg_info_search_with_relevancies_count = {-1, "count", "u"};
static const GDBusArgInfo _zeitgeist_remote_search_engine_dbus_arg_info_search_with_relevancies_result_type = {-1, "result_type", "u"};
static const GDBusArgInfo _zeitgeist_remote_search_engine_dbus_arg_info_search_with_relevancies_events = {-1, "events", "a(asaasay)"};
static const GDBusArgInfo _zeitgeist_remote_search_engine_dbus_arg_info_search_with_relevancies_relevancies = {-1, "relevancies", "ad"};
static const GDBusArgInfo _zeitgeist_remote_search_engine_dbus_arg_info_search_with_relevancies_matches = {-1, "matches", "u"};
static const GDBusArgInfo * const _zeitgeist_remote_search_engine_dbus_arg_info_search_with_relevancies_in[] = {&_zeitgeist_remote_search_engine_dbus_arg_info_search_with_relevancies_query_string, &_zeitgeist_remote_search_engine_dbus_arg_info_search_with_relevancies_time_range, &_zeitgeist_remote_search_engine_dbus_arg_info_search_with_relevancies_filter_templates, &_zeitgeist_remote_search_engine_dbus_arg_info_search_with_relevancies_storage_state, &_zeitgeist_remote_search_engine_dbus_arg_info_search_with_relevancies_offset, &_zeitgeist_remote_search_engine_dbus_arg_info_search_with_relevancies_count, &_zeitgeist_remote_search_engine_dbus_arg_info_search_with_relevancies_result_type, NULL};
static const GDBusArgInfo * const _zeitgeist_remote_search_engine_dbus_arg_info_search_with_relevancies_out[] = {&_zeitgeist_remote_search_engine_dbus_arg_info_search_with_relevancies_events, &_zeitgeist_remote_search_engine_dbus_arg_info_search_with_relevancies_relevancies, &_zeitgeist_remote_search_engine_dbus_arg_info_search_with_relevancies_matches, NULL};
static const GDBusMethodInfo _zeitgeist_remote_search_engine_dbus_method_info_search_with_relevancies = {-1, "SearchWithRelevancies", (GDBusArgInfo **) (&_zeitgeist_remote_search_engine_dbus_arg_info_search_with_relevancies_in), (GDBusArgInfo **) (&_zeitgeist_remote_search_engine_dbus_arg_info_search_with_relevancies_out)};
static const GDBusMethodInfo * const _zeitgeist_remote_search_engine_dbus_method_info[] = {&_zeitgeist_remote_search_engine_dbus_method_info_search, &_zeitgeist_remote_search_engine_dbus_method_info_search_with_relevancies, NULL};
static const GDBusSignalInfo * const _zeitgeist_remote_search_engine_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _zeitgeist_remote_search_engine_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _zeitgeist_remote_search_engine_dbus_interface_info = {-1, "org.gnome.zeitgeist.Index", (GDBusMethodInfo **) (&_zeitgeist_remote_search_engine_dbus_method_info), (GDBusSignalInfo **) (&_zeitgeist_remote_search_engine_dbus_signal_info), (GDBusPropertyInfo **) (&_zeitgeist_remote_search_engine_dbus_property_info)};
static const GDBusInterfaceVTable _zeitgeist_remote_search_engine_dbus_interface_vtable = {zeitgeist_remote_search_engine_dbus_interface_method_call, zeitgeist_remote_search_engine_dbus_interface_get_property, zeitgeist_remote_search_engine_dbus_interface_set_property};

void zeitgeist_remote_search_engine_search (ZeitgeistRemoteSearchEngine* self, const gchar* query_string, GVariant* time_range, GVariant* filter_templates, guint offset, guint count, guint result_type, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ZEITGEIST_REMOTE_SEARCH_ENGINE_GET_INTERFACE (self)->search (self, query_string, time_range, filter_templates, offset, count, result_type, _callback_, _user_data_);
}


void zeitgeist_remote_search_engine_search_finish (ZeitgeistRemoteSearchEngine* self, GAsyncResult* _res_, GVariant** events, guint* matches, GError** error) {
	ZEITGEIST_REMOTE_SEARCH_ENGINE_GET_INTERFACE (self)->search_finish (self, _res_, events, matches, error);
}


void zeitgeist_remote_search_engine_search_with_relevancies (ZeitgeistRemoteSearchEngine* self, const gchar* query_string, GVariant* time_range, GVariant* filter_templates, guint storage_state, guint offset, guint count, guint result_type, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ZEITGEIST_REMOTE_SEARCH_ENGINE_GET_INTERFACE (self)->search_with_relevancies (self, query_string, time_range, filter_templates, storage_state, offset, count, result_type, _callback_, _user_data_);
}


void zeitgeist_remote_search_engine_search_with_relevancies_finish (ZeitgeistRemoteSearchEngine* self, GAsyncResult* _res_, GVariant** events, gdouble** relevancies, int* relevancies_length1, guint* matches, GError** error) {
	ZEITGEIST_REMOTE_SEARCH_ENGINE_GET_INTERFACE (self)->search_with_relevancies_finish (self, _res_, events, relevancies, relevancies_length1, matches, error);
}


static void zeitgeist_remote_search_engine_base_init (ZeitgeistRemoteSearchEngineIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
	}
}


GType zeitgeist_remote_search_engine_get_type (void) {
	return zeitgeist_remote_search_engine_type_id;
}


GType zeitgeist_remote_search_engine_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistRemoteSearchEngineIface), (GBaseInitFunc) zeitgeist_remote_search_engine_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	zeitgeist_remote_search_engine_type_id = g_type_module_register_type (module, G_TYPE_INTERFACE, "ZeitgeistRemoteSearchEngine", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (zeitgeist_remote_search_engine_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (zeitgeist_remote_search_engine_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) zeitgeist_remote_search_engine_proxy_get_type);
	g_type_set_qdata (zeitgeist_remote_search_engine_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.gnome.zeitgeist.Index");
	g_type_set_qdata (zeitgeist_remote_search_engine_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_zeitgeist_remote_search_engine_dbus_interface_info));
	g_type_set_qdata (zeitgeist_remote_search_engine_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) zeitgeist_remote_search_engine_register_object);
	return zeitgeist_remote_search_engine_type_id;
}


G_DEFINE_DYNAMIC_TYPE_EXTENDED (ZeitgeistRemoteSearchEngineProxy, zeitgeist_remote_search_engine_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE_DYNAMIC (ZEITGEIST_TYPE_REMOTE_SEARCH_ENGINE, zeitgeist_remote_search_engine_proxy_zeitgeist_remote_search_engine_interface_init) )
static void zeitgeist_remote_search_engine_proxy_class_init (ZeitgeistRemoteSearchEngineProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = zeitgeist_remote_search_engine_proxy_g_signal;
}


static void zeitgeist_remote_search_engine_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
}


static void zeitgeist_remote_search_engine_proxy_class_finalize (ZeitgeistRemoteSearchEngineProxyClass* klass) {
}


void zeitgeist_remote_search_engine_proxy_register_dynamic_type (GTypeModule* module) {
	zeitgeist_remote_search_engine_proxy_register_type (module);
}


static void zeitgeist_remote_search_engine_proxy_init (ZeitgeistRemoteSearchEngineProxy* self) {
}


static void _vala_g_async_ready_callback (GObject *source_object, GAsyncResult *res, void *user_data) {
	g_simple_async_result_set_op_res_gpointer (user_data, g_object_ref (res), g_object_unref);
	g_simple_async_result_complete (user_data);
	g_object_unref (user_data);
}


static void zeitgeist_remote_search_engine_proxy_search_async (ZeitgeistRemoteSearchEngine* self, const gchar* query_string, GVariant* time_range, GVariant* filter_templates, guint offset, guint count, guint result_type, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.zeitgeist.Index", "Search");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (query_string));
	g_variant_builder_add_value (&_arguments_builder, time_range);
	g_variant_builder_add_value (&_arguments_builder, filter_templates);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (offset));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (count));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (result_type));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_simple_async_result_new ((GObject *) self, _callback_, _user_data_, NULL));
	g_object_unref (_message);
}


static void zeitgeist_remote_search_engine_proxy_search_finish (ZeitgeistRemoteSearchEngine* self, GAsyncResult* _res_, GVariant** events, guint* matches, GError** error) {
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	GVariant* _vala_events;
	guint _vala_matches;
	GVariant* _tmp0_;
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), g_simple_async_result_get_op_res_gpointer ((GSimpleAsyncResult *) _res_), error);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_vala_events = g_variant_iter_next_value (&_reply_iter);
	*events = _vala_events;
	_tmp0_ = g_variant_iter_next_value (&_reply_iter);
	_vala_matches = g_variant_get_uint32 (_tmp0_);
	g_variant_unref (_tmp0_);
	*matches = _vala_matches;
	g_object_unref (_reply_message);
}


static void zeitgeist_remote_search_engine_proxy_search_with_relevancies_async (ZeitgeistRemoteSearchEngine* self, const gchar* query_string, GVariant* time_range, GVariant* filter_templates, guint storage_state, guint offset, guint count, guint result_type, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.zeitgeist.Index", "SearchWithRelevancies");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (query_string));
	g_variant_builder_add_value (&_arguments_builder, time_range);
	g_variant_builder_add_value (&_arguments_builder, filter_templates);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (storage_state));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (offset));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (count));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (result_type));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_simple_async_result_new ((GObject *) self, _callback_, _user_data_, NULL));
	g_object_unref (_message);
}


static void zeitgeist_remote_search_engine_proxy_search_with_relevancies_finish (ZeitgeistRemoteSearchEngine* self, GAsyncResult* _res_, GVariant** events, gdouble** relevancies, int* relevancies_length1, guint* matches, GError** error) {
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	GVariant* _vala_events;
	gdouble* _vala_relevancies;
	int _vala_relevancies_length1;
	GVariant* _tmp1_;
	gdouble* _tmp2_;
	int _tmp2__length;
	int _tmp2__size;
	int _tmp2__length1;
	GVariantIter _tmp3_;
	GVariant* _tmp4_;
	guint _vala_matches;
	GVariant* _tmp5_;
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), g_simple_async_result_get_op_res_gpointer ((GSimpleAsyncResult *) _res_), error);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_vala_events = g_variant_iter_next_value (&_reply_iter);
	*events = _vala_events;
	_vala_relevancies_length1 = 0;
	_tmp1_ = g_variant_iter_next_value (&_reply_iter);
	_tmp2_ = g_new (gdouble, 5);
	_tmp2__length = 0;
	_tmp2__size = 4;
	_tmp2__length1 = 0;
	g_variant_iter_init (&_tmp3_, _tmp1_);
	for (; (_tmp4_ = g_variant_iter_next_value (&_tmp3_)) != NULL; _tmp2__length1++) {
		if (_tmp2__size == _tmp2__length) {
			_tmp2__size = 2 * _tmp2__size;
			_tmp2_ = g_renew (gdouble, _tmp2_, _tmp2__size + 1);
		}
		_tmp2_[_tmp2__length++] = g_variant_get_double (_tmp4_);
		g_variant_unref (_tmp4_);
	}
	_vala_relevancies_length1 = _tmp2__length1;
	_vala_relevancies = _tmp2_;
	g_variant_unref (_tmp1_);
	*relevancies = _vala_relevancies;
	*relevancies_length1 = _vala_relevancies_length1;
	_tmp5_ = g_variant_iter_next_value (&_reply_iter);
	_vala_matches = g_variant_get_uint32 (_tmp5_);
	g_variant_unref (_tmp5_);
	*matches = _vala_matches;
	g_object_unref (_reply_message);
}


static void zeitgeist_remote_search_engine_proxy_zeitgeist_remote_search_engine_interface_init (ZeitgeistRemoteSearchEngineIface* iface) {
	iface->search = zeitgeist_remote_search_engine_proxy_search_async;
	iface->search_finish = zeitgeist_remote_search_engine_proxy_search_finish;
	iface->search_with_relevancies = zeitgeist_remote_search_engine_proxy_search_with_relevancies_async;
	iface->search_with_relevancies_finish = zeitgeist_remote_search_engine_proxy_search_with_relevancies_finish;
}


static void _dbus_zeitgeist_remote_search_engine_search (ZeitgeistRemoteSearchEngine* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	gchar* query_string = NULL;
	GVariant* _tmp6_;
	GVariant* time_range = NULL;
	GVariant* filter_templates = NULL;
	guint offset = 0U;
	GVariant* _tmp7_;
	guint count = 0U;
	GVariant* _tmp8_;
	guint result_type = 0U;
	GVariant* _tmp9_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp6_ = g_variant_iter_next_value (&_arguments_iter);
	query_string = g_variant_dup_string (_tmp6_, NULL);
	g_variant_unref (_tmp6_);
	time_range = g_variant_iter_next_value (&_arguments_iter);
	filter_templates = g_variant_iter_next_value (&_arguments_iter);
	_tmp7_ = g_variant_iter_next_value (&_arguments_iter);
	offset = g_variant_get_uint32 (_tmp7_);
	g_variant_unref (_tmp7_);
	_tmp8_ = g_variant_iter_next_value (&_arguments_iter);
	count = g_variant_get_uint32 (_tmp8_);
	g_variant_unref (_tmp8_);
	_tmp9_ = g_variant_iter_next_value (&_arguments_iter);
	result_type = g_variant_get_uint32 (_tmp9_);
	g_variant_unref (_tmp9_);
	zeitgeist_remote_search_engine_search (self, query_string, time_range, filter_templates, offset, count, result_type, (GAsyncReadyCallback) _dbus_zeitgeist_remote_search_engine_search_ready, invocation);
	_g_free0 (query_string);
	_g_variant_unref0 (time_range);
	_g_variant_unref0 (filter_templates);
}


static void _dbus_zeitgeist_remote_search_engine_search_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	GVariant* events = NULL;
	guint matches = 0U;
	invocation = _user_data_;
	zeitgeist_remote_search_engine_search_finish ((ZeitgeistRemoteSearchEngine*) source_object, _res_, &events, &matches, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, events);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_uint32 (matches));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	_g_variant_unref0 (events);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_zeitgeist_remote_search_engine_search_with_relevancies (ZeitgeistRemoteSearchEngine* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	gchar* query_string = NULL;
	GVariant* _tmp10_;
	GVariant* time_range = NULL;
	GVariant* filter_templates = NULL;
	guint storage_state = 0U;
	GVariant* _tmp11_;
	guint offset = 0U;
	GVariant* _tmp12_;
	guint count = 0U;
	GVariant* _tmp13_;
	guint result_type = 0U;
	GVariant* _tmp14_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp10_ = g_variant_iter_next_value (&_arguments_iter);
	query_string = g_variant_dup_string (_tmp10_, NULL);
	g_variant_unref (_tmp10_);
	time_range = g_variant_iter_next_value (&_arguments_iter);
	filter_templates = g_variant_iter_next_value (&_arguments_iter);
	_tmp11_ = g_variant_iter_next_value (&_arguments_iter);
	storage_state = g_variant_get_uint32 (_tmp11_);
	g_variant_unref (_tmp11_);
	_tmp12_ = g_variant_iter_next_value (&_arguments_iter);
	offset = g_variant_get_uint32 (_tmp12_);
	g_variant_unref (_tmp12_);
	_tmp13_ = g_variant_iter_next_value (&_arguments_iter);
	count = g_variant_get_uint32 (_tmp13_);
	g_variant_unref (_tmp13_);
	_tmp14_ = g_variant_iter_next_value (&_arguments_iter);
	result_type = g_variant_get_uint32 (_tmp14_);
	g_variant_unref (_tmp14_);
	zeitgeist_remote_search_engine_search_with_relevancies (self, query_string, time_range, filter_templates, storage_state, offset, count, result_type, (GAsyncReadyCallback) _dbus_zeitgeist_remote_search_engine_search_with_relevancies_ready, invocation);
	_g_free0 (query_string);
	_g_variant_unref0 (time_range);
	_g_variant_unref0 (filter_templates);
}


static void _dbus_zeitgeist_remote_search_engine_search_with_relevancies_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	GVariant* events = NULL;
	gdouble* relevancies = NULL;
	int relevancies_length1 = 0;
	gdouble* _tmp15_;
	GVariantBuilder _tmp16_;
	int _tmp17_;
	guint matches = 0U;
	invocation = _user_data_;
	zeitgeist_remote_search_engine_search_with_relevancies_finish ((ZeitgeistRemoteSearchEngine*) source_object, _res_, &events, &relevancies, &relevancies_length1, &matches, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, events);
	_tmp15_ = relevancies;
	g_variant_builder_init (&_tmp16_, G_VARIANT_TYPE ("ad"));
	for (_tmp17_ = 0; _tmp17_ < relevancies_length1; _tmp17_++) {
		g_variant_builder_add_value (&_tmp16_, g_variant_new_double (*_tmp15_));
		_tmp15_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp16_));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_uint32 (matches));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	_g_variant_unref0 (events);
	relevancies = (g_free (relevancies), NULL);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void zeitgeist_remote_search_engine_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "Search") == 0) {
		_dbus_zeitgeist_remote_search_engine_search (object, parameters, invocation);
	} else if (strcmp (method_name, "SearchWithRelevancies") == 0) {
		_dbus_zeitgeist_remote_search_engine_search_with_relevancies (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* zeitgeist_remote_search_engine_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean zeitgeist_remote_search_engine_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


guint zeitgeist_remote_search_engine_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_zeitgeist_remote_search_engine_dbus_interface_info), &_zeitgeist_remote_search_engine_dbus_interface_vtable, data, _zeitgeist_remote_search_engine_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}


static void _zeitgeist_remote_search_engine_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


static ZeitgeistSearchEngine* zeitgeist_search_engine_construct (GType object_type) {
	ZeitgeistSearchEngine * self = NULL;
	self = (ZeitgeistSearchEngine*) g_object_new (object_type, NULL);
	return self;
}


static ZeitgeistSearchEngine* zeitgeist_search_engine_new (void) {
	return zeitgeist_search_engine_construct (ZEITGEIST_TYPE_SEARCH_ENGINE);
}


static void zeitgeist_search_engine_proxy_not_present (ZeitgeistSearchEngine* self) {
	ZeitgeistMonitorManager* _tmp0_ = NULL;
	char* _tmp1_ = NULL;
	char* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->notifier;
	_tmp1_ = g_strdup (ZEITGEIST_SEARCH_ENGINE_INDEXER_NAME);
	_tmp2_ = _tmp1_;
	zeitgeist_monitor_manager_remove_monitor (_tmp0_, _tmp2_, "/org/gnome/zeitgeist/monitor/special");
	_g_free0 (_tmp2_);
	zeitgeist_extension_unload ((ZeitgeistExtension*) self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void zeitgeist_search_engine_proxy_acquired (ZeitgeistSearchEngine* self, GObject* obj, GAsyncResult* res) {
	GDBusConnection* conn = NULL;
	GObject* _tmp0_ = NULL;
	GDBusConnection* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (res != NULL);
	_tmp0_ = obj;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, G_TYPE_DBUS_CONNECTION) ? ((GDBusConnection*) _tmp0_) : NULL);
	conn = _tmp1_;
	{
		ZeitgeistRemoteSimpleIndexer* _tmp2_ = NULL;
		GAsyncResult* _tmp3_ = NULL;
		ZeitgeistRemoteSimpleIndexer* _tmp4_ = NULL;
		ZeitgeistRemoteSimpleIndexer* _tmp5_ = NULL;
		ZeitgeistRemoteSimpleIndexer* _tmp6_ = NULL;
		ZeitgeistRemoteSimpleIndexer* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gboolean _tmp11_ = FALSE;
		_tmp3_ = res;
		_tmp4_ = g_async_result_get_source_object (_tmp3_);
		_tmp5_ = g_async_initable_new_finish (_tmp4_, _tmp3_, &_inner_error_);
		g_object_unref (_tmp4_);
		_tmp2_ = (ZeitgeistRemoteSimpleIndexer*) _tmp5_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			_g_object_unref0 (conn);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp6_ = _tmp2_;
		_tmp2_ = NULL;
		_g_object_unref0 (self->priv->siin);
		self->priv->siin = _tmp6_;
		_tmp7_ = self->priv->siin;
		g_object_get (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, G_TYPE_DBUS_PROXY) ? ((GDBusProxy*) _tmp7_) : NULL, "g-name-owner", &_tmp8_, NULL);
		_tmp9_ = _tmp8_;
		_tmp10_ = _tmp9_;
		_tmp11_ = _tmp10_ == NULL;
		_g_free0 (_tmp10_);
		if (_tmp11_) {
			zeitgeist_search_engine_proxy_not_present (self);
			self->priv->siin_connection_failed = TRUE;
		} else {
			self->priv->siin_connection_failed = FALSE;
		}
		_g_object_unref0 (_tmp2_);
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		GError* err = NULL;
		GError* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		self->priv->siin_connection_failed = TRUE;
		_tmp12_ = err;
		_tmp13_ = _tmp12_->message;
		g_warning ("fts.vala:136: %s", _tmp13_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (conn);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (conn);
}


static void zeitgeist_search_engine_wait_for_proxy_data_free (gpointer _data) {
	ZeitgeistSearchEngineWaitForProxyData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ZeitgeistSearchEngineWaitForProxyData, _data_);
}


void zeitgeist_search_engine_wait_for_proxy (ZeitgeistSearchEngine* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ZeitgeistSearchEngineWaitForProxyData* _data_;
	ZeitgeistSearchEngine* _tmp0_ = NULL;
	_data_ = g_slice_new0 (ZeitgeistSearchEngineWaitForProxyData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, zeitgeist_search_engine_wait_for_proxy);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, zeitgeist_search_engine_wait_for_proxy_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	zeitgeist_search_engine_wait_for_proxy_co (_data_);
}


void zeitgeist_search_engine_wait_for_proxy_finish (ZeitgeistSearchEngine* self, GAsyncResult* _res_, GError** error) {
	ZeitgeistSearchEngineWaitForProxyData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean _zeitgeist_search_engine_wait_for_proxy_co_gsource_func (gpointer self) {
	gboolean result;
	result = zeitgeist_search_engine_wait_for_proxy_co (self);
	return result;
}


static gboolean zeitgeist_search_engine_wait_for_proxy_co (ZeitgeistSearchEngineWaitForProxyData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->i = 0;
	while (TRUE) {
		_data_->_tmp2_ = NULL;
		_data_->_tmp2_ = _data_->self->priv->siin;
		if (_data_->_tmp2_ == NULL) {
			_data_->_tmp3_ = 0;
			_data_->_tmp3_ = _data_->i;
			_data_->_tmp1_ = _data_->_tmp3_ < 6;
		} else {
			_data_->_tmp1_ = FALSE;
		}
		if (_data_->_tmp1_) {
			_data_->_tmp4_ = FALSE;
			_data_->_tmp4_ = _data_->self->priv->siin_connection_failed;
			_data_->_tmp0_ = !_data_->_tmp4_;
		} else {
			_data_->_tmp0_ = FALSE;
		}
		if (!_data_->_tmp0_) {
			break;
		}
		g_timeout_add_full (G_PRIORITY_DEFAULT_IDLE, (guint) 250, _zeitgeist_search_engine_wait_for_proxy_co_gsource_func, _data_, NULL);
		_data_->_tmp5_ = 0;
		_data_->_tmp5_ = _data_->i;
		_data_->i = _data_->_tmp5_ + 1;
		_data_->_state_ = 1;
		return FALSE;
		_state_1:
		;
	}
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = _data_->self->priv->siin;
	if (_data_->_tmp7_ == NULL) {
		_data_->_tmp6_ = TRUE;
	} else {
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = _data_->self->priv->siin;
		_data_->_tmp6_ = !G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp8_, G_TYPE_DBUS_PROXY);
	}
	if (_data_->_tmp6_) {
		_data_->_tmp9_ = NULL;
		_data_->_tmp9_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_DATABASE_ERROR, "Not connected to SimpleIndexer");
		_data_->_inner_error_ = _data_->_tmp9_;
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void zeitgeist_search_engine_real_unload (ZeitgeistExtension* base) {
	ZeitgeistSearchEngine * self;
	guint _tmp5_ = 0U;
	GError * _inner_error_ = NULL;
	self = (ZeitgeistSearchEngine*) base;
	{
		GDBusConnection* connection = NULL;
		GDBusConnection* _tmp0_ = NULL;
		guint _tmp1_ = 0U;
		_tmp0_ = g_bus_get_sync (G_BUS_TYPE_SESSION, NULL, &_inner_error_);
		connection = _tmp0_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch1_g_error;
		}
		_tmp1_ = self->priv->registration_id;
		if (_tmp1_ != ((guint) 0)) {
			guint _tmp2_ = 0U;
			_tmp2_ = self->priv->registration_id;
			g_dbus_connection_unregister_object (connection, _tmp2_);
			self->priv->registration_id = (guint) 0;
		}
		_g_object_unref0 (connection);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = err;
		_tmp4_ = _tmp3_->message;
		g_warning ("fts.vala:172: %s", _tmp4_);
		_g_error_free0 (err);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp5_ = ((GObject*) self)->ref_count;
	g_debug ("fts.vala:175: %s, this.ref_count = %u", "Zeitgeist.SearchEngine.unload", _tmp5_);
}


static void zeitgeist_search_engine_real_search_data_free (gpointer _data) {
	ZeitgeistSearchEngineSearchData* _data_;
	_data_ = _data;
	_g_free0 (_data_->query_string);
	_g_variant_unref0 (_data_->time_range);
	_g_variant_unref0 (_data_->filter_templates);
	_g_object_unref0 (_data_->self);
	g_slice_free (ZeitgeistSearchEngineSearchData, _data_);
}


static gpointer _g_variant_ref0 (gpointer self) {
	return self ? g_variant_ref (self) : NULL;
}


static void zeitgeist_search_engine_real_search (ZeitgeistRemoteSearchEngine* base, const gchar* query_string, GVariant* time_range, GVariant* filter_templates, guint offset, guint count, guint result_type, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ZeitgeistSearchEngine * self;
	ZeitgeistSearchEngineSearchData* _data_;
	ZeitgeistSearchEngine* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GVariant* _tmp3_ = NULL;
	GVariant* _tmp4_ = NULL;
	GVariant* _tmp5_ = NULL;
	GVariant* _tmp6_ = NULL;
	guint _tmp7_ = 0U;
	guint _tmp8_ = 0U;
	guint _tmp9_ = 0U;
	self = (ZeitgeistSearchEngine*) base;
	_data_ = g_slice_new0 (ZeitgeistSearchEngineSearchData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, zeitgeist_search_engine_real_search);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, zeitgeist_search_engine_real_search_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = query_string;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (_data_->query_string);
	_data_->query_string = _tmp2_;
	_tmp3_ = time_range;
	_tmp4_ = _g_variant_ref0 (_tmp3_);
	_g_variant_unref0 (_data_->time_range);
	_data_->time_range = _tmp4_;
	_tmp5_ = filter_templates;
	_tmp6_ = _g_variant_ref0 (_tmp5_);
	_g_variant_unref0 (_data_->filter_templates);
	_data_->filter_templates = _tmp6_;
	_tmp7_ = offset;
	_data_->offset = _tmp7_;
	_tmp8_ = count;
	_data_->count = _tmp8_;
	_tmp9_ = result_type;
	_data_->result_type = _tmp9_;
	zeitgeist_search_engine_real_search_co (_data_);
}


static void zeitgeist_search_engine_real_search_finish (ZeitgeistRemoteSearchEngine* base, GAsyncResult* _res_, GVariant** events, guint* matches, GError** error) {
	ZeitgeistSearchEngineSearchData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	if (events) {
		*events = _data_->events;
	} else {
		_g_variant_unref0 (_data_->events);
	}
	_data_->events = NULL;
	if (matches) {
		*matches = _data_->matches;
	}
}


static void zeitgeist_search_engine_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	ZeitgeistSearchEngineSearchData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	zeitgeist_search_engine_real_search_co (_data_);
}


static gboolean zeitgeist_search_engine_real_search_co (ZeitgeistSearchEngineSearchData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->self->priv->siin;
	if (_data_->_tmp0_ == NULL) {
		_data_->_state_ = 1;
		zeitgeist_search_engine_wait_for_proxy (_data_->self, zeitgeist_search_engine_search_ready, _data_);
		return FALSE;
		_state_1:
		zeitgeist_search_engine_wait_for_proxy_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = g_timer_new ();
	_data_->timer = _data_->_tmp1_;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->self->priv->siin;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->query_string;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = _data_->time_range;
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = _data_->filter_templates;
	_data_->_tmp6_ = 0U;
	_data_->_tmp6_ = _data_->offset;
	_data_->_tmp7_ = 0U;
	_data_->_tmp7_ = _data_->count;
	_data_->_tmp8_ = 0U;
	_data_->_tmp8_ = _data_->result_type;
	_data_->_tmp9_ = NULL;
	_data_->_tmp10_ = 0U;
	_data_->_state_ = 2;
	zeitgeist_remote_simple_indexer_search (_data_->_tmp2_, _data_->_tmp3_, _data_->_tmp4_, _data_->_tmp5_, _data_->_tmp6_, _data_->_tmp7_, _data_->_tmp8_, NULL, zeitgeist_search_engine_search_ready, _data_);
	return FALSE;
	_state_2:
	zeitgeist_remote_simple_indexer_search_finish (_data_->_tmp2_, _data_->_res_, &_data_->_tmp9_, &_data_->_tmp10_, &_data_->_inner_error_);
	_g_variant_unref0 (_data_->events);
	_data_->events = _data_->_tmp9_;
	_data_->matches = _data_->_tmp10_;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_timer_destroy0 (_data_->timer);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp11_ = NULL;
	_data_->_tmp11_ = _data_->events;
	_data_->_tmp12_ = 0UL;
	_data_->_tmp12_ = g_variant_n_children (_data_->_tmp11_);
	_data_->_tmp13_ = 0U;
	_data_->_tmp13_ = _data_->matches;
	_data_->_tmp14_ = NULL;
	_data_->_tmp14_ = _data_->timer;
	_data_->_tmp15_ = 0.0;
	_data_->_tmp15_ = g_timer_elapsed (_data_->_tmp14_, NULL);
	g_debug ("fts.vala:188: Got %u[/%u] results from indexer (in %f seconds)", (guint) _data_->_tmp12_, _data_->_tmp13_, _data_->_tmp15_);
	_g_timer_destroy0 (_data_->timer);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void zeitgeist_search_engine_real_search_with_relevancies_data_free (gpointer _data) {
	ZeitgeistSearchEngineSearchWithRelevanciesData* _data_;
	_data_ = _data;
	_g_free0 (_data_->query_string);
	_g_variant_unref0 (_data_->time_range);
	_g_variant_unref0 (_data_->filter_templates);
	_g_object_unref0 (_data_->self);
	g_slice_free (ZeitgeistSearchEngineSearchWithRelevanciesData, _data_);
}


static void zeitgeist_search_engine_real_search_with_relevancies (ZeitgeistRemoteSearchEngine* base, const gchar* query_string, GVariant* time_range, GVariant* filter_templates, guint storage_state, guint offset, guint count, guint result_type, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ZeitgeistSearchEngine * self;
	ZeitgeistSearchEngineSearchWithRelevanciesData* _data_;
	ZeitgeistSearchEngine* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GVariant* _tmp3_ = NULL;
	GVariant* _tmp4_ = NULL;
	GVariant* _tmp5_ = NULL;
	GVariant* _tmp6_ = NULL;
	guint _tmp7_ = 0U;
	guint _tmp8_ = 0U;
	guint _tmp9_ = 0U;
	guint _tmp10_ = 0U;
	self = (ZeitgeistSearchEngine*) base;
	_data_ = g_slice_new0 (ZeitgeistSearchEngineSearchWithRelevanciesData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, zeitgeist_search_engine_real_search_with_relevancies);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, zeitgeist_search_engine_real_search_with_relevancies_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = query_string;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (_data_->query_string);
	_data_->query_string = _tmp2_;
	_tmp3_ = time_range;
	_tmp4_ = _g_variant_ref0 (_tmp3_);
	_g_variant_unref0 (_data_->time_range);
	_data_->time_range = _tmp4_;
	_tmp5_ = filter_templates;
	_tmp6_ = _g_variant_ref0 (_tmp5_);
	_g_variant_unref0 (_data_->filter_templates);
	_data_->filter_templates = _tmp6_;
	_tmp7_ = storage_state;
	_data_->storage_state = _tmp7_;
	_tmp8_ = offset;
	_data_->offset = _tmp8_;
	_tmp9_ = count;
	_data_->count = _tmp9_;
	_tmp10_ = result_type;
	_data_->result_type = _tmp10_;
	zeitgeist_search_engine_real_search_with_relevancies_co (_data_);
}


static void zeitgeist_search_engine_real_search_with_relevancies_finish (ZeitgeistRemoteSearchEngine* base, GAsyncResult* _res_, GVariant** events, gdouble** relevancies, int* relevancies_length1, guint* matches, GError** error) {
	ZeitgeistSearchEngineSearchWithRelevanciesData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	if (events) {
		*events = _data_->events;
	} else {
		_g_variant_unref0 (_data_->events);
	}
	_data_->events = NULL;
	if (relevancies) {
		*relevancies = _data_->relevancies;
	} else {
		_data_->relevancies = (g_free (_data_->relevancies), NULL);
	}
	if (relevancies_length1) {
		*relevancies_length1 = _data_->relevancies_length1;
	}
	_data_->relevancies = NULL;
	if (matches) {
		*matches = _data_->matches;
	}
}


static void zeitgeist_search_engine_search_with_relevancies_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	ZeitgeistSearchEngineSearchWithRelevanciesData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	zeitgeist_search_engine_real_search_with_relevancies_co (_data_);
}


static gboolean zeitgeist_search_engine_real_search_with_relevancies_co (ZeitgeistSearchEngineSearchWithRelevanciesData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->self->priv->siin;
	if (_data_->_tmp0_ == NULL) {
		_data_->_state_ = 1;
		zeitgeist_search_engine_wait_for_proxy (_data_->self, zeitgeist_search_engine_search_with_relevancies_ready, _data_);
		return FALSE;
		_state_1:
		zeitgeist_search_engine_wait_for_proxy_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = g_timer_new ();
	_data_->timer = _data_->_tmp1_;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->self->priv->siin;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->query_string;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = _data_->time_range;
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = _data_->filter_templates;
	_data_->_tmp6_ = 0U;
	_data_->_tmp6_ = _data_->storage_state;
	_data_->_tmp7_ = 0U;
	_data_->_tmp7_ = _data_->offset;
	_data_->_tmp8_ = 0U;
	_data_->_tmp8_ = _data_->count;
	_data_->_tmp9_ = 0U;
	_data_->_tmp9_ = _data_->result_type;
	_data_->_tmp10_ = NULL;
	_data_->_tmp11_ = NULL;
	_data_->_tmp12_ = 0;
	_data_->_tmp13_ = 0U;
	_data_->_state_ = 2;
	zeitgeist_remote_simple_indexer_search_with_relevancies (_data_->_tmp2_, _data_->_tmp3_, _data_->_tmp4_, _data_->_tmp5_, _data_->_tmp6_, _data_->_tmp7_, _data_->_tmp8_, _data_->_tmp9_, NULL, zeitgeist_search_engine_search_with_relevancies_ready, _data_);
	return FALSE;
	_state_2:
	zeitgeist_remote_simple_indexer_search_with_relevancies_finish (_data_->_tmp2_, _data_->_res_, &_data_->_tmp10_, &_data_->_tmp11_, &_data_->_tmp12_, &_data_->_tmp13_, &_data_->_inner_error_);
	_g_variant_unref0 (_data_->events);
	_data_->events = _data_->_tmp10_;
	_data_->relevancies = (g_free (_data_->relevancies), NULL);
	_data_->relevancies = _data_->_tmp11_;
	_data_->relevancies_length1 = _data_->_tmp12_;
	_data_->matches = _data_->_tmp13_;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_timer_destroy0 (_data_->timer);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp14_ = NULL;
	_data_->_tmp14_ = _data_->events;
	_data_->_tmp15_ = 0UL;
	_data_->_tmp15_ = g_variant_n_children (_data_->_tmp14_);
	_data_->_tmp16_ = 0U;
	_data_->_tmp16_ = _data_->matches;
	_data_->_tmp17_ = NULL;
	_data_->_tmp17_ = _data_->timer;
	_data_->_tmp18_ = 0.0;
	_data_->_tmp18_ = g_timer_elapsed (_data_->_tmp17_, NULL);
	g_debug ("fts.vala:207: Got %u[/%u] results from indexer (in %f seconds)", (guint) _data_->_tmp15_, _data_->_tmp16_, _data_->_tmp18_);
	_g_timer_destroy0 (_data_->timer);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static GVariant* _variant_new1 (GHashTable* value) {
	GVariantBuilder _tmp22_;
	GHashTableIter _tmp23_;
	gpointer _tmp24_;
	gpointer _tmp25_;
	g_hash_table_iter_init (&_tmp23_, value);
	g_variant_builder_init (&_tmp22_, G_VARIANT_TYPE ("a{ss}"));
	while (g_hash_table_iter_next (&_tmp23_, &_tmp24_, &_tmp25_)) {
		gchar* _key;
		gchar* _value;
		_key = (gchar*) _tmp24_;
		_value = (gchar*) _tmp25_;
		g_variant_builder_add (&_tmp22_, "{?*}", g_variant_new_string (_key), g_variant_new_string (_value));
	}
	return g_variant_ref_sink (g_variant_builder_end (&_tmp22_));
}


static void _zeitgeist_search_engine_proxy_acquired_gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	zeitgeist_search_engine_proxy_acquired ((ZeitgeistSearchEngine*) self, source_object, res);
	g_object_unref (self);
}


static GObject * zeitgeist_search_engine_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	ZeitgeistSearchEngine * self;
	gboolean _tmp0_ = FALSE;
	ZeitgeistMonitorManager* _tmp1_ = NULL;
	ZeitgeistMonitorManager* _tmp2_ = NULL;
	char* _tmp3_ = NULL;
	char* _tmp4_ = NULL;
	ZeitgeistTimeRange* _tmp5_ = NULL;
	ZeitgeistTimeRange* _tmp6_ = NULL;
	GPtrArray* _tmp7_ = NULL;
	GPtrArray* _tmp8_ = NULL;
	GError * _inner_error_ = NULL;
	parent_class = G_OBJECT_CLASS (zeitgeist_search_engine_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZEITGEIST_TYPE_SEARCH_ENGINE, ZeitgeistSearchEngine);
	_tmp0_ = zeitgeist_utils_using_in_memory_database ();
	if (_tmp0_) {
		return obj;
	}
	_tmp1_ = zeitgeist_monitor_manager_get_default ();
	_g_object_unref0 (self->priv->notifier);
	self->priv->notifier = _tmp1_;
	_tmp2_ = self->priv->notifier;
	_tmp3_ = g_strdup (ZEITGEIST_SEARCH_ENGINE_INDEXER_NAME);
	_tmp4_ = _tmp3_;
	_tmp5_ = zeitgeist_time_range_new_anytime ();
	_tmp6_ = _tmp5_;
	_tmp7_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
	_tmp8_ = _tmp7_;
	zeitgeist_monitor_manager_install_monitor (_tmp2_, _tmp4_, "/org/gnome/zeitgeist/monitor/special", _tmp6_, _tmp8_);
	_g_ptr_array_unref0 (_tmp8_);
	_g_object_unref0 (_tmp6_);
	_g_free0 (_tmp4_);
	{
		GDBusConnection* connection = NULL;
		GDBusConnection* _tmp9_ = NULL;
		guint _tmp10_ = 0U;
		GDBusConnection* _tmp11_ = NULL;
		guint _tmp12_ = 0U;
		GDBusConnection* _tmp31_ = NULL;
		_tmp9_ = g_bus_get_sync (G_BUS_TYPE_SESSION, NULL, &_inner_error_);
		connection = _tmp9_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch2_g_error;
		}
		_tmp11_ = connection;
		_tmp12_ = zeitgeist_remote_search_engine_register_object ((ZeitgeistRemoteSearchEngine*) self, _tmp11_, "/org/gnome/zeitgeist/index/activity", &_inner_error_);
		_tmp10_ = _tmp12_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (connection);
			goto __catch2_g_error;
		}
		self->priv->registration_id = _tmp10_;
		{
			GHashTable* env = NULL;
			GHashFunc _tmp13_ = NULL;
			GEqualFunc _tmp14_ = NULL;
			GHashTable* _tmp15_ = NULL;
			GHashTable* _tmp16_ = NULL;
			gchar* _tmp17_ = NULL;
			const gchar* _tmp18_ = NULL;
			gchar* _tmp19_ = NULL;
			GDBusConnection* _tmp20_ = NULL;
			GHashTable* _tmp21_ = NULL;
			GVariant* _tmp26_ = NULL;
			GVariant** _tmp27_ = NULL;
			GVariant** _tmp28_ = NULL;
			gint _tmp28__length1 = 0;
			GVariant* _tmp29_ = NULL;
			GVariant* _tmp30_ = NULL;
			_tmp13_ = g_str_hash;
			_tmp14_ = g_str_equal;
			_tmp15_ = g_hash_table_new_full (_tmp13_, _tmp14_, _g_free0_, _g_free0_);
			env = _tmp15_;
			_tmp16_ = env;
			_tmp17_ = g_strdup ("ZEITGEIST_DATA_PATH");
			_tmp18_ = zeitgeist_utils_get_data_path ();
			_tmp19_ = g_strdup (_tmp18_);
			g_hash_table_insert (_tmp16_, _tmp17_, _tmp19_);
			_tmp20_ = connection;
			_tmp21_ = env;
			_tmp26_ = _variant_new1 (_tmp21_);
			_tmp27_ = g_new0 (GVariant*, 1 + 1);
			_tmp27_[0] = _tmp26_;
			_tmp28_ = _tmp27_;
			_tmp28__length1 = 1;
			_tmp29_ = g_variant_new_tuple (_tmp28_, 1);
			g_variant_ref_sink (_tmp29_);
			_tmp30_ = _tmp29_;
			g_dbus_connection_call (_tmp20_, "org.freedesktop.DBus", "/org/freedesktop/DBus", "org.freedesktop.DBus", "UpdateActivationEnvironment", _tmp30_, NULL, 0, -1, NULL, NULL, NULL);
			_g_variant_unref0 (_tmp30_);
			_tmp28_ = (_vala_array_free (_tmp28_, _tmp28__length1, (GDestroyNotify) g_variant_unref), NULL);
			_g_hash_table_unref0 (env);
		}
		goto __finally3;
		__catch3_g_error:
		{
			GError* err = NULL;
			err = _inner_error_;
			_inner_error_ = NULL;
			g_warning ("fts.vala:95: Unable to set environment for FTS daemon!");
			_g_error_free0 (err);
		}
		__finally3:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (connection);
			goto __catch2_g_error;
		}
		_tmp31_ = connection;
		g_async_initable_new_async (ZEITGEIST_TYPE_REMOTE_SIMPLE_INDEXER_PROXY, 0, NULL, _zeitgeist_search_engine_proxy_acquired_gasync_ready_callback, g_object_ref (self), "g-flags", 0, "g-name", ZEITGEIST_SEARCH_ENGINE_INDEXER_NAME, "g-connection", _tmp31_, "g-object-path", "/org/gnome/zeitgeist/index/activity", "g-interface-name", "org.gnome.zeitgeist.Index", "g-interface-info", g_type_get_qdata (ZEITGEIST_TYPE_REMOTE_SIMPLE_INDEXER, g_quark_from_static_string ("vala-dbus-interface-info")), NULL);
		_g_object_unref0 (connection);
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* err = NULL;
		GError* _tmp32_ = NULL;
		const gchar* _tmp33_ = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp32_ = err;
		_tmp33_ = _tmp32_->message;
		g_warning ("fts.vala:107: %s", _tmp33_);
		_g_error_free0 (err);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	return obj;
}


static void zeitgeist_search_engine_class_init (ZeitgeistSearchEngineClass * klass) {
	zeitgeist_search_engine_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ZeitgeistSearchEnginePrivate));
	((ZeitgeistExtensionClass *) klass)->unload = zeitgeist_search_engine_real_unload;
	G_OBJECT_CLASS (klass)->constructor = zeitgeist_search_engine_constructor;
	G_OBJECT_CLASS (klass)->finalize = zeitgeist_search_engine_finalize;
}


static void zeitgeist_search_engine_zeitgeist_remote_search_engine_interface_init (ZeitgeistRemoteSearchEngineIface * iface) {
	zeitgeist_search_engine_zeitgeist_remote_search_engine_parent_iface = g_type_interface_peek_parent (iface);
	iface->search = (void (*)(ZeitgeistRemoteSearchEngine*, const gchar*, GVariant*, GVariant*, guint, guint, guint, GVariant**, guint*, GError**)) zeitgeist_search_engine_real_search;
	iface->search_finish = zeitgeist_search_engine_real_search_finish;
	iface->search_with_relevancies = (void (*)(ZeitgeistRemoteSearchEngine*, const gchar*, GVariant*, GVariant*, guint, guint, guint, guint, GVariant**, gdouble**, int*, guint*, GError**)) zeitgeist_search_engine_real_search_with_relevancies;
	iface->search_with_relevancies_finish = zeitgeist_search_engine_real_search_with_relevancies_finish;
}


static void zeitgeist_search_engine_instance_init (ZeitgeistSearchEngine * self) {
	self->priv = ZEITGEIST_SEARCH_ENGINE_GET_PRIVATE (self);
	self->priv->siin_connection_failed = FALSE;
}


static void zeitgeist_search_engine_finalize (GObject* obj) {
	ZeitgeistSearchEngine * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZEITGEIST_TYPE_SEARCH_ENGINE, ZeitgeistSearchEngine);
	_g_object_unref0 (self->priv->siin);
	_g_object_unref0 (self->priv->notifier);
	G_OBJECT_CLASS (zeitgeist_search_engine_parent_class)->finalize (obj);
}


GType zeitgeist_search_engine_get_type (void) {
	return zeitgeist_search_engine_type_id;
}


GType zeitgeist_search_engine_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistSearchEngineClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zeitgeist_search_engine_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ZeitgeistSearchEngine), 0, (GInstanceInitFunc) zeitgeist_search_engine_instance_init, NULL };
	static const GInterfaceInfo zeitgeist_remote_search_engine_info = { (GInterfaceInitFunc) zeitgeist_search_engine_zeitgeist_remote_search_engine_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	zeitgeist_search_engine_type_id = g_type_module_register_type (module, ZEITGEIST_TYPE_EXTENSION, "ZeitgeistSearchEngine", &g_define_type_info, 0);
	g_type_module_add_interface (module, zeitgeist_search_engine_type_id, ZEITGEIST_TYPE_REMOTE_SEARCH_ENGINE, &zeitgeist_remote_search_engine_info);
	return zeitgeist_search_engine_type_id;
}


GType zeitgeist_extension_register (GTypeModule* module) {
	GType result = 0UL;
	g_return_val_if_fail (module != NULL, 0UL);
	zeitgeist_remote_search_engine_register_type (module);
	zeitgeist_remote_search_engine_proxy_register_dynamic_type (module);
	zeitgeist_search_engine_register_type (module);
	result = ZEITGEIST_TYPE_SEARCH_ENGINE;
	return result;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



