/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.Widget;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WidgetCollection
implements Iterable<Widget> {
    private static final int INITIAL_SIZE = 4;
    private Widget[] array;
    private HasWidgets parent;
    private int size;

    public WidgetCollection(HasWidgets parent) {
        this.parent = parent;
        this.array = new Widget[4];
    }

    public void add(Widget w) {
        this.insert(w, this.size);
    }

    public boolean contains(Widget w) {
        return this.indexOf(w) != -1;
    }

    public Widget get(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        return this.array[index];
    }

    public int indexOf(Widget w) {
        for (int i = 0; i < this.size; ++i) {
            if (this.array[i] != w) continue;
            return i;
        }
        return -1;
    }

    public void insert(Widget w, int beforeIndex) {
        if (beforeIndex < 0 || beforeIndex > this.size) {
            throw new IndexOutOfBoundsException();
        }
        if (this.size == this.array.length) {
            Widget[] newArray = new Widget[this.array.length * 2];
            for (int i = 0; i < this.array.length; ++i) {
                newArray[i] = this.array[i];
            }
            this.array = newArray;
        }
        ++this.size;
        for (int i = this.size - 1; i > beforeIndex; --i) {
            this.array[i] = this.array[i - 1];
        }
        this.array[beforeIndex] = w;
    }

    @Override
    public Iterator<Widget> iterator() {
        return new WidgetIterator();
    }

    public void remove(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        --this.size;
        for (int i = index; i < this.size; ++i) {
            this.array[i] = this.array[i + 1];
        }
        this.array[this.size] = null;
    }

    public void remove(Widget w) {
        int index = this.indexOf(w);
        if (index == -1) {
            throw new NoSuchElementException();
        }
        this.remove(index);
    }

    public int size() {
        return this.size;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class WidgetIterator
    implements Iterator<Widget> {
        private int index = -1;

        private WidgetIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < WidgetCollection.this.size - 1;
        }

        @Override
        public Widget next() {
            if (this.index >= WidgetCollection.this.size) {
                throw new NoSuchElementException();
            }
            return WidgetCollection.this.array[++this.index];
        }

        @Override
        public void remove() {
            if (this.index < 0 || this.index >= WidgetCollection.this.size) {
                throw new IllegalStateException();
            }
            WidgetCollection.this.parent.remove(WidgetCollection.this.array[this.index--]);
        }
    }
}

