/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.resources.css;

import com.google.gwt.resources.css.ast.Context;
import com.google.gwt.resources.css.ast.CssExternalSelectors;
import com.google.gwt.resources.css.ast.CssSelector;
import com.google.gwt.resources.css.ast.CssVisitor;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalClassesCollector
extends CssVisitor {
    public static final String GLOB_STRING = "*";
    private final SortedSet<String> allClasses = new TreeSet<String>();
    private final SortedSet<String> externalClasses = new TreeSet<String>();
    private final Set<String> globs = new HashSet<String>();
    private boolean matchAll;

    @Override
    public void endVisit(CssExternalSelectors x, Context ctx) {
        if (this.matchAll) {
            return;
        }
        for (String selector : x.getClasses()) {
            if (selector.equals(GLOB_STRING)) {
                this.matchAll = true;
                return;
            }
            if (selector.endsWith(GLOB_STRING)) {
                this.globs.add(selector.substring(0, selector.length() - 1));
                continue;
            }
            this.externalClasses.add(selector);
        }
    }

    @Override
    public void endVisit(CssSelector x, Context ctx) {
        Matcher m = CssSelector.CLASS_SELECTOR_PATTERN.matcher(x.getSelector());
        while (m.find()) {
            this.allClasses.add(m.group(1));
        }
    }

    public SortedSet<String> getClasses() {
        if (this.matchAll) {
            return this.allClasses;
        }
        for (String glob : this.globs) {
            String clazz;
            Iterator i$ = this.allClasses.tailSet(glob).iterator();
            while (i$.hasNext() && (clazz = (String)i$.next()).startsWith(glob)) {
                this.externalClasses.add(clazz);
            }
        }
        return this.externalClasses;
    }
}

