/*
 * Decompiled with CFR 0.152.
 */
package com.google.web.bindery.autobean.shared.impl;

import com.google.web.bindery.autobean.shared.Splittable;
import com.google.web.bindery.autobean.shared.impl.AutoBeanCodexImpl;
import com.google.web.bindery.autobean.shared.impl.HasSplittable;
import java.util.AbstractList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SplittableList<E>
extends AbstractList<E>
implements HasSplittable {
    private Splittable data;
    private final AutoBeanCodexImpl.Coder elementCoder;
    private final AutoBeanCodexImpl.EncodeState state;

    static <Q> Q reify(AutoBeanCodexImpl.EncodeState state, Splittable data, int index, AutoBeanCodexImpl.Coder coder) {
        if (data.isNull(index)) {
            return null;
        }
        Object toReturn = coder.decode(state, data.get(index));
        data.setReified(String.valueOf(index), toReturn);
        return (Q)toReturn;
    }

    static void set(AutoBeanCodexImpl.EncodeState state, Splittable data, int index, AutoBeanCodexImpl.Coder coder, Object value) {
        data.setReified(String.valueOf(index), value);
        if (value == null) {
            Splittable.NULL.assign(data, index);
            return;
        }
        Splittable backing = coder.extractSplittable(state, value);
        if (backing == null) {
            data.setReified("__unsplittableValues", true);
        } else {
            backing.assign(data, index);
        }
    }

    public SplittableList(Splittable data, AutoBeanCodexImpl.Coder elementCoder, AutoBeanCodexImpl.EncodeState state) {
        assert (data.isIndexed()) : "Expecting indexed data";
        this.data = data;
        this.elementCoder = elementCoder;
        this.state = state;
    }

    @Override
    public void add(int index, E element) {
        SplittableList.set(this.state, this.data, index, this.elementCoder, element);
    }

    @Override
    public E get(int index) {
        if (this.data.isReified(String.valueOf(index))) {
            Object toReturn = this.data.getReified(String.valueOf(index));
            return (E)toReturn;
        }
        return (E)SplittableList.reify(this.state, this.data, index, this.elementCoder);
    }

    @Override
    public Splittable getSplittable() {
        return this.data;
    }

    @Override
    public E remove(int index) {
        E toReturn = this.get(index);
        int newSize = this.data.size() - 1;
        for (int i = index; i < newSize; ++i) {
            this.data.get(i + 1).assign(this.data, i);
            this.data.setReified(String.valueOf(i), this.data.getReified(String.valueOf(i + 1)));
        }
        this.data.setSize(newSize);
        return toReturn;
    }

    @Override
    public E set(int index, E element) {
        E previous = this.get(index);
        SplittableList.set(this.state, this.data, index, this.elementCoder, element);
        return previous;
    }

    @Override
    public int size() {
        return this.data.size();
    }
}

