/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.util.StringTokenizer;
import java.util.regex.Pattern;
import net.sf.saxon.Configuration;
import net.sf.saxon.om.Name11Checker;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;

public class SaxonOutputKeys {
    public static final String SAXON_XQUERY_METHOD = "{http://saxon.sf.net/}xquery";
    public static final String INDENT_SPACES = "{http://saxon.sf.net/}indent-spaces";
    public static final String SUPPRESS_INDENTATION = "{http://saxon.sf.net/}suppress-indentation";
    public static final String DOUBLE_SPACE = "{http://saxon.sf.net/}double-space";
    public static final String STYLESHEET_VERSION = "{http://saxon.sf.net/}stylesheet-version";
    public static final String USE_CHARACTER_MAPS = "use-character-maps";
    public static final String INCLUDE_CONTENT_TYPE = "include-content-type";
    public static final String UNDECLARE_PREFIXES = "undeclare-prefixes";
    public static final String ESCAPE_URI_ATTRIBUTES = "escape-uri-attributes";
    public static final String CHARACTER_REPRESENTATION = "{http://saxon.sf.net/}character-representation";
    public static final String NEXT_IN_CHAIN = "{http://saxon.sf.net/}next-in-chain";
    public static final String NEXT_IN_CHAIN_BASE_URI = "{http://saxon.sf.net/}next-in-chain-base-uri";
    public static final String BYTE_ORDER_MARK = "byte-order-mark";
    public static final String NORMALIZATION_FORM = "normalization-form";
    public static final String RECOGNIZE_BINARY = "{http://saxon.sf.net/}recognize-binary";
    public static final String REQUIRE_WELL_FORMED = "{http://saxon.sf.net/}require-well-formed";
    public static final String SUPPLY_SOURCE_LOCATOR = "{http://saxon.sf.net/}supply-source-locator";
    public static final String WRAP = "{http://saxon.sf.net/}wrap-result-sequence";
    public static final String IMPLICIT_RESULT_DOCUMENT = "{http://saxon.sf.net/}implicit-result-document";
    private static Pattern publicIdPattern = Pattern.compile("^[\\s\\r\\na-zA-Z0-9\\-'()+,./:=?;!*#@$_%]*$");

    private SaxonOutputKeys() {
    }

    public static void checkOutputProperty(String key, String value, Configuration config) throws XPathException {
        NameChecker checker;
        NameChecker nameChecker = checker = config == null ? new Name11Checker() : config.getNameChecker();
        if (!key.startsWith("{") || key.startsWith("{http://saxon.sf.net/}")) {
            if (key.equals(BYTE_ORDER_MARK)) {
                if (value != null) {
                    SaxonOutputKeys.checkYesOrNo(key, value);
                }
            } else if (key.equals("cdata-section-elements")) {
                if (value != null) {
                    SaxonOutputKeys.checkListOfClarkNames(key, value, checker);
                }
            } else if (key.equals("doctype-public")) {
                if (value != null) {
                    SaxonOutputKeys.checkPublicIdentifier(value);
                }
            } else if (key.equals("doctype-system")) {
                if (value != null) {
                    SaxonOutputKeys.checkSystemIdentifier(value);
                }
            } else if (!key.equals("encoding")) {
                if (key.equals(ESCAPE_URI_ATTRIBUTES) || key.equals("escape-uri-attibutes")) {
                    if (value != null) {
                        SaxonOutputKeys.checkYesOrNo(key, value);
                    }
                } else if (key.equals(INCLUDE_CONTENT_TYPE)) {
                    if (value != null) {
                        SaxonOutputKeys.checkYesOrNo(key, value);
                    }
                } else if (key.equals("indent")) {
                    if (value != null) {
                        SaxonOutputKeys.checkYesOrNo(key, value);
                    }
                } else if (!key.equals("media-type")) {
                    if (key.equals("method")) {
                        if (value != null) {
                            SaxonOutputKeys.checkMethod(value, config, checker);
                        }
                    } else if (key.equals(NORMALIZATION_FORM)) {
                        if (value != null) {
                            SaxonOutputKeys.checkNormalizationForm(value, checker);
                        }
                    } else if (key.equals("omit-xml-declaration")) {
                        if (value != null) {
                            SaxonOutputKeys.checkYesOrNo(key, value);
                        }
                    } else if (key.equals("standalone")) {
                        if (value != null && !value.equals("omit")) {
                            SaxonOutputKeys.checkYesOrNo(key, value);
                        }
                    } else if (key.equals(UNDECLARE_PREFIXES)) {
                        if (value != null) {
                            SaxonOutputKeys.checkYesOrNo(key, value);
                        }
                    } else if (key.equals(USE_CHARACTER_MAPS)) {
                        if (value != null) {
                            SaxonOutputKeys.checkListOfClarkNames(key, value, checker);
                        }
                    } else if (!key.equals("version") && !key.equals(STYLESHEET_VERSION)) {
                        if (key.equals(INDENT_SPACES)) {
                            if (value != null) {
                                SaxonOutputKeys.checkExtensions(key, config);
                                SaxonOutputKeys.checkNonNegativeInteger(key, value);
                            }
                        } else if (key.equals(CHARACTER_REPRESENTATION)) {
                            SaxonOutputKeys.checkExtensions(key, config);
                        } else if (key.equals(NEXT_IN_CHAIN)) {
                            SaxonOutputKeys.checkExtensions(key, config);
                        } else if (!key.equals(NEXT_IN_CHAIN_BASE_URI)) {
                            if (key.equals(REQUIRE_WELL_FORMED)) {
                                if (value != null) {
                                    SaxonOutputKeys.checkYesOrNo(key, value);
                                }
                            } else if (key.equals(RECOGNIZE_BINARY)) {
                                if (value != null) {
                                    SaxonOutputKeys.checkExtensions(key, config);
                                    SaxonOutputKeys.checkYesOrNo(key, value);
                                }
                            } else if (key.equals(SUPPRESS_INDENTATION)) {
                                if (value != null) {
                                    SaxonOutputKeys.checkExtensions(key, config);
                                    SaxonOutputKeys.checkListOfClarkNames(key, value, checker);
                                }
                            } else if (key.equals(DOUBLE_SPACE)) {
                                if (value != null) {
                                    SaxonOutputKeys.checkExtensions(key, config);
                                    SaxonOutputKeys.checkListOfClarkNames(key, value, checker);
                                }
                            } else if (key.equals(WRAP)) {
                                if (value != null) {
                                    SaxonOutputKeys.checkExtensions(key, config);
                                    SaxonOutputKeys.checkYesOrNo(key, value);
                                }
                            } else if (key.equals(SUPPLY_SOURCE_LOCATOR)) {
                                if (value != null) {
                                    SaxonOutputKeys.checkYesOrNo(key, value);
                                }
                            } else {
                                throw new XPathException("Unknown serialization parameter " + Err.wrap(key));
                            }
                        }
                    }
                }
            }
        }
    }

    private static void checkExtensions(String key, Configuration config) throws XPathException {
        if (config != null && !config.isLicensedFeature(8)) {
            throw new XPathException("Serialization parameter " + Err.wrap(key) + " is not available in Saxon-HE");
        }
    }

    private static void checkYesOrNo(String key, String value) throws XPathException {
        if (!"yes".equals(value) && !"no".equals(value)) {
            throw new XPathException("Serialization parameter " + Err.wrap(key) + " must have the value yes or no");
        }
    }

    private static void checkMethod(String value, Configuration config, NameChecker checker) throws XPathException {
        if ("xml".equals(value)) {
            return;
        }
        if ("html".equals(value)) {
            return;
        }
        if ("xhtml".equals(value)) {
            return;
        }
        if ("text".equals(value)) {
            return;
        }
        if (!SaxonOutputKeys.isValidClarkName(value, checker)) {
            throw new XPathException("Invalid value for serialization method: must be xml, html, xhtml, text, or a QName in '{uri}local' form");
        }
        SaxonOutputKeys.checkExtensions(value, config);
    }

    private static void checkNormalizationForm(String value, NameChecker checker) throws XPathException {
        if (!checker.isValidNmtoken(value)) {
            throw new XPathException("Invalid value for normalization-form: must be NFC, NFD, NFKC, NFKD, fully-normalized, or none");
        }
    }

    private static boolean isValidClarkName(String value, NameChecker checker) {
        if (value.charAt(0) != '{') {
            return false;
        }
        int closer = value.indexOf(125);
        return closer >= 2 && closer != value.length() - 1 && checker.isValidNCName(value.substring(closer + 1));
    }

    private static void checkNonNegativeInteger(String key, String value) throws XPathException {
        try {
            int n = Integer.parseInt(value);
            if (n < 0) {
                throw new XPathException("Value of " + Err.wrap(key) + " must be a non-negative integer");
            }
        }
        catch (NumberFormatException err) {
            throw new XPathException("Value of " + Err.wrap(key) + " must be a non-negative integer");
        }
    }

    private static void checkListOfClarkNames(String key, String value, NameChecker checker) throws XPathException {
        StringTokenizer tok = new StringTokenizer(value, " \t\n\r", false);
        while (tok.hasMoreTokens()) {
            String s = tok.nextToken();
            if (SaxonOutputKeys.isValidClarkName(s, checker) || checker.isValidNCName(s)) continue;
            throw new XPathException("Value of " + Err.wrap(key) + " must be a list of QNames in '{uri}local' notation");
        }
    }

    private static void checkPublicIdentifier(String value) throws XPathException {
        if (!publicIdPattern.matcher(value).matches()) {
            throw new XPathException("Invalid character in doctype-public parameter");
        }
    }

    private static void checkSystemIdentifier(String value) throws XPathException {
        if (value.contains("'") && value.contains("\"")) {
            throw new XPathException("The doctype-system parameter must not contain both an apostrophe and a quotation mark");
        }
    }

    public static String parseListOfElementNames(String value, NamespaceResolver nsResolver, boolean prevalidated, NameChecker checker, String errorCode) throws XPathException {
        String s = "";
        StringTokenizer st = new StringTokenizer(value, " \t\n\r", false);
        while (st.hasMoreTokens()) {
            String displayname = st.nextToken();
            if (prevalidated) {
                s = s + ' ' + displayname;
                continue;
            }
            try {
                String[] parts = checker.getQNameParts(displayname);
                String muri = nsResolver.getURIForPrefix(parts[0], true);
                if (muri == null) {
                    XPathException err = new XPathException("Namespace prefix '" + parts[0] + "' has not been declared");
                    err.setErrorCode(errorCode);
                    throw err;
                }
                s = s + " {" + muri + '}' + parts[1];
            }
            catch (QNameException err) {
                XPathException e = new XPathException("Invalid element name. " + err.getMessage());
                e.setErrorCode(errorCode);
                throw e;
            }
        }
        return s;
    }
}

