/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree;

import java.util.ArrayList;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.LocationProvider;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.om.AttributeCollectionImpl;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.CommentImpl;
import net.sf.saxon.tree.DocumentImpl;
import net.sf.saxon.tree.ElementImpl;
import net.sf.saxon.tree.NodeFactory;
import net.sf.saxon.tree.NodeImpl;
import net.sf.saxon.tree.ParentNodeImpl;
import net.sf.saxon.tree.ProcInstImpl;
import net.sf.saxon.tree.TextImpl;

public class TreeBuilder
extends Builder {
    private ParentNodeImpl currentNode;
    private boolean contentStarted = false;
    private NodeFactory nodeFactory;
    private int[] size = new int[100];
    private int depth = 0;
    private ArrayList<NodeImpl[]> arrays = new ArrayList(20);
    private int elementNameCode;
    private int elementTypeCode;
    private int pendingLocationId;
    private AttributeCollectionImpl attributes;
    private int[] namespaces;
    private int namespacesUsed;
    private boolean allocateSequenceNumbers = true;
    private int nextNodeNumber = 1;
    private static final int[] EMPTY_ARRAY_OF_INT = new int[0];

    public TreeBuilder() {
        this.nodeFactory = new DefaultNodeFactory();
    }

    public NodeInfo getCurrentRoot() {
        NodeInfo physicalRoot = this.currentRoot;
        if (physicalRoot instanceof DocumentImpl && ((DocumentImpl)physicalRoot).isImaginary()) {
            return ((DocumentImpl)physicalRoot).getDocumentElement();
        }
        return physicalRoot;
    }

    public void reset() {
        super.reset();
        this.currentNode = null;
        this.nodeFactory = null;
        this.depth = 0;
        this.allocateSequenceNumbers = true;
        this.nextNodeNumber = 1;
    }

    public void setAllocateSequenceNumbers(boolean allocate) {
        this.allocateSequenceNumbers = allocate;
    }

    public void setNodeFactory(NodeFactory factory) {
        this.nodeFactory = factory;
    }

    public void open() throws XPathException {
        this.started = true;
        this.depth = 0;
        this.size[this.depth] = 0;
        super.open();
    }

    public void startDocument(int properties) throws XPathException {
        DocumentImpl doc = new DocumentImpl();
        this.currentRoot = doc;
        doc.setSystemId(this.getSystemId());
        doc.setBaseURI(this.getBaseURI());
        doc.setConfiguration(this.config);
        this.currentNode = doc;
        this.depth = 0;
        this.size[this.depth] = 0;
        doc.sequence = 0;
        if (this.lineNumbering) {
            doc.setLineNumbering();
        }
        this.contentStarted = true;
    }

    public void endDocument() throws XPathException {
        this.currentNode.compact(this.size[this.depth]);
    }

    public void close() throws XPathException {
        if (this.currentNode == null) {
            return;
        }
        this.currentNode.compact(this.size[this.depth]);
        this.currentNode = null;
        this.arrays = null;
        super.close();
        this.nodeFactory = null;
    }

    public void startElement(int nameCode, int typeCode, int locationId, int properties) throws XPathException {
        if (this.currentNode == null) {
            this.startDocument(0);
            ((DocumentImpl)this.currentRoot).setImaginary(true);
        }
        this.elementNameCode = nameCode;
        this.elementTypeCode = typeCode;
        this.pendingLocationId = locationId;
        this.namespacesUsed = 0;
        this.attributes = null;
        this.contentStarted = false;
    }

    public void namespace(int namespaceCode, int properties) {
        if (this.contentStarted) {
            throw new IllegalStateException("namespace() called after startContent()");
        }
        if (this.namespaces == null) {
            this.namespaces = new int[5];
        }
        if (this.namespacesUsed == this.namespaces.length) {
            int[] ns2 = new int[this.namespaces.length * 2];
            System.arraycopy(this.namespaces, 0, ns2, 0, this.namespacesUsed);
            this.namespaces = ns2;
        }
        this.namespaces[this.namespacesUsed++] = namespaceCode;
    }

    public void attribute(int nameCode, int typeCode, CharSequence value, int locationId, int properties) throws XPathException {
        properties &= 0xFFFFFFFE;
        if (this.contentStarted) {
            throw new IllegalStateException("attribute() called after startContent()");
        }
        if (this.attributes == null) {
            this.attributes = new AttributeCollectionImpl(this.config);
        }
        this.attributes.addAttribute(nameCode, typeCode, ((Object)value).toString(), locationId, properties);
    }

    public void startContent() throws XPathException {
        int n;
        if (this.contentStarted) {
            throw new IllegalStateException("startContent() called more than once");
        }
        this.contentStarted = true;
        if (this.attributes == null) {
            this.attributes = AttributeCollectionImpl.EMPTY_ATTRIBUTE_COLLECTION;
        } else {
            this.attributes.compact();
        }
        int[] nslist = this.namespaces;
        if (nslist == null || this.namespacesUsed == 0) {
            nslist = EMPTY_ARRAY_OF_INT;
        }
        if (this.allocateSequenceNumbers) {
            int n2 = this.nextNodeNumber;
            n = n2;
            this.nextNodeNumber = n2 + 1;
        } else {
            n = -1;
        }
        ElementImpl elem = this.nodeFactory.makeElementNode(this.currentNode, this.elementNameCode, this.elementTypeCode, this.attributes, nslist, this.namespacesUsed, this.pipe, this.pendingLocationId, n);
        this.namespacesUsed = 0;
        this.attributes = null;
        while (this.depth >= this.arrays.size()) {
            this.arrays.add(new NodeImpl[20]);
        }
        elem.useChildrenArray(this.arrays.get(this.depth));
        int n3 = this.depth;
        int n4 = this.size[n3];
        this.size[n3] = n4 + 1;
        this.currentNode.addChild(elem, n4);
        if (this.depth >= this.size.length - 1) {
            int[] newsize = new int[this.size.length * 2];
            System.arraycopy(this.size, 0, newsize, 0, this.size.length);
            this.size = newsize;
        }
        this.size[++this.depth] = 0;
        this.namespacesUsed = 0;
        if (this.currentNode instanceof DocumentInfo) {
            ((DocumentImpl)this.currentNode).setDocumentElement(elem);
        }
        this.currentNode = elem;
    }

    public void endElement() throws XPathException {
        if (!this.contentStarted) {
            throw new IllegalStateException("missing call on startContent()");
        }
        this.currentNode.compact(this.size[this.depth]);
        --this.depth;
        this.currentNode = (ParentNodeImpl)this.currentNode.getParent();
    }

    public void characters(CharSequence chars, int locationId, int properties) throws XPathException {
        if (!this.contentStarted) {
            throw new IllegalStateException("missing call on startContent()");
        }
        if (chars.length() > 0) {
            TextImpl n = new TextImpl(this.currentNode, ((Object)chars).toString());
            int n2 = this.depth;
            int n3 = this.size[n2];
            this.size[n2] = n3 + 1;
            this.currentNode.addChild(n, n3);
        }
    }

    public void processingInstruction(String name, CharSequence remainder, int locationId, int properties) {
        if (!this.contentStarted) {
            throw new IllegalStateException("missing call on startContent()");
        }
        int nameCode = this.namePool.allocate("", "", name);
        ProcInstImpl pi = new ProcInstImpl(nameCode, ((Object)remainder).toString());
        int n = this.depth;
        int n2 = this.size[n];
        this.size[n] = n2 + 1;
        this.currentNode.addChild(pi, n2);
        LocationProvider locator = this.pipe.getLocationProvider();
        if (locator != null) {
            pi.setLocation(locator.getSystemId(locationId), locator.getLineNumber(locationId));
        }
    }

    public void comment(CharSequence chars, int locationId, int properties) throws XPathException {
        if (!this.contentStarted) {
            throw new IllegalStateException("missing call on startContent()");
        }
        CommentImpl comment = new CommentImpl(((Object)chars).toString());
        int n = this.depth;
        int n2 = this.size[n];
        this.size[n] = n2 + 1;
        this.currentNode.addChild(comment, n2);
    }

    public void graftElement(ElementImpl element) throws XPathException {
        int n = this.depth;
        int n2 = this.size[n];
        this.size[n] = n2 + 1;
        this.currentNode.addChild(element, n2);
    }

    public void setUnparsedEntity(String name, String uri, String publicId) {
        ((DocumentImpl)this.currentRoot).setUnparsedEntity(name, uri, publicId);
    }

    private static class DefaultNodeFactory
    implements NodeFactory {
        private DefaultNodeFactory() {
        }

        public ElementImpl makeElementNode(NodeInfo parent, int nameCode, int typeCode, AttributeCollectionImpl attlist, int[] namespaces, int namespacesUsed, PipelineConfiguration pipe, int locationId, int sequenceNumber) {
            ElementImpl e = new ElementImpl();
            if (namespacesUsed > 0) {
                e.setNamespaceDeclarations(namespaces, namespacesUsed);
            }
            e.initialise(nameCode, typeCode, attlist, parent, sequenceNumber);
            LocationProvider locator = pipe.getLocationProvider();
            if (locator != null) {
                String baseURI = locator.getSystemId(locationId);
                int lineNumber = locator.getLineNumber(locationId);
                int columnNumber = locator.getColumnNumber(locationId);
                e.setLocation(baseURI, lineNumber, columnNumber);
            }
            return e;
        }
    }
}

