/*** Don't forget to add dependancy on log.h for the modules using it ***/

#ifndef __MARTIAN_LOG_H
#define __MARTIAN_LOG_H

#include <stdarg.h>
#include "common.h"

#define PROGPREFIX	"martian"

#ifndef PREFIX
#  define PREFIX	NULL
#endif

/*extern int debuglevel;*/

typedef enum {
	Std, Syslog
} logdev_t;

typedef enum logtypes {
	Error 	= 0,
	Warning = 1,
	Info 	= 2,
	Debug 	= 3,
	Assertion = 4
} logtypes_t;

typedef enum _debuglevels {
	Sequence	= 1,
	Note		= 2,
	Stats		= 2,
	Timings		= 2,
	NonCriticalSysErrors	= 2,
	Session		= 3,
	Event		= 3,
	Dump		= 4,
	Mechanism 	= 5
} debuglevel_t;

static inline int Debugged (debuglevel_t level) {
	return level <= config.debuglevel;
}

extern int log_setup (logdev_t where); 
extern int log_redirect_to_file (char *file);
	
extern void (*logmsg) (enum logtypes type, char *prefix, char *format, ...); 
extern void (*logdebugadd) (debuglevel_t level, char *format, ...);
extern void (*logdebug) (debuglevel_t level, char *prefix, char *format, ...);
extern void (*loginfo) (char *prefix, char *format, ...);
extern void (*logwarn) (char *prefix, char *format, ...);
extern void (*logerr) (char *prefix, char *format, ...); 
extern void (*logsyserror) (logtypes_t type, char *prefix, char *str);

void logassertion (char *expr, char *file, int line, const char *func);

/* macros for fixed prefix in a module */

/*#define DOLOG(fmt...)		do_logmsg (PROGPREFIX PREFIX fmt)
*/
#define LOG(type, fmt...)	logmsg (type, PREFIX, fmt)
#define LOGQ(type, fmt...)	logmsg (type, NULL, fmt)
#define LOGERR(fmt...)		logerr (PREFIX, fmt)
#define LOGWARN(fmt...)		logwarn (PREFIX, fmt)
#define LOGINFO(fmt...)		loginfo (PREFIX, fmt)
#define LOGDEBUG(level, fmt...)	logdebug (level, PREFIX, fmt)
#define LOGSYSERR(type, str)	logsyserror (type, PREFIX, str)
#define LOGQDEBUG(level, fmt...)	logdebug (level, NULL, fmt)

#define ASSERT(expr, action)				\
	if (! (expr)) {					\
		logassertion (__STRING(expr), __FILE__, __LINE__, __FUNCTION__);\
		action;					\
	}

/* SPRINTF_ADJUST macro, prints safe to ptr and update ptr&size */
#define SPRINTF_ADJUST(ptr, size, fmt...) 	\
do {						\
	int written; 				\
	written = snprintf (ptr, size, fmt); \
	if (written > 0) {			\
		size -= written;		\
		ptr += written;			\
	}					\
} while (0)
	
#endif /*__MARTIAN_LOG_H */
