#include <time.h>
#include <syscall.h>
#include <unistd.h>
#include <linux/unistd.h>
#include "log.h"
#include "sysdep.h"
#include <errno.h>
#include <string.h>
#include <pthread.h>
#include <stdlib.h>

struct _mutex {
	pthread_mutex_t obj;
};

static long linux_timer_create (clockid_t clock, struct sigevent *ev, timer_t *timerid)
{
	return syscall (__NR_timer_create, clock, ev, timerid);
}

static long linux_timer_settime (timer_t id, int flags, const struct itimerspec *ts, struct itimerspec *ots)
{
	return syscall (__NR_timer_settime, id, flags, ts, ots);
}

/*
_syscall3 (long, timer_create, clockid_t, clock, struct sigevent *, ev, timer_t *, timerid);
*/


long mtimer_create (clockid_t clock, struct sigevent *ev, mtimer_t *timer) 
{
	long result;
	result = linux_timer_create (clock, ev, &timer->id);
	if (result == 0) {
		timer->settime = (typeof (timer_settime) *) linux_timer_settime;
		return 0;
	}
	LOGDEBUG (2, "linux_timer_create: %s\n", strerror (-result));

	result = timer_create (clock, ev, &timer->id);
	if (timer_create (clock, ev, &timer->id) == 0) {
		timer->settime = timer_settime;
		return 0;
	}
	LOGSYSERR (Debug, "timer_create");

	return result;
}

int mthread_create (void *(*run) (void *arg), void *arg)
{
	pthread_attr_t attr;
	pthread_t id;
	pthread_attr_init (& attr);

	if (pthread_create (&id, &attr, run, arg) != 0) {
		LOGSYSERR (Debug, "pthread_create");
		return -1;
	}

	return 1; /*gettid();*/
}

mutex_t *mutex_create (void ) {
	mutex_t *m = malloc (sizeof (mutex_t));
	if (! m) {
		LOGSYSERR (Error, "malloc");
		return m;
	}
	pthread_mutex_init (&m->obj, NULL);
	return m;
}

int mutex_lock (mutex_t *m) {
	return pthread_mutex_lock (&m->obj);
}

int mutex_unlock (mutex_t *m) {
	return pthread_mutex_unlock (&m->obj);
}

int mgettid (void ) {
	return syscall (__NR_gettid);
}
