########################################################################
#
#    Vision Node - Python source code - file generated by vision
#    Tuesday 27 November 2007 06:29:51 
#    
#       The Scripps Research Institute (TSRI)
#       Molecular Graphics Lab
#       La Jolla, CA 92037, USA
#
# Copyright: Daniel Stoffler, Michel Sanner and TSRI
#   
# revision: Guillaume Vareille
#  
#########################################################################
#
# $Header: /opt/cvs/VisionLibraries/scipylib/signal/lFilter.py,v 1.1 2007/11/28 23:09:08 mgltools Exp $
#
# $Id: lFilter.py,v 1.1 2007/11/28 23:09:08 mgltools Exp $
#

# import node's base class node
from NetworkEditor.items import NetworkNode
class lFilter(NetworkNode):
    mRequiredTypes = {}
    mRequiredSynonyms = [
    ]
    def __init__(self, constrkw = {},  name='lFilter', **kw):
        kw['constrkw'] = constrkw
        kw['name'] = name
        apply( NetworkNode.__init__, (self,), kw)
        code = """def doit(self, b, a,x):
    from scipy.signal import lfilter
    data = lfilter(b,a,x)
    self.outputData(y=data)
"""
        self.configure(function=code)
        self.inputPortsDescr.append(
            {'singleConnection': True, 'name': 'b', 'cast': True, 'datatype': 'None', 'balloon': 'filter numerator', 'required': True, 'height': 8, 'width': 12, 'shape': 'diamond', 'color': 'white'})
        self.inputPortsDescr.append(
            {'singleConnection': True, 'name': 'a', 'cast': True, 'datatype': 'None', 'balloon': 'filter denominator', 'required': True, 'height': 8, 'width': 12, 'shape': 'diamond', 'color': 'white'})
        self.inputPortsDescr.append(
            {'singleConnection': True, 'name': 'x', 'cast': True, 'datatype': 'None', 'balloon': 'signal to filter', 'required': True, 'height': 8, 'width': 12, 'shape': 'diamond', 'color': 'white'})
        self.outputPortsDescr.append(
            {'name': 'y', 'datatype': 'None', 'balloon': 'filter output', 'height': 8, 'width': 12, 'shape': 'diamond', 'color': 'white'})
        self.widgetDescr['a'] = {
            'initialValue': 1, 'widgetGridCfgnode': {'rowspan': 1, 'labelSide': 'left', 'column': 1, 'ipady': 0, 'ipadx': 0, 'columnspan': 1, 'pady': 0, 'padx': 0, 'row': 0}, 'increment':1, 'height': 20, 'labelGridCfg': {'rowspan': 1, 'column': 0, 'sticky': 'w', 'ipady': 0, 'ipadx': 0, 'columnspan': 1, 'pady': 0, 'padx': 0, 'row': 0}, 'width': 60, 'master': 'node', 'wheelPad': 1, 'widgetGridCfg': {'column': 1, 'labelSide': 'left', 'row': 0}, 'labelCfg': {'text': 'a'}, 'class': 'NEThumbWheel', 'oneTurn': 10.0}

    def beforeAddingToNetwork(self, net):
        try:
            ed = net.getEditor()
        except:
            import traceback; traceback.print_exc()
            print 'Warning! Could not import widgets'

