      SUBROUTINE CNSTDD
C
C     THIS SUBROUTINE DEFINES COMMONLY USED PHYSICAL CONSTANTS
C
C     THE /CONDAD/ COMMON BLOCK CONTAINS COMMONLY USED PHYSICAL
C     CONSTANTS IN DOUBLE PRECISION FORM.
C
C     THE /CONDAS/ COMMON BLOCK CONTAINS COMMONLY USED PHYSICAL
C     CONSTANTS IN SINGLE PRECISION FORM.
C
C     THE FOLLOWING IS A PARTIAL LIST OF ROUTINES THAT USE CONSTANTS
C     FROM ONE OF THESE COMMON BLOCKS
C              CDETM    ,CEAD1A   ,CONE     ,DETM5    ,DS1A     ,
C              DTRIA    ,FRRD1A   ,GKAM     ,GP1      ,INPUT    ,
C              KTUBE    ,MCONE    ,MFREE    ,MTUBE    ,PLA32    ,
C              PLA42    ,PRESAX   ,QDMEM    ,RAND3    ,RAND8    ,
C              REIG     ,RFORCE   ,ROD      ,SCONE1   ,SDR2C    ,
C              STUBE1   ,TR1A     ,VDRB
C
C     TYPE DECLARATION
C
      DOUBLE PRECISION   DPI      ,D2PI     ,RADDEG   ,DEGRAD   ,
     1                   D4PISQ
C
C
C     COMMON STATEMENTS
C
      COMMON /CONDAS/    PI       ,TWOPI    ,RADEG    ,DEGRA    ,
     1                   S4PISQ
      COMMON /CONDAD/    DPI      ,D2PI     ,RADDEG   ,DEGRAD   ,
     1                   D4PISQ
C
C
C     PI IS THE SINGLE PRECISION VALUE OF PI
C
      PI     =  3.1415 92653 58979 32384 62643 D0
C
C     DPI IS THE DOUBLE PRECISION VALUE OF PI
C
      DPI    =  3.1415 92653 58979 32384 62643 D0
C
C     TWOPI IS THE SINGLE PRECISION VALUE OF 2*PI
C
      TWOPI  =  6.2831 85307 17958 64769 25287 D0
C
C     D2PI IS THE DOUBLE PRECISION VALUE OF 2*PI
C
      D2PI   =  6.2831 85307 17958 64769 25287 D0
C
C     RADEG IS THE SINGLE PRECISION CONVERSION FACTOR FROM RADIANS TO
C     DEGREES
C
      RADEG  = 57.2957 79513 08232 08767 98155 D0
C
C     RADDEG IS THE DOUBLE PRECISION CONVERSION FACTOR FROM RADIANS TO
C     DEGREES
C
      RADDEG = 57.2957 79513 08232 08767 98155 D0
C
C     DEGRA IS THE SINGLE PRECISIONCONVERSION FACTOR FROM DEGREES TO
C     RADIANS
C
      DEGRA  =  0.0174 53292 51994 32957 69237 D0
C
C     DEGRAD IS THE DOUBLE PRECISION CONVERSION FACTOR FROM DEGREES TO
C     RADIANS
C
      DEGRAD =  0.0174 53292 51994 32957 69237 D0
C
C
C     S4PISQ IS THE SINGLE PRECISION VALUE OF 4*PI**2
C
      S4PISQ = 39.4784 17604 35743 44753 37964 D0
C
C     D4PISQ IS THE DOUBLE PRECISION VALUE OF 4*PI**2
C
      D4PISQ = 39.4784 17604 35743 44753 37964 D0
C
      RETURN
C
C
      END
