/*###############################################################################
# Linux Management Providers (LMP), Battery provider package
# Copyright (C) 2009 Shakhrom RUSTAMOV, TUIT <shahrombek@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#include "OpenDRIM_BatteryAccess.h"

const string systemCreationClassName = "OpenDRIM_ComputerSystem";
const string creationClassName = "OpenDRIM_Battery";
string systemName;

int Battery_OpenDRIM_Battery_load(const CMPIBroker* broker, string& errorMessage) {
	_E_;
	CF_assert(CF_getSystemName(systemName, errorMessage));
	_L_;
	return OK;
}

int Battery_OpenDRIM_Battery_unload(string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

int Battery_OpenDRIM_Battery_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_Battery>& result, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	//Initialize an instance
	
	OpenDRIM_Battery instance;
	instance.setSystemCreationClassName(systemCreationClassName);
	instance.setSystemName(systemName);
	instance.setCreationClassName(creationClassName);
	
	vector<string> batteries;
	CF_assert(CF_runCommandToLines("ls -1 /proc/acpi/battery", batteries, 0, errorMessage));
	
	for (size_t i = 0; i < batteries.size()-1; i++) 
	{
		instance.setDeviceID(batteries[i]);
		if (discriminant == "ei")
			CF_assert(Battery_OpenDRIM_Battery_populate(instance, errorMessage));
		result.push_back(instance);
	}
	_L_;
	return OK;
}

int Battery_OpenDRIM_Battery_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_Battery& instance, const char** properties, string& errorMessage) {
	_E_;
	vector<string> batteries;
	vector<string>::size_type index;
	
	CF_assert(CF_runCommandToLines("ls -1 /proc/acpi/battery", batteries, 0, errorMessage));
	
	if(instance.SystemCreationClassName != systemCreationClassName ||
			instance.CreationClassName != creationClassName ||
			instance.SystemName != systemName ||
			!CF_foundInList(instance.DeviceID,batteries,index))
	{
		errorMessage = "No instance";
		return NOT_FOUND;
	}
	
	CF_assert(Battery_OpenDRIM_Battery_populate(instance, errorMessage));
	_L_;
	return OK;
}

int Battery_OpenDRIM_Battery_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_Battery& newInstance, const OpenDRIM_Battery& oldInstance, const char** properties, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int Battery_OpenDRIM_Battery_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_Battery& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int Battery_OpenDRIM_Battery_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_Battery& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int Battery_OpenDRIM_Battery_RequestStateChange(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_Battery& instance, unsigned int& returnValue, const OpenDRIM_Battery_RequestStateChange_In& in, OpenDRIM_Battery_RequestStateChange_Out& out, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int Battery_OpenDRIM_Battery_SetPowerState(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_Battery& instance, unsigned int& returnValue, const OpenDRIM_Battery_SetPowerState_In& in, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int Battery_OpenDRIM_Battery_Reset(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_Battery& instance, unsigned int& returnValue, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int Battery_OpenDRIM_Battery_EnableDevice(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_Battery& instance, unsigned int& returnValue, const OpenDRIM_Battery_EnableDevice_In& in, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int Battery_OpenDRIM_Battery_OnlineDevice(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_Battery& instance, unsigned int& returnValue, const OpenDRIM_Battery_OnlineDevice_In& in, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int Battery_OpenDRIM_Battery_QuiesceDevice(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_Battery& instance, unsigned int& returnValue, const OpenDRIM_Battery_QuiesceDevice_In& in, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int Battery_OpenDRIM_Battery_SaveProperties(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_Battery& instance, unsigned int& returnValue, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int Battery_OpenDRIM_Battery_RestoreProperties(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_Battery& instance, unsigned int& returnValue, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int Battery_OpenDRIM_Battery_populate(OpenDRIM_Battery& instance, string& errorMessage) {
	_E_;
	
	/*
	 * Properties to fill from profile
	 * + Mandatory:
	 * [X] SystemCreationClassName  [KEY]
	 * [X] SystemName               [KEY]
	 * [X] CreationClassName        [KEY]
	 * [X] DeviceID                 [KEY]
	 * [X] BatteryStatus
	 * [X] OperationalStatus
	 * [X] HealthState
	 * [X] EnabledState
	 * [X] RequestedState
	 * [X] ElementName
	 */
	
	vector<string> battstate, battstate_line;
	string status;
	unsigned short batteryStatus;
	vector<unsigned short> operationalStatus;

	CF_assert(CF_readTextFileToLines("/proc/acpi/battery/" + instance.DeviceID + "/state", battstate, 0, errorMessage));
	CF_splitTextBySpace(battstate_line, battstate[2]);
	
	status = battstate_line[2];
	
	if (status == "fully") //fully charged
		batteryStatus = 3;
	else if (status == "low")
		batteryStatus = 4;
	else if (status == "critical")
		batteryStatus = 5;
	else if (status == "charging")
		batteryStatus = 6;
	else if (status == "undefined")
		batteryStatus = 10;
	else if (status == "learning")
		batteryStatus = 12;
	else if (status == "overcharged")
		batteryStatus = 13;
	else
		batteryStatus =2; //unknown
	
	instance.setBatteryStatus(batteryStatus);
	operationalStatus.push_back(2); // OK
	instance.setOperationalStatus(operationalStatus);
	instance.setHealthState(5);
	instance.setEnabledState(5); // Not supported
	instance.setRequestedState(12); // Not supported
	instance.setElementName("Battery "+instance.DeviceID.substr(instance.DeviceID.size()-1));
	_L_;
	return OK;
}
